/****************************************************************************
 *
 * CRI Middleware SDK
 *
 * Copyright (c) 2010-2015 CRI Middleware Co., Ltd.
 *
 * Library  : CRI Atom
 * Module   : Library User's Header for PC
 * File     : cri_atom_pc.h
 *
 ****************************************************************************/
/*!
 *	\file		cri_atom_pc.h
 */

/* d`h~					*/
/* Prevention of redefinition	*/
#ifndef	CRI_INCL_CRI_ATOM_PC_H
#define	CRI_INCL_CRI_ATOM_PC_H

/***************************************************************************
 *      CN[ht@C
 *      Include files
 ***************************************************************************/
#include <Windows.h>
#include <cri_le_xpt.h>
#include <cri_le_error.h>
#include "cri_le_atom.h"
#include "cri_le_atom_ex.h"
#include "cri_le_atom_asr.h"

/***************************************************************************
 *      萔}N
 *      Macro Constants
 ***************************************************************************/

/***************************************************************************
 *      }N
 *      Macro Functions
 ***************************************************************************/
/*==========================================================================
 *      CRI Atom API
 *=========================================================================*/
/*JP
 * \brief CupRtBO\̂ɃftHglZbg
 * \ingroup ATOMLIB_PC
 * \param[out]	p_config	pRtBO\̂ւ̃|C^
 * \par :
 * ::criAtom_Initialize_PC ֐ɐݒ肷RtBO\
 * i ::CriAtomConfig_PC jɁAftHg̒lZbg܂B<br>
 * \attention
 * {}N͉ʃCAPIłB<br>
 * AtomExC̋@\𗘗pۂɂ́A{}N̑ 
 * ::criAtomEx_SetDefaultConfig_PC }NpB
 * \sa CriAtomConfig_PC
 */
#define criAtom_SetDefaultConfig_PC(p_config)				\
{															\
	criAtom_SetDefaultConfig(&(p_config)->atom);			\
	criAtomAsr_SetDefaultConfig(&(p_config)->asr);			\
	criAtomHcaMx_SetDefaultConfig(&(p_config)->hca_mx);		\
}

/*==========================================================================
 *      CRI AtomEx API
 *=========================================================================*/
/*JP
 * \brief CupRtBO\̂ɃftHglZbg
 * \ingroup ATOMLIB_PC
 * \param[out]	p_config	pRtBO\̂ւ̃|C^
 * \par :
 * ::criAtomEx_Initialize_PC ֐ɐݒ肷RtBO\
 * i ::CriAtomExConfig_PC jɁAftHg̒lZbg܂B<br>
 * \sa CriAtomExConfig_PC
 */
#define criAtomEx_SetDefaultConfig_PC(p_config)				\
{															\
	criAtomEx_SetDefaultConfig(&(p_config)->atom_ex);		\
	criAtomExAsr_SetDefaultConfig(&(p_config)->asr);		\
	criAtomExHcaMx_SetDefaultConfig(&(p_config)->hca_mx);	\
}

/***************************************************************************
 *      f[^^錾
 *      Data Type Declarations
 ***************************************************************************/
/*==========================================================================
 *      CRI Atom API
 *=========================================================================*/
/*JP
 * \brief AtomCupRtBO\
 * \ingroup ATOMLIB_PC
 * CRI AtomCu̓dlw肷邽߂̍\̂łB<br>
 * ::criAtom_Initialize_PC ֐̈Ɏw肵܂B<br>
 * \attention
 * {\͉̂ʃCAPIłB<br>
 * AtomExC̋@\𗘗pۂɂ́A{\̂̑ 
 * ::CriAtomExConfig_PC \̂pB
 * \sa criAtom_Initialize_PC, criAtom_SetDefaultConfig_PC
 */
typedef struct CriAtomConfigTag_PC{
	CriAtomConfig			atom;		/*JP< AtompRtBO\		*/
	CriAtomAsrConfig		asr;		/*JP< ASRpRtBO			*/
	CriAtomHcaMxConfig		hca_mx;		/*JP< HCA-MXpRtBO\	*/
} CriAtomConfig_PC;

/*==========================================================================
 *      CRI AtomEx API
 *=========================================================================*/
/*JP
 * \brief AtomCupRtBO\
 * \ingroup ATOMLIB_PC
 * CRI AtomCu̓dlw肷邽߂̍\̂łB<br>
 * ::criAtomEx_Initialize_PC ֐̈Ɏw肵܂B<br>
 * \sa criAtomEx_Initialize_PC, criAtomEx_SetDefaultConfig_PC
 */
typedef struct CriAtomExConfigTag_PC{
	CriAtomExConfig			atom_ex;	/*JP< AtomExpRtBO\	*/
	CriAtomExAsrConfig		asr;		/*JP< ASRpRtBO			*/
	CriAtomExHcaMxConfig	hca_mx;		/*JP< HCA-MXpRtBO\	*/
} CriAtomExConfig_PC;

/***************************************************************************
 *      ϐ錾
 *      Prototype Variables
 ***************************************************************************/

/***************************************************************************
 *      ֐錾
 *      Prototype Functions
 ***************************************************************************/
#ifdef __cplusplus
extern "C" {
#endif

/*==========================================================================
 *      CRI Atom API
 *=========================================================================*/
/*JP
 * \brief Cup[N̈TCY̌vZ
 * \ingroup ATOMLIB_PC
 * \param[in]	config		pRtBO\
 * \return		CriSint32	[N̈TCY
 * \par :
 * Cugp邽߂ɕKvȁA[N̈̃TCY擾܂B<br>
 * \par l:
 * CuKvƂ郏[N̈̃TCÝACupRtBO
 * \́i ::CriAtomConfig_PC j̓eɂĕω܂B<br>
 * <br>
 *  config ̏́A֐ł̂ݎQƂ܂B<br>
 * ֐𔲂͎QƂ܂̂ŁA֐s config ̗̈Ă
 * 肠܂B
 * \attention
 * {֐͉ʃCAPIłB<br>
 * AtomExC̋@\𗘗pۂɂ́A{֐̑ 
 * ::criAtomEx_CalculateWorkSize_PC ֐pB
 * \sa CriAtomConfig_PC, criAtom_Initialize_PC
 */
CriSint32 CRIAPI criAtom_CalculateWorkSize_PC(const CriAtomConfig_PC *config);

/*JP
 * \brief Cȕ
 * \ingroup ATOMLIB_PC
 * \param[in]	config		pRtBO\
 * \param[in]	work		[N̈
 * \param[in]	work_size	[N̈TCY
 * \par :
 * Cu܂B<br>
 * Cű@\𗘗pɂ́AK̊֐sKv܂B<br>
 * iCű@\́A{֐sA ::criAtom_Finalize_PC ֐s܂ł̊ԁA
 * p\łBj<br>
 * <br>
 * Cuۂɂ́ACuŗp邽߂̃̈i[N̈j
 * mۂKv܂B<br>
 * CuKvƂ郏[N̈̃TCÝApRtBO\̂̓eɉ
 * ω܂B<br>
 * [N̈TCY̌vZɂ́A ::criAtom_CalculateWorkSize_PC 
 * ֐gpĂB<br>
 * \par l:
 * ::criAtom_SetUserAllocator }NgpăAP[^[o^ς݂̏ꍇA
 * {֐Ƀ[N̈w肷Kv͂܂B<br>
 * i work  NULL A work_size  0 w肷邱ƂŁAo^ς݂̃AP[^[
 * Kvȃ[N̈TCỸIɊmۂ܂Bj
 * <br>
 *  config ̏́A֐ł̂ݎQƂ܂B<br>
 * ֐𔲂͎QƂ܂̂ŁA֐s config ̗̈Ă
 * 肠܂B
 * \attention
 * {֐͓IɈȉ̊֐s܂B<br>
 * 	- ::criAtom_Initialize
 * 	- ::criAtomAsr_Initialize
 * 	- ::criAtomHcaMx_Initialize
 * {֐sꍇAL֐sȂłB<br>
 * <br>
 * {֐sAK΂ɂȂ ::criAtom_Finalize_PC ֐sĂB<br>
 * ܂A ::criAtom_Finalize_PC ֐s܂ł́A{֐ēxsȂłB<br>
 * <br>
 * {֐͉ʃCAPIłB<br>
 * AtomExC̋@\𗘗pۂɂ́A{֐̑ 
 * ::criAtomEx_Initialize_PC ֐pB
 * \sa CriAtomConfig_PC, criAtom_Finalize_PC,
 * criAtom_SetUserAllocator, criAtom_CalculateWorkSize_PC
 */
void CRIAPI criAtom_Initialize_PC(
	const CriAtomConfig_PC *config, void *work, CriSint32 work_size);

/*JP
 * \brief CȕI
 * \ingroup ATOMLIB_PC
 * \par :
 * CuI܂B<br>
 * \attention
 * {֐͓IɈȉ̊֐s܂B<br>
 * 	- ::criAtom_Finalize
 * 	- ::criAtomAsr_Finalize
 * 	- ::criAtomHcaMx_Finalize
 * {֐sꍇAL֐sȂłB<br>
 * <br>
 * ::criAtom_Initialize_PC ֐sOɖ{֐s邱Ƃ͂ł܂B<br>
 * <br>
 * {֐͉ʃCAPIłB<br>
 * AtomExC̋@\𗘗pۂɂ́A{֐̑ 
 * ::criAtomEx_Finalize_PC ֐pB
 * \sa criAtom_Initialize_PC
 */
void CRIAPI criAtom_Finalize_PC(void);

/*JP
 * \brief T[o[Xbh̃vCIeBύX
 * \ingroup ATOMLIB_PC
 * \param[in]	prio	XbhvCIeB
 * \par :
 * T[o[iCu̓jsXbh̃vCIeBύX܂B<br>
 * ftHgԁi{֐sȂꍇjł́AT[o[Xbh̃vCIeB
 * THREAD_PRIORITY_HIGHEST ɐݒ肳܂B<br>
 * \attention:
 * {֐́ACuɃXbhf}`Xbhf
 * i ::CRIATOM_THREAD_MODEL_MULTI jɐݒ肵ꍇɂ̂݌ʂ𔭊܂B<br>
 * ̃XbhfIꍇA{֐͉s܂B<br>
 * iG[R[obN܂Bj<br>
 * <br>
 * {֐͏`IO̊ԂɎsKv܂B<br>
 * OIɖ{֐sĂAʂ͂܂B<br>
 * iG[R[obN܂Bj<br>
 * <br>
 * T[o[Xbh́ACRI File SystemCułpĂ܂B<br>
 * łCRI File SystemCuAPIŃT[o[Xbh̐ݒύXĂꍇ
 * {֐ɂݒ肪㏑܂̂łӂB<br>
 * \sa criAtom_Initialize_PC, criAtom_GetThreadPriority_PC
 */
void CRIAPI criAtom_SetThreadPriority_PC(int prio);

/*JP
 * \brief T[o[Xbh̃vCIeB擾
 * \ingroup ATOMLIB_PC
 * \return	int		XbhvCIeB
 * \par :
 * T[o[iCu̓jsXbh̃vCIeB擾܂B<br>
 * 擾ɐƁA{֐̓T[o[sXbh̃vCIeBԂ܂B<br>
 * 擾ɎsꍇA{֐ THREAD_PRIORITY_ERROR_RETURN Ԃ܂B<br>
 * \attention:
 * {֐́ACuɃXbhf}`Xbhf
 * i ::CRIATOM_THREAD_MODEL_MULTI jɐݒ肵ꍇɂ̂݌ʂ𔭊܂B<br>
 * ̃XbhfIꍇA{֐̓G[lԂ܂B<br>
 * iG[R[obN܂Bj<br>
 * <br>
 * {֐͏`IO̊ԂɎsKv܂B<br>
 * OIɖ{֐sꍇA{֐̓G[lԂ܂B<br>
 * iG[R[obN܂Bj<br>
 * \sa criAtom_Initialize_PC, criAtom_SetThreadPriority_PC
 */
int CRIAPI criAtom_GetThreadPriority_PC(void);

/*JP
 * \brief T[o[Xbh̃AtBjeB}XNύX
 * \ingroup ATOMLIB_PC
 * \param[in]	mask	XbhAtBjeB}XN
 * \par :
 * T[o[iCu̓jsXbh̃AtBjeB}XNύX܂B<br>
 * ftHgԁi{֐sȂꍇjł́AT[o[삷vZbT
 * ؐ܂B<br>
 * \attention:
 * {֐́ACuɃXbhf}`Xbhf
 * i ::CRIATOM_THREAD_MODEL_MULTI jɐݒ肵ꍇɂ̂݌ʂ𔭊܂B<br>
 * ̃XbhfIꍇA{֐͉s܂B<br>
 * iG[R[obN܂Bj<br>
 * <br>
 * {֐͏`IO̊ԂɎsKv܂B<br>
 * OIɖ{֐sĂAʂ͂܂B<br>
 * iG[R[obN܂Bj<br>
 * <br>
 * T[o[Xbh́ACRI File SystemCułpĂ܂B<br>
 * łCRI File SystemCuAPIŃT[o[Xbh̐ݒύXĂꍇ
 * {֐ɂݒ肪㏑܂̂łӂB<br>
 * \sa criAtom_Initialize_PC, criAtom_GetThreadAffinityMask_PC
 */
void CRIAPI criAtom_SetThreadAffinityMask_PC(DWORD_PTR mask);

/*JP
 * \brief T[o[Xbh̃AtBjeB}XN̎擾
 * \ingroup ATOMLIB_PC
 * \return	DWORD_PTR	XbhAtBjeB}XN
 * \par :
 * T[o[iCu̓jsXbh̃AtBjeB}XN擾܂B<br>
 * 擾ɐƁA{֐̓T[o[sXbh̃AtBjeB}XNԂ܂B<br>
 * 擾ɎsꍇA{֐ 0 Ԃ܂B<br>
 * \attention:
 * {֐́ACuɃXbhf}`Xbhf
 * i ::CRIATOM_THREAD_MODEL_MULTI jɐݒ肵ꍇɂ̂݌ʂ𔭊܂B<br>
 * ̃XbhfIꍇA{֐̓G[lԂ܂B<br>
 * iG[R[obN܂Bj<br>
 * <br>
 * {֐͏`IO̊ԂɎsKv܂B<br>
 * OIɖ{֐sꍇA{֐̓G[lԂ܂B<br>
 * iG[R[obN܂Bj<br>
 * \sa criAtom_Initialize_PC, criAtom_SetThreadAffinityMask_PC
 */
DWORD_PTR CRIAPI criAtom_GetThreadAffinityMask_PC(void);

/*==========================================================================
 *      CRI AtomEx API
 *=========================================================================*/
/*JP
 * \brief Cup[N̈TCY̌vZ
 * \ingroup ATOMLIB_PC
 * \param[in]	config		pRtBO\
 * \return		CriSint32	[N̈TCY
 * \par :
 * Cugp邽߂ɕKvȁA[N̈̃TCY擾܂B<br>
 * \par l:
 * CuKvƂ郏[N̈̃TCÝACupRtBO
 * \́i ::CriAtomExConfig_PC j̓eɂĕω܂B<br>
 * <br>
 *  config ̏́A֐ł̂ݎQƂ܂B<br>
 * ֐𔲂͎QƂ܂̂ŁA֐s config ̗̈Ă
 * 肠܂B
 * \attention
 * ::CriAtomExConfig \̂acf_infooɒlݒ肵ĂꍇA{֐͎s-1Ԃ܂B<br>
 * ACFf[^̓o^sꍇ́A{֐lgpmۂł͂ȂADXVXeɂ
 * AP[^[gpmۏKvɂȂ܂B
 * \sa CriAtomExConfig_PC, criAtomEx_Initialize_PC
 */
CriSint32 CRIAPI criAtomEx_CalculateWorkSize_PC(const CriAtomExConfig_PC *config);

/*JP
 * \brief Cȕ
 * \ingroup ATOMLIB_PC
 * \param[in]	config		pRtBO\
 * \param[in]	work		[N̈
 * \param[in]	work_size	[N̈TCY
 * \par :
 * Cu܂B<br>
 * Cű@\𗘗pɂ́AK̊֐sKv܂B<br>
 * iCű@\́A{֐sA ::criAtomEx_Finalize_PC ֐s܂ł̊ԁA
 * p\łBj<br>
 * <br>
 * Cuۂɂ́ACuŗp邽߂̃̈i[N̈j
 * mۂKv܂B<br>
 * CuKvƂ郏[N̈̃TCÝApRtBO\̂̓eɉ
 * ω܂B<br>
 * [N̈TCY̌vZɂ́A ::criAtomEx_CalculateWorkSize_PC 
 * ֐gpĂB<br>
 * \par l:
 * ::criAtomEx_SetUserAllocator }NgpăAP[^[o^ς݂̏ꍇA
 * {֐Ƀ[N̈w肷Kv͂܂B<br>
 * i work  NULL A work_size  0 w肷邱ƂŁAo^ς݂̃AP[^[
 * Kvȃ[N̈TCỸIɊmۂ܂Bj
 * <br>
 *  config ̏́A֐ł̂ݎQƂ܂B<br>
 * ֐𔲂͎QƂ܂̂ŁA֐s config ̗̈Ă
 * 肠܂B
 * \attention
 * {֐͓IɈȉ̊֐s܂B<br>
 * 	- ::criAtomEx_Initialize
 * 	- ::criAtomExAsr_Initialize
 * 	- ::criAtomExHcaMx_Initialize
 * {֐sꍇAL֐sȂłB<br>
 * <br>
 * {֐sAK΂ɂȂ ::criAtomEx_Finalize_PC ֐sĂB<br>
 * ܂A ::criAtomEx_Finalize_PC ֐s܂ł́A{֐ēxsȂłB<br>
 * \sa CriAtomExConfig_PC, criAtomEx_Finalize_PC,
 * criAtomEx_SetUserAllocator, criAtomEx_CalculateWorkSize_PC
 */
void CRIAPI criAtomEx_Initialize_PC(
	const CriAtomExConfig_PC *config, void *work, CriSint32 work_size);

/*JP
 * \brief CȕI
 * \ingroup ATOMLIB_PC
 * \par :
 * CuI܂B<br>
 * \attention
 * {֐͓IɈȉ̊֐s܂B<br>
 * 	- ::criAtomEx_Finalize
 * 	- ::criAtomExAsr_Finalize
 * 	- ::criAtomExHcaMx_Finalize
 * {֐sꍇAL֐sȂłB<br>
 * <br>
 * ::criAtomEx_Initialize_PC ֐sOɖ{֐s邱Ƃ͂ł܂B<br>
 * \sa criAtomEx_Initialize_PC
 */
void CRIAPI criAtomEx_Finalize_PC(void);

/*JP
 * \brief T[o[Xbh̃vCIeBύX
 * \ingroup ATOMLIB_PC
 * \param[in]	prio	XbhvCIeB
 * \par :
 * T[o[iCu̓jsXbh̃vCIeBύX܂B<br>
 * ftHgԁi{֐sȂꍇjł́AT[o[Xbh̃vCIeB
 * THREAD_PRIORITY_HIGHEST ɐݒ肳܂B<br>
 * \attention:
 * {֐́ACuɃXbhf}`Xbhf
 * i ::CRIATOM_THREAD_MODEL_MULTI jɐݒ肵ꍇɂ̂݌ʂ𔭊܂B<br>
 * ̃XbhfIꍇA{֐͉s܂B<br>
 * iG[R[obN܂Bj<br>
 * <br>
 * {֐͏`IO̊ԂɎsKv܂B<br>
 * OIɖ{֐sĂAʂ͂܂B<br>
 * iG[R[obN܂Bj<br>
 * <br>
 * T[o[Xbh́ACRI File SystemCułpĂ܂B<br>
 * łCRI File SystemCuAPIŃT[o[Xbh̐ݒύXĂꍇ
 * {֐ɂݒ肪㏑܂̂łӂB<br>
 * \sa criAtomEx_Initialize_PC, criAtomEx_GetThreadPriority_PC
 */
#define criAtomEx_SetThreadPriority_PC(prio)	\
	criAtom_SetThreadPriority_PC(prio)

/*JP
 * \brief T[o[Xbh̃vCIeB擾
 * \ingroup ATOMLIB_PC
 * \return	int		XbhvCIeB
 * \par :
 * T[o[iCu̓jsXbh̃vCIeB擾܂B<br>
 * 擾ɐƁA{֐̓T[o[sXbh̃vCIeBԂ܂B<br>
 * 擾ɎsꍇA{֐ THREAD_PRIORITY_ERROR_RETURN Ԃ܂B<br>
 * \attention:
 * {֐́ACuɃXbhf}`Xbhf
 * i ::CRIATOM_THREAD_MODEL_MULTI jɐݒ肵ꍇɂ̂݌ʂ𔭊܂B<br>
 * ̃XbhfIꍇA{֐̓G[lԂ܂B<br>
 * iG[R[obN܂Bj<br>
 * <br>
 * {֐͏`IO̊ԂɎsKv܂B<br>
 * OIɖ{֐sꍇA{֐̓G[lԂ܂B<br>
 * iG[R[obN܂Bj<br>
 * \sa criAtomEx_Initialize_PC, criAtomEx_SetThreadPriority_PC
 */
#define criAtomEx_GetThreadPriority_PC()	\
	criAtom_GetThreadPriority_PC()

/*JP
 * \brief T[o[Xbh̃AtBjeB}XNύX
 * \ingroup ATOMLIB_PC
 * \param[in]	mask	XbhAtBjeB}XN
 * \par :
 * T[o[iCu̓jsXbh̃AtBjeB}XNύX܂B<br>
 * ftHgԁi{֐sȂꍇjł́AT[o[삷vZbT
 * ؐ܂B<br>
 * \attention:
 * {֐́ACuɃXbhf}`Xbhf
 * i ::CRIATOM_THREAD_MODEL_MULTI jɐݒ肵ꍇɂ̂݌ʂ𔭊܂B<br>
 * ̃XbhfIꍇA{֐͉s܂B<br>
 * iG[R[obN܂Bj<br>
 * <br>
 * {֐͏`IO̊ԂɎsKv܂B<br>
 * OIɖ{֐sĂAʂ͂܂B<br>
 * iG[R[obN܂Bj<br>
 * <br>
 * T[o[Xbh́ACRI File SystemCułpĂ܂B<br>
 * łCRI File SystemCuAPIŃT[o[Xbh̐ݒύXĂꍇ
 * {֐ɂݒ肪㏑܂̂łӂB<br>
 * \sa criAtomEx_Initialize_PC, criAtomEx_GetThreadAffinityMask_PC
 */
#define criAtomEx_SetThreadAffinityMask_PC(mask)	\
	criAtom_SetThreadAffinityMask_PC(mask)

/*JP
 * \brief T[o[Xbh̃AtBjeB}XN̎擾
 * \ingroup ATOMLIB_PC
 * \return	DWORD_PTR	XbhAtBjeB}XN
 * \par :
 * T[o[iCu̓jsXbh̃AtBjeB}XN擾܂B<br>
 * 擾ɐƁA{֐̓T[o[sXbh̃AtBjeB}XNԂ܂B<br>
 * 擾ɎsꍇA{֐ 0 Ԃ܂B<br>
 * \attention:
 * {֐́ACuɃXbhf}`Xbhf
 * i ::CRIATOM_THREAD_MODEL_MULTI jɐݒ肵ꍇɂ̂݌ʂ𔭊܂B<br>
 * ̃XbhfIꍇA{֐̓G[lԂ܂B<br>
 * iG[R[obN܂Bj<br>
 * <br>
 * {֐͏`IO̊ԂɎsKv܂B<br>
 * OIɖ{֐sꍇA{֐̓G[lԂ܂B<br>
 * iG[R[obN܂Bj<br>
 * \sa criAtomEx_Initialize_PC, criAtomEx_SetThreadAffinityMask_PC
 */
#define criAtomEx_GetThreadAffinityMask_PC()	\
	criAtom_GetThreadAffinityMask_PC()

/*==========================================================================
 *      Functions for PCM Output
 *=========================================================================*/
/*JP
 * \brief [UPCMo͕p[N̈TCYvZ
 * \ingroup ATOMLIB_PC
 * \param[in]	config		pRtBO\
 * \return		CriSint32	[N̈TCY
 * \par :
 * [UPCMo͕ŃCu邽߂ɕKvȁA
 * [N̈̃TCY擾܂B<br>
 * \par l:
 * CuKvƂ郏[N̈̃TCÝACupRtBO
 * \́i ::CriAtomExConfig_PC j̓eɂĕω܂B<br>
 * <br>
 *  config ̏́A֐ł̂ݎQƂ܂B<br>
 * ֐𔲂͎QƂ܂̂ŁA֐s config ̗̈Ă
 * 肠܂B
 * \attention
 * {֐ ::criAtomEx_InitializeForUserPcmOutput_PC 
 * ֐gpăCuꍇɎgp܂B<br>
 * ::criAtomEx_Initialize_PC ֐gpꍇɂ́A{֐ł͂Ȃ
 * ::criAtomEx_CalculateWorkSize_PC ֐gpă[N̈TCYvZĂB<br>
 * \sa CriAtomExConfig_PC, criAtomEx_InitializeForUserPcmOutput_PC
 */
#define criAtomEx_CalculateWorkSizeForUserPcmOutput_PC(config)	\
	criAtomEx_CalculateWorkSizeForUserPcmOutput(config)

/*JP
 * \brief [UPCMo͗pCu
 * \ingroup ATOMLIB_PC
 * \param[in]	config		pRtBO\
 * \param[in]	work		[N̈
 * \param[in]	work_size	[N̈TCY
 * \par :
 * [UPCMo̓[hŃCu܂B<br>
 * <br>
 * {֐gpďsꍇAAtomCu͉o͂s܂B<br>
 * [U ::criAtomExAsr_GetPcmDataFloat32 
 * ֐gpăCuIPCMf[^擾A
 * AvP[Vŉo͂sKv܂B<br>
 * \attention
 * {֐ƈȉ̊֐͕pł܂B<br>
 * 	- ::criAtom_Initialize
 * 	- ::criAtomAsr_Initialize
 * 	- ::criAtomHcaMx_Initialize
 * 	- ::criAtom_Initialize_PC
 * \sa CriAtomExConfig_PC, criAtomEx_FinalizeForUserPcmOutput_PC,
 * criAtomExAsr_GetPcmDataFloat32, criAtomEx_CalculateWorkSizeForUserPcmOutput_PC
 */
#define criAtomEx_InitializeForUserPcmOutput_PC(config, work, work_size)	\
	criAtomEx_InitializeForUserPcmOutput(config, work, work_size)

/*JP
 * \brief [UPCMo͗pCuI
 * \ingroup ATOMLIB_PC
 * \par :
 * [UPCMo̓[hŏꂽCuɑ΂AIs܂B<br>
 * \attention
 * {֐ ::criAtomEx_InitializeForUserPcmOutput_PC 
 * ֐gpăCuꍇɎgp܂B<br>
 * ::criAtomEx_Initialize_PC ֐gpꍇɂ́A{֐ł͂Ȃ
 * ::criAtomEx_Finalize_PC ֐gpďIsĂB<br>
 * \sa criAtomEx_InitializeForUserPcmOutput_PC
 */
#define criAtomEx_FinalizeForUserPcmOutput_PC()	\
	criAtomEx_FinalizeForUserPcmOutput()

#ifdef __cplusplus
}
#endif

#endif	/* CRI_INCL_CRI_ATOM_PC_H */

/* --- end of file --- */
