/****************************************************************************
 *
 * CRI Middleware SDK
 *
 * Copyright (c) 2010-2016 CRI Middleware Co., Ltd.
 *
 * Library  : CRI Atom
 * Module   : AtomEx.
 * File     : cri_atom_ex.h
 *
 ****************************************************************************/
/*!
 *	\file		cri_atom_ex.h
 */

/* d`h~					*/
/* Prevention of redefinition	*/
#ifndef CRI_INCL_CRI_ATOM_EX_H
#define CRI_INCL_CRI_ATOM_EX_H

/***************************************************************************
 *      CN[ht@C
 *      Include files
 ***************************************************************************/
#include <cri_le_xpt.h>
#include <cri_le_atom.h>
#include <cri_le_file_system.h>

/***************************************************************************
 *      萔}N
 *      Macro Constants
 ***************************************************************************/
/* o[W */
/* Version Number */
#define CRIATOMEX_VER_NAME		"CRI AtomEx"
#define CRIATOMEX_VER_NUM		"2.29.4"
#define CRIATOMEX_VER_MAJOR		(2)
#define CRIATOMEX_VER_MINOR		(29)
#define CRIATOMEX_VER_PATCH		(4)
#define CRIATOMEX_VER_RELEASE	(0)
#define CRIATOMEX_VER_REVISION	(0)
#define CRIATOMEX_VER_OPTION

/*==========================================================================
 *      CRI AtomEx API
 *=========================================================================*/
/*JP
 * \brief o[`{CX̐ݒ\
 * \ingroup ATOMEXLIB_GLOBAL
 * \par :
 * o[`{CX̐ݒ\lłB
 * CriAtomExConfig::max_virtual_voices ̒ĺA̒lȉɐݒ肷Kv܂B
 * \sa CriAtomExConfig
 */
#define CRIATOMEX_MAX_VIRTUAL_VOICES	(32767)

/*==========================================================================
 *      CRI AtomEx ACF API
 *=========================================================================*/
/*JP
 * \brief AISACRg[ID̖l
 * \ingroup ATOMEXLIB_ACF
 * \par :
 * AISACRg[ID̖lłB<br>
 * \sa CriAtomExAisacControlId, criAtomExPlayer_SetAisacControlById, criAtomExAcf_GetAisacControlIdByName, criAtomExAcf_GetAisacControlNameById
 */
#define CRIATOMEX_INVALID_AISAC_CONTROL_ID	(0xffffffff)

/*JP
 * \brief őDSPoX
 * \ingroup ATOMEXLIB_ACF
 * \par :
 * DSPoXݒŐݒ\ȍőoXłB<br>
 * \sa CriAtomExAcfDspSettingInfo, CriAtomExAcfDspBusInfo
 */
#define CRIATOMEXACF_MAX_BUSES			(64)

/*JP
 * \brief őDSP FX
 * \ingroup ATOMEXLIB_ACF
 * \par :
 * DSPoXݒŐݒ\ȍőDSP FXłB<br>
 * \sa CriAtomExAcfDspBusInfo
 */
#define CRIATOMEXACF_MAX_FXES			(8)

/*JP
 * \brief L[~bgl
 * \ingroup ATOMEXLIB_ACF
 * \par :
 * L[~bg̖lłB<br>
 * \sa CriAtomExCategoryInfo
 */
#define CRIATOMEXACF_INVALID_CUE_LIMITS		(0xffffffff)

/*JP
 * \brief e햼O̍ő啶
 * \ingroup ATOMEXLIB_ACF
 * \par :
 * L[O[oAISACAe햼O̍ő啶łB<br>
 * \par l:
 * c[ł̓͐uoCgvł͂ȂuvōsĂāA
 * SpShift_JISƂĈĂ邽߁A
 * Spgpꍇ̃oCg͍ő128oCgƂȂ܂B
 */
#define CRIATOMEXACF_MAX_NAME_STRING_COUNT	(64)

/*==========================================================================
 *      CRI AtomEx Voice Pool API
 *=========================================================================*/
/*JP
 * \brief ftHg{CX
 * \ingroup ATOMEXLIB_VOICE_POOL
 * \par :
 * {CXv[̃{CX̃ftHglłB<br>
 * {CXv[쐬ɃftHglݒgpƁA
 * ::CRIATOMEX_DEFAULT_VOICES_PER_POOL ̃{CXmۂ܂B<br>
 * \sa criAtomExVoicePool_SetDefaultConfigForStandardVoicePool
 */
#define CRIATOMEX_DEFAULT_VOICES_PER_POOL	(8)

/*JP
 * \brief ŏ{CX
 * \ingroup ATOMEXLIB_VOICE_POOL
 * \par :
 * {CXv[̃{CX̍ŏlłB<br>
 */
#define CRIATOMEX_MIN_VOICES_PER_POOL	(1)

/*JP
 * \brief ő{CX
 * \ingroup ATOMEXLIB_VOICE_POOL
 * \par :
 * {CXv[̃{CX̍őlłB<br>
 */
#define CRIATOMEX_MAX_VOICES_PER_POOL	(32767)

/*==========================================================================
 *      CRI AtomEx Player API
 *=========================================================================*/
/*JP
 * \brief O[vȂ
 * \ingroup ATOMEXLIB_PLAYER
 * \par :
 * {CX~bgO[vɂ鐧邽߂̒萔łB<br>
 * ::criAtomExPlayer_SetGroupNumber ֐ɑ΂Ă̒lw肷ƁA
 * w肳ꂽv[[̓{CX~bgO[vɂ鐧󂯂ȂȂ܂B<br>
 * i󂫃{CX邩A܂͎gvCIeB̃{CX΁A
 * {CX~bgO[vɊ֌WȂ{CX擾܂Bj
 * \sa criAtomExPlayer_SetGroupNumber
 */
#define CRIATOMEXPLAYER_NO_GROUP_LIMITATION	(-1)

/*JP
 * \brief [v񐔐p
 * \ingroup ATOMEXLIB_PLAYER
 * \par :
 */
#define CRIATOMEXPLAYER_NO_LOOP_LIMITATION	(CRIATOMPLAYER_NO_LOOP_LIMITATION)	/*JP<[v񐔐Ȃ	*/
#define CRIATOMEXPLAYER_IGNORE_LOOP			(CRIATOMPLAYER_IGNORE_LOOP)			/*JP<[v𖳎	*/
#define CRIATOMEXPLAYER_FORCE_LOOP			(CRIATOMPLAYER_FORCE_LOOP)			/*JP<[vĐ		*/

/*JP
 * \brief v[[Ɏw\ȍőASRbN
 * \ingroup ATOMEXLIB_PLAYER
 * \par :
 * 1̃v[[ɑ΂Ďw\ASRbN̍ő吔łB
 * \sa criAtomExPlayer_SetAsrRackIdArray
 */
#define CRIATOMEXPLAYER_MAX_ASR_RACKS		(8)

 /*JP
  * \brief v[[Ɏw\ȍőo̓|[g
  * \ingroup ATOMEXLIB_PLAYER
  * \par :
  * 1̃v[[ɑ΂Ďw\ȏo̓|[g̍ő吔łB
  * \sa criAtomExPlayer_AddOutputPort, criAtomExPlayer_AddPreferredOutputPort
  */
#define CRIATOMEXPLAYER_MAX_OUTPUT_PORTS		CRIATOMEXPLAYER_MAX_ASR_RACKS

/*==========================================================================
 *      CRI AtomEx Playback API
 *=========================================================================*/
/*JP
 * \brief ȍĐID
 * \ingroup ATOMEXLIB_PLAYBACK
 * \par :
 * ::criAtomExPlayer_Start ֐ŉ̍ĐJnہA
 * {CX~bgRg[ɂ{CXmۂłȂꍇɕԂA
 * ȍĐIDłB<br>
 * \par l:
 * Đ ID w肷 API ɑ΂Ė{ ID ZbgꍇłA
 * G[R[obN͔܂B<br>
 * iꂸɊ֐烊^[܂Bj<br>
 * ̂߁A ::criAtomExPlayer_Start ֐̌ʂɂ炸A
 * Đ ID gp펞sĂAɖ肠܂B<br>
 * \sa CriAtomExPlaybackId, criAtomExPlayer_Start
 */
#define CRIATOMEX_INVALID_PLAYBACK_ID	(0xFFFFFFFF)

/*JP
 * \brief ȃubNCfbNX
 * \ingroup ATOMEXLIB_PLAYBACK
 * \par :
 * ::criAtomExPlayback_GetCurrentBlockIndex ֐ōĐ̉̃JgubN
 * CfbNX擾ہAĐ̉ubNV[PXł͂Ȃꍇ
 * Ԃ閳ȃCfbNXłB<br>
 * \sa criAtomExPlayback_GetCurrentBlockIndex
 */
#define CRIATOMEX_INVALID_BLOCK_INDEX	(0xFFFFFFFF)

/*==========================================================================
 *      CRI AtomEx Fader API
 *=========================================================================*/
/*JP
 * \brief tF[hAEg̖wl
 * \ingroup ATOMEXLIB_FADER
 * \par :
 * tF[_[̃tF[hAEg𖳌邽߂̒lłB<br>
 * ::criAtomExPlayer_SetFadeOutTime ֐̑2ɖ{p[^[Zbg邱ƂŁA
 * tF[hAEg𖳌邱Ƃ\łB<br>
 * \sa criAtomExPlayer_SetFadeOutTime
 */
#define CRIATOMEX_IGNORE_FADE_OUT		(-1)

/*==========================================================================
 *      CRI AtomEx D-BAS API
 *=========================================================================*/
/*JP
 * \brief AtomEx D-BAS ID
 * \ingroup ATOMEXLIB_DBAS
 * \par :
 * ::criAtomExDbas_Create ֐ɎsۂɕԂlłB <br>
 * \sa criAtomExDbas_Create, criAtomExDbas_Destroy
 */
#define CRIATOMEXDBAS_ILLEGAL_ID		(CRIATOMDBAS_ILLEGAL_ID)

/* ========================================================================*/
/*       CRI AtomEx Streaming Cache API                                    */
/* ========================================================================*/
/*JP
 * \brief sȃXg[~OLbVIDl
 * \ingroup ATOMEXLIB_STREAMING_CACHE
 * \par :
 * ::criAtomExStreamingCache_Create ֐ɎsۂɕԂlłB <br>
 * \sa criAtomExStreamingCache_Create, criAtomExStreamingCache_Destroy
 */
#define CRIATOMEX_STREAMING_CACHE_ILLEGAL_ID	(CRIATOM_STREAMING_CACHE_ILLEGAL_ID)

/*==========================================================================
 *      CRI AtomEx 3D API
 *=========================================================================*/
/*JP
 * \brief 3D̃_ɂeZo@Ɋւp[^[̍ől
 * \ingroup ATOMEXLIB_3D
 * \par :
 * ::CriAtomEx3dSourceRandomPositionConfig::calculation_parameters zɂ
 * ővfłB
 * \sa CriAtomEx3dSourceRandomPositionConfig
 */
#define CRIATOMEX3DSOURCE_MAX_RANDOM_POSITION_CALCULATION_PARAMETERS	(3)

/*==========================================================================
 *      CRI AtomEx Output Port API
 *=========================================================================*/
/*JP
 * \brief o̓|[g̖O̒̍ől
 * \ingroup ATOMEXLIB_OUTPUT_PORT
 * \par :
 * ::CriAtomExOutputPortConfig::name ɖOƂĎwł镶̍ő咷łB
 * \sa CriAtomExOutputPortConfig
 */
#define CRIATOMEX_OUTPUT_PORT_MAX_NAME_LENGTH (64)

/***************************************************************************
 *      }N
 *      Macro Functions
 ***************************************************************************/
/*==========================================================================
 *      CRI AtomEx API
 *=========================================================================*/
/*JP
 * \brief [UAP[^[̓o^
 * \ingroup ATOMEXLIB_GLOBAL
 * \param[in]	p_malloc_func	mۊ֐
 * \param[in]	p_free_func		֐
 * \param[in]	p_obj			[UwIuWFNg
 * \par :
 * CRI Atom CuɃAP[^[i̊mہ^֐jo^܂B<br>
 * {}NŃAP[^[o^ƁAAtomCu[N̈KvƂ^C~OŁA
 * [Uo^mہ^Ăяo邱ƂɂȂ܂B<br>
 * ̌ʁA[N̈KvƂ֐i ::criAtomExPlayer_Create ֐jɑ΂A
 * ʂɃ[N̈Zbg鏈ȗ邱Ƃ\ɂȂ܂B<br>
 * i[N̈ NULL |C^A[N̈TCY 0 oCgw肵ꍇłA
 * AP[^[̓Imۂɂ胉CuȂ삷悤ɂȂ܂Bj<br>
 * \par :
 * mہ^֐̃|C^ NULL w肷邱ƂŁA
 * AP[^[̓o^邱Ƃ\łB<br>
 * Ã̈悪cĂԂœo^ƁA
 * G[R[obNԂAo^̉Ɏs܂B<br>
 * io^ς݂̃AP[^[Ăяo邱ƂɂȂ܂Bj<br>
 * <br>
 * {}N͓I ::criAtom_SetUserAllocator }N
 * ::criAtom_SetUserMallocFunction ֐A ::criAtom_SetUserFreeFunction
 * ֐Ăяo܂B<br>
 * {֐Ƃ API 𕹗pȂ悤ӂB<br>
 * i{֐̌ĂяoɂAL API ɃZbge㏑܂Bj<br>
 * <br>
 * ܂Ao^ꂽAP[^[֐̓}Xbh[hɕ̃XbhR[
 * 邱Ƃ܂B]āAAP[gXbhZ[tłȂꍇ͓Ǝ
 * AP[gr䂷Kv܂B
 */
#define criAtomEx_SetUserAllocator(p_malloc_func, p_free_func, p_obj)	\
	criAtom_SetUserAllocator((p_malloc_func), (p_free_func), (p_obj))

/*JP
 * \brief CupRtBO\̂ɃftHglZbg
 * \ingroup ATOMEXLIB_GLOBAL
 * \param[out]	p_config	pRtBO\̂ւ̃|C^
 * \par :
 * ::criAtomEx_Initialize ֐ɐݒ肷RtBO\́i ::CriAtomExConfig jɁA
 * ftHg̒lZbg܂B<br>
 * \sa
 * CriAtomExConfig
 */
#define criAtomEx_SetDefaultConfig(p_config)	\
{\
	(p_config)->thread_model = CRIATOMEX_THREAD_MODEL_MULTI;\
	(p_config)->server_frequency = 60.0f;\
	(p_config)->parameter_update_interval = 1;\
	(p_config)->enable_atom_sound_disabled_mode = CRI_FALSE;\
	(p_config)->max_virtual_voices = 16;\
	(p_config)->max_parameter_blocks = 1024;\
	(p_config)->max_voice_limit_groups = 16;\
	(p_config)->max_categories = 16;\
	(p_config)->max_aisacs = 8;\
	(p_config)->max_bus_sends = 8;\
	(p_config)->categories_per_playback = 4;\
	(p_config)->max_sequences = (p_config)->max_virtual_voices;\
	(p_config)->max_tracks = (p_config)->max_virtual_voices * 2;\
	(p_config)->max_track_items = (p_config)->max_virtual_voices * 2;\
	(p_config)->max_aisac_auto_modulations = 0;\
	(p_config)->max_pitch = 2400.0f;\
	(p_config)->max_faders = 4;\
	(p_config)->coordinate_system = CRIATOMEX_COORDINATE_SYSTEM_LEFT_HANDED;\
	(p_config)->enable_auto_matching_in_pan_type_auto = CRI_FALSE;\
	(p_config)->enable_category_override_by_ex_player = CRI_FALSE;\
	(p_config)->sequence_prepare_ratio = 1.5;\
	(p_config)->rng_if = NULL;\
	(p_config)->fs_config = NULL;\
	(p_config)->acf_info = NULL;\
	(p_config)->context = NULL;\
	(p_config)->version = CRI_ATOM_VERSION;\
	(p_config)->version_ex = CRIATOMEX_VERSION;\
	(p_config)->version_string = CRI_ATOM_VER_NUM;\
	(p_config)->version_ex_string = CRIATOMEX_VER_NUM;\
}

/*JP
 * \brief ptH[}Xj^[@\̒ǉ
 * \ingroup ATOMEXLIB_GLOBAL
 * \par :
 * ptH[}Xv@\ǉAptH[}XvJn܂B<br>
 * {֐sA ::criAtomEx_GetPerformanceInfo ֐s邱ƂŁA
 * T[o[ׂ̕AT[o[̎sԊuACũptH[}X
 * 擾邱Ƃ\łB
 * \sa criAtomEx_GetPerformanceInfo, criAtomEx_DetachPerformanceMonitor
 * \par :
 * \code
 * 	// ptH[}X擾p\
 * 	CriAtomExPerformanceInfo info;
 * 	
 * 	// Cȕ
 * 	criAtomEx_Initialize(c);
 * 	
 * 	// ptH[}Xj^[@\̒ǉ
 * 	criAtomEx_AttachPerformanceMonitor();
 * 	
 * 	// ptH[}Xj^[̃Zbg
 * 	criAtomEx_ResetPerformanceMonitor();
 * 	
 * 	// ptH[}Xv
 * 	c
 * 	
 * 	// ptH[}X̎擾
 * 	criAtomEx_GetPerformanceInfo(&info);
 * 	
 * 	// vʂ̕\
 * 	printf(
 * 		"Max CPU Load            : %d (us)\n"	\
 * 		"Average CPU Load        : %d (us)\n"	\
 * 		"Max Server Interval     : %d (us)\n"	\
 * 		"Average Server Interval : %d (us)\n",
 * 		info.max_server_time, info.average_server_time,
 * 		info.max_server_interval, info.average_server_interval
 * 	);
 * \endcode
 */
#define criAtomEx_AttachPerformanceMonitor()	criAtom_AttachPerformanceMonitor()

/*JP
 * \brief ptH[}Xj^[@\̍폜
 * \ingroup ATOMEXLIB_GLOBAL
 * \par :
 * ptH[}XvIAptH[}Xv@\폜܂B
 * \attention
 * {֐͊A^̊֐łB<br>
 * {֐sƁA΂炭̊AtomCũT[o[ubN܂B<br>
 * Đɖ{֐sƁAr؂ꓙ̕s\邽߁A
 * {֐̌Ăяo̓V[̐؂ւ蓙Aוϓeł^C~OōsĂB
 */
#define criAtomEx_DetachPerformanceMonitor()	criAtom_DetachPerformanceMonitor()

/*JP
 * \brief ptH[}Xj^[̃Zbg
 * \ingroup ATOMEXLIB_GLOBAL
 * \par :
 * ݂܂ł̌vʂj܂B<br>
 * ptH[}Xj^[́A ::criAtomEx_AttachPerformanceMonitor ֐s
 * ptH[}X̎擾JnAvʂݐς܂B<br>
 * ȑǑvʂȍ~̌vʂɊ܂߂Ȃꍇɂ́A
 * {֐sAݐςꂽvʂUjKv܂B
 */
#define criAtomEx_ResetPerformanceMonitor()		criAtom_ResetPerformanceMonitor()

/*JP
 * \brief ptH[}X̎擾
 * \ingroup ATOMEXLIB_GLOBAL
 * \par :
 * ptH[}X擾܂B<br>
 * {֐́A ::criAtomEx_AttachPerformanceMonitor ֐sォ
 * ::criAtomEx_DetachPerformanceMonitor ֐s܂ł̊ԁAp\łB<br>
 * \sa criAtomEx_AttachPerformanceMonitor, criAtomEx_DetachPerformanceMonitor
 */
#define criAtomEx_GetPerformanceInfo(p_info)	criAtom_GetPerformanceInfo(p_info)

/*JP
 * \brief `l}bsOp^[̎w
 * \ingroup ATOMEXLIB_GLOBAL
 * \param[in]	nch		}bsOp^[ύX`l
 * \param[in]	type	}bsOp^[
 * \par :
 * f[^̊e`lƏo̓Xs[J[̑ΉtύX܂B<br>
 * Ⴆ΁A5chf[^ĐꍇAftHgԂł͊e`l 
 * L, R, C, Ls, Rs ̏ŏo͂܂B<br>
 * ɑ΂A::criAtomEx_SetChannelMapping(5, 1); sꍇA
 * 5chf[^̊e`l L, R, LFE, Ls, Rs ̏ŏo͂悤ɂȂ܂B<br>
 * \par l:
 * A{֐5chf[^̃}bsOp^[ύXɂΉĂ܂B<br>
 */
#define criAtomEx_SetChannelMapping(nch, type)	\
	criAtom_SetChannelMapping((nch), (type))

/*JP
 * \brief ADXf[^̃rbg[gvZ
 * \ingroup ATOMEXLIB_GLOBAL
 * \param[in]	num_channels	f[^̃`l
 * \param[in]	sampling_rate	f[^̃TvO[g
 * \return		CriSint32		rbg[g[bps]
 * \par :
 * ADXf[^̃rbg[gvZ܂B<br>
 * vZɎsƖ{֐-1Ԃ܂B<br>
 * vZɎsRɂẮAG[R[obÑbZ[WŊmF\łB<br>
 */
#define criAtomEx_CalculateAdxBitrate(num_channels, sampling_rate) \
	criAtom_CalculateAdxBitrate(num_channels, sampling_rate)

/*JP
 * \brief HCAf[^̃rbg[gvZ
 * \ingroup ATOMEXLIB_GLOBAL
 * \param[in]	num_channels	f[^̃`l
 * \param[in]	sampling_rate	f[^̃TvO[g
 * \param[in]	quality			f[^̃GR[hi
 * \return		CriSint32		rbg[g[bps]
 * \par :
 * HCAf[^̃rbg[gvZ܂B<br>
 * vZɎsƖ{֐-1Ԃ܂B<br>
 * vZɎsRɂẮAG[R[obÑbZ[WŊmF\łB<br>
 * \par l:
 * qualityɂCRI Atom Craft܂CRI Atom EncoderŐݒ肵GR[hiw肵܂B
 */
#define criAtomEx_CalculateHcaBitrate(num_channels, sampling_rate, quality) \
	criAtom_CalculateHcaBitrate(num_channels, sampling_rate, quality)

/*JP
 * \brief HCA-MXf[^̃rbg[gvZ
 * \ingroup ATOMEXLIB_GLOBAL
 * \param[in]	num_channels	f[^̃`l
 * \param[in]	sampling_rate	f[^̃TvO[g
 * \param[in]	quality			f[^̃GR[hi
 * \return		CriSint32		rbg[g[bps]
 * \par :
 * HCA-MXf[^̃rbg[gvZ܂B<br>
 * vZɎsƖ{֐-1Ԃ܂B<br>
 * vZɎsRɂẮAG[R[obÑbZ[WŊmF\łB<br>
 * \par l:
 * qualityɂCRI Atom Craft܂CRI Atom EncoderŐݒ肵GR[hiw肵܂B
 */
#define criAtomEx_CalculateHcaMxBitrate(num_channels, sampling_rate, quality) \
	criAtom_CalculateHcaMxBitrate(num_channels, sampling_rate, quality)

/*JP
 * \brief Wavef[^̃rbg[gvZ
 * \ingroup ATOMEXLIB_GLOBAL
 * \param[in]	num_channels	f[^̃`l
 * \param[in]	sampling_rate	f[^̃TvO[g
 * \param[in]	num_bits		Tṽrbg
 * \return		CriSint32		rbg[g[bps]
 * \par :
 * Wavef[^̃rbg[gvZ܂B<br>
 * vZɎsƖ{֐-1Ԃ܂B<br>
 * vZɎsRɂẮAG[R[obÑbZ[WŊmF\łB<br>
 */
#define criAtomEx_CalculateWaveBitrate(num_channels, sampling_rate, num_bits)	\
	criAtom_CalculateWaveBitrate(num_channels, sampling_rate, num_bits)

/*JP
 * \brief AIFFf[^̃rbg[gvZ
 * \ingroup ATOMEXLIB_GLOBAL
 * \param[in]	num_channels	f[^̃`l
 * \param[in]	sampling_rate	f[^̃TvO[g
 * \param[in]	num_bits		Tṽrbg
 * \return		CriSint32		rbg[g[bps]
 * \par :
 * AIFFf[^̃rbg[gvZ܂B<br>
 * vZɎsƖ{֐-1Ԃ܂B<br>
 * vZɎsRɂẮAG[R[obÑbZ[WŊmF\łB<br>
 */
#define criAtomEx_CalculateAiffBitrate(num_channels, sampling_rate, num_bits)	\
	criAtom_CalculateAiffBitrate(num_channels, sampling_rate, num_bits)

/*==========================================================================
 *      CRI AtomEx HCA-MX API
 *=========================================================================*/
/*JP
 * \brief HCA-MXRtBO\̂ɃftHglZbg
 * \ingroup ATOMEXLIB_HCA_MX
 * \par :
 * ::criAtomExHcaMx_Initialize ֐ɐݒ肷RtBO\
 * i ::CriAtomExHcaMxConfig jɁAftHglZbg܂B<br>
 * \sa criAtomExHcaMx_Initialize, CriAtomExHcaMxConfig
 */
#define criAtomExHcaMx_SetDefaultConfig(p_config)	\
{\
	(p_config)->server_frequency = 60.0f;\
	(p_config)->num_mixers = 1;\
	(p_config)->max_voices = 16;\
	(p_config)->max_input_channels = CRIATOM_DEFAULT_INPUT_MAX_CHANNELS;\
	(p_config)->max_sampling_rate = CRIATOM_DEFAULT_OUTPUT_SAMPLING_RATE;\
	(p_config)->output_channels = CRIATOM_DEFAULT_OUTPUT_CHANNELS;\
	(p_config)->output_sampling_rate = CRIATOM_DEFAULT_OUTPUT_SAMPLING_RATE;\
	(p_config)->sound_renderer_type	= CRIATOM_SOUND_RENDERER_DEFAULT;\
}

/*==========================================================================
 *      CRI AtomEx Voice Pool API
 *=========================================================================*/
/*JP
 * \brief W{CXv[쐬pRtBO\̂ɃftHglZbg
 * \ingroup ATOMEXLIB_VOICE_POOL
 * \param[out]	p_config	W{CXv[쐬pRtBO\̂ւ̃|C^
 * \par :
 * ::criAtomExVoicePool_AllocateStandardVoicePool ֐ɐݒ肷RtBO\
 * i ::CriAtomExStandardVoicePoolConfig jɁAftHg̒lZbg܂B<br>
 * \sa CriAtomExStandardVoicePoolConfig, criAtomExVoicePool_AllocateStandardVoicePool
 */
#define criAtomExVoicePool_SetDefaultConfigForStandardVoicePool(p_config)	\
{\
	(p_config)->identifier = 0;\
	(p_config)->num_voices = CRIATOMEX_DEFAULT_VOICES_PER_POOL;\
	criAtomPlayer_SetDefaultConfigForStandardPlayer(&(p_config)->player_config);\
	(p_config)->is_streaming_only = CRI_FALSE;\
	(p_config)->min_channels = 1;\
}

/*JP
 * \brief ADX{CXv[쐬pRtBO\̂ɃftHglZbg
 * \ingroup ATOMEXLIB_VOICE_POOL
 * \param[out]	p_config	ADX{CXv[쐬pRtBO\̂ւ̃|C^
 * \par :
 * ::criAtomExVoicePool_AllocateAdxVoicePool ֐ɐݒ肷RtBO\
 * i ::CriAtomExAdxVoicePoolConfig jɁAftHg̒lZbg܂B<br>
 * \sa CriAtomExAdxVoicePoolConfig, criAtomExVoicePool_AllocateAdxVoicePool
 */
#define criAtomExVoicePool_SetDefaultConfigForAdxVoicePool(p_config)	\
{\
	(p_config)->identifier = 0;\
	(p_config)->num_voices = CRIATOMEX_DEFAULT_VOICES_PER_POOL;\
	criAtomPlayer_SetDefaultConfigForAdxPlayer(&(p_config)->player_config);\
	(p_config)->is_streaming_only = CRI_FALSE;\
	(p_config)->min_channels = 1;\
}

/*JP
 * \brief HCA{CXv[쐬pRtBO\̂ɃftHglZbg
 * \ingroup ATOMEXLIB_VOICE_POOL
 * \param[out]	p_config	HCA{CXv[쐬pRtBO\̂ւ̃|C^
 * \par :
 * ::criAtomExVoicePool_AllocateHcaVoicePool ֐ɐݒ肷RtBO\
 * i ::CriAtomExHcaVoicePoolConfig jɁAftHg̒lZbg܂B<br>
 * \sa CriAtomExHcaVoicePoolConfig, criAtomExVoicePool_AllocateHcaVoicePool
 */
#define criAtomExVoicePool_SetDefaultConfigForHcaVoicePool(p_config)	\
{\
	(p_config)->identifier = 0;\
	(p_config)->num_voices = CRIATOMEX_DEFAULT_VOICES_PER_POOL;\
	criAtomPlayer_SetDefaultConfigForHcaPlayer(&(p_config)->player_config);\
	(p_config)->is_streaming_only = CRI_FALSE;\
	(p_config)->min_channels = 1;\
}

/*JP
 * \brief HCA-MX{CXv[쐬pRtBO\̂ɃftHglZbg
 * \ingroup ATOMEXLIB_VOICE_POOL
 * \param[out]	p_config	HCA-MX{CXv[쐬pRtBO\̂ւ̃|C^
 * \par :
 * ::criAtomExVoicePool_AllocateHcaMxVoicePool ֐ɐݒ肷RtBO\
 * i ::CriAtomExHcaMxVoicePoolConfig jɁAftHg̒lZbg܂B<br>
 * \sa CriAtomExHcaMxVoicePoolConfig, criAtomExVoicePool_AllocateHcaMxVoicePool
 */
#define criAtomExVoicePool_SetDefaultConfigForHcaMxVoicePool(p_config)	\
{\
	(p_config)->identifier = 0;\
	(p_config)->num_voices = CRIATOMEX_DEFAULT_VOICES_PER_POOL;\
	criAtomPlayer_SetDefaultConfigForHcaMxPlayer(&(p_config)->player_config);\
	(p_config)->is_streaming_only = CRI_FALSE;\
	(p_config)->min_channels = 1;\
}

/*JP
 * \brief Wave{CXv[쐬pRtBO\̂ɃftHglZbg
 * \ingroup ATOMEXLIB_VOICE_POOL
 * \param[out]	p_config	Wave{CXv[쐬pRtBO\̂ւ̃|C^
 * \par :
 * ::criAtomExVoicePool_AllocateWaveVoicePool ֐ɐݒ肷RtBO\
 * i ::CriAtomExWaveVoicePoolConfig jɁAftHg̒lZbg܂B<br>
 * \sa CriAtomExWaveVoicePoolConfig, criAtomExVoicePool_AllocateWaveVoicePool
 */
#define criAtomExVoicePool_SetDefaultConfigForWaveVoicePool(p_config)	\
{\
	(p_config)->identifier = 0;\
	(p_config)->num_voices = CRIATOMEX_DEFAULT_VOICES_PER_POOL;\
	criAtomPlayer_SetDefaultConfigForWavePlayer(&(p_config)->player_config);\
	(p_config)->is_streaming_only = CRI_FALSE;\
	(p_config)->min_channels = 1;\
}

/*JP
 * \brief AIFF{CXv[쐬pRtBO\̂ɃftHglZbg
 * \ingroup ATOMEXLIB_VOICE_POOL
 * \param[out]	p_config	AIFF{CXv[쐬pRtBO\̂ւ̃|C^
 * \par :
 * ::criAtomExVoicePool_AllocateAiffVoicePool ֐ɐݒ肷RtBO\
 * i ::CriAtomExAiffVoicePoolConfig jɁAftHg̒lZbg܂B<br>
 * \sa CriAtomExAiffVoicePoolConfig, criAtomExVoicePool_AllocateAiffVoicePool
 */
#define criAtomExVoicePool_SetDefaultConfigForAiffVoicePool(p_config)	\
{\
	(p_config)->identifier = 0;\
	(p_config)->num_voices = CRIATOMEX_DEFAULT_VOICES_PER_POOL;\
	criAtomPlayer_SetDefaultConfigForAiffPlayer(&(p_config)->player_config);\
	(p_config)->is_streaming_only = CRI_FALSE;\
	(p_config)->min_channels = 1;\
}

/*JP
 * \brief RawPCM{CXv[쐬pRtBO\̂ɃftHglZbg
 * \ingroup ATOMEXLIB_VOICE_POOL
 * \param[out]	p_config	RawPCM{CXv[쐬pRtBO\̂ւ̃|C^
 * \par :
 * ::criAtomExVoicePool_AllocateRawPcmVoicePool ֐ɐݒ肷RtBO\
 * i ::CriAtomExRawPcmVoicePoolConfig jɁAftHg̒lZbg܂B<br>
 * \sa CriAtomExRawPcmVoicePoolConfig, criAtomExVoicePool_AllocateRawPcmVoicePool
 */
#define criAtomExVoicePool_SetDefaultConfigForRawPcmVoicePool(p_config)	\
{\
	(p_config)->identifier = 0;\
	(p_config)->num_voices = CRIATOMEX_DEFAULT_VOICES_PER_POOL;\
	criAtomPlayer_SetDefaultConfigForRawPcmPlayer(&(p_config)->player_config);\
}

/*JP
 * \brief CXgDg{CXv[쐬pRtBO\̂ɃftHglZbg
 * \ingroup ATOMEXLIB_VOICE_POOL
 * \param[out]	p_config	RawPCM{CXv[쐬pRtBO\̂ւ̃|C^
 * \par :
 * ::criAtomExVoicePool_AllocateInstrumentVoicePool ֐ɐݒ肷RtBO\
 * i ::  CriAtomExInstrumentVoicePoolConfig jɁAftHg̒lZbg܂B<br>
 * \par :
 * ftHgl̂܂܂ł̓v[̍쐬Ɏs܂B<br>
 * [Uo^C^[tF[X̃CXgDgݒ肷Kv܂B
 * \sa  CriAtomExInstrumentVoicePoolConfig, criAtomExVoicePool_AllocateInstrumentVoicePool
 */
#define criAtomExVoicePool_SetDefaultConfigForInstrumentVoicePool(p_config)	\
{\
	(p_config)->identifier = 0;\
	(p_config)->num_voices = CRIATOMEX_DEFAULT_VOICES_PER_POOL;\
	criAtomPlayer_SetDefaultConfigForInstrumentPlayer(&(p_config)->player_config);\
}

/*==========================================================================
 *      CRI AtomEx Player API
 *=========================================================================*/
/*JP
 * \brief v[[쐬pRtBO\̂ɃftHglZbg
 * \ingroup ATOMEXLIB_PLAYER
 * \param[out]	p_config	AtomExv[[쐬pRtBO\̂ւ̃|C^
 * \par :
 * ::criAtomExPlayer_Create ֐ɐݒ肷RtBO\
 * i ::CriAtomExPlayerConfig jɁAftHg̒lZbg܂B<br>
 * \sa CriAtomExPlayerConfig, criAtomExPlayer_Create
 */
#define criAtomExPlayer_SetDefaultConfig(p_config)	\
{\
	(p_config)->voice_allocation_method = CRIATOMEX_ALLOCATE_VOICE_ONCE;\
	(p_config)->max_path_strings = 1;\
	(p_config)->max_path = 0;\
	(p_config)->updates_time = CRI_TRUE;\
	(p_config)->enable_audio_synced_timer = CRI_FALSE;\
	(p_config)->max_aisacs = 8;\
}

/*==========================================================================
 *      CRI AtomEx OutputPort API
 *=========================================================================*/
/*JP
 * \brief o̓|[g쐬pRtBO\̂ɃftHglZbg
 * \ingroup ATOMEXLIB_OUTPUT_PORT
 * \param[in]	outputport_name		o̓|[g
 * \param[out]	p_config			o̓|[g쐬pRtBO\̂ւ̃|C^
 * \par :
 * ::criAtomExOutputPort_Create ֐ɐݒ肷RtBO\
 * i ::CriAtomExOutputPortConfig jɁAftHg̒lZbg܂B<br>
 * \sa CriAtomExOutputPortConfig, criAtomExOutputPort_Create
 */
#define criAtomExOutputPort_SetDefaultConfig(p_config, outputport_name)	\
{\
	(p_config)->name = outputport_name;\
	(p_config)->type = CRIATOMEX_OUTPUT_PORT_TYPE_AUDIO;\
	(p_config)->max_ignored_categories = 4;\
}

/*==========================================================================
 *      CRI AtomEx Fader API
 *=========================================================================*/
/*JP
 * \brief tF[_[A^b`pRtBO\̂ɃftHglZbg
 * \ingroup ATOMEXLIB_FADER
 * \param[out]	p_config	tF[_[A^b`pRtBO\̂ւ̃|C^
 * \par :
 * ::criAtomExPlayer_AttachFader ֐ɐݒ肷RtBO\
 * i ::CriAtomExFaderConfig jɁAftHg̒lZbg܂B<br>
 * \sa CriAtomExFaderConfig, criAtomExPlayer_AttachFader
 */
#define criAtomExFader_SetDefaultConfig(p_config)	\
{\
	(p_config)->reserved = 0;\
}

/*==========================================================================
 *      CRI AtomEx D-BAS API
 *=========================================================================*/
/*JP
 * \brief CriAtomExDbasConfig ւ̃ftHgp[^[̃Zbg
 * \ingroup ATOMEXLIB_DBAS
 * \param[out]	p_config	D-BAS쐬pRtBO\̂ւ̃|C^
 * \par :
 * ::criAtomExDbas_Create ֐ɐݒ肷RtBO\
 * i ::CriAtomExDbasConfig jɁAftHg̒lZbg܂B<br>
 * \sa CriAtomExDbasConfig, criAtomExDbas_Create, criAtomExDbas_CalculateWorkSize
 */
#define criAtomExDbas_SetDefaultConfig(p_config)	\
	criAtomDbas_SetDefaultConfig(p_config)

/*JP
 * \brief D-BAS쐬p[NTCY̌vZ
 * \ingroup ATOMEXLIB_DBAS
 * \param[in]	config		D-BAS쐬pRtBO\̂ւ̃|C^
 * \return		CriSint32	D-BAS쐬p[NTCY
 * \retval		0ȏ		ɏ
 * \retval		-1			G[
 * \par :
 * D-BAS쐬pp[^[ɊÂāAD-BAS̍쐬ɕKv[NTCYvZ܂B<br>
 * <br>
 * [N̈TCY̌vZɎsƁA{֐ -1 Ԃ܂B<br>
 * [N̈TCY̌vZɎsRɂẮAG[R[obÑbZ[WŊmF\łB<br>
 * \attention
 * [N̈̃TCY̓Cui ::criAtomEx_Initialize ֐sj
 * Ɏw肵p[^[ɂĕω܂B<br>
 * ̂߁A{֐sOɁACuĂKv܂B<br>
 * \sa criAtomExDbas_Create, criAtomEx_Initialize
 */
#define criAtomExDbas_CalculateWorkSize(config)	\
	criAtomDbas_CalculateWorkSize(config)

/*JP
 * \brief D-BAS̍쐬
 * \ingroup ATOMEXLIB_DBAS
 * \param[in]	config			D-BAS쐬pRtBO\̂ւ̃|C^
 * \param[in]	work			D-BAS쐬p[N̈ւ̃|C^
 * \param[in]	work_size		D-BAS쐬p[NTCY
 * \return		CriAtomExDbasId	D-BASǗpID
 * \par :
 * D-BAS쐬pp[^[ɊÂāAD-BAS쐬܂B<br>
 * 쐬ɐƁAD-BASCuɓo^ALȊǗpIDԂ܂B<br>
 * D-BAS̍쐬ɎsꍇA{֐ ::CRIATOMEXDBAS_ILLEGAL_ID Ԃ܂B<br>
 * iG[̌̓G[R[obNɕԂ܂Bj<br>
 * <br>
 * 擾ID::criAtomExDbas_Destroy ֐Ŏgp܂B<br>
 * \attention
 * {֐sOɁACuĂKv܂B<br>
 * \sa criAtomExDbas_CalculateWorkSize, criAtomExDbas_Destroy
 */
#define criAtomExDbas_Create(config, work, work_size)	\
	criAtomDbas_Create((config), (work), (work_size))

/*JP
 * \brief D-BAS̔j
 * \ingroup ATOMEXLIB_DBAS
 * \param[in]	atom_dbas_id	D-BASǗpID
 * \par :
 * ::criAtomExDbas_Create ֐Ŏ擾ǗpIDw肵āAD-BASj܂B<br>
 * \sa criAtomExDbas_Create
 */
#define criAtomExDbas_Destroy(atom_dbas_id)	\
	criAtomDbas_Destroy(atom_dbas_id);

/*JP
 * \brief Xg[ĐAtomv[[nh擾
 * \ingroup ATOMEXLIB_DBAS
 * \param[in]	dbas_id			D-BASǗpID
 * \param[out]	players			v[[nh󂯎pz
 * \param[in]	length			v[[nh󂯎pzvf
 * \return		CriSint32		v[[
 * \retval		0ȏ			ɏ
 * \retval		-1				G[
 * \par :
 * Xg[ĐAtomv[[nh擾܂B<br>
 * v[[nh̎擾ɐƁA
 * 3iplayerszjɃv[[nh̃AhXۑA
 * v[[nh߂lƂĕԂ܂B<br>
 * \par l:
 * 3iplayerszjNULLA4ilengthj0w肷邱ƂŁA
 * Xg[Đ̃v[[̐߂lƂĎ擾\łB<br>
 * \attention
 * v[[擾Ănh擾ꍇA
 * v[[擾ƃnh擾̊ԂɃT[o[荞܂Ȃ悤A
 * criAtom_Lock ֐ŔrsKv܂B<br>
 * iT[o[̃^C~OŁAv[[ς\܂Bj<br>
 * <br>
 * zvfXg[Đ̃v[[ɖȂꍇA
 * {֐̓G[li-1jԂ܂B<br>
 */
#define criAtomExDbas_GetStreamingPlayerHandles(dbas_id, players, length)	\
	criAtomDbas_GetStreamingPlayerHandles((dbas_id), (players), (length))

/* ========================================================================*/
/*       CRI AtomEx Streaming Cache API                                    */
/* ========================================================================*/
/*JP
 * \brief CriAtomExStreamingCacheConfigւ̃ftHgp[^[̃Zbg
 * \ingroup ATOMEXLIB_STREAMING_CACHE
 * \param[out]	p_config	Xg[~OLbV쐬pRtBO\̂ւ̃|C^
 * \par :
 * ::criAtomExStreamingCache_CalculateWorkSize ֐A
 * ::criAtomExStreamingCache_Create ֐ɐݒ肷RtBO\
 * i ::CriAtomExStreamingCacheConfig jɑ΂AftHglZbg܂B<br>
 * \sa criAtomExStreamingCache_CalculateWorkSize, criAtomExStreamingCache_Create
 */
#define criAtomExStreamingCache_SetDefaultConfig(p_config)	\
	criAtomStreamingCache_SetDefaultConfig(p_config)

/*JP
 * \brief Xg[~OLbV쐬ɕKvȃ[NTCY̌vZ
 * \ingroup ATOMEXLIB_STREAMING_CACHE
 * \param[in]	p_config	Xg[~OLbV쐬p\
 * \return		CriSint32	Xg[~OLbV쐬ɕKvȃ[NTCY
 * \retval		0ȏ		ɏ
 * \retval		-1			G[
 * \par :
 * Xg[~OLbV쐬ɕKvȃ[NTCYvZ܂B<br>
 * configŗ^p[^[ɈˑAKvȃ[NTCY͑܂B<br>
 * \sa criAtomExStreamingCache_Create
 */
#define criAtomExStreamingCache_CalculateWorkSize(p_config)	\
	criAtomStreamingCache_CalculateWorkSize(p_config)

/*JP
 * \brief Xg[~OLbV̍쐬
 * \ingroup ATOMEXLIB_STREAMING_CACHE
 * \param[in]	config		Xg[~OLbV쐬p\
 * \param[in]	work		Xg[~OLbV쐬p[N
 * \param[in]	work_size	Xg[~OLbV쐬p[NTCY
 * return		CriAtomExStreamingCacheId	Xg[~OLbVID
 * \par :
 * Xg[~OLbV쐬܂B<br>
 * Atomv[[ɃXg[~OLbVݒ肷邱ƂŁA
 * Xg[~OĐsɃt@CŜێiLbVj܂B<br>
 * t@C2ڈȍ~̍Đł́ALbVgĐɎIɐ؂ւ܂B<br>
 * ܂AĐf[^[vf[^ĂꍇA
 * [vȍ~̍Đ͎IɃĐōs悤ɂȂ܂B<br>
 * {@\Atomv[[Xg[~OĐsꍇ̂݋@\܂B<br>
 * {֐ɎsꍇACRIATOMEX_STREAMING_CACHE_ILLEGAL_IDԂ܂B<br>
 * \attention
 * t@CŜLbV鎖OłB<br>
 * āALbVpɊ蓖ĂꂽTCYXg[~OĐΏۂƂ
 * ǂ̃t@CTCYꍇA؃LbV܂B
 * \sa criAtomExStreamingCache_CalculateWorkSize, criAtomExStreamingCache_Destroy,
 */
#define criAtomExStreamingCache_Create(config, work, work_size)	\
	criAtomStreamingCache_Create((config), (work), (work_size));

/*JP
 * \brief Xg[~OLbV̔j
 * \ingroup ATOMEXLIB_STREAMING_CACHE
 * \param[in]	stm_cache_id		Xg[~OLbVID
 * \par :
 * w肵Xg[~OLbVj܂B<br>
 * \attention
 * w肵Xg[~OLbV𗘗pĂv[[݂ȂԂŁA
 * {֐sĂB
 * \sa criAtomExStreamingCache_Create
 */
#define criAtomExStreamingCache_Destroy(stm_cache_id)	\
	criAtomStreamingCache_Destroy(stm_cache_id)

/*JP
 * \brief Xg[~OLbṼLbVeNA
 * \ingroup ATOMEXLIB_STREAMING_CACHE
 * \param[in]	cache_id		Xg[~OLbVID
 * \par :
 * w肵Xg[~OLbV̓eNA܂B<br>
 * LbV͌ÂɃNA܂B<br>
 * w肵Xg[~OLbVgp̃v[[݂ꍇA
 * LbṼNA͓rŒf܂B<br>
 * \attention
 * ԌÂLbVgp̃v[[݂ꍇA{֐sĂ
 * LbV͈؃NA܂B
 * \sa criAtomExStreamingCache_Create
 */
#define criAtomExStreamingCache_Clear(cache_id)	\
	criAtomStreamingCache_Clear(cache_id)

/*JP
 * \brief WaveIDwŃLbVς݌
 * \ingroup ATOMEXLIB_STREAMING_CACHE
 * \param[in]	stm_cache_id		Xg[~OLbVID
 * \param[in]	awb					AWBnh
 * \param[in]	id					WaveID
 * \return		CriBool				LbVς݂łCRI_TRUEAȊOCRI_FALSE
 * \par :
 * w肵Xg[~OLbVɁAw̉f[^LbVĂ邩܂B<br>
 * w̉f[^LbVĂԂłCRI_TRUEA
 * LbVĂȂԂłCRI_FALSEԂ܂B<br>
 * \attention
 * AWBnhĐp̏ꍇA{֐͉f[^̗Lɂ炸CRI_TRUEԂ܂B<br>
 * \sa criAtomExStreamingCache_Create
 */
#define criAtomExStreamingCache_IsCachedWaveId(stm_cache_id, awb, id)	\
	criAtomStreamingCache_IsCachedWaveId((stm_cache_id), (awb), (id))

/*JP
 * \brief pXwŃLbVς݌
 * \ingroup ATOMEXLIB_STREAMING_CACHE
 * \param[in]	stm_cache_id		Xg[~OLbVID
 * \param[in]	src_binder			f[^t@Cǂݍ݌̃oC_[nh
 * \param[in]	path				f[^t@C̃pX
 * \return		CriBool				LbVς݂łCRI_TRUEAȊOCRI_FALSE
 * \par :
 * w肵Xg[~OLbVɁAw̉f[^LbVĂ邩܂B<br>
 * w̉f[^LbVĂԂłCRI_TRUEA
 * LbVĂȂԂłCRI_FALSEԂ܂B<br>
 * \sa criAtomStreamingCache_Create
 */
#define criAtomExStreamingCache_IsCachedFile(stm_cache_id, src_binder, path)	\
	criAtomStreamingCache_IsCachedFile((stm_cache_id), (src_binder), (path))

/*==========================================================================
 *      CRI AtomEx 3D API
 *=========================================================================*/
/*JP
 * \brief 3Dnh쐬pRtBO\̂ɃftHglZbg
 * \ingroup ATOMEXLIB_3D
 * \param[out]	p_config	3Dnh쐬pRtBO\̂ւ̃|C^
 * \par :
 * 3Dnh쐬pRtBO\́i ::CriAtomEx3dSourceConfig jɁAftHg̒lZbg܂B
 * \sa
 * CriAtomEx3dSourceConfig
 */
#define criAtomEx3dSource_SetDefaultConfig(p_config)	\
{\
	(p_config)->enable_voice_priority_decay = CRI_FALSE;\
	(p_config)->random_position_list_max_length = 0;\
}

/*JP
 * \brief 3DnhXg쐬pRtBO\̂ɃftHglZbg
 * \ingroup ATOMEXLIB_3D
 * \param[out]	p_config	3DnhXg쐬pRtBO\̂ւ̃|C^
 * \par :
 * 3DnhXg쐬pRtBO\́i ::CriAtomEx3dSourceListConfig jɁAftHg̒lZbg܂B
 * \sa
 * CriAtomEx3dSourceListConfig
 */
#define criAtomEx3dSourceList_SetDefaultConfig(p_config)	\
{\
	(p_config)->reserved = 0;\
}

/*JP
 * \brief 3DXi[nh쐬pRtBO\̂ɃftHglZbg
 * \ingroup ATOMEXLIB_3D
 * \param[out]	p_config	3DXi[nh쐬pRtBO\̂ւ̃|C^
 * \par :
 * 3DXi[nh쐬pRtBO\́i ::CriAtomEx3dListenerConfig jɁAftHg̒lZbg܂B
 * \sa
 * CriAtomEx3dListenerConfig
 */
#define criAtomEx3dListener_SetDefaultConfig(p_config)	\
{\
	(p_config)->reserved = 0;\
}

/*JP
 * \brief 3D[Wnh쐬pRtBO\̂ɃftHglZbg
 * \ingroup ATOMEXLIB_3D
 * \param[out]	p_config	3D[Wnh쐬pRtBO\̂ւ̃|C^
 * \par :
 * 3D[Wnh쐬pRtBO\́i ::CriAtomEx3dRegionConfig jɁAftHg̒lZbg܂B
 * \sa
 * CriAtomEx3dRegionConfig
 */
#define criAtomEx3dRegion_SetDefaultConfig(p_config)	\
{\
	(p_config)->reserved = 0;\
}

/*JP
 * \brief 3DgV[o[nh쐬pRtBO\̂ɃftHglZbg
 * \ingroup ATOMEXLIB_3D
 * \param[out]	p_config	3DgV[o[nh쐬pRtBO\̂ւ̃|C^
 * \par :
 * 3DgV[o[nh쐬pRtBO\́i ::CriAtomEx3dTransceiverConfig jɁAftHg̒lZbg܂B
 * \sa
 * CriAtomEx3dTransceiverConfig
 */
#define criAtomEx3dTransceiver_SetDefaultConfig(p_config)	\
{\
	(p_config)->reserved = 0;\
}

/*JP
 * \brief 3D̈ʒũ_ɊւRtBO\̂ɃftHglZbg
 * \ingroup ATOMEXLIB_3D
 * \param[out]	p_config	3D̈ʒũ_ɊւRtBO\̂ւ̃|C^
 * \par :
 * 3D̈ʒũ_ɊւRtBO\́i ::CriAtomEx3dSourceRandomPositionConfig jɁAftHg̒lZbg܂B
 * \sa CriAtomEx3dSourceRandomPositionConfig
 */
#define criAtomEx3dSource_SetDefaultConfigForRandomPosition(p_config)	\
{\
	(p_config)->follows_original_source = CRI_FALSE;\
	(p_config)->calculation_type = CRIATOMEX3DSOURCE_RANDOM_POSITION_CALCULATION_TYPE_RECTANGLE;\
	(p_config)->calculation_parameters[0] = 1.0f;\
	(p_config)->calculation_parameters[1] = 1.0f;\
	(p_config)->calculation_parameters[2] = 0.0f;\
}

/*JP
 * \brief 3D̍ŏ^ő勗̐ݒ
 * \ingroup ATOMEXLIB_3D
 * \param[in]	ex_3d_source		3Dnh
 * \param[in]	min_attenuation_distance		ŏ
 * \param[in]	max_attenuation_distance		ő勗
 * \par :
 * 3D̍ŏ^ő勗ݒ肵܂B<br>
 * ŏ́Aȏ㉹ʂ傫ȂȂ\܂Bő勗́AŏʂɂȂ鋗\܂B<br>
 * CũftHgl͈ȉ̂ƂłB<br>
 * 	- ŏF0.0f
 * 	- ő勗F0.0f
 * 	
 * ftHgĺA::criAtomEx3dSource_ChangeDefaultMinMaxAttenuationDistance ֐ɂĕύX\łB<br>
 * f[^ɓYp[^[ݒ肳Ăꍇɖ{֐ĂяoƁAf[^̒l㏑ijēKp܂B
 * \attention
 * ݒ肵p[^[ۂɓKpɂ́A::criAtomEx3dSource_Update ֐ĂяoKv܂B
 * \sa criAtomEx3dSource_Update, criAtomEx3dSource_ChangeDefaultMinMaxDistance
 */
#define criAtomEx3dSource_SetMinMaxDistance(ex_3d_source, min_attenuation_distance, max_attenuation_distance) \
	criAtomEx3dSource_SetMinMaxAttenuationDistance((ex_3d_source), (min_attenuation_distance), (max_attenuation_distance))

/*JP
 * \brief 3D̍ŏ^ő勗̃ftHglύX
 * \ingroup ATOMEXLIB_3D
 * \param[in]	min_attenuation_distance		ŏ
 * \param[in]	max_attenuation_distance		ő勗
 * \par :
 * 3D̍ŏ^ő勗̃ftHglύX܂B<br>
 * {֐ɂăftHglύXƁAȍ~ɍ쐬3Dnhi ::CriAtomEx3dSourceHn j
 * ŏ^ő勗̏l{֐Őݒ肵lƂȂ܂B<br>
 * \attention
 * Yp[^[Ɋւāuc[ŒlύXĂȂiftHgԁjvf[^̏ꍇAÖٓIɃftHglKp܂B<br>
 * ̂߁A{֐ŃftHglύXƁAc[ł̕ҏWɈӐ}Ăp[^[ƈقȂĂ܂\܂B<br>
 * AAȉɊYf[^͖{֐̉e󂯂܂B<br>
 * 	- c[̃vpeBɂāAŏ^ő勗̏lݒ0.0ȊOɐݒ肵Ă
 * 	- CQ[vr[pɃrhĂ
 * 	
 * \sa criAtomEx3dSource_SetMinMaxDistance
 */
#define criAtomEx3dSource_ChangeDefaultMinMaxDistance(min_attenuation_distance, max_attenuation_distance) \
	criAtomEx3dSource_ChangeDefaultMinMaxAttenuationDistance((min_attenuation_distance), (max_attenuation_distance))

/*==========================================================================
 *      CRI AtomEx DSP API
 *=========================================================================*/

/*JP
 * \brief sb`Vt^[DSP̃A^b`pRtBOɃftHglZbg
 * \ingroup ATOMEXLIB_DSP
 * \param[out]	p_config	sb`Vt^[DSP̃A^b`pRtBOւ̃|C^
 * \par :
 * sb`Vt^[DSP̃A^b`pRtBOi ::CriAtomExDspPitchShifterConfig jɁA
 * ftHg̒lZbg܂B
 * \sa CriAtomExDspPitchShifterConfig, criAtomExVoicePool_AttachDspPitchShifter
 */
#define criAtomExVoicePool_SetDefaultConfigForDspPitchShifter(p_config)	\
{\
	(p_config)->num_dsp = CRIATOMEX_DEFAULT_VOICES_PER_POOL;\
	(p_config)->max_channels = CRIATOM_DEFAULT_INPUT_MAX_CHANNELS;\
	(p_config)->max_sampling_rate = CRIATOM_DEFAULT_INPUT_MAX_SAMPLING_RATE;\
	(p_config)->specific.mode = 0;\
	(p_config)->specific.window_size = 1024;\
	(p_config)->specific.overlap_times = 4;\
}

/*JP
 * \brief ^CXgb`DSP̃A^b`pRtBOɃftHglZbg
 * \ingroup ATOMEXLIB_DSP
 * \param[out]	p_config	^CXgb`DSP̃A^b`pRtBOւ̃|C^
 * \par :
 * ^CXgb`DSP̃A^b`pRtBOi ::CriAtomExDspTimeStretchConfig jɁA
 * ftHg̒lZbg܂B
 * \sa CriAtomExDspTimeStretchConfig, criAtomExVoicePool_AttachDspTimeStretch
 */
#define criAtomExVoicePool_SetDefaultConfigForDspTimeStretch(p_config)	\
{\
	(p_config)->num_dsp = CRIATOMEX_DEFAULT_VOICES_PER_POOL;\
	(p_config)->max_channels = CRIATOM_DEFAULT_INPUT_MAX_CHANNELS;\
	(p_config)->max_sampling_rate = CRIATOM_DEFAULT_INPUT_MAX_SAMPLING_RATE;\
	(p_config)->specific.reserved = 0;\
}

/*==========================================================================
 *      CRI AtomEx Tween API
 *=========================================================================*/
/*JP
 * \brief gDC[쐬pRtBO\̂ɃftHglZbg
 * \ingroup ATOMEXLIB_TWEEN
 * \param[out]	p_config	RtBO\̂ւ̃|C^
 * \par :
 * ::criAtomExTween_Create ֐ɐݒ肷RtBO\́i ::CriAtomExTweenConfig jɁA
 * ftHg̒lZbg܂B<br>
 * \sa
 * CriAtomExTweenConfig
 */
#define criAtomExTween_SetDefaultConfig(p_config)	\
{\
	(p_config)->id.parameter_id = CRIATOMEX_PARAMETER_ID_VOLUME;\
	(p_config)->parameter_type = CRIATOMEX_PARAMETER_TYPE_BASIC;\
}

/*==========================================================================
 *      CRI AtomEx Sound Object API
 *=========================================================================*/
/*JP
 * \brief TEhIuWFNg쐬pRtBO\̂ɃftHglZbg
 * \ingroup ATOMEXLIB_SOUND_OBJECT
 * \param[out]	p_config	TEhIuWFNg쐬pRtBO\̂ւ̃|C^
 * \par :
 * ::criAtomExSoundObject_Create ֐ɐݒ肷RtBO\
 * i ::CriAtomExSoundObjectConfig jɁAftHg̒lZbg܂B<br>
 * \sa CriAtomExSoundObjectConfig, criAtomExSoundObject_Create
 */
#define criAtomExSoundObject_SetDefaultConfig(p_config)	\
{\
	(p_config)->enable_voice_limit_scope = CRI_FALSE;\
	(p_config)->enable_category_cue_limit_scope = CRI_FALSE;\
}

/***************************************************************************
 *      f[^^錾
 *      Data Type Declarations
 ***************************************************************************/
/*==========================================================================
 *      CRI AtomEx API
 *=========================================================================*/
/*JP
 * \brief mۊ֐
 * \ingroup ATOMEXLIB_GLOBAL
 * \par :
 * AP[^[o^Ɏgp郁mۊ֐̌^łB
 * \sa criAtomEx_SetUserAllocator
 */
typedef CriAtomMallocFunc CriAtomExMallocFunc;

/*JP
 * \brief ֐
 * \ingroup ATOMEXLIB_GLOBAL
 * \par :
 * AP[^[o^Ɏgp郁֐̌^łB
 * \sa criAtomEx_SetUserAllocator
 */
typedef CriAtomFreeFunc CriAtomExFreeFunc;

/*JP
 * \brief Xbhf
 * \ingroup ATOMEXLIB_GLOBAL
 * \par :
 * AtomCuǂ̂悤ȃXbhfœ삷邩\܂B<br>
 * Cui ::criAtomEx_Initialize ֐ j ::CriAtomExConfig 
 * \̂ɂĎw肵܂B
 * \sa criAtomEx_Initialize, CriAtomExConfig
 */
typedef enum CriAtomExThreadModelTag {
	/*JP
	 * \brief }`Xbh
	 * \par :
	 * Cu͓ŃXbh쐬A}`Xbhɂē삵܂B<br>
	 * Xbh ::criAtomEx_Initialize ֐Ăяoɍ쐬܂B<br>
	 * CũT[o[́A쐬ꂽXbhŒIɎs܂B<br>
	 */
	CRIATOMEX_THREAD_MODEL_MULTI = 0,
	
	/*JP
	 * \brief }`Xbhxo
	 * \par :
	 * Cu͓ŃXbh쐬A}`Xbhɂē삵܂B<br>
	 * Xbh ::criAtomEx_Initialize ֐Ăяoɍ쐬܂B<br>
	 * CũT[o[́A쐬ꂽXbhŒIɎs܂B<br>
	 * sāATEhVXeɘAXbhł̃_Os܂B<br>
	 * \par l:
	 * {Xbhf́Aꕔ̃vbgtH[łgpł܂B<br>
	 * {@\ɖΉ̃vbgtH[ł́ACu
	 * CRIATOMEX_THREAD_MODEL_MULTI_WITH_SONICSYNCw肳ꂽꍇłA
	 * CRIATOMEX_THREAD_MODEL_MULTIw莞Ɠl̓ƂȂ܂B<br>
	 * \attention
	 * Cȕ́ÃXbhŕUčs܂B<br>
	 * {XbhfgpꍇA
	 * ׂ̌vɂ͈ȉ2ނ̊֐𕹗pKv܂B<br>
	 * - criAtomEx_GetPerformanceInfo
	 * - criAtomExAsrRack_GetPerformanceInfo
	 */
	CRIATOMEX_THREAD_MODEL_MULTI_WITH_SONICSYNC = 4,
	
	/*JP
	 * \brief }`Xbhi[U쓮j
	 * \par :
	 * Cu͓ŃXbh쐬A}`Xbhɂē삵܂B<br>
	 * Xbh ::criAtomEx_Initialize ֐Ăяoɍ쐬܂B<br>
	 * T[o[͍̂쐬ꂽXbhŎs܂A
	 * CRIATOMEX_THREAD_MODEL_MULTI Ƃ͈قȂAIɂ͎s܂B<br>
	 * [U ::criAtomEx_ExecuteMain ֐ŖIɃT[o[쓮Kv܂B<br>
	 * i  ::criAtomEx_ExecuteMain ֐sƁAXbhNAT[o[s܂Bj<br>
	 */
	CRIATOMEX_THREAD_MODEL_MULTI_USER_DRIVEN = 3,
	
	/*JP
	 * \brief [U}`Xbh
	 * \par :
	 * Cuł̓Xbh쐬܂񂪁A[UƎɍ쐬Xbh
	 * T[o[֐Ăяo悤A̔r͍s܂B<br>
	 * T[o[ ::criAtomEx_ExecuteMain ֐œs܂B<br>
	 */
	CRIATOMEX_THREAD_MODEL_USER_MULTI = 1,
	
	/*JP
	 * \brief VOXbh
	 * \par :
	 * CuŃXbh쐬܂B܂A̔rs܂B<br>
	 * T[o[ ::criAtomEx_ExecuteMain ֐œs܂B<br>
	 * \attention
	 * ̃fIꍇAeAPIƃT[o[֐𓯈XbhĂяo悤ɂĂB<br>
	 */
	CRIATOMEX_THREAD_MODEL_SINGLE = 2,
	
	/* enum size is 4bytes */
	CRIATOMEX_THREAD_MODEL_ENUM_SIZE_IS_4BYTES = 0x7FFFFFFF
} CriAtomExThreadModel;

/*JP
 * \brief Wn
 * \ingroup ATOMEXLIB_GLOBAL
 * \par :
 * AtomCu3D|WVvZsہAǂ̍Wngp邩\܂B<br>
 * Cui ::criAtomEx_Initialize ֐ j ::CriAtomExConfig 
 * \̂ɂĎw肵܂B
 * \sa criAtomEx_Initialize, CriAtomExConfig
 */
typedef enum CriAtomExCoordinateSystemTag {
	/*JP
	 * \brief Wn
	 * \par :
	 * x̐EAy̐Az̐ƂȂ悤ȁAfJgWnłB
	 */
	CRIATOMEX_COORDINATE_SYSTEM_LEFT_HANDED = 0,
	
	/*JP
	 * \brief EWn
	 * \par :
	 * x̐EAy̐Az̐OƂȂ悤ȁAEfJgWnłB
	 */
	CRIATOMEX_COORDINATE_SYSTEM_RIGHT_HANDED = 1,
	
	/* enum size is 4bytes */
	CRIATOMEX_COORDINATE_SYSTEM_ENUM_SIZE_IS_4BYTES = 0x7FFFFFFF
} CriAtomExCoordinateSystem;

/*JP
 * \brief ACFw^Cv
 * \ingroup ATOMEXLIB_GLOBAL
 * \par :
 * AtomCȕACFo^sۂ́AACF̎w^Cv\܂B<br>
 * Cui ::criAtomEx_Initialize ֐ j ::CriAtomExConfig 
 * \̂ ::CriAtomExAcfRegistrationInfo ɂĎw肵܂B
 * \sa criAtomEx_Initialize, CriAtomExConfig, CriAtomExAcfRegistrationInfo
 */
typedef enum CriAtomExAcfLocationInfoTypeTag {
	CRIATOMEX_ACF_LOCATION_INFO_TYPE_NONE = 0,	/*JP< ݒ */
	CRIATOMEX_ACF_LOCATION_INFO_TYPE_NAME,		/*JP< t@C */
	CRIATOMEX_ACF_LOCATION_INFO_TYPE_ID,		/*JP< RecID */
	CRIATOMEX_ACF_LOCATION_INFO_TYPE_DATA,		/*JP< If[^ */
	CRIATOMEX_ACF_LOCATION_INFO_TYPE_ENUM_SIZE_IS_4BYTES = 0x7FFFFFFF
} CriAtomExAcfLocationInfoType;

/*JP
 * \brief ^iRandom Number Generatorjnh
 * \ingroup ATOMEXLIB_GLOBAL
 */
typedef void *CriAtomExRngHn;

/*JP
 * \brief ^iRandom Number GeneratorjC^[tF[X
 * \ingroup ATOMEXLIB_GLOBAL
 */
typedef struct CriAtomExRngInterfaceTag {
	/*JP
	 * \brief [N̈TCY̌vZ
	 * \return	CriSint32	[N̈TCY
	 * \par :
	 * ^쐬邽߂ɕKvȁA[N̈̃TCY擾܂B<br>
	 */
	CriSint32 (*CalculateWorkSize)(void);

	/*JP
	 * \brief ^̍쐬
	 * \param[in]	work			[N̈
	 * \param[in]	work_size		[N̈TCY
	 * \return		CriAtomExRngHn	^nh
	 * \par :
	 * ^쐬܂B<br>
	 * ^̍쐬ɎsꍇNULLԂ܂B<br>
	 */
	CriAtomExRngHn (*Create)(void* work, CriSint32 work_size);

	/*JP
	 * \brief ^̔j
	 * \param[in]	rng		^nh
	 * \par :
	 * ^j܂B<br>
	 */
	void (*Destroy)(CriAtomExRngHn rng);

	/*JP
	 * \brief ^̐
	 * \param[in]	rng			^nh
	 * \param[in]	min			ŏl
	 * \param[in]	max			ől
	 * \return		CriSint32	^
	 * \par :
	 * V^𐶐܂B<br>
	 * ꂽ^minȏmaxȉłKv܂Bimin,max͔͈͂Ɋ܂ށj
	 */
	CriSint32 (*Generate)(CriAtomExRngHn rng, CriSint32 min, CriSint32 max);

	/*JP
	 * \brief ̐ݒ
	 * \param[in]	rng			^nh
	 * \param[in]	seed		
	 * \par :
	 * [̌ƂȂ闐ݒ肵܂B<br>
	 */
	void (*SetSeed)(CriAtomExRngHn rng, CriUint32 seed);

} CriAtomExRngInterface;

/*JP
 * \brief ACFʒu
 * \ingroup ATOMEXLIB_GLOBAL
 * \par :
 * AtomCȕACFo^sۂ́AACFf[^̎włB<br>
 * Cui ::criAtomEx_Initialize ֐ j ::CriAtomExConfig 
 * \̂acf_infooɐݒ肵܂B
 * \par l
 * f[^w̃^CvɂāAݒ肷ׂ񂪈قȂ܂B<br>
 * K؂typeݒ肵Apinfo̒̑Ή\̂ɐݒsĂB<br>
 * \code
 * CriAtomExConfig config;
 * CriAtomExAcfLocationInfo acf_info;
 *
 * criAtomEx_SetDefaultConfig(&config);
 * 
 * acf_info.type = CRIATOMEX_ACF_LOCATION_INFO_TYPE_NAME;
 * acf_info.name.binder = NULL;
 * acf_info.name.path = "sounddata/project.scf";
 *
 * config.acf_info = &acf_info;
 *
 * criAtomEx_Initialize(&config);
 *
 * \endcode
 * \sa criAtomEx_Initialize, CriAtomExConfig
 */
typedef struct CriAtomExAcfRegistrationInfoTag {
	/*JP w^Cv */
	CriAtomExAcfLocationInfoType type;

	/*JP ACFʒu񋤗p */
	union CriAtomExAcfLocationInfoTag {
		/*JP t@Cw莞 */
		struct CriAtomExAcfLocationInfoNameTag {
			CriFsBinderHn binder;	/*JP< oC_[nh */
			const CriChar8 *path;	/*JP< ACFt@CpX */
		} name;
		/*JP t@CIDw莞 */
		struct CriAtomExAcfLocationInfoIdTag {
			CriFsBinderHn binder;	/*JP< oC_[nh */
			CriSint32 id;			/*JP< RecID */
		} id;
		/*JP If[^w莞 */
		struct CriAtomExAcfLocationInfoDataTag {
			void *buffer;			/*JP< AhX */
			CriSint32 size;			/*JP< TCY */
		} data;
	} info;	
} CriAtomExAcfRegistrationInfo;

/*JP
 * \brief AtomCupRtBO\
 * \ingroup ATOMEXLIB_GLOBAL
 * CRI AtomCu̓dlw肷邽߂̍\̂łB<br>
 * ::criAtomEx_Initialize ֐̈Ɏw肵܂B<br>
 * <br>
 * CRI AtomCúAɖ{\̂Ŏw肳ꂽݒɉāA\[X
 * KvȂmۂ܂B<br>
 * CuKvƂ郏[N̈̃TCÝA{\̂Ŏw肳ꂽp[^[ɉ
 * ω܂B
 * \par l:
 * ftHgݒgpꍇA ::criAtomEx_SetDefaultConfig }Nō\̂ɃftHg
 * p[^[ZbgA ::criAtomEx_Initialize ֐ɍ\̂w肵ĂB<br>
 * \attention
 * IɃo\邽߁A ::criAtomEx_SetDefaultConfig }NgpȂ
 * ꍇɂ́AgpOɕK\̂[NAĂB<br>
 * i\̂̃oɕslȂ悤ӂBj
 * \sa criAtomEx_Initialize, criAtomEx_SetDefaultConfig
 */
typedef struct CriAtomExConfigTag {
	/*JP
		\brief Xbhf
		\par :
		CRI AtomCũXbhfw肵܂B<br>
		\sa CriAtomExThreadModel
	*/
	CriAtomExThreadModel thread_model;
	
	/*JP
		\brief T[o[̎spx
		\par :
		T[o[spxw肵܂B<br>
		ʏAAvP[Ṽt[[gƓlw肵܂B<br>
		<br>
		CRI AtomCúAt@Cǂݍ݂̊ǗAf[^̃fR[hȀóA
		Xe[^X̍XVACuōŝقƂǂ1̊֐ł܂Ƃ߂
		s܂B<br>
		CRI~hEFAł́ACȕꊇčs֐̂Ƃ
		"T[o["ƌĂł܂B<br>
		<br>
		Xbhf ::CRIATOMEX_THREAD_MODEL_MULTI ̏ꍇAT[o[
		CRI AtomCu쐬XbhŁAIɎs܂B<br>
		Xbhf ::CRIATOMEX_THREAD_MODEL_SINGLE  ::CRIATOMEX_THREAD_MODEL_USER_MULTI 
		̏ꍇAT[o[ ::criAtomEx_ExecuteMain ֐Ŏs܂B<br>
		<br>
		server_frequency ɂ́AT[o[spxw肵܂B<br>
		Xbhf ::CRIATOMEX_THREAD_MODEL_MULTI ̏ꍇACRI AtomCu͎w肳ꂽ
		pxŃT[o[s悤AT[o[̌ĂяoԊu𒲐߂܂B<br>
		Xbhf ::CRIATOMEX_THREAD_MODEL_SINGLE  ::CRIATOMEX_THREAD_MODEL_USER_MULTI 
		̏ꍇA[U ::criAtomEx_ExecuteMain ֐ server_frequency Ŏw肵pxȏ
		ŎsKv܂B<br>
		<br>
		AvP[Ṽt[[g̕ϓ傫AT[o[spxɃocL
		łĂ܂ꍇɂ́Aň̃t[[gz肵 server_frequency ̒lw
		邩A܂̓Xbhf ::CRIATOMEX_THREAD_MODEL_MULTI w肵ĂB
		\par l:
		AtomCũT[o[ł́Aȉ̂悤ȏs܂B<br>
		- NGXg̏i{CX̎擾j
		- p[^[̍XVi{[pAsb`̕ύX̓Kpj
		- f[^̃fR[hƏo
		
		T[o[̎spx𑽂ƁAPʃT[o[̉f[^fR[hʂȂȂ܂B<br>
		̌ʁAPʃT[o[ׂ̏͏Ȃ܂iׂU܂jA
		T[o[̎sɔI[o[wbh͑傫Ȃ܂B<br>
		iXbh̋N񐔂p[^[̍XV񐔂Ȃ܂Bj<br>
		<br>
		T[o[̎spxȂƁAXbh̋N┭NGXg̏A
		p[^[̍XV̉񐔂AAvP[VŜׂ͉̏܂B<br>
		ʁAf[^[hpx邽߁APʃT[o[fR[hʂ͑A
		fR[hʂێ邽߂̃obt@[TCY]ɕKvɂȂ܂B<br>
		܂ANGXgpx邽߁A
		NGXg特o͊Jn܂łɂ鎞Ԃ͒Ȃ܂B<br>
		\attention
		Xbhf ::CRIATOMEX_THREAD_MODEL_SINGLE  ::CRIATOMEX_THREAD_MODEL_USER_MULTI 
		w肵ɂ炸A ::criAtomEx_ExecuteMain ֐ server_frequency 
		w肵lȉ̕pxłsȂꍇAĐ̉r؂铙̖肪
		\܂̂ŁAӂB<br>
		\sa criAtomEx_ExecuteMain
	*/
	CriFloat32 server_frequency;
	
	/*JP
		\brief p[^[XVԊu
		\par :
		T[o[sɃp[^[̍XVsԊuw肵܂B<br>
		parameter_update_interval ̒lύX邱ƂŁA
		T[o[̎s񐔂ς邱ƂȂp[^[XVpx邱Ƃ\łB<br>
		<br>
		Ⴆ΁A parameter_update_interval  2 ɐݒ肷ƁA
		T[o[ 2 ɑ΂A 1 񂾂p[^[̕ύXs܂B<br>
		ip[^[̍XVpx 1/2 ɂȂ܂Bj<br>
		\par l:
		T[o[gi server_frequency jƁA
		T[o[̎s񐔂邽߁AAvP[VŜׂ͉̏܂A
		T[o[m̊ԊuJ߁Aobt@Oׂf[^̗ʂ܂B<br>
		̌ʁAobt@Ô߂ɕKvȃ̃TCY͑܂B<br>
		<br>
		ɑ΂AT[o[gύXɃp[^[XVԊui parameter_update_interval j
		̒lグꍇATCY𑝉ɕׂ邱Ƃ\ƂȂ܂B<br>
		AT[o[̋쓮ɔ̃I[o[wbhiXbh̋Nדj
		͍팸Ȃ߁AT[o[̉񐔂炷ꍇɔׁA׍팸̌ʂ͔łB<br>
		\par :
		parameter_update_interval ̒lύXꍇA
		NGXg̏pxȂȂ܂B<br>
		̂߁A parameter_update_interval ̒lύXƁA
		NGXg特o͊Jn܂łɂ鎞ԂȂ܂B<br>
	*/
	CriSint32 parameter_update_interval;
	
	/*JP
		\brief CRI Atom LibraryȊOgo͂sƂw肷tO
		\par :
		CRI Atom Librarygpɉo͂ۂCRI_TRUEw肵܂B<br>
		::criAtomEx_SetDefaultConfig }Nł́ACRI Atom Libraryw肷邽߁ACRI_FALSEw肳܂B<br>
		CRI Atom LibraryȊỎo̓Cupꍇ́A{tOCRI_TRUEw肵ĂAcriAtomEx_Initialize
		s悤ɂĂB
		\attention
		{tO؂ւۂɂ́AAtomCucriAtomEx_FinalizeŏIĂAtO̓eύXAēx
		criAtomEx_Initializeɂďs悤ɂĂB<br>
	*/
	CriBool enable_atom_sound_disabled_mode;
	
	/*JP
		\brief őo[`{CX
		\par :
		AvP[Vœɔs{CX̐łB<br>
		AtomCúA max_virtual_voices Ŏw肳ꂽ
		ǗɕKvȃ\[Xmۂ܂B<br>
		\par l:
		max_virtual_voices Ŏw肳ꂽȏ̉𓯎ɔ邱Ƃ͂ł܂B<br>
		܂A max_virtual_voices ̔NGXgsƂĂAۂ
		鉹̐́AK max_virtual_voices ɈvƂ͌܂B<br>
		ۂɔ\ȉ̐́A{CXv[Ŋmۂꂽ{CXA
		^[Qbg@ŗp\ȃn[hEFA{CX̐Ɉˑ܂B<br>
		<br>
		o[`{CX̖ڈ́Auő哯{1V̔NGXgvłB<br>
		o[`{CXő哯菭ȂꍇA
		ƃNGXg̍vőo[`{CX𒴂ꍇA
		G[R[obN֐ɌxԂ\܂B<br>
		<br>
		CRIATOMEX_RETRY_VOICE_ALLOCATION w肵 AtomEx v[[쐬ꍇA
		Lɑ̃o[`{CXKvƂ\܂B<br>
	*/
	CriSint32 max_virtual_voices;
	
	/*JP
		\brief őp[^[ubN
		\par :
		ĐɃp[^[Ǘs߂̗̈̐łB<br>
		AtomCúA max_parameter_blocks Ŏw肳ꂽ
		p[^[ǗɕKvȃ\[Xmۂ܂B<br>
		\par l:
		1̃L[Đ̂ɕKvȃp[^[ubŃA
		ĐL[̓eɂĕω܂B<br>
		i삷p[^[̐ɔႵĕKvȃp[^[ubN͑܂Bj<br>
		<br>
		p[^[ubNsꍇAĐL[ɑ΂
		ꕔ̃p[^[ݒ肳ȂƂɂȂ܂B<br>
		i{[sb`AtB^[Ӑ}lɂȂȂ\܂Bj<br>
		AvP[VsɃp[^[ubNs̃G[ꍇA
		max_parameter_blocks ̒l𑝂₵ĂB<br>
	*/
	CriSint32 max_parameter_blocks;
	
	/*JP
		\brief ő{CX~bgO[v
		\par :
		AvP[Vō쐬{CX~bgO[v̐łB<br>
		AtomCúA max_voice_limit_groups Ŏw肳ꂽ
		̃{CX~bgO[v쐬ł郊\[Xmۂ܂B<br>
		\attention
		max_voice_limit_groups Ŏw肳ꂽȏ̃{CX~bgO[v
		쐬邱Ƃ͂ł܂B<br>
		I[TOc[ō쐬{CX~bgO[v̐ 
		max_voice_limit_groups 𒴂ꍇAACFt@C̃[hɎs܂B<br>
	*/
	CriSint32 max_voice_limit_groups;

	/*JP
		\brief őJeS
		\par :
		AvP[Vō쐬JeS̐łB<br>
		AtomCúA max_categories Ŏw肳ꂽ
		̃JeS쐬ł郊\[Xmۂ܂B<br>
		\attention
		max_categories Ŏw肳ꂽȏ̃JeS쐬邱Ƃ͂ł܂B<br>
		I[TOc[ō쐬JeS̐ 
		max_categories 𒴂ꍇAACFt@C̃[hɎs܂B<br>
	*/
	CriSint32 max_categories;

	/*JP
		\brief őAISAC
		\par :
		̃L[ɕRÂ邱ƂłAISAC̍ő吔łB<br>
		AtomCúA AtomExPlayer 쐬
		max_aisacs Ŏw肳ꂽAISACQƂł郊\[Xmۂ܂B<br>
		max_aisacs Ɏw肷l̏55łB<br>
		L[AgbNAJeS AISAC ΏۂƂȂ܂B
		~LT[ AISAC ͖{ݒl̑Ώۂł͂܂B
	*/
	CriUint8 max_aisacs;

	/*JP
		\brief őoXZh
		\par :
		̃{CXɃZh邱ƂłoX̍ő吔łB<br>
		max_bus_sends Ɏw肷l̏32łB
	*/
	CriUint8 max_bus_sends;

	/*JP
		\brief ĐPʂł̃JeSQƐ
		\par :
		ĐPʂŎQƉ\ȃJeS̐łB<br>
		AtomCúA categories_per_playback Ŏw肳ꂽ
		̃JeSQƂł郊\[Xmۂ܂B<br>
		w\ȍől ::CRIATOMEXCATEGORY_MAX_CATEGORIES_PER_PLAYBACK łB
		\attention
		categories_per_playback Ŏw肳ꂽȏ̃JeSL[v[[QƂ邱Ƃ͂ł܂B<br>
		I[TOc[ō쐬L[̎QƃJeS 
		categories_per_playback 𒴂ꍇAACFt@C̃[hɎs܂B<br>
	*/
	CriSint32 categories_per_playback;

	/*JP
		\brief őĐV[PX
		\par :
		AvP[VœɍĐV[PX̐łB<br>
		AtomCúA max_sequences Ŏw肳ꂽ max_virtual_voices Ŏw肳ꂽ̑a
		̃V[PXĐł郊\[Xmۂ܂B<br>
		\attention
		Ver.2.00ȍ~̃Cuł͑SẴL[V[PXƂčĐ邽߁A max_sequences ɉ
		 max_virtual_voices ̃\[Xmۂ܂B<br>
		max_sequences Ŏw肳ꂽȏ̃V[PXĐ邱Ƃ͂ł܂B<br>
		G[R[obNꍇA̒l傫ĂB<br>
	*/
	CriSint32 max_sequences;

	/*JP
		\brief őĐgbN
		\par :
		AvP[VœĐV[PX̃gbNłB<br>
		AtomCúA max_tracks Ŏw肳ꂽ max_virtual_voices Ŏw肳ꂽ̑a
		̃gbNĐł郊\[Xmۂ܂B<br>
		\attention
		Ver.2.00ȍ~̃Cuł͑SẴL[V[PXƂčĐ邽߁A max_tracks ɉ
		 max_virtual_voices ̃\[Xmۂ܂B<br>
		max_tracks Ŏw肳ꂽȏ̃gbNĐ邱Ƃ͂ł܂B<br>
		G[R[obNꍇA̒l傫ĂB<br>
	*/
	CriUint32 max_tracks;

	/*JP
		\brief őgbNACe
		\par :
		AvP[VœĐV[PX̃Cxg̑łB<br>
		AtomCúA max_track_items Ŏw肳ꂽ max_virtual_voices Ŏw肳ꂽ̑a
		̃gbNACe쐬ł郊\[Xmۂ܂B<br>
		\attention
		Ver.2.00ȍ~̃Cuł͑SẴL[V[PXƂčĐ邽߁A max_track_items ɉ
		 max_virtual_voices ̃\[Xmۂ܂B<br>
		max_track_items Ŏw肳ꂽȏ̃gbNACe
		쐬邱Ƃ͂ł܂B<br>
		gbNACe͔g`A[vCxg̃V[PXgbNĐ
		ǗKvȃCxgłB<br>
		G[R[obNꍇA̒l傫ĂB<br>
	*/
	CriUint32 max_track_items;
	
	/*JP
		\brief őAISACI[gW[Vigp~j
		\par :
		Ver.2.00.00ȍ~̃Cuł͎gp~ƂȂ܂B
		Cuł̖{oւ̎QƂ͍s܂B<br>
	*/
	CriUint32 max_aisac_auto_modulations;

	/*JP
		\brief sb`ύX̏l
		\par :
		AtomCuœKpsb`ύX̏lݒ肵܂B<br>
		max_pitchɐݒ肳ꂽlȏ̃sb`ύXACuŃNbv܂B<br>
		<br>
		sb`̓ZgPʂŎw肵܂B<br>
		1Zg1IN^[u1/1200łB100ZgłB<br>
		<br>
		Ⴆ΁A max_pitch  1200.0f ݒ肵ꍇA
		1200Zg𒴂sb`ݒ肳ꂽL[ĐƂĂA
		sb`1200Zgɗ}čĐ܂B<br>
		\par l:
		L[ɐݒ肳ꂽsb`ɁAAISACɂsb`ύXhbv[ʂǉKpꂽꍇA
		\ʃx܂Ńsb`オ鋰ꂪ܂B<br>
		isb`ɔႵĒPʎԓ̃fR[hʂ邽߁A
		sb`鉹ʂɖ炵ꍇAׂ}鋰ꂪ܂Bj<br>
		<br>
		{p[^[ł炩߃sb`ݒ肵ĂƂŁA
		zO̕וϓ邱Ƃ\ƂȂ܂B<br>
		Ⴆ΁A max_pitch  1200.0f ݒ肵ꍇA
		AvP[Vłǂ̂悤ȑsƂĂsb`1200Zg
		i2{Đj܂łɗ}邽߁A
		PʎԂ̃fR[hʂ͍őłʏ펞2{܂łɐ܂B<br>
		\par :
		max_pitchɂ 0.0f ȏ̒lݒ肷Kv܂B<br>
		i 0.0f w肵ꍇAsb`̕ύX͈؍sȂȂ܂Bj<br>
	*/
	CriFloat32 max_pitch;

	/*JP
		\brief őtF[_[
		\par :
		AtomCuŎgptF[_[̏lݒ肵܂B<br>
		Őݒ肵AɊmۂtF[_[TrackTransitionBySelectorf[^ĐɃCuŎgp܂B<br>
	*/
	CriUint32 max_faders;

	/*JP
		\brief 3D|WVvZsۂ̍Wn
		\par :
		AtomCu3D|WVvZsہAǂ̍Wngp邩ݒ肵܂B
	*/
	CriAtomExCoordinateSystem coordinate_system;

	/*JP
		\brief p^CvI[g̏ꍇɂAXi[̃I[g}b`O@\̗L
		\par :
		p^CvI[g̏ꍇAXi[̃I[g}b`O@\L邩ݒ肵܂B
		\par lF
		p^Cv3D|WVjȌꍇ̓Xi[̃I[g}b`O@\͏ɗLłB
	*/
	CriBool enable_auto_matching_in_pan_type_auto;

	/*JP
		\brief AtomExPlayerɂJeS̏㏑̗L
		\par :
		AtomExPlayer::criAtomExPlayer_SetCategoryById֐::criAtomExPlayer_SetCategoryByName֐
		păJeSZbgꍇɃL[̃JeSݒ㏑@\L܂B
		\par lF
		CRI Atom Ver.2.20.31̃CúAv[[ɑ΂ăJeSݒsƁA
		L[ɐݒ肳ĂJeS㏑ɂ薳ɂȂĂ܂B
		Ver.2.20.31̋ɖ߂Kvꍇɂ͖{tOCRI_FALSEݒ肵ĂB
	*/
	CriBool enable_category_override_by_ex_player;

	/*JP
		\brief V[PXǂ݊̎w
		\par :
		V[PT[1T[o[œǂݍޗʂ̊w肵܂B
		1.5fw肷Ǝ̃T[o[s\z炳0.5T[o[ǂ݂܂B
		ő3.0fAŏ1.1fw\łB͈͂𒴂ꍇ̓Nbv܂B
		\par l:
		T[o[̗hɂĔ锭^C~ÔꂪÂ炭Ȃ܂B
	*/
	CriFloat32 sequence_prepare_ratio;

	/*JP
	 * \brief ^C^[tF[X
	 * \par :
	 * CRI AtomCuŎgp^C^[tF[Xw肵܂B<br>
	 * NULLw肵ꍇ́AftHg̋^gp܂B<br>
	 */
	const CriAtomExRngInterface *rng_if;

	/*JP
		\brief CRI File System ̏p[^[ւ̃|C^
		\par :
		CRI File System̏p[^[ւ̃|C^w肵܂B
		NULLw肵ꍇAftHgp[^[CRI File System܂B
		\sa criAtomEx_Initialize
	*/
	const CriFsConfig *fs_config;

	/*JP
		\brief ACFւ̃|C^
		\par :
		ACF̓o^sۂACFւ̃|C^w肵܂B
		NULLw肵ꍇAACF̓o^͍s܂B
		{oݒ肵ďACF̓o^sꍇA ::CriAtomExConfig \̂
		max_voice_limit_groups, max_categories, categories_per_playback̊eol
		ACFݒlƔrđ傫̒lpݒlƂĎgp܂B
		CriAtomExACF̓o^sꍇAɂĂ CriAtomExAsr, CriAtomExHcaMx
		̃W[ɂꕔACF̐ݒlgp܂B<br>
		ACF̐ݒlgpɂ̃W[ꍇ́A{ogp
		CȕsǍACF̓o^sĂB<br>
		\attention
		{oݒ肷ꍇAłACFf[^̓o^ACFf[^ɏ
		Kvȃ[N𓮓IɊmۂ邽߁A֐ĂяoOɃAP[^[֐̓o^
		G[R[obN֐̓o^KvɂȂ܂B<br>
		{ogpꍇA[N̈̊mۂ͓o^ꂽAP[^[֐gpčs܂B
		擾ς݃̈gpĂ͍̏s܂B<br>
		\sa criAtomEx_Initialize, criAtomEx_SetUserAllocator
	*/
	const CriAtomExAcfRegistrationInfo *acf_info;

	/*JP
		\brief vbgtH[ŗL̏p[^[ւ̃|C^
		\par :
		CRI AtomCu𓮍삳邽߂ɕKvȁA
		vbgtH[ŗL̏p[^[ւ̃|C^w肵܂B
		NULLw肵ꍇAftHgp[^[ŃvbgtH[ɕKvȏs܂B<br>
		p[^[\̂͊evbgtH[ŗLwb_[ɒ`Ă܂B
		p[^[\̂`ĂȂvbgtH[ł́ANULLw肵ĂB
		\sa criAtomEx_Initialize
	*/
	void *context;

	/*JP
		\brief Cuo[Wԍ
		\par :
		CRI Atom Cũo[WԍłB<br>
		::criAtomEx_SetDefaultConfig }NɂA cri_atom.h wb_[ɒ`Ăo[Wԍݒ肳܂B<br>
		\attention
		AvP[Vł́A̒lύXȂłB<br>
	 */
	CriUint32 version;

	/*JP
		\brief W[o[Wԍ
		\par :
		CRI Atom Ex ̃o[WԍłB<br>
		::criAtomEx_SetDefaultConfig }NɂA{wb_[ɒ`Ăo[Wԍݒ肳܂B<br>
		\attention
		AvP[Vł́A̒lύXȂłB<br>
	 */
	CriUint32 version_ex;

	/*JP
		\brief Cuo[W
		\par :
		CRI Atom Cũo[WłB<br>
		::criAtomEx_SetDefaultConfig }NɂA cri_atom.h wb_[ɒ`Ăo[W񂪐ݒ肳܂B<br>
		\attention
		AvP[Vł́A̒lύXȂłB<br>
	 */
	const CriChar8 *version_string;

	/*JP
		\brief W[o[W
		\par :
		CRI Atom Ex ̃o[WłB<br>
		::criAtomEx_SetDefaultConfig }NɂA{wb_[ɒ`Ăo[W񂪐ݒ肳܂B<br>
		\attention
		AvP[Vł́A̒lύXȂłB<br>
	 */
	const CriChar8 *version_ex_string;
} CriAtomExConfig;

/*JP
 * \brief ptH[}X
 * \ingroup ATOMEXLIB_GLOBAL
 * \par :
 * ptH[}X擾邽߂̍\̂łB<br>
 * ::criAtomEx_GetPerformanceInfo ֐ŗp܂B
 * \sa criAtomEx_GetPerformanceInfo
 */
typedef CriAtomPerformanceInfo CriAtomExPerformanceInfo;

/*JP
 * \brief g`f[^ID
 * \ingroup ATOMEXLIB_GLOBAL
 * \par :
 * g`f[^ID́A[UI[TOc[AWBRecɑ΂Ċ蓖ĂӂIDłB<br>
 * g`f[^IDvOŕێۂɂ́A{ϐ^pĒl舵Kv܂B<br>
 * \sa criAtomExPlayer_SetWaveId
 */
typedef CriSint32 CriAtomExWaveId;

/*JP
 * \brief UID
 * \ingroup ATOMEXLIB_GLOBAL
 * \par :
 * UIDvOŕێۂɂ́A{ϐ^pĒl舵Kv܂B<br>
 */
typedef CriSint32 CriAtomExVibrationId;

/*JP
 * \brief tH[}bg
 * \ingroup ATOMEXLIB_GLOBAL
 * \par :
 * AtomExv[[ōĐ鉹̃tH[}bgw肷邽߂̃f[^^łB<br>
 * ::criAtomExPlayer_SetFormat ֐ŗp܂B<br>
 * \sa criAtomExPlayer_SetFormat
 */
typedef CriAtomFormat CriAtomExFormat;
#define CRIATOMEX_FORMAT_NONE			(CRIATOM_FORMAT_NONE)			/*JP< Ȃ					*/
#define CRIATOMEX_FORMAT_ADX			(CRIATOM_FORMAT_ADX)			/*JP< ADX					*/
#define CRIATOMEX_FORMAT_HCA			(CRIATOM_FORMAT_HCA)			/*JP< HCA					*/
#define CRIATOMEX_FORMAT_HCA_MX			(CRIATOM_FORMAT_HCA_MX)			/*JP< HCA-MX				*/
#define CRIATOMEX_FORMAT_WAVE			(CRIATOM_FORMAT_WAVE)			/*JP< Wave					*/
#define CRIATOMEX_FORMAT_AIFF			(CRIATOM_FORMAT_AIFF)			/*JP< AIFF					*/
#define CRIATOMEX_FORMAT_RAW_PCM		(CRIATOM_FORMAT_RAW_PCM)		/*JP< RawPCM				*/
#define CRIATOMEX_FORMAT_VIBRATION		(CRIATOM_FORMAT_VIBRATION)		/*JP< U					*/
#define CRIATOMEX_FORMAT_AUDIO_BUFFER	(CRIATOM_FORMAT_AUDIO_BUFFER)	/*JP< I[fBIobt@[	*/
#define CRIATOMEX_FORMAT_INPUT_PORT		(CRIATOM_FORMAT_INPUT_PORT)		/*JP< ̓|[g			*/
#define CRIATOMEX_FORMAT_HW1			(CRIATOM_FORMAT_HW1)			/*JP< n[hEFAŗL1		*/
#define CRIATOMEX_FORMAT_HW2			(CRIATOM_FORMAT_HW2)			/*JP< n[hEFAŗL2		*/
#define CRIATOMEX_FORMAT_HW3			(CRIATOM_FORMAT_HW3)			/*JP< n[hEFAŗL2		*/

/*JP
 * \brief f[^tH[}bg
 * \ingroup ATOMEXLIB_GLOBAL
 * \par :
 * f[^̃tH[}bgłB<br>
 * \par l:
 * ɔzuꂽf[^ɂẮA ::criAtomEx_AnalyzeAudioHeader 
 * ֐s邱Ƃŉf[^̃tH[}bg擾\łB<br>
 * Đ̉f[^̃tH[}bgɂĂ
 * ::criAtomExPlayback_GetFormatInfo ֐Ŏ擾\łB<br>
 * \sa criAtomEx_AnalyzeAudioHeader, criAtomExPlayback_GetFormatInfo
 */
typedef struct CriAtomExFormatInfoTag {
	CriAtomExFormat format;				/*JP< tH[}bg		*/
	CriSint32 sampling_rate;			/*JP< TvOg	*/
	CriSint64 num_samples;				/*JP< Tv			*/
	CriSint64 loop_offset;				/*JP< [vJnTv	*/
	CriSint64 loop_length;				/*JP< [vԃTv	*/
	CriSint32 num_channels;				/*JP< `l			*/
	CriUint32 reserved[1];				/*JP< \̈				*/
} CriAtomExFormatInfo;

/*JP
 * \brief |[YΏ
 * \ingroup ATOMEXLIB_GLOBAL
 * \par :
 * |[YΏۂw肷邽߂̃f[^^łB<br>
 * ::criAtomExPlayer_Resume ֐A ::criAtomExPlayback_Resume
 * ֐̈ƂĎgp܂B
 * \sa criAtomExPlayer_Resume, criAtomExPlayback_Resume
 */
typedef enum CriAtomExResumeModeTag {
	CRIATOMEX_RESUME_ALL_PLAYBACK = 0,			/*JP< ꎞ~@Ɋ֌WȂĐĊJ					*/
	CRIATOMEX_RESUME_PAUSED_PLAYBACK = 1,		/*JP< Pause ֐Ń|[ŶݍĐĊJ		*/
	CRIATOMEX_RESUME_PREPARED_PLAYBACK = 2,		/*JP< Prepare ֐ōĐw̍ĐJn	*/
	CRIATOMEX_RESUME_MODE_RESERVED = 3,
	CRIATOMEX_RESUME_MODE_ENUM_SIZE_IS_4BYTES = 0x7FFFFFFF
} CriAtomExResumeMode;

/*JP
 * \brief oCNAbhtB^[̃^Cv
 * \ingroup ATOMEXLIB_GLOBAL
 * \par :
 * oCNAbhtB^[̃^Cvw肷邽߂̃f[^^łB<br>
 * ::criAtomExPlayer_SetBiquadFilterParameters ֐ŗp܂B
 * \sa criAtomExPlayer_SetBiquadFilterParameters
 */
typedef enum CriAtomExBiquadFilterTypeTag {
	CRIATOMEX_BIQUAD_FILTER_TYPE_OFF = 0,			/*JP<tB^[			*/
	CRIATOMEX_BIQUAD_FILTER_TYPE_LOWPASS = 1,		/*JP<[pXtB^[		*/
	CRIATOMEX_BIQUAD_FILTER_TYPE_HIGHPASS = 2,		/*JP<nCpXtB^[		*/
	CRIATOMEX_BIQUAD_FILTER_TYPE_NOTCH = 3,			/*JP<mb`tB^[			*/
	CRIATOMEX_BIQUAD_FILTER_TYPE_LOWSHELF = 4,		/*JP<[VFttB^[	*/
	CRIATOMEX_BIQUAD_FILTER_TYPE_HIGHSHELF = 5,		/*JP<nCVFttB^[	*/
	CRIATOMEX_BIQUAD_FILTER_TYPE_PEAKING = 6,		/*JP<s[LOttB^[	*/

	/* enum size is 4bytes */
	CRIATOMEX_BIQUAD_FILTER_TYPE_ENUM_SIZE_IS_4BYTES = 0x7FFFFFFF
} CriAtomExBiquadFilterType;

/*JP
 * \brief [h
 * \ingroup ATOMEXLIB_GLOBAL
 * \par :
 * [hw肷邽߂̃f[^^łB<br>
 * ::criAtomExPlayer_SetSilentMode ֐ŗp܂B<br>
 * ƂȂǂ́Aȉ̂ꂩ̒l0ɂȂǂŔf܂B<br>
 * 	- {[
 * 	- 3DpjỎZʂɂ{[
 * 	- 3D|WVjỎZʂɂ{[
 * 	
 * \attention
 * Zhx2Dp̐ݒlł͖ƔfȂ_ɂӂB<br>
 * \sa criAtomExPlayer_SetSilentMode
 */
typedef enum CriAtomExSilentModeTag {
	/*JP
	 * \brief Ȃ
	 * \par :
	 * ƂȂĂʂȏ͍s܂BiftHglj
	 */
	CRIATOMEX_SILENT_MODE_NORMAL = 0,

	/*JP
	 * \brief ~
	 * \par :
	 * ƂȂۂ͎Iɒ~܂B
	 */
	CRIATOMEX_SILENT_MODE_STOP = 1,

	/*JP
	 * \brief o[`
	 * \par :
	 * ƂȂۂ͎IɃo[`܂B
	 */
	CRIATOMEX_SILENT_MODE_VIRTUAL = 2,

	/*JP
	 * \brief Ĕ^Ńo[`
	 * \par :
	 * ƂȂۂ͎IɍĔ^Ńo[`܂B
	 */
	CRIATOMEX_SILENT_MODE_VIRTUAL_RETRIGGER = 3,

	/*JP
	 * \brief ꎞ~A^Ńo[`
	 * \par :
	 * ƂȂۂ͎IɈꎞ~A^Ńo[`܂B
	 * Aۂ̓o[`ʒuĐ܂B
	 */
	CRIATOMEX_SILENT_MODE_VIRTUAL_RESUME = 4,

	/* enum size is 4bytes */
	CRIATOMEX_SILENT_MODE_ENUM_SIZE_IS_4BYTES = 0x7FFFFFFF
} CriAtomExSilentMode;

/*JP
 * \brief p^Cv
 * \ingroup ATOMEXLIB_GLOBAL
 * \par :
 * ǂ̂悤ɂĒʌvZsw肷邽߂̃f[^^łB<br>
 * ::criAtomExPlayer_SetPanType ֐ŗp܂B<br>
 * \sa criAtomExPlayer_SetPanType
 */
typedef enum CriAtomExPanTypeTag {
	/*JP
	 * \brief s
	 * \par :
	 * p^CvĂȂԂłB
	 * ::criAtomExAcb_GetCueInfoByName ֐ȂǂɂāA ACB Ver.1.35.00 
	 * ACB f[^̃L[̏i ::CriAtomExCueInfo j擾ꍇɓ܂B
	 * \attention
	 * ::criAtomExPlayer_SetPanType ֐ɂĎw肷ƁAG[܂B
	 */
	CRIATOMEX_PAN_TYPE_UNKNOWN = -1,
	/*JP
	 * \brief p3D
	 * \par :
	 * p3DŒʂvZ܂B
	 */
	CRIATOMEX_PAN_TYPE_PAN3D = 0,
	/*JP
	 * \brief 3D|WVjO
	 * \par :
	 * 3D|WVjOŒʂvZ܂B
	 */
	CRIATOMEX_PAN_TYPE_3D_POS,
	/*JP
	 * \brief 
	 * \par :
	 * AtomExv[[3D^3DXi[ݒ肳Ăꍇ3D|WVjOŁA
	 * ݒ肳ĂȂꍇ̓p3DŁAꂼʂvZ܂B
	 */
	CRIATOMEX_PAN_TYPE_AUTO,
	/* enum size is 4bytes */
	CRIATOMEX_PAN_TYPE_ENUM_SIZE_IS_4BYTES = 0x7FFFFFFF
} CriAtomExPanType;

/*JP
 * \brief pjȌo̓Xs[J[^Cv
 * \ingroup ATOMEXLIB_GLOBAL
 * \par :
 * ʌvZsہAo͂ƂĂǂ̃Xs[J[gp邩\܂B<br>
 * ::criAtomExPlayer_ChangeDefaultPanSpeakerType ֐A::criAtomExPlayer_SetPanSpeakerType ֐ŗp܂B<br>
 * \par l:
 * XeIXs[J[̃vbgtH[ł́AǂI񂾂ƂĂŏIIɂ̓XeIɃ_E~bNX܂B
 * \sa criAtomExPlayer_SetPanSpeakerType
 */
typedef enum CriAtomExPanSpeakerTypeTag {
	/*JP
	 * \brief 4chpjO
	 * \par :
	 * L, R, Ls, RsgpăpjOs܂B<br>
	 * 
	 */
	CRIATOMEX_PAN_SPEAKER_TYPE_4CH = 0,

	/*JP
	 * \brief 5chpjO
	 * \par :
	 * L, R, C, Ls, RsgpăpjOs܂B
	 */
	CRIATOMEX_PAN_SPEAKER_TYPE_5CH = 1,

	/*JP
	 * \brief 6chpjO
	 * \par :
	 * L, R, Ls, Rs, Lsb, RsbgpăpjOs܂B
	 */
	CRIATOMEX_PAN_SPEAKER_TYPE_6CH = 2,

	/*JP
	 * \brief 7chpjO
	 * \par :
	 * L, R, C, Ls, Rs, Lsb, RsbgpăpjOs܂B
	 */
	CRIATOMEX_PAN_SPEAKER_TYPE_7CH = 3,

    /*JP
     * \brief 5.0.2chpjO
     * \par :
     * L, R, C, Ls, Rs, Lts, RtsgpăpjOs܂B
     */
    CRIATOMEX_PAN_SPEAKER_TYPE_5_0_2CH = 4,

	/*JP
	 * \brief 7.0.4chpjO
	 * \par :
	 * L, R, C, Ls, Rs, Lsb, RsbALtfARtfALtbARtbgpăpjOs܂B
	 */
	CRIATOMEX_PAN_SPEAKER_TYPE_7_0_4CH = 5,

    /*JP
     * \brief 4.0.2chpjO
     * \par :
     * L, R, Ls, Rs, Lts, RtsgpăpjOs܂B
     */
    CRIATOMEX_PAN_SPEAKER_TYPE_4_0_2CH = 6,

    /*JP
	 * \brief 6.0.4chpjO
	 * \par :
	 * L, R, Ls, Rs, Lsb, RsbALtfARtfALtbARtbgpăpjOs܂B
     */
    CRIATOMEX_PAN_SPEAKER_TYPE_6_0_4CH = 7,

	/*JP
	 * \brief 7.0.4.4chpjO
	 * \par :
	 * L, R, C, Ls, Rs, Lsb, RsbALtfARtfALtbARtbALbfARbfALbbARbbgpăpjOs܂B
	 */
	CRIATOMEX_PAN_SPEAKER_TYPE_7_0_4_4CH = 8,

	/*JP
	 * \brief 6.0.4.4chpjO
	 * \par :
	 * L, R, Ls, Rs, Lsb, RsbALtfARtfALtbARtbALbfARbfALbbARbbgpăpjOs܂B
	 */
	CRIATOMEX_PAN_SPEAKER_TYPE_6_0_4_4CH = 9,

	/*JP
	 * \brief pjOݒ
	 * \par :
	 * o͐̃`lɉčő̃`l\gpăpjOs܂BZ^[Xs[J[͊܂܂܂BftHg̃pXs[J[^CvłB
	 */
	CRIATOMEX_PAN_SPEAKER_TYPE_AUTO = 10,

	/*JP
	 * \brief pjOݒiZ^[Xs[J[j
	 * \par :
	 * o͐̃`lɉčő̃`l\gpăpjOs܂BZ^[Xs[J[܂܂܂B
	 */
	CRIATOMEX_PAN_SPEAKER_TYPE_AUTO_WITH_CENTER = 11,

	/* enum size is 4bytes */
	CRIATOMEX_PAN_SPEAKER_TYPE_ENUM_SIZE_IS_4BYTES = 0x7FFFFFFF
} CriAtomExPanSpeakerType;

/*JP
 * \brief pjO̊px^Cv
 * \ingroup ATOMEXLIB_GLOBAL
 * \par :
 * }``lfނ̒ʌvZsہAe̓`lǂ̂悤ȊpxƂĈ\܂B<br>
 * ::criAtomExPlayer_SetPanAngleType ֐ŗp܂B<br>
 * \sa criAtomExPlayer_SetPanAngleType
 */
typedef enum CriAtomExPanAngleTypeTag {
	/*JP
	 * \brief ItZbg
	 * \par :
	 * ݒ肳Ăp3Dpx𒆐SƂāAXs[J[̔zuɂItZbgle`lɉāA
	 * ꂼ̓̓`lŌʂɃpjOvZs܂B<br>
	 * Ⴆ΃XeIfނŃp3Dpx0xƐݒ肵ꍇAL`l-30xƂȂ肻̂܂LXs[J[o͂A
	 * R`l+30xƂȂ肻̂܂RXs[J[o͂܂B
	 * ܂p3Dpx+30xƐݒ肵ꍇAL`l0xAR`l60ẍʒuɒʂĂ̂ƂāA
	 * pjOvZs܂B
	 */
	CRIATOMEX_PAN_ANGLE_TYPE_OFFSET = 0,
	/*JP
	 * \brief Œ
	 * \par :
	 * ̓`lɉāAe`lYXs[J[ʒuɌŒ肵đ݂Ă̂ƂāA
	 * eXs[J[Ԃ̃oXvZ悤Ȍ`ŃpjOvZs܂B<br>
	 * Ⴆ΃XeIfނŃp3Dpx0xƐݒ肵ꍇAL`lLXs[J[0.7{ŏo͂A
	 * R`l̓Xs[J[0.7{ŏo͂܂B
	 * ܂p3Dpx+30xƐݒ肵ꍇAL`l͂܂o͂ꂸAR`lRXs[J[炻̂܂܏o͂܂B<br>
	 * \par l:
	 * ̋CRI Audio̍̃p3DƓłB<br>
	 * ǂ̃Xs[J[ɂǂ̃`l蓖Ă邩́A::criAtomExPlayer_SetDrySendLevel ֐Őݒ肷hCZhxł̈ƓlłB
	 * \sa criAtomExPlayer_SetDrySendLevel
	 */
	CRIATOMEX_PAN_ANGLE_TYPE_FIX = 1,
	/*JP
	 * \brief ~bNX
	 * \par :
	 * ȃppx^CvłBgpȂłB
	 */
	CRIATOMEX_PAN_ANGLE_TYPE_AMBIENCE_MIX = 4,
	/*JP
	 * \brief 
	 * \par :
	 * ȃppx^CvłBgpȂłB
	 */
	CRIATOMEX_PAN_ANGLE_TYPE_AMBIENCE_STRAIGHT = 5,

	/* enum size is 4bytes */
	CRIATOMEX_PAN_ANGLE_TYPE_ENUM_SIZE_IS_4BYTES = 0x7FFFFFFF
} CriAtomExPanAngleType;

/*JP
 * \brief o̓Xs[J[̕я
 * \ingroup ATOMEXLIB_GLOBAL
 * \par :
 * e`l̓YƏo̓Xs[J[̑Ή֌W\܂B<br>
 * ::criAtomEx_SetSpeakerAngleArray ֐ŗp܂B<br>
 * \sa criAtomEx_SetSpeakerAngleArray CRIATOMEX_SPEAKER_SYSTEM_SURROUND_5_1 CRIATOMEX_SPEAKER_SYSTEM_SURROUND_7_1
 */
typedef CriUint32 CriAtomExSpeakerSystem;

/*JP
 * \brief 5.1chTEh
 * \par :
 * o̓Xs[J[̕я͈ȉ̂ƂłB
 * \par
 *	-# FRONT LEFT
 *	-# FRONT RIGHT
 *	-# FRONT CENTER
 *	-# LOW FREQUENCY
 *	-# SURROUND LEFT
 *	-# SURROUND RIGHT
 * 	
 * \sa CriAtomExSpeakerSystem
 */
#define CRIATOMEX_SPEAKER_SYSTEM_SURROUND_5_1 (0)

/*JP
 * \brief 7.1chTEh
 * \par :
 * o̓Xs[J[̕я͈ȉ̂ƂłB
 * \par
 *	-# FRONT LEFT
 *	-# FRONT RIGHT
 *	-# FRONT CENTER
 *	-# LOW FREQUENCY
 *	-# SURROUND LEFT
 *	-# SURROUND RIGHT
 *	-# SURROUND BACK LEFT
 *	-# SURROUND BACK RIGHT
 * 	
 * \sa CriAtomExSpeakerSystem
 */
#define CRIATOMEX_SPEAKER_SYSTEM_SURROUND_7_1 (1)

/*JP
 * \brief ʍW\
 * \ingroup ATOMEXLIB_GLOBAL
 * \par :
 * ʍW߂̍\̂łB<br>
 */
typedef struct CriAtomExSphericalCoordinatesTag {
	CriFloat32 azimuth;		/*JP< ʊp	*/
	CriFloat32 elevation;	/*JP< p		*/
	CriFloat32 distance;	/*JP< 		*/
} CriAtomExSphericalCoordinates;

/*JP
 * \brief p[^[\
 * \ingroup ATOMEXLIB_GLOBAL
 * \par :
 * ̋Ɋւp[^[ێ\̂łB<br>
 */
typedef struct CriAtomEx3dAttenuationParameterTag {
	CriFloat32 volume;
	CriFloat32 min_attenuation_distance;
	CriFloat32 max_attenuation_distance;
} CriAtomEx3dAttenuationParameter;

/*JP
 * \brief ubNCfbNX
 * \ingroup ATOMEXLIB_GLOBAL
 * \par :
 * ubNCfbNX́AubNV[PX̃ubÑItZbgԍłB<br>
 * i擪̃ubN0ԁA̎̃ubN1ԁcƂӂɁAubN
 * ԂɊ蓖ĂԍłBj<br>
 * ubNCfbNXvOŕێۂɂ́A{ϐ^pĒl舵Kv܂B<br>
 * \sa criAtomExPlayer_SetFirstBlockIndex, criAtomExPlayback_SetNextBlockIndex, criAtomExPlayback_GetCurrentBlockIndex
 */
typedef CriSint32 CriAtomExBlockIndex;

/*JP
 * \brief Q[ϐID
 * \ingroup ATOMEXLIB_GLOBAL
 * \par :
 * Q[ϐID́A[UI[TOc[ ACF ̃Q[ϐɑ΂Ċ蓖ĂIDłB<br>
 * Q[ϐIDvOŕێۂɂ́A{ϐ^pĒl舵Kv܂B<br>
 * \sa criAtomEx_GetGameVariableById, criAtomEx_SetGameVariableById
 */
typedef CriUint32 CriAtomExGameVariableId;

/*JP
 * \brief Q[ϐ擾p\
 * \ingroup ATOMEXLIB_GLOBAL
 * \par :
 * Q[ϐ擾邽߂̍\̂łB<br>
 * ::CriAtomExGameVariableInfo ֐ɈƂēn܂B<br>
 * \sa criAtomEx_GetGameVariableInfo
 */
typedef struct CriAtomExGameVariableInfoTag {
	const CriChar8* name;		/*JP< Q[ϐ	*/
	CriAtomExGameVariableId id;	/*JP< Q[ϐID	*/
	CriFloat32 value;			/*JP< Q[ϐl	*/
} CriAtomExGameVariableInfo;

/*JP
 * \brief Xg[~O
 * \ingroup ATOMEXLIB_GLOBAL
 * \par :
 * ::criAtomEx_GetStreamingInfo ֐Ŏ擾_ł̃Xg[~Ȍ󋵂łB<br>
 * \sa criAtomEx_GetStreamingInfo
 */
typedef CriAtomStreamingInfo CriAtomExStreamingInfo;

/*JP
 * \brief R[h
 * \ingroup ATOMEXLIB_GLOBAL
 * \par :
 * R[hij\܂B
 */
typedef enum CriAtomExCharacterEncodingTag {
	CRIATOMEX_CHARACTER_ENCODING_UTF8 = 0,	/*JP< UTF-8		*/
	CRIATOMEX_CHARACTER_ENCODING_SJIS = 1,	/*JP< Shift_JIS	*/
	
	/* enum size is 4bytes */
	CRIATOMEX_CHARACTER_ENCODING_ENUM_SIZE_IS_4BYTES = 0x7FFFFFFF
} CriAtomExCharacterEncoding;

/*JP
 * \brief e탊\[X̎gp
 * \ingroup ATOMEXLIB_GLOBAL
 * \par :
 * e탊\[X̎gp󋵂\킷\̂łB
 */
typedef struct CriAtomExResourceUsageTag {
	CriUint32 use_count;	/*JP< Ώۃ\[X݂̌̎gp	*/
	CriUint32 limit;		/*JP< Ώۃ\[X̐			*/
} CriAtomExResourceUsage;

/*JP
 * \brief Ȑ^Cv
 * \ingroup ATOMEXLIB_GLOBAL
 * \par :
 * Ȑ̃^CvłB
 * \sa CriAtomExReactFadeParameter
 */
typedef enum CriAtomExCurveTypeTag {
	CRIATOMEX_CURVE_TYPE_LINEAR = 0,		/*JP< 		*/
	CRIATOMEX_CURVE_TYPE_SQUARE,			/*JP< ᑬω	*/
	CRIATOMEX_CURVE_TYPE_SQUARE_REVERSE,	/*JP< ω	*/
	CRIATOMEX_CURVE_TYPE_S,					/*JP< SȐ	*/
	CRIATOMEX_CURVE_TYPE_FLAT_AT_HALF,		/*JP< tSȐ	*/

	/* enum size is 4bytes */
	CRIATOMEX_CURVE_TYPE_ENUM_SIZE_IS_4BYTES = 0x7FFFFFFF
} CriAtomExCurveType;

/*==========================================================================
 *      CRI AtomEx Debug API
 *=========================================================================*/
/*JP
 * \brief CriAtomEx ̊e탊\[X̏
 * \ingroup ATOMEXLIB_GLOBAL_DEBUG
 * \par :
 * CriAtomEx ̊e탊\[X̏󋵂\\̂łB<br>
 * ::criAtomExDebug_GetResourcesInfo gpĎ擾ĂB<br>
 * \attention
 * JxfobO@\łBAvP[VJɂ̂ݎgpĂB
 * \sa criAtomExDebug_GetResourcesInfo
 */
typedef struct CriAtomExDebugResourcesInfoTag {
	/*JP o[`{CX̎gp󋵁ilimit ̓CuɎw肵 CriAtomExConfig::max_virtual_voices ̐j */
	CriAtomExResourceUsage virtual_voice_usage;
	/*JP V[PX̎gp󋵁ilimit ̓CuɎw肵 CriAtomExConfig::max_sequences ̐j */
	CriAtomExResourceUsage sequence_usage;
	/*JP V[PXgbN̎gp󋵁ilimit ̓CuɎw肵 CriAtomExConfig::max_tracks ̐j */
	CriAtomExResourceUsage sequence_track_usage;
	/*JP V[PXgbNACe̎gp󋵁ilimit ̓CuɎw肵 CriAtomExConfig::max_track_items ̐j */
	CriAtomExResourceUsage sequence_track_item_usage;
	/*JP p[^[ubN̎gp󋵁ilimit ̓CuɎw肵 CriAtomExConfig::max_parameter_blocks ̐j */
	CriAtomExResourceUsage parameter_block;
	/*JP r[g̎gp󋵁ilimit ̓CuɎw肵 CriAtomExConfig::max_virtual_voices ̐j */
	CriAtomExResourceUsage beat_sync_info;
	/*JP r[gJڐݒ̎gp󋵁ilimit ̓CuɎw肵 CriAtomExConfig::max_virtual_voices ̐j */
	CriAtomExResourceUsage beat_sync_transition_setting;
	/*JP r[gWu̎gp󋵁ilimit ̓CuɎw肵 CriAtomExConfig::max_virtual_voices * 2 ̐j */
	CriAtomExResourceUsage beat_sync_job;
} CriAtomExDebugResourcesInfo;

/*==========================================================================
 *      CRI AtomEx HCA-MX API
 *=========================================================================*/
/*JP
 * \brief HCA-MXpRtBO\
 * \ingroup ATOMEXLIB_HCA_MX
 * HCA-MX̓dlw肷邽߂̍\̂łB<br>
 * ::criAtomExHcaMx_Initialize ֐̈Ɏw肵܂B<br>
 * \par l:
 * ftHgݒgpꍇA ::criAtomExHcaMx_SetDefaultConfig }N
 * \̂ɃftHgp[^[ZbgA ::criAtomExHcaMx_Initialize ֐
 * ɍ\̂w肵ĂB<br>
 * \attention
 * IɃo\邽߁A ::criAtomExHcaMx_SetDefaultConfig 
 * }NgpȂꍇɂ́AgpOɕK\̂[NAĂB<br>
 * i\̂̃oɕslȂ悤ӂBj
 * \sa criAtomExHcaMx_Initialize, criAtomExHcaMx_SetDefaultConfig
 */
typedef struct CriAtomExHcaMxConfigTag {
	/*JP
		\brief T[o[̎spx
		\par :
		T[o[spxw肵܂B<br>
		\attention
		AtomCuɎw肵li ::CriAtomExConfig \̂
		server_frequency jƁAlZbgKv܂B<br>
		\sa CriAtomExConfig
	*/
	CriFloat32 server_frequency;
	
	/*JP
		\brief ~LT[
		\par :
		HCA-MXfR[hʂ𑗐M~LT[̐w肵܂B<br>
		~LT[𕡐쐬邱ƂŁA
		~LT[ƂɈقȂDSPoXDSP FXKp邱Ƃ\ɂȂ܂B<br>
		\attention
		HCA-MX̃fR[hAђԂׂ̏́A
		~LT[̐ɔႵďdȂ܂B<br>
		<br>
		{p[^[0ɐݒ肵ꍇłA~LT[ 1 쐬܂B<br>
		io[WƂ̌݊ێ̂߁Bj<br>
		HCA-MXgpȂꍇɂ́A{p[^[ max_voices ̗ 0 
		ɐݒ肵ĂB<br>
	*/
	CriSint32 num_mixers;
	
	/*JP
		\brief ~LT[ɓo^\ȍő{CX
		\par :
		~LT[Ƃɓo^\HCA-MX{CX̐w肵܂B<br>
		HCA-MX{CXv[쐬ۂɂ́A{CX̑
		num_mixers ~ max_voices 𒴂Ȃ悤ӂB
	*/
	CriSint32 max_voices;
	
	/*JP
		\brief ̓f[^̍ő`l
		\par :
		AvP[VōĐHCA-MXf[^̍ő`lw肵܂B<br>
		Đf[^m̏ꍇ1AXeȈꍇ2w肵ĂB<br>
		\par l:
		HCA-MX max_input_channels Ɏw肳ꂽȉ̉f[^
		Đ\ɂȂ܂B<br>
		Ⴆ΁A max_input_channels 6w肵ꍇA5.1chłȂA
		mXeIĐ\ɂȂ܂B<br>
		100̃f[^̂A99mA1XeȈꍇłA
		max_input_channels ɂ2w肷Kv܂B<br>
	*/
	CriSint32 max_input_channels;
	
	/*JP
		\brief őTvO[g
		\par :
		HCA-MX̏o͂ɎwłőTvO[głB<br>
		~LT[̍ŏIo͂Ńsb`ύXꍇɐݒ肵܂B<br>
		~LT[̍ŏIo͂Ńsb`ύXȂꍇ́Aoutput_sampling_rateƓlݒ肵ĂB<br>
		\par l:
		ႦHCA-MXĐ::criAtomExHcaMx_SetFrequencyRatio ֐ 2.0f w肵ăsb`グꍇ́A
		output_sampling_rate * 2 w肵HCA-MXĂB<br>
	*/
	CriSint32 max_sampling_rate;

	/*JP
		\brief o̓`l
		\par :
		HCA-MXf[^̏o̓`lw肵܂B<br>
		ʏA^[Qbg@ɐڑꂽXs[J[̐io̓foCX
		ő`ljw肵܂B<br>
		\par l:
		m݂̂ĐApRg[Ȃꍇɂ́A
		output_channels 1ɂ邱ƂŁAׂ邱Ƃ\łB<br>
		\attention
		output_channels ̐ max_input_channels ȉ̒lɐݒ肷邱Ƃ
		ł܂B<br>
	*/
	CriSint32 output_channels;
	
	/*JP
		\brief o̓TvO[g
		\par :
		ĐHCA-MXf[^̃TvO[gw肵܂B<br>
		HCA-MXf[^쐬ۂɂ́AKSẲf[^𓯈̃TvO
		[gō쐬A̒l output_sampling_rate Ɏw肵ĂB<br>
		\par l:
		HCA-MX́APʂ̃TvO[gύXs܂B<br>
	*/
	CriSint32 output_sampling_rate;
	
	/*JP
		\brief TEh_^Cv
		\par :
		HCA-MX̏o͐TEh_̎ʂw肵܂B<br>
		sound_renderer_type  CRIATOM_SOUND_RENDERER_DEFAULT w肵ꍇA
		f[^̓ftHgݒ̃TEh_ɓ]܂B<br>
		sound_renderer_type  CRIATOM_SOUND_RENDERER_NATIVE w肵ꍇA
		f[^̓ftHgݒ̊evbgtH[̃TEho͂ɓ]܂B<br>
		sound_renderer_type  CRIATOM_SOUND_RENDERER_ASR w肵ꍇA
		f[^ASRiAtom Sound Rendererjɓ]܂B<br>
		iASȐo͐́AASRɕʓrwBj
	*/
	CriAtomSoundRendererType sound_renderer_type;
} CriAtomExHcaMxConfig;

/*==========================================================================
 *      CRI AtomEx ACF API
 *=========================================================================*/
/*JP
 * \brief ACF
 * \ingroup ATOMEXLIB_ACF
 * \par :
 * ACFf[^̏ڍ׏łB<br>
 * \sa criAtomExAcf_GetAcfInfo, criAtomExAcf_GetAcfInfoFromAcfData
 */
typedef struct CriAtomExAcfInfoTag {
	const CriChar8* name;							/*JP< O						*/
	CriUint32 size;									/*JP< TCY					*/
	CriUint32 version;								/*JP< ACBo[W				*/
	CriAtomExCharacterEncoding character_encoding;	/*JP< R[h				*/
	CriSint32 num_dsp_settings;						/*JP< DSPݒ萔					*/
	CriSint32 num_categories;						/*JP< JeS				*/
	CriSint32 num_categories_per_playback;			/*JP< ĐJeSQƐ		*/
	CriSint32 num_reacts;							/*JP< REACT					*/
	CriSint32 num_aisac_controls;					/*JP< AISACRg[		*/
	CriSint32 num_global_aisacs;					/*JP< O[oAISAC			*/
	CriSint32 num_game_variables;					/*JP< Q[ϐ				*/
	CriSint32 max_buses_of_dsp_bus_settings;		/*JP< DSPݒőoX		*/
	CriSint32 num_buses;							/*JP< oX					*/
	CriSint32 num_voice_limit_groups;				/*JP< {CX~bgO[v	*/
	CriSint32 num_output_ports;						/*JP< o̓|[g */
} CriAtomExAcfInfo;

/*JP
 * \brief AISACRg[ID
 * \ingroup ATOMEXLIB_ACF
 * \par :
 * AISACRg[ID́AAISACRg[ɑ΂Ċ蓖ĂĂӂIDłB<br>
 * AISACRg[IDvOŕێۂɂ́A{ϐ^pĒl舵Kv܂B<br>
 * \sa criAtomExPlayer_SetAisacControlById, criAtomExAcf_GetAisacControlIdByName, criAtomExAcf_GetAisacControlNameById
 */
typedef CriUint32 CriAtomExAisacControlId;

/*JP
 * \brief AISACRg[擾p\
 * \ingroup ATOMEXLIB_ACF
 * \par :
 * AISACRg[擾邽߂̍\̂łB<br>
 * ::criAtomExAcf_GetAisacControlInfo ֐ɈƂēn܂B<br>
 * \sa criAtomExAcf_GetAisacControlInfo
 */
typedef struct CriAtomExAisacControlInfoTag {
	const CriChar8*			name;		/*JP< AISACRg[	*/
	CriAtomExAisacControlId	id;			/*JP< AISACRg[ID	*/
} CriAtomExAisacControlInfo;

/*JP
 * \brief AISAC擾p\
 * \ingroup ATOMEXLIB_ACF
 * \par :
 * AISAC擾邽߂̍\̂łB<br>
 * ::criAtomExPlayer_GetAttachedAisacInfo ֐ɈƂēn܂B<br>
 * \sa criAtomExPlayer_GetAttachedAisacInfo
 */
typedef struct CriAtomExAisacInfoTag {
	const CriChar8* name;		/*JP< AISAC	*/
	CriBool default_control_flag;		/*JP< ftHgRg[lݒ肳Ă邩	*/
	CriFloat32 default_control_value;	/*JP< ftHgAISACRg[l	*/
	CriAtomExAisacControlId control_id;			/*JP< Control Id	*/
	const CriChar8* control_name;	/*JP< Control Name	*/
} CriAtomExAisacInfo;

/*JP
 * \brief DSPoXݒ̏擾p\
 * \ingroup ATOMEXLIB_ACF
 * \par :
 * DSPoXݒ̏擾邽߂̍\̂łB<br>
 * ::criAtomExAcf_GetDspSettingInformation ֐ɈƂēn܂B<br>
 * \sa criAtomExAcf_GetDspSettingInformation
 */
typedef struct CriAtomExAcfDspSettingInfoTag {
	const CriChar8* name;									/*JP< ZbeBO			*/
	CriUint16 bus_indexes[CRIATOMEXACF_MAX_BUSES];			/*JP< DSPoXCfbNXz	*/
	CriUint16 extend_bus_indexes[CRIATOMEXACF_MAX_BUSES];	/*JP< DSPgoXCfbNXz	*/
	CriUint16 snapshot_start_index;							/*JP< XibvVbgJnCfbNX	*/
	CriUint8 num_buses;										/*JP< LDSPoX				*/
	CriUint8 num_extend_buses;								/*JP< LgDSPoX				*/
	CriUint16 num_snapshots;								/*JP< XibvVbg				*/
	CriUint16 snapshot_work_size;							/*JP< XibvVbgp[N̈TCY	*/
	CriUint16 num_mixer_aisacs;								/*JP< ~LT[AISAC	*/
	CriUint16 mixer_aisac_start_index;						/*JP< ~LT[AISACJnCfbNX	*/
} CriAtomExAcfDspSettingInfo;

/*JP
 * \brief DSPoXݒXibvVbg̏擾p\
 * \ingroup ATOMEXLIB_ACF
 * \par :
 * DSPoXݒ̃XibvVbg擾邽߂̍\̂łB<br>
 */
typedef struct CriAtomExAcfDspSettingSnapshotInfoTag {
	const CriChar8* name;									/*JP< XibvVbg			*/
	CriUint8 num_buses;										/*JP< LDSPoX					*/
	CriUint8 num_extend_buses;								/*JP< LgDSPoX				*/
	CriUint8 reserved[2];									/*JP< \̈						*/
	CriUint16 bus_indexes[CRIATOMEXACF_MAX_BUSES];			/*JP< DSPoXCfbNXz		*/
	CriUint16 extend_bus_indexes[CRIATOMEXACF_MAX_BUSES];	/*JP< DSPgoXCfbNXz	*/
} CriAtomExAcfDspSettingSnapshotInfo;

/*JP
 * \brief DSPoXݒ擾p\
 * \ingroup ATOMEXLIB_ACF
 * \par :
 * DSPoXݒ擾邽߂̍\̂łB<br>
 * ::criAtomExAcf_GetDspBusInformation ֐ɈƂēn܂B<br>
 * \sa criAtomExAcf_GetDspBusInformation
 */
typedef struct CriAtomExAcfDspBusInfoTag {
	const CriChar8* name;								/*JP< O							*/
	CriFloat32 volume;									/*JP< 							*/
	CriFloat32 pan3d_volume;							/*JP< Pan3D 					*/
	CriFloat32 pan3d_angle;								/*JP< Pan3D px					*/
	CriFloat32 pan3d_distance;							/*JP< Pan3D CeA			*/
	CriFloat32 pan3d_wideness;							/*JP< Pan3D }``l̍L	*/
	CriFloat32 pan3d_spread;							/*JP< Pan3D Xvbh				*/
	CriUint16 fx_indexes[CRIATOMEXACF_MAX_FXES];		/*JP< DSP FXCfbNXz		*/
	CriUint16 bus_link_indexes[CRIATOMEXACF_MAX_BUSES];	/*JP< DSPoXNCfbNXz	*/
	CriUint16 bus_no;									/*JP< ZbeBODSPoXԍ		*/
	CriUint8 num_fxes;									/*JP< DSP FX						*/
	CriUint8 num_bus_links;								/*JP< DSPoXN				*/
} CriAtomExAcfDspBusInfo;

/*JP
 * \brief DSPoXN^Cv
 * \ingroup ATOMEXLIB_ACF
 * \sa CriAtomExAcfDspBusLinkInfo
 */
typedef enum CriAtomExAcfDspBusLinkTypeTag {
	CRIATOMEXACF_DSP_BUS_LINK_TYPE_PRE_VOLUME,		/*JP< v{[^Cv		*/
	CRIATOMEXACF_DSP_BUS_LINK_TYPE_POST_VOLUME,		/*JP< |Xg{[^Cv	*/
	CRIATOMEXACF_DSP_BUS_LINK_TYPE_POST_PAN,		/*JP< |Xgp^Cv			*/
	/* enum size is 4bytes */
	CRIATOMEXACF_DSP_BUS_LINK_TYPE_ENUM_SIZE_IS_4BYTES = 0x7FFFFFFF
} CriAtomExAcfDspBusLinkType;

/*JP
 * \brief DSPoXN擾p\
 * \ingroup ATOMEXLIB_ACF
 * \par :
 * DSPoXN擾邽߂̍\̂łB<br>
 * ::criAtomExAcf_GetDspBusLinkInformation ֐ɈƂēn܂B<br>
 * \sa criAtomExAcf_GetDspBusLinkInformation
 */
typedef struct CriAtomExAcfDspBusLinkInfoTag {
	CriAtomExAcfDspBusLinkType type;	/*JP< ^Cv							*/
	CriFloat32 send_level;				/*JP< Zhx						*/
	CriUint16 bus_no;					/*JP< ̃ZbeBODSPoXԍ	*/
	CriUint16 bus_id;					/*JP< ̃ZbeBODSPoXID	*/
} CriAtomExAcfDspBusLinkInfo;

/*JP
 * \brief Aisac^Cv
 * \ingroup ATOMEXLIB_ACF
 * \sa CriAtomExGlobalAisacInfo
 */
typedef enum CriAtomExAcfAisacTypeTag {
	CRIATOMEXACF_AISAC_TYPE_NORMAL,				/*JP< m[}^Cv				*/
	CRIATOMEXACF_AISAC_TYPE_AUTO_MODULATION,	/*JP< I[gW[V^Cv	*/
	/* enum size is 4bytes */
	CRIATOMEXACF_AISAC_TYPE_ENUM_SIZE_IS_4BYTES = 0x7FFFFFFF
} CriAtomExAcfAisacType;


/*JP
 * \brief Global Aisac擾p\
 * \ingroup ATOMEXLIB_ACF
 * \par :
 * Global Aisac擾邽߂̍\̂łB<br>
 * ::criAtomExAcf_GetGlobalAisacInfo ֐ɈƂēn܂B<br>
 * \attention
 * type::CRIATOMEXACF_AISAC_TYPE_AUTO_MODULATION ̏ꍇA
 * control_id͓IɎgpCfbNXlƂȂ܂B
 * \sa criAtomExAcf_GetGlobalAisacInfo
 */
typedef struct CriAtomExGlobalAisacInfoTag {
	const CriChar8* name;				/*JP< Global Aisac	*/
	CriUint16 index;					/*JP< f[^CfbNX*/
	CriUint16 num_graphs;				/*JP< Ot			*/
	CriAtomExAcfAisacType type;			/*JP< Aisac^Cv		*/
	CriFloat32 random_range;			/*JP< _W	*/
	CriUint16 control_id;				/*JP< Control Id		*/
	CriUint16 dummy;					/*JP< gp			*/
} CriAtomExGlobalAisacInfo;

/* AisacOt^Cv */
/*JP
 * \brief AisacOt^Cv
 * \ingroup ATOMEXLIB_ACF
 * \par :
 * AisacOt̃^CvłB<br>
 * \sa CriAtomExAisacGraphInfo
 */
typedef enum CriAtomExAisacGraphTypeTag {
	CRIATOMEX_AISAC_GRAPH_TYPE_NON = 0,					/*JP< gp	 */
	CRIATOMEX_AISAC_GRAPH_TYPE_VOLUME,					/*JP< {[ */
	CRIATOMEX_AISAC_GRAPH_TYPE_PITCH,					/*JP< sb` */
	CRIATOMEX_AISAC_GRAPH_TYPE_BANDPASS_HI,				/*JP< ohpXtB^[̍JbgItg */
	CRIATOMEX_AISAC_GRAPH_TYPE_BANDPASS_LOW,			/*JP< ohpXtB^[̒JbgItg */
	CRIATOMEX_AISAC_GRAPH_TYPE_BIQUAD_FREQ,				/*JP< oCNAbhtB^[̎g */
	CRIATOMEX_AISAC_GRAPH_TYPE_BIQUAD_Q,				/*JP< oCNAbhtB^[Ql */
	CRIATOMEX_AISAC_GRAPH_TYPE_BUS_0_SEND,				/*JP< oXZhx0 */
	CRIATOMEX_AISAC_GRAPH_TYPE_BUS_1_SEND,				/*JP< oXZhx1 */
	CRIATOMEX_AISAC_GRAPH_TYPE_BUS_2_SEND,				/*JP< oXZhx2 */
	CRIATOMEX_AISAC_GRAPH_TYPE_BUS_3_SEND,				/*JP< oXZhx3 */
	CRIATOMEX_AISAC_GRAPH_TYPE_BUS_4_SEND,				/*JP< oXZhx4 */
	CRIATOMEX_AISAC_GRAPH_TYPE_BUS_5_SEND,				/*JP< oXZhx5 */
	CRIATOMEX_AISAC_GRAPH_TYPE_BUS_6_SEND,				/*JP< oXZhx6 */
	CRIATOMEX_AISAC_GRAPH_TYPE_BUS_7_SEND,				/*JP< oXZhx7 */
	CRIATOMEX_AISAC_GRAPH_TYPE_PAN3D_ANGLE,				/*JP< pjO3Dʊpx */
	CRIATOMEX_AISAC_GRAPH_TYPE_PAN3D_VOLUME,			/*JP< pjO3D{[ */
	CRIATOMEX_AISAC_GRAPH_TYPE_PAN3D_INTERIOR_DISTANCE,	/*JP< pjO3D */
	CRIATOMEX_AISAC_GRAPH_TYPE_PAN3D_CENTER,			/*JP< ACB Ver.0.11.00ȍ~ł͎gpȂ */
	CRIATOMEX_AISAC_GRAPH_TYPE_PAN3D_LFE,				/*JP< ACB Ver.0.11.00ȍ~ł͎gpȂ */
	CRIATOMEX_AISAC_GRAPH_TYPE_AISAC_0,					/*JP< AISACRg[ID 0 */
	CRIATOMEX_AISAC_GRAPH_TYPE_AISAC_1,					/*JP< AISACRg[ID 1 */
	CRIATOMEX_AISAC_GRAPH_TYPE_AISAC_2,					/*JP< AISACRg[ID 2 */
	CRIATOMEX_AISAC_GRAPH_TYPE_AISAC_3,					/*JP< AISACRg[ID 3 */
	CRIATOMEX_AISAC_GRAPH_TYPE_AISAC_4,					/*JP< AISACRg[ID 4 */
	CRIATOMEX_AISAC_GRAPH_TYPE_AISAC_5,					/*JP< AISACRg[ID 5 */
	CRIATOMEX_AISAC_GRAPH_TYPE_AISAC_6,					/*JP< AISACRg[ID 6 */
	CRIATOMEX_AISAC_GRAPH_TYPE_AISAC_7,					/*JP< AISACRg[ID 7 */
	CRIATOMEX_AISAC_GRAPH_TYPE_AISAC_8,					/*JP< AISACRg[ID 8 */
	CRIATOMEX_AISAC_GRAPH_TYPE_AISAC_9,					/*JP< AISACRg[ID 9 */
	CRIATOMEX_AISAC_GRAPH_TYPE_AISAC_10,				/*JP< AISACRg[ID 10 */
	CRIATOMEX_AISAC_GRAPH_TYPE_AISAC_11,				/*JP< AISACRg[ID 11 */
	CRIATOMEX_AISAC_GRAPH_TYPE_AISAC_12,				/*JP< AISACRg[ID 12 */
	CRIATOMEX_AISAC_GRAPH_TYPE_AISAC_13,				/*JP< AISACRg[ID 13 */
	CRIATOMEX_AISAC_GRAPH_TYPE_AISAC_14,				/*JP< AISACRg[ID 14 */
	CRIATOMEX_AISAC_GRAPH_TYPE_AISAC_15,				/*JP< AISACRg[ID 15 */
	CRIATOMEX_AISAC_GRAPH_TYPE_PRIORITY,				/*JP< {CXvCIeB */
	CRIATOMEX_AISAC_GRAPH_TYPE_PRE_DELAY_TIME,			/*JP< vfBC */
	CRIATOMEX_AISAC_GRAPH_TYPE_BIQUAD_GAIN,				/*JP< oCNAbhtB^[̃QC */
	CRIATOMEX_AISAC_GRAPH_TYPE_PAN3D_MIXDOWN_CENTER,	/*JP< pjO3D Z^[x */
	CRIATOMEX_AISAC_GRAPH_TYPE_PAN3D_MIXDOWN_LFE,		/*JP< pjO3D LFEx */
	CRIATOMEX_AISAC_GRAPH_TYPE_EG_ATTACK,				/*JP< Gx[v A^bN */
	CRIATOMEX_AISAC_GRAPH_TYPE_EG_RELEASE,				/*JP< Gx[v [X */
	CRIATOMEX_AISAC_GRAPH_TYPE_PLAYBACK_RATIO,			/*JP< V[PXĐVI */
	CRIATOMEX_AISAC_GRAPH_TYPE_DRY_SEND_L,				/*JP< L chhCZh */
	CRIATOMEX_AISAC_GRAPH_TYPE_DRY_SEND_R,				/*JP< R chhCZh */
	CRIATOMEX_AISAC_GRAPH_TYPE_DRY_SEND_CENTER,			/*JP< Center chhCZh */
	CRIATOMEX_AISAC_GRAPH_TYPE_DRY_SEND_LFE,			/*JP< LFE chhCZh */
	CRIATOMEX_AISAC_GRAPH_TYPE_DRY_SEND_SL,				/*JP< Surround L chhCZh */
	CRIATOMEX_AISAC_GRAPH_TYPE_DRY_SEND_SR,				/*JP< Surround R chhCZh */
	CRIATOMEX_AISAC_GRAPH_TYPE_DRY_SEND_EX1,			/*JP< Ex1 chhCZh */
	CRIATOMEX_AISAC_GRAPH_TYPE_DRY_SEND_EX2,			/*JP< Ex2 chhCZh */
	CRIATOMEX_AISAC_GRAPH_TYPE_WIDENESS,				/*JP< }``l̍L */
	CRIATOMEX_AISAC_GRAPH_TYPE_SPREAD,					/*JP< Xvbh */
	CRIATOMEX_AISAC_GRAPH_TYPE_ARBITRARY_BUS_SEND,		/*JP< CӃoXZh */
	CRIATOMEX_AISAC_GRAPH_TYPE_ARBITRARY_AISAC_CONTROL,	/*JP< CAISACRg[ID */
	CRIATOMEX_AISAC_GRAPH_TYPE_PAN3D_ELEVATION_ANGLE,	/*JP< pjO3Dpx */

	/* enum size is 4bytes */
	CRIATOMEX_AISAC_GRAPH_TYPE_ENUM_SIZE_IS_4BYTES = 0x7FFFFFFF
} CriAtomExAisacGraphType;

/*JP
 * \brief Aisac Graph擾p\
 * \ingroup ATOMEXLIB_ACF
 * \par :
 * Global Aisac Graph擾邽߂̍\̂łB<br>
 * ::criAtomExAcf_GetGlobalAisacGraphInfo ֐ɈƂēn܂B<br>
 * \sa criAtomExAcf_GetGlobalAisacGraphInfo
 */
typedef struct CriAtomExAisacGraphInfoTag {
	CriAtomExAisacGraphType type;		/*JP< Graph^Cv		*/
} CriAtomExAisacGraphInfo;

/*JP
 * \brief ZN^[擾p\
 * \ingroup ATOMEXLIB_ACF
 * \par :
 * ZN^[擾邽߂̍\̂łB<br>
 * ::criAtomExAcf_GetSelectorInfoByIndex ֐܂ ::criAtomExAcf_GetSelectorInfoByName ֐
 * Ƃēn܂B<br>
 * \attention
 * \sa criAtomExAcf_GetSelectorInfoByIndex, criAtomExAcf_GetSelectorInfoByName
 */
typedef struct CriAtomExSelectorInfoTag {
	const CriChar8* name;				/*JP< ZN^[		*/
	CriUint16 index;					/*JP< f[^CfbNX*/
	CriUint16 num_labels;				/*JP< x			*/
	CriUint16 global_label_index;		/*JP< O[oQƃxCfbNX	*/
} CriAtomExSelectorInfo;

/*JP
 * \brief ZN^[x擾p\
 * \ingroup ATOMEXLIB_ACF
 * \par :
 * ZN^[x擾邽߂̍\̂łB<br>
 * ::criAtomExAcf_GetSelectorLabelInfo ֐ɈƂēn܂B<br>
 * \sa criAtomExAcf_GetSelectorLabelInfo
 */
typedef struct CriAtomExSelectorLabelInfoTag {
	const CriChar8* selector_name;			/*JP< ZN^[					*/
	const CriChar8* label_name;				/*JP< ZN^[x				*/
} CriAtomExSelectorLabelInfo;

/*JP
 * \brief ~LT[AisacOt^Cv
 * \ingroup ATOMEXLIB_ACF
 * \par :
 * ~LT[AisacOt̃^CvłB<br>
 */
typedef enum CriAtomExMixerAisacGraphTypeTag {
	CRIATOMEX_MIXER_AISAC_GRAPH_TYPE_VOLUME = 0,		/*JP< {[ */
	CRIATOMEX_MIXER_AISAC_GRAPH_TYPE_PAN3D_ANGLE,		/*JP< pjO3Dpx */
	CRIATOMEX_MIXER_AISAC_GRAPH_TYPE_BUS_SEND_LEVEL,	/*JP< oXZhx */
	CRIATOMEX_MIXER_AISAC_GRAPH_TYPE_WIDENESS,			/*JP< }``l̍L */
	CRIATOMEX_MIXER_AISAC_GRAPH_TYPE_SPREAD,			/*JP< Xvbh */

	/* enum size is 4bytes */
	CRIATOMEX_MIXER_AISAC_GRAPH_TYPE_ENUM_SIZE_IS_4BYTES = 0x7FFFFFFF
} CriAtomExMixerAisacGraphType;
/*==========================================================================
 *      CRI AtomEx Category API
 *=========================================================================*/
/*JP
 * \brief JeSID
 * \ingroup ATOMEXLIB_CATEGORY
 * \par :
 * JeSID́A[UI[TOc[ŃJeSɑ΂Ċ蓖ĂӂIDłB<br>
 * JeSIDvOŕێۂɂ́A{ϐ^pĒl舵Kv܂B<br>
 * \sa criAtomExCategory_SetVolumeById, criAtomExCategory_MuteById, criAtomExCategory_SoloById
 */
typedef CriUint32 CriAtomExCategoryId;

/*JP
 * \brief őĐJeSQƐ
 * \ingroup ATOMEXLIB_CATEGORY
 * Đ̍őJeSQƐłB<br>
 * \sa CriAtomExCueInfo
 */
#define CRIATOMEXCATEGORY_MAX_CATEGORIES_PER_PLAYBACK	(16)

/*JP
 * \brief JeS擾p\
 * \ingroup ATOMEXLIB_CATEGORY
 * \par :
 * JeS擾邽߂̍\̂łB<br>
 * ::criAtomExAcf_GetCategoryInfo ֐ɈƂēn܂B<br>
 * \sa criAtomExAcf_GetCategoryInfo
 */
typedef struct CriAtomExCategoryInfoTag {
	CriUint32 group_no;			/*JP< O[vԍ		*/
	CriUint32 id;				/*JP< JeSID		*/
	const CriChar8* name;		/*JP< JeS		*/
	CriUint32 num_cue_limits;	/*JP< L[~bg	*/
	CriFloat32 volume;			/*JP< {[		*/
} CriAtomExCategoryInfo;

/*JP
 * \brief REACT^Cv
 * \ingroup ATOMEXLIB_CATEGORY
 * \par :
 * REACT̃^CvłB<br>
 * \sa CriAtomExReactParameter, criAtomExCategory_SetReactParameter, criAtomExCategory_GetReactParameter
 */
typedef enum CriAtomExReactTypeTag {
	CRIATOMEX_REACT_TYPE_DUCKER = 0,					/*JP< _bJ[						*/
	CRIATOMEX_REACT_TYPE_AISAC_MODULATION_TRIGGER,		/*JP< AISACW[VgK[	*/

	/* enum size is 4bytes */
	CRIATOMEX_REACT_TYPE_ENUM_SIZE_IS_4BYTES = 0x7FFFFFFF
} CriAtomExReactType;

/*JP
 * \brief REACTɂ_bLÕ^[Qbg
 * \ingroup ATOMEXLIB_CATEGORY
 * \par :
 * REACTɂ_bLOΏۂ̃^CvłB
 * \sa CriAtomExReactParameter, criAtomExCategory_SetReactParameter, criAtomExCategory_GetReactParameter
 */
typedef enum CriAtomExReactDuckerTargetTypeTag {
	CRIATOMEX_REACT_DUCKER_TARGET_TYPE_VOLUME = 0,					/*JP< {[̃_bJ[				*/
	CRIATOMEX_REACT_DUCKER_TARGET_TYPE_AISAC_CONTROL_VALUE,			/*JP< AISACRg[l̃_bJ[	*/

	/* enum size is 4bytes */
	CRIATOMEX_REACT_DUCKER_TARGET_TYPE_ENUM_SIZE_IS_4BYTES = 0x7FFFFFFF
} CriAtomExReactDuckerTargetType;

/*JP
 * \brief REACTtF[hp[^[\
 * \ingroup ATOMEXLIB_CATEGORY
 * \par :
 * REACT̃tF[h쓮p[^[ݒ擾邽߂̍\̂łB<br>
 * \sa CriAtomExReactParameter, criAtomExCategory_SetReactParameter, criAtomExCategory_GetReactParameter
 */
typedef struct CriAtomExReactFadeParameterTag {
	CriAtomExCurveType				curve_type;			/*JP< ωȐ^Cv					*/
	CriFloat32						curve_strength;		/*JP< ωȐ̋i0.0f ` 2.0fj	*/
	CriUint16						fade_time_ms;		/*JP< tF[hԁi~bj			*/
} CriAtomExReactFadeParameter;

/*JP
 * \brief REACTz[h^Cv
 * \ingroup ATOMEXLIB_CATEGORY
 * \par :
 * REACTz[hiԂ̈ێj^CvłB<br>
 * \sa CriAtomExReactParameter, criAtomExCategory_SetReactParameter, criAtomExCategory_GetReactParameter
 */
typedef enum CriAtomExReactHoldTypeTag {
	CRIATOMEX_REACT_HOLD_TYPE_WHILE_PLAYING,		/*JP< ĐɃz[hs		*/
	CRIATOMEX_REACT_HOLD_TYPE_FIXED_TIME,			/*JP< Œ莞ԂŃz[hs		*/

	/* enum size is 4bytes */
	CRIATOMEX_REACT_HOLD_TYPE_ENUM_SIZE_IS_4BYTES = 0x7FFFFFFF
} CriAtomExReactHoldType;

/*JP
 * \brief REACTɂ_bJ[p[^[\
 * \ingroup ATOMEXLIB_CATEGORY
 * \par :
 * REACTɂ_bJ[̋쓮p[^[ݒ擾邽߂̍\̂łB
 * \sa CriAtomExReactParameter, criAtomExCategory_SetReactParameter, criAtomExCategory_GetReactParameter
 */
typedef struct CriAtomExReactDuckerParameterTag {
	union {
		struct {
			CriFloat32	level;							/*JP< {[x				*/
		} volume;
		struct {
			CriAtomExAisacControlId	control_id;			/*JP< AISACRg[id				*/
			CriFloat32	control_value;					/*JP< AISACRg[l				*/
		} aisac_control_value;
	} target;
	CriAtomExReactDuckerTargetType	target_type;		/*JP< _bJ[̑Ώ				*/
	CriAtomExReactFadeParameter		entry;				/*JP< ωJntF[hp[^[		*/
	CriAtomExReactFadeParameter		exit;				/*JP< ωItF[hp[^[		*/
	CriAtomExReactHoldType			hold_type;			/*JP< z[h^Cv					*/
	CriUint16						hold_time_ms;		/*JP< z[hԁi~bj			*/
} CriAtomExReactDuckerParameter;

/*JP
 * \brief AISACW[VgK[p[^[\
 * \ingroup ATOMEXLIB_CATEGORY
 * \par :
 * AISACW[VgK[̋쓮p[^[ݒ擾邽߂̍\̂łB
 * \sa CriAtomExReactParameter, criAtomExCategory_SetReactParameter, criAtomExCategory_GetReactParameter
 */
typedef struct CriAtomExReactAisacModulationParameterTag {
	CriBool		enable_decrement_aisac_modulation_key;	/*JP< ωAISACW[VL[Lۂ	*/
	CriUint32	decrement_aisac_modulation_key;			/*JP< ωAISACW[VL[			*/
	CriBool		enable_increment_aisac_modulation_key;	/*JP< ߂AISACW[VL[Lۂ	*/
	CriUint32	increment_aisac_modulation_key;			/*JP< ߂AISACW[VL[			*/
} CriAtomExReactAisacModulationParameter;

/*JP
 * \brief REACT쓮p[^[\
 * \ingroup ATOMEXLIB_CATEGORY
 * \par :
 * REACT̋쓮p[^[ݒ擾邽߂̍\̂łB<br>
 * ::criAtomExCategory_SetReactParameter , ::criAtomExCategory_GetReactParameter ֐ɈƂēn܂B<br>
 * \sa criAtomExCategory_SetReactParameter, criAtomExCategory_GetReactParameter
 */
typedef struct CriAtomExReactParameterTag {
	union {
		CriAtomExReactDuckerParameter			ducker;				/*JP< _bJ[p[^[						*/
		CriAtomExReactAisacModulationParameter	aisac_modulation;	/*JP< AISACW[VgK[p[^[	*/
	} parameter;
	CriAtomExReactType	type;										/*JP< REACT^Cv							*/
	CriBool				enable_pausing_cue;							/*JP< |[ỸL[͓Kp邩				*/
} CriAtomExReactParameter;

/*JP
 * \brief REACTXe[^X
 * \ingroup ATOMEXLIB_CATEGORY
 * \par :
 * REACT̓ԂlłB<br>
 * \sa criAtomExCategory_SetReactParameter
 */
typedef enum CriAtomExReactStatusTag {
	CRIATOMEX_REACT_STATUS_STOP = 0,	/*JP< ~	*/
	CRIATOMEX_REACT_STATUS_FADEOUT,		/*JP< Jn	*/
	CRIATOMEX_REACT_STATUS_HOLD,		/*JP< p	*/
	CRIATOMEX_REACT_STATUS_FADEIN,		/*JP< I	*/
	CRIATOMEX_REACT_STATUS_ERROR,		/*JP< G[	*/
	/* enum size is 4bytes */
	CRIATOMEX_REACT_STATUS_ENUM_SIZE_IS_4BYTES = 0x7FFFFFFF
} CriAtomExReactStatus;

/*==========================================================================
 *      CRI AtomEx ACB API
 *=========================================================================*/
struct CriAtomExAcbTag;
typedef struct CriAtomExAcbTag CriAtomExAcbObj;
/*JP
 * \brief ACBnh
 * \ingroup ATOMEXLIB_ACB
 * \par :
 * L[V[gǗnhłB<br>
 * ::criAtomExAcb_LoadAcbFile ֐œǂݍ񂾃L[V[gt@C
 * ĐꍇA{nhƃL[IDv[[ɑ΂ăZbg܂B<br>
 * \sa criAtomExAcb_LoadAcbFile, criAtomExPlayer_SetCueId
 */
typedef CriAtomExAcbObj *CriAtomExAcbHn;

/*JP
 * \brief L[ID
 * \ingroup ATOMEXLIB_ACB
 * \par :
 * L[ID́A[UI[TOc[ŃL[ɑ΂Ċ蓖ĂӂIDłB<br>
 * L[IDvOŕێۂɂ́A{ϐ^pĒl舵Kv܂B<br>
 * \sa criAtomExPlayer_SetCueId
 */
typedef CriSint32 CriAtomExCueId;

/*JP
 * \brief L[CfbNX
 * \ingroup ATOMEXLIB_ACB
 * \par :
 * L[CfbNX́AACBt@C̃Rec̃ItZbgԍłB<br>
 * i擪̃Rec0ԁA̎̃Rec1ԁcƂӂɁARec
 * ԂɊ蓖ĂԍłBj<br>
 * L[CfbNXvOŕێۂɂ́A{ϐ^pĒl舵Kv܂B<br>
 * \sa criAtomExPlayer_SetCueIndex
 */
typedef CriSint32 CriAtomExCueIndex;

/*JP
 * \brief ACB
 * \ingroup ATOMEXLIB_ACB
 * \par :
 * ACBf[^̊ełB<br>
 * \sa criAtomExAcb_GetAcbInfo
 */
typedef struct CriAtomExAcbInfoTag {
	const CriChar8* name;							/*JP< O						*/
	CriUint32 size;									/*JP< TCY					*/
	CriUint32 version;								/*JP< ACBo[W				*/
	CriAtomExCharacterEncoding character_encoding;	/*JP< R[h				*/
	CriFloat32 volume;								/*JP< L[V[g{[	*/
	CriSint32 num_cues;								/*JP< L[					*/
} CriAtomExAcbInfo;

/*JP
 * \brief g`
 * \ingroup ATOMEXLIB_ACB
 * \par :
 * g`́AeL[Đ鉹g`̏ڍ׏łB<br>
 * \sa criAtomExAcb_GetWaveformInfoById, criAtomExAcb_GetWaveformInfoByName
 */
/* Waveform information */
typedef struct CriAtomExWaveformInfoTag {
	CriAtomExWaveId wave_id;	/*JP< g`f[^ID			*/
	CriAtomExFormat format;		/*JP< tH[}bg		*/
	CriSint32 sampling_rate;	/*JP< TvOg	*/
	CriSint32 num_channels;		/*JP< `l			*/
	CriSint64 num_samples;		/*JP< g[^Tv	*/
	CriBool streaming_flag;		/*JP< Xg[~OtO	*/
	CriUint32 reserved[1];		/*JP< \̈				*/
} CriAtomExWaveformInfo;

/*JP
 * \brief L[^Cv
 * \ingroup ATOMEXLIB_ACB
 * \sa CriAtomExCueInfo
 */
typedef enum CriAtomExAcbCueTypeTag {
	CRIATOMEXACB_CUE_TYPE_POLYPHONIC = (0),		/*JP< |tHjbN											*/
	CRIATOMEXACB_CUE_TYPE_SEQUENTIAL,			/*JP< V[PV											*/
	CRIATOMEXACB_CUE_TYPE_SHUFFLE,				/*JP< VbtĐ											*/
	CRIATOMEXACB_CUE_TYPE_RANDOM,				/*JP< _													*/
	CRIATOMEXACB_CUE_TYPE_RANDOM_NO_REPEAT,		/*JP< _AiOĐȊO_ɖ炷j	*/
	CRIATOMEXACB_CUE_TYPE_SWITCH_GAME_VARIABLE,	/*JP< XCb`ĐiQ[ϐQƂčĐgbN̐؂ւj	*/
	CRIATOMEXACB_CUE_TYPE_COMBO_SEQUENTIAL,		/*JP< R{V[PViuR{ԁvɘAR{܂ƃV[PVAŌ܂łƁuR{[vobNvn_ɖ߂j*/
	CRIATOMEXACB_CUE_TYPE_SWITCH_SELECTOR,		/*JP< XCb`ĐiZN^[QƂčĐgbN؂ւj	*/
	CRIATOMEXACB_CUE_TYPE_TRACK_TRANSITION_BY_SELECTOR,		/*JP< gbNgWVĐiZN^[QƂčĐgbN؂ւj	*/
	/* enum size is 4bytes */
	CRIATOMEXACB_CUE_TYPE_ENUM_SIZE_IS_4BYTES = 0x7FFFFFFF
} CriAtomExAcbCueType;

/*JP
 * \brief L[3D
 * \ingroup ATOMEXLIB_ACB
 * \par :
 * g`́AL[3Dڍ׏łB<br>
 * \sa CriAtomExCueInfo
 */
typedef struct CriAtomExCuePos3dInfoTag {
	CriFloat32 cone_inside_angle;		/*JP< R[px				*/
	CriFloat32 cone_outside_angle;		/*JP< R[Opx				*/
	CriFloat32 min_distance;			/*JP< ŏ					*/
	CriFloat32 max_distance;			/*JP< ő匸					*/
	CriFloat32 source_radius;			/*JP< ZeroInteriorPanKp	*/
	CriFloat32 interior_distance;		/*JP< InteriorPanKpE		*/
	CriFloat32 doppler_factor;			/*JP< hbv[W				*/
	struct {
		CriBool follows_original_source;	/*JP< 3DɒǏ]邩ǂ */
		CriSint32 calculation_type;			/*JP< ʒuW̎Zo@ */
		CriFloat32 calculation_parameters[CRIATOMEX3DSOURCE_MAX_RANDOM_POSITION_CALCULATION_PARAMETERS];	/*JP< ʒuW̎Zo@Ɋւep[^[z */
	} random_position;
	CriAtomExAisacControlId distance_aisac_control;					/*JP< AISACRg[		*/
	CriAtomExAisacControlId listener_base_angle_aisac_control;		/*JP< Xi[ʊpAISACRg[	*/
	CriAtomExAisacControlId source_base_angle_aisac_control;		/*JP< ʊpAISACRg[		*/
	CriAtomExAisacControlId listener_base_elevation_aisac_control;	/*JP< Xi[pAISACRg[	*/
	CriAtomExAisacControlId source_base_elevation_aisac_control;	/*JP< pAISACRg[		*/
} CriAtomExCuePos3dInfo;

/*JP
 * \brief L[
 * \ingroup ATOMEXLIB_ACB
 * \par :
 * L[̏ڍ׏łB<br>
 * \sa criAtomExAcb_GetCueInfoByName, criAtomExAcb_GetCueInfoById, criAtomExAcb_GetCueInfoByIndex
 */
typedef struct CriAtomExCueInfoTag {
	CriAtomExCueId id;					/*JP< L[ID				*/
	CriAtomExAcbCueType type;			/*JP< ^Cv				*/
	const CriChar8* name;				/*JP< L[				*/
	const CriChar8* user_data;			/*JP< [U[f[^		*/
	CriSint64 length;					/*JP< (msec)			*/
	CriUint16 categories[CRIATOMEXCATEGORY_MAX_CATEGORIES_PER_PLAYBACK];			/*JP< JeSCfbNX	*/
	CriSint16 num_limits;				/*JP< L[~bg		*/
	CriUint16 num_blocks;				/*JP< ubN			*/
	CriUint16 num_tracks;				/*JP< gbN			*/
	CriUint16 num_related_waveforms;	/*JP< ֘Ag`		*/
	CriUint8 priority;					/*JP< vCIeB		*/
	CriUint8 header_visibility;			/*JP< wb_[JtO	*/
	CriUint8 ignore_player_parameter;	/*JP< v[[p[^[tO	*/
	CriUint8 probability;				/*JP< Đm				*/
	CriAtomExPanType pan_type;			/*JP< p^Cv			*/
	CriAtomExCuePos3dInfo pos3d_info;	/*JP< 3D				*/
	CriAtomExGameVariableInfo game_variable_info;	/*JP< Q[ϐiXCb`ϐ̂݁j	*/
	CriFloat32 volume;					/*JP< {[			*/
	CriAtomExSilentMode silent_mode;    /*JP< [h			*/
	CriFloat32 pitch;					/*JP< sb`			*/
	CriUint16 selector_index;			/*JP< ZN^[CfbNXiXCb`ϐ̂݁j		*/
	CriUint16 reserved[1];				/*JP< \̈				*/
} CriAtomExCueInfo;

/*JP
 * \brief ACBnhR[obN֐^
 * \ingroup ATOMEXLIB_ACB
 * \param[in]	obj					[UwIuWFNg
 * \param[in]	acb_hn				ACBnh
 * \return		CriBool				񋓂𑱂邩ǂiCRI_TRUEFpACRI_FALSEF~j
 * \par :
 * ACBnh̒ʒmɎgpAR[obN֐̌^łB<br>
 * ::criAtomExAcb_EnumerateHandles ֐ɖ{֐^̃R[obN֐o^邱ƂŁA
 * ACBnhR[obNoRŎ󂯎邱Ƃ\łB<br>
 * \attention
 * ACBnhR[obN֐ŔjĂ͂܂B<br>
 * \sa criAtomExAcb_EnumerateHandles, CriAtomExAcbHn
 */
typedef CriBool (CRIAPI *CriAtomExAcbHandleCbFunc)(void *obj, CriAtomExAcbHn acb_hn);

/*JP
 * \brief CQ[vr[pf[^̃[hmR[obN֐
 * \ingroup ATOMEXLIB_ACB
 * \par :
 * \param[in]	obj			[UwIuWFNg
 * \param[in]	acb_name	ACB
 * \return					Ȃ
 * \par :
 * CQ[vr[pf[^̃[hmꍇɌĂяoR[obN֐łB<br>
 * CQ[vr[pf[^gpĂ邩ۂɎgp܂B<br>
 * <br>
 * R[obN֐̓o^ɂ ::criAtomExAcb_SetDetectionInGamePreviewDataCallback ֐gp܂B<br>
 * o^R[obN֐́AACB[h֐ACB̓e͂s^C~OŎs܂B<br>
 * \attention
 * {IɁAR[obN֐łAtomCuAPIgpȂłB<br>
 * {R[obN֐ŒԏubNƁA؂ꓙ̖肪܂̂ŁA
 * ӂB<br>
 * \sa criAtomExAcb_SetDetectionInGamePreviewDataCallback
 */
typedef void (CRIAPI *CriAtomExAcbDetectionInGamePreviewDataCbFunc)(
	void *obj, const CriChar8* acb_name);

/*==========================================================================
 *      CRI AtomEx Voice Pool API
 *=========================================================================*/
struct CriAtomExVoicePoolTag;
typedef struct CriAtomExVoicePoolTag CriAtomExVoicePoolObj;
/*JP
 * \brief {CXv[nh
 * \ingroup ATOMEXLIB_VOICE_POOL
 * \par :
 * {CXv[𐧌䂷邽߂̃nhłB<br>
 * ::criAtomExVoicePool_AllocateStandardVoicePool ֐Ń{CXv[쐬ہA
 * ֐̖߂lƂĕԂ܂B<br>
 * {CXv[nh́A{CXv[̏擾A{CXv[
 * ۂɎgp܂B
 * \sa criAtomExVoicePool_AllocateStandardVoicePool, criAtomExVoicePool_Free
 */
typedef struct CriAtomExVoicePoolTag *CriAtomExVoicePoolHn;

/*JP
 * \brief {CXv[ʎq
 * \ingroup ATOMEXLIB_VOICE_POOL
 * \par :
 * {CXv[ʎq́A{CXv[ӂɎʂ邽߂IDłB<br>
 * {CXv[ʎqvOŕێۂɂ́A
 * {ϐ^pĒl舵Kv܂B<br>
 * \par l
 * {CXv[ʎq́Aȉ2ɑ΂Ďw肷Kv܂B<br>
 * 	- {CXv[i{CXv[쐬pRtBO\̂Ŏwj
 * 	- v[[icriAtomExPlayer_SetVoicePoolIdentifier ֐Ŏwj
 * {CXv[ƃv[[̗Ɏʎqݒ肷邱ƂŁA
 * Yv[[͓Y{CXv[̂݃{CX擾悤ɂȂ܂B<br>
 * <br>
 * ̃{CXv[ɓ̃{CXv[ʎqw肷邱Ƃ\łB<br>
 * \sa CriAtomExStandardVoicePoolConfig, criAtomExPlayer_SetVoicePoolIdentifier
 */
typedef CriUint32 CriAtomExVoicePoolIdentifier;

/*JP
 * \brief W{CXv[쐬pRtBO\
 * \ingroup ATOMEXLIB_VOICE_POOL
 * \par :
 * W{CXv[̎dlw肷邽߂̍\̂łB<br>
 * ::criAtomExVoicePool_AllocateStandardVoicePool ֐ɈƂēn܂B<br>
 * v[ł{CX̍ő吔 ::CRIATOMEX_MAX_VOICES_PER_POOL ŁA
 * ŏ ::CRIATOMEX_MIN_VOICES_PER_POOL łB<br>
 * \attention
 * IɃo\邽߁A ::criAtomExVoicePool_SetDefaultConfigForStandardVoicePool
 * }NgpȂꍇɂ́AgpOɕK\̂[NAĂB<br>
 * i\̂̃oɕslȂ悤ӂBj
 * \sa criAtomExVoicePool_AllocateStandardVoicePool, criAtomExVoicePool_SetDefaultConfigForStandardVoicePool
 */
typedef struct CriAtomExStandardVoicePoolConfigTag {
	CriAtomExVoicePoolIdentifier identifier;	/*JP< {CXv[ʎq	*/
	CriSint32 num_voices;						/*JP< v[{CX̐	*/
	CriAtomStandardPlayerConfig player_config;	/*JP< {CX̎dl			*/
	CriBool is_streaming_only;					/*JP< Xg[Đpǂ	*/
	CriSint32 min_channels;						/*JP< ŏ`l		*/
} CriAtomExStandardVoicePoolConfig;

/*JP
 * \brief ADX{CXv[쐬pRtBO\
 * \ingroup ATOMEXLIB_VOICE_POOL
 * \par :
 * ADX{CXv[̎dlw肷邽߂̍\̂łB<br>
 * ::criAtomExVoicePool_AllocateAdxVoicePool ֐ɈƂēn܂B<br>
 * v[ł{CX̍ő吔 ::CRIATOMEX_MAX_VOICES_PER_POOL ŁA
 * ŏ ::CRIATOMEX_MIN_VOICES_PER_POOL łB<br>
 * \attention
 * IɃo\邽߁A ::criAtomExVoicePool_SetDefaultConfigForAdxVoicePool
 * }NgpȂꍇɂ́AgpOɕK\̂[NAĂB<br>
 * i\̂̃oɕslȂ悤ӂBj
 * \sa criAtomExVoicePool_AllocateAdxVoicePool, criAtomExVoicePool_SetDefaultConfigForAdxVoicePool
 */
typedef struct CriAtomExAdxVoicePoolConfigTag {
	CriAtomExVoicePoolIdentifier identifier;	/*JP< {CXv[ʎq	*/
	CriSint32 num_voices;						/*JP< v[{CX̐	*/
	CriAtomAdxPlayerConfig player_config;		/*JP< {CX̎dl			*/
	CriBool is_streaming_only;					/*JP< Xg[Đpǂ	*/
	CriSint32 min_channels;						/*JP< ŏ`l		*/
} CriAtomExAdxVoicePoolConfig;

/*JP
 * \brief HCA{CXv[쐬pRtBO\
 * \ingroup ATOMEXLIB_VOICE_POOL
 * \par :
 * HCA{CXv[̎dlw肷邽߂̍\̂łB<br>
 * ::criAtomExVoicePool_AllocateHcaVoicePool ֐ɈƂēn܂B<br>
 * v[ł{CX̍ő吔 ::CRIATOMEX_MAX_VOICES_PER_POOL ŁA
 * ŏ ::CRIATOMEX_MIN_VOICES_PER_POOL łB<br>
 * \attention
 * IɃo\邽߁A ::criAtomExVoicePool_SetDefaultConfigForHcaVoicePool
 * }NgpȂꍇɂ́AgpOɕK\̂[NAĂB<br>
 * i\̂̃oɕslȂ悤ӂBj
 * \sa criAtomExVoicePool_AllocateHcaVoicePool, criAtomExVoicePool_SetDefaultConfigForHcaVoicePool
 */
typedef struct CriAtomExHcaVoicePoolConfigTag {
	CriAtomExVoicePoolIdentifier identifier;	/*JP< {CXv[ʎq	*/
	CriSint32 num_voices;						/*JP< v[{CX̐	*/
	CriAtomHcaPlayerConfig player_config;		/*JP< {CX̎dl			*/
	CriBool is_streaming_only;					/*JP< Xg[Đpǂ	*/
	CriSint32 min_channels;						/*JP< ŏ`l		*/
} CriAtomExHcaVoicePoolConfig;

/*JP
 * \brief HCA-MX{CXv[쐬pRtBO\
 * \ingroup ATOMEXLIB_VOICE_POOL
 * \par :
 * HCA-MX{CXv[̎dlw肷邽߂̍\̂łB<br>
 * ::criAtomExVoicePool_AllocateHcaMxVoicePool ֐ɈƂēn܂B<br>
 * v[ł{CX̍ő吔 ::CRIATOMEX_MAX_VOICES_PER_POOL ŁA
 * ŏ ::CRIATOMEX_MIN_VOICES_PER_POOL łB<br>
 * \attention
 * IɃo\邽߁A ::criAtomExVoicePool_SetDefaultConfigForHcaMxVoicePool
 * }NgpȂꍇɂ́AgpOɕK\̂[NAĂB<br>
 * i\̂̃oɕslȂ悤ӂBj
 * \sa criAtomExVoicePool_AllocateHcaMxVoicePool, criAtomExVoicePool_SetDefaultConfigForHcaMxVoicePool
 */
typedef struct CriAtomExHcaMxVoicePoolConfigTag {
	CriAtomExVoicePoolIdentifier identifier;	/*JP< {CXv[ʎq	*/
	CriSint32 num_voices;						/*JP< v[{CX̐	*/
	CriAtomHcaMxPlayerConfig player_config;		/*JP< {CX̎dl			*/
	CriBool is_streaming_only;					/*JP< Xg[Đpǂ	*/
	CriSint32 min_channels;						/*JP< ŏ`l		*/
} CriAtomExHcaMxVoicePoolConfig;

/*JP
 * \brief Wave{CXv[쐬pRtBO\
 * \ingroup ATOMEXLIB_VOICE_POOL
 * \par :
 * Wave{CXv[̎dlw肷邽߂̍\̂łB<br>
 * ::criAtomExVoicePool_AllocateWaveVoicePool ֐ɈƂēn܂B<br>
 * v[ł{CX̍ő吔 ::CRIATOMEX_MAX_VOICES_PER_POOL ŁA
 * ŏ ::CRIATOMEX_MIN_VOICES_PER_POOL łB<br>
 * \attention
 * IɃo\邽߁A ::criAtomExVoicePool_SetDefaultConfigForWaveVoicePool
 * }NgpȂꍇɂ́AgpOɕK\̂[NAĂB<br>
 * i\̂̃oɕslȂ悤ӂBj
 * \sa criAtomExVoicePool_AllocateWaveVoicePool, criAtomExVoicePool_SetDefaultConfigForWaveVoicePool
 */
typedef struct CriAtomExWaveVoicePoolConfigTag {
	CriAtomExVoicePoolIdentifier identifier;	/*JP< {CXv[ʎq	*/
	CriSint32 num_voices;						/*JP< v[{CX̐	*/
	CriAtomWavePlayerConfig player_config;		/*JP< {CX̎dl			*/
	CriBool is_streaming_only;					/*JP< Xg[Đpǂ	*/
	CriSint32 min_channels;						/*JP< ŏ`l		*/
} CriAtomExWaveVoicePoolConfig;

/*JP
 * \brief AIFF{CXv[쐬pRtBO\
 * \ingroup ATOMEXLIB_VOICE_POOL
 * \par :
 * AIFF{CXv[̎dlw肷邽߂̍\̂łB<br>
 * ::criAtomExVoicePool_AllocateAiffVoicePool ֐ɈƂēn܂B<br>
 * v[ł{CX̍ő吔 ::CRIATOMEX_MAX_VOICES_PER_POOL ŁA
 * ŏ ::CRIATOMEX_MIN_VOICES_PER_POOL łB<br>
 * \attention
 * IɃo\邽߁A ::criAtomExVoicePool_SetDefaultConfigForAiffVoicePool
 * }NgpȂꍇɂ́AgpOɕK\̂[NAĂB<br>
 * i\̂̃oɕslȂ悤ӂBj
 * \sa criAtomExVoicePool_AllocateAiffVoicePool, criAtomExVoicePool_SetDefaultConfigForAiffVoicePool
 */
typedef struct CriAtomExAiffVoicePoolConfigTag {
	CriAtomExVoicePoolIdentifier identifier;	/*JP< {CXv[ʎq	*/
	CriSint32 num_voices;						/*JP< v[{CX̐	*/
	CriAtomAiffPlayerConfig player_config;		/*JP< {CX̎dl			*/
	CriBool is_streaming_only;					/*JP< Xg[Đpǂ	*/
	CriSint32 min_channels;						/*JP< ŏ`l		*/
} CriAtomExAiffVoicePoolConfig;

/*JP
 * \brief RawPCM{CXv[쐬pRtBO\
 * \ingroup ATOMEXLIB_VOICE_POOL
 * \par :
 * RawPCM{CXv[̎dlw肷邽߂̍\̂łB<br>
 * ::criAtomExVoicePool_AllocateRawPcmVoicePool ֐ɈƂēn܂B<br>
 * v[ł{CX̍ő吔 ::CRIATOMEX_MAX_VOICES_PER_POOL ŁA
 * ŏ ::CRIATOMEX_MIN_VOICES_PER_POOL łB<br>
 * \attention
 * IɃo\邽߁A ::criAtomExVoicePool_SetDefaultConfigForRawPcmVoicePool
 * }NgpȂꍇɂ́AgpOɕK\̂[NAĂB<br>
 * i\̂̃oɕslȂ悤ӂBj
 * \sa criAtomExVoicePool_AllocateRawPcmVoicePool, criAtomExVoicePool_SetDefaultConfigForRawPcmVoicePool
 */
typedef struct CriAtomExRawPcmVoicePoolConfigTag {
	CriAtomExVoicePoolIdentifier identifier;	/*JP< {CXv[ʎq	*/
	CriSint32 num_voices;						/*JP< v[{CX̐	*/
	CriAtomRawPcmPlayerConfig player_config;		/*JP< {CX̎dl			*/
} CriAtomExRawPcmVoicePoolConfig;

/*JP
 * \brief CXgDg{CXv[쐬pRtBO\
 * \ingroup ATOMEXLIB_VOICE_POOL
 * \par :
 * CXgDg{CXv[̎dlw肷邽߂̍\̂łB<br>
 * :: criAtomExVoicePool_AllocateInstrumentVoicePool ֐ɈƂēn܂B<br>
 * v[ł{CX̍ő吔 ::CRIATOMEX_MAX_VOICES_PER_POOL ŁA
 * ŏ ::CRIATOMEX_MIN_VOICES_PER_POOL łB<br>
 * \attention
 * IɃo\邽߁A ::criAtomExVoicePool_SetDefaultConfigForInstrumentVoicePool
 * }NgpȂꍇɂ́AgpOɕK\̂[NAĂB<br>
 * i\̂̃oɕslȂ悤ӂBj
 * \sa criAtomExVoicePool_AllocateInstrumentVoicePool, criAtomExVoicePool_SetDefaultConfigForInstrumentVoicePool
 */
typedef struct CriAtomExInstrumentVoicePoolConfigTag {
	CriAtomExVoicePoolIdentifier identifier;		/*JP< {CXv[ʎq	*/
	CriSint32 num_voices;							/*JP< v[{CX̐	*/
	CriAtomInstrumentPlayerConfig player_config;	/*JP< {CX̎dl			*/
} CriAtomExInstrumentVoicePoolConfig;

/*JP
 * \brief {CXv[R[obN֐^
 * \ingroup ATOMEXLIB_VOICE_POOL
 * \param[in]	obj					[UwIuWFNg
 * \param[in]	pool				{CXv[nh
 * \par :
 * {CXv[̗񋓂ɎgpAR[obN֐̌^łB<br>
 * ::criAtomExVoicePool_EnumerateVoicePools ֐ɖ{֐^̃R[obN֐o^邱ƂŁA
 * 쐬ς݃{CXv[R[obNŎ󂯎邱Ƃ\ƂȂ܂B<br>
 * <br>
 * {R[obN֐ŒԏubNƁA؂ꓙ̖肪܂̂ŁA
 * ӂB<br>
 * \sa criAtomExVoicePool_EnumerateVoicePools
 */
typedef void(CRIAPI* CriAtomExVoicePoolCbFunc)(void* obj, CriAtomExVoicePoolHn pool);

/*==========================================================================
 *      CRI AtomEx Input Port API
 *=========================================================================*/
/*JP
 * \brief ̓|[g
 * \ingroup ATOMEXLIB_INPUT_PORT
 */
typedef enum CriAtomExInputPortTypeTag {
	CRIATOMEX_INPUT_PORT_TYPE_NONE = 0,
	CRIATOMEX_INPUT_PORT_TYPE_MIC,			/*JP< }CN	*/
	CRIATOMEX_INPUT_PORT_TYPE_AUX,			/*JP< AUX		*/
	CRIATOMEX_INPUT_PORT_TYPE_ENUM_IS_4BYTE = 0x7FFFFFFF
} CriAtomExInputPortType;

/*JP
 * \brief ̓|[gnh
 * \ingroup ATOMEXLIB_INPUT_PORT
 * \par :
 * ̓|[g𑀍삷邽߂̃nhłB<br>
 */
typedef void *CriAtomExInputPortHn;

/*==========================================================================
 *      CRI AtomEx Player API
 *=========================================================================*/
/*JP
 * \brief {CXmە
 * \ingroup ATOMEXLIB_PLAYER
 * \par :
 * AtomEx v[[{CXmۂۂ̓dlw肷邽߂̃f[^^łB<br>
 * AtomEx v[[쐬ہA ::CriAtomExPlayerConfig \̂̃oɎw肵܂B<br>
 * \sa CriAtomExPlayerConfig, criAtomExPlayer_Create
 */
typedef enum CriAtomExVoiceAllocationMethodTag {
	CRIATOMEX_ALLOCATE_VOICE_ONCE = 0,		/*JP< {CX̊mۂ1		*/
	CRIATOMEX_RETRY_VOICE_ALLOCATION,		/*JP< {CXJԂmۂ	*/
	CRIATOMEX_VOICE_ALLOCATION_METHOD_IS_4BYTE = 0x7FFFFFFF
} CriAtomExVoiceAllocationMethod;

/*JP
 * \brief v[[쐬pRtBO\
 * \ingroup ATOMEXLIB_PLAYER
 * \par :
 * AtomExv[[쐬ۂɁAdlw肷邽߂̍\̂łB<br>
 * ::criAtomExPlayer_Create ֐̈Ɏw肵܂B<br>
 * <br>
 * 쐬v[[́Anh쐬ɖ{\̂Ŏw肳ꂽݒɉāA
 * \[XKvȂmۂ܂B<br>
 * v[[KvƂ郏[N̈̃TCÝA{\̂Ŏw肳ꂽp[^[ɉĕω܂B
 * \attention
 * IɃo\邽߁A ::criAtomExPlayer_SetDefaultConfig
 * }NgpȂꍇɂ́AgpOɕK\̂[NAĂB<br>
 * i\̂̃oɕslȂ悤ӂBj
 * \sa criAtomExPlayer_Create,  criAtomExPlayer_SetDefaultConfig
 */
typedef struct CriAtomExPlayerConfigTag {
	/*JP
		\brief {CXmە
		\par :
		AtomExv[[{CXmۂۂ̕w肵܂B<br>
		<br>
		voice_allocation_method  CRIATOMEX_ALLOCATE_VOICE_ONCE w肵ꍇA
		AtomExv[[̓{CX̊mۂ𔭉Jñ^C~Oł̂ݍs܂B<br>
		ĐJn_Ń{CXmۂłȂꍇA
		ɂĐɃ{CXDꂽꍇA
		Ɋ֘A郊\[X邽߁A̔g`f[^͂̎_Œ~܂B<br>
		iĐn܂Ȃg`f[^AĐrŒ~ꂽg`f[^A
		ǉ̍ĐNGXgȂɍĐ邱Ƃ͂܂Bj<br>
		<br>
		ɑ΂A voice_allocation_method  CRIATOMEX_RETRY_VOICE_ALLOCATION 
		w肵ꍇAAtomExv[[̓{CX̊mۂKvȌ艽xJԂ܂B<br>
		{CXmۂłȂꍇ{CXDꂽꍇłA
		Ǘ郊\[Xio[`{CXj͉Ȃ̂ŁA
		ēx{CXɋ󂫂ł_ŁAĊJ܂B<br>
		\par l:
		CRIATOMEX_RETRY_VOICE_ALLOCATION w肵ꍇÃ{CX̏ɉA
		sĂȂo[`{CXɂĂIɃ{CX̍Ď擾s邽߁A
		CRIATOMEX_ALLOCATE_VOICE_ONCE w肵ꍇɔׁA
		ׂȂ\܂B<br>
		<br>
		CRIATOMEX_RETRY_VOICE_ALLOCATION w莞A
		{CX̍ĊmۂɐƁAg`f[^<b>Đlʒu</b>V[NĐ܂B<br>
		\attention
		CRIATOMEX_RETRY_VOICE_ALLOCATION w肵 AtomEx v[[쐬ꍇłA
		Atom CuɎw肷 max_virtual_voices 
		̐𒴂ĐvꍇA͍ĊJȂȂ܂B<br>
		iG[R[obN֐ɌxԂAo[`{CX폜܂Bj<br>
		CRIATOMEX_RETRY_VOICE_ALLOCATION w肷ۂɂ́A
		ɕKv[ȃo[`{CXmۂĂB<br>
		i max_virtual_voices ɑ傫߂̒lw肵ĂBj<br>
		<br>
		CRIATOMEX_RETRY_VOICE_ALLOCATION w肵ꍇA
		ĐȂg`f[^{CXDꂽg`f[^A
		ǂĐĊJ邩Aɐ䂷邱Ƃ͂ł܂B<br>
		is^C~Oɂ薈قȂʂɂȂ\܂Bj<br>
	*/
	CriAtomExVoiceAllocationMethod voice_allocation_method;
	
	/*JP
		\brief őpX
		\par :
		AtomExv[[ێpX̐łB<br>
		\par l:
		::criAtomExPlayer_SetFile ֐sƁA
		w肵pXAtomExv[[ɕێ܂B<br>
		AtomExv[[̓ftHgԂł̓pX1ێ܂B<br>
		iTCY팸̂߁Bj<br>
		v[[쐬Ɏw肷 max_path_strings ̐𑝂₹΁A
		AtomExv[[͎w肳ꂽ̃pXۑ悤ɂȂ܂B<br>
		max_path_strings 2ȏ̒lw肷邱ƂŁA
		1̃v[[ŕ̃t@C𓯎ɃpXwōĐ邱Ƃ\ƂȂ܂B<br>
		A max_path_strings ̒lɉĕKvȃ[N̈̃TCY͑܂B<br>
		imax_path_strings~max_pathoCg̃KvƂȂ܂Bj<br>
		\sa criAtomExPlayer_SetDefaultConfig, criAtomExPlayer_SetFile
	*/
	CriSint32 max_path_strings;
	
	/*JP
		\brief őpX
		\par :
		AtomExv[[Ɏw\ȃt@CpX̍ő咷łB<br>
		t@Cw肵ĉ̍ĐsꍇAgppX̍ő咷 max_path 
		ƂĎw肷Kv܂B<br>
		\par l:
		{p[^[́ApbLOĂȂt@CA
		t@Cw肵čĐۂɂ̂݃ZbgKv܂B<br>
		t@Cw̍Đs킸AL[IDg`f[^IDw肵čĐsꍇA
		max_path  0 ɐݒ肷邱Ƃ\łB<br>
		\attention
		::criAtomExPlayer_SetDefaultConfig }N CriAtomExPlayerConfig \̂
		ftHglݒ肵ꍇA max_path ɂ 0 Zbg܂B<br>
		t@Cw肵čĐsꍇA ::criAtomExPlayer_SetDefaultConfig 
		}NgpȂA܂ ::criAtomExPlayer_SetDefaultConfig }Ns
		ɍēxpX̍ő咷ZbgKv܂B<br>
		\sa criAtomExPlayer_SetDefaultConfig, criAtomExPlayer_SetFile
	*/
	CriSint32 max_path;
	
	/*JP
		\brief őAISAC
		\par :
		̃L[ɕRÂ邱ƂłAISAC̍ő吔łB<br>
		AtomCúA AtomExPlayer 쐬
		max_aisacs Ŏw肳ꂽAISACQƂł郊\[Xmۂ܂B<br>
		max_aisacs Ɏw肷l̏55łB
	*/
	CriUint8 max_aisacs;

	/*JP 
		\brief XV̗L
		\par :
		AtomExv[[XVsǂw肵܂B<br>
		\par l:
		updates_time  CRI_FALSE w肵ꍇA
		쐬ꂽAtomExv[[͍Đ̍XVs܂B<br>
		̌ʁA ::criAtomExPlayer_GetTime ֐ɂĐ̎擾͍sȂȂ܂A
		Đׂ̏킸ɉ邱Ƃ\ƂȂ܂B<br>
		\sa criAtomExPlayer_GetTime
	*/
	CriBool updates_time;

	/*JP
		\brief XV̗L
		\par :
		AtomExv[[ĐɓXVsǂw肵܂B<br>
		\par l:
		enable_audio_synced_timer  CRI_TRUE w肵ꍇA
		쐬ꂽAtomExv[[pčĐꂽɑ΂āA
		Đς݃Tvɓ悤ɕ␳Đ̍XVs悤ɂȂ܂B<br>
		␳ꂽĐ ::criAtomExPlayback_GetTimeSyncedWithAudio ֐ɂĎ擾ł܂B<br>
		Đׂ̏オ邽߁AɓmȍĐ擾v[[
		쐬̂ CRI_TRUE w肷悤ɂĂB<br>
		\attention
		{tOLɂꍇAAtomExv[[ɑ΂sb`w肪sȂȂ܂B<br>
		\sa criAtomExPlayback_GetTimeSyncedWithAudio
	*/
	CriBool enable_audio_synced_timer;
} CriAtomExPlayerConfig;

struct CriAtomExPlayerTag;
typedef struct CriAtomExPlayerTag CriAtomExPlayerObj;
/*JP
 * \brief v[[nh
 * \ingroup ATOMEXLIB_PLAYER
 * \par :
 * CriAtomExPlayerHn ́AĐpɍꂽv[[𑀍삷邽߂̃nhłB<br>
 * ::criAtomExPlayer_Create ֐ŉĐp̃v[[쐬ƁA
 * ֐̓v[[pɁA"AtomExv[[nh"Ԃ܂B
 * <br>
 * f[^̃ZbgĐ̊JnAXe[^X̎擾Av[[ɑ΂čśA
 * SAtomExv[[nhĎs܂B<br>
 * \sa criAtomExPlayer_Create
 */
typedef CriAtomExPlayerObj *CriAtomExPlayerHn;

/*JP
 * \brief v[[Xe[^X
 * \ingroup ATOMEXLIB_PLAYER
 * \par :
 * AtomExv[[̍ĐԂlłB<br>
 * ::criAtomExPlayer_GetStatus ֐Ŏ擾\łB<br>
 * <br>
 * ĐԂ́Aʏȉ̏őJڂ܂B<br>
 * -# CRIATOMEXPLAYER_STATUS_STOP
 * -# CRIATOMEXPLAYER_STATUS_PREP
 * -# CRIATOMEXPLAYER_STATUS_PLAYING
 * -# CRIATOMEXPLAYER_STATUS_PLAYEND
 * 
 * AtomExv[[쐬̏Ԃ́A~ԁi CRIATOMEXPLAYER_STATUS_STOP jłB<br>
 * ::criAtomExPlayer_SetData ֐Ńf[^ZbgA ::criAtomExPlayer_Start ֐
 * sƁAĐԁi CRIATOMEXPLAYER_STATUS_PREP jɑJڂAĐn߂܂B<br>
 * f[^[AĐƁAXe[^X͍Đi CRIATOMEXPLAYER_STATUS_PLAYING j
 * ɕςȀo͂Jn܂B<br>
 * Zbgꂽf[^SčĐI_ŁAXe[^X͍Đ
 * i CRIATOMEXPLAYER_STATUS_PLAYEND jɕς܂B
 * \par l
 * AtomExv[[́AAtomv[[ƈقȂA1̃v[[ŕ̍Đ\łB<br>
 * ̂߁AĐAtomExv[[ɑ΂ ::criAtomExPlayer_Start ֐sƁA
 * 2̉dȂčĐ܂B<br>
 * Đ ::criAtomExPlayer_Stop ֐sꍇAAtomExv[[ōĐ̑SẲ
 * ~AXe[^X CRIATOMEXPLAYER_STATUS_STOP ɖ߂܂B<br>
 * i ::criAtomExPlayer_Stop ֐̌Ăяo^C~OɂẮA CRIATOMEXPLAYER_STATUS_STOP 
 * ɑJڂ܂łɎԂꍇ܂Bj<br>
 * <br>
 * 1AtomExv[[ŕ ::criAtomExPlayer_Start ֐sꍇA
 * 1łĐ̉΁AXe[^X CRIATOMEXPLAYER_STATUS_PREP ԂɂȂ܂B<br>
 * iSẲĐ̏ԂɂȂ܂ŁAXe[^X CRIATOMEXPLAYER_STATUS_PLAYING Ԃ
 * Jڂ܂Bj<br>
 * ܂A CRIATOMEXPLAYER_STATUS_PLAYING Ԃ̃v[[ɑ΂Aēx ::criAtomExPlayer_Start 
 * ֐sꍇAXe[^X͈ꎞI CRIATOMEXPLAYER_STATUS_PREP ɖ߂܂B<br>
 * <br>
 * Đɕsȃf[^ǂݍ񂾏ꍇAt@CANZXɎsꍇA
 * Xe[^X CRIATOMEXPLAYER_STATUS_ERROR ɑJڂ܂B<br>
 * ̉Đɂ鉹ŃG[ꍇAv[[̃Xe[^X
 * ̉̏ԂɊ֌WȂA CRIATOMEXPLAYER_STATUS_ERROR ɑJڂ܂B<br>
 * \sa criAtomExPlayer_GetStatus, criAtomExPlayer_SetData, criAtomExPlayer_Start, criAtomExPlayer_Stop
 */
typedef enum CriAtomExPlayerStatusTag {
	CRIATOMEXPLAYER_STATUS_STOP = 0,		/*JP< ~		*/
	CRIATOMEXPLAYER_STATUS_PREP,			/*JP< Đ	*/
	CRIATOMEXPLAYER_STATUS_PLAYING,			/*JP< Đ		*/
	CRIATOMEXPLAYER_STATUS_PLAYEND,			/*JP< Đ		*/
	CRIATOMEXPLAYER_STATUS_ERROR,			/*JP< G[	*/
	CRIATOMEXPLAYER_STATUS_ENUM_SIZE_IS_4BYTES = 0x7FFFFFFF
} CriAtomExPlayerStatus;

/*JP
 * \brief {CX
 * \ingroup ATOMEXLIB_PLAYER
 * \par :
 * AtomExv[[ōĐ鉹̔@w肷邽߂̃f[^^łB<br>
 * ::criAtomExPlayer_SetVoiceControlMethod ֐ŗp܂B<br>
 * \sa criAtomExPlayer_SetVoiceControlMethod
 */
typedef enum CriAtomExVoiceControlMethodTag {
	CRIATOMEX_PREFER_LAST = 0,				/*JP< 㒅D			*/
	CRIATOMEX_PREFER_FIRST = 1,				/*JP< 撅D			*/
	CRIATOMEX_PREFER_DATA = 2,				/*JP< f[^ݒD	*/
	CRIATOMEX_CONTROL_METHOD_ENUM_SIZE_IS_4BYTES = 0x7FFFFFFF
} CriAtomExVoiceControlMethod;

/*JP
 * \brief Xs[J[ID
 * \ingroup ATOMEXLIB_PLAYER
 * \par :
 * o͂Xs[J[w肷邽߂IDłB<br>
 * ::criAtomExPlayer_SetSendLevel ֐ŗp܂B
 * \sa criAtomExPlayer_SetSendLevel
 */
typedef enum CriAtomExSpeakerIdTag {
	CRIATOMEX_SPEAKER_FRONT_LEFT = 0,			/*JP<tgtgXs[J[			*/
	CRIATOMEX_SPEAKER_FRONT_RIGHT = 1,			/*JP<tgCgXs[J[			*/
	CRIATOMEX_SPEAKER_FRONT_CENTER = 2,			/*JP<tgZ^[Xs[J[			*/
	CRIATOMEX_SPEAKER_LOW_FREQUENCY = 3,		/*JP<LFEiTuE[n[j				*/
	CRIATOMEX_SPEAKER_SURROUND_LEFT = 4,		/*JP<TEhtgXs[J[			*/
	CRIATOMEX_SPEAKER_SURROUND_RIGHT = 5,		/*JP<TEhCgXs[J[			*/
	CRIATOMEX_SPEAKER_SURROUND_BACK_LEFT = 6,	/*JP<TEhobNtgXs[J[	*/
	CRIATOMEX_SPEAKER_SURROUND_BACK_RIGHT = 7,	/*JP<TEhobNCgXs[J[	*/

	/* enum size is 4bytes */
	CRIATOMEX_SPEAKER_ENUM_SIZE_IS_4BYTES = 0x7FFFFFFF
} CriAtomExSpeakerId;

/*JP
 * \brief ĐID
 * \ingroup ATOMEXLIB_PLAYER
 * \par :
 * ::criAtomExPlayer_Start ֐sɕԂIDłB<br>
 * v[[Pʂł͂ȂA ::criAtomExPlayer_Start ֐ōĐX̉ɑ΂
 * p[^[ύXԎ擾sꍇA{IDgpĐsKv܂B<br>
 * ȍĐID::CRIATOMEX_INVALID_PLAYBACK_IDłB
 * \sa criAtomExPlayer_Start, criAtomExPlayback_GetStatus, CRIATOMEX_INVALID_PLAYBACK_ID
 */
typedef CriUint32 CriAtomExPlaybackId;

/*JP
 * \brief v[[R[obN֐^
 * \ingroup ATOMEXLIB_PLAYER
 * \param[in]	obj					[UwIuWFNg
 * \param[in]	player				AtomExv[[
 * \par :
 * v[[̗񋓂ɎgpAR[obN֐̌^łB<br>
 * ::criAtomExPlayer_EnumeratePlayers ֐ɖ{֐^̃R[obN֐o^邱ƂŁA
 * AvP[Vō쐬v[[R[obNŎ󂯎邱Ƃ\ƂȂ܂B<br>
 * \attention
 * œnꂽAtomExv[[jĂ͂܂B<br>
 * iANZXᔽnOAbv̏dĂȕs鋰ꂪ܂Bj<br>
 * <br>
 * {R[obN֐ŒԏubNƁA؂ꓙ̖肪܂̂ŁA
 * ӂB<br>
 * \sa criAtomExPlayer_EnumeratePlayers
 */
typedef void (CRIAPI *CriAtomExPlayerCbFunc)(void *obj, CriAtomExPlayerHn player);

/*JP
 * \brief vCobNR[obN֐^
 * \ingroup ATOMEXLIB_PLAYER
 * \param[in]	obj					[UwIuWFNg
 * \param[in]	playback_id			vCobNID
 * \return		CriBool				񋓂𑱂邩ǂiCRI_TRUEFpACRI_FALSEF~j
 * \par :
 * vCobN̗񋓂ɎgpAR[obN֐̌^łB<br>
 * ::criAtomExPlayer_EnumeratePlaybacks ֐ɖ{֐^̃R[obN֐o^邱ƂŁA
 * v[[ōĐ̃vCobNIDR[obNŎ󂯎邱Ƃ\ƂȂ܂B<br>
 * <br>
 * {R[obN֐ŒԏubNƁA؂ꓙ̖肪܂̂ŁA
 * ӂB<br>
 * \sa criAtomExPlayer_EnumeratePlaybacks
 */
typedef CriBool (CRIAPI *CriAtomExPlaybackCbFunc)(void *obj, CriAtomExPlaybackId playback_id);

/*JP
 * \brief f[^vR[obN֐
 * \ingroup ATOMEXLIB_PLAYER
 * \par :
 * \param[in]	obj		[UwIuWFNg
 * \param[in]	id		ĐID
 * \param[in]	player	Atomv[[nh
 * \return				Ȃ
 * \par :
 * ɍĐf[^w肷邽߂̃R[obN֐łB<br>
 * ̉f[^V[XɘAčĐۂɎgp܂B<br>
 * <br>
 * R[obN֐̓o^ɂ ::criAtomExPlayer_SetDataRequestCallback ֐gp܂B<br>
 * o^R[obN֐́A{CXIɎgpĂ Atom v[[
 * AĐp̃f[^v^C~OŎs܂B<br>
 * iÕf[^ǂݍݏIāAɍĐׂf[^v^C~O
 * R[obN֐s܂Bj<br>
 * <br>
 * R[obN֐ ::criAtomPlayer_SetData ֐p Atom v[[Ƀf[^ZbgƁA
 * Zbgꂽf[^͌ݍĐ̃f[^ɑăV[XɘAčĐ܂B<br>
 * ܂A{֐ ::criAtomPlayer_SetPreviousDataAgain ֐s邱ƂŁA
 * f[^JԂĐ邱Ƃ\łB
 * \par l:
 * {֐Ńf[^w肵ȂꍇÃ݂f[^ĐI_ŁA
 * AtomEx v[[̃Xe[^X ::CRIATOMEXPLAYER_STATUS_PLAYEND ɑJڂ܂B<br>
 * <br>
 * ^C~O̖ɂAf[^w肷邱ƂłȂAXe[^X
 * ::CRIATOMEXPLAYER_STATUS_PLAYEND ɑJڂȂꍇɂ́AR[obN֐
 * ::criAtomPlayer_DeferCallback ֐sĂB<br>
 * ::criAtomPlayer_DeferCallback ֐s邱ƂŁA1Vɍēxf[^v
 * R[obN֐Ăяo܂BiR[obNgC\Bj<br>
 * A ::criAtomPlayer_DeferCallback ֐sꍇAĐr؂
 * iAӏɈ莞Ԗj\܂B<br>
 * \attention
 * {R[obN̑ 3 i player j́A AtomEx v[[ł͂ȂA
 * ʃC Atom v[[łB<br>
 * i AtomExPlayerHn ɃLXgƁAANZXᔽ̏dȕs܂Bj<br>
 * <br>
 * ̔g`f[^܂ރL[ĐꍇA
 * ŏɌg`f[^̍ĐI^C~OŃR[obN֐s܂B<br>
 * ̂߁A̔g`f[^܂ރL[ɑ΂ĘAĐ̑sꍇA
 * Ӑ}Ȃgݍ킹Ŕg`AĐ\܂B<br>
 * {@\gpۂɂ́A 1 ̔g`f[^݂̂܂ރL[Đ邩A
 * ܂̓t@CIf[^ĐĂB<br>
 * <br>
 * AR[obN͔g`f[^Đn߂{CXɑ΂Ă̂݊蓖Ă܂B<br>
 * ̂߁Ag`f[^ĐɃ{CXo[`ꍇAR[obN͎s܂B<br>
 * if[^I[ɓB_ŁAR[obNsꂸPLAYENDԂɑJڂ܂Bj<br>
 * <br>
 * {R[obN֐ŁAV[XAĐȊO̐sȂłB<br>
 * R[obN֐AtomCũT[o[s܂B<br>
 * ̂߁AT[o[ւ̊荞݂lȂAPIsꍇA
 * G[AfbhbN\܂B<br>
 * <br>
 * R[obN֐Ŏs\APÍAȉ̂ƂłB<br>
 * 	- criAtomExAcb_GetWaveformInfoByIdiNULLw͕sj
 * 	- criAtomExAcb_GetWaveformInfoByNameiNULLw͕sj
 * 	- criAtomExAcb_GetOnMemoryAwbHandle
 * 	- criAtomExAcb_GetStreamingAwbHandle
 * 	- criAtomPlayer_SetData
 * 	- criAtomPlayer_SetFile
 * 	- criAtomPlayer_SetContentId
 * 	- criAtomPlayer_SetWaveId
 * 	- criAtomPlayer_SetPreviousDataAgain
 * 	- criAtomPlayer_DeferCallback
 * 	
 * <br>
 * {R[obN֐ŒԏubNƁA؂ꓙ̖肪܂̂ŁA
 * ӂB<br>
 * \sa criAtomExPlayer_SetDataRequestCallback, criAtomPlayer_SetData,
 * criAtomPlayer_SetPreviousDataAgain, criAtomPlayer_DeferCallback
 */
typedef void (CRIAPI *CriAtomExPlayerDataRequestCbFunc)(
	void *obj, CriAtomExPlaybackId id, CriAtomPlayerHn player);

/*JP
 * \brief g`tB^[R[obN֐
 * \ingroup ATOMEXLIB_PLAYER
 * \par :
 * \param[in]		obj				[UwIuWFNg
 * \param[in]		id				ĐID
 * \param[in]		format			PCM̌`
 * \param[in]		num_channels	`l
 * \param[in]		num_samples		Tv
 * \param[in,out]	data			PCMf[^̃`lz
 * \return							Ȃ
 * \par :
 * fR[hʂ PCM f[^󂯎R[obN֐łB<br>
 * <br>
 * R[obN֐̓o^ɂ ::criAtomExPlayer_SetFilterCallback ֐gp܂B<br>
 * R[obN֐o^ƁA{CXf[^fR[hxɁA
 * R[obN֐s悤ɂȂ܂B<br>
 * <br>
 * tB^[R[obN֐ɂ́A PCM f[^̃tH[}bg`lA
 * QƉ\ȃTvA PCM f[^i[̈̃AhXԂ܂B<br>
 * R[obNł PCM f[^̒l𒼐ڎQƉ\ɂȂ̂ŁA
 * Đ̉̐U`FbNƂprɗp\łB<br>
 * <br>
 * ܂AR[obN֐ PCM f[^HƁAĐɔf邽߁A
 * PCM f[^ɑ΂ă[UƎ̃GtFNg邱Ƃ\łB<br>
 * iA^CXgb`̂悤ȃf[^ʂHsƂ͂ł܂Bj<br>
 * \par l:
 * PCM f[^̓`lPʂŕĂ܂B<br>
 * iC^[[uĂ܂Bj<br>
 *  6 i data zjɂ́Ae`l PCM f[^z̐擪AhXi[Ă܂B<br>
 * i񎟌z̐擪AhXł͂ȂA`lƂ PCM f[^z̐擪AhXi[
 * ꎟ̃|C^złBj<br>
 * <br>
 * vbgtH[ɂāA PCM f[^̃tH[}bg͈قȂ܂B<br>
 * s̃f[^tH[}bgɂẮA 3 i format jŔʉ\łB<br>
 * PCM f[^̃tH[}bg 16 bit ^̏ꍇA format  CRIATOM_PCM_FORMAT_SINT16 ƂȂA
 * PCM f[^̃tH[}bg 32 bit _^̏ꍇA format  CRIATOM_PCM_FORMAT_FLOAT32 ƂȂ܂B<br>
 * ꂼ̃P[X PCM f[^̒l͈قȂ܂̂łӂB<br>
 * - CRIATOM_PCM_FORMAT_SINT16  -32768 ` +32767
 * - CRIATOM_PCM_FORMAT_FLOAT32  -1.0f ` +1.0f
 * 
 * ifR[h_ł̓NbsOsĂȂ߁A CRIATOM_PCM_FORMAT_FLOAT32 
 * ͏L͈͂킸ɒlo\܂Bj<br>
 * \attention
 * <br>
 * {R[obN֐ŁAAtomCuAPIsȂłB<br>
 * R[obN֐AtomCũT[o[s܂B<br>
 * ̂߁AT[o[ւ̊荞݂lȂAPIsꍇA
 * G[AfbhbN\܂B<br>
 * <br>
 * R[obN֐ŒԏubNƁA؂ꓙ̖肪\܂B<br>
 * \sa criAtomExPlayer_SetFilterCallback
 */
typedef void (CRIAPI *CriAtomExPlayerFilterCbFunc)(
	void *obj, CriAtomExPlaybackId id, CriAtomPcmFormat format,
	CriSint32 num_channels, CriSint32 num_samples, void *data[]);

/*JP
 * \brief ubNgWVR[obN֐
 * \ingroup ATOMEXLIB_PLAYER
 * \par :
 * \param[in]		obj				[UwIuWFNg
 * \param[in]		id				ĐID
 * \param[in]		index			L[̃ubNCfbNXl
 * \return							Ȃ
 * \par :
 * ubNV[PXĐɃubNgWVƂɌĂяoR[obN֐łB<br>
 * <br>
 * R[obN֐̓o^ɂ ::criAtomExPlayer_SetBlockTransitionCallback ֐gp܂B<br>
 * R[obN֐o^ƁAubNgWVxɁA
 * R[obN֐s悤ɂȂ܂B<br>
 * <br>
 * \attention
 * <br>
 * {R[obN֐ŁAAtomCuAPIsȂłB<br>
 * R[obN֐AtomCũT[o[s܂B<br>
 * ̂߁AT[o[ւ̊荞݂lȂAPIsꍇA
 * G[AfbhbN\܂B<br>
 * <br>
 * R[obN֐ŒԏubNƁA؂ꓙ̖肪\܂B<br>
 * \sa criAtomExPlayer_SetBlockTransitionCallback
 */
typedef void (CRIAPI *CriAtomExPlayerBlockTransitionCbFunc)(
	void *obj, CriAtomExPlaybackId id, CriAtomExBlockIndex index);

/*JP
 * \brief ĐgbNpInfo\
 * \ingroup ATOMEXLIB_PLAYER
 */
typedef struct CriAtomExPlaybackTrackInfoTag {
	CriAtomExPlaybackId id;				/*JP< ĐID				*/
	CriAtomExAcbCueType sequence_type;	/*JP< eV[PX^Cv	*/
	CriAtomExPlayerHn player;			/*JP< v[[nh		*/
	CriUint16 track_no;					/*JP< gbNԍ			*/
	CriUint16 reserved[1];				/*JP< \̈				*/
} CriAtomExPlaybackTrackInfo;

/*JP
 * \brief ĐgbN擾R[obN֐
 * \ingroup ATOMEXLIB_PLAYER
 * \par :
 * \param[in]		obj				[UwIuWFNg
 * \param[in]		info			ĐgbN
 * \return							Ȃ
 * \par :
 * |tHjbN^CvAgbNJڃ^CvȊÕL[ĐɍĐgbNʒmR[obN֐łB<br>
 * <br>
 * R[obN֐̓o^ɂ ::criAtomExPlayer_SetPlaybackTrackInfoNotificationCallback ֐gp܂B<br>
 * <br>
 * \attention
 * <br>
 * {R[obN֐ŁAAtomCuAPIsȂłB<br>
 * R[obN֐AtomCũT[o[s܂B<br>
 * ̂߁AT[o[ւ̊荞݂lȂAPIsꍇA
 * G[AfbhbN\܂B<br>
 * <br>
 * R[obN֐ŒԏubNƁA؂ꓙ̖肪\܂B<br>
 * \sa criAtomExPlayer_SetPlaybackTrackInfoNotificationCallback
 */
typedef void (CRIAPI *CriAtomExPlayerPlaybackTrackInfoNotificationCbFunc)(
	void *obj, const CriAtomExPlaybackTrackInfo* info);

/*JP
 * \brief pjOR[obN֐^
 * \ingroup ATOMEXLIB_PLAYER
 * \param[in]	object				[UwIuWFNg
 * \param[in]	input_channels		͉̃`l
 * \param[in]	channel_config		͉̃`l\
 * \param[in]	output_channels		o͐̃`l
 * \param[in]	speaker_mapping		o͐̃Xs[J[}bsO
 * \param[in]	location			̈ʒu
 * \param[in]	parameter			p[^[
 * \param[out]	matrix				Zhx}gNX
 * \return		CriBool				Ǝ̃pjOsǂ
 * \par :
 * pjOp̃R[obN֐̌^łB<br>
 * ::criAtomExPlayer_OverrideDefaultPanMethod ֐s邱ƂŁA
 * R[obN֐̓o^\łB<br>
 * {R[obN֐́ApjO̍ۂɌĂяo܂B<br>
 * AvP[VœƎ̃pjOsꍇɂpB
 * \par ⑫
 * R[obN֐Ăяo_ł́AZhx}gNX̓[NAĂ܂B
 * ̂߁AR[obN֐ŃZhx}gNX[NAKv͂܂B<br>
 * <br>
 * AvP[VŃZhx}gNX𑀍삵ꍇɂ́A
 * ֐̖߂l CRI_TRUE ԂKv܂B<br>
 * CRI_FALSE ԂꍇAR[obNŎw肵Zhx͖A
 * AtomCũftHg̃pjOKp܂B<br>
 * ĩ`l݂̉̂ɓƎ̃pjOsA
 * ftHg̃pjOƓƎ̃pjO؂ւKvꍇɂ́A
 * ߂lŐ䂵ĂBj
 * \attention
 * {R[obN֐ŒԏubNƁA؂ꓙ̖肪܂̂ŁA
 * ӂB<br>
 * \sa criAtomExPlayer_OverrideDefaultPanMethod
 */
typedef CriBool (CRIAPI *CriAtomExPlayerPanCbFunc)(void *object,
	CriSint32 input_channels, CriAtomChannelConfig channel_config,
	CriSint32 output_channels, CriAtomSpeakerMapping speaker_mapping,
	const CriAtomExSphericalCoordinates *location,
	const CriAtomEx3dAttenuationParameter *parameter, CriFloat32 *matrix[]);

/*JP
 * \brief p[^[ID
 * \ingroup ATOMEXLIB_PLAYER
 * \par :
 * p[^[w肷邽߂IDłB<br>
 * ::criAtomExPlayer_GetParameterFloat32 ֐ŗp܂B
 * \sa criAtomExPlayer_GetParameterFloat32, criAtomExPlayer_GetParameterSint32,
 * criAtomExPlayer_GetParameterUint32
 */
typedef enum CriAtomExParameterIdTag {
	CRIATOMEX_PARAMETER_ID_VOLUME					=  0,	/*JP< {[ */
	CRIATOMEX_PARAMETER_ID_PITCH					=  1,	/*JP< sb` */
	CRIATOMEX_PARAMETER_ID_PAN3D_ANGLE				=  2,	/*JP< pjO3Dpx */
	CRIATOMEX_PARAMETER_ID_PAN3D_DISTANCE			=  3,	/*JP< pjO3D */
	CRIATOMEX_PARAMETER_ID_PAN3D_VOLUME				=  4,	/*JP< pjO3D{[ */
	CRIATOMEX_PARAMETER_ID_PAN_TYPE					=  5,	/*JP< p^Cv */
	CRIATOMEX_PARAMETER_ID_PAN_SPEAKER_TYPE			=  6,	/*JP< pXs[J[^Cv */
	CRIATOMEX_PARAMETER_ID_PAN_CH0					=  7,	/*JP< 2Dpi`l0j */
	CRIATOMEX_PARAMETER_ID_PAN_CH1					=  8,	/*JP< 2Dpi`l1j */
	CRIATOMEX_PARAMETER_ID_BUS_SEND_LEVEL_0			=  9,	/*JP< oXZhx0 */
	CRIATOMEX_PARAMETER_ID_BUS_SEND_LEVEL_1			= 10,	/*JP< oXZhx1 */
	CRIATOMEX_PARAMETER_ID_BUS_SEND_LEVEL_2			= 11,	/*JP< oXZhx2 */
	CRIATOMEX_PARAMETER_ID_BUS_SEND_LEVEL_3			= 12,	/*JP< oXZhx3 */
	CRIATOMEX_PARAMETER_ID_BUS_SEND_LEVEL_4			= 13,	/*JP< oXZhx4 */
	CRIATOMEX_PARAMETER_ID_BUS_SEND_LEVEL_5			= 14,	/*JP< oXZhx5 */
	CRIATOMEX_PARAMETER_ID_BUS_SEND_LEVEL_6			= 15,	/*JP< oXZhx6 */
	CRIATOMEX_PARAMETER_ID_BUS_SEND_LEVEL_7			= 16,	/*JP< oXZhx7 */
	CRIATOMEX_PARAMETER_ID_BANDPASS_FILTER_COF_LOW	= 17,	/*JP< ohpXtB^[̒JbgItg */
	CRIATOMEX_PARAMETER_ID_BANDPASS_FILTER_COF_HIGH	= 18,	/*JP< ohpXtB^[̍JbgItg */
	CRIATOMEX_PARAMETER_ID_BIQUAD_FILTER_TYPE		= 19,	/*JP< oCNAbhtB^[̃tB^[^Cv */
	CRIATOMEX_PARAMETER_ID_BIQUAD_FILTER_FREQ		= 20,	/*JP< oCNAbhtB^[̎g */
	CRIATOMEX_PARAMETER_ID_BIQUAD_FILTER_Q			= 21,	/*JP< oCNAbhtB^[Ql */
	CRIATOMEX_PARAMETER_ID_BIQUAD_FILTER_GAIN		= 22,	/*JP< oCNAbhtB^[̃QC */
	CRIATOMEX_PARAMETER_ID_ENVELOPE_ATTACK_TIME		= 23,	/*JP< Gx[ṽA^bN^C */
	CRIATOMEX_PARAMETER_ID_ENVELOPE_HOLD_TIME		= 24,	/*JP< Gx[ṽz[h^C */
	CRIATOMEX_PARAMETER_ID_ENVELOPE_DECAY_TIME		= 25,	/*JP< Gx[ṽfBPC^C */
	CRIATOMEX_PARAMETER_ID_ENVELOPE_RELEASE_TIME	= 26,	/*JP< Gx[ṽ[X^C */
	CRIATOMEX_PARAMETER_ID_ENVELOPE_SUSTAIN_LEVEL	= 27,	/*JP< Gx[ṽTXeBx */
	CRIATOMEX_PARAMETER_ID_START_TIME				= 28,	/*JP< ĐJnʒu */
	CRIATOMEX_PARAMETER_ID_PRIORITY					= 31,	/*JP< {CXvCIeB */
	CRIATOMEX_PARAMETER_ID_SILENT_MODE				= 32,	/*JP< [h */
	CRIATOMEX_PARAMETER_ID_DSP_PARAMETER_0			= 33,	/*JP< CT[VDSP̃p[^[0 */
	CRIATOMEX_PARAMETER_ID_DSP_PARAMETER_1			= 34,	/*JP< CT[VDSP̃p[^[1 */
	CRIATOMEX_PARAMETER_ID_DSP_PARAMETER_2			= 35,	/*JP< CT[VDSP̃p[^[2 */
	CRIATOMEX_PARAMETER_ID_DSP_PARAMETER_3			= 36,	/*JP< CT[VDSP̃p[^[3 */
	CRIATOMEX_PARAMETER_ID_DSP_PARAMETER_4			= 37,	/*JP< CT[VDSP̃p[^[4 */
	CRIATOMEX_PARAMETER_ID_DSP_PARAMETER_5			= 38,	/*JP< CT[VDSP̃p[^[5 */
	CRIATOMEX_PARAMETER_ID_DSP_PARAMETER_6			= 39,	/*JP< CT[VDSP̃p[^[6 */
	CRIATOMEX_PARAMETER_ID_DSP_PARAMETER_7			= 40,	/*JP< CT[VDSP̃p[^[7 */
	CRIATOMEX_PARAMETER_ID_DSP_PARAMETER_8			= 41,	/*JP< CT[VDSP̃p[^[8 */
	CRIATOMEX_PARAMETER_ID_DSP_PARAMETER_9			= 42,	/*JP< CT[VDSP̃p[^[9 */
	CRIATOMEX_PARAMETER_ID_DSP_PARAMETER_10			= 43,	/*JP< CT[VDSP̃p[^[10 */
	CRIATOMEX_PARAMETER_ID_DSP_BYPASS_FLAG			= 44,	/*JP< CT[VDSP̃oCpXtO */

	/* enum size is 4bytes */
	CRIATOMEX_PARAMETER_ID_ENUM_SIZE_IS_4BYTES = 0x7FFFFFFF
} CriAtomExParameterId;

/*==========================================================================
 *      CRI AtomEx Sequencer API
 *=========================================================================*/
/*JP
 * \brief V[PXCxgR[obN
 * \ingroup ATOMEXLIB_SEQUENCER
 * \par :
 * AtomExCũV[PXCxgR[obN^CvłB<br>
 * \sa CriAtomExSequenceEventInfo
 */
typedef enum CriAtomExSequecneEventTypeTag {
	/*JP
	 * \brief V[PXR[obN
	 * \par :
	 * V[PXf[^ɖߍ܂ꂽR[obNCxgB
	 */
	CRIATOMEX_SEQUENCE_EVENT_TYPE_CALLBACK = 0,
		
	/* enum size is 4bytes */
	CRIATOMEX_SEQUENCE_EVENT_TYPE_ENUM_SIZE_IS_4BYTES = 0x7FFFFFFF
} CriAtomExSequecneEventType;

/*JP
 * \brief V[PXR[obNCxgpInfo\
 * \ingroup ATOMEXLIB_SEQUENCER
 */
typedef struct CriAtomExSequenceEventInfoTag {
	CriUint64 position;					/*JP< Cxgʒu			*/
	CriAtomExPlayerHn player;			/*JP< v[[nh		*/
	const CriChar8* string;				/*JP< f[^ߍݕ	*/
	CriAtomExPlaybackId id;				/*JP< ĐID				*/
	CriAtomExSequecneEventType type;	/*JP< Cxg^Cv		*/
	CriUint32 value;					/*JP< f[^ߍݒl		*/
	CriUint32 reserved[1];				/*JP< \̈				*/
} CriAtomExSequenceEventInfo;

/*JP
 * \brief V[PXR[obN
 * \ingroup ATOMEXLIB_SEQUENCER
 * \par :
 * \param[in]	obj		[UwIuWFNg
 * \param[in]	info	V[PXCxg
 * \return				gp
 * AtomExCũV[PXR[obN֐^łB<br>
 * R[obN֐̓o^ɂ ::criAtomExSequencer_SetEventCallback ֐gp܂B<br>
 * o^R[obN֐́AT[o[֐ŃV[PX^C~OŎs܂B<br>
 * ̂߁AT[o[ւ̊荞݂lȂAPIsꍇA
 * G[AfbhbN\܂B<br>
 * {IɁAR[obN֐łAtomCuAPIgpȂłB<br>
 * {R[obN֐ŒԏubNƁA؂ꓙ̖肪܂̂ŁA
 * ӂB<br>
 * \sa criAtomExSequencer_SetEventCallback
 */
typedef CriSint32 (CRIAPI *CriAtomExSequencerEventCbFunc)(void* obj, const CriAtomExSequenceEventInfo* info);

/*==========================================================================
 *      CRI AtomEx Beat Sync API
 *=========================================================================*/
/*JP
 * \brief r[g\
 * \ingroup ATOMEXLIB_BEATSYNC
 */
typedef struct CriAtomExBeatSyncInfoTag {
	CriAtomExPlayerHn player;			/*JP< v[[nh			*/
	CriAtomExPlaybackId playback_id;	/*JP< ĐID					*/
	CriUint32 bar_count;				/*JP< ߐ					*/
	CriUint32 beat_count;				/*JP< 						*/
	CriFloat32 beat_progress;			/*JP< ̐i(0.0f`1.0f)		*/
	CriFloat32 bpm;						/*JP< e|(/)				*/
	CriSint32 offset;					/*JP< ItZbg(ms)		*/
	CriUint32 num_beats;				/*JP< q@@				*/
	const CriChar8* label;				/*JP< r[gx			*/
} CriAtomExBeatSyncInfo;

/*JP
 * \brief r[gʒuoR[obN
 * \ingroup ATOMEXLIB_BEATSYNC
 * \par :
 * \param[in]	obj		[UwIuWFNg
 * \param[in]	info	r[g
 * \return				gp
 * AtomExCũr[gʒuoR[obN֐^łB<br>
 * R[obN֐̓o^ɂ ::criAtomExBeatSync_SetCallback ֐gp܂B<br>
 * o^R[obN֐́AT[o[֐Ńr[gʒuo^C~OŎs܂B<br>
 * ̂߁AT[o[ւ̊荞݂lȂAPIsꍇA
 * G[AfbhbN\܂B<br>
 * {IɁAR[obN֐łAtomCuAPIgpȂłB<br>
 * {R[obN֐ŒԏubNƁA؂ꓙ̖肪܂̂ŁA
 * ӂB<br>
 * \sa criAtomExBeatSync_SetCallback
 */
typedef CriSint32 (CRIAPI *CriAtomExBeatSyncCbFunc)(void* obj, const CriAtomExBeatSyncInfo* info);

/*==========================================================================
 *      CRI AtomEx Playback API
 *=========================================================================*/
/*JP
 * \brief ĐXe[^X
 * \ingroup ATOMEXLIB_PLAYBACK
 * \par :
 * AtomExv[[ōĐς݂̉̃Xe[^XłB<br>
 * ::criAtomExPlayback_GetStatus ֐Ŏ擾\łB<br>
 * <br>
 * ĐԂ́Aʏȉ̏őJڂ܂B<br>
 * -# CRIATOMEXPLAYBACK_STATUS_PREP
 * -# CRIATOMEXPLAYBACK_STATUS_PLAYING
 * -# CRIATOMEXPLAYBACK_STATUS_REMOVED
 * 
 * \par l
 * CriAtomExPlaybackStatusAtomExv[[̃Xe[^Xł͂ȂA
 * v[[ōĐsi ::criAtomExPlayer_Start ֐sj
 * ̃Xe[^XłB<br>
 * <br>
 * Đ̉\[X́A~ꂽ_Ŕj܂B<br>
 * ̂߁Aȉ̃P[XōĐ̃Xe[^X
 * CRIATOMEXPLAYBACK_STATUS_REMOVED ɑJڂ܂B<br>
 * - ĐꍇB
 * - criAtomExPlayback_Stop ֐ōĐ̉~ꍇB
 * - vCIeB̔NGXgɂĐ̃{CXDꂽꍇB
 * - ĐɃG[ꍇB
 * 
 * \sa criAtomExPlayer_Start, criAtomExPlayback_GetStatus, criAtomExPlayback_Stop
 */
typedef enum CriAtomExPlaybackStatusTag {
	CRIATOMEXPLAYBACK_STATUS_PREP = 1,	/*JP< Đ	*/
	CRIATOMEXPLAYBACK_STATUS_PLAYING,	/*JP< Đ		*/
	CRIATOMEXPLAYBACK_STATUS_REMOVED,	/*JP< 폜ꂽ	*/
	CRIATOMEXPLAYBACK_STATUS_ENUM_SIZE_IS_4BYTES = 0x7FFFFFFF
} CriAtomExPlaybackStatus;

/*JP
 * \brief Đ̃^Cv
 * \ingroup ATOMEXLIB_PLAYBACK
 * \par :
 * AtomExv[[ōĐA܂AtomExv[[ōĐ̉́AĐ̃^CvłB<br>
 * \sa CriAtomExSourceInfo
 */
typedef enum CriAtomExSourceTypeTag {
	CRIATOMEX_SOURCE_TYPE_NONE = 0,				/*JP< ݒ					*/
	CRIATOMEX_SOURCE_TYPE_CUE_ID,				/*JP< L[ID					*/
	CRIATOMEX_SOURCE_TYPE_CUE_NAME,				/*JP< L[					*/
	CRIATOMEX_SOURCE_TYPE_CUE_INDEX,			/*JP< L[CfbNX		*/
	CRIATOMEX_SOURCE_TYPE_DATA,					/*JP< If[^			*/
	CRIATOMEX_SOURCE_TYPE_FILE,					/*JP< t@C				*/
	CRIATOMEX_SOURCE_TYPE_CONTENT_ID,			/*JP< CPKRecID			*/
	CRIATOMEX_SOURCE_TYPE_WAVE_ID,				/*JP< f[^ID				*/
	CRIATOMEX_SOURCE_TYPE_VIBRATION_ID,			/*JP< UID					*/
	CRIATOMEX_SOURCE_TYPE_SOUND_GENERATOR_ID,	/*JP< TEhWFl[^ID	*/
	CRIATOMEX_SOURCE_TYPE_RAW_PCM_FLOAT_ID,		/*JP< RawPcmFloatID				*/
	CRIATOMEX_SOURCE_TYPE_INPUT_PORT,			/*JP< ̓|[g				*/
	CRIATOMEX_SOURCE_TYPE_ENUM_SIZE_IS_4BYTES = 0x7FFFFFFF
} CriAtomExSourceType;

/*JP
 * \brief Đ̏
 * \ingroup ATOMEXLIB_PLAYBACK
 * \par :
 * AtomExv[[ōĐ܂͍Đ̉́AĐiĐ^Ăj̏łB<br>
 * ::criAtomExPlayback_GetSource ֐Ŏ擾\łB<br>
 * 擾ɁA::criAtomExAcb_GetCueInfoByIndex ֐𗘗p邱ƂŁA
 * ڍׂȏ擾邱Ƃł܂B
 * \par l
 * Đ̃^CvɂāA擾ł񂪈قȂ܂B<br>
 * typeQƂApsource̒̂ǂ̍\̂ƂăANZX邩IĂB<br>
 * \code
 * CriAtomExSourceInfo source;
 * criAtomExPlayback_GetSource(playback_id, &source);
 * 
 * switch (source.type) {
 * case CRIATOMEXPLAYBACK_SOURCE_TYPE_CUE_ID:
 * 	{
 * 		CriAtomExCueInfo cue_info;
 * 		criAtomExAcb_GetCueInfoById(source.info.cue_id.acb, source.info.cue_id.id, &cue_info);
 *			:
 * 	}
 * 	break;
 * 		:
 * }
 * \endcode
 * \sa criAtomExPlayback_GetSource, criAtomExAcb_GetCueInfoByIndex
 */
typedef struct CriAtomExSourceInfoTag {
	/*JP Đ̃^Cv */
	CriAtomExSourceType type;

	/*JP Đ񋤗p */
	union CriAtomExSourceInfoInfoTag {
		/*JP L[ID */
		struct CriAtomExSourceInfoCueIdTag {
			/*JP ACBnh */
			CriAtomExAcbHn acb;
			/*JP L[ID */
			CriAtomExCueId id;
		} cue_id;
		/*JP L[ */
		struct CriAtomExSourceInfoCueNameTag {
			/*JP ACBnh */
			CriAtomExAcbHn acb;
			/*JP L[ */
			const CriChar8 *name;
		} cue_name;
		/*JP L[CfbNX */
		struct CriAtomExSourceInfoCueIndexTag {
			/*JP ACBnh */
			CriAtomExAcbHn acb;
			/*JP L[CfbNX */
			CriAtomExCueIndex index;
		} cue_index;
		/*JP If[^ */
		struct CriAtomExSourceInfoDataTag {
			/*JP AhX */
			void *buffer;
			/*JP TCY */
			CriSint32 size;
		} data;
		/*JP t@C */
		struct CriAtomExSourceInfoFileTag {
			/*JP oC_[nh */
			CriFsBinderHn binder;
			/*JP t@CpX */
			const CriChar8 *path;
		} file;
		/*JP CPKRecID */
		struct CriAtomExSourceInfoContentIdTag {
			/*JP oC_[nh */
			CriFsBinderHn binder;
			/*JP RecID */
			CriSint32 id;
		} content_id;
		/*JP g`f[^ID */
		struct CriAtomExSourceInfoWaveIdTag {
			/*JP AWBnh */
			CriAtomAwbHn awb;
			/*JP g`f[^ID */
			CriAtomExWaveId id;
		} wave_id;
		/*JP UID */
		struct CriAtomExSourceInfoVibrationIdTag {
			/*JP Uf[^ID */
			CriAtomExVibrationId id;
		} vibration_id;
		struct CriAtomExSourceInfoVibrationNameTag {
			/*JP Uf[^ */
			const CriChar8 *name;
		} vibration_name;
		/* TEhWFl[^ID */
		struct CriAtomExSourceInfoSoundGeneratorParameterTag {
			/*JP g */
			CriFloat32 frequency;
			/*JP g` */
			CriAtomWaveType wave_type;
		} sound_generator_parameter;
		/* RawPCM FloatID */
		struct CriAtomExSourceInfoRawPcmFloatParameterTag {
			/*JP f[^AhX */
			CriFloat32 *data;
			/*JP Tv */
			CriUint32 total_samples;
		} raw_pcm_float_parameter;
		/* ̓|[g */
		struct CriAtomExSourceInfoInputPortTag {
			/*JP ̓|[g^Cv */
			CriAtomExInputPortType type;
			/*JP ̓|[gnh */
			CriAtomExInputPortHn port;
		} input_port;
	} info;
} CriAtomExSourceInfo;

/*JP
 * \brief ĐCxg
 * \ingroup ATOMEXLIB_PLAYBACK
 * \par :
 * ĐCxg̎ʂlłB<br>
 * ĐCxgR[obNɈƂēn܂B<br>
 * \sa CriAtomExPlaybackEventCbFunc, criAtomExPlayer_SetPlaybackEventCallback
 */
typedef enum CriAtomExPlaybackEventTag {
	/*JP
	 * \brief VKĐ\[X̊m
	 * \par :
	 * L[̍ĐɕKvȃ\[XmۂꂽƂlłB<br>
	 * \[Xmێ_ł̓{CX̊蓖Ă͍sĂ炸A
	 * Ă܂io[`Ԃō쐬܂jB
	 */
	CRIATOMEX_PLAYBACK_EVENT_ALLOCATE = 0,
	
	/*JP
	 * \brief {CX̊蓖
	 * \par :
	 * o[`Ԃ̍Đ\[Xɑ΂ă{CX蓖ĂꂽƂlłB<br>
	 * {CX蓖ĂꂽƂŁAL[̔Jn܂B
	 * \par l:
	 * L[ɕ̔g`f[^܂܂ꍇAꂩ1̔g`f[^Đꂽ_Ŗ{Cxg܂B<br>
	 * iL[ĐɊ֘A{CX̐01ɕςuԂɖ{Cxg܂Bj<br>
	 * Ƀ{CX蓖ĂꂽԂŁAɒǉ̃{CX蓖Ă^C~Oł͖{Cxg͔܂B
	 */
	CRIATOMEX_PLAYBACK_EVENT_FROM_VIRTUAL_TO_NORMAL,
	
	/*JP
	 * \brief o[`
	 * \par :
	 * L[̍Đo[`ꂽƂlłB<br>
	 * ȉ̂ꂩ̗vɂÃL[{CX؂藣ꂽꍇɔ܂B<br>
	 * - L[Ɋ܂܂g`f[^I[܂ōĐ߁A{CXsvɂȂ
	 * - ::criAtomExPlayer_Stop ֐̌ĂяoɂAĐ̔g`f[^~ꂽ
	 * - vCIeBɂAĐ̔g`f[^~A{CXDꂽ
	 * 
	 * \par l:
	 * {CxǵAL[Ɋ܂܂"g`f[^"ĐȂȂԂ܂B<br>
	 * {Cxg_ł́AL[̍Đ͏IĂ܂B<br>
	 * iL[̍ĐIۂɂ́Aʓr ::CRIATOMEX_PLAYBACK_EVENT_REMOVE Cxg܂Bj<br>
	 * <br>
	 * L[ɕ̔g`f[^܂܂ꍇASĂ̔g`f[^ĐȂȂ_Ŗ{Cxg܂B<br>
	 * iL[ĐɊ֘A{CX̐10ɕςuԂɖ{Cxg܂Bj<br>
	 * ̃{CX蓖ĂꂽԂł̂1~ꂽꍇɂ́A{Cxg͔܂B
	 */
	CRIATOMEX_PLAYBACK_EVENT_FROM_NORMAL_TO_VIRTUAL,
	
	/*JP
	 * \brief Đ\[X̉
	 * \par :
	 * Đ\[XꂽƂlłB<br>
	 * L[̍ĐۂAĐ~vɂL[~ꂽꍇɖ{Cxg܂B
	 * \par l:
	 * L[Ɋ܂܂g`f[^ĐĂꍇA
	 * {CxgOɁAK ::CRIATOMEX_PLAYBACK_EVENT_FROM_NORMAL_TO_VIRTUAL Cxg܂B
	 */
	CRIATOMEX_PLAYBACK_EVENT_REMOVE,
	
	CRIATOMEX_PLAYBACK_EVENT_ENUM_SIZE_IS_4BYTES = 0x7FFFFFFF
} CriAtomExPlaybackEvent;

/*JP
 * Đڍ
 * \ingroup ATOMEXLIB_PLAYBACK
 * \par :
 * ĐCxgɁAYĐɊւڍ׏ʒm邽߂̍\̂łB<br>
 * ĐCxgR[obNɈƂēn܂B<br>
 * \sa CriAtomExPlaybackEventCbFunc, criAtomExPlayer_SetPlaybackEventCallback
 */
typedef struct CriAtomExPlaybackInfoDetailTag {
	CriAtomExPlayerHn player;			/*JP< Đ̃v[[	*/
	CriAtomExPlaybackId id;				/*JP< ĐID			*/
} CriAtomExPlaybackInfoDetail;

/*JP
 * ĐCxgR[obN֐^
 * \ingroup ATOMEXLIB_PLAYBACK
 * \param[in]	obj					[UwIuWFNg
 * \param[in]	playback_event		Cxg
 * \param[in]	info				ڍ׏
 * \par :
 * ĐCxg̒ʒmɎgpAR[obN֐̌^łB<br>
 * ::criAtomExPlayer_SetPlaybackEventCallback ֐ɖ{֐^̃R[obN֐o^邱ƂŁA
 * ĐCxgɃR[obN󂯎邱Ƃ\ƂȂ܂B<br>
 * \attention
 * {R[obN֐ŒԏubNƁA؂ꓙ̖肪܂̂ŁA
 * ӂB<br>
 * \sa criAtomExPlayer_SetPlaybackEventCallback, CriAtomExPlaybackEvent, CriAtomExPlaybackInfoDetail
 */
typedef void (CRIAPI *CriAtomExPlaybackEventCbFunc)(void *obj,
	CriAtomExPlaybackEvent playback_event, const CriAtomExPlaybackInfoDetail *info);

/*==========================================================================
 *      CRI AtomEx Fader API
 *=========================================================================*/
/*JP
 * \brief tF[_[A^b`pRtBO\
 * \ingroup ATOMEXLIB_FADER
 * \par :
 * ::criAtomExPlayer_AttachFader ֐̈Ɏw肷AtF[_[A^b`p̃RtBO\̂łB<br>
 * \attention
 * w\ȃp[^[͂܂񂪁Ap[^[ǉ\邽߁A
 * {\̂gpۂɂ ::criAtomExFader_SetDefaultConfig }NgpA
 * \̂̏sĂB
 * \sa criAtomExFader_SetDefaultConfig, criAtomExPlayer_CalculateWorkSizeForFader, criAtomExPlayer_AttachFader
 */
typedef struct CriAtomExFaderConfigTag {
	CriSint32 reserved;					/*JP< \li0w肵Ăj	*/
} CriAtomExFaderConfig;

/*==========================================================================
 *      CRI AtomEx D-BAS API
 *=========================================================================*/
/*JP
 * \brief AtomEx D-BAS ID
 * \ingroup ATOMEXLIB_DBAS
 * \par :
 * CriAtomExDbasId ́AD-BASǗpIDłB<br>
 * ::criAtomExDbas_Create ֐D-BAS쐬Ǝ擾ł܂B
 * <br>
 * AvP[VD-BAS ID𗘗p̂́AD-BAS̔ĵ݂łB
 * \sa criAtomExDbas_Create, criAtomExDbas_Destroy
 */
typedef CriAtomDbasId CriAtomExDbasId;

/*JP
 * \brief D-BAS쐬p[^[\
 * \ingroup ATOMEXLIB_DBAS
 * \par :
 * ::criAtomExDbas_Create ֐̈Ɏw肷AD-BAS̍쐬p[^[\̂łB<br>
 * \attention
 * IɃo\邽߁A ::criAtomExDbas_SetDefaultConfig
 * }NgpȂꍇɂ́AgpOɕK\̂[NAĂB<br>
 * i\̂̃oɕslȂ悤ӂBj
 * \sa criAtomExDbas_Create, criAtomExDbas_CalculateWorkSize, criAtomExDbas_SetDefaultConfig
 */
typedef CriAtomDbasConfig CriAtomExDbasConfig;

/* ========================================================================*/
/*       CRI AtomEx Streaming Cache API                                      */
/* ========================================================================*/
/*JP
 * \brief Xg[~OLbVID
 * \ingroup ATOMEXLIB_STREAMING_CACHE
 * \par :
 * CriAtomExStreamingCacheId ́AXg[~OLbVǗpIDłB<br>
 * ::criAtomExStreamingCache_Create ֐ŃXg[~OLbV쐬Ǝ擾ł܂B<br>
 * \sa criAtomExStreamingCache_Create
 */
typedef CriAtomStreamingCacheId CriAtomExStreamingCacheId;

/*JP
 * \brief Xg[~OLbV쐬pRtBO\
 * \ingroup ATOMEXLIB_STREAMING_CACHE
 * \par :
 * v[[ɃXg[~OLbV쐬ۂɁA
 * LbV\ȃt@CTCYo^邽߂̍\̂łB<br>
 * ::criAtomExStreamingCache_CalculateWorkSize ֐A
 * ::criAtomExStreamingCache_Create ֐̈Ɏw肵܂B<br>
 * <br>
 * \attention
 * IɃo\邽߁AgpOɕK\̂[NAĂB<br>
 * i\̂̃oɕslȂ悤ӂBj
 * \sa criAtomStreamingCache_CalculateWorkSize, criAtomStreamingCache_Create
 */
typedef CriAtomStreamingCacheConfig CriAtomExStreamingCacheConfig;

/*==========================================================================
 *      CRI AtomEx 3D API
 *=========================================================================*/
/*JP
 * \brief 3xNg\
 * \ingroup ATOMEXLIB_3D
 * \par :
 * 3xNg߂̍\̂łB<br>
 * \sa CriAtomEx3dListener, CriAtomEx3dSource
 */
typedef struct CriAtomExVectorTag {
	CriFloat32 x;	/*JP< X̗vf */
	CriFloat32 y;	/*JP< Y̗vf */
	CriFloat32 z;	/*JP< Z̗vf */
} CriAtomExVector;

/*JP
 * \brief 3Dnh쐬pRtBO\
 * \ingroup ATOMEXLIB_3D
 * \par :
 * 3Dnh쐬ꍇɎgp\̂łB<br>
 * p[^[ǉ\邽߁A
 * {\̂gpۂɂ ::criAtomEx3dSource_SetDefaultConfig }NgpA
 * \̂̏sĂB
 * \sa criAtomEx3dSource_SetDefaultConfig, criAtomEx3dSource_CalculateWorkSize, criAtomEx3dSource_Create
 */
typedef struct CriAtomEx3dSourceConfigTag {
	/*JP
		\brief ɂ{CXvCIeBLɂ
		\par :
		ɂvCIeBLɂ邩ǂݒ肵܂B<br>
		{p[^[CRI_TRUEɐݒ肵3Dnh쐬ƁA3DnhŔ
		3D̃{CXvCIeB́AXi[Ƃ̋ɂČ󂯂悤ɂȂ܂B<br>
		{CXvCIeB̌ĺÃ{CXɐݒ肳Ăŏ0Aő勗-255łB<br>
		\par l:
		ɂ{CXvCIeB́Ã{CXvCIeBݒƉZēKp܂B<br>
		Ȃ킿AŏIIȃ{CXvCIeB́Aȉ̂ꂼZlɂȂ܂B<br>
		- f[^ɐݒ肳Ăl
		- ::criAtomExPlayer_SetVoicePriority ֐ɂݒl
		- ɂ{CXvCIeBl
		
		{p[^[̃ftHglCRI_FALSEiɂ{CXvCIeBjłB	
		\sa criAtomExPlayer_SetVoicePriority
	*/
	CriBool enable_voice_priority_decay;

	/*JP
	 *	\brief 3Dɂʒũ_ɊւWXg̗vf̍ől
	 *	\par :
	 *	3Dɂʒũ_ɊւWXg̗vf̍ől
	 *	ݒ肵܂B<br>
	 *	{ݒlɏ]āAIɈʒuWXg̗̈mۂ܂B
	 *	\par l:
	 *	3Dɂʒũ_gpȂꍇ
	 *	::CriAtomEx3dSourceRandomPositionConfig \̂̕ϐ calculation_type 
	 *	΂āA ::CRIATOMEX3DSOURCE_RANDOM_POSITION_CALCULATION_TYPE_LIST w
	 *	ȂꍇA{ݒl 0 w肵ĂB
	 *	\sa CriAtomEx3dSourceRandomPositionConfig
	 */
	CriUint32 random_position_list_max_length;
} CriAtomEx3dSourceConfig;

/*JP
 * \brief 3DnhXg쐬pRtBO\
 * \ingroup ATOMEXLIB_3D
 * \par :
 * 3DnhXg쐬ꍇɎgp\̂łB<br>
 * w\ȃp[^[͂܂񂪁Ap[^[ǉ\邽߁A
 * {\̂gpۂɂ ::criAtomEx3dSourceList_SetDefaultConfig }NgpA
 * \̂̏sĂB
 * \sa criAtomEx3dSourceList_SetDefaultConfig, criAtomEx3dSourceList_CalculateWorkSize, criAtomEx3dSourceList_Create
 */
typedef struct CriAtomEx3dSourceListConfigTag {
	CriSint32 reserved;
} CriAtomEx3dSourceListConfig;

/*JP
 * \brief 3DXi[nh쐬pRtBO\
 * \ingroup ATOMEXLIB_3D
 * \par :
 * 3DXi[nh쐬ꍇɎgp\̂łB<br>
 * w\ȃp[^[͂܂񂪁Ap[^[ǉ\邽߁A
 * {\̂gpۂɂ ::criAtomEx3dListener_SetDefaultConfig }NgpA
 * \̂̏sĂB
 * \sa criAtomEx3dListener_SetDefaultConfig, criAtomEx3dListener_CalculateWorkSize, criAtomEx3dListener_Create
 */
typedef struct CriAtomEx3dListenerConfigTag {
	CriSint32 reserved;
} CriAtomEx3dListenerConfig;

struct CriAtomEx3dSourceObjTag;
typedef struct CriAtomEx3dSourceObjTag CriAtomEx3dSourceObj;
/*JP
 * \brief 3Dnh
 * \ingroup ATOMEXLIB_3D
 * \par :
 * 3D߂̃nhłB<br>
 * 3D|WVjO@\Ɏgp܂B<br>
 * <br>
 * 3D̃p[^[Aʒu̐ݒ蓙́A3DnhĎs܂B
 * \sa criAtomEx3dSource_Create
 */
typedef CriAtomEx3dSourceObj *CriAtomEx3dSourceHn;

struct CriAtomEx3dSourceListObjTag;
typedef struct CriAtomEx3dSourceListObjTag CriAtomEx3dSourceListObj;
/*JP
 * \brief 3DnhXg
 * \ingroup ATOMEXLIB_3D
 * \par :
 * 3DnhǗ郊XgnhłB<br>
 * 3D|WVjO@\ɂ}`|WVjOĐɎgp܂B
 * \sa criAtomEx3dSourceList_Create
 */
typedef CriAtomEx3dSourceListObj *CriAtomEx3dSourceListHn;

struct CriAtomEx3dListenerObjTag;
typedef struct CriAtomEx3dListenerObjTag CriAtomEx3dListenerObj;
/*JP
 * \brief 3DXi[nh
 * \ingroup ATOMEXLIB_3D
 * \par :
 * 3DXi[߂̃nhłB<br>
 * 3D|WVjO@\Ɏgp܂B<br>
 * <br>
 * 3DXi[̃p[^[Aʒu̐ݒ蓙́A3DXi[nhĎs܂B
 * \sa criAtomEx3dListener_Create
 */
typedef CriAtomEx3dListenerObj *CriAtomEx3dListenerHn;

/*JP
 * \brief 3D[Wnh쐬pRtBO\
 * \ingroup ATOMEXLIB_3D
 * \par :
 * 3D[Wnh쐬ꍇɎgp\̂łB<br>
 * w\ȃp[^[͂܂񂪁Ap[^[ǉ\邽߁A
 * {\̂gpۂɂ ::criAtomEx3dRegion_SetDefaultConfig }NgpA
 * \̂̏sĂB
 * \sa criAtomEx3dRegion_SetDefaultConfig, criAtomEx3dRegion_CalculateWorkSize, criAtomEx3dRegion_Create
 */
typedef struct CriAtomEx3dRegionConfigTag {
	CriSint32 reserved;					/*JP< \li0w肵Ăj	*/
} CriAtomEx3dRegionConfig;

struct CriAtomEx3dRegionObjTag;
typedef struct CriAtomEx3dRegionObjTag CriAtomEx3dRegionObj;
/*JP
 * \brief 3D[Wnh
 * \ingroup ATOMEXLIB_3D
 * \par :
 * 3D[W߂̃nhłB<br>
 * 3DgV[o[@\Ɏgp܂B
 * \sa criAtomEx3dRegion_Create
 */
typedef CriAtomEx3dRegionObj *CriAtomEx3dRegionHn;

/*JP
 * \brief 3DgV[o[nh쐬pRtBO\
 * \ingroup ATOMEXLIB_3D
 * \par :
 * 3DgV[o[nh쐬ꍇɎgp\̂łB<br>
 * w\ȃp[^[͂܂񂪁Ap[^[ǉ\邽߁A
 * {\̂gpۂɂ ::criAtomEx3dTransceiver_SetDefaultConfig }NgpA
 * \̂̏sĂB
 * \sa criAtomEx3dTransceiver_SetDefaultConfig, criAtomEx3dTransceiver_CalculateWorkSize, criAtomEx3dTransceiver_Create
 */
typedef struct CriAtomEx3dTransceiverConfigTag {
	CriSint32 reserved;					/*JP< \li0w肵Ăj */
} CriAtomEx3dTransceiverConfig;

struct CriAtomEx3dTransceiverObjTag;
typedef struct CriAtomEx3dTransceiverObjTag CriAtomEx3dTransceiverObj;
/*JP
 * \brief 3DgV[o[nh
 * \ingroup ATOMEXLIB_3D
 * \par :
 * 3DgV[o[߂̃nhłB<br>
 * 3DgV[o[@\Ɏgp܂B<br>
 * <br>
 * 3DgV[o[̃p[^[Aʒu̐ݒ蓙́A3DgV[o[nhĎs܂B
 * \sa criAtomEx3dTransceiver_Create
 */
typedef CriAtomEx3dTransceiverObj *CriAtomEx3dTransceiverHn;

/*JP
 * \brief 3D̈ʒũ_ɂʒuW̎Zo@
 * \ingroup ATOMEXLIB_3D
 * \par :
 * 3D̈ʒũ_ɂʒuW̎Zo@̒`łB<br>
 * \sa CriAtomEx3dSourceRandomPositionConfig
 */
typedef enum CriAtomEx3dSourceRandomPositionCalculationTypeTag {
	/*JP
	 * \brief ݒ薳
	 * \par :
	 * WZos܂B
	 * \attention
	 * {`͏擾pɂ̂ݗp܂B<br>
	 * ̂߁A{ݒl ::CriAtomEx3dSourceRandomPositionConfig \̂
	 * w肵 ::criAtomEx3dSource_SetRandomPositionConfig ֐sꍇA
	 * G[܂B
	 */
	CRIATOMEX3DSOURCE_RANDOM_POSITION_CALCULATION_TYPE_NONE = -1,

	/*JP
	 * \brief `
	 * \par :
	 * xz ʏ̋`ōWZo܂B
	 */
	CRIATOMEX3DSOURCE_RANDOM_POSITION_CALCULATION_TYPE_RECTANGLE = 0,

	/*JP
	 * \brief 
	 * \par :
	 * xyz ԏ̒̓ōWZo܂B
	 */
	CRIATOMEX3DSOURCE_RANDOM_POSITION_CALCULATION_TYPE_CUBOID,

	/*JP
	 * \brief ~
	 * \par :
	 * xz ʏ̉~ōWZo܂B
	 */
	CRIATOMEX3DSOURCE_RANDOM_POSITION_CALCULATION_TYPE_CIRCLE,

	/*JP
	 * \brief ~
	 * \par :
	 * xyz ԏ̉~ōWZo܂B
	 */
	CRIATOMEX3DSOURCE_RANDOM_POSITION_CALCULATION_TYPE_CYLINDER,

	/*JP
	 * \brief 
	 * \par :
	 * xyz ԏ̋ōWZo܂B
	 */
	CRIATOMEX3DSOURCE_RANDOM_POSITION_CALCULATION_TYPE_SPHERE,

	/*JP
	 * \brief R[obN
	 * \par :
	 * [U[`̃R[obN֐ɂčW肵܂B
	 * \par l:
	 * ʓrWZosR[obN֐̓o^KvƂȂ܂B
	 * \sa CriAtomEx3dSourceRandomPositionCalculationCbFunc, criAtomEx3dSource_SetRandomPositionCalculationCallback
	 */
	CRIATOMEX3DSOURCE_RANDOM_POSITION_CALCULATION_TYPE_CALLBACK,

	/*JP
	 * \brief WXg
	 * \par :
	 * Oɐݒ肵WXgɍW肵܂B
	 * \par l:
	 * ʓrWXg̐ݒ肪KvƂȂ܂B
	 * \sa criAtomEx3dSource_SetRandomPositionList
	 */
	CRIATOMEX3DSOURCE_RANDOM_POSITION_CALCULATION_TYPE_LIST,

	/* enum size is 4bytes */
	CRIATOMEX3DSOURCE_RANDOM_POSITION_CALCULATION_TYPE_ENUM_SIZE_IS_4BYTES = 0x7FFFFFFF
} CriAtomEx3dSourceRandomPositionCalculationType;

/*JP
 * \brief 3D̈ʒũ_ɊւRtBO\
 * \ingroup ATOMEXLIB_3D
 * \par :
 * 3D̈ʒũ_Ɋւݒ܂Ƃ߂\̂łB
 * \attention
 * IɃo\邽߁A ::criAtomEx3dSource_SetDefaultConfigForRandomPosition
 * }NgpȂꍇɂ́AgpOɕK\̂[NAĂB<br>
 * i\̂̃oɕslȂ悤ӂBj
 * \sa criAtomEx3dSource_SetRandomPositionConfig, criAtomEx3dSource_SetDefaultConfigForRandomPosition
 */
typedef struct CriAtomEx3dSourceRandomPositionConfigTag {
	/*JP
	 * \brief 3DɒǏ]邩ǂ
	 * \par :
	 * _Ɍ肳ꂽ3D3DɒǏ]ēǂݒ肵܂B<br>
	 * CRI_TRUȄꍇ3D̈ʒuɒǏ]܂B<br>
	 * CRI_FALSȄꍇ3DɒǏ]AĐJn̈ʒuɗ܂܂B
	 */
	CriBool follows_original_source;

	/*JP
	 * \brief W̎Zo@
	 * \par :
	 * _ȍW肷ۂ̎Zo@ݒ肵܂B<br>
	 * ڍׂ ::CriAtomEx3dSourceRandomPositionCalculationType QƂĂB
	 * \sa CriAtomEx3dSourceRandomPositionCalculationType
	 */
	CriAtomEx3dSourceRandomPositionCalculationType calculation_type;

	/*JP
	 * \brief W̎Zo@Ɋւep[^[z
	 * \par :
	 * eW̎Zo@ɂĎgpp[^[złB<br>
	 * calculation_type ɐݒ肵W̎Zo@ɑ΂p[^[z
	 * ΂evf̐ݒ͈ȉ̒ʂłB
	 * - ::CRIATOMEX3DSOURCE_RANDOM_POSITION_CALCULATION_TYPE_RECTANGLE
	 *     - 0: E(x), 1: O㕝(z), 2: 0.0f
	 * - ::CRIATOMEX3DSOURCE_RANDOM_POSITION_CALCULATION_TYPE_CUBOID
	 *     - 0: E(x), 1: O㕝(z), 2: ㉺(y)
	 * - ::CRIATOMEX3DSOURCE_RANDOM_POSITION_CALCULATION_TYPE_CIRCLE
	 *     - 0: a, 1: 0.0f, 2: 0.0f
	 * - ::CRIATOMEX3DSOURCE_RANDOM_POSITION_CALCULATION_TYPE_CYLINDER
	 *     - 0: a, 1: ㉺(y), 2: 0.0f
	 * - ::CRIATOMEX3DSOURCE_RANDOM_POSITION_CALCULATION_TYPE_SPHERE
	 *     - 0: a, 1: 0.0f, 2: 0.0f
	 * .
	 * ȂAe}`͌3D𒆐SƂ܂B
	 * \par l:
	 * ȉ̍W̎Zo@ł́A{p[^[͖܂B
	 * - ::CRIATOMEX3DSOURCE_RANDOM_POSITION_CALCULATION_TYPE_CALLBACK
	 * - ::CRIATOMEX3DSOURCE_RANDOM_POSITION_CALCULATION_TYPE_LIST
	 * .
	 * \sa CriAtomEx3dSourceRandomPositionCalculationType
	 */
	CriFloat32 calculation_parameters[CRIATOMEX3DSOURCE_MAX_RANDOM_POSITION_CALCULATION_PARAMETERS];
} CriAtomEx3dSourceRandomPositionConfig;

/*JP
 * \brief 3D̈ʒũ_ɂʒuWʂ̏ڍ
 * \ingroup ATOMEXLIB_3D
 * \par :
 * 3D̈ʒũ_ɂʒuW̌ʏo͎ɁAYĐɊւڍ׏ʒm邽߂̍\̂łB<br>
 * 3D̈ʒũ_ɂʒuWʃR[obN֐ɈƂēn܂B
 * \sa CriAtomEx3dSourceRandomPositionResultCbFunc
 */
typedef struct CriAtomEx3dSourceRandomPositionResultInfoDetailTag {
	CriAtomEx3dSourceHn ex_3d_source;	/*JP< 3D̃nh */
	CriAtomExVector result_pos;			/*JP< ŏIIȈʒuW */
	CriAtomExVector offset_pos;			/*JP< 3D̈ʒuɑ΂ItZbgW */
} CriAtomEx3dSourceRandomPositionResultInfoDetail;

/*JP
 * \brief 3D̈ʒũ_ɂʒuWZoR[obN֐^
 * \ingroup ATOMEXLIB_3D
 * \param[in]	obj					[UwIuWFNg
 * \param[in]	ex_3d_source		3D̃nh
 * \param[out]	result_pos			ʂ̈ʒu
 * \par :
 * 3D̃_ɂʒuWZoR[obN֐̌^łB<br>
 * ::criAtomEx3dSource_SetRandomPositionCalculationCallback ֐s邱ƂŁA
 * R[obN֐̓o^\łB<br>
 * {R[obN֐́A3D̈ʒũ_ɂʒuWZoۂ
 * Ăяo܂B<br>
 * AvP[VňʒuW肵ꍇɂpB
 * \attention
 * {R[obN֐ŒԏubNƁA؂ꓙ̖肪܂̂ŁA
 * ӂB<br>
 * <br>
 * {R[obN֐ ::CriAtomEx3dSourceRandomPositionConfig \̂
 * ::CRIATOMEX3DSOURCE_RANDOM_POSITION_CALCULATION_TYPE_CALLBACK w肵Ƃ̂݌Ăяo܂B
 * \sa CriAtomEx3dSourceRandomPositionConfig, criAtomEx3dSource_SetRandomPositionCalculationCallback
 */
typedef void (CRIAPI *CriAtomEx3dSourceRandomPositionCalculationCbFunc)(
	void *obj, const CriAtomEx3dSourceHn ex_3d_source, CriAtomExVector *result_pos);

/*JP
 * \brief 3D̈ʒũ_ɂʒuWʃR[obN֐^
 * \ingroup ATOMEXLIB_3D
 * \param[in]	obj					[UwIuWFNg
 * \param[in]	result_info			ʒuWʂ̏ڍ
 * \par :
 * 3D̈ʒũ_ɂʒuWʃR[obN֐̌^łB<br>
 * ::criAtomEx3dSource_SetRandomPositionResultCallback ֐s邱ƂŁA
 * R[obN֐̓o^\łB<br>
 * {R[obN֐́A3D̈ʒũ_LȏꍇAʒuW̎Zosꂽ
 * Ăяo܂B<br>
 * AvP[VŃ_ꂽʒuW擾ꍇɂpB
 * \par l:
 * 3DɒǏ]ݒ肪L̏ꍇA3D̈ʒu̕ύXɉĖ{R[obN֐s܂B
 * \attention
 * {R[obN֐ŒԏubNƁA؂ꓙ̖肪܂̂ŁA
 * ӂB
 * \sa criAtomEx3dSource_SetRandomPositionResultCallback, CriAtomEx3dSourceRandomPositionResultInfoDetail
 */
typedef void (CRIAPI *CriAtomEx3dSourceRandomPositionResultCbFunc)(
	void *obj, const CriAtomEx3dSourceRandomPositionResultInfoDetail *result_info);

/*==========================================================================
 *      CRI AtomEx DSP API
 *=========================================================================*/

/*JP
 * \brief sb`Vt^[DSP̃A^b`pRtBO\
 * \ingroup ATOMEXLIB_DSP
 * \par :
 * sb`Vt^[DSP{CXv[ɃA^b`邽߂̍\̂łB<br>
 * \attention
 * IɃo\邽߁A ::criAtomExVoicePool_SetDefaultConfigForDspPitchShifter
 * }NgpȂꍇɂ́AgpOɕK\̂[NAĂB<br>
 * i\̂̃oɕslȂ悤ӂBj
 * \sa criAtomExVoicePool_AttachDspPitchShifter, criAtomExVoicePool_CalculateWorkSizeForDspPitchShifter, criAtomExVoicePool_SetDefaultConfigForDspPitchShifter
 */
typedef struct CriAtomExDspPitchShifterConfigTag {
	/*JP
		\brief 쐬DSP̐
		\par :
		A^b`̃{CXƓlw肷Kv܂B<br>
	*/
	CriSint32 num_dsp;
	
	/*JP
		\brief DSP̍ő`l
		\par :
		DSP\ȍő`lłB<br>
		A^b`{CXv[̃v[[ݒ̍ő`limax_channelsjƓlw肷Kv܂B<br>
	*/
	CriSint32 max_channels;
	
	/*JP
		\brief DSP̍őTvO[g
		\par :
		DSP\ȍőTvO[głB<br>
		A^b`{CXv[̃v[[ݒ̍őTvO[gimax_sampling_ratejƓlw肷Kv܂B<br>
	*/
	CriSint32 max_sampling_rate;
	
	/*JP
		\brief DSPŗLݒ̍\
		\par :
		DSPŗL̃RtBOݒs܂B<br>
		ڂ ::CriAtomDspPitchShifterConfig QƂB<br>
	*/
	CriAtomDspPitchShifterConfig specific;
} CriAtomExDspPitchShifterConfig;

/*JP
 * \brief ^CXgb`DSP̃A^b`pRtBO\
 * \ingroup ATOMEXLIB_DSP
 * \par :
 * ^CXgb`DSP{CXv[ɃA^b`邽߂̍\̂łB<br>
 * \attention
 * IɃo\邽߁A ::criAtomExVoicePool_SetDefaultConfigForDspTimeStretch
 * }NgpȂꍇɂ́AgpOɕK\̂[NAĂB<br>
 * i\̂̃oɕslȂ悤ӂBj
 * \sa criAtomExVoicePool_AttachDspTimeStretch, criAtomExVoicePool_CalculateWorkSizeForDspTimeStretch, criAtomExVoicePool_SetDefaultConfigForDspTimeStretch
 */
typedef struct CriAtomExDspTimeStretchConfigTag {
	/*JP
		\brief 쐬DSP̐
		\par :
		A^b`̃{CXƓlw肷Kv܂B<br>
	*/
	CriSint32 num_dsp;
	
	/*JP
		\brief DSP̍ő`l
		\par :
		DSP\ȍő`lłB<br>
		A^b`{CXv[̃v[[ݒ̍ő`limax_channelsjƓlw肷Kv܂B<br>
	*/
	CriSint32 max_channels;
	
	/*JP
		\brief DSP̍őTvO[g
		\par :
		DSP\ȍőTvO[głB<br>
		A^b`{CXv[̃v[[ݒ̍őTvO[gimax_sampling_ratejƓlw肷Kv܂B<br>
	*/
	CriSint32 max_sampling_rate;
	
	/*JP
		\brief DSPŗLݒ̍\
		\par :
		DSPŗL̃RtBOݒs܂B<br>
		ڂ ::CriAtomDspTimeStretchConfig QƂB<br>
	*/
	CriAtomDspTimeStretchConfig specific;
} CriAtomExDspTimeStretchConfig;

/*JP
 * \brief AFX`̃CT[VDSP̃A^b`pRtBO\
 * \ingroup ATOMLIB_DSP
 * \par :
 * AFX`̃CT[VDSPA^b`ۂɎw肷p[^[łB<br>
 * ::criAtomExVoicePool_AttachDspAfx ֐̈ƂĎg܂B<br>
 * \sa criAtomExVoicePool_AttachDspAfx
 */
typedef struct CriAtomExDspAfxConfigTag {
	/*JP
	\brief 쐬DSP̐
	\par :
	A^b`̃{CXƓlw肷Kv܂B<br>
	*/
	CriSint32 num_dsp;

	/*JP
	\brief DSP̍ő`l
	\par :
	DSP\ȍő`lłB<br>
	A^b`{CXv[̃v[[ݒ̍ő`limax_channelsjƓlw肷Kv܂B<br>
	*/
	CriSint32 max_channels;

	/*JP
	\brief DSP̍őTvO[g
	\par :
	DSP\ȍőTvO[głB<br>
	A^b`{CXv[̃v[[ݒ̍őTvO[gimax_sampling_ratejƓlw肷Kv܂B<br>
	*/
	CriSint32 max_sampling_rate;

	/*JP
	\brief Afx`DSPݒ̍\
	\par :
	Afx`DSP̃RtBOݒs܂B<br>
	ڂ ::CriAtomDspAfxConfig QƂB<br>
	*/
	CriAtomDspAfxConfig specific;
} CriAtomExDspAfxConfig;

/*==========================================================================
 *      CRI AtomEx Tween API
 *=========================================================================*/
/*JP
 * \brief Tweeñp[^[^Cv
 * \ingroup ATOMEXLIB_TWEEN
 * \par :
 * Tweenő삷p[^[̃^CvłB<br>
 * \sa CriAtomExTweenConfig
 */
typedef enum CriAtomExTweenParameterTypeTag {
	/*JP
		\brief {p[^[
		\par :
		{[Asb`ACriAtomExParameterIdŎw肷p[^[𑀍삷ۂɎw肵܂B
	*/
	CRIATOMEX_PARAMETER_TYPE_BASIC,

	/*JP
		\brief AISACRg[l
		\par :
		AISACRg[l𑀍삷ۂɎw肵܂B
	*/
	CRIATOMEX_PARAMETER_TYPE_AISAC,

	/* enum size is 4bytes */
	CRIATOMEX_PARAMETER_TYPE_ENUM_SIZE_IS_4BYTES = 0x7FFFFFFF
} CriAtomExTweenParameterType;

/*JP
 * \brief gDC[쐬pRtBO\
 * \ingroup ATOMEXLIB_TWEEN
 * \par :
 * gDC[쐬ۂɁAdlw肷邽߂̍\̂łB<br>
 * ::criAtomExTween_Create ֐̈Ɏw肵܂B<br>
 * {\̂gpۂɂ ::criAtomExTween_SetDefaultConfig }NgpA
 * \̂̏sĂB
 * \sa criAtomExTween_SetDefaultConfig, criAtomExTween_CalculateWorkSize, criAtomExTween_Create
 */
typedef struct CriAtomExTweenConfigTag {
	/*JP
		\brief IDw苤p
		\par :
		p[^[^Cvɏ]Ap[^[ID܂AISACRg[IDw肵܂B
	*/
	union CriAtomExTweenConfigParameterIdTag {
		/*JP
			\brief p[^[ID
			\par :
			p[^[^Cv::CRIATOMEX_PARAMETER_TYPE_BASICw肷ꍇÃoŃp[^[IDw肵܂B
		*/
		CriAtomExParameterId parameter_id;

		/*JP
			\brief AISACRg[ID
			\par :
			p[^[^Cv::CRIATOMEX_PARAMETER_TYPE_AISACw肷ꍇÃoAISACRg[IDw肵܂B
		*/
		CriAtomExAisacControlId aisac_control_id;
	} id;

	/*JP
		\brief p[^[^Cv
		\par :
		p[^[^Cvw肵܂B
	*/
	CriAtomExTweenParameterType parameter_type;
} CriAtomExTweenConfig;

/*JP
 * \brief gDC[nh
 * \ingroup ATOMEXLIB_TWEEN
 * \par :
 * CriAtomExTweenHn ́AgDC[𑀍삷邽߂̃nhłB<br>
 * gDC[Ƃ́AȒPȎ菇Ńp[^[̎ԕωs߂̃W[łB
 * ::criAtomExTween_Create ֐ŃgDC[쐬ƁA
 * {֐̓gDC[pɁA"gDC[nh"Ԃ܂B
 * <br>
 * p[^[̎ԕω̊JnAgDC[ɑ΂čśA
 * SăgDC[nhĎs܂B<br>
 * ܂AAtomExv[[ɃgDC[֘AÂۂɂgp܂B
 * \sa criAtomExTween_Create, criAtomExPlayer_AttachTween
 */
typedef struct CriAtomExTweenTag *CriAtomExTweenHn;

/*==========================================================================
 *      CRI AtomEx Voice Event API
 *=========================================================================*/
/*JP
 * \brief {CXCxg
 * \ingroup ATOMEXLIB_GLOBAL
 * \par :
 * {CXCxg̎ʂlłB<br>
 * {CXCxgR[obNɈƂēn܂B<br>
 * \sa CriAtomExVoiceEventCbFunc, criAtomEx_SetVoiceEventCallback
 */
typedef enum CriAtomExVoiceEventTag {
	/*JP
	 * \brief {CX̐VKm
	 * \par :
	 * {CXv[󂫃{CX擾AVKɔJnꂽƂlłB<br>
	 */
	CRIATOMEX_VOICE_EVENT_ALLOCATE = 0,
	
	/*JP
	 * \brief {CX̒D
	 * \par :
	 * Đ̃{CXDꂽƂlłB<br>
	 * Đ̃{CX1~Ã{CXʂ̉̍Đɍėp܂B<br>
	 * ~g`f[^ƐVKɍĐg`f[^́A
	 * قȂ{CX~bgO[vɏĂ܂B<br>
	 * iǂ炩A͗̔g`f[^{CX~bgO[vɏĂȂꍇA
	 * {CX̒D蔭ɖ{Cxg܂Bj<br>
	 */
	CRIATOMEX_VOICE_EVENT_ALLOCATE_AND_REMOVE,
	
	/*JP
	 * \brief O[vł̃{CX̒D
	 * \par :
	 * Đ̃{CXDꂽƂlłB<br>
	 * Đ̃{CX1~Ã{CXʂ̉̍Đɍėp܂B<br>
	 * ::CRIATOMEX_VOICE_EVENT_ALLOCATE_AND_REMOVE ƈقȂA
	 * ~g`f[^ƐVKɍĐg`f[^ƂA
	 * ̃{CX~bgO[vɏꍇɖ{Cxg܂B<br>
	 */
	CRIATOMEX_VOICE_EVENT_ALLOCATE_AND_REMOVE_IN_GROUP,
	
	/*JP
	 * \brief {CX̒Dƃ{CX̒
	 * \par :
	 * Đ̃{CXDAɃ{CX̒sꂽƂlłB<br>
	 * 2̃{CX~Â1̃{CXʂ̉̍Đɍėp܂B<br>
	 * i~ꂽ̃{CX́A󂫃{CXƂă{CXv[ɖ߂܂Bj<br>
	 * f[^̍Đv𖞂{CXDʁAO[ṽ{CXӂA
	 * O[vŃ{CX𒲐ꍇɖ{Cxg܂B<br>
	 * \par l:
	 * ̃P[X́A{CX~bgO[vHCAf[^ĐɁA
	 * {CX~bgO[vɏADXf[^Đꍇɔ܂B<br>
	 * ADXf[^Đ邽߁AO[vOADX{CX~ʁA
	 * HCAf[^ADXf[^̍v{CX~bgO[v𒴂ꍇA
	 * vCIeBHCAf[^1~`ɂȂ܂B<br>
	 * i1̔NGXgɑ΂A2̉~`ɂȂ܂Bj<br>
	 */
	CRIATOMEX_VOICE_EVENT_ALOOCATE_AND_REMOVE_TWO,
	
	/*JP
	 * \brief v̊p
	 * \par :
	 * Đ悤Ƃg`f[^̃vCIeBA
	 * S{CXōłႩꍇĩ{CXDȂꍇjɁA
	 * {Cxg܂B<br>
	 */
	CRIATOMEX_VOICE_EVENT_REJECT,
	
	/*JP
	 * \brief O[vł̔v̊p
	 * \par :
	 * Đ悤Ƃg`f[^̃vCIeBA
	 * O[vōłႩꍇiO[v̑̃{CXDȂꍇjɁA
	 * {Cxg܂B<br>
	 */
	CRIATOMEX_VOICE_EVENT_REJECT_BY_GROUP_LIMIT,
	
	/*JP
	 * \brief {CX̒~
	 * \par :
	 * ĐĐ~vɂA{CX~ꂽꍇɖ{Cxg܂B<br>
	 * ~ꂽ{CX́A󂫃{CXƂă{CXv[ɖ߂܂B<br>
	 */
	CRIATOMEX_VOICE_EVENT_REMOVE,
	
	CRIATOMEX_VOICE_EVENT_ENUM_IS_4BYTE = 0x7FFFFFFF
} CriAtomExVoiceEvent;

/*JP
 * \brief {CX̏ڍ׏
 * \ingroup ATOMEXLIB_GLOBAL
 * \par :
 * {CXCxg̃{CX̏ڍ׏ێ\̂łB<br>
 * {CXCxgR[obNɈƂēn܂B<br>
 * \sa CriAtomExVoiceEventCbFunc, criAtomEx_SetVoiceEventCallback
 */
typedef struct CriAtomExVoiceInfoDetailTag {
	CriAtomExPlaybackId playback_id;					/*JP< ĐID					*/
	CriAtomExSourceInfo cue_info;						/*JP< L[				*/
	CriAtomExSourceInfo wave_info;						/*JP< g`					*/
	CriSint32 group_no;									/*JP< O[vԍ				*/
	CriSint32 priority;									/*JP< vCIeB			*/
	CriAtomExVoiceControlMethod control_method;			/*JP< {CX@			*/
	CriAtomExVoiceAllocationMethod allocation_method;	/*JP< {CXmە@			*/
	CriUint32 identifier;								/*JP< {CXv[ʎq		*/
	CriAtomExFormat format;								/*JP< tH[}bg			*/
	CriSint32 sampling_rate;							/*JP< TvOg		*/
	CriSint32 num_channels;								/*JP< `l				*/
	CriBool streaming_flag;								/*JP< Xg[Đǂ	*/
	CriAtomPlayerHn atom_player;						/*JP< Ɏgpv[[	*/
} CriAtomExVoiceInfoDetail;

/*JP
 * \brief {CXCxgR[obN֐^
 * \ingroup ATOMEXLIB_GLOBAL
 * \param[in]	obj					[UwIuWFNg
 * \param[in]	voice_event			Cxg
 * \param[in]	request				v̏ڍ׏
 * \param[in]	removed				~{CX̏ڍ׏
 * \param[in]	removed_in_group	O[v~{CX̏ڍ׏
 * \par :
 * {CXCxg̒ʒmɎgpAR[obN֐̌^łB<br>
 * ::criAtomEx_SetVoiceEventCallback ֐ɖ{֐^̃R[obN֐o^邱ƂŁA
 * {CXCxgɃR[obN󂯎邱Ƃ\ƂȂ܂B<br>
 * <br>
 * R[obN֐̑3`5irequestAremovedAremoved_in_groupjɓĺA
 * {CXCxg̎ʁi2voice_event̒ljɂȉ̂悤ɕς܂B<br>
 * <br>
 * (1) CRIATOMEX_VOICE_EVENT_ALLOCATE<br>
 * 3requestɁA{CX擾NGXg̏񂪓܂B<br>
 * 4A5ɂNULL܂B<br>
 * <br>
 * (2) CRIATOMEX_VOICE_EVENT_ALLOCATE_AND_REMOVE<br>
 * 3requestɁA{CX擾NGXg̏񂪓܂B<br>
 * 4removedɂ́A{CXDA~Đ̏񂪓܂B<br>
 * 5ɂNULL܂B<br>
 * <br>
 * (3) CRIATOMEX_VOICE_EVENT_ALLOCATE_AND_REMOVE_IN_GROUP<br>
 * 3requestɁA{CX擾NGXg̏񂪓܂B<br>
 * 4ɂNULL܂B<br>
 * 5removed_in_groupɂ́A{CXDA~Đ̏񂪓܂B<br>
 * <br>
 * (4) CRIATOMEX_VOICE_EVENT_ALOOCATE_AND_REMOVE_TWO<br>
 * 3requestɁA{CX擾NGXg̏񂪓܂B<br>
 * 4removedɂ́A{CXDA~Đ̏񂪓܂B<br>
 * 5removed_in_groupɂ́AO[v̔ɂA~ꂽĐ̏񂪓܂B<br>
 * <br>
 * (5) CRIATOMEX_VOICE_EVENT_REJECT<br>
 * 3requestɁA{CX̎擾pꂽNGXg̏񂪓܂B<br>
 * 4A5ɂNULL܂B<br>
 * <br>
 * (6) CRIATOMEX_VOICE_EVENT_REJECT_BY_GROUP_LIMIT<br>
 * 3requestɁA{CX̎擾pꂽNGXg̏񂪓܂B<br>
 * 4A5ɂNULL܂B<br>
 * <br>
 * (7) CRIATOMEX_VOICE_EVENT_REMOVE<br>
 * 4removedɁAĐI܂͒~{CX̏񂪓܂B<br>
 * 3A5ɂNULL܂B<br>
 * \attention
 * {R[obNł́A{CXPʂ̃~bg
 *i{CXvCIeBɊÂg`Pʂ̃vCIeBj
 * Ɋւ݂̂擾\łB<br>
 * {CX擾OɃL[~bgŔpꂽꍇA
 * {R[obNCRIATOMEX_VOICE_EVENT_REJECT͕̏Ԃ܂B<br>
 * iJeSL[vCIeBɂ鐧Ɋւ́A擾ł܂Bj<br>
 * <br>
 * {CXCxgR[obN_ł́A request->atom_player
 * ɂ͍Đׂf[^܂ZbgĂ܂B<br>
 * ̂߁AĐ鉹f[^̏񓙂ɂẮA atom_player ɖ₢킹A
 * ::CriAtomExVoiceInfoDetail \̂̃olgpĂB<br>
 * <br>
 * {R[obN֐ŒԏubNƁA؂ꓙ̖肪܂̂ŁA
 * ӂB<br>
 * \sa criAtomEx_SetVoiceEventCallback, CriAtomExVoiceEvent, CriAtomExVoiceInfoDetail
 */
typedef void (CRIAPI *CriAtomExVoiceEventCbFunc)(
	void *obj, CriAtomExVoiceEvent voice_event,
	const CriAtomExVoiceInfoDetail *request,
	const CriAtomExVoiceInfoDetail *removed,
	const CriAtomExVoiceInfoDetail *removed_in_group);

/*JP
 * \brief {CXR[obN֐^
 * \ingroup ATOMEXLIB_GLOBAL
 * \param[in]	obj					[UwIuWFNg
 * \param[in]	voice_info			{CX̏ڍ׏
 * \par :
 * {CX̒ʒmɎgpAR[obN֐̌^łB<br>
 * ::criAtomEx_EnumerateVoiceInfos ֐ɖ{֐^̃R[obN֐o^邱ƂŁA
 * Đ̃{CX̏R[obNŎ󂯎邱Ƃ\ƂȂ܂B<br>
 * \attention
 * {R[obN֐ŒԏubNƁA؂ꓙ̖肪܂̂ŁA
 * ӂB<br>
 * \sa criAtomEx_EnumerateVoiceInfos, CriAtomExVoiceInfoDetail
 */
typedef void (CRIAPI *CriAtomExVoiceInfoCbFunc)(
	void *obj, const CriAtomExVoiceInfoDetail *voice_info);

/*JP
 * \brief {CX~擾p\
 * \ingroup ATOMEXLIB_GLOBAL
 * \par :
 * {CX~擾邽߂̍\̂łB<br>
 * ::CriAtomExMonitoringVoiceStopCbFunc ֐^̈Ƃēn܂B<br>
 * \sa CriAtomExMonitoringVoiceStopCbFunc
 */
typedef struct CriAtomExMonitoringVoiceStopInfoTag {
	CriAtomExPlaybackId playback_id;		/*JP< ĐID			*/
	CriAtomVoiceStopReason reason;			/*JP< ~R			*/
	CriAtomPlayerHn atom_player;			/*JP< ~AtomPlayer	*/
} CriAtomExMonitoringVoiceStopInfo;

/*JP
 * \brief {CX~ĎR[obN֐^
 * \ingroup ATOMEXLIB_ACB
 * \param[in]	obj					[UwIuWFNg
 * \param[in]	voice_stop			{CX~e
 * \par :
 * ĎĂĐIDŔĂ{CX~ۂɎgpAR[obN֐̌^łB<br>
 * \attention
 * {IɁAR[obN֐łAtomCuAPIgpȂłB<br>
 * {R[obN֐ŒԏubNƁA؂ꓙ̖肪܂̂ŁA
 * ӂB<br>
 * \sa criAtomEx_SetMonitoringVoiceStopCallback
 */
typedef void (CRIAPI *CriAtomExMonitoringVoiceStopCbFunc)(void *obj, CriAtomExMonitoringVoiceStopInfo* voice_stop);


/*==========================================================================
 *      CRI AtomEx Cue Link Callback API
 *=========================================================================*/
/*JP
 * \brief L[NR[obN^Cv
 * \ingroup ATOMEXLIB_GLOBAL
 */
typedef enum CriAtomExCueLinkTypeTag {
	CRIATOMEX_CUELINK_TYPE_STATIC		=  0,	/*JP< ÓIN */
	CRIATOMEX_CUELINK_TYPE_DYNAMIC		=  1,	/*JP< IN */

	/* enum size is 4bytes */
	CRIATOMEX_CUELINK_TYPE_ENUM_SIZE_IS_4BYTES = 0x7FFFFFFF
} CriAtomExCueLinkType;

/*JP
 * \brief L[NR[obNpInfo\
 * \ingroup ATOMEXLIB_GLOBAL
 */
typedef struct CriAtomExCueLinkInfoTag {
	CriAtomExPlayerHn player;			/*JP< v[[nh		*/
	CriAtomExPlaybackId base_id;		/*JP< NĐID		*/
	CriAtomExSourceInfo base_cue;		/*JP< NL[		*/
	CriAtomExPlaybackId target_id;		/*JP< NĐID		*/
	CriAtomExSourceInfo target_cue;		/*JP< NL[		*/
	CriAtomExCueLinkType link_type;		/*JP< N^Cv			*/
} CriAtomExCueLinkInfo;

/*JP
 * \brief L[NR[obN
 * \ingroup ATOMEXLIB_GLOBAL
 * \par :
 * \param[in]	obj		[UwIuWFNg
 * \param[in]	info	L[N
 * \return				gp
 * AtomExCũL[NR[obN֐^łB<br>
 * R[obN֐̓o^ɂ ::criAtomEx_SetCueLinkCallback ֐gp܂B<br>
 * o^R[obN֐́ACuŃL[N^C~OŎs܂B<br>
 * ̂߁ACuւ̊荞݂lȂAPIsꍇA
 * G[AfbhbN\܂B<br>
 * {IɁAR[obN֐łAtomCuAPIgpȂłB<br>
 * {R[obN֐ŒԏubNƁA؂ꓙ̖肪܂̂ŁA
 * ӂB<br>
 * \sa criAtomEx_SetCueLinkCallback
 */
typedef CriSint32 (CRIAPI *CriAtomExCueLinkCbFunc)(void* obj, const CriAtomExCueLinkInfo* info);

/*==========================================================================
 *      CRI AtomEx Playback Cancel Callback API
 *=========================================================================*/
/*JP
 * \brief vCobNLZ^Cv
 * \ingroup ATOMEXLIB_GLOBAL
 * \par :
 * vCobNLZ̎ʂlłB<br>
 * \sa CriAtomExPlaybackCancelInfo, criAtomEx_SetPlaybackCancelCallback
 */
typedef enum CriAtomExPlaybackCancelTypeTag {
	/*JP
	 * \brief L[~bg
	 * \par :
	 * L[~bgɂ锭LZB<br>
	 */
	CRIATOMEX_PLAYBACK_CANCEL_TYPE_CUE_LIMIT = 0,

	/*JP
	 * \brief JeSL[~bg
	 * \par :
	 * JeSL[~bgɂ锭LZB<br>
	 */
	CRIATOMEX_PLAYBACK_CANCEL_TYPE_CATEGORY_CUE_LIMIT,
	
	/*JP
	 * \brief voreB
	 * \par :
	 * mɂ锭LZB<br>
	 */
	CRIATOMEX_PLAYBACK_CANCEL_TYPE_PROBABILITY,

	/*JP
	 * \brief L[~bg
	 * \par :
	 * L[~bgɂ锭~B<br>
	 */
	CRIATOMEX_PLAYBACK_CANCEL_TYPE_STOP_BY_CUE_LIMIT,
		
	/*JP
	 * \brief XCb`
	 * \par :
	 * XCb`ɂ锭LZB<br>
	 */
	CRIATOMEX_PLAYBACK_CANCEL_TYPE_SWITCH,

	/*JP
	* \brief gbNs
	* \par :
	* ĐgbNsɂ锭LZB<br>
	*/
	CRIATOMEX_PLAYBACK_CANCEL_TYPE_NO_TRACK_TO_PLAY,


	CRIATOMEX_PLAYBACK_CANCEL_TYPE_ENUM_IS_4BYTE = 0x7FFFFFFF
} CriAtomExPlaybackCancelType;

/*JP
 * \brief vCobNLZR[obNpInfo\
 * \ingroup ATOMEXLIB_GLOBAL
 */
typedef struct CriAtomExPlaybackCancelInfoTag {
	CriAtomExPlaybackCancelType type;	/*JP< LZ^Cv		*/
	CriAtomExPlayerHn player;			/*JP< v[[nh		*/
	CriAtomExPlaybackId id;				/*JP< ĐID				*/
} CriAtomExPlaybackCancelInfo;

/*JP
 * \brief vCobNLZR[obN
 * \ingroup ATOMEXLIB_GLOBAL
 * \par :
 * \param[in]	obj		[UwIuWFNg
 * \param[in]	info	vCobNLZ
 * \return				gp
 * AtomExCũvCobNLZR[obN֐^łB<br>
 * R[obN֐̓o^ɂ ::criAtomEx_SetPlaybackCancelCallback ֐gp܂B<br>
 * o^R[obN֐́ACuōĐJnLZ^C~OŎs܂B<br>
 * ̂߁ACuւ̊荞݂lȂAPIsꍇA
 * G[AfbhbN\܂B<br>
 * {IɁAR[obN֐łAtomCuAPIgpȂłB<br>
 * {R[obN֐ŒԏubNƁA؂ꓙ̖肪܂̂ŁA
 * ӂB<br>
 * \sa criAtomEx_SetPlaybackCancelCallback
 */
typedef void (CRIAPI *CriAtomExPlaybackCancelCbFunc)(void *obj, const CriAtomExPlaybackCancelInfo* info);

/*==========================================================================
 *      CRI AtomEx Track Transition Callback API
 *=========================================================================*/
/*JP
 * \brief gbNgWVoCZN^[R[obNpInfo\
 * \ingroup ATOMEXLIB_GLOBAL
 */
typedef struct CriAtomExTrackTransitionBySelectorInfoTag {
	CriAtomExPlayerHn player;			/*JP< v[[nh		*/
	CriAtomExPlaybackId id;				/*JP< ĐID				*/
	const CriChar8* selector;			/*JP< ZN^[			*/
	const CriChar8* label;				/*JP< x				*/
} CriAtomExTrackTransitionBySelectorInfo;

/*JP
 * \brief gbNgWVoCZN^[R[obN
 * \ingroup ATOMEXLIB_GLOBAL
 * \par :
 * \param[in]	obj		[UwIuWFNg
 * \param[in]	info	gbNgWVoCZN^[
 * \return				gp
 * AtomExCũgbNgWVoCZN^[R[obN֐^łB<br>
 * R[obN֐̓o^ɂ ::criAtomEx_SetTrackTransitionBySelectorCallback ֐gp܂B<br>
 * o^R[obN֐́ACuŃgWVJn^C~OŎs܂B<br>
 * ̂߁ACuւ̊荞݂lȂAPIsꍇA
 * G[AfbhbN\܂B<br>
 * {IɁAR[obN֐łAtomCuAPIgpȂłB<br>
 * {R[obN֐ŒԏubNƁA؂ꓙ̖肪܂̂ŁA
 * ӂB<br>
 * \sa criAtomEx_SetTrackTransitionBySelectorCallback
 */

typedef void (CRIAPI *CriAtomExTrackTransitionBySelectorCbFunc)(void *obj, const CriAtomExTrackTransitionBySelectorInfo* info);


/*==========================================================================
 *      CRI AtomEx Sound Object API
 *=========================================================================*/
/*JP
 * \brief TEhIuWFNg쐬pRtBO\
 * \ingroup ATOMEXLIB_SOUND_OBJECT
 * \par :
 * TEhIuWFNg쐬ۂɁAdlw肷邽߂̍\̂łB<br>
 * ::criAtomExSoundObject_Create ֐̈Ɏw肵܂B<br>
 * <br>
 * 쐬TEhIuWFNǵAnh쐬ɖ{\̂Ŏw肳ꂽݒɉāA
 * \[XKvȂmۂ܂B<br>
 * TEhIuWFNgKvƂ郏[N̈̃TCÝA{\̂Ŏw肳ꂽp[^[ɉĕω܂B
 * \attention
 * IɃo\邽߁Aeo̐ݒOɕK
 * ::criAtomExSoundObject_SetDefaultConfig }NgpăftHglZbgĂB<br>
 * i\̂̃oɕslȂ悤ӂBj
 * \sa criAtomExSoundObject_Create,  criAtomExSoundObject_SetDefaultConfig
 */
typedef struct CriAtomExSoundObjectConfigTag {
	/*JP 
	 * \brief {CX~bgXR[v̗L
	 * \par :
	 * {CX~bgO[vɂ锭ÃTEhIuWFNgœƗčsǂw肵܂B<br>
	 * CRI_TRUEw肷ƁÃTEhIuWFNgɊ֘AtꂽExv[[Đ̔ɂāA<br>
	 * ̃TEhIuWFNgł̂݃JEgA{CX~bgO[vɂ锭s܂B<br>
	 * CRI_FALSEw肵ꍇATEhIuWFNgł̓{CX~bgO[vɂ锭͍s킸A<br>
	 * CRI AtomCuŜł̔ɏ]܂B
	 * \par l:
	 * ftHglCRI_FALSEiTEhIuWFNgŃ{CX~bgsȂjłB
	*/
	CriBool enable_voice_limit_scope;
	/*JP 
	 * \brief JeSL[~bgXR[v̗L
	 * \par :
	 * JeSɂL[ĐÃTEhIuWFNgœƗčsǂw肵܂B<br>
	 * CRI_TRUEw肷ƁÃTEhIuWFNgɊ֘AtꂽExv[[ĐL[̃JeSĐɂāA<br>
	 * ̃TEhIuWFNgł̂݃JEgAĐs܂B<br>
	 * CRI_FALSEw肵ꍇÃTEhIuWFNgł̓JeSɂĐ͍s킸A<br>
	 * CRI AtomCuŜł̃JeSɂĐɏ]܂B
	 * \par l:
	 * ftHglCRI_FALSEiTEhIuWFNgŃJeSL[~bgsȂjłB
	*/
	CriBool enable_category_cue_limit_scope;
} CriAtomExSoundObjectConfig;

struct CriAtomExSoundObjectTag;
typedef struct CriAtomExSoundObjectTag CriAtomExSoundObjectObj;
/*JP
 * \brief TEhIuWFNgnh
 * \ingroup ATOMEXLIB_SOUND_OBJECT
 * \par :
 * CriAtomExSoundObjectHn ́ATEhIuWFNg𑀍삷邽߂̃nhłB<br>
 * <br>
 * ::criAtomExSoundObject_Create ֐ŃTEhIuWFNg쐬ƁA
 * ֐̓TEhIuWFNgpɁA"TEhIuWFNgnh"Ԃ܂B
 * <br>
 * TEhIuWFNgɑ΂čśASăTEhIuWFNgnhĎs܂B
 * \par l:
 * TEhIuWFNgƂ́ẢúvuԁvAu󋵁v𒊏 TOłB<br>
 * <br>
 * TEhIuWFNgAvP[V́úvuԁvAu󋵁vɊ֘At邱ƂɂA
 * 莩Rɉ̃Rg[sƂł܂B<br>
 * Ⴆ΁ALN^݂ƂÃLN^p̃TEhIuWFNg쐬邱ƂŁA
 * LN^ɔsALN^łƂƂɂ܂Ƃ߂čĐ~sA
 * Ƃ悤ȂƂȒPɂł悤ɂȂ܂B<br>
 * <br>
 * TEhIuWFNgǵÂ߂̋@\܂B
 * ʂ̃Rg[́ATEhIuWFNgɊ֘AtꂽAtomExv[[ōs܂B
 * \sa criAtomExSoundObject_Create
 */
typedef CriAtomExSoundObjectObj *CriAtomExSoundObjectHn;

/*==========================================================================
*      CRI AtomExOutputPort API
*=========================================================================*/
/*JP
 * \brief o̓|[g^Cv
 * \ingroup ATOMEXLIB_OUTPUT_PORT
 * \par :
 * o̓|[g̎ʂlłB<br>
 * \sa CriAtomExOutputPortConfig
 */
typedef enum CriAtomExOutputPortTypeTag {
	/*JP
	 * \brief TEh^Cv
	 * \par :
	 * ʏ̉Đo̓|[g^CvłB<br>
	 */
	CRIATOMEX_OUTPUT_PORT_TYPE_AUDIO = 0,

	/*JP
	 * \brief U^Cv
	 * \par :
	 * I[fBIx[X̐UĐo̓|[g^CvłB<br>
	 */
	CRIATOMEX_OUTPUT_PORT_TYPE_VIBRATION,

	/*JP
	 * \brief U^Cv
	 * \par :
	 * sȃ^CvłB֐̕ԂlG[̂Ƃgp܂B<br>
	 */
	CRIATOMEX_OUTPUT_PORT_TYPE_INVALID = -1,

	/* enum size is 4bytes */
	CRIATOMEX_OUTPUT_PORT_TYPE_ENUM_SIZE_IS_4BYTES = 0x7FFFFFFF
} CriAtomExOutputPortType;

/*JP
 * \brief o̓|[g쐬pRtBO\
 * \ingroup ATOMEXLIB_OUTPUT_PORT
 * \par :
 * o̓|[g쐬邽߂̍\̂łB<br>
 * ::criAtomExOutputPort_Create ֐̈Ɏw肵܂B<br>
 * \sa criAtomExOutputPort_Create
 */
typedef struct CriAtomExOutputPortConfigTag {
	/*JP
	 * \brief o̓|[g
	 * \par :
	 * o̓|[g̖Ow肵܂B<br>
	 * \par l: 
	 * ̒ ::CRIATOMEX_OUTPUT_PORT_MAX_NAME_LENGTH ȉłKv܂B<br>
	 * xw肵|[gƂύX邱Ƃ͂ł܂B
	 */
	const CriChar8* name;

	/*JP
	 * \brief o̓|[g^Cv
	 * \par :
	 * o̓|[g̃^Cvw肵܂B<br>
	 * \par l:
	 * xw肵|[g^CvƂύX邱Ƃ͂ł܂B
	 */
	CriAtomExOutputPortType type;

	/*JP
	 * \brief o̓|[g̃JeS̍ő喳ݒ萔
	 * \par :
	 * o̓|[gɎwłJeSݒ肪ső吔B<br>
	 * \par l:
	 * xw肵lƂύX邱Ƃ͂ł܂B
	 */
	CriUint32 max_ignored_categories;
} CriAtomExOutputPortConfig;

struct CriAtomExOutputPortObjTag;
typedef struct CriAtomExOutputPortObjTag CriAtomExOutputPortObj;
/*JP
 * \brief o̓|[gnh
 * \ingroup ATOMEXLIB_OUTPUT_PORT
 * \par :
 * CriAtomExOutputPortHn ́Ȁo͐w肷邽߂̃nhłB<br>
 * <br>
 * o̓|[gnh́Aȉ̂Q̊֐Ŏ擾邱Ƃł܂B<br>
 * - ::criAtomExOutputPort_Create ֐ŐVnh쐬
 * - ::criAtomExAcf_GetOutputPortHnByName ֐ACF̏o̓|[gnh擾
 * <br>
 * ACF̏o̓|[gnh́AACFt@Co^ƂIɍ쐬܂B
 * v[[ɑ΂ ::criAtomExPlayer_AddOutputPort ֐܂ ::criAtomExPlayer_AddPreferredOutputPort ֐ɂ
 * ʂ̏o̓|[gnhw肳ĂȂꍇAo̓|[gw肳ꂽ̍ĐɂACF̏o̓|[ggp܂B
 * \par l:
 * o̓|[ǵȀo͐𒊏ۉTOłB<br>
 * <br>
 * gbNɗ\ߏo̖͐Ow肷ƁAĐƂIɓȌo̓|[gnh蓖Ă܂B
 * o̓|[gASRbNƕRtĂAo̓|[gnh蓖Ăꂽ́AASRbNčĐ܂B
 * <br>
 * ̂߁AACF̏o̓|[gnh܂߁ASĂ̏o̓|[gnh͎gpOɕK
 * ::criAtomExOutputPort_SetAsrRackId ֐œK؂ASRbNƕRtKv܂B
 * \sa criAtomExOutputPort_Create, criAtomExAcf_GetOutputPortHnByName, criAtomExOutputPort_SetAsrRackId
 */
typedef CriAtomExOutputPortObj *CriAtomExOutputPortHn;
/***************************************************************************
 *      ϐ錾
 *      Prototype Variables
 ***************************************************************************/

/***************************************************************************
 *      ֐錾
 *      Prototype Functions
 ***************************************************************************/
#ifdef __cplusplus
extern "C" {
#endif

/*==========================================================================
 *      CRI AtomEx API
 *=========================================================================*/
/*JP
 * \brief Cup[N̈TCY̌vZ
 * \ingroup ATOMEXLIB_GLOBAL
 * \param[in]	config		pRtBO\
 * \return		CriSint32	[N̈TCY
 * \retval		0ȏ		ɏ
 * \retval		-1			G[
 * \par :
 * Cugp邽߂ɕKvȁA[N̈̃TCY擾܂B<br>
 * <br>
 * [N̈TCY̌vZɎsƁA{֐ -1 Ԃ܂B<br>
 * [N̈TCY̌vZɎsRɂẮAG[R[obÑbZ[WŊmF\łB<br>
 * \par l:
 * CuKvƂ郏[N̈̃TCÝACupRtBO
 * \́i ::CriAtomExConfig j̓eɂĕω܂B<br>
 * <br>
 * NULLw肵ꍇAftHgݒ
 * i ::criAtomEx_SetDefaultConfig KpƓp[^[j
 * [N̈TCYvZ܂B
 * <br>
 *  config ̏́A֐ł̂ݎQƂ܂B<br>
 * ֐𔲂͎QƂ܂̂ŁA֐s config ̗̈Ă
 * 肠܂B
 * \attention
 * ::CriAtomExConfig \̂acf_infooɒlݒ肵ĂꍇA{֐͎s-1Ԃ܂B<br>
 * ACFf[^̓o^sꍇ́A{֐lgpmۂł͂ȂADXVXeɂ
 * AP[^[gpmۏKvɂȂ܂B
 * \sa CriAtomExConfig, criAtomEx_Initialize
 */
CriSint32 CRIAPI criAtomEx_CalculateWorkSize(const CriAtomExConfig *config);

/*JP
 * \brief Cȕ
 * \ingroup ATOMEXLIB_GLOBAL
 * \param[in]	config		pRtBO\
 * \param[in]	work		[N̈
 * \param[in]	work_size	[N̈TCY
 * \return		CriBool		łǂHiłFCRI_TRUE^łȂFCRI_FALSEj
 * \par :
 * Cu܂B<br>
 * Cű@\𗘗pɂ́AK̊֐sKv܂B<br>
 * iCű@\́A{֐sA ::criAtomEx_Finalize ֐s܂ł̊ԁA
 * p\łBj<br>
 * <br>
 * Cuۂɂ́ACuŗp邽߂̃̈i[N̈j
 * mۂKv܂B<br>
 * [N̈mۂ@ɂ́Aȉ2ʂ̕@܂B<br>
 * <b>(a) User Allocator</b>F̊mہ^ɁA[Upӂ֐gp@B<br>
 * <b>(b) Fixed Memory</b>FKvȃ̈𒼐ڃCuɓn@B<br>
 * <br>
 * ::CriAtomExConfig \̂acf_infoogpƏACFf[^̓o^s܂B<br>
 * łACFf[^o^sꍇ́AUser AllocatorŃ̈mۂKv܂B<br>
 * <br>
 * User AllocatorpꍇA[U̓CuɃmۊ֐o^Ă܂B<br>
 * workNULLAwork_size0w肵Ė{֐ĂяoƂŁA
 * Cu͓o^ς݂̃mۊ֐gpĕKvȃIɊmۂ܂B<br>
 * [U[N̈pӂKv͂܂B<br>
 * Ɋmۂꂽ́AIi ::criAtomEx_Finalize ֐sjɉ܂B<br>
 * <br>
 * Fixed MemorypꍇA[N̈Ƃĕʓrmۍς݂̃̈{֐
 * ݒ肷Kv܂B<br>
 * [N̈̃TCY ::criAtomEx_CalculateWorkSize ֐Ŏ擾\łB<br>
 * ̑O ::criAtomEx_CalculateWorkSize ֐Ŏ擾TCỸ\
 * mۂĂA{֐ɐݒ肵ĂB<br>
 * AFixed MemorypꍇA[N̈̓CȕIi ::criAtomEx_Finalize ֐j
 * s܂ł̊ԁACuŗpꑱ܂B<br>
 * CȕIsOɁA[N̈̃ȂłB<br>
 * \par :
 * yUser Allocatorɂ郉Cȕz<br>
 * User AllocatorpꍇACȕ^I̎菇͈ȉ̒ʂłB<br>
 * 	-# sOɁA ::criAtomEx_SetUserAllocator ֐pămہ^֐o^B<br>
 * 	-# pRtBO\̂Ƀp[^[ZbgB<br>
 * 	-# ::criAtomEx_Initialize ֐ŏsB<br>
 * iworkɂNULLAwork_sizeɂ0w肷Bj<br>
 * 	-# AvP[VI ::criAtomEx_Finalize ֐ŏIsB<br>
 * 	
 * <br>̓IȃR[h͈ȉ̂ƂłB<br>
 * \code
 * // Ǝ̃mۊ֐
 * void *user_malloc(void *obj, CriUint32 size)
 * {
 * 	void *mem;
 * 	
 * 	// ̊m
 * 	mem = malloc(size);
 * 	
 * 	return (mem);
 * }
 * 
 * // Ǝ̃֐p
 * void user_free(void *obj, void *mem)
 * {
 * 	// ̉
 * 	free(mem);
 * 	
 * 	return;
 * }
 * 
 * main()
 * {
 * 	CriAtomExConfig config;	// CupRtBO\
 * 		:
 * 	// Ǝ̃AP[^[o^
 * 	criAtomEx_SetUserAllocator(user_malloc, user_free, NULL);
 * 	
 * 	// CupRtBO\̂ɃftHglZbg
 * 	criAtomEx_SetDefaultConfig(&config);
 * 	
 * 	// Cȕ
 * 	// [N̈ɂNULL0w肷B
 * 	// Kvȃ́Ao^mۊ֐gĊmۂB
 * 	criAtomEx_Initialize(&config, NULL, 0);
 * 		:
 * 	// AvP[ṼC
 * 		:
 * 	// AvP[VIۂɏIs
 * 	// Ɋmۂꂽ́Ao^֐gĉB
 * 	criAtomEx_Finalize();
 * 		:
 * }
 * \endcode
 * <br>
 * yFixed Memoryɂ郉Cȕz<br>
 * Fixed MemorypꍇACȕ^I̎菇͈ȉ̒ʂłB<br>
 * 	-# pRtBO\̂Ƀp[^[ZbgB<br>
 * 	-# CȕɕKvȃ[N̈̃TCYA ::criAtomEx_CalculateWorkSize 
 * ֐gČvZB<br>
 * 	-# [N̈TCỸmۂB<br>
 * 	-# ::criAtomEx_Initialize ֐ŏsB<br>
 * iworkɂ͊mۂ̃AhXAwork_sizeɂ̓[N̈̃TCYw肷Bj<br>
 * 	-# AvP[VI ::criAtomEx_Finalize ֐ŏIsB<br>
 * 	-# [N̈̃B<br>
 * 	
 * <br>̓IȃR[h͈ȉ̂ƂłB<br>
 * \code
 * main()
 * {
 * 	CriAtomExConfig config;	// CupRtBO\
 * 	void *work;				// [N̈AhX
 * 	CriSint32 work_size;	// [N̈TCY
 * 		:
 * 	// CupRtBO\̂ɃftHglZbg
 * 	criAtomEx_SetDefaultConfig(&config);
 * 	
 * 	// CȕɕKvȃ[N̈̃TCYvZ
 * 	work_size = criAtomEx_CalculateWorkSize(&config);
 * 	
 * 	// [N̈pɃm
 * 	work = malloc((size_t)work_size);
 * 	
 * 	// Cȕ
 * 	// mۍς݂̃[N̈w肷B
 * 	criAtomEx_Initialize(&config, NULL, 0);
 * 		:
 * 	// AvP[ṼC
 * 	// ̊ԁAmۂ͕ێB
 * 		:
 * 	// AvP[VIۂɏIs
 * 	criAtomEx_Finalize();
 * 	
 * 	// KvȂȂ[N̈
 * 	free(work);
 * 		:
 * }
 * \endcode
 * \par l:
 * CuKvƂ郏[N̈̃TCÝApRtBO\̂̓eɉ
 * ω܂B<br>
 * ܂AKvȃ[N̈̃TCÝAvbgtH[ɂĂقȂ܂B
 * <br>
 *  config ̏́A֐ł̂ݎQƂ܂B<br>
 * ֐𔲂͎QƂ܂̂ŁA֐s config ̗̈Ă
 * 肠܂B
 * \attention
 * AXg[ĐsǂɊ֌WȂA Atom Cu͕K 
 * CRI File System Cű@\gp܂B<br>
 * ̂߁ACRI File SystemCȕsĂȂꍇA
 * Atom Cu͏ɓ CRI File System Cȕs܂B<br>
 * <br>
 * Atom Cu CRI File System CuꍇA
 * CRI File System ̏p[^[ƂāA ::CriAtomExConfig \̂
 * fs_config p[^[gp܂B<br>
 * fs_config  NULL ̏ꍇA Atom Cu̓ftHgp[^[i 
 * ::criFs_SetDefaultConfig }N̐ݒlj CRI File System Cu܂B<br>
 * <br>
 * A{֐s鎞_ŁA CRI File System Cuς݂łꍇA
 * {֐ł CRI File System Cȕ͍s܂B<br>
 * <br>
 * {֐sAK΂ɂȂ ::criAtomEx_Finalize ֐sĂB<br>
 * ܂A ::criAtomEx_Finalize ֐s܂ł́A{֐ēxsȂłB<br>
 * \sa CriAtomExConfig, criAtomEx_Finalize, criAtomEx_SetUserAllocator, criAtomEx_CalculateWorkSize
 */
CriBool CRIAPI criAtomEx_Initialize(
	const CriAtomExConfig *config, void *work, CriSint32 work_size);

/*JP
 * \brief CȕI
 * \ingroup ATOMEXLIB_GLOBAL
 * \par :
 * CuI܂B<br>
 * \attention
 * ::criAtomEx_Initialize ֐sOɖ{֐s邱Ƃ͂ł܂B<br>
 * \sa criAtomEx_Initialize
 */
void CRIAPI criAtomEx_Finalize(void);

/*JP
 * \brief CuԂ̎擾
 * \ingroup ATOMEXLIB_GLOBAL
 * \return	CriBool		ǂ
 * \retval	CRI_FALSE	
 * \retval	CRI_TRUE	ς
 * \par :
 * CuɏĂ邩ǂ`FbN܂B<br>
 * \sa criAtomEx_Initialize, criAtomEx_Finalize
 */
CriBool CRIAPI criAtomEx_IsInitialized(void);

/*JP
 * \brief T[o[̎s
 * \ingroup ATOMEXLIB_GLOBAL
 * \par :
 * CRI AtomCu̓ԂXV܂B<br>
 * AvP[V́Å֐IɎsKv܂B<br>
 * <br>
 * T[o[sׂ񐔂́ACũp[^[Ɉˑ܂B<br>
 * CuɃXbhf ::CRIATOMEX_THREAD_MODEL_MULTI ɐݒ肵ꍇA
 * A^C̗v鏈͑SCRI AtomCuŒIɎs邽߁A
 * {֐̌Ăяopx͏ȂĂ͔܂B<br>
 * iŒłb1xsĂ΁A؂ꓙ̖肪邱Ƃ͂܂Bj<br>
 * CuɃXbhf ::CRIATOMEX_THREAD_MODEL_SINGLE 
 * ::CRIATOMEX_THREAD_MODEL_USER_MULTI ɐݒ肵ꍇAt@C̓ǂݍ݊ǗA
 * f[^̃fR[hȀo͓AĐɕKvȏ̂قڑSĂ{֐Ŏs܂B<br>
 * ܂AĐɓāACRI File SystemCũt@CANZXƃf[^WJs܂B<br>
 * ̂߁ACuɎw肵T[o[̎spxi ::CriAtomExConfig \̂
 * server_frequency jpxŖ{֐sꍇA
 * 傫f[^̓ǂݍ݁Akt@C̓ǂݍݓsꍇA
 * ؂ꓙ̖肪\̂ŒӂĂB<br>
 * \par l:
 * CuɃXbhf ::CRIATOMEX_THREAD_MODEL_MULTI ɐݒ肵ꍇłA
 * {֐sKv܂B<br>
 * iXbhf ::CRIATOMEX_THREAD_MODEL_MULTI ̏ꍇAXe[^XXVAꕔ
 * ݂̂s߁A{֐ŒԏubN邱Ƃ͂܂Bj
 * <br>
 * CRI File SystemCũT[o[́ACRI AtomCuŎs܂B<br>
 * ̂߁A{֐sĂꍇAAvP[VŕʓrCRI File SystemCu
 * ̃T[o[ĂяoKv͂܂B<br>
 */
void CRIAPI criAtomEx_ExecuteMain(void);

/*JP
 * \brief [U[}`XbhpT[o[̎s
 * \ingroup ATOMEXLIB_GLOBAL
 * \par :
 * CRI AtomCû݂XV܂B<br>
 * Xbhf::CRIATOMEX_THREAD_MODEL_USER_MULTȈꍇA
 * AvP[V́Å֐IɎsKv܂B<br>
 * <br>
 * t@C̓ǂݍ݊ǗAf[^̃fR[hȀo͓A
 * ĐɕKvȏ̂قڑSĂ{֐Ŏs܂B<br>
 * ̂߁ACuɎw肵T[o[̎spxi ::CriAtomExConfig \̂
 * server_frequency jpxŖ{֐sꍇA؂ꓙ̖肪\
 * ܂B<br>
 * ܂A{֐::criAtomEx_ExecuteMain ֐ƈقȂACRI File SystemCũT[o[s܂B<br>
 * AvP[VKvȃT[o[𐳂ŎsĂB<br>
 * \par l:
 * ::CRIATOMEX_THREAD_MODEL_SINGLE ɐݒ肵ꍇAT[o[̔r䂪sȂ̂ŁA
 * ̃XbhĂяoȂ悤ɂĂB<br>
 * \sa criAtomEx_ExecuteMain
 */
void CRIAPI criAtomEx_ExecuteAudioProcess(void);

/*JP
 * \brief T[o[̊荞݂h~
 * \ingroup ATOMEXLIB_GLOBAL
 * \par :
 * T[o[̊荞ݗ}~܂B<br>
 * {֐sA::criAtomEx_Unlock ֐s܂ł̊ԁAT[o[̓삪}~܂B<br>
 * API𓯈I[fBIt[ŊmɎsꍇɂ́A{֐ŃT[o[
 * 荞݂h~Å֐sĂB
 * \par :
 * \code
 * 	F
 * // T[o[̊荞݂h~
 * criAtomEx_Lock();
 * 
 * // ̉̃p[^[𓯎ɍXV
 * criAtomExPlayer_SetVolume(player1, 0.5f);
 * criAtomExPlayer_SetVolume(player2, 0.6f);
 * criAtomExPlayer_SetVolume(player3, 0.7f);
 * criAtomExPlayer_SetVolume(player4, 0.8f);
 * criAtomExPlayer_UpdateAll(player1);
 * criAtomExPlayer_UpdateAll(player2);
 * criAtomExPlayer_UpdateAll(player3);
 * criAtomExPlayer_UpdateAll(player4);
 * 
 * // T[o[̊荞ݖh~
 * criAtomEx_Unlock();
 * 	F
 * \endcode
 * \attention
 * 荞ݖh~Ԃœɕ̃v[[̍ĐX^[gꍇłA
 * ȉ̗vɂĐg`TvPʂœȂꍇ܂B<br>
 * - Xg[Đ̃f[^ɔx<br>
 * - \[X̒Dɔx<br>
 * Đsꍇ́A::criAtomExPlayer_Prepare ֐gpčĐsA
 * Ɋ荞ݖh~ԂōĐJnĂB<br>
 * <br>
 * {֐sA::criAtomEx_Unlock ֐Ă΂ȂꍇAĐr؂鋰ꂪ܂B<br>
 * T[o[̊荞݂h~Ԃ́Aŏɗ}Kv܂B
 * \sa criAtomEx_Unlock
 */
void CRIAPI criAtomEx_Lock(void);

/*JP
 * \brief T[o[̊荞ݖh~
 * \ingroup ATOMEXLIB_GLOBAL
 * \par :
 * ::criAtomEx_Lock ֐ɂAT[o[̊荞ݖh~܂B
 * \sa criAtomEx_Lock
 */
void CRIAPI criAtomEx_Unlock(void);

/*JP
 * \brief ̎擾
 * \ingroup ATOMEXLIB_GLOBAL
 * \return CriUint64	i}CNbPʁj
 * \par :
 * AtomCũ}X^^C}[玞擾܂B
 * \sa criAtomEx_ResetTimer
 */
CriUint64 CRIAPI criAtomEx_GetTimeMicro(void);

/*JP
 * \brief ^C}[̃Zbg
 * \ingroup ATOMEXLIB_GLOBAL
 * \par :
 * AtomCũ}X^^C}[̎Zbg܂B<br>
 * \par l:
 * {֐ ::criAtomEx_GetTimeMicro ֐Ԃlɑ΂Ă̂݉e܂B<br>
 * {֐sĂAAtomExv[[̍ĐNA邱Ƃ͂܂B<br>
 * \sa criAtomEx_ResetTimer
 */
void CRIAPI criAtomEx_ResetTimer(void);

/*JP
 * \brief ^C}[̃|[Y
 * \ingroup ATOMEXLIB_GLOBAL
 * \param[in]	sw		CRI_TRUE=^C}[ꎞ~ACRI_FALSE=^C}[ĊJ
 * \par :
 * AtomCũ}X^^C}[ꎞ~^ĊJ܂B<br>
 * }X^^C}[ꎞ~ƁAV[PXisȂȂ܂B<br>
 * \par l:
 * {֐ AvP[Vx~ꎞ~悤ȃvbgtH[ɂāA<br>
 * x~ꎞ~ł^C}[isĂ܂vbgtH[̋@\łB<br>
 * AvP[Vx~Ԃꎞ~ԂɑJڂO<br>
 * {֐Ń}X^^C}[ꎞ~ĂƂŁAx~̃V[PX̐is~߂鎖ł܂B<br>
 * \attention
 * {֐ňꎞ~Ώۂ͂܂AtomCũ}X^^C}[łB<br>
 * {֐ł͔̃{CXꎞ~ł܂B
 * {֐Őݒ肵|[YtÓACRI AtomT[o[sꂽ^C~OŔf܂B<br>
 * ɓƂKvꍇ́A::criAtomEx_ExecuteAudioProcess ֐ĂяoœƂ邱Ƃł܂B<br>
 * A::criAtomEx_ExecuteAudioProcessĂяoXbhŃI[fBIs邽߁A
 * CPUׂeł邩ɒӂĂB<br>
 * \sa criAtomEx_ResetTimer
 */
void CRIAPI criAtomEx_PauseTimer(CriBool sw);

/*JP
 * \brief [N̈TCYvZpRtBO\̂̐ݒ
 * \ingroup ATOMEXLIB_GLOBAL
 * \param[in]	config		pRtBO\
 * \par :
 * [N̈TCY̌vZpɁACupRtBO\
 * i ::CriAtomExConfig \́jo^܂B<br>
 * <br>
 * ACF̓o^{CXv[̍쐬ɕKvȃ[N̈̃TCÝA
 * Cui ::criAtomEx_Initialize ֐sj
 * ɐݒ肷\̂̃p[^[ɂĕω܂B<br>
 * ̂߁AʏACF̓o^{CXv[̍쐬ɕKvȃ[N̈TCYvZOɁA
 * CuKv܂B<br>
 * {֐gpăCupRtBO\̂o^ꍇA
 * ACF̓o^{CXv[̍쐬ɕKvȃ[N̈̃TCYA
 * ȂɌvZ\ɂȂ܂B<br>
 * <br>
 * {֐s邱ƂŁAȉ̏ȂɎs\ƂȂ܂B<br>
 * - ::criAtomEx_CalculateWorkSizeForRegisterAcfData ֐
 * - {CXv[쐬p[N̈TCY̌vZ<br>
 * i ::criAtomExVoicePool_CalculateWorkSizeForStandardVoicePool ֐j
 * 
 * \par l:
 * i config j NULL w肵ꍇAftHgݒ
 * i ::criAtomEx_SetDefaultConfig KpƓp[^[j
 * [N̈TCYvZ܂B<br>
 * <br>
 * A{֐ňURtBO\̂ݒ肷ƁA
 * ݒȌԁiԂł̃[N̈TCYvZG[Ƃ铮j
 * ɖ߂ƂłȂȂ܂B<br>
 * i֐ēxsăp[^[㏑邱Ƃ͉\łBj<br>
 * \attention
 * {֐œo^pRtBO\̂́A
 * CuԂł̃[N̈TCYvZɂgp܂B<br>
 * Cuɂ͖{֐ɐݒ肵p[^[ł͂ȂA
 * Ɏw肳ꂽp[^[[N̈TCY̌vZɎgp܂B<br>
 * i{֐œo^\̂̃p[^[ƁA
 * CȕɎgp\̂̃p[^[قȂꍇA
 * [N̈TCYsAnh̍쐬Ɏs鋰ꂪ܂Bj<br>
 * <br>
 * ::criAtomEx_RegisterAcfFile ֐ ::criAtomExAcb_LoadAcbFile ֐A
 * [N̈vZɃt@CANZXKvɂȂ API ɂẮA
 * {֐sꍇł[N̈TCY̌vZs܂B<br>
 * i[N̈TCYvZ邽߂ɂ̓CuKv
 * ܂Bj<br>
 * \par :
 * \code
 * 	CriAtomExConfig atomex_config;
 * 	
 * 	// CupRtBO\̂ɃftHglݒ
 * 	criAtomEx_SetDefaultConfig(&atomex_config);
 * 	
 * 	// Cup[N̈TCY̌vZ
 * 	lib_work_size = criAtomEx_CalculateWorkSize(&atomex_config);
 * 	
 * 	// TuW[̃[N̈TCYvZpɃp[^[o^
 * 	criAtomEx_SetConfigForWorkSizeCalculation(&atomex_config);
 * 	
 * 	// TuW[̃[N̈TCYvZ
 * 	acf_work_size = criAtomEx_CalculateWorkSizeForRegisterAcfData(acf_data, acf_data_size);
 * 	vp_work_size = criAtomExVoicePool_CalculateWorkSizeForStandardVoicePool(NULL);
 * 		F
 * \endcode
 * \sa criAtomEx_CalculateWorkSizeForRegisterAcfData, criAtomExVoicePool_CalculateWorkSizeForStandardVoicePool
 */
void CRIAPI criAtomEx_SetConfigForWorkSizeCalculation(const CriAtomExConfig *config);

/*JP
 * \brief IACFf[^̓o^ɕKvȃ[N̈TCY̌vZ
 * \ingroup ATOMEXLIB_GLOBAL
 * \param[in]	acf_data		ACFf[^AhX
 * \param[in]	acf_data_size	ACFf[^TCY
 * \return		CriSint32		[N̈TCY
 * \retval		0ȏ			ɏ
 * \retval		-1				G[
 * \par :
 * ::criAtomEx_RegisterAcfData ֐̎sɕKvȃ[N̈TCYvZ܂B<br>
 * ::criAtomEx_SetUserAllocator }NɂAP[^[o^s킸
 * ::criAtomEx_RegisterAcfData ֐ACFo^ۂɂ́A
 * {֐ԂTCỸ[N̈ƂēnKv܂B<br>
 * <br>
 * [N̈TCY̌vZɎsƁA{֐ -1 Ԃ܂B<br>
 * [N̈TCY̌vZɎsRɂẮAG[R[obÑbZ[WŊmF\łB<br>
 * \attention
 * [N̈̃TCY̓Cui ::criAtomEx_Initialize ֐sj
 * Ɏw肵p[^[ɂĕω܂B<br>
 * ̂߁A{֐sOɁACuĂKv܂B<br>
 * \sa criAtomEx_RegisterAcfData
 */
CriSint32 CRIAPI criAtomEx_CalculateWorkSizeForRegisterAcfData(
	void *acf_data, CriSint32 acf_data_size);

/*JP
 * \brief IACFf[^̓o^
 * \ingroup ATOMEXLIB_GLOBAL
 * \param[in]	acf_data		ACFf[^AhX
 * \param[in]	acf_data_size	ACFf[^TCY
 * \param[in]	work		[N̈
 * \param[in]	work_size	[N̈TCY
 * \return		CriBool		f[^̓o^ɐ
 * \par :
 * ɔzuꂽACFf[^CuɎ荞݂܂B<br>
 * ACF̓o^ɕKvȃ[N̈̃TCÝA
 * ::criAtomEx_CalculateWorkSizeForRegisterAcfData ֐ŌvZ܂B<br>
 * ACFt@C̓o^ɐƁA{֐͖߂lƂ CRI_TRUE Ԃ܂B<br>
 * f[^sȂǂ̗RɂACFt@C̓ǂݍ݂ɎsꍇA{֐͖߂l
 * ƂCRI_FALSE Ԃ܂B<br>
 * \par l:
 * ::criAtomEx_SetUserAllocator }NgpăAP[^[o^ς݂̏ꍇA
 * {֐Ƀ[N̈w肷Kv͂܂B<br>
 * i work  NULL A work_size  0 w肷邱ƂŁAo^ς݂̃AP[^[
 * Kvȃ[N̈TCỸIɊmۂ܂Bj
 * \attention
 * {֐sOɁACuĂKv܂B<br>
 * <br>
 * {֐́A֐sɍĐׂ̉Ē~܂B<br>
 * ܂Av[[ɐݒ肵ȉACFɊ֘Ap[^[SăZbg܂B<br>
 *  -# AISAC
 *  -# AISACRg[l
 *  -# JeS
 *  -# ZN^[x
 *  -# oXZh
 * 	
 * <br>
 * {֐ɃZbgf[^̈ƃ[N̈́A ::criAtomEx_UnregisterAcf ֐s܂ł̊ԁA
 * AvP[VŕێKv܂B<br>
 * i ::criAtomEx_UnregisterAcf ֐sOɁA[N̈̃ȂłBj
 * ܂Af[^̈̈ꕔ̓[NƂĎgp܂B<br>
 * \sa criAtomEx_UnregisterAcf
 */
CriBool CRIAPI criAtomEx_RegisterAcfData(
	void *acf_data, CriSint32 acf_data_size, void *work, CriSint32 work_size);

/*JP
 * \brief ACFt@C̓o^ɕKvȃ[N̈TCY̌vZ
 * \ingroup ATOMEXLIB_GLOBAL
 * \param[in]	binder		oC_[nh
 * \param[in]	path		t@CpX
 * \return		CriSint32	[N̈TCY
 * \retval		0ȏ		ɏ
 * \retval		-1			G[
 * \par :
 * ::criAtomEx_RegisterAcfFile ֐̎sɕKvȃ[N̈TCYvZ܂B<br>
 * {֐́A ::criAtomEx_SetUserAllocator }NɂAP[^[o^̗Lɂ
 * vZɎgpvfقȂ܂B
 * - AP[^[o^FACFt@CꎞIɓǂݍ݁AACFɋL^ĂJeSA
 * ĐPʂł̃JeSQƐAREACTgpTCYvZs܂B<br>
 * - AP[^[o^FCuɎw肵 ::CriAtomExConfig \̂
 * max_categoriesoAcategories_per_playbackogpTCYvZs܂B<br>
 * <br>
 * [N̈TCY̌vZɎsƁA{֐ -1 Ԃ܂B<br>
 * [N̈TCY̌vZɎsRɂẮAG[R[obÑbZ[WŊmF\łB<br>
 * \par lF
 * f[^CPKɃpbNĂȂꍇAbinderɂNULLw肵ĂB<br>
 * \attention
 * {֐sOɁACuĂKv܂B<br>
 * \sa criAtomEx_RegisterAcfFile
 */
CriSint32 CRIAPI criAtomEx_CalculateWorkSizeForRegisterAcfFile(
	CriFsBinderHn binder, const CriChar8 *path);

/*JP
 * \brief ACFt@C̓o^ɕKvȃ[N̈TCY̌vZiCPKRecIDwj
 * \ingroup ATOMEXLIB_GLOBAL
 * \param[in]	binder		oC_[nh
 * \param[in]	id			CPKRecID
 * \return		CriSint32	[N̈TCY
 * \retval		0ȏ		ɏ
 * \retval		-1			G[
 * \par :
 * ::criAtomEx_RegisterAcfFileById ֐̎sɕKvȃ[N̈TCYvZ܂B<br>
 * t@CpX̑CPKRecIDw肷_΁A
 * ::criAtomEx_CalculateWorkSizeForRegisterAcfFile ֐Ƌ@\͓łB<br>
 * \par lF
 * f[^CPKɃpbNĂȂꍇAbinderɂNULLw肵ĂB<br>
 * \sa criAtomEx_CalculateWorkSizeForRegisterAcfFile, criAtomEx_RegisterAcfFileById
 */
CriSint32 CRIAPI criAtomEx_CalculateWorkSizeForRegisterAcfFileById(
	CriFsBinderHn binder, CriUint16 id);

/*JP
 * \brief ACFt@C̓o^
 * \ingroup ATOMEXLIB_GLOBAL
 * \param[in]	binder		oC_[nh
 * \param[in]	path		t@CpX
 * \param[in]	work		[N̈
 * \param[in]	work_size	[N̈TCY
 * \return		CriBool		t@Cǂݍ݌
 * \par :
 * ACFt@C[hACuɎ荞݂܂B<br>
 * ::criAtomEx_SetUserAllocator }NgpăAP[^[o^ς݂̏ꍇA
 * {֐Ƀ[N̈w肷Kv͂܂B<br>
 * i work  NULL A work_size  0 w肷邱ƂŁAo^ς݂̃AP[^[
 * Kvȃ[N̈TCỸIɊmۂ܂Bj
 * [N̈w肵Ė{֐gpꍇA ::criAtomEx_CalculateWorkSizeForRegisterAcfFile ֐
 * gpă[NTCYvZĂB<br>
 * <br>
 * ACFt@C̓o^ɐƁA{֐͖߂lƂ CRI_TRUE Ԃ܂B<br>
 * [hG[ɂACFt@C̓ǂݍ݂ɎsꍇA{֐͖߂lƂ
 * CRI_FALSE Ԃ܂B<br>
 * \par l:
 * f[^CPKɃpbNĂȂꍇAbinderɂNULLw肵ĂB<br>
 * \attention
 * {֐sOɁACuĂKv܂B<br>
 * <br>
 * {֐́A֐sɍĐׂ̉Ē~܂B<br>
 * ܂Av[[ɐݒ肵ȉACFɊ֘Ap[^[SăZbg܂B<br>
 *  -# AISAC
 *  -# AISACRg[l
 *  -# JeS
 *  -# ZN^[x
 *  -# oXZh
 * 	
 * <br>
 * ::criAtomEx_SetUserAllocator }NɂAP[^[o^s킸
 * ::criAtomEx_CalculateWorkSizeForRegisterAcfFile ֐ɂČvZ[NTCY
 * [N̈w肵{֐̌ĂяoCRI_FALSEԂꂽꍇA[N̈sv
 * ̉\܂B<br>
 * CuɎw肷 ::CriAtomExConfig \̂̈ȉ̃o̐ݒl
 * K؂ł邩mFĂB<br>
 * - max_categoriesFACF̃JeSAREACTƓlȏ<br>
 * - categories_per_playbackFACF̍ĐPʂł̃JeSQƐƓlȏ<br>
 * <br>
 * {֐ɃZbg[N̈́A ::criAtomEx_UnregisterAcf ֐s܂ł̊ԁA
 * AvP[VŕێKv܂B<br>
 * i ::criAtomEx_UnregisterAcf ֐sOɁA[N̈̃ȂłBj
 * \sa criAtomEx_UnregisterAcf
 */
CriBool CRIAPI criAtomEx_RegisterAcfFile(
	CriFsBinderHn binder, const CriChar8 *path, void *work, CriSint32 work_size);

/*JP
 * \brief ACFt@C̓o^iCPKRecIDwj
 * \ingroup ATOMEXLIB_GLOBAL
 * \param[in]	binder		oC_[nh
 * \param[in]	id			CPKRecID
 * \param[in]	work		[N̈
 * \param[in]	work_size	[N̈TCY
 * \return		CriBool		t@Cǂݍ݌
 * \par :
 * ACFt@C[hACuɎ荞݂܂B<br>
 * t@CpX̑CPKRecIDw肷_΁A
 * ::criAtomEx_RegisterAcfFile ֐Ƌ@\͓łB<br>
 * \par lF
 * f[^CPKɃpbNĂȂꍇAbinderɂNULLw肵ĂB<br>
 * \attention
 * {֐́A֐sɍĐׂ̉Ē~܂B<br>
 * ܂Av[[ɐݒ肵p[^[SăZbg܂B<br>
 * \sa criAtomEx_RegisterAcfFile
 */
CriBool CRIAPI criAtomEx_RegisterAcfFileById(
	CriFsBinderHn binder, CriUint16 id, void *work, CriSint32 work_size);

/*JP
 * \brief ACF̓o^
 * \ingroup ATOMEXLIB_GLOBAL
 * \par :
 * ACF̓o^܂B<br>
 * \attention
 * {֐́A֐sɍĐׂ̉Ē~܂B<br>
 * ܂Av[[ɐݒ肵p[^[SăZbg܂B<br>
 * iACFt@Co^ĂȂۂɁAĐɖ{֐sꍇ͉͒~܂j
 * ::criAtomEx_RegisterAcfFile ֐sOɖ{֐s邱Ƃ͂ł܂B<br>
 * \sa criAtomEx_RegisterAcfData, criAtomEx_RegisterAcfFile, criAtomEx_RegisterAcfFileById
 */
void CRIAPI criAtomEx_UnregisterAcf(void);

/*JP
 * \brief IACF̃o[W擾
 * \ingroup ATOMEXLIB_GLOBAL
 * \param[in]	acf_data		ACFf[^AhX
 * \param[in]	acf_data_size	ACFf[^TCY
 * \param[out]	flag			WXg\tO
 * \return		CriUint32		ACFtH[}bgo[W
 * \par :
 * ɔzuꂽACFf[^̃tH[}bgo[W擾܂B<br>
 * ܂AflagɃWXg\ȃo[WǂBoollŕԂ܂B<br>
 */
CriUint32 CRIAPI criAtomEx_GetAcfVersion(
	void *acf_data, CriSint32 acf_data_size, CriBool *flag);

/*JP
 * \brief ACFt@C̃o[W擾
 * \ingroup ATOMEXLIB_GLOBAL
 * \param[in]	binder		oC_[nh
 * \param[in]	path		t@CpX
 * \param[in]	work		[N̈
 * \param[in]	work_size	[N̈TCY
 * \param[out]	flag		WXg\tO
 * \return		CriUint2	ACFtH[}bgo[W
 * \par :
 * ACFt@C[hAACFf[^̃tH[}bgo[W擾܂B<br>
 * ACF̓o^ɕKvȃ[N̈̃TCÝA
 * ::criAtomEx_CalculateWorkSizeForRegisterAcfFile ֐ŌvZ܂B<br>
 * <br>
 * ACFt@CtH[}bgo[WflagɃWXg\ȃo[WǂBoollŕԂ܂B<br>
 * \par l:
 * ::criAtomEx_SetUserAllocator }NgpăAP[^[o^ς݂̏ꍇA
 * {֐Ƀ[N̈w肷Kv͂܂B<br>
 * i work  NULL A work_size  0 w肷邱ƂŁAo^ς݂̃AP[^[
 * Kvȃ[N̈TCỸIɊmۂ܂Bj
 * <br>
 * f[^CPKɃpbNĂȂꍇAbinderɂNULLw肵ĂB<br>
 * \attention
 * {֐ɃZbg[N̈́A AvP[VŕێKv͂܂B<br>
 * i[hf[^͊֐Iɉ܂Bj
 */
CriUint32 CRIAPI criAtomEx_GetAcfVersionFromFile(
	CriFsBinderHn binder, const CriChar8 *path, void *work, CriSint32 work_size, CriBool *flag);

/*JP
 * \brief ACFt@C̃o[W擾iCPKRecIDwj
 * \ingroup ATOMEXLIB_GLOBAL
 * \param[in]	binder		oC_[nh
 * \param[in]	id			CPKRecID
 * \param[in]	work		[N̈
 * \param[in]	work_size	[N̈TCY
 * \param[out]	flag		WXg\tO
 * \return		CriUint2	ACFtH[}bgo[W
 * \par :
 * ACFt@C[hAACFf[^̃tH[}bgo[W擾܂B<br>
 * t@CpX̑CPKRecIDw肷_΁A
 * ::criAtomEx_GetAcfVersionFromFile ֐Ƌ@\͓łB<br>
 * \par lF
 * f[^CPKɃpbNĂȂꍇAbinderɂNULLw肵ĂB<br>
 * \sa criAtomEx_GetAcfVersionFromFile
 */
CriUint32 CRIAPI criAtomEx_GetAcfVersionFromFileById(
	CriFsBinderHn binder, CriUint16 id, void *work, CriSint32 work_size, CriBool *flag);

/*JP
 * \brief WXg\o[W擾
 * \ingroup ATOMEXLIB_GLOBAL
 * \param[out]	version_low		WXg\ʃo[W
 * \param[out]	version_high	WXg\ʃo[W
 * \par :
 * WXg\ACF̃o[W擾܂B<br>
 * ʃo[W̓Curh_ł̏̂߁A̒lʂACFł
 * WXg\ȏꍇ܂B<br>
 */
void CRIAPI criAtomEx_GetSupportedAcfVersion(
	CriUint32 *version_low, CriUint32 *version_high);

/*JP
 * \brief I[fBIwb_[̉
 * \ingroup ATOMEXLIB_GLOBAL
 * \param[in]	buffer			I[fBIf[^i[obt@[
 * \param[in]	buffer_size		I[fBIf[^i[obt@[̃TCY
 * \param[out]	info			tH[}bg
 * \return		CriBool			tH[}bg񂪎擾łǂHi擾łFCRI_TRUE^擾łȂFCRI_FALSEj
 * \par :
 * Ƀ[hꂽf[^̃tH[}bg͂܂B<br>
 * ͂ɐƁA{֐ CRI_TRUE ԂAf[^̃tH[}bg
 * 3i info jɊi[܂B<br>
 * ͂ɎsꍇA{֐ CRI_FALSE Ԃ܂B<br>
 * \par l:
 * {֐̑1i buffer jɂ́AI[fBIf[^̃wb_[̈
 * it@C̐擪[h́ji[ĂKv܂B<br>
 * f[^̓rZbgꍇAwb_[Oɗ]vȃf[^tĂꍇA
 * wb_[̓r܂łi[ĂȂꍇɂ́A{֐̓tH[}bg̉͂Ɏs܂B<br>
 * ADXf[^HCAf[^ɂẮAt@C̐擪2048oCg̗̈Zbg΁A
 * tH[}bg̉͂Ɏs邱Ƃ͂܂B<br>
 * \attention
 * A{֐ADXf[^HCAf[^̉͂ɂΉĂ܂B<br>
 * HCA-MXf[^ɂĂ͉͉͂\łAwb_[񂩂HCAf[^Ȃ̂
 * HCA-MXf[^Ȃ̂͋ʂłȂ߁AtH[}bgʂƂ
 * CRIATOMEX_FORMAT_HCA Ԃ܂B<br>
 */
CriBool CRIAPI criAtomEx_AnalyzeAudioHeader(
	const void *buffer, CriSint32 buffer_size, CriAtomExFormatInfo *info);

/*JP
 * \brief ̐ݒ
 * \ingroup ATOMEXLIB_GLOBAL
 * \param[in]	seed		
 * \par :
 * CRI AtomCuŜŋL^ɗݒ肵܂B<br>
 * ݒ肷邱ƂɂAe탉_ĐɍČ邱Ƃł܂B<br>
 * AtomExv[[ƂɍČꍇ́A::criAtomExPlayer_SetRandomSeed ֐gpĂB
 * <br>
 * \sa criAtomExPlayer_SetRandomSeed
 */
void CRIAPI criAtomEx_SetRandomSeed(CriUint32 seed);

/*JP
 * \brief ACBnh\ǂ̃`FbN
 * \ingroup ATOMLIBEX_ACB
 * \param[in]	buffer		obt@[
 * \param[in]	size		obt@[TCY
 * \return		CriBool		ĐǂiCRI_TRUE = Đ̃v[[ACRI_FALSE = Đ̃v[[Ȃj
 * \par :
 * ::criAtomExPlayer_SetData ֐ŃZbgobt@[̈悪\ǂ`FbN܂B<br>
 * \par l:
 * ĐsĂAtomExv[[SĒ~ꍇłA
 * Cuɂ͓ŸQƂĂ{CX݂\܂B<br>
 * i ::criAtomExPlayer_StopWithoutReleaseTime ֐Œ~sꍇA
 * {CX̒D肪ꍇAAtomExv[[{CX͐؂藣܂A
 * {CXSɒ~܂ł̊ԁAf[^͎QƂ\܂Bj<br>
 * \attention
 * {֐sƁAw肵f[^̈QƂĂAtomv[[݂̑
 * 鏈삵܂B<br>
 * ̂߁A{֐sɑXbhAtomv[[̍쐬^jsƁA
 * ANZXᔽfbhbN̏dȕsU鋰ꂪ܂B<br>
 * {֐sAtomv[[̍쐬^j𑼃XbhōsKvꍇA
 * Atomv[[̍쐬^j ::criAtomEx_Lock ֐ŃbNĂsB<br>
 * <br>
 * ::criAtomExPlayer_SetData ֐ŃZbgobt@[ۂɂ́A
 * f[^Zbgv[[ɑ΂~sA
 * {֐ CRI_FALSE ԂԂɂȂ܂ő҂Kv܂B<br>
 * {֐ CRI_TRUE Ԃ^C~OŃobt@[̈ꍇA
 * ANZXᔽ̒vIȖ肪\܂B<br>
 * \sa criAtomExPlayer_SetData
 */
CriBool CRIAPI criAtomEx_IsDataPlaying(void *buffer, CriSint32 size);

/*JP
 * \brief Xg[~O̎擾
 * \ingroup ATOMEXLIB_GLOBAL
 * \param[out]	streaming_info	Xg[~Oۑ̃|C^
 * \retval		CRI_TRUE	l擾ł
 * \retval		CRI_FALSE	l擾łȂ
 * \par :
 * CRI AtomCũXg[~OǗW[Xg[~O擾܂B<br>
 * {֐́AĂяoꂽ_̃Xg[~O streaming_info ɕۑ܂B<br>
 * \attention
 * AtomT[o[̏ƈꕔr䂵Ă邽߁A
 * Dxt]ɂAtomT[o[~߂Ă܂Ȃ悤ɒӂĂB<br>
 * ꕔ̃vbgtH[ł́AXg[~O擾ł܂B<br>
 * {֐̖߂lmFĂB<br>
 * G[ŃXg[~O擾łȂꍇɂẮA<br>
 * G[R[obNĂȂmFĂB
 * \sa CriExAtomStreamingInfo
 */
#define criAtomEx_GetStreamingInfo(streaming_info) \
	criAtom_GetStreamingInfo(streaming_info)

/*JP
 * \brief t@CI/Ő󂫎ԂgXg[~Oǂݍ݂sǂ
 * \ingroup ATOMEXLIB_GLOBAL
 * \param[in]	flag	CRI_TRUE=t@CI/Ő󂫎Ԃgēǂݍ
 * \retval		CRI_TRUE	ɏ
 * \retval		CRI_FALSE	G[
 * \par :
 * CRI AtomCũXg[~OǗW[ɑ΂āA<br>
 * t@CI/Ő󂫎ԂgăXg[~Oǂݍ݂sǂݒ肵܂B<br>
 * CRI_TRUEݒ肷ƁACRI AtomCũXg[~OǗW[
 * t@CI/Ő󂫎ԂgāA󂫃obt@[ɑ΂ăf[^]ɓǂݍ݂܂B<br>
 * CRI_FALSEݒ肷ƁACRI AtomCũXg[~OǗW[
 * t@CI/Ő󂫎ԂgȂȂA]ȃXg[~Oǂݍ݂sȂȂ܂B<br>
 * ftHgłCRI_TRUEݒ肵ԂłB<br>
 * \par lF
 * t@CI/Ő󂫎ԂgA󂫃obt@[ɑ΂ăf[^]ɓǂݍłƂŁA
 * V[N̔px炷łAIȃt@CI/Ǒサ܂B<br>
 * Aʏt@C̃[h́AXg[~O̓ǂݍ݂DxႢ߁A
 * 󂫃obt@[傫ƒʏt@C̃[h啝ɒxĂ܂܂B<br>
 * \attention
 * AtomT[o[̏ƈꕔr䂵Ă邽߁A
 * Dxt]ɂAtomT[o[~߂Ă܂Ȃ悤ɒӂĂB
 */
#define criAtomEx_SetFreeTimeBufferingFlagForDefaultDevice(flag) \
	criAtom_SetFreeTimeBufferingFlagForDefaultDevice(flag)

/*JP
 * \brief DSPoXݒ̃A^b`p[NTCY̌vZ
 * \ingroup ATOMEXLIB_GLOBAL
 * \param[in]	setting		DSPoXݒ̖O
 * \return		CriSint32	Kv[N̈TCY
 * \retval		0ȏ		ɏ
 * \retval		-1			G[
 * \par :
 * DSPoXݒ肩DSPoX\ẑɕKvȃ[N̈TCYvZ܂B<br>
 * {֐sɂ́A炩ACFo^ĂKv܂<br>
 * <br>
 * [N̈TCY̌vZɎsƁA{֐ -1 Ԃ܂B<br>
 * [N̈TCY̌vZɎsRɂẮAG[R[obÑbZ[WŊmF\łB<br>
 * \par l:
 * DSPoXݒ̃A^b`ɕKvȃ[ÑTCÝACRI Atom Craftō쐬
 * DSPoXݒ̓eɂĕω܂B<br>
 * \sa criAtomEx_AttachDspBusSetting, criAtomEx_RegisterAcfData, criAtomEx_RegisterAcfFile,
 * criAtomEx_RegisterAcfFileById
 */
CriSint32 CRIAPI criAtomEx_CalculateWorkSizeForDspBusSetting(
	const CriChar8 *setting);

/*JP
 * \brief DSPoXݒ̃A^b`p[NTCY̌vZ
 * \ingroup ATOMEXLIB_GLOBAL
 * \param[in]	acf_data		ACFf[^
 * \param[in]	acf_buffer_size	ACFf[^TCY
 * \param[in]	setting_name	DSPoXݒ̖O
 * \return		CriSint32		Kv[N̈TCY
 * \par :
 * DSPoXݒ肩DSPoX\ẑɕKvȃ[N̈TCYvZ܂B<br>
 * ::criAtomEx_CalculateWorkSizeForDspBusSetting ֐ƈႢA
 * ACFo^Oł{֐͎s\łB<br>
 * iAACFf[^OɃɃ[hA
 * ::criAtomExAsr_SetConfigForWorkSizeCalculation 
 * ֐ASRpRtBO\̂o^ĂKv܂Bj<br>
 * <br>
 * [N̈TCY̌vZɎsƁA{֐ -1 Ԃ܂B<br>
 * [N̈TCY̌vZɎsRɂẮA
 * G[R[obÑbZ[WŊmF\łB<br>
 * \par l:
 * DSPoXݒ̃A^b`ɕKvȃ[ÑTCÝACRI Atom Craftō쐬
 * DSPoXݒ̓eɂĕω܂B<br>
 * \attention
 * n[hEFADSPgpvbgtH[iASRgpȂvbgtH[jł́A
 * {֐Ń[N̈TCY擾邱ƂłȂ\܂B<br>
 * i{֐sɃG[R[obNAlԂ\܂Bj<br>
 * {֐삵ȂvbgtH[ɂẮA
 * Cȕ ::criAtomEx_CalculateWorkSizeForDspBusSetting 
 * ֐gpĕKvȃ[N̈TCYvZĂB<br>
 * \sa criAtomEx_AttachDspBusSetting, criAtomEx_RegisterAcfData, criAtomEx_RegisterAcfFile,
 * criAtomEx_RegisterAcfFileById, criAtomExAsr_SetConfigForWorkSizeCalculation, 
 * criAtomEx_CalculateWorkSizeForDspBusSetting
 */
CriSint32 CRIAPI criAtomEx_CalculateWorkSizeForDspBusSettingFromAcfData(
	void *acf_data, CriSint32 acf_buffer_size, const CriChar8 *setting_name);

/*JP
 * \brief DSPoXݒ̃A^b`
 * \ingroup ATOMEXLIB_GLOBAL
 * \param[in]	setting		DSPoXݒ̖O
 * \param[in]	work		[N̈
 * \param[in]	work_size	[N̈TCY
 * \par :
 * DSPoXݒ肩DSPoX\zăTEh_ɃA^b`܂B<br>
 * {֐sɂ́A炩ACFo^ĂKv܂B<br>
 * \code
 *		F
 * 	// ACFt@C̓ǂݍ݂Ɠo^
 * 	criAtomEx_RegisterAcfFile(NULL, "Sample.acf", NULL, 0);
 * 	
 * 	// DSPoXݒ̓Kp
 * 	criAtomEx_AttachDspBusSetting("DspBusSetting_0", NULL, 0);
 * 		F
 * \endcode
 * \par l:
 * DSPoXݒ̃A^b`ɕKvȃ[ÑTCÝA
 * CRI Atom Craftō쐬DSPoXݒ̓eɂĕω܂B<br>
 * \attention
 * {֐͊A^̊֐łB<br>
 * {֐sƁA΂炭̊AtomCũT[o[ubN܂B<br>
 * Đɖ{֐sƁAr؂ꓙ̕s\邽߁A
 * {֐̌Ăяo̓V[̐؂ւ蓙Aוϓeł^C~OōsĂB<br>
 * \sa criAtomEx_DetachDspBusSetting, criAtomEx_RegisterAcfData, criAtomEx_RegisterAcfFile,
 * criAtomEx_RegisterAcfFileById
 */
void CRIAPI criAtomEx_AttachDspBusSetting(
	const CriChar8 *setting, void *work, CriSint32 work_size);

/*JP
 * \brief DSPoXݒ̃f^b`
 * \ingroup ATOMEXLIB_GLOBAL
 * \par :
 * DSPoXݒf^b`܂B<br>
 * ::criAtomEx_SetUserAllocator }NgpăAP[^[o^ς݂̏ꍇA
 * DSPoXݒA^b`Ɋmۂꂽ̈悪܂B<br>
 * iDSPoXݒA^b`Ƀ[N̈nꍇA{֐sł
 * [N̈\łBj<br>
 * \attention
 * {֐͊A^̊֐łB<br>
 * {֐sƁA΂炭̊AtomCũT[o[ubN܂B<br>
 * Đɖ{֐sƁAr؂ꓙ̕s\邽߁A
 * {֐̌Ăяo̓V[̐؂ւ蓙Aוϓeł^C~OōsĂB
 * \sa criAtomEx_AttachDspBusSetting
 */
void CRIAPI criAtomEx_DetachDspBusSetting(void);

/*JP
 * \brief DSPoXXibvVbg̓Kp
 * \ingroup ATOMEXLIB_GLOBAL
 * \param[in]	snapshot_name	XibvVbg
 * \param[in]	time_ms			ԁi~bj
 * \par :
 * DSPoXXibvVbgKp܂B<br>
 * {֐ĂяoƁAXibvVbgŐݒ肵p[^[ time_ms |ĕω܂B<br>
 *  snapshot_name  CRI_NULL w肷ƁADSPoXݒ̏ԁiXibvVbgKpĂȂԁjɖ߂܂B<br>
 * \sa criAtomEx_AttachDspBusSetting
 */
void CRIAPI criAtomEx_ApplyDspBusSnapshot(const CriChar8 *snapshot_name, CriSint32 time_ms);

/*JP
 * \brief KpDSPoXXibvVbg̎擾
 * \ingroup ATOMEXLIB_GLOBAL
 * \return	const CriChar8*	XibvVbgւ̃|C^B
 *							XibvVbgKpĂȂꍇ擾ɎsꍇCRI_NULLԂ܂B
 * \par :
 * KpDSPoXXibvVbg擾܂B
 * XibvVbgKpĂȂꍇCRI_NULLԂ܂B
 * \sa criAtomEx_ApplyDspBusSnapshot
 */
const CriChar8* CRIAPI criAtomEx_GetAppliedDspBusSnapshotName(void);

/*JP
 * \brief L[NR[obN֐̓o^
 * \ingroup ATOMEXLIB_GLOBAL
 * \param[in]	func		L[NR[obN֐
 * \param[in]	obj			[UwIuWFNg
 * \par :
 * L[ĐɃL[NۂɁAL[N󂯎R[obN֐o^܂B<br>
 * \attention
 * o^ꂽR[obN֐́ACuŃL[N^C~OŎs܂B<br>
 * ̂߁ACuւ̊荞݂lȂAPIsꍇA
 * G[AfbhbN\܂B<br>
 * {IɁAR[obN֐łAtomCuAPIgpȂłB<br>
 * {R[obN֐ŒԏubNƁA؂ꓙ̖肪܂̂ŁA
 * ӂB<br>
 * <br>
 * R[obN֐1o^ł܂B<br>
 * o^𕡐sꍇAɓo^ς݂̃R[obN֐A
 * ォo^R[obN֐ɂ㏑Ă܂܂B<br>
 * <br>
 * funcNULLw肷邱Ƃœo^ς݊֐̓o^s܂B<br>
 * \sa CriAtomExCueLinkCbFunc
 */
void CRIAPI criAtomEx_SetCueLinkCallback(CriAtomExCueLinkCbFunc func, void* obj);

/*JP
 * \brief 5.1chXs[J[px̐ݒ
 * \ingroup ATOMEXLIB_GLOBAL
 * \param[in]	angle_l		tgtgXs[J[̊px
 * \param[in]	angle_r		tgCgXs[J[̊px
 * \param[in]	angle_sl	TEhtgXs[J[̊px
 * \param[in]	angle_sr	TEhCgXs[J[̊px
 * \par :
 * p3D3D|WVjǑvZɎgpAo̓Xs[J[̊pxizujݒ肵܂B<br>
 * px́Aʕ0xƂ-180x180x̊ԂŐݒ肵ĂB
 * \attention
 * {֐5.1ch̃pXs[J[^Cv (4CH ܂ 5CH) ɂ̂݉e܂B<br>
 * 7.1ch̃pXs[J[^Cv (6CH ܂ 7CH) ̃Xs[J[pxύXꍇ́A::criAtomEx_SetSpeakerAngleArray ֐gpĂB<br>
 * <br>
 * ݒ肷Xs[J[px́Aangle_sl < angle_l < angle_r < angle_sr ̏ƂȂ悤ȔzuɂKv܂B<br>
 * F
 * \code 
 * criAtomEx_SetSpeakerAngles(-45.0f, 45.0f, -135.0f, 135.0f);
 * \endcode
 * \sa criAtomEx_SetSpeakerAngleArray
 */
void CRIAPI criAtomEx_SetSpeakerAngles(CriFloat32 angle_l, CriFloat32 angle_r, CriFloat32 angle_sl, CriFloat32 angle_sr);

/*JP
 * \brief Xs[J[px̐ݒ
 * \ingroup ATOMEXLIB_GLOBAL
 * \param[in]	speaker_system	o̓Xs[J[̕я
 * \param[in]	angle_array		o̓Xs[J[̊pxz
 * \par :
 * p3D3D|WVjǑvZɎgpAo̓Xs[J[̊pxizujݒ肵܂B<br>
 * px́Aʕ0xƂ-180x180x̊ԂŐݒ肵ĂB<br>
 * pxźAo̓Xs[J[̕я̃Xs[J[ȏ̗vf̔zw肵ĂB<br>
 * pxz NULL w肷ƁAo̓Xs[J[̕яɍ킹āAftHg̊pxݒ肵܂B<br>
 * \attention
 * FRONT LEFTFRONT RIGHT̈ʒuւ悤ȐݒꍇAӐ}ȂɂȂ\܂B
 * \par ⑫:
 * LOW FREQUENCY̊pxύXĂAp3D3D|WVjǑvZʂ͕ω܂B<br>
 * ݒ肵px́AeXs[J[VXeƂɓƗĐݒ肳܂B
 * \par F
 * \code
 * CriFloat32 angle_array[8] = {-30.0f, 30.0f, 0.0f, 0.0f, -90.0f, 90.0f, -150.0f, 150.0f}
 * criAtomEx_SetSpeakerAngleArray(CRIATOMEX_SPEAKER_SYSTEM_SURROUND_7_1, angle_array);
 * \endcode
 * \sa criAtomEx_SetSpeakerAngles
 */
void CRIAPI criAtomEx_SetSpeakerAngleArray(CriAtomExSpeakerSystem speaker_system, const CriFloat32 *angle_array);

/*JP
 * \brief o[`Xs[J[px̐ݒ
 * \ingroup ATOMEXLIB_GLOBAL
 * \param[in]	speaker_system	o[`Xs[J[̕я
 * \param[in]	angle_array		o[`Xs[J[̊pxz
 * \par :
 * o[`Xs[J[ɂp3D3D|WVjǑvZɎgpA
 * o̓Xs[J[̊pxizujݒ肵܂B<br>
 * {֐̑ ::criAtomEx_SetSpeakerAngleArray ֐ƓlȂ߁A{IȐ͂QƂĉB<br>
 * \attention
 * {֐ł̐ݒ ::criAtomEx_ControlVirtualSpeakerSetting ֐ɂăo[`Xs[J[ݒLɂȂA
 * ݒ肵o[`Xs[J[px̓p3D3D|WVjǑvZɔf܂B
 * \sa criAtomEx_SetSpeakerAngleArray, criAtomEx_ControlVirtualSpeakerSetting
 */
void CRIAPI criAtomEx_SetVirtualSpeakerAngleArray(CriAtomExSpeakerSystem speaker_system, const CriFloat32 *angle_array);

/*JP
 * \brief o[`Xs[J[ݒON/OFF
 * \ingroup ATOMEXLIB_GLOBAL
 * \param[in]	sw	XCb`iCRI_FALSE = ACRI_TRUE = Lj
 * \par :
 * p3D3D|WVjǑvZɃo[`Xs[J[̐ݒgp@\ON/OFFݒ肵܂B<br>
 * ̐ݒLɂƁA}``lTEh ::criAtomEx_SetVirtualSpeakerAngleArray ֐ɂĐݒ肵
 * o[`Xs[J[px炻ꂼĐ܂B
 * \attention
 * ftHg̏Ԃ́uvɂȂĂ܂B<br>
 * ܂A{CXĐɁuLvɂꍇAp3D3D|WVjǑvZɂ͑f܂B
 * {CXĐ甽f܂B
 * \sa criAtomEx_SetVirtualSpeakerAngleArray
 */
void CRIAPI criAtomEx_ControlVirtualSpeakerSetting(CriBool sw);

/*JP
 * \brief Q[ϐ̑̎擾
 * \ingroup ATOMEXLIB_GLOBAL
 * \return		CriSint32	Q[ϐ̑
 * \par :
 * ACFt@Cɓo^ĂQ[ϐ̑擾܂B<br>
 * \attention
 * {֐sOɁAACFt@Co^ĂKv܂B<br>
 * ACFt@Co^ĂȂꍇA-1Ԃ܂B
 * \sa criAtomEx_GetGameVariableInfo
 */
CriSint32 CRIAPI criAtomEx_GetNumGameVariables(void);

/*JP
 * \brief Q[ϐ̎擾iCfbNXwj
 * \ingroup ATOMEXLIB_GLOBAL
 * \param[in]	index		Q[ϐCfbNX
 * \param[out]	info		Q[ϐ
 * \return		CriBool		񂪎擾łǂHi擾łFCRI_TRUE^擾łȂFCRI_FALSEj
 * \par :
 * Q[ϐCfbNXQ[ϐ擾܂B<br>
 * w肵CfbNX̃Q[ϐ݂ȂꍇACRI_FALSEԂ܂B
 * \sa CriAtomExGameVariableInfo
 */
CriBool CRIAPI criAtomEx_GetGameVariableInfo(CriUint16 index, CriAtomExGameVariableInfo* info);

/*JP
 * \brief Q[ϐ̎擾
 * \ingroup ATOMEXLIB_GLOBAL
 * \param[in]	id			Q[ϐID
 * \return		CriFloat32	Q[ϐl
 * \par :
 * ACFt@Cɓo^ĂQ[ϐl擾܂B<br>
 * w肵 id ̃Q[ϐ݂ȂꍇA-1.0f Ԃ܂B
 * \attention
 * {֐sOɁAACFt@Co^ĂKv܂B<br>
 */
CriFloat32 CRIAPI criAtomEx_GetGameVariableById(CriAtomExGameVariableId id);

/*JP
 * \brief Q[ϐ̎擾
 * \ingroup ATOMEXLIB_GLOBAL
 * \param[in]	name		Q[ϐ
 * \return		CriFloat32	Q[ϐl
 * \par :
 * ACFt@Cɓo^ĂQ[ϐ擾܂B<br>
 * w肵ÕQ[ϐ݂ȂꍇA-1.0f Ԃ܂B
 * \attention
 * {֐sOɁAACFt@Co^ĂKv܂B<br>
 */
CriFloat32 CRIAPI criAtomEx_GetGameVariableByName(const CriChar8* name);

/*JP
 * \brief Q[ϐ̐ݒ
 * \ingroup ATOMEXLIB_GLOBAL
 * \param[in]	id			Q[ϐID
 * \param[in]	value		Q[ϐl
 * \par :
 * ACFt@Cɓo^ĂQ[ϐɒlݒ肵܂B<br>
 * ݒ\Ȕ͈͂0.0f`1.0f̊ԂłB
 * \par l:
 * Q[ϐ̒l͈ȉ̃TEhɂĎQƂ܂B
 * - XCb`L[ɂĐgbN̐؂ւ
 * - AISAC ɂp[^[̐
 * \attention
 * {֐sOɁAACFt@Co^ĂKv܂B<br>
 * <br>
 * Q[ϐ̒lɓlݒ肵ۂ AISAC ̃p[^[XV͔̏܂B
 */
void CRIAPI criAtomEx_SetGameVariableById(CriAtomExGameVariableId id, CriFloat32 value);

/*JP
 * \brief Q[ϐ̐ݒ
 * \ingroup ATOMEXLIB_GLOBAL
 * \param[in]	name		Q[ϐ
 * \param[in]	value		Q[ϐl
 * \par :
 * ACFt@Cɓo^ĂQ[ϐɒlݒ肵܂B<br>
 * ݒ\Ȕ͈͂0.0f`1.0f̊ԂłB
 * \par l:
 * Q[ϐ̒l͈ȉ̃TEhɂĎQƂ܂B
 * - XCb`L[ɂĐgbN̐؂ւ
 * - AISAC ɂp[^[̐
 * \attention
 * {֐sOɁAACFt@Co^ĂKv܂B<br>
 * <br>
 * Q[ϐ̒lɓlݒ肵ۂ AISAC ̃p[^[XV͔̏܂B
 */
void CRIAPI criAtomEx_SetGameVariableByName(const CriChar8* name, CriFloat32 value);

/*JP
 * \brief vCobNLZR[obN֐̓o^
 * \ingroup ATOMEXLIB_GLOBAL
 * \param[in]	func		vCobNLZR[obN֐
 * \param[in]	obj			[UwIuWFNg
 * \par :
 * L[ĐɍĐJñLZۂɁAvCobNLZ󂯎R[obN֐o^܂B<br>
 * \attention
 * o^ꂽR[obN֐́ACuōĐJnLZ^C~OŎs܂B<br>
 * ̂߁ACuւ̊荞݂lȂAPIsꍇA
 * G[AfbhbN\܂B<br>
 * {IɁAR[obN֐łAtomCuAPIgpȂłB<br>
 * {R[obN֐ŒԏubNƁA؂ꓙ̖肪܂̂ŁA
 * ӂB<br>
 * <br>
 * R[obN֐1o^ł܂B<br>
 * o^𕡐sꍇAɓo^ς݂̃R[obN֐A
 * ォo^R[obN֐ɂ㏑Ă܂܂B<br>
 * <br>
 * funcNULLw肷邱Ƃœo^ς݊֐̓o^s܂B<br>
 * \sa CriAtomExPlaybackCancelCbFunc
 */
void CRIAPI criAtomEx_SetPlaybackCancelCallback(CriAtomExPlaybackCancelCbFunc func, void* obj);

/*JP
 * \brief ACF`FbN@\ON/OFF
 * \ingroup ATOMEXLIB_GLOBAL
 * \param[in]	sw		XCb`iCRI_FALSE = `FbNACRI_TRUE = `FbNLj
 * \par :
 * ACB[hACFƂ̐`FbN@\ON/OFFݒ肵܂B<br>
 * \attention
 * ftHg̏Ԃ́u`FbNLvɂȂĂ܂Bu`FbNvɐݒ肵ꍇɁA
 * Ȃgݍ킹̃f[^gpƁA{ړIƂʂ܂B<br>
 * ܂Au`FbNvɂꍇłAsACBQƂĂACFڂ
 * ȂƂɂ͕ʓrG[R[obN܂B<br>
 */
void CRIAPI criAtomEx_ControlAcfConsistencyCheck(CriBool sw);

/*JP
 * \brief ACF`FbNG[x̐ݒ
 * \ingroup ATOMEXLIB_GLOBAL
 * \param[in]	level		G[x
 * \par :
 * ACB[hACFƂ̐`FbNŔG[̒ʒmxݒ肵܂B<br>
 * ftHgԂł̒ʒmx CRIERR_LEVEL_WARNING łB
 */
void CRIAPI criAtomEx_SetAcfConsistencyCheckErrorLevel(CriErrorLevel level);

/*JP
 * \brief gbNgWVoCZN^[R[obN֐̓o^
 * \ingroup ATOMEXLIB_GLOBAL
 * \param[in]	func		gbNgWVoCZN^[R[obN֐
 * \param[in]	obj			[UwIuWFNg
 * \par :
 * gbNgWVoCZN^[^CvL[̍ĐɃgWVsۂ̏󂯎R[obN֐o^܂B<br>
 * \attention
 * o^ꂽR[obN֐́ACuŃgWVJn^C~OŎs܂B<br>
 * ̂߁ACuւ̊荞݂lȂAPIsꍇA
 * G[AfbhbN\܂B<br>
 * {IɁAR[obN֐łAtomCuAPIgpȂłB<br>
 * {R[obN֐ŒԏubNƁA؂ꓙ̖肪܂̂ŁA
 * ӂB<br>
 * <br>
 * R[obN֐1o^ł܂B<br>
 * o^𕡐sꍇAɓo^ς݂̃R[obN֐A
 * ォo^R[obN֐ɂ㏑Ă܂܂B<br>
 * <br>
 * funcNULLw肷邱Ƃœo^ς݊֐̓o^s܂B<br>
 * \sa CriAtomExTrackTransitionBySelectorCbFunc
 */
void CRIAPI criAtomEx_SetTrackTransitionBySelectorCallback(CriAtomExTrackTransitionBySelectorCbFunc func, void* obj);

/*==========================================================================
 *      CRI AtomEx Debug API
 *=========================================================================*/
/*JP
 * \brief CriAtomEx ̊e탊\[X̏󋵂̎擾
 * \ingroup ATOMEXLIB_GLOBAL_DEBUG
 * \param[out]	resources_info		CriAtomEx ̊e탊\[X̏
 * \par :
 * CriAtomEx ̊e탊\[X̏󋵎擾܂B<br>
 * \attention
 * JxfobO@\łBAvP[VJɂ̂ݎgpĂB
 * \sa CriAtomExDebugResourcesInfo
 */
void CRIAPI criAtomExDebug_GetResourcesInfo(CriAtomExDebugResourcesInfo *resources_info);

/*==========================================================================
 *      CRI AtomEx HCA-MX API
 *=========================================================================*/
/*JP
 * \brief HCA-MXp[N̈TCY̌vZ
 * \ingroup ATOMEXLIB_HCA_MX
 * \param[in]	config		HCA-MXpRtBO\
 * \return		CriSint32	[N̈TCY
 * \retval		0ȏ		ɏ
 * \retval		-1			G[
 * \par :
 * HCA-MX̏ɕKvȃ[N̈̃TCY擾܂B<br>
 * ::criAtomEx_SetUserAllocator }NɂAP[^[o^s킸
 * ::criAtomExHcaMx_Initialize ֐HCA-MX̏sꍇA
 * {֐ŌvZTCỸ[N̈ƂēnKv܂B<br>
 * <br>
 * [N̈TCY̌vZɎsƁA{֐ -1 Ԃ܂B<br>
 * [N̈TCY̌vZɎsRɂẮAG[R[obÑbZ[WŊmF\łB<br>
 * \par l:
 * HCA-MX̏ɕKvȃ[ÑTCÝAHCA-MXpRtBO
 * \́i ::CriAtomExHcaMxConfig j̓eɂĕω܂B<br>
 * <br>
 * NULLw肵ꍇAftHgݒ
 * i ::criAtomExHcaMx_SetDefaultConfig KpƓp[^[j
 * [N̈TCYvZ܂B
 * <br>
 *  config ̏́A֐ł̂ݎQƂ܂B<br>
 * ֐𔲂͎QƂ܂̂ŁA֐s config ̗̈Ă
 * 肠܂B
 * \sa criAtomEx_SetUserAllocator, criAtomExHcaMx_Initialize
 */
CriSint32 CRIAPI criAtomExHcaMx_CalculateWorkSize(const CriAtomExHcaMxConfig *config);

/*JP
 * \brief [N̈TCYvZpRtBO\̂̐ݒ
 * \ingroup ATOMEXLIB_HCA_MX
 * \param[in]	config		HCA-MXpRtBO\
 * \par :
 * [N̈TCY̌vZpɁAHCA-MXpRtBO\
 * i ::CriAtomExHcaMxConfig \́jo^܂B<br>
 * <br>
 * HCA-MX{CXv[̍쐬ɕKvȃ[N̈̃TCÝA
 * HCA-MXi ::criAtomExHcaMx_Initialize ֐sj
 * ɐݒ肷\̂̃p[^[ɂĕω܂B<br>
 * ̂߁Aʏ̓{CXv[̍쐬ɕKvȃ[N̈TCYvZOɁA
 * HCA-MXKv܂B<br>
 * {֐gpHCA-MXpRtBO\̂o^ꍇA
 * ::criAtomExVoicePool_CalculateWorkSizeForHcaMxVoicePool 
 * ֐ȂɎgp\ƂȂ܂B<br>
 * \par l:
 * i config j NULL w肵ꍇAftHgݒ
 * i ::criAtomExVoicePool_SetDefaultConfigForHcaMxVoicePool 
 * KpƓp[^[jŃ[N̈TCYvZ܂B<br>
 * <br>
 * A{֐ňURtBO\̂ݒ肷ƁA
 * ݒȌԁiԂł̃[N̈TCYvZG[Ƃ铮j
 * ɖ߂ƂłȂȂ܂B<br>
 * i֐ēxsăp[^[㏑邱Ƃ͉\łBj<br>
 * \attention
 * {֐œo^pRtBO\̂́A
 * HCA-MXԂł̃[N̈TCYvZɂgp܂B<br>
 * HCA-MXɂ͖{֐ɐݒ肵p[^[ł͂ȂA
 * Ɏw肳ꂽp[^[[N̈TCY̌vZɎgp܂B<br>
 * i{֐œo^\̂̃p[^[ƁA
 * HCA-MXɎgp\̂̃p[^[قȂꍇA
 * [N̈TCYsAnh̍쐬Ɏs鋰ꂪ܂Bj<br>
 * \par :
 * \code
 * 	CriAtomExHcaMxConfig hca_mx_config;
 * 	
 * 	// [N̈vZpHCA-MXݒo^
 * 	criAtomExHcaMx_SetDefaultConfig(&hca_mx_config);
 * 	criAtomExHcaMx_SetConfigForWorkSizeCalculation(&hca_mx_config);
 * 	
 * 	// HCA-MX{CXv[쐬p[N̈TCY̌vZ
 * 	hca_mx_vp_work_size = criAtomExVoicePool_CalculateWorkSizeForHcaMxVoicePool(NULL);
 * 		F
 * \endcode
 * \sa criAtomExVoicePool_CalculateWorkSizeForHcaMxVoicePool, criAtomExVoicePool_SetDefaultConfigForHcaMxVoicePool
 */
void CRIAPI criAtomExHcaMx_SetConfigForWorkSizeCalculation(const CriAtomExHcaMxConfig *config);

/*JP
 * \brief HCA-MX̏
 * \ingroup ATOMEXLIB_HCA_MX
 * \param[in]	config	HCA-MXpRtBO\
 * \param[in]	work		[N̈
 * \param[in]	work_size	[N̈TCY
 * \par :
 * HCA-MX̏s܂B<br>
 * {֐s邱ƂŁAHCA-MXf[^̏o͋@\N܂B<br>
 * \par l:
 * HCA-MX̏ɕKvȃ[ÑTCÝAHCA-MXpRtBO
 * \́i ::CriAtomExHcaMxConfig j̓eɂĕω܂B<br>
 * <br>
 * NULLw肵ꍇAftHgݒ
 * i ::criAtomExHcaMx_SetDefaultConfig KpƓp[^[jŏs܂B<br>
 * <br>
 *  config ̏́A֐ł̂ݎQƂ܂B<br>
 * ֐𔲂͎QƂ܂̂ŁA֐s config ̗̈Ă
 * 肠܂B
 * \attention
 * {֐sOɁACuĂKv܂B<br>
 * <br>
 * {֐͊A^̊֐łB<br>
 * {֐sƁA΂炭̊AtomCũT[o[ubN܂B<br>
 * Đɖ{֐sƁAr؂ꓙ̕s\邽߁A
 * {֐̌Ăяo̓V[̐؂ւ蓙Aוϓeł^C~OōsĂB
 * <br>
 * {֐sAK΂ɂȂ ::criAtomExHcaMx_Finalize ֐sĂB<br>
 * ܂A ::criAtomExHcaMx_Finalize ֐s܂ł́A{֐ēxsȂłB<br>
 * \sa criAtomEx_SetUserAllocator, criAtomExHcaMx_CalculateWorkSize
 */
void CRIAPI criAtomExHcaMx_Initialize(
	const CriAtomExHcaMxConfig *config, void *work, CriSint32 work_size);

/*JP
 * \brief HCA-MX̏I
 * \ingroup ATOMEXLIB_HCA_MX
 * \par :
 * HCA-MX̏Is܂B<br>
 * {֐s邱ƂŁAHCA-MXf[^̏o͂~܂B<br>
 * ::criAtomEx_SetUserAllocator }NgpăAP[^[o^ς݂̏ꍇA
 * HCA-MXɊmۂꂽ̈悪܂B<br>
 * iHCA-MXɃ[N̈nꍇA{֐sł
 * [N̈\łBj<br>
 * \attention
 * {֐͊A^̊֐łB<br>
 * {֐sƁA΂炭̊AtomCũT[o[ubN܂B<br>
 * Đɖ{֐sƁAr؂ꓙ̕s\邽߁A
 * {֐̌Ăяo̓V[̐؂ւ蓙Aוϓeł^C~OōsĂB
 * \sa criAtomEx_SetUserAllocator, criAtomExHcaMx_Initialize
 */
void CRIAPI criAtomExHcaMx_Finalize(void);

/*JP
 * \brief ~LT̃oXZhxݒ
 * \ingroup ATOMEXLIB_HCA_MX
 * \param[in]	mixer_id	~LTID
 * \param[in]	bus_name	oX
 * \param[in]	level		Zhxli0.0f`1.0fj
 * \par :
 * ~LT̃oXZhxݒ肵܂B<br>
 * ftHgԂł́AHCA-MX̃fR[hʂ̓~LTɊi[ꂽA
 * oX01.0f̃xőM܂B<br>
 * {֐gp邱ƂŁAfR[hʂ𑼂̃oXւZh邱Ƃ\ɂȂ܂B<br>
 * i~LTƂɈقȂoXGtFNgKp\ɂȂ܂Bj<br>
 */
void CRIAPI criAtomExHcaMx_SetBusSendLevelByName(
	CriSint32 mixer_id, const CriChar8* bus_name, CriFloat32 level);

/*JP
 * \brief ~LT̏o͎g̐ݒ
 * \ingroup ATOMEXLIB_HCA_MX
 * \param[in]	mixer_id	~LTID
 * \param[in]	ratio		Zhxli0.25f`4.0fj
 * \par :
 * ~LT̏o͎gݒ肵܂B<br>
 * ǵAf[^̎gƍĐg̔䗦ŁAĐx̔{ƓłB<br>
 * g䂪1.0f𒴂ꍇAf[^͌荂ɍĐA
 * 1.0f̏ꍇ́Af[^͌ᑬōĐ܂B<br>
 * {֐gp邱ƂŁAΏۂ̃~LTgpv[[ōĐSĂHCA-MX{CX
 * iHCA-MXpɃGR[hꂽf[^̍ĐjɂāAĐxύX܂
 * iHCA-MX{CXĐꍇAX̃v[[ł̍Đx̐ݒ͖܂jB<br>
 */
void CRIAPI criAtomExHcaMx_SetFrequencyRatio(CriSint32 mixer_id, CriFloat32 ratio);

/*JP
 * \brief ASRbNID̎w
 * \ingroup ATOMEXLIB_HCA_MX
 * \param[in]	mixer_id	~LTID
 * \param[in]	rack_id		ASRbNID
 * \par :
 * ~LT̏o͐ASRbNIDw肵܂B<br>
 * {֐gp邱ƂŁAΏۂ̃~LTgpv[[ōĐSĂHCA-MX{CX
 * iHCA-MXpɃGR[hꂽf[^̍ĐjɂāAo͐ASRbNIDύX܂
 * iHCA-MX{CXĐꍇAX̃v[[łASRbNID̐ݒ͖܂jB<br>
 * \attention
 * {֐ ~LT̃TEh_^CvASRgpꍇɂ̂݌ʂ܂B<br>
 * ĩTEh_^Cv̏ꍇA{֐̐ݒl͖܂Bj<br>
 * \sa CriAtomExAsr_CreateRack
 */
void CRIAPI criAtomExHcaMx_SetAsrRackId(CriSint32 mixer_id, CriSint32 rack_id);

/*==========================================================================
 *      CRI AtomEx ACF API
 *=========================================================================*/
/*JP
 * \brief AISACRg[̎擾
 * \ingroup ATOMEXLIB_ACF
 * \return		CriSint32	AISACRg[
 * \par :
 * o^ꂽACFɊ܂܂AISACRg[̐擾܂B<br>
 * ACFo^ĂȂꍇA-1Ԃ܂B
 */
CriSint32 CRIAPI criAtomExAcf_GetNumAisacControls(void);

/*JP
 * \brief AISACRg[̎擾
 * \ingroup ATOMEXLIB_ACF
 * \param[in]	index		AISACRg[CfbNX
 * \param[out]	info		AISACRg[
 * \return		CriBool		񂪎擾łǂHi擾łFCRI_TRUE^擾łȂFCRI_FALSEj
 * \par :
 * AISACRg[CfbNXAISACRg[擾܂B<br>
 * w肵CfbNXAISACRg[݂ȂꍇACRI_FALSEԂ܂B
 */
CriBool CRIAPI criAtomExAcf_GetAisacControlInfo(CriUint16 index, CriAtomExAisacControlInfo* info);

/*JP
 * \brief AISACRg[ID̎擾iAISACRg[wj
 * \ingroup ATOMEXLIB_ACF
 * \param[in]	name					AISACRg[
 * \return		CriAtomExAisacControlId	AISACRg[ID
 * \par :
 * AISACRg[AISACRg[ID擾܂B<br>
 * ACFo^ĂȂA܂͎w肵AISACRg[AISACRg[݂ȂꍇACRIATOMEX_INVALID_AISAC_CONTROL_IDԂ܂B
 */
CriAtomExAisacControlId CRIAPI criAtomExAcf_GetAisacControlIdByName(const CriChar8* name);

/*JP
 * \brief AISACRg[̎擾iAISACRg[IDwj
 * \ingroup ATOMEXLIB_ACF
 * \param[in]	id				AISACRg[ID
 * \return		const CriChar8* AISACRg[
 * \par :
 * AISACRg[IDAISACRg[擾܂B<br>
 * ACFo^ĂȂA܂͎w肵AISACRg[IDAISACRg[݂ȂꍇANULLԂ܂B
 */
const CriChar8 * CRIAPI criAtomExAcf_GetAisacControlNameById(CriAtomExAisacControlId id);

/*JP
 * \brief DSPoXݒ萔̎擾
 * \ingroup ATOMEXLIB_ACF
 * \return		CriSint32	DSPoXݒ萔
 * \par :
 * Cuɓo^ꂽACFf[^Ɋ܂܂DSPoXݒ̐擾܂B<br>
 * ACFf[^o^ĂȂꍇA{֐ -1 Ԃ܂B<br>
 * \sa criAtomExAcf_GetDspSettingNameByIndex
 */
CriSint32 CRIAPI criAtomExAcf_GetNumDspSettings(void);

/*JP
 * \brief ACFf[^DSPoXݒ萔擾
 * \ingroup ATOMEXLIB_ACF
 * \param[in]	acf_data		ACFf[^
 * \param[in]	acf_data_size	ACFf[^TCY
 * \return		CriSint32		DSPoXݒ萔
 * \par :
 * w肳ꂽACFɊ܂܂DSPoXݒ̐擾܂B<br>
 * \par l:
 * ::criAtomExAcf_GetNumDspSettings ֐ƈقȂA<br>
 * ACFo^Oł{֐͎s\łB
 * \sa criAtomExAcf_GetNumDspSettings
 */
CriSint32 CRIAPI criAtomExAcf_GetNumDspSettingsFromAcfData(
	void *acf_data, CriSint32 acf_data_size);

/*JP
 * \brief DSPoXݒ薼̎擾iindexwj
 * \ingroup ATOMEXLIB_ACF
 * \param[in]	index			DSPoXݒCfbNX
 * \return		const CriChar8* DSPoXݒ薼
 * \par :
 * Cuɓo^ꂽACFf[^DSPoXݒ薼擾܂B<br>
 * ACFf[^o^ĂȂA
 * ܂͎w肵DSPoXݒCfbNXDSPoXݒ肪݂ȂꍇA
 * {֐ NULL Ԃ܂B<br>
 * \sa criAtomExAcf_GetDspSettingInformation 
 */
const CriChar8 * CRIAPI criAtomExAcf_GetDspSettingNameByIndex(CriUint16 index);

/*JP
 * \brief ACFf[^DSPoXݒ薼擾
 * \ingroup ATOMEXLIB_ACF
 * \param[in]	acf_data		ACFf[^
 * \param[in]	acf_data_size	ACFf[^TCY
 * \param[in]	index			DSPoXݒCfbNX
 * \return		const CriChar8* DSPoXݒ薼
 * \par :
 * w肳ꂽACFf[^Ɋ܂܂DSPoXݒ薼擾܂B<br>
 *  3 i index jɂ́AԖڂDSPoXݒ̖̂擾邩w肵܂B<br>
 * \par l:
 * ::criAtomExAcf_GetDspSettingNameByIndex ֐ƈقȂA<br>
 * ACFo^Oł{֐͎s\łB
 * \sa criAtomExAcf_GetDspSettingNameByIndex 
 */
const CriChar8 * CRIAPI criAtomExAcf_GetDspSettingNameByIndexFromAcfData(
	void *acf_data, CriSint32 acf_data_size, CriUint16 index);

/*JP
 * \brief DSPoXݒ̎擾
 * \ingroup ATOMEXLIB_ACF
 * \param[in]	name		ZbeBO
 * \param[out]	info		ZbeBO
 * \return		CriBool		񂪎擾łǂHi擾łFCRI_TRUE^擾łȂFCRI_FALSEj
 * \par :
 * ZbeBOw肵ăZbeBO擾܂B<br>
 * w肵ZbeBODsp setting݂ȂꍇACRI_FALSEԂ܂B<br>
 * \sa criAtomExAcf_GetDspSettingNameByIndex,  criAtomExAcf_GetDspBusInformation
 */
CriBool CRIAPI criAtomExAcf_GetDspSettingInformation(const CriChar8* name, CriAtomExAcfDspSettingInfo* info);

/*JP
 * \brief DSPoXݒXibvVbg̎擾
 * \ingroup ATOMEXLIB_ACF
 * \param[in]	index		XibvVbgCfbNX
 * \param[out]	info		XibvVbg
 * \return		CriBool		񂪎擾łǂHi擾łFCRI_TRUE^擾łȂFCRI_FALSEj
 * \par :
 * XibvVbgCfbNXw肵ăXibvVbg擾܂B<br>
 * w肵ZbeBÕXibvVbg݂ȂꍇACRI_FALSEԂ܂B<br>
 * XibvVbgCfbNX͐eƂȂDSPoXݒ ::CriAtomExAcfDspSettingInfo \̓
 * snapshot_start_indexonum_snapshotsoɓK؂ȒlZoĂB
 * \sa criAtomExAcf_GetDspBusInformation
 */
CriBool CRIAPI criAtomExAcf_GetDspSettingSnapshotInformation(CriUint16 index, CriAtomExAcfDspSettingSnapshotInfo* info);

/*JP
 * \brief DSPoX̎擾
 * \ingroup ATOMEXLIB_ACF
 * \param[in]	index		oXCfbNX
 * \param[out]	info		oX
 * \return		CriBool		񂪎擾łǂHi擾łFCRI_TRUE^擾łȂFCRI_FALSEj
 * \par :
 * CfbNXw肵DSPoX擾܂B<br>
 * w肵CfbNXDSPoX݂ȂꍇACRI_FALSEԂ܂B<br>
 * \sa criAtomExAcf_GetDspSettingInformation,  criAtomExAcf_GetDspFxName, criAtomExAcf_GetDspFxParameters, criAtomExAcf_GetDspBusLinkInformation
 */
CriBool CRIAPI criAtomExAcf_GetDspBusInformation(CriUint16 index, CriAtomExAcfDspBusInfo* info);

/*JP
 * \brief DSP FX̎擾
 * \ingroup ATOMEXLIB_ACF
 * \param[in]	index		DSP FXCfbNX
 * \return		const CriChar8* ւ̃|C^Bsꍇ́ACRI_NULLԂ܂B
 * \par :
 * CfbNXw肵DSP FX𕶎Ŏ擾܂B<br>
 * DSP FXASRgpAACF Ver.1.16.00 ȍ~ACFgpɎ擾\łB<br>
 * ASRgpȂA܂ACF Ver.1.15.01 ȑOłCRI_NULL <br>
 * Ԃ܂B::criAtomExAcf_GetAcfInfo ֐ACF̃o[WmFĂgpB
 * \sa criAtomExAcf_GetDspBusInformation, criAtomExAcf_GetDspFxParameters, criAtomExAcf_GetAcfInfo
 */
const CriChar8* CRIAPI criAtomExAcf_GetDspFxName(CriUint16 index);

/*JP
 * \brief DSP FXp[^[̎擾
 * \ingroup ATOMEXLIB_ACF
 * \param[in]	index		DSP FXCfbNX
 * \param[out]	parameters	DSP FXp[^[
 * \param[in]	size		DSP FXp[^[[NTCY
 * \return		CriBool		񂪎擾łǂHi擾łFCRI_TRUE^擾łȂFCRI_FALSEj
 * \par :
 * CfbNXw肵ACFFXp[^[擾܂B<br>
 * w肵CfbNXDSP FX݂ȂꍇACRI FALSEԂ܂B<br>
 * sizeɂDSP FX^Cvɉp[^[̃TCYw肵ĂB<br>
 * TEh_ASRw肵ꍇ́AACFɂsp[^[floatž`parametersɎ擾܂B
 * ASRȊOł̃TEh_ł́Ap[^[\̂܂B
 * \sa criAtomExAcf_GetDspBusInformation, criAtomExAcf_GetDspFxName
 */
CriBool CRIAPI criAtomExAcf_GetDspFxParameters(CriUint16 index, void* parameters, CriSint32 size);

/*JP
 * \brief DSPoXN̎擾
 * \ingroup ATOMEXLIB_ACF
 * \param[in]	index		DSPoXNCfbNX
 * \param[out]	info		DSPoXN
 * \return		CriBool		񂪎擾łǂHi擾łFCRI_TRUE^擾łȂFCRI_FALSEj
 * \par :
 * CfbNXw肵ăoXN擾܂B<br>
 * w肵CfbNXDSPoXN݂ȂꍇACRI_FALSEԂ܂B<br>
 * \sa criAtomExAcf_GetDspBusInformation
 */
CriBool CRIAPI criAtomExAcf_GetDspBusLinkInformation(CriUint16 index, CriAtomExAcfDspBusLinkInfo* info);

/*JP
 * \brief ACFf[^JeS擾
 * \ingroup ATOMEXLIB_ACF
 * \param[in]	acf_data		ACFf[^
 * \param[in]	acf_data_size	ACFf[^TCY
 * \return	CriSint32			JeS
 * \par :
 * w肳ꂽACFɊ܂܂JeS̐擾܂B<br>
 * \par l:
 * ::criAtomExAcf_GetNumCategories ֐ƈقȂA<br>
 * ACFo^Oł{֐͎s\łB
 * \sa criAtomExAcf_GetNumCategories
 */
CriSint32 CRIAPI criAtomExAcf_GetNumCategoriesFromAcfData(
	void *acf_data, CriSint32 acf_data_size);

/*JP
 * \brief JeS̎擾
 * \ingroup ATOMEXLIB_ACF
 * \return		CriSint32	JeS
 * \par :
 * o^ꂽACFɊ܂܂JeS̐擾܂B
 */
CriSint32 CRIAPI criAtomExAcf_GetNumCategories(void);

/*JP
 * \brief REACT̎擾
 * \ingroup ATOMEXLIB_ACF
 * \return		CriSint32	REACT
 * \par :
 * o^ꂽACFɊ܂܂REACT̐擾܂B
 */
CriSint32 CRIAPI criAtomExAcf_GetNumReacts(void);

/*JP
 * \brief ACFf[^ĐJeSQƐ擾
 * \ingroup ATOMEXLIB_ACF
 * \param[in]	acf_data		ACFf[^
 * \param[in]	acf_data_size	ACFf[^TCY
 * \return	CriSint32			ĐJeSQƐ
 * \par :
 * w肳ꂽACFɊ܂܂JeS̐擾܂B<br>
 * \par l:
 * ::criAtomExAcf_GetNumCategoriesPerPlayback ֐ƈقȂA<br>
 * ACFo^Oł{֐͎s\łB
 * \sa criAtomExAcf_GetNumCategoriesPerPlayback
 */
CriSint32 CRIAPI criAtomExAcf_GetNumCategoriesPerPlaybackFromAcfData(
	void *acf_data, CriSint32 acf_data_size);

/*JP
 * \brief ĐJeSQƐ̎擾
 * \ingroup ATOMEXLIB_ACF
 * \return		CriSint32	ĐJeSQƐ
 * \par :
 * o^ꂽACFɊ܂܂ĐJeSQƐ擾܂B
 */
CriSint32 CRIAPI criAtomExAcf_GetNumCategoriesPerPlayback(void);

/*JP
 * \brief JeS̎擾iCfbNXwj
 * \ingroup ATOMEXLIB_ACF
 * \param[in]	index		JeSCfbNX
 * \param[out]	info		JeS
 * \return		CriBool		񂪎擾łǂHi擾łFCRI_TRUE^擾łȂFCRI_FALSEj
 * \par :
 * JeSCfbNXJeS擾܂B<br>
 * w肵CfbNX̃JeS݂ȂꍇACRI_FALSEԂ܂B
 */
CriBool CRIAPI criAtomExAcf_GetCategoryInfo(CriUint16 index, CriAtomExCategoryInfo* info);

/*JP
 * \brief JeS̎擾iJeSwj
 * \ingroup ATOMEXLIB_ACF
 * \param[in]	name		JeS
 * \param[out]	info		JeS
 * \return		CriBool		񂪎擾łǂHi擾łFCRI_TRUE^擾łȂFCRI_FALSEj
 * \par :
 * JeSJeS擾܂B<br>
 * w肵JeS̃JeS݂ȂꍇACRI_FALSEԂ܂B
 */
CriBool CRIAPI criAtomExAcf_GetCategoryInfoByName(const CriChar8* name, CriAtomExCategoryInfo* info);

/*JP
 * \brief JeS̎擾iJeSIDwj
 * \ingroup ATOMEXLIB_ACF
 * \param[in]	id			JeSID
 * \param[out]	info		JeS
 * \return		CriBool		񂪎擾łǂHi擾łFCRI_TRUE^擾łȂFCRI_FALSEj
 * \par :
 * JeSIDJeS擾܂B<br>
 * w肵JeSID̃JeS݂ȂꍇACRI_FALSEԂ܂B
 */
CriBool CRIAPI criAtomExAcf_GetCategoryInfoById(CriUint32 id, CriAtomExCategoryInfo* info);

/*JP
 * \brief Global Aisac̎擾
 * \ingroup ATOMEXLIB_ACF
 * \return		CriSint32	Global Aisac
 * \par :
 * o^ꂽACFɊ܂܂Global Aisac̐擾܂B
 */
CriSint32 CRIAPI criAtomExAcf_GetNumGlobalAisacs(void);

/*JP
 * \brief Global Aisac̎擾iCfbNXwj
 * \ingroup ATOMEXLIB_ACF
 * \param[in]	index		Global AisacCfbNX
 * \param[out]	info		Global Aisac
 * \return		CriBool		񂪎擾łǂHi擾łFCRI_TRUE^擾łȂFCRI_FALSEj
 * \par :
 * Global AisacCfbNXAisac擾܂B<br>
 * w肵CfbNXGlobal Aisac݂ȂꍇACRI_FALSEԂ܂B
 */
CriBool CRIAPI criAtomExAcf_GetGlobalAisacInfo(CriUint16 index, CriAtomExGlobalAisacInfo* info);

/*JP
 * \brief Global Aisac̎擾iOwj
 * \ingroup ATOMEXLIB_ACF
 * \param[in]	name		Global Aisac
 * \param[out]	info		Global Aisac
 * \return		CriBool		񂪎擾łǂHi擾łFCRI_TRUE^擾łȂFCRI_FALSEj
 * \par :
 * Global AisacAisac擾܂B<br>
 * w肵OGlobal Aisac݂ȂꍇACRI_FALSEԂ܂B
 */
CriBool CRIAPI criAtomExAcf_GetGlobalAisacInfoByName(const CriChar8* name, CriAtomExGlobalAisacInfo* info);

/*JP
 * \brief Global Aisac Graph̎擾
 * \ingroup ATOMEXLIB_ACF
 * \param[in]	aisac_info		Global Aisac
 * \param[in]	graph_index		Aisac graphCfbNX
 * \param[out]	graph_info		Aisac graph
 * \return		CriBool			񂪎擾łǂHi擾łFCRI_TRUE^擾łȂFCRI_FALSEj
 * \par :
 * Global AisacgraphCfbNXgraph擾܂B<br>
 * w肵CfbNXGlobal Aisac݂ȂꍇACRI_FALSEԂ܂B
 */
CriBool CRIAPI criAtomExAcf_GetGlobalAisacGraphInfo(
	const CriAtomExGlobalAisacInfo* aisac_info,
	CriUint16 graph_index,
	CriAtomExAisacGraphInfo* graph_info);

/*JP
 * \brief Global Aisacl̎擾
 * \ingroup ATOMEXLIB_ACF
 * \param[in]	aisac_info					Global Aisac
 * \param[in]	control						AISACRg[l
 * \param[in]	type						Ot^Cv
 * \param[out]	value						AISACl
 * \return		CriBool						l擾łǂHi擾łFCRI_TRUE^擾łȂFCRI_FALSEj
 * \par :
 * Global AisacARg[lAOt^Cvw肵Aisacl擾܂B<br>
 * w肵CfbNXGlobal Aisac݂ȂꍇOt݂Ȃꍇ́ACRI_FALSEԂ܂B
 */
CriBool CRIAPI criAtomExAcf_GetGlobalAisacValue(
	const CriAtomExGlobalAisacInfo* aisac_info,
	CriFloat32 control,
	CriAtomExAisacGraphType type,
	CriFloat32* value);

/*JP
 * \brief ACF̎擾
 * \ingroup ATOMEXLIB_ACF
 * \param[out]	acf_info		ACF
 * \return		CriBool			񂪎擾łǂHi擾łFCRI_TRUE^擾łȂFCRI_FALSEj
 * \par :
 * Cuɓo^ꂽACFf[^̊e擾܂B<br>
 * ACF̎擾ɎsꍇACRI_FALSEԂ܂B
 */
CriBool CRIAPI criAtomExAcf_GetAcfInfo(CriAtomExAcfInfo *acf_info);

/*JP
 * \brief ACFf[^ACF擾
 * \ingroup ATOMEXLIB_ACF
 * \param[in]	acf_data		ACFf[^
 * \param[in]	acf_data_size	ACFf[^TCY
 * \param[out]	acf_info		ACF
 * \return		CriBool			񂪎擾łǂHi擾łFCRI_TRUE^擾łȂFCRI_FALSEj
 * \par :
 * w肳ꂽACFf[^̊e擾܂B<br>
 * ACF̎擾ɎsꍇACRI_FALSEԂ܂B
 * \par l:
 * ::criAtomExAcf_GetAcfInfo ֐ƈقȂA<br>
 * ACFo^Oł{֐͎s\łB
 * \attention
 * 擾ACF̃|C^óAACFf[^̈wĂ܂BiOւ̃|C^j<br>
 * 擾ACFQƂĂԂ́AACFf[^̈Ȃ悤ӂB
 * \sa criAtomExAcf_GetAcfInfo 
 */
CriBool CRIAPI criAtomExAcf_GetAcfInfoFromAcfData(
	void *acf_data, CriSint32 acf_data_size, CriAtomExAcfInfo *acf_info);

/*JP
 * \brief ZN^[̎擾
 * \ingroup ATOMEXLIB_ACF
 * \return		CriSint32	ZN^[
 * \par :
 * o^ꂽACFɊ܂܂ZN^[̐擾܂B
 */
CriSint32 CRIAPI criAtomExAcf_GetNumSelectors(void);

/*JP
 * \brief ZN^[̎擾iCfbNXwj
 * \ingroup ATOMEXLIB_ACF
 * \param[in]	index		ZN^[CfbNX
 * \param[out]	info		ZN^[
 * \return		CriBool		񂪎擾łǂHi擾łFCRI_TRUE^擾łȂFCRI_FALSEj
 * \par :
 * ZN^[CfbNXZN^[擾܂B<br>
 * w肵CfbNX̃ZN^[݂ȂꍇACRI_FALSEԂ܂B
 */
CriBool CRIAPI criAtomExAcf_GetSelectorInfoByIndex(CriUint16 index, CriAtomExSelectorInfo* info);

/*JP
 * \brief ZN^[̎擾iOwj
 * \ingroup ATOMEXLIB_ACF
 * \param[in]	name		ZN^[
 * \param[out]	info		ZN^[
 * \return		CriBool		񂪎擾łǂHi擾łFCRI_TRUE^擾łȂFCRI_FALSEj
 * \par :
 * ZN^[ZN^[擾܂B<br>
 * w肵ÕZN^[݂ȂꍇACRI_FALSEԂ܂B
 */
CriBool CRIAPI criAtomExAcf_GetSelectorInfoByName(const CriChar8* name, CriAtomExSelectorInfo* info);

/*JP
 * \brief ZN^[x̎擾
 * \ingroup ATOMEXLIB_ACF
 * \param[in]	selector_info		ZN^[
 * \param[in]	label_index			xCfbNX
 * \param[out]	label_info			ZN^[x
 * \return		CriBool				񂪎擾łǂHi擾łFCRI_TRUE^擾łȂFCRI_FALSEj
 * \par :
 * ZN^[ƃZN^[xCfbNXZN^[x擾܂B<br>
 * w肵CfbNX̃ZN^[x݂ȂꍇACRI_FALSEԂ܂B
 */
CriBool CRIAPI criAtomExAcf_GetSelectorLabelInfo(
	const CriAtomExSelectorInfo* selector_info,
	CriUint16 label_index,
	CriAtomExSelectorLabelInfo* label_info);

/*JP
 * \brief ZN^[ɑ΂O[oQƃx̐ݒ
 * \ingroup ATOMEXLIB_ACF
 * \param[in]	selsector_name	ZN^[
 * \param[in]	label_name		x
 * \par :
 * ACFt@Cɓo^ĂZN^[ɑ΂ăO[oQƂ郉xݒ肵܂B<br>
 * \attention
 * {֐sOɁAACFt@Co^ĂKv܂B<br>
 * \sa criAtomExAcf_SetGlobalLabelToSelectorByIndex
 */
void CRIAPI criAtomExAcf_SetGlobalLabelToSelectorByName(const CriChar8* selsector_name, const CriChar8* label_name);

/*JP
 * \brief ZN^[ɑ΂O[oQƃx̐ݒ
 * \ingroup ATOMEXLIB_ACF
 * \param[in]	selsector_index	ZN^[CfbNX
 * \param[in]	label_index		xCfbNX
 * \par :
 * ACFt@Cɓo^ĂZN^[ɑ΂ăO[oQƂ郉xݒ肵܂B<br>
 * \attention
 * {֐sOɁAACFt@Co^ĂKv܂B<br>
 * \sa criAtomExAcf_SetGlobalLabelToSelectorByName
 */
void CRIAPI criAtomExAcf_SetGlobalLabelToSelectorByIndex(CriUint16 selsector_index, CriUint16 label_index);

/*JP
 * \brief ACFf[^oX擾
 * \ingroup ATOMEXLIB_ACF
 * \param[in]	acf_data		ACFf[^
 * \param[in]	acf_data_size	ACFf[^TCY
 * \return	CriSint32			oX
 * \par :
 * w肳ꂽACFɊ܂܂oX̐擾܂B<br>
 * \par l:
 * ::criAtomExAcf_GetNumBuses ֐ƈقȂA<br>
 * ACFo^Oł{֐͎s\łB
 * \sa criAtomExAcf_GetNumBuses
 */
CriSint32 CRIAPI criAtomExAcf_GetNumBusesFromAcfData(
	void *acf_data, CriSint32 acf_data_size);

/*JP
 * \brief oX̎擾
 * \ingroup ATOMEXLIB_ACF
 * \return		CriSint32	oX
 * \par :
 * o^ꂽACFɊ܂܂oX̐擾܂B
 */
CriSint32 CRIAPI criAtomExAcf_GetNumBuses(void);

/*JP
 * \brief ACFf[^DSPoXݒ̍őoX擾
 * \ingroup ATOMEXLIB_ACF
 * \param[in]	acf_data		ACFf[^
 * \param[in]	acf_data_size	ACFf[^TCY
 * \return	CriSint32			DSPoXݒ̍őoX
 * \par :
 * w肳ꂽACFɊ܂܂DSPoXݒ̍őoX̐擾܂B<br>
 * \par l:
 * ::criAtomExAcf_GetMaxBusesOfDspBusSettings ֐ƈقȂA<br>
 * ACFo^Oł{֐͎s\łB
 * \sa criAtomExAcf_GetMaxBusesOfDspBusSettings
 */
CriSint32 CRIAPI criAtomExAcf_GetMaxBusesOfDspBusSettingsFromAcfData(
	void *acf_data, CriSint32 acf_data_size);

/*JP
 * \brief DSPoXݒ̍őoX̎擾
 * \ingroup ATOMEXLIB_ACF
 * \return		CriSint32	DSPoXݒ̍őoX
 * \par :
 * o^ꂽACFɊ܂܂DSPoXݒ̍őoX̐擾܂B
 */
CriSint32 CRIAPI criAtomExAcf_GetMaxBusesOfDspBusSettings(void);

/*JP
 * \brief ACF̃oX擾
 * \ingroup ATOMEXLIB_ACF
 * \param[in]	bus_name		oX
 * \return	st CriChar8*		ACFoX
 * \par :
 * w肳ꂽoXACF擾܂B<br>
 * ݂ȂoXw肵ꍇNULLԂ܂B<br>	 
 */
const CriChar8* CRIAPI criAtomExAcf_FindBusName(const CriChar8* bus_name);

/*JP
 * \brief ACF̏o̓|[gnh̎擾iOwj
 * \ingroup ATOMEXLIB_ACF
 * \param[in]	name			o̓|[g
 * \return		o̓|[gnh
 * \par :
 * ACFɕێĂo̓|[g̒Aw肵o̓|[g̃nh擾܂B<br>
 * ACF̏o̓|[gnhACF̓o^ɐAێ܂B<br>
 * ACFɓo^ꂽo̓|[ǵAACF̃wb_[ɋLڂĂ܂B<br>
 * ̏o̓|[gnhɂ̓ftHgASRbNݒ肳Ă邽߁Å֐Ŏ擾nhɑ΂
 * ::criAtomExOutputPort_SetAsrRackId ֐œK؂ASRbNw肷Kv܂B<br>
 * \sa criAtomEx_RegisterAcf, criAtomExOutputPort_SetAsrRackId
 */
CriAtomExOutputPortHn CRIAPI criAtomExAcf_GetOutputPortHnByName(const CriChar8* name);
/*==========================================================================
 *      CRI AtomEx ACB API
 *=========================================================================*/
/*JP
 * \brief IACBf[^̃[hɕKvȃ[N̈TCY̌vZ
 * \ingroup ATOMEXLIB_ACB
 * \param[in]	acb_data		ACBf[^AhX
 * \param[in]	acb_data_size	ACBf[^TCY
 * \param[in]	awb_binder		AWBt@C܂ރoC_[̃nh
 * \param[in]	awb_path		AWBt@C̃pX
 * \return		CriSint32		[N̈TCY
 * \retval		0ȏ			ɏ
 * \retval		-1				G[
 * \par :
 * ::criAtomExAcb_LoadAcbData ֐̎sɕKvȃ[N̈TCYvZ܂B
 * ::criAtomEx_SetUserAllocator }NɂAP[^[o^s킸
 * ::criAtomExAcb_LoadAcbData ֐AWBf[^[hۂɂ́A
 * {֐ԂTCỸ[N̈ƂēnKv܂B<br>
 * <br>
 * [N̈TCY̌vZɎsƁA{֐ -1 Ԃ܂B<br>
 * [N̈TCY̌vZɎsRɂẮAG[R[obÑbZ[WŊmF\łB<br>
 * \par lF
 * f[^CPKɃpbNĂȂꍇAbinderɂNULLw肵ĂB<br>
 * \attention
 * [N̈̃TCY̓Cui ::criAtomEx_Initialize ֐sj
 * Ɏw肵p[^[ɂĕω܂B<br>
 * ̂߁A{֐sOɁACuĂKv܂B<br>
 * \sa criAtomExAcb_LoadAcbData
 */
CriSint32 CRIAPI criAtomExAcb_CalculateWorkSizeForLoadAcbData(
	void *acb_data, CriSint32 acb_data_size,
	CriFsBinderHn awb_binder, const CriChar8 *awb_path);

/*JP
 * \brief IACBf[^̃[hɕKvȃ[N̈TCY̌vZiCPKRecIDwj
 * \ingroup ATOMEXLIB_ACB
 * \param[in]	acb_data		ACBf[^AhX
 * \param[in]	acb_data_size	ACBf[^TCY
 * \param[in]	awb_binder		AWBt@C܂ރoC_[̃nh
 * \param[in]	awb_id			CPKt@CAWBf[^ID
 * \return		CriSint32		[N̈TCY
 * \retval		0ȏ			ɏ
 * \retval		-1				G[
 * \par :
 * ::criAtomExAcb_LoadAcbDataById ֐̎sɕKvȃ[N̈TCYvZ܂B
 * t@CpX̑CPKRecIDw肷_΁A
 * ::criAtomExAcb_CalculateWorkSizeForLoadAcbData ֐Ƌ@\͓łB<br>
 * \par lF
 * f[^CPKɃpbNĂȂꍇAbinderɂNULLw肵ĂB<br>
 * \sa criAtomExAcb_CalculateWorkSizeForLoadAcbData, criAtomExAcb_LoadAcbDataById
 */
CriSint32 CRIAPI criAtomExAcb_CalculateWorkSizeForLoadAcbDataById(
	void *acb_data, CriSint32 acb_data_size, CriFsBinderHn awb_binder, CriUint16 awb_id);

/*JP
 * \brief IACBf[^̃[h
 * \ingroup ATOMEXLIB_ACB
 * \param[in]	acb_data		ACBf[^AhX
 * \param[in]	acb_data_size	ACBf[^TCY
 * \param[in]	awb_binder		AWBt@C܂ރoC_[̃nh
 * \param[in]	awb_path		AWBt@C̃pX
 * \param[in]	work			[N̈
 * \param[in]	work_size		[N̈TCY
 * \return		CriAtomExAcbHn	ACBnh
 * \par :
 * ACBf[^[hAL[ĐɕKvȏ荞݂܂B<br>
 * ACBf[^̃[hɕKvȃ[N̈̃TCÝA
 * ::criAtomExAcb_CalculateWorkSizeForLoadAcbData ֐ŌvZ܂B<br>
 * <br>
 * 3 awb_binder Aё4 awb_path ɂ́AXg[Đp
 * AWBt@Cw肵܂B<br>
 * iIĐ݂̂ACBf[^[hꍇA awb_binder 
 * awb_path ɃZbgl͖܂Bj<br>
 * <br>
 * ACBf[^[hƁAACBf[^ɃANZX邽߂ACBnh
 * i ::CriAtomExAcbHn jԂ܂B<br>
 * AtomExv[[ɑ΂A ::criAtomExPlayer_SetCueId ֐ACBnhAэĐ
 * L[IDZbg邱ƂŁAACBf[^̃L[Đ邱Ƃ\łB<br>
 * <br>
 * ACBt@C̃[hɐƁA{֐͖߂lƂ ACB nhԂ܂B<br>
 * [hG[ɂACBt@C̃[hɎsꍇA{֐͖߂lƂ
 * CRI_NULL Ԃ܂B<br>
 * \par l:
 * ::criAtomEx_SetUserAllocator }NgpăAP[^[o^ς݂̏ꍇA
 * {֐Ƀ[N̈w肷Kv͂܂B<br>
 * i work  NULL A work_size  0 w肷邱ƂŁAo^ς݂̃AP[^[
 * Kvȃ[N̈TCỸIɊmۂ܂Bj
 * <br>
 * {֐͑A֐łB<br>
 * ACBt@COɃɃ[hĂ{֐s邱ƂŁA
 * ACBnh쐬ɏubN̂\łB
 * <br>
 * f[^CPKɃpbNĂȂꍇAbinderɂNULLw肵ĂB<br>
 * \attention
 * {֐ɂăZbgf[^̈⃏[N̈̃eACBnhj
 * ܂ŃAvP[VŕێKv܂B<br>
 * iZbgς݂̃[N̈ɒl񂾂A肵Ă͂܂Bj<br>
 * ܂Af[^̈̈ꕔ̓[NƂĎgp܂B<br>
 * <br>
 * ACBf[^ɂ̓[N̈܂܂Ă܂B<br>
 * ̂߁A1ACBf[^̈𕡐񓯎Ƀ[h邱Ƃ͂ł܂B<br>
 * i쐬ꂽACBnh𕡐AtomExv[[ŋL邱Ƃ͉\łBj<br>
 * <br>
 * ACBnh͓IɃoC_[i CriFsBinderHn jmۂ܂B<br>
 * ACBt@C[hꍇAACBnh̃oC_[mۂłݒ
 * AtomCui܂CRI File SystemCujKv܂B<br>
 * <br>
 * {֐sOɁACuĂKv܂B<br>
 * \sa criAtomExAcb_CalculateWorkSizeForLoadAcbData, CriAtomExAcbHn, criAtomExPlayer_SetCueId
 */
CriAtomExAcbHn CRIAPI criAtomExAcb_LoadAcbData(
	void *acb_data, CriSint32 acb_data_size,
	CriFsBinderHn awb_binder, const CriChar8 *awb_path,
	void *work, CriSint32 work_size);

/*JP
 * \brief IACBf[^̃[hiCPKRecIDwj
 * \ingroup ATOMEXLIB_ACB
 * \param[in]	acb_data		ACBf[^AhX
 * \param[in]	acb_data_size	ACBf[^TCY
 * \param[in]	awb_binder		AWBt@C܂ރoC_[̃nh
 * \param[in]	awb_id			CPKt@CAWBf[^ID
 * \param[in]	work			[N̈
 * \param[in]	work_size		[N̈TCY
 * \return		CriAtomExAcbHn	ACBnh
 * \par :
 * ACBf[^[hAL[ĐɕKvȏ荞݂܂B<br>
 * t@CpX̑CPKRecIDw肷_΁A
 * ::criAtomExAcb_LoadAcbData ֐Ƌ@\͓łB<br>
 * \par lF
 * f[^CPKɃpbNĂȂꍇAbinderɂNULLw肵ĂB<br>
 * \sa criAtomExAcb_LoadAcbData
 */
CriAtomExAcbHn CRIAPI criAtomExAcb_LoadAcbDataById(
	void *acb_data, CriSint32 acb_data_size, CriFsBinderHn awb_binder, CriUint16 awb_id,
	void *work, CriSint32 work_size);

/*JP
 * \brief ACBt@C̃[hɕKvȃ[N̈TCY̌vZ
 * \ingroup ATOMEXLIB_ACB
 * \param[in]	acb_binder	ACBt@C܂ރoC_[̃nh
 * \param[in]	acb_path	ACBt@C̃pX
 * \param[in]	awb_binder	AWBt@C܂ރoC_[̃nh
 * \param[in]	awb_path	AWBt@C̃pX
 * \return		CriSint32	[N̈TCY
 * \retval		0ȏ		ɏ
 * \retval		-1			G[
 * \par :
 * ::criAtomExAcb_LoadAcbFile ֐̎sɕKvȃ[N̈TCYvZ܂B
 * ::criAtomEx_SetUserAllocator }NɂAP[^[o^s킸
 * ::criAtomExAcb_LoadAcbFile ֐ACBt@C[hۂɂ́A
 * {֐ԂTCỸ[N̈ƂēnKv܂B<br>
 * <br>
 * [N̈TCY̌vZɎsƁA{֐ -1 Ԃ܂B<br>
 * [N̈TCY̌vZɎsRɂẮAG[R[obÑbZ[WŊmF\łB<br>
 * \attention
 * [N̈̃TCY̓Cui ::criAtomEx_Initialize ֐sj
 * Ɏw肵p[^[ɂĕω܂B<br>
 * ̂߁A{֐sOɁACuĂKv܂B<br>
 * <br>
 * {֐͊A^̊֐łB<br>
 * ACBt@C̃[hɂ鎞Ԃ́AvbgtH[ɂĈقȂ܂B<br>
 * Q[[v̉ʍXVKvȃ^C~OŖ{֐sƃ~bPʂ
 * ubNAt[鋰ꂪ܂B<br>
 * ACBt@C̃[h́AV[̐؂ւ蓙Aוϓeł
 * ^C~Oōs悤肢܂B<br>
 * \sa criAtomExAcb_LoadAcbFile
 */
CriSint32 CRIAPI criAtomExAcb_CalculateWorkSizeForLoadAcbFile(
	CriFsBinderHn acb_binder, const CriChar8 *acb_path,
	CriFsBinderHn awb_binder, const CriChar8 *awb_path);

/*JP
 * \brief ACBt@C̃[hɕKvȃ[N̈TCY̌vZiCPKRecIDwj
 * \ingroup ATOMEXLIB_ACB
 * \param[in]	acb_binder	ACBt@C܂ރoC_[̃nh
 * \param[in]	acb_id		CPKt@CACBf[^ID
 * \param[in]	awb_binder	AWBt@C܂ރoC_[̃nh
 * \param[in]	awb_id		CPKt@CAWBf[^ID
 * \return		CriSint32	[N̈TCY
 * \retval		0ȏ		ɏ
 * \retval		-1			G[
 * \par :
 * ::criAtomExAcb_LoadAcbFileById ֐̎sɕKvȃ[N̈TCYvZ܂B
 * t@CpX̑CPKRecIDw肷_΁A
 * ::criAtomExAcb_CalculateWorkSizeForLoadAcbFile ֐Ƌ@\͓łB<br>
 * \par lF
 * f[^CPKɃpbNĂȂꍇAbinderɂNULLw肵ĂB<br>
 * \sa criAtomExAcb_CalculateWorkSizeForLoadAcbFile, criAtomExAcb_LoadAcbFileById
 */
CriSint32 CRIAPI criAtomExAcb_CalculateWorkSizeForLoadAcbFileById(
	CriFsBinderHn acb_binder, CriUint16 acb_id, CriFsBinderHn awb_binder, CriUint16 awb_id);

/*JP
 * \brief ACBt@C̃[h
 * \ingroup ATOMEXLIB_ACB
 * \param[in]	acb_binder		ACBt@C܂ރoC_[̃nh
 * \param[in]	acb_path		ACBt@C̃pX
 * \param[in]	awb_binder		AWBt@C܂ރoC_[̃nh
 * \param[in]	awb_path		AWBt@C̃pX
 * \param[in]	work			[N̈
 * \param[in]	work_size		[N̈TCY
 * \return		CriAtomExAcbHn	ACBnh
 * \par :
 * ACBt@C[hAL[ĐɕKvȏ荞݂܂B<br>
 * ACBt@C̃[hɕKvȃ[N̈̃TCÝA
 * ::criAtomExAcb_CalculateWorkSizeForLoadAcbFile ֐ŌvZ܂B<br>
 * <br>
 * 3 awb_binder Aё4 awb_path ɂ́AXg[Đp
 * AWBt@Cw肵܂B<br>
 * iIĐ݂̂ACBf[^[hꍇA awb_binder 
 * awb_path ɃZbgl͖܂Bj<br>
 * <br>
 * ACBt@C[hƁAACBf[^ɃANZX邽߂ACBnh
 * i ::CriAtomExAcbHn jԂ܂B<br>
 * AtomExv[[ɑ΂A ::criAtomExPlayer_SetCueId ֐ACBnhAэĐ
 * L[IDZbg邱ƂŁAACBt@C̃L[Đ邱Ƃ\łB<br>
 * <br>
 * ACBt@C̃[hɐƁA{֐͖߂lƂ ACB nhԂ܂B<br>
 * [hG[ɂACBt@C̃[hɎsꍇA{֐͖߂lƂ
 * CRI_NULL Ԃ܂B<br>
 * \par l:
 * ::criAtomEx_SetUserAllocator }NgpăAP[^[o^ς݂̏ꍇA
 * {֐Ƀ[N̈w肷Kv͂܂B<br>
 * i work  NULL A work_size  0 w肷邱ƂŁAo^ς݂̃AP[^[
 * Kvȃ[N̈TCỸIɊmۂ܂Bj
 * <br>
 * \par lF
 * f[^CPKɃpbNĂȂꍇAbinderɂNULLw肵ĂB<br>
 * \attention
 * {֐sOɁACuĂKv܂B<br>
 * <br>
 * {֐Ƀ[N̈ZbgꍇAZbg̈̃ACBnhj
 * ܂ŃAvP[VŕێKv܂B<br>
 * iZbgς݂̃[N̈ɒl񂾂A肵Ă͂܂Bj<br>
 * <br>
 * {֐͊A^̊֐łB<br>
 * ACBt@C̃[hɂ鎞Ԃ́AvbgtH[ɂĈقȂ܂B<br>
 * Q[[v̉ʍXVKvȃ^C~OŖ{֐sƃ~bPʂ
 * ubNAt[鋰ꂪ܂B<br>
 * ACBt@C̃[h́AV[̐؂ւ蓙Aוϓeł
 * ^C~Oōs悤肢܂B<br>
 * \sa criAtomExAcb_CalculateWorkSizeForLoadAcbFile, CriAtomExAcbHn, criAtomExPlayer_SetCueId
 */
CriAtomExAcbHn CRIAPI criAtomExAcb_LoadAcbFile(
	CriFsBinderHn acb_binder, const CriChar8 *acb_path,
	CriFsBinderHn awb_binder, const CriChar8 *awb_path,
	void *work, CriSint32 work_size);

/*JP
 * \brief ACBt@C̃[hiCPKRecIDwj
 * \ingroup ATOMEXLIB_ACB
 * \param[in]	acb_binder		ACBt@C܂ރoC_[̃nh
 * \param[in]	acb_id			CPKt@CACBf[^ID
 * \param[in]	awb_binder		AWBt@C܂ރoC_[̃nh
 * \param[in]	awb_id			CPKt@CAWBf[^ID
 * \param[in]	work			[N̈
 * \param[in]	work_size		[N̈TCY
 * \return		CriAtomExAcbHn	ACBnh
 * \par :
 * ACBt@C[hAL[ĐɕKvȏ荞݂܂B<br>
 * t@CpX̑CPKRecIDw肷_΁A
 * ::criAtomExAcb_LoadAcbFile ֐Ƌ@\͓łB<br>
 * \par lF
 * f[^CPKɃpbNĂȂꍇAbinderɂNULLw肵ĂB<br>
 * \sa criAtomExAcb_LoadAcbFile
 */
CriAtomExAcbHn CRIAPI criAtomExAcb_LoadAcbFileById(
	CriFsBinderHn acb_binder, CriUint16 acb_id, CriFsBinderHn awb_binder, CriUint16 awb_id,
	void *work, CriSint32 work_size);

/*JP
 * \brief ACBnh̃[X
 * \ingroup ATOMEXLIB_ACB
 * \param[in]	acb_hn		ACBnh
 * \par :
 * ACBnh܂B<br>
 * ::criAtomEx_SetUserAllocator }NgpăAP[^[o^ς݂̏ꍇA
 * ACBnh쐬Ɋmۂꂽ̈悪܂B<br>
 * iACBnh쐬Ƀ[N̈nꍇA{֐sł
 * [N̈\łBj<br>
 * \par l:
 * {֐ACBnhjۂɂ́A
 * YACBnhQƂĂL[͑SĒ~܂B<br>
 * i{֐sɁAACBnh̍쐬Ɏgp[N̈A
 * ACBf[^zuĂ̈悪QƂ邱Ƃ͂܂Bj<br>
 * \attention
 * {֐sƁAj悤ƂĂACBf[^QƂĂ
 * Atomv[[݂̑鏈삵܂B<br>
 * ̂߁A{֐sɑXbhAtomv[[̍쐬^jsƁA
 * ANZXᔽfbhbN̏dȕsU鋰ꂪ܂B<br>
 * {֐sAtomv[[̍쐬^j𑼃XbhōsKvꍇA
 * Atomv[[̍쐬^j ::criAtomEx_Lock ֐ŃbNĂsB<br>
 * \sa criAtomExAcb_LoadAcbData, criAtomExAcb_LoadAcbFile
 */
void CRIAPI criAtomExAcb_Release(CriAtomExAcbHn acb_hn);

/*JP
 * \brief ACBnh\ǂ̃`FbN
 * \ingroup ATOMLIBEX_ACB
 * \param[in]	acb_hn		acbnh
 * \return		CriBool		ACB̏ԁiCRI_TRUE = \ACRI_FALSE = Đ̃v[[j
 * \par :
 * ACBnh𑦍ɉ\ǂ`FbN܂B<br>
 * {֐ CRI_FALSE Ԃ^C~O ::criAtomExAcb_Release ֐sƁA
 * ACBnhQƂĂv[[ɑ΂~s܂B<br>
 * iXg[ĐpACBnh̏ꍇAt@Cǂݍ݊҂߁A
 * ::criAtomExAcb_Release ֐ŒԏubN\܂Bj<br>
 * \par l:
 * ACBnhĐĂv[[SĒ~ꍇłA
 * Cuł͓YACBnhQƂĂ{CX݂\܂B<br>
 * i ::criAtomExPlayer_StopWithoutReleaseTime ֐Œ~sꍇA
 * {CX̒D肪ꍇAv[[{CX͐؂藣܂A
 * ̌{CXŃt@C̓ǂݍ݊҂sP[X܂Bj<br>
 * ::criAtomExAcb_Release ֐ŏubN̂Kvꍇɂ́A
 * {֐ CRI_TRUE Ԃ܂ŁA::criAtomExAcb_Release ֐sȂłB<br>
 * \attention
 * {֐sƁAw肵ACBf[^QƂĂAtomv[[݂̑
 * 鏈삵܂B<br>
 * ̂߁A{֐sɑXbhAtomv[[̍쐬^jsƁA
 * ANZXᔽfbhbN̏dȕsU鋰ꂪ܂B<br>
 * {֐sAtomv[[̍쐬^j𑼃XbhōsKvꍇA
 * Atomv[[̍쐬^j ::criAtomEx_Lock ֐ŃbNĂsB<br>
 * \sa criAtomExAcb_Release
 */
CriBool CRIAPI criAtomExAcb_IsReadyToRelease(CriAtomExAcbHn acb_hn);

/*JP
 * \brief SĂACBnh[X
 * \ingroup ATOMEXLIB_ACB
 * \par :
 * [hς݂̑SĂACBnh܂B<br>
 * ::criAtomEx_SetUserAllocator }NgpăAP[^[o^ς݂̏ꍇA
 * ACBnh쐬Ɋmۂꂽ̈悪܂B<br>
 * iACBnh쐬Ƀ[N̈nꍇA{֐sł
 * [N̈\łBj<br>
 * \par l:
 * {֐sƁASẴL[Đ̎_Œ~܂B<br>
 * i{֐sɁAACBnh̍쐬Ɏgp[N̈A
 * ACBf[^zuĂ̈悪QƂ邱Ƃ͂܂Bj<br>
 * \attention
 * {֐sƁAw肵ACBf[^QƂĂAtomv[[݂̑
 * 鏈삵܂B<br>
 * ̂߁A{֐sɑXbhAtomv[[̍쐬^jsƁA
 * ANZXᔽfbhbN̏dȕsU鋰ꂪ܂B<br>
 * {֐sAtomv[[̍쐬^j𑼃XbhōsKvꍇA
 * Atomv[[̍쐬^j ::criAtomEx_Lock ֐ŃbNĂsB<br>
 * \sa criAtomExAcb_LoadAcbData, criAtomExAcb_LoadAcbFile
 */
void CRIAPI criAtomExAcb_ReleaseAll(void);

/*JP
 * \brief ACBnh̗
 * \ingroup ATOMEXLIB_ACB
 * \param[in]	func		ACBnhR[obN֐
 * \param[in]	obj			[UwIuWFNg
 * \return		CriSint32	񋓂ꂽACBnh̐
 * \par :
 * ACBnh񋓂܂B<br>
 * <br>
 * {֐sƁA 1 i func j
 * ŃZbgꂽR[obN֐ACBnh̐Ăяo܂B<br>
 * R[obN֐ɂ́AACBnhƂēn܂B<br>
 * \par l:
 *  2 i obj jɃZbgĺAR[obN֐̈Ƃēn܂B<br>
 * R[obN֐̂̑̈ɂẮA
 * ʓr ::CriAtomExAcbHandleCbFunc ̐QƂB<br>
 * <br>
 * ߂l͗񋓂ꂽACBnh̐io^R[obN֐Ăяoꂽ񐔁jłB<br>
 * iR[obNɗ񋓂𒆎~ꍇł 1 Ԃ܂Bj<br>
 * ACBnh݂ȂꍇA{֐ 0 Ԃ܂B<br>
 * ܂AsȏꍇAG[ۂɂ -1 Ԃ܂B<br>
 * \attention
 * ACBnhR[obN֐ŔjĂ͂܂B<br>
 * SĂACBnhꊇŔjꍇɂ́A{֐̑ɁA
 * ::criAtomExAcb_ReleaseAll ֐gpĂB<br>
 * \sa CriAtomExAcbHandleCbFunc, criAtomExAcb_ReleaseAll
 */
CriSint32 CRIAPI criAtomExAcb_EnumerateHandles(CriAtomExAcbHandleCbFunc func, void *obj);

/*JP
 * \brief IACB̃o[W擾
 * \ingroup ATOMEXLIB_ACB
 * \param[in]	acb_data		ACBf[^AhX
 * \param[in]	acb_data_size	ACBf[^TCY
 * \param[out]	flag			[h\tO
 * \return		CriUint2		ACBtH[}bgo[W
 * \par :
 * ɔzuꂽACBf[^̃tH[}bgo[W擾܂B<br>
 * ܂AflagɃ[h\ȃo[WǂBoollŕԂ܂B<br>
 */
CriUint32 CRIAPI criAtomExAcb_GetVersion(
	void *acb_data, CriSint32 acb_data_size, void *flag);

/*JP
 * \brief ACBt@C̃o[W擾
 * \ingroup ATOMEXLIB_ACB
 * \param[in]	acb_binder	ACBt@C܂ރoC_[̃nh
 * \param[in]	acb_path	ACBt@C̃pX
 * \param[in]	work		[N̈
 * \param[in]	work_size	[N̈TCY
 * \param[out]	flag		[h\tO
 * \return		CriUint2	ACBtH[}bgo[W
 * \par :
 * ACBt@CɃ[hACBf[^̃tH[}bgo[W擾܂B<br>
 * ACB̓o^ɕKvȃ[N̈̃TCÝA
 * ::criAtomExAcb_CalculateWorkSizeForLoadAcbFile ֐ŌvZ܂B<br>
 * <br>
 * ACBt@CtH[}bgo[WflagɃ[h\ȃo[WǂBoollŕԂ܂B<br>
 * \par l:
 * ::criAtomEx_SetUserAllocator }NgpăAP[^[o^ς݂̏ꍇA
 * {֐Ƀ[N̈w肷Kv͂܂B<br>
 * i work  NULL A work_size  0 w肷邱ƂŁAo^ς݂̃AP[^[
 * Kvȃ[N̈TCỸIɊmۂ܂Bj
 * <br>
 * \par lF
 * f[^CPKɃpbNĂȂꍇAbinderɂNULLw肵ĂB<br>
 * \attention
 * {֐ɃZbg[N̈́A AvP[VŕێKv͂܂B<br>
 * iɃ[hf[^͊֐Iɉ܂Bj<br>
 */
CriUint32 CRIAPI criAtomExAcb_GetVersionFromFile(
	CriFsBinderHn acb_binder, const CriChar8 *acb_path, void *work, CriSint32 work_size, CriBool *flag);

/*JP
 * \brief [h\o[W擾
 * \ingroup ATOMEXLIB_ACB
 * \param[out]	version_low		[h\ʃo[W
 * \param[out]	version_high	[h\ʃo[W
 * \par :
 * [h\ACB̃o[W擾܂B<br>
 * ʃo[W̓Curh_ł̏̂߁A̒lʂACBł
 * [h\ȏꍇ܂B<br>
 */
void CRIAPI criAtomExAcb_GetSupportedVersion(
	CriUint32 *version_low, CriUint32 *version_high);

/*JP
 * \brief L[̎擾
 * \ingroup ATOMEXLIB_ACB
 * \param[in]	acb_hn		ACBnh
 * \return		CriSint32	L[
 * \par :
 * ACBf[^Ɋ܂܂L[擾܂B<br>
 * \par l:
 * i acb_hn j NULL w肵ꍇAŌɃ[hACBf[^ΏۂƂ܂B<br>
 */
CriSint32 CRIAPI criAtomExAcb_GetNumCues(CriAtomExAcbHn acb_hn);

/*JP
 * \brief L[̑݊mFiL[IDwj
 * \ingroup ATOMEXLIB_ACB
 * \param[in]	acb_hn		ACBnh
 * \param[in]	id			L[ID
 * \return		CriBool		L[݂邩ǂi݂FCRI_TRUE^݂ȂFCRI_FALSEj
 * \par :
 * w肵ID̃L[݂邩ǂ擾܂B<br>
 * ݂ꍇɂCRI_TRUEԂ܂B<br>
 * \par l:
 * 1i ach_hn j NULL w肵ꍇASĂACBf[^ΏۂƂȂ܂B<br>
 * iw肵IDACBf[^1ł݂΁A{֐ CRI_TRUE Ԃ܂Bj<br>
 */
CriBool CRIAPI criAtomExAcb_ExistsId(CriAtomExAcbHn acb_hn, CriAtomExCueId id);

/*JP
 * \brief L[̑݊mFiL[wj
 * \ingroup ATOMEXLIB_ACB
 * \param[in]	acb_hn		ACBnh
 * \param[in]	name		L[
 * \return		CriBool		L[݂邩ǂi݂FCRI_TRUE^݂ȂFCRI_FALSEj
 * \par :
 * w肵ÕL[݂邩ǂ擾܂B<br>
 * ݂ꍇɂCRI_TRUEԂ܂B<br>
 * \par l:
 * 1i ach_hn j NULL w肵ꍇASĂACBf[^ΏۂƂȂ܂B<br>
 * iw肵L[ACBf[^1ł݂΁A{֐ CRI_TRUE Ԃ܂Bj<br>
 */
CriBool CRIAPI criAtomExAcb_ExistsName(CriAtomExAcbHn acb_hn, const CriChar8 *name);

/*JP
 * \brief L[̑݊mFiL[CfbNXwj
 * \ingroup ATOMEXLIB_ACB
 * \param[in]	acb_hn		ACBnh
 * \param[in]	index		L[CfbNX
 * \return		CriBool		L[݂邩ǂi݂FCRI_TRUE^݂ȂFCRI_FALSEj
 * \par :
 * w肵CfbNX̃L[݂邩ǂ擾܂B<br>
 * ݂ꍇɂCRI_TRUEԂ܂B<br>
 * \par l:
 * 1i ach_hn j NULL w肵ꍇASĂACBf[^ΏۂƂȂ܂B<br>
 * iw肵L[CfbNXACBf[^1ł݂΁A{֐ CRI_TRUE Ԃ܂Bj<br>
 */
CriBool CRIAPI criAtomExAcb_ExistsIndex(CriAtomExAcbHn acb_hn, CriAtomExCueIndex index);

/*JP
 * \brief L[ID̎擾iL[CfbNXwj
 * \ingroup ATOMEXLIB_ACB
 * \param[in]	acb_hn			ACBnh
 * \param[in]	index			L[CfbNX
 * \return		CriAtomExCueId	L[ID
 * \par :
 * L[CfbNXL[ID擾܂B<br>
 * w肵L[CfbNX̃L[݂ȂꍇA-1Ԃ܂B
 * \par l:
 * 1i ach_hn j NULL w肵ꍇASĂACBf[^ΏۂɁAw肵L[CfbNX
 * vf[^݂̑鏈삵܂B<br>
 * iw肵L[CfbNXACBf[^_ŁA
 * YACBf[^̃L[IDԂ܂Bj<br>
 * ̍ہȀ́AACBf[^̃[hƂ͋tōs܂B<br>
 * iォ烍[hꂽf[^DIɌs܂Bj<br>
 */
CriAtomExCueId CRIAPI criAtomExAcb_GetCueIdByIndex(CriAtomExAcbHn acb_hn, CriAtomExCueIndex index);

/*JP
 * \brief L[ID̎擾iL[wj
 * \ingroup ATOMEXLIB_ACB
 * \param[in]	acb_hn			ACBnh
 * \param[in]	name			L[
 * \return		CriAtomExCueId	L[ID
 * \par :
 * L[L[ID擾܂B<br>
 * w肵L[̃L[݂ȂꍇA-1Ԃ܂B
 * \par l:
 * 1i ach_hn j NULL w肵ꍇASĂACBf[^ΏۂɁAw肵L[
 * vf[^݂̑鏈삵܂B<br>
 * iw肵L[ACBf[^_ŁA
 * YACBf[^̃L[IDԂ܂Bj<br>
 * ̍ہȀ́AACBf[^̃[hƂ͋tōs܂B<br>
 * iォ烍[hꂽf[^DIɌs܂Bj<br>
 */
CriAtomExCueId CRIAPI criAtomExAcb_GetCueIdByName(CriAtomExAcbHn acb_hn, const CriChar8* name);

/*JP
 * \brief L[̎擾iL[CfbNXwj
 * \ingroup ATOMEXLIB_ACB
 * \param[in]	acb_hn		ACBnh
 * \param[in]	index		L[CfbNX
 * \return		const CriChar8* L[
 * \par :
 * L[CfbNXL[擾܂B<br>
 * w肵L[CfbNX̃L[݂ȂꍇANULLԂ܂B
 * \par l:
 * 1i ach_hn j NULL w肵ꍇASĂACBf[^ΏۂɁAw肵L[CfbNX
 * vf[^݂̑鏈삵܂B<br>
 * iw肵L[CfbNXACBf[^_ŁA
 * YACBf[^̃L[̖OԂ܂Bj<br>
 * ̍ہȀ́AACBf[^̃[hƂ͋tōs܂B<br>
 * iォ烍[hꂽf[^DIɌs܂Bj<br>
 */
const CriChar8 * CRIAPI criAtomExAcb_GetCueNameByIndex(CriAtomExAcbHn acb_hn, CriAtomExCueIndex index);

/*JP
 * \brief L[̎擾iL[IDwj
 * \ingroup ATOMEXLIB_ACB
 * \param[in]	acb_hn		ACBnh
 * \param[in]	id			L[ID
 * \return		const CriChar8* L[
 * \par :
 * L[IDL[擾܂B<br>
 * w肵L[ID̃L[݂ȂꍇANULLԂ܂B
 * \par l:
 * 1i ach_hn j NULL w肵ꍇASĂACBf[^ΏۂɁAw肵L[ID
 * vf[^݂̑鏈삵܂B<br>
 * iw肵L[IDACBf[^_ŁA
 * YACBf[^̃L[̖OԂ܂Bj<br>
 * ̍ہȀ́AACBf[^̃[hƂ͋tōs܂B<br>
 * iォ烍[hꂽf[^DIɌs܂Bj<br>
 */
const CriChar8 * CRIAPI criAtomExAcb_GetCueNameById(CriAtomExAcbHn acb_hn, CriAtomExCueId id);

/*JP
 * \brief L[CfbNX̎擾iL[IDwj
 * \ingroup ATOMEXLIB_ACB
 * \param[in]	acb_hn				ACBnh
 * \param[in]	id					L[ID
 * \return		CriAtomExCueIndex	L[CfbNX
 * \par :
 * L[IDL[CfbNX擾܂B<br>
 * w肵L[ID̃L[݂ȂꍇA-1Ԃ܂B
 * \par l:
 * 1i ach_hn j NULL w肵ꍇASĂACBf[^ΏۂɁAw肵L[ID
 * vf[^݂̑鏈삵܂B<br>
 * iw肵L[IDACBf[^_ŁA
 * YACBf[^̃L[̃CfbNXԂ܂Bj<br>
 * ̍ہȀ́AACBf[^̃[hƂ͋tōs܂B<br>
 * iォ烍[hꂽf[^DIɌs܂Bj<br>
 */
CriAtomExCueIndex CRIAPI criAtomExAcb_GetCueIndexById(CriAtomExAcbHn acb_hn, CriAtomExCueId id);

/*JP
 * \brief L[CfbNX̎擾iL[wj
 * \ingroup ATOMEXLIB_ACB
 * \param[in]	acb_hn				ACBnh
 * \param[in]	name				L[
 * \return		CriAtomExCueIndex	L[CfbNX
 * \par :
 * L[L[CfbNX擾܂B<br>
 * w肵L[̃L[݂ȂꍇA-1Ԃ܂B
 * \par l:
 * 1i ach_hn j NULL w肵ꍇASĂACBf[^ΏۂɁAw肵L[
 * vf[^݂̑鏈삵܂B<br>
 * iw肵L[ACBf[^_ŁA
 * YACBf[^̃L[̃CfbNXԂ܂Bj<br>
 * ̍ہȀ́AACBf[^̃[hƂ͋tōs܂B<br>
 * iォ烍[hꂽf[^DIɌs܂Bj<br>
 */
CriAtomExCueIndex CRIAPI criAtomExAcb_GetCueIndexByName(CriAtomExAcbHn acb_hn, const CriChar8* name);

/*JP
 * \brief [Uf[^̎擾iL[IDwj
 * \ingroup ATOMEXLIB_ACB
 * \param[in]	acb_hn				ACBnh
 * \param[in]	id					L[ID
 * \return		const CriChar8 *	[Uf[^
 * \par :
 * L[IDw肵āAL[̃[Uf[^擾܂B<br>
 * w肵L[ID̃L[݂ȂꍇANULLԂ܂B
 * \par l:
 * 1i ach_hn j NULL w肵ꍇASĂACBf[^ΏۂɁAw肵L[ID
 * vf[^݂̑鏈삵܂B<br>
 * iw肵L[IDACBf[^_ŁA
 * YACBf[^̃L[̃[Uf[^Ԃ܂Bj<br>
 * ̍ہȀ́AACBf[^̃[hƂ͋tōs܂B<br>
 * iォ烍[hꂽf[^DIɌs܂Bj<br>
 */
const CriChar8 * CRIAPI criAtomExAcb_GetUserDataById(CriAtomExAcbHn acb_hn, CriAtomExCueId id);

/*JP
 * \brief [Uf[^̎擾iL[wj
 * \ingroup ATOMEXLIB_ACB
 * \param[in]	acb_hn		ACBnh
 * \param[in]	name		L[
 * \return		const CriChar8 * [Uf[^
 * \par :
 * L[w肵āAL[̃[Uf[^擾܂B<br>
 * w肵L[̃L[݂ȂꍇANULLԂ܂B
 * \par l:
 * 1i ach_hn j NULL w肵ꍇASĂACBf[^ΏۂɁAw肵L[
 * vf[^݂̑鏈삵܂B<br>
 * iw肵L[ACBf[^_ŁA
 * YACBf[^̃L[̃[Uf[^Ԃ܂Bj<br>
 * ̍ہȀ́AACBf[^̃[hƂ͋tōs܂B<br>
 * iォ烍[hꂽf[^DIɌs܂Bj<br>
 */
const CriChar8 * CRIAPI criAtomExAcb_GetUserDataByName(CriAtomExAcbHn acb_hn, const CriChar8 *name);

/*JP
 * \brief L[̒̎擾iL[IDwj
 * \ingroup ATOMEXLIB_ACB
 * \param[in]	acb_hn		ACBnh
 * \param[in]	id			L[ID
 * \return		CriSint64	L[̒i~bPʁj
 * \par :
 * L[IDw肵āAL[̒擾܂BL[̒̓~bPʂłB<br>
 * w肵L[ID̃L[݂ȂꍇA[vL[̏ꍇA-1Ԃ܂B<br>
 * \par l:
 * 1i ach_hn j NULL w肵ꍇASĂACBf[^ΏۂɁAw肵L[ID
 * vf[^݂̑鏈삵܂B<br>
 * iw肵L[IDACBf[^_ŁA
 * YACBf[^̃L[̒Ԃ܂Bj<br>
 * ̍ہȀ́AACBf[^̃[hƂ͋tōs܂B<br>
 * iォ烍[hꂽf[^DIɌs܂Bj<br>
 */
CriSint64 CRIAPI criAtomExAcb_GetLengthById(CriAtomExAcbHn acb_hn, CriAtomExCueId id);

/*JP
 * \brief L[̒̎擾iL[wj
 * \ingroup ATOMEXLIB_ACB
 * \param[in]	acb_hn		ACBnh
 * \param[in]	name		L[
 * \return		CriSint64	L[̒i~bPʁj
 * \par :
 * L[w肵āAL[̒擾܂BL[̒̓~bPʂłB<br>
 * w肵L[̃L[݂ȂꍇA[vL[̏ꍇA-1Ԃ܂B<br>
 * \par l:
 * 1i ach_hn j NULL w肵ꍇASĂACBf[^ΏۂɁAw肵L[
 * vf[^݂̑鏈삵܂B<br>
 * iw肵L[ACBf[^_ŁA
 * YACBf[^̃L[̒Ԃ܂Bj<br>
 * ̍ہȀ́AACBf[^̃[hƂ͋tōs܂B<br>
 * iォ烍[hꂽf[^DIɌs܂Bj<br>
 */
CriSint64 CRIAPI criAtomExAcb_GetLengthByName(CriAtomExAcbHn acb_hn, const CriChar8 *name);

/*JP
 * \brief L[ŃRg[\AISAC Controľ̎擾iL[IDwj
 * \ingroup ATOMEXLIB_ACB
 * \param[in]	acb_hn		ACBnh
 * \param[in]	id			L[ID
 * \return		CriSint32	AISAC Controľ
 * \par :
 * L[IDw肵āAL[ŃRg[\AISAC Controľ擾܂B<br>
 * w肵L[ID̃L[݂Ȃꍇ́A-1Ԃ܂B<br>
 * \par l:
 * 1i ach_hn j NULL w肵ꍇASĂACBf[^ΏۂɁAw肵L[ID
 * vf[^݂̑鏈삵܂B<br>
 * iw肵L[IDACBf[^_ŁA
 * YACBf[^̃L[̃Rg[\AISAC ControľԂ܂Bj<br>
 * ̍ہȀ́AACBf[^̃[hƂ͋tōs܂B<br>
 * iォ烍[hꂽf[^DIɌs܂Bj<br>
 * \sa criAtomExAcb_GetNumUsableAisacControlsByName, criAtomExAcb_GetUsableAisacControlById, criAtomExAcb_GetUsableAisacControlByName
 */
CriSint32 CRIAPI criAtomExAcb_GetNumUsableAisacControlsById(CriAtomExAcbHn acb_hn, CriAtomExCueId id);

/*JP
 * \brief L[ŃRg[\AISAC Controľ̎擾iL[wj
 * \ingroup ATOMEXLIB_ACB
 * \param[in]	acb_hn		ACBnh
 * \param[in]	name		L[
 * \return		CriSint32	AISAC Controľ
 * \par :
 * L[w肵āAL[ŃRg[\AISAC Controľ擾܂B<br>
 * w肵L[̃L[݂Ȃꍇ́A-1Ԃ܂B<br>
 * \par l:
 * 1i ach_hn j NULL w肵ꍇASĂACBf[^ΏۂɁAw肵L[
 * vf[^݂̑鏈삵܂B<br>
 * iw肵L[ACBf[^_ŁA
 * YACBf[^̃L[̃Rg[\AISAC ControľԂ܂Bj<br>
 * ̍ہȀ́AACBf[^̃[hƂ͋tōs܂B<br>
 * iォ烍[hꂽf[^DIɌs܂Bj<br>
 * \sa criAtomExAcb_GetNumUsableAisacControlsById, criAtomExAcb_GetUsableAisacControlById, criAtomExAcb_GetUsableAisacControlByName
 */
CriSint32 CRIAPI criAtomExAcb_GetNumUsableAisacControlsByName(CriAtomExAcbHn acb_hn, const CriChar8 *name);

/*JP
 * \brief L[ŃRg[\AISAC Control̎擾iL[IDwj
 * \ingroup ATOMEXLIB_ACB
 * \param[in]	acb_hn		ACBnh
 * \param[in]	id			L[ID
 * \param[in]	index		AISAC ControlCfbNX
 * \param[out]	info		AISAC Control
 * \return		CriBool		擾ɐǂiFCRI_TRUEAsFCRI_FALSEj
 * \par :
 * L[IDAISAC ControlCfbNXw肵āAAISAC Control擾܂B<br>
 * w肵L[ID̃L[݂Ȃꍇ́ACRI_FALSEԂ܂B<br>
 * \par l:
 * 1i ach_hn j NULL w肵ꍇASĂACBf[^ΏۂɁAw肵L[ID
 * vf[^݂̑鏈삵܂B<br>
 * iw肵L[IDACBf[^_ŁA
 * YACBf[^̃L[AISAC Control񂪕Ԃ܂Bj<br>
 * ̍ہȀ́AACBf[^̃[hƂ͋tōs܂B<br>
 * iォ烍[hꂽf[^DIɌs܂Bj<br>
 * \sa criAtomExAcb_GetNumUsableAisacControlsById, criAtomExAcb_GetNumUsableAisacControlsByName, criAtomExAcb_GetUsableAisacControlByName
 */
CriBool CRIAPI criAtomExAcb_GetUsableAisacControlById(CriAtomExAcbHn acb_hn, CriAtomExCueId id, CriUint16 index, CriAtomExAisacControlInfo* info);

/*JP
 * \brief L[ŃRg[\AISAC Control̎擾iL[wj
 * \ingroup ATOMEXLIB_ACB
 * \param[in]	acb_hn		ACBnh
 * \param[in]	name		L[
 * \param[in]	index		AISAC ControlCfbNX
 * \param[out]	info		AISAC Control
 * \return		CriBool		擾ɐǂiFCRI_TRUEAsFCRI_FALSEj
 * \par :
 * L[AISAC ControlCfbNXw肵āAAISAC Control擾܂B<br>
 * w肵L[̃L[݂Ȃꍇ́ACRI_FALSEԂ܂B<br>
 * \par l:
 * 1i ach_hn j NULL w肵ꍇASĂACBf[^ΏۂɁAw肵L[
 * vf[^݂̑鏈삵܂B<br>
 * iw肵L[ACBf[^_ŁA
 * YACBf[^̃L[AISAC Control񂪕Ԃ܂Bj<br>
 * ̍ہȀ́AACBf[^̃[hƂ͋tōs܂B<br>
 * iォ烍[hꂽf[^DIɌs܂Bj<br>
 * \sa criAtomExAcb_GetNumUsableAisacControlsById, criAtomExAcb_GetNumUsableAisacControlsByName, criAtomExAcb_GetUsableAisacControlById
 */
CriBool CRIAPI criAtomExAcb_GetUsableAisacControlByName(CriAtomExAcbHn acb_hn, const CriChar8 *name, CriUint16 index, CriAtomExAisacControlInfo* info);

/*JP
 * \brief L[AISAC ControlŃRg[\ǂ̎擾iIDwj
 * \ingroup ATOMEXLIB_ACB
 * \param[in]	acb_hn				ACBnh
 * \param[in]	id					L[ID
 * \param[in]	aisac_control_id	AISAC Control id
 * \return		CriBool				Rg[\ǂi\FCRI_TRUEAs\FCRI_FALSEj
 * \par :
 * L[IDAISAC Control Idw肵āAL[AISAC ControlŃRg[\ǂ擾܂B<br>
 * w肵L[ID̃L[݂Ȃꍇ́ACRI_FALSEԂ܂B<br>
 * \par l:
 * 1i ach_hn j NULL w肵ꍇASĂACBf[^ΏۂɁAw肵L[ID
 * vf[^݂̑鏈삵܂B<br>
 * iw肵L[IDACBf[^_ŁA
 * YACBf[^̃L[AISAC ControlɒlԂ܂j<br>
 * ̍ہȀ́AACBf[^̃[hƂ͋tōs܂B<br>
 * iォ烍[hꂽf[^DIɌs܂Bj<br>
 * \sa criAtomExAcb_IsUsingAisacControlByName
 */
CriBool CRIAPI criAtomExAcb_IsUsingAisacControlById(CriAtomExAcbHn acb_hn, CriAtomExCueId id, CriAtomExAisacControlId aisac_control_id);

/*JP
 * \brief L[AISAC ControlŃRg[\ǂ̎擾iOwj
 * \ingroup ATOMEXLIB_ACB
 * \param[in]	acb_hn					ACBnh
 * \param[in]	name					L[
 * \param[in]	aisac_control_name		AISAC ControlCfbNX
 * \return		CriBool					擾ɐǂiFCRI_TRUEAsFCRI_FALSEj
 * \par :
 * L[AISAC ControlCfbNXw肵āAAISAC Control擾܂B<br>
 * w肵L[̃L[݂Ȃꍇ́ACRI_FALSEԂ܂B<br>
 * \par l:
 * 1i ach_hn j NULL w肵ꍇASĂACBf[^ΏۂɁAw肵L[
 * vf[^݂̑鏈삵܂B<br>
 * iw肵L[ACBf[^_ŁA
 * YACBf[^̃L[AISAC ControlɒlԂ܂j<br>
 * ̍ہȀ́AACBf[^̃[hƂ͋tōs܂B<br>
 * iォ烍[hꂽf[^DIɌs܂Bj<br>
 * \sa criAtomExAcb_IsUsingAisacControlById
 */
CriBool CRIAPI criAtomExAcb_IsUsingAisacControlByName(CriAtomExAcbHn acb_hn, const CriChar8 *name, const CriChar8 *aisac_control_name);

/*JP
 * \brief L[ɐݒ肳ĂvCIeB̎擾iL[IDwj
 * \ingroup ATOMEXLIB_ACB
 * \param[in]	acb_hn		ACBnh
 * \param[in]	id			L[ID
 * \return		CriSint32	vCIeBi擾Ɏsꍇ-1A܂j
 * \par :
 * L[IDw肵āAL[ɐݒ肳ĂvCIeB擾܂B<br>
 * w肵L[ID̃L[݂Ȃꍇ́A-1Ԃ܂B<br>
 * \par l:
 * 1i ach_hn j NULL w肵ꍇASĂACBf[^ΏۂɁAw肵L[ID
 * vf[^݂̑鏈삵܂B<br>
 * iw肵L[IDACBf[^_ŁA
 * YACBf[^̃L[̃vCIeBԂ܂Bj<br>
 * ̍ہȀ́AACBf[^̃[hƂ͋tōs܂B<br>
 * iォ烍[hꂽf[^DIɌs܂Bj<br>
 * \sa criAtomExAcb_GetCuePriorityByName
 */
CriSint32 CRIAPI criAtomExAcb_GetCuePriorityById(CriAtomExAcbHn acb_hn, CriAtomExCueId id);

/*JP
 * \brief L[ɐݒ肳ĂvCIeB̎擾iL[wj
 * \ingroup ATOMEXLIB_ACB
 * \param[in]	acb_hn		ACBnh
 * \param[in]	name		L[
 * \return		CriSint32	vCIeBi擾Ɏsꍇ-1A܂j
 * \par :
 * L[w肵āAL[ɐݒ肳ĂvCIeB擾܂B<br>
 * w肵L[̃L[݂Ȃꍇ́A-1Ԃ܂B<br>
 * \par l:
 * 1i ach_hn j NULL w肵ꍇASĂACBf[^ΏۂɁAw肵L[
 * vf[^݂̑鏈삵܂B<br>
 * iw肵L[ACBf[^_ŁA
 * YACBf[^̃L[̃vCIeBԂ܂Bj<br>
 * ̍ہȀ́AACBf[^̃[hƂ͋tōs܂B<br>
 * iォ烍[hꂽf[^DIɌs܂Bj<br>
 * \sa criAtomExAcb_GetCuePriorityById
 */
CriSint32 CRIAPI criAtomExAcb_GetCuePriorityByName(CriAtomExAcbHn acb_hn, const CriChar8 *name);

/*JP
 * \brief g`̎擾iL[IDwj
 * \ingroup ATOMEXLIB_ACB
 * \param[in]	acb_hn			ACBnh
 * \param[in]	id				L[ID
 * \param[out]	waveform_info	g`
 * \return		CriBool			擾ɐǂiFCRI_TRUEAsFCRI_FALSEj
 * \par :
 * L[IDw肵āÃL[ōĐ鉹g`̏擾܂B<br>
 * ̃L[ōĐ鉹g`ꍇA߂̃gbNōŏɍĐ鉹g`̏񂪎擾܂B
 * w肵L[ID̃L[݂ȂꍇACRI_FALSEԂ܂B<br>
 * \par l:
 * 1i ach_hn j NULL w肵ꍇASĂACBf[^ΏۂɁAw肵L[ID
 * vf[^݂̑鏈삵܂B<br>
 * iw肵L[IDACBf[^_ŁA
 * YACBf[^̃L[̉g`񂪕Ԃ܂Bj<br>
 * ̍ہȀ́AACBf[^̃[hƂ͋tōs܂B<br>
 * iォ烍[hꂽf[^DIɌs܂Bj<br>
 */
CriBool CRIAPI criAtomExAcb_GetWaveformInfoById(
	CriAtomExAcbHn acb_hn, CriAtomExCueId id, CriAtomExWaveformInfo *waveform_info);

/*JP
 * \brief g`̎擾iL[wj
 * \ingroup ATOMEXLIB_ACB
 * \param[in]	acb_hn			ACBnh
 * \param[in]	name			L[
 * \param[out]	waveform_info	g`
 * \return		CriBool			擾ɐǂiFCRI_TRUEAsFCRI_FALSEj
 * \par :
 * L[w肵āÃL[ōĐ鉹g`̏擾܂B<br>
 * ̃L[ōĐ鉹g`ꍇA߂̃gbNōŏɍĐ鉹g`̏񂪎擾܂B
 * w肵L[̃L[݂ȂꍇACRI_FALSEԂ܂B<br>
 * \par l:
 * 1i ach_hn j NULL w肵ꍇASĂACBf[^ΏۂɁAw肵L[
 * vf[^݂̑鏈삵܂B<br>
 * iw肵L[ACBf[^_ŁA
 * YACBf[^̃L[̉g`񂪕Ԃ܂Bj<br>
 * ̍ہȀ́AACBf[^̃[hƂ͋tōs܂B<br>
 * iォ烍[hꂽf[^DIɌs܂Bj<br>
 */
CriBool CRIAPI criAtomExAcb_GetWaveformInfoByName(
	CriAtomExAcbHn acb_hn, const CriChar8 *name, CriAtomExWaveformInfo *waveform_info);

/*JP
 * \brief IĐp AWB nh̎擾
 * \ingroup ATOMEXLIB_ACB
 * \param[in]	acb_hn			ACB nh
 * \return		CriAtomAwbHn	AWB nh
 * \par :
 * ACB f[^IĐp AWB nh擾܂B<br>
 * \par l:
 * ACB f[^ɂ́AIĐp̔g`f[^ AWB tH[}bgŊi[Ă܂B<br>
 * ACB nh쐬ہA Atom Cu̓IĐp 
 * AWB f[^ǂݍ݁AĐp̃nhi AWB nhj쐬܂B<br>
 * <br>
 * {֐gp邱ƂŁA Atom CuIɍ쐬 AWB nh
 * 擾邱Ƃ\łB<br>
 * 擾 AWB nhgp邱ƂŁA ACB nh̃Ig`f[^A
 * AvP[V ::criAtomExPlayer_SetWaveId 
 * ֐gpčĐ邱Ƃ\ɂȂ܂B<br>
 * iL[Ɋ܂܂g`f[^V[XAĐۂA
 * fobOpr ACB f[^Ɋ܂܂Ig`f[^ĐA
 * Ƃprɗp\łBj<br>
 * \attention
 * ACB nhێ AWB nh́A ACB nh[Xɔj܂B<br>
 * {֐Ŏ擾 AWB nhʂɔjA
 * 擾ς݂ AWB nh ACB nh[XɃANZX肷ƁA
 * ANZXᔽ̏dȕs\܂B<br>
 * \sa criAtomExAcb_GetStreamingAwbHandle
 */
CriAtomAwbHn CRIAPI criAtomExAcb_GetOnMemoryAwbHandle(CriAtomExAcbHn acb_hn);

/*JP
 * \brief Xg[Đp AWB nh̎擾
 * \ingroup ATOMEXLIB_ACB
 * \param[in]	acb_hn			ACB nh
 * \return		CriAtomAwbHn	AWB nh
 * \par :
 * ACB f[^Xg[Đp AWB nh擾܂B<br>
 * ȂA{֐ł̓Xbg̐擪 AWB nĥ݂擾\łB<br>
 * 擪ȊÕXbgɂ AWB nh擾ۂ͈ȉ̊֐gpĂB
 * - ::criAtomExAcb_GetStreamingAwbHandleBySlotName
 * - ::criAtomExAcb_GetStreamingAwbHandleBySlotIndex
 * \par l:
 * ACB f[^ɂ́AXg[Đp AWB t@C֘AtĂ܂B<br>
 * ACB nh쐬ہA Atom Cu̓Xg[Đp
 * AWB f[^ǂݍ݁AĐp̃nhi AWB nhj쐬܂B<br>
 * <br>
 * {֐gp邱ƂŁA Atom CuIɍ쐬 AWB nh
 * 擾邱Ƃ\łB<br>
 * 擾 AWB nhgp邱ƂŁA Xg[Đp̔g`f[^A
 * AvP[V ::criAtomExPlayer_SetWaveId 
 * ֐gpčĐ邱Ƃ\ɂȂ܂B<br>
 * iL[Ɋ܂܂g`f[^V[XAĐۂA
 * fobOpr ACB f[^Ɋ֘AtꂽXg[Đpg`f[^ĐA
 * Ƃprɗp\łBj<br>
 * \attention
 * ACB nhێ AWB nh́A ACB nh[Xɔj܂B<br>
 * {֐Ŏ擾 AWB nhʂɔjA
 * 擾ς݂ AWB nh ACB nh[XɃANZX肷ƁA
 * ANZXᔽ̏dȕs\܂B<br>
 * \sa criAtomExAcb_GetOnMemoryAwbHandle
 */
CriAtomAwbHn CRIAPI criAtomExAcb_GetStreamingAwbHandle(CriAtomExAcbHn acb_hn);

/*JP
 * \brief w肵 AWB Xbg̃Xg[Đp AWB nh̎擾
 * \ingroup ATOMEXLIB_ACB
 * \param[in]	acb_hn			ACB nh
 * \param[in]	awb_slot_name	AWB Xbg
 * \return		CriAtomAwbHn	AWB nh
 * \par :
 * ACB f[^w肵 AWB Xbg̃Xg[Đp AWB nh擾܂B
 * \par l:
 * ACB f[^ɂ́AXg[Đp AWB t@C֘AtĂ܂B<br>
 * ACB nh쐬ہA Atom Cu̓Xg[Đp
 * AWB f[^ǂݍ݁AĐp̃nhi AWB nhj쐬܂B<br>
 * <br>
 * {֐gp邱ƂŁA Atom CuIɍ쐬 AWB nh
 * 擾邱Ƃ\łB<br>
 * 擾 AWB nhgp邱ƂŁA Xg[Đp̔g`f[^A
 * AvP[V ::criAtomExPlayer_SetWaveId
 * ֐gpčĐ邱Ƃ\ɂȂ܂B<br>
 * iL[Ɋ܂܂g`f[^V[XAĐۂA
 * fobOpr ACB f[^Ɋ֘AtꂽXg[Đpg`f[^ĐA
 * Ƃprɗp\łBj<br>
 * \attention
 * ACB nhێ AWB nh́A ACB nh[Xɔj܂B<br>
 * {֐Ŏ擾 AWB nhʂɔjA
 * 擾ς݂ AWB nh ACB nh[XɃANZX肷ƁA
 * ANZXᔽ̏dȕs\܂B<br>
 * \sa criAtomExAcb_GetOnMemoryAwbHandle
 */
CriAtomAwbHn CRIAPI criAtomExAcb_GetStreamingAwbHandleBySlotName(CriAtomExAcbHn acb_hn, const CriChar8 *awb_slot_name);

/*JP
 * \brief w肵 AWB XbgCfbNX̃Xg[Đp AWB nh̎擾
 * \ingroup ATOMEXLIB_ACB
 * \param[in]	acb_hn			ACB nh
 * \param[in]	awb_slot_index	AWB XbgCfbNX
 * \return		CriAtomAwbHn	AWB nh
 * \par :
 * ACB f[^w肵 AWB XbgCfbNX̃Xg[Đp AWB nh擾܂B
 * \par l:
 * ACB f[^ɂ́AXg[Đp AWB t@C֘AtĂ܂B<br>
 * ACB nh쐬ہA Atom Cu̓Xg[Đp
 * AWB f[^ǂݍ݁AĐp̃nhi AWB nhj쐬܂B<br>
 * <br>
 * {֐gp邱ƂŁA Atom CuIɍ쐬 AWB nh
 * 擾邱Ƃ\łB<br>
 * 擾 AWB nhgp邱ƂŁA Xg[Đp̔g`f[^A
 * AvP[V ::criAtomExPlayer_SetWaveId
 * ֐gpčĐ邱Ƃ\ɂȂ܂B<br>
 * iL[Ɋ܂܂g`f[^V[XAĐۂA
 * fobOpr ACB f[^Ɋ֘AtꂽXg[Đpg`f[^ĐA
 * Ƃprɗp\łBj<br>
 * \attention
 * ACB nhێ AWB nh́A ACB nh[Xɔj܂B<br>
 * {֐Ŏ擾 AWB nhʂɔjA
 * 擾ς݂ AWB nh ACB nh[XɃANZX肷ƁA
 * ANZXᔽ̏dȕs\܂B<br>
 * \sa criAtomExAcb_GetOnMemoryAwbHandle
 */
CriAtomAwbHn CRIAPI criAtomExAcb_GetStreamingAwbHandleBySlotIndex(CriAtomExAcbHn acb_hn, CriUint16 awb_slot_index);

/*JP
 * \brief L[̎擾iL[wj
 * \ingroup ATOMEXLIB_ACB
 * \param[in]	acb_hn		ACBnh
 * \param[in]	name		L[
 * \param[out]	info		L[
 * \return		CriBool		擾ɐǂiFCRI_TRUEAsFCRI_FALSEj
 * \par :
 * L[w肵āAL[擾܂B<br>
 * w肵L[̃L[݂ȂꍇACRI_FALSEԂ܂B<br>
 * \par l:
 * 1i ach_hn j NULL w肵ꍇASĂACBf[^ΏۂɁAw肵L[
 * vf[^݂̑鏈삵܂B<br>
 * iw肵L[ACBf[^_ŁA
 * YACBf[^̃L[̏񂪕Ԃ܂Bj<br>
 * ̍ہȀ́AACBf[^̃[hƂ͋tōs܂B<br>
 * iォ烍[hꂽf[^DIɌs܂Bj<br>
 * \sa criAtomExAcb_GetCueInfoById, criAtomExAcb_GetCueInfoByIndex
 */
CriBool CRIAPI criAtomExAcb_GetCueInfoByName(CriAtomExAcbHn acb_hn, const CriChar8* name, CriAtomExCueInfo* info);

/*JP
 * \brief L[̎擾iL[IDwj
 * \ingroup ATOMEXLIB_ACB
 * \param[in]	acb_hn		ACBnh
 * \param[in]	id			L[ID
 * \param[out]	info		L[
 * \return		CriBool		擾ɐǂiFCRI_TRUEAsFCRI_FALSEj
 * \par :
 * L[IDw肵āAL[擾܂B<br>
 * w肵L[ID̃L[݂ȂꍇACRI_FALSEԂ܂B<br>
 * \par l:
 * 1i ach_hn j NULL w肵ꍇASĂACBf[^ΏۂɁAw肵L[
 * vf[^݂̑鏈삵܂B<br>
 * iw肵L[ACBf[^_ŁA
 * YACBf[^̃L[̏񂪕Ԃ܂Bj<br>
 * ̍ہȀ́AACBf[^̃[hƂ͋tōs܂B<br>
 * iォ烍[hꂽf[^DIɌs܂Bj<br>
 * \sa criAtomExAcb_GetCueInfoByName, criAtomExAcb_GetCueInfoByIndex
 */
CriBool CRIAPI criAtomExAcb_GetCueInfoById(CriAtomExAcbHn acb_hn, CriAtomExCueId id, CriAtomExCueInfo* info);

/*JP
 * \brief L[̎擾iL[CfbNXwj
 * \ingroup ATOMEXLIB_ACB
 * \param[in]	acb_hn		ACBnh
 * \param[in]	index		L[CfbNX
 * \param[out]	info		L[
 * \return		CriBool		擾ɐǂiFCRI_TRUEAsFCRI_FALSEj
 * \par :
 * L[CfbNXw肵āAL[擾܂B<br>
 * w肵L[CfbNX̃L[݂ȂꍇACRI_FALSEԂ܂B<br>
 * \par l:
 * 1i ach_hn j NULL w肵ꍇASĂACBf[^ΏۂɁAw肵L[
 * vf[^݂̑鏈삵܂B<br>
 * iw肵L[ACBf[^_ŁA
 * YACBf[^̃L[̏񂪕Ԃ܂Bj<br>
 * ̍ہȀ́AACBf[^̃[hƂ͋tōs܂B<br>
 * iォ烍[hꂽf[^DIɌs܂Bj<br>
 * \sa criAtomExAcb_GetCueInfoByName, criAtomExAcb_GetCueInfoById
 */
CriBool CRIAPI criAtomExAcb_GetCueInfoByIndex(CriAtomExAcbHn acb_hn, CriAtomExCueIndex index, CriAtomExCueInfo* info);

/*JP
 * \brief L[~bgݒ肳ĂL[̔̎擾iL[wj
 * \ingroup ATOMEXLIB_ACB
 * \param[in]	acb_hn		ACBnh
 * \param[in]	name		L[
 * \return		CriSint32	iL[~bgݒ肳ĂȂL[w肵ꍇ-1A܂j
 * \par :
 * L[w肵āAL[~bgݒ肳ĂL[̔擾܂B<br>
 * w肵L[̃L[݂ȂꍇAL[~bgݒ肳ĂȂL[w肵ꍇ-1Ԃ܂B<br>
 * \par l:
 * 1i ach_hn j NULL w肵ꍇASĂACBf[^ΏۂɁAw肵L[
 * vf[^݂̑鏈삵܂B<br>
 * iw肵L[ACBf[^_ŁA
 * YACBf[^̃L[̔Ԃ܂Bj<br>
 * ̍ہȀ́AACBf[^̃[hƂ͋tōs܂B<br>
 * iォ烍[hꂽf[^DIɌs܂Bj<br>
 * \sa criAtomExAcb_GetNumCuePlayingCountById, criAtomExAcb_GetNumCuePlayingCountByIndex
 */
CriSint32 CRIAPI criAtomExAcb_GetNumCuePlayingCountByName(CriAtomExAcbHn acb_hn, const CriChar8* name);

/*JP
 * \brief L[~bgݒ肳ĂL[̔̎擾iL[IDwj
 * \ingroup ATOMEXLIB_ACB
 * \param[in]	acb_hn		ACBnh
 * \param[in]	id			L[ID
 * \return		CriSint32	iL[~bgݒ肳ĂȂL[w肵ꍇ-1A܂j
 * \par :
 * L[IDw肵āAL[~bgݒ肳ĂL[̔擾܂B<br>
 * w肵L[ID̃L[݂ȂꍇAL[~bgݒ肳ĂȂL[w肵ꍇ-1Ԃ܂B<br>
 * \par l:
 * 1i ach_hn j NULL w肵ꍇASĂACBf[^ΏۂɁAw肵L[
 * vf[^݂̑鏈삵܂B<br>
 * iw肵L[ACBf[^_ŁA
 * YACBf[^̃L[̔Ԃ܂Bj<br>
 * ̍ہȀ́AACBf[^̃[hƂ͋tōs܂B<br>
 * iォ烍[hꂽf[^DIɌs܂Bj<br>
 * \sa criAtomExAcb_GetNumCuePlayingCountByName, criAtomExAcb_GetNumCuePlayingCountByIndex
 */
CriSint32 CRIAPI criAtomExAcb_GetNumCuePlayingCountById(CriAtomExAcbHn acb_hn, CriAtomExCueId id);

/*JP
 * \brief L[~bgݒ肳ĂL[̔̎擾iL[CfbNXwj
 * \ingroup ATOMEXLIB_ACB
 * \param[in]	acb_hn		ACBnh
 * \param[in]	index		L[CfbNX
 * \return		CriSint32	iL[~bgݒ肳ĂȂL[w肵ꍇ-1A܂j
 * \par :
 * L[w肵āAL[~bgݒ肳ĂL[̔擾܂B<br>
 * w肵L[CfbNX̃L[݂ȂꍇAL[~bgݒ肳ĂȂL[w肵ꍇ-1Ԃ܂B<br>
 * \par l:
 * 1i ach_hn j NULL w肵ꍇASĂACBf[^ΏۂɁAw肵L[
 * vf[^݂̑鏈삵܂B<br>
 * iw肵L[ACBf[^_ŁA
 * YACBf[^̃L[̔Ԃ܂Bj<br>
 * ̍ہȀ́AACBf[^̃[hƂ͋tōs܂B<br>
 * iォ烍[hꂽf[^DIɌs܂Bj<br>
 * \sa criAtomExAcb_GetNumCuePlayingCountByName, criAtomExAcb_GetNumCuePlayingCountById
 */
CriSint32 CRIAPI criAtomExAcb_GetNumCuePlayingCountByIndex(CriAtomExAcbHn acb_hn, CriAtomExCueIndex index);

/*JP
 * \brief ubNCfbNX̎擾iL[CfbNXwj
 * \ingroup ATOMEXLIB_ACB
 * \param[in]	acb_hn				ACBnh
 * \param[in]	index				L[CfbNX
 * \param[in]	block_name			ubN
 * \return		CriAtomExBlockIndex	ubNCfbNX
 * \par :
 * L[CfbNXƃubNubNCfbNX擾܂B<br>
 * w肵L[CfbNX̃L[݂ȂꍇubN݂Ȃꍇ́A
 * CRIATOMEX_INVALID_BLOCK_INDEX Ԃ܂B
 * \par l:
 * 1i ach_hn j NULL w肵ꍇASĂACBf[^ΏۂɁAw肵L[CfbNX
 * vf[^݂̑鏈삵܂B<br>
 * iw肵L[CfbNXACBf[^_ŁA
 * YACBf[^̃L[̃ubNCfbNXԂ܂Bj<br>
 * ̍ہȀ́AACBf[^̃[hƂ͋tōs܂B<br>
 * iォ烍[hꂽf[^DIɌs܂Bj<br>
 */
CriAtomExBlockIndex CRIAPI criAtomExAcb_GetBlockIndexByIndex(CriAtomExAcbHn acb_hn, CriAtomExCueIndex index, const CriChar8* block_name);

/*JP
 * \brief ubNCfbNX̎擾iL[IDwj
 * \ingroup ATOMEXLIB_ACB
 * \param[in]	acb_hn				ACBnh
 * \param[in]	id					L[ID
 * \param[in]	block_name			ubN
 * \return		CriAtomExBlockIndex	ubNCfbNX
 * \par :
 * L[IDƃubNubNCfbNX擾܂B<br>
 * w肵L[ID̃L[݂ȂꍇubN݂Ȃꍇ́A
 * CRIATOMEX_INVALID_BLOCK_INDEX Ԃ܂B
 * \par l:
 * 1i ach_hn j NULL w肵ꍇASĂACBf[^ΏۂɁAw肵L[ID
 * vf[^݂̑鏈삵܂B<br>
 * iw肵L[IDACBf[^_ŁA
 * YACBf[^̃L[̃ubNCfbNXԂ܂Bj<br>
 * ̍ہȀ́AACBf[^̃[hƂ͋tōs܂B<br>
 * iォ烍[hꂽf[^DIɌs܂Bj<br>
 */
CriAtomExBlockIndex CRIAPI criAtomExAcb_GetBlockIndexById(CriAtomExAcbHn acb_hn, CriAtomExCueId id, const CriChar8* block_name);

/*JP
 * \brief ubNCfbNX̎擾iL[wj
 * \ingroup ATOMEXLIB_ACB
 * \param[in]	acb_hn				ACBnh
 * \param[in]	name				L[
 * \param[in]	block_name			ubN
 * \return		CriAtomExBlockIndex	ubNCfbNX
 * \par :
 * L[ƃubNubNCfbNX擾܂B<br>
 * w肵L[̃L[݂ȂꍇubN݂Ȃꍇ́A
 * CRIATOMEX_INVALID_BLOCK_INDEX Ԃ܂B
 * \par l:
 * 1i ach_hn j NULL w肵ꍇASĂACBf[^ΏۂɁAw肵L[
 * vf[^݂̑鏈삵܂B<br>
 * iw肵L[ACBf[^_ŁA
 * YACBf[^̃L[̃ubNCfbNXԂ܂Bj<br>
 * ̍ہȀ́AACBf[^̃[hƂ͋tōs܂B<br>
 * iォ烍[hꂽf[^DIɌs܂Bj<br>
 */
CriAtomExBlockIndex CRIAPI criAtomExAcb_GetBlockIndexByName(CriAtomExAcbHn acb_hn, const CriChar8* name, const CriChar8* block_name);

/*JP
 * \brief CQ[vr[pf[^̃[hmR[obN֐̓o^
 * \ingroup ATOMEXLIB_ACB
 * \param[in]	func		[hmR[obN֐
 * \param[in]	obj			[UwIuWFNg
 * \par :
 * CQ[vr[pf[^̃[hmꍇɌĂяoR[obN֐o^܂B<br>
 * o^ꂽR[obN֐́AACB[h֐ACB̓e͂s^C~OŎs܂B<br>
 * \attention
 * {IɁAR[obN֐łAtomCuAPIgpȂłB<br>
 * {R[obN֐ŒԏubNƁA؂ꓙ̖肪܂̂ŁA
 * ӂB<br>
 * <br>
 * R[obN֐1o^ł܂B<br>
 * o^𕡐sꍇAɓo^ς݂̃R[obN֐A
 * ォo^R[obN֐ɂ㏑Ă܂܂B<br>
 * <br>
 * funcNULLw肷邱Ƃœo^ς݊֐̓o^s܂B<br>
 * \sa CriAtomExAcbDetectionInGamePreviewDataCbFunc
 */
void CRIAPI criAtomExAcb_SetDetectionInGamePreviewDataCallback(CriAtomExAcbDetectionInGamePreviewDataCbFunc func, void* obj);

/*JP
 * \brief ACB̎擾
 * \ingroup ATOMEXLIB_ACB
 * \param[in]	acb_hn		ACBnh
 * \param[out]	acb_info	ACB
 * \return		CriBool		񂪎擾łǂHi擾łFCRI_TRUE^擾łȂFCRI_FALSEj
 * \par :
 * ACBf[^̊e擾܂B<br>
 * \par l:
 * i acb_hn j NULL w肵ꍇAŌɃ[hACBf[^ΏۂƂ܂B<br>
 * \sa CriAtomExAcbInfo
 */
CriBool CRIAPI criAtomExAcb_GetAcbInfo(CriAtomExAcbHn acb_hn, CriAtomExAcbInfo *acb_info);

/*JP
 * \brief L[^CvXe[g̃ZbgiL[wj
 * \ingroup ATOMEXLIB_ACB
 * \param[in]	acb_hn		ACBnh
 * \param[in]	name		L[
 * \par :
 * L[w肵āAL[^CvXe[gZbg܂B<br>
 * \attention
 * ZbgΏۂ͎w肵L[̃Xe[ĝ݂łBL[Ɋ܂܂TuVZL[N
 * Xe[g̓Zbg܂B
 * \par l:
 * L[^CvXe[ǵA|tHjbN^CvL[ȊÕL[Đ̑OĐgbN
 * Xe[gƂĊǗdg݂łB<br>
 * {֐́AXe[gǗ̈ZbgACB[h̏Ԃɖ߂܂B
 * \sa criAtomExAcb_ResetCueTypeStateById, criAtomExAcb_ResetCueTypeStateByIndex
 */
void CRIAPI criAtomExAcb_ResetCueTypeStateByName(CriAtomExAcbHn acb_hn, const CriChar8* name);

/*JP
 * \brief L[^CvXe[g̃ZbgiL[IDwj
 * \ingroup ATOMEXLIB_ACB
 * \param[in]	acb_hn		ACBnh
 * \param[in]	id			L[ID
 * \par :
 * L[IDw肵āAL[^CvXe[gZbg܂B<br>
 * \attention
 * ZbgΏۂ͎w肵L[̃Xe[ĝ݂łBL[Ɋ܂܂TuVZL[N
 * Xe[g̓Zbg܂B
 * \par l:
 * L[^CvXe[ǵA|tHjbN^CvL[ȊÕL[Đ̑OĐgbN
 * Xe[gƂĊǗdg݂łB<br>
 * {֐́AXe[gǗ̈ZbgACB[h̏Ԃɖ߂܂B
 * \sa criAtomExAcb_ResetCueTypeStateByName, criAtomExAcb_ResetCueTypeStateByIndex
 */
void CRIAPI criAtomExAcb_ResetCueTypeStateById(CriAtomExAcbHn acb_hn, CriAtomExCueId id);

/*JP
 * \brief L[^CvXe[g̃ZbgiL[CfbNXwj
 * \ingroup ATOMEXLIB_ACB
 * \param[in]	acb_hn		ACBnh
 * \param[in]	index		L[CfbNX
 * \par :
 * L[CfbNXw肵āAL[^CvXe[gZbg܂B<br>
 * \attention
 * ZbgΏۂ͎w肵L[̃Xe[ĝ݂łBL[Ɋ܂܂TuVZL[N
 * Xe[g̓Zbg܂B
 * \par l:
 * L[^CvXe[ǵA|tHjbN^CvL[ȊÕL[Đ̑OĐgbN
 * Xe[gƂĊǗdg݂łB<br>
 * {֐́AXe[gǗ̈ZbgACB[h̏Ԃɖ߂܂B
 * \sa criAtomExAcb_ResetCueTypeStateByName, criAtomExAcb_ResetCueTypeStateById
 */
void CRIAPI criAtomExAcb_ResetCueTypeStateByIndex(CriAtomExAcbHn acb_hn, CriAtomExCueIndex index);

/*JP
 * \brief Xg[pAWBt@C̃A^b`
 * \ingroup ATOMEXLIB_ACB
 * \param[in]	acb_hn		ACBnh
 * \param[in]	awb_binder	AWBt@C܂ރoC_[̃nh
 * \param[in]	awb_path	AWBt@C̃pX
 * \param[in]	awb_name	AWB
 * \param[in]	work		A^b`ŕKvȒǉ[N
 * \param[in]	work_size	ǉ[NTCY
 * \par :
 * ACBnhɑ΂ăXg[pAWBt@CA^b`܂B
 * 2 awb_binder Aё3 awb_path ɂ́AXg[Đp
 * AWBt@Cw肵܂B<br>
 * 5 awb_name AWBA^b`Xbgw肷邽߂Ɏgp܂B
 * ̂߁AAtomCrafto͂AWBit@Cgq菜jύXĂꍇ
 * ̓IWiAWBw肵ĂB<br>
 * AWBt@C̃A^b`sɂ́ACuŗp邽߂̃̈
 * i[N̈jmۂKv܂B<br>
 * AWBt@C̃A^b`ɎsꍇAG[R[obN܂B<br>
 * s̗RɂẮAG[R[obÑbZ[WŊmF\łB<br>
 * \par l:
 * [N̈mۂ@ɂ́Aȉ2ʂ̕@܂B<br>
 * <b>(a) User Allocator</b>F̊mہ^ɁA[Upӂ֐gp@B<br>
 * <b>(b) Fixed Memory</b>FKvȃ̈𒼐ڃCuɓn@B<br>
 * <br>
 * User AllocatorpꍇA[U[N̈pӂKv͂܂B<br>
 * workNULLAwork_size0w肷邾ŁAKvȃo^ς݂̃mۊ֐mۂ܂B<br>
 * A^b`Ɋmۂꂽ́Af^b`i ::criAtomExAcb_DetachAwbFile 
 * ֐sjAACBnh[Xi ::criAtomExAcb_Release ֐sjɉ܂B<br>
 * <br>
 * Fixed MemorypꍇA[N̈Ƃĕʓrmۍς݂̃̈{֐
 * ݒ肷Kv܂B<br>
 * [N̈̃TCY ::criAtomExAcb_CalculateWorkSizeForAttachAwbFile ֐Ŏ擾\łB<br>
 * {֐Ăяo ::criAtomExAcb_CalculateWorkSizeForAttachAwbFile ֐Ŏ擾
 * TCỸ\ߊmۂĂA{֐ɐݒ肵ĂB<br>
 * AFixed MemorypꍇA[N̈̓f^b`i ::criAtomExAcb_DetachAwbFile 
 * ֐sjAACBnh[Xi ::criAtomExAcb_Release ֐sjs܂ł̊ԁA
 * Cuŗpꑱ܂B<br>
 * AWBt@CA^b`ƃCuIɃoC_[i CriFsBinderHn jƃ[_[i CriFsLoaderHn j
 * mۂ܂B<br>
 * ǉAWBt@CA^b`ꍇAǉ̃oC_[ƃ[_[mۂłݒ
 * AtomCui܂CRI File SystemCujKv܂B<br>
 * \par lF
 * f[^CPKɃpbNĂȂꍇAbinderɂNULLw肵ĂB<br>
 * \sa criAtomExAcb_DetachAwbFile, criAtomExAcb_Release, criAtomExAcb_CalculateWorkSizeForAttachAwbFile
*/
void CRIAPI criAtomExAcb_AttachAwbFile(
	CriAtomExAcbHn acb_hn,
	CriFsBinderHn awb_binder,
	const CriChar8* awb_path,
	const CriChar8* awb_name,
	void* work,
	CriSint32 work_size);

/*JP
 * \brief Xg[pAWBt@C̃f^b`
 * \ingroup ATOMEXLIB_ACB
 * \param[in]	acb_hn		ACBnh
 * \param[in]	awb_name	AWB
 * \par :
 * ACBnhɃA^b`ĂXg[pAWBt@Cf^b`܂B
 * 2 awb_name AWBA^b`Ɏw肵̂ƓAWBww肭B<br>
 * A^b`̃[N̈mۂUser Allocatorpꍇ́AA^b`Ɋmۂ̈悪
 * {֐ɊJ܂B<br>
 * \sa criAtomExAcb_AttachAwbFile
 */
void CRIAPI criAtomExAcb_DetachAwbFile(
	CriAtomExAcbHn acb_hn,
	const CriChar8* awb_name);

/*JP
 * \brief Xg[pAWBt@C̃A^b`ɕKvȃ[NTCY擾
 * \ingroup ATOMEXLIB_ACB
 * \param[in]	awb_binder	AWBt@C܂ރoC_[̃nh
 * \param[in]	awb_path	AWBt@C̃pX
 * \return		CriSint32	[N̈TCY
 * \retval		0ȏ		ɏ
 * \retval		-1			G[
 * \par :
 * ::criAtomExAcb_LoadAcbFileById ֐̎sɕKvȃ[N̈TCYvZ܂B<br>
 * \par lF
 * f[^CPKɃpbNĂȂꍇAbinderɂNULLw肵ĂB<br>
 * \sa criAtomExAcb_AttachAwbFile
 */
CriSint32 CRIAPI criAtomExAcb_CalculateWorkSizeForAttachAwbFile(
	CriFsBinderHn awb_binder,
	const CriChar8* awb_path);

/*JP
 * \brief Xg[pAWBXbg̎擾
 * \ingroup ATOMEXLIB_ACB
 * \param[in]	acb_hn		ACBnh
 * \return		CriSint32	Xg[AWBXbg
 * \par :
 * ACBnhKvƂXg[AWB̐擾܂B<br>
 */
CriSint32 CRIAPI criAtomExAcb_GetNumAwbFileSlots(
	CriAtomExAcbHn acb_hn);

/*JP
 * \brief Xg[pAWBXbg̎擾
 * \ingroup ATOMEXLIB_ACB
 * \param[in]	acb_hn		ACBnh
 * \param[in]	index		XbgCfbNX
 * \return		const CriChar8*	Xg[AWB|[g
 * \par :
 * CfbNXw肵ACBnh̃Xg[AWBXbg擾܂B<br>
 * 擾Xbg ::criAtomExAcb_AttachAwbFile ֐̑4A
 * ::criAtomExAcb_DetachAwbFile ֐̑2̃XbgwɎgp܂B<br>
 */
const CriChar8* CRIAPI criAtomExAcb_GetAwbFileSlotName(
	CriAtomExAcbHn acb_hn, CriUint16 index);

/*JP
 * \brief Xg[pAWBt@C̃A^b`Ԏ擾
 * \ingroup ATOMEXLIB_ACB
 * \param[in]	acb_hn		ACBnh
 * \param[in]	awb_name	AWB
 * \par :
 * ACBnhAWBt@CA^b`Ă邩擾܂B
 * 2 awb_name AWBA^b`XbgłBԂ擾XbgAWBw肵ĂB<br>
 */
CriBool CRIAPI criAtomExAcb_IsAttachedAwbFile(
	CriAtomExAcbHn acb_hn,
	const CriChar8* awb_name);


/*==========================================================================
 *      CRI AtomEx Voice Pool API
 *=========================================================================*/
/*JP
 * \brief W{CXv[쐬p[N̈TCY̌vZ
 * \ingroup ATOMEXLIB_VOICE_POOL
 * \param[in]	config		W{CXv[쐬pRtBO\
 * \return		CriSint32	[N̈TCY
 * \retval		0ȏ		ɏ
 * \retval		-1			G[
 * \par :
 * W{CXv[̍쐬ɕKvȃ[N̈̃TCYvZ܂B<br>
 * ::criAtomEx_SetUserAllocator }NɂAP[^[o^s킸
 * ::criAtomExVoicePool_AllocateStandardVoicePool ֐Ń{CXv[쐬ۂɂ́A
 * ::criAtomExVoicePool_AllocateStandardVoicePool ֐ɖ{֐ԂTCỸ[N
 * ̈ƂēnKv܂B<br>
 * <br>
 * [N̈TCY̌vZɎsƁA{֐ -1 Ԃ܂B<br>
 * [N̈TCY̌vZɎsRɂẮAG[R[obÑbZ[WŊmF\łB<br>
 * \par l:
 * {CXv[̍쐬ɕKvȃ[ÑTCÝAv[[쐬pRtBO
 * \́i ::CriAtomExStandardVoicePoolConfig j̓eɂĕω܂B<br>
 * <br>
 * NULLw肵ꍇAftHgݒ
 * i ::criAtomExVoicePool_SetDefaultConfigForStandardVoicePool }Ngp
 * Ɠp[^[jŃ[N̈TCYvZ܂B
 * <br>
 *  config ̏́A֐ł̂ݎQƂ܂B<br>
 * ֐𔲂͎QƂ܂̂ŁA֐s config ̗̈Ă
 * 肠܂B
 * \attention
 * [N̈̃TCY̓Cui ::criAtomEx_Initialize ֐sj
 * Ɏw肵p[^[ɂĕω܂B<br>
 * ̂߁A{֐sOɁACuĂKv܂B<br>
 * \sa criAtomExVoicePool_AllocateStandardVoicePool
 */
CriSint32 CRIAPI criAtomExVoicePool_CalculateWorkSizeForStandardVoicePool(
	const CriAtomExStandardVoicePoolConfig *config);

/*JP
 * \brief W{CXv[̍쐬
 * \ingroup ATOMEXLIB_VOICE_POOL
 * \param[in]	config		W{CXv[쐬pRtBO\
 * \param[in]	work		[N̈
 * \param[in]	work_size	[N̈TCY
 * \return		CriAtomExVoicePoolHn	{CXv[nh
 * \par F
 * W{CXv[쐬܂B<br>
 * iW{CX́AADXf[^HCAf[^̗̍ĐɑΉ{CXłBj<br>
 * <br>
 * {CXv[쐬ۂɂ́A[N̈ƂănKv܂B<br>
 * Kvȃ̃TCÝA ::criAtomExVoicePool_CalculateWorkSizeForStandardVoicePool 
 * ֐ŌvZ܂B<br>
 * i::criAtomEx_SetUserAllocator }NgpăAP[^[o^ς݂̏ꍇA
 * {֐Ƀ[N̈w肷Kv͂܂Bj<br>
 * <br>
 * {֐s邱ƂŁAADXHCA̍Đ\ȃ{CXv[܂B<br>
 * AtomExv[[ADXHCAf[^iADXHCAf[^܂ރL[j̍ĐsƁA
 * AtomExv[[͍쐬ꂽW{CXv[{CX擾AĐs܂B<br>
 * <br>
 * {CXv[̍쐬ɐƁA߂lƂă{CXv[nhԂ܂B<br>
 * AvP[VIɂ́A쐬{CXv[ ::criAtomExVoicePool_Free 
 * ֐ŔjKv܂B<br>
 * <br>
 * {CXv[̍쐬ɎsƁA{֐NULLԂ܂B<br>
 * {CXv[̍쐬ɎsRɂẮAG[R[obÑbZ[WŊmF\łB<br>
 * \par l:
 * {CXv[쐬ɂ́Av[쐬pRtBO\
 * i ::CriAtomExStandardVoicePoolConfig \̂ num_voices j
 * Ŏw肵̃{CXACuō쐬܂B<br>
 * 쐬{CX̐قǁAɍĐ\ȉ̐͑܂A
 * ʁAgp郁͑܂B<br>
 * <br>
 * {CXv[쐬ɂ́A{CX̑ɁAĐ\ȉ̃`lA
 * TvOgAXg[Đ̗Lw肵܂B<br>
 * <br>
 * {CXv[쐬Ɏw肷鉹`li ::CriAtomExStandardVoicePoolConfig 
 * \̂ player_config.max_channels j́A{CXv[̃{CXĐł
 * f[^̃`lɂȂ܂B<br>
 * `lȂ邱ƂŁA{CXv[̍쐬ɕKvȃTCY
 * Ȃ܂Aw肳ꂽ`lzf[^͍ĐłȂȂ܂B<br>
 * Ⴆ΁A{CXv[mō쐬ꍇAXeĨf[^͍Đł܂B<br>
 * iXeIf[^ĐꍇAAtomExv[[́AXeIĐ\
 * {CXv[̂݃{CX擾܂Bj<br>
 * AXeĨ{CXv[쐬ꍇAmf[^ĐɃXeI
 * {CXv[̃{CXgp\͂܂B<br>
 * <br>
 * TvO[gi ::CriAtomExStandardVoicePoolConfig \̂ 
 * player_config.max_sampling_rate jɂĂAl邱Ƃł{CXv[
 * ɕKvȃTCY͏邱Ƃ\łAw肳ꂽTvO[g
 * zf[^͍ĐłȂȂ܂B<br>
 * iw肳ꂽTvO[gȉ̃f[^݂̂Đ\łBj<br>
 * <br>
 * Xg[~OĐ̗Li::CriAtomExStandardVoicePoolConfig \̂ 
 * player_config.streaming_flag jɂĂAIĐ݂̂̃{CXv[
 * Xg[~OĐ\ȃ{CXv[ɔׁATCYȂ܂B<br>
 * <br>
 * AAtomExv[[f[^ĐۂɁA
 * {CXv[̃{CXSĎgpłꍇA
 * {CXvCIeBɂ锭䂪s܂B<br>
 * i{CXvCIeB̏ڍׂ ::criAtomExPlayer_SetVoicePriority 
 * ֐̐QƂBj<br>
 * \attention
 * {֐sOɁACuĂKv܂B<br>
 * <br>
 * {֐Ƀ[N̈ZbgꍇAZbg̈̃{CXv[j
 * ܂ŃAvP[VŕێKv܂B<br>
 * iZbgς݂̃[N̈ɒl񂾂A肵Ă͂܂Bj<br>
 * <br>
 *  config ̏́A֐ł̂ݎQƂ܂B<br>
 * ֐𔲂͎QƂ܂̂ŁA֐s config ̗̈Ă
 * 肠܂B
 * <br>
 * Xg[Đp̃{CXv[́AIɃ{CX̐[_[i CriFsLoaderHn j
 * mۂ܂B<br>
 * Xg[Đp̃{CXv[쐬ꍇA{CX̃[_[mۂłݒ
 * AtomCui܂CRI File SystemCujKv܂B<br>
 * <br>
 * {֐͊A^̊֐łB<br>
 * {CXv[̍쐬ɂ鎞Ԃ́AvbgtH[ɂĈقȂ܂B<br>
 * Q[[v̉ʍXVKvȃ^C~OŖ{֐sƃ~bPʂ
 * ubNAt[鋰ꂪ܂B<br>
 * {CXv[̍쐬^j́AV[̐؂ւ蓙Aוϓeł
 * ^C~Oōs悤肢܂B<br>
 * \sa CriAtomExStandardVoicePoolConfig, criAtomExVoicePool_CalculateWorkSizeForStandardVoicePool, criAtomExVoicePool_Free
 */
CriAtomExVoicePoolHn CRIAPI criAtomExVoicePool_AllocateStandardVoicePool(
	const CriAtomExStandardVoicePoolConfig *config, void *work, CriSint32 work_size);

/*JP
 * \brief ADX{CXv[쐬p[N̈TCY̌vZ
 * \ingroup ATOMEXLIB_VOICE_POOL
 * \param[in]	config		ADX{CXv[쐬pRtBO\
 * \return		CriSint32	[N̈TCY
 * \retval		0ȏ		ɏ
 * \retval		-1			G[
 * \par :
 * ADX{CXv[̍쐬ɕKvȃ[N̈̃TCYvZ܂B<br>
 * ::criAtomEx_SetUserAllocator }NɂAP[^[o^s킸
 * ::criAtomExVoicePool_AllocateAdxVoicePool ֐Ń{CXv[쐬ۂɂ́A
 * ::criAtomExVoicePool_AllocateAdxVoicePool ֐ɖ{֐ԂTCỸ[N
 * ̈ƂēnKv܂B<br>
 * <br>
 * [N̈TCY̌vZɎsƁA{֐ -1 Ԃ܂B<br>
 * [N̈TCY̌vZɎsRɂẮAG[R[obÑbZ[WŊmF\łB<br>
 * \par l:
 * {CXv[̍쐬ɕKvȃ[ÑTCÝAv[[쐬pRtBO
 * \́i ::CriAtomExAdxVoicePoolConfig j̓eɂĕω܂B<br>
 * <br>
 * NULLw肵ꍇAftHgݒ
 * i ::criAtomExVoicePool_SetDefaultConfigForAdxVoicePool }Ngp
 * p[^[jŃ[N̈TCYvZ܂B
 * <br>
 *  config ̏́A֐ł̂ݎQƂ܂B<br>
 * ֐𔲂͎QƂ܂̂ŁA֐s config ̗̈Ă
 * 肠܂B
 * \attention
 * [N̈̃TCY̓Cui ::criAtomEx_Initialize ֐sj
 * Ɏw肵p[^[ɂĕω܂B<br>
 * ̂߁A{֐sOɁACuĂKv܂B<br>
 * \sa criAtomExVoicePool_AllocateAdxVoicePool
 */
CriSint32 CRIAPI criAtomExVoicePool_CalculateWorkSizeForAdxVoicePool(
	const CriAtomExAdxVoicePoolConfig *config);

/*JP
 * \brief ADX{CXv[̍쐬
 * \ingroup ATOMEXLIB_VOICE_POOL
 * \param[in]	config		ADX{CXv[쐬pRtBO\
 * \param[in]	work		[N̈
 * \param[in]	work_size	[N̈TCY
 * \return		CriAtomExVoicePoolHn	{CXv[nh
 * \par F
 * ADX{CXv[쐬܂B<br>
 * {CXv[쐬ۂɂ́A[N̈ƂănKv܂B<br>
 * Kvȃ̃TCÝA ::criAtomExVoicePool_CalculateWorkSizeForAdxVoicePool 
 * ֐ŌvZ܂B<br>
 * i::criAtomEx_SetUserAllocator }NgpăAP[^[o^ς݂̏ꍇA
 * {֐Ƀ[N̈w肷Kv͂܂Bj<br>
 * <br>
 * {֐s邱ƂŁAADXĐ\ȃ{CXv[܂B<br>
 * AtomExv[[ADXf[^iADXf[^܂ރL[j̍ĐsƁA
 * AtomExv[[͍쐬ꂽADX{CXv[{CX擾AĐs܂B<br>
 * <br>
 * {CXv[̍쐬ɐƁA߂lƂă{CXv[nhԂ܂B<br>
 * AvP[VIɂ́A쐬{CXv[ ::criAtomExVoicePool_Free 
 * ֐ŔjKv܂B<br>
 * <br>
 * {CXv[̍쐬ɎsƁA{֐NULLԂ܂B<br>
 * {CXv[̍쐬ɎsRɂẮAG[R[obÑbZ[WŊmF\łB<br>
 * \par l:
 * {CXv[쐬ɂ́Av[쐬pRtBO\
 * i ::CriAtomExAdxVoicePoolConfig \̂ num_voices j
 * Ŏw肵̃{CXACuō쐬܂B<br>
 * 쐬{CX̐قǁAɍĐ\ADX̐͑܂A
 * ʁAgp郁͑܂B<br>
 * <br>
 * {CXv[쐬ɂ́A{CX̑ɁAĐ\ȉ̃`lA
 * TvOgAXg[Đ̗Lw肵܂B<br>
 * <br>
 * {CXv[쐬Ɏw肷鉹`li ::CriAtomExAdxVoicePoolConfig 
 * \̂ player_config.max_channels j́A{CXv[̃{CXĐł
 * f[^̃`lɂȂ܂B<br>
 * `lȂ邱ƂŁA{CXv[̍쐬ɕKvȃTCY
 * Ȃ܂Aw肳ꂽ`lzf[^͍ĐłȂȂ܂B<br>
 * Ⴆ΁A{CXv[mō쐬ꍇAXeĨf[^͍Đł܂B<br>
 * iXeIf[^ĐꍇAAtomExv[[́AXeIĐ\
 * {CXv[̂݃{CX擾܂Bj<br>
 * AXeĨ{CXv[쐬ꍇAmf[^ĐɃXeI
 * {CXv[̃{CXgp\͂܂B<br>
 * <br>
 * TvO[gi ::CriAtomExAdxVoicePoolConfig \̂ 
 * player_config.max_sampling_rate jɂĂAl邱Ƃł{CXv[
 * ɕKvȃTCY͏邱Ƃ\łAw肳ꂽTvO[g
 * zf[^͍ĐłȂȂ܂B<br>
 * iw肳ꂽTvO[gȉ̃f[^݂̂Đ\łBj<br>
 * <br>
 * Xg[~OĐ̗Li::CriAtomExAdxVoicePoolConfig \̂ 
 * player_config.streaming_flag jɂĂAIĐ݂̂̃{CXv[
 * Xg[~OĐ\ȃ{CXv[ɔׁATCYȂ܂B<br>
 * <br>
 * AAtomExv[[f[^ĐۂɁA
 * {CXv[̃{CXSĎgpłꍇA
 * {CXvCIeBɂ锭䂪s܂B<br>
 * i{CXvCIeB̏ڍׂ ::criAtomExPlayer_SetVoicePriority 
 * ֐̐QƂBj<br>
 * \attention
 * {֐sOɁACuĂKv܂B<br>
 * <br>
 *  config ̏́A֐ł̂ݎQƂ܂B<br>
 * ֐𔲂͎QƂ܂̂ŁA֐s config ̗̈Ă
 * 肠܂B
 * <br>
 * Xg[Đp̃{CXv[́AIɃ{CX̐[_[i CriFsLoaderHn j
 * mۂ܂B<br>
 * Xg[Đp̃{CXv[쐬ꍇA{CX̃[_[mۂłݒ
 * AtomCui܂CRI File SystemCujKv܂B<br>
 * <br>
 * {֐͊A^̊֐łB<br>
 * {CXv[̍쐬ɂ鎞Ԃ́AvbgtH[ɂĈقȂ܂B<br>
 * Q[[v̉ʍXVKvȃ^C~OŖ{֐sƃ~bPʂ
 * ubNAt[鋰ꂪ܂B<br>
 * {CXv[̍쐬^j́AV[̐؂ւ蓙Aוϓeł
 * ^C~Oōs悤肢܂B<br>
 * \sa CriAtomExAdxVoicePoolConfig, criAtomExVoicePool_CalculateWorkSizeForAdxVoicePool, criAtomExVoicePool_Free
 */
CriAtomExVoicePoolHn CRIAPI criAtomExVoicePool_AllocateAdxVoicePool(
	const CriAtomExAdxVoicePoolConfig *config, void *work, CriSint32 work_size);

/*JP
 * \brief HCA{CXv[쐬p[N̈TCY̌vZ
 * \ingroup ATOMEXLIB_VOICE_POOL
 * \param[in]	config		HCA{CXv[쐬pRtBO\
 * \return		CriSint32	[N̈TCY
 * \retval		0ȏ		ɏ
 * \retval		-1			G[
 * \par :
 * HCA{CXv[̍쐬ɕKvȃ[N̈̃TCYvZ܂B<br>
 * ::criAtomEx_SetUserAllocator }NɂAP[^[o^s킸
 * ::criAtomExVoicePool_AllocateHcaVoicePool ֐Ń{CXv[쐬ۂɂ́A
 * ::criAtomExVoicePool_AllocateHcaVoicePool ֐ɖ{֐ԂTCỸ[N
 * ̈ƂēnKv܂B<br>
 * <br>
 * [N̈TCY̌vZɎsƁA{֐ -1 Ԃ܂B<br>
 * [N̈TCY̌vZɎsRɂẮAG[R[obÑbZ[WŊmF\łB<br>
 * \par l:
 * {CXv[̍쐬ɕKvȃ[ÑTCÝAv[[쐬pRtBO
 * \́i ::CriAtomExHcaVoicePoolConfig j̓eɂĕω܂B<br>
 * <br>
 * NULLw肵ꍇAftHgݒ
 * i ::criAtomExVoicePool_SetDefaultConfigForHcaVoicePool }Ngp
 * p[^[jŃ[N̈TCYvZ܂B
 * <br>
 *  config ̏́A֐ł̂ݎQƂ܂B<br>
 * ֐𔲂͎QƂ܂̂ŁA֐s config ̗̈Ă
 * 肠܂B
 * \attention
 * [N̈̃TCY̓Cui ::criAtomEx_Initialize ֐sj
 * Ɏw肵p[^[ɂĕω܂B<br>
 * ̂߁A{֐sOɁACuĂKv܂B<br>
 * \sa criAtomExVoicePool_AllocateHcaVoicePool
 */
CriSint32 CRIAPI criAtomExVoicePool_CalculateWorkSizeForHcaVoicePool(
	const CriAtomExHcaVoicePoolConfig *config);

/*JP
 * \brief HCA{CXv[̍쐬
 * \ingroup ATOMEXLIB_VOICE_POOL
 * \param[in]	config		HCA{CXv[쐬pRtBO\
 * \param[in]	work		[N̈
 * \param[in]	work_size	[N̈TCY
 * \return		CriAtomExVoicePoolHn	{CXv[nh
 * \par F
 * HCA{CXv[쐬܂B<br>
 * {CXv[쐬ۂɂ́A[N̈ƂănKv܂B<br>
 * Kvȃ̃TCÝA ::criAtomExVoicePool_CalculateWorkSizeForHcaVoicePool 
 * ֐ŌvZ܂B<br>
 * i::criAtomEx_SetUserAllocator }NgpăAP[^[o^ς݂̏ꍇA
 * {֐Ƀ[N̈w肷Kv͂܂Bj<br>
 * <br>
 * {֐s邱ƂŁAHCAĐ\ȃ{CXv[܂B<br>
 * AtomExv[[HCAf[^iHCAf[^܂ރL[j̍ĐsƁA
 * AtomExv[[͍쐬ꂽHCA{CXv[{CX擾AĐs܂B<br>
 * <br>
 * {CXv[̍쐬ɐƁA߂lƂă{CXv[nhԂ܂B<br>
 * AvP[VIɂ́A쐬{CXv[ ::criAtomExVoicePool_Free 
 * ֐ŔjKv܂B<br>
 * <br>
 * {CXv[̍쐬ɎsƁA{֐NULLԂ܂B<br>
 * {CXv[̍쐬ɎsRɂẮAG[R[obÑbZ[WŊmF\łB<br>
 * \par l:
 * {CXv[쐬ɂ́Av[쐬pRtBO\
 * i ::CriAtomExHcaVoicePoolConfig \̂ num_voices j
 * Ŏw肵̃{CXACuō쐬܂B<br>
 * 쐬{CX̐قǁAɍĐ\HCA̐͑܂A
 * ʁAgp郁͑܂B<br>
 * <br>
 * {CXv[쐬ɂ́A{CX̑ɁAĐ\ȉ̃`lA
 * TvOgAXg[Đ̗Lw肵܂B<br>
 * <br>
 * {CXv[쐬Ɏw肷鉹`li ::CriAtomExHcaVoicePoolConfig 
 * \̂ player_config.max_channels j́A{CXv[̃{CXĐł
 * f[^̃`lɂȂ܂B<br>
 * `lȂ邱ƂŁA{CXv[̍쐬ɕKvȃTCY
 * Ȃ܂Aw肳ꂽ`lzHCAf[^͍ĐłȂȂ܂B<br>
 * Ⴆ΁A{CXv[mō쐬ꍇAXeIHCAf[^͍Đł܂B<br>
 * iXeIHCAf[^ĐꍇAAtomExv[[́AXeIHCAĐ\
 * {CXv[̂݃{CX擾܂Bj<br>
 * AXeĨ{CXv[쐬ꍇAmf[^ĐɃXeI
 * {CXv[̃{CXgp\͂܂B<br>
 * <br>
 * TvO[gi ::CriAtomExHcaVoicePoolConfig \̂ 
 * player_config.max_sampling_rate jɂĂAl邱Ƃł{CXv[
 * ɕKvȃTCY͏邱Ƃ\łAw肳ꂽTvO[g
 * zHCAf[^͍ĐłȂȂ܂B<br>
 * iw肳ꂽTvO[gȉHCAf[^݂̂Đ\łBj<br>
 * <br>
 * Xg[~OĐ̗Li::CriAtomExHcaVoicePoolConfig \̂ 
 * player_config.streaming_flag jɂĂAIĐ݂̂̃{CXv[
 * Xg[~OĐ\ȃ{CXv[ɔׁATCYȂ܂B<br>
 * <br>
 * AAtomExv[[f[^ĐۂɁA
 * {CXv[̃{CXSĎgpłꍇA
 * {CXvCIeBɂ锭䂪s܂B<br>
 * i{CXvCIeB̏ڍׂ ::criAtomExPlayer_SetVoicePriority 
 * ֐̐QƂBj<br>
 * \attention
 * {֐sOɁACuĂKv܂B<br>
 * <br>
 * {֐Ƀ[N̈ZbgꍇAZbg̈̃{CXv[j
 * ܂ŃAvP[VŕێKv܂B<br>
 * iZbgς݂̃[N̈ɒl񂾂A肵Ă͂܂Bj<br>
 * <br>
 *  config ̏́A֐ł̂ݎQƂ܂B<br>
 * ֐𔲂͎QƂ܂̂ŁA֐s config ̗̈Ă
 * 肠܂B
 * <br>
 * {֐͊A^̊֐łB<br>
 * {CXv[̍쐬ɂ鎞Ԃ́AvbgtH[ɂĈقȂ܂B<br>
 * Q[[v̉ʍXVKvȃ^C~OŖ{֐sƃ~bPʂ
 * ubNAt[鋰ꂪ܂B<br>
 * {CXv[̍쐬^j́AV[̐؂ւ蓙Aוϓeł
 * ^C~Oōs悤肢܂B<br>
 * \sa CriAtomExHcaVoicePoolConfig, criAtomExVoicePool_CalculateWorkSizeForHcaVoicePool, criAtomExVoicePool_Free
 */
CriAtomExVoicePoolHn CRIAPI criAtomExVoicePool_AllocateHcaVoicePool(
	const CriAtomExHcaVoicePoolConfig *config, void *work, CriSint32 work_size);

/*JP
 * \brief HCA-MX{CXv[쐬p[N̈TCY̌vZ
 * \ingroup ATOMEXLIB_VOICE_POOL
 * \param[in]	config		HCA-MX{CXv[쐬pRtBO\
 * \return		CriSint32	[N̈TCY
 * \retval		0ȏ		ɏ
 * \retval		-1			G[
 * \par :
 * HCA-MX{CXv[̍쐬ɕKvȃ[N̈̃TCYvZ܂B<br>
 * ::criAtomEx_SetUserAllocator }NɂAP[^[o^s킸
 * ::criAtomExVoicePool_AllocateHcaMxVoicePool ֐Ń{CXv[쐬ۂɂ́A
 * ::criAtomExVoicePool_AllocateHcaMxVoicePool ֐ɖ{֐ԂTCỸ[N
 * ̈ƂēnKv܂B<br>
 * <br>
 * [N̈TCY̌vZɎsƁA{֐ -1 Ԃ܂B<br>
 * [N̈TCY̌vZɎsRɂẮAG[R[obÑbZ[WŊmF\łB<br>
 * \par l:
 * {CXv[̍쐬ɕKvȃ[ÑTCÝAv[[쐬pRtBO
 * \́i ::CriAtomExHcaMxVoicePoolConfig j̓eɂĕω܂B<br>
 * <br>
 * NULLw肵ꍇAftHgݒ
 * i ::criAtomExVoicePool_SetDefaultConfigForHcaMxVoicePool }Ngp
 * p[^[jŃ[N̈TCYvZ܂B
 * <br>
 *  config ̏́A֐ł̂ݎQƂ܂B<br>
 * ֐𔲂͎QƂ܂̂ŁA֐s config ̗̈Ă
 * 肠܂B
 * \attention
 * [N̈̃TCYHCA-MXi ::criAtomExHcaMx_Initialize ֐sj
 * Ɏw肵p[^[ɂĕω܂B<br>
 * ̂߁A{֐sOɁAHCA-MXĂKv܂B<br>
 * \sa criAtomExVoicePool_AllocateHcaMxVoicePool
 */
CriSint32 CRIAPI criAtomExVoicePool_CalculateWorkSizeForHcaMxVoicePool(
	const CriAtomExHcaMxVoicePoolConfig *config);

/*JP
 * \brief HCA-MX{CXv[̍쐬
 * \ingroup ATOMEXLIB_VOICE_POOL
 * \param[in]	config		HCA-MX{CXv[쐬pRtBO\
 * \param[in]	work		[N̈
 * \param[in]	work_size	[N̈TCY
 * \return		CriAtomExVoicePoolHn	{CXv[nh
 * \par F
 * HCA-MX{CXv[쐬܂B<br>
 * {CXv[쐬ۂɂ́A[N̈ƂănKv܂B<br>
 * Kvȃ̃TCÝA ::criAtomExVoicePool_CalculateWorkSizeForHcaMxVoicePool 
 * ֐ŌvZ܂B<br>
 * i::criAtomEx_SetUserAllocator }NgpăAP[^[o^ς݂̏ꍇA
 * {֐Ƀ[N̈w肷Kv͂܂Bj<br>
 * <br>
 * {֐s邱ƂŁAHCA-MXĐ\ȃ{CXv[܂B<br>
 * AtomExv[[HCA-MXf[^iHCA-MXf[^܂ރL[j̍ĐsƁA
 * AtomExv[[͍쐬ꂽHCA-MX{CXv[{CX擾AĐs܂B<br>
 * <br>
 * {CXv[̍쐬ɐƁA߂lƂă{CXv[nhԂ܂B<br>
 * AvP[VIɂ́A쐬{CXv[ ::criAtomExVoicePool_Free 
 * ֐ŔjKv܂B<br>
 * <br>
 * {CXv[̍쐬ɎsƁA{֐NULLԂ܂B<br>
 * {CXv[̍쐬ɎsRɂẮAG[R[obÑbZ[WŊmF\łB<br>
 * \par l:
 * {CXv[쐬ɂ́Av[쐬pRtBO\
 * i ::CriAtomExHcaMxVoicePoolConfig \̂ num_voices j
 * Ŏw肵̃{CXACuō쐬܂B<br>
 * 쐬{CX̐قǁAɍĐ\HCA-MX̐͑܂A
 * ʁAgp郁͑܂B<br>
 * <br>
 * {CXv[쐬ɂ́A{CX̑ɁAĐ\ȉ̃`lA
 * TvOgAXg[Đ̗Lw肵܂B<br>
 * <br>
 * {CXv[쐬Ɏw肷鉹`li ::CriAtomExHcaMxVoicePoolConfig 
 * \̂ player_config.max_channels j́A{CXv[̃{CXĐł
 * f[^̃`lɂȂ܂B<br>
 * `lȂ邱ƂŁA{CXv[̍쐬ɕKvȃTCY
 * Ȃ܂Aw肳ꂽ`lzHCA-MXf[^͍ĐłȂȂ܂B<br>
 * Ⴆ΁A{CXv[mō쐬ꍇAXeIHCA-MXf[^͍Đł܂B<br>
 * iXeIHCA-MXf[^ĐꍇAAtomExv[[́AXeIHCA-MXĐ\
 * {CXv[̂݃{CX擾܂Bj<br>
 * AXeĨ{CXv[쐬ꍇAmf[^ĐɃXeI
 * {CXv[̃{CXgp\͂܂B<br>
 * <br>
 * TvO[gi ::CriAtomExHcaMxVoicePoolConfig \̂ 
 * player_config.max_sampling_rate jɂĂAl邱Ƃł{CXv[
 * ɕKvȃTCY͏邱Ƃ\łAw肳ꂽTvO[g
 * ȊOHCA-MXf[^͍ĐłȂȂ܂B<br>
 * ĩ{CXv[ƈقȂATvO[g̃f[^݂̂Đ\łBj<br>
 * <br>
 * Xg[~OĐ̗Li::CriAtomExHcaMxVoicePoolConfig \̂ 
 * player_config.streaming_flag jɂĂAIĐ݂̂̃{CXv[
 * Xg[~OĐ\ȃ{CXv[ɔׁATCYȂ܂B<br>
 * <br>
 * AAtomExv[[f[^ĐۂɁA
 * {CXv[̃{CXSĎgpłꍇA
 * {CXvCIeBɂ锭䂪s܂B<br>
 * i{CXvCIeB̏ڍׂ ::criAtomExPlayer_SetVoicePriority 
 * ֐̐QƂBj<br>
 * \attention
 * {֐sOɁAKHCA-MX̏i ::criAtomExHcaMx_Initialize ֐j
 * sĂKv܂B<br>
 * ܂A ::criAtomExHcaMx_Initialize ֐sɎw肵ȏHCA-MXf[^͍Đł܂B<br>
 * HCA-MX{CXv[쐬ۂɂ́A ::CriAtomExHcaMxVoicePoolConfig \̂ num_voices 
 * ̒lAHCA-MXɎw肷 ::CriAtomExHcaMxConfig \̂ max_voices ̐𒴂Ȃ悤A
 * ӂB<br>
 * <br>
 * {֐Ƀ[N̈ZbgꍇAZbg̈̃{CXv[j
 * ܂ŃAvP[VŕێKv܂B<br>
 * iZbgς݂̃[N̈ɒl񂾂A肵Ă͂܂Bj<br>
 * <br>
 *  config ̏́A֐ł̂ݎQƂ܂B<br>
 * ֐𔲂͎QƂ܂̂ŁA֐s config ̗̈Ă
 * 肠܂B
 * <br>
 * {֐͊A^̊֐łB<br>
 * {CXv[̍쐬ɂ鎞Ԃ́AvbgtH[ɂĈقȂ܂B<br>
 * Q[[v̉ʍXVKvȃ^C~OŖ{֐sƃ~bPʂ
 * ubNAt[鋰ꂪ܂B<br>
 * {CXv[̍쐬^j́AV[̐؂ւ蓙Aוϓeł
 * ^C~Oōs悤肢܂B<br>
 * \sa CriAtomExHcaMxVoicePoolConfig, criAtomExVoicePool_CalculateWorkSizeForHcaMxVoicePool, criAtomExVoicePool_Free
 */
CriAtomExVoicePoolHn CRIAPI criAtomExVoicePool_AllocateHcaMxVoicePool(
	const CriAtomExHcaMxVoicePoolConfig *config, void *work, CriSint32 work_size);

/*JP
 * \brief Wave{CXv[쐬p[N̈TCY̌vZ
 * \ingroup ATOMEXLIB_VOICE_POOL
 * \param[in]	config		Wave{CXv[쐬pRtBO\
 * \return		CriSint32	[N̈TCY
 * \retval		0ȏ		ɏ
 * \retval		-1			G[
 * \par :
 * Wave{CXv[̍쐬ɕKvȃ[N̈̃TCYvZ܂B<br>
 * ::criAtomEx_SetUserAllocator }NɂAP[^[o^s킸
 * ::criAtomExVoicePool_AllocateWaveVoicePool ֐Ń{CXv[쐬ۂɂ́A
 * ::criAtomExVoicePool_AllocateWaveVoicePool ֐ɖ{֐ԂTCỸ[N
 * ̈ƂēnKv܂B<br>
 * <br>
 * [N̈TCY̌vZɎsƁA{֐ -1 Ԃ܂B<br>
 * [N̈TCY̌vZɎsRɂẮAG[R[obÑbZ[WŊmF\łB<br>
 * \par l:
 * {CXv[̍쐬ɕKvȃ[ÑTCÝAv[[쐬pRtBO
 * \́i ::CriAtomExWaveVoicePoolConfig j̓eɂĕω܂B<br>
 * <br>
 * NULLw肵ꍇAftHgݒ
 * i ::criAtomExVoicePool_SetDefaultConfigForWaveVoicePool }Ngp
 * p[^[jŃ[N̈TCYvZ܂B
 * <br>
 *  config ̏́A֐ł̂ݎQƂ܂B<br>
 * ֐𔲂͎QƂ܂̂ŁA֐s config ̗̈Ă
 * 肠܂B
 * \attention
 * [N̈̃TCY̓Cui ::criAtomEx_Initialize ֐sj
 * Ɏw肵p[^[ɂĕω܂B<br>
 * ̂߁A{֐sOɁACuĂKv܂B<br>
 * \sa criAtomExVoicePool_AllocateWaveVoicePool
 */
CriSint32 CRIAPI criAtomExVoicePool_CalculateWorkSizeForWaveVoicePool(
	const CriAtomExWaveVoicePoolConfig *config);

/*JP
 * \brief Wave{CXv[̍쐬
 * \ingroup ATOMEXLIB_VOICE_POOL
 * \param[in]	config		Wave{CXv[쐬pRtBO\
 * \param[in]	work		[N̈
 * \param[in]	work_size	[N̈TCY
 * \return		CriAtomExVoicePoolHn	{CXv[nh
 * \par F
 * Wave{CXv[쐬܂B<br>
 * {CXv[쐬ۂɂ́A[N̈ƂănKv܂B<br>
 * Kvȃ̃TCÝA ::criAtomExVoicePool_CalculateWorkSizeForWaveVoicePool 
 * ֐ŌvZ܂B<br>
 * i::criAtomEx_SetUserAllocator }NgpăAP[^[o^ς݂̏ꍇA
 * {֐Ƀ[N̈w肷Kv͂܂Bj<br>
 * <br>
 * {֐s邱ƂŁAWaveĐ\ȃ{CXv[܂B<br>
 * AtomExv[[Wavef[^iWavef[^܂ރL[j̍ĐsƁA
 * AtomExv[[͍쐬ꂽWave{CXv[{CX擾AĐs܂B<br>
 * <br>
 * {CXv[̍쐬ɐƁA߂lƂă{CXv[nhԂ܂B<br>
 * AvP[VIɂ́A쐬{CXv[ ::criAtomExVoicePool_Free 
 * ֐ŔjKv܂B<br>
 * <br>
 * {CXv[̍쐬ɎsƁA{֐NULLԂ܂B<br>
 * {CXv[̍쐬ɎsRɂẮAG[R[obÑbZ[WŊmF\łB<br>
 * \par l:
 * {CXv[쐬ɂ́Av[쐬pRtBO\
 * i ::CriAtomExWaveVoicePoolConfig \̂ num_voices j
 * Ŏw肵̃{CXACuō쐬܂B<br>
 * 쐬{CX̐قǁAɍĐ\Wave̐͑܂A
 * ʁAgp郁͑܂B<br>
 * <br>
 * {CXv[쐬ɂ́A{CX̑ɁAĐ\ȉ̃`lA
 * TvOgAXg[Đ̗Lw肵܂B<br>
 * <br>
 * {CXv[쐬Ɏw肷鉹`li ::CriAtomExWaveVoicePoolConfig 
 * \̂ player_config.max_channels j́A{CXv[̃{CXĐł
 * f[^̃`lɂȂ܂B<br>
 * `lȂ邱ƂŁA{CXv[̍쐬ɕKvȃTCY
 * Ȃ܂Aw肳ꂽ`lzWavef[^͍ĐłȂȂ܂B<br>
 * Ⴆ΁A{CXv[mō쐬ꍇAXeIWavef[^͍Đł܂B<br>
 * iXeIWavef[^ĐꍇAAtomExv[[́AXeIWaveĐ\
 * {CXv[̂݃{CX擾܂Bj<br>
 * AXeĨ{CXv[쐬ꍇAmf[^ĐɃXeI
 * {CXv[̃{CXgp\͂܂B<br>
 * <br>
 * TvO[gi ::CriAtomExWaveVoicePoolConfig \̂ 
 * player_config.max_sampling_rate jɂĂAl邱Ƃł{CXv[
 * ɕKvȃTCY͏邱Ƃ\łAw肳ꂽTvO[g
 * zWavef[^͍ĐłȂȂ܂B<br>
 * iw肳ꂽTvO[gȉWavef[^݂̂Đ\łBj<br>
 * <br>
 * Xg[~OĐ̗Li::CriAtomExWaveVoicePoolConfig \̂ 
 * player_config.streaming_flag jɂĂAIĐ݂̂̃{CXv[
 * Xg[~OĐ\ȃ{CXv[ɔׁATCYȂ܂B<br>
 * <br>
 * AAtomExv[[f[^ĐۂɁA
 * {CXv[̃{CXSĎgpłꍇA
 * {CXvCIeBɂ锭䂪s܂B<br>
 * i{CXvCIeB̏ڍׂ ::criAtomExPlayer_SetVoicePriority 
 * ֐̐QƂBj<br>
 * \attention
 * {֐sOɁACuĂKv܂B<br>
 * <br>
 * {֐Ƀ[N̈ZbgꍇAZbg̈̃{CXv[j
 * ܂ŃAvP[VŕێKv܂B<br>
 * iZbgς݂̃[N̈ɒl񂾂A肵Ă͂܂Bj<br>
 * <br>
 *  config ̏́A֐ł̂ݎQƂ܂B<br>
 * ֐𔲂͎QƂ܂̂ŁA֐s config ̗̈Ă
 * 肠܂B
 * <br>
 * Xg[Đp̃{CXv[́AIɃ{CX̐[_[i CriFsLoaderHn j
 * mۂ܂B<br>
 * Xg[Đp̃{CXv[쐬ꍇA{CX̃[_[mۂłݒ
 * AtomCui܂CRI File SystemCujKv܂B<br>
 * <br>
 * {֐͊A^̊֐łB<br>
 * {CXv[̍쐬ɂ鎞Ԃ́AvbgtH[ɂĈقȂ܂B<br>
 * Q[[v̉ʍXVKvȃ^C~OŖ{֐sƃ~bPʂ
 * ubNAt[鋰ꂪ܂B<br>
 * {CXv[̍쐬^j́AV[̐؂ւ蓙Aוϓeł
 * ^C~Oōs悤肢܂B<br>
 * <br>
 * Đ\ȃtH[}bǵA32bitȉ̔񈳏kPCMf[^݂̂łB<br>
 * [vĐsꍇAXg[Đp̉f[^ɂẮA
 * smpl`Ndata`NOɔzuĂKv܂B
 * \sa CriAtomExWaveVoicePoolConfig, criAtomExVoicePool_CalculateWorkSizeForWaveVoicePool, criAtomExVoicePool_Free
 */
CriAtomExVoicePoolHn CRIAPI criAtomExVoicePool_AllocateWaveVoicePool(
	const CriAtomExWaveVoicePoolConfig *config, void *work, CriSint32 work_size);

/*JP
 * \brief AIFF{CXv[쐬p[N̈TCY̌vZ
 * \ingroup ATOMEXLIB_VOICE_POOL
 * \param[in]	config		AIFF{CXv[쐬pRtBO\
 * \return		CriSint32	[N̈TCY
 * \retval		0ȏ		ɏ
 * \retval		-1			G[
 * \par :
 * AIFF{CXv[̍쐬ɕKvȃ[N̈̃TCYvZ܂B<br>
 * ::criAtomEx_SetUserAllocator }NɂAP[^[o^s킸
 * ::criAtomExVoicePool_AllocateAiffVoicePool ֐Ń{CXv[쐬ۂɂ́A
 * ::criAtomExVoicePool_AllocateAiffVoicePool ֐ɖ{֐ԂTCỸ[N
 * ̈ƂēnKv܂B<br>
 * <br>
 * [N̈TCY̌vZɎsƁA{֐ -1 Ԃ܂B<br>
 * [N̈TCY̌vZɎsRɂẮAG[R[obÑbZ[WŊmF\łB<br>
 * \par l:
 * {CXv[̍쐬ɕKvȃ[ÑTCÝAv[[쐬pRtBO
 * \́i ::CriAtomExAiffVoicePoolConfig j̓eɂĕω܂B<br>
 * <br>
 * NULLw肵ꍇAftHgݒ
 * i ::criAtomExVoicePool_SetDefaultConfigForAiffVoicePool }Ngp
 * p[^[jŃ[N̈TCYvZ܂B
 * <br>
 *  config ̏́A֐ł̂ݎQƂ܂B<br>
 * ֐𔲂͎QƂ܂̂ŁA֐s config ̗̈Ă
 * 肠܂B
 * \attention
 * [N̈̃TCY̓Cui ::criAtomEx_Initialize ֐sj
 * Ɏw肵p[^[ɂĕω܂B<br>
 * ̂߁A{֐sOɁACuĂKv܂B<br>
 * \sa criAtomExVoicePool_AllocateAiffVoicePool
 */
CriSint32 CRIAPI criAtomExVoicePool_CalculateWorkSizeForAiffVoicePool(
	const CriAtomExAiffVoicePoolConfig *config);

/*JP
 * \brief AIFF{CXv[̍쐬
 * \ingroup ATOMEXLIB_VOICE_POOL
 * \param[in]	config		AIFF{CXv[쐬pRtBO\
 * \param[in]	work		[N̈
 * \param[in]	work_size	[N̈TCY
 * \return		CriAtomExVoicePoolHn	{CXv[nh
 * \par F
 * AIFF{CXv[쐬܂B<br>
 * {CXv[쐬ۂɂ́A[N̈ƂănKv܂B<br>
 * Kvȃ̃TCÝA ::criAtomExVoicePool_CalculateWorkSizeForAiffVoicePool 
 * ֐ŌvZ܂B<br>
 * i::criAtomEx_SetUserAllocator }NgpăAP[^[o^ς݂̏ꍇA
 * {֐Ƀ[N̈w肷Kv͂܂Bj<br>
 * <br>
 * {֐s邱ƂŁAAIFFĐ\ȃ{CXv[܂B<br>
 * AtomExv[[AIFFf[^iAIFFf[^܂ރL[j̍ĐsƁA
 * AtomExv[[͍쐬ꂽAIFF{CXv[{CX擾AĐs܂B<br>
 * <br>
 * {CXv[̍쐬ɐƁA߂lƂă{CXv[nhԂ܂B<br>
 * AvP[VIɂ́A쐬{CXv[ ::criAtomExVoicePool_Free 
 * ֐ŔjKv܂B<br>
 * <br>
 * {CXv[̍쐬ɎsƁA{֐NULLԂ܂B<br>
 * {CXv[̍쐬ɎsRɂẮAG[R[obÑbZ[WŊmF\łB<br>
 * \par l:
 * {CXv[쐬ɂ́Av[쐬pRtBO\
 * i ::CriAtomExAiffVoicePoolConfig \̂ num_voices j
 * Ŏw肵̃{CXACuō쐬܂B<br>
 * 쐬{CX̐قǁAɍĐ\AIFF̐͑܂A
 * ʁAgp郁͑܂B<br>
 * <br>
 * {CXv[쐬ɂ́A{CX̑ɁAĐ\ȉ̃`lA
 * TvOgAXg[Đ̗Lw肵܂B<br>
 * <br>
 * {CXv[쐬Ɏw肷鉹`li ::CriAtomExAiffVoicePoolConfig 
 * \̂ player_config.max_channels j́A{CXv[̃{CXĐł
 * f[^̃`lɂȂ܂B<br>
 * `lȂ邱ƂŁA{CXv[̍쐬ɕKvȃTCY
 * Ȃ܂Aw肳ꂽ`lzAIFFf[^͍ĐłȂȂ܂B<br>
 * Ⴆ΁A{CXv[mō쐬ꍇAXeIAIFFf[^͍Đł܂B<br>
 * iXeIAIFFf[^ĐꍇAAtomExv[[́AXeIAIFFĐ\
 * {CXv[̂݃{CX擾܂Bj<br>
 * AXeĨ{CXv[쐬ꍇAmf[^ĐɃXeI
 * {CXv[̃{CXgp\͂܂B<br>
 * <br>
 * TvO[gi ::CriAtomExAiffVoicePoolConfig \̂ 
 * player_config.max_sampling_rate jɂĂAl邱Ƃł{CXv[
 * ɕKvȃTCY͏邱Ƃ\łAw肳ꂽTvO[g
 * zAIFFf[^͍ĐłȂȂ܂B<br>
 * iw肳ꂽTvO[gȉAIFFf[^݂̂Đ\łBj<br>
 * <br>
 * Xg[~OĐ̗Li::CriAtomExAiffVoicePoolConfig \̂ 
 * player_config.streaming_flag jɂĂAIĐ݂̂̃{CXv[
 * Xg[~OĐ\ȃ{CXv[ɔׁATCYȂ܂B<br>
 * <br>
 * AAtomExv[[f[^ĐۂɁA
 * {CXv[̃{CXSĎgpłꍇA
 * {CXvCIeBɂ锭䂪s܂B<br>
 * i{CXvCIeB̏ڍׂ ::criAtomExPlayer_SetVoicePriority 
 * ֐̐QƂBj<br>
 * \attention
 * {֐sOɁACuĂKv܂B<br>
 * <br>
 * {֐Ƀ[N̈ZbgꍇAZbg̈̃{CXv[j
 * ܂ŃAvP[VŕێKv܂B<br>
 * iZbgς݂̃[N̈ɒl񂾂A肵Ă͂܂Bj<br>
 * <br>
 *  config ̏́A֐ł̂ݎQƂ܂B<br>
 * ֐𔲂͎QƂ܂̂ŁA֐s config ̗̈Ă
 * 肠܂B
 * <br>
 * {֐͊A^̊֐łB<br>
 * {CXv[̍쐬ɂ鎞Ԃ́AvbgtH[ɂĈقȂ܂B<br>
 * Q[[v̉ʍXVKvȃ^C~OŖ{֐sƃ~bPʂ
 * ubNAt[鋰ꂪ܂B<br>
 * {CXv[̍쐬^j́AV[̐؂ւ蓙Aוϓeł
 * ^C~Oōs悤肢܂B<br>
 * <br>
 * Đ\ȃtH[}bǵA32bitȉ̔񈳏kPCMf[^݂̂łB<br>
 * [vĐsꍇAXg[Đp̉f[^ɂẮA
 * INST`NSSND`NOɔzuĂKv܂B
 * \sa CriAtomExAiffVoicePoolConfig, criAtomExVoicePool_CalculateWorkSizeForAiffVoicePool, criAtomExVoicePool_Free
 */
CriAtomExVoicePoolHn CRIAPI criAtomExVoicePool_AllocateAiffVoicePool(
	const CriAtomExAiffVoicePoolConfig *config, void *work, CriSint32 work_size);

/*JP
 * \brief RawPCM{CXv[쐬p[N̈TCY̌vZ
 * \ingroup ATOMEXLIB_VOICE_POOL
 * \param[in]	config		RawPCM{CXv[쐬pRtBO\
 * \return		CriSint32	[N̈TCY
 * \retval		0ȏ		ɏ
 * \retval		-1			G[
 * \par :
 * RawPCM{CXv[̍쐬ɕKvȃ[N̈̃TCYvZ܂B<br>
 * ::criAtomEx_SetUserAllocator }NɂAP[^[o^s킸
 * ::criAtomExVoicePool_AllocateRawPcmVoicePool ֐Ń{CXv[쐬ۂɂ́A
 * ::criAtomExVoicePool_AllocateRawPcmVoicePool ֐ɖ{֐ԂTCỸ[N
 * ̈ƂēnKv܂B<br>
 * <br>
 * [N̈TCY̌vZɎsƁA{֐ -1 Ԃ܂B<br>
 * [N̈TCY̌vZɎsRɂẮAG[R[obÑbZ[WŊmF\łB<br>
 * \par l:
 * {CXv[̍쐬ɕKvȃ[ÑTCÝAv[[쐬pRtBO
 * \́i ::CriAtomExRawPcmVoicePoolConfig j̓eɂĕω܂B<br>
 * <br>
 * NULLw肵ꍇAftHgݒ
 * i ::criAtomExVoicePool_SetDefaultConfigForRawPcmVoicePool }Ngp
 * p[^[jŃ[N̈TCYvZ܂B
 * <br>
 *  config ̏́A֐ł̂ݎQƂ܂B<br>
 * ֐𔲂͎QƂ܂̂ŁA֐s config ̗̈Ă
 * 肠܂B
 * \attention
 * [N̈̃TCY̓Cui ::criAtomEx_Initialize ֐sj
 * Ɏw肵p[^[ɂĕω܂B<br>
 * ̂߁A{֐sOɁACuĂKv܂B<br>
 * \sa criAtomExVoicePool_AllocateRawPcmVoicePool
 */
CriSint32 CRIAPI criAtomExVoicePool_CalculateWorkSizeForRawPcmVoicePool(
	const CriAtomExRawPcmVoicePoolConfig *config);

/*JP
 * \brief RawPCM{CXv[̍쐬
 * \ingroup ATOMEXLIB_VOICE_POOL
 * \param[in]	config		RawPCM{CXv[쐬pRtBO\
 * \param[in]	work		[N̈
 * \param[in]	work_size	[N̈TCY
 * \return		CriAtomExVoicePoolHn	{CXv[nh
 * \par F
 * RawPCM{CXv[쐬܂B<br>
 * {CXv[쐬ۂɂ́A[N̈ƂănKv܂B<br>
 * Kvȃ̃TCÝA ::criAtomExVoicePool_CalculateWorkSizeForRawPcmVoicePool 
 * ֐ŌvZ܂B<br>
 * i::criAtomEx_SetUserAllocator }NgpăAP[^[o^ς݂̏ꍇA
 * {֐Ƀ[N̈w肷Kv͂܂Bj<br>
 * <br>
 * {֐s邱ƂŁARawPCMĐ\ȃ{CXv[܂B<br>
 * AtomExv[[RawPCMf[^iRawPCMf[^܂ރL[j̍ĐsƁA
 * AtomExv[[͍쐬ꂽRawPCM{CXv[{CX擾AĐs܂B<br>
 * <br>
 * {CXv[̍쐬ɐƁA߂lƂă{CXv[nhԂ܂B<br>
 * AvP[VIɂ́A쐬{CXv[ ::criAtomExVoicePool_Free 
 * ֐ŔjKv܂B<br>
 * <br>
 * {CXv[̍쐬ɎsƁA{֐NULLԂ܂B<br>
 * {CXv[̍쐬ɎsRɂẮAG[R[obÑbZ[WŊmF\łB<br>
 * \par l:
 * {CXv[쐬ɂ́Av[쐬pRtBO\
 * i ::CriAtomExRawPcmVoicePoolConfig \̂ num_voices j
 * Ŏw肵̃{CXACuō쐬܂B<br>
 * 쐬{CX̐قǁAɍĐ\RawPCM̐͑܂A
 * ʁAgp郁͑܂B<br>
 * <br>
 * {CXv[쐬ɂ́A{CX̑ɁAĐ\ȉ̃`lA
 * TvOgAXg[Đ̗Lw肵܂B<br>
 * <br>
 * {CXv[쐬Ɏw肷鉹`li ::CriAtomExRawPcmVoicePoolConfig 
 * \̂ player_config.max_channels j́AۂɋRawPCM̃tH[}bg
 * `lw肵܂B<br>
 * <br>
 * TvO[gi ::CriAtomExRawPcmVoicePoolConfig \̂ 
 * player_config.max_sampling_rate jɂĂAۂɋRawPCM
 * tH[}bg̃TvO[gw肵܂B<br>
 * <br>
 * AAtomExv[[f[^ĐۂɁA
 * {CXv[̃{CXSĎgpłꍇA
 * {CXvCIeBɂ锭䂪s܂B<br>
 * i{CXvCIeB̏ڍׂ ::criAtomExPlayer_SetVoicePriority 
 * ֐̐QƂBj<br>
 * \attention
 * {֐sOɁACuĂKv܂B<br>
 * <br>
 * {֐Ƀ[N̈ZbgꍇAZbg̈̃{CXv[j
 * ܂ŃAvP[VŕێKv܂B<br>
 * iZbgς݂̃[N̈ɒl񂾂A肵Ă͂܂Bj<br>
 * <br>
 *  config ̏́A֐ł̂ݎQƂ܂B<br>
 * ֐𔲂͎QƂ܂̂ŁA֐s config ̗̈Ă
 * 肠܂B
 * <br>
 * {֐͊A^̊֐łB<br>
 * {CXv[̍쐬ɂ鎞Ԃ́AvbgtH[ɂĈقȂ܂B<br>
 * Q[[v̉ʍXVKvȃ^C~OŖ{֐sƃ~bPʂ
 * ubNAt[鋰ꂪ܂B<br>
 * {CXv[̍쐬^j́AV[̐؂ւ蓙Aוϓeł
 * ^C~Oōs悤肢܂B<br>
 * \sa CriAtomExRawPcmVoicePoolConfig, criAtomExVoicePool_CalculateWorkSizeForRawPcmVoicePool, criAtomExVoicePool_Free
 */
CriAtomExVoicePoolHn CRIAPI criAtomExVoicePool_AllocateRawPcmVoicePool(
	const CriAtomExRawPcmVoicePoolConfig *config, void *work, CriSint32 work_size);

/*JP
 * \brief CXgDg{CXv[̍쐬
 * \ingroup ATOMEXLIB_VOICE_POOL
 * \param[in]	config		CXgDg{CXv[쐬pRtBO\
 * \param[in]	work		[N̈
 * \param[in]	work_size	[N̈TCY
 * \return		CriAtomExInstrumentVoicePoolHn 	CXgDg{CXv[nh
 * \par F
 * CXgDg{CXv[쐬܂B<br>
 * {CXv[쐬ۂɂ́A[N̈ƂănKv܂B<br>
 * Kvȃ̃TCÝA ::criAtomExVoicePool_CalculateWorkSizeForInstrumentVoicePool 
 * ֐ŌvZ܂B<br>
 * i::criAtomEx_SetUserAllocator }NgpăAP[^[o^ς݂̏ꍇA
 * {֐Ƀ[N̈w肷Kv͂܂Bj<br>
 * <br>
 * {֐s邱ƂŁACXgDggbN̍Đ\ȃ{CXv[܂B<br>
 * AtomExv[[ŃCXgDggbN̍ĐsƁA
 * AtomExv[[͍쐬ꂽCXgDg{CXv[{CX擾AĐs܂B<br>
 * <br>
 * {CXv[̍쐬ɐƁA߂lƂă{CXv[nhԂ܂B<br>
 * AvP[VIɂ́A쐬{CXv[ ::criAtomExVoicePool_Free 
 * ֐ŔjKv܂B<br>
 * <br>
 * {CXv[̍쐬ɎsƁA{֐NULLԂ܂B<br>
 * {CXv[̍쐬ɎsRɂẮAG[R[obÑbZ[WŊmF\łB<br>
 * \sa CriAtomExInstrumentVoicePoolConfig, criAtomExVoicePool_CalculateWorkSizeForInstrumentVoicePool, criAtomExVoicePool_Free, 
 */
CriAtomExVoicePoolHn CRIAPI criAtomExVoicePool_AllocateInstrumentVoicePool(
	const CriAtomExInstrumentVoicePoolConfig *config, void *work, CriSint32 work_size);

/*JP
 * \brief {CXv[̔j
 * \ingroup ATOMEXLIB_VOICE_POOL
 * \param[in]	pool		{CXv[nh
 * \par :
 * 쐬ς݂̃{CXv[j܂B<br>
 * ::criAtomEx_SetUserAllocator }NgpăAP[^[o^ς݂̏ꍇA
 * {CXv[쐬Ɋmۂꂽ̈悪܂B<br>
 * i{CXv[쐬Ƀ[N̈nꍇA{֐sł
 * [N̈\łBj<br>
 * \attention
 * {֐͊A^̊֐łB<br>
 * ĐɃ{CXv[jꍇA{֐ōĐ~҂Ă
 * \[X̉s܂B<br>
 * it@CĐĂꍇ́Aɓǂݍ݊҂s܂Bj<br>
 * ̂߁A{֐ŏԁit[jubN\܂B<br>
 * {CXv[̍쐬^j́AV[̐؂ւ蓙Aוϓeł
 * ^C~Oōs悤肢܂B<br>
 * \sa criAtomExVoicePool_AllocateStandardVoicePool
 */
void CRIAPI criAtomExVoicePool_Free(CriAtomExVoicePoolHn pool);

/*JP
 * \brief SẴ{CXv[j
 * \ingroup ATOMEXLIB_VOICE_POOL
 * \par :
 * 쐬ς݂̃{CXv[SĔj܂B<br>
 * ::criAtomEx_SetUserAllocator }NgpăAP[^[o^ς݂̏ꍇA
 * {CXv[쐬Ɋmۂꂽ̈悪܂B<br>
 * i{CXv[쐬Ƀ[N̈nꍇA{֐sł
 * [N̈\łBj<br>
 * \attention
 * {֐͊A^̊֐łB<br>
 * ĐɃ{CXv[jꍇA{֐ōĐ~҂Ă
 * \[X̉s܂B<br>
 * it@CĐĂꍇ́Aɓǂݍ݊҂s܂Bj<br>
 * ̂߁A{֐ŏԁit[jubN\܂B<br>
 * {CXv[̍쐬^j́AV[̐؂ւ蓙Aוϓeł
 * ^C~Oōs悤肢܂B<br>
 * \sa criAtomExVoicePool_AllocateStandardVoicePool
 */
void CRIAPI criAtomExVoicePool_FreeAll(void);

/*JP
 * \brief {CXv[̗
 * \ingroup ATOMEXLIB_VOICE_POOL
 * \param[in]	func		{CXv[R[obN֐
 * \param[in]	obj			[UwIuWFNg
 * \par :
 * AvP[Vō쐬{CXv[񋓂܂B<br>
 * <br>
 * {֐sƁA 1 i func j
 * ŃZbgꂽR[obN֐{CXv[̐Ăяo܂B<br>
 * i{CXv[nhAƂăR[obN֐ɓn܂Bj<br>
 * \par l:
 *  2 i obj jɃZbgĺAR[obN֐̈Ƃēn܂B<br>
 * R[obN֐̂̑̈ɂẮA
 * ʓr ::CriAtomExVoicePoolCbFunc ̐QƂB<br>
 * \sa CriAtomExVoicePoolCbFunc
 */
void CRIAPI criAtomExVoicePool_EnumerateVoicePools(CriAtomExVoicePoolCbFunc func, void* obj);

/*JP
 * \brief {CX̎gp󋵂̎擾
 * \ingroup ATOMEXLIB_VOICE_POOL
 * \param[in]	pool		{CXv[nh
 * \param[out]	cur_num		ݎgp̃{CX
 * \param[out]	limit		p\ȃ{CX̍ő吔
 * \par :
 * {CXv[̃{CX̂Aݎgp̃{CX̐Aїp\
 * ő{CXiv[쐬Ɏw肵 max_voices ̐j擾܂B<br>
 */
void CRIAPI criAtomExVoicePool_GetNumUsedVoices(
	CriAtomExVoicePoolHn pool, CriSint32 *cur_num, CriSint32 *limit);

/*JP
 * \brief v[[nh̎擾
 * \ingroup ATOMEXLIB_VOICE_POOL
 * \param[in]	pool		{CXv[nh
 * \param[in]	index		v[[CfbNX
 * \return		CriAtomPlayerHn		Atomv[[nh
 * \par :
 * {CXv[ō쐬ꂽAtomv[[nh擾܂B<br>
 * \par l:
 * {֐͏擾prɂ̂ݗp\ȃfobO֐łB<br>
 */
CriAtomPlayerHn CRIAPI criAtomExVoicePool_GetPlayerHandle(
	CriAtomExVoicePoolHn pool, CriSint32 index);

/*JP
 * \brief CXgDg{CXv[쐬p[N̈TCY̌vZ
 * \ingroup ATOMEXLIB_VOICE_POOL
 * \param[in]	config		CXgDg{CXv[쐬pRtBO\
 * \return		CriSint32	[N̈TCY
 * \retval		0ȏ		ɏ
 * \retval		-1			G[
 * \par :
 * CXgDg{CXv[̍쐬ɕKvȃ[N̈̃TCYvZ܂B<br>
 * ::criAtomEx_SetUserAllocator }NɂAP[^[o^s킸
 * ::criAtomExVoicePool_AllocateInstrumentVoicePool ֐Ń{CXv[쐬ۂɂ́A
 * ::criAtomExVoicePool_AllocateInstrumentVoicePool ֐ɖ{֐ԂTCỸ[N
 * ̈ƂēnKv܂B<br>
 * <br>
 * [N̈TCY̌vZɎsƁA{֐ -1 Ԃ܂B<br>
 * [N̈TCY̌vZɎsRɂẮAG[R[obÑbZ[WŊmF\łB<br>
 * \sa criAtomExVoicePool_AllocateInstrumentVoicePool
 */
CriSint32 CRIAPI criAtomExVoicePool_CalculateWorkSizeForInstrumentVoicePool(
	const CriAtomExInstrumentVoicePoolConfig *config);

/*==========================================================================
 *      CRI AtomEx Category API
 *=========================================================================*/
/*JP
 * \brief IDwɂJeSɑ΂{[ݒ
 * \ingroup ATOMEXLIB_CATEGORY
 * \param[in]	id		JeSID
 * \param[in]	volume	{[l
 * \par :
 * IDwŃJeSɑ΂ă{[ݒ肵܂B
 * \attention
 * {֐ɂݒlACFɂĐݒ肳ĂJeS{[㏑ύX܂B<br>
 * {֐ɂݒlACFݒlƂ̏ZKp͍sȂƂɒӂĂB
 */
void CRIAPI criAtomExCategory_SetVolumeById(CriAtomExCategoryId id, CriFloat32 volume);

/*JP
 * \brief IDwɂJeS{[擾
 * \ingroup ATOMEXLIB_CATEGORY
 * \param[in]	id		JeSID
 * return		CriFloat32 JeS{[
 * \par :
 * IDwŃJeS̃{[擾܂B
 */
CriFloat32 CRIAPI criAtomExCategory_GetVolumeById(CriAtomExCategoryId id);

/*JP
 * \brief IDwɂŏIJeS{[擾
 * \ingroup ATOMEXLIB_CATEGORY
 * \param[in]	id		JeSID
 * return		CriFloat32 JeS{[
 * \par :
 * IDwREACTAAISACȂǂ̉e󂯂ŏIIȃJeS̃{[l擾܂B
 * \par l:
 * ŏIIȃJeS̃{[l擾邽߂Ƀp[^[̌vZŝŁA
 * ׂ傫֐łB
 */
CriFloat32 CRIAPI criAtomExCategory_GetTotalVolumeById(CriAtomExCategoryId id);

/*JP
 * \brief OwɂJeSɑ΂{[ݒ
 * \ingroup ATOMEXLIB_CATEGORY
 * \param[in]	name	JeS
 * \param[in]	volume	{[l
 * \par :
 * OwŃJeSɑ΂ă{[ݒ肵܂B
 * \attention
 * {֐ɂݒlACFɂĐݒ肳ĂJeS{[㏑ύX܂B<br>
 * {֐ɂݒlACFݒlƂ̏ZKp͍sȂƂɒӂĂB
 */
void CRIAPI criAtomExCategory_SetVolumeByName(const CriChar8* name, CriFloat32 volume);

/*JP
 * \brief OwɂJeS{[擾
 * \ingroup ATOMEXLIB_CATEGORY
 * \param[in]	name		JeS
 * return		CriFloat32 JeS{[
 * \par :
 * OwŃJeS̃{[擾܂B
 */
CriFloat32 CRIAPI criAtomExCategory_GetVolumeByName(const CriChar8* name);

/*JP
 * \brief OwɂŏIJeS{[擾
 * \ingroup ATOMEXLIB_CATEGORY
 * \param[in]	name		JeS
 * return		CriFloat32 JeS{[
 * \par :
 * OwREACTAAISACȂǂ̉e󂯂ŏIIȃJeS̃{[l擾܂B
 * \par l:
 * ŏIIȃJeS̃{[l擾邽߂Ƀp[^[̌vZŝŁA
 * ׂ傫֐łB
 */
CriFloat32 CRIAPI criAtomExCategory_GetTotalVolumeByName(const CriChar8* name);

/*JP
 * \brief IDwɂJeS~[gԐݒ
 * \ingroup ATOMEXLIB_CATEGORY
 * \param[in]	id	JeSID
 * \param[in]	mute ~[gԁiCRI_TRUE = ~[gACRI_FALSE = ~[gj
 * \par :
 * IDwŃJeS̃~[gԂݒ肵܂B
 */
void CRIAPI criAtomExCategory_MuteById(CriAtomExCategoryId id, CriBool mute);

/*JP
 * \brief IDwɂJeS~[gԎ擾
 * \ingroup ATOMEXLIB_CATEGORY
 * \param[in]	id	JeSID
 * return		CriBool ~[gԁiCRI_TRUE = ~[gACRI_FALSE = ~[gĂȂj
 * \par :
 * IDwŃJeS̃~[gԂ擾܂B
 */
CriBool CRIAPI criAtomExCategory_IsMutedById(CriAtomExCategoryId id);

/*JP
 * \brief OwɂJeS~[gԐݒ
 * \ingroup ATOMEXLIB_CATEGORY
 * \param[in]	name	JeS
 * \param[in]	mute ~[gԁiCRI_TRUE = ~[gACRI_FALSE = ~[gj
 * \par :
 * OwŃJeS̃~[gԂݒ肵܂B
 */
void CRIAPI criAtomExCategory_MuteByName(const CriChar8* name, CriBool mute);

/*JP
 * \brief OwɂJeS~[gԎ擾
 * \ingroup ATOMEXLIB_CATEGORY
 * \param[in]	name	JeS
 * return		CriBool ~[gԁiCRI_TRUE = ~[gACRI_FALSE = ~[gĂȂj
 * \par :
 * OwŃJeS̃~[gԂ擾܂B
 */
CriBool CRIAPI criAtomExCategory_IsMutedByName(const CriChar8* name);

/*JP
 * \brief IDwɂJeS\Ԑݒ
 * \ingroup ATOMEXLIB_CATEGORY
 * \param[in]	id	JeSID
 * \param[in]	solo \ԁiCRI_TRUE = \ACRI_FALSE = \j
 * \param[in]	mute_volume ̃JeSɓKp~[g{[l
 * \par :
 * IDwŃJeS̃\Ԃݒ肵܂B<br>
 * mute_volumeŎw肵{[͓JeSO[vɏ
 * JeSɑ΂ēKp܂B
 */
void CRIAPI criAtomExCategory_SoloById(CriAtomExCategoryId id, CriBool solo, CriFloat32 mute_volume);

/*JP
 * \brief IDwɂJeS\Ԏ擾
 * \ingroup ATOMEXLIB_CATEGORY
 * \param[in]	id	JeSID
 * return		CriBool \ԁiCRI_TRUE = \ACRI_FALSE = \ł͂Ȃj
 * \par :
 * IDwŃJeS̃\Ԃ擾܂B
 */
CriBool CRIAPI criAtomExCategory_IsSoloedById(CriAtomExCategoryId id);

/*JP
 * \brief OwɂJeS\Ԑݒ
 * \ingroup ATOMEXLIB_CATEGORY
 * \param[in]	name JeS
 * \param[in]	solo \ԁiCRI_TRUE = \ACRI_FALSE = \j
 * \param[in]	mute_volume ̃JeSɓKp~[g{[l
 * \par :
 * OwŃJeS̃\Ԃݒ肵܂B<br>
 * mute_volumeŎw肵{[͓JeSO[vɏ
 * JeSɑ΂ēKp܂B
 */
void CRIAPI criAtomExCategory_SoloByName(const CriChar8* name, CriBool solo, CriFloat32 mute_volume);

/*JP
 * \brief OwɂJeS\Ԏ擾
 * \ingroup ATOMEXLIB_CATEGORY
 * \param[in]	name	JeS
 * return		CriBool \ԁiCRI_TRUE = \ACRI_FALSE = \ł͂Ȃj
 * \par :
 * OwŃJeS̃\Ԃ擾܂B
 */
CriBool CRIAPI criAtomExCategory_IsSoloedByName(const CriChar8* name);

/*JP
 * \brief IDwɂJeS̃|[Y^|[Y
 * \ingroup ATOMEXLIB_CATEGORY
 * \param[in]	id	JeSID
 * \param[in]	sw	XCb`iCRI_FALSE = |[YACRI_TRUE = |[Yj
 * \par :
 * IDwŃJeS̃|[Y^|[Ys܂B<br>
 * ::criAtomExCategory_SetFadeOutTimeById ֐::criAtomExCategory_SetFadeOutTimeByName
 * ֐ŃtF[hAEgԂݒ肳ĂꍇɃ|[YsƁAݒ肳ꂽԂŃtF[hAEgɎۂɃ|[Y܂B<br>
 * ::criAtomExCategory_SetFadeInTimeById ֐::criAtomExCategory_SetFadeInTimeByName
 * ֐ŃtF[hCԂݒ肳ĂꍇɃ|[YsƁA|[YAݒ肳ꂽԂŃtF[hC܂B<br>
 * \par l:
 * JeS̃|[ÝAAtomExv[[^Đ̃|[Y
 * i::criAtomExPlayer_Pause ֐::criAtomExPlayback_Pause ֐ł̃|[YjƂ͓ƗĈA
 * ̍ŏIIȃ|[YԂ́Aꂼ̃|[YԂlČ܂܂B<br>
 * Ȃ킿Aǂ炩|[YԂȂ|[YAǂ|[YԂȂ|[YAƂȂ܂B
 */
void CRIAPI criAtomExCategory_PauseById(CriAtomExCategoryId id, CriBool sw);

/*JP
 * \brief IDwɂJeS̃|[YԎ擾
 * \ingroup ATOMEXLIB_CATEGORY
 * \param[in]	id		JeSID
 * return		CriBool	|[Y
 * \par :
 * IDwŃJeS̃|[YԂ擾܂B
 */
CriBool CRIAPI criAtomExCategory_IsPausedById(CriAtomExCategoryId id);

/*JP
 * \brief OwɂJeS̃|[Y^|[Y
 * \ingroup ATOMEXLIB_CATEGORY
 * \param[in]	name	JeS
 * \param[in]	sw		XCb`iCRI_FALSE = |[YACRI_TRUE = |[Yj
 * \par :
 * OwŃJeS̃|[Y^|[Ys܂B<br>
 * JeS𖼑OŎw肷ȊÓA::criAtomExCategory_PauseById ֐Ǝdl͓łB<br>
 * \sa criAtomExCategory_PauseById
 */
void CRIAPI criAtomExCategory_PauseByName(const CriChar8* name, CriBool sw);

/*JP
 * \brief OwɂJeS̃|[YԎ擾
 * \ingroup ATOMEXLIB_CATEGORY
 * \param[in]	name	JeS
 * return		CriBool |[Y
 * \par :
 * OwŃJeS̃|[YԂ擾܂B
 */
CriBool CRIAPI criAtomExCategory_IsPausedByName(const CriChar8* name);

/*JP
 * \brief tF[hCԂ̐ݒiJeSIDwj
 * \ingroup ATOMEXLIB_CATEGORY
 * \param[in]	id	JeSID
 * \param[in]	ms	tF[hCԁi~bPʁj
 * \par :
 * JeSɃtF[hCԂݒ肵܂B<br>
 * tF[hCԂ̓|[Ysۂɗp܂B<br>
 */
void CRIAPI criAtomExCategory_SetFadeInTimeById(CriAtomExCategoryId id, CriUint16 ms);

/*JP
 * \brief tF[hCԂ̐ݒiJeSwj
 * \ingroup ATOMEXLIB_CATEGORY
 * \param[in]	name	JeS
 * \param[in]	ms		tF[hCԁi~bPʁj
 * \par :
 * JeSɃtF[hCԂݒ肵܂B<br>
 * tF[hCԂ̓|[Ysۂɗp܂B<br>
 */
void CRIAPI criAtomExCategory_SetFadeInTimeByName(const CriChar8* name, CriUint16 ms);

/*JP
 * \brief tF[hAEgԂ̐ݒiJeSIDwj
 * \ingroup ATOMEXLIB_CATEGORY
 * \param[in]	id	JeSID
 * \param[in]	ms	tF[hAEgԁi~bPʁj
 * \par :
 * JeSɃtF[hAEgԂݒ肵܂B<br>
 * tF[hAEgԂ̓|[Ysۂɗp܂B<br>
 */
void CRIAPI criAtomExCategory_SetFadeOutTimeById(CriAtomExCategoryId id, CriUint16 ms);

/*JP
 * \brief tF[hAEgԂ̐ݒiJeSwj
 * \ingroup ATOMEXLIB_CATEGORY
 * \param[in]	name	JeS
 * \param[in]	ms		tF[hAEgԁi~bPʁj
 * \par :
 * JeSɃtF[hAEgԂݒ肵܂B<br>
 * tF[hAEgԂ̓|[Ysۂɗp܂B<br>
 */
void CRIAPI criAtomExCategory_SetFadeOutTimeByName(const CriChar8* name, CriUint16 ms);

/*JP
 * \brief IDwɂJeSɑ΂AISACRg[lݒ
 * \ingroup ATOMEXLIB_CATEGORY
 * \param[in]	id				JeSID
 * \param[in]	control_id		AISACRg[ID
 * \param[in]	control_value	AISACRg[l
 * \par :
 * IDwŃJeSɑ΂AISACRg[lݒ肵܂B<br>
 * \par l:
 * JeSIDŁAAISACRg[𖼑OŎw肵ꍇA::criAtomExAcf_GetAisacControlIdByName ֐ɂĕϊsĂB
 * \attention
 * L[gbNɐݒ肳ĂAISACɊւẮAv[[łAISACRg[lݒA<b>JeSAISACRg[lD悵</b>QƂ܂B<br>
 * JeSɃA^b`AISACɂẮA<b>JeSɐݒ肵AISACRg[l̂</b>AQƂ܂B
 * \sa criAtomExCategory_SetAisacControlByName, criAtomExCategory_AttachAisacById, criAtomExCategory_AttachAisacByName
 */
void CRIAPI criAtomExCategory_SetAisacControlById(
	CriAtomExCategoryId id,
	CriAtomExAisacControlId control_id,
	CriFloat32 control_value
);

/*JP
 * \brief OwɂJeSɑ΂AISACRg[lݒ
 * \ingroup ATOMEXLIB_CATEGORY
 * \param[in]	name			JeS
 * \param[in]	control_name	AISACRg[
 * \param[in]	control_value	AISACRg[l
 * \par :
 * OwŃJeSɑ΂AISACRg[lݒ肵܂B<br>
 * JeSAISACRg[𖼑OŎw肷ȊÓA::criAtomExCategory_SetAisacControlById ֐Ǝdl͓łB<br>
 * \par l:
 * JeS𖼑OAAISACRg[IDŎw肵ꍇA::criAtomExAcf_GetAisacControlNameById ֐ɂĕϊsĂB
 * \sa criAtomExCategory_SetAisacControlById, criAtomExCategory_AttachAisacById, criAtomExCategory_AttachAisacByName
 */
void CRIAPI criAtomExCategory_SetAisacControlByName(
	const CriChar8* name,
	const CriChar8* control_name,
	CriFloat32 control_value
);

/*JP
 * \brief IDwŃJeSɃA^b`ĂSĂAISACRg[lftHglɐݒ肷
 * \ingroup ATOMEXLIB_CATEGORY
 * \param[in]	category_id		JeSID
 * \retval	CRI_TRUE = 
 * \retval	CRI_FALSE = s
 * \par :
 * JeSɃA^b`ĂSĂAISACRg[lftHglɐݒ肵܂B<br>
 * ݂ȂJeSw肵ꍇACRI_FALSEԂ܂B<br>
 * \sa criAtomExCategory_GetNumAttachedAisacsById
 */
CriBool CRIAPI criAtomExCategory_ResetAllAisacControlById(CriAtomExCategoryId category_id);

/*JP
 * \brief OwŃJeSɃA^b`ĂSĂAISACRg[lftHglɐݒ肷
 * \ingroup ATOMEXLIB_CATEGORY
 * \param[in]	category_name					JeS
 * \retval	CRI_TRUE = 
 * \retval	CRI_FALSE = s
 * \par :
 * JeSɃA^b`ĂSĂAISACRg[lftHglɐݒ肵܂B<br>
 * ݂ȂJeSw肵ꍇACRI_FALSEԂ܂B<br>
 * \sa criAtomExCategory_GetNumAttachedAisacsById
 */
CriBool CRIAPI criAtomExCategory_ResetAllAisacControlByName(const CriChar8* category_name);

/*JP
 * \brief IDwŃJeSAISACt
 * \ingroup ATOMEXLIB_CATEGORY
 * \param[in]	id					JeSID
 * \param[in]	global_aisac_name	tO[oAISAC
 * \par :
 * JeSAISACA^b`itj܂B
 * AISACA^b`邱ƂɂAL[gbNAISACݒ肵ĂȂĂAAISAČʂ𓾂邱Ƃł܂B<br>
 * <br>
 * AISAC̃A^b`ɎsꍇA֐ŃG[R[obN܂B<br>
 * AISAC̃A^b`ɎsRɂẮAG[R[obÑbZ[WmFĂB<br>
 * \par l:
 * S̐ݒiACFt@CjɊ܂܂O[oAISAĈ݁AA^b`\łB<br>
 * AISAČʂ𓾂ɂ́AL[gbNɐݒ肳ĂAISACƓlɁAYAISACRg[lݒ肷Kv܂B<br>
 * \attention
 * L[gbNɁuAISACRg[lύXAISACvݒ肳ĂƂĂA
 * ̓KpʂAISACRg[ĺAJeSɃA^b`AISACɂ͉e܂B<br>
 * JeSɃA^b`AISACɂẮA<b>JeSɐݒ肵AISACRg[l̂</b>AQƂ܂B<br>
 * ݁AuI[gW[Vvu_vƂRg[^CvAISAC̃A^b`ɂ͑ΉĂ܂B<br>
 * ݁AJeSɃA^b`łAISAC̍ő吔́A8ŒłB
 * \sa criAtomExCategory_DetachAisacById
 */
void CRIAPI criAtomExCategory_AttachAisacById(CriAtomExCategoryId id, const CriChar8* global_aisac_name);

/*JP
 * \brief OwŃJeSAISACt
 * \ingroup ATOMEXLIB_CATEGORY
 * \param[in]	name				JeS
 * \param[in]	global_aisac_name	tO[oAISAC
 * \par :
 * JeSAISACA^b`itj܂B
 * JeS𖼑OŎw肷ȊÓA::criAtomExCategory_AttachAisacById ֐Ǝdl͓łB<br>
 * \sa criAtomExCategory_AttachAisacById, criAtomExCategory_DetachAisacByName
 */
void CRIAPI criAtomExCategory_AttachAisacByName(const CriChar8* name, const CriChar8* global_aisac_name);

/*JP
 * \brief IDwŃJeSAISACO
 * \ingroup ATOMEXLIB_CATEGORY
 * \param[in]	id					JeSID
 * \param[in]	global_aisac_name	OO[oAISAC
 * \par :
 * JeSAISACf^b`iOj܂B<br>
 * <br>
 * AISAC̃f^b`ɎsꍇA֐ŃG[R[obN܂B<br>
 * AISAC̃f^b`ɎsRɂẮAG[R[obÑbZ[WmFĂB<br>
 * \sa criAtomExCategory_AttachAisacById
 */
void CRIAPI criAtomExCategory_DetachAisacById(CriAtomExCategoryId id, const CriChar8* global_aisac_name);

/*JP
 * \brief OwŃJeSAISACO
 * \ingroup ATOMEXLIB_CATEGORY
 * \param[in]	name					JeS
 * \param[in]	global_aisac_name	OO[oAISAC
 * \par :
 * JeSAISACf^b`iOj܂B<br>
 * JeS𖼑OŎw肷ȊÓA::criAtomExCategory_DetachAisacById ֐Ǝdl͓łB<br>
 * \sa criAtomExCategory_DetachAisacById, criAtomExCategory_AttachAisacByName
 */
void CRIAPI criAtomExCategory_DetachAisacByName(const CriChar8* name, const CriChar8* global_aisac_name);

/*JP
 * \brief IDwŃJeSSĂAISACO
 * \ingroup ATOMEXLIB_CATEGORY
 * \param[in]	id					JeSID
 * \par :
 * JeSSĂAISACf^b`iOj܂B
 */
void CRIAPI criAtomExCategory_DetachAisacAllById(CriAtomExCategoryId id);

/*JP
 * \brief OwŃJeSSĂAISACO
 * \ingroup ATOMEXLIB_CATEGORY
 * \param[in]	name					JeS
 * \par :
 * JeSSĂAISACf^b`iOj܂B
 */
void CRIAPI criAtomExCategory_DetachAisacAllByName(const CriChar8* name);

/*JP
 * \brief IDwŃJeSɃA^b`ĂAISAC擾
 * \ingroup ATOMEXLIB_CATEGORY
 * \param[in]	id					JeSID
 * \return	JeSɃA^b`ĂAISAC
 * \par :
 * JeSɃA^b`ĂAISAC擾܂B<br>
 * ݂ȂJeSw肵ꍇAlԂ܂B
 */
CriSint32 CRIAPI criAtomExCategory_GetNumAttachedAisacsById(CriAtomExCategoryId id);

/*JP
 * \brief OwŃJeSɃA^b`ĂAISAC擾
 * \ingroup ATOMEXLIB_CATEGORY
 * \param[in]	name					JeS
 * \return	JeSɃA^b`ĂAISAC
 * \par :
 * JeSɃA^b`ĂAISAC擾܂B
 * ݂ȂJeSw肵ꍇAlԂ܂B
 */
CriSint32 CRIAPI criAtomExCategory_GetNumAttachedAisacsByName(const CriChar8* name);

/*JP
 * \brief IDwŃJeSɃA^b`ĂAISAC̏擾
 * \ingroup ATOMEXLIB_CATEGORY
 * \param[in]	id						JeSID
 * \param[in]	aisac_attached_index	A^b`ĂAISAC̃CfbNX
 * \param[out]	aisac_info				AISAC
 * \retval	CRI_TRUE = 񂪎擾ł
 * \retval	CRI_FALSE = 񂪎擾łȂ
 * \par :
 * JeSɃA^b`ĂAISAC̏擾܂B<br>
 * ݂ȂJeSw肵ꍇAȃCfbNXw肵ꍇACRI_FALSEԂ܂B<br>
 * \sa criAtomExCategory_GetNumAttachedAisacsById
 */
CriBool CRIAPI criAtomExCategory_GetAttachedAisacInfoById(
	CriAtomExCategoryId id, 
	CriSint32 aisac_attached_index,
	CriAtomExAisacInfo *aisac_info
);

/*JP
 * \brief OwŃJeSɃA^b`ĂAISAC̏擾
 * \ingroup ATOMEXLIB_CATEGORY
 * \param[in]	name					JeS
 * \param[in]	aisac_attached_index	A^b`ĂAISAC̃CfbNX
 * \param[out]	aisac_info				AISAC
 * \retval	CRI_TRUE = 񂪎擾ł
 * \retval	CRI_FALSE = 񂪎擾łȂ
 * \par :
 * JeSɃA^b`ĂAISAC̏擾܂B<br>
 * ݂ȂJeSw肵ꍇAȃCfbNXw肵ꍇACRI_FALSEԂ܂B<br>
 * \sa criAtomExCategory_GetNumAttachedAisacsByName
 */
CriBool CRIAPI criAtomExCategory_GetAttachedAisacInfoByName(
	const CriChar8* name,
	CriSint32 aisac_attached_index,
	CriAtomExAisacInfo *aisac_info
);

/*JP
 * \brief IDwŃJeSɃA^b`ĂAISACRg[̌ݒl擾
 * \ingroup ATOMEXLIB_CATEGORY
 * \param[in]	category_id			JeSID
 * \param[in]	aisac_control_id	AISACRg[ID
 * \param[out]	control_value		AISACRg[̌ݒl
 * \retval	CRI_TRUE = 񂪎擾ł
 * \retval	CRI_FALSE = 񂪎擾łȂ
 * \par :
 * JeSɃA^b`ĂAISACRg[̌ݒl擾܂B<br>
 * ݂ȂJeSAISACRg[w肵ꍇACRI_FALSEԂ܂B<br>
 * \sa criAtomExCategory_GetNumAttachedAisacsById
 */
CriBool CRIAPI criAtomExCategory_GetCurrentAisacControlValueById(
	CriAtomExCategoryId category_id,
	CriAtomExAisacControlId aisac_control_id,
	CriFloat32 * control_value
);

/*JP
 * \brief OwŃJeSɃA^b`ĂAISACRg[̌ݒl擾
 * \ingroup ATOMEXLIB_CATEGORY
 * \param[in]	category_name			JeS
 * \param[in]	aisac_control_name		AISACRg[
 * \param[out]	control_value			AISACRg[̌ݒl
 * \retval	CRI_TRUE = 񂪎擾ł
 * \retval	CRI_FALSE = 񂪎擾łȂ
 * \par :
 * JeSɃA^b`ĂAISACRg[̌ݒl擾܂B<br>
 * ݂ȂJeSw肵ꍇAȃCfbNXw肵ꍇACRI_FALSEԂ܂B<br>
 * \sa criAtomExCategory_GetNumAttachedAisacsById
 */
CriBool CRIAPI criAtomExCategory_GetCurrentAisacControlValueByName(
	const CriChar8* category_name,
	const CriChar8* aisac_control_name,
	CriFloat32 * control_value
);

/*JP
 * \brief REACT쓮p[^[̐ݒ
 * \ingroup ATOMEXLIB_CATEGORY
 * \param[in]	react_name			REACT
 * \param[in]	react_parameter		REACT쓮p[^[\
 * \par :
 * REACT쓮p[^[ݒ肵܂B<br>
 * REACT삵ĂԂ̓p[^[ݒ肷邱Ƃ͂ł܂ix܂jB<br>
 * ݂ȂREACTw肵ꍇ́AG[R[obNԂ܂B<br>
 * \sa criAtomExCategory_GetReactParameter
 */
void CRIAPI criAtomExCategory_SetReactParameter(
	const CriChar8* react_name, 
	const CriAtomExReactParameter* react_parameter);

/*JP
 * \brief REACT쓮p[^[̎擾
 * \ingroup ATOMEXLIB_CATEGORY
 * \param[in]	react_name			REACT
 * \param[out]	react_parameter		REACT쓮p[^[\
 * \retval	CRI_TRUE = 񂪎擾ł
 * \retval	CRI_FALSE = 񂪎擾łȂ
 * \par :
 * REACT쓮p[^[̌ݒl擾܂B<br>
 * ݂ȂREACTw肵ꍇ́AG[R[obNCRI_FALSEԂ܂B<br>
 * \sa criAtomExCategory_SetReactParameter
 */
CriBool CRIAPI criAtomExCategory_GetReactParameter(
	const CriChar8* react_name, 
	CriAtomExReactParameter* react_parameter);

/*JP
 * \brief REACTXe[^X̎擾
 * \ingroup ATOMEXLIB_CATEGORY
 * \param[in]	react_name			REACT
 * \return	CriAtomExReactStatus	REACTXe[^X
 * \par :
 * REACT̓Xe[^X擾܂B<br>
 * ݂ȂREACTw肵ꍇ́AG[R[obN
 * ::CRIATOMEX_REACT_STATUS_ERROR Ԃ܂B<br>
 */
CriAtomExReactStatus CRIAPI criAtomExCategory_GetReactStatus(const CriChar8* react_name);

/*JP
 * \brief IDwŃJeSɏ锭̃L[擾
 * \ingroup ATOMEXLIB_CATEGORY
 * \param[in]	id					JeSID
 * \return	JeSɏ锭̃L[
 * \par :
 * JeSɏ锭̃L[擾܂B<br>
 * ݂ȂJeSw肵ꍇAlԂ܂B
 */
CriSint32 CRIAPI criAtomExCategory_GetNumCuePlayingCountById(CriAtomExCategoryId id);

/*JP
 * \brief OwŃJeSɏ锭̃L[擾
 * \ingroup ATOMEXLIB_CATEGORY
 * \param[in]	name					JeS
 * \return	JeSɏ锭̃L[
 * \par :
 * JeSɏ锭̃L[擾܂B
 * ݂ȂJeSw肵ꍇAlԂ܂B
 */
CriSint32 CRIAPI criAtomExCategory_GetNumCuePlayingCountByName(const CriChar8* name);

/*JP
 * \brief IDwŃJeSɏ锭̃L[~
 * \ingroup ATOMEXLIB_CATEGORY
 * \param[in]	id					JeSID
 * \par :
 * w肵JeSɏ锭̃L[~܂B<br>
 */
void CRIAPI criAtomExCategory_StopById(CriAtomExCategoryId id);

/*JP
 * \brief OwŃJeSɏ锭̃L[~
 * \ingroup ATOMEXLIB_CATEGORY
 * \param[in]	name					JeS
 * \par :
 * w肵JeSɏ锭̃L[~܂B<br>
 */
void CRIAPI criAtomExCategory_StopByName(const CriChar8* name);

/*JP
 * \brief IDwŃJeSɏ锭̃L[𑦎~
 * \ingroup ATOMEXLIB_CATEGORY
 * \param[in]	id					JeSID
 * \par :
 * w肵JeSɏ锭̃L[𑦎~܂B<br>
 */
void CRIAPI criAtomExCategory_StopWithoutReleaseTimeById(CriAtomExCategoryId id);

/*JP
 * \brief OwŃJeSɏ锭̃L[𑦎~
 * \ingroup ATOMEXLIB_CATEGORY
 * \param[in]	name					JeS
 * \par :
 * w肵JeSɏ锭̃L[𑦎~܂B<br>
 */
void CRIAPI criAtomExCategory_StopWithoutReleaseTimeByName(const CriChar8* name);
	
/*==========================================================================
 *      CRI AtomEx Player API
 *=========================================================================*/
/*JP
 * \brief AtomExPlayerp[N̈TCY̌vZ
 * \ingroup ATOMEXLIB_PLAYER
 * \param[in]	config		v[[쐬pRtBO\
 * \return		CriSint32	[N̈TCY
 * \retval		0ȏ		ɏ
 * \retval		-1			G[
 * \par :
 * AtomExv[[쐬邽߂ɕKvȁA[N̈̃TCY擾܂B<br>
 * AP[^[o^AtomExv[[쐬ꍇA
 * 炩ߖ{֐ŌvZ[N̈TCỸ
 * [N̈Ƃ ::criAtomExPlayer_Create ֐ɃZbgKv܂B<br>
 * <br>
 * v[[̍쐬ɕKvȃ[ÑTCÝAv[[쐬pRtBO
 * \́i ::CriAtomExPlayerConfig j̓eɂĕω܂B<br>
 * <br>
 * NULLw肵ꍇAftHgݒ
 * i ::criAtomExPlayer_SetDefaultConfig KpƓp[^[j
 * [N̈TCYvZ܂B
 * <br>
 * [N̈TCYvZɎsꍇA߂l -1 ɂȂ܂B<br>
 * [N̈TCY̌vZɎsRɂẮAG[R[obN
 * bZ[WŊmF\łB<br>
 * \par l:
 *  config ̏́A֐ł̂ݎQƂ܂B<br>
 * ֐𔲂͎QƂ܂̂ŁA֐s config ̗̈Ă
 * 肠܂B
 * \attention
 * {֐sOɁACuĂKv܂B<br>
 * \sa CriAtomExPlayerConfig, criAtomExPlayer_Create
 */
CriSint32 CRIAPI criAtomExPlayer_CalculateWorkSize(
	const CriAtomExPlayerConfig *config);

/*JP
 * \brief AtomExPlayer̍쐬
 * \ingroup ATOMEXLIB_PLAYER
 * \param[in]	config		AtomExv[[쐬pRtBO\
 * \param[in]	work		[N̈
 * \param[in]	work_size	[N̈TCY
 * \return		CriAtomExPlayerHn	AtomExv[[nh
 * \par :
 * AtomExv[[쐬܂B<br>
 * <br>
 * v[[쐬ۂɂ́ACuŗp邽߂̃̈i[N̈j
 * mۂKv܂B<br>
 * [N̈mۂ@ɂ́Aȉ2ʂ̕@܂B<br>
 * <b>(a) User Allocator</b>F̊mہ^ɁA[Upӂ֐gp@B<br>
 * <b>(b) Fixed Memory</b>FKvȃ̈𒼐ڃCuɓn@B<br>
 * <br>
 * User AllocatorpꍇA[U[N̈pӂKv͂܂B<br>
 * workNULLAwork_size0w肷邾ŁAKvȃo^ς݂̃mۊ֐mۂ܂B<br>
 * AtomExv[[쐬Ɋmۂꂽ́AAtomExv[[ji ::criAtomExPlayer_Destroy 
 * ֐sjɉ܂B<br>
 * <br>
 * Fixed MemorypꍇA[N̈Ƃĕʓrmۍς݂̃̈{֐
 * ݒ肷Kv܂B<br>
 * [N̈̃TCY ::criAtomExPlayer_CalculateWorkSize ֐Ŏ擾\łB<br>
 * AtomExv[[쐬O ::criAtomExPlayer_CalculateWorkSize ֐Ŏ擾
 * TCỸ\ߊmۂĂA{֐ɐݒ肵ĂB<br>
 * AFixed MemorypꍇA[N̈AtomExv[[̔j
 * i ::criAtomExPlayer_Destroy ֐js܂ł̊ԁACuŗpꑱ܂B<br>
 * AtomExv[[̔jsOɁA[N̈̃ȂłB<br>
 * \par :
 * yUser AllocatorɂAtomExv[[̍쐬z<br>
 * User AllocatorpꍇAAtomExv[[̍쐬^j̎菇͈ȉ̂悤ɂȂ܂B<br>
 * 	-# AtomExv[[쐬OɁA ::criAtomEx_SetUserAllocator ֐pămہ^֐o^B<br>
 * 	-# AtomExv[[쐬pRtBO\̂Ƀp[^[ZbgB<br>
 * 	-# ::criAtomExPlayer_Create ֐AtomExv[[쐬B<br>
 * iworkɂNULLAwork_sizeɂ0w肷Bj<br>
 * 	-# nhsvɂȂ ::criAtomExPlayer_Destroy ֐AtomExv[[jB<br>
 * 	
 * <br>̓IȃR[h͈ȉ̂ƂłB<br>
 * \code
 * // Ǝ̃mۊ֐
 * void *user_malloc(void *obj, CriUint32 size)
 * {
 * 	void *mem;
 * 	
 * 	// ̊m
 * 	mem = malloc(size);
 * 	
 * 	return (mem);
 * }
 * 
 * // Ǝ̃֐p
 * void user_free(void *obj, void *mem)
 * {
 * 	// ̉
 * 	free(mem);
 * 	
 * 	return;
 * }
 * 
 * main()
 * {
 * 	CriAtomExPlayerConfig config;	// AtomExv[[쐬pRtBO\
 * 	CriAtomExPlayerHn player;		// AtomExv[[nh
 * 		:
 * 	// Ǝ̃AP[^[o^
 * 	criAtomEx_SetUserAllocator(user_malloc, user_free, NULL);
 * 	
 * 	// AtomExv[[쐬pRtBO\̂ݒ
 * 	criAtomExPlayer_SetDefaultConfig(&config);
 * 	
 * 	// AtomExv[[̍쐬
 * 	// [N̈ɂNULL0w肷B
 * 	// Kvȃ́Ao^mۊ֐gĊmۂB
 * 	player = criAtomExPlayer_Create(&config, NULL, 0);
 * 		:
 * 	// Đ
 * 		:
 * 	// AtomExv[[svɂȂ_Ŕj
 * 	// AtomExv[[쐬ɃCuŊmۂꂽB
 * 	criAtomExPlayer_Destroy(player);
 * 		:
 * }
 * \endcode
 * CuɃmہ^֐o^ς݂̏ꍇAAtomExv[[쐬
 * ɍēx֐o^Kv͂܂B<br>
 * <br>
 * yFixed MemoryɂAtomExv[[̍쐬z<br>
 * Fixed MemorypꍇAAtomExv[[̍쐬^j̎菇͈ȉ̂悤ɂȂ܂B<br>
 * 	-# AtomExv[[쐬pRtBO\̂Ƀp[^[ZbgB<br>
 * 	-# AtomExv[[̍쐬ɕKvȃ[N̈̃TCYA
 * ::criAtomExPlayer_CalculateWorkSize ֐gČvZB<br>
 * 	-# [N̈TCỸmۂB<br>
 * 	-# ::criAtomExPlayer_Create ֐AtomExv[[쐬B<br>
 * iworkɂ͊mۂ̃AhXAwork_sizeɂ̓[N̈̃TCYw肷Bj<br>
 * 	-# nhsvɂȂ ::criAtomExPlayer_Destroy ֐AtomExv[[jB<br>
 * 	-# [N̈̃B<br>
 * 	
 * <br>̓IȃR[h͈ȉ̂ƂłB<br>
 * \code
 * main()
 * {
 * 	CriAtomExPlayerConfig config;	// AtomExv[[쐬pRtBO\
 * 	CriAtomExPlayerHn player;		// AtomExv[[nh
 * 	void *work;						// [N̈AhX
 * 	CriSint32 work_size;			// [N̈TCY
 * 		:
 * 	// AtomExv[[쐬pRtBO\̂ݒ
 * 	criAtomExPlayer_SetDefaultConfig(&config);
 * 	
 * 	// AtomExv[[̍쐬ɕKvȃ[N̈̃TCYvZ
 * 	work_size = criAtomExPlayer_CalculateWorkSize(&config);
 * 	
 * 	// [N̈pɃm
 * 	work = malloc((size_t)work_size);
 * 	
 * 	// AtomExv[[̍쐬
 * 	// [N̈ɂNULL0w肷B
 * 	// mۍς݂̃[N̈w肷B
 * 	player = criAtomExPlayer_Create(&config, work, work_size);
 * 		:
 * 	// Đ
 * 	// ̊ԁAmۂ͕ێB
 * 		:
 * 	// AtomExv[[svɂȂ_Ŕj
 * 	criAtomExPlayer_Destroy(player);
 * 	
 * 	// KvȂȂ[N̈
 * 	free(work);
 * 		:
 * }
 * \endcode
 * ::criAtomExPlayer_Create ֐sƁAAtomExv[[쐬A
 * v[[𐧌䂷邽߂̃nhi ::CriAtomExPlayerHn jԂ܂B<br>
 * f[^̃ZbgAĐ̊JnAXe[^X̎擾AAtomExv[[ɑ΂
 * śASănhɑ΂čs܂B<br>
 * <br>
 * v[[̍쐬ɎsꍇA߂lƂ NULL Ԃ܂B<br>
 * v[[̍쐬ɎsRɂẮAG[R[obÑbZ[WŊmF\łB<br>
 * <br>
 * 쐬ꂽAtomExv[[nhgpĉf[^Đ菇͈ȉ̂ƂłB<br>
 * -# ::criAtomExPlayer_SetData ֐gpāAAtomExv[[ɍĐf[^ZbgB<br>
 * it@CĐ́A ::criAtomExPlayer_SetFile ֐܂ ::criAtomExPlayer_SetContentId 
 * ֐gpBj<br>
 * -# ::criAtomExPlayer_Start ֐ōĐJnB<br>
 * \par l:
 *  config ̏́A֐ł̂ݎQƂ܂B<br>
 * ֐𔲂͎QƂ܂̂ŁA֐s config ̗̈Ă
 * 肠܂B
 * \attention
 * {֐sOɁACuĂKv܂B<br>
 * <br>
 * {֐͊A^̊֐łB<br>
 * AtomExv[[̍쐬ɂ鎞Ԃ́AvbgtH[ɂĈقȂ܂B<br>
 * Q[[v̉ʍXVKvȃ^C~OŖ{֐sƃ~bPʂ
 * ubNAt[鋰ꂪ܂B<br>
 * AtomExv[[̍쐬^j́AV[̐؂ւ蓙Aוϓeł
 * ^C~Oōs悤肢܂B<br>
 * \sa CriAtomExPlayerConfig, criAtomExPlayer_CalculateWorkSize,
 * CriAtomExPlayerHn, criAtomExPlayer_Destroy,
 * criAtomExPlayer_SetData, criAtomExPlayer_SetFile, criAtomExPlayer_SetContentId,
 * criAtomExPlayer_Start
 */
CriAtomExPlayerHn CRIAPI criAtomExPlayer_Create(
	const CriAtomExPlayerConfig *config, void *work, CriSint32 work_size);

/*JP
 * \brief AtomExv[[̔j
 * \ingroup ATOMEXLIB_PLAYER
 * \param[in]	player		AtomExv[[nh
 * \par :
 * AtomExv[[j܂B<br>
 * {֐s_ŁAAtomExv[[쐬Ɋmۂꂽ\[XSĉ܂B<br>
 * ܂AɎw肵AtomExv[[nhɂȂ܂B<br>
 * \attention
 * {֐͊A^̊֐łB<br>
 * ĐAtomExv[[j悤ƂꍇA{֐ōĐ~
 * ҂Ă烊\[X̉s܂B<br>
 * it@CĐĂꍇ́Aɓǂݍ݊҂s܂Bj<br>
 * ̂߁A{֐ŏԁit[jubN\܂B<br>
 * AtomExv[[̍쐬^j́AV[̐؂ւ蓙Aוϓeł
 * ^C~Oōs悤肢܂B<br>
 * \sa criAtomExPlayer_Create, CriAtomExPlayerHn
 */
void CRIAPI criAtomExPlayer_Destroy(CriAtomExPlayerHn player);

/*JP
 * \brief f[^̃ZbgiL[IDwj
 * \ingroup ATOMEXLIB_PLAYER
 * \param[in]	player			AtomExv[[nh
 * \param[in]	acb_hn			ACBnh
 * \param[in]	id				L[ID
 * \par :
 * L[IDAAtomExv[[Ɋ֘At܂B<br>
 * {֐ŃL[IDwA ::criAtomExPlayer_Start ֐ōĐ
 * JnƁAw肳ꂽL[Đ܂B
 * \par :
 * \code
 * main()
 * {
 * 		:
 * 	// f[^Zbg
 * 	criAtomExPlayer_SetCueId(player, acb_hn, 100);
 * 	
 * 	// Zbgꂽf[^Đ
 * 	criAtomExPlayer_Start(player);
 * 		:
 * }
 * \endcode
 * AUZbgf[^̏́Ãf[^Zbg܂AtomExv[[ɕێ
 * ܂B<br>
 * ̂߁Af[^xĐꍇɂ́AĐɃf[^ZbgȂKv
 * ͂܂B
 * \par l:
 * 2i ach_hn j NULL w肵ꍇASĂACBf[^ΏۂɁAw肵L[ID
 * vf[^݂̑鏈삵܂B<br>
 * iw肵L[IDACBf[^_ŁA
 * YACBf[^̃L[v[[ɃZbg܂Bj<br>
 * ̍ہȀ́AACBf[^̃[hƂ͋tōs܂B<br>
 * iォ烍[hꂽf[^DIɌs܂Bj<br>
 * <br>
 * ::criAtomExPlayer_SetCueId ֐ŃL[ZbgꍇAȉ̊֐Őݒ肳ꂽ
 * p[^[͖܂B<br>
 * 	- ::criAtomExPlayer_SetFormat
 * 	- ::criAtomExPlayer_SetNumChannels
 * 	- ::criAtomExPlayer_SetSamplingRate
 * 	
 * itH[}bg`lATvO[g̏́A
 * ACB t@C̏ɎIɃZbg܂Bj<br>
 * \sa criAtomExPlayer_Start
 */
void CRIAPI criAtomExPlayer_SetCueId(
	CriAtomExPlayerHn player, CriAtomExAcbHn acb_hn, CriAtomExCueId id);

/*JP
 * \brief f[^̃ZbgiL[wj
 * \ingroup ATOMEXLIB_PLAYER
 * \param[in]	player			AtomExv[[nh
 * \param[in]	acb_hn			ACBnh
 * \param[in]	cue_name		L[
 * L[AAtomExv[[Ɋ֘At܂B<br>
 * {֐ŃL[wA ::criAtomExPlayer_Start ֐ōĐ
 * JnƁAw肳ꂽL[Đ܂B
 * \par :
 * \code
 * main()
 * {
 * 		:
 * 	// f[^Zbg
 * 	criAtomExPlayer_SetCueName(player, acb_hn, "gun_shot");
 * 	
 * 	// Zbgꂽf[^Đ
 * 	criAtomExPlayer_Start(player);
 * 		:
 * }
 * \endcode
 * AUZbgf[^̏́Ãf[^Zbg܂AtomExv[[ɕێ
 * ܂B<br>
 * ̂߁Af[^xĐꍇɂ́AĐɃf[^ZbgȂKv
 * ͂܂B
 * \par l:
 * 2i ach_hn j NULL w肵ꍇASĂACBf[^ΏۂɁAw肵L[
 * vf[^݂̑鏈삵܂B<br>
 * iw肵L[ACBf[^_ŁA
 * YACBf[^̃L[v[[ɃZbg܂Bj<br>
 * ̍ہȀ́AACBf[^̃[hƂ͋tōs܂B<br>
 * iォ烍[hꂽf[^DIɌs܂Bj<br>
 * <br>
 * ::criAtomExPlayer_SetCueName ֐ŃL[ZbgꍇAȉ̊֐Őݒ肳ꂽ
 * p[^[͖܂B<br>
 * 	- ::criAtomExPlayer_SetFormat
 * 	- ::criAtomExPlayer_SetNumChannels
 * 	- ::criAtomExPlayer_SetSamplingRate
 * 	
 * itH[}bg`lATvO[g̏́A
 * ACB t@C̏ɎIɃZbg܂Bj<br>
 * \sa criAtomExPlayer_Start
 */
void CRIAPI criAtomExPlayer_SetCueName(
	CriAtomExPlayerHn player, CriAtomExAcbHn acb_hn, const CriChar8 *cue_name);

/*JP
 * \brief f[^̃ZbgiL[CfbNXwj
 * \ingroup ATOMEXLIB_PLAYER
 * \param[in]	player			AtomExv[[nh
 * \param[in]	acb_hn			ACBnh
 * \param[in]	index			L[CfbNX
 * L[CfbNXAAtomExv[[Ɋ֘At܂B<br>
 * {֐ŃL[CfbNXwA ::criAtomExPlayer_Start ֐ōĐ
 * JnƁAw肳ꂽL[Đ܂B
 * \par :
 * \code
 * main()
 * {
 * 		:
 * 	// f[^Zbg
 * 	criAtomExPlayer_SetCueIndex(player, acb_hn, 300);
 * 	
 * 	// Zbgꂽf[^Đ
 * 	criAtomExPlayer_Start(player);
 * 		:
 * }
 * \endcode
 * AUZbgf[^̏́Ãf[^Zbg܂AtomExv[[ɕێ
 * ܂B<br>
 * ̂߁Af[^xĐꍇɂ́AĐɃf[^ZbgȂKv
 * ͂܂B
 * \par l:
 * 2i ach_hn j NULL w肵ꍇASĂACBf[^ΏۂɁAw肵L[CfbNX
 * vf[^݂̑鏈삵܂B<br>
 * iw肵L[CfbNXACBf[^_ŁA
 * YACBf[^̃L[v[[ɃZbg܂Bj<br>
 * ̍ہȀ́AACBf[^̃[hƂ͋tōs܂B<br>
 * iォ烍[hꂽf[^DIɌs܂Bj<br>
 * <br>
 * ::criAtomExPlayer_SetCueIndex ֐ŃL[ZbgꍇAȉ̊֐Őݒ肳ꂽ
 * p[^[͖܂B<br>
 * 	- ::criAtomExPlayer_SetFormat
 * 	- ::criAtomExPlayer_SetNumChannels
 * 	- ::criAtomExPlayer_SetSamplingRate
 * 	
 * itH[}bg`lATvO[g̏́A
 * ACB t@C̏ɎIɃZbg܂Bj<br>
 * <br>
 * {֐gp邱ƂŁAL[L[IDw肹Ƀv[[ɑ΂
 * Zbg邱Ƃ\łB<br>
 * iL[L[ID킩ȂꍇłAACBt@C̃RecʂĐ
 * \Ȃ̂ŁAfobOprɗp\łBj<br>
 * \sa criAtomExPlayer_Start
 */
void CRIAPI criAtomExPlayer_SetCueIndex(
	CriAtomExPlayerHn player, CriAtomExAcbHn acb_hn, CriAtomExCueIndex index);

/*JP
 * \brief f[^̃ZbgiIf[^̎wj
 * \ingroup ATOMEXLIB_PLAYER
 * \param[in]	player			AtomExv[[nh
 * \param[in]	buffer			obt@[AhX
 * \param[in]	size			obt@[TCY
 * \par :
 * ɔzuꂽf[^AAtomExv[[Ɋ֘At܂B<br>
 * {֐ŃAhXƃTCYwA ::criAtomExPlayer_Start ֐ōĐ
 * JnƁAw肳ꂽf[^Đ܂B
 * \par :
 * \code
 * main()
 * {
 * 		:
 * 	// f[^Zbg
 * 	criAtomExPlayer_SetData(player, buffer, buffer_size);
 * 	
 * 	// Đ鉹f[^̃tH[}bgw
 * 	criAtomExPlayer_SetFormat(player, CRIATOMEX_FORMAT_ADX);
 * 	criAtomExPlayer_SetNumChannels(player, 1);
 * 	criAtomExPlayer_SetSamplingRate(player, 24000);
 * 	
 * 	// Zbgꂽf[^Đ
 * 	criAtomExPlayer_Start(player);
 * 		:
 * }
 * \endcode
 * AUZbgf[^̏́Ãf[^Zbg܂AtomExv[[ɕێ
 * ܂B<br>
 * ̂߁Af[^xĐꍇɂ́AĐɃf[^ZbgȂKv
 * ͂܂B
 * \attention
 * v[[L̂̓obt@[̃AhXƃTCŶ݂łB<br>
 * iobt@[̃f[^Rs[킯ł͂܂Bj<br>
 * ̂߁Aw肵f[^̍ĐI܂ł̊ԁA
 * AvP[VŃobt@[ێKv܂B<br>
 * <br>
 * ĐsĂAtomExv[[~ꍇłA
 * Cuɂ͓ŸQƂĂ{CX݂\܂B<br>
 * {֐ŃZbg̈ۂɂ́AO ::criAtomEx_IsDataPlaying
 * ֐sAŸւ̎QƂsĂȂƂmFĂB
 * <br>
 * ::criAtomExPlayer_SetData ֐ŉf[^ZbgꍇAȉ̊֐gp
 * Đ鉹f[^̏ʓrw肷Kv܂B<br>
 * 	- ::criAtomExPlayer_SetFormat
 * 	- ::criAtomExPlayer_SetNumChannels
 * 	- ::criAtomExPlayer_SetSamplingRate
 * 	
 * \sa criAtomExPlayer_SetFormat, criAtomExPlayer_Start, criAtomEx_IsDataPlaying
 */
void CRIAPI criAtomExPlayer_SetData(
	CriAtomExPlayerHn player, void *buffer, CriSint32 size);

/*JP
 * \brief f[^̃Zbgit@C̎wj
 * \ingroup ATOMEXLIB_PLAYER
 * \param[in]	player		AtomExv[[nh
 * \param[in]	binder		oC_[nh
 * \param[in]	path		t@CpX
 * \par :
 * t@CAtomExv[[Ɋ֘At܂B<br>
 * {֐Ńt@CwA ::criAtomExPlayer_Start ֐ōĐJnƁA
 * w肳ꂽt@CXg[~OĐ܂B<br>
 * A{֐s_ł́At@C̓ǂݍ݂͊Jn܂B<br>
 * t@C̓ǂݍ݂Jn̂́A ::criAtomExPlayer_Start ֐słB<br>
 * \par :
 * \code
 * main()
 * {
 * 		:
 * 	// t@CZbg
 * 	criAtomExPlayer_SetFile(player, NULL, "sample.hca");
 * 	
 * 	// Đ鉹f[^̃tH[}bgw
 * 	criAtomExPlayer_SetFormat(player, CRIATOMEX_FORMAT_HCA);
 * 	criAtomExPlayer_SetNumChannels(player, 2);
 * 	criAtomExPlayer_SetSamplingRate(player, 48000);
 * 	
 * 	// Zbgꂽf[^Đ
 * 	criAtomExPlayer_Start(player);
 * 		:
 * }
 * \endcode
 * AUZbgt@C̏́Ãf[^Zbg܂AtomExv[[ɕێ
 * ܂B<br>
 * ̂߁Af[^xĐꍇɂ́AĐɃf[^ZbgȂKv
 * ͂܂B
 * \par lF
 * f[^CPKɃpbNĂȂꍇAbinderɂNULLw肵ĂB<br>
 * \attention
 * ::criAtomExPlayer_SetFile ֐sƁA
 * w肵pXAtomExv[[ɕێ܂B<br>
 * AtomExv[[̓ftHgԂł̓pXێ̈1mۂ܂B<br>
 * iTCY팸̂߁Bj<br>
 * At@CĐɕʂ̃t@CAtomExv[[ɃZbgꍇA
 * Đ̃t@CƃZbgt@C̗̃pXێKv邽߁A
 * 2̃pXۑ̈悪KvɂȂ܂B<br>
 * 2ȏ̃t@C𓯎ɍĐꍇɂ́Av[[쐬Ɏw肷
 * max_path_strings ̐𑝂₷Kv܂B<br>
 * max_path_strings ̐𑝂₷ƂŁAAtomExv[[͎w肳ꂽ
 * pX𓯎ɕۑł悤ɂȂ܂B<br>
 * imax_path_strings 2ȏ̒lw肷邱ƂŁA
 * 1̃v[[ŕ̃t@C𓯎ɃpXwōĐ邱Ƃ\ƂȂ܂Bj<br>
 * A max_path_strings ̒lɉĕKvȃ[N̈̃TCY͑܂B<br>
 * <br>
 * ::criAtomExPlayer_SetFile ֐ŉf[^ZbgꍇAȉ̊֐gp
 * Đ鉹f[^̏ʓrw肷Kv܂B<br>
 * 	- ::criAtomExPlayer_SetFormat
 * 	- ::criAtomExPlayer_SetNumChannels
 * 	- ::criAtomExPlayer_SetSamplingRate
 * 	
 * \sa CriAtomExPlayerConfig, criAtomExPlayer_Create, criAtomExPlayer_Start
 */
void CRIAPI criAtomExPlayer_SetFile(
	CriAtomExPlayerHn player, CriFsBinderHn binder, const CriChar8 *path);

/*JP
 * \brief f[^̃ZbgiCPKRecID̎wj
 * \ingroup ATOMEXLIB_PLAYER
 * \param[in]	player		AtomExv[[nh
 * \param[in]	binder		oC_[nh
 * \param[in]	id			RecID
 * \par :
 * RecAtomExv[[Ɋ֘At܂B<br>
 * CRI File SystemCugpCPKt@C̃Rect@C
 * IDwōĐ邽߂Ɏgp܂B<br>
 * {֐ɃoC_[ƃRecIDwA ::criAtomExPlayer_Start ֐ōĐ
 * JnƁAw肳ꂽRect@CXg[~OĐ܂B<br>
 * A{֐s_ł́At@C̓ǂݍ݂͊Jn܂B<br>
 * t@C̓ǂݍ݂Jn̂́A ::criAtomExPlayer_Start ֐słB<br>
 * \par :
 * \code
 * main()
 * {
 * 		:
 * 	// CPKt@CoCh
 * 	criFsBinder_BindCpk(binder, "sample.cpk", work, work_size, &bind_id);
 * 	
 * 	// oCh҂
 * 	for (;;) {
 * 		// Xe[^X̃`FbN
 * 		criFsBinder_GetStatus(binder, &status);
 * 		if (status == CRIFSBINDER_STATUS_COMPLETE) {
 * 			break;
 * 		}
 * 		
 * 		// T[o[̎s
 * 		criFs_ExecuteMain();
 * 		
 * 		// Vsync҂
 * 			:
 * 	}
 * 		:
 * 	// t@CZbg
 * 	// sample.cpk1Ԃ̃RecZbg
 * 	criAtomExPlayer_SetContentId(player, binder, 1);
 * 	
 * 	// Đ鉹f[^̃tH[}bgw
 * 	criAtomExPlayer_SetFormat(player, CRIATOMEX_FORMAT_ADX);
 * 	criAtomExPlayer_SetNumChannels(player, 2);
 * 	criAtomExPlayer_SetSamplingRate(player, 44100);
 * 	
 * 	// Zbgꂽf[^Đ
 * 	criAtomExPlayer_Start(player);
 * 		:
 * }
 * \endcode
 * AUZbgt@C̏́Ãf[^Zbg܂AtomExv[[ɕێ
 * ܂B<br>
 * ̂߁Af[^xĐꍇɂ́AĐɃf[^ZbgȂKv
 * ͂܂B
 * \par lF
 * f[^CPKɃpbNĂȂꍇAbinderɂNULLw肵ĂB<br>
 * \attention
 * ::criAtomExPlayer_SetContentId ֐ŉf[^ZbgꍇAȉ̊֐gp
 * Đ鉹f[^̏ʓrw肷Kv܂B<br>
 * 	- ::criAtomExPlayer_SetFormat
 * 	- ::criAtomExPlayer_SetNumChannels
 * 	- ::criAtomExPlayer_SetSamplingRate
 * 	
 * \sa CriAtomExPlayerConfig, criAtomExPlayer_Create, criAtomExPlayer_Start
 */
void CRIAPI criAtomExPlayer_SetContentId(
	CriAtomExPlayerHn player, CriFsBinderHn binder, CriSint32 id);

/*JP
 * \brief f[^̃Zbgig`f[^ID̎wj
 * \ingroup ATOMEXLIB_PLAYER
 * \param[in]	player		AtomExv[[nh
 * \param[in]	awb			AWBnh
 * \param[in]	id			g`f[^ID
 * \par :
 * Đg`f[^AtomExv[[Ɋ֘At܂B<br>
 * {֐AWBnhƔg`f[^IDwA ::criAtomExPlayer_Start ֐ōĐ
 * JnƁAw肵g`f[^Xg[~OĐ܂B<br>
 * A{֐s_ł́At@C̓ǂݍ݂͊Jn܂B<br>
 * t@C̓ǂݍ݂Jn̂́A ::criAtomExPlayer_Start ֐słB<br>
 * \par :
 * \code
 * main()
 * {
 * 		:
 * 	// AWBTOC[hAWBnh쐬
 * 	awb = criAtomAwb_LoadToc(NULL, "sample.awb", NULL, 0);
 * 		:
 * 	// g`f[^Zbg
 * 	// AWB1Ԃ̔g`f[^Zbg
 * 	criAtomExPlayer_SetWaveId(player, awb, 1);
 * 	
 * 	// Đ鉹f[^̃tH[}bgw
 * 	criAtomExPlayer_SetFormat(player, CRIATOMEX_FORMAT_HCA_MX);
 * 	criAtomExPlayer_SetNumChannels(player, 2);
 * 	criAtomExPlayer_SetSamplingRate(player, 32000);
 * 	
 * 	// Zbgꂽf[^Đ
 * 	criAtomExPlayer_Start(player);
 * 		:
 * }
 * \endcode
 * AUZbgt@C̏́Ãf[^Zbg܂AtomExv[[ɕێ
 * ܂B<br>
 * ̂߁Af[^xĐꍇɂ́AĐɃf[^ZbgȂKv
 * ͂܂B
 * \attention
 * {֐ŉf[^ZbgꍇA
 * ȉ̊֐gpčĐ鉹f[^̏ʓrw肷Kv܂B<br>
 * 	- ::criAtomExPlayer_SetFormat
 * 	- ::criAtomExPlayer_SetNumChannels
 * 	- ::criAtomExPlayer_SetSamplingRate
 * 	
 * <br>
 * {֐ŃZbgĐɁA ::criAtomAwb_Release ֐Ńf[^jȂłB<br>
 * AWBt@Cjۂɂ́AKĐ~Ԃ ::criAtomAwb_Release ֐sĂB<br>
 * \sa CriAtomExPlayerConfig, criAtomExPlayer_Create, criAtomExPlayer_Start
 */
void CRIAPI criAtomExPlayer_SetWaveId(
	CriAtomExPlayerHn player, CriAtomAwbHn awb, CriAtomExWaveId id);

/*JP
 * \brief Đ̊Jn
 * \ingroup ATOMEXLIB_PLAYER
 * \param[in]	player		AtomExv[[nh
 * \return		CriAtomExPlaybackId		ĐID
 * \par :
 * f[^̍ĐJn܂B<br>
 * {֐sOɁAO ::criAtomExPlayer_SetData ֐gpAĐ
 * f[^AtomExv[[ɃZbgĂKv܂B<br>
 * Ⴆ΁AỈf[^Đꍇɂ́Aȉ̂悤ɎO
 * ::criAtomExPlayer_SetData ֐gĉf[^ZbgA{֐s
 * Kv܂B<br>
 * \code
 * main()
 * {
 * 		:
 * 	// f[^Zbg
 * 	criAtomExPlayer_SetData(player, buffer, buffer_size);
 * 	
 * 	// Đ鉹f[^̃tH[}bgw
 * 	criAtomExPlayer_SetFormat(player, CRIATOMEX_FORMAT_HCA_MX);
 * 	criAtomExPlayer_SetNumChannels(player, 1);
 * 	criAtomExPlayer_SetSamplingRate(player, 24000);
 * 	
 * 	// Zbgꂽf[^Đ
 * 	criAtomExPlayer_Start(player);
 * 		:
 * }
 * \endcode
 * {֐sAĐ̐i݋iJnꂽAĐjǂȂ
 * 邩́AXe[^X擾邱ƂŊmF\łB<br>
 * Xe[^X̎擾ɂ́A ::criAtomExPlayer_GetStatus ֐gp܂B<br>
 * ::criAtomExPlayer_GetStatus ֐͈ȉ5ʂ̃Xe[^XԂ܂B<br>
 * 	-# CRIATOMEXPLAYER_STATUS_STOP
 * 	-# CRIATOMEXPLAYER_STATUS_PREP
 * 	-# CRIATOMEXPLAYER_STATUS_PLAYING
 * 	-# CRIATOMEXPLAYER_STATUS_PLAYEND
 * 	-# CRIATOMEXPLAYER_STATUS_ERROR
 * 	
 * AtomExv[[쐬_ł́AAtomExv[[̃Xe[^X͒~
 * i CRIATOMEXPLAYER_STATUS_STOP jłB<br>
 * Đ鉹f[^ZbgA{֐s邱ƂŁAAtomExv[[̃Xe[^X
 * ԁi CRIATOMEXPLAYER_STATUS_PREP jɕύX܂B<br>
 * iCRIATOMEXPLAYER_STATUS_PREP ́Af[^fR[h̊Jn҂ĂԂłBj<br>
 * Đ̊Jnɏ[ȃf[^ꂽ_ŁAAtomExv[[̓Xe[^X
 * Đԁi CRIATOMEXPLAYER_STATUS_PLAYING jɕύXȀo͂Jn܂B<br>
 * Zbgꂽf[^SčĐIƁAAtomExv[[̓Xe[^XĐI
 * i CRIATOMEXPLAYER_STATUS_PLAYEND jɕύX܂B<br>
 * AĐɃG[ꍇɂ́AAtomExv[[̓Xe[^XG[
 * i CRIATOMEXPLAYER_STATUS_ERROR jɕύX܂B<br>
 * <br>
 * AtomExv[[̃Xe[^X`FbNAXe[^Xɉď؂ւ邱ƂŁA
 * ̍ĐԂɘAvO쐬邱Ƃ\łB<br>
 * Ⴆ΁A̍Đ҂ďi߂ꍇɂ́Aȉ̂悤ȃR[hɂȂ܂B
 * \code
 * main()
 * {
 * 		:
 * 	// f[^Zbg
 * 	criAtomExPlayer_SetData(player, buffer, buffer_size);
 * 	
 * 	// Đ鉹f[^̃tH[}bgw
 * 	criAtomExPlayer_SetFormat(player, CRIATOMEX_FORMAT_ADX);
 * 	criAtomExPlayer_SetNumChannels(player, 1);
 * 	criAtomExPlayer_SetSamplingRate(player, 22050);
 * 	
 * 	// Zbgꂽf[^Đ
 * 	criAtomExPlayer_Start(player);
 * 	
 * 	// Đ҂
 * 	for (;;) {
 * 		// Xe[^X̎擾
 * 		status = criAtomExPlayer_GetStatus(player);
 * 		
 * 		// Xe[^X̃`FbN
 * 		if (status == CRIATOMEXPLAYER_STATUS_PLAYEND) {
 * 			// ĐI̓[v𔲂
 * 			break;
 * 		}
 * 		
 * 		// T[o[̎s
 * 		criAtomEx_ExecuteMain();
 * 		
 * 		// ʕ\̍XV
 * 			:
 * 	}
 * 		:
 * }
 * \endcode
 * \par l:
 * ֐sɔ\[XmۂłȂꍇiSẴ{CXgpŁAȂ
 * ̃{CXDȂꍇjA{֐ CRIATOMEX_INVALID_PLAYBACK_ID Ԃ܂B<br>
 * A߂lɃG[`FbNsȂĂAقƂǂ̃P[XŖ͔܂B<br>
 * ĐIDi ::CriAtomExPlaybackId jgp API ɑ΂A CRIATOMEX_INVALID_PLAYBACK_ID 
 * ZbgƂĂAAtomCu͓ɉ܂B<br>
 * ̂߁AfobOړIŔsꂽǂ`FbNꍇA
 * {֐̌ʂɉăAvP[Vŏ؂蕪Kv͂܂B<br>
 * i CRIATOMEX_INVALID_PLAYBACK_ID ԂꂽۂɁALȍĐIDԂꂽꍇ
 * l̏sĂAG[R[obN͔܂Bj
 * \sa criAtomExPlayer_SetData, criAtomExPlayer_SetFile, criAtomExPlayer_GetStatus,
 * criAtomExPlayer_Pause, criAtomEx_ExecuteMain
 */
CriAtomExPlaybackId CRIAPI criAtomExPlayer_Start(CriAtomExPlayerHn player);

/*JP
 * \brief Đ̏
 * \ingroup ATOMEXLIB_PLAYER
 * \param[in]	player		AtomExv[[nh
 * \return		CriAtomExPlaybackId		ĐID
 * \par :
 * f[^̍Đ܂B<br>
 * {֐sOɁAO ::criAtomExPlayer_SetData ֐gpA
 * Đׂf[^AtomExv[[ɃZbgĂKv܂B<br>
 * <br>
 * {֐sƁA|[YԂŉ̍ĐJn܂B<br>
 * ֐s̃^C~OŉĐɕKvȃ\[XmۂA
 * obt@OiXg[Đst@C̓ǂݍ݁jJn܂A
 * obt@O͍s܂B<br>
 * i\ȏԂɂȂĂA|[YԂőҋ@܂Bj<br>
 * <br>
 * 1ĐP[Xł́A{֐͈ȉ̃R[hƓ܂B<br>
 * \code
 * 		F
 * 	// v[[|[YԂɐݒ
 * 	criAtomExPlayer_Pause(player, CRI_TRUE);
 * 	
 * 	// ̍ĐJn
 * 	id = criAtomExPlayer_Start(player);
 * 		F
 * \endcode
 * <br>
 * {֐ōĐs𔭉ɂ́A
 * {֐ԂĐ ID i ::CriAtomExPlaybackId jɑ΂A
 * ::criAtomExPlayback_Pause (id, CRI_FALSE); ̑sKv܂B<br>
 * \par l:
 * Xg[~OĐ̉ĐہA{֐gp ::criAtomExPlayer_Start ֐gpꍇA
 * ۂɉ̍ĐJn܂łɂ̓^CO܂B<br>
 * if[^̃obt@OɎԂ邽߁Bj<br>
 * {֐gp邱ƂŁAXg[Đ̉ɂĂÃ^C~O
 * 䂷邱Ƃ\ɂȂ܂B
 * <br>
 * 菇̊Tv́Aȉ̂ƂłB<br>
 * \code
 * main()
 * {
 * 		:
 * 	// f[^Zbg
 * 	criAtomExPlayer_SetFile(player, NULL, "sample.adx");
 * 	
 * 	// Đ鉹f[^̃tH[}bgw
 * 	criAtomExPlayer_SetFormat(player, CRIATOMEX_FORMAT_ADX);
 * 	criAtomExPlayer_SetNumChannels(player, 2);
 * 	criAtomExPlayer_SetSamplingRate(player, 48000);
 * 	
 * 	// Zbgꂽf[^̍ĐJn
 * 	playback_id = criAtomExPlayer_Prepare(player);
 * 		:
 * 	// Đ҂
 * 	for (;;) {
 * 		// ĐXe[^X`FbN
 * 		playback_status = criAtomExPlayback_GetStatus(playback_id);
 * 		if (playback_status == CRIATOMEXPLAYBACK_STATUS_PLAYING) {
 * 			// Xe[^XĐԂɂȂ_Ń[v𔲂
 * 			break;
 * 		}
 * 		
 * 		// T[o[̎s
 * 		criAtomEx_ExecuteMain();
 * 		
 * 		// ʕ\̍XV
 * 			:
 * 	}
 * 	
 * 	// |[Y
 * 	criAtomExPlayback_Pause(playback_id, CRI_FALSE);
 * 		:
 * }
 * \endcode
 * |[Y ::criAtomExPlayback_Pause ֐gpꍇA
 * {֐ɂĐ̂߂̃|[YƁA ::criAtomExPlayer_Pause
 * ֐ɂꎞ~̗܂B<br>
 * ::criAtomExPlayer_Pause ֐Ń|[Y~܂
 * {֐ōĐsĐꍇA|[Ỷ
 * ::criAtomExPlayer_Resume ֐i܂ ::criAtomExPlayback_Resume
 * ֐jpB<br>
 * \sa criAtomExPlayback_GetStatus, criAtomExPlayback_Pause
 */
CriAtomExPlaybackId CRIAPI criAtomExPlayer_Prepare(CriAtomExPlayerHn player);

/*JP
 * \brief Đ̒~
 * \ingroup ATOMEXLIB_PLAYER
 * \param[in]	player		AtomExv[[nh
 * \par :
 * Đ̒~v𔭍s܂B<br>
 * ĐAtomExv[[ɑ΂Ė{֐sƁA
 * AtomExv[[͍Đ~it@C̓ǂݍ݂A~jA
 * Xe[^X~ԁi CRIATOMEXPLAYER_STATUS_STOP jɑJڂ܂B<br>
 * \par l:
 * ɒ~ĂAtomExv[[iXe[^X CRIATOMEXPLAYER_STATUS_PLAYEND 
 * CRIATOMEXPLAYER_STATUS_ERROR AtomExv[[j ɑ΂Ė{֐sƁA
 * AtomExv[[̃Xe[^X CRIATOMEXPLAYER_STATUS_STOP ɕύX܂B
 * \attention
 * {֐͊A^̊֐ł͂܂B<br>
 * ̂߁A֐ŏԃubN邱Ƃ͂܂񂪁A
 * ֐𔲂_ł͍Đ~ĂȂ\_ɂӂB<br>
 * i~ԂɂȂ܂łɁAԂꍇ܂Bj<br>
 * ~ۏ؂Kvꍇɂ́A{֐ĂяoA
 * AtomExv[[̃Xe[^X~ԁiCRIATOMEXPLAYER_STATUS_STOPj
 * ɂȂ邱ƂmFĂB
 * \sa criAtomExPlayer_Start, criAtomExPlayer_GetStatus
 */
void CRIAPI criAtomExPlayer_Stop(CriAtomExPlayerHn player);

/*JP
 * \brief Đ̒~i[X^Cj
 * \ingroup ATOMEXLIB_PLAYER
 * \param[in]	player		AtomExv[[nh
 * \par :
 * Đ̒~v𔭍s܂B<br>
 * ̍ہAĐ̉ɃGx[ṽ[X^Cݒ肳ĂƂĂA
 * 𖳎Ē~܂B<br>
 * ĐAtomExv[[ɑ΂Ė{֐sƁA
 * AtomExv[[͍Đ~it@C̓ǂݍ݂A~jA
 * Xe[^X~ԁi CRIATOMEXPLAYER_STATUS_STOP jɑJڂ܂B<br>
 * \par l:
 * ɒ~ĂAtomExv[[iXe[^X CRIATOMEXPLAYER_STATUS_PLAYEND 
 * CRIATOMEXPLAYER_STATUS_ERROR AtomExv[[j ɑ΂Ė{֐sƁA
 * AtomExv[[̃Xe[^X CRIATOMEXPLAYER_STATUS_STOP ɕύX܂B
 * \attention
 * {֐͊A^̊֐ł͂܂B<br>
 * ̂߁A֐ŏԃubN邱Ƃ͂܂񂪁A
 * ֐𔲂_ł͍Đ~ĂȂ\_ɂӂB<br>
 * i~ԂɂȂ܂łɁAԂꍇ܂Bj<br>
 * ~ۏ؂Kvꍇɂ́A{֐ĂяoA
 * AtomExv[[̃Xe[^X~ԁiCRIATOMEXPLAYER_STATUS_STOPj
 * ɂȂ邱ƂmFĂB
 * \sa criAtomExPlayer_Start, criAtomExPlayer_GetStatus
 */
void CRIAPI criAtomExPlayer_StopWithoutReleaseTime(CriAtomExPlayerHn player);

/*JP
 * \brief SẴv[[̍Đ~
 * \ingroup ATOMEXLIB_PLAYER
 * \par :
 * SĂAtomExv[[ɑ΂AĐ̒~v𔭍s܂B<br>
 * {֐sƁAAtomExv[[͍Đ~it@C̓ǂݍ݂A~jA
 * Xe[^X~ԁi CRIATOMEXPLAYER_STATUS_STOP jɑJڂ܂B<br>
 * \par l:
 * ɒ~ĂAtomExv[[iXe[^X CRIATOMEXPLAYER_STATUS_PLAYEND 
 * CRIATOMEXPLAYER_STATUS_ERROR AtomExv[[j ɂĂA
 * {֐sƃXe[^X CRIATOMEXPLAYER_STATUS_STOP ɕύX܂B
 * \attention
 * {֐͊A^̊֐ł͂܂B<br>
 * ̂߁A֐ŏԃubN邱Ƃ͂܂񂪁A
 * ֐𔲂_ł͍Đ~ĂȂ\_ɂӂB<br>
 * i~ԂɂȂ܂łɁAԂꍇ܂Bj<br>
 * ~ۏ؂Kvꍇɂ́A{֐ĂяoA
 * AtomExv[[̃Xe[^X~ԁiCRIATOMEXPLAYER_STATUS_STOPj
 * ɂȂ邱ƂmFĂB
 * \sa criAtomExPlayer_Start, criAtomExPlayer_GetStatus
 */
void CRIAPI criAtomExPlayer_StopAllPlayers(void);

/*JP
 * \brief SẴv[[̍Đ~i[X^Cj
 * \ingroup ATOMEXLIB_PLAYER
 * \par :
 * SĂAtomExv[[ɑ΂AĐ̒~v𔭍s܂B<br>
 * ̍ہAĐ̉ɃGx[ṽ[X^Cݒ肳ĂƂĂA
 * 𖳎Ē~܂B<br>
 * {֐sƁAAtomExv[[͍Đ~it@C̓ǂݍ݂A~jA
 * Xe[^X~ԁi CRIATOMEXPLAYER_STATUS_STOP jɑJڂ܂B<br>
 * \par l:
 * ɒ~ĂAtomExv[[iXe[^X CRIATOMEXPLAYER_STATUS_PLAYEND 
 * CRIATOMEXPLAYER_STATUS_ERROR AtomExv[[j ɂĂA
 * {֐sƃXe[^X CRIATOMEXPLAYER_STATUS_STOP ɕύX܂B
 * \attention
 * {֐͊A^̊֐ł͂܂B<br>
 * ̂߁A֐ŏԃubN邱Ƃ͂܂񂪁A
 * ֐𔲂_ł͍Đ~ĂȂ\_ɂӂB<br>
 * i~ԂɂȂ܂łɁAԂꍇ܂Bj<br>
 * ~ۏ؂Kvꍇɂ́A{֐ĂяoA
 * AtomExv[[̃Xe[^X~ԁiCRIATOMEXPLAYER_STATUS_STOPj
 * ɂȂ邱ƂmFĂB
 * \sa criAtomExPlayer_Start, criAtomExPlayer_GetStatus
 */
void CRIAPI criAtomExPlayer_StopAllPlayersWithoutReleaseTime(void);

/*JP
 * \brief v[[̗
 * \ingroup ATOMEXLIB_PLAYER
 * \param[in]	func		v[[R[obN֐
 * \param[in]	obj			[UwIuWFNg
 * \par :
 * AvP[VŊmۂv[[񋓂܂B<br>
 * <br>
 * {֐sƁA 1 i func j
 * ŃZbgꂽR[obN֐AtomExv[[̐Ăяo܂B<br>
 * iAtomExv[[nhAƂăR[obN֐ɓn܂Bj<br>
 * \par l:
 *  2 i obj jɃZbgĺAR[obN֐̈Ƃēn܂B<br>
 * R[obN֐̂̑̈ɂẮA
 * ʓr ::CriAtomExPlayerCbFunc ̐QƂB<br>
 * \sa CriAtomExPlayerCbFunc
 */
void CRIAPI criAtomExPlayer_EnumeratePlayers(CriAtomExPlayerCbFunc func, void *obj);

/*JP
 * \brief |[Y^|[Y
 * \ingroup ATOMEXLIB_PLAYER
 * \param[in]	player		AtomExv[[nh
 * \param[in]	sw			XCb`iCRI_FALSE = |[YACRI_TRUE = |[Yj
 * \par :
 * Đ̃|[Y^|[Ys܂B<br>
 * sw  CRI_TRUE w肵Ė{֐sƁAAtomExv[[͍Đ
 * |[Yiꎞ~j܂B<br>
 * sw  CRI_FALSE w肵Ė{֐sƁAAtomExv[[̓|[Y
 * Aꎞ~Ă̍ĐĊJ܂B<br>
 * \par l:
 * ftHgԁiv[[쐬̏ԁjł́A|[Y͉Ă܂B<br>
 * \attention
 * 2iswj CRI_FALSE w肵ă|[Y̑sꍇA
 * {֐Ń|[YłȂA::criAtomExPlayer_Prepare 
 * ֐ōĐ̉ɂĂĐJnĂ܂܂B<br>
 * io[WƂ̌݊ێ̂߂̎dlłBj<br>
 * {֐Ń|[YɂĂ̂݃|[YꍇA
 * {֐gpA criAtomExPlayer_Resume(player, CRIATOMEX_RESUME_PAUSED_PLAYBACK);
 * să|[YsĂB<br>
 * <br>
 * {֐sƁAv[[ōĐĂ"SĂ"ɑ΂ă|[Y^|[Y
 * ̏s܂B<br>
 * Đ̌X̉ɑ΂AʂɃ|[Y^|[Y̏sꍇɂ́A
 * ::criAtomExPlayback_Pause ֐pB
 * \sa criAtomExPlayer_IsPaused, criAtomExPlayback_Pause, criAtomExPlayer_Resume
 */
void CRIAPI criAtomExPlayer_Pause(CriAtomExPlayerHn player, CriBool sw);

/*JP
 * \brief |[Y
 * \ingroup ATOMEXLIB_PLAYER
 * \param[in]	player		AtomExv[[nh
 * \param[in]	mode		|[YΏ
 * \par :
 * ꎞ~Ԃ̉s܂B<br>
 * ::criAtomExPlayer_Pause ֐ƈقȂA ::criAtomExPlayer_Prepare
 * ֐ōĐJn҂̉ƁA ::criAtomExPlayer_Pause ֐i܂ 
 * ::criAtomExPlayback_Pause ֐Ń|[YƂA
 * ʂɍĊJ邱Ƃ\łB<br>
 * <br>
 * 2imodej ::CRIATOMEX_RESUME_PAUSED_PLAYBACK w肵Ė{֐sƁA
 * [U ::criAtomExPlayer_Pause ֐i܂ ::criAtomExPlayback_Pause 
 * ֐jňꎞ~ԂɂȂ̍ĐĊJ܂B<br>
 * 2imodej ::CRIATOMEX_RESUME_PREPARED_PLAYBACK w肵Ė{֐sƁA
 * [U ::criAtomExPlayer_Prepare ֐ōĐw̍ĐJn܂B<br>
 * <br>
 * ::criAtomExPlayer_Pause ֐Ń|[YԂ̃v[[ɑ΂ ::criAtomExPlayer_Prepare
 * ֐ōĐsꍇẢ ::CRIATOMEX_RESUME_PAUSED_PLAYBACK
 * w̃|[YƁA ::CRIATOMEX_RESUME_PREPARED_PLAYBACK
 * w̃|[Y̗s܂ŁAĐJn܂B<br>
 * \par l:
 * ::criAtomExPlayer_Pause ֐ ::criAtomExPlayer_Prepare ֐Ɋ֌WȂA
 * ɍĐJnꍇɂ́A2imodej ::CRIATOMEX_RESUME_ALL_PLAYBACK
 * w肵Ė{֐s邩A܂ criAtomExPlayer_Pause(player, CRI_FALSE);
 * sĂB<br>
 * \attention
 * {֐sƁAv[[ōĐĂ"SĂ"ɑ΂ă|[Y
 * ̏s܂B<br>
 * Đ̌X̉ɑ΂AʂɃ|[Y̏sꍇɂ́A
 * ::criAtomExPlayback_Resume ֐pB
 * \sa criAtomExPlayback_Resume, criAtomExPlayer_Pause
 */
void CRIAPI criAtomExPlayer_Resume(CriAtomExPlayerHn player, CriAtomExResumeMode mode);

/*JP
 * \brief |[YԂ̎擾
 * \ingroup ATOMEXLIB_PLAYER
 * \param[in]	player		AtomExv[[nh
 * \return		CriBool		|[YǂiCRI_FALSE = |[YĂȂACRI_TRUE = |[Yj
 * \par :
 * v[[|[YǂԂ܂B<br>
 * \attention
 * {֐ CRI_TRUE Ԃ̂́AuSĂ̍Đ|[Y̏ꍇv݂̂łB<br>
 * ::criAtomExPlayer_Pause ֐sAĐIDwŌX̉̃|[Y
 * i ::criAtomExPlayback_Pause ֐sjꍇA{֐ CRI_FALSE 
 * Ԃ܂B<br>
 * <br>
 * {֐ ::criAtomExPlayer_Pause ֐Ń|[YꂽƁA
 * ::criAtomExPlayer_Prepare ֐Ń|[YꂽƂʂ܂B<br>
 * i|[Y@Ɋ֌WȂASĂ̍Đ|[YĂ邩ǂ݂̂𔻒肵܂Bj<br>
 * \sa criAtomExPlayer_Pause, criAtomExPlayback_Pause
 */
CriBool CRIAPI criAtomExPlayer_IsPaused(CriAtomExPlayerHn player);

/*JP
 * \brief Xe[^X̎擾
 * \ingroup ATOMEXLIB_PLAYER
 * \param[in]	player		AtomExv[[nh
 * \return		CriAtomExPlayerStatus	Xe[^X
 * \par :
 * AtomExv[[̃Xe[^X擾܂B<br>
 * Xe[^XAtomExv[[̍ĐԂlŁAȉ5ʂ̒l݂܂B<br>
 * -# CRIATOMEXPLAYER_STATUS_STOP
 * -# CRIATOMEXPLAYER_STATUS_PREP
 * -# CRIATOMEXPLAYER_STATUS_PLAYING
 * -# CRIATOMEXPLAYER_STATUS_PLAYEND
 * -# CRIATOMEXPLAYER_STATUS_ERROR
 * 
 * AtomExv[[쐬_ł́AAtomExv[[̃Xe[^X͒~
 * i CRIATOMEXPLAYER_STATUS_STOP jłB<br>
 * Đ鉹f[^ZbgA::criAtomExPlayer_Start ֐s邱ƂŁA
 * AtomExv[[̃Xe[^Xԁi CRIATOMEXPLAYER_STATUS_PREP jɕύX܂B<br>
 * iCRIATOMEXPLAYER_STATUS_PREP ́Af[^fR[h̊Jn҂ĂԂłBj<br>
 * Đ̊Jnɏ[ȃf[^ꂽ_ŁAAtomExv[[̓Xe[^X
 * Đԁi CRIATOMEXPLAYER_STATUS_PLAYING jɕύXȀo͂Jn܂B<br>
 * Zbgꂽf[^SčĐIƁAAtomExv[[̓Xe[^XĐI
 * i CRIATOMEXPLAYER_STATUS_PLAYEND jɕύX܂B<br>
 * AĐɃG[ꍇɂ́AAtomExv[[̓Xe[^XG[
 * i CRIATOMEXPLAYER_STATUS_ERROR jɕύX܂B<br>
 * <br>
 * AtomExv[[̃Xe[^X`FbNAXe[^Xɉď؂ւ邱ƂŁA
 * ̍ĐԂɘAvO쐬邱Ƃ\łB<br>
 * Ⴆ΁A̍Đ҂ďi߂ꍇɂ́Aȉ̂悤ȃR[hɂȂ܂B
 * \code
 * main()
 * {
 * 		:
 * 	// f[^Zbg
 * 	criAtomExPlayer_SetData(player, buffer, buffer_size);
 * 	
 * 	// Đ鉹f[^̃tH[}bgw
 * 	criAtomExPlayer_SetFormat(player, CRIATOMEX_FORMAT_ADX);
 * 	criAtomExPlayer_SetNumChannels(player, 1);
 * 	criAtomExPlayer_SetSamplingRate(player, 24000);
 * 	
 * 	// Zbgꂽf[^Đ
 * 	criAtomExPlayer_Start(player);
 * 	
 * 	// Đ҂
 * 	for (;;) {
 * 		// Xe[^X̎擾
 * 		status = criAtomExPlayer_GetStatus(player);
 * 		
 * 		// Xe[^X̃`FbN
 * 		if (status == CRIATOMEXPLAYER_STATUS_PLAYEND) {
 * 			// ĐI̓[v𔲂
 * 			break;
 * 		}
 * 		
 * 		// T[o[̎s
 * 		criAtomEx_ExecuteMain();
 * 		
 * 		// ʕ\̍XV
 * 			:
 * 	}
 * 		:
 * }
 * \endcode
 * \sa criAtomExPlayer_Start
 */
CriAtomExPlayerStatus CRIAPI criAtomExPlayer_GetStatus(CriAtomExPlayerHn player);

/*JP
 * \brief Đ̗̉
 * \ingroup ATOMEXLIB_PLAYER
 * \param[in]	player		AtomExv[[nh
 * \param[in]	func		vCobNR[obN֐
 * \param[in]	obj			[UwIuWFNg
 * \par :
 * v[[ōĐ̃vCobN񋓂܂B<br>
 * <br>
 * {֐sƁA 2 i func j
 * ŃZbgꂽR[obN֐Đ̃vCobN̐Ăяo܂B<br>
 * ivCobNIDAƂăR[obN֐ɓn܂Bj<br>
 * \par l:
 *  3 i obj jɃZbgĺAR[obN֐̈Ƃēn܂B<br>
 * R[obN֐̂̑̈ɂẮA
 * ʓr ::CriAtomExPlaybackCbFunc ̐QƂB<br>
 * \sa CriAtomExPlaybackCbFunc
 */
void CRIAPI criAtomExPlayer_EnumeratePlaybacks(CriAtomExPlayerHn player, CriAtomExPlaybackCbFunc func, void* obj);

/*JP
 * \brief Đ̉̎擾
 * \ingroup ATOMEXLIB_PLAYER
 * \param[in]	player		AtomExv[[nh
 * \return		CriSint32	Đ
 * \par :
 * v[[ŌݍĐ̉̐擾܂B<br>
 * \par l:
 * {֐́A ::criAtomExPlayer_Start ֐ōĐsA݂LȍĐID̐Ԃ܂B<br>
 * i gp̃{CX̐ł͂܂B̔g`f[^܂ރV[PX1ĐꍇłA
 * 1ƃJEg܂Bj<br>
 * gp̃{CX擾ꍇɂ́A ::criAtomExVoicePool_GetNumUsedVoices ֐pB<br>
 * \sa criAtomExPlayer_Start, criAtomExVoicePool_GetNumUsedVoices
 */
CriSint32 CRIAPI criAtomExPlayer_GetNumPlaybacks(CriAtomExPlayerHn player);

/*JP
 * \brief ŏIĐID̎擾
 * \ingroup ATOMEXLIB_PLAYER
 * \param[in]	player		AtomExv[[nh
 * \return		CriSint32	ĐID
 * \par :
 * v[[ōŌɍĐ̍ĐID擾܂B<br>
 * \par l:
 * \sa criAtomExPlayer_Start
 */
CriAtomExPlaybackId CRIAPI criAtomExPlayer_GetLastPlaybackId(CriAtomExPlayerHn player);

/*JP
 * \brief Đ̎擾
 * \ingroup ATOMEXLIB_PLAYER
 * \param[in]	player		AtomExv[[nh
 * \return		Sint64	Đi~bPʁj
 * \par :
 * AtomExv[[ōŌɍĐ́AĐ擾܂B<br>
 * <br>
 * Đ擾łꍇA{֐ 0 ȏ̒lԂ܂B<br>
 * Đ擾łȂꍇi{CX̎擾ɎsꍇjA{֐͕lԂ܂B<br>
 * \par l:
 * v[[ŕ̉ĐA{֐sꍇA{֐
 * "Ō"Đ̎Ԃ܂B<br>
 * ̉ɑ΂čĐ`FbNKvꍇɂ́A
 * Đ鉹̐v[[쐬邩A܂
 * ::criAtomExPlayback_GetTime ֐pB<br>
 * <br>
 * {֐ԂĐ́uĐJnォ̌oߎԁvłB<br>
 * [vĐAV[XAĐsꍇłA
 * ĐʒuɉĎ߂邱Ƃ͂܂B<br>
 * <br>
 * ::criAtomExPlayer_Pause ֐Ń|[YꍇA
 * Đ̃JEgAbv~܂B<br>
 * i|[Y΍ēxJEgAbvĊJ܂Bj
 * <br>
 * {֐Ŏ擾\Ȏ̐x́AT[o[̎gɈˑ܂B<br>
 * i̍XV̓T[o[Pʂōs܂Bj<br>
 * 萸x̍擾Kvꍇɂ́A{֐̑
 * ::criAtomExPlayback_GetNumPlayedSamples ֐gpA
 * Đς݃Tv擾ĂB<br>
 * \attention
 * ߂ľ^CriSint64łAA32bitȏ̐x͂܂B<br>
 * ĐɐsꍇA24ōĐُɂȂ_ɒӂKvłB<br>
 * i 2147483647 ~b𒴂_ŁAĐI[o[t[AlɂȂ܂Bj<br>
 * <br>
 * AtomExv[[쐬A ::CriAtomExPlayerConfig \̂ updates_time 
 * CRI_FALSE ɐݒ肵ꍇAYv[[Đ擾邱Ƃ͂łȂȂ܂B<br>
 * <br>
 * Đ̉ɂďꂽꍇA
 * Đ̃JEgAbv̎_Œ~܂B<br>
 * ܂AĐJn_Ŕɂ{CX蓖ĂȂꍇA
 * {֐͐Ԃ܂B<br>
 * ilԂ܂Bj<br>
 * <br>
 * hCuŃ[hgCAꎞIɉf[^̋r؂ꂽꍇłA
 * Đ̃JEgAbvr؂邱Ƃ͂܂B<br>
 * if[^~ɂĐ~ꍇłA͐iݑ܂Bj<br>
 * ̂߁A{֐Ŏ擾ɉfƂ̓sꍇA
 * [hgCɓ傫Y\܂B<br>
 * g`f[^Ɖf̓ɎKvꍇ́A{֐̑
 * ::criAtomExPlayback_GetNumPlayedSamples ֐gpA
 * Đς݃TvƂ̓ĂB<br>
 * \sa criAtomExPlayback_GetTime, criAtomExPlayback_GetNumPlayedSamples
 */
CriSint64 CRIAPI criAtomExPlayer_GetTime(CriAtomExPlayerHn player);

/*JP
 * \brief tH[}bg̎w
 * \ingroup ATOMEXLIB_PLAYER
 * \param[in]	player		AtomExv[[nh
 * \param[in]	format		tH[}bg
 * \par :
 * AtomExv[[ōĐ鉹̃tH[}bgw肵܂B<br>
 * ̊֐́A::criAtomExPlayer_Start ֐Ń{CXv[{CX
 * 擾ۂ́A擾Ώۂi荞ފ֐̂ЂƂłB<br>
 * ̊֐ł́A擾Ώۃ{CXA
 * w肵tH[}bg̃f[^Đ\ȃ{CXɍi荞݂܂B<br>
 * i荞݂s֐́Å֐̂قɁA::criAtomExPlayer_SetSamplingRate ֐
 * ::criAtomExPlayer_SetNumChannels ֐܂B<br>
 * ֐sÕftHgݒlADXtH[}bgłB<br>
 * \par l:
 * {֐́AACBt@CgpɉĐꍇɂ̂݃ZbgKv܂B<br>
 * L[ĐꍇAtH[}bg̓L[V[g玩Ŏ擾邽߁A
 * ʓr{֐sKv͂܂B<br>
 * \sa criAtomExPlayer_SetSamplingRate, criAtomExPlayer_SetNumChannels
 */
void CRIAPI criAtomExPlayer_SetFormat(
	CriAtomExPlayerHn player, CriAtomExFormat format);

/*JP
 * \brief `l̎w
 * \ingroup ATOMEXLIB_PLAYER
 * \param[in]	player			AtomExv[[nh
 * \param[in]	num_channels	`l
 * \par :
 * AtomExv[[ōĐ鉹̃`lw肵܂B<br>
 * ̊֐́A::criAtomExPlayer_Start ֐Ń{CXv[{CX
 * 擾ۂ́A擾Ώۂi荞ފ֐̂ЂƂłB<br>
 * ̊֐ł́A擾Ώۃ{CXA
 * w肵`l̃f[^Đ\ȃ{CXɍi荞݂܂B<br>
 * i荞݂s֐́Å֐̂قɁA::criAtomExPlayer_SetFormat ֐
 * ::criAtomExPlayer_SetSamplingRate ֐܂B<br>
 * ֐sÕftHgݒl2`lłB<br>
 * \par l:
 * {֐́AACBt@CgpɉĐꍇɂ̂݃ZbgKv܂B<br>
 * L[ĐꍇAtH[}bg̓L[V[g玩Ŏ擾邽߁A
 * ʓr{֐sKv͂܂B<br>
 * \sa criAtomExPlayer_SetFormat, criAtomExPlayer_SetSamplingRate
 */
void CRIAPI criAtomExPlayer_SetNumChannels(
	CriAtomExPlayerHn player, CriSint32 num_channels);

/*JP
 * \brief TvO[g̎w
 * \ingroup ATOMEXLIB_PLAYER
 * \param[in]	player			AtomExv[[nh
 * \param[in]	sampling_rate	TvO[g
 * \par :
 * AtomExv[[ōĐ鉹̃TvO[gw肵܂B<br>
 * ̊֐́A::criAtomExPlayer_Start ֐Ń{CXv[{CX
 * 擾ۂ́A擾Ώۂi荞ފ֐̂ЂƂłB<br>
 * ̊֐ł́A擾Ώۃ{CXA
 * w肵TvO[g̃f[^Đ\ȃ{CXɍi荞݂܂B<br>
 * i荞݂s֐́Å֐̂قɁA::criAtomExPlayer_SetFormat ֐
 * ::criAtomExPlayer_SetNumChannels ֐܂B<br>
 * ֐sÕftHgݒl CRIATOM_DEFAULT_OUTPUT_SAMPLING_RATE łB<br>
 * \par l:
 * {֐́AACBt@CgpɉĐꍇɂ̂݃ZbgKv܂B<br>
 * L[ĐꍇAtH[}bg̓L[V[g玩Ŏ擾邽߁A
 * ʓr{֐sKv͂܂B<br>
 * \sa criAtomExPlayer_SetFormat, criAtomExPlayer_SetNumChannels
 */
void CRIAPI criAtomExPlayer_SetSamplingRate(
	CriAtomExPlayerHn player, CriSint32 sampling_rate);

/*JP
 * \brief TEh_^Cv̎w
 * \ingroup ATOMEXLIB_PLAYER
 * \param[in]	player		AtomExv[[nh
 * \param[in]	type		TEh_^Cv
 * \par :
 * AtomExv[[ōĐ鉹̏o͐TEh_w肵܂B<br>
 * ::criAtomExPlayer_Start ֐ŉĐہAAtomExv[[͖{֐
 * w肳ꂽTEh_o͂{CXA{CXv[擾܂B<br>
 * ֐sÕftHgݒl ::CRIATOM_SOUND_RENDERER_ANY łB<br>
 * \par l:
 * ::CRIATOM_SOUND_RENDERER_ANY w肵ꍇAv[[̓{CX̏o͐Ɋ֌WȂA
 * ŏɌ{CXv[gpĔs܂B<br>
 * \sa CriAtomSoundRendererType
 */
void CRIAPI criAtomExPlayer_SetSoundRendererType(
	CriAtomExPlayerHn player, CriAtomSoundRendererType type);

/*JP
 * \brief O[vԍ̎w
 * \ingroup ATOMEXLIB_PLAYER
 * \param[in]	player		AtomExv[[nh
 * \param[in]	group_no	O[vԍ
 * \par :
 * Ƀ{CXǂ̃{CX~bgO[v擾邩w肵܂B<br>
 * group_no  ::CRIATOMEXPLAYER_NO_GROUP_LIMITATION w肵ꍇA
 * v[[̓{CX~bgO[vɂ鐧󂯂ȂȂ܂B<br>
 * i󂫃{CX邩A܂͎gvCIeB̃{CX΁A
 * {CX~bgO[vɊ֌WȂ{CX擾܂Bj<br>
 * \par l:
 * ::criAtomExPlayer_Start ֐ōĐJnہA
 * w肵{CX~bgO[ṽ{CXSĎgpꍇA
 * Đ邩ǂ́A{CXvCIeBɂČ܂܂B<br>
 * i{CXvCIeB̏ڍׂ ::criAtomExPlayer_SetVoicePriority 
 * ֐̐QƂBj<br>
 * <br>
 * L[Đɖ{֐ĂяoƁAf[^ɐݒ肳Ă{CX~bgO[vݒ<b>㏑</b>܂if[^̐ݒl͖܂jB<br>
 * Agroup_no  ::CRIATOMEXPLAYER_NO_GROUP_LIMITATION w肵ꍇ̓f[^ɐݒ肳Ă{CX~bgO[vQƂ܂B
 * \sa CRIATOMEXPLAYER_NO_GROUP_LIMITATION, criAtomExPlayer_Start, criAtomExPlayer_SetVoicePriority, criAtomExPlayer_SetVoiceControlMethod
 */
void CRIAPI criAtomExPlayer_SetGroupNumber(
	CriAtomExPlayerHn player, CriSint32 group_no);

/*JP
 * \brief {CX@̎w
 * \ingroup ATOMEXLIB_PLAYER
 * \param[in]	player		AtomExv[[nh
 * \param[in]	method		{CX@
 * \par :
 * AtomExv[[Ƀ{CX@ݒ肵܂B<br>
 * {֐Ń{CX@ZbgA ::criAtomExPlayer_Start ֐ŉĐƁA
 * Yv[[ōĐg`f[^ɂ́A{֐Ŏw肵Kp܂B<br>
 * <br>
 * {CX@i method jɂ́Aȉ̂ꂩw\łB<br>
 * - CRIATOMEX_PREFER_LAST
 * - CRIATOMEX_PREFER_FIRST
 * - CRIATOMEX_PREFER_DATA
 * 
 * <br>
 * 󂫃{CXȂԂōĐ̃{CXƓvCIeB̉ĐꍇA
 * {CX CRIATOMEX_PREFER_LAST w肳Ă΁A
 * Đ̃{CX~ĐVKɉ̍ĐJn܂B<br>
 *  CRIATOMEX_PREFER_FIRST w肳ĂꍇA
 * VK̍ĐNGXgLZÃ{CXĐ𑱂܂B<br>
 * <br>
 * CRIATOMEX_PREFER_DATA w肳ĂꍇA
 * f[^ɂ炩ߐݒ肳Ă{CXiI[TOc[Őݒ肵lj
 * gp܂B<br>
 * CRIATOMEX_PREFER_DATA w肵Ăɂ炸AP̃t@CĐA
 * f[^Ƀ{CXݒ肳ĂȂꍇA
 * 㒅Di CRIATOMEX_PREFER_LAST jŃ{CX䂳܂B<br>
 * <br>
 * ֐sÕftHgݒl̓f[^ˑi CRIATOMEX_PREFER_DATA jłB<br>
 * \par l:
 * AtomExv[[g`f[^Đ悤ƂہA
 * Yg`f[^{CX~bgO[v̔ɒBĂꍇA
 * {CXv[̃{CXSĎgpłꍇA
 * {CXvCIeBɂ锭䂪s܂B<br>
 * <br>
 * {֐ŃZbg{CX́A̍ہA
 * Đ悤Ƃg`f[^̃vCIeBƁA
 * Đ̔g`f[^̃vCIeBvCIeBłꍇɍl܂B<br>
 * i{CXvCIeBɂ锭̏ڍׂ ::criAtomExPlayer_SetVoicePriority 
 * ֐̐QƂBj<br>
 * \sa criAtomExPlayer_Start, criAtomExPlayer_SetVoicePriority
 */
void CRIAPI criAtomExPlayer_SetVoiceControlMethod(
	CriAtomExPlayerHn player, CriAtomExVoiceControlMethod method);

/*JP
 * \brief {CXv[ʎq̎w
 * \ingroup ATOMEXLIB_PLAYER
 * \param[in]	player		AtomExv[[nh
 * \param[in]	identifier	{CXv[ʎq
 * \par :
 * Ƀ{CXǂ̃{CXv[擾邩w肵܂B<br>
 * {֐sƁAv[[͈ȍ~w肳ꂽ{CXv[ʎqɈv
 * {CXv[̂݃{CX擾܂B<br>
 * \par l:
 * {CXv[ʎq̃ftHgl 0 łB<br>
 * <br>
 * {p[^[ ::criAtomExPlayer_ResetParameters ֐ɂăNA܂B
 * \sa CriAtomExStandardVoicePoolConfig, criAtomExVoicePool_AllocateStandardVoicePool, criAtomExPlayer_ResetParameters
 */
void CRIAPI criAtomExPlayer_SetVoicePoolIdentifier(
	CriAtomExPlayerHn player, CriAtomExVoicePoolIdentifier identifier);

/*JP
 * \brief HCAfR[h~LTID̎w
 * \ingroup ATOMEXLIB_PLAYER
 * \param[in]	player		AtomExv[[nh
 * \param[in]	mixer_id	~LTID
 * \par :
 * HCA-MX̃fR[h~LTIDw肵܂B<br>
 * \par l:
 * {p[^[ ::criAtomExPlayer_ResetParameters ֐ɂăNA܂B
 * \attention
 * {֐ HCA-MX {CXgpꍇɂ̂݌ʂ܂B<br>
 * ĩ{CXgpꍇA{֐̐ݒl͖܂Bj<br>
 * <br>
 * ~LTID͍ĐJnOɐݒ肷Kv܂B<br>
 * ɍĐJnꂽɑ΂Aォ~LTIDύX邱Ƃ͂ł܂B<br>
 * \sa CriAtomExHcaMxVoicePoolConfig, criAtomExVoicePool_AllocateHcaMxVoicePool, criAtomExPlayer_ResetParameters
 */
void CRIAPI criAtomExPlayer_SetHcaMxMixerId(CriAtomExPlayerHn player, CriSint32 mixer_id);

/*JP
 * \brief ASRbNID̎w
 * \ingroup ATOMEXLIB_PLAYER
 * \param[in]	player		AtomExv[[nh
 * \param[in]	rack_id		ASRbNID
 * \par :
 * {CX̏o͐ASRbNIDw肵܂B<br>
 * ASRbNIDw肵ꍇA ::criAtomExPlayer_SetAsrRackIdArray ֐gpĂB
 * \par l:
 * {p[^[ ::criAtomExPlayer_ResetParameters ֐ɂăNA܂B<br>
 * <br>
 * L[Đɖ{֐ĂяoƁAf[^ɐݒ肳Ăp[^[pbgASRbNIDݒ<b>㏑</b>܂if[^̐ݒl͖܂jB
 * \attention
 * {֐ {CX̃TEh_^CvASRgpꍇɂ̂݌ʂ܂B<br>
 * ĩ{CXgpꍇA{֐̐ݒl͖܂Bj<br>
 * <br>
 * ASRbNID͍ĐJnOɐݒ肷Kv܂B<br>
 * ɍĐJnꂽɑ΂AォASRbNIDύX邱Ƃ͂ł܂B<br>
 * <br>
 *  ::criAtomExPlayer_SetAsrRackIdArray ֐sɖ{֐sƁA ::criAtomExPlayer_SetAsrRackIdArray ֐ɂ
 * ݒ肵ASRbNIDݒ͏㏑܂B<br>
 * <br>
 * HCA-MXpɃGR[hꂽf[^ɂ́A{֐̐ݒ肪Kp܂B<br>
 * HCA-MXpɃGR[hꂽf[^ɂďo͐ASRbNIDݒ肷ꍇA
 * ::criAtomExHcaMx_SetAsrRackId ֐gpāAHCA-MX~LT̂̏o͐ASRbNIDݒ肵ĂB<br>
 * \sa criAtomExAsr_CreateRack, criAtomExPlayer_SetAsrRackIdArray, criAtomExHcaMx_SetAsrRackId, criAtomExPlayer_ResetParameters
 */
void CRIAPI criAtomExPlayer_SetAsrRackId(CriAtomExPlayerHn player, CriSint32 rack_id);

/*JP
 * \brief ASRbNID̎w
 * \ingroup ATOMEXLIB_PLAYER
 * \param[in]	player			AtomExv[[nh
 * \param[in]	rack_id_array	ASRbNID̔z
 * \param[in]	num_racks		ASRbNIDw萔
 * \par :
 * {CX̏o͐ASRbNID𕡐w肵܂B<br>
 * ::CRIATOMEXPLAYER_MAX_ASR_RACKS ɒ`ꂽASRbNIDw肷邱Ƃ\łB<br>
 * PASRbNIDw肷ꍇ́A ::criAtomExPlayer_SetAsrRackId ֐gp邱Ƃłw\łB
 * \par l:
 * {p[^[ ::criAtomExPlayer_ResetParameters ֐ɂăNA܂B<br>
 * <br>
 * L[Đɖ{֐ĂяoƁAf[^ɐݒ肳Ăp[^[pbgASRbNIDݒ<b>㏑</b>܂if[^̐ݒl͖܂jB
 * \attention
 * {֐ {CX̃TEh_^CvASRgpꍇɂ̂݌ʂ܂B<br>
 * ĩ{CXgpꍇA{֐̐ݒl͖܂Bj<br>
 * <br>
 * ASRbNID͍ĐJnOɐݒ肷Kv܂B<br>
 * ɍĐJnꂽɑ΂AォASRbNIDύX邱Ƃ͂ł܂B<br>
 * <br>
 * ASRbNIDw肵v[[ĐꍇA{CX͂̎w肳ꂽASRbNID̐gp܂B<br>
 * ̂߁AOɎw肷ASRbNID̃{CXmۂĂKv܂B<br>
 * <br>
 * ::criAtomExPlayer_SetData ֐gpL[ĐȊO̍Đł́A{֐ɂĎw肵ASRbNID̓A
 * 1ځiz̃CfbNX0j̗vfɊi[ĂASRbNID݂̂Kp܂B<br>
 * <br>
 *  ::criAtomExPlayer_SetAsrRackId ֐sɖ{֐sƁA ::criAtomExPlayer_SetAsrRackId ֐ɂ
 * ݒ肵ASRbNIDݒ͏㏑܂B<br>
 * <br>
 * HCA-MXpɃGR[hꂽf[^ɂ́A{֐̐ݒ肪Kp܂B<br>
 * HCA-MXpɃGR[hꂽf[^ɂďo͐ASRbNIDݒ肷ꍇA
 * ::criAtomExHcaMx_SetAsrRackId ֐gpāAHCA-MX~LT̂̏o͐ASRbNIDݒ肵ĂB<br>
 * \sa criAtomExAsr_CreateRack, criAtomExPlayer_SetAsrRackId, criAtomExHcaMx_SetAsrRackId, criAtomExPlayer_ResetParameters
 */
void CRIAPI criAtomExPlayer_SetAsrRackIdArray(
	CriAtomExPlayerHn player, const CriSint32 *rack_id_array, CriSint32 num_racks);

/*JP
 * \brief ĐJnʒu̎w
 * \ingroup ATOMEXLIB_PLAYER
 * \param[in]	player		AtomExv[[nh
 * \param[in]	start_time_ms	ĐJnʒui~bwj
 * \par :
 * AtomExv[[ōĐ鉹ɂāAĐJnʒuw肵܂B<br>
 * f[^rĐꍇAĐJnOɖ{֐ōĐJnʒu
 * w肷Kv܂B<br>
 * <br>
 * ĐJnʒu̎w̓~bPʂōs܂B<br>
 * Ⴆ΁A start_time_ms  10000 ZbgĖ{֐sƁA
 * ɍĐ鉹f[^ 10 bڂ̈ʒuĐ܂B
 * \par l:
 * f[^r̍Đ́Af[^擪̍ĐɔׁAJn
 * ^C~OxȂ܂B<br>
 * ́AUf[^̃wb_[͌AwʒuɃWvĂf[^ǂ
 * čĐJn邽߂łB<br>
 * \attention
 * start_time_ms ɂ64bitlZbg\łAA32bitȏ̍Đ
 * w肷邱Ƃ͂ł܂B<br>
 * <br>
 * @ŗL̉tH[}bgɂĂAĐJnʒuwłȂꍇ܂B<br>
 * <br>
 * ĐJnʒuw肵ăV[PXĐꍇAwʒuOɔzuꂽ
 * g`f[^͍Đ܂B<br>
 * iV[PX̌X̔g`rĐ邱Ƃ͂܂Bj<br>
 */
void CRIAPI criAtomExPlayer_SetStartTime(
	CriAtomExPlayerHn player, CriSint64 start_time_ms);

/*JP
 * \brief ĐJnʒu̎w
 * \ingroup ATOMEXLIB_PLAYER
 * \param[in]	player		AtomExv[[nh
 * \param[in]	start_time_us	ĐJnʒui}CNbwj
 * \par :
 * AtomExv[[ōĐ鉹ɂāAĐJnʒuw肵܂B<br>
 * f[^rĐꍇAĐJnOɖ{֐ōĐJnʒu
 * w肷Kv܂B<br>
 * <br>
 * ĐJnʒu̎w̓}CNbPʂōs܂B<br>
 * Ⴆ΁A start_time_us  10000000 ZbgĖ{֐sƁA
 * ɍĐ鉹f[^ 10 bڂ̈ʒuĐ܂B
 * \par l:
 * f[^r̍Đ́Af[^擪̍ĐɔׁAJn
 * ^C~OxȂ܂B<br>
 * ́AUf[^̃wb_[͌AwʒuɃWvĂf[^ǂ
 * čĐJn邽߂łB<br>
 * ݒ肵l::criAtomExPlayer_SetStartTimeɂݒ㏑܂B<br>
 * {p[^[ ::criAtomExPlayer_ResetParameters ֐ɂăNA܂B
 * <br>
 * @ŗL̉tH[}bgɂĂAĐJnʒuwłȂꍇ܂B<br>
 * ĐJnʒuw肵ăV[PXĐꍇAwʒuOɔzuꂽ
 * g`f[^͍Đ܂B<br>
 * iV[PX̌X̔g`rĐ邱Ƃ͂܂Bj<br>
 */
void CRIAPI criAtomExPlayer_SetStartTimeMicro(
	CriAtomExPlayerHn player, CriSint64 start_time_us);

/*JP
 * \brief ĐID̐ݒ
 * \ingroup ATOMEXLIB_PLAYER
 * \param[in]	player		AtomExv[[nh
 * \param[in]	playback_id	ΏۂƂȂĐID
 * \par :
 * AtomExv[[ōĐ鉹Aw肵ĐID̉ɓ܂B<br>
 * {֐ōĐIDݒɉĐƁA
 * ͎̉w肳ꂽĐIDƓĐʒuɃV[NčĐn߂܂B<br>
 * \par l:
 * Ώۂ̍ĐIDȏꍇAf[^̐擪ĐJn܂B<br>
 * playback_id  CRIATOMEX_INVALID_PLAYBACK_ID w肷ƁA
 * ĐID̓o^NA܂B<br>
 * \attention
 * {֐́AP̂̔g`f[^Đꍇɂ̂ݗp\łB<br>
 * V[PXf[^ɂ͗pł܂B<br>
 * iV[PXf[^ɑ΂ĎgpꍇA
 * V[PXōŏɌg`f[^ɑ΂ēsĂ܂܂Bj<br>
 * <br>
 * {֐ōĐʒu𒲐\ȃR[fbŃAȉ̃R[fbN݂̂łB<br>
 * 	- ADX
 * 	- HCA
 * 	- Wave
 * 	
 * <br>
 * ̃R[fbNɂẮA{֐pĐ͍s܂B<br>
 * iHCA-MXAn[hEFAfR[hsR[fbNł́A{@\͗pł܂Bj<br>
 * <br>
 * {@\ɂĐʒu̓́A\ȌTvPʂōs܂A
 * 1Tv̌덷Ȃ邱Ƃۏ؂̂ł͂܂B<br>
 * i~bx̃Yeꍇɂ݂̂pBj<br>
 * ܂AĐʒu̓x́AvbgtH[ɂĂقȂ܂B<br>
 * <br>
 * {֐ ::criAtomExPlayer_SetStartTime ֐𕹗p邱Ƃ͂ł܂B<br>
 * {֐gpꍇA̍ĐJnʒu̓CuŎIɒ܂B<br>
 * ̂߁A{֐ ::criAtomExPlayer_SetStartTime ֐𕹗p邱Ƃ͂ł܂B<br>
 * i ::criAtomExPlayer_SetStartTime ֐̐ݒ͖܂Bj<br>
 * <br>
 * {֐gpčĐsꍇAĐJnɃmCYꍇ܂B<br>
 * {@\gpꍇA\ȌtF[hC𕹗pĂB<br>
 * <br>
 * {֐gpăL[ĐsꍇA ::criAtomExPlayer_GetTime ֐
 * ::criAtomExPlayback_GetTime ֐ɂĐ̎擾͐s܂B<br>
 * Đ̊mFɂ́Å֐̑ɁA ::criAtomExPlayback_GetNumPlayedSamples
 * ֐pB<br>
 * <br>
 * \sa criAtomExPlayback_GetNumPlayedSamples
 */
void CRIAPI criAtomExPlayer_SetSyncPlaybackId(
	CriAtomExPlayerHn player, CriAtomExPlaybackId playback_id);

/*JP
 * \brief V[PXĐVI̐ݒ
 * \ingroup ATOMEXLIB_PLAYER
 * \param[in]	player			AtomExv[[nh
 * \param[in]	playback_ratio	V[PXĐVI
 * \par :
 * AtomExv[[ōĐV[PX̍ĐVIݒ肵܂B<br>
 * ĐVI̐ݒ͈͂ 0.0f ` 2.0f łB<br>
 * ͈͊O̒lݒ肵ꍇ́Al͏lݒ肳܂B
 * \par l:
 * {p[^[ ::criAtomExPlayer_ResetParameters ֐ɂăNA܂B
 * \attention
 * {֐ɂݒĺAV[PX^CṽL[Đꍇɂ̂ݓKp܂B<br>
 * V[PXɂĔg`f[^̍ĐVIɂ͗pł܂B<br>
 * \sa criAtomExPlayer_ResetParameters
 */
void CRIAPI criAtomExPlayer_SetPlaybackRatio(
	CriAtomExPlayerHn player, CriFloat32 playback_ratio);

/*JP
 * \brief [v񐔂̐
 * \ingroup ATOMEXLIB_PLAYER
 * \param[in]	player		AtomExv[[nh
 * \param[in]	count		[v
 * \par :
 * g`f[^̃[vĐ񐔂𐧌܂B<br>
 * Ⴆ΁Acount1w肵ꍇA[vg`f[^1̂݃[včĐI܂B<br>
 * i[vGh|CgɓBA1񂾂[vX^[gʒuɖ߂܂Bj<br>
 * \par l:
 * ftHgԂł́A[v|Cgt̉f[^͖Ƀ[vĐ܂B<br>
 * [v񐔂UA[v񐔂ēxɖ߂ꍇɂ́A
 * count  ::CRIATOMEXPLAYER_NO_LOOP_LIMITATION w肵ĂB<br>
 * <br>
 * count  ::CRIATOMEXPLAYER_IGNORE_LOOP w肷邱ƂŁA
 * [v|Cgt̉f[^[vɍĐ邱Ƃ\łB<br>
 * <br>
 * {p[^[ ::criAtomExPlayer_ResetParameters ֐ɂăNA܂B
 * \attention
 * [v񐔂̎ẃAĐJnOɍsKv܂B<br>
 * Đɖ{֐sĂA[v񐔂͕ύX܂B<br>
 * Đ̔Cӂ̃^C~OŃ[vĐ~ꍇA
 * [vĐł͂ȂAV[XAĐŐsĂB<br>
 * <br>
 * {֐Ŏw肵[v񐔂́A
 * 炩߃[v|Cgݒ肳ꂽg`f[^Đꍇɂ̂ݓKp܂B<br>
 * g`f[^̂Ƀ[v|Cgݒ肳ĂȂꍇA
 * {֐sĂ̌ʂ܂B<br>
 * <br>
 * {֐gpă[v񐔂w肵ꍇłA
 * [vIɃ[vGh|Cgȍ~̔g`f[^Đ邱Ƃ͂܂B<br>
 * iw񐔕[vA[vGh|CgōĐ~܂Bj<br>
 * <br>
 * OIɁAȉ̏𖞂ꍇɌAVbgŃ[v|Cgȍ~
 * f[^܂߂čĐ邱Ƃ\łBi[v͂܂j<br>
 * 	- criatomencd.exe  -nodelterm w肵ăf[^GR[hB
 * 	- {֐ ::CRIATOMEXPLAYER_IGNORE_LOOP w肵ĂĐsB
 * 	
 * <br>
 * {֐Ń[v񐔂𐧌ł̂́AADXR[fbNHCAR[fbN݂̂łB<br>
 * vbgtH[ˑ̉R[fbNɑ΂Ė{֐sȂłB<br>
 * iĐIȂAmCY铙̖肪܂Bj<br>
 * \sa criAtomExPlayer_ResetParameters
 */
void CRIAPI criAtomExPlayer_LimitLoopCount(CriAtomExPlayerHn player, CriSint32 count);

/*JP
 * \brief Đp[^[̍XViĐ̉Sāj
 * \ingroup ATOMEXLIB_PLAYER
 * \param[in]	player		AtomExv[[nh
 * \par :
 * AtomExv[[ɐݒ肳ĂĐp[^[iAISACRg[l܂ށjgpāA
 * AtomExv[[ōĐ̉SĂ̍Đp[^[XV܂B<br>
 * \par :
 * \code
 * CriFloat32 volume;
 * // Start playback
 * criAtomExPlayer_Start(player);
 *                :
 * criAtomExPlayer_Start(player);
 *                :
 * // Change Volume
 * volume = 0.3f;
 * criAtomExPlayer_SetVolume(player, volume);
 * criAtomExPlayer_UpdateAll(player);
 * \endcode
 * \sa criAtomExPlayer_Update
 */
void CRIAPI criAtomExPlayer_UpdateAll(CriAtomExPlayerHn player);

/*JP
 * \brief Đp[^[̍XViĐIDwj
 * \ingroup ATOMEXLIB_PLAYER
 * \param[in]	player		AtomExv[[nh
 * \param[in]	id			ĐID
 * \par :
 * AtomExv[[ɐݒ肳ĂĐp[^[iAISACRg[l܂ށjgpāA
 * ĐIDɂĎw肳ꂽ̍Đp[^[XV܂B<br>
 * \par :
 * \code
 * CriFloat32 volume;
 * // Start playback
 * id = criAtomExPlayer_Start(player);
 *                :
 * // Change Volume
 * volume = 0.3f;
 * criAtomExPlayer_SetVolume(player, volume);
 * criAtomExPlayer_Update(player, id);
 * \endcode
 * \par l:
 * ĐID́AAtomExv[[ōĐꂽwĂKv܂B<br>
 * \sa criAtomExPlayer_UpdateAll
 */
void CRIAPI criAtomExPlayer_Update(
	CriAtomExPlayerHn player, CriAtomExPlaybackId id);

/*JP
 * \brief Đp[^[̏
 * \ingroup ATOMEXLIB_PLAYER
 * \param[in]	player		AtomExv[[nh
 * \par :
 * AtomExv[[ɐݒ肳ĂĐp[^[iAISACRg[l܂ށjZbgAԁiݒԁjɖ߂܂B<br>
 * {֐ĂяoA::criAtomExPlayer_Start ֐ɂĐJnƁAԂ̍Đp[^[ōĐ܂B<br>
 * \par :
 * \code
 * CriFloat32 volume;
 * // Start playback
 * id = criAtomExPlayer_Start(player);
 *                :
 * // Change Volume
 * volume = 0.3f;
 * criAtomExPlayer_SetVolume(player, volume);
 * criAtomExPlayer_Update(player, id);
 *                :
 * // Reset Parameters
 * criAtomExPlayer_ResetParameters(player);
 * id = criAtomExPlayer_Start(player);
 * \endcode
 * \par l:
 * {֐ĂяoA::criAtomExPlayer_Update ֐A::criAtomExPlayer_UpdateAll ֐ĂяoƂĂAłɍĐĂ鉹̃p[^[͏lɂ͖߂܂B<br>
 * łɍĐĂ鉹̃p[^[ςꍇ́AI::criAtomExPlayer_SetVolume ֐ĂяoĂB<br>
 * <br>
 * {֐ŃZbgp[^[́Aep[^[̐ݒs֐ɑΏۂǂLڂĂ邽߁AQƂĉB<br>
 * <br>
 * ȂA{֐ł3Dnh3DXi[nĥ̂p[^[iʒuj̓Zbg܂BuAtomExv[[ɐݒ肳ĂnhvƂݒ肾Zbg܂B
 * ̃nĥ̃p[^[Zbgꍇɂ́Aꂼ̃nh̃p[^[Zbg֐ĂяoĂB
 * \sa criAtomEx3dSource_ResetParameters, criAtomEx3dListener_ResetParameters
 */
void CRIAPI criAtomExPlayer_ResetParameters(CriAtomExPlayerHn player);

/*JP
 * \brief p[^[̎擾i_j
 * \ingroup ATOMEXLIB_PLAYER
 * \param[in]	player	AtomExv[[nh
 * \param[in]	id		p[^[ID
 * \return		p[^[ݒl
 * \par :
 * AtomExv[[ɐݒ肳Ăep[^[̒l擾܂B<br>
 * l͕_Ŏ擾܂B
 * \sa CriAtomExParameterId, criAtomExPlayer_GetParameterUint32, criAtomExPlayer_GetParameterSint32
 */
CriFloat32 CRIAPI criAtomExPlayer_GetParameterFloat32(CriAtomExPlayerHn player, CriAtomExParameterId id);

/*JP
 * \brief p[^[̎擾iȂj
 * \ingroup ATOMEXLIB_PLAYER
 * \param[in]	player	AtomExv[[nh
 * \param[in]	id		p[^[ID
 * \return		p[^[ݒl
 * \par :
 * AtomExv[[ɐݒ肳Ăep[^[̒l擾܂B<br>
 * l͕ȂŎ擾܂B
 * \sa CriAtomExParameterId, criAtomExPlayer_GetParameterFloat32, criAtomExPlayer_GetParameterSint32
 */
CriUint32 CRIAPI criAtomExPlayer_GetParameterUint32(CriAtomExPlayerHn player, CriAtomExParameterId id);

/*JP
 * \brief p[^[̎擾itj
 * \ingroup ATOMEXLIB_PLAYER
 * \param[in]	player	AtomExv[[nh
 * \param[in]	id		p[^[ID
 * \return		p[^[ݒl
 * \par :
 * AtomExv[[ɐݒ肳Ăep[^[̒l擾܂B<br>
 * l͕tŎ擾܂B
 * \sa CriAtomExParameterId, criAtomExPlayer_GetParameterFloat32, criAtomExPlayer_GetParameterUint32
 */
CriSint32 CRIAPI criAtomExPlayer_GetParameterSint32(CriAtomExPlayerHn player, CriAtomExParameterId id);

/*JP
 * \brief {[̐ݒ
 * \ingroup ATOMEXLIB_PLAYER
 * \param[in]	player		AtomExv[[nh
 * \param[in]	volume		{[l
 * \par :
 * õ͉{[w肵܂B<br>
 * {֐Ń{[ݒA::criAtomExPlayer_Start ֐ōĐJnƁA
 * ݒ肳ꂽ{[ŉĐ܂B<br>
 * ܂{[ݒ ::criAtomExPlayer_Update ֐ ::criAtomExPlayer_UpdateAll 
 * ֐ĂяoƂŁAłɍĐꂽ̃{[XV邱Ƃ\łB<br>
 * <br>
 * {[l͉f[^̐Uɑ΂{łiPʂ̓fVxł͂܂jB<br>
 * Ⴆ΁A1.0fw肵ꍇA͂̂܂܂̃{[ŏo͂܂B<br>
 * 0.5fw肵ꍇAg`̐U𔼕ɂf[^Ɠʁi-6dBj
 * o͂܂B<br>
 * 0.0fw肵ꍇA̓~[g܂iɂȂ܂jB<br>
 * {[̃ftHgl1.0fłB<br>
 * \par :
 * \code
 * 	F
 * // {[̐ݒ
 * criAtomExPlayer_SetVolume(player, 0.5f);
 * 
 * // Đ̊Jn
 * // lj{[̓v[[ɐݒ肳ꂽli0.5fjōĐB
 * id = criAtomExPlayer_Start(player);
 * 	F
 * // {[̕ύX
 * // Ӂj̎_ł͍Đ̉̃{[͕ύXȂB
 * criAtomExPlayer_SetVolume(player, 0.3f);
 * 
 * // v[[ɐݒ肳ꂽ{[Đ̉ɂf
 * criAtomExPlayer_Update(player, id);
 * 	F
 * \endcode
 * \par l:
 * {[lɂ0.0fȏ̒lݒ\łB<br>
 * iAtomCu Ver.1.21.07A
 * {[l1.0f𒴂lwł悤ɂȂ܂Bj<br>
 * 1.0f𒴂lZbgꍇA<b>vbgtH[ɂĂ</b>A
 * g`f[^fނ傫ȉʂōĐ\łB<br>
 * {[l0.0f̒lw肵ꍇAl0.0fɃNbv܂B<br>
 * i{[lɕ̒lݒ肵ꍇłA
 * g`f[^̈ʑ]邱Ƃ͂܂Bj<br>
 * <br>
 * L[ĐAf[^Ƀ{[ݒ肳Ăꍇɖ{֐ĂяoƁA
 * f[^ɐݒ肳ĂlƖ{֐ɂݒlƂ<b>Z</b>lKp܂B<br>
 * Ⴆ΁Af[^̃{[0.8fAAtomExv[[̃{[0.5f̏ꍇA
 * ۂɓKp{[0.4fɂȂ܂B<br>
 * <br>
 * fVxŐݒ肵ꍇAȉ̌vZŕϊĂݒ肵ĂB<br>
 * \code
 * volume = powf(10.0f, db_vol / 20.0f);
 * \endcode
 * db_volfVxlAvolume{[lłB<br>
 * <br>
 * {p[^[ ::criAtomExPlayer_ResetParameters ֐ɂăNA܂B
 * \attention
 * 1.0f𒴂{[w肷ꍇAȉ̓_ɒӂKv܂B<br>
 *  - vbgtH[ƂɋقȂ\B
 *  - ꂪ\B
 * 	
 * <br>
 * {֐1.0f𒴂{[lݒ肵ꍇłA
 * ̔g`f[^傫ȉʂōĐ邩ǂ́A
 * vbgtH[≹kR[fbN̎ʂɂĈقȂ܂B<br>
 * ̂߁A}`vbgtH[^CgŃ{[𒲐ꍇɂ́A
 * 1.0f𒴂{[lgpȂƂ߂܂B<br>
 * i1.0f𒴂{[lw肵ꍇAg`f[^ĐꍇłA
 * @킲ƂɈقȂ鉹ʂŏo͂\܂Bj<br>
 * <br>
 * ܂Aʂグ邱Ƃ\ȋ@łĂA
 * n[hEFAŏo͉\ȉʂɂ͏邽߁A
 * ɂmCY\܂B<br>
 * \sa criAtomExPlayer_Start, criAtomExPlayer_Update, criAtomExPlayer_UpdateAll, criAtomExPlayer_ResetParameters
 */
void CRIAPI criAtomExPlayer_SetVolume(
	CriAtomExPlayerHn player, CriFloat32 volume);

/*JP
 * \brief sb`̐ݒ
 * \ingroup ATOMEXLIB_PLAYER
 * \param[in]	player		AtomExv[[nh
 * \param[in]	pitch		sb`iZgPʁj
 * \par :
 * õ͉sb`w肵܂B<br>
 * {֐Ńsb`ݒA::criAtomExPlayer_Start ֐ōĐJnƁA
 * ݒ肳ꂽsb`ŉĐ܂B<br>
 * ܂sb` ::criAtomExPlayer_Update ֐ ::criAtomExPlayer_UpdateAll 
 * ֐ĂяoƂɂAłɍĐꂽ̃sb`XV邱Ƃ\łB<br>
 * <br>
 * sb`̓ZgPʂŎw肵܂B<br>
 * 1Zg1IN^[u1/1200łB100ZgłB<br>
 * Ⴆ΁A100.0fw肵ꍇAsb`オ܂B-100.0fw肵ꍇA
 * sb`܂B<br>
 * sb`̃ftHgl0.0fłB<br>
 * \par :
 * \code
 * 	F
 * // sb`̐ݒ
 * criAtomExPlayer_SetPitch(player, 100.0f);
 * 
 * // Đ̊Jn
 * // ljsb`̓v[[ɐݒ肳ꂽli0.5fjōĐB
 * id = criAtomExPlayer_Start(player);
 * 	F
 * // sb`̕ύX
 * // Ӂj̎_ł͍Đ̉̃sb`͕ύXȂB
 * criAtomExPlayer_SetPitch(player, -200.0f);
 * 
 * // v[[ɐݒ肳ꂽsb`Đ̉ɂf
 * criAtomExPlayer_Update(player, id);
 * 	F
 * \endcode
 * \par l:
 * L[ĐAf[^Ƀsb`ݒ肳Ăꍇɖ{֐ĂяoƁA
 * f[^ɐݒ肳ĂlƖ{֐ɂݒlƂ<b>Z</b>lKp܂B<br>
 * Ⴆ΁Af[^̃sb`-100.0fAAtomExv[[̃sb`200.0f̏ꍇA
 * ۂɓKpsb`100.0fɂȂ܂B
 * <br>
 * TvO[g̎g䗦Őݒ肵ꍇAȉ̌vZŕϊĂݒ肵ĂB<br>
 * \code
 * pitch = 1200.0f*logf(freq_ratio)/logf(2.0f);
 * \endcode
 * freq_ratiog䗦Apitchsb`̒lłB<br>
 * <br>
 * {p[^[ ::criAtomExPlayer_ResetParameters ֐ɂăNA܂B
 * \attention
 * HCA-MXpɃGR[hꂽf[^́Asb`̕ύXł܂B<br>
 * i{֐sĂAsb`͕ς܂Bj<br>
 * sb`ύXɂẮAADXHCAÃR[fbNŃGR[hsĂB<br>
 * <br>
 * ݒ\ȍősb`́Af[^̃TvO[gƃ{CXv[̍őTvO[gɈˑ܂B<br>
 * Ⴆ΁Af[^̃TvO[g24kHzŁA{CXv[̍őTvO[g48kHz̏ꍇA
 * ݒ\ȍősb`1200(g䗦2{)ɂȂ܂B<br>
 * <br>
 * ĐTvO[g̏㉺ɂsb`Ă邽߁A
 * sb`ύXƉƈꏏɍĐxω܂B
 * \sa criAtomExPlayer_Start, criAtomExPlayer_Update, criAtomExPlayer_UpdateAll, criAtomExPlayer_SetMaxPitch, criAtomExPlayer_ResetParameters
 */
void CRIAPI criAtomExPlayer_SetPitch(CriAtomExPlayerHn player, CriFloat32 pitch);

/*JP
 * \brief ősb`̐ݒ
 * \ingroup ATOMEXLIB_PLAYER
 * \param[in]	player		Atomv[[nh
 * \param[in]	pitch		ősb`
 * \par :
 * ̍ősb`ݒ肵܂B<br>
 * {֐ōősb`w肷邱ƂŁAw͈͓ł̃sb`ύXɔf悤ɂȂ܂B<br>
 * \par l:
 * Atom Ver.2.10.00ȑÕCuł́Asb`グۂɉr؂
 * iĐxȂʁAf[^̋ȂȂjP[X܂B<br>
 * ̑΍ƂāAAtom Ver.2.10.00ł̓sb`グĂr؂Ȃ悤A
 * [Ƀobt@OĂsb`グ悤ύXĂ܂B<br>
 * CɂAsb`ɂĉr؂邱Ƃ͂ȂȂ܂A
 * sb`グۂɃobt@O҂ԕsb`ύXx`ɂȂ邽߁A
 * ̕ωȑÕo[WƔׂĊɖɂȂ\܂B<br>
 * iZԂɃsb`グP[XɂāA̖ς\܂Bj<br>
 * <br>
 * {֐ōősb`炩ߐݒ肵ꍇA
 * w肳ꂽxz肵ďɃobt@Os悤ɂȂ邽߁A
 * iw肳ꂽ͈͓̎gɂẮjobt@OȂɃsb`ύXɍs܂B<br>
 * ZԂɃsb`グP[XɂẮA
 * \zősb`炩ߖ{֐Őݒ肵ĂĐsĂB<br>
 * <br>
 * {p[^[ ::criAtomExPlayer_ResetParameters ֐ɂăNA܂B
 * \sa criAtomExPlayer_SetPitch, criAtomExPlayer_ResetParameters
 */
void CRIAPI criAtomExPlayer_SetMaxPitch(CriAtomExPlayerHn player, CriFloat32 pitch);

/*JP
 * \brief pjO3Dpx̐ݒ
 * \ingroup ATOMEXLIB_PLAYER
 * \param[in]	player		AtomExv[[nh
 * \param[in]	pan3d_angle	pjO3Dpxi-180.0f`180.0fFxPʁj
 * \par :
 * pjO3Dpxw肵܂B<br>
 * {֐ŃpjO3DpxݒA::criAtomExPlayer_Start ֐ɂĐJnƁAݒ肳ꂽpjO3DpxōĐ܂B<br>
 * ܂ݒA::criAtomExPlayer_Update ֐A::criAtomExPlayer_UpdateAll ֐ĂяoƂɂA
 * łɍĐꂽ̃pjO3DpxXV邱Ƃł܂B<br>
 * <br>
 * px͓xPʂŎw肵܂B<br>
 * O0xƂAEivj180.0fAivj-180.0f܂Őݒł܂B<br>
 * Ⴆ΁A45.0fw肵ꍇAEO45xɒʂ܂B-45.0fw肵ꍇAO45xɒʂ܂B<br>
 * \par :
 * \code
 * 	F
 * // pjO3Dpx̐ݒ
 * criAtomExPlayer_SetPan3dAngle(player, 45.0f);
 * 
 * // Đ̊Jn
 * // ljpjO3Dpx̓v[[ɐݒ肳ꂽli45.0fjōĐB
 * id = criAtomExPlayer_Start(player);
 * 	F
 * // pjO3Dpx̕ύX
 * // Ӂj̎_ł͍Đ̉̃pjO3Dpx͕ύXȂB
 * criAtomExPlayer_SetPan3dAngle(player, -45.0f);
 * 
 * // v[[ɐݒ肳ꂽpjO3DpxĐ̉ɂf
 * criAtomExPlayer_Update(player, id);
 * 	F
 * \endcode
 * \par l:
 * L[ĐAf[^ɃpjO3Dpxݒ肳Ăꍇɖ{֐ĂяoƁA
 * f[^ɐݒ肳ĂlƖ{֐ɂݒlƂ<b>Z</b>lKp܂B<br>
 * Ⴆ΁Af[^̃pjO3Dpx15.0fAAtomExv[[̃pjO3Dpx30.0f̏ꍇA
 * ۂɓKppjO3Dpx45.0fɂȂ܂B
 * <br>
 * ۂɓKppjO3Dpx180.0f𒴂lɂȂꍇAl-360.0fĔ͈͓ɔ[߂܂B<br>
 * lɁAۂɓKp{[l-180.0f̒lɂȂꍇ́Al+360.0fĔ͈͓ɔ[߂܂B<br>
 * i+360.0f, -360.0fĂʂ͕ςȂ߁AIɂ-180.0f`180.0f͈̔͂𒴂Đݒ\łBj<br>
 * <br>
 * {p[^[ ::criAtomExPlayer_ResetParameters ֐ɂăNA܂B
 * \sa criAtomExPlayer_Start, criAtomExPlayer_Update, criAtomExPlayer_UpdateAll, criAtomExPlayer_ResetParameters
 */
void CRIAPI criAtomExPlayer_SetPan3dAngle(
	CriAtomExPlayerHn player, CriFloat32 pan3d_angle);

/*JP
 * \brief pjO3Dp̐ݒ
 * \ingroup ATOMEXLIB_PLAYER
 * \param[in]	player					AtomExv[[nh
 * \param[in]	pan3d_elevation			pjO3Dpi-180.0f`180.0fFxPʁj
 * \par :
 * pjO3Dpw肵܂B<br>
 * {֐ŃpjO3DpݒA::criAtomExPlayer_Start ֐ɂĐJnƁAݒ肳ꂽpjO3DpxōĐ܂B<br>
 * ܂ݒA::criAtomExPlayer_Update ֐A::criAtomExPlayer_UpdateAll ֐ĂяoƂɂA
 * łɍĐꂽ̃pjO3DpxXV邱Ƃł܂B<br>
 * <br>
 * px͓xPʂŎw肵܂B<br>
 * O0xƂA180.0fA-180.0f܂Őݒł܂B<br>
 * Ⴆ΁A45.0fw肵ꍇAO45xɒʂ܂B-45.0fw肵ꍇAO45xɒʂ܂B<br>
 * \par :
 * \code
 * 	F
 * // pjO3Dp̐ݒ
 * criAtomExPlayer_SetPan3dElevatio(player, 45.0f);
 *
 * // Đ̊Jn
 * // ljpjO3Dp̓v[[ɐݒ肳ꂽli45.0fjōĐB
 * id = criAtomExPlayer_Start(player);
 * 	F
 * // pjO3Dp̕ύX
 * // Ӂj̎_ł͍Đ̉̃pjO3Dp͕ύXȂB
 * criAtomExPlayer_SetPan3dElevation(player, -45.0f);
 *
 * // v[[ɐݒ肳ꂽpjO3DpĐ̉ɂf
 * criAtomExPlayer_Update(player, id);
 * 	F
 * \endcode
 * <br>
 * {p[^[ ::criAtomExPlayer_ResetParameters ֐ɂăNA܂B
 * \sa criAtomExPlayer_Start, criAtomExPlayer_Update, criAtomExPlayer_UpdateAll, criAtomExPlayer_ResetParameters
 */
void CRIAPI criAtomExPlayer_SetPan3dElevation(
	CriAtomExPlayerHn player, CriFloat32 pan3d_elevation);

/*JP
 * \brief pjO3D̐ݒ
 * \ingroup ATOMEXLIB_PLAYER
 * \param[in]	player					AtomExv[[nh
 * \param[in]	pan3d_interior_distance	pjO3Di-1.0f`1.0fj
 * \par :
 * pjO3DŃCeApjOsۂ̋w肵܂B<br>
 * {֐ŃpjO3DݒA::criAtomExPlayer_Start ֐ɂĐJnƁAݒ肳ꂽpjO3DōĐ܂B<br>
 * ܂ݒA::criAtomExPlayer_Update ֐A::criAtomExPlayer_UpdateAll ֐ĂяoƂɂA
 * łɍĐꂽ̃pjO3DXV邱Ƃł܂B<br>
 * <br>
 * ́AXi[ʒu0.0fAXs[J[̔zuĂ~1.0fƂāA-1.0f`1.0f͈̔͂Ŏw肵܂B<br>
 * lw肷ƁApjO3Dpx180x]Atɒʂ܂B
 * \par :
 * \code
 * 	F
 * // pjO3D̐ݒ
 * criAtomExPlayer_SetPan3dInteriorDistance(player, 0.5f);
 * 
 * // Đ̊Jn
 * // ljpjO3D̓v[[ɐݒ肳ꂽli0.5fjōĐB
 * id = criAtomExPlayer_Start(player);
 * 	F
 * // pjO3D̕ύX
 * // Ӂj̎_ł͍Đ̉̃pjO3D͕ύXȂB
 * // ljȉ̏̓p3Dpx180x]̂Ɠ
 * criAtomExPlayer_SetPan3dInteriorDistance(player, -0.5f);
 * 
 * // v[[ɐݒ肳ꂽpjO3DĐ̉ɂf
 * criAtomExPlayer_Update(player, id);
 * 	F
 * \endcode
 * \par l:
 * L[ĐAf[^ɃpjO3Dݒ肳Ăꍇɖ{֐ĂяoƁA
 * f[^ɐݒ肳ĂlƖ{֐ɂݒlƂ<b>Z</b>lKp܂B<br>
 * Ⴆ΁Af[^̃pjO3D0.8fAAtomExv[[̃pjO3D0.5f̏ꍇA
 * ۂɓKppjO3D0.4fɂȂ܂B
 * <br>
 * ۂɓKppjO3D1.0f𒴂lɂȂꍇAl1.0fɃNbv܂B<br>
 * lɁAۂɓKppjO3D-1.0f̒lɂȂꍇAl-1.0fɃNbv܂B<br>
 * <br>
 * {p[^[ ::criAtomExPlayer_ResetParameters ֐ɂăNA܂B
 * \sa criAtomExPlayer_Start, criAtomExPlayer_Update, criAtomExPlayer_UpdateAll, criAtomExPlayer_ResetParameters
 */
void CRIAPI criAtomExPlayer_SetPan3dInteriorDistance(
	CriAtomExPlayerHn player, CriFloat32 pan3d_interior_distance);

/*JP
 * \brief pjO3D{[̐ݒ
 * \ingroup ATOMEXLIB_PLAYER
 * \param[in]	player			AtomExv[[nh
 * \param[in]	pan3d_volume	pjO3D{[i0.0f`1.0fj
 * \par :
 * pjO3D̃{[w肵܂B<br>
 * {֐ŃpjO3D{[ݒA::criAtomExPlayer_Start ֐ɂĐJnƁA
 * ݒ肳ꂽpjO3D{[ōĐ܂B<br>
 * ܂ݒA::criAtomExPlayer_Update ֐A::criAtomExPlayer_UpdateAll ֐ĂяoƂɂA
 * łɍĐꂽ̃pjO3D{[XV邱Ƃł܂B<br>
 * <br>
 * pjO3D{[́ApjO3DƁA
 * Z^[^LFEւ̏o̓xƂʂɐ䂷ꍇɎgp܂B<br>
 * Ⴆ΁AZhxŏLFẼ{[ŏo͂ĂA
 * ʂ̓pjO3DŃRg[悤ȏꍇłB
 * <br>
 * l͈̔͂∵́Aʏ̃{[ƓłB::criAtomExPlayer_SetVolume ֐QƂĂB
 * \par :
 * \code
 * 	F
 * // pjO3D{[̐ݒ
 * criAtomExPlayer_SetPan3dVolume(player, 0.8f);
 * 
 * // Đ̊Jn
 * // ljpjO3D{[̓v[[ɐݒ肳ꂽli0.5fjōĐB
 * id = criAtomExPlayer_Start(player);
 * 	F
 * // pjO3D{[̕ύX
 * // Ӂj̎_ł͍Đ̉̃pjO3D{[͕ύXȂB
 * criAtomExPlayer_SetPan3dVolume(player, 0.7f);
 * 
 * // v[[ɐݒ肳ꂽpjO3D{[Đ̉ɂf
 * criAtomExPlayer_Update(player, id);
 * 	F
 * \endcode
 * \par l:
 * {p[^[ ::criAtomExPlayer_ResetParameters ֐ɂăNA܂B
 * \sa criAtomExPlayer_Start, criAtomExPlayer_Update, criAtomExPlayer_UpdateAll, criAtomExPlayer_SetVolume, criAtomExPlayer_ResetParameters
 */
void CRIAPI criAtomExPlayer_SetPan3dVolume(
	CriAtomExPlayerHn player, CriFloat32 pan3d_volume);

/*JP
 * \brief p^Cv̐ݒ
 * \ingroup ATOMEXLIB_PLAYER
 * \param[in]	player			AtomExv[[nh
 * \param[in]	pan_type		p^Cv
 * \par :
 * p^Cvw肵܂B<br>
 * {֐Ńp^CvݒA::criAtomExPlayer_Start ֐ɂĐJnƁAݒ肳ꂽp^CvōĐ܂B<br>
 * ܂ݒA::criAtomExPlayer_Update ֐A::criAtomExPlayer_UpdateAll ֐ĂяoƂɂA
 * łɍĐꂽ̃p^CvXV邱Ƃł܂B<br>
 * \par l:
 * L[Đɖ{֐ĂяoƁAf[^ɐݒ肳Ăp^Cvݒ<b>㏑</b>܂if[^̐ݒl͖܂jB<br>
 * ʏ̓f[^Ńp^Cvݒ肳Ă邽߁A{֐ĂяoKv͂܂B<br>
 * ACBt@CgpɉĐꍇɁA3D|WVjOLɂ邽߂ɂ́A{֐::CRIATOMEX_PAN_TYPE_3D_POSݒ肵ĂB<br>
 * <br>
 * {p[^[ ::criAtomExPlayer_ResetParameters ֐ɂăNA܂B
 * \attention
 * ::CRIATOMEX_PAN_TYPE_UNKNOWN w肵ĎsꍇAG[܂B
 * \sa criAtomExPlayer_Start, criAtomExPlayer_Update, criAtomExPlayer_UpdateAll, CriAtomExPanType, criAtomExPlayer_ResetParameters
 */
void CRIAPI criAtomExPlayer_SetPanType(
	CriAtomExPlayerHn player, CriAtomExPanType pan_type);

/*JP
 * \brief v[[Đ̃p^Cv̎擾
 * \ingroup ATOMEXLIB_PLAYER
 * \param[in]	player				AtomExv[[nh
 * \return		CriAtomExPanType	v[[Đ̃p^Cv
 * \par :
 * v[[Đ̃p^Cv擾܂B<br>
 * {֐ ::criAtomExPlayer_SetPanType ֐ɂĐݒ肵p^Cvɉp^Cvԋp܂B<br>
 * Yݒ֐ĂяoĂȂꍇAf[^̐ݒlˑƂȂĂ܂ ::CRIATOMEX_PAN_TYPE_UNKNOWN ԋp܂B<br>
 * \par l:
 * ::CRIATOMEX_PAN_TYPE_AUTO ݒ肵ĂꍇAȉɏ]ĕԋpp^Cvω܂B
 * - ::CriAtomExConfig::enable_auto_matching_in_pan_type_auto ̐ݒ
 * - ::CriAtomEx3dListenerHn ݒ肳Ă邩ǂ
 * - ::CriAtomEx3dSourceHn ݒ肳Ă邩ǂ
 * - ::CriAtomEx3dSourceListHn ݒ肳Ă邩ǂ
 * \sa criAtomExPlayer_SetPanType
 */
CriAtomExPanType CRIAPI criAtomExPlayer_GetPanTypeOnPlayback(CriAtomExPlayerHn player);

/*JP
 * \brief pjȌo̓Xs[J[^Cvݒ
 * \ingroup ATOMEXLIB_PLAYER
 * \param[in]	player				AtomExv[[nh
 * \param[in]	pan_speaker_type	pjȌo̓Xs[J[^Cv
 * \par :
 * pjȌo̓Xs[J[^Cvw肵܂B<br>
 * {֐ŃpjȌo̓Xs[J[^CvݒA::criAtomExPlayer_Start ֐ɂĐJnƁAݒ肳ꂽo̓Xs[J[^CvŃpjOvZ܂B<br>
 * ܂ݒA::criAtomExPlayer_Update ֐A::criAtomExPlayer_UpdateAll ֐ĂяoƂɂA
 * łɍĐꂽ̏o̓Xs[J[^CvXV邱Ƃł܂B<br>
 * \par l:
 * {֐̐ݒ̓p3D3D|WVjOɂpjOvZɉe܂B<br>
 * CũftHgl4chpjOi::CRIATOMEX_PAN_SPEAKER_TYPE_4CHjłB<br>
 * ftHgl::criAtomExPlayer_ChangeDefaultPanSpeakerType ֐ɂĕύX\łB<br>
 * XeIXs[J[̃vbgtH[ł́AǂI񂾂ƂĂŏIIɂ̓XeIɃ_E~bNX܂B<br>
 * <br>
 * {p[^[̓f[^ɂ͐ݒłȂ߁Aɖ{֐̐ݒlKp܂B<br>
 * <br>
 * {p[^[ ::criAtomExPlayer_ResetParameters ֐ɂăNA܂B
 * \sa criAtomExPlayer_Start, criAtomExPlayer_Update, criAtomExPlayer_UpdateAll, CriAtomExPanSpeakerType, criAtomExPlayer_ResetParameters
 */
void CRIAPI criAtomExPlayer_SetPanSpeakerType(
	CriAtomExPlayerHn player, CriAtomExPanSpeakerType pan_speaker_type);

/*JP
 * \brief MixDownCenter{[ItZbgl̐ݒ
 * \ingroup ATOMEXLIB_PLAYER
 * \param[in]	player							AtomExv[[nh
 * \param[in]	mixdown_center_volume_offset	MixDownCenter{[̃ItZbgl
 * \par :
 * Center, LFEȊO̐MmɃ~bNXCenterɏo͂邽߂̃{[lݒ肵܂B<br>
 * {֐ɂݒĺACRI Atom Craftɂf[^ݒlɑ΂ĉZKp܂B<br>
 * {֐̑mixdown_center_volume_offsetɂ0`1̕_lŏo̓{[ݒ肵ĂB<br>
 * \attention
 * ݒl͈̔͊OmF͍s܂B͈͊Oݒ肷ۂɂ͈ȉ̓_ɒӂĂB<br>
 * 1傫lFo͐Ul̑ɂNbsOmCY邱Ƃ܂B<br>
 * lFf[^ݒlƂ̘aƂȂꍇ́Alʂɑ΂Ĉʑ𔽓]ʂo͂܂B<br>
 * \sa criAtomExPlayer_Start, criAtomExPlayer_Update, criAtomExPlayer_UpdateAll, CriAtomExPanSpeakerType, criAtomExPlayer_ResetParameters
 */
void CRIAPI criAtomExPlayer_AddMixDownCenterVolumeOffset(
	CriAtomExPlayerHn player, CriFloat32 mixdown_center_volume_offset);

/*JP
 * \brief MixDownLFE{[ItZbgl̐ݒ
 * \ingroup ATOMEXLIB_PLAYER
 * \param[in]	player							AtomExv[[nh
 * \param[in]	mixdown_lfe_volume_offset		MixDownLFE{[̃ItZbgl
 * \par :
 * Center, LFEȊO̐MmɃ~bNXLFEɏo͂邽߂̃{[lݒ肵܂B<br>
 * {֐ɂݒĺACRI Atom Craftɂf[^ݒlɑ΂ĉZKp܂B<br>
 * {֐̑mixdown_lfe_volume_offsetɂ0`1̕_lŏo̓{[ݒ肵ĂB<br>
 * \attention
 * ݒl͈̔͊OmF͍s܂B͈͊Oݒ肷ۂɂ͈ȉ̓_ɒӂĂB<br>
 * 1傫lFo͐Ul̑ɂNbsOmCY邱Ƃ܂B<br>
 * lFf[^ݒlƂ̘aƂȂꍇ́Alʂɑ΂Ĉʑ𔽓]ʂo͂܂B<br>
 * \sa criAtomExPlayer_Start, criAtomExPlayer_Update, criAtomExPlayer_UpdateAll, CriAtomExPanSpeakerType, criAtomExPlayer_ResetParameters
 */
void CRIAPI criAtomExPlayer_AddMixDownLfeVolumeOffset(
	CriAtomExPlayerHn player, CriFloat32 mixdown_lfe_volume_offset);

/*JP
 * \brief pjȌo̓Xs[J[^Cvݒ̃ftHglύX
 * \ingroup ATOMEXLIB_PLAYER
 * \param[in]	pan_speaker_type	pjȌo̓Xs[J[^Cv
 * \par :
 * pjȌo̓Xs[J[^CṽftHglύX܂B<br>
 * ::criAtomExPlayer_SetPanSpeakerType ֐sĂȂAtomExv[[́ASĖ{֐Őݒ肵o̓Xs[J[^CvōĐ܂B<br>
 * \par l:
 * {֐̐ݒ̓p3D3D|WVjOɂpjOvZɉe܂B<br>
 * CũftHgl ASR ̏o ch `l\ɈˑZ^[Xs[J[܂߂Ȃi::CRIATOMEX_PAN_SPEAKER_TYPE_AUTOjłB<br>
 * XeIXs[J[̃vbgtH[ł́AǂI񂾂ƂĂŏIIɂ̓XeIɃ_E~bNX܂B<br>
 * <br>
 * {p[^[̓f[^ɂ͐ݒłȂ߁Aɖ{֐̐ݒlKp܂B<br>
 * \attention
 * Đ̉ftHglQƂ^C~O̓[U[̑Ɉˑ܂B<br>
 * ̂߁AĐɃftHglύXꍇAӐ}^C~OŕύXfƂ͌܂B<br>
 * {֐gpꍇAȂǉĐOɎs悤ɂĂB<br>
 * \sa criAtomExPlayer_SetPanSpeakerType, CriAtomExPanSpeakerType
 */
void CRIAPI criAtomExPlayer_ChangeDefaultPanSpeakerType(
	CriAtomExPanSpeakerType pan_speaker_type);

/*JP
 * \brief ftHg̃pjO㏑
 * \ingroup ATOMEXLIB_PLAYER
 * \param[in]	func	pjO֐
 * \param[in]	obj		[UwIuWFNg
 * \par :
 * pjO[U[Ǝ̏ɒu܂B<br>
 * \par l:
 * {֐ŃpjO֐o^ƁAAtomCũpjOA
 * pjO̍ۂɃ[U[w肵R[obN֐Ăяo悤삪ύX܂B<br>
 * R[obNŃZhx}gNX𑀍삷邱ƂɂA
 * [U[Ǝ̃pjOASYgp邱Ƃ\ƂȂ܂B
 * \sa CriAtomExPlayerPanCbFunc
 */
void CRIAPI criAtomExPlayer_OverrideDefaultPanMethod(CriAtomExPlayerPanCbFunc func, void *obj);

/*JP
 * \brief pjO̊px^Cvݒ
 * \ingroup ATOMEXLIB_PLAYER
 * \param[in]	player				AtomExv[[nh
 * \param[in]	pan_angle_type	pjO̊px^Cv
 * \par :
 * pjO̊px^Cvw肵܂B<br>
 * px^Cv́A}``liXeIA5.1chj̉fނpjOƂɁAe̓`lǂ̂悤ȊpxƂĈ\܂B<br>
 * {֐ŃpjO̊px^CvݒA::criAtomExPlayer_Start ֐ɂĐJnƁAݒ肳ꂽpx^CvŃpjOvZ܂B<br>
 * ܂ݒA::criAtomExPlayer_Update ֐A::criAtomExPlayer_UpdateAll ֐ĂяoƂɂA
 * łɍĐꂽ̊px^CvXV邱Ƃł܂B<br>
 * \par l:
 * {֐̐ݒ̓p3D3D|WVjOɂpjOvZɉe܂B<br>
 * ftHgl̓ItZbgi::CRIATOMEX_PAN_ANGLE_TYPE_OFFSETjłB<br>
 * {֐́AɂCRI AudioƂ̌݊pɎgp܂B
 * {֐ ::CRIATOMEX_PAN_ANGLE_TYPE_FIX ݒ肷邱ƂŁACRI Audioł̃p3DvZƓɂȂ܂B<br>
 * <br>
 * {p[^[̓f[^ɂ͐ݒłȂ߁Aɖ{֐̐ݒlKp܂B<br>
 * <br>
 * {p[^[ ::criAtomExPlayer_ResetParameters ֐ɂăNA܂B
 * \sa criAtomExPlayer_Start, criAtomExPlayer_Update, criAtomExPlayer_UpdateAll, CriAtomExPanAngleType, criAtomExPlayer_ResetParameters
 */
void CRIAPI criAtomExPlayer_SetPanAngleType(
	CriAtomExPlayerHn player, CriAtomExPanAngleType pan_angle_type);

/*JP
 * \brief }``l̍Lݒ
 * \ingroup ATOMEXLIB_PLAYER
 * \param[in]	player		AtomExv[[nh
 * \param[in]	wideness	}``l̍L
 * \par :
 * }``l̍Lw肵܂B<br>
 * }``liXeIA5.1chj̉fނpjOƂɁAe̓`lԂ̊pxǂꂾL邩w肵܂B<br>
 *  wideness ̒l 0.0 ` 1.0 łBftHgl 1.0 łB<br>
 * Ⴆ΃XeIL0.5ōĐƁAʂ猩č`l-15x(-30x*0.5)AE`l15x(30x*0.5)ɒʂ悤pjOvZ܂B<br>
 * mɂ͉e܂B<br>
 * \par lF
 * {֐ŃpjO̊px^CvݒA::criAtomExPlayer_Start ֐ɂĐJnƁAݒ肳ꂽLŃpjOvZ܂B<br>
 * ܂ݒA::criAtomExPlayer_Update ֐A::criAtomExPlayer_UpdateAll ֐ĂяoƂɂA
 * łɍĐꂽ̍LXV邱Ƃł܂B<br>
 * <br>
 * {p[^[ ::criAtomExPlayer_ResetParameters ֐ɂăNA܂B
 * \sa criAtomExPlayer_Start, criAtomExPlayer_Update, criAtomExPlayer_UpdateAll, criAtomExPlayer_ResetParameters, criAtomExPlayer_SetSpread
 */
void CRIAPI criAtomExPlayer_SetWideness(CriAtomExPlayerHn player, CriFloat32 wideness);

/*JP
 * \brief Xvbh̐ݒ
 * \ingroup ATOMEXLIB_PLAYER
 * \param[in]	player		AtomExv[[nh
 * \param[in]	spread		Xvbh
 * \par :
 * Xvbhw肵܂B<br>
 * Xvbh́A̒ʊ𑀍삷p[^[łB<br>
 *  spread ̒l 0.0 ` 1.0 łBftHgl 0.0 łB<br>
 * spread ̒l傫قǁA̒ʊ܂B<br>
 * Ⴆ΁A-30xɔzúAftHgݒiXvbh̒l0̏ԁjłLXs[J[݂̂o͂܂B<br>
 * Xvbh̒lύXꍇALXs[J[łȂA͂̃̕Xs[J[ŏo͂悤ω܂B<br>
 * ::criAtomExPlayer_SetWideness ֐ƈقȂAmɂKp\łB
 * \par lF
 * {֐ŃpjO̊px^CvݒA::criAtomExPlayer_Start ֐ɂĐJnƁAݒ肳ꂽLŃpjOvZ܂B<br>
 * ܂ݒA::criAtomExPlayer_Update ֐A::criAtomExPlayer_UpdateAll ֐ĂяoƂɂA
 * łɍĐꂽ̍LXV邱Ƃł܂B<br>
 * <br>
 * {p[^[ ::criAtomExPlayer_ResetParameters ֐ɂăNA܂B
 * \sa criAtomExPlayer_Start, criAtomExPlayer_Update, criAtomExPlayer_UpdateAll, criAtomExPlayer_ResetParameters, criAtomExPlayer_SetWideness
 */
void CRIAPI criAtomExPlayer_SetSpread(CriAtomExPlayerHn player, CriFloat32 spread);

/*JP
 * \brief Zhx̐ݒ
 * \ingroup ATOMEXLIB_PLAYER
 * \param[in]	player		AtomExv[[nh
 * \param[in]	ch			`lԍ
 * \param[in]	spk			Xs[J[ID
 * \param[in]	level		Zhxli0.0f`1.0fj
 * \par :
 * Zhxw肵܂B<br>
 * Zhx́Af[^̊e`l̉Aǂ̃Xs[J[
 * ǂ̒x̉ʂŏo͂邩w肷邽߂̎dg݂łB<br>
 * {֐ŃZhxݒA::criAtomExPlayer_Start ֐ɂĐJnƁA
 * ݒ肳ꂽZhxōĐ܂B<br>
 * ܂ݒA::criAtomExPlayer_Update ֐A::criAtomExPlayer_UpdateAll ֐ĂяoƂɂA
 * łɍĐꂽ̃ZhxXV邱Ƃł܂B<br>
 * <br>
 * 2̃`lԍ"f[^̃`lԍ"w肵܂B<br>
 * 3̃Xs[J[IDɂ́Aw肵`lԍ̃f[^ǂ̃Xs[J[
 * o͂邩w肵A4ł͑M̃xi{[jw肵܂B<br>
 * Ⴆ΁Af[^̃`l0Ԃ̃f[^CgXs[J[
 * t{[i1.0fjŏo͂ꍇAw͈ȉ̂悤ɂȂ܂B
 * \code
 * criAtomExPlayer_SetSendLevel(player, 0, CRIATOMEX_SPEAKER_FRONT_RIGHT, 1.0f);
 * \endcode
 * <br>
 * Zhxl͈̔͂∵́A{[ƓłB::criAtomExPlayer_SetVolume ֐QƂĂB<br>
 * <br>
 * ȂAZ^[Xs[J[̂vbgtH[ŁAmZ^[Xs[J[݂̂o͂ꍇA
 * {֐ł͂Ȃ::criAtomExPlayer_SetPanSpeakerType ֐::CRIATOMEX_PAN_SPEAKER_TYPE_5CH
 * ݒ肷邱ƂE߂܂B<br>
 * \par :
 * \code
 * CriSint32 ch = 0;	// channel number 0
 * CriAtomExSpeakerId spk = CRIATOMEX_SPEAKER_FRONT_CENTER;
 * CriFloat32 level = 1.0f;
 * // Set send level(ch0 to center)
 * criAtomExPlayer_SetSendLevel(player, ch, spk, level);
 * // Start playback
 * id = criAtomExPlayer_Start(player);
 *                :
 * // Change send level
 * level = 0.7f;
 * criAtomExPlayer_SetSendLevel(player, ch, spk, level);
 * criAtomExPlayer_Update(player, id);
 * \endcode
 * \par l:
 * Zhx̐ݒɂ́uݒvu蓮ݒv2ʂ肪݂܂B<br>
 * AtomExv[[쐬A ::criAtomExPlayer_ResetParameters ֐
 * p[^[NAꍇAZhx̐ݒ́uݒvƂȂ܂B<br>
 * ɑ΂A{֐sꍇAZhx̐ݒ́u蓮ݒvɂȂ܂B<br>
 * i[UeXs[J[ւ̃ZhxRg[ApjOsKv܂Bj<br>
 * <br>
 * uݒv̏ꍇAAtomExv[[͈ȉ̂悤ɉ[eBO܂B<br>
 * <br>
 * ymĐꍇz<br>
 * `l0̉ẼXs[J[0.7fi-3dBj̃{[ŏo͂܂B<br>
 * <br>
 * yXeIĐꍇz<br>
 * `l0̉tgXs[J[A
 * `l1̉CgXs[J[o͂܂B<br>
 * <br>
 * y4chĐꍇz<br>
 * `l0̉tgXs[J[A`l1̉CgXs[J[A
 * `l2̉TEhtgXs[J[A
 * `l3̉TEhCgXs[J[炻ꂼo͂܂B<br>
 * <br>
 * y5.1chĐꍇz<br>
 * `l0̉tgXs[J[A`l1̉CgXs[J[A
 * `l2̉Z^[Xs[J[A`l3̉LFEA
 * `l4̉TEhtgXs[J[A
 * `l5̉TEhCgXs[J[炻ꂼo͂܂B<br>
 * <br>
 * y7.1chĐꍇz<br>
 * `l0̉tgXs[J[A`l1̉CgXs[J[A
 * `l2̉Z^[Xs[J[A`l3̉LFEA
 * `l4̉TEhtgXs[J[A
 * `l5̉TEhCgXs[J[炻ꂼo͂܂B<br>
 * `l6̉TEhobNtgXs[J[A
 * `l7̉TEhobNCgXs[J[炻ꂼo͂܂B<br>
 * <br>
 * ɑ΂A{֐pāu蓮ݒvsꍇAf[^̃`l
 * ֌WȂAw肳ꂽZhxݒŉo͂܂B<br>
 * if[^̃`lɉāAKXZhxݒ؂ւKv܂Bj<br>
 * <br>
 * ߋɎw肵ZhxNAA[eBOuݒv̏Ԃɖ߂ꍇ́A
 * ::criAtomExPlayer_ResetParameters ֐sĂB<br>
 * <br>
 * {p[^[̓f[^ɂ͐ݒłȂ߁Aɖ{֐̐ݒlKp܂B<br>
 * \attention
 * Zhxݒ肵ĂȂ`lɂẮAo͂܂B<br>
 * Ⴆ΁AĐ鉹f[^XeIɂ炸Aǂ炩̃`lɑ΂
 * Zhxݒ肳ĂȂꍇAZhxݒ肵ĂȂ`l̉
 * ̓~[g܂B<br>
 * ZhxRg[ۂɂ́AKo͂sSẴ`lɂăZh
 * x̐ݒsĂB<br>
 * <br>
 * {֐păZhxݒ肵ꍇAp3D3D|WVjO̐ݒ͖܂B<br>
 * \sa criAtomExPlayer_Start, criAtomExPlayer_Update, criAtomExPlayer_UpdateAll, criAtomExPlayer_SetVolume, criAtomExPlayer_SetPanSpeakerType, criAtomExPlayer_ResetParameters
 */
void CRIAPI criAtomExPlayer_SetSendLevel(
	CriAtomExPlayerHn player, CriSint32 ch, CriAtomExSpeakerId spk, CriFloat32 level);

/*JP
 * \brief oXZhx̐ݒ
 * \ingroup ATOMEXLIB_PLAYER
 * \param[in]	player		AtomExv[[nh
 * \param[in]	bus_name	oX
 * \param[in]	level		Zhxli0.0f`1.0fj
 * \par :
 * oXZhxw肵܂B<br>
 * oXZhx́Aǂ̃oXɂǂꂾw肷邽߂̎dg݂łB<br>
 * {֐ŃoXZhxݒA::criAtomExPlayer_Start ֐ɂĐJnƁA
 * ݒ肳ꂽoXZhxōĐ܂B<br>
 * ܂ݒA::criAtomExPlayer_Update ֐A::criAtomExPlayer_UpdateAll ֐ĂяoƂɂA
 * łɍĐꂽ̃oXZhxXV邱Ƃł܂B<br>
 * L[ĐAf[^ɃoXZhxݒ肳Ăꍇɖ{֐ĂяoƁA
 * f[^ɐݒ肳ĂlƖ{֐ɂݒlƂ<b>Z</b>lKp܂B<br>
 * <br>
 * 2ɂDSPoXݒ̃oXw肵܂B<br>
 * 3ł͑M̃xi{[jw肵܂B<br>
 * <br>
 * 2̃oXŎw肵oXKpDSPoXݒɑ݂ȂꍇAݒl͖lƂď܂B<br>
 * Zhxl͈̔͂∵́A{[ƓłB::criAtomExPlayer_SetVolume ֐QƂĂB
 * \par :
 * \code
 * 	F
 * // oXZhxݒ
 * cosnt CriChar8* bus_name = "Reverb";
 * CriFloat32 level = 0.3f;
 * criAtomExPlayer_SetBusSendLevelByName(player, bus_name, level);
 * 
 * // Đ̊Jn
 * id = criAtomExPlayer_Start(player);
 * 	F
 * // p[^[̕ύX
 * // Ӂj̎_ł͍Đ̉̃p[^[͕ύXȂB
 * level = 0.5f;
 * criAtomExPlayer_SetBusSendLevelByName(player, bus_name, level);
 * 
 * // v[[ɐݒ肳ꂽp[^[Đ̉ɂf
 * criAtomExPlayer_Update(player, id);
 * 	F
 * \endcode
 * \par l:
 * {֐ɈقȂoXw肵ĕĂяoƂŁÃoXɗƂł܂B<br>
 * <br>
 * {p[^[ ::criAtomExPlayer_ResetParameters ֐ɂăNA܂B
 * \sa criAtomExPlayer_Start, criAtomExPlayer_Update, criAtomExPlayer_UpdateAll, criAtomExPlayer_SetVolume, criAtomExPlayer_ResetParameters
 */
void CRIAPI criAtomExPlayer_SetBusSendLevelByName(
	CriAtomExPlayerHn player, const CriChar8* bus_name, CriFloat32 level);

/*JP
 * \brief oXZhx̃Zbg
 * \ingroup ATOMEXLIB_PLAYER
 * \param[in]	player			AtomExv[[nh
 * \par :
 *  AtomEx v[[ɐݒ肳ĂoXZhZbgAԁiݒԁjɖ߂܂B<br>
 * \sa criAtomExPlayer_SetBusSendLevelByName
 */
void CRIAPI criAtomExPlayer_ResetBusSends(CriAtomExPlayerHn player);

/*JP
 * \brief oXZhx̎擾
 * \ingroup ATOMEXLIB_PLAYER
 * \param[in]	player		AtomEx v[[nh
 * \param[in]	bus_name	oX
 * \param[out]	level		oXZhxli0.0f`1.0fj
 * \return		CriBool		oXZhxl擾łǂHi擾łFCRI_TRUE^擾łȂFCRI_FALSEj
 * \par :
 * w肵 AtomEx v[[ɐݒ肳ẴoXZhx擾܂B<br>
 * <br>
 * 2ɂDSPoXݒ̃oXw肵܂B<br>
 * <br>
 * ȂAȉ̃P[XɊYꍇAoXZhx̎擾Ɏs܂B
 *	- 2̃oXŎw肵oXKpDSPoXݒɑ݂Ȃ
 *	- 1ɂĎw肵 AtomEx v[[ɑ2̃oXɊւoXZhx̐ݒsĂȂ
 * 	
 * \sa criAtomExPlayer_SetBusSendLevelByName
 */
CriBool CRIAPI criAtomExPlayer_GetBusSendLevelByName(
	CriAtomExPlayerHn player, const CriChar8* bus_name, CriFloat32* level);

/*JP
 * \brief oXZhx̐ݒiItZbgwj
 * \ingroup ATOMEXLIB_PLAYER
 * \param[in]	player			AtomExv[[nh
 * \param[in]	bus_name		oX
 * \param[in]	level_offset	Zhxli0.0f`1.0fj
 * \par :
 * oXZhxItZbgŎw肵܂B<br>
 * L[ĐAf[^ɃoXZhxݒ肳Ăꍇɖ{֐ĂяoƁA
 * f[^ɐݒ肳ĂlƖ{֐ɂݒlƂ<b>Z</b>lKp܂B<br>
 * ȊO̎dl ::criAtomExPlayer_SetBusSendLevelByName ֐ƓlłB
 * \par l:
 * ::criAtomExPlayer_SetBusSendLevelByName ֐ 0.0f ݒ肵A{֐ŃItZbglݒ肷邱ƂŁA<br>
 * f[^ɐݒ肳ĂoXZhx𖳎Ēlݒ\łBi㏑ݒj<br>
 * <br>
 * {p[^[ ::criAtomExPlayer_ResetParameters ֐ɂăNA܂B
 * \sa criAtomExPlayer_SetBusSendLevelByName, criAtomExPlayer_ResetParameters
 */
void CRIAPI criAtomExPlayer_SetBusSendLevelOffsetByName(
	CriAtomExPlayerHn player, const CriChar8* bus_name, CriFloat32 level_offset);

/*JP
 * \brief oXZhx̃ItZbg̎擾
 * \ingroup ATOMEXLIB_PLAYER
 * \param[in]	player			AtomEx v[[nh
 * \param[in]	bus_name		oX
 * \param[out]	level_offset	oXZhx̃ItZbgli0.0f`1.0fj
 * \return		CriBool			oXZhx̃ItZbgl擾łǂHi擾łFCRI_TRUE^擾łȂFCRI_FALSEj
 * \par :
 * w肵 AtomEx v[[ɐݒ肳ẴoXZhx̃ItZbg擾܂B<br>
 * <br>
 * 2ɂDSPoXݒ̃oXw肵܂B<br>
 * <br>
 * ȂAȉ̃P[XɊYꍇAoXZhx̃ItZbg̎擾Ɏs܂B
 *	- 2̃oXŎw肵oXKpDSPoXݒɑ݂Ȃ
 *	- 1ɂĎw肵 AtomEx v[[ɑ2̃oXɊւoXZhx̐ݒsĂȂ
 * 	
 * \sa criAtomExPlayer_SetBusSendLevelByName
 */
CriBool CRIAPI criAtomExPlayer_GetBusSendLevelOffsetByName(
	CriAtomExPlayerHn player, const CriChar8* bus_name, CriFloat32* level_offset);

/*JP
 * \brief ADX1݊̃p̐ݒ
 * \ingroup ATOMEXLIB_PLAYER
 * \param[in]	player		AtomExv[[nh
 * \param[in]	ch			`lԍ
 * \param[in]	pan			pݒli-1.0f`1.0fj
 * \par :
 * ADX1݊̃pݒ֐łB<br>
 * \par l:
 * {p[^[ ::criAtomExPlayer_ResetParameters ֐ɂăNA܂B
 * \attention
 * {֐ADX1̈ڐA^CgpɗpӂĂ܂B<br>
 * ADXŐVKɃpsAvP[V쐬ꍇA
 * ::criAtomExPlayer_SetPan3dAngle ֐gpĂB<br>
 * <br>
 * {֐ŃpݒA::criAtomExPlayer_Start ֐ɂĐJnƁAݒ肳ꂽpōĐ܂B<br>
 * łɍĐꂽ̃pύXꍇA{֐ŐVȃpݒv[[Ɏw肵A
 * ::criAtomExPlayer_Update ֐A::criAtomExPlayer_UpdateAll ֐ōĐ̉ɂ̃p[^[KpKv܂B<br>
 * <br>
 * {֐ŃpRg[\Ȃ̂́AmƃXeÎ݂łB
 * ܂AE̒ʂ̂݃Rg[ł܂B<br>
 * 3chȏ̉ɑ΂ăpRg[ꍇAO܂߂ʂRg[ꍇɂ́A
 * ::criAtomExPlayer_SetPan3dAngle ֐::criAtomExPlayer_SetSendLevel ֐gpKv܂B<br>
 * <br>
 * Đ鉹f[^XeȈꍇA`l0Ԃƃ`l1Ԃ̂ꂼ̃p
 * ɂāAƗăRg[邱Ƃ\łB<br>
 * Aݒ肳ꂽpmȂ̂AXeIȂ̂͋
 * Ȃ߁AXeIݒpɃpݒsAtomExv[[ŃmĐ
 * ꍇAӐ}Ȃʒuɉʂ\܂B<br>
 * <br>
 * Đ鉹f[^XeIɂ炸Aǂ炩̃`lɑ΂
 * pݒ肳ĂȂꍇApݒ肵ĂȂ`l̉̒ʈʒu
 *  0.0f ȉójɂȂ܂B<br>
 * XeĨpRg[ۂɂ́AK̃`lɂăp
 * ݒsĂB<br>
 * <br>
 * {֐::criAtomExPlayer_SetPan3dAngle ֐ ::criAtomExPlayer_SetSendLevel ֐𕹗pȂłB<br>
 * ҂𕹗pꍇAӐ}ȂpōĐ\܂B<br>
 * \sa criAtomExPlayer_Start, criAtomExPlayer_Update, criAtomExPlayer_UpdateAll,
 * criAtomExPlayer_SetPan3dAngle, criAtomExPlayer_SetSendLevel, criAtomExPlayer_ResetParameters
 */
void CRIAPI criAtomExPlayer_SetPanAdx1Compatible(
	CriAtomExPlayerHn player, CriSint32 ch, CriFloat32 pan);

/*JP
 * \brief ohpXtB^[̃p[^[ݒ
 * \ingroup ATOMEXLIB_PLAYER
 * \param[in]	player		AtomExv[[nh
 * \param[in]	cof_low		KJbgItgi0.0f`1.0fj
 * \param[in]	cof_high	KJbgItgi0.0f`1.0fj
 * \par :
 * ohpXtB^[̃JbgItgw肵܂B<br>
 * {֐ŃJbgItgݒA::criAtomExPlayer_Start ֐ɂĐJnƁA
 * ݒ肳ꂽJbgItgŃohpXtB^[삵܂B<br>
 * ܂ݒA::criAtomExPlayer_Update ֐A::criAtomExPlayer_UpdateAll ֐ĂяoƂɂA
 * łɍĐꂽɑ΂ăohpXtB^[̃JbgItgXV邱Ƃł܂B<br>
 * <br>
 * KJbgItǵAΐ24Hz`24000HzA0.0f`1.0fɐKlłB<br>
 * Ⴆ΁AKJbgItg0.0fAKJbgItg1.0fƎw肷ƁA
 * ohpXtB^[͑S悪ʉ߂AKJbgItgグقǁA
 * ܂KJbgItgقǁAʉ߈悪ȂĂ܂B<br>
 * \par :
 * \code
 * 	F
 * // tB^[̃p[^[ݒ
 * CriFloat32 cof_low = 0.0f;
 * CriFloat32 cof_high = 0.3f;
 * criAtomExPlayer_SetBandpassFilterParameters(player, cof_low, cof_high);
 * 
 * // Đ̊Jn
 * id = criAtomExPlayer_Start(player);
 * 	F
 * // p[^[̕ύX
 * // Ӂj̎_ł͍Đ̉̃p[^[͕ύXȂB
 * cof_low = 0.7f;
 * cof_high = 1.0f;
 * criAtomExPlayer_SetBandpassFilterParameters(player, cof_low, cof_high);
 * 
 * // v[[ɐݒ肳ꂽp[^[Đ̉ɂf
 * criAtomExPlayer_Update(player, id);
 * 	F
 * \endcode
 * \par l:
 * L[ĐAf[^ɃohpXtB^[̃p[^[ݒ肳Ăꍇɖ{֐ĂяoƁA
 * ȉ̂悤ɐݒ肳܂B
 * - cof_low<br>
 * 	f[^ɐݒ肳ꂽlɑ΂Aucof_low_rev = 1.0f - cof_lowvƂĂZAŏIIɂ܂ucof_low = 1.0f - cof_low_revvƌɖ߂ēKp܂B<br>
 * 	܂A0.0fu摤ɍłtB^[JvƂāAJZēKpĂ`ɂȂ܂B
 * - cof_high<br>
 * 	f[^ɐݒ肳ꂽlɑ΂AZēKp܂B<br>
 * 	܂A1.0fu摤ɍłtB^[JvƂāAJZēKpĂ`ɂȂ܂B
 * 
 * <br>
 * ۂɓKp鐳KJbgItg1.0f𒴂lɂȂꍇAl1.0fɃNbv܂B<br>
 * lɁAۂɓKp鐳KJbgItg0.0f̒lɂȂꍇAl0.0fɃNbv܂B<br>
 * <br>
 * {p[^[ ::criAtomExPlayer_ResetParameters ֐ɂăNA܂B
 * \sa criAtomExPlayer_Start, criAtomExPlayer_Update, criAtomExPlayer_UpdateAll, criAtomExPlayer_ResetParameters
 */
void CRIAPI criAtomExPlayer_SetBandpassFilterParameters(
	CriAtomExPlayerHn player, CriFloat32 cof_low, CriFloat32 cof_high);

/*JP
 * \brief oCNAbhtB^[̃p[^[ݒ
 * \ingroup ATOMEXLIB_PLAYER
 * \param[in]	player		AtomExv[[nh
 * \param[in]	type		tB^[^Cv
 * \param[in]	frequency	Kgi0.0f`1.0fj
 * \param[in]	gain		QCifVxlj
 * \param[in]	q_value		Ql
 * \par :
 * oCNAbhtB^[̊ep[^[w肵܂B<br>
 * {֐Ńp[^[ݒA::criAtomExPlayer_Start ֐ɂĐJnƁA
 * ݒ肳ꂽp[^[ŃoCNAbhtB^[삵܂B<br>
 * ܂ݒA::criAtomExPlayer_Update ֐A::criAtomExPlayer_UpdateAll ֐ĂяoƂɂA
 * łɍĐꂽɑ΂ăoCNAbhtB^[̃p[^[XV邱Ƃł܂B<br>
 * <br>
 * KǵAΐ24Hz`24000HzA0.0f`1.0fɐKlłB<br>
 * QC̓fVxŎw肵܂B<br>
 * QC̓tB^[^Cvȉ̏ꍇ̂ݗLłB<br>
 * - CRIATOMEX_BIQUAD_FILTER_TYPE_LOWSHELFF[VFttB^[
 * - CRIATOMEX_BIQUAD_FILTER_TYPE_HIGHSHELFFnCVFttB^[
 * - CRIATOMEX_BIQUAD_FILTER_TYPE_PEAKINGFs[LOtB^[
 * 
 * \par :
 * \code
 * 	F
 * // tB^[̃p[^[ݒ
 * CriAtomExBiquadFilterType type = CRIATOMEX_BIQUAD_FILTER_TYPE_LOWPASS;
 * CriFloat32 frequency = 0.5f;
 * CriFloat32 gain = 1.0f;
 * CriFloat32 q_value = 3.0f;
 * criAtomExPlayer_SetBiquadFilterParameters(player, type, frequency, gain, q_value);
 * 
 * // Đ̊Jn
 * id = criAtomExPlayer_Start(player);
 * 	F
 * // p[^[̕ύX
 * // Ӂj̎_ł͍Đ̉̃p[^[͕ύXȂB
 * frequency = 0.7f;
 * criAtomExPlayer_SetBiquadFilterParameters(player, type, frequency, gain, q_value);
 * 
 * // v[[ɐݒ肳ꂽp[^[Đ̉ɂf
 * criAtomExPlayer_Update(player, id);
 * 	F
 * \endcode
 * \par l:
 * - type<br>
 * 	f[^ɐݒ肳ꂽl㏑܂B
 * - frequency<br>
 * 	f[^ɐݒ肳ꂽlɉZ܂B
 * - gain<br>
 * 	f[^ɐݒ肳ꂽlɏZ܂B
 * - q_value<br>
 *	f[^ɐݒ肳ꂽlɉZ܂B
 * 
 * <br>
 * ۂɓKp鐳KJbgItg1.0f𒴂lɂȂꍇAl1.0fɃNbv܂B<br>
 * lɁAۂɓKp鐳KJbgItg0.0f̒lɂȂꍇAl0.0fɃNbv܂B<br>
 * <br>
 * {p[^[ ::criAtomExPlayer_ResetParameters ֐ɂăNA܂B
 * \attention
 * HCA-MXpɃGR[hꂽf[^ɂ́AoCNAbhtB^[Kp܂B<br>
 * oCNAbhtB^[gṕAADXHCAÃR[fbNŃGR[hĂB<br>
 * <br>
 * ASRpłł́AlCeBu{CXo͎ɃtB^[gpł܂B<br>
 * ASRp\ȊŃoCNAbhtB^[gpꍇɂ́A
 * o̓TEh_ASRɐݒ肷Kv܂B<br>
 * \sa criAtomExPlayer_Start, criAtomExPlayer_Update, criAtomExPlayer_UpdateAll, criAtomExPlayer_ResetParameters
 */
void CRIAPI criAtomExPlayer_SetBiquadFilterParameters(
	CriAtomExPlayerHn player, CriAtomExBiquadFilterType type, CriFloat32 frequency,
	CriFloat32 gain, CriFloat32 q_value);

/*JP
 * \brief {CXvCIeB̐ݒ
 * \ingroup ATOMEXLIB_PLAYER
 * \param[in]	player		AtomExv[[nh
 * \param[in]	priority	{CXvCIeBi-255`255j
 * \par :
 * AtomExv[[Ƀ{CXvCIeBݒ肵܂B<br>
 * {֐ŃvCIeBZbgA ::criAtomExPlayer_Start ֐ŉĐƁA
 * Đꂽ͖{֐ŃZbgvCIeBŔ܂B<br>
 * ܂ݒA::criAtomExPlayer_Update ֐A::criAtomExPlayer_UpdateAll ֐ĂяoƂɂA
 * łɍĐꂽ̃vCIeBXV邱Ƃł܂B<br>
 * <br>
 * {CXvCIeBɂ́A-255`255͈̔͂Őlw肵܂B<br>
 * ͈͊O̒lݒ肵ꍇA͈͂Ɏ܂悤ɃNbsO܂B<br>
 * ֐sÕftHgݒl0łB<br>
 * \par l:
 * AtomExv[[g`f[^Đ悤ƂہA
 * Yg`f[^{CX~bgO[v̔ɒBĂꍇA
 * {CXv[̃{CXSĎgpłꍇA
 * {CXvCIeBɂ锭䂪s܂B<br>
 * iw肳ꂽg`f[^Đ邩ǂA{CXvCIeBƂɔ肵܂Bj<br>
 * <br>
 * ̓Iɂ́AĐsƂg`f[^̃vCIeBA
 * ݃{CXōĐ̔g`f[^̃vCIeBꍇA
 * AtomExv[[͍Đ̃{CXDANGXgꂽg`f[^̍ĐJn܂B<br>
 * iĐ̉~Aʂ̉Đ܂Bj<br>
 * <br>
 * tɁAĐsƂg`f[^̃vCIeBA
 * {CXōĐ̔g`f[^̃vCIeBႢꍇA
 * AtomExv[[̓NGXgꂽg`f[^̍Đs܂B<br>
 * iNGXgꂽ͍ĐꂸAĐ̉葱܂Bj<br>
 * <br>
 * Đ悤Ƃg`f[^̃vCIeBA
 * {CXōĐ̔g`f[^̃vCIeBƓꍇA
 * AtomExv[[͔i撅D or 㒅Djɏ]A
 * ȉ̂悤Ȑ䂪s܂B<br>
 * - 撅D掞́AĐ̔g`f[^D悵ANGXgꂽg`f[^Đ܂B
 * - 㒅D掞́ANGXgꂽg`f[^D悵A{CXD܂B
 * 
 * <br>
 * L[ĐAf[^Ƀ{CXvCIeBݒ肳Ăꍇɖ{֐ĂяoƁA
 * f[^ɐݒ肳ĂlƖ{֐ɂݒlƂ<b>Z</b>lKp܂B<br>
 * Ⴆ΁Af[^̃vCIeB255AAtomExv[[̃vCIeB45̏ꍇA
 * ۂɓKpvCIeB300ɂȂ܂B<br>
 * {֐Őݒ\Ȓl͈̔͂-255`255łACǔvZ CriSint32 ͈̔͂ōs邽߁A
 * f[^ƉZʂ-255`255𒴂ꍇ܂B<br>
 * <br>
 * {p[^[ ::criAtomExPlayer_ResetParameters ֐ɂăNA܂B
 * \attention
 * {֐́Ag`f[^ɃZbgꂽ<b>{CXvCIeB</b>𐧌䂵܂B<br>
 * Atom CraftŃL[ɑ΂Đݒ肳ꂽ<b>JeSL[vCIeB</b>ɂ͉e^܂̂ŁA
 * ӂB
 * \sa criAtomExPlayer_Start, criAtomExPlayer_Update, criAtomExPlayer_UpdateAll, criAtomExPlayer_SetVoiceControlMethod, criAtomExPlayer_ResetParameters
 */
void CRIAPI criAtomExPlayer_SetVoicePriority(
	CriAtomExPlayerHn player, CriSint32 priority);

/*JP
 * \brief AISACRg[l̐ݒiRg[IDwj
 * \ingroup ATOMEXLIB_PLAYER
 * \param[in]	player			AtomExv[[nh
 * \param[in]	control_id		Rg[ID
 * \param[in]	control_value	Rg[li0.0f`1.0fj
 * \par :
 * Rg[IDwAISAC̃Rg[lw肵܂B<br>
 * {֐AISACRg[lݒA::criAtomExPlayer_Start ֐ɂĐJnƁA
 * ݒ肳ꂽAISACRg[lōĐ܂B<br>
 * ܂ݒA::criAtomExPlayer_Update ֐A::criAtomExPlayer_UpdateAll ֐ĂяoƂɂA
 * łɍĐꂽAISACRg[lXV邱Ƃł܂B<br>
 * ݒ肵Rg[l폜ɂ́A::criAtomExPlayer_ClearAisacControls ֐gpĂB<br>
 * <br>
 * AISACRg[lɂ́A0.0f`1.0f͈̔͂Ŏlw肵܂B<br>
 * \par :
 * \code
 * 	F
 * // AISACRg[l̐ݒ
 * CriAtomExAisacControlId control_id = 0;
 * CriFloat32 control_value = 0.5f;
 * criAtomExPlayer_SetAisacControlById(player, control_id, control_value);
 * 
 * // Đ̊Jn
 * id = criAtomExPlayer_Start(player);
 * 	F
 * // p[^[̕ύX
 * // Ӂj̎_ł͍Đ̉̃p[^[͕ύXȂB
 * control_value = 0.3f;
 * criAtomExPlayer_SetAisacControlById(player, control_id, control_value);
 * 
 * // v[[ɐݒ肳ꂽp[^[Đ̉ɂf
 * criAtomExPlayer_Update(player, id);
 * 	F
 * \endcode
 * \par l:
 * AISAC̃Rg[^CvɂāAȉ̂悤ɋς܂B
 * - It
 * 		- {֐ɂAISACRg[lݒ̏ꍇ͂AISAC͓삵܂B
 * - I[gW[V
 * 		- {֐̐ݒlɂ͉eꂸAԌo߂ƂƂɎIAISACRg[lω܂B
 * - _
 * 		- {֐ɂĐݒ肳ꂽAISACRg[l𒆉lƂāAf[^ɐݒ肳ꂽ_Ń_}CYAŏIIAISACRg[l肵܂B
 * 		- _}CY͍ĐJñp[^[Kpł̂ݍsAĐ̉ɑ΂AISACRg[lύX͂ł܂B
 * 		- ĐJnAISACRg[lݒ肳ĂȂꍇA0.0f𒆉lƂă_}CYs܂B
 * 		
 * 
 * <br>
 * {p[^[ ::criAtomExPlayer_ResetParameters ֐ɂăNA܂B
 * \sa criAtomExPlayer_Start, criAtomExPlayer_Update, criAtomExPlayer_UpdateAll, criAtomExPlayer_SetAisacControlByName, criAtomExPlayer_ClearAisacControls, criAtomExPlayer_ResetParameters
 */
void CRIAPI criAtomExPlayer_SetAisacControlById(
	CriAtomExPlayerHn player, CriAtomExAisacControlId control_id, CriFloat32 control_value);

/*JP
 * \brief AISACRg[l̐ݒiRg[wj
 * \ingroup ATOMEXLIB_PLAYER
 * \param[in]	player			AtomExv[[nh
 * \param[in]	control_name	Rg[
 * \param[in]	control_value	Rg[li0.0f`1.0fj
 * \par :
 * Rg[wAISAC̃Rg[lw肵܂B<br>
 * {֐AISACRg[lݒA::criAtomExPlayer_Start ֐ɂĐJnƁA
 * ݒ肳ꂽAISACRg[lōĐ܂B<br>
 * ܂ݒA::criAtomExPlayer_Update ֐A::criAtomExPlayer_UpdateAll ֐ĂяoƂɂA
 * łɍĐꂽAISACRg[lXV邱Ƃł܂B<br>
 * ݒ肵Rg[l폜ɂ́A::criAtomExPlayer_ClearAisacControls ֐gpĂB<br>
 * <br>
 * AISACRg[l̈::criAtomExPlayer_SetAisacControlById ֐ƓlłB<br>
 * \par :
 * \code
 * 	F
 * // AISACRg[l̐ݒ
 * const CriChar8 *control_name = "Any";
 * CriFloat32 control_value = 0.5f;
 * criAtomExPlayer_SetAisacControlByName(player, control_name, control_value);
 * 
 * // Đ̊Jn
 * id = criAtomExPlayer_Start(player);
 * 	F
 * // p[^[̕ύX
 * // Ӂj̎_ł͍Đ̉̃p[^[͕ύXȂB
 * control_value = 0.3f;
 * criAtomExPlayer_SetAisacControlByName(player, control_name, control_value);
 * 
 * // v[[ɐݒ肳ꂽp[^[Đ̉ɂf
 * criAtomExPlayer_Update(player, id);
 * 	F
 * \endcode
 * \par l:
 * {p[^[ ::criAtomExPlayer_ResetParameters ֐ɂăNA܂B
 * \sa criAtomExPlayer_Start, criAtomExPlayer_Update, criAtomExPlayer_UpdateAll, criAtomExPlayer_SetAisacControlById, criAtomExPlayer_ClearAisacControls, criAtomExPlayer_ResetParameters
 */
void CRIAPI criAtomExPlayer_SetAisacControlByName(
	CriAtomExPlayerHn player, const CriChar8 *control_name, CriFloat32 control_value);

/*JP
 * \brief v[[ɐݒ肳ĂAISACRg[l̍폜
 * \ingroup ATOMEXLIB_PLAYER
 * \param[in]	player			AtomExv[[nh
 * \par :
 * v[[ɐݒ肳ĂAISACRg[lSč폜܂B<br>
 * ܂폜A::criAtomExPlayer_Update ֐A::criAtomExPlayer_UpdateAll ֐ĂяoƂɂA
 * łɍĐ̉ɑ΂AISACRg[l̍폜s܂B
 * \sa criAtomExPlayer_SetAisacControlById, criAtomExPlayer_SetAisacControlByName, criAtomExPlayer_Update, criAtomExPlayer_UpdateAll
 */
void CRIAPI criAtomExPlayer_ClearAisacControls(CriAtomExPlayerHn player);


/*JP
 * \brief 3Dnh̐ݒ
 * \ingroup ATOMEXLIB_PLAYER
 * \param[in]	player		AtomExv[[nh
 * \param[in]	source		3Dnh
 * \par :
 * 3D|WVjO邽߂3Dnhݒ肵܂B<br>
 * 3DXi[nh3Dnhݒ肷邱ƂŁA3DXi[nh3Dnḧʒu֌Wʂ≹ʁAsb`IɓKp܂B<br>
 * {֐3DnhݒA::criAtomExPlayer_Start ֐ɂĐJnƁA
 * ݒ肳ꂽ3DnhQƂčĐ܂B<br>
 * ܂ݒA::criAtomExPlayer_Update ֐A::criAtomExPlayer_UpdateAll ֐ĂяoƂɂA
 * łɍĐꂽQƂ3DnhύX邱Ƃł܂B<br>
 * sourceNULLݒ肵ꍇ́Ałɐݒ肳Ă3DnhNA܂B<br>
 * \par l:
 * {p[^[ ::criAtomExPlayer_ResetParameters ֐ɂăNA܂B
 * \attention
 * 3Dnh̃p[^[̕ύXAXV́AAtomExv[[̊֐ł͂ȂA3Dnh̊֐gpčs܂B<br>
 * ftHgł́A3D|WVjǑvZ͍Wnōs܂B<br>
 * EWnŊexNgݒ肷ꍇ́ACui ::criAtomEx_Initialize ֐ j̐ݒ
 * ::CriAtomExConfig::coordinate_system CRIATOMEX_COORDINATE_SYSTEM_RIGHT_HANDED w肵ĂB<br>
 * ACBt@CgpɉĐꍇ́AI3D|WVjOLɂ邽߂ɁA::criAtomExSetPanType ֐::CRIATOMEX_PAN_TYPE_3D_POSݒ肷Kv܂B<br>
 * <br>
 * {֐ ::criAtomExPlayer_Set3dSourceListHn ֐݂͂ɐݒ㏑܂B<br>
 * Ⴆ΁A ::criAtomExPlayer_Set3dSourceListHn ֐ɂ3DnhXgAtomExv[[ɐݒA{֐ɂAtomExv[[3Dnhݒ肷ƁA
 * AtomExv[[ɂ͐V3Dnhݒ肳Aɐݒ肳Ă3DnhXgAtomExv[[NA܂B
 * <br>
 * {֐pAtomExv[[ɐݒ肳ꂽ3Dnh́A3DnhXgɒǉ邱Ƃ͂ł܂B
 * 3DnhXgɒǉꍇ́Aɐݒ肳ĂAtomExv[[3DnhɊւݒNAĂB
 * \par :
 * \code
 * CriAtomEx3dListenerHn listener;
 * CriAtomEx3dSourceHn source;
 * CriAtomExVector pos;
 *
 * listener = criAtomEx3dListener_Create(NULL, NULL, 0);
 * source = criAtomEx3dSource_Create(NULL, NULL, 0);
 * player = criAtomExPlayer_Create(NULL, NULL, 0);
 * criAtomExPlayer_Set3dListenerHn(player, listener);
 * criAtomExPlayer_Set3dSourceHn(player, source);
 *
 * pos.x = 0.0f;
 * pos.y = 0.0f;
 * pos.z = 0.0f;
 * criAtomEx3dSource_SetPosition(source, &pos);
 * criAtomEx3dSource_Update(source);
 * // Start playback
 * id = criAtomExPlayer_Start(player);
 *                :
 * pos.x += 10.0f;
 * criAtomEx3dSource_SetPosition(source, &pos);
 * criAtomEx3dSource_Update(source);
 * \endcode
 * \sa CriAtomEx3dSourceHn, CriAtomEx3dSourceListHn, criAtomExPlayer_Set3dSourceListHn, criAtomEx3dListenerHn, criAtomExPlayer_SetListenerHn, criAtomExPlayer_Update, criAtomExPlayer_ResetParameters
 */
void CRIAPI criAtomExPlayer_Set3dSourceHn(
	CriAtomExPlayerHn player, CriAtomEx3dSourceHn source);

/*JP
 * \brief 3DnhXg̐ݒ
 * \ingroup ATOMEXLIB_PLAYER
 * \param[in]	player			AtomExv[[nh
 * \param[in]	source_list		3DnhXg
 * \par :
 * }`|WVjOĐ邽߂3DnhXgݒ肵܂B<br>
 * 3DXi[nh3DnhXgݒ肷邱ƂŁA3DXi[nh3DnhXg
 * SĂ3Dnḧʒu֌Wʂ≹ʁAsb`IɓKp܂B<br>
 * {֐3DnhXgݒA::criAtomExPlayer_Start ֐ɂĐJnƁA
 * ݒ肳ꂽ3DnhXgQƂčĐ܂B<br>
 * ܂ݒA::criAtomExPlayer_Update ֐A::criAtomExPlayer_UpdateAll ֐ĂяoƂɂA
 * łɍĐꂽQƂ3DnhXgύX邱Ƃł܂B<br>
 * source_listNULLݒ肵ꍇ́Ałɐݒ肳Ă3DnhXgNA܂B<br>
 * \par l:
 * {p[^[ ::criAtomExPlayer_ResetParameters ֐ɂăNA܂B
 * \attention
 * 3DnhXgɒǉĂ3Dnh̕ύXAXV́AAtomExv[[̊֐ł͂ȂA3Dnh̊֐gpčs܂B<br>
 * EWnŊexNgݒ肷ꍇ́ACui ::criAtomEx_Initialize ֐ j̐ݒ
 * ::CriAtomExConfig::coordinate_system CRIATOMEX_COORDINATE_SYSTEM_RIGHT_HANDED w肵ĂB<br>
 * ACBt@CgpɉĐꍇ́AI3D|WVjOLɂ邽߂ɁA::criAtomExSetPanType ֐::CRIATOMEX_PAN_TYPE_3D_POSݒ肷Kv܂B<br>
 * <br>
 * {֐ ::criAtomExPlayer_Set3dSourceHn ֐݂͂ɐݒ㏑܂B<br>
 * Ⴆ΁A ::criAtomExPlayer_Set3dSourceHn ֐ɂ3DnhAtomExv[[ɐݒA{֐ɂAtomExv[[3DnhXgݒ肷ƁA
 * AtomExv[[ɂ͐V3DnhXgݒ肳Aɐݒ肳Ă3DnhAtomExv[[NA܂B
 * \par :
 * \code
 * CriAtomEx3dListenerHn listener;
 * CriAtomEx3dSourceListHn source_list;
 * CriAtomEx3dSourceHn source[8];
 * CriAtomExVector pos[8];
 * CriSint32 i;
 *
 * listener = criAtomEx3dListener_Create(NULL, NULL, 0);
 * source_list = criAtomEx3dSourceList_Create(NULL, NULL, 0);
 * for (i = 0; i < 8; i++) {
 *     source[i] = criAtomEx3dSource_Create(NULL, NULL, 0);
 * 
 *     pos[i].x = (CriFloat32)i;
 *     pos[i].y = 0.0f;
 *     pos[i].z = 0.0f;
 *     criAtomEx3dSource_SetPosition(source, &pos);
 *     criAtomEx3dSource_Update(source);
 * 
 *     criAtomEx3dSourceList_Add(source_list, source[i]);
 * }
 * 
 * player = criAtomExPlayer_Create(NULL, NULL, 0);
 * criAtomExPlayer_Set3dListenerHn(player, listener);
 * criAtomExPlayer_Set3dSourceListHn(player, source_list);
 *
 * // Start playback
 * id = criAtomExPlayer_Start(player);
 *                :
 * pos[2].x += 25.0f;
 * criAtomEx3dSource_SetPosition(source[2], &pos);
 * criAtomEx3dSource_Update(source[2]);
 * pos[5].z += 10.0f;
 * criAtomEx3dSource_SetPosition(source[5], &pos);
 * criAtomEx3dSource_Update(source[5]);
 * \endcode
 * \sa CriAtomEx3dSourceListHn, CriAtomEx3dSourceHn, criAtomExPlayer_Set3dSourceHn, CriAtomEx3dListenerHn, CriAtomExPlayer_Set3dListenerHn, criAtomExPlayer_Update, criAtomExPlayer_ResetParameters
 */
void CRIAPI criAtomExPlayer_Set3dSourceListHn(
	CriAtomExPlayerHn player, CriAtomEx3dSourceListHn source_list);

/*JP
 * \brief 3DXi[nh̐ݒ
 * \ingroup ATOMEXLIB_PLAYER
 * \param[in]	player		AtomExv[[nh
 * \param[in]	listener	3DXi[nh
 * \par :
 * 3D|WVjO邽߂3DXi[nhݒ肵܂B<br>
 * 3DXi[nh3Dnh܂3DnhXgݒ肷邱ƂŁA3DXi[3Dnh܂
 * 3DnhXg̑SĂ3Dnḧʒu֌Wʂ≹ʁAsb`IɓKp܂B<br>
 * {֐3DXi[nhݒA::criAtomExPlayer_Start ֐ɂĐJnƁA
 * ݒ肳ꂽ3DXi[nhQƂčĐ܂B<br>
 * ܂ݒA::criAtomExPlayer_Update ֐A::criAtomExPlayer_UpdateAll ֐ĂяoƂɂA
 * łɍĐꂽQƂ3DXi[nhύX邱Ƃł܂B<br>
 * listenerNULLݒ肵ꍇ́Ałɐݒ肳Ă3DXi[nhNA܂B<br>
 * \par l:
 * {֐3DXi[nhݒ肵ĂȂĂAȉ̏𖞂Ăꍇ͎I3Dɑ΂čł̋߂3DXi[蓖Ă܂B<br>
 *  - 3Dnh܂3DnhXgݒ肳Ă
 *  - 3DXi[criAtomEx3dListener_Createɂč쐬Ă
 * 	
 * <br>
 * {p[^[ ::criAtomExPlayer_ResetParameters ֐ɂăNA܂B
 * \attention
 * 3DXi[nh̃p[^[̕ύXAXV́AAtomExv[[̊֐ł͂ȂA3DXi[nh̊֐gpčs܂B<br>
 * ftHgł́A3D|WVjǑvZ͍Wnōs܂B<br>
 * EWnŊexNgݒ肷ꍇ́ACui ::criAtomEx_Initialize ֐ j̐ݒ
 * ::CriAtomExConfig::coordinate_system CRIATOMEX_COORDINATE_SYSTEM_RIGHT_HANDED w肵ĂB<br>
 * <br>
 * \par :
 * \code
 * CriAtomEx3dListenerHn listener;
 * CriAtomEx3dSourceHn source;
 * CriAtomExVector pos;
 *
 * listener = criAtomEx3dListener_Create(NULL, NULL, 0);
 * source = criAtomEx3dSource_Create(NULL, NULL, 0);
 * player = criAtomExPlayer_Create(NULL, NULL, 0);
 * criAtomExPlayer_Set3dListenerHn(player, listener);
 * criAtomExPlayer_Set3dSourceHn(player, source);
 *
 * pos.x = 0.0f;
 * pos.y = 0.0f;
 * pos.z = 0.0f;
 * criAtomEx3dSource_SetPosition(source, &pos);
 * criAtomEx3dSource_Update(source);
 * // Start playback
 * id = criAtomExPlayer_Start(player);
 *                :
 * pos.x += 10.0f;
 * criAtomEx3dSource_SetPosition(source, &pos);
 * criAtomEx3dSource_Update(source);
 * \endcode
 * \sa CriAtomEx3dListenerHn, criAtomExPlayer_Set3dSourceHn, criAtomExPlayer_Update, criAtomExPlayer_ResetParameters
 */
void CRIAPI criAtomExPlayer_Set3dListenerHn(
	CriAtomExPlayerHn player, CriAtomEx3dListenerHn listener);

/*JP
 * \brief AISACRg[l̎擾iRg[IDwj
 * \ingroup ATOMEXLIB_PLAYER
 * \param[in]	player			AtomExv[[nh
 * \param[in]	control_id		Rg[ID
 * \return		CriFloat32		Rg[li0.0f`1.0fjAݒ莞-1.0f
 * \par :
 * Rg[IDwAISAC̃Rg[l擾܂B<br>
 * w肵Rg[IDAISACRg[lݒ肳ĂȂꍇA-1.0fԂ܂B<br>
 * \attention
 * {֐́AAtomExv[[ɐݒ肳ꂽAISACRg[l擾܂B<br>
 * Đ̉AISACRg[lύXAISACݒ肳ĂƂĂA̕ύXʂ擾邱Ƃ͂ł܂B
 * \par :
 * \code
 * CriAtomExAisacControlId control_id = 0;
 * CriFloat32 control_value = 0.5f;
 * // Set AISAC control value
 * criAtomExPlayer_SetAisacControlById(player, control_id, control_value);
 * // Start playback
 * id = criAtomExPlayer_Start(player);
 *                :
 * // Get AISAC control value
 * control_value = criAtomExPlayer_GetAisacControlById(player, control_id);
 * \endcode
 * \sa criAtomExPlayer_SetAisacControlById, criAtomExPlayer_GetAisacControlByName
 */
CriFloat32 CRIAPI criAtomExPlayer_GetAisacControlById(
	CriAtomExPlayerHn player, CriAtomExAisacControlId control_id);

/*JP
 * \brief AISACRg[l̎擾iRg[wj
 * \ingroup ATOMEXLIB_PLAYER
 * \param[in]	player			AtomExv[[nh
 * \param[in]	control_name	Rg[
 * \return		CriFloat32		Rg[li0.0f`1.0fjAݒ莞-1.0f
 * \par :
 * Rg[wAISAC̃Rg[l擾܂B<br>
 * w肵Rg[AISACRg[lݒ肳ĂȂꍇA-1.0fԂ܂B<br>
 * \attention
 * {֐́AAtomExv[[ɐݒ肳ꂽAISACRg[l擾܂B<br>
 * Đ̉AISACRg[lύXAISACݒ肳ĂƂĂA̕ύXʂ擾邱Ƃ͂ł܂B
 * \par :
 * \code
 * const CriChar8 *control_name = "Any";
 * CriFloat32 control_value = 0.5f;
 * // Set AISAC control value
 * criAtomExPlayer_SetAisacControlByName(player, control_name, control_value);
 * // Start playback
 * id = criAtomExPlayer_Start(player);
 *                :
 * // Get AISAC control value
 * control_value = criAtomExPlayer_GetAisacControlByName(player, control_name);
 * \endcode
 * \sa criAtomExPlayer_SetAisacControlByName, criAtomExPlayer_GetAisacControlById
 */
CriFloat32 CRIAPI criAtomExPlayer_GetAisacControlByName(
	CriAtomExPlayerHn player, const CriChar8 *control_name);

/*JP
 * \brief JeS̐ݒiIDwj
 * \ingroup ATOMEXLIB_PLAYER
 * \param[in]	player			AtomExv[[nh
 * \param[in]	category_id		JeSID
 * \par :
 * JeSIDwŃJeSݒ肵܂B<br>
 * ݒ肵JeS폜ɂ́A ::criAtomExPlayer_UnsetCategory ֐gp܂B<br>
 * \par l:
 * L[Đɖ{֐ĂяoƁAf[^ɐݒ肳ĂJeSݒƃ}[W܂B
 * ̍ہAJeSO[vĂꍇɂ͖{֐̐ݒ肪LɂȂ܂B
 * CRI AtomCu Ver.2.20.31ł
 * f[^ɐݒ肳ĂJeSݒ<b>㏑</b>Ă܂Bif[^̐ݒl͖ĂjB<br>
 * ]̎dlœ삳ꍇ̓Cui ::criAtomEx_Initialize ֐ j
 * ::CriAtomExConfig::enable_category_override_by_ex_player CRI_TRUEݒ肵ĂB
 * {֐Őݒ肵JeŚAACF̃WXgAAWXgsƃNA܂B<br>
 * <br>
 * {p[^[ ::criAtomExPlayer_ResetParameters ֐ɂăNA܂B
 * \par :
 * \code
 * // Set default category
 * criAtomExPlayer_SetCategoryById(player, (CriUint32)CRIATOMEXCATEGORY_DEFAULT_ID_BGM);
 * \endcode
 * \attention
 * JeSݒ͍ĐJnOɍsĂBĐ̉̃JeS͍XV܂B<br>
 * \sa criAtomExPlayer_UnsetCategory, criAtomExPlayer_SetCategoryByName, criAtomExPlayer_ResetParameters
 */
void CRIAPI criAtomExPlayer_SetCategoryById(
	CriAtomExPlayerHn player, CriUint32 category_id);

/*JP
 * \brief JeS̐ݒiJeSwj
 * \ingroup ATOMEXLIB_PLAYER
 * \param[in]	player			AtomExv[[nh
 * \param[in]	category_name	JeS
 * \par :
 * JeSwŃJeSݒ肵܂B<br>
 * ݒ肵JeS폜ɂ́A ::criAtomExPlayer_UnsetCategory ֐gp܂B<br>
 * \par l:
 * JeSw𖼑OōsƂA{IȎdl::criAtomExPlayer_SetCategoryById ֐ƓlłB
 * ftHgJeSł̎wsꍇ CRIATOMEXCATEGORY_DEFAULT_NAME_??? gpĂB<br>
 * <br>
 * {p[^[ ::criAtomExPlayer_ResetParameters ֐ɂăNA܂B
 * \par :
 * \code
 * // Set default category
 * criAtomExPlayer_SetCategoryByName(player, CRIATOMEXCATEGORY_DEFAULT_NAME_BGM);
 * \endcode
 * \attention
 * JeSݒ͍ĐJnOɍsĂBĐ̉̃JeS͍XV܂B<br>
 * \sa criAtomExPlayer_UnsetCategory, criAtomExPlayer_SetCategoryById, criAtomExPlayer_ResetParameters
 */
void CRIAPI criAtomExPlayer_SetCategoryByName(
	CriAtomExPlayerHn player, const CriChar8 *category_name);

/*JP
 * \brief JeS̍폜
 * \ingroup ATOMEXLIB_PLAYER
 * \param[in]	player			AtomExv[[nh
 * \par :
 * v[[nhɐݒ肳ĂJeS폜܂B<br>
 * \par :
 * \code
 * // Unset category
 * criAtomExPlayer_UnsetCategory(player);
 * \endcode
 * \sa criAtomExPlayer_SetCategoryByName, criAtomExPlayer_SetCategoryById
 */
void CRIAPI criAtomExPlayer_UnsetCategory(CriAtomExPlayerHn player);

/*JP
 * \brief JeS̎擾
 * \ingroup ATOMEXLIB_PLAYER
 * \param[in]	player		AtomExv[[nh
 * \return		CriSint32	JeS
 * \par :
 * v[[nhɐݒ肳ĂJeS̐擾܂B
 */
CriSint32 CRIAPI criAtomExPlayer_GetNumCategories(CriAtomExPlayerHn player);

/*JP
 * \brief JeS̎擾iCfbNXwj
 * \ingroup ATOMEXLIB_PLAYER
 * \param[in]	player		AtomExv[[nh
 * \param[in]	index		CfbNX
 * \param[out]	info		JeS
 * \return		CriBool		񂪎擾łǂHi擾łFCRI_TRUE^擾łȂFCRI_FALSEj
 * \par :
 * CfbNXw肵ăv[[nhɐݒ肳ĂJeS擾܂B<br>
 * w肵CfbNX̃JeS݂ȂꍇACRI_FALSEԂ܂B
 */
CriBool CRIAPI criAtomExPlayer_GetCategoryInfo(CriAtomExPlayerHn player, CriUint16 index, CriAtomExCategoryInfo* info);

/*JP
 * \brief gbN̎w
 * \ingroup ATOMEXLIB_PLAYER
 * \param[in]	player				AtomExv[[nh
 * \param[in]	num_tracks			gbN
 * \param[in]	channels_per_track	gbÑ`l
 * \par :
 * }``l̃gbN\w肵܂B<br>
 * {֐gp邱ƂŁA6ch̉f[^m6gbN̉A
 * XeI3gbN̉ƂĈƂ\ɂȂ܂B<br>
 * \par :
 * \code
 * 		F
 * 	// gbN̐ݒ
 * 	// lj6ch̉XeI3gbNƂĈ
 * 	CriSint32 channels_per_track[3] = { 2, 2, 2 };
 * 	criAtomExPlayer_SetTrackInfo(params.player, 3, channels_per_track);
 * 		F
 * 	// gbNƂɃ{[ݒ
 * 	criAtomExPlayer_SetTrackVolume(params.player, 0, 1.0f);
 * 	criAtomExPlayer_SetTrackVolume(params.player, 1, 0.5f);
 * 	criAtomExPlayer_SetTrackVolume(params.player, 2, 0.25f);
 * 		F
 * \endcode
 * \attention
 * {֐͓I ::criAtomExPlayer_SetSendLevel ֐gpĂ܂B<br>
 * ̂߁A{֐s ::criAtomExPlayer_SetSendLevel ֐gpꍇA
 * ̏o͈ʒuo̓{[Ӑ}ȂʂɂȂ\܂B<br>
 * ilɁA ::criAtomExPlayer_SetPan3dAngle ֐ ::criAtomExPlayer_SetSendLevel 
 * ֐pł܂Bj<br>
 * {֐́AR`lȏ̓͂ɑΉ@łpł܂B<br>
 * Q`liXeIjȉ̓͂܂łΉĂȂ@ł̓NG[ƂȂ܂B<br>
 * \sa criAtomExPlayer_SetTrackVolume
 */
void CRIAPI criAtomExPlayer_SetTrackInfo(CriAtomExPlayerHn player,
	CriSint32 num_tracks, const CriSint32 *channels_per_track);

/*JP
 * \brief gbÑ{[ݒ
 * \ingroup ATOMEXLIB_PLAYER
 * \param[in]	player		AtomExv[[nh
 * \param[in]	track_no	gbNԍ
 * \param[in]	volume		gbÑ{[
 * \par :
 * gbNƂ̃{[ݒ肵܂B<br>
 * \par l:
 * {p[^[ ::criAtomExPlayer_ResetParameters ֐ɂăNA܂B
 * \attention
 * {֐ ::criAtomExPlayer_SetTrackInfo ֐ŃgbNݒ肵
 * v[[ɑ΂Ă̂ݎs\łB<br>
 * <br>
 * {֐͓I ::criAtomExPlayer_SetSendLevel ֐gpĂ܂B<br>
 * ̂߁A{֐s ::criAtomExPlayer_SetSendLevel ֐gpꍇA
 * ̏o͈ʒuo̓{[Ӑ}ȂʂɂȂ\܂B<br>
 * ilɁA ::criAtomExPlayer_SetPan3dAngle ֐ ::criAtomExPlayer_SetSendLevel 
 * ֐pł܂Bj<br>
 * {֐́AR`lȏ̓͂ɑΉ@łpł܂B<br>
 * Q`liXeIjȉ̓͂܂łΉĂȂ@ł̓NG[ƂȂ܂B<br>
 * \sa criAtomExPlayer_SetTrackInfo, criAtomExPlayer_ResetParameters
 */
void CRIAPI criAtomExPlayer_SetTrackVolume(
	CriAtomExPlayerHn player, CriSint32 track_no, CriFloat32 volume);

/*JP
 * \brief [h̐ݒ
 * \ingroup ATOMEXLIB_PLAYER
 * \param[in]	player		AtomExv[[nh
 * \param[in]	silent_mode	[h
 * \par :
 * [hw肵܂B<br>
 * {֐Ŗ[hݒA::criAtomExPlayer_Start ֐ɂĐJnƁAݒ肳ꂽ[hōĐ܂B<br>
 * ܂ݒA::criAtomExPlayer_Update ֐A::criAtomExPlayer_UpdateAll ֐ĂяoƂɂA
 * łɍĐꂽ̖[hXV邱Ƃł܂B<br>
 * <br>
 * [h̏ڍׂ́A::CriAtomExSilentMode QƂĂB<br>
 * [h̃ftHgl::CRIATOMEX_SILENT_MODE_NORMAL łB<br>
 * \par :
 * \code
 * // Set silent mode
 * criAtomExPlayer_SetSilentMode(player, CRIATOMEX_SILENT_MODE_STOP);
 * // Start playback
 * id = criAtomExPlayer_Start(player);
 *                :
 * // Change volume to silent
 * volume = 0.0f;
 * criAtomExPlayer_SetVolume(player, volume);
 * criAtomExPlayer_Update(player, id);
 * \endcode
 * \par l:
 * {p[^[ ::criAtomExPlayer_ResetParameters ֐ɂăNA܂B
 * \sa CriAtomExSilentMode, criAtomExPlayer_Start, criAtomExPlayer_Update, criAtomExPlayer_UpdateAll, criAtomExPlayer_ResetParameters
 */
void CRIAPI criAtomExPlayer_SetSilentMode(
	CriAtomExPlayerHn player, CriAtomExSilentMode silent_mode);

/*JP
 * \brief L[vCIeB̐ݒ
 * \ingroup ATOMEXLIB_PLAYER
 * \param[in]	player			AtomExv[[nh
 * \param[in]	cue_priority	L[vCIeB
 * \par :
 * AtomExv[[ɃL[vCIeBݒ肵܂B<br>
 * {֐ŃL[vCIeBZbgA ::criAtomExPlayer_Start ֐ŉĐƁA
 * Đꂽ͖{֐ŃZbgL[vCIeBŔ܂B<br>
 * ֐sÕftHgݒl0łB<br>
 * \par l:
 * AtomExv[[L[ĐہAĐL[̏JeS~bg
 * ς݂̏ꍇAvCIeBɂ锭䂪s܂B<br>
 * ̓Iɂ́AAtomExv[[̍ĐNGXgAĐ̃L[̃vCIeB
 * ꍇAAtomExv[[͍Đ̃L[~ANGXgɂĐJn܂B<br>
 * iĐ̉~Aʂ̉Đ܂Bj<br>
 * tɁAAtomExv[[̍ĐNGXgAĐ̃L[̃vCIeBႢꍇA
 * AtomExv[[̍ĐNGXgۂ܂B<br>
 * iNGXgꂽL[͍Đ܂Bj<br>
 * AtomExv[[̍ĐNGXgAĐ̃L[̃vCIeBƓꍇA
 * AtomExv[[͌㒅DŔs܂B<br>
 * <br>
 * {p[^[ ::criAtomExPlayer_ResetParameters ֐ɂăNA܂B
 * \sa criAtomExPlayer_Start, criAtomExPlayer_ResetParameters
 */
void CRIAPI criAtomExPlayer_SetCuePriority(
	CriAtomExPlayerHn player, CriSint32 cue_priority);

/*JP
 * \brief vfBC^C̐ݒ
 * \ingroup ATOMEXLIB_PLAYER
 * \param[in]	player				AtomExv[[nh
 * \param[in]	predelay_time_ms	vfBC
 * \par :
 * vfBC^Cݒ肵܂B<br>
 * {֐ŃvfBC^CݒA::criAtomExPlayer_Start ֐ɂĐJnƁA
 * ݒ肳ꂽvfBC^C҂܂B<br>
 * <br>
 * vfBC^C̒Pʂmsi~bjłB<br>
 * vfBC^C̃ftHgl0.0fłB<br>
 * \attention
 * Đ::criAtomExPlayer_Update ֐A::criAtomExPlayer_UpdateAll ֐ɂčXV邱Ƃ͂ł܂B<br>
 * \par l:
 * L[ĐAf[^ɃvfBC^Cݒ肳Ăꍇɖ{֐ĂяoƁA
 * f[^ɐݒ肳ĂlƖ{֐̐ݒl<b>Z</b>lKp܂B<br>
 * \sa criAtomExPlayer_Start
 */
void CRIAPI criAtomExPlayer_SetPreDelayTime(
	CriAtomExPlayerHn player, CriFloat32 predelay_time_ms);

/*JP
 * \brief Gx[ṽA^bN^C̐ݒ
 * \ingroup ATOMEXLIB_PLAYER
 * \param[in]	player			AtomExv[[nh
 * \param[in]	attack_time_ms	A^bN^C
 * \par :
 * Gx[ṽA^bN^Cݒ肵܂B<br>
 * {֐ŃA^bN^CݒA::criAtomExPlayer_Start ֐ɂĐJnƁAݒ肳ꂽA^bN^CōĐ܂B<br>
 * <br>
 * A^bN^C̒Pʂmsi~bjłB<br>
 * A^bN^C̃ftHgl0.0fłB<br>
 * \attention
 * Đ::criAtomExPlayer_Update ֐A::criAtomExPlayer_UpdateAll ֐ɂčXV邱Ƃ͂ł܂B<br>
 * \par :
 * \code
 * CriFloat32 attack_time_ms = 10.0f;
 * // Set attack time
 * criAtomExPlayer_SetEnvelopeAttackTime(player, attack_time_ms);
 * // Start playback(attack time=10ms)
 * criAtomExPlayer_Start(player);
 * \endcode
 * \par l:
 * L[ĐAf[^ɃA^bN^Cݒ肳Ăꍇɖ{֐ĂяoƁA
 * f[^ɐݒ肳Ăl<b>㏑</b>ēKp܂if[^̐ݒl͖܂jB<br>
 * <br>
 * {p[^[ ::criAtomExPlayer_ResetParameters ֐ɂăNA܂B
 * \sa criAtomExPlayer_Start, criAtomExPlayer_ResetParameters
 */
void CRIAPI criAtomExPlayer_SetEnvelopeAttackTime(
	CriAtomExPlayerHn player, CriFloat32 attack_time_ms);

/*JP
 * \brief Gx[ṽA^bNJ[u̐ݒ
 * \ingroup ATOMEXLIB_PLAYER
 * \param[in]	player			AtomExv[[nh
 * \param[in]	curve_type		J[u^Cv
 * \param[in]	strength		J[ű
 * \par :
 * Gx[ṽA^bNJ[uݒ肵܂B<br>
 * {֐ŃA^bNJ[uݒA::criAtomExPlayer_Start ֐ɂĐJnƁAݒ肳ꂽA^bNJ[uōĐ܂B<br>
 * <br>
 * J[u^Cv ::CriAtomExCurveType ɒ`Ăw肵܂B<br>
 * J[u^CṽftHg ::CRIATOMEX_CURVE_TYPE_LINEAR łB<br>
 * <br>
 * J[ű́A0.0f`2.0f͈̔͂Ŏlw肵܂B<br>
 * J[ű̃ftHgl1.0fłB<br>
 * \attention
 * Đ::criAtomExPlayer_Update ֐A::criAtomExPlayer_UpdateAll ֐ɂčXV邱Ƃ͂ł܂B<br>
 * \par l:
 * L[ĐAf[^ɃA^bNJ[uݒ肳Ăꍇɖ{֐ĂяoƁA
 * f[^ɐݒ肳Ăl<b>㏑</b>ēKp܂if[^̐ݒl͖܂jB<br>
 * <br>
 * {p[^[ ::criAtomExPlayer_ResetParameters ֐ɂăNA܂B
 * \sa criAtomExPlayer_Start, criAtomExPlayer_ResetParameters
 */
void CRIAPI criAtomExPlayer_SetEnvelopeAttackCurve(
	CriAtomExPlayerHn player, CriAtomExCurveType curve_type, CriFloat32 strength);

/*JP
 * \brief Gx[ṽz[h^C̐ݒ
 * \ingroup ATOMEXLIB_PLAYER
 * \param[in]	player			AtomExv[[nh
 * \param[in]	hold_time_ms	z[h^C
 * \par :
 * Gx[ṽz[h^Cݒ肵܂B<br>
 * {֐Ńz[h^CݒA::criAtomExPlayer_Start ֐ɂĐJnƁAݒ肳ꂽz[h^CōĐ܂B<br>
 * <br>
 * z[h^C̒Pʂmsi~bjłB<br>
 * z[h^C̃ftHgl0.0fłB<br>
 * \attention
 * Đ::criAtomExPlayer_Update ֐A::criAtomExPlayer_UpdateAll ֐ɂčXV邱Ƃ͂ł܂B<br>
 * \par :
 * \code
 * CriFloat32 hold_time_ms = 10.0f;
 * // Set hold time
 * criAtomExPlayer_SetEnvelopeHoldTime(player, hold_time_ms);
 * // Start playback(hold time=10ms)
 * criAtomExPlayer_Start(player);
 * \endcode
 * \par l:
 * L[ĐAf[^Ƀz[h^Cݒ肳Ăꍇɖ{֐ĂяoƁA
 * f[^ɐݒ肳Ăl<b>㏑</b>ēKp܂if[^̐ݒl͖܂jB<br>
 * <br>
 * {p[^[ ::criAtomExPlayer_ResetParameters ֐ɂăNA܂B
 * \sa criAtomExPlayer_Start, criAtomExPlayer_ResetParameters
 */
void CRIAPI criAtomExPlayer_SetEnvelopeHoldTime(
	CriAtomExPlayerHn player, CriFloat32 hold_time_ms);

/*JP
 * \brief Gx[ṽfBPC^C̐ݒ
 * \ingroup ATOMEXLIB_PLAYER
 * \param[in]	player			AtomExv[[nh
 * \param[in]	decay_time_ms	fBPC^C
 * \par :
 * Gx[ṽfBPC^Cݒ肵܂B<br>
 * {֐ŃfBPC^CݒA::criAtomExPlayer_Start ֐ɂĐJnƁAݒ肳ꂽfBPC^CōĐ܂B<br>
 * <br>
 * fBPC^C̒Pʂmsi~bjłB<br>
 * fBPC^C̃ftHgl0.0fłB<br>
 * \attention
 * Đ::criAtomExPlayer_Update ֐A::criAtomExPlayer_UpdateAll ֐ɂčXV邱Ƃ͂ł܂B<br>
 * \par :
 * \code
 * CriFloat32 decay_time_ms = 10.0f;
 * // Set decay time
 * criAtomExPlayer_SetEnvelopeDecayTime(player, decay_time_ms);
 * // Start playback(decay time=10ms)
 * criAtomExPlayer_Start(player);
 * \endcode
 * \par l:
 * L[ĐAf[^ɃfBPC^Cݒ肳Ăꍇɖ{֐ĂяoƁA
 * f[^ɐݒ肳Ăl<b>㏑</b>ēKp܂if[^̐ݒl͖܂jB<br>
 * <br>
 * {p[^[ ::criAtomExPlayer_ResetParameters ֐ɂăNA܂B
 * \sa criAtomExPlayer_Start, criAtomExPlayer_ResetParameters
 */
void CRIAPI criAtomExPlayer_SetEnvelopeDecayTime(
	CriAtomExPlayerHn player, CriFloat32 decay_time_ms);

/*JP
 * \brief Gx[ṽfBPCJ[u̐ݒ
 * \ingroup ATOMEXLIB_PLAYER
 * \param[in]	player			AtomExv[[nh
 * \param[in]	curve_type		J[u^Cv
 * \param[in]	strength		J[ű
 * \par :
 * Gx[ṽfBPCJ[uݒ肵܂B<br>
 * {֐ŃfBPCJ[uݒA::criAtomExPlayer_Start ֐ɂĐJnƁAݒ肳ꂽfBPCJ[uōĐ܂B<br>
 * <br>
 * J[u^Cv ::CriAtomExCurveType ɒ`Ăw肵܂B<br>
 * J[u^CṽftHg ::CRIATOMEX_CURVE_TYPE_LINEAR łB<br>
 * <br>
 * J[ű́A0.0f`2.0f͈̔͂Ŏlw肵܂B<br>
 * J[ű̃ftHgl1.0fłB<br>
 * \attention
 * Đ::criAtomExPlayer_Update ֐A::criAtomExPlayer_UpdateAll ֐ɂčXV邱Ƃ͂ł܂B<br>
 * \par l:
 * L[ĐAf[^ɃfBPCJ[uݒ肳Ăꍇɖ{֐ĂяoƁA
 * f[^ɐݒ肳Ăl<b>㏑</b>ēKp܂if[^̐ݒl͖܂jB<br>
 * <br>
 * {p[^[ ::criAtomExPlayer_ResetParameters ֐ɂăNA܂B
 * \sa criAtomExPlayer_Start, criAtomExPlayer_ResetParameters
 */
void CRIAPI criAtomExPlayer_SetEnvelopeDecayCurve(
	CriAtomExPlayerHn player, CriAtomExCurveType curve_type, CriFloat32 strength);

/*JP
 * \brief Gx[ṽ[X^C̐ݒ
 * \ingroup ATOMEXLIB_PLAYER
 * \param[in]	player			AtomExv[[nh
 * \param[in]	release_time_ms	[X^C
 * \par :
 * Gx[ṽ[X^Cݒ肵܂B<br>
 * {֐Ń[X^CݒA::criAtomExPlayer_Start ֐ɂĐJnƁAݒ肳ꂽ[X^CōĐ܂B<br>
 * <br>
 * [X^C̒Pʂmsi~bjłB<br>
 * [X^C̃ftHgl0.0fłB<br>
 * \par :
 * \code
 * CriFloat32 release_time_ms = 3000.0f;
 * // Set release time
 * criAtomExPlayer_SetEnvelopeReleaseTime(player, release_time_ms);
 * // Start playback(release time=3000ms)
 * criAtomExPlayer_Start(player);
 * \endcode
 * \par l:
 * L[ĐAf[^Ƀ[X^Cݒ肳Ăꍇɖ{֐ĂяoƁA
 * f[^ɐݒ肳Ăl<b>㏑</b>ēKp܂if[^̐ݒl͖܂jB<br>
 * <br>
 * {p[^[ ::criAtomExPlayer_ResetParameters ֐ɂăNA܂B
 * \sa criAtomExPlayer_Start, criAtomExPlayer_ResetParameters
 */
void CRIAPI criAtomExPlayer_SetEnvelopeReleaseTime(
	CriAtomExPlayerHn player, CriFloat32 release_time_ms);

/*JP
 * \brief Gx[ṽ[XJ[u̐ݒ
 * \ingroup ATOMEXLIB_PLAYER
 * \param[in]	player			AtomExv[[nh
 * \param[in]	curve_type		J[u^Cv
 * \param[in]	strength		J[ű
 * \par :
 * Gx[ṽ[XJ[uݒ肵܂B<br>
 * {֐Ń[XJ[uݒA::criAtomExPlayer_Start ֐ɂĐJnƁAݒ肳ꂽ[XJ[uōĐ܂B<br>
 * <br>
 * J[u^Cv ::CriAtomExCurveType ɒ`Ăw肵܂B<br>
 * J[u^CṽftHg ::CRIATOMEX_CURVE_TYPE_LINEAR łB<br>
 * <br>
 * J[ű́A0.0f`2.0f͈̔͂Ŏlw肵܂B<br>
 * J[ű̃ftHgl1.0fłB<br>
 * \attention
 * Đ::criAtomExPlayer_Update ֐A::criAtomExPlayer_UpdateAll ֐ɂčXV邱Ƃ͂ł܂B<br>
 * \par l:
 * L[ĐAf[^Ƀ[XJ[uݒ肳Ăꍇɖ{֐ĂяoƁA
 * f[^ɐݒ肳Ăl<b>㏑</b>ēKp܂if[^̐ݒl͖܂jB<br>
 * <br>
 * {p[^[ ::criAtomExPlayer_ResetParameters ֐ɂăNA܂B
 * \sa criAtomExPlayer_Start, criAtomExPlayer_ResetParameters
 */
void CRIAPI criAtomExPlayer_SetEnvelopeReleaseCurve(
	CriAtomExPlayerHn player, CriAtomExCurveType curve_type, CriFloat32 strength);

/*JP
 * \brief Gx[ṽTXeBx̐ݒ
 * \ingroup ATOMEXLIB_PLAYER
 * \param[in]	player			AtomExv[[nh
 * \param[in]	susutain_level	TXeBxi0.0f`1.0fj
 * \par :
 * Gx[ṽTXeBxݒ肵܂B<br>
 * {֐ŃTXeBxݒA::criAtomExPlayer_Start ֐ɂĐJnƁAݒ肳ꂽTXeBxōĐ܂B<br>
 * <br>
 * TXeBxɂ́A0.0f`1.0f͈̔͂Ŏlw肵܂B<br>
 * TXeBx̃ftHgl1.0fłB<br>
 * \attention
 * Đ::criAtomExPlayer_Update ֐A::criAtomExPlayer_UpdateAll ֐ɂčXV邱Ƃ͂ł܂B<br>
 * \par :
 * \code
 * CriFloat32 susutain_level = 0.5f;
 * // Set susutain level
 * criAtomExPlayer_SetEnvelopeSustainLevel(player, susutain_level);
 * // Start playback(sustain level=0.5)
 * criAtomExPlayer_Start(player);
 * \endcode
 * \par l:
 * L[ĐAf[^ɃTXeBxݒ肳Ăꍇɖ{֐ĂяoƁA
 * f[^ɐݒ肳Ăl<b>㏑</b>ēKp܂if[^̐ݒl͖܂jB<br>
 * <br>
 * {p[^[ ::criAtomExPlayer_ResetParameters ֐ɂăNA܂B
 * \sa criAtomExPlayer_Start, criAtomExPlayer_ResetParameters
 */
void CRIAPI criAtomExPlayer_SetEnvelopeSustainLevel(
	CriAtomExPlayerHn player, CriFloat32 susutain_level);

/*JP
 * \brief f[^vR[obN֐̓o^
 * \ingroup ATOMEXLIB_PLAYER
 * \param[in]	player		AtomExv[[nh
 * \param[in]	func		f[^vR[obN֐
 * \param[in]	obj			[UwIuWFNg
 * \par :
 * f[^vR[obN֐̓o^s܂B<br>
 * <br>
 * f[^vR[obŃẢf[^V[XɘAčĐۂ
 * gp܂B<br>
 * o^R[obN֐́A{CXIɎgpĂ Atom v[[
 * AĐp̃f[^v^C~OŎs܂B<br>
 * iÕf[^ǂݍݏIāAɍĐׂf[^v^C~O
 * R[obN֐s܂Bj<br>
 * o^R[obN֐ ::criAtomPlayer_SetData ֐p Atom v[[
 * f[^ZbgƁAZbgꂽf[^͌ݍĐ̃f[^ɑăV[X
 * AčĐ܂B<br>
 * ܂AR[obN֐ ::criAtomPlayer_SetPreviousDataAgain ֐s邱ƂŁA
 * f[^JԂĐ邱Ƃ\łB<br>
 * \par l:
 * o^R[obN֐Ńf[^w肵ȂꍇÃ݂f[^Đ
 * I_ŁAAtomEx v[[̃Xe[^X CRIATOMEXPLAYER_STATUS_PLAYEND ɑJڂ܂B<br>
 * <br>
 * ^C~O̖ɂAf[^w肷邱ƂłȂAXe[^X
 * CRIATOMEXPLAYER_STATUS_PLAYEND ɑJڂȂꍇɂ́AR[obN֐
 * ::criAtomPlayer_DeferCallback ֐sĂB<br>
 * ::criAtomPlayer_DeferCallback ֐s邱ƂŁA1Vɍēxf[^v
 * R[obN֐Ăяo܂BiR[obNgC\Bj<br>
 * A ::criAtomPlayer_DeferCallback ֐sꍇAĐr؂
 * iAӏɈ莞Ԗj\܂B<br>
 * \par :
 * ȉ̃R[hsƁAbuffer1̃f[^buffer2̃f[^V[X
 * AčĐ܂B<br>
 * ǐbuffer2̃f[^JԂĐ܂Bj<br>
 * \code
 * // f[^vR[obN֐
 * void on_data_request(void *obj, CriAtomExPlaybackId id, CriAtomPlayerHn player)
 * {
 * 	// čĐf[^Zbg
 * 	criAtomPlayer_SetData(player, buffer2, buffer_size2);
 * }
 * 
 * main()
 * {
 * 		:
 * 	// f[^vR[obN֐̓o^
 * 	criAtomExPlayer_SetDataRequestCallback(player, on_data_request, NULL);
 * 	
 * 	// f[^Zbg
 * 	criAtomExPlayer_SetData(player, buffer1, buffer_size1);
 * 	
 * 	// Zbgꂽf[^Đ
 * 	criAtomExPlayer_Start(player);
 * 		:
 * }
 * \endcode
 * ȉ̏ɂAꉹf[^𖳌Ƀ[vĐ\łB<br>
 * \code
 * // f[^vR[obN֐
 * void on_data_request(void *obj, CriAtomExPlaybackId id, CriAtomPlayerHn player)
 * {
 * 	// OĐf[^ăZbg
 * 	criAtomPlayer_SetPreviousDataAgain(player);
 * }
 * 
 * main()
 * {
 * 		:
 * 	// f[^vR[obN֐̓o^
 * 	criAtomExPlayer_SetDataRequestCallback(player, on_data_request, NULL);
 * 	
 * 	// f[^Zbg
 * 	criAtomExPlayer_SetData(player, buffer, buffer_size);
 * 	
 * 	// Zbgꂽf[^Đ
 * 	criAtomExPlayer_Start(player);
 * 		:
 * }
 * \endcode
 * \attention
 * R[obN֐͍ĐJnOɐݒ肷Kv܂B<br>
 * Đ̉ɑ΂R[obNݒ肵A
 * ݒς݂̃R[obNォύX邱Ƃ͂ł܂B<br>
 * <br>
 * ̔g`f[^܂ރL[ĐꍇA
 * ŏɌg`f[^̍ĐI^C~OŃR[obN֐s܂B<br>
 * ̂߁A̔g`f[^܂ރL[ɑ΂ĘAĐ̑sꍇA
 * Ӑ}Ȃgݍ킹Ŕg`AĐ\܂B<br>
 * {@\gpۂɂ́A 1 ̔g`f[^݂̂܂ރL[Đ邩A
 * ܂̓t@CIf[^ĐĂB<br>
 * <br>
 * f[^vR[obN֐ŒԏubNƁA؂ꓙ̖肪
 * ܂̂ŁAӂB<br>
 * <br>
 * R[obN֐Ŏs\APÍAȉ̂ƂłB<br>
 * 	- criAtomExAcb_GetWaveformInfoByIdiNULLw͕sj
 * 	- criAtomExAcb_GetWaveformInfoByNameiNULLw͕sj
 * 	- criAtomExAcb_GetOnMemoryAwbHandle
 * 	- criAtomExAcb_GetStreamingAwbHandle
 * 	- criAtomPlayer_SetData
 * 	- criAtomPlayer_SetFile
 * 	- criAtomPlayer_SetContentId
 * 	- criAtomPlayer_SetWaveId
 * 	- criAtomPlayer_SetPreviousDataAgain
 * 	- criAtomPlayer_DeferCallback
 * 	
 * R[obN֐ŏLȊOAPIsꍇA
 * G[R[obNfbhbN̖肪\܂B<br>
 * <br>
 * V[XAĐT|[gȂR[fbNgpĂꍇA
 * f[^vR[obN֐Ŏ̃f[^ZbgĂA
 * f[^͑čĐ܂B<br>
 * - HCA-MXR[fbNgpꍇAf[^V[Xɂ͘AꂸA
 * Đ̉ƎɍĐ鉹Ƃ̌pڂɖ܂B
 * - vbgtH[ŗL̉kR[fbNgpĂꍇA
 * G[\܂B
 * 
 * V[XAĐɎgpg`f[^̃tH[}bǵA
 * SēɂKv܂B<br>
 * ̓Iɂ́Aȉ̃p[^[łKv܂B<br>
 * 	- R[fbN
 * 	- `l
 * 	- TvO[g
 * 	
 * p[^[قȂg`A悤ƂꍇA
 * Ӑ}Ȃxŉf[^ĐꂽA
 * G[R[obN铙̖肪܂B<br>
 * <br>
 * R[obN֐Ń[vt̔g`f[^ZbgꍇłA
 * [vĐ͍s܂B<br>
 * i[v|CgAĐI܂Bj<br>
 * <br>
 * R[obN֐1o^ł܂B<br>
 * o^𕡐sꍇAɓo^ς݂̃R[obN֐A
 * ォo^R[obN֐ɂ㏑Ă܂܂B<br>
 * <br>
 * funcNULLw肷邱Ƃœo^ς݊֐̓o^s܂B<br>
 * \sa CriAtomExPlayerDataRequestCbFunc, criAtomPlayer_SetData,
 * criAtomPlayer_SetPreviousDataAgain, criAtomPlayer_DeferCallback
 */
void CRIAPI criAtomExPlayer_SetDataRequestCallback(
	CriAtomExPlayerHn player, CriAtomExPlayerDataRequestCbFunc func, void *obj);

/*JP
 * \brief g`tB^[R[obN֐̓o^
 * \ingroup ATOMEXLIB_PLAYER
 * \param[in]	player		AtomExv[[nh
 * \param[in]	func		g`tB^[R[obN֐
 * \param[in]	obj			[UwIuWFNg
 * \par :
 * fR[hʂ PCM f[^󂯎R[obN֐o^܂B<br>
 * o^ꂽR[obN֐́A{CXf[^fR[h^C~OŌĂяo܂B<br>
 * \attention
 * ̉f[^܂ރL[ĐꍇA
 * ŏɌg`f[^ɂĂ̂݃R[obNs܂B<br>
 * i̔g`f[^܂ރL[ɂẮA
 * 2ڈȍ~̔g`f[^̏邱Ƃł܂Bj<br>
 * <br>
 * R[obN֐ŁAAtomCuAPIsȂłB<br>
 * R[obN֐AtomCũT[o[s܂B<br>
 * ̂߁AT[o[ւ̊荞݂lȂAPIsꍇA
 * G[AfbhbN\܂B<br>
 * <br>
 * g`tB^[R[obN֐ŒԏubNƁA؂ꓙ̖
 * ܂̂ŁAӂB<br>
 * <br>
 * HCA-MXR[fbNvbgtH[ŗL̉kR[fbNgpĂꍇA
 * tB^[R[obN͗pł܂B<br>
 * <br>
 * R[obN֐1o^ł܂B<br>
 * o^𕡐sꍇAɓo^ς݂̃R[obN֐A
 * ォo^R[obN֐ɂ㏑Ă܂܂B<br>
 * <br>
 * funcNULLw肷邱Ƃœo^ς݊֐̓o^s܂B<br>
 * \sa CriAtomExPlayerFilterCbFunc
 */
void CRIAPI criAtomExPlayer_SetFilterCallback(
	CriAtomExPlayerHn player, CriAtomExPlayerFilterCbFunc func, void *obj);

/*JP
 * \brief ̐ݒ
 * \ingroup ATOMEXLIB_PLAYER
 * \param[in]	player		AtomExv[[nh
 * \param[in]	seed		
 * \par :
 * AtomExv[[ێ^ɗݒ肵܂B<br>
 * ݒ肷邱ƂɂAe탉_ĐɍČ邱Ƃł܂B<br>
 * <br>
 * \sa criAtomEx_SetRandomSeed
 */
void CRIAPI criAtomExPlayer_SetRandomSeed(CriAtomExPlayerHn player, CriUint32 seed);

/*JP
 * \brief DSPp[^[̐ݒ
 * \ingroup ATOMEXLIB_PLAYER
 * \param[in]	player		AtomExv[[nh
 * \param[in]	param_id	p[^[IDi0`10j
 * \param[in]	param_val	p[^[IDi0.0f`1.0fj
 * \par :
 * AtomExv[[ێCT[VDSP̃p[^[ݒ肵܂B<br>
 * DSPLɂ́A{CXv[ɂ炩DSPA^b`ĂKv܂B<br>
 * \par l:
 * {p[^[ ::criAtomExPlayer_ResetParameters ֐ɂăNA܂B
 * \sa criAtomExPlayer_ResetParameters
 */
void CRIAPI criAtomExPlayer_SetDspParameter(
	CriAtomExPlayerHn player, CriSint32 param_id, CriFloat32 param_val);

/*JP
 * \brief DSPp[^[̐ݒ
 * \ingroup ATOMEXLIB_PLAYER
 * \param[in]	player		AtomExv[[nh
 * \param[in]	is_bypassed	oCpXL
 * \par :
 * AtomExv[[ێCT[VDSPoCpX邩ݒ肵܂B<br>
 * ̊֐ŖIɎw肵Ȃ΁ACT[VDSP̓oCpX܂B<br>
 * \par l:
 * {p[^[ ::criAtomExPlayer_ResetParameters ֐ɂăNA܂B
 * \sa criAtomExPlayer_ResetParameters
 */
void CRIAPI criAtomExPlayer_SetDspBypass(
	CriAtomExPlayerHn player, CriBool is_bypassed);

/*JP
 * \brief v[[AISACt
 * \ingroup ATOMEXLIB_PLAYER
 * \param[in]	player				AtomExv[[nh
 * \param[in]	global_aisac_name	tO[oAISAC
 * \par :
 * v[[AISACA^b`itj܂B
 * AISACA^b`邱ƂɂAL[gbNAISACݒ肵ĂȂĂAAISAČʂ𓾂邱Ƃł܂B<br>
 * {֐AISACA^b`A::criAtomExPlayer_Start ֐ɂĐJnƁAA^b`AISAClāAep[^[Kp܂B<br>
 * ܂A^b`A::criAtomExPlayer_Update ֐A::criAtomExPlayer_UpdateAll ֐ĂяoƂɂA
 * łɍĐꂽɑ΂ĂAA^b`AISACɂep[^[ݒKp邱Ƃł܂B<br>
 * <br>
 * AISAC̃A^b`ɎsꍇA֐ŃG[R[obN܂B<br>
 * AISAC̃A^b`ɎsRɂẮAG[R[obÑbZ[WmFĂB<br>
 * \par :
 * \code
 * // Attach Aisac
 * criAtomExPlayer_AttachAisac(player, "GlobalAisac1");
 * criAtomExPlayer_SetAisacControlByName(player, "Any", 0.5f);
 * criAtomExPlayer_Start(player);
 * \endcode
 * \par l:
 * S̐ݒiACFt@CjɊ܂܂O[oAISAĈ݁AA^b`\łB<br>
 * AISAČʂ𓾂ɂ́AL[gbNɐݒ肳ĂAISACƓlɁAYAISACRg[lݒ肷Kv܂B
 * <br>
 * {p[^[ ::criAtomExPlayer_ResetParameters ֐ɂăNA܂B
 * \attention
 * L[gbNɁuAISACRg[lύXAISACvݒ肳ĂƂĂA̓KpʂAISACRg[ĺAv[[ɃA^b`AISACɂ͉e܂B
 * ݁AuI[gW[Vvu_vƂRg[^CvAISAC̃A^b`ɂ͑ΉĂ܂B<br>
 * ݁Av[[ɃA^b`łAISAC̍ő吔́A8ŒłB
 * \sa criAtomExPlayer_DetachAisac, criAtomExPlayer_ResetParameters
 */
void CRIAPI criAtomExPlayer_AttachAisac(CriAtomExPlayerHn player, const CriChar8* global_aisac_name);
void CRIAPI criAtomExPlayer_AttachAisacByIndex(CriAtomExPlayerHn player, CriUint16 global_aisac_index);

/*JP
 * \brief v[[AISACO
 * \ingroup ATOMEXLIB_PLAYER
 * \param[in]	player		AtomExv[[
 * \param[in]	global_aisac_name	OO[oAISAC
 * \par :
 * v[[AISACf^b`iOj܂B<br>
 * {֐AISACf^b`A::criAtomExPlayer_Start ֐ɂĐJnƁAf^b`AISAC̉e͎󂯂ȂȂ܂B<br>
 * ܂f^b`A::criAtomExPlayer_Update ֐A::criAtomExPlayer_UpdateAll ֐ĂяoƂɂA
 * łɍĐꂽɑ΂ĂAf^b`AISACɂe󂯂ȂȂ܂B<br>
 * <br>
 * AISAC̃f^b`ɎsꍇA֐ŃG[R[obN܂B<br>
 * AISAC̃f^b`ɎsRɂẮAG[R[obÑbZ[WmFĂB<br>
 * \sa criAtomExPlayer_AttachAisac
 */
void CRIAPI criAtomExPlayer_DetachAisac(CriAtomExPlayerHn player, const CriChar8* global_aisac_name);
void CRIAPI criAtomExPlayer_DetachAisacByIndex(CriAtomExPlayerHn player, CriUint16 global_aisac_index);

/*JP
 * \brief v[[SĂAISACO
 * \ingroup ATOMEXLIB_PLAYER
 * \param[in]	player		AtomExv[[
 * \par :
 * v[[SĂAISACf^b`iOj܂B<br>
 * {֐AISACf^b`A::criAtomExPlayer_Start ֐ɂĐJnƁAf^b`AISAC̉e͎󂯂ȂȂ܂B<br>
 * ܂f^b`A::criAtomExPlayer_Update ֐A::criAtomExPlayer_UpdateAll ֐ĂяoƂɂA
 * łɍĐꂽɑ΂ĂAf^b`AISACɂe󂯂ȂȂ܂B
 * \sa criAtomExPlayer_AttachAisac
 */
void CRIAPI criAtomExPlayer_DetachAisacAll(CriAtomExPlayerHn player);

/*JP
 * \brief v[[ɃA^b`ĂAISAC擾
 * \ingroup ATOMEXLIB_PLAYER
 * \param[in]	player		AtomExv[[
 * \return	v[[ɃA^b`ĂAISAC
 * \par :
 * v[[ɃA^b`ĂAISAC擾܂B
 */
CriSint32 CRIAPI criAtomExPlayer_GetNumAttachedAisacs(CriAtomExPlayerHn player);

/*JP
 * \brief v[[ɃA^b`ĂAISAC̏擾
 * \ingroup ATOMEXLIB_PLAYER
 * \param[in]	player					AtomExv[[
 * \param[in]	aisac_attached_index	A^b`ĂAISAC̃CfbNX
 * \param[out]	aisac_info				AISAC
 * \retval	CRI_TRUE = 񂪎擾ł
 * \retval	CRI_FALSE = 񂪎擾łȂ
 * \par :
 * v[[ɃA^b`ĂAISAC̏擾܂B<br>
 * ȃCfbNXw肵ꍇACRI_FALSEԂ܂B<br>
 * \sa criAtomExPlayer_GetNumAttachedAisacs
 */
CriBool CRIAPI criAtomExPlayer_GetAttachedAisacInfo(
	CriAtomExPlayerHn player,
	CriSint32 aisac_attached_index,
	CriAtomExAisacInfo *aisac_info
);

/*JP
 * \brief v[[ɃXg[~OLbVݒ肵܂
 * \ingroup ATOMEXLIB_PLAYER
 * \param[in]	player			AtomExv[[
 * \param[in]	cache_id		v[[ŎgpXg[~OLbVID
 * \par :
 * v[[ŎgpXg[~OLbVIDwŐݒ肵܂B<br>
 * \attention
 * v[[Ŏgp̃Xg[~OLbVjꍇ́A
 * Ƀv[[jĂB<br>
 * t̏ŏꍇ̌ʂ͕słB<br>
 * \sa criAtomStreamingCache_Create, criAtomStreamingCache_Destroy
 */
void CRIAPI criAtomExPlayer_SetStreamingCacheId(
	CriAtomExPlayerHn player, CriAtomExStreamingCacheId cache_id);

/*JP
 * \brief v[[ɃgDC[t
 * \ingroup ATOMEXLIB_PLAYER
 * \param[in]	player	AtomExv[[nh
 * \param[in]	tween	gDC[nh
 * \par :
 * v[[ɃgDC[A^b`itj܂B
 * gDC[A^b`邱ƂɂAȒPȎ菇Ńp[^[̎ԕωsƂł܂B<br>
 * {֐ŃgDC[A^b`A::criAtomExPlayer_Start ֐ɂĐJnƁAA^b`gDC[lāAep[^[Kp܂B<br>
 * ܂A^b`A::criAtomExPlayer_Update ֐A::criAtomExPlayer_UpdateAll ֐ĂяoƂɂA
 * łɍĐꂽɑ΂ĂAA^b`gDC[ɂep[^[ݒKp邱Ƃł܂B<br>
 * \par :
 * \code
 * // {[tF[hTween̍쐬
 * CriAtomExTweenConfig config;
 * criAtomExTween_SetDefaultConfig(&config);
 *
 * config.parameter_type = CRIATOMEX_PARAMETER_TYPE_BASIC;
 * config.id.parameter_id = CRIATOMEX_PARAMETER_ID_VOLUME;
 * fade_tween = criAtomExTween_Create(&config, NULL, 0);
 *
 * // TweeñA^b`
 * criAtomExPlayer_AttachTween(player, fade_tween);
 *
 * // ĐJn
 * criAtomExPlayer_Start(player);
 *             :
 * // 1bă{[0.2ɃtF[h
 * criAtomExTween_MoveTo(fade_tween, 1000, 0.2f);
 *             :
 * // 2bă{[1.0ɕA
 * criAtomExTween_MoveTo(fade_tween, 2000, 1.0f);
 * \endcode
 * \par l:
 * gDC[ɂĕωp[^[́AAtomExv[[ɐݒ肳Ăp[^[ɑ΂AZ^Z^㏑܂B<br>
 * Z^Z^㏑̂ǂɊY邩́AAtomExv[[ւ̐ݒ֐i::criAtomExPlayer_SetVolume ֐jƓlłB
 * Ⴆ΁A{[łΏZAAISACRg[lłΏ㏑܂B<br>
 * ݁Av[[ɃA^b`łgDC[̍ő吔́A8ŒłB<br>
 * <br>
 * {p[^[ ::criAtomExPlayer_ResetParameters ֐ɂăNA܂B
 * \sa criAtomExPlayer_DetachTween, criAtomExPlayer_DetachTweenAll, criAtomExTween_Create, criAtomExPlayer_ResetParameters
 */
void CRIAPI criAtomExPlayer_AttachTween(CriAtomExPlayerHn player, CriAtomExTweenHn tween);

/*JP
 * \brief v[[gDC[O
 * \ingroup ATOMEXLIB_PLAYER
 * \param[in]	player	AtomExv[[
 * \param[in]	tween	OgDC[nh
 * \par :
 * v[[gDC[f^b`iOj܂B<br>
 * {֐ŃgDC[f^b`A::criAtomExPlayer_Start ֐ɂĐJnƁAf^b`gDC[̉e͎󂯂ȂȂ܂B<br>
 * ܂f^b`A::criAtomExPlayer_Update ֐A::criAtomExPlayer_UpdateAll ֐ĂяoƂɂA
 * łɍĐꂽɑ΂ĂAf^b`gDC[ɂe󂯂ȂȂ܂B<br>
 * \sa criAtomExPlayer_AttachTween
 */
void CRIAPI criAtomExPlayer_DetachTween(CriAtomExPlayerHn player, CriAtomExTweenHn tween);

/*JP
 * \brief v[[SẴgDC[O
 * \ingroup ATOMEXLIB_PLAYER
 * \param[in]	player	AtomExv[[
 * \par :
 * v[[SẴgDC[f^b`iOj܂B<br>
 * {֐ŃgDC[f^b`A::criAtomExPlayer_Start ֐ɂĐJnƁAf^b`gDC[̉e͎󂯂ȂȂ܂B<br>
 * ܂f^b`A::criAtomExPlayer_Update ֐A::criAtomExPlayer_UpdateAll ֐ĂяoƂɂA
 * łɍĐꂽɑ΂ĂAf^b`gDC[ɂe󂯂ȂȂ܂B
 * \sa criAtomExPlayer_AttachTween
 */
void CRIAPI criAtomExPlayer_DetachTweenAll(CriAtomExPlayerHn player);

/*JP
 * \brief ĐJnubÑZbgiubNCfbNXwj
 * \ingroup ATOMEXLIB_PLAYER
 * \param[in]	player			AtomExv[[nh
 * \param[in]	index			ubNCfbNX
 * \par :
 * ĐJnubNCfbNXAAtomExv[[Ɋ֘At܂B<br>
 * {֐ōĐJnubNCfbNXwAubNV[PXL[
 * ::criAtomExPlayer_Start ֐ōĐJnƎw肵ubNĐ
 * Jn܂B
 * \par :
 * \code
 * main()
 * {
 * 		:
 * 	// f[^Zbg
 * 	criAtomExPlayer_SetCueIndex(player, acb_hn, 300);
 * 	
 * 	// JnubNZbg
 * 	criAtomExPlayer_SetFirstBlockIndex(player, 1);
 * 	
 * 	// Zbgꂽf[^Đ
 * 	criAtomExPlayer_Start(player);
 * 		:
 * }
 * \endcode
 * \par l:
 * AtomExv[[̃ftHgubNCfbNX 0 łB<br>
 * ::criAtomExPlayer_Start ֐ɂĐJnɃv[[ɐݒ肳ĂL[
 * ubNV[PXłȂꍇ́A{֐Őݒ肵l͗p܂B<br>
 * w肵CfbNXɑΉubNȂꍇ͐擪ubNĐs܂B<br>
 * ̍ہAwCfbNX̃ubN݂Ȃẽ[jO܂B<br>
 * \par l:
 * ĐJñubNJڂ ::criAtomExPlayback_SetNextBlockIndex ֐gpčsA
 * Đ̃ubNCfbNX擾 ::criAtomExPlayback_GetCurrentBlockIndex ֐gp܂B<br>
 * <br>
 * {p[^[ ::criAtomExPlayer_ResetParameters ֐ɂăNA܂B
 * \sa criAtomExPlayer_Start, criAtomExPlayback_SetNextBlockIndex, criAtomExPlayback_GetCurrentBlockIndex, criAtomExPlayer_ResetParameters
 */
void CRIAPI criAtomExPlayer_SetFirstBlockIndex(
	CriAtomExPlayerHn player, CriAtomExBlockIndex index);

/*JP
 * \brief ubNgWVR[obN֐̓o^
 * \ingroup ATOMEXLIB_PLAYER
 * \param[in]	player		AtomExv[[nh
 * \param[in]	func		ubNgWVR[obN֐
 * \param[in]	obj			[UwIuWFNg
 * \par :
 * ubNV[PXĐɃubNgWVƂɌĂяoR[obN֐o^܂B<br>
 * o^ꂽR[obN֐́AubNgWVƌĂяo܂B<br>
 * <br>
 * R[obN֐ŁAAtomCuAPIsȂłB<br>
 * R[obN֐AtomCũT[o[s܂B<br>
 * ̂߁AT[o[ւ̊荞݂lȂAPIsꍇA
 * G[AfbhbN\܂B<br>
 * <br>
 * R[obN֐ŒԏubNƁA؂ꓙ̖
 * ܂̂ŁAӂB<br>
 * <br>
 * R[obN֐1o^ł܂B<br>
 * o^𕡐sꍇAɓo^ς݂̃R[obN֐A
 * ォo^R[obN֐ɂ㏑Ă܂܂B<br>
 * <br>
 * funcNULLw肷邱Ƃœo^ς݊֐̓o^s܂B<br>
 * \sa CriAtomExPlayerBlockTransitionCbFunc
 */
void CRIAPI criAtomExPlayer_SetBlockTransitionCallback(
	CriAtomExPlayerHn player, CriAtomExPlayerBlockTransitionCbFunc func, void *obj);

/*JP
 * \brief TEhIuWFNg̎擾
 * \ingroup ATOMEXLIB_PLAYER
 * \param[in]	player		AtomExv[[nh
 * \return TEhIuWFNgnh
 * \par :
 * AtomExv[[Ɋ֘AtĂTEhIuWFNg擾܂B<br>
 * ǂ̃TEhIuWFNgɂ֘AtĂȂꍇNULLԂ܂B
 * \sa CriAtomExSoundObjectHn, criAtomExSoundObject_AddPlayer
 */
CriAtomExSoundObjectHn CRIAPI criAtomExPlayer_GetSoundObject(CriAtomExPlayerHn player); 

/*JP
 * \brief hCZhx̐ݒiCRI Audio݊pj
 * \ingroup ATOMEXLIB_PLAYER
 * \param[in]	player			AtomExv[[nh
 * \param[in]	spk				Xs[J[ID
 * \param[in]	offset			hCZhxItZbgiZlj	
 * \param[in]	gain			hCZhxQCiZlj
 * \par :
 * õ͉hCZhxݒ肵܂B<br>
 * {֐CRI AudioƂ̌݊płACRI AudioɂhCZhxƓ܂B<br>
 * {֐ŃhCZhxݒA::criAtomExPlayer_Start ֐ōĐJnƁA
 * ݒ肳ꂽhCZhxŉĐ܂B<br>
 * ܂hCZhxݒ ::criAtomExPlayer_Update ֐ ::criAtomExPlayer_UpdateAll 
 * ֐ĂяoƂŁAłɍĐꂽ̃hCZhxXV邱Ƃ\łB<br>
 * <br>
 * hCZhxł́AĐ̊eXs[J[ւ̏o̓xʂɎw肷邱Ƃł܂B<br>
 * eXs[J[ւ̏o͂ƂĂǂ̓̓`lgp邩́Ag`̃`lɈˑ܂B
 * Ⴆ΃mg`̏ꍇ͑SẴXs[J[ւ̏o͂Ƃ0`l͂ƂĎgpA
 * XeIg`̏ꍇL̃Xs[J[iL,SL,SBLjւ̏o͂ɂ0`liL`ljA
 * R̃Xs[J[iR,SR,SBLjւ̏o͂ɂ1`liR`lj͂ƂĎgp܂B
 * ihCZhx̐ݒł́AXeỈ̓Z^[Xs[J[ALFEւ͏o͂ł܂Bj<br>
 * <br>
 * hCZhx́Ap3DZhx̐ݒɂo̓xɑ΂ĉZ܂B<br>
 * hCZhxl͈̔͂∵́A{Iɂ̓{[ƓłB::criAtomExPlayer_SetVolume ֐QƂĂB<br>
 * hCZhx̃ftHgl0.0fłB<br>
 * <br>
 * \par :
 * \code
 * main()
 * {
 *  	F
 *  // ljĐ鉹̓młƉ
 * 	// hCZhxݒif[^̒l𔼕ɂ0.2fZj
 * 	criAtomExPlayer_SetDrySendLevel(player, CRIATOMEX_SPEAKER_FRONT_CENTER, 0.2f, 0.5f);
 *  
 *  // Đ̊Jn
 *  // ljhCZhx̓v[[ɐݒ肳ꂽlōĐB
 *  id = criAtomExPlayer_Start(player);
 *  	F
 * 	// hCZhxݒif[^̒l𖳌ɂ0.8fŏ㏑j
 *  // Ӂj̎_ł͍Đ̉̃hCZhx͕ύXȂB
 * 	criAtomExPlayer_SetDrySendLevel(player, CRIATOMEX_SPEAKER_FRONT_CENTER, 0.8f, 0.0f);
 *  
 *  // v[[ɐݒ肳ꂽhCZhxĐ̉ɂf
 *  criAtomExPlayer_Update(player, id);
 *  	F
 * }
 * \endcode
 * \par l:
 * L[ĐAf[^ɃhCZhxݒ肳Ăꍇɖ{֐ĂяoƁA
 * f[^ɐݒ肳Ălɑ΂ gain ZA offset ZlKp܂B<br>
 * Ⴆ΁Af[^̃hCZhx1.0fAAtomExv[[̃hCZhx offset 0.2fAgain 0.5f
 * ̏ꍇAۂɓKpZhx0.7fɂȂ܂B<br>
 * hCZhx͒ʏłCRI Atom Craftł͐ݒłACRI Audio Craftō쐬
 * vWFNgt@CC|[gꍇɂ̂݁Af[^ɐݒ肳Ăꍇ܂B<br>
 * ʏł6chfނĐہAIɃZ^[^LFEo͂܂A
 * f[^܂͖{֐ŃhCZhxݒ肳ꂽꍇAł͏o͂ȂȂ܂B
 * ܂lɁAf[^܂͖{֐ŃhCZhxݒ肳ꂽꍇACRI Atom CraftŐݒ肵Z^[^LFE~bNXx͖ƂȂ܂B<br>
 * <br>
 * {p[^[ ::criAtomExPlayer_ResetParameters ֐ɂăNA܂B
 * \sa criAtomExPlayer_Start, criAtomExPlayer_Update, criAtomExPlayer_UpdateAll, criAtomExPlayer_ResetParameters
 */
void CRIAPI criAtomExPlayer_SetDrySendLevel(
	CriAtomExPlayerHn player, CriAtomExSpeakerId spk, CriFloat32 offset, CriFloat32 gain);

/*JP
 * \brief ZN^[̃v[[ւ̐ݒ
 * \ingroup ATOMEXLIB_PLAYER
 * \param[in]	player			AtomExv[[nh
 * \param[in]	selector		ZN^[
 * \param[in]	label			x
 * \par :
 * ZN^[ƃxw肵āAv[[ɐݒ肵܂B<br>
 * gbNɃZN^[xw肳ĂL[ĐꍇA{֐Ŏw肵ZN^[x
 * ƈvgbNĐ܂B<br>
 * ZN^[AxACFwb_[ɋLڂĂ܂B<br>
 * v[[ɐݒ肵x̌ʍ폜́A ::criAtomExPlayer_UnsetSelectorLabel ֐sĂB<br>
 * v[[ɐݒ肵ẍꊇ폜́A ::criAtomExPlayer_ClearSelectorLabels ֐sĂB<br>
 * x܂ޑSẴv[[ݒl폜́A ::criAtomExPlayer_ResetParameters ֐sĂB<br>
 * \sa criAtomExPlayer_ClearSelectorLabels, criAtomExPlayer_ResetParameters, criAtomExPlayer_Update, criAtomExPlayer_UpdateAll
 */
void CRIAPI criAtomExPlayer_SetSelectorLabel(
	CriAtomExPlayerHn player, const CriChar8 *selector, const CriChar8 *label);

/*JP
 * \brief v[[ɐݒ肳ĂZN^[̍폜
 * \ingroup ATOMEXLIB_PLAYER
 * \param[in]	player			AtomExv[[nh
 * \param[in]	selector		ZN^[
 * \par :
 * v[[ɐݒ肳Ăw肳ꂽZN^[ƂɕRÂx̏폜܂B<br>
 * ܂폜A::criAtomExPlayer_Update ֐A::criAtomExPlayer_UpdateAll ֐ĂяoƂɂA
 * łɍĐ̉ɑ΂ăZN^[̍폜s܂AĐ~邱Ƃ͂܂B
 * \sa criAtomExPlayer_SetSelectorLabel, criAtomExPlayer_Update, criAtomExPlayer_UpdateAll
 */
void CRIAPI criAtomExPlayer_UnsetSelectorLabel(CriAtomExPlayerHn player, const CriChar8 *selector);

/*JP
 * \brief v[[ɐݒ肳ĂSẴZN^[̍폜
 * \ingroup ATOMEXLIB_PLAYER
 * \param[in]	player			AtomExv[[nh
 * \par :
 * v[[ɐݒ肳ĂZN^[AxSč폜܂B<br>
 * ܂폜A::criAtomExPlayer_Update ֐A::criAtomExPlayer_UpdateAll ֐ĂяoƂɂA
 * łɍĐ̉ɑ΂ăZN^[̍폜s܂AĐ~邱Ƃ͂܂B
 * \sa criAtomExPlayer_SetSelectorLabel, criAtomExPlayer_Update, criAtomExPlayer_UpdateAll
 */
void CRIAPI criAtomExPlayer_ClearSelectorLabels(CriAtomExPlayerHn player);

/*JP
 * \brief ĐgbNԍʒmR[obN֐̓o^
 * \ingroup ATOMEXLIB_PLAYER
 * \param[in]	player		AtomExv[[nh
 * \param[in]	func		ĐgbNԍʒmR[obN֐
 * \param[in]	obj			[UwIuWFNg
 * \par :
 * ĐgbNԍʒm邽߂̃R[obN֐o^܂B<br>
 * o^ꂽR[obN֐́A|tHjbN^CvȊÕL[ĐɌĂяo܂B<br>
 * <br>
 * R[obN֐ŁAAtomCuAPIsȂłB<br>
 * R[obN֐AtomCũT[o[s܂B<br>
 * ̂߁AT[o[ւ̊荞݂lȂAPIsꍇA
 * G[AfbhbN\܂B<br>
 * <br>
 * R[obN֐ŒԏubNƁA؂ꓙ̖
 * ܂̂ŁAӂB<br>
 * <br>
 * R[obN֐1o^ł܂B<br>
 * o^𕡐sꍇAɓo^ς݂̃R[obN֐A
 * ォo^R[obN֐ɂ㏑Ă܂܂B<br>
 * <br>
 * funcNULLw肷邱Ƃœo^ς݊֐̓o^s܂B<br>
 * \sa CriAtomExPlayerPlaybackTrackInfoNotificationCbFunc
 */
void CRIAPI criAtomExPlayer_SetPlaybackTrackInfoNotificationCallback(
	CriAtomExPlayerHn player, CriAtomExPlayerPlaybackTrackInfoNotificationCbFunc func, void *obj);

/*JP
 * ĐCxgR[obN̓o^
 * \ingroup ATOMEXLIB_PLAYER
 * \param[in]	player		AtomExv[[nh
 * \param[in]	func		ĐCxgR[obN֐
 * \param[in]	obj			[UwIuWFNg
 * \par :
 * ĐCxgR[obNo^܂B<br>
 * {֐gpčĐCxgR[obNo^邱ƂŁA
 * ĐCxgiĐp\[X̊mہ^A{CX̊蓖āAo[`j̏ڍ׏
 * iĐAtomExv[[ĐIDj擾\łB<br>
 * \par l:
 *  2 i obj jɃZbgĺAR[obN֐̈Ƃēn܂B<br>
 * R[obN֐̂̑̈ɂẮA
 * ʓr ::CriAtomExPlaybackEventCbFunc ̐QƂB<br>
 * <br>
 * funcNULLw肷邱Ƃœo^ς݊֐̓o^s܂B<br>
 * \attention
 * 1AtomExv[[ɑ΂A1̃R[obN֐o^ł܂B<br>
 * o^𕡐sꍇAɓo^ς݂̃R[obN֐A
 * ォo^R[obN֐ɂ㏑Ă܂܂B<br>
 * \sa CriAtomExVoiceEventCbFunc
 */
void CRIAPI criAtomExPlayer_SetPlaybackEventCallback(
	CriAtomExPlayerHn player, CriAtomExPlaybackEventCbFunc func, void *obj);

/*JP
 * \brief ͉̃`lRtBOw
 * \ingroup ATOMEXLIB_PLAYER
 * \param[in]   player              AtomExv[[nh
 * \param[in]   num_channels        `l
 * \param[in]   channel_config      `lRtBO
 * \par :
 * ͉̃`lRtBOw肵܂B<br>
 * {֐sɎw肵`l̉ĐꍇAY̊e`l͎̑w肵`lRtBOɊÂĔf܂B
 * \par l:
 * ftHgl::criAtom_ChangeDefaultChannelConfig ֐ɂĕύX\łB<br>
 * {p[^[ ::criAtomExPlayer_ResetParameters ֐ɂăNA܂B
 * \sa criAtom_ChangeDefaultChannelConfig, criAtomExPlayer_ResetParameters
 */
void CRIAPI criAtomExPlayer_SetChannelConfig(
    CriAtomExPlayerHn player, CriSint32 num_channels, CriAtomChannelConfig channel_config);

/*==========================================================================
 *      CRI AtomEx Playback API
 *=========================================================================*/
/*JP
 * \brief Đ̒~
 * \ingroup ATOMEXLIB_PLAYBACK
 * \param[in]	id			ĐID
 * \par :
 * ĐPʂŒ~s܂B<br>
 * {֐gp邱ƂŁAv[[ɂčĐꂽAv[[Pʂł͂ȂA
 * ʂɒ~邱Ƃ\łB<br>
 * \par l:
 * AtomEx v[[ɂčĐꂽSẲ~ꍇA
 * {֐ł͂Ȃ ::criAtomExPlayer_Stop ֐pB<br>
 * i ::criAtomExPlayer_Stop ֐́Ãv[[ōĐ̑SẲ~܂Bj<br>
 * \attention
 * {֐ōĐ̒~sƁAĐ̉̃Xe[^X
 * ::CRIATOMEXPLAYBACK_STATUS_REMOVED ɑJڂ܂B<br>
 * ~Ƀ{CX\[Xj邽߁AU ::CRIATOMEXPLAYBACK_STATUS_REMOVED
 * ԂɑJڂĐ ID ́Aȍ~擾łȂȂ܂B<br>
 * \sa criAtomExPlayer_Stop, criAtomExPlayback_GetStatus
 */
void CRIAPI criAtomExPlayback_Stop(CriAtomExPlaybackId id);

/*JP
 * \brief Đ̒~i[X^Cj
 * \ingroup ATOMEXLIB_PLAYBACK
 * \param[in]	id			ĐID
 * \par :
 * ĐPʂŒ~s܂B<br>
 * ̍ہAĐ̉ɃGx[ṽ[X^Cݒ肳ĂƂĂA𖳎Ē~܂B<br>
 * {֐gp邱ƂŁAv[[ɂčĐꂽAv[[Pʂł͂ȂA
 * ʂɒ~邱Ƃ\łB<br>
 * \par l:
 * v[[ɂčĐꂽSẲ~ꍇA
 * {֐ł͂Ȃ ::criAtomExPlayer_StopWithoutReleaseTime ֐pB<br>
 * \attention
 * {֐ōĐ̒~sƁAĐ̉̃Xe[^X
 * ::CRIATOMEXPLAYBACK_STATUS_REMOVED ɑJڂ܂B<br>
 * ~Ƀ{CX\[Xj邽߁AU ::CRIATOMEXPLAYBACK_STATUS_REMOVED
 * ԂɑJڂĐ ID ́Aȍ~擾łȂȂ܂B<br>
 * \sa criAtomExPlayer_StopWithoutReleaseTime
 */
void CRIAPI criAtomExPlayback_StopWithoutReleaseTime(CriAtomExPlaybackId id);

/*JP
 * \brief Đ̃|[Y^|[Y
 * \ingroup ATOMEXLIB_PLAYBACK
 * \param[in]	id			ĐID
 * \param[in]	sw			XCb`i CRI_FALSE = |[YA CRI_TRUE = |[Y j
 * \par :
 * ĐPʂŃ|[Y^|[Ys܂B<br>
 * sw  CRI_TRUE w肵Ė{֐sƁAw肵ID̉|[Y
 * iꎞ~j܂B<br>
 * sw  CRI_FALSE w肵Ė{֐sƁAw肵ID̉̃|[Y
 * Aꎞ~Ă̍ĐĊJ܂B<br>
 * <br>
 * {֐gp邱ƂŁAv[[ɂčĐꂽAv[[Pʂł͂ȂA
 * ʂɃ|[Y^|[Y邱Ƃ\łB<br>
 * \par l:
 * v[[ɂčĐꂽSẲ|[Y^|[YꍇA
 * {֐ł͂Ȃ ::criAtomExPlayer_Pause ֐pB<br>
 * <br>
 * tF[_[A^b`v[[ōĐɑ΂Ė{֐ŌʂɃ|[Y^|[Y̑sꍇA
 * NXtF[h̓tF[hC̉̃|[YԂɓčs܂B<br>
 * Ⴆ΁ANXtF[hcriAtomExPlayer_Pause ֐ŗ̉|[YꍇA
 * tF[hC̉̃|[Y΃NXtF[hĊJ܂A
 * tF[hAEg̉̃|[YĂNXtF[h͍ĊJ܂B<br>
 * \attention
 * 2iswj CRI_FALSE w肵ă|[Y̑sꍇA
 * {֐Ń|[YłȂA::criAtomExPlayer_Prepare 
 * ֐ōĐ̉ɂĂĐJnĂ܂܂B<br>
 * io[WƂ̌݊ێ̂߂̎dlłBj<br>
 * {֐Ń|[YɂĂ̂݃|[YꍇA
 * {֐gpA criAtomExPlayback_Resume(id, CRIATOMEX_RESUME_PAUSED_PLAYBACK);
 * să|[YsĂB<br>
 * <br>
 * tF[_[A^b`v[[ɑ΂ĐIDwŃ|[ỶsƁA
 * tF[hC鉹̔\[XmۂłȂꍇA
 * tF[hC鉹̔\[XDꂽꍇɃ|[YsA
 * tF[hAEg̉܂ŌoĂtF[hAEgȂԂƂȂ܂B<br>
 * tF[_[A^b`v[[ōĐɑ΂ẮA{֐ł͂ȂA
 * ::criAtomExPlayer_Pause ֐Ń|[ỶsĂB<br>
 * \sa criAtomExPlayback_IsPaused, criAtomExPlayer_Pause, criAtomExPlayback_Resume
 */
void CRIAPI criAtomExPlayback_Pause(CriAtomExPlaybackId id, CriBool sw);

/*JP
 * \brief Đ̋@\ʂ̃|[Y
 * \ingroup ATOMEXLIB_PLAYBACK
 * \param[in]	id			ĐID
 * \param[in]	mode		|[YΏ
 * \par :
 * ĐPʂňꎞ~Ԃ̉s܂B<br>
 * ::criAtomExPlayback_Pause ֐ƈقȂA ::criAtomExPlayer_Prepare
 * ֐ōĐJn҂̉ƁA ::criAtomExPlayer_Pause ֐i܂
 * ::criAtomExPlayback_Pause ֐Ń|[YƂA
 * ʂɍĊJ邱Ƃ\łB<br>
 * <br>
 * 2imodej ::CRIATOMEX_RESUME_PAUSED_PLAYBACK w肵Ė{֐sƁA
 * [U ::criAtomExPlayer_Pause ֐i܂ ::criAtomExPlayback_Pause 
 * ֐jňꎞ~ԂɂȂ̍ĐĊJ܂B<br>
 * 2imodej ::CRIATOMEX_RESUME_PREPARED_PLAYBACK w肵Ė{֐sƁA
 * [U ::criAtomExPlayer_Prepare ֐ōĐw̍ĐJn܂B<br>
 * <br>
 * ::criAtomExPlayback_Pause ֐Ń|[YԂ̃v[[ɑ΂
 * ::criAtomExPlayer_Prepare ֐ōĐsꍇA
 * ̉ ::CRIATOMEX_RESUME_PAUSED_PLAYBACK
 * w̃|[YƁA ::CRIATOMEX_RESUME_PREPARED_PLAYBACK
 * w̃|[Y̗s܂ŁAĐJn܂B<br>
 * \par l:
 * tF[_[A^b`v[[ōĐɑ΂Ė{֐ŌʂɃ|[Y̑sꍇA
 * NXtF[h̓tF[hC̉̃|[YԂɓčs܂B<br>
 * Ⴆ΁ANXtF[hcriAtomExPlayer_Pause ֐ŗ̉|[YꍇA
 * tF[hC̉̃|[Y΃NXtF[hĊJ܂A
 * tF[hAEg̉̃|[YĂNXtF[h͍ĊJ܂B<br>
 * \attention
 * tF[_[A^b`v[[ɑ΂ĐIDwŃ|[ỶsƁA
 * tF[hC鉹̔\[XmۂłȂꍇA
 * tF[hC鉹̔\[XDꂽꍇɃ|[YsA
 * tF[hAEg̉܂ŌoĂtF[hAEgȂԂƂȂ܂B<br>
 * tF[_[A^b`v[[ōĐɑ΂ẮA{֐ł͂ȂA
 * ::criAtomExPlayer_Pause ֐Ń|[ỶsĂB<br>
 * \sa criAtomExPlayback_IsPaused, criAtomExPlayer_Resume, criAtomExPlayer_Pause
 */
void CRIAPI criAtomExPlayback_Resume(CriAtomExPlaybackId id, CriAtomExResumeMode mode);

/*JP
 * \brief Đ̃|[YԂ̎擾
 * \ingroup ATOMEXLIB_PLAYBACK
 * \param[in]	id			ĐID
 * \return		CriBool		|[YǂiCRI_FALSE = |[YĂȂACRI_TRUE = |[Yj
 * \par :
 * Đ̉|[YǂԂ܂B<br>
 * \sa criAtomExPlayback_Pause
 */
CriBool CRIAPI criAtomExPlayback_IsPaused(CriAtomExPlaybackId id);

/*JP
 * \brief ĐXe[^X̎擾
 * \ingroup ATOMEXLIB_PLAYBACK
 * \param[in]	id						ĐID
 * \return		CriAtomExPlaybackStatus	ĐXe[^X
 * \par :
 * ::criAtomExPlayer_Start ֐ōĐꂽ̃Xe[^X擾܂B<br>
 * \par l:
 * ::criAtomExPlayer_GetStatus ֐AtomExv[[̃Xe[^XԂ̂ɑ΂A
 * {֐͍Đς݂̌X̉̃Xe[^X擾܂B<br>
 * <br>
 * Đ̉̃{CX\[X́Aȉ̏ꍇɍ폜܂B<br>
 * - ĐꍇB
 * - criAtomExPlayback_Stop ֐ōĐ̉~ꍇB
 * - vCIeB̔NGXgɂĐ̃{CXDꂽꍇB
 * - ĐɃG[ꍇB
 * 
 * ̂߁A ::criAtomExPlayback_Stop ֐gpĖIɍĐ~A
 * ̗̑vɂčĐ~ꂽ̈ႢɊ֌WȂA
 * Đ̃Xe[^X͂̏ꍇ ::CRIATOMEXPLAYBACK_STATUS_REMOVED
 * ɑJڂ܂B<br>
 * iG[̔mKvꍇɂ́A{֐ł͂ȂA::criAtomExPlayer_GetStatus
 * ֐ AtomEx v[[̃Xe[^X`FbNKv܂Bj<br>
 * \sa criAtomExPlayer_Start, criAtomExPlayer_GetStatus, criAtomExPlayback_Stop
 */
CriAtomExPlaybackStatus CRIAPI criAtomExPlayback_GetStatus(CriAtomExPlaybackId id);

/*JP
 * \brief Đ̃tH[}bg̎擾
 * \ingroup ATOMEXLIB_PLAYBACK
 * \param[in]	id			ĐID
 * \param[out]	info		tH[}bg
 * \return		CriBool		񂪎擾łǂi CRI_TRUE = 擾łA CRI_FALSE = 擾łȂj
 * \par :
 * ::criAtomExPlayer_Start ֐ōĐꂽ̃tH[}bg擾܂B<br>
 * <br>
 * tH[}bg񂪎擾łꍇA{֐ CRI_TRUE Ԃ܂B<br>
 * w肵{CXɏĂꍇɂ́A{֐ CRI_FALSE Ԃ܂B<br>
 * \par l:
 * ̉f[^܂ރL[ĐꍇAŏɌ
 * f[^̏񂪕Ԃ܂B<br>
 * \attention
 * {֐́AĐ̂݃tH[}bg擾\łB<br>
 * ĐĐIAɂ{CXꂽꍇɂ́A
 * tH[}bg̎擾Ɏs܂B<br>
 * {CX̍ĐԂ criAtomExPlayback_GetStatus ֐Ŏ擾邱Ƃ͂łȂ߂ӂB
 * \sa criAtomExPlayer_Start, criAtomExPlayer_GetStatus
 */
CriBool CRIAPI criAtomExPlayback_GetFormatInfo(
	CriAtomExPlaybackId id, CriAtomExFormatInfo *info);

/*JP
 * \brief Đ̍Đ̎擾
 * \ingroup ATOMEXLIB_PLAYBACK
 * \param[in]	id			ĐID
 * \param[out]	source		Đ
 * \retval CRI_TRUE = 񂪎擾ł
 * \retval CRI_FALSE = 񂪎擾łȂ
 * \par :
 * ::criAtomExPlayer_Start ֐ōĐꂽ̍Đ擾܂B<br>
 * 擾ɁA::criAtomExAcb_GetCueInfoByIndex ֐𗘗p邱ƂŁA
 * ڍׂȏ擾邱Ƃł܂B<br>
 * <br>
 * Đ񂪎擾łꍇA{֐ CRI_TRUE Ԃ܂B<br>
 * w肵{CXɏĂꍇɂ́A{֐ CRI_FALSE Ԃ܂B<br>
 * \par l
 * Đ̃^CvɂāA擾ł񂪈قȂ܂B<br>
 * typeQƂApsource̒̂ǂ̍\̂ƂăANZX邩IĂB<br>
 * \code
 * CriAtomExSourceInfo source;
 * criAtomExPlayback_GetSource(playback_id, &source);
 * 
 * switch (source.type) {
 * case CRIATOMEXPLAYBACK_SOURCE_TYPE_CUE_ID:
 * 	{
 * 		CriAtomExCueInfo cue_info;
 * 		criAtomExAcb_GetCueInfoById(source.info.cue_id.acb, source.info.cue_id.id, &cue_info);
 *			:
 * 	}
 * 	break;
 * 		:
 * }
 * \endcode
 * \attention
 * {֐́AĐ̂ݍĐ擾\łB<br>
 * ĐIAɂ{CXꂽꍇɂ́A
 * Đ̎擾Ɏs܂B<br>
 * \sa criAtomExPlayer_Start, criAtomExPlayer_GetStatus
 */
CriBool CRIAPI criAtomExPlayback_GetSource(
	CriAtomExPlaybackId id, CriAtomExSourceInfo *source);

/*JP
 * \brief Atomv[[̎擾
 * \ingroup ATOMEXLIB_PLAYBACK
 * \param[in]	id			ĐID
 * \retval CriAtomPlayerHn	Atomv[[nh
 * \par :
 * ĐIDɕRÂꂽ{CXiAtomv[[nhj擾܂B<br>
 * \par l:
 * ̔g`f[^܂ރL[ĐĂꍇA
 * {֐͍ŏɌ{CXɑΉAtomv[[nhԂ܂B<br>
 * g`f[^ĐĂȂꍇA{֐NULLԂ܂B<br>
 */
CriAtomPlayerHn CRIAPI criAtomExPlayback_GetAtomPlayer(CriAtomExPlaybackId id);

/*JP
 * \brief Đ̎擾
 * \ingroup ATOMEXLIB_PLAYBACK
 * \param[in]	id		ĐID
 * \return		Sint64	Đi~bPʁj
 * \par :
 * ::criAtomExPlayer_Start ֐ōĐꂽ̍Đ擾܂B<br>
 * <br>
 * Đ擾łꍇA{֐ 0 ȏ̒lԂ܂B<br>
 * w肵{CXɏĂꍇɂ́A{֐͕lԂ܂B<br>
 * \par l:
 * {֐ԂĐ́uĐJnォ̌oߎԁvłB<br>
 * [vĐAV[XAĐsꍇłA
 * ĐʒuɉĎ߂邱Ƃ͂܂B<br>
 * <br>
 * ::criAtomExPlayer_Pause ֐Ń|[YꍇA
 * Đ̃JEgAbv~܂B<br>
 * i|[Y΍ēxJEgAbvĊJ܂Bj
 * <br>
 * {֐Ŏ擾\Ȏ̐x́AT[o[̎gɈˑ܂B<br>
 * i̍XV̓T[o[Pʂōs܂Bj<br>
 * 萸x̍擾Kvꍇɂ́A{֐̑
 * ::criAtomExPlayback_GetNumPlayedSamples ֐gpA
 * Đς݃Tv擾ĂB<br>
 * \attention
 * ߂ľ^CriSint64łAA32bitȏ̐x͂܂B<br>
 * ĐɐsꍇA24ōĐُɂȂ_ɒӂKvłB<br>
 * i 2147483647 ~b𒴂_ŁAĐI[o[t[AlɂȂ܂Bj<br>
 * <br>
 * {֐́AĐ̂ݎ擾\łB<br>
 * i ::criAtomExPlayer_GetTime ֐ƈقȂA{֐͍Đ̉ƂɎ
 * 擾\łAĐI邱Ƃł܂Bj<br>
 * ĐIAɂ{CXꂽꍇɂ́A
 * Đ̎擾Ɏs܂B<br>
 * ilԂ܂Bj<br>
 * <br>
 * hCuŃ[hgCAꎞIɉf[^̋r؂ꂽꍇłA
 * Đ̃JEgAbvr؂邱Ƃ͂܂B<br>
 * if[^~ɂĐ~ꍇłA͐iݑ܂Bj<br>
 * ̂߁A{֐Ŏ擾ɉfƂ̓sꍇA
 * [hgCɓ傫Y\܂B<br>
 * g`f[^Ɖf̓ɎKvꍇ́A{֐̑
 * ::criAtomExPlayback_GetNumPlayedSamples ֐gpA
 * Đς݃TvƂ̓ĂB<br>
 * \sa criAtomExPlayer_Start, criAtomExPlayer_GetTime, criAtomExPlayback_GetNumPlayedSamples
 */
CriSint64 CRIAPI criAtomExPlayback_GetTime(CriAtomExPlaybackId id);

/*JP
 * \brief Đ̎擾iĐɓ␳݁j
 * \ingroup ATOMEXLIB_PLAYBACK
 * \param[in]	id		ĐID
 * \return		Sint64	Đi~bPʁj
 * \par :
 * ::criAtomExPlayer_Start ֐ōĐꂽ̍Đ擾܂B<br>
 * <br>
 * Đ擾łꍇA{֐ 0 ȏ̒lԂ܂B<br>
 * w肵{CXɏĂꍇɂ́A{֐͕lԂ܂B<br>
 * \par l:
 * ::criAtomExPlayback_GetTime ֐ԂuĐJnォ̌oߎԁvƂ
 * قȂA{֐͍Đ̉ɓĐ擾邱Ƃ
 * \łB<br>
 * foCX̃[hgCɂ艹f[^̋r؂
 * Đ~ꍇA܂̓VXe̊荞݂ɂ艹o͂Wꂽ
 * ꍇɂ́AĐ̃JEgAbvꎞIɒ~܂B<br>
 * ĐꂽɌɓsꍇ́A{֐
 * 擾ĐpĂB<br>
 * A[vĐAV[XAĐɍsꍇłA
 * ĐʒuɉĎ߂邱Ƃ͂܂B<br>
 * ܂Ag`̋l܂ĂȂV[PXL[
 * Đg`؂ւubNV[PXL[ɑ΂ẮAɍĐ
 * 擾邱Ƃł܂B<br>
 * <br>
 * ::criAtomExPlayer_Pause ֐Ń|[YꍇA
 * Đ̃JEgAbv~܂B<br>
 * i|[Y΍ēxJEgAbvĊJ܂Bj<br>
 * <br>
 * {֐ɂĐ̎擾sꍇ́AΉAtomExv[[쐬ɁA
 * ::CriAtomExPlayerConfig \̂ enable_audio_synced_timer  CRI_TRUE 
 * ݒ肵ĂB<br>
 * ftHgł͖ɂȂĂ܂B<br>
 * <br>
 * ߂ľ^ long łAA32bitȏ̐x͂܂B<br>
 * ĐɐsꍇA24ōĐُɂȂ_ɒӂKvłB<br>
 * i 2147483647 ~b𒴂_ŁAĐI[o[t[AlɂȂ܂Bj<br>
 * <br>
 * {֐́AĐ̂ݎ擾\łB<br>
 * i ::criAtomExPlayer_GetTime ֐ƈقȂA{֐͍Đ̉ƂɎ
 * 擾\łAĐI邱Ƃł܂Bj<br>
 * ĐIAɂ{CXꂽꍇɂ́A
 * Đ̎擾Ɏs܂B<br>
 * ilԂ܂Bj<br>
 * <br>
 * {֐͓ŎvZsĂAvbgtH[ɂĂ͏ׂ
 * ɂȂ\܂B܂AAvP[V̓t[łĂA
 * ĂяoɍXVꂽԂ܂B<br>
 * AvP[VɂĐ̗p@ɂ܂A{Iɖ{֐p
 * 擾1t[ɂx̂ݍs悤ɂĂB<br>
 * \sa criAtomExPlayer_Create, criAtomExPlayer_Start, criAtomExPlayback_GetTime
 */
CriSint64 CRIAPI criAtomExPlayback_GetTimeSyncedWithAudio(CriAtomExPlaybackId id);

/*JP
 * \brief Đ̎擾iĐɓ␳݁j
 * \ingroup ATOMEXLIB_PLAYBACK
 * \param[in]	id		ĐID
 * \return		Sint64	Đi}CNbPʁj
 * \par :
 * ::criAtomExPlayer_Start ֐ōĐꂽ̍Đ擾܂B<br>
 * <br>
 * Đ擾łꍇA{֐ 0 ȏ̒lԂ܂B<br>
 * w肵{CXɏĂꍇɂ́A{֐͕lԂ܂B<br>
 * \par l:
 * ::criAtomExPlayback_GetTime ֐ԂuĐJnォ̌oߎԁvƂ
 * قȂA{֐͍Đ̉ɓĐ擾邱Ƃ
 * \łB<br>
 * foCX̃[hgCɂ艹f[^̋r؂
 * Đ~ꍇA܂̓VXe̊荞݂ɂ艹o͂Wꂽ
 * ꍇɂ́AĐ̃JEgAbvꎞIɒ~܂B<br>
 * ĐꂽɌɓsꍇ́A{֐
 * 擾ĐpĂB<br>
 * A[vĐAV[XAĐɍsꍇłA
 * ĐʒuɉĎ߂邱Ƃ͂܂B<br>
 * ܂Ag`̋l܂ĂȂV[PXL[
 * Đg`؂ւubNV[PXL[ɑ΂ẮAɍĐ
 * 擾邱Ƃł܂B<br>
 * <br>
 * ::criAtomExPlayer_Pause ֐Ń|[YꍇA
 * Đ̃JEgAbv~܂B<br>
 * i|[Y΍ēxJEgAbvĊJ܂Bj<br>
 * <br>
 * {֐ɂĐ̎擾sꍇ́AΉAtomExv[[쐬ɁA
 * ::CriAtomExPlayerConfig \̂ enable_audio_synced_timer  CRI_TRUE 
 * ݒ肵ĂB<br>
 * ftHgł͖ɂȂĂ܂B<br>
 * <br>
 * {֐́AĐ̂ݎ擾\łB<br>
 * i ::criAtomExPlayer_GetTime ֐ƈقȂA{֐͍Đ̉ƂɎ
 * 擾\łAĐI邱Ƃł܂Bj<br>
 * ĐIAɂ{CXꂽꍇɂ́A
 * Đ̎擾Ɏs܂B<br>
 * ilԂ܂Bj<br>
 * <br>
 * {֐͓ŎvZsĂAvbgtH[ɂĂ͏ׂ
 * ɂȂ\܂B܂AAvP[V̓t[łĂA
 * ĂяoɍXVꂽԂ܂B<br>
 * AvP[VɂĐ̗p@ɂ܂A{Iɖ{֐p
 * 擾1t[ɂx̂ݍs悤ɂĂB<br>
 * \sa criAtomExPlayer_Create, criAtomExPlayer_Start, criAtomExPlayback_GetTime
 */
CriSint64 CRIAPI criAtomExPlayback_GetTimeSyncedWithAudioMicro(CriAtomExPlaybackId id);

/*JP
 * \brief V[PXĐʒu̎擾
 * \ingroup ATOMEXLIB_PLAYBACK
 * \param[in]	id		ĐID
 * \return		Sint64	V[PXĐʒui~bPʁj
 * \par :
 * ::criAtomExPlayer_Start ֐ōĐꂽ̃V[PXĐʒu擾܂B<br>
 * <br>
 * Đʒu擾łꍇA{֐ 0 ȏ̒lԂ܂B<br>
 * w肵V[PXɏĂꍇɂ́A{֐͕lԂ܂B<br>
 * \par l:
 * {֐ԂĐ́uV[PXf[^̍ĐʒuvłB<br>
 * V[PX[vAubNJڂsꍇ́A߂lԂ܂B<br>
 * <br>
 * L[wȊOł̍Đł̓V[PT[삵܂BL[ĐȊO̍Đɑ΂
 * {֐͕lԂ܂B<br>
 * <br>
 * ::criAtomExPlayer_Pause ֐Ń|[YꍇA
 * Đʒu̍XV~܂B<br>
 * i|[Y΍ēxXVĊJ܂Bj
 * <br>
 * {֐Ŏ擾\Ȏ̐x́AT[o[̎gɈˑ܂B<br>
 * i̍XV̓T[o[Pʂōs܂Bj<br>
 * \attention
 * ߂ľ^CriSint64łAA32bitȏ̐x͂܂B<br>
 * ĐʒuɐsꍇAV[PX[v̐ݒ肪Ȃf[^ł͖24ōĐʒuُɂȂ_ɒӂKvłB<br>
 * i 2147483647 ~b𒴂_ŁAĐʒuI[o[t[AlɂȂ܂Bj<br>
 * <br>
 * {֐́AĐ݈̂ʒu擾\łB<br>
 * ĐIAɂV[PXꂽꍇɂ́A
 * Đʒu̎擾Ɏs܂B<br>
 * ilԂ܂Bj<br>
 */
CriSint64 CRIAPI criAtomExPlayback_GetSequencePosition(CriAtomExPlaybackId id);

/*JP
 * \brief ĐTv̎擾
 * \ingroup ATOMEXLIB_PLAYBACK
 * \param[in]	id				ĐID
 * \param[out]	num_samples		Đς݃Tv
 * \param[out]	sampling_rate	TvO[g
 * \return		CriBool			Tv擾łǂi CRI_TRUE = 擾łA CRI_FALSE = 擾łȂj
 * \par :
 * ::criAtomExPlayer_Start ֐ōĐꂽ̍ĐTvA
 * уTvO[gԂ܂B<br>
 * <br>
 * ĐTv擾łꍇA{֐ CRI_TRUE Ԃ܂B<br>
 * w肵{CXɏĂꍇɂ́A{֐ CRI_FALSE Ԃ܂B<br>
 * iG[ num_samples  sampling_rate ̒llɂȂ܂Bj<br>
 * \par l:
 * Đς݃Tv̒l̐x́AvbgtH[ SDK 
 * ̃TEhCuɈˑ܂B<br>
 * ivbgtH[ɂāAĐς݃Tv̐m͈قȂ܂Bj<br>
 * <br>
 * ̉f[^܂ރL[ĐꍇAŏɌ
 * f[^̏񂪕Ԃ܂B<br>
 * \attention
 * hCuŃ[hgCAf[^̋r؂ꂽꍇA
 * ĐTṽJEgAbv~܂B<br>
 * if[^ĊJ΁AJEgAbvĊJ܂Bj<br>
 * <br>
 * {֐́AĐ̂ݍĐTv擾\łB<br>
 * ĐIAɂ{CXꂽꍇɂ́A
 * ĐTv̎擾Ɏs܂B<br>
 * \sa criAtomExPlayer_Start
 */
CriBool CRIAPI criAtomExPlayback_GetNumPlayedSamples(
	CriAtomExPlaybackId id, CriSint64 *num_samples, CriSint32 *sampling_rate);

/*JP
 * \brief TEhobt@[ւ̏݃Tv̎擾
 * \ingroup ATOMEXLIB_PLAYBACK
 * \param[in]	id				ĐID
 * \param[out]	num_samples		ݍς݃Tv
 * \param[out]	sampling_rate	TvO[g
 * \return		CriBool			Tv擾łǂi CRI_TRUE = 擾łA CRI_FALSE = 擾łȂj
 * \par :
 * ::criAtomExPlayer_Start ֐ōĐꂽɂāA
 * TEhobt@[ւ̏ݍς݃TvAуTvO[gԂ܂B<br>
 * {֐ ::criAtomExPlayback_GetNumPlayedSamples ֐ƈقȂA
 * TEhobt@[ɏ܂ꂽo͂̉f[^̃Tv܂ޒlԂ܂B
 * <br>
 * ݍς݃Tv擾łꍇA{֐ CRI_TRUE Ԃ܂B<br>
 * w肵{CXɏĂꍇɂ́A{֐ CRI_FALSE Ԃ܂B<br>
 * iG[ num_samples  sampling_rate ̒llɂȂ܂Bj<br>
 * \par l:
 * ݍς݃Tv̒l̐x́AvbgtH[ SDK 
 * ̃TEhCuɈˑ܂B<br>
 * ivbgtH[ɂāAݍς݃Tv̐m͈قȂ܂Bj<br>
 * <br>
 * ̉f[^܂ރL[ĐꍇAŏɌ
 * f[^̏񂪕Ԃ܂B<br>
 * \attention
 * hCuŃ[hgCAf[^̋r؂ꂽꍇA
 * ݍς݃TṽJEgAbv~܂B<br>
 * if[^ĊJ΁AJEgAbvĊJ܂Bj<br>
 * <br>
 * {֐́AĐ̂ݏݍς݃Tv擾\łB<br>
 * ĐIAɂ{CXꂽꍇɂ́A
 * ݍς݃Tv̎擾Ɏs܂B<br>
 * \sa criAtomExPlayback_GetNumPlayedSamples
 */
CriBool CRIAPI criAtomExPlayback_GetNumRenderedSamples(
	CriAtomExPlaybackId id, CriSint64 *num_samples, CriSint32 *sampling_rate);

/*JP
 * \brief p[^̎擾i_j
 * \ingroup ATOMEXLIB_PLAYBACK
 * \param[in]	playback_id		ĐID
 * \param[in]	parameter_id	p[^[ID
 * \param[out]	value_float32	p[^[ݒl
 * \return		p[^[擾łǂi CRI_TRUE = 擾łA CRI_FALSE = 擾łȂj
 * \par :
 * ::criAtomExPlayer_Start ֐ōĐꂽɐݒ肳Ăep[^[̒l擾܂B<br>
 * l͕_Ŏ擾܂B<br>
 * p[^[擾łꍇA{֐ CRI_TRUE Ԃ܂B<br>
 * w肵{CXɏĂꍇɂ́A{֐ CRI_FALSE Ԃ܂B<br>
 * \attention
 * {֐́AĐ̂݃p[^[擾\łB<br>
 * ĐIAɂ{CXꂽꍇɂ́A
 * p[^[̎擾Ɏs܂B<br>
 * \sa CriAtomExParameterId, criAtomExPlayback_GetParameterUint32, criAtomExPlayback_GetParameterSint32
 */
CriBool CRIAPI criAtomExPlayback_GetParameterFloat32(
	CriAtomExPlaybackId playback_id,
	CriAtomExParameterId parameter_id,
	CriFloat32 *value_float32
);

/*JP
 * \brief p[^[̎擾iȂj
 * \ingroup ATOMEXLIB_PLAYBACK
 * \param[in]	playback_id		ĐID
 * \param[in]	parameter_id	p[^[ID
 * \param[out]	value_uint32	p[^[ݒl
 * \return		p[^[擾łǂi CRI_TRUE = 擾łA CRI_FALSE = 擾łȂj
 * \par :
 * ::criAtomExPlayer_Start ֐ōĐꂽɐݒ肳Ăep[^[̒l擾܂B<br>
 * l͕ȂŎ擾܂B<br>
 * p[^[擾łꍇA{֐ CRI_TRUE Ԃ܂B<br>
 * w肵{CXɏĂꍇɂ́A{֐ CRI_FALSE Ԃ܂B<br>
 * \attention
 * {֐́AĐ̂݃p[^[擾\łB<br>
 * ĐIAɂ{CXꂽꍇɂ́A
 * p[^[̎擾Ɏs܂B<br>
 * \sa CriAtomExParameterId, criAtomExPlayback_GetParameterFloat32, criAtomExPlayback_GetParameterSint32
 */
CriBool CRIAPI criAtomExPlayback_GetParameterUint32(
	CriAtomExPlaybackId playback_id,
	CriAtomExParameterId parameter_id,
	CriUint32* value_uint32
);

/*JP
 * \brief p[^[̎擾itj
 * \ingroup ATOMEXLIB_PLAYBACK
 * \param[in]	playback_id		ĐID
 * \param[in]	parameter_id	p[^[ID
 * \param[out]	value_sint32	p[^[ݒl
 * \return		p[^[擾łǂi CRI_TRUE = 擾łA CRI_FALSE = 擾łȂj
 * \par :
 * ::criAtomExPlayer_Start ֐ōĐꂽɐݒ肳Ăep[^[̒l擾܂B<br>
 * l͕tŎ擾܂B<br>
 * p[^[擾łꍇA{֐ CRI_TRUE Ԃ܂B<br>
 * w肵{CXɏĂꍇɂ́A{֐ CRI_FALSE Ԃ܂B<br>
 * \attention
 * {֐́AĐ̂݃p[^[擾\łB<br>
 * ĐIAɂ{CXꂽꍇɂ́A
 * p[^[̎擾Ɏs܂B<br>
 * \sa CriAtomExParameterId, criAtomExPlayback_GetParameterFloat32, criAtomExPlayback_GetParameterUint32
 */
CriBool CRIAPI criAtomExPlayback_GetParameterSint32(
	CriAtomExPlaybackId playback_id,
	CriAtomExParameterId parameter_id,
	CriSint32* value_sint32
);

/*JP
 * \brief AISACRg[l̎擾iRg[IDwj
 * \ingroup ATOMEXLIB_PLAYBACK
 * \param[in]	playback_id		ĐID
 * \param[in]	control_id		Rg[ID
 * \param[out]	control_value	Rg[li0.0f`1.0fjAݒ莞-1.0f
 * \return		AISACRg[l擾łǂi CRI_TRUE = 擾łA CRI_FALSE = 擾łȂj
 * \par :
 * ::criAtomExPlayer_Start ֐ōĐꂽɐݒ肳ĂAISACRg[lARg[IDwŎ擾܂B<br>
 * AISACRg[l擾łꍇiݒ莞u-1.0f擾łvƈ܂jA{֐ CRI_TRUE Ԃ܂B<br>
 * w肵{CXɏĂꍇɂ́A{֐ CRI_FALSE Ԃ܂B<br>
 * \attention
 * {֐́AĐ̂AISACRg[l擾\łB<br>
 * ĐIAɂ{CXꂽꍇɂ́A
 * AISACRg[l̎擾Ɏs܂B<br>
 * \sa criAtomExPlayer_SetAisacControlById, criAtomExPlayback_GetAisacControlByName
 */
CriBool CRIAPI criAtomExPlayback_GetAisacControlById(
	CriAtomExPlaybackId playback_id, CriAtomExAisacControlId control_id, CriFloat32 *control_value);

/*JP
 * \brief AISACRg[l̎擾iRg[wj
 * \ingroup ATOMEXLIB_PLAYBACK
 * \param[in]	playback_id		ĐID
 * \param[in]	control_name	Rg[
 * \param[out]	control_value	Rg[li0.0f`1.0fjAݒ莞-1.0f
 * \return		AISACRg[l擾łǂi CRI_TRUE = 擾łA CRI_FALSE = 擾łȂj
 * \par :
 * ::criAtomExPlayer_Start ֐ōĐꂽɐݒ肳ĂAISACRg[lARg[wŎ擾܂B<br>
 * AISACRg[l擾łꍇiݒ莞u-1.0f擾łvƈ܂jA{֐ CRI_TRUE Ԃ܂B<br>
 * w肵{CXɏĂꍇɂ́A{֐ CRI_FALSE Ԃ܂B<br>
 * \attention
 * {֐́AĐ̂AISACRg[l擾\łB<br>
 * ĐIAɂ{CXꂽꍇɂ́A
 * AISACRg[l̎擾Ɏs܂B<br>
 * \sa criAtomExPlayer_SetAisacControlById, criAtomExPlayback_GetAisacControlByName
 */
CriBool CRIAPI criAtomExPlayback_GetAisacControlByName(
	CriAtomExPlaybackId playback_id, const CriChar8 *control_name, CriFloat32 *control_value);

/*JP
 * \brief Đ̃ubNJ
 * \ingroup ATOMEXLIB_PLAYBACK
 * \param[in]	id			ĐID
 * \param[in]	index		ubNCfbNX
 * \par :
 * ĐPʂŃubNJڂs܂B<br>
 * {֐sƁAw肵ID̉ubNV[PX̏ꍇ̓f[^
 * ݒɏ]Cӂ̑Jڃ^C~OŎwubNɑJڂ܂B
 * <br>
 * \par l:
 * ĐJnubN̎w ::criAtomExPlayer_SetFirstBlockIndex ֐gpčsA
 * Đ̃ubNCfbNX擾 ::criAtomExPlayback_GetCurrentBlockIndex ֐gp܂B
 * \sa criAtomExPlayer_SetFirstBlockIndex, criAtomExPlayback_GetCurrentBlockIndex
 */
void CRIAPI criAtomExPlayback_SetNextBlockIndex(CriAtomExPlaybackId id, CriAtomExBlockIndex index);

/*JP
 * \brief Đ̃JgubNCfbNX̎擾
 * \ingroup ATOMEXLIB_PLAYBACK
 * \param[in]	id						ĐID
 * \return		CriAtomExBlockIndex		JgubNCfbNX
 * \par :
 * ::criAtomExPlayer_Start ֐ōĐꂽubNV[PX
 * JgubNCfbNX擾܂B<br>
 * \par l:
 * ĐIDɂĐĂf[^ubNV[PXł͂Ȃꍇ́A
 * ::CRIATOMEX_INVALID_BLOCK_INDEX Ԃ܂B<br>
 * \sa criAtomExPlayer_Start, criAtomExPlayer_SetFirstBlockIndex, criAtomExPlayback_SetNextBlockIndex
 */
CriAtomExBlockIndex CRIAPI criAtomExPlayback_GetCurrentBlockIndex(CriAtomExPlaybackId id);

/*JP
 * \brief ĐgbN̎擾
 * \ingroup ATOMEXLIB_PLAYBACK
 * \param[in]	id			ĐID
 * \param[out]	info		ĐgbN
 * \return		CriBool		^s
 * \par :
 * Đ̃L[̃gbN擾܂B<br>
 * 擾łgbN̓L[̏񂾂łBTuV[PXL[N͎̏擾ł܂B<br>
 * \par l:
 * ȉɊYf[^Đ̏ꍇAgbN̎擾Ɏs܂B<br>
 * - L[ȊÕf[^ĐĂBigbN񂪑݂Ȃ߁j<br>
 * - Đ̃L[|tHjbN^CvA܂̓ZN^[QƂ̃XCb`^CvłBigbN񂪕݂\邽߁j<br>
 * - Đ̃L[gbNJڃ^CvłBiJڂɂĐgbNς邽߁j<br>
 */
CriBool CRIAPI criAtomExPlayback_GetPlaybackTrackInfo(CriAtomExPlaybackId id, CriAtomExPlaybackTrackInfo* info);

/*JP
 * \brief r[g̎擾
 * \ingroup ATOMEXLIB_PLAYBACK
 * \param[in]	id			ĐID
 * \param[out]	info		r[g
 * \return		CriBool		^s
 * \par :
 * Đ̃L[̃r[g擾܂B<br>
 * ݂BPMA߂̃JEgÃJEgA̐i(0.0`1.0)擾邱Ƃł܂B<br>
 * L[ɂ̓r[g񂪐ݒ肳ĂKv܂B<br>
 * L[NX^[gANVōĐĂL[͎̏擾ł܂B<br>
 * \par l:
 * ȉɊYf[^Đ̏ꍇAr[g̎擾Ɏs܂B<br>
 * - L[ȊÕf[^ĐĂBir[g񂪑݂Ȃ߁j<br>
 * - r[g񂪐ݒ肳ĂȂL[ĐĂB<br>
 * - r[g񂪐ݒ肳ĂL["ԐړI"ɍĐĂBiL[NX^[gANVōĐĂj<br>
 */
CriBool CRIAPI criAtomExPlayback_GetBeatSyncInfo(CriAtomExPlaybackId id, CriAtomExBeatSyncInfo* info);

/*JP
 * \brief r[gItZbg̐ݒ
 * \ingroup ATOMEXLIB_PLAYBACK
 * \param[in]	id			ĐID
 * \param[in]	time_ms		ItZbg
 * \return		CriBool		^s
 * \par :
 * Đ̃L[̃r[gItZbgݒ肵܂B<br>
 * L[ɂ̓r[g񂪐ݒ肳ĂKv܂B<br>
 * L[NX^[gANVōĐĂL[ւ̐ݒ͂ł܂B<br>
 * \par l:
 * ȉɊYf[^Đ̏ꍇAr[gItZbg̐ݒɎs܂B<br>
 * - L[ȊÕf[^ĐĂBir[g񂪑݂Ȃ߁j<br>
 * - r[g񂪐ݒ肳ĂȂL[ĐĂB<br>
 * - r[g񂪐ݒ肳ĂL["ԐړI"ɍĐĂBiL[NX^[gANVōĐĂj<br>
 */
CriBool CRIAPI criAtomExPlayback_SetBeatSyncOffset(CriAtomExPlaybackId id, CriSint16 time_ms);

/*==========================================================================
 *      CRI AtomEx Fader API
 *=========================================================================*/
/*JP
 * \brief tF[_[̃A^b`ɕKvȃ[N̈TCY̌vZ
 * \ingroup ATOMEXLIB_FADER
 * \param[in]	config		tF[_[A^b`pRtBO\
 * \return		CriSint32	[N̈TCY
 * \retval		0ȏ		ɏ
 * \retval		-1			G[
 * \par :
 * AtomExv[[ɃtF[_[A^b`̂ɕKvȁA[N̈̃TCY擾܂B<br>
 * AP[^[o^ɃtF[_[A^b`ꍇA炩ߖ{֐ŌvZ
 * [N̈TCỸ[N̈Ƃ ::criAtomExPlayer_AttachFader ֐
 * ZbgKv܂B<br>
 * <br>
 * NULLw肵ꍇAftHgݒ
 * i ::criAtomExFader_SetDefaultConfig KpƓp[^[j
 * [N̈TCYvZ܂B<br>
 * <br>
 * [N̈TCYvZɎsꍇA߂l -1 ɂȂ܂B<br>
 * [N̈TCY̌vZɎsRɂẮAG[R[obN
 * bZ[WŊmF\łB<br>
 * \par l:
 *  config ̏́A֐ł̂ݎQƂ܂B<br>
 * ֐𔲂͎QƂ܂̂ŁA֐s config ̗̈Ă
 * 肠܂B
 * \attention
 * {֐sOɁACuĂKv܂B<br>
 * \sa CriAtomExFaderConfig, criAtomExPlayer_AttachFader
 */
CriSint32 CRIAPI criAtomExPlayer_CalculateWorkSizeForFader(
	const CriAtomExFaderConfig *config);

/*JP
 * \brief v[[ɃtF[_[t
 * \ingroup ATOMEXLIB_FADER
 * \param[in]	player		AtomExv[[
 * \param[in]	config		tF[_[A^b`pRtBO\
 * \param[in]	work		[N̈
 * \param[in]	work_size	[N̈TCY
 * \par :
 * v[[ɃtF[_[A^b`itjA
 * AtomExPlayerNXtF[hp̃v[[ɕω܂B<br>
 * i̓ĐA]AtomExPlayer̎@\ꕔpłȂȂ܂Bj<br>
 * <br>
 * {֐ŃtF[_[A^b`v[[́Aȍ~ĐJn
 * i ::criAtomExPlayer_Start ֐ ::criAtomExPlayer_Prepare ֐s閈jɁA
 * ȉ̐s܂B<br>
 * - ɃtF[hAEg̉΋~B
 * - ݍĐi܂̓tF[hCj̉tF[hAEgB
 * - VKɍĐJn鉹tF[hCB
 * 
 * <br>
 * ܂AĐ~i ::criAtomExPlayer_Stop ֐sjɂ́A
 * ȉ̐s܂B<br>
 * - ɃtF[hAEg̉΋~B
 * - ݍĐi܂̓tF[hCj̉tF[hAEgB
 * 
 * <br>
 * v[[ɃtF[_[tۂɂ́A[N̈ƂănKv܂B<br>
 * Kvȃ̃TCÝA ::criAtomExPlayer_CalculateWorkSizeForFader 
 * ֐ŌvZ܂B<br>
 * i::criAtomEx_SetUserAllocator }NgpăAP[^[o^ς݂̏ꍇA
 * {֐Ƀ[N̈w肷Kv͂܂Bj<br>
 * <br>
 * tF[_[̃A^b`ɎsꍇA֐ŃG[R[obN܂B<br>
 * tF[_[̃A^b`ɎsRɂẮAG[R[obÑbZ[WmFĂB<br>
 * \par :
 * 2 ̃L[i MUSIC1  MUSIC2 jNXtF[hꍇ̏́Aȉ̂ƂłB<br>
 * \code
 * 		F
 * 	// AtomExv[[̍쐬
 * 	player = criAtomExPlayer_Create(NULL, NULL, 0);
 * 	
 * 	// v[[ɃtF[_[A^b`
 * 	criAtomExPlayer_AttachFader(player, NULL, NULL, 0);
 * 	
 * 	// tF[hC^AEgԂ̎w
 * 	// ljL̗ł5bŃNXtF[hs悤wB
 * 	criAtomExPlayer_SetFadeInTime(player, 5000);	// tF[hCԂ̎w
 * 	criAtomExPlayer_SetFadeOutTime(player, 5000);	// tF[hAEgԂ̎w
 * 	
 * 	// Đ鉹f[^Zbg
 * 	criAtomExPlayer_SetCueName(player, acb_hn, "MUSIC1");
 * 	
 * 	// Đ̊Jn
 * 	// lj̏ɂAMUSIC15bŃtF[hCȂĐB
 * 	criAtomExPlayer_Start(player);
 * 		F
 * 	iĐ[vj
 * 		F
 * 	// ɍĐ鉹f[^Zbg
 * 	criAtomExPlayer_SetCueName(player, acb_hn, "MUSIC2");
 * 	
 * 	// Đ̊Jn
 * 	// lj̏ɂAMUSIC1tF[hAEgAMUSIC2tF[hCȂĐB
 * 	criAtomExPlayer_Start(player);
 * 		F
 * \endcode
 * \par l:
 * tF[_[A^b`v[[Đ̏ꍇA{֐s^C~O
 * v[[Đ̉͑SĒ~܂B<br>
 * <br>
 * tF[_[́AA^b`̃v[[ɑ΂ ::criAtomExPlayer_Start
 * ֐A ::criAtomExPlayer_Stop ֐sxA
 * Yv[[ōĐ̉ɑ΂Ĉȉ̐s܂B<br>
 * <br>
 * -# ɃtF[hAEg݂̉ꍇẢ𑦍ɒ~B
 * -# tF[hC̉i܂͍Đ̉j݂ꍇA
 * ̉̎_̉ʂ ::criAtomExPlayer_SetFadeOutTime 
 * ֐Ŏw肳ꂽԂătF[hAEgB
 * -# ::criAtomExPlayer_Start ֐sꂽꍇA
 * v[[ɃZbgĂ鉹f[^{[0ōĐJnA
 * ::criAtomExPlayer_SetFadeInTime ֐Ŏw肳ꂽԂătF[hCB
 * 
 * <br>
 * i ::criAtomExPlayer_Start ֐̑ ::criAtomExPlayer_Prepare 
 * ֐gpꍇA|[Y鎞_ŏL̐䂪s܂Bj<br>
 * \attention
 * {֐sƁAAtomExPlayerɑ΂Đ^~삪傫ύX܂B<br>
 * itF[_[A^b`Oŋ傫ς܂Bj<br>
 * ̓Iɂ́Aɔ\ȉ̐1iNXtF[ĥ2jɌ肳A
 * ::CriAtomExPlaybackId psȂȂ܂B<br>
 * <br>
 * {֐́ANXtF[hsꍇɂ̂ݕKvƂȂ܂B<br>
 * 1̃tF[hC^AEgɂẮAGx[vTweenpB<br>
 * <br>
 * {֐Ƀ[N̈ZbgꍇAZbg̈̃tF[_[f^b`
 * ܂ŃAvP[VŕێKv܂B<br>
 * iZbgς݂̃[N̈ɒl񂾂A肵Ă͂܂Bj<br>
 * <br>
 * tF[_[̓dl̓sAtF[hC^AEg̏ΏۂƂȂ̂́A
 * ߋ2̉Đ݂̂łB<br>
 * ȑOɍĐꂽ́A ::criAtomExPlayer_Start ֐
 * ::criAtomExPlayer_Stop ֐sꂽ_ŋIɒ~܂B<br>
 * ~̃^C~OňӐ}ȂmCY鋰ꂪ܂̂ŁA
 * Đ3ȏɂȂȂ悤ӂĂB<br>
 * i ::criAtomExPlayer_GetNumPlaybacks ֐œĐmFĂBj<br>
 * <br>
 * tF[hC^AEg@\̂́wAtomExv[[ɑ΂鑀x݂̂łB<br>
 * ::criAtomExPlayer_Start ֐sɎ擾ĐIDɑ΂A
 * ::criAtomExPlayback_Stop sĂAtF[hAEg͍s܂B<br>
 * itF[_[̐ݒ肪Aɒ~s܂Bj<br>
 * <br>
 *  config ̏́A֐ł̂ݎQƂ܂B<br>
 * ֐𔲂͎QƂ܂̂ŁA֐s config ̗̈Ă
 * 肠܂B
 * \sa CriAtomExFaderConfig, criAtomExPlayer_CalculateWorkSizeForFader
 */
void CRIAPI criAtomExPlayer_AttachFader(CriAtomExPlayerHn player,
	const CriAtomExFaderConfig *config, void *work, CriSint32 work_size);

/*JP
 * \brief v[[tF[_[O
 * \ingroup ATOMEXLIB_FADER
 * \param[in]	player		AtomExv[[
 * \par :
 * v[[tF[_[f^b`iOj܂B<br>
 * {֐ŃtF[_[f^b`v[[ɂ́Aȍ~tF[hC^AEg̏sȂȂ܂B<br>
 * \par l:
 * tF[_[f^b`v[[Đ̏ꍇA{֐s^C~O
 * v[[Đ̉͑SĒ~܂B<br>
 * <br>
 * {֐sɃv[[jꍇAv[[ji ::criAtomExPlayer_Destroy ֐sj
 * ɃCuŃtF[_[̃f^b`s܂B<br>
 * \sa criAtomExPlayer_AttachFader
 */
void CRIAPI criAtomExPlayer_DetachFader(CriAtomExPlayerHn player);

/*JP
 * \brief tF[hAEgԂ̐ݒ
 * \ingroup ATOMEXLIB_FADER
 * \param[in]	player	AtomExv[[nh
 * \param[in]	ms		tF[hAEgԁi~bwj
 * \par :
 * tF[_[A^b`ς݂̃v[[ɑ΂AtF[hAEgԂw肵܂B<br>
 * 񉹐Đi ::criAtomExPlayer_Start ֐sjɂ́A{֐Őݒ肳ꂽ
 * ԂōĐ̉tF[hAEg܂B<br>
 * <br>
 * tF[hAEgԂ̃ftHgl 500 ~błB<br>
 * \par l:
 * tF[hAEgԂݒ肳ĂꍇAAtomExv[[͈ȉ̏ōĐ~܂B<br>
 * <br>
 *	-# w肳ꂽԂŉ̃{[ 0 ܂ŗƂB
 *	-# {[ 0 ̏ԂŃfBCԂo߂܂ōĐ𑱂B
 *	-# fBCԌoߌɍĐ~B
 * 	
 * <br>
 * tF[hAEg̃{[Rg[́AĐ~Oɍs܂B<br>
 * ̂߁Ag`f[^ɂ炩ߐݒ肳ꂽGx[ṽ[XԂ͖܂B<br>
 * iɂ́A{[ 0 ɂȂĂGx[ṽ[XKp܂Bj<br>
 * <br>
 * 2i ms j 0 w肷ꍇƁA ::CRIATOMEX_IGNORE_FADE_OUT
 * w肷ꍇƂł́Aȉ̂悤ɋقȂ܂B<br>
 * <br>
 *	- 0w莞FɃ{[ 0 ɗƂA~sB
 *	- CRIATOMEX_IGNORE_FADE_OUTw莞F{[ύX͍sꂸA~sB
 * 	
 * <br>
 * Đ~ɃtF[hAEgs킸Ag`ɂ炩ߐݒ肳Ă
 * Gx[ṽ[XLɂꍇA2i ms jɁA
 * ::CRIATOMEX_IGNORE_FADE_OUT w肵ĂB<br>
 * ::CRIATOMEX_IGNORE_FADE_OUT w肷邱ƂŁA
 * tF[hAEgɂ{[䂪sȂȂ邽߁A
 * ::criAtomExPlayer_Stop ֐sAfBCԌoߌɒʏ̒~s܂B<br>
 * ig`f[^ɃGx[ṽ[Xݒ肳ĂꍇA[Xs܂Bj<br>
 * \attention
 * {֐sOɁA ::criAtomExPlayer_AttachFader ֐gp
 * 炩߃v[[ɃtF[_[A^b`ĂKv܂B<br>
 * <br>
 * {֐Őݒ肵ĺAɍĐ̉ɂ͈؉e܂B<br>
 * {֐Őݒ肵tF[hԂ́A{֐s ::criAtomExPlayer_Start ֐
 * ::criAtomExPlayer_Stop ֐s^C~OœKp܂B<br>
 * iɃtF[hAEgJnĂ鉹ɑ΂ẮA
 * {֐ŌォtF[hAEgԂύX邱Ƃ͂ł܂Bj<br>
 * \sa criAtomExPlayer_AttachFader, criAtomExPlayer_SetFadeInTime
 */
void CRIAPI criAtomExPlayer_SetFadeOutTime(CriAtomExPlayerHn player, CriSint32 ms);

/*JP
 * \brief tF[hAEgԂ̎擾
 * \ingroup ATOMEXLIB_FADER
 * \param[in]	player	AtomExv[[nh
 * \return	CriSint32	tF[hAEgԁi~bPʁj
 * \par :
 * tF[hAEgԂ擾܂B<br>
 * \par l:
 * {֐ ::criAtomExPlayer_SetFadeOutTime ֐ŃZbglԂ܂B<br>
 * \sa criAtomExPlayer_SetFadeOutTime
 */
CriSint32 CRIAPI criAtomExPlayer_GetFadeOutTime(CriAtomExPlayerHn player);

/*JP
 * \brief tF[hCԂ̐ݒ
 * \ingroup ATOMEXLIB_FADER
 * \param[in]	player	AtomExv[[nh
 * \param[in]	ms		tF[hCԁi~bwj
 * \par :
 * tF[_[A^b`ς݂̃v[[ɑ΂AtF[hCԂw肵܂B<br>
 * 񉹐Đi ::criAtomExPlayer_Start ֐sjɂ́A{֐Őݒ肳ꂽ
 * ԂŐVKɉtF[hCĐ܂B<br>
 * <br>
 * tF[hCԂ̃ftHgl 0 błB<br>
 * ̂߁A{֐gpȂꍇtF[hC͍sꂸAɃt{[
 * ŉ̍ĐJn܂B<br>
 * \attention
 * {֐sOɁA ::criAtomExPlayer_AttachFader ֐gp
 * 炩߃v[[ɃtF[_[A^b`ĂKv܂B<br>
 * <br>
 * {֐Őݒ肵ĺAɍĐ̉ɂ͈؉e܂B<br>
 * {֐Őݒ肵tF[hԂ́A{֐s ::criAtomExPlayer_Start ֐
 * s^C~OœKp܂B<br>
 * iɃtF[hCJnĂ鉹ɑ΂ẮA
 * {֐ŌォtF[hCԂύX邱Ƃ͂ł܂Bj<br>
 * \sa criAtomExPlayer_AttachFader, criAtomExPlayer_SetFadeInTime
 */
void CRIAPI criAtomExPlayer_SetFadeInTime(CriAtomExPlayerHn player, CriSint32 ms);

/*JP
 * \brief tF[hCԂ̎擾
 * \ingroup ATOMEXLIB_FADER
 * \param[in]	player	AtomExv[[nh
 * \return	CriSint32	tF[hCԁi~bPʁj
 * \par :
 * tF[hCԂ擾܂B<br>
 * \par l:
 * {֐ ::criAtomExPlayer_SetFadeInTime ֐ŃZbglԂ܂B<br>
 * \sa criAtomExPlayer_SetFadeInTime
 */
CriSint32 CRIAPI criAtomExPlayer_GetFadeInTime(CriAtomExPlayerHn player);

/*JP
 * \brief tF[hCJnItZbg̐ݒ
 * \ingroup ATOMEXLIB_FADER
 * \param[in]	player	AtomExv[[nh
 * \param[in]	ms		tF[hCJnItZbgi~bwj
 * \par :
 * tF[_[A^b`ς݂̃v[[ɑ΂AtF[hCJnItZbgw肵܂B<br>
 * {֐gp邱ƂŁAtF[hCJn^C~OtF[hAEgɑ΂
 * Cӂ̎ԑ߂Ax点邱Ƃ\łB<br>
 * Ⴆ΁AtF[hAEgԂ5bAtF[hCJnItZbg5bɐݒ肵ꍇA
 * tF[hAEg5bŊɎ̉tF[hC邱Ƃ\łB<br>
 * tɁAtF[hCԂ5bAtF[hCJnItZbg-5bɐݒ肵ꍇA
 * tF[hC5bŊɍĐ̉̃tF[hAEgJn邱Ƃ\łB<br>
 * <br>
 * tF[hCJnItZbg̃ftHgl 0 błB<br>
 * itF[hCƃtF[hAEgɊJn܂Bj<br>
 * \par l:
 * tF[hCJñ^C~ÓAtF[hC鉹̍Đ^C~OłB<br>
 * ̂߁AtF[hCJnItZbg 0 bɐݒ肳ĂꍇłAtF[hC
 * ̃obt@OɎԂꍇiXg[Đjɂ́AtF[hAEg̊Jn܂ł
 * ΂炭Ԃ܂B<br>
 * i{p[^[́AtF[hCƃtF[hAEg̃^C~O𒲐邽߂̑ΒlłBj<br>
 * \attention
 * {֐sOɁA ::criAtomExPlayer_AttachFader ֐gp
 * 炩߃v[[ɃtF[_[A^b`ĂKv܂B<br>
 * <br>
 * {֐Őݒ肵ĺAɍĐ̉ɂ͈؉e܂B<br>
 * {֐Őݒ肵tF[hԂ́A{֐s ::criAtomExPlayer_Start ֐
 * ::criAtomExPlayer_Stop ֐s^C~OœKp܂B<br>
 * iɃtF[hJnĂ鉹ɑ΂ẮA
 * {֐ŌォtF[h̃^C~OύX邱Ƃ͂ł܂Bj<br>
 * \sa criAtomExPlayer_AttachFader, criAtomExPlayer_SetFadeInTime
 */
void CRIAPI criAtomExPlayer_SetFadeInStartOffset(CriAtomExPlayerHn player, CriSint32 ms);

/*JP
 * \brief tF[hCJnItZbg̎擾
 * \ingroup ATOMEXLIB_FADER
 * \param[in]	player	AtomExv[[nh
 * \return	CriSint32	tF[hCJnItZbgi~bPʁj
 * \par :
 * tF[hCJnItZbg擾܂B<br>
 * \par l:
 * {֐ ::criAtomExPlayer_SetFadeInStartOffset ֐ŃZbglԂ܂B<br>
 * \sa criAtomExPlayer_SetFadeInStartOffset
 */
CriSint32 CRIAPI criAtomExPlayer_GetFadeInStartOffset(CriAtomExPlayerHn player);

/*JP
 * \brief tF[hAEg̃fBCԂ̐ݒ
 * \ingroup ATOMEXLIB_FADER
 * \param[in]	player	AtomExv[[nh
 * \param[in]	ms		tF[hCJnItZbgi~bwj
 * \par :
 * tF[hAEgA{CXj܂ł̃fBCԂݒ肵܂B<br>
 * {֐gp邱ƂŁAtF[hAEgI{CXj܂ł̃^C~OCӂɐݒ\łB<br>
 * <br>
 * fBCԂ̃ftHgl 500 ~błB<br>
 * itF[hAEgĐ{CX́A{[ 0 ɐݒ肳ꂽA 500 ~bɔj܂Bj<br>
 * \par l:
 * ̃tF[hAEgOɃ{CX~vbgtH[ȊÓA
 * {֐gpKv͂܂B<br>
 * \attention
 * {֐sOɁA ::criAtomExPlayer_AttachFader ֐gp
 * 炩߃v[[ɃtF[_[A^b`ĂKv܂B<br>
 * <br>
 * {֐Őݒ肵ĺAɍĐ̉ɂ͈؉e܂B<br>
 * {֐Őݒ肵tF[hԂ́A{֐s ::criAtomExPlayer_Start ֐
 * ::criAtomExPlayer_Stop ֐s^C~OœKp܂B<br>
 * iɃtF[hAEgJnĂ鉹ɑ΂ẮA
 * {֐ŌォtF[hAEg̃fBCԂύX邱Ƃ͂ł܂Bj<br>
 * <br>
 * {[̐ƃ{CX̒~f^C~ÓAvbgtH[ɂĈقȂ܂B<br>
 * ̂߁A{֐ 0 w肵ꍇAvbgtH[ɂĂ̓{[̕ύXf
 * OɃ{CX~鋰ꂪ܂B<br>
 * \sa criAtomExPlayer_AttachFader, criAtomExPlayer_SetFadeInTime
 */
void CRIAPI criAtomExPlayer_SetFadeOutEndDelay(CriAtomExPlayerHn player, CriSint32 ms);

/*JP
 * \brief tF[hAEg̃fBCԂ̎擾
 * \ingroup ATOMEXLIB_FADER
 * \param[in]	player	AtomExv[[nh
 * \return	CriSint32	tF[hAEg̃fBCԁi~bPʁj
 * \par :
 * tF[hAEg̃fBCԂ擾܂B<br>
 * \par l:
 * {֐ ::criAtomExPlayer_SetFadeOutEndDelay ֐ŃZbglԂ܂B<br>
 * \sa criAtomExPlayer_SetFadeOutEndDelay
 */
CriSint32 CRIAPI criAtomExPlayer_GetFadeOutEndDelay(CriAtomExPlayerHn player);

/*JP
 * \brief tF[hǂ̃`FbN
 * \ingroup ATOMEXLIB_FADER
 * \param[in]	player	AtomExv[[nh
 * \return	CriBool		tF[hǂiCRI_TRUE = tF[hACRI_FALSE = tF[hł͂Ȃj
 * \par :
 * tF[hsĂŒǂ`FbN܂B<br>
 * \par l:
 * {֐́Aȉ̏Ԓ CRI_TRUE Ԃ܂B<br>
 * - NXtF[hJn̂߂̓҂B
 * - tF[hC^tF[hAEgi{[ύXjB
 * - tF[hAEg̃fBCԒB
 * 
 */
CriBool CRIAPI criAtomExPlayer_IsFading(CriAtomExPlayerHn player);

/*JP
 * \brief tF[_[p[^[̏
 * \ingroup ATOMEXLIB_FADER
 * \param[in]	player	AtomExv[[nh
 * \par :
 * tF[_[ɐݒ肳Ăep[^[NAAlɖ߂܂B<br>
 * \attention
 * {֐sOɁA ::criAtomExPlayer_AttachFader ֐gp
 * 炩߃v[[ɃtF[_[A^b`ĂKv܂B<br>
 * <br>
 * {֐ŃtF[_[p[^[NAĂAɍĐ̉ɂ͈؉e܂B<br>
 * {֐ŃNAtF[_[p[^[́A{֐s ::criAtomExPlayer_Start ֐
 * ::criAtomExPlayer_Stop ֐s^C~OœKp܂B<br>
 * iɃtF[hJnĂ鉹ɑ΂ẮA
 * {֐ŃNAtF[_[p[^[Kp邱Ƃ͂ł܂Bj<br>
 * \sa criAtomExPlayer_AttachFader, criAtomExPlayer_SetFadeInTime
 */
void CRIAPI criAtomExPlayer_ResetFaderParameters(CriAtomExPlayerHn player);


/*==========================================================================
 *      CRI AtomEx Sequencer API
 *=========================================================================*/
/*JP
 * \brief V[PXR[obN֐̓o^
 * \ingroup ATOMEXLIB_SEQUENCER
 * \param[in]	func		V[PXR[obN֐
 * \param[in]	obj			[UwIuWFNg
 * \par :
 * V[PXf[^ɖߍ܂ꂽR[obN󂯎R[obN֐o^܂B<br>
 * o^ꂽR[obN֐́AT[o[֐ŃR[obNCxg^C~OŎs܂B<br>
 * \attention
 * ̂߁AT[o[ւ̊荞݂lȂAPIsꍇA
 * G[AfbhbN\܂B<br>
 * {IɁAR[obN֐łAtomCuAPIgpȂłB<br>
 * {R[obN֐ŒԏubNƁA؂ꓙ̖肪܂̂ŁA
 * ӂB<br>
 * <br>
 * R[obN֐1o^ł܂B<br>
 * o^𕡐sꍇAɓo^ς݂̃R[obN֐A
 * ォo^R[obN֐ɂ㏑Ă܂܂B<br>
 * <br>
 * funcNULLw肷邱Ƃœo^ς݊֐̓o^s܂B<br>
 * \sa CriAtomExSequencerEventCbFunc
 */
void CRIAPI criAtomExSequencer_SetEventCallback(CriAtomExSequencerEventCbFunc func, void* obj);

/*==========================================================================
 *      CRI AtomEx Beat Sync API
 *=========================================================================*/
/*JP
 * \brief r[gʒuoR[obN֐̓o^
 * \ingroup ATOMEXLIB_BEATSYNC
 * \param[in]	func		r[gʒuoR[obN֐
 * \param[in]	obj			[UwIuWFNg
 * \par :
 * r[gʒuo󂯎R[obN֐o^܂B<br>
 * o^ꂽR[obN֐́AT[o[֐Ńr[gʒuo^C~OŎs܂B<br>
 * \attention
 * ̂߁AT[o[ւ̊荞݂lȂAPIsꍇA
 * G[AfbhbN\܂B<br>
 * {IɁAR[obN֐łAtomCuAPIgpȂłB<br>
 * {R[obN֐ŒԏubNƁA؂ꓙ̖肪܂̂ŁA
 * ӂB<br>
 * <br>
 * R[obN֐1o^ł܂B<br>
 * o^𕡐sꍇAɓo^ς݂̃R[obN֐A
 * ォo^R[obN֐ɂ㏑Ă܂܂B<br>
 * <br>
 * funcNULLw肷邱Ƃœo^ς݊֐̓o^s܂B<br>
 * \sa CriAtomExBeatSyncCbFunc
 */
void CRIAPI criAtomExBeatSync_SetCallback(CriAtomExBeatSyncCbFunc func, void* obj);

/*==========================================================================
 *      CRI AtomEx 3D API
 *=========================================================================*/
/*JP
 * \brief 3Dnh̍쐬ɕKvȃ[N̈TCY̌vZ
 * \ingroup ATOMEXLIB_3D
 * \param[in]	config		3Dnh쐬pRtBO\̂ւ̃|C^
 * \return		CriSint32	3Dnh쐬p[NTCY
 * \retval		0ȏ		ɏ
 * \retval		-1			G[
 * \par :
 * 3Dnh쐬邽߂ɕKvȁA[N̈̃TCY擾܂B<br>
 * AP[^[o^3Dnh쐬ꍇA
 * 炩ߖ{֐ŌvZ[N̈TCỸ
 * [N̈Ƃ ::criAtomEx3dSource_Create ֐ɃZbgKv܂B<br>
 * <br>
 * 3Dnh̍쐬ɕKvȃ[ÑTCÝA3Dnh쐬pRtBO
 * \́i ::CriAtomEx3dSourceConfig j̓eɂĕω܂B<br>
 * <br>
 * NULLw肵ꍇAftHgݒ
 * i ::criAtomEx3dSource_SetDefaultConfig KpƓp[^[j
 * [N̈TCYvZ܂B
 * <br>
 * [N̈TCYvZɎsꍇA߂l -1 ɂȂ܂B<br>
 * [N̈TCY̌vZɎsRɂẮAG[R[obN
 * bZ[WŊmF\łB<br>
 * \par l:
 *  config ̏́A֐ł̂ݎQƂ܂B<br>
 * ֐𔲂͎QƂ܂̂ŁA֐s config ̗̈Ă
 * 肠܂B

 * \sa criAtomEx3dSource_Create, CriAtomEx3dSourceConfig
 */
CriSint32 CRIAPI criAtomEx3dSource_CalculateWorkSize(const CriAtomEx3dSourceConfig *config);

/*JP
 * \brief 3Dnh̍쐬
 * \ingroup ATOMEXLIB_3D
 * \param[in]	config				3Dnh쐬pRtBO\̂ւ̃|C^
 * \param[in]	work				3Dnh쐬p[N̈ւ̃|C^
 * \param[in]	work_size			3Dnh쐬p[NTCY
 * \return		CriAtomEx3dSourceHn	3Dnh
 * \par :
 * 3Dnh쐬pRtBOɊÂāA3Dnh쐬܂B<br>
 * 쐬ɐƁA3DnhԂ܂B<br>
 * 3Dnh쐬ۂɂ́A[N̈ƂănKv܂B<br>
 * Kvȃ̃TCÝA ::criAtomEx3dSource_CalculateWorkSize 
 * ֐ŌvZ܂B<br>
 * i::criAtomEx_SetUserAllocator }NgpăAP[^[o^ς݂̏ꍇA
 * {֐Ƀ[N̈w肷Kv͂܂Bj<br>
 * \attention
 * {֐sOɁACuĂKv܂B<br>
 * <br>
 * \sa criAtomEx3dSource_CalculateWorkSize, criAtomEx3dSource_Destroy
 */
CriAtomEx3dSourceHn CRIAPI criAtomEx3dSource_Create(
	const CriAtomEx3dSourceConfig *config, void *work, CriSint32 work_size);

/*JP
 * \brief 3Dnh̔j
 * \ingroup ATOMEXLIB_3D
 * \param[in]	ex_3d_source		3Dnh
 * \par :
 * 3Dnhj܂B<br>
 * {֐s_ŁA3Dnh쐬Ɋmۂꂽ\[XSĉ܂B<br>
 * ܂AɎw肵3DnhɂȂ܂B<br>
 * 3DnhZbgAtomExv[[ōĐĂ鉹ꍇA
 * {֐sOɁẢ~邩AAtomExv[[jĂB
 * \sa criAtomEx3dSource_Create
 */
void CRIAPI criAtomEx3dSource_Destroy(CriAtomEx3dSourceHn ex_3d_source);

/*JP
 * \brief 3D̍XV
 * \ingroup ATOMEXLIB_3D
 * \param[in]	ex_3d_source		3Dnh
 * \par :
 * 3Dɐݒ肳Ăp[^[gpāA3DXV܂B<br>
 * {֐ł́A3Dɐݒ肳ĂSẴp[^[XV܂B
 * p[^[ЂƂύXxɖ{֐ɂčXVsA
 * ̃p[^[ύXĂXVsIłB
 * \par :
 * \code
 * CriAtomExVector pos;
 * CriAtomExVector vel;
 * 
 * // Set position
 * pos.x = 0.0f
 * pos.y = 0.0f
 * pos.z = 1.0f
 * criAtomEx3dSource_SetPosition(source, &pos);
 * // Set velocity
 * vel.x = 1.0f
 * vel.y = 0.0f
 * vel.z = 0.0f
 * criAtomEx3dSource_SetVelocity(source, &vel);
 * 
 * // Update source parameters
 * criAtomEx3dSource_Update(source);
 * \endcode
 * \attention
 * {֐AtomExv[[̃p[^[XVi::criAtomExPlayer_UpdateAll, criAtomExPlayer_Updatej
 * Ƃ͓Ɨē삵܂B3D̃p[^[ύXۂ́A{֐ɂčXVsĂB
 */
void CRIAPI criAtomEx3dSource_Update(CriAtomEx3dSourceHn ex_3d_source);

/*JP
 * \brief 3Dp[^[̏
 * \ingroup ATOMEXLIB_3D
 * \param[in]	ex_3d_source		3Dnh
 * \par :
 * 3Dɐݒ肳Ăp[^[NAAlɖ߂܂B<br>
 * \attention
 * NAp[^[ۂɓKpɂ́A::criAtomEx3dSource_Update ֐ĂяoKv܂B
 * \sa criAtomEx3dSource_Update
 */
void CRIAPI criAtomEx3dSource_ResetParameters(CriAtomEx3dSourceHn ex_3d_source);

/*JP
 * \brief 3D̈ʒu̐ݒ
 * \ingroup ATOMEXLIB_3D
 * \param[in]	ex_3d_source		3Dnh
 * \param[in]	position			ʒuxNg
 * \par :
 * 3D̈ʒuݒ肵܂B<br>
 * ʒúAAђʌvZɎgp܂B<br>
 * ʒúA3xNgŎw肵܂B<br>
 * ftHgl(0.0f, 0.0f, 0.0f)łB<br>
 * f[^ɂ͈ʒu͐ݒłȂ߁Aɖ{֐ł̐ݒlgp܂B<br>
 * \attention
 * ݒ肵p[^[ۂɓKpɂ́A::criAtomEx3dSource_Update ֐ĂяoKv܂B
 * \sa criAtomEx3dSource_Update
 */
void CRIAPI criAtomEx3dSource_SetPosition(CriAtomEx3dSourceHn ex_3d_source, const CriAtomExVector *position);

/*JP
 * \brief 3D̈ʒu̎擾
 * \ingroup ATOMEXLIB_3D
 * \param[in]	ex_3d_source		3Dnh
 * \par :
 * 3D̈ʒu擾܂B<br>
 * ʒúA3xNgŎ擾܂B<br>
 */
CriAtomExVector CRIAPI criAtomEx3dSource_GetPosition(CriAtomEx3dSourceHn ex_3d_source);

/*JP
 * \brief 3D̑x̐ݒ
 * \ingroup ATOMEXLIB_3D
 * \param[in]	ex_3d_source		3Dnh
 * \param[in]	velocity			xxNg
 * \par :
 * 3D̑xݒ肵܂B<br>
 * x́Ahbv[ʂ̌vZɎgp܂B<br>
 * x́A3xNgŎw肵܂Bx̒Pʂ́A1b̈ړłB
 * ftHgl(0.0f, 0.0f, 0.0f)łB<br>
 * f[^ɂ͑x͐ݒłȂ߁Aɖ{֐ł̐ݒlgp܂B<br>
 * \attention
 * ݒ肵p[^[ۂɓKpɂ́A::criAtomEx3dSource_Update ֐ĂяoKv܂B
 * \sa criAtomEx3dSource_Update
 */
void CRIAPI criAtomEx3dSource_SetVelocity(CriAtomEx3dSourceHn ex_3d_source, const CriAtomExVector *velocity);

/*JP
 * \brief 3Ď̐ݒ
 * \ingroup ATOMEXLIB_3D
 * \param[in]	ex_3d_source		3Dnh
 * \param[in]	front				OxNg
 * \param[in]	top					xNg			
 * \par :
 * 3Ďݒ肵܂B<br>
 * {֐Őݒ肵́ATEhR[̌ƂĐݒ肳܂B<br>
 * TEhR[́A特\A̎w̕\Ɏgp܂B<br>
 * TEhR[̌́A3xNgŎw肵܂Bݒ肳ꂽxNǵACuŐKĎgp܂B<br>
 * f[^ɂ̓TEhR[̌͐ݒłȂ߁Aɖ{֐ł̐ݒlgp܂B<br>
 * ftHgl͈ȉ̂ƂłB<br>
 * 	- OxNgF(0.0f, 0.0f, 1.0f)
 * 	- xNgF(0.0f, 1.0f, 0.0f)
 * 	
 * \par l:
 * TEhR[̌ݒ肵ꍇAxNg͖AOxNĝ݂gp܂B<br>
 * ܂AAmbisonicsĐgpĂꍇA{֐Ŏw肵уXi[̌ɏ]Ambisonics]܂B
 * \attention
 * ݒ肵p[^[ۂɓKpɂ́A::criAtomEx3dSource_Update ֐ĂяoKv܂B<br>
 * ܂AAmbiosnicsɑ΂ăTEhR[Kp邱Ƃ͏o܂B
 * \sa criAtomEx3dSource_SetConeParameter, criAtomEx3dSource_Update
 */
void CRIAPI criAtomEx3dSource_SetOrientation(CriAtomEx3dSourceHn ex_3d_source, const CriAtomExVector *front, const CriAtomExVector *top);

/*JP
 * \brief 3D̃TEhR[p[^[̐ݒ
 * \ingroup ATOMEXLIB_3D
 * \param[in]	ex_3d_source		3Dnh
 * \param[in]	inside_angle		TEhR[̃CTChAO
 * \param[in]	outside_angle		TEhR[̃AEgTChAO
 * \param[in]	outside_volume		TEhR[̃AEgTCh{[
 * \par :
 * 3D̃TEhR[p[^[ݒ肵܂B<br>
 * TEhR[́A特\A̎w̕\Ɏgp܂B<br>
 * TEhR[́AR[AOR[ō\܂BCTChAO͓R[̊pxA
 * AEgTChAO͊OR[̊pxAAEgTCh{[͊OR[̊pxȏ̕ł̉ʂꂼ\܂B<br>
 * R[̊px菬px̕ł́AR[ɂ錸󂯂܂B
 * R[ƊOR[̊Ԃ̕ł́AXɃAEgTCh{[܂Ō܂B<br>
 * CTChAOуAEgTChAÓA0.0f`360.0fxŎw肵܂B<br>
 * AEgTCh{[́A0.0f`1.0fUɑ΂{Ŏw肵܂iPʂ̓fVxł͂܂jB<br>
 * CũftHgl͈ȉ̂ƂłAR[ɂ錸͍s܂B<br>
 * 	- CTChAOF360.0f
 * 	- AEgTChAOF360.0f
 * 	- AEgTCh{[F0.0f
 * 	
 * ftHgĺA::criAtomEx3dSource_ChangeDefaultConeParameter ֐ɂĕύX\łB<br>
 * f[^ɓYp[^[ݒ肳Ăꍇɖ{֐ĂяoƁAȉ̂悤ɓKp܂B
 * 	- CTChAOFZ
 * 	- AEgTChAOFZ
 * 	- AEgTCh{[FZ
 * 	
 * \attention
 * ݒ肵p[^[ۂɓKpɂ́A::criAtomEx3dSource_Update ֐ĂяoKv܂B
 * \sa criAtomEx3dSource_Update, criAtomEx3dSource_ChangeDefaultConeParameter
 */
void CRIAPI criAtomEx3dSource_SetConeParameter(CriAtomEx3dSourceHn ex_3d_source,
	CriFloat32 inside_angle,
	CriFloat32 outside_angle,
	CriFloat32 outside_volume
);

/*JP
 * \brief 3D̃TEhR[p[^[̃ftHglύX
 * \ingroup ATOMEXLIB_3D
 * \param[in]	inside_angle		TEhR[̃CTChAO
 * \param[in]	outside_angle		TEhR[̃AEgTChAO
 * \param[in]	outside_volume		TEhR[̃AEgTCh{[
 * \par :
 * 3D̃TEhR[p[^[̃ftHglύX܂B<br>
 * {֐ɂăftHglύXƁAȍ~ɍ쐬3Dnhi ::CriAtomEx3dSourceHn j
 * TEhR[p[^[̏l{֐Őݒ肵lƂȂ܂B<br>
 * CũftHglɂẮA ::criAtomEx3dSource_SetConeParameter ֐QƂĉB<br>
 * \attention
 * Yp[^[Ɋւāuc[ŒlύXĂȂiftHgԁjvf[^̏ꍇAÖٓIɃftHglKp܂B<br>
 * ̂߁A{֐ŃftHglύXƁAc[ł̕ҏWɈӐ}Ăp[^[ƈقȂĂ܂\܂B<br>
 * AACQ[vr[pɃrhꂽf[^͖{֐̉e󂯂܂B
 * \sa criAtomEx3dSource_SetConeParameter
 */
void CRIAPI criAtomEx3dSource_ChangeDefaultConeParameter(
	CriFloat32 inside_angle,
	CriFloat32 outside_angle,
	CriFloat32 outside_volume
);

/*JP
 * \brief 3D̍ŏ^ő勗̐ݒ
 * \ingroup ATOMEXLIB_3D
 * \param[in]	ex_3d_source		3Dnh
 * \param[in]	min_attenuation_distance		ŏ
 * \param[in]	max_attenuation_distance		ő勗
 * \par :
 * 3D̍ŏ^ő勗ݒ肵܂B<br>
 * ŏ́Aȏ㉹ʂ傫ȂȂ\܂Bő勗́AŏʂɂȂ鋗\܂B<br>
 * CũftHgl͈ȉ̂ƂłB<br>
 * 	- ŏF0.0f
 * 	- ő勗F0.0f
 * 	
 * ftHgĺA::criAtomEx3dSource_ChangeDefaultMinMaxAttenuationDistance ֐ɂĕύX\łB<br>
 * f[^ɓYp[^[ݒ肳Ăꍇɖ{֐ĂяoƁAf[^̒l㏑ijēKp܂B
 * \attention
 * ݒ肵p[^[ۂɓKpɂ́A::criAtomEx3dSource_Update ֐ĂяoKv܂B
 * \sa criAtomEx3dSource_Update, criAtomEx3dSource_ChangeDefaultMinMaxAttenuationDistance
 */
void CRIAPI criAtomEx3dSource_SetMinMaxAttenuationDistance(CriAtomEx3dSourceHn ex_3d_source,
	CriFloat32 min_attenuation_distance,
	CriFloat32 max_attenuation_distance
);

/*JP
 * \brief 3D̍ŏ^ő勗̃ftHglύX
 * \ingroup ATOMEXLIB_3D
 * \param[in]	min_attenuation_distance		ŏ
 * \param[in]	max_attenuation_distance		ő勗
 * \par :
 * 3D̍ŏ^ő勗̃ftHglύX܂B<br>
 * {֐ɂăftHglύXƁAȍ~ɍ쐬3Dnhi ::CriAtomEx3dSourceHn j
 * ŏ^ő勗̏l{֐Őݒ肵lƂȂ܂B<br>
 * CũftHglɂẮA ::criAtomEx3dSource_SetMinMaxAttenuationDistance ֐QƂĉB<br
 * \attention
 * Yp[^[Ɋւāuc[ŒlύXĂȂiftHgԁjvf[^̏ꍇAÖٓIɃftHglKp܂B<br>
 * ̂߁A{֐ŃftHglύXƁAc[ł̕ҏWɈӐ}Ăp[^[ƈقȂĂ܂\܂B<br>
 * AAȉɊYf[^͖{֐̉e󂯂܂B<br>
 * 	- c[̃vpeBɂāAŏ^ő勗̏lݒ0.0ȊOɐݒ肵Ă
 * 	- CQ[vr[pɃrhĂ
 * 	
 * \sa criAtomEx3dSource_SetMinMaxAttenuationDistance
 */
void CRIAPI criAtomEx3dSource_ChangeDefaultMinMaxAttenuationDistance(
	CriFloat32 min_attenuation_distance,
	CriFloat32 max_attenuation_distance
);

/*JP
 * \brief 3D̃CeApjOE̐ݒ
 * \ingroup ATOMEXLIB_3D
 * \param[in]	ex_3d_source		3Dnh
 * \param[in]	source_radius		3D̔a
 * \param[in]	interior_distance	CeA
 * \par :
 * 3D̃CeApjOE̐ݒ܂B<br>
 * 3D̔áA3DƂƂ̔ałB<br>
 * CeÁACeApjOKp3D̔a̋łB<br>
 * 3D̔ał́ACeApjOKp܂ACeA0.0ƈ邽߁A
 * SẴXs[J[瓯ʂŉĐ܂B<br>
 * CeAł́ACeApjOKp܂B<br>
 * CeAOł́ACeApjOKpꂸAʒuɍł߂1A
 * ܂2̃Xs[J[特Đ܂B<br>
 * CũftHgl͈ȉ̂ƂłB<br>
 * 	- 3D̔aF0.0f
 * 	- CeAF0.0fi3D̍ŏɈˑj
 * 	
 * ftHgĺA ::criAtomEx3dSource_ChangeDefaultInteriorPanField ֐ɂĕύX\łB<br>
 * ܂A݃c[ɂēYp[^[ݒłȂ߁Aɖ{֐ł̐ݒlgp܂B
 * \attention
 * ݒ肵p[^[ۂɓKpɂ́A::criAtomEx3dSource_Update ֐ĂяoKv܂B
 * \sa criAtomEx3dSource_Update, criAtomEx3dSource_ChangeDefaultInteriorPanField
 */
void CRIAPI criAtomEx3dSource_SetInteriorPanField(CriAtomEx3dSourceHn ex_3d_source, CriFloat32 source_radius, CriFloat32 interior_distance);

/*JP
 * \brief 3D̃CeApjOẼftHglύX
 * \ingroup ATOMEXLIB_3D
 * \param[in]	source_radius		3D̔a
 * \param[in]	interior_distance	CeA
 * \par :
 * 3D̃CeApjOẼftHglύX܂B<br>
 * {֐ɂăftHglύXƁAȍ~ɍ쐬3Dnhi ::CriAtomEx3dSourceHn j
 * CeApjOȄl{֐Őݒ肵lƂȂ܂B<br>
 * CũftHglɂẮA ::criAtomEx3dSource_SetInteriorPanField ֐QƂĉB<br>
 * \sa criAtomEx3dSource_SetInteriorPanField
 */
void CRIAPI criAtomEx3dSource_ChangeDefaultInteriorPanField(CriFloat32 source_radius, CriFloat32 interior_distance);

/*JP
 * \brief 3D̃hbv[W̐ݒ
 * \ingroup ATOMEXLIB_3D
 * \param[in]	ex_3d_source		3Dnh
 * \param[in]	doppler_factor		hbv[W
 * \par :
 * 3D̃hbv[Wݒ肵܂B<br>
 * hbv[ẂA340m/sƂČvZꂽhbv[ʂɑ΂āA֒\邽߂̔{w肵܂B<br>
 * Ⴆ΁A2.0fw肷ƁA340m/sƂČvZsb`2{ēKp܂B<br>
 * 0.0fw肷ƁAhbv[ʂ͖ɂȂ܂B
 * CũftHgl0.0fłB<br>
 * ftHgĺA::criAtomEx3dSource_ChangeDefaultDopplerFactor ֐ɂĕύX\łB<br>
 * f[^ɓYp[^[ݒ肳Ăꍇɖ{֐ĂяoƁAf[^̒l㏑ijēKp܂B
 * \attention
 * ݒ肵p[^[ۂɓKpɂ́A::criAtomEx3dSource_Update ֐ĂяoKv܂B
 * \sa criAtomEx3dSource_Update, criAtomEx3dSource_ChangeDefaultDopplerFactor
 */
void CRIAPI criAtomEx3dSource_SetDopplerFactor(CriAtomEx3dSourceHn ex_3d_source, CriFloat32 doppler_factor);

/*JP
 * \brief 3D̃hbv[W̃ftHglύX
 * \ingroup ATOMEXLIB_3D
 * \param[in]	doppler_factor		hbv[W
 * \par :
 * 3D̃hbv[W̃ftHglύX܂B<br>
 * {֐ɂăftHglύXƁAȍ~ɍ쐬3Dnhi ::CriAtomEx3dSourceHn j
 * hbv[W̏l{֐Őݒ肵lƂȂ܂B<br>
 * CũftHglɂẮA ::criAtomEx3dSource_SetDopplerFactor ֐QƂĉB<br>
 * \attention
 * Yp[^[Ɋւāuc[ŒlύXĂȂiftHgԁjvf[^̏ꍇAÖٓIɃftHglKp܂B<br>
 * ̂߁A{֐ŃftHglύXƁAc[ł̕ҏWɈӐ}Ăp[^[ƈقȂĂ܂\܂B<br>
 * AACQ[vr[pɃrhꂽf[^͖{֐̉e󂯂܂B
 * \sa criAtomEx3dSource_SetDopplerFactor
 */
void CRIAPI criAtomEx3dSource_ChangeDefaultDopplerFactor(CriFloat32 doppler_factor);

/*JP
 * \brief 3D̃{[̐ݒ
 * \ingroup ATOMEXLIB_3D
 * \param[in]	ex_3d_source		3Dnh
 * \param[in]	volume				{[
 * \par :
 * 3D̃{[ݒ肵܂B<br>
 * 3D̃{[́AʂɊւ鉹ʁiL,R,SL,SRjɂ̂݉eALFEZ^[ւ̏o̓xɂ͉e܂B<br>
 * {[lɂ́A0.0f`1.0f͈̔͂Ŏlw肵܂B<br>
 * {[l͉f[^̐Uɑ΂{łiPʂ̓fVxł͂܂jB<br>
 * Ⴆ΁A1.0fw肵ꍇA͂̂܂܂̃{[ŏo͂܂B<br>
 * 0.5fw肵ꍇAg`̐U𔼕ɂf[^Ɠʁi-6dBj
 * o͂܂B<br>
 * 0.0fw肵ꍇA̓~[g܂iɂȂ܂jB<br>
 * CũftHgl1.0fłB<br>
 * ftHgĺA::criAtomEx3dSource_ChangeDefaultVolume ֐ɂĕύX\łB<br>
 * f[^ɓYp[^[ݒ肳Ăꍇɖ{֐ĂяoƁAf[^̒lƏZēKp܂B
 * \attention
 * ݒ肵p[^[ۂɓKpɂ́A::criAtomEx3dSource_Update ֐ĂяoKv܂B
 * \sa criAtomEx3dSource_Update, criAtomEx3dSource_ChangeDefaultVolume
 */
void CRIAPI criAtomEx3dSource_SetVolume(CriAtomEx3dSourceHn ex_3d_source, CriFloat32 volume);

/*JP
 * \brief 3D̃{[̃ftHglύX
 * \ingroup ATOMEXLIB_3D
 * \param[in]	volume				{[
 * \par :
 * 3D̃{[̃ftHglύX܂B<br>
 * {֐ɂăftHglύXƁAȍ~ɍ쐬3Dnhi ::CriAtomEx3dSourceHn j
 * {[̏l{֐Őݒ肵lƂȂ܂B<br>
 * CũftHglɂẮA ::criAtomEx3dSource_SetVolume ֐QƂĉB<br>
 * \attention
 * Yp[^[Ɋւāuc[ŒlύXĂȂiftHgԁjvf[^̏ꍇAÖٓIɃftHglKp܂B<br>
 * ̂߁A{֐ŃftHglύXƁAc[ł̕ҏWɈӐ}Ăp[^[ƈقȂĂ܂\܂B<br>
 * AACQ[vr[pɃrhꂽf[^͖{֐̉e󂯂܂B
 * \sa criAtomEx3dSource_SetVolume
 */
void CRIAPI criAtomEx3dSource_ChangeDefaultVolume(CriFloat32 volume);

/*JP
 * \brief pxAISACRg[l̍őωʂ̐ݒ
 * \ingroup ATOMEXLIB_3D
 * \param[in]	ex_3d_source		3Dnh
 * \param[in]	max_delta			pxAISACRg[l̍őω
 * \par :
 * pxAISACɂAISACRg[lύXۂ́Aőωʂݒ肵܂B<br>
 * őωʂ߂ɕύXƁAƃXi[Ԃ̑Ίpx}ɕςꍇłA
 * pxAISACɂAISACRg[l̕ωX[Yɂ邱Ƃł܂B<br>
 * Ⴆ΁A(0.5f / 30.0f)ݒ肷ƁApx0x180xɕωꍇɁA30t[ĕω悤ȕωʂƂȂ܂B<br>
 * ftHgl1.0fiȂjłB
 * f[^ł͖{p[^[͐ݒłȂ߁Aɖ{֐ł̐ݒlgp܂B<br>
 * \attention
 * ݒ肵p[^[ۂɓKpɂ́A::criAtomEx3dSource_Update ֐ĂяoKv܂B<br>
 * {֐Őݒ肵Ăőωʂ́AʊpxɌvZĂApxAISACRg[l̕ωɂ̂ݓKp܂B
 * ʊpx̂ɂ͉e͂܂B
 * \sa criAtomEx3dSource_Update
 */
void CRIAPI criAtomEx3dSource_SetMaxAngleAisacDelta(CriAtomEx3dSourceHn ex_3d_source, CriFloat32 max_delta);

/*JP
 * \brief AISACRg[ID̐ݒ
 * \ingroup ATOMEXLIB_3D
 * \param[in]	ex_3d_source		3Dnh
 * \param[in]	aisac_control_id	AISACRg[ID
 * \par :
 * ŏAő勗Ԃ̋ɘAAISACRg[IDw肵܂B<br>
 * {֐AISACRg[IDݒ肵ꍇAftHg͖̋ɂȂ܂B<br>
 * f[^ɐݒ肳Ă鋗AISACRg[ID́A{֐ɂď㏑Kp܂B<br>
 * \attention
 * ݒ肵p[^[ۂɓKpɂ́A::criAtomEx3dSource_Update ֐ĂяoKv܂B<br>
 * {֐Ŏw肵 AISAC Rg[ ID ɑ΂Rg[ĺA
 * ȉ֐̂ꂩgpăv[[ɐݒ肵Rg[lAD悵ēKp܂B<br>
 * - ::criAtomExPlayer_SetAisacControlById ֐<br>
 * - ::criAtomExPlayer_SetAisacControlByName ֐<br>
 * Đ 3D ɑ΂ AISAC Rg[ ID ̕ύXsꍇA
 * ύXÕRg[ ID ɑ΂ŏIRg[lKpꑱ܂B<br>
 * ̂߁AύXO^ύX̂Q̃p[^[KpAӐ}o͂܂B<br>
 * w肷3DɕRÂĐĂȂԂŖ{֐s邱Ƃ𐄏܂B<br>
 * \sa criAtomEx3dSource_Update
 */
void CRIAPI criAtomEx3dSource_SetDistanceAisacControlId(CriAtomEx3dSourceHn ex_3d_source, CriAtomExAisacControlId aisac_control_id);

/*JP
 * \brief Xi[ʊpAISACRg[ID̐ݒ
 * \ingroup ATOMEXLIB_3D
 * \param[in]	ex_3d_source		3Dnh
 * \param[in]	aisac_control_id	Xi[ʊpAISACRg[ID
 * \par :
 * Xi[猩̕ʊpɘAAISACRg[IDw肵܂B<br>
 * f[^ɐݒ肳Ă郊Xi[ʊpAISACRg[ID́A{֐ɂď㏑Kp܂B<br>
 * \attention
 * ݒ肵p[^[ۂɓKpɂ́A::criAtomEx3dSource_Update ֐ĂяoKv܂B<br>
 * {֐Ŏw肵 AISAC Rg[ ID ɑ΂Rg[ĺA
 * ȉ֐̂ꂩgpăv[[ɐݒ肵Rg[lAD悵ēKp܂B<br>
 * - ::criAtomExPlayer_SetAisacControlById ֐<br>
 * - ::criAtomExPlayer_SetAisacControlByName ֐<br>
 * Đ 3D ɑ΂ AISAC Rg[ ID ̕ύXsꍇA
 * ύXÕRg[ ID ɑ΂ŏIRg[lKpꑱ܂B<br>
 * ̂߁AύXO^ύX̂Q̃p[^[KpAӐ}o͂܂B<br>
 * w肷3DɕRÂĐĂȂԂŖ{֐s邱Ƃ𐄏܂B<br>
 * \sa criAtomEx3dSource_Update
 */
void CRIAPI criAtomEx3dSource_SetListenerBasedAzimuthAngleAisacControlId(CriAtomEx3dSourceHn ex_3d_source, CriAtomExAisacControlId aisac_control_id);

/*JP
 * \brief Xi[pAISACRg[ID̐ݒ
 * \ingroup ATOMEXLIB_3D
 * \param[in]	ex_3d_source		3Dnh
 * \param[in]	aisac_control_id	Xi[pAISACRg[ID
 * \par :
 * Xi[猩̋pɘAAISACRg[IDw肵܂B<br>
 * f[^ɐݒ肳Ă郊Xi[pAISACRg[ID́A{֐ɂď㏑Kp܂B<br>
 * \attention
 * ݒ肵p[^[ۂɓKpɂ́A::criAtomEx3dSource_Update ֐ĂяoKv܂B<br>
 * {֐Ŏw肵 AISAC Rg[ ID ɑ΂Rg[ĺA
 * ȉ֐̂ꂩgpăv[[ɐݒ肵Rg[lAD悵ēKp܂B<br>
 * - ::criAtomExPlayer_SetAisacControlById ֐<br>
 * - ::criAtomExPlayer_SetAisacControlByName ֐<br>
 * Đ 3D ɑ΂ AISAC Rg[ ID ̕ύXsꍇA
 * ύXÕRg[ ID ɑ΂ŏIRg[lKpꑱ܂B<br>
 * ̂߁AύXO^ύX̂Q̃p[^[KpAӐ}o͂܂B<br>
 * w肷3DɕRÂĐĂȂԂŖ{֐s邱Ƃ𐄏܂B<br>
 * \sa criAtomEx3dSource_Update
 */
void CRIAPI criAtomEx3dSource_SetListenerBasedElevationAngleAisacControlId(CriAtomEx3dSourceHn ex_3d_source, CriAtomExAisacControlId aisac_control_id);

/*JP
 * \brief ʊpAISACRg[ID̐ݒ
 * \ingroup ATOMEXLIB_3D
 * \param[in]	ex_3d_source		3Dnh
 * \param[in]	aisac_control_id	ʊpAISACRg[ID
 * \par :
 * 猩Xi[̕ʊpɘAAISACRg[IDw肵܂B<br>
 * f[^ɐݒ肳Ă鉹ʊpAISACRg[ID́A{֐ɂď㏑Kp܂B<br>
 * \attention
 * ݒ肵p[^[ۂɓKpɂ́A::criAtomEx3dSource_Update ֐ĂяoKv܂B<br>
 * {֐Ŏw肵 AISAC Rg[ ID ɑ΂Rg[ĺA
 * ȉ֐̂ꂩgpăv[[ɐݒ肵Rg[lAD悵ēKp܂B<br>
 * - ::criAtomExPlayer_SetAisacControlById ֐<br>
 * - ::criAtomExPlayer_SetAisacControlByName ֐<br>
 * Đ 3D ɑ΂ AISAC Rg[ ID ̕ύXsꍇA
 * ύXÕRg[ ID ɑ΂ŏIRg[lKpꑱ܂B<br>
 * ̂߁AύXO^ύX̂Q̃p[^[KpAӐ}o͂܂B<br>
 * w肷3DɕRÂĐĂȂԂŖ{֐s邱Ƃ𐄏܂B<br>
 * \sa criAtomEx3dSource_Update
 */
void CRIAPI criAtomEx3dSource_SetSourceBasedAzimuthAngleAisacControlId(CriAtomEx3dSourceHn ex_3d_source, CriAtomExAisacControlId aisac_control_id);

/*JP
 * \brief pAISACRg[ID̐ݒ
 * \ingroup ATOMEXLIB_3D
 * \param[in]	ex_3d_source		3Dnh
 * \param[in]	aisac_control_id	pAISACRg[ID
 * \par :
 * 猩Xi[̋pɘAAISACRg[IDw肵܂B<br>
 * f[^ɐݒ肳Ă鉹pAISACRg[ID́A{֐ɂď㏑Kp܂B<br>
 * \attention
 * ݒ肵p[^[ۂɓKpɂ́A::criAtomEx3dSource_Update ֐ĂяoKv܂B<br>
 * {֐Ŏw肵 AISAC Rg[ ID ɑ΂Rg[ĺA
 * ȉ֐̂ꂩgpăv[[ɐݒ肵Rg[lAD悵ēKp܂B<br>
 * - ::criAtomExPlayer_SetAisacControlById ֐<br>
 * - ::criAtomExPlayer_SetAisacControlByName ֐<br>
 * Đ 3D ɑ΂ AISAC Rg[ ID ̕ύXsꍇA
 * ύXÕRg[ ID ɑ΂ŏIRg[lKpꑱ܂B<br>
 * ̂߁AύXO^ύX̂Q̃p[^[KpAӐ}o͂܂B<br>
 * w肷3DɕRÂĐĂȂԂŖ{֐s邱Ƃ𐄏܂B<br>
 * \sa criAtomEx3dSource_Update
 */
void CRIAPI criAtomEx3dSource_SetSourceBasedElevationAngleAisacControlId(CriAtomEx3dSourceHn ex_3d_source, CriAtomExAisacControlId aisac_control_id);

/*JP
 * \brief 3Dnhɑ΂3D[Wnh̐ݒ
 * \ingroup ATOMEXLIB_3D
 * \par :
 * 3Dnhɑ΂3D[Wnhݒ肵܂B
 *
 * \attention
 * ExPlayerɐݒ肳Ă3D3DXi[ɐݒ肳Ă郊[WقȂA
 * 3DƓ[Wݒ肳Ă3DgV[o[ȂꍇA̓~[g܂B<br>
 * ݒ肵p[^[ۂɓKpɂ́A::criAtomEx3dSource_Update ֐ĂяoKv܂B
 * <br>
 * \sa criAtomEx3dRegion_Create, criAtomEx3dSource_Update
 */
void CRIAPI criAtomEx3dSource_Set3dRegionHn(CriAtomEx3dSourceHn ex_3d_source, CriAtomEx3dRegionHn ex_3d_region);

/*JP
 * \brief 3Dɑ΂ʒũ_̐ݒ
 * \ingroup ATOMEXLIB_3D
 * \param[in]	ex_3d_source	3Dnh
 * \param[in]	config			3D̈ʒũ_ɊւRtBO\̂̃|C^
 * \par :
 * 3Dnhɑ΂Ĉʒũ_̐ݒ܂B
 * {֐sƁAĐɉ̈ʒüʒu񂨂ѐݒlɏ]
 * _ɕω܂B
 * \par l:
 * 2 config ɑ΂ NULL w肷ƁAݒ邱Ƃ\łB
 * \attention
 * ݒ肵p[^[ۂɓKpɂ́A::criAtomEx3dSource_Update ֐ĂяoKv܂B<br>
 * <br>
 * {֐͍Đ̉ɑ΂ăp[^[͓Kp܂B<br>
 * Đ̉Kp܂B
 * \sa CriAtomEx3dSourceRandomPositionConfig
 */
void CRIAPI criAtomEx3dSource_SetRandomPositionConfig(
	CriAtomEx3dSourceHn ex_3d_source, const CriAtomEx3dSourceRandomPositionConfig *config);

/*JP
 * \brief 3D̈ʒũ_ɂʒuWZoR[obN֐̓o^
 * \ingroup ATOMEXLIB_3D
 * \param[in]	ex_3d_source	3Dnh
 * \param[in]	func			3D̃_ɂʒuWZoR[obN֐
 * \param[in]	obj				[U[wIuWFNg
 * \par :
 * 3Dɑ΂āA3D̈ʒũ_ɂʒuWZoR[obN֐o^܂B<br>
 * o^R[obN֐́A3D̈ʒũ_LȏꍇA
 * WZos^C~OŎs܂B
 * \par l:
 * 3D̈ʒũ_ɊւRtBO\̂ł
 * ::CriAtomEx3dSourceRandomPositionConfig ̕ϐ calculation_type ɑ΂
 * ::CRIATOMEX3DSOURCE_RANDOM_POSITION_CALCULATION_TYPE_CALLBACK
 * ݒ肵Ăꍇ̂݁AWZoɎw肵R[obN֐s܂B
 * \attention
 * R[obNo^̓Kpɂ́A::criAtomEx3dSource_Update ֐ĂяoKv܂B<br>
 * <br>
 * T[o[ւ̊荞݂lȂAPIsꍇA
 * G[AfbhbN\܂B<br>
 * {IɁAR[obN֐łAtomCuAPIgpȂłB<br>
 * {R[obN֐ŒԏubNƁA؂ꓙ̖肪܂̂ŁA
 * ӂB<br>
 * <br>
 * R[obN֐͊e3D̃nhɂA1o^ł܂B<br>
 * o^𕡐sꍇAɓo^ς݂̃R[obN֐A
 * ォo^R[obN֐ɂ㏑Ă܂܂B<br>
 * <br>
 * funcNULLw肷邱Ƃœo^ς݊֐̓o^s܂B
 * \sa CriAtomEx3dSourceRandomPositionCalculationCbFunc, CriAtomEx3dSourceRandomPositionConfig
 */
void CRIAPI criAtomEx3dSource_SetRandomPositionCalculationCallback(
	CriAtomEx3dSourceHn ex_3d_source, CriAtomEx3dSourceRandomPositionCalculationCbFunc func, void *obj);

/*JP
 * \brief 3D̈ʒũ_ɂʒuWXg̐ݒ
 * \ingroup ATOMEXLIB_3D
 * \param[in]	ex_3d_source	3Dnh
 * \param[in]	position_list	ʒuWXg
 * \param[in]	length			Xg̗vf
 * \par :
 * ʒuWXg̔zw肵܂B<br>
 * 3D̈ʒũ_L̏ꍇAw肵z̍W烉_ɍW肳܂B
 * \par l:
 * ʒuW̎Zo@Ƃ ::CRIATOMEX3DSOURCE_RANDOM_POSITION_CALCULATION_TYPE_LIST
 * ݒ肵Ăꍇ̂݁A{p[^[QƂ܂B<br>
 * ̑̎Zo@ݒ肵ĂꍇA{p[^[͖܂B<br>
 * \attention
 * ݒ肵p[^[ۂɓKpɂ́A::criAtomEx3dSource_Update ֐ĂяoKv܂B<br>
 * <br>
 * {֐ɐݒ肵̈́A ::criAtomEx3dSource_SetRandomPositionList ֐
 * ̎śA͎QƂ܂B<br>
 * ɓŊmۂʒuWXgɕۑ܂B<br>
 * ̂߁A ::CriAtomEx3dSourceConfig::random_position_list_max_length 
 * lݒ肷ƃG[܂B
 * \sa CriAtomEx3dSourceRandomPositionConfig, CriAtomEx3dSourceConfig
 */
void CRIAPI criAtomEx3dSource_SetRandomPositionList(
	CriAtomEx3dSourceHn ex_3d_source, const CriAtomExVector *position_list, CriUint32 length);

/*JP
 * \brief 3D̈ʒũ_ɂʒuWʃR[obN֐̓o^
 * \ingroup ATOMEXLIB_3D
 * \param[in]	ex_3d_source	3Dnh
 * \param[in]	func			3D̃_ɂʒuWʃR[obN֐
 * \param[in]	obj				[U[wIuWFNg
 * \par :
 * 3D̈ʒũ_ɂʒuWʃR[obN֐o^܂B<br>
 * o^R[obN֐́A3D̈ʒũ_LȏꍇA
 * WZosꂽ̃^C~OŎs܂B
 * \par l:
 * Ǐ]ݒ肪L̏ꍇÃ\[ẌړɉĖ{R[obN֐s܂B
 * \attention
 * R[obNo^̓Kpɂ́A::criAtomEx3dSource_Update ֐ĂяoKv܂B<br>
 * <br>
 * T[o[ւ̊荞݂lȂAPIsꍇA
 * G[AfbhbN\܂B<br>
 * {IɁAR[obN֐łAtomCuAPIgpȂłB<br>
 * {R[obN֐ŒԏubNƁA؂ꓙ̖肪܂̂ŁA
 * ӂB<br>
 * <br>
 * R[obN֐1o^ł܂B<br>
 * o^𕡐sꍇAɓo^ς݂̃R[obN֐A
 * ォo^R[obN֐ɂ㏑܂B<br>
 * <br>
 * funcNULLw肷邱Ƃœo^ς݊֐̓o^s܂B
 * \sa CriAtomEx3dSourceRandomPositionResultCbFunc
 */
void CRIAPI criAtomEx3dSource_SetRandomPositionResultCallback(
	CriAtomEx3dSourceHn ex_3d_source, CriAtomEx3dSourceRandomPositionResultCbFunc func, void *obj);

/*JP
 * \brief 3DnhXg̍쐬ɕKvȃ[N̈TCY̌vZ
 * \ingroup ATOMEXLIB_3D
 * \param[in]	config		3DnhXg쐬pRtBO\̂ւ̃|C^
 * \return		CriSint32	3DnhXg쐬p[NTCY
 * \retval		0ȏ		ɏ
 * \retval		-1			G[
 * \par :
 * 3DnhXg쐬邽߂ɕKvȃ[N̈̃TCY擾܂B<br>
 * AP[^[o^3DnhXg쐬ꍇA
 * 炩ߖ{֐ŌvZ[N̈TCỸ
 * [N̈Ƃ ::criAtomEx3dSourceList_Create ֐ɃZbgKv܂B<br>
 * <br>
 * 3DnhXg̍쐬ɕKvȃ[ÑTCÝA3DnhXg쐬pRtBO
 * \́i ::CriAtomEx3dSourceListConfig j̓eɂĕω܂B<br>
 * <br>
 * NULLw肵ꍇAftHgݒ
 * i ::criAtomEx3dSourceList_SetDefaultConfig KpƓp[^[j
 * [N̈TCYvZ܂B
 * <br>
 * [N̈TCYvZɎsꍇA߂l -1 ɂȂ܂B<br>
 * [N̈TCY̌vZɎsRɂẮAG[R[obN
 * bZ[WŊmF\łB<br>
 * \par l:
 *  config ̏́A֐ł̂ݎQƂ܂B<br>
 * ֐𔲂͎QƂ܂̂ŁA֐s config ̗̈Ă
 * 肠܂B
 * \sa criAtomEx3dSourceList_Create, CriAtomEx3dSourceListConfig
 */
CriSint32 CRIAPI criAtomEx3dSourceList_CalculateWorkSize(const CriAtomEx3dSourceListConfig *config);

/*JP
 * \brief 3DnhXg̍쐬
 * \ingroup ATOMEXLIB_3D
 * \param[in]	config					3DnhXg쐬pRtBO\̂ւ̃|C^
 * \param[in]	work					3DnhXg쐬p[N̈ւ̃|C^
 * \param[in]	work_size				3DnhXg쐬p[NTCY
 * \return		CriAtomEx3dSourceListHn	3DnhXg
 * \par :
 * 3DnhXg쐬pRtBOɊÂāA3DnhXg쐬܂B<br>
 * 쐬ɐƁA3DnhXgԂ܂B<br>
 * 3DnhXg쐬ۂɂ́A[N̈ƂănKv܂B<br>
 * Kvȃ̃TCÝA ::criAtomEx3dSourceList_CalculateWorkSize 
 * ֐ŌvZ܂B<br>
 * i::criAtomEx_SetUserAllocator }NgpăAP[^[o^ς݂̏ꍇA
 * {֐Ƀ[N̈w肷Kv͂܂Bj<br>
 * \attention
 * {֐sOɁACuĂKv܂B<br>
 * <br>
 * \sa criAtomEx3dSourceList_CalculateWorkSize, criAtomEx3dSourceList_Destroy
 */
CriAtomEx3dSourceListHn CRIAPI criAtomEx3dSourceList_Create(
	const CriAtomEx3dSourceListConfig *config, void *work, CriSint32 work_size);

/*JP
 * \brief 3DnhXg̔j
 * \ingroup ATOMEXLIB_3D
 * \param[in]	ex_3d_source_list		3DnhXg
 * \par :
 * 3DnhXgj܂B<br>
 * {֐s_ŁA3DnhXg쐬Ɋmۂꂽ\[XSĉ܂B<br>
 * ܂AɎw肵3DnhXgɂȂ܂B<br>
 * 3DnhXgZbgAtomExv[[ōĐĂ鉹ꍇA
 * {֐sOɁẢ~邩AAtomExv[[jĂB
 * \par l:
 * 3DnhXg3DnhǉĂԂŖ{֐sꍇA
 * ǉĂ3Dnh͎I3DnhXg폜܂B
 * \sa criAtomEx3dSourceList_Create
 */
void CRIAPI criAtomEx3dSourceList_Destroy(CriAtomEx3dSourceListHn ex_3d_source_list);

/*JP
 * \brief 3DnhXgւ3Dnh̒ǉ
 * \ingroup ATOMEXLIB_3D
 * \param[in]	ex_3d_source_list		3DnhXg
 * \param[in]	ex_3d_source			3Dnh
 * \par :
 * 3DnhXg3Dnhǉ܂B<br>
 * ǉAtomExv[[3DnhXgƊ֘AtA
 * }`|WVjOĐ\ƂȂ܂B<br>
 * ǉ3Dnh3DnhXg폜ꍇ́A ::criAtomEx3dSourceList_Remove ֐܂
 * ::criAtomEx3dSourceList_RemoveAll ֐ĂяoĂB<br>
 * \par l:
 * ȉ̏ɓĂ͂܂3Dnh3DnhXgɒǉ邱Ƃ͂ł܂B<br>
 * - AtomExv[[ɐݒ肳Ă
 * - ɑ3DnhXgɒǉĂ
 * <br>
 * {֐͍ĐAtomExv[[ɎtĂ3DnhXgɑ΂Ăgp\łB<br>
 * \attention :
 * {֐͊A^̊֐łB<br>
 * {֐sƁA΂炭̊AtomCũT[o[ubN܂B<br>
 * Đɖ{֐sƁAr؂ꓙ̕s\邽߁A
 * {֐̌Ăяo̓V[̐؂ւ蓙Aוϓeł^C~OōsĂB
 * \sa criAtomEx3dSourceList_Remove, criAtomEx3dSourceList_RemoveAll
 */
void CRIAPI criAtomEx3dSourceList_Add(
	CriAtomEx3dSourceListHn ex_3d_source_list, CriAtomEx3dSourceHn ex_3d_source);

/*JP
 * \brief 3DnhXg3Dnh̍폜
 * \ingroup ATOMEXLIB_3D
 * \param[in]	ex_3d_source_list		3DnhXg
 * \param[in]	ex_3d_source			3Dnh
 * \par :
 * 3DnhXgAw肵3Dnh폜܂B<br>
 * 3DnhXgSĂ3Dnh폜ꍇ́A ::criAtomEx3dSourceList_RemoveAll ֐
 * ĂяoĂB<br>
 * 3DnhXg3Dnhǉꍇ́A ::criAtomEx3dSourceList_Add ֐ĂяoĂB 
 * \par l:
 * {֐͍ĐAtomExv[[ɎtĂ3DnhXgɑ΂Ăgp\łB<br>
 * \attention :
 * {֐͊A^̊֐łB<br>
 * {֐sƁA΂炭̊AtomCũT[o[ubN܂B<br>
 * Đɖ{֐sƁAr؂ꓙ̕s\邽߁A
 * {֐̌Ăяo̓V[̐؂ւ蓙Aוϓeł^C~OōsĂB
 * \sa criAtomEx3dSourceList_RemoveAll
 */
void CRIAPI criAtomEx3dSourceList_Remove(
	CriAtomEx3dSourceListHn ex_3d_source_list, CriAtomEx3dSourceHn ex_3d_source);

/*JP
 * \brief 3DnhXg3Dnh̑S폜
 * \ingroup ATOMEXLIB_3D
 * \param[in]	ex_3d_source_list		3DnhXg
 * \par :
 * 3DnhXgǉĂSĂ3Dnh폜܂B<br>
 * 3DnhXg3Dnh폜ꍇ́A ::criAtomEx3dSourceList_Remove ֐
 * ĂяoĂB<br>
 * 3DnhXg3Dnhǉꍇ́A ::criAtomEx3dSourceList_Add ֐ĂяoĂB 
 * \par l:
 * {֐͍ĐAtomExv[[ɎtĂ3DnhXgɑ΂Ăgp\łB<br>
 * \attention :
 * {֐͊A^̊֐łB<br>
 * {֐sƁA΂炭̊AtomCũT[o[ubN܂B<br>
 * Đɖ{֐sƁAr؂ꓙ̕s\邽߁A
 * {֐̌Ăяo̓V[̐؂ւ蓙Aוϓeł^C~OōsĂB
 * \sa criAtomEx3dSourceList_Remove
 */
void CRIAPI criAtomEx3dSourceList_RemoveAll(CriAtomEx3dSourceListHn ex_3d_source_list);

/*JP
 * \brief 3DXi[nh̍쐬ɕKvȃ[N̈TCY̌vZ
 * \ingroup ATOMEXLIB_3D
 * \param[in]	config		3DXi[nh쐬pRtBO\̂ւ̃|C^
 * \return		CriSint32	3DXi[nh쐬p[NTCY
 * \retval		0ȏ		ɏ
 * \retval		-1			G[
 * \par :
 * 3DXi[nh쐬邽߂ɕKvȁA[N̈̃TCY擾܂B<br>
 * AP[^[o^3DXi[nh쐬ꍇA
 * 炩ߖ{֐ŌvZ[N̈TCỸ
 * [N̈Ƃ ::criAtomEx3dListener_Create ֐ɃZbgKv܂B<br>
 * <br>
 * 3DXi[nh̍쐬ɕKvȃ[ÑTCÝA3DXi[nh쐬pRtBO
 * \́i ::CriAtomEx3dListenerConfig j̓eɂĕω܂B<br>
 * <br>
 * NULLw肵ꍇAftHgݒ
 * i ::criAtomEx3dListener_SetDefaultConfig KpƓp[^[j
 * [N̈TCYvZ܂B
 * <br>
 * [N̈TCYvZɎsꍇA߂l -1 ɂȂ܂B<br>
 * [N̈TCY̌vZɎsRɂẮAG[R[obN
 * bZ[WŊmF\łB<br>
 * \par l:
 *  config ̏́A֐ł̂ݎQƂ܂B<br>
 * ֐𔲂͎QƂ܂̂ŁA֐s config ̗̈Ă
 * 肠܂B
 * \sa criAtomEx3dListener_Create, CriAtomEx3dListenerConfig
 */
CriSint32 CRIAPI criAtomEx3dListener_CalculateWorkSize(const CriAtomEx3dListenerConfig *config);

/* 3DXi[̍쐬 */
/*JP
 * \brief 3DXi[nh̍쐬
 * \ingroup ATOMEXLIB_3D
 * \param[in]	config				3DXi[nh쐬pRtBO\̂ւ̃|C^
 * \param[in]	work				3DXi[nh쐬p[N̈ւ̃|C^
 * \param[in]	work_size			3DXi[nh쐬p[NTCY
 * \return		CriAtomEx3dListenerHn	3DXi[nh
 * \par :
 * 3DXi[nh쐬pRtBOɊÂāA3DXi[nh쐬܂B<br>
 * 쐬ɐƁA3DXi[nhԂ܂B<br>
 * 3DXi[nh쐬ۂɂ́A[N̈ƂănKv܂B<br>
 * Kvȃ̃TCÝA ::criAtomEx3dListener_CalculateWorkSize 
 * ֐ŌvZ܂B<br>
 * i::criAtomEx_SetUserAllocator }NgpăAP[^[o^ς݂̏ꍇA
 * {֐Ƀ[N̈w肷Kv͂܂Bj<br>
 * \attention
 * {֐sOɁACuĂKv܂B<br>
 * <br>
 * \sa criAtomEx3dListener_CalculateWorkSize, criAtomEx3dListener_Destroy
 */
CriAtomEx3dListenerHn CRIAPI criAtomEx3dListener_Create(
	const CriAtomEx3dListenerConfig *config, void *work, CriSint32 work_size);

/*JP
 * \brief 3DXi[nh̔j
 * \ingroup ATOMEXLIB_3D
 * \param[in]	ex_3d_listener		3DXi[nh
 * \par :
 * 3DXi[nhj܂B<br>
 * {֐s_ŁA3DXi[nh쐬Ɋmۂꂽ\[XSĉ܂B<br>
 * ܂AɎw肵3DXi[nhɂȂ܂B<br>
 * 3DXi[nhZbgAtomExv[[ōĐĂ鉹ꍇA
 * {֐sOɁẢ~邩AAtomExv[[jĂB
 * \sa criAtomEx3dListener_Create
 */
void CRIAPI criAtomEx3dListener_Destroy(CriAtomEx3dListenerHn ex_3d_listener);

/*JP
 * \brief 3DXi[̍XV
 * \ingroup ATOMEXLIB_3D
 * \param[in]	ex_3d_listener		3DXi[nh
 * \par :
 * 3DXi[ɐݒ肳Ăp[^[gpāA3DXi[XV܂B<br>
 * {֐ł́A3DXi[ɐݒ肳ĂSẴp[^[XV܂B
 * p[^[ЂƂύXxɖ{֐ɂčXVsA
 * ̃p[^[ύXĂXVsIłB
 * \par :
 * \code
 * CriAtomExVector pos;
 * CriAtomExVector vel;
 * 
 * // Set position
 * pos.x = 0.0f
 * pos.y = 0.0f
 * pos.z = 1.0f
 * criAtomEx3dListener_SetPosition(source, &pos);
 * // Set velocity
 * vel.x = 1.0f
 * vel.y = 0.0f
 * vel.z = 0.0f
 * criAtomEx3dListener_SetVelocity(source, &vel);
 * 
 * // Update source parameters
 * criAtomEx3dListener_Update(source);
 * \endcode
 * \attention
 * {֐AtomExv[[̃p[^[XVi::criAtomExPlayer_UpdateAll, criAtomExPlayer_Updatej
 * Ƃ͓Ɨē삵܂B3DXi[̃p[^[ύXۂ́A{֐ɂčXVsĂB
 */
void CRIAPI criAtomEx3dListener_Update(CriAtomEx3dListenerHn ex_3d_listener);

/*JP
 * \brief 3Dp[^[̏
 * \ingroup ATOMEXLIB_3D
 * \param[in]	ex_3d_listener		3DXi[nh
 * \par :
 * 3DXi[ɐݒ肳Ăp[^[NAAlɖ߂܂B<br>
 * \attention
 * NAp[^[ۂɓKpɂ́A::criAtomEx3dListener_Update ֐ĂяoKv܂B
 * \sa criAtomEx3dListener_Update
 */
void CRIAPI criAtomEx3dListener_ResetParameters(CriAtomEx3dListenerHn ex_3d_listener);

/*JP
 * \brief 3DXi[̈ʒu̐ݒ
 * \ingroup ATOMEXLIB_3D
 * \param[in]	ex_3d_listener		3DXi[nh
 * \param[in]	position			ʒuxNg
 * \par :
 * 3DXi[̈ʒuݒ肵܂B<br>
 * ʒúAAђʌvZɎgp܂B<br>
 * ʒúA3xNgŎw肵܂B<br>
 * ftHgl(0.0f, 0.0f, 0.0f)łB<br>
 * f[^ɂ͈ʒu͐ݒłȂ߁Aɖ{֐ł̐ݒlgp܂B<br>
 * \attention
 * ݒ肵p[^[ۂɓKpɂ́A::criAtomEx3dListener_Update ֐ĂяoKv܂B
 * \sa criAtomEx3dListener_Update
 */
void CRIAPI criAtomEx3dListener_SetPosition(CriAtomEx3dListenerHn ex_3d_listener, const CriAtomExVector *position);

/*JP
 * \brief 3DXi[̈ʒu̎擾
 * \ingroup ATOMEXLIB_3D
 * \param[in]	ex_3d_listener		3DXi[nh

 * \par :
 * 3DXi[̈ʒu擾܂B<br>
 * ʒúA3xNgŎ擾܂B<br>
 */
CriAtomExVector CRIAPI criAtomEx3dListener_GetPosition(CriAtomEx3dListenerHn ex_3d_listener);

/*JP
 * \brief 3DXi[̑x̐ݒ
 * \ingroup ATOMEXLIB_3D
 * \param[in]	ex_3d_listener		3DXi[nh
 * \param[in]	velocity			xxNg
 * \par :
 * 3DXi[̑xݒ肵܂B<br>
 * x́Ahbv[ʂ̌vZɎgp܂B<br>
 * x́A3xNgŎw肵܂Bx̒Pʂ́A1b̈ړłB
 * ftHgl(0.0f, 0.0f, 0.0f)łB<br>
 * f[^ɂ͑x͐ݒłȂ߁Aɖ{֐ł̐ݒlgp܂B<br>
 * \attention
 * ݒ肵p[^[ۂɓKpɂ́A::criAtomEx3dListener_Update ֐ĂяoKv܂B
 * \sa criAtomEx3dListener_Update
 */
void CRIAPI criAtomEx3dListener_SetVelocity(CriAtomEx3dListenerHn ex_3d_listener, const CriAtomExVector *velocity);

/*JP
 * \brief 3DXi[̌̐ݒ
 * \ingroup ATOMEXLIB_3D
 * \param[in]	ex_3d_listener		3DXi[nh
 * \param[in]	front				OxNg
 * \param[in]	top				xNg
 * \par :
 * 3DXi[̌OxNgƏxNgŐݒ肵܂B<br>
 * ́A3xNgŎw肵܂Bݒ肳ꂽxNǵACuŐKĎgp܂B<br>
 * ftHgl͈ȉ̂ƂłB<br>
 * 	- OxNgF(0.0f, 0.0f, 1.0f)
 * 	- xNgF(0.0f, 1.0f, 0.0f)
 * 	
 * f[^ɂ̓Xi[̌͐ݒłȂ߁Aɖ{֐ł̐ݒlgp܂B<br>
 * \attention
 * ݒ肵p[^[ۂɓKpɂ́A::criAtomEx3dListener_Update ֐ĂяoKv܂B
 * \sa criAtomEx3dListener_Update
 */
void CRIAPI criAtomEx3dListener_SetOrientation(CriAtomEx3dListenerHn ex_3d_listener, const CriAtomExVector *front, const CriAtomExVector *top);

/*JP
 * \brief 3DXi[̃hbv[{̐ݒ
 * \ingroup ATOMEXLIB_3D
 * \param[in]	ex_3d_listener		3DXi[nh
 * \param[in]	doppler_multiplier	hbv[{
 * \par :
 * 3DXi[̃hbv[{ݒ肵܂B̔{̓hbv[ʂ̌vZɎgp܂B<br>
 * Ⴆ΁Adoppler_multiplier10.0fw肷ƁAhbv[ʂʏ10{ɂȂ܂B<br>
 * doppler_multiplierɂ0.0fȏ̒lw肵܂B
 * ftHgl1.0fłB<br>
 * f[^ɂ̓Xi[̃hbv[{͐ݒłȂ߁Aɖ{֐ł̐ݒlgp܂B<br>
 * \attention
 * ݒ肵p[^[ۂɓKpɂ́A::criAtomEx3dListener_Update ֐ĂяoKv܂B
 * \sa criAtomEx3dListener_Update
 */
void CRIAPI criAtomEx3dListener_SetDopplerMultiplier(CriAtomEx3dListenerHn ex_3d_listener, CriFloat32 doppler_multiplier);

/*JP
 * \brief 3DXi[̒ړ_̐ݒ
 * \ingroup ATOMEXLIB_3D
 * \param[in]	ex_3d_listener		3DXi[nh
 * \param[in]	focus_point			ړ_xNg
 * \par :
 * 3DXi[̒ړ_ݒ肵܂B<br>
 * ړ_́A3D|WVjOsɂāA
 * ړ_ݒ肷ƁAXi[̈ʒuƒړ_̊ԂŌ΂A̒Ń}CNړ邱Ƃł悤ɂȂ܂B<br>
 * Ⴆ΁AXi[̓JƏɓĂAvLN^̈ʒuɒړ_ݒ肷邱ƂŁA󋵂ɉāAqϓIϓI_ɕ\^悤Ȏgł܂B<br>
 * ȂAXi[̈ʒuƒړ_̊Ԃňړł}CŃAẼ}CNƈقȂAZTivZpjƕZTiʌvZpj𕪗Ă܂B<br>
 * Ɨđ삷邱ƂŁAႦ΁uLɒڂ̂ŁA̓Lʒuōsvuʂ͉ʂ̌ڂɍ킹߁AʌvZ̓JʒuōsvƂ\sƂł܂B<br>
 * ftHgl(0.0f, 0.0f, 0.0f)łBZTZT̃tH[JXxݒ肵Ȃ󋵂ł́Aړ_ݒ肷Kv͂܂B̏ꍇA]ǂASĂ3D|WVjOvZXi[ʒuōs܂B<br>
 * \attention
 * ݒ肵p[^[ۂɓKpɂ́A::criAtomEx3dListener_Update ֐ĂяoKv܂B
 * \sa criAtomEx3dListener_Update, criAtomEx3dListener_SetDistanceFocusLevel, criAtomEx3dListener_SetDirectionFocusLevel
 */
void CRIAPI criAtomEx3dListener_SetFocusPoint(CriAtomEx3dListenerHn ex_3d_listener, const CriAtomExVector *focus_point);

/*JP
 * \brief ZT̃tH[JXx̐ݒ
 * \ingroup ATOMEXLIB_3D
 * \param[in]	ex_3d_listener			3DXi[nh
 * \param[in]	distance_focus_level	ZT̃tH[JXx
 * \par :
 * ZT̃tH[JXxݒ肵܂B<br>
 * ZT́A3D|WVjOvẐAvZ̊ƂȂʒu\܂Bʂ𖳎ċ̂݂̂m}CNAƂłB<br>
 * tH[JXx́Aړ_ɑ΂ĂǂꂾZTi}CNj߂Â邩\܂BZTi}CNj́AXi[ʒuƒړ_̊Ԃ񂾒œƂłA0.0fXi[ʒuA1.0fړ_ƓʒuɂȂ܂B<br>
 * Ⴆ΁AZT̃tH[JXx1.0fAZT̃tH[JXx0.0fƂ邱ƂŁAړ_ɋKpAXi[ʒuɒʂ肵܂B<br>
 * ftHgl0.0fłBZTZT̃tH[JXxݒ肵Ȃ󋵂ł́A]ǂASĂ3D|WVjOvZXi[ʒuōs܂B<br>
 * \attention
 * ݒ肵p[^[ۂɓKpɂ́A::criAtomEx3dListener_Update ֐ĂяoKv܂B
 * \sa criAtomEx3dListener_Update, criAtomEx3dListener_SetFocusPoint, criAtomEx3dListener_SetDirectionFocusLevel
 */
void CRIAPI criAtomEx3dListener_SetDistanceFocusLevel(CriAtomEx3dListenerHn ex_3d_listener, CriFloat32 distance_focus_level);

/*JP
 * \brief ZT̃tH[JXx̐ݒ
 * \ingroup ATOMEXLIB_3D
 * \param[in]	ex_3d_listener			3DXi[nh
 * \param[in]	direction_focus_level	ZT̃tH[JXx
 * \par :
 * ZT̃tH[JXxݒ肵܂B<br>
 * ZT́A3D|WVjOvẐAʌvZ̊ƂȂʒu\܂B𖳎Ēʂ݂̂m}CNAƂłB<br>
 * ZŤɂẮAXi[̌i::criAtomEx3dListener_SetOrientation ֐Őݒĵ܂܎gp܂B<br>
 * tH[JXx́Aړ_ɑ΂ĂǂꂾZTi}CNj߂Â邩\܂BZTi}CNj́AXi[ʒuƒړ_̊Ԃ񂾒œƂłA0.0fXi[ʒuA1.0fړ_ƓʒuɂȂ܂B<br>
 * Ⴆ΁AZT̃tH[JXx1.0fAZT̃tH[JXx0.0fƂ邱ƂŁAړ_ɋKpAXi[ʒuɒʂ肵܂B<br>
 * ftHgl0.0fłBZTZT̃tH[JXxݒ肵Ȃ󋵂ł́A]ǂASĂ3D|WVjOvZXi[ʒuōs܂B<br>
 * \attention
 * ݒ肵p[^[ۂɓKpɂ́A::criAtomEx3dListener_Update ֐ĂяoKv܂B
 * \sa criAtomEx3dListener_Update, criAtomEx3dListener_SetFocusPoint, criAtomEx3dListener_SetDistanceFocusLevel
 */
void CRIAPI criAtomEx3dListener_SetDirectionFocusLevel(CriAtomEx3dListenerHn ex_3d_listener, CriFloat32 direction_focus_level);

/*JP
 * \brief 3DXi[̒ړ_̎擾
 * \ingroup ATOMEXLIB_3D
 * \param[in]	ex_3d_listener		3DXi[nh
 * \param[out]	focus_point			ړ_xNg
 * \par :
 * 3DXi[̒ړ_擾܂B<br>
 * ftHgl(0.0f, 0.0f, 0.0f)łB3DXi[̒ړ_ݒ肵ĂȂꍇAftHglԋp܂B<br>
 * \sa criAtomEx3dListener_GetDistanceFocusLevel, criAtomEx3dListener_GetDirectionFocusLevel
 */
void CRIAPI criAtomEx3dListener_GetFocusPoint(CriAtomEx3dListenerHn ex_3d_listener, CriAtomExVector *focus_point);

/*JP
 * \brief ZT̃tH[JXx̎擾
 * \ingroup ATOMEXLIB_3D
 * \param[in]	ex_3d_listener			3DXi[nh
 * \par :
 * ZT̃tH[JXxݒ肵܂B<br>
 * ftHgl0.0fłBZT̃tH[JXxݒ肵ĂȂꍇAftHglԋp܂B<br>
 * \sa criAtomEx3dListener_GetDistanceFocusLevel, criAtomEx3dListener_GetDirectionFocusLevel
 */
CriFloat32 CRIAPI criAtomEx3dListener_GetDistanceFocusLevel(CriAtomEx3dListenerHn ex_3d_listener);

/*JP
 * \brief ZT̃tH[JXx̎擾
 * \ingroup ATOMEXLIB_3D
 * \param[in]	ex_3d_listener			3DXi[nh
 * \par :
 * ZT̃tH[JXx擾܂B<br>
 * ftHgl0.0fłBZT̃tH[JXxݒ肵ĂȂꍇAftHglԋp܂B<br>
 * \sa criAtomEx3dListener_GetFocusPoint, criAtomEx3dListener_GetDistanceFocusLevel
 */
CriFloat32 CRIAPI criAtomEx3dListener_GetDirectionFocusLevel(CriAtomEx3dListenerHn ex_3d_listener);

/*JP
 * \brief p^Cvp3D̎ɁAAISACƊpxAISACRg[lɔf邩ݒ
 * \ingroup ATOMEXLIB_3D
 * \param[in]	flag	AISACRg[lKp邩HiCRI_TRUE:ACRI_FALSE:Ȃj
 * \par :
 *  flag  CRI_TRUE ݒ肷ƁAp^Cvp3D̉ĐۂɁA3D\[X3DXi[nh<br>
 * ݒ肳ĂƂ͏ɋAISACƊpxAISAČvZʂɓKp܂B
 * \attention
 * AtomCũftHgł́Ap3Dɑ΂ċAISACƊpxAISAČvZʂ͓Kp܂B<br>
 * {֐CRI AtomCu Ver.2.17.19 ȑO̓Ƃׂ̌݊̈ɒǉ܂B
 * <br>
 * \sa criAtomEx_IsEnableCalculationAisacControlFrom3dPosition
 */
void CRIAPI criAtomEx_EnableCalculationAisacControlFrom3dPosition(CriBool flag);

/*JP
 * \brief p^Cvp3D̎ɁAAISACƊpxAISACRg[lɔfĂ邩擾
 * \ingroup ATOMEXLIB_3D
 * \retval	CRI_TRUE	vZʂKpĂ
 * \retval	CRI_FALSE	vZʂKpĂȂ
 * \par :
 * p^Cvp3D̉ĐۂɁA3D\[X3DXi[nh<br>
 * ݒ肳ĂƂɋAISACƊpxAISAČvZʂɓKpĂ邩ۂ擾܂B
 * \attention
 * AtomCũftHgł́Ap3Dɑ΂ċAISACƊpxAISAČvZʂ͓Kp܂B<br>
 * {֐CRI AtomCu Ver.2.17.19 ȑO̓Ƃׂ̌݊̈ɒǉ܂B
 * <br>
 * \sa criAtomEx_EnableCalculationAisacControlFrom3dPosition
 */
CriBool CRIAPI criAtomEx_IsEnableCalculationAisacControlFrom3dPosition(void);

/*JP
 * \brief 3DXi[nhɑ΂3D[Wnh̐ݒ
 * \ingroup ATOMEXLIB_3D
 * \par :
 * 3DXi[nhɑ΂3D[Wnhݒ肵܂B
 *
 * \attention
 * ExPlayerɐݒ肳Ă3D3DXi[ɐݒ肳Ă郊[WقȂA
 * 3DƓ[Wݒ肳Ă3DgV[o[ȂꍇA̓~[g܂B<br>
 * ݒ肵p[^[ۂɓKpɂ́A::criAtomEx3dListener_Update ֐ĂяoKv܂B
 * <br>
 * \sa criAtomEx3dRegion_Create, criAtomEx3dListener_Update
 */
void CRIAPI criAtomEx3dListener_Set3dRegionHn(CriAtomEx3dListenerHn ex_3d_listener, CriAtomEx3dRegionHn ex_3d_region);

/*JP
 * \brief 3D[Wnh̍쐬ɕKvȃ[N̈TCY̌vZ
 * \ingroup ATOMEXLIB_3D
 * \param[in]	config		3D[Wnh쐬pRtBO\̂ւ̃|C^
 * \return		CriSint32	3D[Wnh쐬p[NTCY
 * \retval		0ȏ		ɏ
 * \retval		-1			G[
 * \par :
 * 3D[Wnh쐬邽߂ɕKvȁA[N̈̃TCY擾܂B<br>
 * AP[^[o^3D[Wnh쐬ꍇA
 * 炩ߖ{֐ŌvZ[N̈TCỸ
 * [N̈Ƃ ::criAtomEx3dRegion_Create ֐ɃZbgKv܂B<br>
 * <br>
 * 3D[Wnh̍쐬ɕKvȃ[ÑTCÝA3D[Wnh쐬pRtBO
 * \́i ::CriAtomEx3dRegionConfig j̓eɂĕω܂B<br>
 * <br>
 * NULLw肵ꍇAftHgݒ
 * i ::criAtomEx3dRegion_SetDefaultConfig KpƓp[^[j
 * [N̈TCYvZ܂B
 * <br>
 * [N̈TCYvZɎsꍇA߂l -1 ɂȂ܂B<br>
 * [N̈TCY̌vZɎsRɂẮAG[R[obN
 * bZ[WŊmF\łB<br>
 * \par l:
 *  config ̏́A֐ł̂ݎQƂ܂B<br>
 * ֐𔲂͎QƂ܂̂ŁA֐s config ̗̈Ă
 * 肠܂B
 * \sa criAtomEx3dRegion_Create, CriAtomEx3dRegionConfig
 */
CriSint32 CRIAPI criAtomEx3dRegion_CalculateWorkSize(const CriAtomEx3dRegionConfig *config);

/*JP
 * \brief 3D[Wnh̍쐬
 * \ingroup ATOMEXLIB_3D
 * \param[in]	config				3D[Wnh쐬pRtBO\̂ւ̃|C^
 * \param[in]	work				3D[Wnh쐬p[N̈ւ̃|C^
 * \param[in]	work_size			3D[Wnh쐬p[NTCY
 * \return		criAtomEx3dRegionHn	3D[Wnh
 * \par :
 * 3D[Wnh쐬pRtBOɊÂāA3D[Wnh쐬܂B<br>
 * 쐬ɐƁA3D[WnhԂ܂B<br>
 * 3D[Wnh쐬ۂɂ́A[N̈ƂănKv܂B<br>
 * Kvȃ̃TCÝA ::criAtomEx3dRegion_CalculateWorkSize
 * ֐ŌvZ܂B<br>
 * i::criAtomEx_SetUserAllocator }NgpăAP[^[o^ς݂̏ꍇA
 * {֐Ƀ[N̈w肷Kv͂܂Bj<br>
 * \attention
 * {֐sOɁACuĂKv܂B<br>
 * <br>
 * \sa criAtomEx3dRegion_CalculateWorkSize, criAtomEx3dRegion_Destroy
 */
CriAtomEx3dRegionHn CRIAPI criAtomEx3dRegion_Create(
	const CriAtomEx3dRegionConfig *config, void *work, CriSint32 work_size);

/*JP
 * \brief 3D[Wnh̔j
 * \ingroup ATOMEXLIB_3D
 * \param[in]	ex_3d_region		3D[Wnh
 * \par :
 * 3D[Wnhj܂B<br>
 * {֐s_ŁA3D[Wnh쐬Ɋmۂꂽ\[XSĉ܂B<br>
 * ܂AɎw肵3D[WnhɂȂ܂B<br>
 * 3D[WnhZbg3DA3DXi[A3DgV[o[ꍇA
 * {֐sOɁAY3D[Wݒ肵ĂSẴnhj邩A
 * ݒO悤ɂĂB
 * \sa criAtomEx3dRegion_Create
 */
void CRIAPI criAtomEx3dRegion_Destroy(CriAtomEx3dRegionHn ex_3d_region);

/*JP
 * \brief 3DgV[o[nh̍쐬ɕKvȃ[N̈TCY̌vZ
 * \ingroup ATOMEXLIB_3D
 * \param[in]	config		3DgV[o[nh쐬pRtBO\̂ւ̃|C^
 * \return		CriSint32	3DgV[o[nh쐬p[NTCY
 * \retval		0ȏ		ɏ
 * \retval		-1			G[
 * \par :
 * 3DgV[o[nh쐬邽߂ɕKvȁA[N̈̃TCY擾܂B<br>
 * AP[^[o^3DgV[o[nh쐬ꍇA
 * 炩ߖ{֐ŌvZ[N̈TCỸ
 * [N̈Ƃ ::criAtomEx3dTransceiver_Create ֐ɃZbgKv܂B<br>
 * <br>
 * 3DgV[o[nh̍쐬ɕKvȃ[ÑTCÝA3DgV[o[nh쐬pRtBO
 * \́i ::CriAtomEx3dTransceiverConfig j̓eɂĕω܂B<br>
 * <br>
 * NULLw肵ꍇAftHgݒ
 * i ::criAtomEx3dTransceiver_SetDefaultConfig KpƓp[^[j
 * [N̈TCYvZ܂B
 * <br>
 * [N̈TCYvZɎsꍇA߂l -1 ɂȂ܂B<br>
 * [N̈TCY̌vZɎsRɂẮAG[R[obN
 * bZ[WŊmF\łB<br>
 * \par l:
 *  config ̏́A֐ł̂ݎQƂ܂B<br>
 * ֐𔲂͎QƂ܂̂ŁA֐s config ̗̈Ă
 * 肠܂B
 * \sa criAtomEx3dTransceiver_Create, CriAtomEx3dTransceiverConfig
 */
CriSint32 CRIAPI criAtomEx3dTransceiver_CalculateWorkSize(const CriAtomEx3dTransceiverConfig *config);

/*JP
 * \brief 3DgV[o[nh̍쐬
 * \ingroup ATOMEXLIB_3D
 * \param[in]	config				3DgV[o[nh쐬pRtBO\̂ւ̃|C^
 * \param[in]	work				3DgV[o[nh쐬p[N̈ւ̃|C^
 * \param[in]	work_size			3DgV[o[nh쐬p[NTCY
 * \return		criAtomEx3dTransceiverHn	3DgV[o[nh
 * \par :
 * 3DgV[o[nh쐬pRtBOɊÂāA3DgV[o[nh쐬܂B<br>
 * 쐬ɐƁA3DgV[o[nhԂ܂B<br>
 * 3DgV[o[nh쐬ۂɂ́A[N̈ƂănKv܂B<br>
 * Kvȃ̃TCÝA ::criAtomEx3dTransceiver_CalculateWorkSize
 * ֐ŌvZ܂B<br>
 * i::criAtomEx_SetUserAllocator }NgpăAP[^[o^ς݂̏ꍇA
 * {֐Ƀ[N̈w肷Kv͂܂Bj<br>
 * \attention
 * {֐sOɁACuĂKv܂B<br>
 * <br>
 * \sa criAtomEx3dTransceiver_CalculateWorkSize, criAtomEx3dTransceiver_Destroy
 */
CriAtomEx3dTransceiverHn CRIAPI criAtomEx3dTransceiver_Create(const CriAtomEx3dTransceiverConfig *config, void *work, CriSint32 work_size);

/*JP
 * \brief 3DgV[o[nh̔j
 * \ingroup ATOMEXLIB_3D
 * \param[in]	ex_3d_transceiver		3DgV[o[nh
 * \par :
 * 3DgV[o[nhj܂B<br>
 * {֐s_ŁA3DgV[o[nh쐬Ɋmۂꂽ\[XSĉ܂B<br>
 * ܂AɎw肵3DgV[o[nhɂȂ܂B<br>
 * \sa criAtomEx3dTransceiver_Create
 */
void CRIAPI criAtomEx3dTransceiver_Destroy(CriAtomEx3dTransceiverHn ex_3d_transceiver);

/*JP
 * \brief 3DgV[o[̍XV
 * \ingroup ATOMEXLIB_3D
 * \param[in]	ex_3d_transceiver		3DgV[o[nh
 * \par :
 * 3DgV[o[ɐݒ肳Ăp[^[gpāA3DgV[o[XV܂B<br>
 * {֐ł́A3DgV[o[ɐݒ肳ĂSẴp[^[XV܂B
 * p[^[ЂƂύXxɖ{֐ɂčXVsA
 * ̃p[^[ύXĂXVsIłB
 * \par :
 * \code
 * CriAtomExVector in_pos, out_pos;
 *
 * // Set input position
 * in_pos.x = 0.0f
 * in_pos.y = 0.0f
 * in_pos.z = 1.0f
 * criAtomEx3dTransceiver_SetInputPosition(transceiver, &in_pos);
 *
 * // Set output position
 * out_pos.x = 0.0f
 * out_pos.y = 0.0f
 * out_pos.z = 1.0f
 * criAtomEx3dTransceiver_SetOutputPosition(transceiver, &out_pos);
 *
 * // Update transceiver parameters
 * criAtomEx3dTransceiver_Update(transceiver);
 * \endcode
 * \attention
 * {֐AtomExv[[̃p[^[XVi::criAtomExPlayer_UpdateAll, criAtomExPlayer_Updatej
 * Ƃ͓Ɨē삵܂B3DgV[o[̃p[^[ύXۂ́A{֐ɂčXVsĂB
 */
void CRIAPI criAtomEx3dTransceiver_Update(CriAtomEx3dTransceiverHn ex_3d_transceiver);

/*JP
 * \brief 3DgV[o[͂̈ʒu̐ݒ
 * \ingroup ATOMEXLIB_3D
 * \param[in]	ex_3d_transceiver		3DgV[o[nh
 * \param[in]	position			ʒuxNg
 * \par :
 * 3DgV[o[͂̈ʒuݒ肵܂B<br>
 * ʒúAAђʌvZɎgp܂B<br>
 * ʒúA3xNgŎw肵܂B<br>
 * ftHgl(0.0f, 0.0f, 0.0f)łB<br>
 * \attention
 * ݒ肵p[^[ۂɓKpɂ́A::criAtomEx3dTransceiver_Update ֐ĂяoKv܂B
 * \sa criAtomEx3dTransceiver_Update
 */
void CRIAPI criAtomEx3dTransceiver_SetInputPosition(CriAtomEx3dTransceiverHn ex_3d_transceiver, const CriAtomExVector *position);

/*JP
 * \brief 3DgV[o[o͂̈ʒu̐ݒ
 * \ingroup ATOMEXLIB_3D
 * \param[in]	ex_3d_transceiver		3DgV[o[nh
 * \param[in]	position			ʒuxNg
 * \par :
 * 3DgV[o[o͂̈ʒuݒ肵܂B<br>
 * ʒúAAђʌvZɎgp܂B<br>
 * ʒúA3xNgŎw肵܂B<br>
 * ftHgl(0.0f, 0.0f, 0.0f)łB<br>
 * \attention
 * ݒ肵p[^[ۂɓKpɂ́A::criAtomEx3dTransceiver_Update ֐ĂяoKv܂B
 * \sa criAtomEx3dTransceiver_Update
 */
void CRIAPI criAtomEx3dTransceiver_SetOutputPosition(CriAtomEx3dTransceiverHn ex_3d_transceiver, const CriAtomExVector *position);

/*JP
 * \brief 3DgV[o[͂̌̐ݒ
 * \ingroup ATOMEXLIB_3D
 * \param[in]	ex_3d_transceiver		3DgV[o[nh
 * \param[in]	front				OxNg
 * \param[in]	top					xNg
 * \par :
 * 3DgV[o[̌OxNgƏxNgŐݒ肵܂B<br>
 * ́A3xNgŎw肵܂Bݒ肳ꂽxNǵACuŐKĎgp܂B<br>
 * ftHgl͈ȉ̂ƂłB<br>
 * 	- OxNgF(0.0f, 0.0f, 1.0f)
 * 	- xNgF(0.0f, 1.0f, 0.0f)
 * 	
 * \attention
 * ݒ肵p[^[ۂɓKpɂ́A::criAtomEx3dTransceiver_Update ֐ĂяoKv܂B<br>
 * \sa criAtomEx3dTransceiver_Update
 */
void CRIAPI criAtomEx3dTransceiver_SetInputOrientation(CriAtomEx3dTransceiverHn ex_3d_transceiver, const CriAtomExVector *front, const CriAtomExVector *top);

/*JP
 * \brief 3DgV[o[o͂̌̐ݒ
 * \ingroup ATOMEXLIB_3D
 * \param[in]	ex_3d_transceiver		3DgV[o[nh
 * \param[in]	front				OxNg
 * \param[in]	top					xNg
 * \par :
 * 3DgV[o[o͂̌ݒ肵܂B<br>
 * {֐Őݒ肵́ATEhR[̌ƂĐݒ肳܂B<br>
 * TEhR[́A3DgV[o[特\A̎w̕\Ɏgp܂B<br>
 * TEhR[̌́A3xNgŎw肵܂Bݒ肳ꂽxNǵACuŐKĎgp܂B<br>
 * ftHgl͈ȉ̂ƂłB<br>
 * 	- OxNgF(0.0f, 0.0f, 1.0f)
 * 	- xNgF(0.0f, 1.0f, 0.0f)
 * 	
 * \attention
 * ݒ肵p[^[ۂɓKpɂ́A::criAtomEx3dTransceiver_Update ֐ĂяoKv܂B<br>
 * \sa criAtomEx3dTransceiver_SetOutputConeParameter, criAtomEx3dTransceiver_Update
 */
void CRIAPI criAtomEx3dTransceiver_SetOutputOrientation(CriAtomEx3dTransceiverHn ex_3d_transceiver, const CriAtomExVector *front, const CriAtomExVector *top);

/*JP
 * \brief 3DgV[o[o͂̃TEhR[p[^[̐ݒ
 * \ingroup ATOMEXLIB_3D
 * \param[in]	ex_3d_transceiver		3DgV[o[nh
 * \param[in]	inside_angle		TEhR[̃CTChAO
 * \param[in]	outside_angle		TEhR[̃AEgTChAO
 * \param[in]	outside_volume		TEhR[̃AEgTCh{[
 * \par :
 * 3DgV[o[o͂̃TEhR[p[^[ݒ肵܂B<br>
 * TEhR[́A3DgV[o[特\A̎w̕\Ɏgp܂B<br>
 * TEhR[́AR[AOR[ō\܂BCTChAO͓R[̊pxA
 * AEgTChAO͊OR[̊pxAAEgTCh{[͊OR[̊pxȏ̕ł̉ʂꂼ\܂B<br>
 * R[̊px菬px̕ł́AR[ɂ錸󂯂܂B
 * R[ƊOR[̊Ԃ̕ł́AXɃAEgTCh{[܂Ō܂B<br>
 * CTChAOуAEgTChAÓA0.0f`360.0fxŎw肵܂B<br>
 * AEgTCh{[́A0.0f`1.0fUɑ΂{Ŏw肵܂iPʂ̓fVxł͂܂jB<br>
 * CũftHgl͈ȉ̂ƂłAR[ɂ錸͍s܂B<br>
 * 	- CTChAOF360.0f
 * 	- AEgTChAOF360.0f
 * 	- AEgTCh{[F0.0f
 * 	
 * ftHgĺA::criAtomEx3dTransceiver_ChangeDefaultConeParameter ֐ɂĕύX\łB<br>
 * 	
 * \attention
 * ݒ肵p[^[ۂɓKpɂ́A::criAtomEx3dTransceiver_Update ֐ĂяoKv܂B
 * \sa criAtomEx3dTransceiver_Update
 */
void CRIAPI criAtomEx3dTransceiver_SetOutputConeParameter(CriAtomEx3dTransceiverHn ex_3d_transceiver, CriFloat32 inside_angle, CriFloat32 outside_angle, CriFloat32 outside_volume);

/*JP
 * \brief 3DgV[o[̍ŏ^ő勗̐ݒ
 * \ingroup ATOMEXLIB_3D
 * \param[in]	ex_3d_transceiver		3DgV[o[nh
 * \param[in]	min_attenuation_distance		ŏ
 * \param[in]	max_attenuation_distance		ő勗
 * \par :
 * 3DgV[o[̍ŏ^ő勗ݒ肵܂B<br>
 * ŏ́Aȏ㉹ʂ傫ȂȂ\܂Bő勗́AŏʂɂȂ鋗\܂B<br>
 * CũftHgl͈ȉ̂ƂłB<br>
 * 	- ŏF0.0f
 * 	- ő勗F0.0f
 * 	
 * \attention
 * ݒ肵p[^[ۂɓKpɂ́A::criAtomEx3dTransceiver_Update ֐ĂяoKv܂B
 * \sa criAtomEx3dTransceiver_Update
 */
void CRIAPI criAtomEx3dTransceiver_SetOutputMinMaxAttenuationDistance(CriAtomEx3dTransceiverHn ex_3d_transceiver, CriFloat32 min_attenuation_distance, CriFloat32 max_attenuation_distance);

/*JP
 * \brief 3DgV[o[o͂̃CeApjOE̐ݒ
 * \ingroup ATOMEXLIB_3D
 * \param[in]	ex_3d_transceiver		3DgV[o[nh
 * \param[in]	transceiver_radius		3DgV[o[̔a
 * \param[in]	interior_distance	CeA
 * \par :
 * 3DgV[o[o͂̃CeApjOE̐ݒ܂B<br>
 * 3DgV[o[o͂̔áA3DgV[o[o͂ƂƂ̔ałB<br>
 * CeÁACeApjOKp3DgV[o[̔a̋łB<br>
 * 3DgV[o[̔ał́ACeApjOKp܂ACeA0.0ƈ邽߁A
 * SẴXs[J[瓯ʂŉĐ܂B<br>
 * CeAł́ACeApjOKp܂B<br>
 * CeAOł́ACeApjOKpꂸA3DgV[o[ʒuɍł߂1A
 * ܂2̃Xs[J[特Đ܂B<br>
 * CũftHgl͈ȉ̂ƂłB<br>
 * 	- 3DgV[o[̔aF0.0f
 * 	- CeAF0.0fi3DgV[o[̍ŏɈˑj
 * 	
 * \attention
 * ݒ肵p[^[ۂɓKpɂ́A::criAtomEx3dTransceiver_Update ֐ĂяoKv܂B
 * \sa criAtomEx3dTransceiver_Update
 */
void CRIAPI criAtomEx3dTransceiver_SetOutputInteriorPanField(CriAtomEx3dTransceiverHn ex_3d_transceiver, CriFloat32 transceiver_radius, CriFloat32 interior_distance);

/*JP
 * \brief 3DgV[o[͂̃NXtF[hE̐ݒ
 * \ingroup ATOMEXLIB_3D
 * \param[in]	ex_3d_transceiver		3DgV[o[nh
 * \param[in]	direct_audio_radius		ډ̈̔a
 * \param[in]	crossfade_distance	NXtF[h
 * \par :
 * 3DgV[o[͂̃NXtF[hE̐ݒ܂B<br>
 * ډ̈̔ał́A3DgV[o[̏o͍͂̉ĐꂸA3D݂̉̂Đ܂B<br>
 * NXtF[h́A3DgV[o[o͂3D̉̃NXtF[hKp钼ډ̈悩̋łB<br>
 * ډ̈ł́ANXtF[h̊̉=1A3DgV[o[̉=0ɂȂ̂ŁA
 * 3DgV[o[o͕͂̉ȂȂẢ݂̂Đ܂B<br>
 * NXtF[hł́AXi[̈ʒuɉăNXtF[hKp܂B<br>
 * NXtF[hOł́A3D͕̉A3DgV[o[o݂͂̉̂悤ɂȂ܂B
 * CũftHgl͈ȉ̂ƂłB<br>
 * 	- ډ̈̔aF0.0f
 * 	- NXtF[hF0.0f
 * 	
 * \attention
 * ݒ肵p[^[ۂɓKpɂ́A::criAtomEx3dTransceiver_Update ֐ĂяoKv܂B
 * \sa criAtomEx3dTransceiver_Update
 */
void CRIAPI criAtomEx3dTransceiver_SetInputCrossFadeField(CriAtomEx3dTransceiverHn ex_3d_transceiver, CriFloat32 direct_audio_radius, CriFloat32 crossfade_distance);

/*JP
 * \brief 3DgV[o[o͂̃{[̐ݒ
 * \ingroup ATOMEXLIB_3D
 * \param[in]	ex_3d_transceiver		3DgV[o[nh
 * \param[in]	volume				{[
 * \par :
 * 3DgV[o[o͂̃{[ݒ肵܂B<br>
 * 3DgV[o[o͂̃{[́AʂɊւ鉹ʁiL,R,SL,SRjɂ̂݉eALFEZ^[ւ̏o̓xɂ͉e܂B<br>
 * {[lɂ́A0.0f`1.0f͈̔͂Ŏlw肵܂B<br>
 * {[l͉f[^̐Uɑ΂{łiPʂ̓fVxł͂܂jB<br>
 * Ⴆ΁A1.0fw肵ꍇA͂̂܂܂̃{[ŏo͂܂B<br>
 * 0.5fw肵ꍇAg`̐U𔼕ɂf[^Ɠʁi-6dBj
 * o͂܂B<br>
 * 0.0fw肵ꍇA̓~[g܂iɂȂ܂jB<br>
 * CũftHgl1.0fłB<br>
 * \attention
 * ݒ肵p[^[ۂɓKpɂ́A::criAtomEx3dTransceiver_Update ֐ĂяoKv܂B
 * \sa criAtomEx3dTransceiver_Update
 */
void CRIAPI criAtomEx3dTransceiver_SetOutputVolume(CriAtomEx3dTransceiverHn ex_3d_transceiver, CriFloat32 volume);

/*JP
 * \brief 3DgV[o[AISACt
 * \ingroup ATOMEXLIB_3D
 * \param[in]	ex_3d_transceiver	3DgV[o[nh
 * \param[in]	global_aisac_name	tO[oAISAC
 * \par :
 * 3DgV[o[AISACA^b`itj܂B
 * AISACA^b`邱ƂɂAL[gbNAISACݒ肵ĂȂĂAAISAČʂ𓾂邱Ƃł܂B<br>
 * <br>
 * AISAC̃A^b`ɎsꍇA֐ŃG[R[obN܂B<br>
 * AISAC̃A^b`ɎsRɂẮAG[R[obÑbZ[WmFĂB<br>
 * \par l:
 * S̐ݒiACFt@CjɊ܂܂O[oAISAĈ݁AA^b`\łB<br>
 * AISAČʂ𓾂ɂ́AL[gbNɐݒ肳ĂAISACƓlɁAYAISACRg[lݒ肷Kv܂B<br>
 * \attention
 * L[gbNɁuAISACRg[lύXAISACvݒ肳ĂƂĂA
 * ̓KpʂAISACRg[ĺA3DgV[o[ɃA^b`AISACɂ͉e܂B<br>
 * ݁AuI[gW[Vvu_vƂRg[^CvAISAC̃A^b`ɂ͑ΉĂ܂B<br>
 * ݁A3DgV[o[ɃA^b`łAISAC̍ő吔́A8ŒłB
 * \sa criAtomEx3dTransceiver_DetachAisac
 */
void CRIAPI criAtomEx3dTransceiver_AttachAisac(CriAtomEx3dTransceiverHn ex_3d_transceiver, const CriChar8* global_aisac_name);

/*JP
 * \brief 3DgV[o[AISACO
 * \ingroup ATOMEXLIB_3D
 * \param[in]	ex_3d_transceiver	3DgV[o[nh
 * \param[in]	global_aisac_name	OO[oAISAC
 * \par :
 * 3DgV[o[AISACf^b`iOj܂B<br>
 * <br>
 * AISAC̃f^b`ɎsꍇA֐ŃG[R[obN܂B<br>
 * AISAC̃f^b`ɎsRɂẮAG[R[obÑbZ[WmFĂB<br>
 * \sa criAtomEx3dTransceiver_AttachAisac
 */
void CRIAPI criAtomEx3dTransceiver_DetachAisac(CriAtomEx3dTransceiverHn ex_3d_transceiver, const CriChar8* global_aisac_name);

/*JP
 * \brief pxAISACRg[l̍őωʂ̐ݒ
 * \ingroup ATOMEXLIB_3D
 * \param[in]	ex_3d_transceiver	3DgV[o[nh
 * \param[in]	max_delta			pxAISACRg[l̍őω
 * \par :
 * pxAISACɂAISACRg[lύXۂ́Aőωʂݒ肵܂B<br>
 * őωʂ߂ɕύXƁA3DgV[o[ƃXi[Ԃ̑Ίpx}ɕςꍇłA
 * pxAISACɂAISACRg[l̕ωX[Yɂ邱Ƃł܂B<br>
 * Ⴆ΁A(0.5f / 30.0f)ݒ肷ƁApx0x180xɕωꍇɁA30t[ĕω悤ȕωʂƂȂ܂B<br>
 * ftHgl1.0fiȂjłB
 * f[^ł͖{p[^[͐ݒłȂ߁Aɖ{֐ł̐ݒlgp܂B<br>
 * \attention
 * ݒ肵p[^[ۂɓKpɂ́A::criAtomEx3dTransceiver_Update ֐ĂяoKv܂B<br>
 * {֐Őݒ肵Ăőωʂ́AʊpxɌvZĂApxAISACRg[l̕ωɂ̂ݓKp܂B
 * ʊpx̂ɂ͉e͂܂B
 * \sa criAtomEx3dTransceiver_Update
 */
void CRIAPI criAtomEx3dTransceiver_SetMaxAngleAisacDelta(CriAtomEx3dTransceiverHn ex_3d_transceiver, CriFloat32 max_delta);

/*JP
 * \brief AISACRg[ID̐ݒ
 * \ingroup ATOMEXLIB_3D
 * \param[in]	ex_3d_transceiver	3DgV[o[nh
 * \param[in]	aisac_control_id	AISACRg[ID
 * \par :
 * ŏAő勗Ԃ̋ɘAAISACRg[IDw肵܂B<br>
 * {֐AISACRg[IDݒ肵ꍇAftHg͖̋ɂȂ܂B<br>
 * \attention
 * ݒ肵p[^[ۂɓKpɂ́A::criAtomEx3dTransceiver_Update ֐ĂяoKv܂B<br>
 * \sa criAtomEx3dTransceiver_Update
 */
void CRIAPI criAtomEx3dTransceiver_SetDistanceAisacControlId(CriAtomEx3dTransceiverHn ex_3d_transceiver, CriAtomExAisacControlId aisac_control_id);

/*JP
 * \brief Xi[ʊpAISACRg[ID̐ݒ
 * \ingroup ATOMEXLIB_3D
 * \param[in]	ex_3d_transceiver	3DgV[o[nh
 * \param[in]	aisac_control_id	Xi[ʊpAISACRg[ID
 * \par :
 * Xi[猩3DgV[o[̕ʊpɘAAISACRg[IDw肵܂B<br>
 * \attention
 * ݒ肵p[^[ۂɓKpɂ́A::criAtomEx3dTransceiver_Update ֐ĂяoKv܂B<br>
 * \sa criAtomEx3dTransceiver_Update
 */
void CRIAPI criAtomEx3dTransceiver_SetListenerBasedAzimuthAngleAisacControlId(CriAtomEx3dTransceiverHn ex_3d_transceiver, CriAtomExAisacControlId aisac_control_id);

/*JP
 * \brief Xi[pAISACRg[ID̐ݒ
 * \ingroup ATOMEXLIB_3D
 * \param[in]	ex_3d_transceiver	3DgV[o[nh
 * \param[in]	aisac_control_id	Xi[pAISACRg[ID
 * \par :
 * Xi[猩3DgV[o[̋pɘAAISACRg[IDw肵܂B<br>
 * \attention
 * ݒ肵p[^[ۂɓKpɂ́A::criAtomEx3dTransceiver_Update ֐ĂяoKv܂B<br>
 * \sa criAtomEx3dTransceiver_Update
 */
void CRIAPI criAtomEx3dTransceiver_SetListenerBasedElevationAngleAisacControlId(CriAtomEx3dTransceiverHn ex_3d_transceiver, CriAtomExAisacControlId aisac_control_id);

/*JP
 * \brief 3DgV[o[o͊ʊpAISACRg[ID̐ݒ
 * \ingroup ATOMEXLIB_3D
 * \param[in]	ex_3d_transceiver	3DgV[o[nh
 * \param[in]	aisac_control_id	3DgV[o[ʊpAISACRg[ID
 * \par :
 * 3DgV[o[o͂̈ʒu猩Xi[̕ʊpɘAAISACRg[IDw肵܂B<br>
 * \attention
 * ݒ肵p[^[ۂɓKpɂ́A::criAtomEx3dTransceiver_Update ֐ĂяoKv܂B<br>
 * \sa criAtomEx3dTransceiver_Update
 */
void CRIAPI criAtomEx3dTransceiver_SetTransceiverOutputBasedAzimuthAngleAisacControlId(CriAtomEx3dTransceiverHn ex_3d_transceiver, CriAtomExAisacControlId aisac_control_id);

/*JP
 * \brief 3DgV[o[o͊pAISACRg[ID̐ݒ
 * \ingroup ATOMEXLIB_3D
 * \param[in]	ex_3d_transceiver	3DgV[o[nh
 * \param[in]	aisac_control_id	3DgV[o[pAISACRg[ID
 * \par :
 * 3DgV[o[o͂̈ʒu猩Xi[̋pɘAAISACRg[IDw肵܂B<br>
 * \attention
 * ݒ肵p[^[ۂɓKpɂ́A::criAtomEx3dTransceiver_Update ֐ĂяoKv܂B<br>
 * \sa criAtomEx3dTransceiver_Update
 */
void CRIAPI criAtomEx3dTransceiver_SetTransceiverOutputBasedElevationAngleAisacControlId(CriAtomEx3dTransceiverHn ex_3d_transceiver, CriAtomExAisacControlId aisac_control_id);

/*JP
 * \brief 3DgV[o[nhɑ΂3D[Wnh̐ݒ
 * \ingroup ATOMEXLIB_3D
 * \par :
 * 3DgV[o[nhɑ΂3D[Wnhݒ肵܂B
 *
 * \attention
 * ExPlayerɐݒ肳Ă3D3DXi[ɐݒ肳Ă郊[WقȂA
 * 3DƓ[Wݒ肳Ă3DgV[o[ȂꍇA̓~[g܂B<br>
 * ݒ肵p[^[ۂɓKpɂ́A::criAtomEx3dTransceiver_Update ֐ĂяoKv܂B
 * <br>
 * \sa criAtomEx3dRegion_Create, criAtomEx3dTransceiver_Update
 */
void CRIAPI criAtomEx3dTransceiver_Set3dRegionHn(CriAtomEx3dTransceiverHn ex_3d_transceiver, CriAtomEx3dRegionHn ex_3d_region);

/*==========================================================================
 *      CRI AtomEx DSP API
 *=========================================================================*/

/*JP
 * \brief DSP̃f^b`
 * \ingroup ATOMEXLIB_DSP
 * \param[in]	pool		{CXv[nh
 * \par :
 * {CXv[ɒǉDSPO܂B<br>
 * \attention
 * {֐͊A^̊֐łB<br>
 * {֐sƁA΂炭̊AtomCũT[o[ubN܂B<br>
 * Đɖ{֐sƁAr؂ꓙ̕s\邽߁A
 * {֐̌Ăяo̓V[̐؂ւ蓙Aוϓeł^C~OōsĂB
 * \attention l:
 * ݁A{֐gpłȂvbgtH[݂܂B<br>
 */
void CRIAPI criAtomExVoicePool_DetachDsp(CriAtomExVoicePoolHn pool);

/*JP
 * \brief sb`Vt^[DSPA^b`p[N̈TCY̌vZ
 * \ingroup ATOMEXLIB_DSP
 * \param[in]	config		A^b`pRtBO
 * \return		CriSint32	[N̈TCY
 * \retval		0ȏ		ɏ
 * \retval		-1			G[
 * \par :
 * sb`Vt^[DSP̃A^b`ɕKvȃ[N̈TCYvZ܂B
 * \sa criAtomExVoicePool_AttachDspPitchShifter
 */
CriSint32 CRIAPI criAtomExVoicePool_CalculateWorkSizeForDspPitchShifter(
	const CriAtomExDspPitchShifterConfig *config);

/*JP
 * \brief sb`Vt^[DSP̃A^b`
 * \ingroup ATOMEXLIB_DSP
 * \param[in]	pool		A^b`{CXv[nh
 * \param[in]	config		A^b`pRtBO
 * \param[in]	work		A^b`p[N̈ւ̃|C^
 * \param[in]	work_size	A^b`p[N̈̃TCY
 * \par :
 * {CXv[Ƀsb`Vt^[DSPǉ܂B<br>
 * \attention
 * {֐͊A^̊֐łB<br>
 * {֐sƁA΂炭̊AtomCũT[o[ubN܂B<br>
 * Đɖ{֐sƁAr؂ꓙ̕s\邽߁A
 * {֐̌Ăяo̓V[̐؂ւ蓙Aוϓeł^C~OōsĂB
 * \attention l:
 * ݁A{֐gpłȂvbgtH[݂܂B<br>
 */
void CRIAPI criAtomExVoicePool_AttachDspPitchShifter(CriAtomExVoicePoolHn pool,
	const CriAtomExDspPitchShifterConfig *config, void *work, CriSint32 work_size);

/*JP
 * \brief ^CXgb`DSPA^b`p[N̈TCY̌vZ
 * \ingroup ATOMEXLIB_DSP
 * \param[in]	config		A^b`pRtBO
 * \return		CriSint32	[N̈TCY
 * \retval		0ȏ		ɏ
 * \retval		-1			G[
 * \par :
 * ^CXgb`DSP̃A^b`ɕKvȃ[N̈TCYvZ܂B
 * \sa criAtomExVoicePool_AttachDspTimeStretch
 */
CriSint32 CRIAPI criAtomExVoicePool_CalculateWorkSizeForDspTimeStretch(
	const CriAtomExDspTimeStretchConfig *config);

/*JP
 * \brief ^CXgb`DSP̃A^b`
 * \ingroup ATOMEXLIB_DSP
 * \param[in]	pool		A^b`{CXv[nh
 * \param[in]	config		A^b`pRtBO
 * \param[in]	work		A^b`p[N̈ւ̃|C^
 * \param[in]	work_size	A^b`p[N̈̃TCY
 * \par :
 * {CXv[Ƀ^CXgb`DSPǉ܂B<br>
 * \attention
 * {֐͊A^̊֐łB<br>
 * {֐sƁA΂炭̊AtomCũT[o[ubN܂B<br>
 * Đɖ{֐sƁAr؂ꓙ̕s\邽߁A
 * {֐̌Ăяo̓V[̐؂ւ蓙Aוϓeł^C~OōsĂB
 * \attention l:
 * ݁A{֐gpłȂvbgtH[݂܂B<br>
 */
void CRIAPI criAtomExVoicePool_AttachDspTimeStretch(CriAtomExVoicePoolHn pool,
	const CriAtomExDspTimeStretchConfig *config, void *work, CriSint32 work_size);

/*JP
* \brief ^CXgb`DSPA^b`p[N̈TCY̌vZ
* \ingroup ATOMEXLIB_DSP
* \param[in]	config		A^b`pRtBO
* \return		CriSint32	[N̈TCY
* \retval		0ȏ		ɏ
* \retval		-1			G[
* \par :
* AFX`DSP̃A^b`ɕKvȃ[N̈TCYvZ܂B
* \sa criAtomExVoicePool_AttachDspAfx
*/
CriSint32 CRIAPI criAtomExVoicePool_CalculateWorkSizeForDspAfx(
	const CriAtomExDspAfxConfig *config);

/*JP
* \brief AFX`DSP̃A^b`
* \ingroup ATOMEXLIB_DSP
* \param[in]	pool		A^b`{CXv[nh
* \param[in]	config		A^b`pRtBO
* \param[in]	work		A^b`p[N̈ւ̃|C^
* \param[in]	work_size	A^b`p[N̈̃TCY
* \par :
* {CXv[AFX`DSPǉ܂B<br>
* \attention
* {֐͊A^̊֐łB<br>
* {֐sƁA΂炭̊AtomCũT[o[ubN܂B<br>
* Đɖ{֐sƁAr؂ꓙ̕s\邽߁A
* {֐̌Ăяo̓V[̐؂ւ蓙Aוϓeł^C~OōsĂB
* \attention l:
* ݁A{֐gpłȂvbgtH[݂܂B<br>
*/
void CRIAPI criAtomExVoicePool_AttachDspAfx(CriAtomExVoicePoolHn pool,
	const CriAtomExDspAfxConfig *config, void *work, CriSint32 work_size);

/* ========================================================================*/
/*       CRI AtomEx Streaming Cache API                                    */
/* ========================================================================*/
/*JP
 * \brief w肵CueiIDwj̃Xg[pf[^LbVς݂擾܂
 * \ingroup ATOMEXLIB_STREAMING_CACHE
 * \param[in]	stm_cache_id	ΏۂƂXg[~OLbVID
 * \param[in]	acb_hn			Cue܂łACBnh
 * \param[in]	id				LbVς݊mFΏۂCueID
 * \retval	CRI_TRUE	= LbVς
 * \retval	CRI_FALSE	= LbV
 * \par :
 * ΏۂƂXg[~OLbVɂāA
 * IDŎw肵CuẽXg[~Opf[^LbVς݂擾܂B<br>
 * \attention
 * {֐́ACuẽXg[pf[^ꍇɂĂ͐mȏԂ܂B<br>
 * CuẽXg[pf[^ꍇA
 * CueōŏɌXg[pf[^LbVꂽiK
 * CRI_TRUEԂ܂B<br>
 * \sa criAtomStreamingCache_IsCachedWaveformByName
 */
CriBool CRIAPI criAtomExStreamingCache_IsCachedWaveformById(
	CriAtomExStreamingCacheId stm_cache_id, CriAtomExAcbHn acb_hn, CriAtomExCueId id);

/*JP
 * \brief w肵CueiOwj̃Xg[pf[^LbVς݂擾܂
 * \ingroup ATOMEXLIB_STREAMING_CACHE
 * \param[in]	stm_cache_id	ΏۂƂXg[~OLbVID
 * \param[in]	acb_hn			Cue܂łACBnh
 * \param[in]	name			LbVς݊mFΏۂCue
 * \retval	CRI_TRUE	= LbVς
 * \retval	CRI_FALSE	= LbV
 * \par :
 * ΏۂƂXg[~OLbVɂāA
 * CueŎw肵CuẽXg[~Opf[^LbVς݂擾܂B<br>
 * \attention
 * {֐́ACuẽXg[pf[^ꍇɂĂ͐mȏԂ܂B<br>
 * CuẽXg[pf[^ꍇA
 * CueōŏɌXg[pf[^LbVꂽiK
 * CRI_TRUEԂ܂B<br>
 * \sa criAtomStreamingCache_IsCachedWaveformById
 */
CriBool CRIAPI criAtomExStreamingCache_IsCachedWaveformByName(
	CriAtomExStreamingCacheId stm_cache_id, CriAtomExAcbHn acb_hn, const CriChar8 *name);

/*JP
 * \brief w肵CueiIDwj̃Xg[pf[^LbVɃ[hJn
 * \ingroup ATOMEXLIB_STREAMING_CACHE
 * \param[in]	stm_cache_id	ΏۂƂXg[~OLbVID
 * \param[in]	acb_hn			Cue܂łACBnh
 * \param[in]	cue_id			LbVΏۂCueID
 * \return		CriFsLoaderHn	CriFsLoadernh
 * \retval	NULL		= [hJn̎s
 * \retval	NULLȊO	= [hJn̐
 * \par :
 * Xg[~OLbVɑ΂AIDŎw肵CuẽXg[~Opf[^̃[hJn܂B<br>
 * {֐ɐƃ[hJnA::CRIFSLAODER_STATUS_LOADINGԂ
 * ::CriFsLoaderHn nhԂ܂B<br>
 * {֐ɎsƁANULLԂ܂B<br>
 * ߂lCriFsLoadernh::CRIFSLOADER_STATUS_COMPLETEԂɂȂƁA
 * [hуLbV͊łB<br>
 * [h́A{֐Ŏ擾CriFsLoadernh
 * ::criFsLoader_Destroy ֐ŔjĂB<br>
 * \par l:
 * {֐͑AłB
 * \attention
 * CuẽXg[pf[^ꍇA
 * {֐CueōŏɌXg[pf[^݂̂[h܂B<br>
 */
CriFsLoaderHn CRIAPI criAtomExStreamingCache_LoadWaveformByIdAsync(
	CriAtomExStreamingCacheId stm_cache_id, CriAtomExAcbHn acb_hn, CriAtomExCueId cue_id);

/*JP
 * \brief w肵CueiOwj̃Xg[pf[^LbVɃ[hJn
 * \ingroup ATOMEXLIB_STREAMING_CACHE
 * \param[in]	stm_cache_id	ΏۂƂXg[~OLbVID
 * \param[in]	acb_hn			Cue܂łACBnh
 * \param[in]	name			LbVΏۂCue
 * \return		CriFsLoaderHn	CriFsLoadernh
 * \retval	NULL		= [hJn̎s
 * \retval	NULLȊO	= [hJn̐
 * \par :
 * Xg[~OLbVɑ΂AOŎw肵CuẽXg[~Opf[^[h܂B<br>
 * {֐ɐƃ[hJnA::CRIFSLAODER_STATUS_LOADINGԂ
 * ::CriFsLoaderHn nhԂ܂B<br>
 * {֐ɎsƁANULLԂ܂B<br>
 * ߂lCriFsLoadernh::CRIFSLOADER_STATUS_COMPLETEԂɂȂƁA
 * [hуLbV͊łB<br>
 * [h́A{֐Ŏ擾CriFsLoadernh
 * ::criFsLoader_Destroy ֐ŔjĂB<br>
 * \par l:
 * {֐͑AłB
 * \attention
 * CuẽXg[pf[^ꍇA
 * {֐CueōŏɌXg[pf[^݂̂[h܂B<br>
 */
CriFsLoaderHn CRIAPI criAtomExStreamingCache_LoadWaveformByNameAsync(
	CriAtomExStreamingCacheId stm_cache_id, CriAtomExAcbHn acb_hn, const CriChar8 *name);

/* ========================================================================*/
/*       CRI AtomEx Tween(Parameter Animation) API                         */
/* ========================================================================*/
/*JP
 * \brief gDC[̍쐬ɕKvȃ[N̈TCY̌vZ
 * \ingroup ATOMEXLIB_TWEEN
 * \param[in]	config		gDC[쐬pRtBO\
 * \return		CriSint32	[N̈TCY
 * \retval		0ȏ		ɏ
 * \retval		-1			G[
 * \par :
 * gDC[쐬̂ɕKvȁA[N̈̃TCY擾܂B<br>
 * AP[^[o^ɃgDC[쐬ꍇA炩ߖ{֐ŌvZ
 * [N̈TCỸ[N̈Ƃ ::criAtomExTween_Create ֐
 * ZbgKv܂B<br>
 * <br>
 * NULLw肵ꍇAftHgݒ
 * i ::criAtomExTween_SetDefaultConfig KpƓp[^[j
 * [N̈TCYvZ܂B<br>
 * <br>
 * [N̈TCYvZɎsꍇA߂l -1 ɂȂ܂B<br>
 * [N̈TCY̌vZɎsRɂẮAG[R[obN
 * bZ[WŊmF\łB<br>
 * \par l:
 *  config ̏́A֐ł̂ݎQƂ܂B<br>
 * ֐𔲂͎QƂ܂̂ŁA֐s config ̗̈Ă
 * 肠܂B
 * \attention
 * {֐sOɁACuĂKv܂B<br>
 * \sa CriAtomExTweenConfig, criAtomExTween_Create
 */
CriSint32 CRIAPI criAtomExTween_CalculateWorkSize(const CriAtomExTweenConfig *config);

/*JP
 * \brief gDC[̍쐬
 * \ingroup ATOMEXLIB_TWEEN
 * \param[in]	config				gDC[쐬pRtBO\̂ւ̃|C^
 * \param[in]	work				gDC[쐬p[N̈ւ̃|C^
 * \param[in]	work_size			gDC[쐬p[NTCY
 * \return		CriAtomExTweenHn	gDC[nh
 * \par :
 * gDC[쐬pRtBOɊÂāAgDC[쐬܂B<br>
 * 쐬ɐƁAgDC[nhԂ܂B<br>
 * gDC[쐬ۂɂ́A[N̈ƂănKv܂B<br>
 * Kvȃ̃TCÝA ::criAtomExTween_CalculateWorkSize 
 * ֐ŌvZ܂B<br>
 * i::criAtomEx_SetUserAllocator }NgpăAP[^[o^ς݂̏ꍇA
 * {֐Ƀ[N̈w肷Kv͂܂Bj<br>
 * 쐬gDC[́A::criAtomExPlayer_AttachTween ֐ɂAtomExv[[ɃA^b`邱ƂŌʂ𔭊܂B
 * \par l:
 * gDC[̕ێp[^[̏ĺARtBO\̂Ńp[^[^Cv::CRIATOMEX_PARAMETER_TYPE_BASICw肵ꍇ͊ep[^[̃ftHglA܂̓p[^[^Cv::CRIATOMEX_PARAMETER_TYPE_AISACw肵ꍇ0.0fłB
 * \attention
 * {֐sOɁACuĂKv܂B<br>
 * TweennhA^b`AtomExv[[ōĐĂ鉹ꍇA
 * {֐sOɁẢ~邩AAtomExv[[jĂB
 * <br>
 * \sa criAtomExTween_CalculateWorkSize, criAtomExTween_Destroy, criAtomExPlayer_AttachTween
 */
CriAtomExTweenHn CRIAPI criAtomExTween_Create(
	const CriAtomExTweenConfig *config, void *work, CriSint32 work_size);

/*JP
 * \brief gDC[̔j
 * \ingroup ATOMEXLIB_TWEEN
 * \param[in]	tween		gDC[nh
 * \par :
 * gDC[j܂B<br>
 * {֐s_ŁAgDC[쐬Ɋmۂꂽ\[XSĉ܂B<br>
 * ܂AɎw肵gDC[nhɂȂ܂B<br>
 * gDC[A^b`AtomExv[[ōĐĂ鉹ꍇA
 * {֐sOɁẢ~邩AAtomExv[[jĂB
 * \sa criAtomExTween_Create
 */
void CRIAPI criAtomExTween_Destroy(CriAtomExTweenHn tween);

/*JP
 * \brief ݒl̎擾
 * \ingroup ATOMEXLIB_TWEEN
 * \param[in]	tween		gDC[nh
 * \par :
 * gDC[ێĂp[^[̌ݒl擾܂B<br>
 */
CriFloat32 CRIAPI criAtomExTween_GetValue(CriAtomExTweenHn tween);

/*JP
 * \brief ݒlwlɕω
 * \ingroup ATOMEXLIB_TWEEN
 * \param[in]	tween		gDC[nh
 * \param[in]	time_ms		ωɗv鎞ԁi~bPʁj
 * \param[in]	value		ω̍ŏIl
 * \par :
 * time_msŎw肵ԂāA{֐ĂяoɃgDC[ێĂ錻ݒlAvalueŎw肵lւƕω܂B<br>
 * ωJ[u̓jAi`jłB
 */
void CRIAPI criAtomExTween_MoveTo(CriAtomExTweenHn tween, CriUint16 time_ms, CriFloat32 value);

/*JP
 * \brief wl猻ݒlɕω
 * \ingroup ATOMEXLIB_TWEEN
 * \param[in]	tween		gDC[nh
 * \param[in]	time_ms		ωɗv鎞ԁi~bPʁj
 * \param[in]	value		ωO̊Jnl
 * \par :
 * time_msŎw肵ԂāAvalueŎw肵lA{֐ĂяoɃgDC[ێĂ錻ݒlւƕω܂B<br>
 * ωJ[u̓jAi`jłB
 */
void CRIAPI criAtomExTween_MoveFrom(CriAtomExTweenHn tween, CriUint16 time_ms, CriFloat32 value);

/*JP
 * \brief gDC[̒~
 * \ingroup ATOMEXLIB_TWEEN
 * \param[in]	tween		gDC[nh
 * \par :
 * gDC[ɂp[^[̎ԕω~܂B<br>
 */
void CRIAPI criAtomExTween_Stop(CriAtomExTweenHn tween);

/*JP
 * \brief gDC[̃Zbg
 * \ingroup ATOMEXLIB_TWEEN
 * \param[in]	tween		gDC[nh
 * \par :
 * gDC[̕ێĂp[^[̌ݒlZbgAlɖ߂܂B<br>
 * gDC[̕ێp[^[̏ĺARtBO\̂Ńp[^[^Cv::CRIATOMEX_PARAMETER_TYPE_BASICw肵ꍇ͊ep[^[̃ftHglA܂̓p[^[^Cv::CRIATOMEX_PARAMETER_TYPE_AISACw肵ꍇ0.0fłB
 * \par l:
 * gDC[ɂ鎞ԕω삵ĂꍇA~܂B
 */
void CRIAPI criAtomExTween_Reset(CriAtomExTweenHn tween);

/*==========================================================================
 *      CRI AtomEx Voice Event API
 *=========================================================================*/
/*JP
 * \brief {CXCxgR[obN̓o^
 * \ingroup ATOMEXLIB_GLOBAL
 * \param[in]	func		{CXCxgR[obN֐
 * \param[in]	obj			[UwIuWFNg
 * \par :
 * {CXCxgR[obNo^܂B<br>
 * {֐gpă{CXCxgR[obNo^邱ƂŁA
 * {CXCxgi{CX̎擾^^Dj̏ڍ׏
 * iĐ^~鉹f[^̏ڍ׏񓙁j擾\łB<br>
 * \par l:
 *  2 i obj jɃZbgĺAR[obN֐̈Ƃēn܂B<br>
 * R[obN֐̂̑̈ɂẮA
 * ʓr ::CriAtomExVoiceEventCbFunc ̐QƂB<br>
 * <br>
 * funcNULLw肷邱Ƃœo^ς݊֐̓o^s܂B<br>
 * \attention
 * {֐œo^R[obNɂ́A{CXPʂ̃~bg
 *i{CXvCIeBɊÂg`Pʂ̃vCIeBj
 * Ɋւ݂̂Ԃ܂B<br>
 * iJeSL[vCIeBɂ鐧Ɋւ́A擾ł܂Bj<br>
 * <br>
 * R[obN֐1o^ł܂B<br>
 * o^𕡐sꍇAɓo^ς݂̃R[obN֐A
 * ォo^R[obN֐ɂ㏑Ă܂܂B<br>
 * \sa CriAtomExVoiceEventCbFunc
 */
void CRIAPI criAtomEx_SetVoiceEventCallback(CriAtomExVoiceEventCbFunc func, void *obj);

/*JP
 * \brief {CX̗
 * \ingroup ATOMEXLIB_GLOBAL
 * \param[in]	func		{CXR[obN֐
 * \param[in]	obj			[UwIuWFNg
 * \par :
 * Đ̃{CX̏񋓂܂B<br>
 * <br>
 * {֐sƁA 1 i func j
 * ŃZbgꂽR[obN֐Đ̃{CX̐Ăяo܂B<br>
 * R[obN֐ɂ́AĐ̃{CXɊւڍ׏
 * CriAtomExVoiceInfoDetail \̂Ƃēn܂B<br>
 * \par l:
 *  2 i obj jɃZbgĺAR[obN֐̈Ƃēn܂B<br>
 * R[obN֐̂̑̈ɂẮA
 * ʓr ::CriAtomExVoiceInfoCbFunc ̐QƂB<br>
 * \attention
 * {֐œo^R[obNɂ́A
 * \ȃ{CX\[X{CX̏񂾂Ԃ܂B<br>
 * io[`ꂽ{CX͕̏Ԃ܂Bj<br>
 * \sa CriAtomExVoiceInfoCbFunc
 */
void CRIAPI criAtomEx_EnumerateVoiceInfos(CriAtomExVoiceInfoCbFunc func, void *obj);

/*JP
 * \brief {CX~ĎR[obN֐̓o^
 * \ingroup ATOMEXLIB_GLOBAL
 * \param[in]	func		{CX~ĎR[obN֐
 * \param[in]	obj			[UwIuWFNg
 * \par :
 * {CX̒~ĎR[obN֐̓o^܂B<br>
 * <br>
 * {֐sƁA 1 i func j
 * ŃZbgꂽR[obN֐ĎĂĐIDŔĂ{CX~ۂɌĂяo܂B<br>
 * R[obN֐ɂ́A~{CXɊւ
 * CriAtomExMonitoringVoiceStopInfo \̂Ƃēn܂B<br>
 * \par l:
 *  2 i obj jɃZbgĺAR[obN֐̈Ƃēn܂B<br>
 * R[obN֐̂̑̈ɂẮA
 * ʓr ::CriAtomExMonitoringVoiceStopCbFunc ̐QƂB<br>
 * ::criAtomEx_SetMonitoringVoiceStopPlaybackId ֐ɂĐݒ肵ĎĐIDɂčĐ̃L[A
 * ȉ̍\EݒꍇɃR[obN֐ɂĒʒmĐIDĎĐIDƂ͈قȂ邱Ƃ܂B<br>
 * ͍ĐɂɂĕʓrĐIDU邽߂ƂȂ܂B<br>
 * - L[NgpĂ<br>
 * - V[PX^CvgbNJڃ^CṽL[<br>
 * \sa CriAtomExMonitoringVoiceStopCbFunc, criAtomEx_SetMonitoringVoiceStopPlaybackId
 */
void CRIAPI criAtomEx_SetMonitoringVoiceStopCallback(CriAtomExMonitoringVoiceStopCbFunc func, void *obj);

/*JP
 * \brief {CX~ĎĐID̓o^
 * \ingroup ATOMEXLIB_GLOBAL
 * \param[in]	playback_id		{CX~ĎĐID
 * \par :
 * {CX̒~ĎĐIDo^܂B<br>
 * <br>
 * Ď\ȍĐID͂PłB<br>
 * ɍĐIDݒς݂̏ԂŖ{֐Ăяoꍇ́AĎĐID񂪏㏑܂B<br>
 * Ďs߂ɂ::criAtomEx_SetMonitoringVoiceStopCallback ֐Œʒms߂̃R[obN֐o^ĂB<br>
 * \par l:
 * ĎĐIDɂčĐ̃L[̃ANVgbNɂVKL[̍ĐsꂽꍇA
 * ̐VKL[̔{CXɂĂ̓{CX~̊ĎΏۂƂ͂Ȃ܂B<br>
 * ̓ANVɂĐJnAĂяoL[Ƃ̈ˑ֌WȂԂōs邽߂ƂȂ܂B<br>
 * ̂߁AANV̌ĂяoL[ƌĂяoL[̗蔭Ă{CX̒~𓯎ɊĎ邱Ƃ͏o܂B<br>
 * ANVɂčĐJnL[ĐID ::criAtomExPlayer_SetPlaybackEventCallback ֐ŃR[obN֐
 * o^Ď擾o܂BKXA擾EݒsĂB<br>
 * \sa criAtomEx_SetMonitoringVoiceStopCallback
 */
void CRIAPI criAtomEx_SetMonitoringVoiceStopPlaybackId(CriAtomExPlaybackId playback_id);


/*==========================================================================
 *      CRI AtomEx Sound Object API
 *=========================================================================*/
/*JP
 * \brief TEhIuWFNgp[N̈TCY̌vZ
 * \ingroup ATOMEXLIB_SOUND_OBJECT
 * \param[in]	config		TEhIuWFNg쐬pRtBO\
 * \return		CriSint32	[N̈TCY
 * \retval		0ȏ		ɏ
 * \retval		-1			G[
 * \par :
 * TEhIuWFNg쐬邽߂ɕKvȁA[N̈̃TCY擾܂B<br>
 * AP[^[o^ɃTEhIuWFNg쐬ꍇA
 * 炩ߖ{֐ŌvZ[N̈TCỸ
 * [N̈Ƃ ::criAtomExSoundObject_Create ֐ɃZbgKv܂B<br>
 * <br>
 * v[[̍쐬ɕKvȃ[ÑTCÝAv[[쐬pRtBO
 * \́i ::CriAtomExSoundObjectConfig j̓eɂĕω܂B<br>
 * <br>
 * NULLw肵ꍇAftHgݒ
 * i ::criAtomExSoundObject_SetDefaultConfig KpƓp[^[j
 * [N̈TCYvZ܂B
 * <br>
 * [N̈TCYvZɎsꍇA߂l -1 ɂȂ܂B<br>
 * [N̈TCY̌vZɎsRɂẮAG[R[obN
 * bZ[WŊmF\łB<br>
 * \par l:
 *  config ̏́A֐ł̂ݎQƂ܂B<br>
 * ֐𔲂͎QƂ܂̂ŁA֐s config ̗̈Ă
 * 肠܂B
 * \attention
 * {֐sOɁACuĂKv܂B<br>
 * \sa CriAtomExSoundObjectConfig, criAtomExSoundObject_Create
 */
CriSint32 CRIAPI criAtomExSoundObject_CalculateWorkSize(
	const CriAtomExSoundObjectConfig *config);

/*JP
 * \brief TEhIuWFNg̍쐬
 * \ingroup ATOMEXLIB_SOUND_OBJECT
 * \param[in]	config		TEhIuWFNg쐬pRtBO\
 * \param[in]	work		[N̈
 * \param[in]	work_size	[N̈TCY
 * \return		CriAtomExSoundObjectHn	TEhIuWFNgnh
 * \par :
 * TEhIuWFNg쐬܂B<br>
 * \sa CriAtomExSoundObjectConfig, criAtomExSoundObject_CalculateWorkSize,
 * CriAtomExSoundObjectHn, criAtomExSoundObject_Destroy
 */
CriAtomExSoundObjectHn CRIAPI criAtomExSoundObject_Create(
	const CriAtomExSoundObjectConfig *config, void *work, CriSint32 work_size);

/*JP
 * \brief TEhIuWFNg̔j
 * \ingroup ATOMEXLIB_SOUND_OBJECT
 * \param[in]	sound_object	TEhIuWFNg
 * \par :
 * TEhIuWFNgj܂B<br>
 * {֐s_ŁATEhIuWFNg쐬Ɋmۂꂽ\[XSĉ܂B<br>
 * ܂AɎw肵TEhIuWFNgnhɂȂ܂B<br>
 * \sa criAtomExSoundObject_Create, CriAtomExSoundObjectHn
 */
void CRIAPI criAtomExSoundObject_Destroy(CriAtomExSoundObjectHn sound_object);

/*JP
 * \brief AtomExv[[̒ǉ
 * \ingroup ATOMEXLIB_SOUND_OBJECT
 * \param[in]	sound_object	TEhIuWFNg
 * \param[in]	player			AtomExv[[
 * \par :
 * TEhIuWFNgAtomExv[[ǉ܂B<br>
 * ǉAtomExv[[̓TEhIuWFNgƊ֘AtA
 * TEhIuWFNgɂȉ̉e󂯂悤ɂȂ܂B<br>
 * - Cxg@\é͈iXR[vǰ
 * - ĐRg[i~A|[Yj
 * - p[^[Rg[
 * 
 * ǉAtomExv[[TEhIuWFNg폜ꍇ́A ::criAtomExSoundObject_DeletePlayer
 * ֐ĂяoĂB<br>
 * ΏۂAtomExv[[ɃTEhIuWFNgɒǉς݂̏ꍇ́AN܂B<br>
 * \attention
 * {֐̌ĂяóAǉ悤ƂĂAtomExv[[ŉĐĂȂԂōsĂB<br>
 * Xe[^X ::CRIATOMEXPLAYER_STATUS_STOP ł͂ȂAtomExv[[w肳ꂽꍇA
 * ǉ ::criAtomExPlayer_StopWithoutReleaseTime ֐ɂčĐ~s܂B
 * \sa criAtomExSoundObject_DeletePlayer, criAtomExSoundObject_DeleteAllPlayers
 */
void CRIAPI criAtomExSoundObject_AddPlayer(CriAtomExSoundObjectHn sound_object, CriAtomExPlayerHn player);

/*JP
 * \brief AtomExv[[̍폜
 * \ingroup ATOMEXLIB_SOUND_OBJECT
 * \param[in]	sound_object	TEhIuWFNg
 * \param[in]	player			AtomExv[[
 * \par :
 * TEhIuWFNgAtomExv[[폜܂B<br>
 * 폜AtomExv[[̓TEhIuWFNgƂ̊֘At؂A
 * TEhIuWFNgɂe󂯂ȂȂ܂B<br>
 * \attention
 * {֐̌ĂяóA폜悤ƂĂAtomExv[[ŉĐĂȂԂōsĂB<br>
 * Xe[^X ::CRIATOMEXPLAYER_STATUS_STOP ł͂ȂAtomExv[[w肳ꂽꍇA
 * 폜 ::criAtomExPlayer_StopWithoutReleaseTime ֐ɂčĐ~s܂B
 * \sa criAtomExSoundObject_AddPlayer, criAtomExSoundObject_DeleteAllPlayers
 */
void CRIAPI criAtomExSoundObject_DeletePlayer(CriAtomExSoundObjectHn sound_object, CriAtomExPlayerHn player);

/*JP
 * \brief SĂAtomExv[[̍폜
 * \ingroup ATOMEXLIB_SOUND_OBJECT
 * \param[in]	sound_object	TEhIuWFNg
 * \par :
 * TEhIuWFNgɊ֘AtĂSĂAtomExv[[폜܂B<br>
 * 폜AtomExv[[̓TEhIuWFNgƂ̊֘At؂A
 * TEhIuWFNgɂe󂯂ȂȂ܂B<br>
 * \attention
 * {֐̌ĂяóA폜悤ƂĂAtomExv[[ŉĐĂȂԂōsĂB<br>
 * Xe[^X ::CRIATOMEXPLAYER_STATUS_STOP ł͂ȂAtomExv[[܂܂ĂꍇA
 * 폜 ::criAtomExPlayer_StopWithoutReleaseTime ֐ɂčĐ~s܂B
 * \sa criAtomExSoundObject_AddPlayer, criAtomExSoundObject_DeletePlayer
 */
void CRIAPI criAtomExSoundObject_DeleteAllPlayers(CriAtomExSoundObjectHn sound_object);

/***************************************************************************
 *      bAPIigp͂Tj
 *      Tentative API (Please don't use it)
 ***************************************************************************/
/* ȉɐ錾Ă֐Atom̓pAQ[GWƂ̘Agɂ
 * bIɎgpĂAPIłB
 * ̃Abvf[gɂė\ȂύXE폜s邽߁Agp͂TB
 */
typedef void (CRIAPI *CriAtomExAcbReleasedCbFunc)(void *obj);
typedef enum CriAtomExResourceTypeTag {
	CRIATOMEX_INITIAL_RESOURCE = 0,
	CRIATOMEX_ADDITIONAL_RESOURCE
} CriAtomExResourceType;
typedef struct CriAtomExOutputPortInfoTag {
	const CriChar8* name;
	CriAtomExOutputPortType type;
	CriBool is_monaural_mix;
} CriAtomExOutputPortInfo;
void CRIAPI criAtomExAcb_ReleaseAsync(
	CriAtomExAcbHn acb_hn, CriAtomExAcbReleasedCbFunc func, void *obj);
void CRIAPI criAtomExAcb_AttachAwbHn(
	CriAtomExAcbHn acb_hn, CriAtomAwbHn awb_hn);
CriBool CRIAPI criAtomExPlayer_IsReadyToStartAsync(CriAtomExPlayerHn player);
CriBool CRIAPI criAtomExPlayer_StartAsync(CriAtomExPlayerHn player, CriAtomExPlaybackId *playback_id);
void CRIAPI criAtomExPlayer_StopAsync(CriAtomExPlayerHn player);
void CRIAPI criAtomExPlayer_UpdateAllAsync(CriAtomExPlayerHn player);
CriSint64 CRIAPI criAtomExPlayer_GetTimeReal(CriAtomExPlayerHn player);
CriSint64 CRIAPI criAtomExPlayback_GetTimeReal(CriAtomExPlaybackId id);
void CRIAPI criAtomExPlayback_EnumerateAtomPlayers(
	CriAtomExPlaybackId id, CriAtomPlayerCbFunc func, void* obj);
void CRIAPI criAtomExPlayback_EnumerateVoiceInfos(
	CriAtomExPlaybackId id, CriAtomExVoiceInfoCbFunc func, void* obj);
CriAtomExAcbHn CRIAPI criAtomExAcb_GetCurrentAcb(void);
CriBool CRIAPI criAtomExAcb_IsParameterPalletAssignedByName(CriAtomExAcbHn acb_hn, const CriChar8 *cue_name);
void CRIAPI criAtomEx3dSource_SetAttenuationDistanceSetting(CriAtomEx3dSourceHn ex_3d_source, CriBool sw);
CriBool CRIAPI criAtomEx3dSource_GetAttenuationDistanceSetting(const CriAtomEx3dSourceHn ex_3d_source);
CriBool CRIAPI criAtomExAcb_IsCompatibleWithAcf(CriAtomExAcbHn acb_hn);
CriBool CRIAPI criAtomEx3dRegion_IsDestroyable(CriAtomEx3dRegionHn ex_3d_region);
CriSint32 CRIAPI criAtomEx_CalculateResourceSize(const CriAtomExConfig *in_config);
void CRIAPI criAtomEx_AddResource(
	const CriAtomExConfig *in_config, void *work, CriSint32 work_size);
void CRIAPI criAtomEx_RemoveResource(void);
void CRIAPI criAtomExPlayer_SetResourceType(CriAtomExPlayerHn player, CriAtomExResourceType type);
CriSint16 CRIAPI criAtomExAcf_GetNumOutputPorts(void);
CriBool CRIAPI criAtomExAcf_GetOutputPortInfoByIndex(CriUint16 index, CriAtomExOutputPortInfo *info);
CriFloat32 CRIAPI criAtomExPlayback_GetAudioSyncedTimeScale(CriAtomExPlaybackId id);
void CRIAPI criAtomExPlayback_GetTimeAndScaleSyncedWithAudio(CriAtomExPlaybackId id, CriSint64* playback_time_ms, CriFloat32* time_scale);
void CRIAPI criAtomExPlayer_SetNextBlockIndex(CriAtomExPlayerHn player, CriAtomExBlockIndex index);
void CRIAPI criAtomExPlayer_SetAdditionalVoicePoolIdentifier(
	CriAtomExPlayerHn player, CriAtomExVoicePoolIdentifier identifier);
void CRIAPI criAtomExVoicePool_SetAdditionalIdentifier(
	CriAtomExVoicePoolHn pool, CriAtomExVoicePoolIdentifier identifier);
CriBool CRIAPI criAtomExVoicePool_GetIdentifier(CriAtomExVoicePoolHn pool, CriUint64* identifier);
CriBool CRIAPI criAtomExPlayer_GetAsrRackIdArray(CriAtomExPlayerHn player, CriSint32* rack_id_array, CriSint32 num_racks);
void CRIAPI criAtomExAcf_DoCreateSpatialAsrRack(CriBool do_create);
const CriChar8* CRIAPI criAtomExAcf_GetReactNameByIndex(CriUint16 index);
void CRIAPI criAtomExCategory_OverrideCueLimitById(const CriAtomExCategoryId id, CriSint32 num_limit);
void CRIAPI criAtomExCategory_OverrideCueLimitByName(const CriChar8* name, CriSint32 num_limit);
void CRIAPI criAtomExAcf_OverrideVoiceLimitForGroup(const CriSint32 group_index, CriSint32 num_limit);

#ifdef __cplusplus
}
#endif

/***************************************************************************
 *      o[WƂ̌݊p
 *      For compatibility with old version
 ***************************************************************************/
/**
 * \cond
 */

typedef CriAtomExConfig CriAtomExLibraryConfig;
typedef CriAtomExFormatInfo CriAtomExPlaybackFormatInfo;
typedef CriAtomExSourceType CriAtomExPlaybackSourceType;
typedef CriAtomExSourceInfo CriAtomExPlaybackSource;
typedef CriAtomExVoiceControlMethod CriAtomExControlMethod;
typedef CriAtomExVoiceAllocationMethod CriAtomExPlayerVoiceAllocationMethod;
typedef CriAtomExSequencerEventCbFunc CriAtomExSequencer_EventCbFunc;
typedef CriAtomExCurveType CriAtomExReactDuckerCurveType;
#define criAtomExPlayer_SetDefaultPlayerConfig(p_config)	\
	criAtomExPlayer_SetDefaultConfig(p_config)
#define criAtomExPlayer_SetPriority(player, priority)	\
	criAtomExPlayer_SetVoicePriority((player), (priority))
#define criAtomExPlayer_SetControlMethod(player, method)	\
	criAtomExPlayer_SetVoiceControlMethod((player), (method))
#define criAtomExPlayer_GetPlaybackStatus(player, id)	\
	criAtomExPlayback_GetStatus(id)
#define criAtomExVoicePool_SetDefaultHcaMxVoicePoolConfig(p_config)	\
	criAtomExVoicePool_SetDefaultConfigForHcaMxVoicePool(p_config)
#define criAtomEx_RegisterAcfFromConfig(config, work, work_size)	\
	criAtomEx_RegisterAcfConfig(config, work, work_size)
#define criAtomEx_CalculateWorkSizeForHcaMxVoicePool(p_config)	\
	criAtomExVoicePool_CalculateWorkSizeForHcaMxVoicePool(p_config)
#define criAtomEx_AllocateHcaMxVoicePool(p_config, work, work_size)	\
	criAtomExVoicePool_AllocateHcaMxVoicePool(p_config, work, work_size)
#define criAtomEx_FreeVoicePool(pool)	\
	criAtomExVoicePool_Free(pool)

#define criAtomExPlayer_SetAisacById(player, control_id, control_value) \
	criAtomExPlayer_SetAisacControlById(player, control_id, control_value)
#define criAtomExPlayer_SetAisacByName(player, control_name, control_value) \
	criAtomExPlayer_SetAisacControlByName(player, control_name, control_value)
#define criAtomExPlayer_SetPanSpread(player, spread) \
	criAtomExPlayer_SetWideness((player), (spread))
#define criAtomExPlayer_GetAisacById(player, control_id) \
	criAtomExPlayer_GetAisacControlById(player, control_id)
#define criAtomExPlayer_GetAisacByName(player, control_name) \
	criAtomExPlayer_GetAisacControlByName(player,control_name)
#define criAtomExPlayback_GetAisacById(playback_id, control_id, control_value) \
	criAtomExPlayback_GetAisacControlById(playback_id, control_id, control_value)
#define criAtomExPlayback_GetAisacByName(playback_id, control_name, control_value) \
	criAtomExPlayback_GetAisacControlByName(playback_id, control_name, control_value)
#define criAtomExCategory_SetAisacById(id, control_id, control_value) \
	criAtomExCategory_SetAisacControlById(id, control_id, control_value)
#define criAtomExCategory_SetAisacByName(name, control_name, control_value) \
	criAtomExCategory_SetAisacControlByName(name, control_name, control_value)
#define criAtomExPlayer_SetPan(player, ch, pan) \
	criAtomExPlayer_SetPanAdx1Compatible((player), (ch), (pan))
#define criAtomEx3dSource_SetListenerBasedAngleAisacControlId(ex_3d_source, aisac_control_id) \
	criAtomEx3dSource_SetListenerBasedAzimuthAngleAisacControlId((ex_3d_source), (aisac_control_id))
#define criAtomEx3dSource_SetSourceBasedAngleAisacControlId(ex_3d_source, aisac_control_id) \
	criAtomEx3dSource_SetSourceBasedAzimuthAngleAisacControlId((ex_3d_source), (aisac_control_id))
#define criAtomEx3dRegion_IsReadyToDestroy(ex_3d_region) \
	criAtomEx3dRegion_IsDestroyable((ex_3d_region))
/* _[̏oChݒɉāAŃ_E~bNX邽߉L֐͖ɂĂ܂ */
#define criAtomEx_SetDownmixMode(downmix_mode)

#define CRIATOMEX_VERSION					(0xFFFFFFFF)
#define CRIATOMEXPLAYBACK_STATUS_STOP		((CriAtomExPlaybackStatus)0)
#define CRIATOMEXPLAYBACK_STATUS_PLAYEND	(CRIATOMEXPLAYBACK_STATUS_REMOVED)
#define CRIATOMEXPLAYBACK_STATUS_ERROR		((CriAtomExPlaybackStatus)4)
#define CRIATOMEXPLAYBACK_SOURCE_TYPE_NONE			(CRIATOMEX_SOURCE_TYPE_NONE)
#define CRIATOMEXPLAYBACK_SOURCE_TYPE_CUE_ID		(CRIATOMEX_SOURCE_TYPE_CUE_ID)
#define CRIATOMEXPLAYBACK_SOURCE_TYPE_CUE_NAME		(CRIATOMEX_SOURCE_TYPE_CUE_NAME)
#define CRIATOMEXPLAYBACK_SOURCE_TYPE_CUE_INDEX		(CRIATOMEX_SOURCE_TYPE_CUE_INDEX)
#define CRIATOMEXPLAYBACK_SOURCE_TYPE_DATA			(CRIATOMEX_SOURCE_TYPE_DATA)
#define CRIATOMEXPLAYBACK_SOURCE_TYPE_FILE			(CRIATOMEX_SOURCE_TYPE_FILE)
#define CRIATOMEXPLAYBACK_SOURCE_TYPE_CONTENT_ID	(CRIATOMEX_SOURCE_TYPE_CONTENT_ID)
#define CRIATOMEXPLAYBACK_SOURCE_TYPE_WAVE_ID		(CRIATOMEX_SOURCE_TYPE_WAVE_ID)
#define CRIATOMEXPLAYER_ALLOCATE_VOICE_ONCE			(CRIATOMEX_ALLOCATE_VOICE_ONCE)
#define CRIATOMEXPLAYER_RETRY_VOICE_ALLOCATION		(CRIATOMEX_RETRY_VOICE_ALLOCATION)
#define CRIATOMEX_REACT_DUCKER_CURVE_TYPE_LINEAR				(CRIATOMEX_CURVE_TYPE_LINEAR)
#define CRIATOMEX_REACT_DUCKER_CURVE_TYPE_SQUARE				(CRIATOMEX_CURVE_TYPE_SQUARE)
#define CRIATOMEX_REACT_DUCKER_CURVE_TYPE_SQUARE_REVERSE		(CRIATOMEX_CURVE_TYPE_SQUARE_REVERSE)
#define CRIATOMEX_REACT_DUCKER_CURVE_TYPE_S						(CRIATOMEX_CURVE_TYPE_S)
#define CRIATOMEX_REACT_DUCKER_CURVE_TYPE_FLAT_AT_HALF			(CRIATOMEX_CURVE_TYPE_FLAT_AT_HALF)
#define CRIATOMEX_REACT_DUCKER_CURVE_TYPE_ENUM_SIZE_IS_4BYTES	(CRIATOMEX_CURVE_TYPE_ENUM_SIZE_IS_4BYTES)
#define CRIATOMEX_AISAC_GRAPH_TYPE_PAN_SPREAD			(CRIATOMEX_AISAC_GRAPH_TYPE_WIDENESS)
#define CRIATOMEX_MIXER_AISAC_GRAPH_TYPE_PAN_SPREAD		(CRIATOMEX_MIXER_AISAC_GRAPH_TYPE_WIDENESS)

#ifdef __cplusplus
extern "C" {
#endif
/*JP
 * \deprecated
 * 폜\̔񐄏APIłB
 */
#define criAtomEx_SetDefaultConfigForAcf(p_config)	\
{\
	(p_config)->num_groups = 0;\
	(p_config)->voices_per_group = NULL;\
	(p_config)->num_category_groups = 8;\
	(p_config)->num_categories = 64;\
}

/*JP
 * \deprecated
 * 폜\̔񐄏APIłB
 */
typedef struct CriAtomExAcfConfigTag {
	CriSint32 num_groups;				/*JP< {CX~bgO[v			*/
	const CriSint32 *voices_per_group;	/*JP< O[v̍ő哯	*/
	CriSint32 num_category_groups;		/*JP< JeSO[v				*/
	CriSint32 num_categories;			/*JP< JeS						*/
} CriAtomExAcfConfig;

/*JP
 * \deprecated
 * 폜\̔񐄏APIłB
 * ::criAtomExHcaMx_SetBusSendLevelByName ֐̎gpĂB
 */
void CRIAPI criAtomExHcaMx_SetBusSendLevel(
	CriSint32 mixer_id, CriSint32 bus_index, CriFloat32 level);

/*JP
 * \deprecated
 * 폜\̔񐄏APIłB
 * ::criAtomExPlayer_SetBusSendLevelByName ֐̎gpĂB
 */
void CRIAPI criAtomExPlayer_SetBusSendLevel(
	CriAtomExPlayerHn player, CriSint32 bus_index, CriFloat32 level);

/*JP
 * \deprecated
 * 폜\̔񐄏APIłB
 * ::criAtomExPlayer_SetBusSendLevelOffsetByName ֐̎gpĂB
 */
void CRIAPI criAtomExPlayer_SetBusSendLevelOffset(
	CriAtomExPlayerHn player, CriSint32 bus_index, CriFloat32 level_offset);

/*JP
 * \deprecated
 * 폜\̔񐄏APIłB
 * ::criAtomExDebug_GetResourcesInfo ֐̎gpĂB
 */
void CRIAPI criAtomEx_GetNumUsedVirtualVoices(CriSint32 *cur_num, CriSint32 *limit);

/*JP
 * \deprecated
 * 폜\̔񐄏APIłB
 * ::criAtomExDebug_GetResourcesInfo ֐̎gpĂB
 */
void CRIAPI criAtomEx_GetNumUsedSequences(CriSint32 *cur_num, CriSint32 *limit);

/*JP
 * \deprecated
 * 폜\̔񐄏APIłB
 * ::criAtomExDebug_GetResourcesInfo ֐̎gpĂB
 */
void CRIAPI criAtomEx_GetNumUsedSequenceTracks(CriSint32 *cur_num, CriSint32 *limit);

/*JP
 * \deprecated
 * 폜\̔񐄏APIłB
 * ::criAtomExDebug_GetResourcesInfo ֐̎gpĂB
 */
void CRIAPI criAtomEx_GetNumUsedSequenceTrackItems(CriSint32 *cur_num, CriSint32 *limit);

/*JP
 * \deprecated
 * 폜\̔񐄏APIłB
 * ::criAtomEx3dListener_SetDopplerMultiplier ֐̎gpĂB
 * Ɏw肷ldistance_factor̋tɕύXKv܂B
 */
void CRIAPI criAtomEx3dListener_SetDistanceFactor(CriAtomEx3dListenerHn ex_3d_listener, CriFloat32 distance_factor);

/*JP
 * \deprecated
 * 폜\̔񐄏APIłB
 * ĂяoĂʂ͂܂B
 */
void CRIAPI criAtomEx_GetNumUsedAisacAutoModulations(CriSint32 *cur_num, CriSint32 *limit);

/*JP
 * \deprecated
 * 폜\̔񐄏APIłB
 * ::criAtomEx3dSource_SetOrientation ֐̎gpĂB
 */
void CRIAPI criAtomEx3dSource_SetConeOrientation(CriAtomEx3dSourceHn ex_3d_source, const CriAtomExVector *cone_orient);

/*JP
 * \deprecated
 * 폜\̔񐄏APIłB
 * ĂяoĂʂ͂܂B
 */
CriSint32 CRIAPI criAtomEx_CalculateWorkSizeForRegisterAcfConfig(
	const CriAtomExAcfConfig *config);

/*JP
 * \deprecated
 * 폜\̔񐄏APIłB
 * ĂяoĂʂ͂܂B
 */
void CRIAPI criAtomEx_RegisterAcfConfig(
	const CriAtomExAcfConfig *config, void *work, CriSint32 work_size);

/*JP
 * \deprecated
 * 폜\̔񐄏APIłB
 * ĂяoĂʂ͂܂B
 */
void CRIAPI criAtomExPlayer_SetSequencePrepareTime(
	CriAtomExPlayerHn player, CriUint32 seq_prep_time_ms);

/*JP
 * \deprecated
 * 폜\̔񐄏APIłB
 * ::criAtomExAcf_GetDspFxName ֐̎gpĂB
 */
CriUint32 CRIAPI criAtomExAcf_GetDspFxType(CriUint16 index);

#ifdef __cplusplus
}
#endif

/**
 * \endcond
 */

#endif /* CRI_INCL_CRI_ATOM_EX_H */

/* --- end of file --- */
