/****************************************************************************
 *
 * CRI Middleware SDK
 *
 * Copyright (c) 2010-2015 CRI Middleware Co., Ltd.
 *
 * Library  : CRI Atom
 * Module   : Library User's Header for iOS
 * File     : cri_atom_ios.h
 *
 ****************************************************************************/
/*!
 *	\file		cri_atom_ios.h
 */

/* d`h~					*/
/* Prevention of redefinition	*/
#ifndef	CRI_INCL_CRI_ATOM_IOS_H
#define	CRI_INCL_CRI_ATOM_IOS_H

/***************************************************************************
 *      CN[ht@C
 *      Include files
 ***************************************************************************/
#include <cri_le_error.h>
#include <cri_le_atom.h>
#include <cri_le_atom_ex.h>
#include <cri_le_atom_asr.h>

/***************************************************************************
 *      萔}N
 *      Macro Constants
 ***************************************************************************/
/*==========================================================================
 *      CRI Atom API
 *=========================================================================*/
/*JP
 * \brief CupRtBO\̂ɃftHglZbg
 * \ingroup ATOMLIB_IOS
 * \param[out]	p_config	pRtBO\̂ւ̃|C^
 * \par :
 * ::criAtom_Initialize_IOS ֐ɐݒ肷RtBO\
 * i ::CriAtomConfig_IOS jɁAftHg̒lZbg܂B<br>
 * \attention
 * {}N͉ʃCAPIłB<br>
 * AtomExC̋@\𗘗pۂɂ́A{}N̑ 
 * ::criAtomEx_SetDefaultConfig_IOS }NpB
 * \sa CriAtomConfig_IOS
 */
#define criAtom_SetDefaultConfig_IOS(p_config)				\
{															\
	criAtom_SetDefaultConfig(&(p_config)->atom);			\
	criAtomExAsr_SetDefaultConfig(&(p_config)->asr);		\
    criAtomHcaMx_SetDefaultConfig(&(p_config)->hca_mx);		\
    (p_config)->buffering_time = 50;						\
    (p_config)->output_sampling_rate = CRIATOM_DEFAULT_OUTPUT_SAMPLING_RATE; \
}

/*==========================================================================
 *      CRI AtomEx API
 *=========================================================================*/
/*JP
 * \brief CupRtBO\̂ɃftHglZbg
 * \ingroup ATOMLIB_IOS
 * \param[out]	p_config	pRtBO\̂ւ̃|C^
 * \par :
 * ::criAtomEx_Initialize_IOS ֐ɐݒ肷RtBO\
 * i ::CriAtomExConfig_IOS jɁAftHg̒lZbg܂B<br>
 * \sa CriAtomExConfig_IOS
 */
#define criAtomEx_SetDefaultConfig_IOS(p_config)			\
{															\
	criAtomEx_SetDefaultConfig(&(p_config)->atom_ex);		\
	criAtomExAsr_SetDefaultConfig(&(p_config)->asr);		\
    criAtomExHcaMx_SetDefaultConfig(&(p_config)->hca_mx);	\
    (p_config)->buffering_time = 50;						\
    (p_config)->output_sampling_rate = CRIATOM_DEFAULT_OUTPUT_SAMPLING_RATE; \
}

/***************************************************************************
 *      }N
 *      Macro Functions
 ***************************************************************************/

/***************************************************************************
 *      f[^^錾
 *      Data Type Declarations
 ***************************************************************************/
/*==========================================================================
 *      CRI Atom API
 *=========================================================================*/
/*JP
 * \brief AtomCupRtBO\
 * \ingroup ATOMLIB_IOS
 * CRI AtomCu̓dlw肷邽߂̍\̂łB<br>
 * ::criAtom_Initialize_IOS ֐̈Ɏw肵܂B<br>
 * \attention
 * {\͉̂ʃCAPIłB<br>
 * AtomExC̋@\𗘗pۂɂ́A{\̂̑ 
 * ::CriAtomExConfig_IOS \̂pB
 * \sa criAtom_Initialize_IOS, criAtom_SetDefaultConfig_IOS
 */
typedef struct {
	CriAtomConfig			atom;		/* AtompRtBO\		*/
	CriAtomAsrConfig		asr;		/* ASRpRtBO			*/
	CriAtomHcaMxConfig		hca_mx;		/* HCA-MXpRtBO\		*/
	CriUint32				buffering_time;	/* o̓obt@O(P:msec)	*/
	CriSint32				output_sampling_rate;	/* o̓TvOg	*/
} CriAtomConfig_IOS;

/*==========================================================================
 *      CRI AtomEx API
 *=========================================================================*/
/*JP
 * \brief AtomCupRtBO\
 * \ingroup ATOMLIB_IOS
 * CRI AtomCu̓dlw肷邽߂̍\̂łB<br>
 * ::criAtomEx_Initialize_IOS ֐̈Ɏw肵܂B<br>
 * \sa criAtomEx_Initialize_IOS, criAtomEx_SetDefaultConfig_IOS
 */
typedef struct {
	CriAtomExConfig			atom_ex;	/* AtomExpRtBO\	*/
	CriAtomExAsrConfig		asr;		/* ASRpRtBO		*/
	CriAtomExHcaMxConfig	hca_mx;		/* HCA-MXpRtBO\	*/
	CriUint32				buffering_time;	/* o̓obt@O(P:msec)	*/
	CriSint32				output_sampling_rate;	/* o̓TvOg	*/
} CriAtomExConfig_IOS;

/***************************************************************************
 *      ϐ錾
 *      Prototype Variables
 ***************************************************************************/

/***************************************************************************
 *      ֐錾
 *      Prototype Functions
 ***************************************************************************/
#ifdef __cplusplus
extern "C" {
#endif

/*==========================================================================
 *      CRI Atom API
 *=========================================================================*/
/*JP
 * \brief Cup[N̈TCY̌vZ
 * \ingroup ATOMLIB_IOS
 * \param[in]	config		pRtBO\
 * \return		CriSint32	[N̈TCY
 * \par :
 * Cugp邽߂ɕKvȁA[N̈̃TCY擾܂B<br>
 * \par l:
 * CuKvƂ郏[N̈̃TCÝACupRtBO
 * \́i ::CriAtomConfig_IOS j̓eɂĕω܂B<br>
 * <br>
 *  config ̏́A֐ł̂ݎQƂ܂B<br>
 * ֐𔲂͎QƂ܂̂ŁA֐s config ̗̈Ă
 * 肠܂B
 * \attention
 * {֐͉ʃCAPIłB<br>
 * AtomExC̋@\𗘗pۂɂ́A{֐̑ 
 * ::criAtomEx_CalculateWorkSize_IOS ֐pB
 * \sa CriAtomConfig_IOS, criAtom_Initialize_IOS
 */
CriSint32 CRIAPI criAtom_CalculateWorkSize_IOS(const CriAtomConfig_IOS *config);

/*JP
 * \brief Cȕ
 * \ingroup ATOMLIB_IOS
 * \param[in]	config		pRtBO\
 * \param[in]	work		[N̈
 * \param[in]	work_size	[N̈TCY
 * \par :
 * Cu܂B<br>
 * Cű@\𗘗pɂ́AK̊֐sKv܂B<br>
 * iCű@\́A{֐sA ::criAtom_Finalize_IOS ֐s܂ł̊ԁA
 * p\łBj<br>
 * <br>
 * Cuۂɂ́ACuŗp邽߂̃̈i[N̈j
 * mۂKv܂B<br>
 * CuKvƂ郏[N̈̃TCÝApRtBO\̂̓eɉ
 * ω܂B<br>
 * [N̈TCY̌vZɂ́A ::criAtom_CalculateWorkSize_IOS 
 * ֐gpĂB<br>
 * \par l:
 * ::criAtom_SetUserAllocator }NgpăAP[^o^ς݂̏ꍇA
 * {֐Ƀ[N̈w肷Kv͂܂B<br>
 * i work  NULL A work_size  0 w肷邱ƂŁAo^ς݂̃AP[^
 * Kvȃ[N̈TCỸIɊmۂ܂Bj
 * <br>
 *  config ̏́A֐ł̂ݎQƂ܂B<br>
 * ֐𔲂͎QƂ܂̂ŁA֐s config ̗̈Ă
 * 肠܂B
 * \attention
 * {֐͓IɈȉ̊֐s܂B<br>
 * 	- ::criAtom_Initialize
 * 	- ::criAtomAsr_Initialize
 * 	- ::criAtomHcaMx_Initialize
 * 	.
 * {֐sꍇAL֐sȂłB<br>
 * <br>
 * {֐sAK΂ɂȂ ::criAtom_Finalize_IOS ֐sĂB<br>
 * ܂A ::criAtom_Finalize_IOS ֐s܂ł́A{֐ēxsȂłB<br>
 * <br>
 * {֐͉ʃCAPIłB<br>
 * AtomExC̋@\𗘗pۂɂ́A{֐̑ 
 * ::criAtomEx_Initialize_IOS ֐pB
 * \sa CriAtomConfig_IOS, criAtom_Finalize_IOS,
 * criAtom_SetUserAllocator, criAtom_CalculateWorkSize_IOS
 */
void CRIAPI criAtom_Initialize_IOS(
	const CriAtomConfig_IOS *config, void *work, CriSint32 work_size);

/*JP
 * \brief CȕI
 * \ingroup ATOMLIB_IOS
 * \par :
 * CuI܂B<br>
 * \attention
 * {֐͓IɈȉ̊֐s܂B<br>
 * 	- ::criAtom_Finalize
 * 	- ::criAtomAsr_Finalize
 * 	- ::criAtomHcaMx_Finalize
 * 	.
 * {֐sꍇAL֐sȂłB<br>
 * <br>
 * ::criAtom_Initialize_IOS ֐sOɖ{֐s邱Ƃ͂ł܂B<br>
 * <br>
 * {֐͉ʃCAPIłB<br>
 * AtomExC̋@\𗘗pۂɂ́A{֐̑ 
 * ::criAtomEx_Finalize_IOS ֐pB
 * \sa criAtom_Initialize_IOS
 */
void CRIAPI criAtom_Finalize_IOS(void);

/*JP
 * \brief T[oXbhvCIeB̐ݒ
 * \ingroup ATOMLIB_IOS
 * \param[in]	prio	Xbh̃vCIeB
 * \par :
 * CRIT[oXbh̃vCIeBݒ肵܂B<br>
 *  prio  pthread ̃vCIeBݒlƂĎgp܂B<br>
 * vCIeBݒl̓CXbh̑ΒlɂȂ܂B<br>
 * AvP[ṼCXbh(0)vCIeBw肵ĂB<br>
 * vCIeB̃ftHgl16łB<br>
 * \attention
 * ::criAtom_Initialize_IOS ֐sOɖ{֐s邱Ƃ͂ł܂B<br>
 * <br>
 * T[oXbh́ACRI File SystemCułpĂ܂B<br>
 * łCRI File SystemCuAPIŃT[oXbh̐ݒύXĂꍇ
 * {֐ɂݒ肪㏑܂̂łӂB<br>
 */
void CRIAPI criAtom_SetServerThreadPriority_IOS(int prio);

/*JP
 * \brief TEh̍ĊJ
 * \ingroup ATOMLIB_IOS
 * \par :
 * AudioSessionInterruption Callbak֐Ăяo߂̊֐łB<br>
 * TEhĊJ܂B<br>
 * {֐ĂяoOɁAAudioSessioñp[^ݒƃANeBxCgsĂB<br>
 * <br>
 * {֐͉ʃCAPIłB<br>
 * AtomExC̋@\𗘗pۂɂ́A{֐̑ 
 * ::criAtomEx_StartSound_IOS ֐pB
 * \attention
 * ::criAtom_Initialize_IOS ֐sOɖ{֐s邱Ƃ͂ł܂B<br>
 * \sa criAtom_StopSound_IOS
 */
void CRIAPI criAtom_StartSound_IOS(void);

/*JP
 * \brief TEh̒~
 * \ingroup ATOMLIB_IOS
 * \par :
 * AudioSessionInterruption Callbak֐Ăяo߂̊֐łB<br>
 * TEh~܂B<br>
 * <br>
 * {֐͉ʃCAPIłB<br>
 * AtomExC̋@\𗘗pۂɂ́A{֐̑ 
 * ::criAtomEx_StopSound_IOS ֐pB
 * \attention
 * ::criAtom_Initialize_IOS ֐sOɖ{֐s邱Ƃ͂ł܂B<br>
 * \sa criAtom_StartSound_IOS
 */
void CRIAPI criAtom_StopSound_IOS(void);

/*JP
 * \brief TEh̕
 * \ingroup ATOMLIB_IOS
 * \par :
 * AudioSessionAddPropertyListener Callback֐Ăяo߂̊֐łB<br>
 * Cũ{CX𕜋܂B<br>
 * iOS̃f[łmediaserverdSۂɂ́ACũ{CXȃ{CXɂȂA
 * ĐKvɂȂ܂B<br>
 * ̂悤ɁA{CX̕KvȍۂɌĂяoĂB<br>
 * <br>
 * {֐͉ʃCAPIłB<br>
 * AtomExC̋@\𗘗pۂɂ́A{֐̑ 
 * ::criAtomEx_RecoverSound_IOS ֐pB
 */
void CRIAPI criAtom_RecoverSound_IOS(void);

 /*JP
  * \brief TEh̏ɐۂ
  * \ingroup ATOMLIB_IOS
  * \par :
  * TEhCȕɐۂԂ֐łB<br>
  * iOSł́AAvobNOEhɂԂŃTEhCȕsꍇ
  * IAudioSession̏ɎsĂꍇ܂B<br>
  * {֐ŏsĂ邱ƂmFꍇ́AAvtHAOEhɂԂ
  * ēxCȕsA ::criAtom_RecoverSound_IOS p
  * TEh̕sKv܂B<br>
  * <br>
  * {֐͉ʃCAPIłB<br>
  * AtomExC̋@\𗘗pۂɂ́A{֐̑
  * ::criAtomEx_IsInitializationSucceeded_IOS ֐pB
  */
CriBool CRIAPI criAtom_IsInitializationSucceeded_IOS(void);

/*JP
 * \brief AudioSession̐ݒ
 * \ingroup ATOMLIB_IOS
 * \param[in]	config		RtBO\
 * \par :
 * RtBOɏ]AudioSession̐ݒs܂B<br>
 * ڍׂȐݒsꍇ͂̊֐ĂяoAAudioSession̊eAPIpĐݒ肵ĂB<br>
 */
void CRIAPI criAtom_SetupAudioSession_IOS(CriAtomAudioSessionConfig_IOS* config);

/*==========================================================================
 *      CRI Atom Player API
 *=========================================================================*/
/*JP
 * \brief MP3v[쐬p[N̈TCY̌vZ
 * \ingroup ATOMLIB_IOS
 * \param[in]	config		MP3v[쐬pRtBO\
 * \return		CriSint32	[N̈TCY
 * \par :
 * MP3Đpv[쐬邽߂ɕKvȁA[N̈̃TCY擾܂B<br>
 * \par l:
 * v[̍쐬ɕKvȃ[ÑTCÝAv[쐬pRtBO
 * \́i ::CriAtomMp3PlayerConfig_IOS j̓eɂĕω܂B<br>
 * <br>
 * NULLw肵ꍇAftHgݒ
 * i ::criAtomPlayer_SetDefaultConfigForMp3Player_IOS KpƓp[^j
 * [N̈TCYvZ܂B
 * <br>
 *  config ̏́A֐ł̂ݎQƂ܂B<br>
 * ֐𔲂͎QƂ܂̂ŁA֐s config ̗̈Ă
 * 肠܂B
 * \sa CriAtomMp3PlayerConfig_IOS, criAtomPlayer_CreateMp3Player_IOS
 */
CriSint32 CRIAPI criAtomPlayer_CalculateWorkSizeForMp3Player_IOS(
	const CriAtomMp3PlayerConfig_IOS *config);

/*JP
 * \brief MP3v[̍쐬
 * \ingroup ATOMLIB_IOS
 * \param[in]	config		MP3v[쐬pRtBO\
 * \param[in]	work		[N̈
 * \param[in]	work_size	[N̈TCY
 * \return		CriAtomPlayerHn	Atomv[nh
 * \par :
 * MP3Đ\ȃv[쐬܂B<br>
 * <br>
 * {֐͊A^̊֐łB<br>
 * Q[[v̉ʍXVKvȃ^C~OŖ{֐sƃ~bPʂ
 * ubNAt[鋰ꂪ܂B<br>
 * MP3v[̍쐬^j́AV[̐؂ւ蓙Aוϓeł
 * ^C~Oōs悤肢܂B<br>
 * \sa CriAtomMp3PlayerConfig_IOS, criAtomPlayer_CalculateWorkSizeForMp3Player_IOS,
 * criAtomPlayer_Destroy
 */
CriAtomPlayerHn CRIAPI criAtomPlayer_CreateMp3Player_IOS(
	const CriAtomMp3PlayerConfig_IOS *config, void *work, CriSint32 work_size);

/*==========================================================================
 *      CRI AtomEx API
 *=========================================================================*/
/*JP
 * \brief Cup[N̈TCY̌vZ
 * \ingroup ATOMLIB_IOS
 * \param[in]	config		pRtBO\
 * \return		CriSint32	[N̈TCY
 * \par :
 * Cugp邽߂ɕKvȁA[N̈̃TCY擾܂B<br>
 * \par l:
 * CuKvƂ郏[N̈̃TCÝACupRtBO
 * \́i ::CriAtomExConfig_IOS j̓eɂĕω܂B<br>
 * <br>
 *  config ̏́A֐ł̂ݎQƂ܂B<br>
 * ֐𔲂͎QƂ܂̂ŁA֐s config ̗̈Ă
 * 肠܂B
 * \attention
 * ::CriAtomExConfig_IOS \̂acf_infooɒlݒ肵ĂꍇA{֐͎s-1Ԃ܂B<br>
 * ACFf[^̓o^sꍇ́A{֐lgpmۂł͂ȂADXVXeɂ
 * AP[^gpmۏKvɂȂ܂B
 * \sa CriAtomExConfig_IOS, criAtomEx_Initialize_IOS
 */
CriSint32 CRIAPI criAtomEx_CalculateWorkSize_IOS(const CriAtomExConfig_IOS *config);

/*JP
 * \brief Cȕ
 * \ingroup ATOMLIB_IOS
 * \param[in]	config		pRtBO\
 * \param[in]	work		[N̈
 * \param[in]	work_size	[N̈TCY
 * \par :
 * Cu܂B<br>
 * Cű@\𗘗pɂ́AK̊֐sKv܂B<br>
 * iCű@\́A{֐sA ::criAtomEx_Finalize_IOS ֐s܂ł̊ԁA
 * p\łBj<br>
 * <br>
 * Cuۂɂ́ACuŗp邽߂̃̈i[N̈j
 * mۂKv܂B<br>
 * CuKvƂ郏[N̈̃TCÝApRtBO\̂̓eɉ
 * ω܂B<br>
 * [N̈TCY̌vZɂ́A ::criAtomEx_CalculateWorkSize_IOS 
 * ֐gpĂB<br>
 * \par l:
 * ::criAtomEx_SetUserAllocator }NgpăAP[^o^ς݂̏ꍇA
 * {֐Ƀ[N̈w肷Kv͂܂B<br>
 * i work  NULL A work_size  0 w肷邱ƂŁAo^ς݂̃AP[^
 * Kvȃ[N̈TCỸIɊmۂ܂Bj
 * <br>
 *  config ̏́A֐ł̂ݎQƂ܂B<br>
 * ֐𔲂͎QƂ܂̂ŁA֐s config ̗̈Ă
 * 肠܂B
 * \attention
 * {֐͓IɈȉ̊֐s܂B<br>
 * 	- ::criAtomEx_Initialize
 * 	- ::criAtomExAsr_Initialize
 * 	- ::criAtomExHcaMx_Initialize
 * 	.
 * {֐sꍇAL֐sȂłB<br>
 * <br>
 * {֐sAK΂ɂȂ ::criAtomEx_Finalize_IOS ֐sĂB<br>
 * ܂A ::criAtomEx_Finalize_IOS ֐s܂ł́A{֐ēxsȂłB<br>
 * \sa CriAtomExConfig_IOS, criAtomEx_Finalize_IOS,
 * criAtomEx_SetUserAllocator, criAtomEx_CalculateWorkSize_IOS
 */
void CRIAPI criAtomEx_Initialize_IOS(
	const CriAtomExConfig_IOS *config, void *work, CriSint32 work_size);

/*JP
 * \brief CȕI
 * \ingroup ATOMLIB_IOS
 * \par :
 * CuI܂B<br>
 * \attention
 * {֐͓IɈȉ̊֐s܂B<br>
 * 	- ::criAtomEx_Finalize
 * 	- ::criAtomExAsr_Finalize
 * 	- ::criAtomExHcaMx_Finalize
 * 	.
 * {֐sꍇAL֐sȂłB<br>
 * <br>
 * ::criAtomEx_Initialize_IOS ֐sOɖ{֐s邱Ƃ͂ł܂B<br>
 * \sa criAtomEx_Initialize_IOS
 */
void CRIAPI criAtomEx_Finalize_IOS(void);

/*JP
 * \brief T[oXbhvCIeB̐ݒ
 * \ingroup ATOMLIB_IOS
 * \param[in]	prio	Xbh̃vCIeB
 * \par :
 * CRIT[oXbh̃vCIeBݒ肵܂B<br>
 *  prio  pthread ̃vCIeBݒlƂĎgp܂B<br>
 * vCIeBݒl̓CXbh̑ΒlɂȂ܂B<br>
 * AvP[ṼCXbh(0)vCIeBw肵ĂB<br>
 * vCIeB̃ftHgl16łB<br>
 * \attention
 * ::criAtomEx_Initialize_IOS ֐sOɖ{֐s邱Ƃ͂ł܂B<br>
 * <br>
 * T[oXbh́ACRI File SystemCułpĂ܂B<br>
 * łCRI File SystemCuAPIŃT[oXbh̐ݒύXĂꍇ
 * {֐ɂݒ肪㏑܂̂łӂB<br>
 */
void CRIAPI criAtomEx_SetServerThreadPriority_IOS(int prio);

/*JP
 * \brief TEh̍ĊJ
 * \ingroup ATOMLIB_IOS
 * \par :
 * AudioSessionInterruption Callbak֐Ăяo߂̊֐łB<br>
 * TEhĊJ܂B<br>
 * {֐ĂяoOɁAAudioSessioñp[^ݒƃANeBxCgsĂB<br>
 * \par :
 * \code
 * // AudioSession Interruption Callbak
 * static void interruptionListenerCallback(void *inUserData, UInt32 interruptionState)
 * {
 * 	if (interruptionState == kAudioSessionBeginInterruption) {
 * 		// I[fBI̒~
 * 		criAtomEx_StopSound_IOS();
 * 	}
 * 	if (interruptionState == kAudioSessionEndInterruption) {
 * 		// AudioSessioñvpeBݒƃANeBxCg
 * 		setupAudioSession();
 * 		// I[fBI̊Jn
 * 		criAtomEx_StartSound_IOS();
 * 	}
 * }
 * // AudioSessioñvpeBݒƃANeBxCg
 * static void setupAudioSession(void)
 * {
 * 		:
 * }
 * \endcode
 * \attention
 * ::criAtomEx_Initialize_IOS ֐sOɖ{֐s邱Ƃ͂ł܂B<br>
 * \sa criAtomEx_StopSound_IOS
 */
void CRIAPI criAtomEx_StartSound_IOS(void);

/*JP
 * \brief TEh̒~
 * \ingroup ATOMLIB_IOS
 * \par :
 * AudioSessionInterruption Callbak֐Ăяo߂̊֐łB<br>
 * TEh~܂B<br>
 * \attention
 * ::criAtomEx_Initialize_IOS ֐sOɖ{֐s邱Ƃ͂ł܂B<br>
 * \sa criAtomEx_StartSound_IOS
 */
void CRIAPI criAtomEx_StopSound_IOS(void);

/*JP
 * \brief TEh̕
 * \ingroup ATOMLIB_IOS
 * \par :
 * AudioSessionAddPropertyListener Callback֐Ăяo߂̊֐łB<br>
 * Cũ{CX𕜋܂B<br>
 * iOS̃f[łmediaserverdSۂɂ́ACũ{CXȃ{CXɂȂA
 * ĐKvɂȂ܂B<br>
 * ̂悤ɁA{CX̕KvȍۂɌĂяoĂB<br>
 */
void CRIAPI criAtomEx_RecoverSound_IOS(void);

/*JP
 * \brief TEh̏ɐۂ
 * \ingroup ATOMLIB_IOS
 * \par :
 * TEhCȕɐۂԂ֐łB<br>
 * iOSł́AAvobNOEhɂԂŃTEhCȕsꍇ
 * IAudioSession̏ɎsĂꍇ܂B<br>
 * {֐ŏsĂ邱ƂmFꍇ́AAvtHAOEhɂԂ
 * ēxCȕsA ::criAtomEx_RecoverSound_IOS p
 * TEh̕sKv܂B<br>
 */
CriBool CRIAPI criAtomEx_IsInitializationSucceeded_IOS(void);

#ifdef __cplusplus
}
#endif

/***************************************************************************
 *      bAPIigp͂Tj
 *      Tentative API (Please don't use it)
 ***************************************************************************/
/* ȉɐ錾Ă֐Atom̓pAQ[GWƂ̘Agɂ
 * bIɎgpĂAPIłB
 * ̃Abvf[gɂė\ȂύXE폜s邽߁Agp͂TB
 */

/*JP
 * \brief obNOEhĐ̊Jn
 * \ingroup ATOMLIB_IOS
 * \par :
 * obNOEhĐ̊JnAtomCuɒʒm܂B
 */
void CRIAPI criAtomEx_EnableBackgroundPlayback_IOS(void);

/*JP
 * \brief obNOEhĐ̏I
 * \ingroup ATOMLIB_IOS
 * \par :
 * obNOEhĐ̏IAtomCuɒʒm܂B
 */
void CRIAPI criAtomEx_DisableBackgroundPlayback_IOS(void);

/*JP
 * \brief 荞݃tO̎擾
 * \ingroup ATOMLIB_IOS
 * \par :
 * Ovɂĉ̊荞݂AAtomCủ~ĂꍇCRI_TRUEԂ܂B<br>
 * CriAtomExConfig_IOS::use_handling_os_notificationsCRI_TRUEŏĂꍇA
 * AtomCủA܂BACRI_FALSEԂ܂B<br>
 * ::criAtomEx_EnableBackgroundPlayback_IOS ŃobNOEhĐLɂĂꍇA
 * A͖ɂȂ܂B𕜋Aꍇ::criAtomEx_ResumeAudio_IOSĂяoĉĊJĂB<br>
 */
CriBool CRIAPI criAtomEx_IsInterruptedOtherAudio_IOS(void);

/*JP
 * \brief ̍ĊJ
 * \ingroup ATOMLIB_IOS
 * \par :
 * obNOEhĐLɉ~ہA𕜋A܂B
 * ::criAtomEx_IsInterruptedOtherAudio_IOS CRI_TRUEԂ^C~Ô݌ʂ܂B
 */
void CRIAPI criAtomEx_ResumeAudio_IOS(void);

/***************************************************************************
 *      o[WƂ̌݊p
 *      For compatibility with old version
 ***************************************************************************/


#endif	/* CRI_INCL_CRI_ATOM_IOS_H */

/* --- end of file --- */
