﻿import sys
import os
import json
import shutil
import cri.atomcraft.debug as acdebug
import cri.atomcraft.project as acproject

# projectdir/temp/

project = acproject.get_child_objects(None, "Project")["data"]
print(project)
project_file_path = acproject.get_value(project[0], "ProjectFilePath")["data"];
import_audio_file_settings = os.path.dirname(project_file_path) + '/temp/import_audio_file_info.json'

if not os.path.isfile(import_audio_file_settings):
    acdebug.warning("not found json file")

json_load = None
json_open = open(import_audio_file_settings, 'r', encoding='utf-8')
#if json_open == None:
#    acdebug.warning("not json open")

try:
    json_load = json.load(json_open)
except Exception:
    pass

asset_message = json_load['ImportAudioFileMessage']
import_audio_file_infos = asset_message['ImportAudioFileSettings']

sync_material_list = []

for audio_file_info in import_audio_file_infos:
    file_path = audio_file_info['audioFilePath']
    file_name = os.path.basename(file_path)
    importMaterialOrcaPath = audio_file_info['importMaterialOrcaPath']
    sequenceCreationDestinationPath = audio_file_info['SequenceCreationDestinationPath']
    sequenceCreationDestinationPath = audio_file_info['SequenceCreationDestinationPath']
    SequenceCreationType =  audio_file_info['SequenceCreationType']

    dest_material = acproject.get_object_from_path(importMaterialOrcaPath + '/' + file_name)["data"]

    if not dest_material:
        dest_material_folder = acproject.get_object_from_path(importMaterialOrcaPath)["data"]
        material_folder_path = acproject.get_value(dest_material_folder, "SrcFileAbsolutePath")["data"]
        material_folder_path = material_folder_path + "/" + file_name;
        # remove audio file
        if os.path.isfile(material_folder_path):
           os.remove(material_folder_path)

        dest_material = acproject.register_material(dest_material_folder, file_path)["data"]
    else:
        regsted_audio_file_path = acproject.get_value(dest_material, "SrcFileAbsolutePath")["data"]
        if os.path.isfile(regsted_audio_file_path):
           os.remove(regsted_audio_file_path)

        shutil.copy(file_path,regsted_audio_file_path)
        sync_material_list.append(dest_material)

    # create sequence
    if sequenceCreationDestinationPath != "":
        sequence_name = os.path.splitext(file_name)[0]
        if SequenceCreationType == "Cue":
            # create cue
            dest_cuesheet = acproject.get_object_from_path(sequenceCreationDestinationPath)["data"]
            # acproject.create_simple_cue(dest_cuesheet, dest_material)
            cue = acproject.create_object(dest_cuesheet, "Cue", sequence_name)["data"]
            if cue != None:
                track = acproject.create_object(cue, "Track", sequence_name)["data"]
                waveform_region = acproject.create_waveform_region(track, dest_material)["data"]
        elif SequenceCreationType == "Track":
            # create track and waveformregion
            dest_cue = acproject.get_object_from_path(sequenceCreationDestinationPath)["data"]
            track = acproject.create_object(dest_cue, "Track", sequence_name)["data"]
            if track != None:
                waveform_region = acproject.create_waveform_region(track, dest_material)["data"]
        elif SequenceCreationType == "WaveformRegion":
            # create track and waveformregion
            dest_track = acproject.get_object_from_path(sequenceCreationDestinationPath)["data"]
            waveform_region = acproject.create_waveform_region(dest_track, dest_material)["data"]


if len(sync_material_list) > 0:
    acproject.sync_local_files(sync_material_list)
