# -*- coding: utf-8 -*-

#
# CRI Middleware SDK
# Copyright (c) 2019 CRI Middleware Co., Ltd.
#
import os
import json
from ctypes import *

libpath=os.path.dirname(__file__) + ("/CriAcApiClient.dll" if os.name == 'nt' else "/CriAcApiClient.dylib")
criacapimodule = CDLL(libpath)

criacapimodule.criAcApiClient_Initialize.restype = (c_int)
criacapimodule.criAcApiClient_Initialize.argtype = (None)

criacapimodule.criAcApiClient_Finalize.restype = (None)
criacapimodule.criAcApiClient_Finalize.argtype = (None)

criacapimodule.criAcApiClient_Connect.restype = (c_int)
criacapimodule.criAcApiClient_Connect.argtype = (c_char_p, c_ushort)

criacapimodule.criAcApiClient_GetStatus.restype = (c_int)
criacapimodule.criAcApiClient_GetStatus.argtype = (None)

criacapimodule.criAcApiClient_Disconnect.restype = (None)
criacapimodule.criAcApiClient_Disconnect.argtype = (None)

criacapimodule.criAcApiClient_Call.restype = (c_int)
criacapimodule.criAcApiClient_Call.argtype = (c_char_p, c_int)

criacapimodule.criAcApiClient_GetResponseBuffer.restype = (c_int)
criacapimodule.criAcApiClient_GetResponseBuffer.argtype = (c_char_p, c_int)

criacapimodule.criAcApiClient_GetResponseBufferLength.restype = (c_int)
criacapimodule.criAcApiClient_GetResponseBufferLength.argtype = (None)

def initialize():
    return criacapimodule.criAcApiClient_Initialize()

def finalize():
    criacapimodule.criAcApiClient_Finalize()

def connect(host_ip_address, port_number):
    return criacapimodule.criAcApiClient_Connect(host_ip_address.encode(), port_number)

def get_status():
    return criacapimodule.criAcApiClient_GetStatus()

def disconnect():
    return criacapimodule.criAcApiClient_Disconnect()

def call(request_json):
    criacapimodule.criAcApiClient_Call((request_json + '\0').encode(), len(request_json))
    response_buffer_length = 1 + criacapimodule.criAcApiClient_GetResponseBufferLength()
    response_buffer = create_string_buffer(response_buffer_length)
    received = criacapimodule.criAcApiClient_GetResponseBuffer(response_buffer, response_buffer_length)
    if received == 0:
        return response_buffer.value.decode()
    else:
        return ''
