#
# CRI Middleware SDK
# Copyright (c) 2019 CRI Middleware Co., Ltd.
#

import criatomcraft_api_lib
import json
from . import common
from . import error

ACAPIMODULE_PREVIEW = "preview"

def start_playback_cue(cue):
    arguments = {}
    arguments["cue"] = cue
    return common.call_api(ACAPIMODULE_PREVIEW, "start_playback_cue", arguments, False)

def stop_all():
    return common.call_api(ACAPIMODULE_PREVIEW, "stop_all", None, False)
    
def start_ingame_preview(target, ip_address):
    arguments = {}
    arguments["target_config_type"] = target
    arguments["ip_address"] = ip_address
    return common.call_api(ACAPIMODULE_PREVIEW, "start_ingame_preview", arguments, False)
    
def stop_ingame_preview():
    return common.call_api(ACAPIMODULE_PREVIEW, "stop_ingame_preview", None, False)

def get_playback_state(cue):
    arguments = {}
    arguments["cue"] = cue
    return common.call_api(ACAPIMODULE_PREVIEW, "get_playback_state", arguments, False)

