# CRI Middleware SDK
# Copyright (c) 2020 CRI Middleware Co., Ltd.
# CRI Atom Craft Robot Samples
# Version : 1.0.0
# 
# --Description:[ja]キュー名の重複確認
# --Description:[en]Check for overlapping Cue names
# --Description:[zh]检查重复的Cue名称

import csv
import os
import sys
import cri.atomcraft.debug as acdebug
import cri.atomcraft.project as acproject

# Get the selected CueSheets
cuesheets = acproject.get_selected_objects("CueSheet")["data"]

if not cuesheets:
    acdebug.warning("Please select a CueSheet.")
    sys.exit()

# Enumerate Cues from CueSheet
cuesheet = cuesheets[0]
cues = acproject.find_objects(cuesheet, "Cue")["data"]

# Make a double array of Cue names and Cues
cuename_cue_pairs = []
for cue in cues:
    cue_name = acproject.get_value(cue, "Name")["data"]
    cuename_cue_pairs.append([cue_name, cue])

# Sort by Cue name
cuename_cue_pairs.sort()

# -----Check for overlapping Cue names -----
cueheet_name = acproject.get_value(cuesheet, "Name")["data"]
acdebug.log("Start checking for overlapping Cue names in the CueSheet \"{0}\".".format(cueheet_name))

overlapping_cues = []

is_overlapped_prev_cue_name = False
for i in range(len(cuename_cue_pairs) - 1):
    if cuename_cue_pairs[i][0] == cuename_cue_pairs[i+1][0]:
        # Add if the name is the same as for the next Cue.
        overlapping_cues.append(cuename_cue_pairs[i])
        is_overlapped_prev_cue_name = True
    else:
        if is_overlapped_prev_cue_name:
            # Add if the name is the same as for the previous Cue.
            overlapping_cues.append(cuename_cue_pairs[i])
        is_overlapped_prev_cue_name = False

if is_overlapped_prev_cue_name:
    # Add if the name is the same as for the previous Cue.
    overlapping_cues.append(cuename_cue_pairs[-1])

if overlapping_cues:
    acdebug.log("These Cue names overlap.")
    project = acproject.get_child_objects(None, "Project")["data"][0]
    project_dir = os.path.dirname(acproject.get_value(project, "ProjectFilePath")["data"])
    csv_path = os.path.join(project_dir, cueheet_name + "check_overlapping_cue_name_result.csv")
    with open(csv_path, "w") as f:
        writer = csv.writer(f)
        writer.writerow(["Cue Name", "Path"])
        for cuename_cue_pair in overlapping_cues:
            path = acproject.get_object_path(cuename_cue_pair[1])["data"]
            acdebug.log("Cue Name: {0}, Path: {1}".format(cuename_cue_pair[0], path))
            writer.writerow([cuename_cue_pair[0], path])
    acdebug.log("Output the result to a file: {0}".format(csv_path))
else:
    acdebug.log("There were no overlapping Cue names.")

acdebug.log("The checking of overlapping Cue names is completed.")
