/****************************************************************************
 *
 * CRI Middleware SDK
 *
 * Copyright (c) 2006-2017 CRI Middleware Co., Ltd.
 *
 * Library  : CRI File System
 * Module   : Library User's Header
 * File     : cri_file_system.h
 *
 ****************************************************************************/
/*!
 *	\file		cri_file_system.h
 */

/* d`h~					*/
/* Prevention of redefinition	*/
#ifndef	CRI_FILE_SYSTEM_H_INCLUDED
#define	CRI_FILE_SYSTEM_H_INCLUDED

/***************************************************************************
 *      CN[ht@C
 *      Include files
 ***************************************************************************/
#include "cri_le_xpt.h"
#include "cri_le_error.h"

#ifdef __cplusplus
#if defined(XPT_TGT_TBCG)
#if !defined(XPT_DISABLE_FSV1API)
	/* o[WAPI */
	/* Old version API */
	#include "cri_file_system_ver1api.h"
#endif
#endif
#endif

/***************************************************************************
 *      萔}N
 *      Macro Constants
 ***************************************************************************/
/* o[W */
/* Version Number */
#define CRI_FS_VER_NAME		"CRI File System"
#define CRI_FS_VER_NUM		"2.88.15"
#define CRI_FS_VER_MAJOR	(2)
#define CRI_FS_VER_MINOR	(88)
#define CRI_FS_VER_PATCH	(15)
#define CRI_FS_VER_RELEASE	(0)
#define CRI_FS_VER_REVISION	(0)

/*JP
 * \brief RtBM[ṼftHgl
 */
#define	CRIFS_CONFIG_DEFAULT_THREAD_MODEL		CRIFS_THREAD_MODEL_MULTI
#define	CRIFS_CONFIG_DEFAULT_NUM_BINDERS		(16)
#define	CRIFS_CONFIG_DEFAULT_NUM_LOADERS		(16)
#define	CRIFS_CONFIG_DEFAULT_NUM_GROUP_LOADERS	(2)
#define	CRIFS_CONFIG_DEFAULT_NUM_STDIO_HANDLES	(16)
#define	CRIFS_CONFIG_DEFAULT_NUM_INSTALLERS		(0)
#define	CRIFS_CONFIG_DEFAULT_MAX_BINDS			(16)
#define	CRIFS_CONFIG_DEFAULT_MAX_FILES			(16)
#define	CRIFS_CONFIG_DEFAULT_MAX_PATH			(256)

/*JP
 * \brief ftHgfoCXID
 */
#define CRIFS_DEVICE_DEFAULT	(CRIFS_DEVICE_00)
/*JP
 * \brief t@CVXefoCXID
 */

/*JP
 * \brief ftHgfoCXID`
 * \par l:
 * ̒`͔p~\łB::CRIFS_DEVICE_DEFAULTgpĂB
 * \sa CRIFS_DEVICE_DEFAULT
 */
#define CRIFS_DEFAULT_DEVICE	(CRIFS_DEVICE_DEFAULT)

/*JP
 * \brief t@CpX̍ő咷
 * \ingroup FSLIB_CRIFS
 * \par :
 * t@CpX̍ő咷łBNULL܂݂܂B<br>
 * t@CpX̐l𒴉߂邱Ƃ͂܂B<br>
 * \attention
 * ̒ĺA傫Ȃ\܂B<br>
 * \sa criFs_AddressToPath
 */

/*JP
 * \brief ȃoChID
 * \ingroup FSLIB_BINDER
 * \par :
 * gpoC_[ɗ^IDłBoChɎsɂԂĂ邱Ƃ܂B<br>
 * \sa CriFsBindId, criFsBinder_BindCpk, criFsBinder_BindFile, criFsBinder_BindFiles, criFsBinder_BindDirectory
 */

/*JP
 * \brief LoChID̊Jnԍ
 * \ingroup FSLIB_BINDER
 * \par :
 * LȃoChID̊JnԍłB<br>
 * eoCh֐ŕԂIDID傫ΗLłB<br>
 * \sa CriFsBindId, criFsBinder_BindCpk, criFsBinder_BindFile, criFsBinder_BindFiles, criFsBinder_BindDirectory
 */

/***************************************************************************
 *      }N
 *      Macro Functions
 ***************************************************************************/
/*JP
 * \brief [U[AP[^[̓o^
 * \ingroup FSLIB_CRIFS
 * \param[in]	p_malloc_func	mۊ֐
 * \param[in]	p_free_func		֐
 * \param[in]	p_obj			[U[wIuWFNg
 * \par :
 * CRI File SystemCuɃAP[^[i̊mہ^֐jo^܂B<br>
 * CRI File SystemCuCuōsȂA
 * [U[Ǝ̃ɒuꍇɎgp܂B
 */
#define criFs_SetUserAllocator(p_malloc_func, p_free_func, p_obj)	\
{\
	criFs_SetUserMallocFunction(p_malloc_func, p_obj);\
	criFs_SetUserFreeFunction(p_free_func, p_obj);\
}

/***************************************************************************
 *      f[^^錾
 *      Data Type Declarations
 ***************************************************************************/
/*==========================================================================
 *      CRI File System API
 *=========================================================================*/
/*JP
 * \brief Xbhf
 * \par :
 * CRI File SystemCuǂ̂悤ȃXbhfœ삷邩\܂B<br>
 * Cui::criFs_InitializeLibrary ֐jɁA::CriFsConfig \̂ɂĎw肵܂B
 * \sa CriFsConfig
 * \sa criFs_InitializeLibrary
 */
typedef enum CriFsThreadModelTag {
	/*JP
	 * \brief }`Xbh
	 * \par :
	 * Cu͓ŃXbh쐬A}`Xbhɂē삵܂B<br>
	 * Xbh ::criFs_InitializeLibrary ֐Ăяoɍ쐬܂B
	 */
	/*EN
	 * \brief Multithread
	 * \par Description:
	 * The library creates threads inside and operates in multithread environment. <br>
	 * A thread is created when the ::criFs_InitializeLibrary function is called.
	 */
	CRIFS_THREAD_MODEL_MULTI = 0,

	/*JP
	 * \brief }`Xbhi[U[쓮j
	 * \par :
	 * Cu͓ŃXbh쐬A}`Xbhɂē삵܂B<br>
	 * Xbh ::criFs_InitializeLibrary ֐Ăяoɍ쐬܂B<br>
	 * T[o[͍̂쐬ꂽXbhŎs܂A
	 * CRIFS_THREAD_MODEL_MULTI Ƃ͈قȂAIɂ͎s܂B<br>
	 * [U[ ::criFs_ExecuteMain ֐ŖIɃT[o[쓮Kv܂B<br>
	 * i  ::criFs_ExecuteMain ֐sƁAXbhNAT[o[s܂Bj<br>
	 */
	CRIFS_THREAD_MODEL_MULTI_USER_DRIVEN = 3,

	/*JP
	 * \brief [U[}`Xbh
	 * \par :
	 * Cuł̓Xbh쐬܂񂪁A[U[Ǝɍ쐬XbhT[o[֐i::criFs_ExecuteFileAccess ֐A::criFs_ExecuteDataDecompression ֐jĂяo悤A̔r͍s܂B
	 */
	/*EN
	 * \brief User multithread
	 * \par Description:
	 * No thread is created but exclusion control is performed inside the library for the server processing functions (::criFs_ExecuteFileAccess, ::criFs_ExecuteDataDecompression) to be able to be called from a user-created thread.
	 */
	CRIFS_THREAD_MODEL_USER_MULTI = 1,

	/*JP
	 * \brief VOXbh
	 * \par :
	 * CuŃXbh쐬܂B܂A̔rs܂B<br>
	 * ̃fIꍇAeAPIƃT[o[֐i::criFs_ExecuteFileAccess ֐A::criFs_ExecuteDataDecompression ֐jƂ𓯈XbhĂяo悤ɂĂB
	 */
	/*EN
	 * \brief Single thread
	 * \par Description:
	 * No thread is created inside the library. Exclusion control is not performed inside the library either. <br>
	 * When selecting this model, call the APIs and server processing functions (::criFs_ExecuteFileAccess, ::criFs_ExecuteDataDecompression) from the same thread.
	 */
	CRIFS_THREAD_MODEL_SINGLE = 2,

	/* enum be 4bytes */
	CRIFS_THREAD_MODEL_ENUM_BE_SINT32 = 0x7FFFFFFF
} CriFsThreadModel;

/*JP
 * \brief RtBM[V
 * \par :
 * CRI File SystemCu̓dlw肷邽߂̍\̂łB<br>
 * Cui ::criFs_InitializeLibrary ֐jɈƂĖ{\̂w肵܂B<br>
 * \par
 * CRI File SystemCúAɎw肳ꂽRtBM[VɉāA\[XKvȐmۂ܂B<br>
 * ̂߁ARtBM[VɎw肷l邱ƂŁACuKvƂ郁̃TCY}邱Ƃ\łB<br>
 * ARtBM[VɎw肵ȏ̃nhmۂ邱Ƃ͂łȂȂ邽߁AlƁAnh̊mۂɎs\܂B<br>
 * \par l:
 * ftHgݒgpꍇA ::criFs_SetDefaultConfig ֐ŃftHgp[^ZbgA ::criFs_InitializeLibrary ֐Ɏw肵ĂB<br>
 * \attention
 * IɃo[\ɔAݒO::criFs_SetDefaultConfig ֐ŏĂgpĂB<br>
 * \sa criFs_InitializeLibrary, criFs_SetDefaultConfig
 */
typedef struct CriFsConfigTag {
	/*JP
		\brief Xbhf
		\par :
		CRI File System̃Xbhfw肵܂B<br>
		\sa CriFsThreadModel
	*/
	CriFsThreadModel thread_model;

	/*JP
		\brief gpCriFsBinder̐
		\par :
		AvP[VŎgpoC_[iCriFsBinderj̐w肵܂B<br>
		AvP[V ::criFsBinder_Create ֐gpăoC_[쐬ꍇA
		{p[^ɎgpoC_[̐w肷Kv܂B<br>
		<br>
		num_bindersɂ́uɎgpoC_[̍ő吔vw肵܂B<br>
		Ⴆ΁A ::criFsBinder_Create ֐ ::criFsBinder_Destroy ֐݂ɑĎsP[XɂẮA
		ő哯ɂ1̃oC_[gpȂ߁A֐̌Ăяo񐔂Ɋ֌WȂnum_binders1w肷邱Ƃ\łB<br>
		tɁAʂŃoC_[10gpꍇɂ́Ȃ̏ʂŃoC_[SgpȂꍇłĂA
		num_binders10w肷Kv܂B<br>
		\par l:
		CRI File SystemCúAgpoC_[̐̃ɗv܂B<br>
		̂߁Anum_bindersɕKvŏ̒lZbg邱ƂŁACuKvƂ郁̃TCY}邱Ƃ\łB<br>
		\sa criFsBinder_Create, criFsBinder_Destroy
	*/
	CriSint32 num_binders;

	/*JP
		\brief gpCriFsLoader̐
		\par :
		AvP[VŎgp郍[_[iCriFsLoaderj̐w肵܂B<br>
		AvP[V ::criFsLoader_Create ֐gpă[_[쐬ꍇA
		{p[^Ɏgp郍[_[̐w肷Kv܂B<br>
		<br>
		num_loadersɂ́uɎgp郍[_[̍ő吔vw肵܂B<br>
		Ⴆ΁A ::criFsLoader_Create ֐ ::criFsLoader_Destroy ֐݂ɑĎsP[XɂẮA
		ő哯ɂ1̃[_[gpȂ߁A֐̌Ăяo񐔂Ɋ֌WȂnum_loaders1w肷邱Ƃ\łB<br>
		tɁAʂŃ[_[10gpꍇɂ́Ȃ̏ʂŃ[_[SgpȂꍇłĂA
		num_loaders10w肷Kv܂B<br>
		\par l:
		CRI File SystemCúAgp郍[_[̐̃ɗv܂B<br>
		̂߁Anum_loadersɕKvŏ̒lZbg邱ƂŁACuKvƂ郁̃TCY}邱Ƃ\łB<br>
		\sa criFsLoader_Create, criFsLoader_Destroy
	*/
	CriSint32 num_loaders;

	/*JP
		\brief gpCriFsGroupLoader̐
		\par :
		AvP[VŎgpO[v[_[iCriFsGroupLoaderj̐w肵܂B<br>
		AvP[V ::criFsGroupLoader_Create ֐gpăO[v[_[쐬ꍇA
		{p[^ɎgpO[v[_[̐w肷Kv܂B<br>
		<br>
		num_group_loadersɂ́uɎgpO[v[_[̍ő吔vw肵܂B<br>
		Ⴆ΁A ::criFsGroupLoader_Create ֐ ::criFsGroupLoader_Destroy ֐݂ɑĎsP[XɂẮA
		ő哯ɂ1̃O[v[_[gpȂ߁A֐̌Ăяo񐔂Ɋ֌WȂnum_group_loaders1w肷邱Ƃ\łB<br>
		tɁAʂŃO[v[_[10gpꍇɂ́Ȃ̏ʂŃO[v[_[SgpȂꍇłĂA
		num_group_loaders10w肷Kv܂B<br>
		\par l:
		CRI File SystemCúAgpO[v[_[̐̃ɗv܂B<br>
		̂߁Anum_group_loadersɕKvŏ̒lZbg邱ƂŁACuKvƂ郁̃TCY}邱Ƃ\łB<br>
		\sa criFsGroupLoader_Create, criFsGroupLoader_Destroy
	*/
	CriSint32 num_group_loaders;

	/*JP
		\brief gpCriFsStdio̐
		\par :
		AvP[VŎgpCriFsStdionh̐w肵܂B<br>
		AvP[V ::criFsStdio_OpenFile ֐gpCriFsStdionh쐬ꍇA
		{p[^ɎgpCriFsStdionh̐w肷Kv܂B<br>
		<br>
		num_stdio_handlesɂ́uɎgpCriFsStdionh̍ő吔vw肵܂B<br>
		Ⴆ΁A ::criFsStdio_OpenFile ֐ ::criFsStdio_CloseFile ֐݂ɑĎsP[XɂẮA
		ő哯ɂ1CriFsStdionhgpȂ߁A֐̌Ăяo񐔂Ɋ֌WȂnum_stdio_handles1w肷邱Ƃ\łB<br>
		tɁAʂCriFsStdionh10gpꍇɂ́Ȃ̏ʂCriFsStdionhSgpȂꍇłĂA
		num_stdio_handles10w肷Kv܂B<br>
		\par l:
		CRI File SystemCúAgpCriFsStdionh̐̃ɗv܂B<br>
		̂߁Anum_stdio_handlesɕKvŏ̒lZbg邱ƂŁACuKvƂ郁̃TCY}邱Ƃ\łB<br>
		\attention
		ubWCugpADXCu~僉Cu𕹗pꍇA
		ADXTnhcriSsPlynh͓ICriFsStdionh쐬܂B<br>
		̂߁AubWCugpꍇɂ́ACRI File SystemCu
		num_stdio_handlesADXTnhcriSsPlynh̐lw肵ĂB<br>
		\sa criFsStdio_OpenFile, criFsStdio_CloseFile
	*/
	CriSint32 num_stdio_handles;

	/*JP
		\brief gpCriFsInstaller̐
		\par :
		AvP[VŎgpCXg[[iCriFsInstallerj̐w肵܂B<br>
		AvP[V criFsInstaller_Create ֐gpăCXg[[쐬ꍇA
		{p[^ɎgpCXg[[̐w肷Kv܂B<br>
		<br>
		num_installersɂ́uɎgpCXg[[̍ő吔vw肵܂B<br>
		Ⴆ΁A criFsInstaller_Create ֐ criFsInstaller_Destroy ֐݂ɑĎsP[XɂẮA
		ő哯ɂ1̃CXg[[gpȂ߁A֐̌Ăяo񐔂Ɋ֌WȂnum_installers1w肷邱Ƃ\łB<br>
		tɁAʂŃCXg[[10gpꍇɂ́Ȃ̏ʂŃCXg[[SgpȂꍇłĂA
		num_installers10w肷Kv܂B<br>
		\par l:
		CRI File SystemCúAgpCXg[[̐̃ɗv܂B<br>
		̂߁Anum_installersɕKvŏ̒lZbg邱ƂŁACuKvƂ郁̃TCY}邱Ƃ\łB<br>
		\attention
		::criFs_SetDefaultConfig }NgpăRtBM[VꍇAnum_installers̐0ɐݒ肳܂B<br>
		̂߁ACXg[[gpꍇɂ́AAvP[Vnum_installers𖾎IɎw肷Kv܂B<br>
	*/
	CriSint32 num_installers;

	/*JP
		\brief ő哯oCh
		\par :
		AvP[VŃoChsAێoChIDiCriFsBindIdj̐w肵܂B<br>
		AvP[V ::criFsBinder_BindCpk ֐gpăoChsꍇA
		{p[^ɎgpoChID̐w肷Kv܂B<br>
		<br>
		max_bindsɂ́uɎgpoChID̍ő吔vw肵܂B<br>
		Ⴆ΁A ::criFsBinder_BindCpk ֐ ::criFsBinder_Unbind ֐݂ɑĎsP[XɂẮA
		ő哯ɂ1̃oChIDgpȂ߁A֐̌Ăяo񐔂Ɋ֌WȂmax_binds1w肷邱Ƃ\łB<br>
		tɁAʂŃoChID10gpꍇɂ́Ȃ̏ʂŃoCh؍sȂꍇłĂA
		max_binds10w肷Kv܂B<br>
		\par l:
		CRI File SystemCúAgpoChID̐̃ɗv܂B<br>
		̂߁Amax_bindsɕKvŏ̒lZbg邱ƂŁACuKvƂ郁̃TCY}邱Ƃ\łB<br>
		\sa criFsBinder_BindCpk, criFsBinder_BindFile, criFsBinder_BindFiles, criFsBinder_BindDirectory, criFsBinder_Unbind
	*/
	CriSint32 max_binds;

	/*JP
		\brief ő哯I[vt@C
		\par :
		AvP[VŃI[vt@C̐w肵܂B<br>
		AvP[V ::criFsStdio_OpenFile ֐gpăt@CI[vꍇA
		{p[^ɃI[vt@C̐w肷Kv܂B<br>
		<br>
		max_filesɂ́uɃI[vt@C̍ő吔vw肵܂B<br>
		Ⴆ΁A ::criFsStdio_OpenFile ֐ ::criFsStdio_CloseFile ֐݂ɑĎsP[XɂẮA
		ő哯ɂ1̃t@CI[vȂ߁A֐̌Ăяo񐔂Ɋ֌WȂmax_files1w肷邱Ƃ\łB<br>
		tɁAʂŃt@C10I[vꍇɂ́Ȃ̏ʂŃt@C1I[vȂꍇłĂA
		max_files10w肷Kv܂B<br>
		\par ⑫:
		CRI File SystemCúAȉ̊֐sꍇɃt@CI[v܂B<br>
		## t@CI[v
		|֐					|l	|
		| --- | --- |
		|criFsBinder_BindCpk	|I[vt@C̐1B<br> criFsBinder_Unbind ֐s܂ł̊ԃt@C̓I[vꑱB	|
		|criFsBinder_BindFile	|I[vt@C̐1B<br> criFsBinder_Unbind ֐s܂ł̊ԃt@C̓I[vꑱB	|
		|criFsBinder_BindFiles	|XgɊ܂܂鐔t@CI[vB<br> criFsBinder_Unbind ֐s܂Ńt@C̓I[vꑱB	|
		|criFsLoader_Load		|I[vt@C̐1B<br> [h܂ł̊ԃt@C̓I[vꑱB<br> oC_[w肵ꍇAt@C̓I[vȂioC_[ɃI[vς݂̂߁jB	|
		|criFsStdio_OpenFile	|I[vt@C̐1B<br> criFsStdio_CloseFile ֐s܂ł̊ԃt@C̓I[vꑱB<br> oC_[w肵ꍇAt@C̓I[vȂioC_[ɃI[vς݂̂߁jB	|
		|criFsInstaller_Copy	|I[vt@C̐2B<br> t@CRs[܂ł̊ԃt@C̓I[vꑱB<br> oC_[w肵ꍇAI[vt@C1ɂȂi1oC_[ɃI[vς݂̂߁jB	|
		\attention
		ubWCugpADXCu~僉Cu𕹗pꍇA
		ADXTnhcriSsPlynh͓ICriFsStdionh쐬܂B<br>
		̂߁AubWCugpꍇɂ́ACRI File SystemCu
		max_filesADXTnhcriSsPlynh̐lw肵ĂB<br>
	*/
	CriSint32 max_files;

	/*JP
		\brief pX̍ő咷ioCgPʁj
		\par :
		AvP[VŎw肷t@CpX̍ő咷w肵܂B<br>
		AvP[V ::criFsLoader_Load ֐gpăt@CɃANZXꍇA
		{p[^ɃAvP[VŎgppX̍ő咷w肷Kv܂B<br>
		<br>
		max_pathɂ́ugppX̍ő吔vw肵܂B<br>
		ʂ256oCg̃t@CpXgpꍇȂ̏ʂ32oCg̃t@CpXgȂꍇłA
		max_pathɂ256w肷Kv܂B<br>
		\par l:
		pX̍ő咷ɂ́AI[NULL܂񂾐w肷Kv܂B<br>
		iu{PoCgv̒lw肷Kv܂Bj<br>
		\attention
		PCA[U[AvP[VRȏꏊɃCXg[\ȏꍇɂ́Az肳őTCY max_path Ɏw肷Kv܂̂ŁAӂB<br>
	*/
	CriSint32 max_path;

	/*JP
		\brief Cuo[Wԍ
		\par :
		CRI File SystemCũo[WԍłB<br>
		::criFs_SetDefaultConfig ֐ɂA{wb_[ɒ`Ăo[Wԍݒ肳܂B<br>
		\attention
		AvP[Vł́A̒lύXȂłB<br>
	*/
	CriUint32 version;

	/*JP
		\brief Cuo[W
		\par :
		CRI File SystemCũo[WłB<br>
		::criFs_SetDefaultConfig ֐ɂA{wb_[ɒ`Ăo[W񂪐ݒ肳܂B<br>
		\attention
		AvP[Vł́A̒lύXȂłB<br>
	 */
	const CriChar8 *version_string;

	/*JP
		\brief CPKt@CCRC`FbNsǂ
		\par :
		CPKt@CCRCgpAf[^`FbNsǂ؂ւtOłB<br>
		{tO CRI_TRUE ɐݒ肷ƁAȉ̃^C~OCRC`FbNs܂B
		 - CPKoChTOCCRC`FbN
		 - Rect@C[hɃRect@CPʂCRC`FbN
		CPKɕtꂽCRCƁAۂɓǂ݂񂾃f[^CRCvȂꍇAG[ƂȂ܂B
	 */
	CriBool enable_crc_check;
} CriFsConfig;

/*JP
 * \brief t@CI[vG[̃gC@
 */

/*JP
 * \brief t@C[hG[̃gC@
 */

/*JP
 * \brief ftHg̃pX؂蕶̐ݒ
 */

/*JP
 * \brief t@CI/O[h̐ݒ 
 */
typedef enum CriFsFileIoModeTag {
	CRIFS_FILE_IO_MODE_DEFAULT = 0,				/*JP< @ftHg̃t@CI/O[h */
	CRIFS_FILE_IO_MODE_SHARE_FILE_HANDLE = 1,	/*JP< t@CnhL */
	CRIFS_FILE_IO_MODE_OPEN_EVERY_TIME = 2,		/*JP< t@CANZXƂɃt@C̃I[vs */
	/* enum be 4bytes */
	CRIFS_FILE_IO_MODE_ENUM_BE_SINT32 = 0x7FFFFFFF
} CriFsFileIoMode;

/*JP
 * \brief mۊ֐
 * \ingroup FSLIB_CRIFS
 * \param[in]	obj		[U[wIuWFNg
 * \param[in]	size	vTCYioCgPʁj
 * \return		void*	mۂ̃AhXisNULLj
 * \par :
 * mۊ֐o^p̃C^[tFCXłB<br>
 * CRI File SystemCuCuōsȂmۏA
 * [U[Ǝ̃mۏɒuꍇɎgp܂B<br>
 * \par l:
 * R[obN֐sۂɂ́AsizeɕKvƂ郁̃TCYZbg
 * Ă܂B<br>
 * R[obN֐sizẽmۂAmۂ̃AhX
 * ߂lƂĕԂĂB<br>
 * A obj ɂ́A::criFs_SetUserMallocFunction ֐œo^[U[w
 * IuWFNgn܂B<br>
 * mێɃ}l[W[QƂKvꍇɂ́A
 * YIuWFNg ::criFs_SetUserMallocFunction ֐̈ɃZbgĂA
 * {R[obN֐̈oRĎQƂĂB<br>
 * \attention
 * ̊mۂɎsꍇAG[R[obNԂꂽAĂяo̊֐
 * s\܂̂łӂB
 * \sa CriFsFreeFunc, criFs_SetUserMallocFunction
 */
typedef void *(CRIAPI *CriFsMallocFunc)(void *obj, CriUint32 size);

/*JP
 * \brief ֐
 * \ingroup FSLIB_CRIFS
 * \param[in]	obj		[U[wIuWFNg
 * \param[in]	mem		郁AhX
 * \return				Ȃ
 * \par :
 * ֐o^p̃C^[tFCXłB<br>
 * CRI File SystemCuCuōsȂA
 * [U[Ǝ̃ɒuꍇɎgp܂B<br>
 * \par l:
 * R[obN֐sۂɂ́Amemɉׂ̃AhXZbg
 * Ă܂B<br>
 * R[obN֐mem̗̈̃ĂB
 * A obj ɂ́A::criFs_SetUserFreeFunction ֐œo^[U[w
 * IuWFNgn܂B<br>
 * mێɃ}l[W[QƂKvꍇɂ́A
 * YIuWFNg ::criFs_SetUserFreeFunction ֐̈ɃZbgĂA
 * {R[obN֐̈oRĎQƂĂB<br>
 * \sa criFsMallocFunc, criFs_SetUserFreeFunction
 */
typedef void (CRIAPI *CriFsFreeFunc)(void *obj, void *mem);


/*==========================================================================
 *      CriFsIo API
 *=========================================================================*/
/*JP
 * \brief foCXID
 */
/*EN
 * \brief Device ID
 */
typedef enum CriFsDeviceIdTag {
	CRIFS_DEVICE_00 = 0,	/*JP< ftHgfoCX */
	CRIFS_DEVICE_01,
	CRIFS_DEVICE_02,
	CRIFS_DEVICE_03,
	CRIFS_DEVICE_04,
	CRIFS_DEVICE_05,
	CRIFS_DEVICE_06,
	CRIFS_DEVICE_07,		/*JP<  */
	CRIFS_DEVICE_MAX,

	CRIFS_DEVICE_INVALID	= -1,	/*JP<  */

	/* enum be 4bytes */
	CRIFS_DEVICE_ENUM_BE_SINT32 = 0x7fffffff
} CriFsDeviceId;


/*JP
 * \brief t@CI[v[h
 */
/*EN
 * \brief File Opening Mode
 */
typedef enum {
	CRIFS_FILE_MODE_APPEND			= 0,	/*JP< t@CɒǋL								*/	/*EN< Appends to an existing file						*/
	CRIFS_FILE_MODE_CREATE			= 1,	/*JP< t@C̐VK쐬ĩt@C͏㏑j		*/	/*EN< Creates a new file always							*/
	CRIFS_FILE_MODE_CREATE_NEW		= 2,	/*JP< t@C̐VK쐬i㏑sj					*/	/*EN< Creates a new file (Can not overwrite)			*/
	CRIFS_FILE_MODE_OPEN			= 3,	/*JP< t@C̃I[v							*/	/*EN< Opens an existing file							*/
	CRIFS_FILE_MODE_OPEN_OR_CREATE	= 4,	/*JP< t@C̃I[vi݂Ȃꍇ͐VK쐬j	*/	/*EN< Opens a file if available (Or creates new file)	*/
	CRIFS_FILE_MODE_TRUNCATE		= 5,	/*JP< t@C0Byteɐ؂l߂ăI[v			*/	/*EN< Opens a file and truncates it						*/

	/* enum be 4bytes */
	CRIFS_FILE_MODE_ENUM_BE_SINT32 = 0x7FFFFFFF
} CriFsFileMode;

/*JP
 * \brief t@CANZX
 */
/*EN
 * \brief Kind of File Access
 */
typedef enum {
	CRIFS_FILE_ACCESS_READ			= 0,	/*JP< ǂݍ݂̂		*/	/*EN< Read Only			*/
	CRIFS_FILE_ACCESS_WRITE			= 1,	/*JP< ݂̂		*/	/*EN< Write Only		*/
	CRIFS_FILE_ACCESS_READ_WRITE	= 2,	/*JP< ǂݏ			*/	/*EN< Read and Write	*/

	/* enum be 4bytes */
	CRIFS_FILE_ACCESS_ENUM_BE_SINT32 = 0x7FFFFFFF
} CriFsFileAccess;

/*JP
 * \brief I/OC^[tFCX̃G[R[h
 */
/*JP
 * \brief Error of I/O Interface
 */
typedef enum {
	CRIFS_IO_ERROR_OK				=   0,	/*JP< G[Ȃ */
	CRIFS_IO_ERROR_NG				=  -1,	/*JP< ʃG[ */
	CRIFS_IO_ERROR_TRY_AGAIN		=  -2,	/*JP< gCׂ */

											/*  */
	CRIFS_IO_ERROR_NG_NO_ENTRY		= -11,	/*JP< ʃG[it@Cj */
	CRIFS_IO_ERROR_NG_INVALID_DATA	= -12,	/*JP< ʃG[if[^sj */

	/* enum be 4bytes */
	CRIFS_IO_ERROR_ENUM_BE_SINT32 = 0x7FFFFFFF
} CriFsIoError;

/*JP
 * \brief t@Cnh
 */
/*EN
 * \brief File Handle
 */
typedef void *CriFsFileHn;

/*JP
 * \brief I/OC^[tFCX
 */
/*EN
 * \brief I/O Interface
 */
typedef struct CriFsIoInterfaceTag {
	/*JP
	 * \brief t@C̗L̊mF
	 * \param[in]	path	t@C̃pX
	 * \param[out]	result	t@C݂邩ǂ
	 * \return	CriFsIoError	G[R[h
	 * \par :
	 * w肳ꂽt@C̗LmF֐łB<br>
	 * t@C݂ꍇ CRI_TRUE A
	 * ݂Ȃꍇ CRI_FALSE  result ɃZbgKv܂B<br>
	 */
	CriFsIoError (CRIAPI *Exists)(const CriChar8 *path, CriBool *result);

	/*JP
	 * \brief t@C̍폜
	 * \param[in]	path	t@C̃pX
	 * \return	CriFsIoError	G[R[h
	 * \par :
	 * w肳ꂽt@C폜֐łB<br>
	 * \par l:
	 * foCXŏ݂sȂȂꍇɂ́Å֐A
	 * \̂̃o[ CRI_NULL w肷邱Ƃ\łB<br>
	 */
	CriFsIoError (CRIAPI *Remove)(const CriChar8 *path);

	/*JP
	 * \brief t@C̕ύX
	 * \param[in]	old_path	l[Õt@C̃pX
	 * \param[in]	new_path	l[̃t@C̃pX
	 * \return	CriFsIoError	G[R[h
	 * \par :
	 * t@C̕ύXsȂ֐łB<br>
	 * old_path Ŏw肳ꂽt@CA new_path Ƀl[܂B<br>
	 * \par l:
	 * foCXŏ݂sȂȂꍇɂ́Å֐A
	 * \̂̃o[ CRI_NULL w肷邱Ƃ\łB<br>
	 */
	CriFsIoError (CRIAPI *Rename)(const CriChar8 *old_path, const CriChar8 *new_path);

	/*JP
	 * \brief t@C̃I[v
	 * \param[in]	path	t@C̃pX
	 * \param[in]	mode	t@CI[v[h
	 * \param[in]	access	t@CANZX
	 * \param[out]	filehn	t@Cnh
	 * \return	CriFsIoError	G[R[h
	 * \par :
	 * w肳ꂽt@CI[v֐łB<br>
	 * I[vɐꍇACriFsFileHn ^̃t@CnhԂKv܂B<br>
	 * \par ⑫:
	 * CriFsFileHn  void |C^[ƂĒ`Ă܂B<br>
	 * Ǝ̃t@C\̂`ÃAhX CriFsFileHn ^ɃLXgĕԂĂB<br>
	 * At@CI[vɃ̊mۂKvȏꍇɂ́A{֐œIɃ̊mۂsȂĂB<br>
	 * \attention
	 * ߂l̃G[R[hi CriFsIoError jɂ́A֐Ōps\ȃG[
	 * ꍇɌ CRIFS_IO_ERROR_NG ZbgĂB<br>
	 * it@C̃I[vɎsꍇłAAvP[Vŏp\ȏꍇɂ
	 * filehn  NULL ZbgACRIFS_IO_ERROR_OK ԂKv܂Bj<br>
	 * ܂AfBXN}҂̗RɂA֐sꂽ^C~OŃI[v
	 * słȂꍇAG[R[hƂ CRIFS_IO_ERROR_TRY_AGAIN ԂƂŁA
	 * 莞Ԍi10msjɍēxI[v蒼Ƃ\łB<br>
	 * i֐̎s^C~O摗肷邱Ƃ\łBj
	 */
	CriFsIoError (CRIAPI *Open)(
		const CriChar8 *path, CriFsFileMode mode, CriFsFileAccess access, CriFsFileHn *filehn);

	/*JP
	 * \brief t@C̃N[Y
	 * \param[in]	filehn	t@Cnh
	 * \return	CriFsIoError	G[R[h
	 * \par :
	 * w肳ꂽt@CnhN[Y֐łB<br>
	 * t@CI[vɓIɃ̊mۂsȂꍇ́AN[YɃĂB<br>
	 */
	CriFsIoError (CRIAPI *Close)(CriFsFileHn filehn);

	/*JP
	 * \brief t@CTCY̎擾
	 * \param[in]	filehn	t@Cnh
	 * \param[out]	file_size	t@CTCY
	 * \return	CriFsIoError	G[R[h
	 * \par :
	 * w肳ꂽt@CnhAYt@C̃TCY擾֐łB<br>
	 * \attention
	 * ̊֐̓CXbhォ璼ڎs\܂B<br>
	 * ̂߁Å֐̒ŒԏubN邱Ƃ͔Kv܂B<br>
	 * t@Cnht@CTCY擾̂ɎԂꍇɂ́A
	 * t@CI[vɂ炩߃t@CTCY擾it@Cnhɕێj
	 * ĂA{֐sɂ̒lԂ悤֐ĂB<br>
	 */
	CriFsIoError (CRIAPI *GetFileSize)(CriFsFileHn filehn, CriSint64 *file_size);

	/*JP
	 * \brief ǂݍ݂̊Jn
	 * \param[in]	filehn	t@Cnh
	 * \param[in]	offset	ǂݍ݊Jnʒu
	 * \param[in]	read_size	ǂݍ݃TCY
	 * \param[in]	buffer	ǂݍݐobt@[
	 * \param[in]	buffer_size	obt@[TCY
	 * \return	CriFsIoError	G[R[h
	 * \par :
	 * f[^̓ǂݍ݂Jn֐łB<br>
	 * offset Ŏw肳ꂽʒuA read_size Ŏw肳ꂽTCYf[^
	 * buffer ɓǂݍ݂܂B<br>
	 * ֐̃C^[tFCXƂĂ͔񓯊I/Oɂz肵Ă܂A
	 * XbhgpꍇiXbhf CRIFS_THREAD_MODEL_MULTI w肷ꍇj
	 * ɂ́Å֐𓯊I/OgĎĂ肠܂B<br>
	 * i֐Ńt@C̓ǂݍ݂܂ő҂Ă肠܂Bj<br>
	 * \attention
	 * ۂɓǂݍ߂TCÝA GetReadSize ֐ŕԂKv܂B<br>
	 * I/Oɂ{֐ꍇłAǂݍ߂TCY GetReadSize ֐
	 * s܂ŁAt@CnhɕێKv܂B<br>
	 */
	CriFsIoError (CRIAPI *Read)(CriFsFileHn filehn, CriSint64 offset, CriSint64 read_size, void *buffer, CriSint64 buffer_size);

	/*JP
	 * \brief ǂݍ݊`FbN
	 * \param[in]	filehn	t@Cnh
	 * \param[out]	result	t@C̓ǂݍ݂ǂ
	 * \return	CriFsIoError	G[R[h
	 * \par :
	 * t@C̓ǂݍ݂ǂmF֐łB<br>
	 * t@C̓ǂݍ݂ꍇ CRI_TRUE A
	 * ǂݍݓȑꍇ CRI_FALSE  result ɃZbgKv܂B<br>
	 * \attention
	 * result ɂ́A[h̐ۂɊ֌WȂA[h_
	 * ifoCXւ̃ANZXI_j CRI_TRUE ZbgKv܂B<br>
	 * [hG[ꍇłA result  CRI_TRUE ZbgA
	 * ֐̖߂l CRIFS_IO_ERROR_OK ԂĂB<br>
	 * i[hǂɂẮA GetReadSize ֐ŔʂĂ܂Bj<br>
	 * result  CRI_FALSE Ԃ́ACRI File System
	 * Cu͑̓ǂݍݗv؏܂B<br>
	 * i[hG[ result  CRI_FALSE ZbgꍇA
	 * t@C̃[hłȂȂAnh
	 * Destroy ֐珈AȂȂ\܂B<br>
	 */
	CriFsIoError (CRIAPI *IsReadComplete)(CriFsFileHn filehn, CriBool *result);

	/*JP
	 * \brief t@Cǂݍ݂̃LZs
	 * \param[in]	filehn	t@Cnh
	 * \return	CriFsIoError	G[R[h
	 * \par :
	 * foCX̃t@Cǂݍ݂ɑ΂ăLZ𔭍sAɕA֐łB
	 * ߂l CRIFS_IO_ERROR_OK ԂĂB<br>
	 * CRIFS_IO_ERROR_OKȊO̒lԂĂA
	 * CRI File System̓CRIFS_IO_ERROR_OKԂꍇƓłB<br>
	 */
	CriFsIoError (CRIAPI *CancelRead)(CriFsFileHn filehn);

	/*JP
	 * \brief ǂݍ݃TCY̎擾
	 * \param[in]	filehn	t@Cnh
	 * \param[out]	read_size	ǂݍ߂TCY
	 * \return	CriFsIoError	G[R[h
	 * \par :
	 * [hsȂʁAۂɃobt@[ɓǂݍ߂f[^̃TCYԂ֐łB<br>
	 * t@C̏I[ł́A Read ֐Ŏw肵TCỸf[^Kǂݍ߂Ƃ͌܂B<br>
	 * \attention
	 * [hG[ꍇA read_size  -1 ZbgA
	 * ֐̖߂l CRIFS_IO_ERROR_OK ԂĂB
	 */
	CriFsIoError (CRIAPI *GetReadSize)(CriFsFileHn filehn, CriSint64 *read_size);

	/*JP
	 * \brief ݂̊Jn
	 * \param[in]	filehn	t@Cnh
	 * \param[in]	offset	݊Jnʒu
	 * \param[in]	write_size	݃TCY
	 * \param[in]	buffer	ݐobt@[
	 * \param[in]	buffer_size	obt@[TCY
	 * \return	CriFsIoError	G[R[h
	 * \par :
	 * f[^݂̏Jn֐łB<br>
	 * offset Ŏw肳ꂽʒuA write_size Ŏw肳ꂽTCYf[^
	 * buffer 珑݂܂B<br>
	 * ֐̃C^[tFCXƂĂ͔񓯊I/Oɂz肵Ă܂A
	 * XbhgpꍇiXbhf CRIFS_THREAD_MODEL_MULTI w肷ꍇj
	 * ɂ́Å֐𓯊I/OgĎĂ肠܂B<br>
	 * i֐Ńt@C݂̏܂ő҂Ă肠܂Bj<br>
	 * \attention
	 * ۂɏ߂TCÝA GetWriteSize ֐ŕԂKv܂B<br>
	 * I/Oɂ{֐ꍇłA߂TCY GetWriteSize ֐
	 * s܂ŁAt@CnhɕێKv܂B<br>
	 * \par l:
	 * foCXŏ݂sȂȂꍇɂ́Å֐A
	 * \̂̃o[ CRI_NULL w肷邱Ƃ\łB<br>
	 */
	CriFsIoError (CRIAPI *Write)(CriFsFileHn filehn, CriSint64 offset, CriSint64 write_size, void *buffer, CriSint64 buffer_size);

	/*JP
	 * \brief ݊`FbN
	 * \param[in]	filehn	t@Cnh
	 * \param[out]	result	t@C݂̏ǂ
	 * \return	CriFsIoError	G[R[h
	 * \par :
	 * t@C݂̏ǂmF֐łB<br>
	 * t@C݂̏ꍇ CRI_TRUE A
	 * ݓȑꍇ CRI_FALSE  result ɃZbgKv܂B<br>
	 * \attention
	 * CgG[ꍇA result  CRI_TRUE ZbgA
	 * ֐̖߂l CRIFS_IO_ERROR_OK ԂĂB
	 * \par l:
	 * foCXŏ݂sȂȂꍇɂ́Å֐A
	 * \̂̃o[ CRI_NULL w肷邱Ƃ\łB<br>
	 * \attention
	 * result ɂ́ACg̐ۂɊ֌WȂACg_
	 * ifoCXւ̃ANZXI_j CRI_TRUE ZbgKv܂B<br>
	 * CgG[ꍇłA result  CRI_TRUE ZbgA
	 * ֐̖߂l CRIFS_IO_ERROR_OK ԂĂB<br>
	 * iCgǂɂẮA GetReadSize ֐ŔʂĂ܂Bj<br>
	 * result  CRI_FALSE Ԃ́ACRI File System
	 * Cu͑̓ǂݍݗv؏܂B<br>
	 * iCgG[ result  CRI_FALSE ZbgꍇA
	 * t@C̃[hłȂȂAnh
	 * Destroy ֐珈AȂȂ\܂B<br>
	 */
	CriFsIoError (CRIAPI *IsWriteComplete)(CriFsFileHn filehn, CriBool *result);

	/*JP
	 * \brief t@C݂̃LZs
	 * \param[in]	filehn	t@Cnh
	 * \return	CriFsIoError	G[R[h
	 * \par :
	 * foCX̃t@C݂ɑ΂ăLZ𔭍sAɕA֐łB
	 * ߂l CRIFS_IO_ERROR_OK ԂĂB<br>
	 * CRIFS_IO_ERROR_OKȊO̒lԂĂA
	 * CRI File System̓CRIFS_IO_ERROR_OKԂꍇƓłB<br>
	 */
	CriFsIoError (CRIAPI *CancelWrite)(CriFsFileHn filehn);

	/*JP
	 * \brief ݃TCY̎擾
	 * \param[in]	filehn	t@Cnh
	 * \param[out]	write_size	߂TCY
	 * \return	CriFsIoError	G[R[h
	 * \par :
	 * CgsȂʁAۂɃobt@[ɓǂݍ߂f[^̃TCYԂ֐łB<br>
	 * \attention
	 * CgG[ꍇA write_size  -1 ZbgA
	 * ֐̖߂l CRIFS_IO_ERROR_OK ԂĂB
	 * \par l:
	 * foCXŏ݂sȂȂꍇɂ́Å֐A
	 * \̂̃o[ CRI_NULL w肷邱Ƃ\łB<br>
	 */
	CriFsIoError (CRIAPI *GetWriteSize)(CriFsFileHn filehn, CriSint64 *write_size);

	/*JP
	 * \brief tbV̎s
	 * \param[in]	filehn	t@Cnh
	 * \return	CriFsIoError	G[R[h
	 * \par :
	 * ݗpɃobt@[OĂf[^A
	 * IɃfoCXɏos֐łB<br>
	 * i ANSI C W API ł fflush ֐ɑ鏈łBj<br>
	 * \par l:
	 * foCXŏ݂sȂȂꍇɂ́Å֐A
	 * \̂̃o[ CRI_NULL w肷邱Ƃ\łB<br>
	 */
	CriFsIoError (CRIAPI *Flush)(CriFsFileHn filehn);

	/*JP
	 * \brief t@CTCY̕ύX
	 * \param[in]	filehn	t@Cnh
	 * \param[out]	size	t@CTCY
	 * \return	CriFsIoError	G[R[h
	 * \par :
	 * t@C̃TCYw肵TCYɕύX֐łB<br>
	 * \par ⑫:
	 * {֐́ADMA]TCY̐ɂfoCXւ݂̏oCgPʂ
	 * sȂȂꍇɁAt@CTCY␳邽߂Ɏgp܂B<br>
	 * ̂߁A݂oCgPʂŉ\ȃfoCXɂẮÅ֐A
	 * \̂̃o[ CRI_NULL w肷邱Ƃ\łB<br>
	 * \par l:
	 * foCXŏ݂sȂȂꍇɂ́Å֐A
	 * \̂̃o[ CRI_NULL w肷邱Ƃ\łB<br>
	 */
	CriFsIoError (CRIAPI *Resize)(CriFsFileHn filehn, CriSint64 size);

	/*JP
	 * \brief lCeBut@Cnh̎擾
	 * \param[in]	filehn	t@Cnh
	 * \param[out]	native_filehn	lCeBũt@Cnh
	 * \return	CriFsIoError	G[R[h
	 * \par :
	 * vbgtH[SDKŗpt@C̃nh擾֐łB<br>
	 * Ⴆ΁A ANSI C W fopen ֐gpăt@CI[vꍇA
	 * native_filehn Ƃăt@C|C^[i FILE * jԂKv܂B<br>
	 * \par l:
	 * APLAYSTATION3ȊŐ@ł͂̊֐Kv͂܂B<br>
	 */
	CriFsIoError (CRIAPI *GetNativeFileHandle)(CriFsFileHn filehn, void **native_filehn);

	/*JP
	 * \brief ǂݍ݃vOXZR[obN̐ݒ
	 * \param[in]	filehn		t@Cnh
	 * \param[in]	callback    ǂݍ݃vOXZR[obN
	 * \param[in]	obj			IuWFNg
	 * \par :
	 * {֐́A::criFsLoader_GetProgress œiAPʓǂݍ݃TCY
	 * ׂxōXV邽߂́Aǂݍ݃vOXZR[obNݒ肷֐łB<br>
	 * {֐ȂꍇA{֐œnꂽR[obN֐gpȂꍇA
	 * ::criFsLoader_GetProgress œíA{IɒPʓǂݍ݃TCYɍXV܂B<br>
	 * {֐ꍇ́AnꂽR[obN֐ Read ֐ŌĂяoĂB
	 * ܂AĂяoۂɂ͑ objAɃւ̓ǂݍ݂TCY
	 * oCgPʂœnĂB<br>
	 * Ⴆ΁A[hvfoCX 8192byte ɕēǂݍޏꍇ́A
	 * 8192byte ̓ǂݍ݊ɁA 8192 nČĂяoĂB<br>
	 * ́Aǂݍ݃vOXZR[obNĂяoɂ ::criFsLoader_GetProgress
	 * œiXV܂BPʓǂݍ݃TCYׂxōXV
	 * sƂ ::criFsLoader_GetProgress œi̗xׂȂ܂B<br>
	 * \par l:
	 * ǂݍ݃NGXgׂxœǂݍݐi擾łȂꍇ́A
	 * 郁bg͂܂B
	 * \sa ::criFsLoader_GetProgress
	 */
	CriFsIoError (CRIAPI *SetAddReadProgressCallback)(CriFsFileHn filehn, void(*callback)(void*, CriSint32), void* obj);

	/*JP
	 * \brief ̓t@CANZXv\ǂ̖₢킹
	 * \param[out]	result	̓t@CANZXv\ǂ
	 * \par :
	 * I/OC^[tF[X̓t@CANZXv\ł邩ǂԂ֐łB<br>
	 * {֐ȂꍇAs\łƂ݂Ȃ܂B<br>
	 * {֐ĂāAresult  CRI_TRUE ꍇA
	 * criFsLoader ͌悭t@C̃[hs߂ɕŃ[hvs悤ɂȂ܂B<br>
	 * \par l:
	 * Ń[hvsꍇACriFsFileIoMode  CRIFS_FILE_IO_MODE_OPEN_EVERY_TIME łKv܂B
	 */
	CriFsIoError(CRIAPI *CanParallelRead)(CriBool *result);
} CriFsIoInterface, *CriFsIoInterfacePtr;

/*JP
 * \brief I/OIR[obN֐
 * \param[in]	path	t@C̃pX
 * \param[out]	device_id	foCXID
 * \param[out]	ioif	I/OC^[tFCX
 * \par :
 * I/OIR[obN֐́ACRI File SystemCuI/OA
 * [U[̓ƎI/OC^[tF[XŒuۂɎgp܂B<br>
 * ̓Iɂ́A[U[ ::CriFsSelectIoCbFunc ^̊֐A
 * ̊֐ ::criFs_SetSelectIoCallback ֐ɃZbgKv܂B<br>
 * ::CriFsSelectIoCbFunc ֐́A͂ꂽt@C̃pXipathj͂A
 * ̃t@C݂foCXIDidevice_idjƁA
 * foCXɃANZX邽߂I/OC^[tFCXiioifjԂKv܂B<br>
 * \par ⑫:
 * CuftHgԂŗpI/OC^[tFCX́A ::criFs_GetDefaultIoInterface ֐Ŏ擾\łB<br>
 * ̃t@Ĉ݂ƎI/OC^[tFCXꍇɂ́A
 * ̃t@CS ::criFs_GetDefaultIoInterface ֐Ŏ擾I/OC^[tFCXŏĂB<br>
 * \code
 * CriError
 * \endcode
 * \sa criFs_SetSelectIoCallback, criFs_GetDefaultIoInterface
 */
typedef CriError (CRIAPI *CriFsSelectIoCbFunc)(const CriChar8 *path, CriFsDeviceId *device_id, CriFsIoInterfacePtr *ioif);

/*==========================================================================
 *      CriFsBinder API
 *=========================================================================*/
struct CriFsBinderHnObjTag;
/*JP
 * \brief CriFsBindernh
 * \ingroup FSLIB_BINDER
 * \par F
 * oC_[Ƃ́At@Cǂ߂̃f[^x[XłB<br>
 * - CriFsBinderHn (oC_[nh)ƃoCh<br>
 * oC_[𗘗pɂ́AoC_[nh( CriFsBinderHn )쐬A
 * CPKt@C^t@C^fBNgoC_[Ɍт܂B
 * ̃oC_[ւ̌ѕtoChƌĂт܂B<br>
 * oC_[쐬ƁAoC_[nh( CriFsBinderHn )擾܂B<br>
 * - CriFsBindId ioChIDj<br>
 * oC_[ɃoChsƁAoChID쐬܂BX̃oChʂ邽߂Ɏgp܂B<br>
 * - t@C̃oChƃAoCh<br>
 * oC_[ɂ́ACPKt@Ct@CAfBNgǂ̂悤ȑgݍ킹łłoChł܂B<br>
 * oChڂ̃oChԂ邱ƂAoChƌĂт܂B<br>
 * - płoCh<br>
 * 쐬łoC_[⓯ɃoChłő吔́A CriFsConfig 
 * num_binders (oC_[) max_binds (oCh\ȍő吔)Ŏw肵܂B<br>
 * - CPKt@C̃oCh<br>
 * CPKt@CɎ[ĂX̃t@CiRect@CjɃANZXɂ́A
 * CPKt@CoChKv܂B<br>
 * CPKt@C̃Rect@CoChł܂BCPKt@CAoChꍇA
 * oChĂRect@CAoCh܂iÖٓIAoChjB<br>
 * - oC_[̃vCIeB<br>
 * oC_[́AړĨt@Cǂ̃oChIDɂ̂܂B<br>
 * ̃oChIĎ́A{Iɂ̓oChꂽԂɂȂ܂AoChID̃vCIeB
 * 삷邱ƂŁAύX邱Ƃł܂B<br>
 * - oC_[CriFsAPI<br>
 * CriFsLoader, CriFsGroupLoader, CriFsBinderɂ́AoC_[ɎAPI܂B
 * ̍ۂɂ́A CriFsBinderHn  CriFsBindId Aǂw肷̂ɒӂĂB
 */
typedef struct CriFsBinderHnObjTag *CriFsBinderHn;

/*JP
 * \brief CriFsBinder ID
 * \ingroup FSLIB_BINDER
 * \par F
 * oC_[ɑ΂ăoChsƁA CriFsBindId (oChID)쐬܂B<br>
 * oChID́AX̃oChʂ邽߂̂̂ŁAl͕Ȃ32rbgl͈̔͂
 * Ƃ܂B<br>
 * ̌^̕ϐ́AȃoChIDł邱ƂӖʒl CRIFSBINDER_BID_NULL ([)
 * Ƃꍇ܂B<br>
 */
typedef CriUint32 CriFsBindId;

/*JP
 * \brief t@C\
 * \ingroup FSLIB_BINDER
 * \par F
 * criFsBinder_Find(ById) ֐̏o͏łB
 * t@CɃANZX邽߂̏i[܂B<br>
 * CPKt@C̃Rect@CłꍇApathCPKt@CAoffsetCPKt@C
 * 擪̃ItZbgʒuƂȂ܂B<br>
 * \sa criFsBinder_Find(), criFsBinder_FindById()
 */
typedef struct CriFsBinderFileInfoTag {
	CriFsFileHn filehn;		/*JP< t@Cnh */
	CriChar8 *path;			/*JP< pX */
	CriSint64 offset;		/*JP< t@C̐擪̃ItZbgʒu */
	CriSint64 read_size;   	/*JP< ǍTCYikt@CTCYj */
	CriSint64 extract_size;	/*JP< WJTCYĩt@CTCYA񈳏kȂread_sizeƓlj */
	CriFsBindId binderid;	/*JP< oChIDiǂ̃oCh悩猩j */
	CriUint32 reserved[1];	/*JP< \̈ */
} CriFsBinderFileInfo;

/*JP
 * \brief oC_[Xe[^X
 * \ingroup FSLIB_BINDER
 * \par F
 * criFsBinder_GetStatus ֐Ŏ擾AoChID̏ԂłB<br>
 * oCh܂ŁAoChڂɃANZX邱Ƃ͂ł܂B<br>
 * oChΏۂ݂ȂAoChɕKvȃ\[Xsꍇ́A
 * oChsƂȂ܂B<br>
 * oChs̏ڂ̓G[R[obN֐Ŏ擾ĂB
 * \sa criFsBinder_GetStatus()
 */
typedef enum {
	CRIFSBINDER_STATUS_NONE = 0,
	CRIFSBINDER_STATUS_ANALYZE,		/*JP< oCh */
	CRIFSBINDER_STATUS_COMPLETE,	/*JP< oCh */
	CRIFSBINDER_STATUS_UNBIND,		/*JP< AoCh */
	CRIFSBINDER_STATUS_REMOVED,		/*JP< AoCh */
	CRIFSBINDER_STATUS_INVALID,		/*JP< oCh */
	CRIFSBINDER_STATUS_ERROR,		/*JP< oChs */

	/* enum be 4bytes */
	CRIFSBINDER_STATUS_ENUM_BE_SINT32 = 0x7FFFFFFF
} CriFsBinderStatus;
/*==========================================================================
 *      CriFsLoader API
 *=========================================================================*/
struct CriFsLoaderObjTag;
/*JP
 * \brief CriFsLoadernh
 */
typedef struct CriFsLoaderObjTag *CriFsLoaderHn;



/*JP
 * \brief [hXe[^X
 */
/*EN
 * \brief Loading Status
 */

/*JP
 * \brief [_[vCIeB
 */
/*EN
 * \brief Priority
 */
typedef enum {
	CRIFSLOADER_PRIORITY_HIGHEST 		= 2,	/*JP< ō		*/	/*EN< Highest		*/
	CRIFSLOADER_PRIORITY_ABOVE_NORMAL 	= 1,	/*JP< 		*/	/*EN< Above normal	*/
	CRIFSLOADER_PRIORITY_NORMAL 		= 0,	/*JP< 		*/	/*EN< Normal		*/
	CRIFSLOADER_PRIORITY_BELOW_NORMAL 	= -1,	/*JP< 		*/	/*EN< Below normal	*/
	CRIFSLOADER_PRIORITY_LOWEST 		= -2,	/*JP< Œ		*/	/*EN< Lowest		*/
	/* enum be 4bytes */
	CRIFSLOADER_PRIORITY_ENUM_BE_SINT32 = 0x7FFFFFFF
} CriFsLoaderPriority;

/*==========================================================================
 *      Group Loader API
 *=========================================================================*/



/*==========================================================================
 *      Log Output API
 *=========================================================================*/
/*JP
 * \brief ANZXOo̓[h
 */


/*==========================================================================
 *      CriFsStdio API
 *=========================================================================*/
/*JP
 * \brief CriFsStdionh
 */
struct CriFsStdioObjTag;
typedef struct CriFsStdioObjTag *CriFsStdioHn;

/*JP
 * \brief t@C̃V[NJnʒu
 */
typedef enum {
	CRIFSSTDIO_SEEK_SET = 0, /*JP< t@C̐擪 */
	CRIFSSTDIO_SEEK_CUR = 1, /*JP< ݂̓Ǎʒu */
	CRIFSSTDIO_SEEK_END = 2, /*JP< t@C̏I[ */
	/* enum be 4bytes */
	CRIFSSTDIO_SEEK_ENUM_BE_SINT32 = 0x7FFFFFFF
} CRIFSSTDIO_SEEK_TYPE;

/*JP
 * \brief t@C폜
 */


/*==========================================================================
 *      Load Limiter API
 *=========================================================================*/

/***************************************************************************
 *      ϐ錾
 *      Prototype Variables
 ***************************************************************************/

/***************************************************************************
 *      ֐錾
 *      Prototype Functions
 ***************************************************************************/
#ifdef __cplusplus
extern "C" {
#endif

/*==========================================================================
 *      CRI File System API
 *=========================================================================*/
/*JP
 * \brief ftHgRtBM[ṼZbg
 * \ingroup FSLIB_CRIFS
 * \param[in]	p_config	RtBM[V
 * \par :
 * ::criFs_InitializeLibrary ֐ɐݒ肷RtBM[Vi ::CriFsConfig jɁAftHg̒lZbg܂B<br>
 * \par ⑫:
 * RtBM[Vɐݒ肷ep[^AAvP[VŎgpnh̐ɉĒ߂邱ƂŁA
 * CuKvƂ郁TCY}邱Ƃ\łB<br>
 * AAvP[VŎgpnh̐młȂJiKATCY^Cgł͂ȂP[Xł́A
 * {}Ngp邱ƂɂŁAȗ邱Ƃ\łB<br>
 * \attention:
 * {}Nł́AقƂǂ̃P[XŕKv[Ȑ̃nhmۂł悤ARtBM[V̊ep[^ɑ傫߂̒lZbg܂B<br>
 * ̂߁A{}NgpꍇACuKvƂ郏[N̈̃TCY͑傫Ȃ܂̂ŁAӂB<br>
 * iTCY^CgȃP[Xł́A{}NŃRtBM[VAep[^ʂɒ߂邱ƂIXX܂Bj<br>
 * \sa
 * CriFsConfig
*/
#define criFs_SetDefaultConfig(p_config)	\
{\
	(p_config)->thread_model		= CRIFS_CONFIG_DEFAULT_THREAD_MODEL;\
	(p_config)->num_binders			= CRIFS_CONFIG_DEFAULT_NUM_BINDERS;\
	(p_config)->num_loaders			= CRIFS_CONFIG_DEFAULT_NUM_LOADERS;\
	(p_config)->num_group_loaders	= CRIFS_CONFIG_DEFAULT_NUM_GROUP_LOADERS;\
	(p_config)->num_stdio_handles	= CRIFS_CONFIG_DEFAULT_NUM_STDIO_HANDLES;\
	(p_config)->num_installers		= CRIFS_CONFIG_DEFAULT_NUM_INSTALLERS;\
	(p_config)->max_binds			= CRIFS_CONFIG_DEFAULT_MAX_BINDS;\
	(p_config)->max_files			= CRIFS_CONFIG_DEFAULT_MAX_FILES;\
	(p_config)->max_path			= CRIFS_CONFIG_DEFAULT_MAX_PATH;\
	(p_config)->version				= CRI_FS_VERSION;\
	(p_config)->version_string		= CRI_FS_VER_NUM;\
	(p_config)->enable_crc_check	= CRI_FALSE;\
}




/*JP
 * \brief mۊ֐̓o^
 * \ingroup FSLIB_CRIFS
 * \param[in]	func		mۊ֐
 * \param[in]	obj			[U[wIuWFNg
 * \par :
 * CRI File SystemCuɃmۊ֐o^܂B<br>
 * CRI File SystemCuCuōsȂmۏA
 * [U[Ǝ̃mۏɒuꍇɎgp܂B<br>
 * <br>
 * {֐̎gp菇͈ȉ̂ƂłB<br>
 * (1) ::CriFsMallocFunc C^[tFCXɕmۊ֐pӂB<br>
 * (2) ::criFs_SetUserMallocFunction ֐gpACRI File SystemCuɑ΂
 * mۊ֐o^B<br>
 * <br>
 * ̓IȃR[h̗͈ȉ̂ƂłB
 * \par :
 * \code
 * // Ǝ̃mۊ֐p
 * void *user_malloc(void *obj, CriUint32 size)
 * {
 * 	void *mem;
 *
 * 	// ̊m
 * 	mem = malloc(size);
 *
 * 	return (mem);
 * }
 *
 * main()
 * {
 * 		:
 * 	// mۊ֐̓o^
 * 	criFs_SetUserMallocFunction(user_malloc, NULL);
 * 		:
 * }
 * \endcode
 * \par l:
 *  obj Ɏw肵ĺA ::CriFsMallocFunc ɈƂēn܂B<br>
 * mێɃ}l[W[QƂKvꍇɂ́A
 * YIuWFNg{֐̈ɃZbgĂAR[obN֐ňoR
 * ĎQƂĂB<br>
 * \attention
 * mۊ֐o^ۂɂ́A킹ă֐i ::CriFsFreeFunc j
 * o^Kv܂B
 * \sa CriFsMallocFunc, criFs_SetUserFreeFunction
 */
void CRIAPI criFs_SetUserMallocFunction(CriFsMallocFunc func, void *obj);

/*JP
 * \brief ֐̓o^
 * \ingroup FSLIB_CRIFS
 * \param[in]	func		֐
 * \param[in]	obj			[U[wIuWFNg
 * \par :
 * CRI File SystemCuɃ֐o^܂B<br>
 * CRI File SystemCuCuōsȂA
 * [U[Ǝ̃ɒuꍇɎgp܂B<br>
 * <br>
 * {֐̎gp菇͈ȉ̂ƂłB<br>
 * (1) ::CriFsFreeFunc C^[tFCXɕ֐pӂB<br>
 * (2) ::criFs_SetUserFreeFunction ֐gpACRI File SystemCuɑ΂
 * ֐o^B<br>
 * <br>
 * ̓IȃR[h̗͈ȉ̂ƂłB
 * \par :
 * \code
 * // Ǝ̃֐p
 * void user_free(void *obj, void *mem)
 * {
 * 	// ̉
 * 	free(mem);
 *
 * 	return;
 * }
 *
 * main()
 * {
 * 		:
 * 	// ֐̓o^
 * 	criFs_SetUserFreeFunction(user_free, NULL);
 * 		:
 * }
 * \endcode
 * \par l:
 *  obj Ɏw肵ĺA ::CriFsFreeFunc ɈƂēn܂B<br>
 * mێɃ}l[W[QƂKvꍇɂ́A
 * YIuWFNg{֐̈ɃZbgĂAR[obN֐ňoR
 * ĎQƂĂB<br>
 * \attention
 * ֐o^ۂɂ́A킹ămۊ֐i ::CriFsMallocFunc j
 * o^Kv܂B
 * \sa CriFsFreeFunc, criFs_SetUserMallocFunction
 */
void CRIAPI criFs_SetUserFreeFunction(CriFsFreeFunc func, void *obj);








/*JP
 * \brief oC_[gp̎擾
 * \ingroup FSLIB_CRIFS
 * \param[out]	cur_num		ݎgp̃oC_[̐
 * \param[out]	max_num		ߋɍő哯ɗpoC_[̐
 * \param[out]	limit		p\ȃoC_[̏
 * \return	CriError	G[R[h
 * \par :
 * oC_[̎gpɊւ擾܂B<br>
 */
CriError CRIAPI criFs_GetNumUsedBinders(CriSint32 *cur_num, CriSint32 *max_num, CriSint32 *limit);







/*JP
 * \brief I/OIR[obN̓o^
 * \ingroup FSLIB_CRIFS
 * \param[in]	func	I/OIR[obN
 * \return	CriError	G[R[h
 * \par :
 * I/OIR[obN֐i ::CriFsSelectIoCbFunc jo^܂B<br>
 * CRI File SystemCu̓t@CɃANZXہA܂߂ɁÃt@C݂foCXIDi ::CriFsDeviceId jƁA
 * foCXɃANZX邽߂I/OC^[tFCXi ::CriFsIoInterface jI܂B<br>
 * ftHgԂł́AfoCXIDI/OC^[tFCX̑I̓CuňÖٓIɍsȂ܂A
 * {֐gp邱ƂŁAfoCXIDI/OC^[tFCX[U[RɎw肷邱Ƃ\ɂȂ܂B<br>
 * ɂA[U[Ǝɍ쐬I/OC^[tFCXgpăt@CɃANZX邱Ƃ\ɂȂ܂B<br>
 * \code
 * // ƎI/OC^[tFCX`
 * // lj\̂̃o[֐̓[U[ƎɎB
 * static CriFsIoInterface g_userIoInterface = {
 * 	userExists,
 * 	userRemove,
 * 	userRename,
 * 	userOpen,
 * 	userClose,
 * 	userGetFileSize,
 * 	userRead,
 * 	userIsReadComplete,
 * 	userGetReadSize,
 * 	userWrite,
 * 	userIsWriteComplete,
 * 	userGetWriteSize,
 * 	userFlush,
 * 	userResize,
 * 	userGetNativeFileHandle
 * };
 *
 * // I/OIR[obN֐
 * CriError user_select_io_callback(
 * 	const CriChar8 *path, CriFsDeviceId *device_id, CriFsIoInterfacePtr *ioif)
 * {
 * 	// pX͂AfoCXID肷
 * 	if (strncmp(path, c) == 0) {
 * 		(*device_id) = CRIFS_DEVICE_`;
 * 	} else {
 * 		(*device_id) = CRIFS_DEFAULT_DEVICE;
 * 	}
 *
 * 	// t@CANZXɎgpI/OC^[tFCXw肷
 * 	(*ioif) = g_userIoInterface;
 *
 * 	return (CRIERR_OK);
 * }
 *
 * int main(c)
 * {
 * 		F
 * 	// I/OIR[obNo^
 * 	criFs_SetSelectIoCallback(user_select_io_callback);
 * 		F
 * }
 * \endcode
 * \attention
 * R[obN֐1o^ł܂B<br>
 * o^𕡐sꍇAɓo^ς݂̃R[obN֐A
 * ォo^R[obN֐ɂ㏑Ă܂܂B<br>
 * <br>
 * funcNULLw肷ƂƂœo^ς݊֐̓o^s܂B<br>
 * \sa CriFsSelectIoCbFunc, criFs_GetDefaultIoInterface
 */
CriError CRIAPI criFs_SetSelectIoCallback(CriFsSelectIoCbFunc func);


/*JP
 * \brief t@CI/O[h̐ݒ
 * \ingroup FSLIB_CRIFS
 * \param[in]	io_mode t@CI/O[h	
 * \return	CriError			G[R[h
 * \par :
 * CRI File SystemCuŜ̃t@CI/O[hݒ肵܂B<br>
 * ::CRIFS_FILE_IO_MODE_SHARE_FILE_HANDLE ݒ肷ƁAt@CnhCuŋL
 * At@CANZXǂs܂B<br>
 * ̓Iɂ́A::criFsBinder_BindCpk ֐A::criFsBinder_BindFile ֐Ăяoɍ쐬
 * t@Cnh̓AoCh܂ŃCuŕێAێ̃t@Cɑ΂ANZXł
 * t@CI[v܂B<br>
 * <br>
 * ::CRIFS_FILE_IO_MODE_OPEN_EVERY_TIME ݒ肷ƁAt@Cnh̋Ls킸Ƀt@C
 * ANZX̂тɃt@CI[vs܂B<br>
 * t@CI[vׂ̕t@Cǂݍ݂̐\͗܂At@CANZXKvȎ̂
 * t@Cnh쐬邽߁At@CfBXNv^Ȃǂ̃\[Xŏɗ}邱Ƃ\łB<br>
 * <br>
 * ݒ莞iCRI File SystemCũftHgݒj́A@킲ƂɈقȂ܂B<br>
 * @ŗL}jAɋLڂȂAftHgݒ ::CRIFS_FILE_IO_MODE_SHARE_FILE_HANDLE łB<br>
 * \par ӁF
 * {֐̓CuOɌĂяoĂB<br>
 * CuɌĂяoƂ͏o܂B
 *
 * \sa CriFsFileIoMode
 */
CriError CRIAPI criFs_ControlFileIoMode(CriFsFileIoMode io_mode);

/*==========================================================================
 *      CriFsIo API
 *=========================================================================*/

/*==========================================================================
 *      CriFsBinder API
 *=========================================================================*/

/*JP
 * \brief oC_[̐
 * \ingroup FSLIB_BINDER
 * \param[out]	bndrhn		oC_[nh
 * \return		CriError	G[R[h
 * \par F
 * oC_[𐶐AoC_[nhԂ܂B<br>
 * \par F
 * \code
 * CriFsBinderHn bndrhn;
 * criFsBinder_Create(&bndrhn);
 * 		:
 * criFsBinder_Destroy(bndrhn);
 * \endcode
 * \sa criFsBinder_Destroy()
 */
CriError CRIAPI criFsBinder_Create(CriFsBinderHn *bndrhn);

/*JP
 * \brief oC_[쐬p[N̈TCY̎擾
 * \ingroup FSLIB_BINDER
 * \param[out]	work_size	[N̈TCY
 * \return	CriError		G[R[h
 * \par :
 * oC_[̍쐬ɕKvȃ[N̈̃TCY擾܂B<br>
 * ::criFsBinder_CreateWithWork ֐ŃoC_[쐬ꍇA
 * {֐Ń[N̈̃TCY擾A擾TCỸmۂKv܂B<br>
 * \par l:
 * ::criFsBinder_Create ֐gpăoC_[쐬ꍇA{֐gpKv͂܂B
 * \sa criFsBinder_CreateWithWork
 */
CriError CRIAPI criFsBinder_GetWorkSize(CriSint32 *work_size);

/*JP
 * \brief CriFsBinder̍쐬
 * \ingroup FSLIB_BINDER
 * \param[out]	binder		CriFsBindernh
 * \param[in]	work		[N̈
 * \param[in]	work_size	[N̈TCY
 * \return	CriError	G[R[h
 * \par :
 * CriFsBinder쐬܂B<br>
 * oC_[쐬ہA[N̈w肷_ ::criFsBinder_Create ֐ƈقȂ܂B<br>
 * <br>
 * {֐ō쐬oC_[́ACuɎw肵[N̈Ƃ͈قȂ̈ɔzu܂B
 * ̂߁A ::CriFsConfig::num_binders ̐󂯂܂B<br>
 * i ::CriFsConfig::num_binders Ɏw肵̃oC_[쐬ԂłĂA
 * {֐łɃoC_[쐬邱Ƃ\łBj<br>
 * <br>
 * [N̈̃TCY ::criFsBinder_GetWorkSize ֐Ŏ擾\łB<br>
 * oC_[쐬O ::criFsBinder_GetWorkSize ֐Ŏ擾TCỸmۂA{֐Ɏw肵ĂB<br>
 * <br>
 * {֐ō쐬oC_[́AftHgԂł͓1񂵂oChs܂B<br>
 * iCu ::CriFsConfig::max_binds Ŏw肵oCh\ȍő吔𒴂ĂȂƂĂA
 * 2̃oChsƃG[܂Bj<br>
 * {֐ō쐬oC_[œ2ȏ̃oChsꍇA
 * ::criFsBinder_AddResourceForBinding ֐Œǉ̃\[Xw肷Kv܂B<br>
 * <br>
 * {֐ŃoC_[쐬ꍇłA ::criFsBinder_BindFiles ֐ŕ̃t@CoChꍇɂ́A
 * ʓrt@CI[vp̃\[XoCht@C̐KvƂȂ܂B<br>
 * ::criFsBinder_BindFiles ֐gpꍇɂ́A
 * z肳t@C̏Cu ::CriFsConfig::max_files Ɏw肵ĂB
 * \attention
 * oC_[ji ::criFsBinder_Destroy ֐sj܂ł́A[N̈ɑ΂ǂݏ܂B<br>
 * [N̈ƂĎw肵́AoC_[j܂ł͉ȂłB<br>
 * \sa criFsBinder_GetWorkSize, criFsBinder_AddResourceForBinding
 */
CriError CRIAPI criFsBinder_CreateWithWork(CriFsBinderHn *bndrhn, void *work, CriSint32 work_size);

/*JP
 * \brief oC_[̔j
 * \ingroup FSLIB_BINDER
 * \param[in]	bndrhn		oC_[nh
 * \return		CriError	G[R[h
 * \par F
 * oC_[j܂B<br>
 * \par ӁF
 * joC_[ɃoChĂoChIDɔj܂B<br>
 * {֐Ŕjł̂́A::criFsBinder_Create ֐ɂ萶ꂽoC_[nĥ݂łB<br>
 * ::criFsBinder_GetHandle ֐ɂ CriFsBindId 擾ꂽoC_[nh͔jł܂B<br>
 * CriFsBindId ɂĂ ::criFsBinder_Unbind ֐gpB
 *
 * \sa criFsBinder_Create() criFsBinder_Unbind()
 */
CriError CRIAPI criFsBinder_Destroy(CriFsBinderHn bndrhn);

/*JP
 * \brief t@C̃oCh
 * \ingroup FSLIB_BINDER
 * \param[in,out]	bndrhn	t@CoChoC_[nh
 * \param[in]	srcbndrhn	oChΏۂ̃t@C邽߂̃oC_[nh
 * \param[in]	path		oCht@C̃pX
 * \param[in]	work		oChp[N̈
 * \param[in]	worksize	[N̈̃TCYioCgj
 * \param[out]	bndrid		oChID
 * \return		CriError	G[R[h
 * \par F
 * t@CoChAoChIDԂ܂B<br>
 * srcbndrhñoC_[pathŎw肳ꂽt@CAbndrhnɃoCh܂B
 * srcbndrhnNULL̏ꍇAftHgfoCX̃t@C܂B<br>
 * [N̈(work)̃TCÝAcriFsBinder_GetWorkSizeForBindFileŎ擾ł܂B
 * [N̈́AoChIDj܂ŕێĉB<br>
 * mہ^R[obN֐o^ĂꍇA[N̈NULL([NTCY͂Ojݒ肷ƁA
 * Kvȃ[N̈mہ^R[obN֐gpēIɊmۂ܂B<br>
 * oChJnłȂꍇAoChID CRIFSBINDER_BID_NULL Ԃ܂B
 * oChID CRIFSBINDER_BID_NULL ȊOԂꂽꍇ͓\[XmۂĂ܂̂ŁA
 * oCh̐^sɊւ炸AsvɂȂoChID̓AoChĂB<br><br>
 * oChꂽt@C̓t@CI[vԂŕێ܂B
 * ̂߁AICriFsLoader쐬Ă܂B<br><br>
 * {֐͑A֐łB{֐畜ÁAt@C̃oCh͂܂Ă炸A
 * oChID𗘗pt@Cւ̃ANZX͍s܂B<br>
 * oChID̃oChԂi CRIFSBINDER_STATUS_COMPLETE jƂȂɁA
 * t@C͗p\ƂȂ܂B<br>
 * oChԂ criFsBinder_GetStatus ֐Ŏ擾܂B<br>
 * \par F
 * \code
 * void *work;
 * CriSint32 wksz;
 * CriFsBindId bndrid;
 * criFsBinder_GetWorkSizeForBindFile(NULL, "sample.txt", &wksz);
 * work = malloc(wksz);
 * criFsBinder_BindFile(bndrhn, NULL, "sample.txt", work, wksz, &bndrid);
 * for (;;) {
 * 	CriFsBinderStatus status;
 * 	criFsBinder_GetStatus(bndrid, &status);
 * 	if (status == CRIFSBINDER_STATUS_COMPLETE) break;
 * }
 * // f[^̃[h (t@CI[vԂł̃ANZX)
 * criFsBinder_GetFileSize(binder, "sample.txt", &fsize); 
 * criFsLoader_Load(loader, binder, "sample.txt", 0, fsize, buffer, buffer_size); 
 * // [h҂... 
 * \endcode
 * \sa criFsBinder_GetWorkSizeForBindFile(), criFsBinder_SetUserHeapFunc(), criFsBinder_GetStatus(), criFsBinder_Unbind()
 */
CriError CRIAPI criFsBinder_BindFile(CriFsBinderHn bndrhn, CriFsBinderHn srcbndrhn, const CriChar8 *path, void *work, CriSint32 worksize, CriFsBindId *bndrid);
/*JP
 * \brief t@CZNṼoCh
 * \ingroup FSLIB_BINDER
 * \param[in,out]	bndrhn		t@CZNVoChoC_[nh
 * \param[in]	srcbndrhn		oChΏۂ̃t@C邽߂̃oC_[nh
 * \param[in]	path			oCht@C̃pX
 * \param[in]	offset			f[^̊JnʒuioCgj
 * \param[in]	size			f[^TCYioCgj
 * \param[in]	section_name	ZNV
 * \param[in]	work			oChp[N̈
 * \param[in]	worksize		[N̈̃TCYioCgj
 * \param[out]	bndrid			oChID
 * \return		CriError		G[R[h
 * \par F
 * t@C̈ꕔoChẢӏzIȃt@CƂĈ悤ݒ肵܂B<br>
 * srcbndrhñoC_[pathŎw肳ꂽt@CăoCh܂B
 * srcbndrhnNULL̏ꍇAftHgfoCXgp܂B<br>
 * [N̈(work)̃TCÝAcriFsBinder_GetWorkSizeForBindFileSectionŎ擾ł܂B
 * [N̈́AoChIDj܂ŕێĉB<br>
 * mہ^R[obN֐o^ĂꍇA[N̈NULL([NTCY͂Ojݒ肷ƁA
 * Kvȃ[N̈mہ^R[obN֐gpēIɊmۂ܂B<br>
 * oChJnłȂꍇAoChID CRIFSBINDER_BID_NULL Ԃ܂B
 * oChID CRIFSBINDER_BID_NULL ȊOԂꂽꍇ͓\[XmۂĂ܂̂ŁA
 * oCh̐^sɊւ炸AsvɂȂoChID̓AoChĂB<br><br>
 * oChꂽt@C̓t@CI[vԂŕێ܂B
 * ̂߁AICriFsLoader쐬Ă܂B<br><br>
 * {֐͑A֐łB{֐畜ÁAt@C̃oCh͂܂Ă炸A
 * oChID𗘗pt@Cւ̃ANZX͍s܂B<br>
 * oChID̃oChԂi CRIFSBINDER_STATUS_COMPLETE jƂȂɁA
 * t@C͗p\ƂȂ܂B<br>
 * oChԂ criFsBinder_GetStatus ֐Ŏ擾܂B<br>
 * \par F
 * \code
 * CriFsBindId binder_id;
 * CriFsBinderStatus status;
 * 	F
 * // sample.txt100oCgڂ5000oCgSTAGE1ƂOŃoCh
 * // ljAP[^[Oɓo^ς݂ł΃[N̈TCY̎w͕svB
 * criFsBinder_BindFileSection(binder_hn, NULL, "sample.txt", 100, 5000, "STAGE1", NULL, 0, &binder_id);
 *
 * // oCh҂
 * for (;;) {
 * 	// oChԂ̃`FbN
 * 	criFsBinder_GetStatus(binder_id, &status);
 * 	if (status == CRIFSBINDER_STATUS_COMPLETE) {
 * 		break;
 * 	}
 *
 * 	// T[o[̎s
 * 	criFs_ExecuteMain();
 *
 * 	// Vsync҂
 * 	c
 * }
 *
 * // oChς݂̃ZNṼf[^ǂݍ
 * // lj[h̃pXɂ̓ZNVw肷B
 * criFsLoader_Load(loader_hn, binder_hn, "STAGE1", 0, 5000, buffer, buffer_size);
 * 	F
 * \endcode
 * \sa criFsBinder_GetWorkSizeForBindFileSection, criFsBinder_GetStatus, criFsBinder_Unbind
 */
CriError CRIAPI criFsBinder_BindFileSection(
	CriFsBinderHn bndrhn, CriFsBinderHn srcbndrhn, const CriChar8 *path,
	CriUint64 offset, CriSint32 size, const CriChar8 *section_name,
	void *work, CriSint32 worksize, CriFsBindId *bndrid);

/*==========================================================================
 *      CriFsLoader API
 *=========================================================================*/

/*JP
 * \brief oChԂ̎擾
 * \ingroup FSLIB_BINDER
 * \param[in]	bndrid	oChID
 * \param[out]	status	CriFsBinderStatusoC_[Xe[^X
 * \return	CriError	G[R[h
 * \par F
 * w肳ꂽoChID̃oChԂ擾܂B <br>
 * oChԂ CRIFSBINDER_STATUS_COMPLETE ɂȂ܂ł́A
 * ̃oChIDɂt@CANZXs܂B<br>
 * \par F
 * \code
 * CriFsBinderStatus status;
 * criFsBinder_GetStatus(bndrid, &status);
 * \endcode
 * \sa criFsBinder_BindCpk(), criFsBinder_BindFile(), criFsBinder_BindFiles()
 */
CriError CRIAPI criFsBinder_GetStatus(CriFsBindId bndrid, CriFsBinderStatus *status);

/*==========================================================================
 *      CriFsGroupLoader API
 *=========================================================================*/

/*==========================================================================
 *      Log Output API
 *=========================================================================*/


/*==========================================================================
 *      CriFsStdio API
 *=========================================================================*/
/*JP
 * \brief ANSI C ɏt@CI[v
 * \ingroup FSLIB_CRIFSSTDIO
 * \param[in] bndr  I[vt@CoChĂCriFsBinder̃nh
 * \param[in] fname I[vt@CpX
 * \param[in] mode  I[v[h ("r":ǂݍݐp[h,"w":ݐp[h)
 * \return	CriFsStdioHn ꍇALCriFsStdionhԂ܂B<br>
 *                       sꍇNULLԂ܂B
 * \par F
 * w肳ꂽt@CI[v܂B<br>
 * ɂ́AI[vt@CoChĂoC_[w肵܂B<br>
 * vbgtH[W̃t@CpXt@CI[vꍇAɂNULLw肵܂B<br>
 * ɂ́AI[vt@CpX𕶎Ŏw肵܂B<br>
 * ÓAI[ṽ[hłB"r"w肷Ɠǂݍݐp[hA<br>
 * "w"w肷Əݐp[hŃt@CI[v܂B<br>
 * ݐp[h́At@C݂T|[gĂvbgtH[ł̂ݐɓ삵A
 * T|[g̃vbgtH[ł̓G[R[obNAI[v͎s܂B<br>
 * \par lF
 * t@C݂͈̏ȉ̃[ōs܂B<br>
 * - w肵t@C݂ȂꍇAVKɃt@C쐬B
 * - w肵t@Cɑ݂ꍇAt@CҏW܂B<br>
 * it@C폜邱Ƃ͂܂Bj
 * <br>
 * t@C폜ĐVKɃt@C݂̏sꍇɂ́A
 * {֐sO ::criFsStdio_RemoveFile ֐Ńt@C̍폜sĂB
 * \sa criFsStdio_CloseFile, criFsStdio_RemoveFile
 */
CriFsStdioHn CRIAPI criFsStdio_OpenFile(CriFsBinderHn bndr, const char *fname, const char *mode);

/*JP
 * \brief ANSI C ɏt@CN[Y
 * \ingroup FSLIB_CRIFSSTDIO
 * \param[in] stdhn N[Yt@CCriFsStdionh
 * \return CriError G[R[h<br>
 * \par F
 * w肵t@CN[Y܂B<br>
 * ɂ́AN[Yt@CCriFsStdionhw肵܂B<br>
 * \sa criFsStdio_OpenFile
 */
CriError CRIAPI criFsStdio_CloseFile(CriFsStdioHn stdhn);

/*JP
 * \brief ANSI C ɏAPIɊÂt@CTCY擾
 * \ingroup FSLIB_CRIFSSTDIO
 * \param[in] stdhn TCY擾t@CCriFsStdionh
 * \return CriSint64 w肵nhLł΁At@CTCYԂ܂B
 * \par F
 * w肵t@C̃TCY擾܂B<br>
 * ɂ́ATCY擾t@CCriFsStdionhw肵܂B<br>
 */
CriSint64 CRIAPI criFsStdio_GetFileSize(CriFsStdioHn stdhn);

/*JP
 * \brief ANSI C ɏ t@C[hItZbg̃V[N
 * \ingroup FSLIB_CRIFSSTDIO
 * \param[in] rdr                [hItZbgV[Nt@CCriFsStdionh
 * \param[in] offset               V[ÑItZbgibytej
 * \param[in] seek_type V[NJnʒu̎w
 * \return CriSint64  0<br>
 *                   s -1<br>
 * \par F
 * w肵t@C̃[hItZbgV[N܂B<br>
 * ɂ́A[hItZbgV[Nt@ĆACriFsStdionhw肵܂B<br>
 * ɂ́AV[ÑItZbgw肵܂BPʂbytełB<br>
 * \attention
 * t@C擪OɃV[N邱Ƃ͏o܂Bt@C[hItZbgt@C擪
 * OɂȂ悤V[NItZbgw肵ꍇAV[Nʂ̃t@C[hItZbg̓t@C擪ɂȂ܂B<br>
 * At@CI[𒴂V[N͉\łB<br>
 * ܂AwCriFsStdionhԃobt@[ꍇA
 * {֐Œԃobt@[̗L͈͊OɃV[NƁAԃobt@[̓ej܂B<br>
 * \sa criFsStdio_TellFileOffset
 * \sa criFsStdio_SetInterstageBuffer
 */
CriSint64 CRIAPI criFsStdio_SeekFile(CriFsStdioHn rdr, CriSint64 offset, CRIFSSTDIO_SEEK_TYPE seek_type);

/*JP
 * \brief ANSI C ɏAPIɊÂt@C̃f[^Ǎ
 * \ingroup FSLIB_CRIFSSTDIO
 * \param[in] stdhn ǍCriFsStdionh
 * \param[in] rsize ǍvTCYibytej
 * \param[in] buf   Ǎobt@[
 * \param[in] bsize Ǎobt@[̃TCYibytej
 * \return CriSint64 Ǎ ǂݍ߂TCYibytej<br>
 *                   Ǎs -1
 * \par F
 * t@Cf[^wTCYibytejǂݍ݂܂B<br>
 * ɂ́Af[^̓Ǎłt@CCriFsStdionhw肵܂B<br>
 * ɂ́AǂݍރTCYw肵܂B<br>
 * Oɂ́Aǂݍ񂾃f[^̏ݐobt@[w肵܂B<br>
 * lɂ́Aǂݍ񂾃f[^̏ݐobt@[TCYw肵܂B<br>
 * \attention
 * ߂ĺA<b>ǍvTCYȉɂȂ</b>ƂɒӂĂB<br>
 * Ⴆ΃t@CI[ł́A߂lǍvTCY菬Ȃ邱Ƃ܂A
 * ǍɎsĂ킯ł͂܂BǍɎsꍇA-1Ԃ܂B
 */
CriSint64 CRIAPI criFsStdio_ReadFile(CriFsStdioHn stdhn, CriSint64 rsize, void *buf, CriSint64 bsize);

#ifdef __cplusplus
}
#endif

/***************************************************************************
 *      o[WƂ̌݊p
 *      For compatibility with old version
 ***************************************************************************/
#define CRI_FS_VERSION		(0xFFFFFFFF)
typedef CriFsBindId CriFsBinderId;

#endif	/* CRI_FILE_SYSTEM_H_INCLUDED */

/* --- end of file --- */
