/****************************************************************************
 *
 * CRI Middleware SDK
 *
 * Copyright (c) 2010 CRI Middleware Co., Ltd.
 *
 * Library  : CRI AtomEx Monitor Library
 * Module   : Monitor Library C Interface Header
 * File     : cri_le_atom_ex_monitor.h
 *
 ****************************************************************************/
/*!
 *	\file	cri_le_atom_ex_monitor.h
 */

#ifndef CRI_INCL_CRI_ATOMEX_MONITOR_H
#define CRI_INCL_CRI_ATOMEX_MONITOR_H

/***************************************************************************
 *      CN[ht@C
 *      Include files
 ***************************************************************************/

#include "cri_le_xpt.h"
#include "cri_le_atom_ex.h"
#include "cri_le_atom_asr.h"

/***************************************************************************
 *      萔}N
 *      Macro Constants
 ***************************************************************************/
/* o[W */
/* Version Number */
#define CRIATOMEX_MONITOR_VER_NAME				"CRI AtomEx Monitor"
#define CRIATOMEX_MONITOR_VER_NUM				"1.23.74"
#define CRIATOMEX_MONITOR_VER_MAJOR				(1)
#define CRIATOMEX_MONITOR_VER_MINOR				(23)
#define CRIATOMEX_MONITOR_VER_PATCH				(74)
#define CRIATOMEX_MONITOR_VER_RELEASE			(0)
#define CRIATOMEX_MONITOR_VER_REVISION			(0)
#define CRIATOMEX_MONITOR_VER_OPTION


/*JP
 * \brief ftHgvr[IuWFNg
 * \ingroup ATOMEXMONITORLIB_GLOBAL
 * \par :
 * ftHg̃vr[IuWFNgłB<br>
 * \sa criAtomExMonitor_SetDefaultConfig
 */
#define CRIATOMX_MONITOR_DEFAULT_NUM_PUREVIEW_OBJECTS		(200)
/*JP
 * \brief ftHgʐMobt@TCY
 * \ingroup ATOMEXMONITORLIB_GLOBAL
 * \par :
 * ftHg̒ʐMobt@TCYłB<br>
 * \sa criAtomExMonitor_SetDefaultConfig
 */
#define CRIATOMX_MONITOR_DEFAULT_COMMUNICATION_BUFFER_SIZE	(2*1024*1024)
/*JP
 * \brief ftHgĐʒuXVԊu
 * \ingroup ATOMEXMONITORLIB_GLOBAL
 * \par :
 * ftHg̍ĐʒuXVԊułB<br>
 * \sa criAtomExMonitor_SetDefaultConfig
 */
#define CRIATOMX_MONITOR_DEFAULT_PLAYBACK_POSITION_UPDATE_INTERVAL	(8)

/*JP
 * \brief O擾[h
 * \ingroup ATOMEXMONITORLIB_GLOBAL
 * \par :
 * O擾̃[hłB<br>
 * \sa criAtomExMonitor_SetLogMode
 */
#define CRIATOMEX_MONITOR_LOG_MODE_OFF						(0)
#define CRIATOMEX_MONITOR_LOG_MODE_PLAYBACK					(1)			/* Đ֘A */
#define CRIATOMEX_MONITOR_LOG_MODE_ERROR					(1 << 1)	/* G[֘A */
#define CRIATOMEX_MONITOR_LOG_MODE_LOW_LEVEL_PLAYBACK		(1 << 2)	/* ჌xĐ֘A */
#define CRIATOMEX_MONITOR_LOG_MODE_SYSTEM_INFORMATION		(1 << 3)	/* VXe֘A */
#define CRIATOMEX_MONITOR_LOG_MODE_HANDLE_INFORMATION		(1 << 4)	/* VXe֘A */
#define CRIATOMEX_MONITOR_LOG_MODE_CUE_LIMIT				(1 << 5)	/* L[~bg֘A */
#define CRIATOMEX_MONITOR_LOG_MODE_PROBABILITY				(1 << 6)	/* voreB֘A */
#define CRIATOMEX_MONITOR_LOG_MODE_CATEGORY					(1 << 7)	/* JeS֘A */
#define CRIATOMEX_MONITOR_LOG_MODE_EXECUTING_INFORMATION	(1 << 8)	/* ֘A */
#define CRIATOMEX_MONITOR_LOG_MODE_3D_INFO					(1 << 9)	/* 3D֘A */
#define CRIATOMEX_MONITOR_LOG_MODE_USER_LOG					(1 << 10)	/* [UO */
#define CRIATOMEX_MONITOR_LOG_MODE_VOICE_VOLUME				(1 << 11)	/* {CX{[ */
#define CRIATOMEX_MONITOR_LOG_MODE_ASR						(1 << 12)	/* TEh_[֘A */

#define CRIATOMEX_MONITOR_LOG_MODE_ALL						(0xFFFFFFFF)


/***************************************************************************
 *      }N
 *      Macro Functions
 ***************************************************************************/
/*JP
 * \brief Atomj^[CuRtBO\̂ɃftHglZbg
 * \ingroup ATOMEXMONITORLIB_GLOBAL
 * \par :
 * ::criAtomExMonitor_Initialize ֐ɐݒ肷RtBO\
 * i ::CriAtomExMonitorConfig jɁAftHglZbg܂B<br>
 * \sa criAtomExMonitor_Initialize, CriAtomExMonitorConfig
 */
#define criAtomExMonitor_SetDefaultConfig(p_config)	\
{\
	(p_config)->max_preivew_object = CRIATOMX_MONITOR_DEFAULT_NUM_PUREVIEW_OBJECTS;\
	(p_config)->communication_buffer_size = CRIATOMX_MONITOR_DEFAULT_COMMUNICATION_BUFFER_SIZE;\
	(p_config)->additional_buffer = 0;\
	(p_config)->additional_buffer_size = 0;\
	(p_config)->playback_position_update_interval = CRIATOMX_MONITOR_DEFAULT_PLAYBACK_POSITION_UPDATE_INTERVAL;\
}
 
/***************************************************************************
 *      f[^^錾
 *      Data Type Declarations
 ***************************************************************************/
/*JP
 * \brief Atomj^[CupRtBO\
 * \ingroup ATOMEXMONITORLIB_GLOBAL
 * \par :
 * j^[Cu̓dlw肷邽߂̍\̂łB<br>
 * ::criAtomExMonitor_Initialize ֐̈Ɏw肵܂B<br>
 * <br>
 * CRI AtomEx MonitorCúAɖ{\̂Ŏw肳ꂽݒɉāA\[X
 * KvȂmۂ܂B<br>
 * CuKvƂ郏[N̈̃TCÝA{\̂Ŏw肳ꂽp[^[ɉ
 * ω܂B
 * \par l:
 * ftHgݒgpꍇA ::criAtomExMonitor_SetDefaultConfig }Nō\̂ɃftHg
 * p[^[ZbgA ::criAtomExMonitor_Initialize ֐ɍ\̂w肵ĂB<br>
 * \attention
 * IɃo\邽߁A ::criAtomExMonitor_SetDefaultConfig }NgpȂ
 * ꍇɂ́AgpOɕK\̂[NAĂB<br>
 * i\̂̃oɕslȂ悤ӂBj
 * \sa criAtomExMonitor_Initialize, criAtomExMonitor_SetDefaultConfig
 */
typedef struct CriAtomExMonitorConfigTag {
	/*JP
		\brief CQ[vr[pǗ\[X̍ől
		\par :
		Ŏw肷Ǘ\[X̓CQ[vr[ ACB nhPɑ΂P܂B<br>
		Ɏgp ACB 傫Ȓlݒ肷悤ɂĂB<br>
	*/
	CriUint32	max_preivew_object;
	/*JP
		\brief ʐMpobt@TCY
		\par :
		j^CuƃI[TOc[ԂōsʐMɎgpobt@TCYw肵܂B<br>
		obt@͑MpAMp2Aꂼݒl̔̊g̈悪ɕt܂B<br>
		̂ߎۂɕKvȃobt@TCY͐ݒl3{ƂȂ܂B<br>
	*/
	CriUint32	communication_buffer_size;
	/*JP
		\brief ǉobt@
		\par :
		TCP/IPڑȊO̐ڑsAʐMobt@Ow肷KvꍇɎgp܂B<br>
		Ɏw肪Ȃꍇ͎gp܂B<br>
	*/
	CriUintPtr	additional_buffer;
	/*JP
		\brief ǉobt@TCY
		\par :
		Ow̒ʐMobt@TCYłB<br>
	*/
	CriUint32	additional_buffer_size;
	/*JP
		\brief ĐʒuXVԊu
		\par :
		T[osɍĐʒȗMsԊuw肵܂B<br>
		playback_position_update_interval ̒lύX邱ƂŁA
		T[o̎s񐔂ς邱ƂȂĐʒȗMpx邱Ƃ\łB<br>
		<br>
		Ⴆ΁A playback_position_update_interval  2 ɐݒ肷ƁA
		T[o 2 ɑ΂A 1 񂾂ĐʒȗMs܂B<br>
		iĐʒȗMpx 1/2 ɂȂ܂Bj<br>
	*/
	CriSint32	playback_position_update_interval;
} CriAtomExMonitorConfig;

/*JP
 * \brief f[^XV^Cv
 * \ingroup ATOMEXMONITORLIB_GLOBAL
 * \par :
 * CQ[vr[AtomCraftiI[TOc[jɂf[^XṼ^[QbgłB<br>
 * \sa CriAtomExMonitorDataUpdateNotificationInfo
 */
typedef enum CriAtomExMonitorDataUpdateTargetTag {
	CRIATOMEXMONITOR_DATA_UPDATE_TARGET_ACF = 0,			/*JP< ACFXV */
	CRIATOMEXMONITOR_DATA_UPDATE_TARGET_ACB = 1,			/*JP< ACBXV */
	/* enum size is 4bytes */
	CRIATOMEXMONITOR_DATA_UPDATE_TARGET_ENUM_SIZE_IS_4BYTES = 0x7FFFFFFF
} CriAtomExMonitorDataUpdateTarget;

/*JP
 * \brief f[^XVXe[^X
 * \ingroup ATOMEXMONITORLIB_GLOBAL
 * \par :
 * CQ[vr[AtomCraftiI[TOc[jɂf[^XV̏ԂłB<br>
 * \sa CriAtomExMonitorDataUpdateNotificationInfo
 */
typedef enum CriAtomExMonitorDataUpdateEventTag {
	CRIATOMEXMONITOR_DATA_UPDATE_EVENT_BEGIN = 0,	/*JP< JnCxg */
	CRIATOMEXMONITOR_DATA_UPDATE_EVENT_END   = 1,	/*JP< ICxg */
	/* enum size is 4bytes */
	CRIATOMEXMONITOR_DATA_UPDATE_EVENT_ENUM_SIZE_IS_4BYTES = 0x7FFFFFFF
} CriAtomExMonitorDataUpdateEvent;

/*JP
 * \brief f[^XV
 * \ingroup ATOMEXMONITORLIB_GLOBAL
 * \par :
 * CQ[vr[AtomCraftiI[TOc[jɂf[^XVłB<br>
 * \sa criAtomExMonitor_SetDataUpdateNotificationCallback
 */
typedef struct CriAtomExMonitorDataUpdateNotificationInfoTag {
	CriAtomExMonitorDataUpdateTarget target;				/*JP< XV^[Qbg */
	CriAtomExMonitorDataUpdateEvent event;				/*JP< Cxg */
	CriAtomExAcbHn acb_hn;								/*JP< ACBnh */
	const CriChar8* name;								/*JP< O */
} CriAtomExMonitorDataUpdateNotificationInfo;

/*JP
 * \brief I[TOc[ɂf[^XVʒm擾R[obN֐
 * \ingroup ATOMEXLIB_ACB
 * \par :
 * \param[in]	obj			[UwIuWFNg
 * \param[in]	info		f[^XVʒm擾
 * \return					Ȃ
 * \par :
 * CQ[vr[ɃI[TOc[̃f[^XVꍇɌĂяoR[obN֐łB<br>
 * CQ[vr[ɃAvP[VŃf[^XVԂ擾ꍇɎgp܂B<br>
 * <br>
 * R[obN֐̓o^ɂ ::criAtomExMonitor_SetDataUpdateNotificationCallback ֐gp܂B<br>
 * o^R[obN֐́ACQ[vr[ɃI[TOc[̃f[^XVÕ^C~OŎs܂B<br>
 * \attention
 * {IɁAR[obN֐łAtomCuAPIgpȂłB<br>
 * {R[obN֐ŒԏubNƁA؂ꓙ̖肪܂̂ŁA
 * ӂB<br>
 * R[obN֐ɈƂēnCriAtomExMonitorDataUpdateNotificationInfo\̂ւ̎QƂ̓R[obN֐ōsĂB<br>
 * R[obN֐OŎQƂꍇ́Aʗ̈ɓeۑĂsĂB
 * \sa criAtomExMonitor_SetDataUpdateNotificationCallback, CriAtomExMonitorDataUpdateNotificationInfo
 */
typedef void (CRIAPI *CriAtomExMonitorDataUpdateNotificationCbFunc)(
	void *obj, const CriAtomExMonitorDataUpdateNotificationInfo* info);

/*	Log Callback Function type	*/
typedef void (*CriAtomExMonitorLogCbFunc)(void* obj, const CriChar8 *log_string);

/***************************************************************************
 *      ϐ錾
 *      Prototype Variables
 ***************************************************************************/

/***************************************************************************
 *      ֐錾
 *      Prototype Functions
 ***************************************************************************/
#ifdef __cplusplus
extern "C" {
#endif

/*JP
 * \brief j^[@\p[N̈TCY̌vZ
 * \ingroup ATOMEXMONITORLIB_GLOBAL
 * \param[in]	config		pRtBO\
 * \return		CriSint32	[N̈TCY
 * \par :
 * j^[@\gp邽߂ɕKvȁA[N̈̃TCY擾܂B<br>
 * <br>
 * [N̈TCY̌vZɎsƁA{֐ -1 Ԃ܂B<br>
 * [N̈TCY̌vZɎsRɂẮAG[R[obÑbZ[WŊmF\łB<br>
 * \par l:
 * j^[@\KvƂ郏[N̈̃TCÝAj^[@\pRtBO
 * \́i ::CriAtomExMonitorConfig j̓eɂĕω܂B<br>
 * <br>
 * NULLw肵ꍇAftHgݒ
* i ::criAtomExMonitor_SetDefaultConfig KpƓp[^[j
 * [N̈TCYvZ܂B
 * <br>
 *  config ̏́A֐ł̂ݎQƂ܂B<br>
 * ֐𔲂͎QƂ܂̂ŁA֐s config ̗̈Ă
 * 肠܂B
 * \sa criAtomExMonitor_SetDefaultConfig, criAtomExMonitor_Initialize, CriAtomExMonitorConfig
 */
CriSint32 CRIAPI criAtomExMonitor_CalculateWorkSize(const CriAtomExMonitorConfig* config);

/*JP
 * \brief j^[@\̏
 * \ingroup ATOMEXMONITORLIB_GLOBAL
 * \param[in]	config		pRtBO\
 * \param[in]	work		[N̈
 * \param[in]	work_size	[N̈TCY
 * \par :
 * j^[@\܂B<br>
 * j^[@\𗘗pɂ́AK̊֐sKv܂B<br>
 * ij^[@\́A{֐sA ::criAtomExMonitor_Finalize ֐s܂ł̊ԁA
 * p\łBj<br>
 * {֐̌ĂяóAcriAtomEx_Initialize ֐s ::criAtomEx_Finalize ֐s܂ł̊Ԃ
 * s悤ɂĂB<br>
 * \sa criAtomExMonitor_Finalize, CriAtomExMonitorConfig
 */
void CRIAPI criAtomExMonitor_Initialize(
	const CriAtomExMonitorConfig *config, void *work, CriSint32 work_size);

/*JP
 * \brief j^[@\̏I
 * \ingroup ATOMEXMONITORLIB_GLOBAL
 * \par :
 * j^[@\I܂B<br>
 * \attention
 * ::criAtomExMonitor_Initialize ֐sOɖ{֐s邱Ƃ͂ł܂B<br>
 * \sa criAtomExMonitor_Initialize
 */
void CRIAPI criAtomExMonitor_Finalize(void);

/*JP
 * \brief T[o[IPAhX̎擾
 * \ingroup ATOMEXMONITORLIB_GLOBAL
 * \par :
 * T[o[IPAhX擾܂B<br>
 * \attention
 * ::criAtomExMonitor_Initialize ֐sOɖ{֐s邱Ƃ͂ł܂B<br>
 * \sa criAtomExMonitor_Initialize, criAtomExMonitor_GetClientIpString
 */
const CriChar8* CRIAPI criAtomExMonitor_GetServerIpString(void);

/*JP
 * \brief NCAgIPAhX̎擾
 * \ingroup ATOMEXMONITORLIB_GLOBAL
 * \par :
 * NCAgIPAhX擾܂B<br>
 * \attention
 * ::criAtomExMonitor_Initialize ֐sOɖ{֐s邱Ƃ͂ł܂B<br>
 * \sa criAtomExMonitor_Initialize, criAtomExMonitor_GetServerIpString
 */
const CriChar8* CRIAPI criAtomExMonitor_GetClientIpString(void);

/*JP
 * \brief c[ڑԂ̎擾
 * \ingroup ATOMEXMONITORLIB_GLOBAL
 * \return		CriBool	ڑԁiCRI_TRUE:ڑACRI_FALSE:ڑj
 * \par :
 * Craft ڑԂ擾܂B<br>
 * \attention
 * ::criAtomExMonitor_Initialize ֐sOɖ{֐s邱Ƃ͂ł܂B<br>
 * \sa criAtomExMonitor_Initialize
 */
CriBool CRIAPI criAtomExMonitor_IsConnected(void);

/*JP
 * \brief vt@C[ڑԂ̎擾
 * \ingroup ATOMEXMONITORLIB_GLOBAL
 * \return		CriBool	ڑԁiCRI_TRUE:ڑACRI_FALSE:ڑj
 * \par :
 * vt@C[ڑԂ擾܂B<br>
 * \attention
 * ::criAtomExMonitor_Initialize ֐sOɖ{֐s邱Ƃ͂ł܂B<br>
 * \sa criAtomExMonitor_Initialize
 */
CriBool CRIAPI criAtomExMonitor_IsConnectedToProfiler(void);

/*JP
 * \brief O擾R[obN̓o^
 * \ingroup ATOMEXMONITORLIB_GLOBAL
 * \param[in]		cbf			R[obN֐
 * \param[in]		obj			[UwIuWFNg
 * \par :
 * O擾pR[obN֐o^܂B<br>
 * ֐o^ƃO擾JnANULLݒ肷邱ƂŃO擾~܂B<br>
 * 擾郍Õ[hؑւ ::criAtomExMonitor_SetLogMode ֐Őݒw肭B<br>
 * \attention
 * ::criAtomExMonitor_Initialize ֐sOɖ{֐s邱Ƃ͂ł܂B<br>
 * \sa criAtomExMonitor_Initialize, criAtomExMonitor_SetLogMode
 */
void CRIAPI criAtomExMonitor_SetLogCallback(CriAtomExMonitorLogCbFunc cbf, void* obj);

/*JP
 * \brief O[h̐ݒ
 * \ingroup ATOMEXMONITORLIB_GLOBAL
 * \param		mode		Oo̓[h
 * \par :
 * O擾̃[hݒ肵܂B<br>
 * {֐Őݒ肵[hɂ ::criAtomExMonitor_SetLogCallback ֐
 * o^O擾pR[obN֐Ăяo܂B<br>
 * \sa criAtomExMonitor_SetLogCallback
 */
void CRIAPI criAtomExMonitor_SetLogMode(CriUint32 mode);

/*JP
 * \brief [UȌo
 * \ingroup ATOMEXMONITORLIB_GLOBAL
 * \param[in]		message		[UObZ[W
 * \par :
 * [UOo͂܂B<br>
 * {֐ɂďo͂O̓O擾R[obNvt@CŎ擾AmFs܂B
 * \sa criAtomExMonitor_SetLogCallback
 */
void CRIAPI criAtomExMonitor_OutputUserLog(const CriChar8* message);

/*JP
 * \brief f[^XVʒmR[obN֐̓o^
 * \ingroup ATOMEXMONITORLIB_GLOBAL
 * \param[in]	func		f[^XVʒmR[obN֐
 * \param[in]	obj			[UwIuWFNg
 * \par :
 * CQ[vr[ɃI[TOc[̃f[^XVꍇɌĂяoR[obN֐o^܂B<br>
 * \attention
 * R[obN֐ŁAAtomCuAPIsȂłB<br>
 * R[obN֐AtomMonitorCũT[os܂B<br>
 * ̂߁AT[oւ̊荞݂lȂAPIsꍇA
 * G[AfbhbN\܂B<br>
 * <br>
 * R[obN֐ŒԏubNƁA؂ꓙ̖
 * ܂̂ŁAӂB<br>
 * <br>
 * R[obN֐1o^ł܂B<br>
 * o^𕡐sꍇAɓo^ς݂̃R[obN֐A
 * ォo^R[obN֐ɂ㏑Ă܂܂B<br>
 * <br>
 * funcNULLw肷ƂƂœo^ς݊֐̓o^s܂B<br>
 * \attention
 * ::criAtomExMonitor_Initialize ֐sOɖ{֐s邱Ƃ͂ł܂B<br>
 * \sa CriAtomExMonitorDataUpdateNotificationCbFunc, CriAtomExMonitorDataUpdateNotificationInfo
 */
void CRIAPI criAtomExMonitor_SetDataUpdateNotificationCallback(
	CriAtomExMonitorDataUpdateNotificationCbFunc func, void *obj);

/***************************************************************************
 *      bAPIigp͂Tj
 *      Tentative API (Please don't use it)
 ***************************************************************************/
 /* ȉɐ錾Ă֐Atom̓pAQ[GWƂ̘Agɂ
  * bIɎgpĂAPIłB
  * ̃Abvf[gɂė\ȂύXE폜s邽߁Agp͂TB
  */

 typedef enum CriAtomExAsrRackBounceModeTag {
	CRIATOMEXASRRACK_BOUNCE_MODE_RACK = 0,			/* ASR Rack ̏o */
	CRIATOMEXASRRACK_BOUNCE_MODE_DEVICE_INPUT = 1,	/* foCXւ̓ */
	/* enum size is 4bytes */
	CRIATOMEXASRRACK_BOUNCE_TARGET_ENUM_SIZE_IS_4BYTES = 0x7FFFFFFF
} CriAtomExAsrRackBounceMode;

void CRIAPI criAtomExAsrRack_SetBounceMode(CriAtomExAsrRackId rack_id, CriAtomExAsrRackBounceMode bounce_mode);
CriBool CRIAPI criAtomExAsrRack_StartBounce(CriAtomExAsrRackId rack_id, const CriChar8* path, CriUint32 num_channels);
void CRIAPI criAtomExAsrRack_StopBounce(CriAtomExAsrRackId rack_id);
CriUint32 CRIAPI criAtomExAsrRack_GetBounceTime(CriAtomExAsrRackId rack_id);

/***************************************************************************
 *      o[WƂ̌݊p
 *      For compatibility with old version
 ***************************************************************************/
#define CRIATOMEX_MONITOR_VERSION				(0xFFFFFFFF)

#ifdef __cplusplus
}
#endif

#endif //	CRI_INCL_CRI_ATOMEX_MONITOR_H
