/****************************************************************************
 *
 * CRI Middleware SDK
 *
 * Copyright (c) 2009-2018 CRI Middleware Co., Ltd.
 *
 * Library  : CRI Atom
 * Module   : Library User's Header
 * File     : cri_atom.h
 *
 ****************************************************************************/
/*!
 *	\file		cri_atom.h
 */

/* d`h~					*/
/* Prevention of redefinition	*/
#ifndef CRI_INCL_CRI_ATOM_H
#define CRI_INCL_CRI_ATOM_H

/***************************************************************************
 *      CN[ht@C
 *      Include files
 ***************************************************************************/
#include "cri_le_xpt.h"
#include <cri_le_file_system.h>

/***************************************************************************
 *      萔}N
 *      Macro Constants
 ***************************************************************************/
/* o[W */
/* Version Number */
#define CRI_ATOM_VER_NAME		"CRI Atom (LE)"
#define CRI_ATOM_VER_NUM		"2.29.322"
#define CRI_ATOM_VER_MAJOR		(2)
#define CRI_ATOM_VER_MINOR		(29)
#define CRI_ATOM_VER_PATCH		(322)
#define CRI_ATOM_VER_RELEASE	(0)
#define CRI_ATOM_VER_REVISION	(0)

/*==========================================================================
 *      CRI Atom API
 *=========================================================================*/
#if defined(XPT_TGT_ANDROID) || defined(XPT_TGT_IOS) || defined(XPT_TGT_IPHONE)
#define CRIATOM_DEFAULT_OUTPUT_CHANNELS				(2)
#define CRIATOM_DEFAULT_OUTPUT_SAMPLING_RATE		(48000)
#define CRIATOM_DEFAULT_INPUT_MAX_CHANNELS			(2)
#define CRIATOM_DEFAULT_INPUT_MAX_SAMPLING_RATE		(48000)
#define CRIATOM_DEFAULT_DECODE_LATENCY				(0)
#define CRIATOM_DEFAULT_DBAS_MAX_STREAMS			(8)
#define CRIATOM_SOUND_RENDERER_DEFAULT				(CRIATOM_SOUND_RENDERER_ASR)
#else
#define CRIATOM_DEFAULT_OUTPUT_CHANNELS				(6)
#define CRIATOM_DEFAULT_OUTPUT_SAMPLING_RATE		(48000)
#define CRIATOM_DEFAULT_INPUT_MAX_CHANNELS			(2)
#define CRIATOM_DEFAULT_INPUT_MAX_SAMPLING_RATE		(48000)
#define CRIATOM_DEFAULT_DECODE_LATENCY				(0)
#define CRIATOM_DEFAULT_DBAS_MAX_STREAMS			(8)
#define CRIATOM_SOUND_RENDERER_DEFAULT				(CRIATOM_SOUND_RENDERER_ASR)
#endif

/*==========================================================================
 *      CRI Atom Player API
 *=========================================================================*/
/*JP
 * \brief [v񐔐p
 * \ingroup ATOMLIB_PLAYER
 * \par :
 */
#define CRIATOMPLAYER_NO_LOOP_LIMITATION	(-1)		/*JP<[v񐔐Ȃ	*/
#define CRIATOMPLAYER_IGNORE_LOOP			(-2)		/*JP<[v𖳎	*/
#define CRIATOMPLAYER_FORCE_LOOP			(-3)		/*JP<[vĐ		*/

/*==========================================================================
 *      CRI Atom AWB API
 *=========================================================================*/
/*JP
 * \brief IAWBnh̍쐬ɕKvȃ[N̈TCY
 * \ingroup ATOMLIB_AWB
 * \par :
 * IAWBnh̍쐬ɕKvȃ[N̈TCYłB<br>
 * \sa criAtomAwb_LoadFromMemory
 */
#define CRIATOMAWB_WORKSIZE_FOR_LOADFROMMEMORY	(64)

 /*JP
  * \brief sȔg`f[^ID
  * \ingroup ATOMLIB_AWB
  * \par :
  * ::criAtomAwb_GetIdByIndex ֐ɎsۂɕԂlłB<br>
  * \sa criAtomAwb_GetIdByIndex
  */
#define CRIATOMAWB_ILLEGAL_ID (-1)

/*==========================================================================
 *      CRI Atom D-BAS API
 *=========================================================================*/
/*JP
 * \brief Atom D-BAS ID
 * \ingroup ATOMLIB_DBAS
 * \par :
 * ::criAtomDbas_Create ֐ɎsۂɕԂlłB <br>
 * \sa criAtomDbas_Create, criAtomDbas_Destroy
 */
#define CRIATOMDBAS_ILLEGAL_ID	(-1)

/*JP
 * \brief D-BAS쐬p̃ftHgőrbg[gl
 * \ingroup ATOMLIB_AWB
 * \par :
 * D-BAS쐬p̃ftHgp[^[l`łB<br>
 * evbgtH[Œ`ĂftHg̍őXg[{A
 * XeIADXf[^Xg[~OĐOŌvZĂ܂B <br>
 * \sa criAtomDbas_Create, criAtomDbas_CalculateWorkSize, criAtom_CalculateAdxBitrate
 */
#define CRIATOM_DEFAULT_DBAS_MAX_BPS \
	(criAtom_CalculateAdxBitrate(CRIATOM_DEFAULT_INPUT_MAX_CHANNELS,\
								 CRIATOM_DEFAULT_INPUT_MAX_SAMPLING_RATE)\
								 * CRIATOM_DEFAULT_DBAS_MAX_STREAMS)

/*JP
 * \brief D-BAS쐬p̃ftHg̃obt@[ۏؐ
 * \ingroup ATOMLIB_DBAS
 * \par :
 * D-BAS쐬p̃ftHg̃obt@[ۏؐłB
 * [v擪Aу[vI[ŋɒ[Ƀf[^ȂȂ鉹f[^łĂA
 * Xg[~OĐr؂邱ƂȂSɍĐpłlݒ肵Ă܂B
 * \sa criAtomDbas_Create, criAtomDbas_CalculateWorkSize
 */
#define CRIATOMDBAS_DEFAULT_NUM_SECUREMENT_BUFFERS	(4)

/*JP
 * \brief D-BAS쐬Ɏw\ȃobt@[ۏؐ̉l
 * \ingroup ATOMLIB_DBAS
 * \par :
 * D-BAS쐬Ɏw\ȃobt@[ۏؐ̉lłB
 * r؂ꂸɃXg[~OĐ邽߂ɂ́A
 * Œł2obt@[i_uobt@OjKvȂ߁A
 * 2̒lɐݒ肷鎖͂ł܂B
 * \sa criAtomDbas_Create, criAtomDbas_CalculateWorkSize
 */
#define CRIATOMDBAS_MINIMUM_NUM_SECUREMENT_BUFFERS	(2)


/* ========================================================================*/
/*       CRI Atom Streaming Cache API                                      */
/* ========================================================================*/
/*JP
 * \brief sȃXg[~OLbVIDl
 * \ingroup ATOMLIB_STREAMING_CACHE
 * \par :
 * ::criAtomStreamingCache_Create ֐ɎsۂɕԂlłB <br>
 * \sa criAtomStreamingCache_Create, criAtomStreamingCache_Destroy
 */
#define CRIATOM_STREAMING_CACHE_ILLEGAL_ID	(0)

/*JP
 * \brief Xg[~OLbVɃLbVt@C̃ftHgl
 * \ingroup ATOMLIB_STREAMING_CACHE
 * \par :
 * Xg[~OLbV쐬p̃ftHgp[^[l`łB<br>
 * LbV\ȃt@Cw肵܂B<br>
 * ftHgl10t@CłB<br>
 * \sa CriAtomStreamingCacheConfig
 */
#define CRIATOM_STREAMING_CACHE_DEFAULT_NUM_FILES	(10)

/*JP
 * \brief Xg[~OLbVɃLbVt@CTCỸftHgl
 * \ingroup ATOMLIB_STREAMING_CACHE
 * \par :
 * Xg[~OLbV쐬p̃ftHgp[^[l`łB<br>
 * LbV\ȃt@CTCY bytePʂŎw肵܂B<br>
 * ftHgl 1 MB łB<br>
 * \sa CriAtomStreamingCacheConfig
 */
#define CRIATOM_STREAMING_CACHE_DEFAULT_CACHE_SIZE	(1 * 1024 * 1024)

/*==========================================================================
 *      CRI Atom HCA-MX API
 *=========================================================================*/
/*JP
 * \brief HCA-MX̍ő~LT[
 * \ingroup ATOMLIB_HCA_MX
 * \par :
 * HCA-MX̍ő~LT[łB
 * CriAtomHcaMxConfig::num_mixers ̒ĺA̒lȉɐݒ肷Kv܂B
 * \sa CriAtomHcaMxConfig
 */
#define CRIATOM_HCA_MX_MAX_MIXERS (8)

/*JP
 * \brief HCA-MX̏o̓`l̍ől
 * \ingroup ATOMLIB_HCA_MX
 * \par :
 * HCA-MX̏o̓`l̍őlłB
 * CriAtomHcaMxConfig::output_channels ̒ĺA̒lȉɐݒ肷Kv܂B
 * \sa CriAtomHcaMxConfig
 */
#define CRIATOM_HCA_MX_MAX_OUTPUT_CHANNELS (8)

/***************************************************************************
 *      }N
 *      Macro Functions
 ***************************************************************************/
/*==========================================================================
 *      CRI Atom API
 *=========================================================================*/
/*JP
 * \brief CriAtomConfigւ̃ftHgp[^[Zbg
 * \ingroup ATOMLIB_GLOBAL
 * \param[out]	p_config	pRtBO\̂ւ̃|C^
 * \par :
 * ::criAtom_Initialize ֐ɐݒ肷RtBO\́i ::CriAtomConfig jɁA
 * ftHg̒lZbg܂B<br>
 * \sa
 * CriAtomConfig
*/
#define criAtom_SetDefaultConfig(p_config)	\
{\
	(p_config)->thread_model = CRIATOM_THREAD_MODEL_MULTI;\
	(p_config)->server_frequency = 60.0f;\
	(p_config)->fs_config = NULL;\
	(p_config)->context = NULL;\
	(p_config)->version = CRI_ATOM_VERSION;\
	(p_config)->version_string = CRI_ATOM_VER_NUM;\
	(p_config)->max_players = 16;\
}

/*JP
 * \brief [UAP[^[̓o^
 * \ingroup ATOMLIB_GLOBAL
 * \param[in]	p_malloc_func	mۊ֐
 * \param[in]	p_free_func		֐
 * \param[in]	p_obj			[UwIuWFNg
 * \par :
 * CRI Atom CuɃAP[^[i̊mہ^֐jo^܂B<br>
 * {}NŃAP[^[o^ƁAAtomCu[N̈KvƂ^C~OŁA
 * [Uo^mہ^Ăяo邱ƂɂȂ܂B<br>
 * ̌ʁA[N̈KvƂ֐i ::criAtomPlayer_CreateAdxPlayer ֐jɑ΂A
 * ʂɃ[N̈Zbg鏈ȗ邱Ƃ\ɂȂ܂B<br>
 * i[N̈ NULL |C^A[N̈TCY 0 oCgw肵ꍇłA
 * AP[^[̓Imۂɂ胉CuȂ삷悤ɂȂ܂Bj<br>
 * \par :
 * mہ^֐̃|C^ NULL w肷邱ƂŁA
 * AP[^[̓o^邱Ƃ\łB<br>
 * Ã̈悪cĂԂœo^ƁA
 * G[R[obNԂAo^̉Ɏs܂B<br>
 * io^ς݂̃AP[^[Ăяo邱ƂɂȂ܂Bj<br>
 * <br>
 * {}N͓I ::criAtom_SetUserMallocFunction ֐
 * ::criAtom_SetUserFreeFunction ֐Ăяo܂B<br>
 * {֐Ƃ API 𕹗pȂ悤ӂB<br>
 * i{֐̌ĂяoɂAL API ɃZbge㏑܂Bj<br>
 * <br>
 * ܂Ao^ꂽAP[^[֐̓}Xbh[hɕ̃XbhR[
 * 邱Ƃ܂B]āAAP[gXbhZ[tłȂꍇ͓Ǝ
 * AP[gr䂷Kv܂B
 */
#define criAtom_SetUserAllocator(p_malloc_func, p_free_func, p_obj)	\
{\
	criAtom_SetUserMallocFunction(p_malloc_func, p_obj);\
	criAtom_SetUserFreeFunction(p_free_func, p_obj);\
}

/*==========================================================================
 *      CRI Atom HCA-MX API
 *=========================================================================*/
/*JP
 * \brief HCA-MXRtBO\̂ɃftHglZbg
 * \ingroup ATOMLIB_HCA_MX
 * \par :
 * ::criAtomHcaMx_Initialize ֐ɐݒ肷RtBO\
 * i ::CriAtomHcaMxConfig jɁAftHglZbg܂B<br>
 * \sa criAtomHcaMx_Initialize, CriAtomHcaMxConfig
 */
#define criAtomHcaMx_SetDefaultConfig(p_config)	\
{\
	(p_config)->server_frequency = 60.0f;\
	(p_config)->num_mixers = 1;\
	(p_config)->max_players = 16;\
	(p_config)->max_input_channels = CRIATOM_DEFAULT_INPUT_MAX_CHANNELS;\
	(p_config)->max_sampling_rate = CRIATOM_DEFAULT_OUTPUT_SAMPLING_RATE;\
	(p_config)->output_channels = CRIATOM_DEFAULT_OUTPUT_CHANNELS;\
	(p_config)->output_sampling_rate = CRIATOM_DEFAULT_OUTPUT_SAMPLING_RATE;\
	(p_config)->sound_renderer_type	= CRIATOM_SOUND_RENDERER_DEFAULT;\
}

/*==========================================================================
 *      CRI Atom Player API
 *=========================================================================*/
/*JP
 * \brief CriAtomStandardPlayerConfigւ̃ftHgp[^[̃Zbg
 * \ingroup ATOMLIB_PLAYER
 * \param[out]	p_config	Wv[[쐬pRtBO\̂ւ̃|C^
 * \par :
 * ::criAtomPlayer_CreateStandardPlayer ֐ɐݒ肷RtBO\
 * i ::CriAtomStandardPlayerConfig jɁAftHg̒lZbg܂B<br>
 * \sa CriAtomStandardPlayerConfig, criAtomPlayer_CreateStandardPlayer
 */
#define criAtomPlayer_SetDefaultConfigForStandardPlayer(p_config)	\
{\
	(p_config)->max_channels		= CRIATOM_DEFAULT_INPUT_MAX_CHANNELS;\
	(p_config)->max_sampling_rate	= CRIATOM_DEFAULT_INPUT_MAX_SAMPLING_RATE;\
	(p_config)->streaming_flag		= CRI_FALSE;\
	(p_config)->sound_renderer_type	= CRIATOM_SOUND_RENDERER_DEFAULT;\
	(p_config)->decode_latency		= CRIATOM_DEFAULT_DECODE_LATENCY;\
	(p_config)->context				= NULL;\
}

/*JP
 * \brief CriAtomAdxPlayerConfigւ̃ftHgp[^[̃Zbg
 * \ingroup ATOMLIB_PLAYER
 * \param[out]	p_config	ADXv[[쐬pRtBO\̂ւ̃|C^
 * \par :
 * ::criAtomPlayer_CreateAdxPlayer ֐ɐݒ肷RtBO\
 * i ::CriAtomAdxPlayerConfig jɁAftHg̒lZbg܂B<br>
 * \sa CriAtomAdxPlayerConfig, criAtomPlayer_CreateAdxPlayer
 */
#define criAtomPlayer_SetDefaultConfigForAdxPlayer(p_config)	\
{\
	(p_config)->max_channels		= CRIATOM_DEFAULT_INPUT_MAX_CHANNELS;\
	(p_config)->max_sampling_rate	= CRIATOM_DEFAULT_INPUT_MAX_SAMPLING_RATE;\
	(p_config)->streaming_flag		= CRI_FALSE;\
	(p_config)->sound_renderer_type	= CRIATOM_SOUND_RENDERER_DEFAULT;\
	(p_config)->decode_latency		= CRIATOM_DEFAULT_DECODE_LATENCY;\
	(p_config)->context				= NULL;\
}

/*JP
 * \brief CriAtomHcaPlayerConfigւ̃ftHgp[^[̃Zbg
 * \ingroup ATOMLIB_PLAYER
 * \param[out]	p_config	HCAv[[쐬pRtBO\̂ւ̃|C^
 * \par :
 * ::criAtomPlayer_CreateHcaPlayer ֐ɐݒ肷RtBO\
 * i ::CriAtomHcaPlayerConfig jɁAftHg̒lZbg܂B<br>
 * \sa CriAtomHcaPlayerConfig, criAtomPlayer_CreateHcaPlayer
 */
#define criAtomPlayer_SetDefaultConfigForHcaPlayer(p_config)	\
{\
	(p_config)->max_channels		= CRIATOM_DEFAULT_INPUT_MAX_CHANNELS;\
	(p_config)->max_sampling_rate	= CRIATOM_DEFAULT_INPUT_MAX_SAMPLING_RATE;\
	(p_config)->streaming_flag		= CRI_FALSE;\
	(p_config)->sound_renderer_type	= CRIATOM_SOUND_RENDERER_DEFAULT;\
	(p_config)->decode_latency		= CRIATOM_DEFAULT_DECODE_LATENCY;\
	(p_config)->context				= NULL;\
}

/*JP
 * \brief CriAtomHcaMxPlayerConfigւ̃ftHgp[^[̃Zbg
 * \ingroup ATOMLIB_PLAYER
 * \param[out]	p_config	HCA-MXv[[쐬pRtBO\̂ւ̃|C^
 * \par :
 * ::criAtomPlayer_CreateHcaMxPlayer ֐ɐݒ肷RtBO\
 * i ::CriAtomHcaMxPlayerConfig jɁAftHg̒lZbg܂B<br>
 * \sa CriAtomHcaMxPlayerConfig, criAtomPlayer_CreateHcaMxPlayer
 */
#define criAtomPlayer_SetDefaultConfigForHcaMxPlayer(p_config)	\
{\
	(p_config)->max_channels		= CRIATOM_DEFAULT_INPUT_MAX_CHANNELS;\
	(p_config)->max_sampling_rate	= CRIATOM_DEFAULT_INPUT_MAX_SAMPLING_RATE;\
	(p_config)->streaming_flag		= CRI_FALSE;\
}

/*JP
 * \brief CriAtomWavePlayerConfigւ̃ftHgp[^[̃Zbg
 * \ingroup ATOMLIB_PLAYER
 * \param[out]	p_config	WAVEv[[쐬pRtBO\̂ւ̃|C^
 * \par :
 * ::criAtomPlayer_CreateWavePlayer ֐ɐݒ肷RtBO\
 * i ::CriAtomWavePlayerConfig jɁAftHg̒lZbg܂B<br>
 * \sa CriAtomWavePlayerConfig, criAtomPlayer_CreateWavePlayer
 */
#define criAtomPlayer_SetDefaultConfigForWavePlayer(p_config)	\
{\
	(p_config)->max_channels		= CRIATOM_DEFAULT_INPUT_MAX_CHANNELS;\
	(p_config)->max_sampling_rate	= CRIATOM_DEFAULT_INPUT_MAX_SAMPLING_RATE;\
	(p_config)->streaming_flag		= CRI_FALSE;\
	(p_config)->sound_renderer_type	= CRIATOM_SOUND_RENDERER_DEFAULT;\
	(p_config)->decode_latency		= CRIATOM_DEFAULT_DECODE_LATENCY;\
	(p_config)->context				= NULL;\
}

/*JP
 * \brief CriAtomAiffPlayerConfigւ̃ftHgp[^[̃Zbg
 * \ingroup ATOMLIB_PLAYER
 * \param[out]	p_config	AIFFv[[쐬pRtBO\̂ւ̃|C^
 * \par :
 * ::criAtomPlayer_CreateAiffPlayer ֐ɐݒ肷RtBO\
 * i ::CriAtomAiffPlayerConfig jɁAftHg̒lZbg܂B<br>
 * \sa CriAtomAiffPlayerConfig, criAtomPlayer_CreateAiffPlayer
 */
#define criAtomPlayer_SetDefaultConfigForAiffPlayer(p_config)	\
{\
	(p_config)->max_channels		= CRIATOM_DEFAULT_INPUT_MAX_CHANNELS;\
	(p_config)->max_sampling_rate	= CRIATOM_DEFAULT_INPUT_MAX_SAMPLING_RATE;\
	(p_config)->streaming_flag		= CRI_FALSE;\
	(p_config)->sound_renderer_type	= CRIATOM_SOUND_RENDERER_DEFAULT;\
	(p_config)->decode_latency		= CRIATOM_DEFAULT_DECODE_LATENCY;\
	(p_config)->context				= NULL;\
}

/*JP
 * \brief CriAtomRawPcmPlayerConfigւ̃ftHgp[^[̃Zbg
 * \ingroup ATOMLIB_PLAYER
 * \param[out]	p_config	RawPCMv[[쐬pRtBO\̂ւ̃|C^
 * \par :
 * ::criAtomPlayer_CreateRawPcmPlayer ֐ɐݒ肷RtBO\
 * i ::CriAtomRawPcmPlayerConfig jɁAftHg̒lZbg܂B<br>
 * \sa CriAtomRawPcmPlayerConfig, criAtomPlayer_CreateRawPcmPlayer
 */
#define criAtomPlayer_SetDefaultConfigForRawPcmPlayer(p_config)	\
{\
	(p_config)->pcm_format			= CRIATOM_PCM_FORMAT_SINT16;\
	(p_config)->max_channels		= CRIATOM_DEFAULT_INPUT_MAX_CHANNELS;\
	(p_config)->max_sampling_rate	= CRIATOM_DEFAULT_INPUT_MAX_SAMPLING_RATE;\
	(p_config)->sound_renderer_type	= CRIATOM_SOUND_RENDERER_DEFAULT;\
	(p_config)->decode_latency		= CRIATOM_DEFAULT_DECODE_LATENCY;\
	(p_config)->context				= NULL;\
}

/*JP
 * \brief CriAtomInstrumentPlayerConfigփftHgp[^[̃Zbg
 * \ingroup ATOMLIB_PLAYER
 * \param[out]	p_config	CXgDgv[[쐬pRtBO\̂ւ̃|C^
 * \par :
 * ::criAtomPlayer_CreateRawPcmPlayer ֐ɐݒ肷RtBO\
 * i ::CriAtomRawPcmPlayerConfig jɁAftHg̒lZbg܂B<br>
 * \sa criAtomExVoicePool_AllocateInstrumentVoicePool
 */
#define criAtomPlayer_SetDefaultConfigForInstrumentPlayer(p_config)	\
{\
	(p_config)->interface_name		= "";\
	(p_config)->instrument_name		= "";\
	(p_config)->max_channels		= CRIATOM_DEFAULT_INPUT_MAX_CHANNELS;\
	(p_config)->max_sampling_rate	= CRIATOM_DEFAULT_INPUT_MAX_SAMPLING_RATE;\
	(p_config)->sound_renderer_type = CRIATOM_SOUND_RENDERER_DEFAULT;\
}

/*==========================================================================
 *      CRI Atom D-BAS API
 *=========================================================================*/
/*JP
 * \brief CriAtomDbasConfig ւ̃ftHgp[^[̃Zbg
 * \ingroup ATOMLIB_DBAS
 * \param[out]	p_config	D-BAS쐬pRtBO\̂ւ̃|C^
 * \par :
 * ::criAtomDbas_Create ֐ɐݒ肷RtBO\
 * i ::CriAtomDbasConfig jɁAftHg̒lZbg܂B<br>
 * \sa CriAtomDbasConfig, criAtomDbas_Create, criAtomDbas_CalculateWorkSize
 */
#define criAtomDbas_SetDefaultConfig(p_config)	\
{\
	(p_config)->identifier	= 0;\
	(p_config)->max_streams	= CRIATOM_DEFAULT_DBAS_MAX_STREAMS;\
	(p_config)->max_bps		= CRIATOM_DEFAULT_DBAS_MAX_BPS;\
	(p_config)->max_mana_streams	= 0;\
	(p_config)->max_mana_bps		= 0;\
	(p_config)->num_securement_buffers = CRIATOMDBAS_DEFAULT_NUM_SECUREMENT_BUFFERS;\
}

/* ========================================================================*/
/*       CRI Atom Streaming Cache API                                      */
/* ========================================================================*/
/*JP
 * \brief CriAtomStreamingCacheConfigւ̃ftHgp[^[̃Zbg
 * \ingroup ATOMLIB_STREAMING_CACHE
 * \param[out]	p_config	Xg[~OLbV쐬pRtBO\̂ւ̃|C^
 * \par :
 * ::criAtomStreamingCache_CalculateWorkSize ֐A
 * ::criAtomStreamingCache_Create ֐ɐݒ肷RtBO\
 * i ::CriAtomStreamingCacheConfig jɑ΂AftHglZbg܂B<br>
 * \sa criAtomStreamingCache_CalculateWorkSize, criAtomStreamingCache_Create
 */
#define criAtomStreamingCache_SetDefaultConfig(p_config)	\
{\
	(p_config)->max_files		= CRIATOM_STREAMING_CACHE_DEFAULT_NUM_FILES;\
	(p_config)->max_path		= CRIFS_CONFIG_DEFAULT_MAX_PATH;\
	(p_config)->cache_size		= CRIATOM_STREAMING_CACHE_DEFAULT_CACHE_SIZE;\
}

/* ========================================================================*/
/*       CRI Atom Meter API                                                */
/* ========================================================================*/

/*JP
 * \brief x[^[@\RtBO\̂ɃftHglZbg
 * \ingroup ATOMLIB_METER
 * \par :
 * ::criAtomMeter_AttachLevelMeter ֐ɐݒ肷RtBO\
 * i ::CriAtomLevelMeterConfig jɁAftHglZbg܂B<br>
 * \sa criAtomMeter_AttachLevelMeter, CriAtomLevelMeterConfig
 */
#define criAtomMeter_SetDefaultConfigForLevelMeter(p_config) \
{\
	(p_config)->interval = 50;\
	(p_config)->hold_time = 1000;\
}

/*JP
 * \brief EhlX[^[@\RtBO\̂ɃftHglZbg
 * \ingroup ATOMLIB_ASR
 * \par :
 * ::criAtomMeter_AttachLoudnessMeter ֐ɐݒ肷RtBO\
 * i ::CriAtomLoudnessMeterConfig jɁAftHglZbg܂B<br>
 * \sa criAtomMeter_AttachLoudnessMeter, CriAtomLoudnessMeterConfig
 */
#define criAtomMeter_SetDefaultConfigForLoudnessMeter(p_config) \
{\
	(p_config)->short_term_time = 3;\
	(p_config)->integrated_time = 600;\
}

/*JP
 * \brief gD[s[N[^[@\RtBO\̂ɃftHglZbg
 * \ingroup ATOMLIB_ASR
 * \par :
 * ::criAtomMeter_AttachTruePeakMeter ֐ɐݒ肷RtBO\
 * i ::CriAtomTruePeakMeterConfig jɁAftHglZbg܂B<br>
 * \sa criAtomMeter_AttachTruePeakMeter, CriAtomTruePeakMeterConfig
 */
#define criAtomMeter_SetDefaultConfigForTruePeakMeter(p_config) \
{\
	(p_config)->sample_clipping = CRI_TRUE;\
	(p_config)->interval = 50;\
	(p_config)->hold_time = 1000; \
}

/***************************************************************************
 *      f[^^錾
 *      Data Type Declarations
 ***************************************************************************/
/*==========================================================================
 *      CRI Atom API
 *=========================================================================*/
/*JP
 * \brief Xbhf
 * \ingroup ATOMLIB_GLOBAL
 * \par :
 * CRI AtomCuǂ̂悤ȃXbhfœ삷邩\܂B<br>
 * Cui ::criAtom_Initialize ֐ j ::CriAtomConfig \̂ɂ
 * w肵܂B
 * \sa criAtom_Initialize, CriAtomConfig
 */
typedef enum CriAtomThreadModelTag {
	/*JP
	 * \brief }`Xbh
	 * \par :
	 * Cu͓ŃXbh쐬A}`Xbhɂē삵܂B<br>
	 * Xbh ::criAtom_Initialize ֐Ăяoɍ쐬܂B<br>
	 * CũT[o[́A쐬ꂽXbhŒIɎs܂B<br>
	 */
	CRIATOM_THREAD_MODEL_MULTI = 0,

	/* Tentative */
	CRIATOM_THREAD_MODEL_MULTI_WITH_SONICSYNC = 4,

	/*JP
	 * \brief }`Xbhi[U쓮j
	 * \par :
	 * Cu͓ŃXbh쐬A}`Xbhɂē삵܂B<br>
	 * Xbh ::criAtom_Initialize ֐Ăяoɍ쐬܂B<br>
	 * T[o[͍̂쐬ꂽXbhŎs܂A
	 * CRIATOM_THREAD_MODEL_MULTI Ƃ͈قȂAIɂ͎s܂B<br>
	 * [U ::criAtom_ExecuteMain ֐ŖIɃT[o[쓮Kv܂B<br>
	 * i  ::criAtom_ExecuteMain ֐sƁAXbhNAT[o[s܂Bj<br>
	 */
	CRIATOM_THREAD_MODEL_MULTI_USER_DRIVEN = 3,

	/*JP
	 * \brief [U}`Xbh
	 * \par :
	 * Cuł̓Xbh쐬܂񂪁A[UƎɍ쐬Xbh
	 * T[o[֐Ăяo悤A̔r͍s܂B<br>
	 * T[o[ ::criAtom_ExecuteMain ֐œs܂B<br>
	 */
	CRIATOM_THREAD_MODEL_USER_MULTI = 1,

	/*JP
	 * \brief VOXbh
	 * \par :
	 * CuŃXbh쐬܂B܂A̔rs܂B<br>
	 * T[o[ ::criAtom_ExecuteMain ֐œs܂B<br>
	 * \attention
	 * ̃fIꍇAeAPIƃT[o[֐Ƃ𓯈XbhĂяo悤ɂĂB<br>
	 */
	CRIATOM_THREAD_MODEL_SINGLE = 2,

	/* enum size is 4bytes */
	CRIATOM_THREAD_MODEL_ENUM_SIZE_IS_4BYTES = 0x7FFFFFFF
} CriAtomThreadModel;

/*JP
 * \brief CupRtBO\
 * \ingroup ATOMLIB_GLOBAL
 * \par :
 * CRI AtomCu̓dlw肷邽߂̍\̂łB<br>
 * ::criAtom_Initialize ֐̈Ɏw肵܂B<br>
 * <br>
 * CRI AtomCúAɖ{\̂Ŏw肳ꂽݒɉāA\[X
 * KvȂmۂ܂B<br>
 * CuKvƂ郏[N̈̃TCÝA{\̂Ŏw肳ꂽp[^[ɉ
 * ω܂B
 * \par l:
 * ftHgݒgpꍇA ::criAtom_SetDefaultConfig }Nō\̂ɃftHg
 * p[^[ZbgA ::criAtom_Initialize ֐ɍ\̂w肵ĂB<br>
 * \attention
 * IɃo\邽߁A
 * ::criAtom_SetDefaultConfig }NŕK\̂ĂB<br>
 * i\̂̃oɕslȂ悤ӂBj
 * \sa criAtom_Initialize, criAtom_SetDefaultConfig
 */
typedef struct CriAtomConfigTag {
	/*JP
		\brief Xbhf
		\par :
		CRI AtomCũXbhfw肵܂B<br>
		\sa CriAtomThreadModel
	*/
	CriAtomThreadModel thread_model;

	/*JP
		\brief T[o[̎spx
		\par :
		T[o[spxw肵܂B<br>
		ʏAAvP[Ṽt[[gƓlw肵܂B<br>
		<br>
		CRI AtomCúAt@Cǂݍ݂̊ǗAf[^̃fR[hȀóA
		Xe[^X̍XVACuōŝقƂǂ1̊֐ł܂Ƃ߂
		s܂B<br>
		CRI~hEFAł́ACȕꊇčs֐̂Ƃ
		"T[o["ƌĂł܂B<br>
		<br>
		Xbhf ::CRIATOM_THREAD_MODEL_MULTI ̏ꍇAT[o[CRI AtomCu
		쐬XbhŁAIɎs܂B<br>
		Xbhf ::CRIATOM_THREAD_MODEL_SINGLE  ::CRIATOM_THREAD_MODEL_USER_MULTI
		̏ꍇAT[o[ ::criAtom_ExecuteMain ֐Ŏs܂B<br>
		<br>
		server_frequency ɂ́AT[o[spxw肵܂B<br>
		Xbhf ::CRIATOM_THREAD_MODEL_MULTI ̏ꍇACRI AtomCu͎w肳ꂽ
		pxŃT[o[s悤AT[o[̌ĂяoԊu𒲐߂܂B<br>
		Xbhf ::CRIATOM_THREAD_MODEL_SINGLE  ::CRIATOM_THREAD_MODEL_USER_MULTI
		̏ꍇA[U ::criAtom_ExecuteMain ֐ server_frequency Ŏw肵pxȏ
		ŎsKv܂B<br>
		<br>
		AvP[Ṽt[[g̕ϓ傫AT[o[spxɃocL
		łĂ܂ꍇɂ́Aň̃t[[gz肵 server_frequency ̒lw
		邩A܂̓Xbhf ::CRIATOM_THREAD_MODEL_MULTI w肵ĂB
		\par l:
		T[o[̎spx𑽂ƁAPʃT[o[̏ʁifR[hʓj
		ȂȂ܂B
		̌ʁAPʃT[o[ׂ̏͏Ȃ܂iׂU܂jA
		T[o[̎sɔI[o[wbh͑傫Ȃ܂B<br>
		igуQ[@ACPU\[XȂŃT[o[̎spx𑽂ꍇA
		T[o[̎sɔI[o[wbhłȂȂ\܂Bj<br>
		<br>
		T[o[̎spxȂƁAPʃT[o[̏ʂȂ܂B<br>
		T[o[̎sɔI[o[wbh͒ጸ܂APʃT[o[̕
		Ȃ邽߁At[̖肪鋰ꂪ܂B<br>
		\attention
		Xbhf ::CRIATOM_THREAD_MODEL_SINGLE  ::CRIATOM_THREAD_MODEL_USER_MULTI
		w肵ɂ炸A ::criAtom_ExecuteMain ֐ server_frequency 
		w肵lȉ̕pxłsȂꍇAĐ̉r؂铙̖肪
		\܂̂ŁAӂB<br>
		\sa criAtom_ExecuteMain
	*/
	CriFloat32 server_frequency;

	/*JP
		\brief CRI File System ̏p[^[ւ̃|C^
		\par :
		CRI File System̏p[^[ւ̃|C^w肵܂B
		NULLw肵ꍇAftHgp[^[CRI File System܂B
		\sa criAtom_Initialize
	*/
	const CriFsConfig *fs_config;

	/*JP
		\brief vbgtH[ŗL̏p[^[ւ̃|C^
		\par :
		CRI AtomCu𓮍삳邽߂ɕKvȁA
		vbgtH[ŗL̏p[^[ւ̃|C^w肵܂B
		NULLw肵ꍇAftHgp[^[ŃvbgtH[ɕKvȏs܂B<br>
		p[^[\̂͊evbgtH[ŗLwb_[ɒ`Ă܂B
		p[^[\̂`ĂȂvbgtH[ł́ANULLw肵ĂB
		\sa criAtom_Initialize
	*/
	void *context;

	/*JP
		\brief Cuo[Wԍ
		\par :
		CRI AtomCũo[WԍłB<br>
		::criAtom_SetDefaultConfig }NɂA{wb_[ɒ`Ăo[Wԍݒ肳܂B<br>
		\attention
		AvP[Vł́A̒lύXȂłB<br>
	 */
	CriUint32 version;

	/*JP
		\brief Cuo[W
		\par :
		CRI AtomCũo[WłB<br>
		::criAtom_SetDefaultConfig }NɂA{wb_[ɒ`Ăo[W񂪐ݒ肳܂B<br>
		\attention
		AvP[Vł́A̒lύXȂłB<br>
	 */
	const CriChar8 *version_string;

	/*JP
		\brief őv[[
		\par :
		AvP[VŎgpv[[iCriAtomPlayerj̐w肵܂B<br>
		AvP[V ::criAtomPlayer_CreateStandardPlayer ֐gpăv[[쐬ꍇA
		{p[^[Ɏgpv[[̐w肷Kv܂B<br>
		<br>
		max_playersɂ́uɎgpv[[̍ő吔vw肵܂B<br>
		Ⴆ΁A ::criAtomPlayer_CreateStandardPlayer ֐ ::criAtomPlayer_Destroy ֐݂ɑĎsP[XɂẮA
		ő哯ɂ1̃v[[gpȂ߁A֐̌Ăяo񐔂Ɋ֌WȂmax_players1w肷邱Ƃ\łB<br>
		tɁAʂŃv[[10gpꍇɂ́Ȃ̏ʂŃv[[SgpȂꍇłĂA
		max_players10w肷Kv܂B<br>
		\sa criAtomPlayer_CreateStandardPlayer, criAtomPlayer_Destroy
	*/
	CriSint32 max_players;
} CriAtomConfig;

/*JP
 * \brief mۊ֐
 * \ingroup ATOMLIB_GLOBAL
 * \param[in]	obj		[UwIuWFNg
 * \param[in]	size	vTCYioCgPʁj
 * \return		void*	mۂ̃AhXisNULLj
 * \par :
 * mۊ֐o^p̃C^[tF[XłB<br>
 * CRI AtomCuCuōsmۏA
 * [UƎ̃mۏɒuꍇɎgp܂B<br>
 * \par l:
 * R[obN֐sۂɂ́AsizeɕKvƂ郁̃TCYZbg
 * Ă܂B<br>
 * R[obN֐sizẽmۂAmۂ̃AhX
 * ߂lƂĕԂĂB<br>
 * A obj ɂ́A::criAtom_SetUserMallocFunction ֐œo^[Uw
 * IuWFNgn܂B<br>
 * mێɃ}l[W[QƂKvꍇɂ́A
 * YIuWFNg ::criAtom_SetUserMallocFunction ֐̈ɃZbgĂA
 * {R[obN֐̈oRĎQƂĂB<br>
 * \attention
 * ̊mۂɎsꍇAG[R[obNԂꂽAĂяo̊֐
 * s\܂̂łӂB
 * \sa CriAtomFreeFunc, criAtom_SetUserMallocFunction
 */
typedef void *(CRIAPI *CriAtomMallocFunc)(void *obj, CriUint32 size);

/*JP
 * \brief ֐
 * \ingroup ATOMLIB_GLOBAL
 * \param[in]	obj		[UwIuWFNg
 * \param[in]	mem		郁AhX
 * \return				Ȃ
 * \par :
 * ֐o^p̃C^[tF[XłB<br>
 * CRI AtomCuCuōsA
 * [UƎ̃ɒuꍇɎgp܂B<br>
 * \par l:
 * R[obN֐sۂɂ́Amemɉׂ̃AhXZbg
 * Ă܂B<br>
 * R[obN֐mem̗̈̃ĂB
 * A obj ɂ́A::criAtom_SetUserFreeFunction ֐œo^[Uw
 * IuWFNgn܂B<br>
 * mێɃ}l[W[QƂKvꍇɂ́A
 * YIuWFNg ::criAtom_SetUserFreeFunction ֐̈ɃZbgĂA
 * {R[obN֐̈oRĎQƂĂB<br>
 * \sa CriAtomMallocFunc, criAtom_SetUserFreeFunction
 */
typedef void (CRIAPI *CriAtomFreeFunc)(void *obj, void *mem);

/*JP
 * \brief I[fBIt[JnR[obN֐
 * \ingroup ATOMLIB_GLOBAL
 * \param[in]	obj		[UwIuWFNg
 * \return				Ȃ
 * \par :
 * I[fBIt[̊JnɎsR[obN֐łB<br>
 * I[fBIt[́ACRI AtomCuŃT[o[s^C~O܂B<br>
 * R[obN֐̓o^ɂ ::criAtom_SetAudioFrameStartCallback ֐gp܂B<br>
 * o^R[obN֐́AI[fBIt[̊JniT[o[JnOjɎs܂B
 * \par l:
 * CuɃXbhf}`Xbhi ::CRIATOM_THREAD_MODEL_MULTI j
 * ɐݒ肵ꍇA{R[obN֐CRI AtomCuō쐬ꂽXbh
 * Ăяo܂B<br>
 * CuɃXbhf[U}`Xbhi ::CRIATOM_THREAD_MODEL_USER_MULTI jA
 * ܂̓VOXbhi ::CRIATOM_THREAD_MODEL_SINGLE jɐݒ肵ꍇA{R[obN֐
 * ::criAtom_ExecuteMain ֐ŌĂяo܂B<br>
 * <br>
 * A obj ɂ́A::criAtom_SetAudioFrameStartCallback ֐œo^[Uw
 * IuWFNgn܂B<br>
 * \sa criAtom_SetAudioFrameStartCallback
 */
typedef void (CRIAPI *CriAtomAudioFrameStartCbFunc)(void *obj);

/*JP
 * \brief I[fBIt[IR[obN֐
 * \ingroup ATOMLIB_GLOBAL
 * \param[in]	obj		[UwIuWFNg
 * \return				Ȃ
 * \par :
 * I[fBIt[̏IɎsR[obN֐łB<br>
 * I[fBIt[́ACRI AtomCuŃT[o[s^C~O܂B<br>
 * R[obN֐̓o^ɂ ::criAtom_SetAudioFrameEndCallback ֐gp܂B<br>
 * o^R[obN֐́AI[fBIt[̏IiT[o[IjɎs܂B<br>
 * \par l:
 * CuɃXbhf}`Xbhi ::CRIATOM_THREAD_MODEL_MULTI j
 * ɐݒ肵ꍇA{R[obN֐CRI AtomCuō쐬ꂽXbh
 * Ăяo܂B<br>
 * CuɃXbhf[U}`Xbhi ::CRIATOM_THREAD_MODEL_USER_MULTI jA
 * ܂̓VOXbhi ::CRIATOM_THREAD_MODEL_SINGLE jɐݒ肵ꍇA{R[obN֐
 * ::criAtom_ExecuteMain ֐ŌĂяo܂B<br>
 * <br>
 * A obj ɂ́A::criAtom_SetAudioFrameEndCallback ֐œo^[Uw
 * IuWFNgn܂B<br>
 * \sa criAtom_SetAudioFrameEndCallback
 */
typedef void (CRIAPI *CriAtomAudioFrameEndCbFunc)(void *obj);

/*JP
 * \brief TEh_^Cv
 * \ingroup ATOMLIB_GLOBAL
 * \par :
 * Atomv[[A܂ASRō쐬TEh_̎ʂw肷邽߂̃f[^^łB<br>
 * Atomv[[ASR쐬ɃRtBO\̂̃p[^[ƂĎw肵܂B
 * \attention
 * ::CRIATOM_SOUND_RENDERER_ANY  ::criAtomExPlayer_SetSoundRendererType ֐ɑ΂Ă̂ݎw\łB<br>
 * {CXv[쐬ɂ͎gpł܂B<br>
 * \sa CriAtomAdxPlayerConfig, criAtomPlayer_CreateAdxPlayer, criAtomExAsrRack_Create
 */
typedef enum CriAtomSoundRendererTypeTag {
	CRIATOM_SOUND_RENDERER_NATIVE	= 1,		/*JP<vbgtH[Cu֏o	*/
	CRIATOM_SOUND_RENDERER_ASR		= 2,		/*JP<Atom Sound Renderer֏o			*/
	CRIATOM_SOUND_RENDERER_EXTENDED = 3,
	CRIATOM_SOUND_RENDERER_SPATIAL	= 4,		/*JP<̉o						*/

	CRIATOM_SOUND_RENDERER_HW1 = (0 << 16) | CRIATOM_SOUND_RENDERER_NATIVE,		/*JP<@ŗL`1						*/
	CRIATOM_SOUND_RENDERER_HW2 = (1 << 16) | CRIATOM_SOUND_RENDERER_NATIVE,		/*JP<@ŗL`2						*/
	CRIATOM_SOUND_RENDERER_HW3 = (2 << 16) | CRIATOM_SOUND_RENDERER_NATIVE,		/*JP<@ŗL`3						*/
	CRIATOM_SOUND_RENDERER_HW4 = (3 << 16) | CRIATOM_SOUND_RENDERER_NATIVE,		/*JP<@ŗL`4						*/
	CRIATOM_SOUND_RENDERER_FORCED_NATIVE = (15 << 16) | CRIATOM_SOUND_RENDERER_NATIVE,	/* Platform Specific */

	CRIATOM_SOUND_RENDERER_HAPTIC = (0 << 16) | CRIATOM_SOUND_RENDERER_EXTENDED,	/*JP<U								*/
	CRIATOM_SOUND_RENDERER_PSEUDO = (1 << 16) | CRIATOM_SOUND_RENDERER_EXTENDED,	/*JP<								*/

	/* ASR̍쐬̂ݎgp\ */
	CRIATOM_SOUND_RENDERER_SPATIAL_CHANNELS =	(0 << 16) | CRIATOM_SOUND_RENDERER_SPATIAL,	/*JP<XyVCUt`lx[XĐ	 */
	CRIATOM_SOUND_RENDERER_AMBISONICS		=	(1 << 16) | CRIATOM_SOUND_RENDERER_SPATIAL,	/*JP<AmbisonicsĐ					*/
	CRIATOM_SOUND_RENDERER_PASSTHROUGH		=	(2 << 16) | CRIATOM_SOUND_RENDERER_SPATIAL,	/*JP<pXX[Đ				*/
	CRIATOM_SOUND_RENDERER_OBJECT			=	(3 << 16) | CRIATOM_SOUND_RENDERER_SPATIAL,	/*JP<IuWFNgx[XĐ			*/

	CRIATOM_SOUND_RENDERER_ANY = 0,			/*JP<o͕𐧌Ȃ				*/

	/* enum size is 4bytes */
	CRIATOM_SOUND_RENDERER_ENUM_SIZE_IS_4BYTES = 0x7FFFFFFF
} CriAtomSoundRendererType;

/*JP
 * \brief Xs[J[ID
 * \ingroup ATOMLIB_GLOBAL
 * \par :
 * o͂Xs[J[w肷邽߂IDłB<br>
 * ::criAtomPlayer_SetSendLevel ֐ŗp܂B
 * \sa criAtomPlayer_SetSendLevel
 */
typedef enum CriAtomSpeakerIdTag {
	CRIATOM_SPEAKER_FRONT_LEFT = 0,				/*JP<tgtgXs[J[			*/
	CRIATOM_SPEAKER_FRONT_RIGHT = 1,			/*JP<tgCgXs[J[			*/
	CRIATOM_SPEAKER_FRONT_CENTER = 2,			/*JP<tgZ^[Xs[J[			*/
	CRIATOM_SPEAKER_LOW_FREQUENCY = 3,			/*JP<LFEiTuE[n[j				*/
	CRIATOM_SPEAKER_SURROUND_LEFT = 4,			/*JP<TEhtgXs[J[			*/
	CRIATOM_SPEAKER_SURROUND_RIGHT = 5,			/*JP<TEhCgXs[J[			*/
	CRIATOM_SPEAKER_SURROUND_BACK_LEFT = 6,		/*JP<TEhobNtgXs[J[	*/
	CRIATOM_SPEAKER_SURROUND_BACK_RIGHT = 7,	/*JP<TEhobNCgXs[J[	*/
	CRIATOM_SPEAKER_TOP_FRONT_LEFT = 8,			/*JP<gbvtgtgXs[J[		*/
	CRIATOM_SPEAKER_TOP_FRONT_RIGHT = 9,		/*JP<gbvtgCgXs[J[		*/
	CRIATOM_SPEAKER_TOP_BACK_LEFT = 10,			/*JP<gbvobNtgXs[J[		*/
	CRIATOM_SPEAKER_TOP_BACK_RIGHT = 11,		/*JP<gbvobNCgXs[J[		*/
	CRIATOM_SPEAKER_BOTTOM_FRONT_LEFT = 12,		/*JP<{gtgtgXs[J[		*/
	CRIATOM_SPEAKER_BOTTOM_FRONT_RIGHT = 13,	/*JP<{gtgCgXs[J[		*/
	CRIATOM_SPEAKER_BOTTOM_BACK_LEFT = 14,		/*JP<{gobNtgXs[J[		*/
	CRIATOM_SPEAKER_BOTTOM_BACK_RIGHT = 15,		/*JP<{gobNCgXs[J[		*/

	/* enum size is 4bytes */
	CRIATOM_SPEAKER_ENUM_SIZE_IS_4BYTES = 0x7FFFFFFF
} CriAtomSpeakerId;

/*JP
 * \brief ptH[}X
 * \ingroup ATOMLIB_GLOBAL
 * \par :
 * ptH[}X擾邽߂̍\̂łB<br>
 * ::criAtom_GetPerformanceInfo ֐ŗp܂B
 * \sa criAtom_GetPerformanceInfo
 */
typedef struct CriAtomPerformanceInfoTag {
	CriUint32 server_process_count;		/*JP<T[o[s									*/
	CriUint32 last_server_time;			/*JP<T[o[Ԃ̍ŏIvli}CNbPʁj		*/
	CriUint32 max_server_time;			/*JP<T[o[Ԃ̍őli}CNbPʁj			*/
	CriUint32 average_server_time;		/*JP<T[o[Ԃ̕ϒli}CNbPʁj			*/
	CriUint32 last_server_interval;		/*JP<T[o[sԊu̍ŏIvli}CNbPʁj	*/
	CriUint32 max_server_interval;		/*JP<T[o[sԊu̍őli}CNbPʁj		*/
	CriUint32 average_server_interval;	/*JP<T[o[sԊu̕ϒli}CNbPʁj		*/
} CriAtomPerformanceInfo;

/*JP
 * \brief GR[hi
 * \ingroup ATOMLIB_GLOBAL
 * \par :
 * CRI Atom Encoder, CRI Atom CraftŐݒ肳GR[hĩf[^^łB<br>
 * f[^̃rbg[gvZƂɎgp܂B
 * \sa criAtom_CalculateHcaBitrate, criAtom_CalculateHcaMxBitrate
 */
typedef enum CriAtomEncodeQualityTag {
	CRIATOM_ENCODE_QUALITY_LOWEST = 0,	/*JP<Œiݒ	*/
	CRIATOM_ENCODE_QUALITY_LOW,			/*JP<iݒ		*/
	CRIATOM_ENCODE_QUALITY_MIDDLE,		/*JP<iݒ		*/
	CRIATOM_ENCODE_QUALITY_HIGH,		/*JP<iݒ		*/
	CRIATOM_ENCODE_QUALITY_HIGHEST,		/*JP<ōiݒ	*/

	/* enum size is 4bytes */
	CRIATOM_ENCODE_QUALITY_ENUM_SIZE_IS_4BYTES = 0x7FFFFFFF
} CriAtomEncodeQuality;

/*JP
 * \brief tH[}bg
 * \ingroup ATOMLIB_GLOBAL
 * \par :
 * f[^̃tH[}bgf[^^łB<br>
 * ȉ̂ꂩ̒lp\łB<br>
 * - ::CRIATOM_FORMAT_ADX
 * - ::CRIATOM_FORMAT_HCA
 * - ::CRIATOM_FORMAT_HCA_MX
 * - ::CRIATOM_FORMAT_WAVE
 * - ::CRIATOM_FORMAT_RAW_PCM
 * - ::CRIATOM_FORMAT_AIFF
 * - ::CRIATOM_FORMAT_VIBRATION
 * - ::CRIATOM_FORMAT_AUDIO_BUFFER
 * - ::CRIATOM_FORMAT_HW1
 * - ::CRIATOM_FORMAT_HW2
* - ::CRIATOM_FORMAT_HW3
 *
 */
typedef CriUint32 CriAtomFormat;
#define CRIATOM_FORMAT_NONE			(0x00000000)		/*JP< Ȃ				*/
#define CRIATOM_FORMAT_ADX			(0x00000001)		/*JP< ADX				*/
#define CRIATOM_FORMAT_HCA			(0x00000003)		/*JP< HCA				*/
#define CRIATOM_FORMAT_HCA_MX		(0x00000004)		/*JP< HCA-MX			*/
#define CRIATOM_FORMAT_WAVE			(0x00000005)		/*JP< Wave				*/
#define CRIATOM_FORMAT_RAW_PCM		(0x00000006)		/*JP< Raw PCM			*/
#define CRIATOM_FORMAT_AIFF			(0x00000007)		/*JP< AIFF				*/
#define CRIATOM_FORMAT_VIBRATION	(0x00000008)		/*JP< U				*/
#define CRIATOM_FORMAT_AUDIO_BUFFER	(0x00000009)		/*JP< AudioBuffer		*/
#define CRIATOM_FORMAT_INSTRUMENT	(0x0000000C)		/*JP< CXgDg*/
#define CRIATOM_FORMAT_INPUT_PORT	(0x00000100)		/*JP< ̓|[g		*/
#define CRIATOM_FORMAT_MIC_INPUT	(0x00000101)		/*JP< }CN		*/
#define CRIATOM_FORMAT_AUX_INPUT	(0x00000102)		/*JP< AUX			*/
#define CRIATOM_FORMAT_HW1			(0x00010001)		/*JP< n[hEFAŗL	*/
#define CRIATOM_FORMAT_HW2			(0x00010002)		/*JP< n[hEFAŗL	*/
#define CRIATOM_FORMAT_HW3			(0x00010003)		/*JP< n[hEFAŗL	*/

/*JP
 * \brief f[^tH[}bg
 * \ingroup ATOMLIB_GLOBAL
 * \par :
 * f[^̃tH[}bgłB<br>
 * ::criAtomPlayer_GetFormatInfo ֐Ŏgp܂B<br>
 * \sa criAtomPlayer_GetFormatInfo
 */
typedef struct CriAtomFormatInfoTag {
	CriAtomFormat format;				/*JP< tH[}bg		*/
	CriSint32 sampling_rate;			/*JP< TvOg	*/
	CriSint64 num_samples;				/*JP< Tv			*/
	CriSint64 loop_offset;				/*JP< [vJnTv	*/
	CriSint64 loop_length;				/*JP< [vԃTv	*/
	CriSint32 num_channels;				/*JP< `l			*/
	CriUint32 reserved[1];				/*JP< \̈				*/
} CriAtomFormatInfo;

/*JP
 * \brief PCMtH[}bg
 * \ingroup ATOMLIB_GLOBAL
 * \par :
 * PCMf[^̌^łB
 * \sa criAtomPlayer_SetFilterCallback
 */
typedef enum CriAtomPcmFormatTag {
	CRIATOM_PCM_FORMAT_SINT16 = 0,
	CRIATOM_PCM_FORMAT_FLOAT32,

	/* enum size is 4bytes */
	CRIATOM_PCM_FORMAT_ENUM_SIZE_IS_4BYTES = 0x7FFFFFFF
} CriAtomPcmFormat;

/*JP
 * \brief Xg[~O
 * \ingroup ATOMLIB_GLOBAL
 * \par :
 * ::criAtom_GetStreamingInfo ֐Ŏ擾_ł̃Xg[~Ȍ󋵂łB<br>
 * \sa criAtom_GetStreamingInfo
 */
typedef struct CriAtomStreamingInfoTag {
	/*JP
		\brief ݂̃Xg[~O
		\par :
		擾_ł̃Xg[~OłB<br>
		Xg[~OĐ̑ɔA̒lω܂B<br>
	*/
	CriSint32	num_streaming;	/*JP< 				*/

	/*JP
		\brief ݂̃Xg[~Orbg[g
		\par :
		擾_ł̑SXg[~OĐ̍vrbg[głB<br>
		Xg[~OĐ̑ɔA̒lω܂B<br>
		Pʂ [bps] ibit / bjłB<br>
	*/
	CriFloat32	total_bps;

	/*JP
		\brief ݂̍ňĐJnCeV
		\par :
		擾_ł́AVXg[~OĐ̍ĐJnCeV
		̗\ňlłB<br>
		Pʂ [b] łB<br>
		̒l͒x̍őlɂė\łA
		VXg[~OĐɂ̒l̎ԕx킯ł͂܂B<br>
		\attention
		ۂɂ́AVXg[~OĐǉꂽA<br>
		Xg[f[^̃rbg[gǂݍ܂Ă琳mȒxԂČvZ܂B<br>
	*/
	CriFloat32	worst_latency;
} CriAtomStreamingInfo;

/*JP
 * \brief p[^[ID
 * \ingroup ATOMLIB_PLAYER
 * \par :
 * p[^[w肷邽߂IDłB<br>
 */
typedef enum CriAtomParameterIdTag {
	CRIATOM_PARAMETER_ID_VOLUME					=  0,	/*JP< {[ */
	CRIATOM_PARAMETER_ID_FREQUENCY_RATIO		=  1,	/*JP< g */

	/* enum size is 4bytes */
	CRIATOM_PARAMETER_ID_ENUM_SIZE_IS_4BYTES = 0x7FFFFFFF
} CriAtomParameterId;

/*JP
 * \brief {CX~R
 * \ingroup ATOMLIB_GLOBAL
 * \par :
 * {CX̒~R\܂B
 */
typedef enum CriAtomVoiceStopReasonTag {
	CRIATOM_VOICE_STOP_REASON_EXPLAYER_STOP = 0,					/*JP< EXv[[~		*/
	CRIATOM_VOICE_STOP_REASON_EXPLAYER_STOPWITHOUTRELEASE,			/*JP< EXv[[~		*/
	CRIATOM_VOICE_STOP_REASON_PLAYBACK_STOP,						/*JP< ĐIDw~	*/
	CRIATOM_VOICE_STOP_REASON_PLAYBACK_STOPWITHOUTRELEASE,			/*JP< ĐIDw葦~	*/
	CRIATOM_VOICE_STOP_REASON_SOUNDPLAYER_DESTROY,					/*JP< TEhv[[j		*/
	CRIATOM_VOICE_STOP_REASON_FADER_STOP,							/*JP< tF[_[~		*/
	CRIATOM_VOICE_STOP_REASON_PLAYER_STOP,							/*JP< v[[~		*/
	CRIATOM_VOICE_STOP_REASON_AWB_STOP,								/*JP< AWB~			*/
	CRIATOM_VOICE_STOP_REASON_STREAMING_CACHE_STOP,					/*JP< Xg[~OLbV~			*/
	CRIATOM_VOICE_STOP_REASON_PLAYER_FORCE_STOP,					/*JP< v[[~		*/
	CRIATOM_VOICE_STOP_REASON_PLAYER_DESTROY,						/*JP< v[[j		*/
	CRIATOM_VOICE_STOP_REASON_MTPLAYER_STOP,						/*JP< MTv[[j		*/
	CRIATOM_VOICE_STOP_REASON_VOICE_POOL_DESTROY,					/*JP< {CXv[j		*/
	CRIATOM_VOICE_STOP_REASON_VOICE_STEAL_CASE1,					/*JP< {CXD		*/
	CRIATOM_VOICE_STOP_REASON_VOICE_STEAL_CASE2,					/*JP< {CXD		*/
	CRIATOM_VOICE_STOP_REASON_VOICE_STEAL_CASE3,					/*JP< {CXD		*/
	CRIATOM_VOICE_STOP_REASON_VOICE_STEAL_CASE4,					/*JP< {CXD		*/
	CRIATOM_VOICE_STOP_REASON_SOUND_SERVER_RESULT_VIRTUAL_VOICE_BEYOND_LIFE_TIME,	/*JP< T[o[			*/
	CRIATOM_VOICE_STOP_REASON_SOUND_SERVER_RESULT_CANT_CALC_3DPOS,					/*JP< T[o[			*/
	CRIATOM_VOICE_STOP_REASON_SOUND_SERVER_RESULT_INTERNAL_PLAYBACK_CANCEL,			/*JP< T[o[			*/
	CRIATOM_VOICE_STOP_REASON_SOUND_SERVER_RESULT_NO_PLAYER_NO_RETRY,				/*JP< T[o[			*/
	CRIATOM_VOICE_STOP_REASON_SOUND_SERVER_RESULT_FAILED_RETRY_BEYOND_LIFE_TIME,	/*JP< T[o[			*/
	CRIATOM_VOICE_STOP_REASON_SOUND_SERVER_RESULT_PLAYER_STATUS_PLAYEND,			/*JP< T[o[			*/
	CRIATOM_VOICE_STOP_REASON_SOUND_SERVER_RESULT_PLAYER_STATUS_ERROR,				/*JP< T[o[			*/
	CRIATOM_VOICE_STOP_REASON_SOUND_SERVER_RESULT_IMPOSSIBLE_RETRY,					/*JP< T[o[			*/
	CRIATOM_VOICE_STOP_REASON_SOUND_SERVER_RESULT_PLAYER_STATUS_STOP,				/*JP< T[o[			*/
	CRIATOM_VOICE_STOP_REASON_SOUND_SERVER_RESULT_INVALID_SERVER_REQUEST,			/*JP< T[o[			*/
	CRIATOM_VOICE_STOP_REASON_SOUND_SERVER_RESULT_SILENT_MODE_STOP,					/*JP< T[o[			*/
	CRIATOM_VOICE_STOP_REASON_SOUND_SERVER_RESULT_SOUNDCOMPLEX_STATUS_ERROR,		/*JP< T[o[			*/
	CRIATOM_VOICE_STOP_REASON_SOUND_SERVER_RESULT_NO_ELEMENT_CASE1,					/*JP< T[o[			*/
	CRIATOM_VOICE_STOP_REASON_SOUND_SERVER_RESULT_NO_ELEMENT_CASE2,					/*JP< T[o[			*/
	CRIATOM_VOICE_STOP_REASON_SOUND_SERVER_RESULT_STOP_NOT_PLAYING_ELEMENT,			/*JP< T[o[			*/
	CRIATOM_VOICE_STOP_REASON_SOUND_SERVER_RESULT_NOT_ACTIVE_VOICE,					/*JP< T[o[			*/
	CRIATOM_VOICE_STOP_REASON_ELEMENT_FREE,							/*JP< Gg		*/
	CRIATOM_VOICE_STOP_REASON_EXPLAYER_STOP_ERROR_HN,				/*JP< G[v[[̒~		*/
	CRIATOM_VOICE_STOP_REASON_ACB_RELEASE,							/*JP< ACB		*/
	CRIATOM_VOICE_STOP_REASON_VOICE_ALLOCATE_FAIL,					/*JP< {CXmێs		*/
	CRIATOM_VOICE_STOP_REASON_VOICE_RESET,							/*JP< {CXZbg		*/
	CRIATOM_VOICE_STOP_REASON_VOICE_VIRTUALIZE,						/*JP< {CXo[`		*/
	CRIATOM_VOICE_STOP_REASON_PLAYBACKSOUND_ALLOCATE_FAIL,			/*JP< vCobNTEhmێs		*/
	CRIATOM_VOICE_STOP_REASON_STOP_ACTION_WITH_BEATSYNC,			/*JP< r[g~ANV		*/
	CRIATOM_VOICE_STOP_REASON_START_CANCEL_WITH_BEATSYNC,			/*JP< r[gĐLZ		*/
	CRIATOM_VOICE_STOP_REASON_STOP_ACTION,							/*JP< ~ANV		*/
	CRIATOM_VOICE_STOP_REASON_BLOCK_TRANSITION_CASE0,				/*JP< ubNJ			*/
	CRIATOM_VOICE_STOP_REASON_BLOCK_TRANSITION_CASE1,				/*JP< ubNJ			*/
	CRIATOM_VOICE_STOP_REASON_BLOCK_TRANSITION_CASE2,				/*JP< ubNJ			*/
	CRIATOM_VOICE_STOP_REASON_BLOCK_TRANSITION_CASE3,				/*JP< ubNJ			*/
	CRIATOM_VOICE_STOP_REASON_CATEGORY_CUE_LIMIT,					/*JP< JeSL[~bg		*/
	CRIATOM_VOICE_STOP_REASON_UNSET_ACB,							/*JP< ACB		*/
	CRIATOM_VOICE_STOP_REASON_SEQUENCE_END,							/*JP< V[PXGh}[J[		*/
	CRIATOM_VOICE_STOP_REASON_BLODK_END,							/*JP< ubNGh		*/
	CRIATOM_VOICE_STOP_REASON_SEQUENCE_EXECUTE,						/*JP< V[PXT[o[	*/
	CRIATOM_VOICE_STOP_REASON_TRACK_MONO,							/*JP< gbNm[h	*/
	CRIATOM_VOICE_STOP_REASON_FADER_STOP_IMMEDIATE,					/*JP< tF[_[~	*/
	CRIATOM_VOICE_STOP_REASON_CUE_LIMIT,							/*JP< L[~bg	*/
	CRIATOM_VOICE_STOP_REASON_STOP_ACB_____NOUSE,					/*JP< (p~)SACB~	*/
	CRIATOM_VOICE_STOP_REASON_SOUND_OBJECT_ADD_PLAYER,				/*JP< TEhIuWFNgւ̃v[[ǉ	*/
	CRIATOM_VOICE_STOP_REASON_SOUND_OBJECT_DELETE_PLAYER,			/*JP< TEhIuWFNgv[[̍폜	*/
	CRIATOM_VOICE_STOP_REASON_SOUND_OBJECT_DELETE_ALL_PLAYER,		/*JP< TEhIuWFNgv[[̍폜	*/
	CRIATOM_VOICE_STOP_REASON_UNREGISTER_ACF,						/*JP< ACF̃AWXg	*/
	CRIATOM_VOICE_STOP_REASON_EXPLAYER_DESTROY,						/*JP< CriAtomExPlayernh̔j	*/
	CRIATOM_VOICE_STOP_REASON_EXPLAYER_ATTACH_FADER,				/*JP< CriAtomExPlayerւ̃tF[_[t	*/
	CRIATOM_VOICE_STOP_REASON_EXPLAYER_DETACH_FADER,				/*JP< CriAtomExPlayerւ̃tF[_[O	*/
	CRIATOM_VOICE_STOP_REASON_DETACH_AWB,							/*JP< AWB	*/
	CRIATOM_VOICE_STOP_MULTIPLE_PLAYBACK_PROHIBITION_TIME,			/*JP< dĐ֎~ԓĐ	*/
	CRIATOM_VOICE_STOP_REASON_CATEGORY_STOP,						/*JP< JeS~	*/
	CRIATOM_VOICE_STOP_REASON_CATEGORY_STOPWITHOUTRELEASE,			/*JP< JeS~	*/
	CRIATOM_VOICE_STOP_REASON_NOTE_OFF,								/*JP< ^CC~		*/
	CRIATOM_VOICE_STOP_REASON_REGISTER_ACF,							/*JP< ACF̓o^ */
	CRIATOM_VOICE_STOP_REASON_STOP_ACTION_WITH_FADE,				/*JP< tF[ht~ANV		*/
	CRIATOM_VOICE_STOP_REASON_RESET_TRACK_PARAMETER,				/*JP< gbNp[^[̃Zbg		*/
	CRIATOM_VOICE_STOP_REASON_BLOCK_TRANSITION_CASE4,				/*JP< ubNJ		*/
	CRIATOM_VOICE_STOP_REASON_BLOCK_TRANSITION_CASE5,				/*JP< ubNJ		*/
	CRIATOM_VOICE_STOP_REASON_BLOCK_TRANSITION_CASE6,				/*JP< ubNJ		*/
	CRIATOM_VOICE_STOP_REASON_NOTE_OFF2,							/*JP< m[g~		*/
	CRIATOM_VOICE_STOP_REASON_ALL_NOTE_OFF,							/*JP< Sm[g~		*/
	CRIATOM_VOICE_STOP_REASON_ALL_NOTE_OFF_WITHOUTRELEASE,			/*JP< Sm[g~		*/
	CRIATOM_VOICE_STOP_REASON_SOUND_SERVER_RESULT_ENVELOPE_LEVEL_ZERO,			/*JP< T[o[			*/
	CRIATOM_VOICE_STOP_REASON_AUX_IN_STOP,							/*JP< O͒~		*/
	CRIATOM_VOICE_STOP_REASON_ACB_RELEASE_ASYNC,					/*JP< 񓯊ACB		*/
	CRIATOM_VOICE_STOP_REASON_INGAMEPREVIEW_PREPARE_OVERWRITE_ACF,	/*JP< InGamePreview ACF XVO	*/
	CRIATOM_VOICE_STOP_REASON_INGAMEPREVIEW_PREPARE_OVERWRITE_ACB,	/*JP< InGamePreview ACB XVO	*/
	CRIATOM_VOICE_STOP_REASON_CUE_LIMIT_RESUME_PREPARE,				/*JP< W[ł̃L[~bg	*/
	CRIATOM_VOICE_STOP_REASON_MIDI_PLAYER_NOTE_OFF,					/*JP< MidiPlayer m[gIt	*/
	CRIATOM_VOICE_STOP_REASON_VOICE_DROP_IN_OBA,					/*JP< T[o[FOBA Đł̃{CXhbv */
	CRIATOM_VOICE_STOP_REASON_CANCEL_VOICE_LIMIT,					/*JP< {CX~bgɂLZ */

	/* initial state */
	CRIATOM_VOICE_STOP_REASON_NONE = 0x7FFFFFFE,
	/* enum size is 4bytes */
	CRIATOM_VOICE_STOP_REASON_ENUM_SIZE_IS_4BYTES = 0x7FFFFFFF
} CriAtomVoiceStopReason;

/*JP
 * \brief foCXXVʒmR[obN
 * \ingroup ATOMLIB_GLOBAL
 * \param[in]	obj				[UwIuWFNg
 * \par :
 * foCX̍XVʒmɎgpAR[obN֐̌^łB<br>
 * ::criAtom_SetDeviceUpdateCallback ֐ɖ{֐^̃R[obN֐o^邱ƂŁA
 * foCXXVꂽۂɃR[obNoRŒʒm󂯎邱Ƃ\łB<br>
 * \sa criAtom_SetDeviceUpdateCallback
 */
typedef void (CRIAPI *CriAtomDeviceUpdateCbFunc)(void *obj);

/*JP
 * \brief foCX^Cv
 * \ingroup ATOMLIB_GLOBAL
 * \par :
 * ݍĐĂfoCX̎ނ\܂B<br>
 * ::criAtomExAsrRack_GetDeviceType ֐ASRbNo͂ĂfoCX̎ނ
 * 擾邱Ƃł܂B<br>
 * \par l:
 * e^Cv̓Iɂǂ̃foCXw̓vbgtH[ɂĈقȂ܂B
 * \sa criAtomExAsrRack_GetDeviceType
 */
typedef enum CriAtomDeviceTypeTag {
	CRIATOM_DEVICE_TYPE_HDMI = 1,			/*JP< HDMI */
	CRIATOM_DEVICE_TYPE_HEADPHONE,			/*JP< wbhz */
	CRIATOM_DEVICE_TYPE_BUILT_IN_SPEAKER,	/*JP< Xs[J[ */
	CRIATOM_DEVICE_TYPE_PAD_SPEAKER,		/*JP< pbhXs[J[ */
	CRIATOM_DEVICE_TYPE_VIBRATION,			/*JP< U */

	CRIATOM_DEVICE_TYPE_UNKNOWN = 0,			/*JP< foCX^Cv̊mFłȂ */
	CRIATOM_DEVICE_TYPE_UNAVAILABLE = -1,		/*JP< o̓foCX݂Ȃ */

	CRIATOM_DEVICE_TYPE_ENUM_SIZE_IS_4BYTES = 0x7FFFFFFF
} CriAtomDeviceType;

/*!
 * \brief `lRtBO
 * \par :
 * ͉̃`l\lłB<br>
 */
typedef enum CriAtomChannelConfigTag {
	CRIATOM_CHANNEL_CONFIG_UNKNOWN			= 0x00000000,	/*!< s					*/

	CRIATOM_CHANNEL_CONFIG_MONO				= 0x00000004,	/*!< m				*/
	CRIATOM_CHANNEL_CONFIG_STEREO			= 0x00000003,	/*!< XeI				*/
	CRIATOM_CHANNEL_CONFIG_3_LRC			= 0x00000007,	/*!< 3chiL, R, Cj			*/
	CRIATOM_CHANNEL_CONFIG_3_LRS			= 0x00000103,	/*!< 3chiL, R, Csj		*/
	CRIATOM_CHANNEL_CONFIG_QUAD				= 0x00000C03,	/*!< 4chiL, R, Ls, Rsj	*/
	CRIATOM_CHANNEL_CONFIG_5				= 0x00000C07,	/*!< 5ch					*/
	CRIATOM_CHANNEL_CONFIG_4_1				= 0x00000C0B,	/*!< 4.1ch					*/
	CRIATOM_CHANNEL_CONFIG_5_1				= 0x00000C0F,	/*!< 5.1ch					*/
	CRIATOM_CHANNEL_CONFIG_6_1				= 0x00000D0F,	/*!< 6.1ch					*/
	CRIATOM_CHANNEL_CONFIG_7_1				= 0x00000C3F,	/*!< 7.1ch					*/
	CRIATOM_CHANNEL_CONFIG_5_1_2			= 0x000C0C0F,	/*!< 5.1.2ch				*/
	CRIATOM_CHANNEL_CONFIG_7_1_2			= 0x000C0C3F,	/*!< 7.1.2ch				*/
	CRIATOM_CHANNEL_CONFIG_7_1_4			= 0x00033C3F,	/*!< 7.1.4ch				*/
	CRIATOM_CHANNEL_CONFIG_7_1_4_4			= 0x03C33C3F,	/*!< 7.1.4.4ch				*/

	CRIATOM_CHANNEL_CONFIG_AMBISONICS_1P	= 0x7F000001,	/*!< 1st Order Ambisonics	*/
	CRIATOM_CHANNEL_CONFIG_AMBISONICS_2P	= 0x7F000002,	/*!< 2nd Order Ambisonics	*/
	CRIATOM_CHANNEL_CONFIG_AMBISONICS_3P	= 0x7F000003,	/*!< 3rd Order Ambisonics	*/
	CRIATOM_CHANNEL_CONFIG_AMBISONICS_4P	= 0x7F000004,	/*!< 4th Order Ambisonics	*/
	CRIATOM_CHANNEL_CONFIG_AMBISONICS_5P	= 0x7F000005,	/*!< 5th Order Ambisonics	*/
	CRIATOM_CHANNEL_CONFIG_AMBISONICS_6P	= 0x7F000006,	/*!< 6th Order Ambisonics	*/
	CRIATOM_CHANNEL_CONFIG_AMBISONICS_7P	= 0x7F000007,	/*!< 7th Order Ambisonics	*/

	CRIATOM_CHANNEL_CONFIG_ENUM_SIZE_IS_4BYTES = 0x7FFFFFFF
} CriAtomChannelConfig;

/*!
 * \brief AmbisonnicstH[}bg
 * \par :
 * Ambisonics̃`lяƐKlłB<br>
 */
typedef enum CriAtomAmbisonicsFormatTag {
	CRIATOM_AMBISONICS_FORMAT_FUMA_MAXN = 0,	/*!< FuMa maxN	*/
	CRIATOM_AMBISONICS_FORMAT_ACN_SN3D,			/*!< ACN SN3D	*/
	CRIATOM_AMBISONICS_FORMAT_ACN_N3D,			/*!< ACN N3D	*/

	CRIATOM_AMBISONICS_FORMAT_ENUM_IS_4BYTE = 0x7FFFFFFF
} CriAtomAmbisonicsFormat;

/*JP
 * \brief Xs[J[}bsO
 * \ingroup ATOMLIB_GLOBAL
 * \par :
 * Xs[J[\\܂B<br>
 * \sa CriAtomExAsrConfig CriAtomExAsrRackConfig CriAtomExAcfDspBusInfo
 */
typedef enum CriAtomSpeakerMappingTag {
	CRIATOM_SPEAKER_MAPPING_AUTO = 0,				/*JP< ݒ */
	CRIATOM_SPEAKER_MAPPING_MONO,					/*JP< 1ch */
	CRIATOM_SPEAKER_MAPPING_STEREO,					/*JP< 2ch */
	CRIATOM_SPEAKER_MAPPING_5_1,					/*JP< 5.1ch */
	CRIATOM_SPEAKER_MAPPING_7_1,					/*JP< 7.1ch */
	CRIATOM_SPEAKER_MAPPING_5_1_2,					/*JP< 5.1.2ch */
	CRIATOM_SPEAKER_MAPPING_7_1_2,					/*JP< 7.1.2ch */
	CRIATOM_SPEAKER_MAPPING_7_1_4,					/*JP< 7.1.4ch */
	CRIATOM_SPEAKER_MAPPING_7_1_4_4,				/*JP< 7.1.4.4ch */
	CRIATOM_SPEAKER_MAPPING_AMBISONICS_1P,			/*JP< 1st order Ambisonics */
	CRIATOM_SPEAKER_MAPPING_AMBISONICS_2P,			/*JP< 2nd order Ambisonics */
	CRIATOM_SPEAKER_MAPPING_AMBISONICS_3P,			/*JP< 3rd order Ambisonics */
	CRIATOM_SPEAKER_MAPPING_AMBISONICS_4P,			/*JP< 4th order Ambisonics */
	CRIATOM_SPEAKER_MAPPING_AMBISONICS_5P,			/*JP< 5th order Ambisonics */
	CRIATOM_SPEAKER_MAPPING_AMBISONICS_6P,			/*JP< 6th order Ambisonics */
	CRIATOM_SPEAKER_MAPPING_AMBISONICS_7P,			/*JP< 7th order Ambisonics */
	CRIATOM_SPEAKER_MAPPING_OBJECT_16,				/*JP< IuWFNgx[XĐ */
	CRIATOM_SPEAKER_MAPPING_OBJECT_32,				/*JP< IuWFNgx[XĐ */
	CRIATOM_SPEAKER_MAPPING_OBJECT_64,				/*JP< IuWFNgx[XĐ */
	CRIATOM_SPEAKER_MAPPING_OBJECT_128,				/*JP< IuWFNgx[XĐ */
	CRIATOM_SPEAKER_MAPPING_CUSTOM,
	CRIATOM_SPEAKER_MAPPING_ENUM_SIZE_IS_4BYTES = 0x7FFFFFFF
} CriAtomSpeakerMapping;
/*==========================================================================
 *      CRI Atom HCA-MX API
 *=========================================================================*/
/*JP
 * \brief HCA-MXpRtBO\
 * \ingroup ATOMLIB_HCA_MX
 * HCA-MX̓dlw肷邽߂̍\̂łB<br>
 * ::criAtomHcaMx_Initialize ֐̈Ɏw肵܂B<br>
 * \par l:
 * ftHgݒgpꍇA ::criAtomHcaMx_SetDefaultConfig }N
 * \̂ɃftHgp[^[ZbgA ::criAtomHcaMx_Initialize ֐
 * ɍ\̂w肵ĂB<br>
 * \attention
 * IɃo\邽߁A ::criAtomHcaMx_SetDefaultConfig
 * }NgpȂꍇɂ́AgpOɕK\̂[NAĂB<br>
 * i\̂̃oɕslȂ悤ӂBj
 * \sa criAtomHcaMx_Initialize, criAtomHcaMx_SetDefaultConfig
 */
typedef struct CriAtomHcaMxConfigTag {
	/*JP
		\brief T[o[̎spx
		\par :
		T[o[spxw肵܂B<br>
		\attention
		AtomCuɎw肵li ::CriAtomConfig \̂
		server_frequency jƁAlZbgKv܂B<br>
		\sa CriAtomConfig
	*/
	CriFloat32 server_frequency;

	/*JP
		\brief ~LT[
		\par :
		HCA-MXfR[hʂ𑗐M~LT[̐w肵܂B<br>
		~LT[𕡐쐬邱ƂŁA
		~LT[ƂɈقȂoXGtFNgKp邱Ƃ\ɂȂ܂B<br>
		\attention
		HCA-MX̃fR[hAђԂׂ̏́A
		~LT[̐ɔႵďdȂ܂B<br>
	*/
	CriSint32 num_mixers;

	/*JP
		\brief ~LT[ɓo^\ȍőv[[
		\par :
		~LT[Ƃɓo^\HCA-MXv[[̐w肵܂B<br>
	*/
	CriSint32 max_players;

	/*JP
		\brief ̓f[^̍ő`l
		\par :
		AvP[VōĐHCA-MXf[^̍ő`lw肵܂B<br>
		Đf[^m̏ꍇ1AXeȈꍇ2w肵ĂB<br>
		\par l:
		HCA-MX max_input_channels Ɏw肳ꂽȉ̉f[^
		Đ\ɂȂ܂B<br>
		Ⴆ΁A max_input_channels 6w肵ꍇA5.1chłȂA
		mXeIĐ\ɂȂ܂B<br>
		100̃f[^̂A99mA1XeȈꍇłA
		max_input_channels ɂ2w肷Kv܂B<br>
	*/
	CriSint32 max_input_channels;

	/*JP
		\brief őTvO[g
		\par :
		HCA-MX̏o͂ɎwłőTvO[głB<br>
		\par l:
		Ⴆ::criAtomHcaMx_SetFrequencyRatio ֐ 2.0f w肷ꍇ
		output_sampling_rate * 2 w肵ĂB<br>
	*/
	CriSint32 max_sampling_rate;

	/*JP
		\brief o̓`l
		\par :
		HCA-MXf[^̏o̓`lw肵܂B<br>
		ʏA^[Qbg@ɐڑꂽXs[J[̐io̓foCX
		ő`ljw肵܂B<br>
		o̓`l̍ől ::CRIATOM_HCA_MX_MAX_OUTPUT_CHANNELS ŁAŏ 1 łB<br>
		\par l:
		m݂̂ĐApRg[Ȃꍇɂ́A
		output_channels 1ɂ邱ƂŁAׂ邱Ƃ\łB<br>
		\attention
		output_channels ̐ max_input_channels ȉ̒lɐݒ肷邱Ƃ
		ł܂B<br>
	*/
	CriSint32 output_channels;

	/*JP
		\brief o̓TvO[g
		\par :
		ĐHCA-MXf[^̃TvO[gw肵܂B<br>
		HCA-MX́APʂ̃TvO[gύXs܂B<br>
		HCA-MXf[^쐬ۂɂ́AKSẲf[^𓯈̃TvO
		[gō쐬A̒l output_sampling_rate Ɏw肵ĂB<br>
	*/
	CriSint32 output_sampling_rate;

	/*JP
		\brief TEh_^Cv
		\par :
		HCA-MX̏o͐TEh_̎ʂw肵܂B<br>
		sound_renderer_type  CRIATOM_SOUND_RENDERER_DEFAULT w肵ꍇA
		f[^̓ftHgݒ̃TEh_ɓ]܂B<br>
		sound_renderer_type  CRIATOM_SOUND_RENDERER_NATIVE w肵ꍇA
		f[^̓ftHgݒ̊evbgtH[̃TEho͂ɓ]܂B<br>
		sound_renderer_type  CRIATOM_SOUND_RENDERER_ASR w肵ꍇA
		f[^ASRiAtom Sound Rendererjɓ]܂B<br>
		iASȐo͐́AASRɕʓrwBj
	*/
	CriAtomSoundRendererType sound_renderer_type;
} CriAtomHcaMxConfig;

/*==========================================================================
 *      CRI Atom AWB API
 *=========================================================================*/
struct CriAtomAwbTag;
/*JP
 * \brief AWBnh
 * \ingroup ATOMLIB_AWB
 * \par :
 * Đf[^܂܂ĂAWBt@CTOCnhłB<br>
 * ::criAtomAwb_LoadToc ֐Ŏ擾܂B<br>
 * \sa criAtomAwb_LoadToc
 */
typedef struct CriAtomAwbTag *CriAtomAwbHn;

/*JP
 * \brief AWBXe[^X
 * \ingroup ATOMLIB_AWB
 * \par :
 * AWB̏ԂlłB<br>
 * ::criAtomAwb_GetStatus ֐Ŏ擾܂B<br>
 * \sa criAtomAwb_GetStatus
 */
typedef enum CriAtomAwbStatusTag {
	CRIATOMAWB_STATUS_STOP = 0,		/*JP<~		*/
	CRIATOMAWB_STATUS_LOADING,		/*JP<[h	*/
	CRIATOMAWB_STATUS_COMPLETE,		/*JP<[h	*/
	CRIATOMAWB_STATUS_ERROR,		/*JP<[hs	*/

	/* enum size is 4bytes */
	CRIATOMAWB_STATUS_ENUM_SIZE_IS_4BYTES = 0x7FFFFFFF
} CriAtomAwbStatus;

/*JP
 * \brief AWB̎
 * \ingroup ATOMLIB_AWB
 * \par :
 * AWBnhTOĈ݂̃nhȂ̂AɃ[hꂽAWBnhȂ̂lłB
 * ::criAtomAwb_GetType ֐Ŏ擾܂B<br>
 * \sa criAtomAwb_GetType
 */
typedef enum CriAtomAwbTypeTag {
	CRIATOMAWB_TYPE_TOC = 0,	/*JP<TOĈ݂AWBnh	*/
	CRIATOMAWB_TYPE_ONMEMORY,	/*JP<IAWBnh		*/
	CRIATOMAWB_TYPE_ERROR,		/*JP<AWBnh			*/

	/* enum size is 4bytes */
	CRIATOMAWB_TYPE_ENUM_SIZE_IS_4BYTES = 0x7FFFFFFF
} CriAtomAwbType;

/*==========================================================================
 *      CRI Atom Player API
 *=========================================================================*/
/*JP
 * Wv[[쐬pRtBO\
 * \ingroup ATOMLIB_PLAYER
 * \par :
 * Wv[[iADXHCAĐ\ȃv[[j쐬ۂɁA
 * dlw肷邽߂̍\̂łB<br>
 * ::criAtomPlayer_CreateStandardPlayer ֐̈Ɏw肵܂B<br>
 * <br>
 * 쐬v[[́Anh쐬ɖ{\̂Ŏw肳ꂽݒɉāA
 * \[XKvȂmۂ܂B<br>
 * v[[KvƂ郏[N̈̃TCÝA{\̂Ŏw肳ꂽp[^[ɉĕω܂B
 * \attention
 * IɃo\邽߁A ::criAtomPlayer_SetDefaultConfigForStandardPlayer
 * }NgpȂꍇɂ́AgpOɕK\̂[NAĂB<br>
 * i\̂̃oɕslȂ悤ӂBj
 * \sa criAtomPlayer_CreateStandardPlayer, criAtomPlayer_SetDefaultConfigForStandardPlayer
 */
typedef struct CriAtomStandardPlayerConfigTag {
	/*JP
		\brief őo̓`l
		\par :
		Atomv[[ōĐ鉹̃`lw肵܂B<br>
		::criAtomPlayer_CreateStandardPlayer ֐ō쐬ꂽAtomv[[́Amax_channelsŎw肵
		`l"ȉ"f[^Đ\łB<br>
		őo̓`lƂĎw肷lƁA쐬ꂽAtomv[[ōĐ\ȃf[^
		֌WȉɎ܂B<br>
		\table "őo̓`lƍĐ\ȃf[^̊֌W" align=center border=1 cellspacing=0 cellpadding=4
		{őo̓`liw肷lj	| 쐬ꂽAtomv[[ōĐ\ȃf[^	}
		[1									| m									]
		[2									| mAXeI						]
		[6									| mAXeIA5.1ch					]
		[8									| mAXeIA5.1chA7.1ch			]
		\endtable
		<br>
		\par l:
		TEho͎Ƀn[hEFA\[XgpvbgtH[ɂẮA
		o̓`l邱ƂŁAn[hEFA\[X̏}邱Ƃ
		\łB<br>
		\attention
		w肳ꂽőo̓`l𒴂f[^́AĐ邱Ƃ͂ł܂B<br>
		Ⴆ΁Aőo̓`l1ɐݒ肵ꍇA쐬ꂽAtomv[[
		XeIĐ邱Ƃ͂ł܂B<br>
		imɃ_E~bNXďo͂邱Ƃ͂܂Bj
	*/
	CriSint32 max_channels;

	/*JP
		\brief őTvO[g
		\par :
		Atomv[[ōĐ鉹̃TvO[gw肵܂B<br>
		::criAtomPlayer_CreateStandardPlayer ֐ō쐬ꂽAtomv[[́Amax_sampling_rateŎw肵
		TvO[g"ȉ"f[^Đ\łB<br>
		<br>
		\par l:
		őTvO[g邱ƂŁAAtomv[[쐬ɕKvƂȂ郏[N
		̃TCY}邱Ƃ\łB
		\attention
		w肳ꂽőTvO[g𒴂f[^́AĐ邱Ƃ͂ł܂B<br>
		Ⴆ΁AőTvO[g24000ɐݒ肵ꍇA쐬ꂽAtomv[[
		48000Hz̉Đ邱Ƃ͂ł܂B<br>
		i_ETvOďo͂邱Ƃ͂܂Bj
	*/
	CriSint32 max_sampling_rate;

	/*JP
		\brief Xg[~OĐsǂ
		\par :
		Atomv[[ŃXg[~OĐit@C̍Đjsǂw肵܂B<br>
		streaming_flagCRI_FALSEw肵ꍇA쐬ꂽAtomv[[̓Ĩf[^
		Đi ::criAtomPlayer_SetData ֐Ŏw肵AhX̍Đĵ݂T|[g
		܂Bit@C̍Đ͂ł܂Bj<br>
		streaming_flagCRI_TRUEw肵ꍇA쐬ꂽAtomv[[̓Ĩf[^
		ĐɉAt@C̍Đi ::criAtomPlayer_SetFile ֐
		::criAtomPlayer_SetContentId ֐Ŏw肳ꂽt@C̍ĐjT|[g܂B<br>
		\par ⑫:
		streaming_flagCRI_TRUEɂꍇAAtomv[[쐬Ƀt@Cǂݍݗp̃\[X
		mۂ܂B<br>
		̂߁Astreaming_flagCRI_FALSȄꍇɔׁAAtomv[[̍쐬ɕKvȃ
		TCY傫Ȃ܂B
	*/
	CriBool streaming_flag;

	/*JP
		\brief TEh_^Cv
		\par :
		Atomv[[gpTEh_̎ʂw肵܂B<br>
		sound_renderer_type  CRIATOM_SOUND_RENDERER_DEFAULT w肵ꍇA
		f[^̓ftHgݒ̃TEh_ɓ]܂B<br>
		sound_renderer_type  CRIATOM_SOUND_RENDERER_NATIVE w肵ꍇA
		f[^͊evbgtH[̃TEho͂ɓ]܂B<br>
		sound_renderer_type  CRIATOM_SOUND_RENDERER_ASR w肵ꍇA
		f[^ASRiAtom Sound Rendererjɓ]܂B<br>
		iASȐo͐́AASRɕʓrwBj
	*/
	CriAtomSoundRendererType sound_renderer_type;

	/*JP
		\brief fR[h̃CeV
		\par :
		fR[h̃CeVw肵܂B<br>
		decode_latency  0 ɐݒ肵ꍇAv[[͉ĐJn
		f[^̃fR[h\ȌxȂs܂B<br>
		iIĐ ::criAtomPlayer_Start ֐sA
		ŏ̃T[o[ōĐJnɕKvȗʂ̃f[^fR[hA
		̏o͂Jn܂Bj<br>
		ɑ΂ decode_latency  1 ȏɐݒ肵ꍇA
		ĐJnɕKvȃf[^̃fR[hÃT[o[ɕčs܂B<br>
		iIĐłĂ ::criAtomPlayer_Start ֐sA
		decode_latency Ɏw肵񐔃T[o[삷܂ł͉̏o͂Jn܂Bj<br>
		\par l:
		Atomv[[̓TEhobt@[̃f[^cʂɁA
		T[o[̉f[^̃fR[hʂ肵Ă܂B<br>
		ĐJnO̓TEhobt@[̏Ԃ̂߁A
		Đɔׂđ̃f[^iĐ 2 ` 4 {xjfR[h܂B<br>
		v[[̉f[^̃fR[hׂ͏߁A
		ꉹꉹ̔Jnׂ̏ɂȂ邱Ƃ͂قƂǂ܂B<br>
		AAvP[V 1V ɑʂ̔NGXg𓯎ɔsꍇA
		SẴv[[ׂ̏̃s[NAׂڂɌđ傫Ȃꍇ܂B<br>
		sP[Xł́A decode_latency ̒l𑝂₷ƂŁA
		ǏIɏׂȂǏ邱Ƃ\łB<br>
		<br>
		decode_latency ̃ftHgĺAقƂǂ̊ 0 ɐݒ肳Ă܂B<br>
		AgуQ[@A킸ȕוϓłAvP[Vɑ傫ȉeyڂł́A
		ftHgl 1 ȏɐݒ肳Ă\܂B<br>
		iۂɃZbglɂĂ ::criAtomPlayer_SetDefaultConfigForAdxPlayer
		}N̓KpʂmFĂBj<br>
		<br>
		 decode_latency ̒l 4 ȏ̒lw肷邱Ƃ͂ł܂B<br>
		i decode_latency  4 ȏ̒lw肵ꍇłACu 3 ɕύX܂Bj<br>
	*/
	CriSint32 decode_latency;

	/*JP
		\brief vbgtH[ŗL̃p[^[ւ̃|C^
		\par :
		vbgtH[ŗL̃p[^[ւ̃|C^w肵܂B
		NULLw肵ꍇAvbgtH[̃ftHgp[^[Ńv[[쐬܂B<br>
		p[^[\̂͊evbgtH[ŗLwb_[ɒ`Ă܂B
		p[^[\̂`ĂȂvbgtH[ł́ANULLw肵ĂB
	*/
	void *context;
} CriAtomStandardPlayerConfig;

/*JP
 * ADXv[[쐬pRtBO\
 * \ingroup ATOMLIB_PLAYER
 * \par :
 * ADXĐ\ȃv[[쐬ۂɁAdlw肷邽߂̍\̂łB<br>
 * ::criAtomPlayer_CreateAdxPlayer ֐̈Ɏw肵܂B<br>
 * <br>
 * 쐬v[[́Anh쐬ɖ{\̂Ŏw肳ꂽݒɉāA
 * \[XKvȂmۂ܂B<br>
 * v[[KvƂ郏[N̈̃TCÝA{\̂Ŏw肳ꂽp[^[ɉĕω܂B
 * \attention
 * IɃo\邽߁A ::criAtomPlayer_SetDefaultConfigForAdxPlayer
 * }NgpȂꍇɂ́AgpOɕK\̂[NAĂB<br>
 * i\̂̃oɕslȂ悤ӂBj
 * \sa criAtomPlayer_CreateAdxPlayer, criAtomPlayer_SetDefaultConfigForAdxPlayer
 */
typedef struct CriAtomAdxPlayerConfigTag {
	/*JP
		\brief őo̓`l
		\par :
		Atomv[[ōĐ鉹̃`lw肵܂B<br>
		::criAtomPlayer_CreateAdxPlayer ֐ō쐬ꂽAtomv[[́Amax_channelsŎw肵
		`l"ȉ"f[^Đ\łB<br>
		őo̓`lƂĎw肷lƁA쐬ꂽAtomv[[ōĐ\ȃf[^
		֌WȉɎ܂B<br>
		\table "őo̓`lƍĐ\ȃf[^̊֌W" align=center border=1 cellspacing=0 cellpadding=4
		{őo̓`liw肷lj	| 쐬ꂽAtomv[[ōĐ\ȃf[^	}
		[1									| m									]
		[2									| mAXeI						]
		[6									| mAXeIA5.1ch					]
		[8									| mAXeIA5.1chA7.1ch			]
		\endtable
		<br>
		\par l:
		TEho͎Ƀn[hEFA\[XgpvbgtH[ɂẮA
		o̓`l邱ƂŁAn[hEFA\[X̏}邱Ƃ
		\łB<br>
		\attention
		w肳ꂽőo̓`l𒴂f[^́AĐ邱Ƃ͂ł܂B<br>
		Ⴆ΁Aőo̓`l1ɐݒ肵ꍇA쐬ꂽAtomv[[
		XeIĐ邱Ƃ͂ł܂B<br>
		imɃ_E~bNXďo͂邱Ƃ͂܂Bj
	*/
	CriSint32 max_channels;

	/*JP
		\brief őTvO[g
		\par :
		Atomv[[ōĐ鉹̃TvO[gw肵܂B<br>
		::criAtomPlayer_CreateAdxPlayer ֐ō쐬ꂽAtomv[[́Amax_sampling_rateŎw肵
		TvO[g"ȉ"f[^Đ\łB<br>
		<br>
		\par l:
		őTvO[g邱ƂŁAAtomv[[쐬ɕKvƂȂ郏[N
		̃TCY}邱Ƃ\łB
		\attention
		w肳ꂽőTvO[g𒴂f[^́AĐ邱Ƃ͂ł܂B<br>
		Ⴆ΁AőTvO[g24000ɐݒ肵ꍇA쐬ꂽAtomv[[
		48000Hz̉Đ邱Ƃ͂ł܂B<br>
		i_ETvOďo͂邱Ƃ͂܂Bj
	*/
	CriSint32 max_sampling_rate;

	/*JP
		\brief Xg[~OĐsǂ
		\par :
		Atomv[[ŃXg[~OĐit@C̍Đjsǂw肵܂B<br>
		streaming_flagCRI_FALSEw肵ꍇA쐬ꂽAtomv[[̓Ĩf[^
		Đi ::criAtomPlayer_SetData ֐Ŏw肵AhX̍Đĵ݂T|[g
		܂Bit@C̍Đ͂ł܂Bj<br>
		streaming_flagCRI_TRUEw肵ꍇA쐬ꂽAtomv[[̓Ĩf[^
		ĐɉAt@C̍Đi ::criAtomPlayer_SetFile ֐
		::criAtomPlayer_SetContentId ֐Ŏw肳ꂽt@C̍ĐjT|[g܂B<br>
		\par ⑫:
		streaming_flagCRI_TRUEɂꍇAAtomv[[쐬Ƀt@Cǂݍݗp̃\[X
		mۂ܂B<br>
		̂߁Astreaming_flagCRI_FALSȄꍇɔׁAAtomv[[̍쐬ɕKvȃ
		TCY傫Ȃ܂B
	*/
	CriBool streaming_flag;

	/*JP
		\brief TEh_^Cv
		\par :
		Atomv[[gpTEh_̎ʂw肵܂B<br>
		sound_renderer_type  CRIATOM_SOUND_RENDERER_DEFAULT w肵ꍇA
		f[^̓ftHgݒ̃TEh_ɓ]܂B<br>
		sound_renderer_type  CRIATOM_SOUND_RENDERER_NATIVE w肵ꍇA
		f[^̓ftHgݒ̊evbgtH[̃TEho͂ɓ]܂B<br>
		sound_renderer_type  CRIATOM_SOUND_RENDERER_ASR w肵ꍇA
		f[^ASRiAtom Sound Rendererjɓ]܂B<br>
		iASȐo͐́AASRɕʓrwBj
	*/
	CriAtomSoundRendererType sound_renderer_type;

	/*JP
		\brief fR[h̃CeV
		\par :
		fR[h̃CeVw肵܂B<br>
		decode_latency  0 ɐݒ肵ꍇAv[[͉ĐJn
		f[^̃fR[h\ȌxȂs܂B<br>
		iIĐ ::criAtomPlayer_Start ֐sA
		ŏ̃T[o[ōĐJnɕKvȗʂ̃f[^fR[hA
		̏o͂Jn܂Bj<br>
		ɑ΂ decode_latency  1 ȏɐݒ肵ꍇA
		ĐJnɕKvȃf[^̃fR[hÃT[o[ɕčs܂B<br>
		iIĐłĂ ::criAtomPlayer_Start ֐sA
		decode_latency Ɏw肵񐔃T[o[삷܂ł͉̏o͂Jn܂Bj<br>
		\par l:
		Atomv[[̓TEhobt@[̃f[^cʂɁA
		T[o[̉f[^̃fR[hʂ肵Ă܂B<br>
		ĐJnO̓TEhobt@[̏Ԃ̂߁A
		Đɔׂđ̃f[^iĐ 2 ` 4 {xjfR[h܂B<br>
		v[[̉f[^̃fR[hׂ͏߁A
		ꉹꉹ̔Jnׂ̏ɂȂ邱Ƃ͂قƂǂ܂B<br>
		AAvP[V 1V ɑʂ̔NGXg𓯎ɔsꍇA
		SẴv[[ׂ̏̃s[NAׂڂɌđ傫Ȃꍇ܂B<br>
		sP[Xł́A decode_latency ̒l𑝂₷ƂŁA
		ǏIɏׂȂǏ邱Ƃ\łB<br>
		<br>
		decode_latency ̃ftHgĺAقƂǂ̊ 0 ɐݒ肳Ă܂B<br>
		AgуQ[@A킸ȕוϓłAvP[Vɑ傫ȉeyڂł́A
		ftHgl 1 ȏɐݒ肳Ă\܂B<br>
		iۂɃZbglɂĂ ::criAtomPlayer_SetDefaultConfigForAdxPlayer
		}N̓KpʂmFĂBj<br>
		<br>
		 decode_latency ̒l 4 ȏ̒lw肷邱Ƃ͂ł܂B<br>
		i decode_latency  4 ȏ̒lw肵ꍇłACu 3 ɕύX܂Bj<br>
	*/
	CriSint32 decode_latency;

	/*JP
		\brief vbgtH[ŗL̃p[^[ւ̃|C^
		\par :
		vbgtH[ŗL̃p[^[ւ̃|C^w肵܂B
		NULLw肵ꍇAvbgtH[̃ftHgp[^[Ńv[[쐬܂B<br>
		p[^[\̂͊evbgtH[ŗLwb_[ɒ`Ă܂B
		p[^[\̂`ĂȂvbgtH[ł́ANULLw肵ĂB
	*/
	void *context;
} CriAtomAdxPlayerConfig;

/*JP
 * \ingroup ATOMLIB_PLAYER
 * HCAv[[쐬pRtBO\
 * \par :
 * HCAĐ\ȃv[[쐬ۂɁAdlw肷邽߂̍\̂łB<br>
 * ::criAtomPlayer_CreateHcaPlayer ֐̈Ɏw肵܂B<br>
 * <br>
 * 쐬v[[́Anh쐬ɖ{\̂Ŏw肳ꂽݒɉāA
 * \[XKvȂmۂ܂B<br>
 * v[[KvƂ郏[N̈̃TCÝA{\̂Ŏw肳ꂽp[^[ɉĕω܂B
 * \attention
 * IɃo\邽߁A ::criAtomPlayer_SetDefaultConfigForHcaPlayer
 * }NgpȂꍇɂ́AgpOɕK\̂[NAĂB<br>
 * i\̂̃oɕslȂ悤ӂBj
 * \sa criAtomPlayer_CreateHcaPlayer, criAtomPlayer_SetDefaultConfigForHcaPlayer
 */
typedef struct CriAtomHcaPlayerConfigTag {
	/*JP
		\brief őo̓`l
		\par :
		Atomv[[ōĐ鉹̃`lw肵܂B<br>
		::criAtomPlayer_CreateHcaPlayer ֐ō쐬ꂽAtomv[[́Amax_channelsŎw肵
		`l"ȉ"f[^Đ\łB<br>
	*/
	CriSint32 max_channels;

	/*JP
		\brief őTvO[g
		\par :
		Atomv[[ōĐ鉹̃TvO[gw肵܂B<br>
		::criAtomPlayer_CreateHcaPlayer ֐ō쐬ꂽAtomv[[́Amax_sampling_rateŎw肵
		TvO[g"ȉ"f[^Đ\łB<br>
		<br>
		\par l:
		őTvO[g邱ƂŁAAtomv[[쐬ɕKvƂȂ郏[N
		̃TCY}邱Ƃ\łB
		\attention
		w肳ꂽőTvO[g𒴂f[^́AĐ邱Ƃ͂ł܂B<br>
		Ⴆ΁AőTvO[g24000ɐݒ肵ꍇA쐬ꂽAtomv[[
		48000Hz̉Đ邱Ƃ͂ł܂B<br>
		i_ETvOďo͂邱Ƃ͂܂Bj
	*/
	CriSint32 max_sampling_rate;

	/*JP
		\brief Xg[~OĐsǂ
		\par :
		Atomv[[ŃXg[~OĐit@C̍Đjsǂw肵܂B<br>
		streaming_flagCRI_FALSEw肵ꍇA쐬ꂽAtomv[[̓Ĩf[^
		Đi ::criAtomPlayer_SetData ֐Ŏw肵AhX̍Đĵ݂T|[g
		܂Bit@C̍Đ͂ł܂Bj<br>
		streaming_flagCRI_TRUEw肵ꍇA쐬ꂽAtomv[[̓Ĩf[^
		ĐɉAt@C̍Đi ::criAtomPlayer_SetFile ֐
		::criAtomPlayer_SetContentId ֐Ŏw肳ꂽt@C̍ĐjT|[g܂B<br>
		\par ⑫:
		streaming_flagCRI_TRUEɂꍇAAtomv[[쐬Ƀt@Cǂݍݗp̃\[X
		mۂ܂B<br>
		̂߁Astreaming_flagCRI_FALSȄꍇɔׁAAtomv[[̍쐬ɕKvȃ
		TCY傫Ȃ܂B
	*/
	CriBool streaming_flag;

	/*JP
		\brief TEh_^Cv
		\par :
		Atomv[[gpTEh_̎ʂw肵܂B<br>
		sound_renderer_type  CRIATOM_SOUND_RENDERER_DEFAULT w肵ꍇA
		f[^̓ftHgݒ̃TEh_ɓ]܂B<br>
		sound_renderer_type  CRIATOM_SOUND_RENDERER_NATIVE w肵ꍇA
		f[^̓ftHgݒ̊evbgtH[̃TEho͂ɓ]܂B<br>
		sound_renderer_type  CRIATOM_SOUND_RENDERER_ASR w肵ꍇA
		f[^ASRiAtom Sound Rendererjɓ]܂B<br>
		iASȐo͐́AASRɕʓrwBj
	*/
	CriAtomSoundRendererType sound_renderer_type;

	/*JP
		\brief fR[h̃CeV
		\par :
		fR[h̃CeVw肵܂B<br>
		decode_latency  0 ɐݒ肵ꍇAv[[͉ĐJn
		f[^̃fR[h\ȌxȂs܂B<br>
		iIĐ ::criAtomPlayer_Start ֐sA
		ŏ̃T[o[ōĐJnɕKvȗʂ̃f[^fR[hA
		̏o͂Jn܂Bj<br>
		ɑ΂ decode_latency  1 ȏɐݒ肵ꍇA
		ĐJnɕKvȃf[^̃fR[hÃT[o[ɕčs܂B<br>
		iIĐłĂ ::criAtomPlayer_Start ֐sA
		decode_latency Ɏw肵񐔃T[o[삷܂ł͉̏o͂Jn܂Bj<br>
		\par l:
		Atomv[[̓TEhobt@[̃f[^cʂɁA
		T[o[̉f[^̃fR[hʂ肵Ă܂B<br>
		ĐJnO̓TEhobt@[̏Ԃ̂߁A
		Đɔׂđ̃f[^iĐ 2 ` 4 {xjfR[h܂B<br>
		v[[̉f[^̃fR[hׂ͏߁A
		ꉹꉹ̔Jnׂ̏ɂȂ邱Ƃ͂قƂǂ܂B<br>
		AAvP[V 1V ɑʂ̔NGXg𓯎ɔsꍇA
		SẴv[[ׂ̏̃s[NAׂڂɌđ傫Ȃꍇ܂B<br>
		sP[Xł́A decode_latency ̒l𑝂₷ƂŁA
		ǏIɏׂȂǏ邱Ƃ\łB<br>
		<br>
		decode_latency ̃ftHgĺAقƂǂ̊ 0 ɐݒ肳Ă܂B<br>
		AgуQ[@A킸ȕוϓłAvP[Vɑ傫ȉeyڂł́A
		ftHgl 1 ȏɐݒ肳Ă\܂B<br>
		iۂɃZbglɂĂ ::criAtomPlayer_SetDefaultConfigForAdxPlayer
		}N̓KpʂmFĂBj<br>
		<br>
		 decode_latency ̒l 4 ȏ̒lw肷邱Ƃ͂ł܂B<br>
		i decode_latency  4 ȏ̒lw肵ꍇłACu 3 ɕύX܂Bj<br>
	*/
	CriSint32 decode_latency;

	/*JP
		\brief vbgtH[ŗL̃p[^[ւ̃|C^
		\par :
		vbgtH[ŗL̃p[^[ւ̃|C^w肵܂B
		NULLw肵ꍇAvbgtH[̃ftHgp[^[Ńv[[쐬܂B<br>
		p[^[\̂͊evbgtH[ŗLwb_[ɒ`Ă܂B
		p[^[\̂`ĂȂvbgtH[ł́ANULLw肵ĂB
	*/
	void *context;
} CriAtomHcaPlayerConfig;

/*JP
 * \ingroup ATOMLIB_PLAYER
 * HCA-MXv[[쐬pRtBO\
 * \par :
 * HCA-MXĐ\ȃv[[쐬ۂɁAdlw肷邽߂̍\̂łB<br>
 * ::criAtomPlayer_CreateHcaMxPlayer ֐̈Ɏw肵܂B<br>
 * <br>
 * 쐬v[[́Anh쐬ɖ{\̂Ŏw肳ꂽݒɉāA
 * \[XKvȂmۂ܂B<br>
 * v[[KvƂ郏[N̈̃TCÝA{\̂Ŏw肳ꂽp[^[ɉĕω܂B
 * \attention
 * IɃo\邽߁A ::criAtomPlayer_SetDefaultConfigForHcaMxPlayer
 * }NgpȂꍇɂ́AgpOɕK\̂[NAĂB<br>
 * i\̂̃oɕslȂ悤ӂBj
 * \sa criAtomPlayer_CreateHcaMxPlayer, criAtomPlayer_SetDefaultConfigForHcaMxPlayer
 */
typedef struct CriAtomHcaMxPlayerConfigTag {
	/*JP
		\brief őo̓`l
		\par :
		Atomv[[ōĐ鉹̃`lw肵܂B<br>
		::criAtomPlayer_CreateHcaMxPlayer ֐ō쐬ꂽAtomv[[́Amax_channelsŎw肵
		`l"ȉ"f[^Đ\łB<br>
	*/
	CriSint32 max_channels;

	/*JP
		\brief őTvO[g
		\par :
		Atomv[[ōĐ鉹̃TvO[gw肵܂B<br>
		::criAtomPlayer_CreateHcaMxPlayer ֐ō쐬ꂽAtomv[[́Amax_sampling_rateŎw肵
		TvO[gƈv鉹f[^݂̂Đ\łB<br>
		<br>
		\par l:
		őTvO[g邱ƂŁAAtomv[[쐬ɕKvƂȂ郏[N
		̃TCY}邱Ƃ\łB
		\attention
		w肳ꂽőTvO[gɈvȂf[^́AĐ邱Ƃ͂ł܂B<br>
		Ⴆ΁AőTvO[g48000ɐݒ肵ꍇA쐬ꂽAtomv[[
		48000HzȊỎĐ邱Ƃ͂ł܂B<br>
		i[gϊďo͂邱Ƃ͂܂Bj
	*/
	CriSint32 max_sampling_rate;

	/*JP
		\brief Xg[~OĐsǂ
		\par :
		Atomv[[ŃXg[~OĐit@C̍Đjsǂw肵܂B<br>
		streaming_flagCRI_FALSEw肵ꍇA쐬ꂽAtomv[[̓Ĩf[^
		Đi ::criAtomPlayer_SetData ֐Ŏw肵AhX̍Đĵ݂T|[g
		܂Bit@C̍Đ͂ł܂Bj<br>
		streaming_flagCRI_TRUEw肵ꍇA쐬ꂽAtomv[[̓Ĩf[^
		ĐɉAt@C̍Đi ::criAtomPlayer_SetFile ֐
		::criAtomPlayer_SetContentId ֐Ŏw肳ꂽt@C̍ĐjT|[g܂B<br>
		\par ⑫:
		streaming_flagCRI_TRUEɂꍇAAtomv[[쐬Ƀt@Cǂݍݗp̃\[X
		mۂ܂B<br>
		̂߁Astreaming_flagCRI_FALSȄꍇɔׁAAtomv[[̍쐬ɕKvȃ
		TCY傫Ȃ܂B
	*/
	CriBool streaming_flag;
} CriAtomHcaMxPlayerConfig;

/*JP
 * \ingroup ATOMLIB_PLAYER
 * WAVEv[[쐬pRtBO\
 * \par :
 * WAVEĐ\ȃv[[쐬ۂɁAdlw肷邽߂̍\̂łB<br>
 * ::criAtomPlayer_CreateWavePlayer ֐̈Ɏw肵܂B<br>
 * <br>
 * 쐬v[[́Anh쐬ɖ{\̂Ŏw肳ꂽݒɉāA
 * \[XKvȂmۂ܂B<br>
 * v[[KvƂ郏[N̈̃TCÝA{\̂Ŏw肳ꂽp[^[ɉĕω܂B
 * \attention
 * IɃo\邽߁A ::criAtomPlayer_SetDefaultConfigForWavePlayer
 * }NgpȂꍇɂ́AgpOɕK\̂[NAĂB<br>
 * i\̂̃oɕslȂ悤ӂBj
 * \sa criAtomPlayer_CreateWavePlayer, criAtomPlayer_SetDefaultConfigForWavePlayer
 */
typedef struct CriAtomWavePlayerConfigTag {
	/*JP
		\brief őo̓`l
		\par :
		Atomv[[ōĐ鉹̃`lw肵܂B<br>
		::criAtomPlayer_CreateWavePlayer ֐ō쐬ꂽAtomv[[́Amax_channelsŎw肵
		`l"ȉ"f[^Đ\łB<br>
	*/
	CriSint32 max_channels;

	/*JP
		\brief őTvO[g
		\par :
		Atomv[[ōĐ鉹̃TvO[gw肵܂B<br>
		::criAtomPlayer_CreateWavePlayer ֐ō쐬ꂽAtomv[[́Amax_sampling_rateŎw肵
		TvO[g"ȉ"f[^Đ\łB<br>
		<br>
		\par l:
		őTvO[g邱ƂŁAAtomv[[쐬ɕKvƂȂ郏[N
		̃TCY}邱Ƃ\łB
		\attention
		w肳ꂽőTvO[g𒴂f[^́AĐ邱Ƃ͂ł܂B<br>
		Ⴆ΁AőTvO[g24000ɐݒ肵ꍇA쐬ꂽAtomv[[
		48000Hz̉Đ邱Ƃ͂ł܂B<br>
		i_ETvOďo͂邱Ƃ͂܂Bj
	*/
	CriSint32 max_sampling_rate;

	/*JP
		\brief Xg[~OĐsǂ
		\par :
		Atomv[[ŃXg[~OĐit@C̍Đjsǂw肵܂B<br>
		streaming_flagCRI_FALSEw肵ꍇA쐬ꂽAtomv[[̓Ĩf[^
		Đi ::criAtomPlayer_SetData ֐Ŏw肵AhX̍Đĵ݂T|[g
		܂Bit@C̍Đ͂ł܂Bj<br>
		streaming_flagCRI_TRUEw肵ꍇA쐬ꂽAtomv[[̓Ĩf[^
		ĐɉAt@C̍Đi ::criAtomPlayer_SetFile ֐
		::criAtomPlayer_SetContentId ֐Ŏw肳ꂽt@C̍ĐjT|[g܂B<br>
		\par ⑫:
		streaming_flagCRI_TRUEɂꍇAAtomv[[쐬Ƀt@Cǂݍݗp̃\[X
		mۂ܂B<br>
		̂߁Astreaming_flagCRI_FALSȄꍇɔׁAAtomv[[̍쐬ɕKvȃ
		TCY傫Ȃ܂B
	*/
	CriBool streaming_flag;

	/*JP
		\brief TEh_^Cv
		\par :
		Atomv[[gpTEh_̎ʂw肵܂B<br>
		sound_renderer_type  CRIATOM_SOUND_RENDERER_DEFAULT w肵ꍇA
		f[^̓ftHgݒ̃TEh_ɓ]܂B<br>
		sound_renderer_type  CRIATOM_SOUND_RENDERER_NATIVE w肵ꍇA
		f[^̓ftHgݒ̊evbgtH[̃TEho͂ɓ]܂B<br>
		sound_renderer_type  CRIATOM_SOUND_RENDERER_ASR w肵ꍇA
		f[^ASRiAtom Sound Rendererjɓ]܂B<br>
		iASȐo͐́AASRɕʓrwBj
	*/
	CriAtomSoundRendererType sound_renderer_type;

	/*JP
		\brief fR[h̃CeV
		\par :
		fR[h̃CeVw肵܂B<br>
		decode_latency  0 ɐݒ肵ꍇAv[[͉ĐJn
		f[^̃fR[h\ȌxȂs܂B<br>
		iIĐ ::criAtomPlayer_Start ֐sA
		ŏ̃T[o[ōĐJnɕKvȗʂ̃f[^fR[hA
		̏o͂Jn܂Bj<br>
		ɑ΂ decode_latency  1 ȏɐݒ肵ꍇA
		ĐJnɕKvȃf[^̃fR[hÃT[o[ɕčs܂B<br>
		iIĐłĂ ::criAtomPlayer_Start ֐sA
		decode_latency Ɏw肵񐔃T[o[삷܂ł͉̏o͂Jn܂Bj<br>
		\par l:
		Atomv[[̓TEhobt@[̃f[^cʂɁA
		T[o[̉f[^̃fR[hʂ肵Ă܂B<br>
		ĐJnO̓TEhobt@[̏Ԃ̂߁A
		Đɔׂđ̃f[^iĐ 2 ` 4 {xjfR[h܂B<br>
		v[[̉f[^̃fR[hׂ͏߁A
		ꉹꉹ̔Jnׂ̏ɂȂ邱Ƃ͂قƂǂ܂B<br>
		AAvP[V 1V ɑʂ̔NGXg𓯎ɔsꍇA
		SẴv[[ׂ̏̃s[NAׂڂɌđ傫Ȃꍇ܂B<br>
		sP[Xł́A decode_latency ̒l𑝂₷ƂŁA
		ǏIɏׂȂǏ邱Ƃ\łB<br>
		<br>
		decode_latency ̃ftHgĺAقƂǂ̊ 0 ɐݒ肳Ă܂B<br>
		AgуQ[@A킸ȕוϓłAvP[Vɑ傫ȉeyڂł́A
		ftHgl 1 ȏɐݒ肳Ă\܂B<br>
		iۂɃZbglɂĂ ::criAtomPlayer_SetDefaultConfigForAdxPlayer
		}N̓KpʂmFĂBj<br>
		<br>
		 decode_latency ̒l 4 ȏ̒lw肷邱Ƃ͂ł܂B<br>
		i decode_latency  4 ȏ̒lw肵ꍇłACu 3 ɕύX܂Bj<br>
	*/
	CriSint32 decode_latency;

	/*JP
		\brief vbgtH[ŗL̃p[^[ւ̃|C^
		\par :
		vbgtH[ŗL̃p[^[ւ̃|C^w肵܂B
		NULLw肵ꍇAvbgtH[̃ftHgp[^[Ńv[[쐬܂B<br>
		p[^[\̂͊evbgtH[ŗLwb_[ɒ`Ă܂B
		p[^[\̂`ĂȂvbgtH[ł́ANULLw肵ĂB
	*/
	void *context;
} CriAtomWavePlayerConfig;

/*JP
 * \ingroup ATOMLIB_PLAYER
 * AIFFv[[쐬pRtBO\
 * \par :
 * AIFFĐ\ȃv[[쐬ۂɁAdlw肷邽߂̍\̂łB<br>
 * ::criAtomPlayer_CreateAiffPlayer ֐̈Ɏw肵܂B<br>
 * <br>
 * 쐬v[[́Anh쐬ɖ{\̂Ŏw肳ꂽݒɉāA
 * \[XKvȂmۂ܂B<br>
 * v[[KvƂ郏[N̈̃TCÝA{\̂Ŏw肳ꂽp[^[ɉĕω܂B
 * \attention
 * IɃo\邽߁A ::criAtomPlayer_SetDefaultConfigForAiffPlayer
 * }NgpȂꍇɂ́AgpOɕK\̂[NAĂB<br>
 * i\̂̃oɕslȂ悤ӂBj
 * \sa criAtomPlayer_CreateAiffPlayer, criAtomPlayer_SetDefaultConfigForAiffPlayer
 */
typedef struct CriAtomAiffPlayerConfigTag {
	/*JP
		\brief őo̓`l
		\par :
		Atomv[[ōĐ鉹̃`lw肵܂B<br>
		::criAtomPlayer_CreateAiffPlayer ֐ō쐬ꂽAtomv[[́Amax_channelsŎw肵
		`l"ȉ"f[^Đ\łB<br>
	*/
	CriSint32 max_channels;

	/*JP
		\brief őTvO[g
		\par :
		Atomv[[ōĐ鉹̃TvO[gw肵܂B<br>
		::criAtomPlayer_CreateAiffPlayer ֐ō쐬ꂽAtomv[[́Amax_sampling_rateŎw肵
		TvO[g"ȉ"f[^Đ\łB<br>
		<br>
		\par l:
		őTvO[g邱ƂŁAAtomv[[쐬ɕKvƂȂ郏[N
		̃TCY}邱Ƃ\łB
		\attention
		w肳ꂽőTvO[g𒴂f[^́AĐ邱Ƃ͂ł܂B<br>
		Ⴆ΁AőTvO[g24000ɐݒ肵ꍇA쐬ꂽAtomv[[
		48000Hz̉Đ邱Ƃ͂ł܂B<br>
		i_ETvOďo͂邱Ƃ͂܂Bj
	*/
	CriSint32 max_sampling_rate;

	/*JP
		\brief Xg[~OĐsǂ
		\par :
		Atomv[[ŃXg[~OĐit@C̍Đjsǂw肵܂B<br>
		streaming_flagCRI_FALSEw肵ꍇA쐬ꂽAtomv[[̓Ĩf[^
		Đi ::criAtomPlayer_SetData ֐Ŏw肵AhX̍Đĵ݂T|[g
		܂Bit@C̍Đ͂ł܂Bj<br>
		streaming_flagCRI_TRUEw肵ꍇA쐬ꂽAtomv[[̓Ĩf[^
		ĐɉAt@C̍Đi ::criAtomPlayer_SetFile ֐
		::criAtomPlayer_SetContentId ֐Ŏw肳ꂽt@C̍ĐjT|[g܂B<br>
		\par ⑫:
		streaming_flagCRI_TRUEɂꍇAAtomv[[쐬Ƀt@Cǂݍݗp̃\[X
		mۂ܂B<br>
		̂߁Astreaming_flagCRI_FALSȄꍇɔׁAAtomv[[̍쐬ɕKvȃ
		TCY傫Ȃ܂B
	*/
	CriBool streaming_flag;

	/*JP
		\brief TEh_^Cv
		\par :
		Atomv[[gpTEh_̎ʂw肵܂B<br>
		sound_renderer_type  CRIATOM_SOUND_RENDERER_DEFAULT w肵ꍇA
		f[^̓ftHgݒ̃TEh_ɓ]܂B<br>
		sound_renderer_type  CRIATOM_SOUND_RENDERER_NATIVE w肵ꍇA
		f[^̓ftHgݒ̊evbgtH[̃TEho͂ɓ]܂B<br>
		sound_renderer_type  CRIATOM_SOUND_RENDERER_ASR w肵ꍇA
		f[^ASRiAtom Sound Rendererjɓ]܂B<br>
		iASȐo͐́AASRɕʓrwBj
	*/
	CriAtomSoundRendererType sound_renderer_type;

	/*JP
		\brief fR[h̃CeV
		\par :
		fR[h̃CeVw肵܂B<br>
		decode_latency  0 ɐݒ肵ꍇAv[[͉ĐJn
		f[^̃fR[h\ȌxȂs܂B<br>
		iIĐ ::criAtomPlayer_Start ֐sA
		ŏ̃T[o[ōĐJnɕKvȗʂ̃f[^fR[hA
		̏o͂Jn܂Bj<br>
		ɑ΂ decode_latency  1 ȏɐݒ肵ꍇA
		ĐJnɕKvȃf[^̃fR[hÃT[o[ɕčs܂B<br>
		iIĐłĂ ::criAtomPlayer_Start ֐sA
		decode_latency Ɏw肵񐔃T[o[삷܂ł͉̏o͂Jn܂Bj<br>
		\par l:
		Atomv[[̓TEhobt@[̃f[^cʂɁA
		T[o[̉f[^̃fR[hʂ肵Ă܂B<br>
		ĐJnO̓TEhobt@[̏Ԃ̂߁A
		Đɔׂđ̃f[^iĐ 2 ` 4 {xjfR[h܂B<br>
		v[[̉f[^̃fR[hׂ͏߁A
		ꉹꉹ̔Jnׂ̏ɂȂ邱Ƃ͂قƂǂ܂B<br>
		AAvP[V 1V ɑʂ̔NGXg𓯎ɔsꍇA
		SẴv[[ׂ̏̃s[NAׂڂɌđ傫Ȃꍇ܂B<br>
		sP[Xł́A decode_latency ̒l𑝂₷ƂŁA
		ǏIɏׂȂǏ邱Ƃ\łB<br>
		<br>
		decode_latency ̃ftHgĺAقƂǂ̊ 0 ɐݒ肳Ă܂B<br>
		AgуQ[@A킸ȕוϓłAvP[Vɑ傫ȉeyڂł́A
		ftHgl 1 ȏɐݒ肳Ă\܂B<br>
		iۂɃZbglɂĂ ::criAtomPlayer_SetDefaultConfigForAdxPlayer
		}N̓KpʂmFĂBj<br>
		<br>
		 decode_latency ̒l 4 ȏ̒lw肷邱Ƃ͂ł܂B<br>
		i decode_latency  4 ȏ̒lw肵ꍇłACu 3 ɕύX܂Bj<br>
	*/
	CriSint32 decode_latency;

	/*JP
		\brief vbgtH[ŗL̃p[^[ւ̃|C^
		\par :
		vbgtH[ŗL̃p[^[ւ̃|C^w肵܂B
		NULLw肵ꍇAvbgtH[̃ftHgp[^[Ńv[[쐬܂B<br>
		p[^[\̂͊evbgtH[ŗLwb_[ɒ`Ă܂B
		p[^[\̂`ĂȂvbgtH[ł́ANULLw肵ĂB
	*/
	void *context;
} CriAtomAiffPlayerConfig;

/*JP
 * \ingroup ATOMLIB_PLAYER
 * RawPCMv[[쐬pRtBO\
 * \par :
 * RawPCMĐ\ȃv[[쐬ۂɁAdlw肷邽߂̍\̂łB<br>
 * ::criAtomPlayer_CreateRawPcmPlayer ֐̈Ɏw肵܂B<br>
 * <br>
 * 쐬v[[́Anh쐬ɖ{\̂Ŏw肳ꂽݒɉāA
 * \[XKvȂmۂ܂B<br>
 * v[[KvƂ郏[N̈̃TCÝA{\̂Ŏw肳ꂽp[^[ɉĕω܂B
 * \attention
 * IɃo\邽߁A ::criAtomPlayer_SetDefaultConfigForRawPcmPlayer
 * }NgpȂꍇɂ́AgpOɕK\̂[NAĂB<br>
 * i\̂̃oɕslȂ悤ӂBj
 * \sa criAtomPlayer_CreateRawPcmPlayer, criAtomPlayer_SetDefaultConfigForRawPcmPlayer
 */
typedef struct CriAtomRawPcmPlayerConfigTag {
	/*JP
		\brief PCMtH[}bg
		\par :
		Atomv[[ōĐ鉹PCMtH[}bgw肵܂B<br>
		\attention
		w肳ꂽtH[}bgȊORawPCMtH[}bg̃f[^͍Đł܂B<br>
		Đf[^ǂȃtH[}bgłĂAŎw肳ꂽtH[}bgƂčĐ܂B<br>
	*/
	CriAtomPcmFormat pcm_format;

	/*JP
		\brief o̓`l
		\par :
		Atomv[[ōĐ鉹̃`lw肵܂B<br>
		::criAtomPlayer_CreateRawPcmPlayer ֐ō쐬ꂽAtomv[[́A
		max_channelsŎw肵`l"ȉ"f[^Đ\łB<br>
		\attention
		w肳ꂽ`lȊORawPCMtH[}bg̃f[^͍Đł܂B<br>
		Đf[^ǂȃtH[}bgłĂAŎw肳ꂽ`lƂčĐ܂B<br>
	*/
	CriSint32 max_channels;

	/*JP
		\brief TvO[g
		\par :
		Atomv[[ōĐ鉹̃TvO[gw肵܂B<br>
		::criAtomPlayer_CreateRawPcmPlayer ֐ō쐬ꂽAtomv[[́Amax_sampling_rateŎw肵
		TvO[g"ȉ"f[^Đ\łB<br>
		<br>
		\par l:
		őTvO[g邱ƂŁAAtomv[[쐬ɕKvƂȂ郏[N
		̃TCY}邱Ƃ\łB
		\attention
		w肳ꂽTvO[gƈႤf[^͍Đł܂B<br>
		Đf[^ǂȃtH[}bgłĂAŎw肳ꂽTvO[gƂčĐ܂B<br>
	*/
	CriSint32 max_sampling_rate;

	/*JP
		\brief TEh_^Cv
		\par :
		Atomv[[gpTEh_̎ʂw肵܂B<br>
		sound_renderer_type  CRIATOM_SOUND_RENDERER_DEFAULT w肵ꍇA
		f[^̓ftHgݒ̃TEh_ɓ]܂B<br>
		sound_renderer_type  CRIATOM_SOUND_RENDERER_NATIVE w肵ꍇA
		f[^̓ftHgݒ̊evbgtH[̃TEho͂ɓ]܂B<br>
		sound_renderer_type  CRIATOM_SOUND_RENDERER_ASR w肵ꍇA
		f[^ASRiAtom Sound Rendererjɓ]܂B<br>
		iASȐo͐́AASRɕʓrwBj
	*/
	CriAtomSoundRendererType sound_renderer_type;

	/*JP
		\brief fR[h̃CeV
		\par :
		fR[h̃CeVw肵܂B<br>
		decode_latency  0 ɐݒ肵ꍇAv[[͉ĐJn
		f[^̃fR[h\ȌxȂs܂B<br>
		iIĐ ::criAtomPlayer_Start ֐sA
		ŏ̃T[o[ōĐJnɕKvȗʂ̃f[^fR[hA
		̏o͂Jn܂Bj<br>
		ɑ΂ decode_latency  1 ȏɐݒ肵ꍇA
		ĐJnɕKvȃf[^̃fR[hÃT[o[ɕčs܂B<br>
		iIĐłĂ ::criAtomPlayer_Start ֐sA
		decode_latency Ɏw肵񐔃T[o[삷܂ł͉̏o͂Jn܂Bj<br>
		\par l:
		Atomv[[̓TEhobt@[̃f[^cʂɁA
		T[o[̉f[^̃fR[hʂ肵Ă܂B<br>
		ĐJnO̓TEhobt@[̏Ԃ̂߁A
		Đɔׂđ̃f[^iĐ 2 ` 4 {xjfR[h܂B<br>
		v[[̉f[^̃fR[hׂ͏߁A
		ꉹꉹ̔Jnׂ̏ɂȂ邱Ƃ͂قƂǂ܂B<br>
		AAvP[V 1V ɑʂ̔NGXg𓯎ɔsꍇA
		SẴv[[ׂ̏̃s[NAׂڂɌđ傫Ȃꍇ܂B<br>
		sP[Xł́A decode_latency ̒l𑝂₷ƂŁA
		ǏIɏׂȂǏ邱Ƃ\łB<br>
		<br>
		decode_latency ̃ftHgĺAقƂǂ̊ 0 ɐݒ肳Ă܂B<br>
		AgуQ[@A킸ȕוϓłAvP[Vɑ傫ȉeyڂł́A
		ftHgl 1 ȏɐݒ肳Ă\܂B<br>
		iۂɃZbglɂĂ ::criAtomPlayer_SetDefaultConfigForRawPcmPlayer
		}N̓KpʂmFĂBj<br>
		<br>
		 decode_latency ̒l 4 ȏ̒lw肷邱Ƃ͂ł܂B<br>
		i decode_latency  4 ȏ̒lw肵ꍇłACu 3 ɕύX܂Bj<br>
	*/
	CriSint32 decode_latency;

	/*JP
		\brief vbgtH[ŗL̃p[^[ւ̃|C^
		\par :
		vbgtH[ŗL̃p[^[ւ̃|C^w肵܂B
		NULLw肵ꍇAvbgtH[̃ftHgp[^[Ńv[[쐬܂B<br>
		p[^[\̂͊evbgtH[ŗLwb_[ɒ`Ă܂B
		p[^[\̂`ĂȂvbgtH[ł́ANULLw肵ĂB
	*/
	void *context;
} CriAtomRawPcmPlayerConfig;

/*JP
 * \ingroup ATOMLIB_PLAYER
 * CXgDgv[[쐬pRtBO\
 * \par :
 * CXgDgĐ\ȃv[[쐬ۂɁAdlw肷邽߂̍\̂łB<br>
 * <br>
 * 쐬v[[́Anh쐬ɖ{\̂Ŏw肳ꂽݒɉāA
 * \[XKvȂmۂ܂B<br>
 * v[[KvƂ郏[N̈̃TCÝA{\̂Ŏw肳ꂽp[^[ɉĕω܂B
 * \attention
 * IɃo\邽߁A ::criAtomPlayer_SetDefaultConfigForInstrumentPlayer
 * }NgpȂꍇɂ́AgpOɕK\̂[NAĂB<br>
 * i\̂̃oɕslȂ悤ӂBj
 */
typedef struct CriAtomInstrumentPlayerConfigTag {
	const CriChar8				*interface_name;			/*JP< C^[tF[X					*/
	const CriChar8				*instrument_name;			/*JP< CXgDg					*/
	CriSint32					max_channels;				/*JP< ő`l						*/
	CriSint32					max_sampling_rate;			/*JP< őTvO[g				*/
	CriAtomSoundRendererType	sound_renderer_type;		/*JP< o͐̃TEh_^Cv		*/
} CriAtomInstrumentPlayerConfig;

/*JP
 * \brief ĐXe[^X
 * \ingroup ATOMLIB_PLAYER
 * \par :
 * Atomv[[̍ĐԂlłB<br>
 * ::criAtomPlayer_GetStatus ֐Ŏ擾\łB
 * <br>
 * ĐԂ́Aʏȉ̏őJڂ܂B<br>
 * -# CRIATOMPLAYER_STATUS_STOP
 * -# CRIATOMPLAYER_STATUS_PREP
 * -# CRIATOMPLAYER_STATUS_PLAYING
 * -# CRIATOMPLAYER_STATUS_PLAYEND
 *
 * Atomv[[쐬̏Ԃ́A~ԁi CRIATOMPLAYER_STATUS_STOP jłB<br>
 * ::criAtomPlayer_SetData ֐Ńf[^ZbgA ::criAtomPlayer_Start ֐
 * sƁAĐԁi CRIATOMPLAYER_STATUS_PREP jɑJڂAĐn߂܂B<br>
 * f[^[AĐƁAXe[^X͍Đi CRIATOMPLAYER_STATUS_PLAYING j
 * ɕςȀo͂Jn܂B<br>
 * Zbgꂽf[^SčĐI_ŁAXe[^X͍Đ
 * i CRIATOMPLAYER_STATUS_PLAYEND jɕς܂B
 * \par l
 * Đ ::criAtomPlayer_Stop ֐sꍇAL̗Ɋ֌WȂA
 * ŏIIɃXe[^X CRIATOMPLAYER_STATUS_STOP ɖ߂܂B<br>
 * i ::criAtomPlayer_Stop ֐̌Ăяo^C~OɂẮA CRIATOMPLAYER_STATUS_STOP
 * ɑJڂ܂łɎԂꍇ܂Bj<br>
 * ܂AĐɕsȃf[^ǂݍ񂾏ꍇAt@CANZXɎsꍇA
 * L̗Ɋ֌WȂAXe[^X CRIATOMPLAYER_STATUS_ERROR ɑJڂ܂B
 * \attention
 * Xe[^X CRIATOMPLAYER_STATUS_PREP  CRIATOMPLAYER_STATUS_PLAYING ̃^C~Oł́A
 * f[^̃Zbgi ::criAtomPlayer_SetData ֐jAĐ̊Jni ::criAtomPlayer_Start ֐j
 * ͍s܂B<br>
 * ݍĐAtomv[[~ĕʂ̃f[^Đꍇ́AU ::criAtomPlayer_Stop
 * ֐ōĐ~AXe[^X CRIATOMPLAYER_STATUS_STOP ɑJڂĂ玟̃f[^
 * Zbg^ĐKv܂B
 * \sa criAtomPlayer_GetStatus, criAtomPlayer_SetData, criAtomPlayer_Start, criAtomPlayer_Stop
 */
typedef enum CriAtomPlayerStatusTag {
	CRIATOMPLAYER_STATUS_STOP = 0,		/*JP< ~		*/
	CRIATOMPLAYER_STATUS_PREP = 1,		/*JP< Đ	*/
	CRIATOMPLAYER_STATUS_PLAYING = 2,	/*JP< Đ		*/
	CRIATOMPLAYER_STATUS_PLAYEND = 3,	/*JP< Đ		*/
	CRIATOMPLAYER_STATUS_ERROR = 4,		/*JP< G[	*/

	/* enum size is 4bytes */
	CRIATOMPLAYER_STATUS_ENUM_SIZE_IS_4BYTES = 0x7FFFFFFF
} CriAtomPlayerStatus;

struct CriAtomPlayerTag;
/*JP
 * \brief Atomv[[nh
 * \ingroup ATOMLIB_PLAYER
 * \par :
 * CriAtomPlayerHn ́AĐpɍꂽv[[𑀍삷邽߂̃nhłB<br>
 * ::criAtomPlayer_CreateAdxPlayer ֐ŉĐp̃v[[쐬ƁA
 * ֐̓v[[pɁA"Atomv[[nh"Ԃ܂B
 * <br>
 * Atomv[[Ƃ́AR[fbNɈˑȂĐ̂߂̃C^[tF[X񋟂A
 * ۉꂽv[[IuWFNgłB<br>
 * Atomv[[̍쐬@͍Đ鉹R[fbNɂقȂ܂A
 * 쐬ꂽv[[̐ɂẮAAtomv[[pAPIʂŗp\łB
 * <br>
 * f[^̃ZbgĐ̊JnAXe[^X̎擾Av[[ɑ΂čśA
 * SAtomv[[nhĎs܂B<br>
 * \sa criAtomPlayer_CreateAdxPlayer
 */
typedef struct CriAtomPlayerTag *CriAtomPlayerHn;

/*JP
 * \brief f[^vR[obN֐
 * \ingroup ATOMLIB_PLAYER
 * \par :
 * \param[in]	obj		[UwIuWFNg
 * \param[in]	player	Atomv[[nh
 * \return				Ȃ
 * \par :
 * ɍĐf[^w肷邽߂̃R[obN֐łB<br>
 * ̉f[^V[XɘAčĐۂɎgp܂B<br>
 * <br>
 * R[obN֐̓o^ɂ ::criAtomPlayer_SetDataRequestCallback ֐gp܂B<br>
 * o^R[obN֐́AAtomv[[AĐp̃f[^v^C~O
 * s܂B<br>
 * iÕf[^ǂݍݏIāAɍĐׂf[^v^C~O
 * R[obN֐s܂Bj
 * {֐ ::criAtomPlayer_SetData ֐pAtomv[[Ƀf[^ZbgƁA
 * Zbgꂽf[^͌ݍĐ̃f[^ɑăV[XɘAčĐ܂B<br>
 * ܂A{֐ ::criAtomPlayer_SetPreviousDataAgain ֐s邱ƂŁA
 * f[^JԂĐ邱Ƃ\łB
 * \par l:
 * {֐Ńf[^w肵ȂꍇÃ݂f[^ĐI_ŁA
 * Atomv[[̃Xe[^X CRIATOMPLAYER_STATUS_PLAYEND ɑJڂ܂B<br>
 * <br>
 * ^C~O̖ɂAf[^w肷邱ƂłȂAXe[^X
 * CRIATOMPLAYER_STATUS_PLAYEND ɑJڂȂꍇɂ́AR[obN֐
 * ::criAtomPlayer_DeferCallback ֐sĂB<br>
 * ::criAtomPlayer_DeferCallback ֐s邱ƂŁA1Vɍēxf[^v
 * R[obN֐Ăяo܂BiR[obNgC\Bj<br>
 * A ::criAtomPlayer_DeferCallback ֐sꍇAĐr؂
 * iAӏɈ莞Ԗj\܂B<br>
 * \attention
 * {R[obN֐ŒԏubNƁA؂ꓙ̖肪܂̂ŁA
 * ӂB<br>
 * \sa criAtomPlayer_SetDataRequestCallback, criAtomPlayer_SetData,
 * criAtomPlayer_SetPreviousDataAgain, criAtomPlayer_DeferCallback
 */
typedef void (CRIAPI *CriAtomPlayerDataRequestCbFunc)(void *obj, CriAtomPlayerHn player);

/*JP
 * \brief Xe[^XύXR[obN֐
 * \ingroup ATOMLIB_PLAYER
 * \par :
 * \param[in]	obj		[UwIuWFNg
 * \param[in]	player	Atomv[[nh
 * \return				Ȃ
 * \par :
 * Atomv[[̃Xe[^XύX^C~OŎsR[obN֐łB<br>
 * <br>
 * R[obN֐̓o^ɂ ::criAtomPlayer_SetStatusChangeCallback ֐gp܂B<br>
 * o^R[obN֐́AAtomv[[̃Xe[^XXV^C~O
 * s܂B<br>
 * ύXꂽXe[^XɂẮAœnAtomv[[nhiplayerjɑ΂A
 * ::criAtomPlayer_GetStatus ֐s邱ƂŎ擾\łB
 * \par l:
 * ɂ́AXe[^XJځ`R[obN֐s܂ł̊Ԃɑ̏荞݂œ삷
 * ]n邽߁AXe[^XJڂƃR[obN֐s̃^C~OY\܂B<br>
 * \attention
 * {R[obN֐ŒԏubNƁA؂ꓙ̖肪܂̂ŁA
 * ӂB<br>
 * \sa criAtomPlayer_SetStatusChangeCallback, criAtomPlayer_GetStatus
 */
typedef void (CRIAPI *CriAtomPlayerStatusChangeCbFunc)(void *obj, CriAtomPlayerHn player);

/*JP
 * \brief p[^[ύXR[obN֐
 * \ingroup ATOMLIB_PLAYER
 * \par :
 * \param[in]	obj				[UwIuWFNg
 * \param[in]	player			Atomv[[nh
 * \param[in]	id				p[^[ID
 * \param[in]	value			p[^[l
 * \return				Ȃ
 * \par :
 * Atomv[[̃p[^[ύX^C~OŎsR[obN֐łB<br>
 * <br>
 * R[obN֐̓o^ɂ ::criAtomPlayer_SetParameterChangeCallback ֐gp܂B<br>
 * o^R[obN֐́AAtomv[[̃p[^[XV^C~OŎs܂B<br>
 * \attention
 * {R[obN֐ŒԏubNƁA؂ꓙ̖肪܂̂ŁA
 * ӂB<br>
 * \sa criAtomPlayer_SetParameterChangeCallback
 */
typedef void (CRIAPI *CriAtomPlayerParameterChangeCbFunc)(void *obj,
	CriAtomPlayerHn player, CriAtomParameterId id, CriFloat32 value);

/*JP
 * \brief g`tB^[R[obN֐
 * \ingroup ATOMLIB_PLAYER
 * \par :
 * \param[in]		obj				[UwIuWFNg
 * \param[in]		format			PCM̌`
 * \param[in]		num_channels	`l
 * \param[in]		num_samples		Tv
 * \param[in,out]	data			PCMf[^̃`lz
 * \return						Ȃ
 * \par :
 * fR[hʂ PCM f[^󂯎R[obN֐łB<br>
 * <br>
 * R[obN֐̓o^ɂ ::criAtomPlayer_SetFilterCallback ֐gp܂B<br>
 * R[obN֐o^ƁA Atom v[[f[^fR[hxɁA
 * R[obN֐s悤ɂȂ܂B<br>
 * <br>
 * tB^[R[obN֐ɂ́A PCM f[^̃tH[}bg`lA
 * QƉ\ȃTvA PCM f[^i[̈̃AhXԂ܂B<br>
 * R[obNł PCM f[^̒l𒼐ڎQƉ\ɂȂ̂ŁA
 * Đ̉̐U`FbNƂprɗp\łB<br>
 * <br>
 * ܂AR[obN֐ PCM f[^HƁAĐɔf邽߁A
 * PCM f[^ɑ΂ă[UƎ̃GtFNg邱Ƃ\łB<br>
 * iA^CXgb`̂悤ȃf[^ʂHsƂ͂ł܂Bj<br>
 * \par l:
 * PCM f[^̓`lPʂŕĂ܂B<br>
 * iC^[[uĂ܂Bj<br>
 *  6 i data zjɂ́Ae`l PCM f[^z̐擪AhXi[Ă܂B<br>
 * i񎟌z̐擪AhXł͂ȂA`lƂ PCM f[^z̐擪AhXi[
 * ꎟ̃|C^złBj<br>
 * <br>
 * vbgtH[ɂāA PCM f[^̃tH[}bg͈قȂ܂B<br>
 * s̃f[^tH[}bgɂẮA 3 i format jŔʉ\łB<br>
 * PCM f[^̃tH[}bg 16 bit ^̏ꍇA format  CRIATOM_PCM_FORMAT_SINT16 ƂȂA
 * PCM f[^̃tH[}bg 32 bit _^̏ꍇA format  CRIATOM_PCM_FORMAT_FLOAT32 ƂȂ܂B<br>
 * ꂼ̃P[X PCM f[^̒l͈قȂ܂̂łӂB<br>
 * - CRIATOM_PCM_FORMAT_SINT16  -32768 ` +32767
 * - CRIATOM_PCM_FORMAT_FLOAT32  -1.0f ` +1.0f
 *
 * ifR[h_ł̓NbsOsĂȂ߁A CRIATOM_PCM_FORMAT_FLOAT32
 * ͏L͈͂킸ɒlo\܂Bj<br>
 * \attention
 * R[obN֐ŒԏubNƁA؂ꓙ̖肪\܂B<br>
 * \sa criAtomPlayer_SetFilterCallback
 */
typedef void (CRIAPI *CriAtomPlayerFilterCbFunc)(void *obj, CriAtomPcmFormat format,
	CriSint32 num_channels, CriSint32 num_samples, void *data[]);

/*JP
 * \brief [hvR[obN֐
 * \ingroup ATOMLIB_PLAYER
 * \par :
 * \param[in]	obj		[UwIuWFNg
 * \param[in]	binder	t@C[hoC_[
 * \param[in]	path	t@CpX
 * \param[in]	offset	[hJnʒu
 * \param[in]	length	[hvTCY
 * \return				Ȃ
 * \par :
 * Atomv[[̃t@C[hԂĎ邽߂́AfobOp̃R[obN֐łB<br>
 * R[obN֐̓o^ɂ ::criAtomPlayer_SetLoadRequestCallback ֐gp܂B<br>
 * <br>
 * o^R[obN֐́AAtomv[[f[^̃[hv𔭍s^C~OŎs܂B<br>
 * \par l:
 * \attention
 * {R[obN֐ŒԏubNƁA؂ꓙ̖肪܂̂ŁA
 * ӂB<br>
 * \sa criAtomPlayer_SetLoadRequestCallback
 */
typedef void (CRIAPI *CriAtomPlayerLoadRequestCbFunc)(void *obj,
	CriFsBinderHn binder, const CriChar8 *path, CriSint64 offset, CriSint64 length);

/*==========================================================================
 *      CRI Atom D-BAS API
 *=========================================================================*/
/*JP
 * \brief Atom D-BAS ID
 * \ingroup ATOMLIB_DBAS
 * \par :
 * CriAtomDbasId ́AD-BASǗpIDłB<br>
 * ::criAtomDbas_Create ֐D-BAS쐬Ǝ擾ł܂B
 * <br>
 * AvP[VD-BAS ID𗘗p̂́AD-BAS̔ĵ݂łB
 * \sa criAtomDbas_Create, criAtomDbas_Destroy
 */
typedef CriSint32 CriAtomDbasId;

/*JP
 * \brief D-BAS쐬p[^[\
 * \ingroup ATOMLIB_DBAS
 * \par :
 * ::criAtomDbas_Create ֐̈Ɏw肷AD-BAS̍쐬p[^[\̂łB<br>
 * <br>
 * \attention
 * IɃo\邽߁A ::criAtomDbas_SetDefaultConfig
 * }NgpȂꍇɂ́AgpOɕK\̂[NAĂB<br>
 * i\̂̃oɕslȂ悤ӂBj
 * \sa criAtomDbas_Create, criAtomDbas_CalculateWorkSize, criAtomDbas_SetDefaultConfig
 */
typedef struct CriAtomDbasConfigTag {
	/*JP
		\brief D-BAS ʎq
		\par :
		AvP[VD-BAS쐬ۂɎw肷鎯ʎqłB<br>
		AvP[VǂD-BASgIɎw肷ۂɎgp܂B<br>
	*/
	CriUint32 identifier;				/*JP< D-BAS ʎq	*/
	/*JP
		\brief őXg[~O
		\par :
		D-BASŊǗuԍőXg[~O{w肵܂B<br>
		I[fBIłȂASofdec2ōĐ郀[r[f[^̃Xg[~O{Kv܂B<br>
		Ⴆ΁AV[Ał̓I[fBIf[^Q{A
		V[Bł̓I[fBIf[^P{ƃ[r[f[^Q{AXg[~OĐƂ܂B<br>
		̏ꍇAuԍőXg[~O{̓V[B̂R{ݒ肵ĂB<br>
		܂AAvP[VŜʂāAňԂ̃Xg[~O{z肵lݒ肵ĂB
	*/
	CriSint32 max_streams;
	/*JP
		\brief őrbg[g
		\par :
		Xg[~OŜɂuԍőrbg[gw肵܂B<br>
		̒lɂ́AAvP[VŜʂāA
		Xg[~OĐf[^̏rbg[g̃s[Nlݒ肵ĂB<br>
		I[fBIłȂASofdec2ōĐ郀[r[f[^̏rbg[gKv܂B<br>
		Ⴆ΁AV[Ał̓I[fBIf[^S{AV[Bł̓[r[f[^P{AXg[~OĐƂ܂B<br>
		̎AI[fBIf[^S{̏rbg[g[r[f[^P{̏rbg[g傫ꍇA<br>
		[r[f[^̏rbg[gݒ肵ĂB<br>
		܂AAvP[VŜʂāAňԂ̏rbg[gz肵lݒ肵ĂB
	*/
	CriSint32 max_bps;
	/*JP
		\brief CRI ManaōĐőXg[~O
		\par :
		CRI ManaōĐuԍőXg[~O{w肵܂B<br>
		D-BAS̃gpʂ̌vZł́Amax_streams 炱̒lXg[~O{A<br>
		CRI Atom̍őXg[~O{ƂĈ܂B<br>
		CRI ManaŃXg[~OĐsȂꍇ 0 ɐݒ肵ĂB<br>
	*/
	CriSint32 max_mana_streams;
	/*JP
		\brief CRI ManaōĐőrbg[g
		\par :
		CRI ManaōĐuԍőrbg[gw肵܂B<br>
		D-BAS̃gpʂ̌vZł́Amax_bps 炱̒lrbg[gA<br>
		CRI Atom̍őrbg[gƂĈ܂B<br>
		CRI ManaŃXg[~OĐsȂꍇ 0 ɐݒ肵ĂB<br>
	*/
	CriSint32 max_mana_bps;
	/*JP
		\brief PXg[Ɋ蓖ĂŒۏ؃obt@[
		\par :
		PXg[Ɋ蓖ĂŒۏ؃obt@[w肵܂BPʂ[]łB<br>
		ADXł̓obt@[ubNPʂŊǗĂ邽߁A
		t@CI[⃋[v擪̔[ȃf[^TCYɑ΂ĂA
		obt@[ubNP蓖Ă܂B<br>
		Vbg̃Xg[~OĐł́A
		_uobt@OŃf[^ǂނ̒PȏłĂA
		Xg[r؂鎖͂܂B<br>
		A[vtf[^̏ꍇł́A[vI[̂킸ȃf[^ɂPubNA
		[v擪̂킸ȃf[^ɂPubNgĂ܂ƁA<br>
		obt@Oς݂̃f[^ɒ[ɏȂɂ炸A
		̃f[^ǂݍރobt@[󂩂Ȃ߃Xg[r؂Ă܂܂B<br>
		{p[^[́AD-BASmۂXg[~Oobt@[TCYɉe^܂B<br>
		r؂Ȃ\ɊmFłĂ΁A
		{p[^[̉l ::CRIATOMDBAS_MINIMUM_NUM_SECUREMENT_BUFFERS łB<br>
	*/
	CriSint32 num_securement_buffers;
} CriAtomDbasConfig;

/* ========================================================================*/
/*       CRI Atom Streaming Cache API                                      */
/* ========================================================================*/
/*JP
 * \brief Xg[~OLbVID
 * \ingroup ATOMLIB_STREAMING_CACHE
 * \par :
 * CriAtomStreamingCacheId ́AXg[~OLbVǗpIDłB<br>
 * ::criAtomStreamingCache_Create ֐ŃXg[~OLbV쐬Ǝ擾ł܂B<br>
 * \sa criAtomStreamingCache_Create
 */
typedef CriUintPtr CriAtomStreamingCacheId;

/*JP
 * \brief Xg[~OLbV쐬pRtBO\
 * \ingroup ATOMLIB_PLAYER
 * \par :
 * v[[ɃXg[~OLbV쐬ۂɁA
 * LbV\ȃt@CTCYo^邽߂̍\̂łB<br>
 * ::criAtomStreamingCache_CalculateWorkSize ֐A
 * ::criAtomStreamingCache_Create ֐̈Ɏw肵܂B<br>
 * <br>
 * \attention
 * IɃo\邽߁AgpOɕK\̂[NAĂB<br>
 * i\̂̃oɕslȂ悤ӂBj
 * \sa criAtomStreamingCache_CalculateWorkSize, criAtomStreamingCache_Create
 */
typedef struct CriAtomStreamingCacheConfigTag {
	/*JP
		\brief LbVt@C̍őpX
		\par :
		Xg[~OLbVŃLbVt@C̍őpXw肵܂B<br>
	*/
	CriSint32 max_path;
	/*JP
		\brief LbV\ȃt@C̍ő吔
		\par :
		Xg[~OLbVŃLbVt@Cw肵܂B<br>
	*/
	CriSint32 max_files;
	/*JP
		\brief LbV\ȃt@CTCY
		\par :
		Xg[~OLbVŃLbV\ȃt@CTCYw肵܂B<br>
		̃p[^[Ŏw肵ȏ̃t@CLbV邱Ƃ͂ł܂B<br>
		܂AXg[~OLbV̕Kv[NTCÝA
		̃p[^[Ŏw肵TCYȏ̃TCYv܂B<br>
	*/
	CriSint32 cache_size;
} CriAtomStreamingCacheConfig;

/* ========================================================================*/
/*       CRI Atom DSP API                                                  */
/* ========================================================================*/

/*JP
 * \brief sb`Vt^[A^b`pp[^[\
 * \ingroup ATOMLIB_DSP
 * \par :
 * sb`Vt^[DSPA^b`ۂɎw肷p[^[łB<br>
 * ::criAtomExVoicePool_AttachDspPitchShifter ֐
 * ::CriAtomExDspPitchShifterConfig \̂̃oƂĎw肵܂B<br>
 * \sa criAtomExVoicePool_AttachDspPitchShifter
 */
typedef struct CriAtomDspPitchShifterConfigTag {
	/*JP
		\brief sb`Vtg[h
		\par :
		sb`Vtg̏@iASYjw肵܂B<br>
		ɂĐݒύXƉシ邱Ƃ܂B<br>
		L͎w\ȒlƑΉ郂[hłB<br>
		0: Music<br>
		1: Vocal<br>
		2: SoundEffect<br>
		3: Speech<br>
	*/
	CriSint32 mode;

	/*JP
		\brief EChETCY
		\par :
		sb`Vtg̏PʂłB<br>
		ɂĐݒύXƉシ邱Ƃ܂B<br>
		128,256,512,1024,2048̂ꂩݒ\łB<br>
	*/
	CriSint32 window_size;

	/*JP
		\brief I[o[bv
		\par :
		sb`Vtǧʂ̃I[o[bv񐔂łB<br>
		ݒ肷قǕiサ܂AׂƂ̃g[hItłB<br>
		1,2,4,8̂ꂩݒ\łB<br>
	*/
	CriSint32 overlap_times;
} CriAtomDspPitchShifterConfig;

/*JP
 * \brief sb`Vt^[pp[^[
 * \ingroup ATOMLIB_DSP
 * \par :
 * sb`Vt^[DSPɎw肷p[^[łB<br>
 * ::criAtomExPlayer_SetDspParameter ֐ param_id Ɏw肵܂B
 * \sa criAtomExPlayer_SetDspParameter
 */
typedef enum CriAtomDspPitchShifterParameterIdTag {
	/*JP
		\brief sb`
		\par :
		sb`Vt^[̃sb`VtgʂłB<br>
		Pʂ̓ZgłB<br>
		ݒ\Ȓl͈̔͂ -2400 ` 2400 ܂łłB<br>
		\par l:
		Ɣׂ 1200  2{A-1200  1/2{ ̃sb`VtgɂȂ܂B<br>
	*/
	CRIATOMDSP_PITCHSHIFTER_PARAM_PITCH		= 0,

	/*JP
		\brief tH}g
		\par :
		sb`Vt^[̃tH}gVtgʂłB<br>
		Pʂ̓ZgłB<br>
		ݒ\Ȓl͈̔͂ -2400 ` 2400 ܂łłB<br>
		\par l:
		Ɣׂ 1200  2{A-1200  1/2{ ̃tH}gVtgɂȂ܂B<br>
		\attention
		tH}gVtgLɂȂ̂̓sb`Vtg[h Vocal  Speech <br>
		ꍇ݂̂łB<br>
	*/
	CRIATOMDSP_PITCHSHIFTER_PARAM_FORMANT	= 1,

	/*JP
		\brief sb`Vtg[h
		\par :
		sb`Vtg̏@iASYjw肵܂B<br>
		ɂĐݒύXƉシ邱Ƃ܂B<br>
		L͎w\ȒlƑΉ郂[hłB<br>
		0: Music<br>
		1: Vocal<br>
		2: SoundEffect<br>
		3: Speech<br>
	*/
	CRIATOMDSP_PITCHSHIFTER_PARAM_MODE		= 2
} CriAtomDspPitchShifterParameterId;

/*JP
 * \brief ^CXgb`pp[^[\
 * \ingroup ATOMLIB_DSP
 * \par :
 * ^CXgb`DSPA^b`ۂɎw肷p[^[łB<br>
 * ::criAtomExVoicePool_AttachDspTimeStretch ֐
 * ::CriAtomExDspTimeStretchConfig \̂̃oƂĎw肵܂B<br>
 * \sa criAtomExVoicePool_AttachDspTimeStretch
 */
typedef struct CriAtomDspTimeStretchConfigTag {
	CriSint32 reserved;
} CriAtomDspTimeStretchConfig;

/*JP
 * \brief ^CXgb`pp[^[
 * \ingroup ATOMLIB_DSP
 * \par :
 * ^CXgb`DSPɎw肷p[^[łB<br>
 * ::criAtomExPlayer_SetDspParameter ֐ param_id Ɏw肵܂B
 * \sa criAtomExPlayer_SetDspParameter
 */
typedef enum CriAtomDspTimeStretchParameterIdTag {
	/*JP
		\brief Xgb`䗦
		\par :
		ĐԂ̔{łB<br>
		f[^̍Đ ratio |lXgb`ʂ̍ĐԂƂȂ܂B<br>
		ݒ\Ȓl͈̔͂ 0.5f ` 2.0f ܂łłB<br>
		\attention
		ݒ肷l͍Đxł͂ȂuĐԁvɑ΂{łB<br>
		Xgb`̊ĐxŎw肷ꍇAĐx̔{̋tݒ肵ĂB<br>
	*/
	CRIATOMDSP_TIMESTRETCH_PARAM_RATIO		= 0,

	/*JP
		\brief t[
		\par :
		^CXgb`ۂ̃t[(P:~b)łB<br>
		Đ鉹̎ނɂĒ邱Ƃŕiコ܂B<br>
		ݒ\Ȓl͈̔͂ 10 ` 60 ܂łłB<br>
		\par l:
		{CX 20msec ӂAy 50msec ӂŗǍDȕiɂȂ܂B<br>
	*/
	CRIATOMDSP_TIMESTRETCH_PARAM_FRAME_TIME	= 1,

	/*JP
		\brief i
		\par :
		^CXgb`̕iłB<br>
		قǕiオ܂ACPUׂƂ̃g[hItłB<br>
		ݒ\Ȓl͈̔͂ 0 ` 10 ܂łłB<br>
		\par l:
		l̐͒߂ł\ŁAy^CXgb`ꍇ́A
		ݒ肷قǗǍDɂȂ܂B<br>
	*/
	CRIATOMDSP_TIMESTRETCH_PARAM_QUALITY	= 2
} CriAtomDspTimeStretchParameterId;

/*JP
 * \brief XyNgAiCU쐬pp[^[\
 * \ingroup ATOMLIB_DSP
 * \par :
 * XyNgAiCUA^b`ۂɎw肷p[^[łB<br>
 * ::criAtomDspSpectra_Create ֐̈Ɏgp܂B<br>
 * \sa criAtomDspSpectra_Create
 */
typedef struct CriAtomDspSpectraConfigTag {
	/*JP
		\brief ш敪
		\par :
		g̑шɕČv邩w肵܂B<br>
		::criAtomDspSpectra_GetLevels ֐̖߂li CriFloat32 zj́A
		{p[^[Ŏw肵ƓɂȂ܂B<br>
	*/
	CriUint32 num_bands;
} CriAtomDspSpectraConfig;

/* XyNgAiCUnh */
struct CriAtomDspSpectraObj;
typedef struct CriAtomDspSpectraObj *CriAtomDspSpectraHn;

/*JP
 * \brief GtFNgC^[tF[X\̂̕sS^
 * \par :
 * GtFNgC^[tF[Xo^֐̈^łB<br>
 * CriAtomDspAfxConfig\̂̃o[ƂĎw肵܂B
 * \sa criAtomExVoicePool_AttachDspAfx
 */
typedef const struct CriAfxInterfaceWithVersionTag* CriAtomAfxInterfaceWithVersionPtr;

/*JP
 * \brief CT[VDSPAFXpp[^[\
 * \ingroup ATOMLIB_DSP
 * \par :
 * AFX`̃CT[VDSPA^b`ۂɎw肷p[^[łB<br>
 * ::criAtomExVoicePool_AttachDspAfx ֐
 * ::CriAtomExDspAfxConfig \̂̃oƂĎw肵܂B<br>
 * \sa criAtomExVoicePool_AttachDspAfx
 */
typedef struct CriAtomDspAfxConfigTag {
	/*!
	* \brief RtBOp[^[
	* \par :
	* RtBOp[^[w肵܂B
	*/
	CriUint32		num_config_parameters;

	/*!
	* \brief RtBOp[^[z
	* \par :
	* GtFNgCX^XɎgpp[^[̔zݒ肵܂B<br>
	* {p[^[́ACX^XɕKvƂȂǉ̃p[^[łA쎞p[^[Ƃ͈قȂ܂B <br>
	* Ⴆ΁AfBCGtFNg̃RtBOp[^[łőxԂ́A <br>
	* CX^Xɗpӂxobt@TCYm肳ׂɗpӂĂA쎞͎gp܂B
	*/
	const CriFloat32	*config_parameters;

	/*!
	* \brief 쎞p[^[
	* \par :
	* 쎞p[^[w肵܂B
	*/
	CriUint32		num_parameters;

	/*!
	* \brief ftHgp[^[z
	* \par :
	* GtFNg̓쎞p[^[̃ftHglzݒ肵܂B<br>
	* {CXv[ɃGtFNgA^b`AGtFNg̃p[^[ꍇAŎw肵p[^[ɂȂ܂B <br>
	*/
	const CriFloat32	*default_parameters;

	/*JP
	\brief Afx`GtFNg̃C^tF[X
	\par :
	A^b`Afx`̃GtFNgC^tF[Xݒ肵܂B
	*/
	CriAtomAfxInterfaceWithVersionPtr afx_if;
} CriAtomDspAfxConfig;

/* ========================================================================*/
/*       CRI Atom Meter API                                                */
/* ========================================================================*/

/*JP
 * \brief x[^[@\ǉpRtBO\
 * \ingroup ATOMLIB_METER
 * \par :
 * x[^[@\ǉ邽߂̍\̂łB<br>
 * ::criAtomMeter_AttachLevelMeter ֐̈Ɏw肵܂B<br>
 * \par l:
 * ftHgݒgpꍇA ::criAtomMeter_SetDefaultConfigForLevelMeter }N
 * \̂ɃftHgp[^[ZbgA ::criAtomMeter_AttachLevelMeter ֐
 * ɍ\̂w肵ĂB<br>
 * \attention
 * IɃo\邽߁A ::criAtomMeter_SetDefaultConfigForLevelMeter
 * }NgpȂꍇɂ́AgpOɕK\̂[NAĂB<br>
 * i\̂̃oɕslȂ悤ӂBj
 * \sa criAtomMeter_AttachLevelMeter
 */
typedef struct {
	/*JP
		\brief Ԋui~bPʁj
		\par :
		茋ʂXVԊułB<br>
	*/
	CriSint32 interval;

	/*JP
		\brief s[Nz[hԁi~bPʁj
		\par :
		s[Nl傫lōXVꂽƂAȂ悤Ƀz[h鎞ԂłB<br>
	*/
	CriSint32 hold_time;
} CriAtomLevelMeterConfig;

/*JP
 * \brief x
 * \ingroup ATOMLIB_METER
 * \par :
 * x擾邽߂̍\̂łB<br>
 * ::criAtomMeter_GetLevelInfo ֐ŗp܂B
 * \par l:
 * exl̒PʂdBłB<br>
 * \sa criAtomMeter_GetLevelInfo
 */
typedef struct CriAtomLevelInfoTag {
	/*JP
		\brief L`l
		\par :
		茋ʂLȃ`lłB<br>
	*/
	CriSint32 num_channels;

	/*JP
		\brief RMSx
		\par :
		ԊuԂ̉URMSi敽ϕjvZlłB<br>
		xƂĈ܂B
	*/
	CriFloat32 rms_levels[16];

	/*JP
		\brief s[Nx
		\par :
		ԊuԂ̉U̍őlłB<br>
	*/
	CriFloat32 peak_levels[16];

	/*JP
		\brief s[Nz[hx
		\par :
		z[hĂs[NxlłB<br>
	*/
	CriFloat32 peak_hold_levels[16];
} CriAtomLevelInfo;

/*JP
 * \brief EhlX[^[@\ǉpRtBO\
 * \ingroup ATOMLIB_METER
 * EhlX[^[@\ǉ邽߂̍\̂łB<br>
 * ::criAtomMeter_AttachLoudnessMeter ֐̈Ɏw肵܂B<br>
 * \par l:
 * ftHgݒgpꍇA ::criAtomMeter_SetDefaultConfigForLoudnessMeter }N
 * \̂ɃftHgp[^[ZbgA ::criAtomMeter_AttachLoudnessMeter ֐
 * ɍ\̂w肵ĂB<br>
 * \attention
 * IɃo\邽߁A ::criAtomMeter_SetDefaultConfigForLoudnessMeter
 * }NgpȂꍇɂ́AgpOɕK\̂[NAĂB<br>
 * i\̂̃oɕslȂ悤ӂBj
 * \sa criAtomMeter_AttachLoudnessMeter
 */
typedef struct {
	/*JP
		\brief V[g^[莞
		\par :
		Z̕σEhlX̑莞ԁibPʁjłB<br>
		W3błB<br>
	*/
	CriSint32 short_term_time;

	/*JP
		\brief CeO[ebh莞
		\par :
		̕σEhlX̑莞ԁibPʁjłB<br>
		CeO[ebhl̓RecPʂ̕σEhlXłB<br>
	*/
	CriSint32 integrated_time;
} CriAtomLoudnessMeterConfig;

/*JP
 * \brief EhlX
 * \ingroup ATOMLIB_METER
 * \par :
 * EhlX擾邽߂̍\̂łB<br>
 * ::criAtomMeter_GetLoudnessInfo ֐ŗp܂B
 * \par l:
 * exl̒PʂLKFSłB<br>
 * \sa criAtomMeter_GetLoudnessInfo
 */
typedef struct CriAtomLoudnessInfoTag {
	/*JP
		\brief JEg
		\par :
		肵񐔂łB<br>
		0.1b1񑪒肳܂B<br>
	*/
	CriSint32		count;
	/*JP
		\brief [^[l
		\par :
		uԂ̃EhlXxłB<br>
	*/
	CriFloat32		momentary;
	/*JP
		\brief V[g^[l
		\par :
		Z̃EhlXσxłB<br>
	*/
	CriFloat32		short_term;
	/*JP
		\brief CeO[ebhl
		\par :
		̃EhlXσxłB<br>
	*/
	CriFloat32		integrated;
} CriAtomLoudnessInfo;

/*JP
 * \brief gD[s[N[^[@\ǉpRtBO\
 * \ingroup ATOMLIB_METER
 * gD[s[N[^[@\ǉ邽߂̍\̂łB<br>
 * ::criAtomMeter_AttachTruePeakMeter ֐̈Ɏw肵܂B<br>
 * \par l:
 * ftHgݒgpꍇA ::criAtomMeter_SetDefaultConfigForTruePeakMeter }N
 * \̂ɃftHgp[^[ZbgA ::criAtomMeter_AttachTruePeakMeter ֐
 * ɍ\̂w肵ĂB<br>
 * \attention
 * IɃo\邽߁A ::criAtomMeter_SetDefaultConfigForTruePeakMeter
 * }NgpȂꍇɂ́AgpOɕK\̂[NAĂB<br>
 * i\̂̃oɕslȂ悤ӂBj
 * \sa criAtomMeter_AttachTruePeakMeter
 */
typedef struct {
	/*JP
		\brief NbsO
		\par :
		g`̃Tv𑪒OɃNbvtOłB<br>
		g`̃Tv𑪒OɃNbvtOłB<br>
	*/
	CriBool sample_clipping;

	/*JP
		\brief Ԋui~bPʁj
		\par :
		茋ʂXVԊułB<br>
	*/
	CriSint32 interval;

	/*JP
		\brief z[hԁi~bPʁj
		\par :
		s[Nl傫lōXVꂽƂAȂ悤Ƀz[h鎞ԂłB<br>
	*/
	CriSint32 hold_time;
} CriAtomTruePeakMeterConfig;

/*JP
 * \brief gD[s[N
 * \ingroup ATOMLIB_METER
 * \par :
 * gD[s[N擾邽߂̍\̂łB<br>
 * ::criAtomMeter_GetTruePeakInfo ֐ŗp܂B
 * \par l:
 * exl̒PʂdBłB<br>
 * \sa criAtomMeter_GetTruePeakInfo
 */
typedef struct CriAtomTruePeakInfoTag {
	/*JP
		\brief L`l
		\par :
		茋ʂLȃ`lłB<br>
	*/
	CriSint32		num_channels;

	/*JP
		\brief gD[s[Nx
		\par :
		gD[s[N[^[̑茋ʂłB<br>
	*/
	CriFloat32		levels[16];

	/*JP
		\brief s[Nz[hx
		\par :
		z[hĂs[NxłB<br>
	*/
	CriFloat32		hold_levels[16];
} CriAtomTruePeakInfo;

/*==========================================================================
 *      CRI Atom Instrument API
 *=========================================================================*/
/*JP
 * \brief o[WtC^[tF[X^
 * \par :
 * CXgDgC^[tF[Xo^֐̈^łB
 * \sa  criAtomInstrument_RegisterInstrumentInterface, criAtomInstrument_UnregisterInstrumentInterface
 */
typedef const struct CriAinstInterfaceWithVersionTag* CriAtomAinstInterfaceWithVersionPtr;

/***************************************************************************
 *      ϐ錾
 *      Prototype Variables
 ***************************************************************************/

/***************************************************************************
 *      ֐錾
 *      Prototype Functions
 ***************************************************************************/
#ifdef __cplusplus
extern "C" {
#endif

/*==========================================================================
 *      CRI Atom API
 *=========================================================================*/
/*JP
 * \brief Cũo[WԍrhԂ܂B
 * \ingroup ATOMLIB_GLOBAL
 * \return	const CriChar8*	Cu񕶎
 * \par :
 * Cũo[WArhAvbgtH[̏񂪕\܂B
 */
const CriChar8* CRIAPI criAtom_GetVersionString(void);

/*JP
 * \brief Cup[N̈TCY̌vZ
 * \ingroup ATOMLIB_GLOBAL
 * \param[in]	config		pRtBO\
 * \return		CriSint32	[N̈TCY
 * \retval		0ȏ		ɏ
 * \retval		-1			G[
 * \par :
 * CRI AtomCugp邽߂ɕKvȁA[N̈̃TCY擾܂B<br>
 * <br>
 * [N̈TCY̌vZɎsƁA{֐ -1 Ԃ܂B<br>
 * [N̈TCY̌vZɎsRɂẮAG[R[obÑbZ[WŊmF\łB<br>
 * \par l:
 * CRI AtomCuKvƂ郏[N̈̃TCÝACupRtBO
 * \́i ::CriAtomConfig j̓eɂĕω܂B<br>
 * <br>
 * NULLw肵ꍇAftHgݒ
 * i ::criAtom_SetDefaultConfig KpƓp[^[j
 * [N̈TCYvZ܂B
 * <br>
 *  config ̏́A֐ł̂ݎQƂ܂B<br>
 * ֐𔲂͎QƂ܂̂ŁA֐s config ̗̈Ă
 * 肠܂B
 * \sa CriAtomConfig, criAtom_Initialize
 */
CriSint32 CRIAPI criAtom_CalculateWorkSize(const CriAtomConfig *config);

/*JP
 * \brief Cȕ
 * \ingroup ATOMLIB_GLOBAL
 * \param[in]	config		pRtBO\
 * \param[in]	work		[N̈
 * \param[in]	work_size	[N̈TCY
 * \par :
 * CRI AtomCu܂B<br>
 * Cű@\𗘗pɂ́AK̊֐sKv܂B<br>
 * iCű@\́A{֐sA ::criAtom_Finalize ֐s܂ł̊ԁA
 * p\łBj<br>
 * <br>
 * Cuۂɂ́ACuŗp邽߂̃̈i[N̈j
 * mۂKv܂B<br>
 * [N̈mۂ@ɂ́Aȉ2ʂ̕@܂B<br>
 * <b>(a) User Allocator</b>F̊mہ^ɁA[Upӂ֐gp@B<br>
 * <b>(b) Fixed Memory</b>FKvȃ̈𒼐ڃCuɓn@B<br>
 * <br>
 * User AllocatorpꍇA[UCRI AtomCuɃmۊ֐o^Ă܂B<br>
 * workNULLAwork_size0w肵Ė{֐ĂяoƂŁA
 * Cu͓o^ς݂̃mۊ֐gpĕKvȃIɊmۂ܂B<br>
 * [U[N̈pӂKv͂܂B<br>
 * Ɋmۂꂽ́AIi ::criAtom_Finalize ֐sjɉ܂B<br>
 * <br>
 * Fixed MemorypꍇA[N̈Ƃĕʓrmۍς݂̃̈{֐
 * ݒ肷Kv܂B<br>
 * [N̈̃TCY ::criAtom_CalculateWorkSize ֐Ŏ擾\łB<br>
 * ̑O ::criAtom_CalculateWorkSize ֐Ŏ擾TCỸ\
 * mۂĂA{֐ɐݒ肵ĂB<br>
 * AFixed MemorypꍇA[N̈̓CȕIi ::criAtom_Finalize ֐j
 * s܂ł̊ԁACuŗpꑱ܂B<br>
 * CȕIsOɁA[N̈̃ȂłB<br>
 * \par :
 * yUser Allocatorɂ郉Cȕz<br>
 * User AllocatorpꍇACȕ^I̎菇͈ȉ̒ʂłB<br>
 * 	-# sOɁA ::criAtom_SetUserMallocFunction ֐
 * ::criAtom_SetUserFreeFunction ֐pămہ^֐o^B<br>
 * 	-# pRtBO\̂Ƀp[^[ZbgB<br>
 * 	-# ::criAtom_Initialize ֐ŏsB<br>
 * iworkɂNULLAwork_sizeɂ0w肷Bj<br>
 * 	-# AvP[VI ::criAtom_Finalize ֐ŏIsB<br>
 *
 * <br>̓IȃR[h͈ȉ̂ƂłB<br>
 * \code
 * // Ǝ̃mۊ֐
 * void *user_malloc(void *obj, CriUint32 size)
 * {
 * 	void *mem;
 *
 * 	// ̊m
 * 	mem = malloc(size);
 *
 * 	return (mem);
 * }
 *
 * // Ǝ̃֐p
 * void user_free(void *obj, void *mem)
 * {
 * 	// ̉
 * 	free(mem);
 *
 * 	return;
 * }
 *
 * main()
 * {
 * 	CriAtomConfig config;	// CupRtBO\
 * 		:
 * 	// Ǝ̃mۊ֐o^
 * 	criAtom_SetUserMallocFunction(user_malloc, NULL);
 *
 * 	// Ǝ̃֐o^
 * 	criAtom_SetUserFreeFunction(user_free, NULL);
 *
 * 	// CupRtBO\̂ɃftHglZbg
 * 	criAtom_SetDefaultConfig(&config);
 *
 * 	// Cȕ
 * 	// [N̈ɂNULL0w肷B
 * 	// Kvȃ́Ao^mۊ֐gĊmۂB
 * 	criAtom_Initialize(&config, NULL, 0);
 * 		:
 * 	// AvP[ṼC
 * 		:
 * 	// AvP[VIۂɏIs
 * 	// Ɋmۂꂽ́Ao^֐gĉB
 * 	criAtom_Finalize();
 * 		:
 * }
 * \endcode
 * <br>
 * yFixed Memoryɂ郉Cȕz<br>
 * Fixed MemorypꍇACȕ^I̎菇͈ȉ̒ʂłB<br>
 * 	-# pRtBO\̂Ƀp[^[ZbgB<br>
 * 	-# CȕɕKvȃ[N̈̃TCYA ::criAtom_CalculateWorkSize
 * ֐gČvZB<br>
 * 	-# [N̈TCỸmۂB<br>
 * 	-# ::criAtom_Initialize ֐ŏsB<br>
 * iworkɂ͊mۂ̃AhXAwork_sizeɂ̓[N̈̃TCYw肷Bj<br>
 * 	-# AvP[VI ::criAtom_Finalize ֐ŏIsB<br>
 * 	-# [N̈̃B<br>
 *
 * <br>̓IȃR[h͈ȉ̂ƂłB<br>
 * \code
 * main()
 * {
 * 	CriAtomConfig config;	// CupRtBO\
 * 	void *work;				// [N̈AhX
 * 	CriSint32 work_size;	// [N̈TCY
 * 		:
 * 	// CupRtBO\̂ɃftHglZbg
 * 	criAtom_SetDefaultConfig(&config);
 *
 * 	// CȕɕKvȃ[N̈̃TCYvZ
 * 	work_size = criAtom_CalculateWorkSize(&config);
 *
 * 	// [N̈pɃm
 * 	work = malloc((size_t)work_size);
 *
 * 	// Cȕ
 * 	// mۍς݂̃[N̈w肷B
 * 	criAtom_Initialize(&config, NULL, 0);
 * 		:
 * 	// AvP[ṼC
 * 	// ̊ԁAmۂ͕ێB
 * 		:
 * 	// AvP[VIۂɏIs
 * 	criAtom_Finalize();
 *
 * 	// KvȂȂ[N̈
 * 	free(work);
 * 		:
 * }
 * \endcode
 * \par l:
 * CuKvƂ郏[N̈̃TCÝApRtBO\̂̓eɉ
 * ω܂B<br>
 * ܂AKvȃ[N̈̃TCÝAvbgtH[ɂĂقȂ܂B
 * <br>
 *  config ̏́A֐ł̂ݎQƂ܂B<br>
 * ֐𔲂͎QƂ܂̂ŁA֐s config ̗̈Ă
 * 肠܂B
 * \attention
 * AXg[Đ̗LɊ֌WȂACRI AtomCȕOɕK
 * CRI File SystemCuĂKv܂B<br>
 * CRI File SystemCȕsĂȂꍇ́A
 * CRI AtomCuCRI File SystemCu܂B<br>
 * ̍ۂ̏p[^[criFs_SetDefaultConfig}NŐݒ肳lłB
 * <br>
 * {֐sAK΂ɂȂ ::criAtom_Finalize ֐sĂB<br>
 * ܂A ::criAtom_Finalize ֐s܂ł́A{֐ēxs邱Ƃ͂ł܂B<br>
 * \sa CriAtomConfig, criAtom_Finalize, criAtom_SetUserMallocFunction,
 * criAtom_SetUserFreeFunction, criAtom_CalculateWorkSize
 */
void CRIAPI criAtom_Initialize(const CriAtomConfig *config, void *work, CriSint32 work_size);

/*JP
 * \brief CȕI
 * \ingroup ATOMLIB_GLOBAL
 * \par :
 * CRI AtomCuI܂B<br>
 * \attention
 * ::criAtom_Initialize ֐sOɖ{֐s邱Ƃ͂ł܂B<br>
 * \sa criAtom_Initialize
 */
void CRIAPI criAtom_Finalize(void);

/*JP
 * \brief CuԂ̎擾
 * \ingroup ATOMLIB_GLOBAL
 * \return	CriBool		ǂ
 * \retval	CRI_FALSE	
 * \retval	CRI_TRUE	ς
 * \par :
 * CRI AtomCuɏĂ邩ǂ`FbN܂B<br>
 * \sa criAtom_Initialize, criAtom_Finalize
 */
CriBool CRIAPI criAtom_IsInitialized(void);

/*JP
 * \brief I[fBIo͂Lǂ̃`FbN
 * \ingroup ATOMLIB_GLOBAL
 * \return	CriBool		I[fBIo͂Lǂ
 * \retval	CRI_TRUE	L
 * \retval	CRI_FALSE	
 * \par :
 * I[fBIo͂Lǂ`FbN܂B<br>
 * CRI AtomCuATEhfoCXp\łꍇA
 * {֐CRI_TRUEԂ܂B<br>
 * CRI AtomCuɁATEhfoCXps\łꍇA
 * {֐CRI_FALSEԂ܂B<br>
 * \par ⑫:
 * TEhfoCXȏꍇłAAtomCu͉o͂ɓ삵܂B<br>
 * if[^ʂ^C}[ɌvZA\Ȍ艹o͂LȏꍇƓ̓G~[g܂Bj<br>
 * ̂߁Ao̓foCXgpłȂP[XłĂA
 * AvP[VAtomCuAPIĂяoKv͂܂B<br>
 * iPCA[UTEhfoCX𖳌ĂP[Xɑ΂ʒmsꍇɁA
 * {֐gpĂBj<br>
 * \attention
 * {֐́AuAtomCu_ŃI[fBIfoCXp\ǂvԂ܂B<br>
 * CuɃ[UTEhfoCX𔲂P[XɂẮA{֐ł͌mł܂B<br>
 * ie@ŗLAPIgpKv܂Bj<br>
 * <br>
 * I[fBIo͂ȏԂAtomCuA
 * [UI[fBIfoCXLƂĂAAtomCu͉o͂s܂B<br>
 * iI[fBIfoCXڑꂽƂAtomCuŌo邱Ƃ͂܂Bj<br>
 * AvP[VsɃI[fBIfoCXLꍇɂ́A
 * AtomCȕ蒼Kv܂B<br>
 * \sa criAtom_Initialize
 */
CriBool CRIAPI criAtom_IsAudioOutputActive(void);

/*JP
 * \brief }`XbhpT[o[̎s
 * \ingroup ATOMLIB_GLOBAL
 * \par :
 * CRI AtomCu̓ԂXV܂B<br>
 * AvP[V́Å֐IɎsKv܂B<br>
 * <br>
 * T[o[sׂ񐔂́ACũp[^[Ɉˑ܂B<br>
 * CuɃXbhf ::CRIATOM_THREAD_MODEL_MULTI ɐݒ肵ꍇA
 * {֐̌Ăяopx͏ȂĂ͔܂B<br>
 * ȂȂAA^Cv鏈͑SCRI AtomCu
 * IɎs邽߂łB<br>
 * iŒłb1xsĂ΁A؂ꓙ̖肪邱Ƃ͂܂Bj<br>
 * CuɃXbhf ::CRIATOM_THREAD_MODEL_SINGLE 
 * ::CRIATOM_THREAD_MODEL_USER_MULTI ɐݒ肵ꍇAt@C̓ǂݍ݊ǗA
 * f[^̃fR[hȀo͓AĐɕKvȏ̂قڑSĂ{֐Ŏs܂B<br>
 * ܂AĐɓāACRI File SystemCũt@CANZXƃf[^WJs܂B<br>
 * ̂߁Aȉ̏ꍇ͉؂Ȃǂ̖肪\̂ŒӂĂB<br>
 * ECuɎw肵T[o[̎spx
 * i ::CriAtomConfig \̂server_frequency jpxŖ{֐sꍇ<br>
 * E傫f[^̓ǂݍ݁Akt@C̓ǂݍݓsꍇ<br>
 * \par l:
 * CuɃXbhf ::CRIATOM_THREAD_MODEL_MULTI ɐݒ肵ꍇłA
 * {֐sKv܂B<br>
 * iXbhf ::CRIATOM_THREAD_MODEL_MULTI ɐݒ肵ꍇAXe[^XXVAꕔ
 * ݂̂s߁A{֐ŒԏubN邱Ƃ͂܂Bj
 * <br>
 * CRI File SystemCũT[o[́ACRI AtomCuŎs܂B<br>
 * ̂߁A{֐sĂꍇAAvP[VŕʓrCRI File SystemCu
 * ̃T[o[ĂяoKv͂܂B<br>
 * \sa criAtom_ExecuteAudioProcess
 */
void CRIAPI criAtom_ExecuteMain(void);

/*JP
 * \brief [U[}`XbhpT[o[̎s
 * \ingroup ATOMLIB_GLOBAL
 * \par :
 * CRI AtomCû݂XV܂B<br>
 * Xbhf::CRIATOM_THREAD_MODEL_USER_MULTȈꍇA
 * AvP[V́Å֐IɎsKv܂B<br>
 *
 * <br>
 * t@C̓ǂݍ݊ǗAf[^̃fR[hȀo͓A
 * ĐɕKvȏ̂قڑSĂ{֐Ŏs܂B<br>
 * ̂߁ACuɎw肵T[o[̎spxi ::CriAtomConfig \̂
 * server_frequency jpxŖ{֐sꍇA؂ꓙ̖肪\
 * ܂B<br>
 * ܂A{֐::criAtom_ExecuteMain ֐ƈقȂACRI File SystemCũT[o[s܂B<br>
 * AvP[VKvȃT[o[𐳂ŎsĂB<br>
 * \par l:
 * ::CRIATOM_THREAD_MODEL_SINGLE ɐݒ肵ꍇAT[o[̔r䂪sȂ̂ŁA
 * ̃XbhĂяoȂ悤ɂĂB<br>
 * \sa criAtom_ExecuteMain
 */
void CRIAPI criAtom_ExecuteAudioProcess(void);

/*JP
 * \brief mۊ֐̓o^
 * \ingroup ATOMLIB_GLOBAL
 * \param[in]	func		mۊ֐
 * \param[in]	obj			[UwIuWFNg
 * \par :
 * CRI AtomCuɃmۊ֐o^܂B<br>
 * CRI AtomCuCuōsmۏA
 * [UƎ̃mۏɒuꍇɎgp܂B<br>
 * <br>
 * {֐̎gp菇͈ȉ̂ƂłB<br>
 * (1) ::CriAtomMallocFunc C^[tF[Xɕmۊ֐pӂB<br>
 * (2) ::criAtom_SetUserMallocFunction ֐gpACRI AtomCuɑ΂
 * mۊ֐o^B<br>
 * <br>
 * ̓IȃR[h̗͈ȉ̂ƂłB
 * \par :
 * \code
 * // Ǝ̃mۊ֐p
 * void *user_malloc(void *obj, CriUint32 size)
 * {
 * 	void *mem;
 *
 * 	// ̊m
 * 	mem = malloc(size);
 *
 * 	return (mem);
 * }
 *
 * main()
 * {
 * 		:
 * 	// mۊ֐̓o^
 * 	criAtom_SetUserMallocFunction(user_malloc, NULL);
 * 		:
 * }
 * \endcode
 * \par l:
 *  obj Ɏw肵ĺA ::CriAtomMallocFunc ɈƂēn܂B<br>
 * mێɃ}l[W[QƂKvꍇɂ́A
 * YIuWFNg{֐̈ɃZbgĂAR[obN֐ňoR
 * ĎQƂĂB<br>
 * \attention
 * mۊ֐o^ۂɂ́A킹ă֐i ::CriAtomFreeFunc j
 * o^Kv܂B
 * \sa CriAtomMallocFunc, criAtom_SetUserFreeFunction
 */
void CRIAPI criAtom_SetUserMallocFunction(CriAtomMallocFunc func, void *obj);

/*JP
 * \brief ֐̓o^
 * \ingroup ATOMLIB_GLOBAL
 * \param[in]	func		֐
 * \param[in]	obj			[UwIuWFNg
 * \par :
 * CRI AtomCuɃ֐o^܂B<br>
 * CRI AtomCuCuōsA
 * [UƎ̃ɒuꍇɎgp܂B<br>
 * <br>
 * {֐̎gp菇͈ȉ̂ƂłB<br>
 * (1) ::CriAtomFreeFunc C^[tF[Xɕ֐pӂB<br>
 * (2) ::criAtom_SetUserFreeFunction ֐gpACRI AtomCuɑ΂
 * ֐o^B<br>
 * <br>
 * ̓IȃR[h̗͈ȉ̂ƂłB
 * \par :
 * \code
 * // Ǝ̃֐p
 * void user_free(void *obj, void *mem)
 * {
 * 	// ̉
 * 	free(mem);
 *
 * 	return;
 * }
 *
 * main()
 * {
 * 		:
 * 	// ֐̓o^
 * 	criAtom_SetUserFreeFunction(user_free, NULL);
 * 		:
 * }
 * \endcode
 * \par l:
 *  obj Ɏw肵ĺA ::CriAtomFreeFunc ɈƂēn܂B<br>
 * mێɃ}l[W[QƂKvꍇɂ́A
 * YIuWFNg{֐̈ɃZbgĂAR[obN֐ňoR
 * ĎQƂĂB<br>
 * \attention
 * ֐o^ۂɂ́A킹ămۊ֐i ::CriAtomMallocFunc j
 * o^Kv܂B
 * \sa CriAtomFreeFunc, criAtom_SetUserMallocFunction
 */
void CRIAPI criAtom_SetUserFreeFunction(CriAtomFreeFunc func, void *obj);

/*JP
 * \brief I[fBIt[JnR[obN֐̓o^
 * \ingroup ATOMLIB_GLOBAL
 * \param[in]	func		I[fBIt[JnR[obN֐
 * \param[in]	obj			[UwIuWFNg
 * \par :
 * CRI AtomCuɃI[fBIt[JnR[obNo^܂B<br>
 * I[fBIt[́ACRI AtomCuŃT[o[s^C~O܂B<br>
 * {֐œo^R[obN֐́AI[fBIt[̊JniT[o[JnOj
 * s܂B
 * \par l:
 * CuɃXbhf}`Xbhi ::CRIATOM_THREAD_MODEL_MULTI j
 * ɐݒ肵ꍇAR[obN֐CRI AtomCuō쐬ꂽXbh
 * Ăяo܂B<br>
 * CuɃXbhf[U}`Xbhi ::CRIATOM_THREAD_MODEL_USER_MULTI jA
 * ܂̓VOXbhi ::CRIATOM_THREAD_MODEL_SINGLE jɐݒ肵ꍇAR[obN֐
 * ::criAtom_ExecuteMain ֐ŌĂяo܂B<br>
 * <br>
 *  obj Ɏw肵ĺA ::CriAtomAudioFrameStartCbFunc ɈƂēn܂B<br>
 * \attention
 * R[obN֐1o^ł܂B<br>
 * o^𕡐sꍇAɓo^ς݂̃R[obN֐A
 * ォo^R[obN֐ɂ㏑Ă܂܂B<br>
 * <br>
 * funcNULLw肷邱Ƃœo^ς݊֐̓o^s܂B<br>
 */
void CRIAPI criAtom_SetAudioFrameStartCallback(
	CriAtomAudioFrameStartCbFunc func, void *obj);

/*JP
 * \brief I[fBIt[IR[obN֐̓o^
 * \ingroup ATOMLIB_GLOBAL
 * \param[in]	func		I[fBIt[IR[obN֐
 * \param[in]	obj			[UwIuWFNg
 * \par :
 * CRI AtomCuɃI[fBIt[IR[obNo^܂B<br>
 * I[fBIt[́ACRI AtomCuŃT[o[s^C~O܂B<br>
 * {֐œo^R[obN֐́AI[fBIt[̏IiT[o[Ij
 * s܂B
 * \par l:
 * CuɃXbhf}`Xbhi ::CRIATOM_THREAD_MODEL_MULTI j
 * ɐݒ肵ꍇAR[obN֐CRI AtomCuō쐬ꂽXbh
 * Ăяo܂B<br>
 * CuɃXbhf[U}`Xbhi ::CRIATOM_THREAD_MODEL_USER_MULTI jA
 * ܂̓VOXbhi ::CRIATOM_THREAD_MODEL_SINGLE jɐݒ肵ꍇAR[obN֐
 * ::criAtom_ExecuteMain ֐ŌĂяo܂B<br>
 * <br>
 *  obj Ɏw肵ĺA ::CriAtomAudioFrameEndCbFunc ɈƂēn܂B<br>
 * \attention
 * R[obN֐1o^ł܂B<br>
 * o^𕡐sꍇAɓo^ς݂̃R[obN֐A
 * ォo^R[obN֐ɂ㏑Ă܂܂B<br>
 * <br>
 * funcNULLw肷邱Ƃœo^ς݊֐̓o^s܂B<br>
 */
void CRIAPI criAtom_SetAudioFrameEndCallback(
	CriAtomAudioFrameEndCbFunc func, void *obj);

/*JP
 * \brief foCXXVʒm̓o^
 * \ingroup ATOMLIB_GLOBAL
 * \param[in]	func	foCXXVʒmR[obN֐
 * \param[in]	obj		[UwIuWFNg
 * \par :
 * foCX̍XVʒm󂯎邽߂̃R[obNݒ肵܂B<br>
 * <br>
 * {֐sƁAfoCXXVꂽہA 1 i callback j
 * ŃZbgꂽR[obN֐Ăяo܂B<br>
 * \par l:
 *  2 i object jɃZbgĺAR[obN֐̈Ƃēn܂B<br>
 */
void CRIAPI criAtom_SetDeviceUpdateCallback(
	CriAtomDeviceUpdateCbFunc func, void *obj);

/*JP
 * \brief T[o[̊荞݂h~
 * \ingroup ATOMLIB_GLOBAL
 * \par :
 * T[o[̊荞݂h~܂B<br>
 * {֐sA::criAtom_Unlock ֐s܂ł̊ԁAT[o[̓h~܂B<br>
 * API𓯈I[fBIt[ŊmɎsꍇɂ́A{֐ŃT[o[
 * 荞݂h~Å֐sĂB
 * \par :
 * \code
 * 	F
 * // T[o[̊荞݂h~
 * criAtom_Lock();
 *
 * // ̉𓯎ɍĐJn
 * criAtomPlayer_Start(player1);
 * criAtomPlayer_Start(player2);
 * criAtomPlayer_Start(player3);
 * criAtomPlayer_Start(player4);
 *
 * // T[o[̊荞ݖh~
 * criAtom_Unlock();
 * 	F
 * \endcode
 * \attention
 * L̗̂悤ɁÃv[[œɍĐX^[gꍇłA
 * Xg[Đ͓ɔJnƂ͌܂B<br>
 * iobt@OɔĐx邽߁Bj<br>
 * <br>
 * {֐sA::criAtom_Unlock ֐Ă΂ȂꍇAĐr؂鋰ꂪ܂B<br>
 * T[o[̊荞݂h~Ԃ́Aŏɗ}Kv܂B
 * \sa criAtom_Unlock
 */
void CRIAPI criAtom_Lock(void);

/*JP
 * \brief T[o[̊荞ݖh~
 * \ingroup ATOMLIB_GLOBAL
 * \par :
 * ::criAtom_Lock ֐ɂAT[o[̊荞ݖh~܂B
 * \sa criAtom_Lock
 */
void CRIAPI criAtom_Unlock(void);

/*JP
 * \brief `lRtBÕftHglύX
 * \ingroup ATOMLIB_GLOBAL
 * \param[in]   num_channels        `l
 * \param[in]   channel_config      `lRtBO
 * \par :
 * f[^̊e`lƏo̓Xs[J[̑ΉtύX܂B<br>
 * AtomCúAftHgԂł͉f[^ȉ̃`l\łƑz肵ē삵܂B<br>
 * |`l	| z肳`l\				|
 * |---				|---									|
 * |1				| CRIATOM_CHANNEL_CONFIG_MONO			|
 * |2				| CRIATOM_CHANNEL_CONFIG_STEREO			|
 * |3				| CRIATOM_CHANNEL_CONFIG_3_LRC			|
 * |4				| CRIATOM_CHANNEL_CONFIG_QUAD			|
 * |5				| CRIATOM_CHANNEL_CONFIG_5				|
 * |6				| CRIATOM_CHANNEL_CONFIG_5_1			|
 * |7				| CRIATOM_CHANNEL_CONFIG_6_1			|
 * |8				| CRIATOM_CHANNEL_CONFIG_7_1			|
 * |9				| CRIATOM_CHANNEL_CONFIG_AMBISONICS_2P	|
 * |10				| CRIATOM_CHANNEL_CONFIG_7_1_2			|
 * |12				| CRIATOM_CHANNEL_CONFIG_7_1_4			|
 * |16				| CRIATOM_CHANNEL_CONFIG_7_1_4_4		|
 * |25				| CRIATOM_CHANNEL_CONFIG_AMBISONICS_4P	|
 * |36				| CRIATOM_CHANNEL_CONFIG_AMBISONICS_5P	|
 * |49				| CRIATOM_CHANNEL_CONFIG_AMBISONICS_6P	|
 * |64				| CRIATOM_CHANNEL_CONFIG_AMBISONICS_7P	|
 * Đ鉹f[^̃`l\LƈقȂꍇɂ́A{֐gpă`l\ύXKv܂B<br>
 * Ⴆ΁A8ch̉5.1.2chƂĈ悤wꍇAȉ̂悤ȃR[hŃ`l\ύXKv܂B
 * \code
 * 	// 8ch̉5.1.2chƂĈ悤w
 * 	criAtom_ChangeDefaultChannelConfig(8, CRIATOM_CHANNEL_CONFIG_5_1_2);
 * \endcode
 * \par l:
 * {֐ł͌16chȉ̃`l\݂̂ύX\łB
 * \attention
 * \ύX̉éAinum_channelsjŎw肵`l̉f[^ɂ̂݉e܂B<br>
 * ̂߁AقȂ`l̉f[^݂ꍇAe`lɑ΂Ăꂼ`l\̕ύXsKv܂B<br>
 * Ⴆ΁A4ch8ch̗ɂă`l\ύXꍇAnum_channels4̃P[X8̃P[X2p^[̃`l\w肷Kv܂B
 * \code
 * 	// 4ch̃`l\ύX
 * 	criAtom_ChangeDefaultChannelConfig(4, CRIATOM_CHANNEL_CONFIG_AMBISONICS_1P);
 * 	
 * 	// 8ch̃`l\ύX
 * 	criAtom_ChangeDefaultChannelConfig(8, CRIATOM_CHANNEL_CONFIG_5_1_2);
 * \endcode
 * Đ̉ftHglQƂ^C~O̓[U[̑Ɉˑ܂B<br>
 * ̂߁AĐɃftHglύXꍇAӐ}^C~OŕύXfƂ͌܂B<br>
 * {֐gpꍇAȂǉĐOɎsĂB<br>
 * \attention
 * 16ch𒴂`lɑ΂Ă͌`lRtBOύX邱Ƃł܂B
 */
void CRIAPI criAtom_ChangeDefaultChannelConfig(
    CriSint32 num_channels, CriAtomChannelConfig channel_config);

/*JP
 * \brief `l̃ftHglύX
 * \ingroup ATOMLIB_GLOBAL
 * \param[in]   num_channels        `l
 * \param[in]   channel_order       `l
 * \par :
 * w肵`l̉f[^ɂāA`l̓ǂݍݏύX܂B<br>
 * AtomCúAftHgԂł͉f[^ȉ̃`lŃC^[[uĂƑz肵ē삵܂B<br>
 * |`lԍ	| z肳`l		|
 * |---				|---						|
 * |0				| tg					|
 * |1				| Cg					|
 * |2				| Z^[					|
 * |3				| LFE						|
 * |4				| TEhtg			|
 * |5				| TEhCg			|
 * |6				| TEhobNtg	|
 * |7				| TEhobNCg	|
 * |8				| gbvtgtg		|
 * |9				| gbvtgCg		|
 * |10				| gbvobNtg		|
 * |11				| gbvobNCg		|
 * Đ鉹f[^̕яLƈقȂꍇɂ́A{֐gpă`l̓ǂݍݏύXKv܂B<br>
 * Ⴆ΁Ã͉TEhobNTEhOɂ7.1ch̉f[^
 * i4A5`lڂ6A7`lڂƂւf[^jgpꍇA
 * ȉ̂悤ȃR[hŃ`lяw肷Kv܂B
 * \code
 * 	// 8chɂāATEhƃTEhobN
 * 	// CȗzƋtɃC^[[uĂ邱Ƃ𖾎
 * 	CriSint32 channel_order[] = { 0, 1, 2, 3, 6, 7, 4, 5 };
 * 	criAtom_ChangeDefaultChannelOrder(8, channel_order);
 * \endcode
 * \par ⑫:
 * m̓Z^[`lƉ߂܂B<br>
 * AftHgԂł̓tgXs[J[ƃCgXs[J[gpAt@gZ^[ŏo͂܂B<br>
 * imZ^[Xs[J[o͂ɂ́ApXs[J[^CvύXKv܂Bj<br>
 * <br>
 * 5.1.2ch̉f[^́AftHgňȉ̃`lƉ߂܂B<br>
 * |`lԍ	| z肳`l		|
 * |---				|---						|
 * |0				| tg					|
 * |1				| Cg					|
 * |2				| Z^[					|
 * |3				| LFE						|
 * |4				| TEhtg			|
 * |5				| TEhCg			|
 * |6				| gbvtg				|
 * |7				| gbvgCg			|
 * \attention
 * ύX̉éAinum_channelsjŎw肵`l̉f[^ɂ̂݉e܂B<br>
 * ̂߁AقȂ`l̉f[^݂ꍇAe`lɑ΂Ăꂼ`l̕ύXsKv܂B<br>
 * Ⴆ΁A7.1ch7.1.4ch̗ɂă`lύXꍇAnum_channels8̃P[X12̃P[X2p^[̃`lw肷Kv܂B
 * \code
 * 	// 8ch̃`lύX
 * 	CriSint32 channel_order_for_8ch[8] = { c };
 * 	criAtom_ChangeDefaultChannelOrder(8, channel_order_for_8ch);
 * 	
 * 	// 12ch̃`lύX
 * 	CriSint32 channel_order_for_12ch[12] = { c };
 * 	criAtom_ChangeDefaultChannelOrder(12, channel_order_for_12ch);
 * \endcode
 * Đ̉ftHglQƂ^C~O̓[U[̑Ɉˑ܂B<br>
 * ̂߁AĐɃftHglύXꍇAӐ}^C~OŕύXfƂ͌܂B<br>
 * {֐gpꍇAȂǉĐOɎsĂB<br>
 */
void CRIAPI criAtom_ChangeDefaultChannelOrder(
    CriSint32 num_channels, const CriSint32 *channel_order);


/*JP
 * \deprecated
 * 폜\̔񐄏APIłB
 * ::criAtom_ChangeDefaultChannelConfig ֐̎gpĂB
 */
void CRIAPI criAtom_SetChannelMapping(CriSint32 nch, CriUint32 type);

/*JP
 * \brief Ambisonics̃tH[}bgw
 * \ingroup ATOMLIB_GLOBAL
 * \param[in]	format				tH[}bg
 * \par :
 * Ambisonicsf[^̃`lяƐKw肵܂B<br>
 * ftHg̃tH[}bg CRIATOM_AMBISONICS_ACN_SN3D łB
 */
void CRIAPI criAtom_SetAmbisonicsInputFormat(CriAtomAmbisonicsFormat format);

/*JP
 * \brief ptH[}Xj^[@\̒ǉ
 * \ingroup ATOMLIB_GLOBAL
 * \par :
 * ptH[}Xv@\ǉAptH[}XvJn܂B<br>
 * {֐sA ::criAtom_GetPerformanceInfo ֐s邱ƂŁA
 * T[o[ׂ̕AT[o[̎sԊuACũptH[}X
 * 擾邱Ƃ\łB
 * \sa criAtom_GetPerformanceInfo, criAtom_DetachPerformanceMonitor
 * \par :
 * \code
 * 	// ptH[}X擾p\
 * 	CriAtomPerformanceInfo info;
 *
 * 	// Cȕ
 * 	criAtom_Initialize(c);
 *
 * 	// ptH[}Xj^[@\̒ǉ
 * 	criAtom_AttachPerformanceMonitor();
 *
 * 	// ptH[}Xj^[̃Zbg
 * 	criAtom_ResetPerformanceMonitor();
 *
 * 	// ptH[}Xv
 * 	c
 *
 * 	// ptH[}X̎擾
 * 	criAtom_GetPerformanceInfo(&info);
 *
 * 	// vʂ̕\
 * 	printf(
 * 		"Max CPU Load            : %d (us)\n"	\
 * 		"Average CPU Load        : %d (us)\n"	\
 * 		"Max Server Interval     : %d (us)\n"	\
 * 		"Average Server Interval : %d (us)\n",
 * 		info.max_server_time, info.average_server_time,
 * 		info.max_server_interval, info.average_server_interval
 * 	);
 * \endcode
 */
void CRIAPI criAtom_AttachPerformanceMonitor(void);

/*JP
 * \brief ptH[}Xj^[@\̍폜
 * \ingroup ATOMLIB_GLOBAL
 * \par :
 * ptH[}XvIAptH[}Xv@\폜܂B
 * \attention
 * {֐͊A^̊֐łB<br>
 * {֐sƁA΂炭̊AtomCũT[o[ubN܂B<br>
 * Đɖ{֐sƁAr؂ꓙ̕s\邽߁A
 * {֐̌Ăяo̓V[̐؂ւ蓙Aוϓeł^C~OōsĂB
 */
void CRIAPI criAtom_DetachPerformanceMonitor(void);

/*JP
 * \brief ptH[}Xj^[̃Zbg
 * \ingroup ATOMLIB_GLOBAL
 * \par :
 * ݂܂ł̌vʂj܂B<br>
 * ptH[}Xj^[́A ::criAtom_AttachPerformanceMonitor ֐s
 * ptH[}X̎擾JnAvʂݐς܂B<br>
 * ꂩvԂɑ΂AȑǑvʂȍ~̌vʂɊ܂߂Ȃꍇɂ́A
 * {֐sAݐςꂽvʂUjKv܂B
 */
void CRIAPI criAtom_ResetPerformanceMonitor(void);

/*JP
 * \brief ptH[}X̎擾
 * \ingroup ATOMLIB_GLOBAL
 * \param[out]	info	ptH[}X
 * \par :
 * ptH[}X擾܂B<br>
 * {֐́A ::criAtom_AttachPerformanceMonitor ֐sォ
 * ::criAtom_DetachPerformanceMonitor ֐s܂ł̊ԁAp\łB<br>
 * \sa criAtom_AttachPerformanceMonitor, criAtom_DetachPerformanceMonitor
 */
void CRIAPI criAtom_GetPerformanceInfo(CriAtomPerformanceInfo *info);

/*JP
 * \brief ADXf[^̃rbg[gvZ
 * \ingroup ATOMLIB_GLOBAL
 * \param[in]	num_channels	f[^̃`l
 * \param[in]	sampling_rate	f[^̃TvO[g
 * \return		CriSint32		rbg[g[bps]
 * \par :
 * ADXf[^̃rbg[gvZ܂B<br>
 * vZɎsƖ{֐-1Ԃ܂B<br>
 * vZɎsRɂẮAG[R[obÑbZ[WŊmF\łB<br>
 */
CriSint32 CRIAPI criAtom_CalculateAdxBitrate(
	CriSint32 num_channels, CriSint32 sampling_rate);

/*JP
 * \brief HCAf[^̃rbg[gvZ
 * \ingroup ATOMLIB_GLOBAL
 * \param[in]	num_channels	f[^̃`l
 * \param[in]	sampling_rate	f[^̃TvO[g
 * \param[in]	quality			f[^̃GR[hi
 * \return		CriSint32		rbg[g[bps]
 * \par :
 * HCAf[^̃rbg[gvZ܂B<br>
 * vZɎsƖ{֐-1Ԃ܂B<br>
 * vZɎsRɂẮAG[R[obÑbZ[WŊmF\łB<br>
 * \par l:
 * qualityɂCRI Atom Craft܂CRI Atom EncoderŐݒ肵GR[hiw肵܂B
 */
CriSint32 CRIAPI criAtom_CalculateHcaBitrate(
	CriSint32 num_channels, CriSint32 sampling_rate, CriAtomEncodeQuality quality);

/*JP
 * \brief HCA-MXf[^̃rbg[gvZ
 * \ingroup ATOMLIB_GLOBAL
 * \param[in]	num_channels	f[^̃`l
 * \param[in]	sampling_rate	f[^̃TvO[g
 * \param[in]	quality			f[^̃GR[hi
 * \return		CriSint32		rbg[g[bps]
 * \par :
 * HCA-MXf[^̃rbg[gvZ܂B<br>
 * vZɎsƖ{֐-1Ԃ܂B<br>
 * vZɎsRɂẮAG[R[obÑbZ[WŊmF\łB<br>
 * \par l:
 * qualityɂCRI Atom Craft܂CRI Atom EncoderŐݒ肵GR[hiw肵܂B
 */
CriSint32 CRIAPI criAtom_CalculateHcaMxBitrate(
	CriSint32 num_channels, CriSint32 sampling_rate, CriAtomEncodeQuality quality);

/*JP
 * \brief Xg[~O̎擾
 * \ingroup ATOMLIB_GLOBAL
 * \param[out]	streaming_info	Xg[~Oۑ̃|C^
 * \retval		CRI_TRUE	l擾ł
 * \retval		CRI_FALSE	l擾łȂ
 * \par :
 * CRI AtomCũXg[~OǗW[Xg[~O擾܂B<br>
 * {֐́AĂяoꂽ_̃Xg[~O streaming_info ɕۑ܂B<br>
 * \attention
 * AtomT[o[̏ƈꕔr䂵Ă邽߁A
 * Dxt]ɂAtomT[o[~߂Ă܂Ȃ悤ɒӂĂB<br>
 * ꕔ̃vbgtH[ł́AXg[~O擾ł܂B<br>
 * {֐̖߂lmFĂB<br>
 * G[ŃXg[~O擾łȂꍇɂẮA<br>
 * G[R[obNĂȂmFĂB
 * \sa CriAtomStreamingInfo
 */
CriBool CRIAPI criAtom_GetStreamingInfo(CriAtomStreamingInfo* streaming_info);

/*JP
 * \brief t@CI/Ő󂫎ԂgXg[~Oǂݍ݂sǂ
 * \ingroup ATOMLIB_GLOBAL
 * \param[in]	flag	CRI_TRUE=t@CI/Ő󂫎Ԃgēǂݍ
 * \retval		CRI_TRUE	ɏ
 * \retval		CRI_FALSE	G[
 * \par :
 * CRI AtomCũXg[~OǗW[ɑ΂āA<br>
 * t@CI/Ő󂫎ԂgăXg[~Oǂݍ݂sǂݒ肵܂B<br>
 * CRI_TRUEݒ肷ƁACRI AtomCũXg[~OǗW[
 * t@CI/Ő󂫎ԂgāA󂫃obt@[ɑ΂ăf[^]ɓǂݍ݂܂B<br>
 * CRI_FALSEݒ肷ƁACRI AtomCũXg[~OǗW[
 * t@CI/Ő󂫎ԂgȂȂA]ȃXg[~Oǂݍ݂sȂȂ܂B<br>
 * ftHgłCRI_TRUEݒ肵ԂłB<br>
 * \par lF
 * t@CI/Ő󂫎ԂgA󂫃obt@[ɑ΂ăf[^]ɓǂݍłƂŁA
 * V[N̔px炷łAIȃt@CI/Ǒサ܂B<br>
 * Aʏt@C̃[h́AXg[~O̓ǂݍ݂DxႢ߁A
 * 󂫃obt@[傫ƒʏt@C̃[h啝ɒxĂ܂܂B<br>
 * \attention
 * AtomT[o[̏ƈꕔr䂵Ă邽߁A
 * Dxt]ɂAtomT[o[~߂Ă܂Ȃ悤ɒӂĂB
 */
CriBool CRIAPI criAtom_SetFreeTimeBufferingFlagForDefaultDevice(CriBool flag);


/*==========================================================================
 *      CRI Atom HCA-MX API
 *=========================================================================*/
/*JP
 * \brief HCA-MXp[N̈TCY̌vZ
 * \ingroup ATOMLIB_HCA_MX
 * \param[in]	config		HCA-MXpRtBO\
 * \return		CriSint32	[N̈TCY
 * \retval		0ȏ		ɏ
 * \retval		-1			G[
 * \par :
 * HCA-MX̏ɕKvȃ[N̈̃TCY擾܂B<br>
 * ::criAtom_SetUserAllocator }NɂAP[^[o^s킸
 * ::criAtomHcaMx_Initialize ֐HCA-MX̏sꍇA
 * {֐ŌvZTCỸ[N̈ƂēnKv܂B<br>
 * <br>
 * [N̈TCY̌vZɎsƁA{֐ -1 Ԃ܂B<br>
 * [N̈TCY̌vZɎsRɂẮAG[R[obÑbZ[WŊmF\łB<br>
 * \par l:
 * HCA-MX̏ɕKvȃ[ÑTCÝAHCA-MXpRtBO
 * \́i ::CriAtomHcaMxConfig j̓eɂĕω܂B<br>
 * <br>
 * NULLw肵ꍇAftHgݒ
 * i ::criAtomHcaMx_SetDefaultConfig KpƓp[^[j
 * [N̈TCYvZ܂B
 * <br>
 *  config ̏́A֐ł̂ݎQƂ܂B<br>
 * ֐𔲂͎QƂ܂̂ŁA֐s config ̗̈Ă
 * 肠܂B
 * \sa criAtom_SetUserAllocator, criAtomHcaMx_Initialize
 */
CriSint32 CRIAPI criAtomHcaMx_CalculateWorkSize(const CriAtomHcaMxConfig *config);

/*JP
 * \brief [N̈TCYvZpRtBO\̂̐ݒ
 * \ingroup ATOMLIB_HCA_MX
 * \param[in]	config		HCA-MXpRtBO\
 * \par :
 * [N̈TCY̌vZpɁAHCA-MXpRtBO\
 * i ::CriAtomHcaMxConfig \́jo^܂B<br>
 * <br>
 * HCA-MXv[[̍쐬ɕKvȃ[N̈̃TCÝA
 * HCA-MXi ::criAtomHcaMx_Initialize ֐sj
 * ɐݒ肷\̂̃p[^[ɂĕω܂B<br>
 * ̂߁Aʏ̓v[[̍쐬ɕKvȃ[N̈TCYvZOɁA
 * HCA-MXKv܂B<br>
 * {֐gpHCA-MXpRtBO\̂o^ꍇA
 * ::criAtomPlayer_CalculateWorkSizeForHcaMxPlayer
 * ֐ȂɎgp\ƂȂ܂B<br>
 * \par l:
 * i config j NULL w肵ꍇAftHgݒ
 * i ::criAtomPlayer_SetDefaultConfigForHcaMxPlayer
 * KpƓp[^[jŃ[N̈TCYvZ܂B<br>
 * <br>
 * A{֐ňURtBO\̂ݒ肷ƁA
 * ݒȌԁiԂł̃[N̈TCYvZG[Ƃ铮j
 * ɖ߂ƂłȂȂ܂B<br>
 * i֐ēxsăp[^[㏑邱Ƃ͉\łBj<br>
 * \attention
 * {֐œo^pRtBO\̂́A
 * HCA-MXԂł̃[N̈TCYvZɂgp܂B<br>
 * HCA-MXɂ͖{֐ɐݒ肵p[^[ł͂ȂA
 * Ɏw肳ꂽp[^[[N̈TCY̌vZɎgp܂B<br>
 * i{֐œo^\̂̃p[^[ƁA
 * HCA-MXɎgp\̂̃p[^[قȂꍇA
 * [N̈TCYsAnh̍쐬Ɏs鋰ꂪ܂Bj<br>
 * \par :
 * \code
 * 	CriAtomHcaMxConfig hca_mx_config;
 *
 * 	// [N̈vZpHCA-MXݒo^
 * 	criAtomHcaMx_SetDefaultConfig(&hca_mx_config);
 * 	criAtomHcaMx_SetConfigForWorkSizeCalculation(&hca_mx_config);
 *
 * 	// HCA-MXv[[쐬p[N̈TCY̌vZ
 * 	hca_mx_vp_work_size = criAtomPlayer_CalculateWorkSizeForHcaMxPlayer(NULL);
 * 		F
 * \endcode
 * \sa criAtomPlayer_CalculateWorkSizeForHcaMxPlayer, criAtomPlayer_SetDefaultConfigForHcaMxPlayer
 */
void CRIAPI criAtomHcaMx_SetConfigForWorkSizeCalculation(const CriAtomHcaMxConfig *config);

/*JP
 * \brief HCA-MX̏
 * \ingroup ATOMLIB_HCA_MX
 * \param[in]	config	HCA-MXpRtBO\
 * \param[in]	work		[N̈
 * \param[in]	work_size	[N̈TCY
 * \par :
 * HCA-MX̏s܂B<br>
 * {֐s邱ƂŁAHCA-MXf[^̏o͋@\N܂B<br>
 * \par l:
 * HCA-MX̏ɕKvȃ[ÑTCÝAHCA-MXpRtBO
 * \́i ::CriAtomHcaMxConfig j̓eɂĕω܂B<br>
 * <br>
 * NULLw肵ꍇAftHgݒ
 * i ::criAtomHcaMx_SetDefaultConfig KpƓp[^[jŏs܂B<br>
 * <br>
 *  config ̏́A֐ł̂ݎQƂ܂B<br>
 * ֐𔲂͎QƂ܂̂ŁA֐s config ̗̈Ă
 * 肠܂B
 * \attention
 * {֐sOɁACuĂKv܂B<br>
 * <br>
 * {֐͊A^̊֐łB<br>
 * {֐sƁA΂炭̊AtomCũT[o[ubN܂B<br>
 * Đɖ{֐sƁAr؂ꓙ̕s\邽߁A
 * {֐̌Ăяo̓V[̐؂ւ蓙Aוϓeł^C~OōsĂB
 * <br>
 * {֐sAK΂ɂȂ ::criAtomHcaMx_Finalize ֐sĂB<br>
 * ܂A ::criAtomHcaMx_Finalize ֐s܂ł́A{֐ēxsȂłB<br>
 * \sa criAtom_SetUserAllocator, criAtomHcaMx_CalculateWorkSize
 */
void CRIAPI criAtomHcaMx_Initialize(
	const CriAtomHcaMxConfig *config, void *work, CriSint32 work_size);

/*JP
 * \brief HCA-MX̏I
 * \ingroup ATOMLIB_HCA_MX
 * \par :
 * HCA-MX̏Is܂B<br>
 * {֐s邱ƂŁAHCA-MXf[^̏o͂~܂B<br>
 * ::criAtom_SetUserAllocator }NgpăAP[^[o^ς݂̏ꍇA
 * HCA-MXɊmۂꂽ̈悪܂B<br>
 * iHCA-MXɃ[N̈nꍇA{֐sł
 * [N̈\łBj<br>
 * \attention
 * {֐͊A^̊֐łB<br>
 * {֐sƁA΂炭̊AtomCũT[o[ubN܂B<br>
 * Đɖ{֐sƁAr؂ꓙ̕s\邽߁A
 * {֐̌Ăяo̓V[̐؂ւ蓙Aוϓeł^C~OōsĂB
 * \sa criAtom_SetUserAllocator, criAtomHcaMx_Initialize
 */
void CRIAPI criAtomHcaMx_Finalize(void);

/*JP
 * \brief ~LT[̃oXZhxݒ
 * \ingroup ATOMLIB_HCA_MX
 * \param[in]	mixer_id	~LT[ID
 * \param[in]	bus_name	oX
 * \param[in]	level		Zhxli0.0f`1.0fj
 * \par :
 * ~LT[̃oXZhxݒ肵܂B<br>
 * ftHgԂł́AHCA-MX̃fR[hʂ̓~LT[Ɋi[ꂽA
 * oX01.0f̃xőM܂B<br>
 * {֐gp邱ƂŁAfR[hʂ𑼂̃oXւZh邱Ƃ\ɂȂ܂B<br>
 * i~LT[ƂɈقȂoXGtFNgKp\ɂȂ܂Bj<br>
 */
void CRIAPI criAtomHcaMx_SetBusSendLevelByName(
	CriSint32 mixer_id, const CriChar8* bus_name, CriFloat32 level);

/*JP
 * \brief ~LT[̏o͎g̐ݒ
 * \ingroup ATOMLIB_HCA_MX
 * \param[in]	mixer_id	~LT[ID
 * \param[in]	ratio		Zhxli0.25f`4.0fj
 * \par :
 * ~LT[̏o͎gݒ肵܂B<br>
 * ǵAf[^̎gƍĐg̔䗦ŁAĐx̔{ƓłB<br>
 * g䂪1.0f𒴂ꍇAf[^͌荂ɍĐA
 * 1.0f̏ꍇ́Af[^͌ᑬōĐ܂B<br>
 * {֐gp邱ƂŁAΏۂ̃~LT[gpSẴv[[̍Đx
 * ύX邱Ƃł܂iX̃v[[̍Đx͕ύXł܂jB<br>
 */
void CRIAPI criAtomHcaMx_SetFrequencyRatio(CriSint32 mixer_id, CriFloat32 ratio);

/*==========================================================================
 *      CRI Atom AWB API
 *=========================================================================*/
/*JP
 * \brief AWBt@CTOC񃍁[hp[N̈TCY̌vZ
 * \ingroup ATOMLIB_AWB
 * \param[in]	num			AWBt@CɊ܂܂Rec
 * \return		CriSint32	[N̈TCY
 * \retval		0ȏ		ɏ
 * \retval		-1			G[
 * \par :
 * AWBt@CTOC[h邽߂ɏ\ȃ[N̈̃TCY擾܂B<br>
 * <br>
 * [N̈TCY̌vZɎsƁA{֐ -1 Ԃ܂B<br>
 * [N̈TCY̌vZɎsRɂẮAG[R[obÑbZ[WŊmF\łB<br>
 * \attention
 * {֐sOɁACuĂKv܂B<br>
 * \sa criAtomAwb_LoadToc, criAtomAwb_LoadTocAsync
 */
CriSint32 CRIAPI criAtomAwb_CalculateWorkSizeForLoadToc(CriSint32 num);

/*JP
 * \brief AWBt@CTOC񃍁[hiŁj
 * \ingroup ATOMLIB_AWB
 * \param[in]	binder		oC_[nh
 * \param[in]	path		AWBt@C
 * \param[in]	work		AWBt@CTOC񃍁[hp[N̈
 * \param[in]	work_size	[N̈TCY
 * \return		CriAtomAwbHn AWBnh
 * \par :
 * Đ̉ƂĎgpAWBt@CTOC[h܂B<br>
 * [h܂Ŗ{֐͕A܂̂ŁAV[̐؂ւA
 * וϓeł^C~OŎsĂB<br>
 * [hɐƁA߂lɗLAWBnhԂ܂̂ŁA
 * ::criAtomPlayer_SetWaveId ֐Ɏw肵ĎgpĂB<br>
 * gIAWBnh́A::criAtomAwb_Release ֐ŉĂB<br>
 * TOC̃[hɎsꍇNULLԂ܂B<br>
 * \par l:
 * ONULLAl0w肵ĎsƁA
 * Kvȃ[N̈֐œIɊmۂ܂B
 * IɊmۂ̈́A::criAtomAwb_Release ֐ŉ܂B
 * \sa criAtomPlayer_SetWaveId, criAtomAwb_Release, criAtomAwb_LoadTocById
 */
CriAtomAwbHn CRIAPI criAtomAwb_LoadToc(
	CriFsBinderHn binder, const CriChar8 *path, void *work, CriSint32 work_size);

/*JP
 * \brief IDwɂAWBt@CTOC񃍁[hiŁj
 * \ingroup ATOMLIB_AWB
 * \param[in]	binder		oC_[nh
 * \param[in]	id			AWBt@Ci[ĂCPKRecID
 * \param[in]	work		AWBt@CTOC񃍁[hp[N̈
 * \param[in]	work_size	[N̈TCY
 * \return		CriAtomAwbHn AWBnh
 * \par :
 * ::criAtomAwb_LoadToc ֐Ƃقړl̋@\֐łB
 * ::criAtomAwb_LoadToc ֐ƈقȂ_́A
 * pXwł͂ȂCPK̃RecIDwAWBt@CTOC[h_łB<br>
 * \sa criAtomPlayer_SetWaveId, criAtomAwb_Release, criAtomAwb_LoadToc
 */
CriAtomAwbHn CRIAPI criAtomAwb_LoadTocById(
	CriFsBinderHn binder, CriUint16 id, void *work, CriSint32 work_size);

/*JP
 * \brief AWBt@CTOC񃍁[hi񓯊Łj
 * \ingroup ATOMLIB_AWB
 * \param[in]	binder		oC_[nh
 * \param[in]	path		AWBt@C
 * \param[in]	work		AWBt@CTOC񃍁[hp[N̈
 * \param[in]	work_size	[N̈TCY
 * \return		CriAtomAwbHn AWBnh
 * \par :
 * Đ̉ƂĎgpAWBt@CTOC[h܂B<br>
 * {֐̓[hv𔭍s񓯊֐Ȃ̂ŁA
 * [h̊AvP[Vő҂Kv܂B<br>
 * ::criAtomAwb_GetStatus ֐AWBnh̃Xe[^XIɎ擾A
 * [h̊mFĂB<br>
 * [h̊҂ĂԂAWBnh̃Xe[^XXV̂߂ɁA
 * I::criAtom_ExecuteMain ֐sKv܂B<br>
 * [hv̔sɐƖ߂lɗLAWBnhԂ܂B<br>
 * [h́A::criAtomPlayer_SetWaveId ֐Ɏw肵ĎgpĂB<br>
 * gIAWBnh́A::criAtomAwb_Release ֐ŉĂB<br>
 * TOC̃[hv̔sɎsꍇNULLԂ܂B<br>
 * \par l:
 * ONULLAl0w肵ĎsƁA
 * Kvȃ[N̈֐œIɊmۂ܂B
 * IɊmۂ̈́A::criAtomAwb_Release ֐ŉ܂B<br>
 * {֐Ŏ擾AWBnh̃Xe[^XG[ԁi::CRIATOMAWB_STATUS_ERRORjɂȂꍇA
 * ::criAtomAwb_Release ֐ŉĂB
 * \sa criAtomPlayer_SetWaveId, criAtomAwb_Release, criAtomAwb_GetStatus, criAtomAwb_LoadTocAsyncById
 */
CriAtomAwbHn CRIAPI criAtomAwb_LoadTocAsync(
	CriFsBinderHn binder, const CriChar8 *path, void *work, CriSint32 work_size);

/*JP
 * \brief IDwɂAWBt@CTOC񃍁[hi񓯊Łj
 * \ingroup ATOMLIB_AWB
 * \param[in]	binder		oC_[nh
 * \param[in]	id			AWBt@Ci[ĂCPKRecID
 * \param[in]	work		AWBt@CTOC񃍁[hp[N̈
 * \param[in]	work_size	[N̈TCY
 * \return		CriAtomAwbHn AWBnh
 * \par :
 * ::criAtomAwb_LoadTocAsync ֐Ƃقړl̋@\֐łB
 * ::criAtomAwb_LoadTocAsync ֐ƈقȂ_́A
 * pXwł͂ȂCPK̃RecIDwAWBt@CTOC[h_łB<br>
 * \sa criAtomPlayer_SetWaveId, criAtomAwb_Release, criAtomAwb_GetStatus, criAtomAwb_LoadTocAsync
 */
CriAtomAwbHn CRIAPI criAtomAwb_LoadTocAsyncById(
	CriFsBinderHn binder, CriUint16 id, void *work, CriSint32 work_size);

/*JP
 * \brief IAWBnh̍쐬
 * \ingroup ATOMLIB_AWB
 * \param[in]	awb_mem			AWBt@Cǂݍ񂾃̈ւ̃|C^
 * \param[in]	awb_mem_size	AWBt@CTCY
 * \param[in]	work			IAWBp[N̈ւ̃|C^
 * \param[in]	work_size		IAWBp[N̈TCY
 * \return		CriAtomAwbHn IAWBnh
 * \par :
 * ɓǂݍ܂ꂽAWBt@CC[WAIAWBnh쐬܂B<br>
 * IAWBt@CC[W畡̃IAWBnh쐬邱Ƃł܂B<br>
 * [N̈mۂ@ɂ́Aȉ2ʂ̕@܂B<br>
 * <b>(a) User Allocator</b>F̊mہ^ɁA[Upӂ֐gp@B<br>
 * <b>(b) Fixed Memory</b>FKvȃ̈𒼐ڃCuɓn@B<br>
 * <br>
 * User AllocatorpꍇA[U[N̈pӂKv͂܂B<br>
 * workNULLAwork_size0w肷邾ŁAKvȃo^ς݂̃mۊ֐mۂ܂B<br>
 * IAWBnh쐬ɓIɊmۂꂽ́A<br>
 * IAWBji ::criAtomAwb_Release ֐sjɉ܂B<br>
 * Fixed Memorpꍇ́A::CRIATOMAWB_WORKSIZE_FOR_LOADFROMMEMORY ֐g
 * Kvȃ[N̈TCY߂ĂB<br>
 * [N̈Ƃ͈قȂAawb_mem ͕K[U̐ӔCŊǗKv_ɂ͒ӂĂB<br>
 * <br>
 * \attention
 * {֐ƁA awb_memœnꂽ̈IAWBf[^pɏ܂B<br>
 * ̂߁AXbh::CRIATOMAWB_WORKSIZE_FOR_LOADFROMMEMORY ֐ĂяoĂꍇ́A<br>
 * rɂXbh̎sւꍇ܂B<br>
 * ȂAawb_mem Ŏẅ ::criAtomAwb_Release ֐sɎ蓮ŉĂB
 * \sa CRIATOMAWB_WORKSIZE_FOR_LOADFROMMEMORY,criAtomAwb_Release
 */
CriAtomAwbHn CRIAPI criAtomAwb_LoadFromMemory(
	void *awb_mem, CriSint32 awb_mem_size, void *work, CriSint32 work_size);

/*JP
 * \brief AWBnh̎ʂl擾
 * \ingroup ATOMLIB_AWB
 * \param[in]	awb				擾AWBnh
 * \return		CriAtomAwbType 	AWBnh̎ʂl
 * \par :
 * AWBnhTOĈ݂ł邩AIAWBnhȂ̂l擾܂B
 * {֐sꍇ::CRIATOMAWB_TYPE_ERRORԂ܂B<br>
 * \sa criAtomAwb_GetWaveDataInfo, criAtomPlayer_SetData,
 */
CriAtomAwbType CRIAPI criAtomAwb_GetType(CriAtomAwbHn awb);

/*JP
 * \brief AWBTOC񂩂g`f[^̃t@C擾
 * \ingroup ATOMLIB_AWB
 * \param[in]	awb			擾AWBnh
 * \param[in]	id			g`f[^ID
 * \param[out]	offset		g`f[^̃ItZbgiBytej
 * \param[out]	size		g`f[^̃TCYiBytej
 * \return		Ȃ
 * \par :
 * AWBnhidŎw肵g`f[^̃t@CItZbgƃTCY擾܂B<br>
 * 擾ItZbgƃTCÝAAWBt@Cg`f[^𒼐ړǂݍޏꍇɎgp܂B<br>
 * \attention
 * {֐sOɁAAWBnh̎ʂ::criAtomAwb_GetType ֐ŊmFĂB<br>
 * AWBnh̎ʂ::CRIATOMAWB_TYPE_TOCƈقȂꍇA܂͕sAWBnhꍇA{֐͎sAG[R[obN܂B<br>
 * {֐sꍇAo͒lłoffsetsize̒l͕słB<br>
 * \sa criAtomAwb_GetType, criAtomAwb_GetWaveDataInfo, criAtomPlayer_SetData,criAtomAwb_GetType
 */
CriBool CRIAPI criAtomAwb_GetWaveFileInfo(
	CriAtomAwbHn awb, CriSint32 id, CriSint64 *offset, CriUint32 *size);

/*JP
 * \brief IAWBg`f[^̏擾
 * \ingroup ATOMLIB_AWB
 * \param[in]	awb				擾AWBnh
 * \param[in]	id				g`f[^ID
 * \param[out]	wave_data_start	g`f[^̐擪|C^iBytej
 * \param[out]	size			g`f[^̃TCYiBytej
 * \return		Ȃ
 * \par :
 * IAWBidŎw肵g`f[^̐擪|C^ƃTCY擾܂B<br>
 * IAWBg`f[^ĐꍇAʏ::criAtomPlayer_SetWaveId ֐ŏ\Ȃ̂ŁAQƂĂB<br>
 * \attention
 * {֐sOɁAAWBnh̎ʂ::criAtomAwb_GetType ֐ŊmFĂB<br>
 * AWBnh̎ʂقȂꍇA܂͕sAWBnhꍇA{֐͎sAG[R[obN܂B<br>
 * {֐sꍇAo͒lłwave_data_startsize̒l͕słB<br>
 *
 * \sa criAtomAwb_GetType, criAtomAwb_GetWaveFileInfo, criAtomPlayer_SetData,criAtomPlayer_SetWaveId
 *
 */
void CRIAPI criAtomAwb_GetWaveDataInfo(CriAtomAwbHn awb, CriSint32 id, void **wave_data_start, CriUint32 *size);

/*JP
 * \brief AWBnhAWBt@CɊ܂܂Rec擾
 * \ingroup ATOMLIB_AWB
 * \param[in]	awb				擾AWBnh
 * \return		Rect@Ci0`65535j
 * \par :
 * AWBnhAWBt@CɊ܂܂ĂRecig`f[^j擾܂B<br>
 * Rect@C̒l̗L͈͂1`65535łB<br>
 * G[ꍇ 0 Ԃ܂B<br>
 * \sa criAtomAwb_LoadToc, criAtomAwb_LoadFromMemory
 */
CriUint16 CRIAPI criAtomAwb_GetNumContents(CriAtomAwbHn awb);

/*JP
 * \brief AWBnh̉
 * \ingroup ATOMLIB_AWB
 * \param[in]	awb	AWBnh
 * \return		Ȃ
 * \par :
 * AWBnh܂B<br>
 * gIAWBnh́A{֐ŉĂB<br>
 * AWBnh͖ȃnhɂȂ̂ŁAgpȂłB<br>
 * \attention
 * {֐sƁAw肵AWBf[^QƂĂAtomv[[݂ȂA
 * CuŌs܂B<br>
 * ̂߁A{֐sɑXbhAtomv[[̍쐬^jsƁA
 * ANZXᔽfbhbN̏dȕsU鋰ꂪ܂B<br>
 * {֐sAtomv[[̍쐬^j𑼃XbhōsKvꍇA
 * {֐ ::criAtom_Lock ֐ŃbNĂsĂB<br>
 * <br>
 * AtomExv[[gpAWBt@CĐꍇA
 * Đɖ{֐AWBnhjĂ͂܂B<br>
 * KAtomExv[[~Ă{֐sĂB<br>
 * \sa criAtomAwb_LoadToc, criAtomAwb_LoadTocAsync, criAtomAwb_GetStatus
 */
void CRIAPI criAtomAwb_Release(CriAtomAwbHn awb);

/*JP
 * \brief AWBnh\ǂ̃`FbN
 * \ingroup ATOMLIB_AWB
 * \param[in]	awb	AWBnh
 * \return		CriBool		AWB̏ԁiCRI_TRUE = \ACRI_FALSE = Đ̃v[[j
 * \par :
 * AWBnh𑦍ɉ\ǂ`FbN܂B<br>
 * {֐ CRI_FALSE Ԃ^C~O ::criAtomAwb_Release ֐sƁA
 * AWBnhQƂĂv[[ɑ΂~s܂B<br>
 * iXg[ĐpAWBnh̏ꍇAt@Cǂݍ݊҂߁A
 * ::criAtomAwb_Release ֐ŒԏubN\܂Bj<br>
 * \attention
 * {֐sƁAw肵AWBf[^QƂĂAtomv[[݂ȂA
 * CuŌs܂B<br>
 * ̂߁A{֐sɑXbhAtomv[[̍쐬^jsƁA
 * ANZXᔽfbhbN̏dȕsU鋰ꂪ܂B<br>
 * {֐sAtomv[[̍쐬^j𑼃XbhōsKvꍇA
 * {֐ ::criAtom_Lock ֐ŃbNĂsĂB<br>
 * \sa criAtomAwb_Release
 */
CriBool CRIAPI criAtomAwb_IsReadyToRelease(CriAtomAwbHn awb);

/*JP
 * \brief AWBnh̃Xe[^X擾
 * \ingroup ATOMLIB_AWB
 * \param[in]	awb AWBnh
 * \return		CriAtomAwbStatus AWBnh̏Ԃl
 * \par :
 * AWBnh̃Xe[^X擾܂B<br>
 * {֐Ŏ擾AWBnh̃Xe[^X́A::criAtom_ExecuteMain ֐
 * s邱ƂōXV܂B<br>
 * \sa criAtomAwb_LoadToc, criAtomAwb_LoadTocAsync
 */
CriAtomAwbStatus CRIAPI criAtomAwb_GetStatus(CriAtomAwbHn awb);

/*JP
 * \brief g`f[^ID̎擾
 * \ingroup ATOMLIB_AWB
 * \param[in]	awb AWBnh
 * \param[in]	index	 g`CfbNX
 * \retval		g`f[^ID (0ȏ)								ɏ
 * \retval		CRIATOMAWB_ILLEGAL_ID (-1)		G[
 * \par :
 * AWBnhindexŎw肵g`f[^ID擾܂B<br>
 * \sa criAtomAwb_LoadToc, criAtomAwb_LoadTocAsync
 */
CriSint32 CRIAPI criAtomAwb_GetIdByIndex(CriAtomAwbHn awb, CriUint16 index);

/*==========================================================================
 *      CRI Atom Player API
 *=========================================================================*/
/*JP
 * \brief Wv[[쐬p[N̈TCY̌vZ
 * \ingroup ATOMLIB_PLAYER
 * \param[in]	config		Wv[[쐬pRtBO\
 * \return		CriSint32	[N̈TCY
 * \retval		0ȏ		ɏ
 * \retval		-1			G[
 * \par :
 * Wv[[iADXHCAĐ\ȃv[[j쐬邽߂ɕKvȁA
 * [N̈̃TCY擾܂B<br>
 * <br>
 * [N̈TCY̌vZɎsƁA{֐ -1 Ԃ܂B<br>
 * [N̈TCY̌vZɎsRɂẮAG[R[obÑbZ[WŊmF\łB<br>
 * \par l:
 * v[[̍쐬ɕKvȃ[ÑTCÝAv[[쐬pRtBO
 * \́i ::CriAtomStandardPlayerConfig j̓eɂĕω܂B<br>
 * <br>
 * NULLw肵ꍇAftHgݒ
 * i ::criAtomPlayer_SetDefaultConfigForStandardPlayer KpƓp[^[j
 * Ń[N̈TCYvZ܂B
 * <br>
 *  config ̏́A֐ł̂ݎQƂ܂B<br>
 * ֐𔲂͎QƂ܂̂ŁA֐s config ̗̈Ă
 * 肠܂B
 * \attention
 * [N̈̃TCY̓Cui ::criAtom_Initialize ֐sj
 * Ɏw肵p[^[ɂĕω܂B<br>
 * ̂߁A{֐sOɁACuĂKv܂B<br>
 * \sa CriAtomStandardPlayerConfig, criAtomPlayer_CreateStandardPlayer
 */
CriSint32 CRIAPI criAtomPlayer_CalculateWorkSizeForStandardPlayer(
	const CriAtomStandardPlayerConfig *config);

/*JP
 * \brief Wv[[̍쐬
 * \ingroup ATOMLIB_PLAYER
 * \param[in]	config		Wv[[쐬pRtBO\
 * \param[in]	work		[N̈
 * \param[in]	work_size	[N̈TCY
 * \return		CriAtomPlayerHn	Atomv[[nh
 * \par :
 * ADXHCAĐ\ȃv[[쐬܂B<br>
 * {֐ō쐬ꂽAtomv[[ɂ́AADXf[^HCAf[^̃fR[h@\tĂ܂B<br>
 * <br>
 * 쐬ꂽv[[ōĐł鉹̃tH[}bǵAiconfigjɎw肵
 * p[^[ɂČ܂܂B<br>
 * Ⴆ΁Aconfigmax_sampling_rate24000ݒ肵ꍇA쐬ꂽv[[ł
 * 24kHz𒴂TvO[g̉f[^͍ĐłȂȂ܂B<br>
 * configNULLw肵ꍇAftHgݒi ::criAtomPlayer_SetDefaultConfigForStandardPlayer
 * KpƓp[^[jŃv[[쐬܂B
 * <br>
 * v[[쐬ۂɂ́ACuŗp邽߂̃̈i[N̈j
 * mۂKv܂B<br>
 * [N̈mۂ@ɂ́Aȉ2ʂ̕@܂B<br>
 * <b>(a) User Allocator</b>F̊mہ^ɁA[Upӂ֐gp@B<br>
 * <b>(b) Fixed Memory</b>FKvȃ̈𒼐ڃCuɓn@B<br>
 * <br>
 * User AllocatorpꍇA[U[N̈pӂKv͂܂B<br>
 * workNULLAwork_size0w肷邾ŁAKvȃo^ς݂̃mۊ֐mۂ܂B<br>
 * Wv[[쐬Ɋmۂꂽ́AWv[[ji ::criAtomPlayer_Destroy
 * ֐sjɉ܂B<br>
 * <br>
 * Fixed MemorypꍇA[N̈Ƃĕʓrmۍς݂̃̈{֐
 * ݒ肷Kv܂B<br>
 * [N̈̃TCY ::criAtomPlayer_CalculateWorkSizeForStandardPlayer ֐Ŏ擾\łB<br>
 * Wv[[쐬O ::criAtomPlayer_CalculateWorkSizeForStandardPlayer ֐Ŏ擾
 * TCỸ\ߊmۂĂA{֐ɐݒ肵ĂB<br>
 * AFixed MemorypꍇA[N͕̈Wv[[̔j
 * i ::criAtomPlayer_Destroy ֐js܂ł̊ԁACuŗpꑱ܂B<br>
 * Wv[[̔jsOɁA[N̈̃ȂłB<br>
 * \par :
 * yUser AllocatorɂWv[[̍쐬z<br>
 * User AllocatorpꍇAWv[[̍쐬^j̎菇͈ȉ̂悤ɂȂ܂B<br>
 * 	-# Wv[[쐬OɁA ::criAtom_SetUserMallocFunction ֐
 * ::criAtom_SetUserFreeFunction ֐pămہ^֐o^B<br>
 * 	-# Wv[[쐬pRtBO\̂Ƀp[^[ZbgB<br>
 * 	-# ::criAtomPlayer_CreateStandardPlayer ֐ŕWv[[쐬B<br>
 * iworkɂNULLAwork_sizeɂ0w肷Bj<br>
 * 	-# nhsvɂȂ ::criAtomPlayer_Destroy ֐ŕWv[[jB<br>
 *
 * <br>̓IȃR[h͈ȉ̂ƂłB<br>
 * \code
 * // Ǝ̃mۊ֐
 * void *user_malloc(void *obj, CriUint32 size)
 * {
 * 	void *mem;
 *
 * 	// ̊m
 * 	mem = malloc(size);
 *
 * 	return (mem);
 * }
 *
 * // Ǝ̃֐p
 * void user_free(void *obj, void *mem)
 * {
 * 	// ̉
 * 	free(mem);
 *
 * 	return;
 * }
 *
 * main()
 * {
 * 	CriAtomStandardPlayerConfig config;	// Wv[[쐬pRtBO\
 * 	CriAtomPlayerHn player;				// Atomv[[nh
 * 		:
 * 	// Ǝ̃mۊ֐o^
 * 	criAtom_SetUserMallocFunction(user_malloc, NULL);
 *
 * 	// Ǝ̃֐o^
 * 	criAtom_SetUserFreeFunction(user_free, NULL);
 *
 * 	// Wv[[쐬pRtBO\̂ݒ
 * 	memset(&config, 0, sizeof(config));
 * 	config.max_channels = 2;			// XeIĐ\ȃv[[쐬
 * 	config.max_sampling_rate = 48000;	// ő48000Hz̉Đ
 *
 * 	// Wv[[̍쐬
 * 	// [N̈ɂNULL0w肷B
 * 	// Kvȃ́Ao^mۊ֐gĊmۂB
 * 	player = criAtomPlayer_CreateStandardPlayer(&config, NULL, 0);
 * 		:
 * 	// Đ
 * 		:
 * 	// Wv[[svɂȂ_Ŕj
 * 	// Wv[[쐬ɃCuŊmۂꂽB
 * 	criAtomPlayer_Destroy(player);
 * 		:
 * }
 * \endcode
 * CuɃmہ^֐o^ς݂̏ꍇAWv[[쐬
 * ɍēx֐o^Kv͂܂B<br>
 * <br>
 * yFixed MemoryɂWv[[̍쐬z<br>
 * Fixed MemorypꍇAWv[[̍쐬^j̎菇͈ȉ̂悤ɂȂ܂B<br>
 * 	-# Wv[[쐬pRtBO\̂Ƀp[^[ZbgB<br>
 * 	-# Wv[[̍쐬ɕKvȃ[N̈̃TCYA
 * ::criAtomPlayer_CalculateWorkSizeForStandardPlayer ֐gČvZB<br>
 * 	-# [N̈TCỸmۂB<br>
 * 	-# ::criAtomPlayer_CreateStandardPlayer ֐ŕWv[[쐬B<br>
 * iworkɂ͊mۂ̃AhXAwork_sizeɂ̓[N̈̃TCYw肷Bj<br>
 * 	-# nhsvɂȂ ::criAtomPlayer_Destroy ֐ŕWv[[jB<br>
 * 	-# [N̈̃B<br>
 *
 * <br>̓IȃR[h͈ȉ̂ƂłB<br>
 * \code
 * main()
 * {
 * 	CriAtomStandardPlayerConfig config;	// Wv[[쐬pRtBO\
 * 	CriAtomPlayerHn player;				// Atomv[[nh
 * 	void *work;							// [N̈AhX
 * 	CriSint32 work_size;				// [N̈TCY
 * 		:
 * 	// Wv[[쐬pRtBO\̂ݒ
 * 	memset(&config, 0, sizeof(config));
 * 	config.max_channels = 2;			// XeIĐ\ȃv[[쐬
 * 	config.max_sampling_rate = 48000;	// ő48000Hz̉Đ
 *
 * 	// Wv[[̍쐬ɕKvȃ[N̈̃TCYvZ
 * 	work_size = criAtomPlayer_CalculateWorkSizeForStandardPlayer(&config);
 *
 * 	// [N̈pɃm
 * 	work = malloc((size_t)work_size);
 *
 * 	// Wv[[̍쐬
 * 	// [N̈ɂNULL0w肷B
 * 	// mۍς݂̃[N̈w肷B
 * 	player = criAtomPlayer_CreateStandardPlayer(&config, work, work_size);
 * 		:
 * 	// Đ
 * 	// ̊ԁAmۂ͕ێB
 * 		:
 * 	// Wv[[svɂȂ_Ŕj
 * 	criAtomPlayer_Destroy(player);
 *
 * 	// KvȂȂ[N̈
 * 	free(work);
 * 		:
 * }
 * \endcode
 * ::criAtomPlayer_CreateStandardPlayer ֐sƁAAtomv[[쐬A
 * v[[𐧌䂷邽߂̃nhi ::CriAtomPlayerHn jԂ܂B<br>
 * f[^̃ZbgAĐ̊JnAXe[^X̎擾AAtomv[[ɑ΂
 * śASănhɑ΂čs܂B<br>
 * <br>
 * 쐬ꂽAtomv[[nhgpĉf[^Đ菇͈ȉ̂ƂłB<br>
 * -# ::criAtomPlayer_SetData ֐gpāAAtomv[[ɍĐf[^ZbgB<br>
 * it@CĐ́A ::criAtomPlayer_SetFile ֐܂ ::criAtomPlayer_SetContentId
 * ֐gpBj<br>
 * -# ::criAtomPlayer_Start ֐ōĐJnB<br>
 * \par l:
 *  config ̏́A֐ł̂ݎQƂ܂B<br>
 * ֐𔲂͎QƂ܂̂ŁA֐s config ̗̈Ă
 * 肠܂B
 * \attention
 * {֐sOɁACuĂKv܂B<br>
 * <br>
 * {֐͊A^̊֐łB<br>
 * Wv[[̍쐬ɂ鎞Ԃ́AvbgtH[ɂĈقȂ܂B<br>
 * Q[[v̉ʍXVKvȃ^C~OŖ{֐sƃ~bPʂ
 * ubNAt[鋰ꂪ܂B<br>
 * Wv[[̍쐬^j́AV[̐؂ւ蓙Aוϓeł
 * ^C~Oōs悤肢܂B<br>
 * \sa CriAtomStandardPlayerConfig, criAtomPlayer_CalculateWorkSizeForStandardPlayer,
 * CriAtomPlayerHn, criAtomPlayer_Destroy,
 * criAtomPlayer_SetData, criAtomPlayer_SetFile, criAtomPlayer_SetContentId,
 * criAtomPlayer_Start, criAtomPlayer_CreateStandardPlayer
 */
CriAtomPlayerHn CRIAPI criAtomPlayer_CreateStandardPlayer(
	const CriAtomStandardPlayerConfig *config, void *work, CriSint32 work_size);

/*JP
 * \brief ADXv[[쐬p[N̈TCY̌vZ
 * \ingroup ATOMLIB_PLAYER
 * \param[in]	config		ADXv[[쐬pRtBO\
 * \return		CriSint32	[N̈TCY
 * \retval		0ȏ		ɏ
 * \retval		-1			G[
 * \par :
 * ADXĐpv[[쐬邽߂ɕKvȁA[N̈̃TCY擾܂B<br>
 * <br>
 * [N̈TCY̌vZɎsƁA{֐ -1 Ԃ܂B<br>
 * [N̈TCY̌vZɎsRɂẮAG[R[obÑbZ[WŊmF\łB<br>
 * \par l:
 * v[[̍쐬ɕKvȃ[ÑTCÝAv[[쐬pRtBO
 * \́i ::CriAtomAdxPlayerConfig j̓eɂĕω܂B<br>
 * <br>
 * NULLw肵ꍇAftHgݒ
 * i ::criAtomPlayer_SetDefaultConfigForAdxPlayer KpƓp[^[j
 * [N̈TCYvZ܂B
 * <br>
 *  config ̏́A֐ł̂ݎQƂ܂B<br>
 * ֐𔲂͎QƂ܂̂ŁA֐s config ̗̈Ă
 * 肠܂B
 * \attention
 * [N̈̃TCY̓Cui ::criAtom_Initialize ֐sj
 * Ɏw肵p[^[ɂĕω܂B<br>
 * ̂߁A{֐sOɁACuĂKv܂B<br>
 * \sa CriAtomAdxPlayerConfig, criAtomPlayer_CreateAdxPlayer
 */
CriSint32 CRIAPI criAtomPlayer_CalculateWorkSizeForAdxPlayer(
	const CriAtomAdxPlayerConfig *config);

/*JP
 * \brief ADXv[[̍쐬
 * \ingroup ATOMLIB_PLAYER
 * \param[in]	config		ADXv[[쐬pRtBO\
 * \param[in]	work		[N̈
 * \param[in]	work_size	[N̈TCY
 * \return		CriAtomPlayerHn	Atomv[[nh
 * \par :
 * ADXĐ\ȃv[[쐬܂B<br>
 * {֐ō쐬ꂽAtomv[[ɂ́AADXf[^̃fR[h@\tĂ܂B<br>
 * <br>
 * 쐬ꂽv[[ōĐł鉹̃tH[}bǵAiconfigjɎw肵
 * p[^[ɂČ܂܂B<br>
 * Ⴆ΁Aconfigmax_sampling_rate24000ݒ肵ꍇA쐬ꂽv[[ł
 * 24kHz𒴂TvO[g̉f[^͍ĐłȂȂ܂B<br>
 * configNULLw肵ꍇAftHgݒi ::criAtomPlayer_SetDefaultConfigForAdxPlayer
 * KpƓp[^[jŃv[[쐬܂B
 * <br>
 * v[[쐬ۂɂ́ACuŗp邽߂̃̈i[N̈j
 * mۂKv܂B<br>
 * [N̈mۂ@ɂ́Aȉ2ʂ̕@܂B<br>
 * <b>(a) User Allocator</b>F̊mہ^ɁA[Upӂ֐gp@B<br>
 * <b>(b) Fixed Memory</b>FKvȃ̈𒼐ڃCuɓn@B<br>
 * <br>
 * User AllocatorpꍇA[U[N̈pӂKv͂܂B<br>
 * workNULLAwork_size0w肷邾ŁAKvȃo^ς݂̃mۊ֐mۂ܂B<br>
 * ADXv[[쐬Ɋmۂꂽ́AADXv[[ji ::criAtomPlayer_Destroy
 * ֐sjɉ܂B<br>
 * <br>
 * Fixed MemorypꍇA[N̈Ƃĕʓrmۍς݂̃̈{֐
 * ݒ肷Kv܂B<br>
 * [N̈̃TCY ::criAtomPlayer_CalculateWorkSizeForAdxPlayer ֐Ŏ擾\łB<br>
 * ADXv[[쐬O ::criAtomPlayer_CalculateWorkSizeForAdxPlayer ֐Ŏ擾
 * TCỸ\ߊmۂĂA{֐ɐݒ肵ĂB<br>
 * AFixed MemorypꍇA[N̈ADXv[[̔j
 * i ::criAtomPlayer_Destroy ֐js܂ł̊ԁACuŗpꑱ܂B<br>
 * ADXv[[̔jsOɁA[N̈̃ȂłB<br>
 * \par :
 * yUser AllocatorɂADXv[[̍쐬z<br>
 * User AllocatorpꍇAADXv[[̍쐬^j̎菇͈ȉ̂悤ɂȂ܂B<br>
 * 	-# ADXv[[쐬OɁA ::criAtom_SetUserMallocFunction ֐
 * ::criAtom_SetUserFreeFunction ֐pămہ^֐o^B<br>
 * 	-# ADXv[[쐬pRtBO\̂Ƀp[^[ZbgB<br>
 * 	-# ::criAtomPlayer_CreateAdxPlayer ֐ADXv[[쐬B<br>
 * iworkɂNULLAwork_sizeɂ0w肷Bj<br>
 * 	-# nhsvɂȂ ::criAtomPlayer_Destroy ֐ADXv[[jB<br>
 *
 * <br>̓IȃR[h͈ȉ̂ƂłB<br>
 * \code
 * // Ǝ̃mۊ֐
 * void *user_malloc(void *obj, CriUint32 size)
 * {
 * 	void *mem;
 *
 * 	// ̊m
 * 	mem = malloc(size);
 *
 * 	return (mem);
 * }
 *
 * // Ǝ̃֐p
 * void user_free(void *obj, void *mem)
 * {
 * 	// ̉
 * 	free(mem);
 *
 * 	return;
 * }
 *
 * main()
 * {
 * 	CriAtomAdxPlayerConfig config;	// ADXv[[쐬pRtBO\
 * 	CriAtomPlayerHn player;			// Atomv[[nh
 * 		:
 * 	// Ǝ̃mۊ֐o^
 * 	criAtom_SetUserMallocFunction(user_malloc, NULL);
 *
 * 	// Ǝ̃֐o^
 * 	criAtom_SetUserFreeFunction(user_free, NULL);
 *
 * 	// ADXv[[쐬pRtBO\̂ݒ
 * 	memset(&config, 0, sizeof(config));
 * 	config.max_channels = 2;			// XeIĐ\ȃv[[쐬
 * 	config.max_sampling_rate = 48000;	// ő48000Hz̉Đ
 *
 * 	// ADXv[[̍쐬
 * 	// [N̈ɂNULL0w肷B
 * 	// Kvȃ́Ao^mۊ֐gĊmۂB
 * 	player = criAtomPlayer_CreateAdxPlayer(&config, NULL, 0);
 * 		:
 * 	// Đ
 * 		:
 * 	// ADXv[[svɂȂ_Ŕj
 * 	// ADXv[[쐬ɃCuŊmۂꂽB
 * 	criAtomPlayer_Destroy(player);
 * 		:
 * }
 * \endcode
 * CuɃmہ^֐o^ς݂̏ꍇAADXv[[쐬
 * ɍēx֐o^Kv͂܂B<br>
 * <br>
 * yFixed MemoryɂADXv[[̍쐬z<br>
 * Fixed MemorypꍇAADXv[[̍쐬^j̎菇͈ȉ̂悤ɂȂ܂B<br>
 * 	-# ADXv[[쐬pRtBO\̂Ƀp[^[ZbgB<br>
 * 	-# ADXv[[̍쐬ɕKvȃ[N̈̃TCYA
 * ::criAtomPlayer_CalculateWorkSizeForAdxPlayer ֐gČvZB<br>
 * 	-# [N̈TCỸmۂB<br>
 * 	-# ::criAtomPlayer_CreateAdxPlayer ֐ADXv[[쐬B<br>
 * iworkɂ͊mۂ̃AhXAwork_sizeɂ̓[N̈̃TCYw肷Bj<br>
 * 	-# nhsvɂȂ ::criAtomPlayer_Destroy ֐ADXv[[jB<br>
 * 	-# [N̈̃B<br>
 *
 * <br>̓IȃR[h͈ȉ̂ƂłB<br>
 * \code
 * main()
 * {
 * 	CriAtomAdxPlayerConfig config;	// ADXv[[쐬pRtBO\
 * 	CriAtomPlayerHn player;			// Atomv[[nh
 * 	void *work;						// [N̈AhX
 * 	CriSint32 work_size;			// [N̈TCY
 * 		:
 * 	// ADXv[[쐬pRtBO\̂ݒ
 * 	memset(&config, 0, sizeof(config));
 * 	config.max_channels = 2;			// XeIĐ\ȃv[[쐬
 * 	config.max_sampling_rate = 48000;	// ő48000Hz̉Đ
 *
 * 	// ADXv[[̍쐬ɕKvȃ[N̈̃TCYvZ
 * 	work_size = criAtomPlayer_CalculateWorkSizeForAdxPlayer(&config);
 *
 * 	// [N̈pɃm
 * 	work = malloc((size_t)work_size);
 *
 * 	// ADXv[[̍쐬
 * 	// [N̈ɂNULL0w肷B
 * 	// mۍς݂̃[N̈w肷B
 * 	player = criAtomPlayer_CreateAdxPlayer(&config, work, work_size);
 * 		:
 * 	// Đ
 * 	// ̊ԁAmۂ͕ێB
 * 		:
 * 	// ADXv[[svɂȂ_Ŕj
 * 	criAtomPlayer_Destroy(player);
 *
 * 	// KvȂȂ[N̈
 * 	free(work);
 * 		:
 * }
 * \endcode
 * ::criAtomPlayer_CreateAdxPlayer ֐sƁAAtomv[[쐬A
 * v[[𐧌䂷邽߂̃nhi ::CriAtomPlayerHn jԂ܂B<br>
 * f[^fR[_[̃ZbgAĐ̊JnAXe[^X̎擾AAtomv[[ɑ΂
 * śASănhɑ΂čs܂B<br>
 * <br>
 * 쐬ꂽAtomv[[nhgpĉf[^Đ菇͈ȉ̂ƂłB<br>
 * -# ::criAtomPlayer_SetData ֐gpāAAtomv[[ɍĐf[^ZbgB<br>
 * it@CĐ́A ::criAtomPlayer_SetFile ֐܂ ::criAtomPlayer_SetContentId
 * ֐gpBj<br>
 * -# ::criAtomPlayer_Start ֐ōĐJnB<br>
 * \par l:
 *  config ̏́A֐ł̂ݎQƂ܂B<br>
 * ֐𔲂͎QƂ܂̂ŁA֐s config ̗̈Ă
 * 肠܂B
 * \attention
 * {֐sOɁACuĂKv܂B<br>
 * <br>
 * {֐͊A^̊֐łB<br>
 * ADXv[[̍쐬ɂ鎞Ԃ́AvbgtH[ɂĈقȂ܂B<br>
 * Q[[v̉ʍXVKvȃ^C~OŖ{֐sƃ~bPʂ
 * ubNAt[鋰ꂪ܂B<br>
 * ADXv[[̍쐬^j́AV[̐؂ւ蓙Aוϓeł
 * ^C~Oōs悤肢܂B<br>
 * \sa CriAtomAdxPlayerConfig, criAtomPlayer_CalculateWorkSizeForAdxPlayer,
 * CriAtomPlayerHn, criAtomPlayer_Destroy,
 * criAtomPlayer_SetData, criAtomPlayer_SetFile, criAtomPlayer_SetContentId,
 * criAtomPlayer_Start, criAtomPlayer_CreateAdxPlayer
 */
CriAtomPlayerHn CRIAPI criAtomPlayer_CreateAdxPlayer(
	const CriAtomAdxPlayerConfig *config, void *work, CriSint32 work_size);

/*JP
 * \brief HCAv[[쐬p[N̈TCY̌vZ
 * \ingroup ATOMLIB_PLAYER
 * \param[in]	config		HCAv[[쐬pRtBO\
 * \return		CriSint32	[N̈TCY
 * \retval		0ȏ		ɏ
 * \retval		-1			G[
 * \par :
 * HCAĐpv[[쐬邽߂ɕKvȁA[N̈̃TCY擾܂B<br>
 * <br>
 * [N̈TCY̌vZɎsƁA{֐ -1 Ԃ܂B<br>
 * [N̈TCY̌vZɎsRɂẮAG[R[obÑbZ[WŊmF\łB<br>
 * \par l:
 * v[[̍쐬ɕKvȃ[ÑTCÝAv[[쐬pRtBO
 * \́i ::CriAtomHcaPlayerConfig j̓eɂĕω܂B<br>
 * <br>
 * NULLw肵ꍇAftHgݒ
 * i ::criAtomPlayer_SetDefaultConfigForHcaPlayer KpƓp[^[j
 * [N̈TCYvZ܂B
 * <br>
 *  config ̏́A֐ł̂ݎQƂ܂B<br>
 * ֐𔲂͎QƂ܂̂ŁA֐s config ̗̈Ă
 * 肠܂B
 * \attention
 * [N̈̃TCY̓Cui ::criAtom_Initialize ֐sj
 * Ɏw肵p[^[ɂĕω܂B<br>
 * ̂߁A{֐sOɁACuĂKv܂B<br>
 * \sa CriAtomHcaPlayerConfig, criAtomPlayer_CreateHcaPlayer
 */
CriSint32 CRIAPI criAtomPlayer_CalculateWorkSizeForHcaPlayer(
	const CriAtomHcaPlayerConfig *config);

/*JP
 * \brief HCAv[[̍쐬
 * \ingroup ATOMLIB_PLAYER
 * \param[in]	config		HCAv[[쐬pRtBO\
 * \param[in]	work		[N̈
 * \param[in]	work_size	[N̈TCY
 * \return		CriAtomPlayerHn	Atomv[[nh
 * \par :
 * HCAĐ\ȃv[[쐬܂B<br>
 * {֐ō쐬ꂽAtomv[[ɂ́AHCAf[^̃fR[h@\tĂ܂B<br>
 * <br>
 * 쐬ꂽv[[ōĐł鉹̃tH[}bǵAiconfigjɎw肵
 * p[^[ɂČ܂܂B<br>
 * Ⴆ΁Aconfigmax_sampling_rate24000ݒ肵ꍇA쐬ꂽv[[ł
 * 24kHz𒴂TvO[g̉f[^͍ĐłȂȂ܂B<br>
 * configNULLw肵ꍇAftHgݒi ::criAtomPlayer_SetDefaultConfigForHcaPlayer
 * KpƓp[^[jŃv[[쐬܂B
 * <br>
 * v[[쐬ۂɂ́ACuŗp邽߂̃̈i[N̈j
 * mۂKv܂B<br>
 * [N̈mۂ@ɂ́Aȉ2ʂ̕@܂B<br>
 * <b>(a) User Allocator</b>F̊mہ^ɁA[Upӂ֐gp@B<br>
 * <b>(b) Fixed Memory</b>FKvȃ̈𒼐ڃCuɓn@B<br>
 * ȅڍׂɂẮAʓr ::criAtomPlayer_CreateAdxPlayer ֐̐QƂB<br>
 * <br>
 * ::criAtomPlayer_CreateHcaPlayer ֐sƁAAtomv[[쐬A
 * v[[𐧌䂷邽߂̃nhi ::CriAtomPlayerHn jԂ܂B<br>
 * f[^fR[_[̃ZbgAĐ̊JnAXe[^X̎擾AAtomv[[ɑ΂
 * śASănhɑ΂čs܂B<br>
 * <br>
 * 쐬ꂽAtomv[[nhgpĉf[^Đ菇͈ȉ̂ƂłB<br>
 * -# ::criAtomPlayer_SetData ֐gpāAAtomv[[ɍĐf[^ZbgB<br>
 * it@CĐ́A ::criAtomPlayer_SetFile ֐܂ ::criAtomPlayer_SetContentId
 * ֐gpBj<br>
 * -# ::criAtomPlayer_Start ֐ōĐJnB<br>
 * \par l:
 *  config ̏́A֐ł̂ݎQƂ܂B<br>
 * ֐𔲂͎QƂ܂̂ŁA֐s config ̗̈Ă
 * 肠܂B
 * \attention
 * {֐sOɁACuĂKv܂B<br>
 * <br>
 * {֐͊A^̊֐łB<br>
 * HCAv[[̍쐬ɂ鎞Ԃ́AvbgtH[ɂĈقȂ܂B<br>
 * Q[[v̉ʍXVKvȃ^C~OŖ{֐sƃ~bPʂ
 * ubNAt[鋰ꂪ܂B<br>
 * HCAv[[̍쐬^j́AV[̐؂ւ蓙Aוϓeł
 * ^C~Oōs悤肢܂B<br>
 * \sa CriAtomHcaPlayerConfig, criAtomPlayer_CalculateWorkSizeForHcaPlayer,
 * CriAtomPlayerHn, criAtomPlayer_Destroy,
 * criAtomPlayer_SetData, criAtomPlayer_SetFile, criAtomPlayer_SetContentId,
 * criAtomPlayer_Start, criAtomPlayer_CreateHcaPlayer
 */
CriAtomPlayerHn CRIAPI criAtomPlayer_CreateHcaPlayer(
	const CriAtomHcaPlayerConfig *config, void *work, CriSint32 work_size);

/*JP
 * \brief HCA-MXv[[쐬p[N̈TCY̌vZ
 * \ingroup ATOMLIB_PLAYER
 * \param[in]	config		HCA-MXv[[쐬pRtBO\
 * \return		CriSint32	[N̈TCY
 * \retval		0ȏ		ɏ
 * \retval		-1			G[
 * \par :
 * HCA-MXĐpv[[쐬邽߂ɕKvȁA[N̈̃TCY擾܂B<br>
 * <br>
 * [N̈TCY̌vZɎsƁA{֐ -1 Ԃ܂B<br>
 * [N̈TCY̌vZɎsRɂẮAG[R[obÑbZ[WŊmF\łB<br>
 * \par l:
 * v[[̍쐬ɕKvȃ[ÑTCÝAv[[쐬pRtBO
 * \́i ::CriAtomHcaMxPlayerConfig j̓eɂĕω܂B<br>
 * <br>
 * NULLw肵ꍇAftHgݒ
 * i ::criAtomPlayer_SetDefaultConfigForHcaMxPlayer KpƓp[^[j
 * [N̈TCYvZ܂B
 * <br>
 *  config ̏́A֐ł̂ݎQƂ܂B<br>
 * ֐𔲂͎QƂ܂̂ŁA֐s config ̗̈Ă
 * 肠܂B
 * \attention
 * [N̈̃TCYHCA-MXi ::criAtomHcaMx_Initialize ֐sj
 * Ɏw肵p[^[ɂĕω܂B<br>
 * ̂߁A{֐sOɁAHCA-MXĂKv܂B<br>
 * \sa CriAtomHcaMxPlayerConfig, criAtomPlayer_CreateHcaMxPlayer
 */
CriSint32 CRIAPI criAtomPlayer_CalculateWorkSizeForHcaMxPlayer(
	const CriAtomHcaMxPlayerConfig *config);

/*JP
 * \brief HCA-MXv[[̍쐬
 * \ingroup ATOMLIB_PLAYER
 * \param[in]	config		HCA-MXv[[쐬pRtBO\
 * \param[in]	work		[N̈
 * \param[in]	work_size	[N̈TCY
 * \return		CriAtomPlayerHn	Atomv[[nh
 * \par :
 * HCA-MXĐ\ȃv[[쐬܂B<br>
 * {֐ō쐬ꂽAtomv[[ɂ́AHCA-MXf[^̃fR[h@\tĂ܂B<br>
 * <br>
 * 쐬ꂽv[[ōĐł鉹̃tH[}bǵAiconfigjɎw肵
 * p[^[ɂČ܂܂B<br>
 * Ⴆ΁Aconfigmax_sampling_rate24000ݒ肵ꍇA쐬ꂽv[[ł
 * 24kHz𒴂TvO[g̉f[^͍ĐłȂȂ܂B<br>
 * configNULLw肵ꍇAftHgݒi ::criAtomPlayer_SetDefaultConfigForHcaMxPlayer
 * KpƓp[^[jŃv[[쐬܂B
 * <br>
 * v[[쐬ۂɂ́ACuŗp邽߂̃̈i[N̈j
 * mۂKv܂B<br>
 * [N̈mۂ@ɂ́Aȉ2ʂ̕@܂B<br>
 * <b>(a) User Allocator</b>F̊mہ^ɁA[Upӂ֐gp@B<br>
 * <b>(b) Fixed Memory</b>FKvȃ̈𒼐ڃCuɓn@B<br>
 * ȅڍׂɂẮAʓr ::criAtomPlayer_CreateAdxPlayer ֐̐QƂB<br>
 * <br>
 * ::criAtomPlayer_CreateHcaMxPlayer ֐sƁAAtomv[[쐬A
 * v[[𐧌䂷邽߂̃nhi ::CriAtomPlayerHn jԂ܂B<br>
 * f[^fR[_[̃ZbgAĐ̊JnAXe[^X̎擾AAtomv[[ɑ΂
 * śASănhɑ΂čs܂B<br>
 * <br>
 * 쐬ꂽAtomv[[nhgpĉf[^Đ菇͈ȉ̂ƂłB<br>
 * -# ::criAtomPlayer_SetData ֐gpāAAtomv[[ɍĐf[^ZbgB<br>
 * it@CĐ́A ::criAtomPlayer_SetFile ֐܂ ::criAtomPlayer_SetContentId
 * ֐gpBj<br>
 * -# ::criAtomPlayer_Start ֐ōĐJnB<br>
 * \par l:
 *  config ̏́A֐ł̂ݎQƂ܂B<br>
 * ֐𔲂͎QƂ܂̂ŁA֐s config ̗̈Ă
 * 肠܂B
 * \attention
 * {֐sOɁAHCA-MXĂKv܂B<br>
 * <br>
 * {֐͊A^̊֐łB<br>
 * HCA-MXv[[̍쐬ɂ鎞Ԃ́AvbgtH[ɂĈقȂ܂B<br>
 * Q[[v̉ʍXVKvȃ^C~OŖ{֐sƃ~bPʂ
 * ubNAt[鋰ꂪ܂B<br>
 * HCA-MXv[[̍쐬^j́AV[̐؂ւ蓙Aוϓeł
 * ^C~Oōs悤肢܂B<br>
 * \sa CriAtomHcaMxPlayerConfig, criAtomPlayer_CalculateWorkSizeForHcaMxPlayer,
 * CriAtomPlayerHn, criAtomPlayer_Destroy,
 * criAtomPlayer_SetData, criAtomPlayer_SetFile, criAtomPlayer_SetContentId,
 * criAtomPlayer_Start, criAtomPlayer_CreateHcaMxPlayer
 */
CriAtomPlayerHn CRIAPI criAtomPlayer_CreateHcaMxPlayer(
	const CriAtomHcaMxPlayerConfig *config, void *work, CriSint32 work_size);

/*JP
 * \brief WAVEv[[쐬p[N̈TCY̌vZ
 * \ingroup ATOMLIB_PLAYER
 * \param[in]	config		WAVEv[[쐬pRtBO\
 * \return		CriSint32	[N̈TCY
 * \retval		0ȏ		ɏ
 * \retval		-1			G[
 * \par :
 * WAVEĐpv[[쐬邽߂ɕKvȁA[N̈̃TCY擾܂B<br>
 * <br>
 * [N̈TCY̌vZɎsƁA{֐ -1 Ԃ܂B<br>
 * [N̈TCY̌vZɎsRɂẮAG[R[obÑbZ[WŊmF\łB<br>
 * \par l:
 * v[[̍쐬ɕKvȃ[ÑTCÝAv[[쐬pRtBO
 * \́i ::CriAtomWavePlayerConfig j̓eɂĕω܂B<br>
 * <br>
 * NULLw肵ꍇAftHgݒ
 * i ::criAtomPlayer_SetDefaultConfigForWavePlayer KpƓp[^[j
 * [N̈TCYvZ܂B
 * <br>
 *  config ̏́A֐ł̂ݎQƂ܂B<br>
 * ֐𔲂͎QƂ܂̂ŁA֐s config ̗̈Ă
 * 肠܂B
 * \attention
 * [N̈̃TCY̓Cui ::criAtom_Initialize ֐sj
 * Ɏw肵p[^[ɂĕω܂B<br>
 * ̂߁A{֐sOɁACuĂKv܂B<br>
 * \sa CriAtomWavePlayerConfig, criAtomPlayer_CreateWavePlayer
 */
CriSint32 CRIAPI criAtomPlayer_CalculateWorkSizeForWavePlayer(
	const CriAtomWavePlayerConfig *config);

/*JP
 * \brief WAVEv[[̍쐬
 * \ingroup ATOMLIB_PLAYER
 * \param[in]	config		WAVEv[[쐬pRtBO\
 * \param[in]	work		[N̈
 * \param[in]	work_size	[N̈TCY
 * \return		CriAtomPlayerHn	Atomv[[nh
 * \par :
 * WAVEĐ\ȃv[[쐬܂B<br>
 * {֐ō쐬ꂽAtomv[[ɂ́AWAVEf[^̃fR[h@\tĂ܂B<br>
 * <br>
 * 쐬ꂽv[[ōĐł鉹̃tH[}bǵAiconfigjɎw肵
 * p[^[ɂČ܂܂B<br>
 * Ⴆ΁Aconfigmax_sampling_rate24000ݒ肵ꍇA쐬ꂽv[[ł
 * 24kHz𒴂TvO[g̉f[^͍ĐłȂȂ܂B<br>
 * configNULLw肵ꍇAftHgݒi ::criAtomPlayer_SetDefaultConfigForWavePlayer
 * KpƓp[^[jŃv[[쐬܂B
 * <br>
 * v[[쐬ۂɂ́ACuŗp邽߂̃̈i[N̈j
 * mۂKv܂B<br>
 * [N̈mۂ@ɂ́Aȉ2ʂ̕@܂B<br>
 * <b>(a) User Allocator</b>F̊mہ^ɁA[Upӂ֐gp@B<br>
 * <b>(b) Fixed Memory</b>FKvȃ̈𒼐ڃCuɓn@B<br>
 * ȅڍׂɂẮAʓr ::criAtomPlayer_CreateAdxPlayer ֐̐QƂB<br>
 * <br>
 * ::criAtomPlayer_CreateWavePlayer ֐sƁAAtomv[[쐬A
 * v[[𐧌䂷邽߂̃nhi ::CriAtomPlayerHn jԂ܂B<br>
 * f[^fR[_[̃ZbgAĐ̊JnAXe[^X̎擾AAtomv[[ɑ΂
 * śASănhɑ΂čs܂B<br>
 * <br>
 * 쐬ꂽAtomv[[nhgpĉf[^Đ菇͈ȉ̂ƂłB<br>
 * -# ::criAtomPlayer_SetData ֐gpāAAtomv[[ɍĐf[^ZbgB<br>
 * it@CĐ́A ::criAtomPlayer_SetFile ֐܂ ::criAtomPlayer_SetContentId
 * ֐gpBj<br>
 * -# ::criAtomPlayer_Start ֐ōĐJnB<br>
 * \par l:
 *  config ̏́A֐ł̂ݎQƂ܂B<br>
 * ֐𔲂͎QƂ܂̂ŁA֐s config ̗̈Ă
 * 肠܂B
 * \attention
 * {֐sOɁACuĂKv܂B<br>
 * <br>
 * {֐͊A^̊֐łB<br>
 * WAVEv[[̍쐬ɂ鎞Ԃ́AvbgtH[ɂĈقȂ܂B<br>
 * Q[[v̉ʍXVKvȃ^C~OŖ{֐sƃ~bPʂ
 * ubNAt[鋰ꂪ܂B<br>
 * WAVEv[[̍쐬^j́AV[̐؂ւ蓙Aוϓeł
 * ^C~Oōs悤肢܂B<br>
 * <br>
 * AWavet@C̃`N͂͌ɂ͍sĂ܂B<br>
 * `N̕яFORM`NACOMM`NASSND`Nł͂ȂꍇA
 * ̑̃`N܂Wavet@ĆA͂Ɏs\܂B<br>
 * ܂A_őΉĂtH[}bǵAm܂̓XeI
 * 16bit 񈳏kf[^݂̂łB<br>
 * \sa CriAtomWavePlayerConfig, criAtomPlayer_CalculateWorkSizeForWavePlayer,
 * CriAtomPlayerHn, criAtomPlayer_Destroy,
 * criAtomPlayer_SetData, criAtomPlayer_SetFile, criAtomPlayer_SetContentId,
 * criAtomPlayer_Start, criAtomPlayer_CreateWavePlayer
 */
CriAtomPlayerHn CRIAPI criAtomPlayer_CreateWavePlayer(
	const CriAtomWavePlayerConfig *config, void *work, CriSint32 work_size);

/*JP
 * \brief AIFFv[[쐬p[N̈TCY̌vZ
 * \ingroup ATOMLIB_PLAYER
 * \param[in]	config		AIFFv[[쐬pRtBO\
 * \return		CriSint32	[N̈TCY
 * \retval		0ȏ		ɏ
 * \retval		-1			G[
 * \par :
 * AIFFĐpv[[쐬邽߂ɕKvȁA[N̈̃TCY擾܂B<br>
 * <br>
 * [N̈TCY̌vZɎsƁA{֐ -1 Ԃ܂B<br>
 * [N̈TCY̌vZɎsRɂẮAG[R[obÑbZ[WŊmF\łB<br>
 * \par l:
 * v[[̍쐬ɕKvȃ[ÑTCÝAv[[쐬pRtBO
 * \́i ::CriAtomAiffPlayerConfig j̓eɂĕω܂B<br>
 * <br>
 * NULLw肵ꍇAftHgݒ
 * i ::criAtomPlayer_SetDefaultConfigForAiffPlayer KpƓp[^[j
 * [N̈TCYvZ܂B
 * <br>
 *  config ̏́A֐ł̂ݎQƂ܂B<br>
 * ֐𔲂͎QƂ܂̂ŁA֐s config ̗̈Ă
 * 肠܂B
 * \attention
 * [N̈̃TCY̓Cui ::criAtom_Initialize ֐sj
 * Ɏw肵p[^[ɂĕω܂B<br>
 * ̂߁A{֐sOɁACuĂKv܂B<br>
 * \sa CriAtomAiffPlayerConfig, criAtomPlayer_CreateAiffPlayer
 */
CriSint32 CRIAPI criAtomPlayer_CalculateWorkSizeForAiffPlayer(
	const CriAtomAiffPlayerConfig *config);

/*JP
 * \brief AIFFv[[̍쐬
 * \ingroup ATOMLIB_PLAYER
 * \param[in]	config		AIFFv[[쐬pRtBO\
 * \param[in]	work		[N̈
 * \param[in]	work_size	[N̈TCY
 * \return		CriAtomPlayerHn	Atomv[[nh
 * \par :
 * AIFFĐ\ȃv[[쐬܂B<br>
 * {֐ō쐬ꂽAtomv[[ɂ́AAIFFf[^̃fR[h@\tĂ܂B<br>
 * <br>
 * 쐬ꂽv[[ōĐł鉹̃tH[}bǵAiconfigjɎw肵
 * p[^[ɂČ܂܂B<br>
 * Ⴆ΁Aconfigmax_sampling_rate24000ݒ肵ꍇA쐬ꂽv[[ł
 * 24kHz𒴂TvO[g̉f[^͍ĐłȂȂ܂B<br>
 * configNULLw肵ꍇAftHgݒi ::criAtomPlayer_SetDefaultConfigForAiffPlayer
 * KpƓp[^[jŃv[[쐬܂B
 * <br>
 * v[[쐬ۂɂ́ACuŗp邽߂̃̈i[N̈j
 * mۂKv܂B<br>
 * [N̈mۂ@ɂ́Aȉ2ʂ̕@܂B<br>
 * <b>(a) User Allocator</b>F̊mہ^ɁA[Upӂ֐gp@B<br>
 * <b>(b) Fixed Memory</b>FKvȃ̈𒼐ڃCuɓn@B<br>
 * ȅڍׂɂẮAʓr ::criAtomPlayer_CreateAdxPlayer ֐̐QƂB<br>
 * <br>
 * ::criAtomPlayer_CreateAiffPlayer ֐sƁAAtomv[[쐬A
 * v[[𐧌䂷邽߂̃nhi ::CriAtomPlayerHn jԂ܂B<br>
 * f[^fR[_[̃ZbgAĐ̊JnAXe[^X̎擾AAtomv[[ɑ΂
 * śASănhɑ΂čs܂B<br>
 * <br>
 * 쐬ꂽAtomv[[nhgpĉf[^Đ菇͈ȉ̂ƂłB<br>
 * -# ::criAtomPlayer_SetData ֐gpāAAtomv[[ɍĐf[^ZbgB<br>
 * it@CĐ́A ::criAtomPlayer_SetFile ֐܂ ::criAtomPlayer_SetContentId
 * ֐gpBj<br>
 * -# ::criAtomPlayer_Start ֐ōĐJnB<br>
 * \par l:
 *  config ̏́A֐ł̂ݎQƂ܂B<br>
 * ֐𔲂͎QƂ܂̂ŁA֐s config ̗̈Ă
 * 肠܂B
 * \attention
 * {֐sOɁACuĂKv܂B<br>
 * <br>
 * {֐͊A^̊֐łB<br>
 * AIFFv[[̍쐬ɂ鎞Ԃ́AvbgtH[ɂĈقȂ܂B<br>
 * Q[[v̉ʍXVKvȃ^C~OŖ{֐sƃ~bPʂ
 * ubNAt[鋰ꂪ܂B<br>
 * AIFFv[[̍쐬^j́AV[̐؂ւ蓙Aוϓeł
 * ^C~Oōs悤肢܂B<br>
 * <br>
 * AAIFFt@C̃`N͂͌ɂ͍sĂ܂B<br>
 * `N̕яFORM`NACOMM`NASSND`Nł͂ȂꍇA
 * ̑̃`N܂AIFFt@ĆA͂Ɏs\܂B<br>
 * ܂A_őΉĂtH[}bǵAm܂̓XeI
 * 16bit 񈳏kf[^݂̂łB<br>
 * \sa CriAtomAiffPlayerConfig, criAtomPlayer_CalculateWorkSizeForAiffPlayer,
 * CriAtomPlayerHn, criAtomPlayer_Destroy,
 * criAtomPlayer_SetData, criAtomPlayer_SetFile, criAtomPlayer_SetContentId,
 * criAtomPlayer_Start, criAtomPlayer_CreateAiffPlayer
 */
CriAtomPlayerHn CRIAPI criAtomPlayer_CreateAiffPlayer(
	const CriAtomAiffPlayerConfig *config, void *work, CriSint32 work_size);

/*JP
 * \brief RawPCMv[[쐬p[N̈TCY̌vZ
 * \ingroup ATOMLIB_PLAYER
 * \param[in]	config		RawPCMv[[쐬pRtBO\
 * \return		CriSint32	[N̈TCY
 * \retval		0ȏ		ɏ
 * \retval		-1			G[
 * \par :
 * RawPCMĐpv[[쐬邽߂ɕKvȁA[N̈̃TCY擾܂B<br>
 * <br>
 * [N̈TCY̌vZɎsƁA{֐ -1 Ԃ܂B<br>
 * [N̈TCY̌vZɎsRɂẮAG[R[obÑbZ[WŊmF\łB<br>
 * \par l:
 * v[[̍쐬ɕKvȃ[ÑTCÝAv[[쐬pRtBO
 * \́i ::CriAtomRawPcmPlayerConfig j̓eɂĕω܂B<br>
 * <br>
 * NULLw肵ꍇAftHgݒ
 * i ::criAtomPlayer_SetDefaultConfigForRawPcmPlayer KpƓp[^[j
 * [N̈TCYvZ܂B
 * <br>
 *  config ̏́A֐ł̂ݎQƂ܂B<br>
 * ֐𔲂͎QƂ܂̂ŁA֐s config ̗̈Ă
 * 肠܂B
 * \attention
 * [N̈̃TCY̓Cui ::criAtom_Initialize ֐sj
 * Ɏw肵p[^[ɂĕω܂B<br>
 * ̂߁A{֐sOɁACuĂKv܂B<br>
 * \sa CriAtomRawPcmPlayerConfig, criAtomPlayer_CreateRawPcmPlayer
 */
CriSint32 CRIAPI criAtomPlayer_CalculateWorkSizeForRawPcmPlayer(
	const CriAtomRawPcmPlayerConfig *config);

/*JP
 * \brief RawPCMv[[̍쐬
 * \ingroup ATOMLIB_PLAYER
 * \param[in]	config		RawPCMv[[쐬pRtBO\
 * \param[in]	work		[N̈
 * \param[in]	work_size	[N̈TCY
 * \return		CriAtomPlayerHn	Atomv[[nh
 * \par :
 * RawPCMĐ\ȃv[[쐬܂B<br>
 * {֐ō쐬ꂽAtomv[[ɂ́ARawPCMf[^̃fR[h@\tĂ܂B<br>
 * <br>
 * 쐬ꂽv[[ōĐł鉹̃tH[}bǵAiconfigjɎw肵
 * p[^[ɂČ܂܂B<br>
 * Ⴆ΁Aconfigmax_sampling_rate24000ݒ肵ꍇA쐬ꂽv[[ł
 * 24kHz𒴂TvO[g̉f[^͍ĐłȂȂ܂B<br>
 * configNULLw肵ꍇAftHgݒi ::criAtomPlayer_SetDefaultConfigForRawPcmPlayer
 * KpƓp[^[jŃv[[쐬܂B
 * <br>
 * v[[쐬ۂɂ́ACuŗp邽߂̃̈i[N̈j
 * mۂKv܂B<br>
 * [N̈mۂ@ɂ́Aȉ2ʂ̕@܂B<br>
 * <b>(a) User Allocator</b>F̊mہ^ɁA[Upӂ֐gp@B<br>
 * <b>(b) Fixed Memory</b>FKvȃ̈𒼐ڃCuɓn@B<br>
 * ȅڍׂɂẮAʓr ::criAtomPlayer_CreateAdxPlayer ֐̐QƂB<br>
 * <br>
 * ::criAtomPlayer_CreateRawPcmPlayer ֐sƁAAtomv[[쐬A
 * v[[𐧌䂷邽߂̃nhi ::CriAtomPlayerHn jԂ܂B<br>
 * f[^fR[_[̃ZbgAĐ̊JnAXe[^X̎擾AAtomv[[ɑ΂
 * śASănhɑ΂čs܂B<br>
 * <br>
 * 쐬ꂽAtomv[[nhgpĉf[^Đ菇͈ȉ̂ƂłB<br>
 * -# ::criAtomPlayer_SetData ֐gpāAAtomv[[ɍĐf[^ZbgB<br>
 * it@CĐ́A ::criAtomPlayer_SetFile ֐܂ ::criAtomPlayer_SetContentId
 * ֐gpBj<br>
 * -# ::criAtomPlayer_Start ֐ōĐJnB<br>
 * \par l:
 *  config ̏́A֐ł̂ݎQƂ܂B<br>
 * ֐𔲂͎QƂ܂̂ŁA֐s config ̗̈Ă
 * 肠܂B
 * \attention
 * {֐sOɁACuĂKv܂B<br>
 * <br>
 * {֐͊A^̊֐łB<br>
 * RawPCMv[[̍쐬ɂ鎞Ԃ́AvbgtH[ɂĈقȂ܂B<br>
 * Q[[v̉ʍXVKvȃ^C~OŖ{֐sƃ~bPʂ
 * ubNAt[鋰ꂪ܂B<br>
 * RawPCMv[[̍쐬^j́AV[̐؂ւ蓙Aוϓeł
 * ^C~Oōs悤肢܂B<br>
 * \sa CriAtomRawPcmPlayerConfig, criAtomPlayer_CalculateWorkSizeForRawPcmPlayer,
 * CriAtomPlayerHn, criAtomPlayer_Destroy,
 * criAtomPlayer_SetData, criAtomPlayer_SetFile, criAtomPlayer_SetContentId,
 * criAtomPlayer_Start, criAtomPlayer_CreateRawPcmPlayer
 */
CriAtomPlayerHn CRIAPI criAtomPlayer_CreateRawPcmPlayer(
	const CriAtomRawPcmPlayerConfig *config, void *work, CriSint32 work_size);

/*JP
 * \brief Atomv[[̔j
 * \ingroup ATOMLIB_PLAYER
 * \param[in]	player		Atomv[[nh
 * \par :
 * Atomv[[j܂B<br>
 * {֐s_ŁAAtomv[[쐬Ɋmۂꂽ\[XSĉ܂B<br>
 * ܂AɎw肵Atomv[[nhɂȂ܂B<br>
 * \attention
 * {֐͊A^̊֐łB<br>
 * ĐAtomv[[j悤ƂꍇA{֐ōĐ~
 * ҂Ă烊\[X̉s܂B<br>
 * it@CĐĂꍇ́Aɓǂݍ݊҂s܂Bj<br>
 * ̂߁A{֐ŏԁit[jubN\܂B<br>
 * Atomv[[̍쐬^j́AV[̐؂ւ蓙Aוϓeł
 * ^C~Oōs悤肢܂B<br>
 * \sa criAtomPlayer_CreateAdxPlayer, CriAtomPlayerHn
 */
void CRIAPI criAtomPlayer_Destroy(CriAtomPlayerHn player);

/*JP
 * \brief f[^̃ZbgiIf[^̎wj
 * \ingroup ATOMLIB_PLAYER
 * \param[in]	player			Atomv[[nh
 * \param[in]	buffer			obt@[AhX
 * \param[in]	buffer_size		obt@[TCY
 * \par :
 * ɔzuꂽf[^AAtomv[[Ɋ֘At܂B<br>
 * {֐ŃAhXƃTCYwA ::criAtomPlayer_Start ֐ōĐ
 * JnƁAw肳ꂽf[^Đ܂B
 * \par :
 * \code
 * main()
 * {
 * 		:
 * 	// f[^Zbg
 * 	criAtomPlayer_SetData(player, buffer, buffer_size);
 *
 * 	// Zbgꂽf[^Đ
 * 	criAtomPlayer_Start(player);
 * 		:
 * }
 * \endcode
 * AUZbgf[^̏́Ãf[^Zbg܂Atomv[[ɕێ
 * ܂B<br>
 * ̂߁Af[^xĐꍇɂ́AĐɃf[^ZbgȂKv
 * ͂܂B
 * \par l:
 * f[^vR[obN֐i ::CriAtomPlayerDataRequestCbFunc jŖ{֐sƁA
 * OZbg̏I[ɘAĎ̃f[^Đ܂B<br>
 * Ⴆ΁Aȉ̃R[hsƁAbuffer1̃f[^buffer2̃f[^V[X
 * AčĐ܂B<br>
 * ǐbuffer2̃f[^JԂĐ܂Bj<br>
 * \code
 * // f[^vR[obN֐
 * void on_data_request(void *obj, CriAtomPlayerHn player)
 * {
 * 	// čĐf[^Zbg
 * 	criAtomPlayer_SetData(player, buffer2, buffer_size2);
 * }
 *
 * main()
 * {
 * 		:
 * 	// f[^vR[obN֐̓o^
 * 	criAtomPlayer_SetDataRequestCallback(player, on_data_request, NULL);
 *
 * 	// f[^Zbg
 * 	criAtomPlayer_SetData(player, buffer1, buffer_size1);
 *
 * 	// Zbgꂽf[^Đ
 * 	criAtomPlayer_Start(player);
 * 		:
 * }
 * \endcode
 * f[^vR[obN֐ ::criAtomPlayer_SetFile ֐s邱ƂŁA
 * If[^ƃt@CAčĐ邱Ƃ\łB<br>
 * iAɍĐIf[^ZꍇAɍĐt@C
 * ǂݍ݂Ԃɍ킸Ar؂\܂Bj<br>
 * \attention
 * v[[L̂̓obt@[̃AhXƃTCŶ݂łB<br>
 * iobt@[̃f[^Rs[킯ł͂܂Bj<br>
 * ̂߁Aw肵f[^̍ĐI܂ł̊ԁA
 * AvP[VŃobt@[ێKv܂B<br>
 * <br>
 * {֐͒~̃v[[ɑ΂Ă̂ݎs\łB<br>
 * \sa criAtomPlayer_Start
 */
void CRIAPI criAtomPlayer_SetData(
	CriAtomPlayerHn player, void *buffer, CriSint32 buffer_size);

/*JP
 * \brief f[^̃Zbgit@C̎wj
 * \ingroup ATOMLIB_PLAYER
 * \param[in]	player		Atomv[[nh
 * \param[in]	binder		oC_[nh
 * \param[in]	path		t@CpX
 * \par :
 * t@CAtomv[[Ɋ֘At܂B<br>
 * {֐Ńt@CwA ::criAtomPlayer_Start ֐ōĐJnƁA
 * w肳ꂽt@CXg[~OĐ܂B<br>
 * A{֐s_ł́At@C̓ǂݍ݂͊Jn܂B<br>
 * t@C̓ǂݍ݂Jn̂́A ::criAtomPlayer_Start ֐słB<br>
 * \par :
 * \code
 * main()
 * {
 * 		:
 * 	// t@CZbg
 * 	criAtomPlayer_SetFile(player, NULL, "sample.adx");
 *
 * 	// Zbgꂽf[^Đ
 * 	criAtomPlayer_Start(player);
 * 		:
 * }
 * \endcode
 * AUZbgt@C̏́Ãf[^Zbg܂Atomv[[ɕێ
 * ܂B<br>
 * ̂߁Af[^xĐꍇɂ́AĐɃf[^ZbgȂKv
 * ͂܂B
 * \par l:
 * f[^vR[obN֐i ::CriAtomPlayerDataRequestCbFunc jŖ{֐sƁA
 * OZbg̏I[ɘAĎ̃f[^Đ܂B<br>
 * Ⴆ΁Aȉ̃R[hsƁA"sample1.adx""sample2.adx"V[X
 * AčĐ܂B<br>
 * ǐ"sample2.adx"JԂĐ܂Bj<br>
 * \code
 * // f[^vR[obN֐
 * void on_data_request(void *obj, CriAtomPlayerHn player)
 * {
 * 	// čĐt@CZbg
 * 	criAtomPlayer_SetFile(player, NULL, "sample2.adx");
 * }
 *
 * main()
 * {
 * 		:
 * 	// f[^vR[obN֐̓o^
 * 	criAtomPlayer_SetDataRequestCallback(player, on_data_request, NULL);
 *
 * 	// t@CZbg
 * 	criAtomPlayer_SetFile(player, NULL, "sample1.adx");
 *
 * 	// Zbgꂽf[^Đ
 * 	criAtomPlayer_Start(player);
 * 		:
 * }
 * \endcode
 * AibinderjɃoC_[w肷邱ƂŁA
 * CPKt@C̃RecĐ邱Ƃ\łB<br>
 * \code
 * main()
 * {
 * 		:
 * 	// CPKt@CoCh
 * 	criFsBinder_BindCpk(binder, "sample.cpk", work, work_size, &bind_id);
 *
 * 	// oCh҂
 * 	for (;;) {
 * 		// Xe[^X̃`FbN
 * 		criFsBinder_GetStatus(binder, &status);
 * 		if (status == CRIFSBINDER_STATUS_COMPLETE) {
 * 			break;
 * 		}
 *
 * 		// T[o[̎s
 * 		criFs_ExecuteMain();
 *
 * 		// Vsync҂
 * 			:
 * 	}
 * 		:
 * 	// t@CZbg
 * 	// sample.cpkcontent.adxZbg
 * 	criAtomPlayer_SetFile(player, binder, "content.adx");
 *
 * 	// Zbgꂽf[^Đ
 * 	criAtomPlayer_Start(player);
 * 		:
 * }
 * \endcode
 * f[^vR[obN֐ ::criAtomPlayer_SetData ֐s邱ƂŁA
 * t@CƃIf[^AčĐ邱Ƃ\łB
 * \attention
 * t@C̍Đsꍇɂ́AXg[~OĐɑΉ
 * Atomv[[gpKv܂B<br>
 * i ::CriAtomAdxPlayerConfig streaming_flagCRI_TRUEݒ肵
 * Atomv[[쐬Kv܂Bj<br>
 * <br>
 * {֐͒~̃v[[ɑ΂Ă̂ݎs\łB<br>
 * \sa CriAtomAdxPlayerConfig, criAtomPlayer_CreateAdxPlayer, criAtomPlayer_Start
 */
void CRIAPI criAtomPlayer_SetFile(
	CriAtomPlayerHn player, CriFsBinderHn binder, const CriChar8 *path);

/*JP
 * \brief f[^̃ZbgiCPKRecID̎wj
 * \ingroup ATOMLIB_PLAYER
 * \param[in]	player		Atomv[[nh
 * \param[in]	binder		oC_[nh
 * \param[in]	id			RecID
 * \par :
 * RecAtomv[[Ɋ֘At܂B<br>
 * CRI File SystemCugpCPKt@C̃Rect@C
 * IDwōĐ邽߂Ɏgp܂B<br>
 * {֐ɃoC_[ƃRecIDwA ::criAtomPlayer_Start ֐ōĐ
 * JnƁAw肳ꂽRect@CXg[~OĐ܂B<br>
 * A{֐s_ł́At@C̓ǂݍ݂͊Jn܂B<br>
 * t@C̓ǂݍ݂Jn̂́A ::criAtomPlayer_Start ֐słB<br>
 * \par :
 * \code
 * main()
 * {
 * 		:
 * 	// CPKt@CoCh
 * 	criFsBinder_BindCpk(binder, "sample.cpk", work, work_size, &bind_id);
 *
 * 	// oCh҂
 * 	for (;;) {
 * 		// Xe[^X̃`FbN
 * 		criFsBinder_GetStatus(binder, &status);
 * 		if (status == CRIFSBINDER_STATUS_COMPLETE) {
 * 			break;
 * 		}
 *
 * 		// T[o[̎s
 * 		criFs_ExecuteMain();
 *
 * 		// Vsync҂
 * 			:
 * 	}
 * 		:
 * 	// t@CZbg
 * 	// sample.cpk1Ԃ̃RecZbg
 * 	criAtomPlayer_SetContentId(player, binder, 1);
 *
 * 	// Zbgꂽf[^Đ
 * 	criAtomPlayer_Start(player);
 * 		:
 * }
 * \endcode
 * AUZbgt@C̏́Ãf[^Zbg܂Atomv[[ɕێ
 * ܂B<br>
 * ̂߁Af[^xĐꍇɂ́AĐɃf[^ZbgȂKv
 * ͂܂B
 * \par l:
 * f[^vR[obN֐i ::CriAtomPlayerDataRequestCbFunc jŖ{֐sƁA
 * OZbg̏I[ɘAĎ̃f[^Đ܂B<br>
 * Ⴆ΁Aȉ̃R[hsƁA1Ԃ̃f[^2Ԃ̃f[^V[X
 * AčĐ܂B<br>
 * ǐ2Ԃ̃f[^JԂĐ܂Bj<br>
 * \code
 * // f[^vR[obN֐
 * void on_data_request(void *obj, CriAtomPlayerHn player)
 * {
 * 	// oC_[̎擾
 * 	binder = (CriFsBinderHn)obj;
 *
 * 	// čĐt@CZbg
 * 	// oC_[2Ԃ̃RecZbg
 * 	criAtomPlayer_SetContentId(player, binder, 2);
 * }
 *
 * main()
 * {
 * 		:
 * 	// f[^vR[obN֐̓o^
 * 	criAtomPlayer_SetDataRequestCallback(player, on_data_request, binder);
 *
 * 	// t@CZbg
 * 	// oC_[1Ԃ̃RecZbg
 * 	criAtomPlayer_SetContentId(player, binder, 1);
 *
 * 	// Zbgꂽf[^Đ
 * 	criAtomPlayer_Start(player);
 * 		:
 * }
 * \endcode
 * f[^vR[obN֐ ::criAtomPlayer_SetData ֐s邱ƂŁA
 * t@CƃIf[^AčĐ邱Ƃ\łB
 * \attention
 * t@C̍Đsꍇɂ́AXg[~OĐɑΉ
 * Atomv[[gpKv܂B<br>
 * i ::CriAtomAdxPlayerConfig streaming_flagCRI_TRUEݒ肵
 * Atomv[[쐬Kv܂Bj<br>
 * <br>
 * {֐͒~̃v[[ɑ΂Ă̂ݎs\łB<br>
 * \sa CriAtomAdxPlayerConfig, criAtomPlayer_CreateAdxPlayer, criAtomPlayer_Start
 */
void CRIAPI criAtomPlayer_SetContentId(
	CriAtomPlayerHn player, CriFsBinderHn binder, CriSint32 id);

/*JP
 * \brief f[^̃Zbgif[^ID̎wj
 * \ingroup ATOMLIB_PLAYER
 * \param[in]	player		Atomv[[nh
 * \param[in]	awb			AWBnh
 * \param[in]	id			g`f[^ID
 * \par :
 * Đg`f[^Atomv[[Ɋ֘At܂B<br>
 * {֐AWBnhƔg`f[^IDwA ::criAtomPlayer_Start ֐ōĐ
 * JnƁAw肵g`f[^Xg[~OĐ܂B<br>
 * A{֐s_ł́At@C̓ǂݍ݂͊Jn܂B<br>
 * t@C̓ǂݍ݂Jn̂́A ::criAtomPlayer_Start ֐słB<br>
 * \par :
 * \code
 * main()
 * {
 * 		:
 * 	// AWBTOC[hAWBnh쐬
 * 	awb = criAtomAwb_LoadToc(NULL, "sample.awb", NULL, 0);
 * 		:
 * 	// g`f[^Zbg
 * 	// AWB1Ԃ̔g`f[^Zbg
 * 	criAtomPlayer_SetWaveId(player, awb, 1);
 *
 * 	// Zbgꂽf[^Đ
 * 	criAtomPlayer_Start(player);
 * 		:
 * }
 * \endcode
 * AUZbgt@C̏́Ãf[^Zbg܂Atomv[[ɕێ
 * ܂B<br>
 * ̂߁Af[^xĐꍇɂ́AĐɃf[^ZbgȂKv
 * ͂܂B
 * \par l:
 * f[^vR[obN֐i ::CriAtomPlayerDataRequestCbFunc jŖ{֐sƁA
 * OZbg̏I[ɘAĎ̃f[^Đ܂B<br>
 * Ⴆ΁Aȉ̃R[hsƁA1Ԃ̃f[^2Ԃ̃f[^V[X
 * AčĐ܂B<br>
 * ǐ2Ԃ̃f[^JԂĐ܂Bj<br>
 * \code
 * // f[^vR[obN֐
 * void on_data_request(void *obj, CriAtomPlayerHn player)
 * {
 * 	// AWBnh̎擾
 * 	awb = (CriAtomAwbHn)obj;
 *
 * 	// čĐt@CZbg
 * 	// AWB2Ԃ̔g`f[^Zbg
 * 	criAtomPlayer_SetWaveId(player, awb, 2);
 * }
 *
 * main()
 * {
 * 		:
 * 	// f[^vR[obN֐̓o^
 * 	criAtomPlayer_SetDataRequestCallback(player, on_data_request, awb);
 *
 * 	// g`f[^Zbg
 * 	// AWB1Ԃ̔g`f[^Zbg
 * 	criAtomPlayer_SetWaveId(player, awb, 1);
 *
 * 	// Zbgꂽg`f[^Đ
 * 	criAtomPlayer_Start(player);
 * 		:
 * }
 * \endcode
 * f[^vR[obN֐ ::criAtomPlayer_SetData ֐s邱ƂŁA
 * t@CƃIf[^AčĐ邱Ƃ\łB
 * \attention
 * t@C̍Đsꍇɂ́AXg[~OĐɑΉ
 * Atomv[[gpKv܂B<br>
 * i ::CriAtomAdxPlayerConfig streaming_flagCRI_TRUEݒ肵
 * Atomv[[쐬Kv܂Bj<br>
 * <br>
 * {֐͒~̃v[[ɑ΂Ă̂ݎs\łB<br>
 * \sa CriAtomAdxPlayerConfig, criAtomPlayer_CreateAdxPlayer, criAtomPlayer_Start
 */
void CRIAPI criAtomPlayer_SetWaveId(
	CriAtomPlayerHn player, CriAtomAwbHn awb, CriSint32 id);

/*JP
 * \brief ꉹf[^̍ăZbg
 * \ingroup ATOMLIB_PLAYER
 * \param[in]	player		Atomv[[nh
 * \par :
 * OĐf[^AēxĐ悤Atomv[[Ɏw܂B<br>
 * \par :
 * ȉ̏ɂAꉹf[^𖳌Ƀ[vĐ\łB<br>
 * \code
 * // f[^vR[obN֐
 * void on_data_request(void *obj, CriAtomPlayerHn player)
 * {
 * 	// OĐf[^ăZbg
 * 	criAtomPlayer_SetPreviousDataAgain(player);
 * }
 *
 * main()
 * {
 * 		:
 * 	// f[^vR[obN֐̓o^
 * 	criAtomPlayer_SetDataRequestCallback(player, on_data_request, NULL);
 *
 * 	// f[^Zbg
 * 	criAtomPlayer_SetData(player, buffer, buffer_size);
 *
 * 	// Zbgꂽf[^Đ
 * 	criAtomPlayer_Start(player);
 * 		:
 * }
 * \endcode
 * \attention
 * {֐̓f[^vR[obN֐ł̂ݎgp܂B<br>
 * if[^vR[obN֐Ołs\łȀꍇ̌ʂ܂Bj<br>
 * \sa criAtomPlayer_SetDataRequestCallback
 */
void CRIAPI criAtomPlayer_SetPreviousDataAgain(CriAtomPlayerHn player);

/*JP
 * \brief R[obN֐̍Ďsv
 * \ingroup ATOMLIB_PLAYER
 * \param[in]	player		Atomv[[nh
 * \par :
 * f[^vR[obN֐̏扄΂܂B<br>
 * f[^vR[obN֐sꂽ_ŁAɍĐ鉹f[^
 * ܂܂ĂȂꍇA{֐s邱ƂŁAR[obN֐gC
 * 邱Ƃ\ɂȂ܂B<br>
 * i~bɍēxf[^vR[obN֐Ă΂܂Bj
 * \par l:
 * f[^vR[obN֐ŉȂꍇAAtomv[[̃Xe[^X
 * CRIATOMPLAYER_STATUS_PLAYEND ɑJڂ܂B<br>
 * Af[^vR[obN֐Ŗ{֐sꍇAAtomv[[
 * Xe[^X CRIATOMPLAYER_STATUS_PLAYING ێ܂B
 * \attention
 * {֐sꍇAAtomv[[̃Xe[^X CRIATOMPLAYER_STATUS_PLAYING
 * ێ܂Ao͓͂r؂\܂B<br>
 * if[^̓ǂݍ݂ԂɍȂꍇAOĐƁAɃZbg鉹
 * Ƃ̊ԂɁA\܂Bj<br>
 * <br>
 * {֐̓f[^vR[obN֐ł̂ݎgp\łB<br>
 * if[^vR[obN֐OŎsꍇAG[܂Bj<br>
 * \sa criAtomPlayer_SetDataRequestCallback
 */
void CRIAPI criAtomPlayer_DeferCallback(CriAtomPlayerHn player);

/*JP
 * \brief Đ̊Jn
 * \ingroup ATOMLIB_PLAYER
 * \param[in]	player		Atomv[[nh
 * \par :
 * f[^̍ĐJn܂B<br>
 * {֐sOɁAO ::criAtomPlayer_SetData ֐gpAĐ
 * f[^Atomv[[ɃZbgĂKv܂B<br>
 * Ⴆ΁AỈf[^Đꍇɂ́Aȉ̂悤ɎO
 * ::criAtomPlayer_SetData ֐gĉf[^ZbgA{֐s
 * Kv܂B<br>
 * \code
 * main()
 * {
 * 		:
 * 	// f[^Zbg
 * 	criAtomPlayer_SetData(player, buffer, buffer_size);
 *
 * 	// Zbgꂽf[^Đ
 * 	criAtomPlayer_Start(player);
 * 		:
 * }
 * \endcode
 * {֐sAĐ̐i݋iJnꂽAĐjǂȂ
 * 邩́AXe[^X擾邱ƂŊmF\łB<br>
 * Xe[^X̎擾ɂ́A ::criAtomPlayer_GetStatus ֐gp܂B<br>
 * ::criAtomPlayer_GetStatus ֐͈ȉ5ʂ̃Xe[^XԂ܂B<br>
 * 	-# CRIATOMPLAYER_STATUS_STOP
 * 	-# CRIATOMPLAYER_STATUS_PREP
 * 	-# CRIATOMPLAYER_STATUS_PLAYING
 * 	-# CRIATOMPLAYER_STATUS_PLAYEND
 * 	-# CRIATOMPLAYER_STATUS_ERROR
 *
 * Atomv[[쐬_ł́AAtomv[[̃Xe[^X͒~
 * i CRIATOMPLAYER_STATUS_STOP jłB<br>
 * Đ鉹f[^ZbgA{֐s邱ƂŁAAtomv[[̃Xe[^X
 * ԁi CRIATOMPLAYER_STATUS_PREP jɕύX܂B<br>
 * iCRIATOMPLAYER_STATUS_PREP ́Af[^fR[h̊Jn҂ĂԂłBj<br>
 * Đ̊Jnɏ[ȃf[^ꂽ_ŁAAtomv[[̓Xe[^X
 * Đԁi CRIATOMPLAYER_STATUS_PLAYING jɕύXȀo͂Jn܂B<br>
 * Zbgꂽf[^SčĐIƁAAtomv[[̓Xe[^XĐI
 * i CRIATOMPLAYER_STATUS_PLAYEND jɕύX܂B<br>
 * AĐɃG[ꍇɂ́AAtomv[[̓Xe[^XG[
 * i CRIATOMPLAYER_STATUS_ERROR jɕύX܂B<br>
 * <br>
 * Atomv[[̃Xe[^X`FbNAXe[^Xɉď؂ւ邱ƂŁA
 * ̍ĐԂɘAvO쐬邱Ƃ\łB<br>
 * Ⴆ΁A̍Đ҂ďi߂ꍇɂ́Aȉ̂悤ȃR[hɂȂ܂B
 * \code
 * main()
 * {
 * 		:
 * 	// f[^Zbg
 * 	criAtomPlayer_SetData(player, buffer, buffer_size);
 *
 * 	// Zbgꂽf[^Đ
 * 	criAtomPlayer_Start(player);
 *
 * 	// Đ҂
 * 	for (;;) {
 * 		// Xe[^X̎擾
 * 		status = criAtomPlayer_GetStatus(player);
 *
 * 		// Xe[^X̃`FbN
 * 		if (status == CRIATOMPLAYER_STATUS_PLAYEND) {
 * 			// ĐI̓[v𔲂
 * 			break;
 * 		}
 *
 * 		// T[o[̎s
 * 		criAtom_ExecuteMain();
 *
 * 		// ʕ\̍XV
 * 			:
 * 	}
 * 		:
 * }
 * \endcode
 * \par l:
 * ĐJnAۂɉo͂܂łɂ́A^CO܂B<br>
 * Ĩf[^Đi ::criAtomPlayer_SetData ֐Ńf[^Zbgꍇj́A
 * {֐sAŏɃT[o[sꂽ^C~OŃXe[^X
 * CRIATOMPLAYER_STATUS_PLAYING ɑJڂ܂B<br>
 * AXg[~OĐ́AĐێ邽߂ɕKvȃf[^[obt@O
 * ܂ł̊ԁACRIATOMPLAYER_STATUS_PREP ێ܂B<br>
 * iKv[ȃf[^ꂽ_ŁA CRIATOMPLAYER_STATUS_PLAYING ɑJڂ܂Bj<br>
 * <br>
 * AXe[^X CRIATOMPLAYER_STATUS_PLAYING ɑJڂ^C~ÓA
 * ܂"TEhCuɑ΂čĐw𔭍s"^C~OɂȂ܂B<br>
 * ̂߁AۂɃXs[J[特o^C~ÓAevbgtH[̃TEh
 * CȕԂɈˑ܂B<br>
 * <br>
 * Xg[~OĐɔJn^C~ÓAɃXg[~OĐs
 * ̐AfoCX̓ǂݍݑxɂĕω܂B<br>
 * Xg[~OĐɈӐ}Ƃ^C~OŔJnꍇɂ́A
 * ::criAtomPlayer_Pause ֐ŎOɃ|[YĂAAtomv[[̃Xe[^X
 * CRIATOMPLAYER_STATUS_PLAYING ɑJڂ_ŁA|[YĂB<br>
 * i|[YԂŃXe[^X CRIATOMPLAYER_STATUS_PLAYING ɑJڂꍇA
 * |[Yŏ̃T[o[sꂽ^C~OŁAJn܂B<br>
 * <br>
 * ̓IȃR[h͈ȉ̂ƂłB<br>
 * \code
 * main()
 * {
 * 		:
 * 	// t@CZbg
 * 	criAtomPlayer_SetData(player, NULL, "sample.adx");
 *
 * 	// ĐJnOɃ|[YĂ
 * 	criAtomPlayer_Pause(player, CRI_TRUE);
 *
 * 	// Zbgꂽf[^Đ
 * 	criAtomPlayer_Start(player);
 *
 * 	// Xe[^XCRIATOMPLAYER_STATUS_PLAYINGɑJڂ̂҂
 * 	for (;;) {
 * 		// Xe[^X̎擾
 * 		status = criAtomPlayer_GetStatus(player);
 *
 * 		// Xe[^X̃`FbN
 * 		if (status == CRIATOMPLAYER_STATUS_PLAYING) {
 * 			// CRIATOMPLAYER_STATUS_PLAYINGԂɂȂ_Ń[v𔲂
 * 			break;
 * 		}
 *
 * 		// T[o[̎s
 * 		criAtom_ExecuteMain();
 *
 * 		// ʕ\̍XV
 * 			:
 * 	}
 *
 * 	// |[Ỷ
 * 	// ̃T[o[s^C~OŔJn
 * 	criAtomPlayer_Pause(player, CRI_FALSE);
 * 		:
 * }
 * \endcode
 * \attention
 * ɍĐJnAtomv[[ɑ΂Ė{֐s邱Ƃ͂ł܂B<br>
 * iADXCuƂ͈قȂAĐAtomv[[ɑ΂čēxĐ̊JnwꍇA
 * G[ɂȂ܂Bj<br>
 * Atomv[[ɑ΂čĐwꍇɂ́AKOɃXe[^X`FbNA
 * Xe[^Xi CRIATOMPLAYER_STATUS_PREP jĐi CRIATOMPLAYER_STATUS_PLAYING j
 * ɂȂĂȂƂmFB
 * \sa criAtomPlayer_SetData, criAtomPlayer_SetFile, criAtomPlayer_GetStatus,
 * criAtomPlayer_Pause, criAtom_ExecuteMain
 */
void CRIAPI criAtomPlayer_Start(CriAtomPlayerHn player);

/*JP
 * \brief Đ̒~
 * \ingroup ATOMLIB_PLAYER
 * \param[in]	player		Atomv[[nh
 * \par :
 * Đ̒~v𔭍s܂B<br>
 * ĐAtomv[[ɑ΂Ė{֐sƁAAtomv[[͍Đ~
 * it@C̓ǂݍ݂A~߂jAXe[^X~
 * i CRIATOMPLAYER_STATUS_STOP jɑJڂ܂B<br>
 * ɒ~ĂAtomv[[iXe[^X CRIATOMPLAYER_STATUS_PLAYEND 
 * CRIATOMPLAYER_STATUS_ERROR Atomv[[j ɑ΂Ė{֐sƁA
 * Atomv[[̃Xe[^X CRIATOMPLAYER_STATUS_STOP ɕύX܂B
 * \attention
 * ĐAtomv[[ɑ΂Ė{֐sꍇAXe[^X
 * CRIATOMPLAYER_STATUS_STOP ɂȂƂ͌܂B<br>
 * i~ԂɂȂ܂łɁAԂꍇ܂Bj<br>
 * ̂߁A{֐ōĐ~Aĕʂ̉f[^Đꍇɂ́A
 * KXe[^X CRIATOMPLAYER_STATUS_STOP ɑJڂƂmFĂ
 * ̃f[^Zbgi܂͍Đ̊JnjsĂB<br>
 * <br>
 * \code
 * main()
 * {
 * 		:
 * 	// Đ̒~v
 * 	criAtomPlayer_Stop(player);
 *
 * 	// Xe[^XCRIATOMPLAYER_STATUS_STOPɑJڂ̂҂
 * 	for (;;) {
 * 		// Xe[^X̎擾
 * 		status = criAtomPlayer_GetStatus(player);
 *
 * 		// Xe[^X̃`FbN
 * 		if (status == CRIATOMPLAYER_STATUS_STOP) {
 * 			// CRIATOMPLAYER_STATUS_STOPԂɂȂ_Ń[v𔲂
 * 			break;
 * 		}
 *
 * 		// T[o[̎s
 * 		criAtom_ExecuteMain();
 *
 * 		// ʕ\̍XV
 * 			:
 * 	}
 *
 * 	// ʂ̉t@CZbg
 * 	criAtomPlayer_SetData(player, NULL, "sample.adx");
 *
 * 	// Zbgꂽf[^Đ
 * 	criAtomPlayer_Start(player);
 * 		:
 * }
 * \endcode
 * \sa criAtomPlayer_Start, criAtomPlayer_GetStatus
 */
void CRIAPI criAtomPlayer_Stop(CriAtomPlayerHn player);

/*JP
 * \brief Đ̃|[Y^|[Y
 * \ingroup ATOMLIB_PLAYER
 * \param[in]	player		Atomv[[nh
 * \param[in]	flag		tOiCRI_TRUE = |[YACRI_FALSE = |[Yj
 * \par :
 * Đ|[Yiꎞ~jA|[Y܂B<br>
 * |[Y邩A|[Y邩́AflagŎw肵܂B<br>
 * flagCRI_TRUEw肵ꍇAĐ̓|[Y܂B<br>
 * flagCRI_FALSEw肵ꍇA|[Y܂B<br>
 * Atomv[[|[YĂ邩ǂ ::criAtomPlayer_IsPaused ֐gp
 * ƂŊmF\łB<br>
 * <br>
 * {֐͎Ɉȉ2ʂ̗prɗp܂B<br>
 * 	- o͂̈ꎞ~^ꎞ~B
 * 	- Xg[~OĐ̓oB
 *
 * <br>
 * yo͂̈ꎞ~^ꎞ~ɂāz
 * ĐAtomv[[ɑ΂ă|[YsƁA̎_ŉ̏o͂𒆒f܂B<br>
 * |[YꂽAtomv[[ɑ΂ă|[YsƁA|[Yɒfꂽӏ
 * ĐĊJ܂B<br>
 * <br>
 * yXg[~OĐ̓oɂāz
 * |[Y͍ĐJnOAtomv[[ɑ΂ĂLłB<br>
 * ĐJnOAtomv[[ɑ΂ă|[YꍇA|[YꂽAtomv[[
 * ::criAtomPlayer_Start ֐ōĐwĂȀo͍͂s܂B<br>
 * AĐ͍s邽߁Af[^[ɋĂ΁AXe[^X
 * CRIATOMPLAYER_STATUS_PLAYING ܂őJڂ܂B<br>
 * <br>
 * Xe[^X CRIATOMPLAYER_STATUS_PLAYING ̏ԂŃ|[YĂAtomv[[
 * ɂẮA|[Ys^C~OŔJn邱Ƃ\łB<br>
 * ̂߁Aȉ̏菇𓥂ނƂŁAXg[~OĐ̔^C~O
 * ̃ANVɓ邱Ƃ\łB<br>
 * 	-# ::criAtomPlayer_Pause ֐Atomv[[|[YB
 * 	-# ::criAtomPlayer_Start ֐Atomv[[ɍĐJnwB
 * 	-# Atomv[[̃Xe[^X CRIATOMPLAYER_STATUS_PLAYING ɂȂ̂҂B
 * 	-# Jn^C~O ::criAtomPlayer_Pause ֐sA|[YB
 *
 * <br>
 * ̓IȃR[h͈ȉ̂ƂłB<br>
 * \code
 * main()
 * {
 * 		:
 * 	// t@CZbg
 * 	criAtomPlayer_SetData(player, NULL, "sample.adx");
 *
 * 	// ĐJnOɃ|[YĂ
 * 	criAtomPlayer_Pause(player, CRI_TRUE);
 *
 * 	// Zbgꂽf[^Đ
 * 	criAtomPlayer_Start(player);
 *
 * 	// Xe[^XCRIATOMPLAYER_STATUS_PLAYINGɑJڂ̂҂
 * 	for (;;) {
 * 		// Xe[^X̎擾
 * 		status = criAtomPlayer_GetStatus(player);
 *
 * 		// Xe[^X̃`FbN
 * 		if (status == CRIATOMPLAYER_STATUS_PLAYING) {
 * 			// CRIATOMPLAYER_STATUS_PLAYINGԂɂȂ_Ń[v𔲂
 * 			break;
 * 		}
 *
 * 		// T[o[̎s
 * 		criAtom_ExecuteMain();
 *
 * 		// ʕ\̍XV
 * 			:
 * 	}
 *
 * 	// |[Ỷ
 * 	// ̃T[o[s^C~OŔJn
 * 	criAtomPlayer_Pause(player, CRI_FALSE);
 * 		:
 * }
 * \endcode
 * \par l:
 * ɂ́A ::criAtomPlayer_Pause ֐sAŏɃT[o[삵_
 * |[Ys܂B<br>
 * ̂߁AT[o[sOɃ|[Y˃|[Y̑sƁA
 * ~܂邱ƂȂĐiތ`ɂȂ܂B
 * <br>
 * A|[YꂽAtomv[[ɑ΂čēx|[YsA|[YĂȂ
 * Atomv[[ɑ΂ă|[YsĂAG[͔܂B<br>
 * iꂸɊ֐𔲂܂Bj
 * \sa criAtomPlayer_IsPaused, criAtomPlayer_Start
 */
void CRIAPI criAtomPlayer_Pause(CriAtomPlayerHn player, CriBool flag);

/*JP
 * \brief |[YĂ邩ǂ̃`FbN
 * \ingroup ATOMLIB_PLAYER
 * \param[in]	player		Atomv[[nh
 * \return		CriBool		|[YԁiCRI_TRUE = |[YĂACRI_FALSE = |[YĂȂj
 * \par :
 * Atomv[[|[YĂ邩ǂ`FbN܂B<br>
 * |[YĂ邩ǂ́A߂lŔ肵܂B<br>
 * ߂lCRI_TRUEꍇAAtomv[[̓|[YĂ܂B<br>
 * ߂lCRI_FALSEꍇAAtomv[[̓|[YĂ܂B<br>
 * \par l:
 * {֐ ::criAtomPlayer_Pause ֐Ŏw肳ꂽtÔ܂ܕԂ܂B<br>
 * i ::criAtomPlayer_Pause ֐̑2ɃZbglflagƂĕԂ܂Bj<br>
 * ̂߁A{֐̌ʂƎۂɉo͂~Ă邩ǂ́AKvƂ
 * ܂B<br>
 * i ::criAtomPlayer_Pause ֐̎s^C~OƁAۂɉo͂~^C~O
 * ^CO݂邽߁Bj
 * \sa criAtomPlayer_Pause
 */
CriBool CRIAPI criAtomPlayer_IsPaused(CriAtomPlayerHn player);

/*JP
 * \brief Xe[^X̎擾
 * \ingroup ATOMLIB_PLAYER
 * \param[in]	player		Atomv[[nh
 * \return		CriAtomPlayerStatus	Xe[^X
 * \par :
 * Atomv[[̃Xe[^X擾܂B<br>
 * Xe[^XAtomv[[̍ĐԂlŁAȉ5ʂ̒l݂܂B<br>
 * -# CRIATOMPLAYER_STATUS_STOP
 * -# CRIATOMPLAYER_STATUS_PREP
 * -# CRIATOMPLAYER_STATUS_PLAYING
 * -# CRIATOMPLAYER_STATUS_PLAYEND
 * -# CRIATOMPLAYER_STATUS_ERROR
 *
 * Atomv[[쐬_ł́AAtomv[[̃Xe[^X͒~
 * i ::CRIATOMPLAYER_STATUS_STOP jłB<br>
 * Đ鉹f[^ZbgA::criAtomPlayer_Start ֐s邱ƂŁA
 * Atomv[[̃Xe[^Xԁi ::CRIATOMPLAYER_STATUS_PREP jɕύX܂B<br>
 * i ::CRIATOMPLAYER_STATUS_PREP ́Af[^fR[h̊Jn҂ĂԂłBj<br>
 * Đ̊Jnɏ[ȃf[^ꂽ_ŁAAtomv[[̓Xe[^X
 * Đԁi ::CRIATOMPLAYER_STATUS_PLAYING jɕύXȀo͂Jn܂B<br>
 * Zbgꂽf[^SčĐIƁAAtomv[[̓Xe[^XĐI
 * i ::CRIATOMPLAYER_STATUS_PLAYEND jɕύX܂B<br>
 * AĐɃG[ꍇɂ́AAtomv[[̓Xe[^XG[
 * i ::CRIATOMPLAYER_STATUS_ERROR jɕύX܂B<br>
 * <br>
 * Atomv[[̃Xe[^X`FbNAXe[^Xɉď؂ւ邱ƂŁA
 * ̍ĐԂɘAvO쐬邱Ƃ\łB<br>
 * Ⴆ΁A̍Đ҂ďi߂ꍇɂ́Aȉ̂悤ȃR[hɂȂ܂B
 * \code
 * main()
 * {
 * 		:
 * 	// f[^Zbg
 * 	criAtomPlayer_SetData(player, buffer, buffer_size);
 *
 * 	// Zbgꂽf[^Đ
 * 	criAtomPlayer_Start(player);
 *
 * 	// Đ҂
 * 	for (;;) {
 * 		// Xe[^X̎擾
 * 		status = criAtomPlayer_GetStatus(player);
 *
 * 		// Xe[^X̃`FbN
 * 		if (status == CRIATOMPLAYER_STATUS_PLAYEND) {
 * 			// ĐI̓[v𔲂
 * 			break;
 * 		}
 *
 * 		// T[o[̎s
 * 		criAtom_ExecuteMain();
 *
 * 		// ʕ\̍XV
 * 			:
 * 	}
 * 		:
 * }
 * \endcode
 * \par l:
 * foCX̃f[^ǂݍ݂ɎsꍇAf[^G[ꍇ
 * isȃf[^ǂݍ񂾏ꍇjAAtomv[[̃Xe[^X̓G[ԂɂȂ܂B<br>
 * f[^ǂݍ݃G[ɃAvP[VŃG[bZ[W\ꍇɂ́A
 * Xe[^X CRIATOMPLAYER_STATUS_ERROR ɂȂĂȂǂ`FbNA
 * KXG[bZ[W̕\sĂB<br>
 * \code
 * main()
 * {
 * 		:
 * 	// Xe[^X̎擾
 * 	status = criAtomPlayer_GetStatus(player);
 *
 * 	// Xe[^X̃`FbN
 * 	if (status == CRIATOMPLAYER_STATUS_ERROR) {
 * 		// CRIATOMPLAYER_STATUS_ERRORɂȂ_ŃG[bZ[W\
 * 			:
 * 	}
 * 		:
 * }
 * \endcode
 * \sa criAtomPlayer_Start
 */
CriAtomPlayerStatus CRIAPI criAtomPlayer_GetStatus(CriAtomPlayerHn player);

/*JP
 * \brief `l̎擾
 * \ingroup ATOMLIB_PLAYER
 * \param[in]	player		Atomv[[nh
 * \return		CriSint32	`l
 * \par :
 * Atomv[[ōĐ̉ɂāA`l擾܂B<br>
 * <br>
 * `l擾łȂꍇA{֐ -1 Ԃ܂B<br>
 * \attention
 * Đ́Av[[̃Xe[^X ::CRIATOMPLAYER_STATUS_PLAYING
 * ɂȂ܂Ŏ擾ł܂B<br>
 * i ::CRIATOMPLAYER_STATUS_PREP ɖ{֐sꍇAG[lԂ܂Bj<br>
 */
CriSint32 CRIAPI criAtomPlayer_GetNumChannels(CriAtomPlayerHn player);

/*JP
 * \brief Đς݃Tv̎擾
 * \ingroup ATOMLIB_PLAYER
 * \param[in]	player			Atomv[[nh
 * \param[out]	num_played		Đς݃TviTvPʁj
 * \param[out]	sampling_rate	TvO[giHzPʁj
 * \return		CriBool			Tv擾łǂi CRI_TRUE = 擾łA CRI_FALSE = 擾łȂj
 * \par :
 * Atomv[[ōĐ̉ɂāAĐς݂̃TvA
 * уTvO[g擾܂B<br>
 * Đ̓TvPʁATvO[gHzPʂłB<br>
 * <br>
 * Tv擾łꍇA߂l CRI_TRUE ɂȂ܂B<br>
 * Đς݃Tv擾łȂꍇA߂l CRI_FALSE ɂȂ܂B<br>
 * iɁA sampling_rate  -1 ɂȂ܂Bj<br>
 * \par l
 * 擾Kv̂ȂɂẮA NULL w\łB<br>
 * Ⴆ΁ATvO[ĝ݂擾ꍇA2i num_played j
 * ɂ NULL w\łB
 * <br>
 * {֐ԂĐς݃Tv́Ao͍ς݉f[^̗ݐϒlłB<br>
 * ̂߁A[vĐAV[XAĐsꍇłA
 * ĐʒuɉăTv߂邱Ƃ͂܂B<br>
 * ܂A ::criAtomPlayer_Pause ֐Ń|[YꍇA
 * Đς݃TṽJEgAbv~܂B<br>
 * i|[Y΃JEgAbvĊJ܂Bj
 * \attention
 * Đς݃Tv́Av[[̃Xe[^X ::CRIATOMPLAYER_STATUS_PLAYING
 * ɂȂ܂Ŏ擾ł܂B<br>
 * i ::CRIATOMPLAYER_STATUS_PREP ɖ{֐sꍇAG[lԂ܂Bj<br>
 * <br>
 * ĐTv̐x́AvbgtH[̃TEhCuɈˑ܂B
 */
CriBool CRIAPI criAtomPlayer_GetNumPlayedSamples(
	CriAtomPlayerHn player, CriSint64 *num_played, CriSint32 *sampling_rate);

/*JP
 * \brief TEhobt@ւ̏݃Tv̎擾
 * \ingroup ATOMLIB_PLAYER
 * \param[in]	player			Atomv[nh
 * \param[out]	num_rendered	ݍς݃TviTvPʁj
 * \param[out]	sampling_rate	TvO[giHzPʁj
 * \return		CriBool			Tv擾łǂi CRI_TRUE = 擾łA CRI_FALSE = 擾łȂj
 * \par :
 * Atomv[ōĐ̉ɂāATEhobt@ւ̏ݍς݂̃TvA
 * уTvO[g擾܂B<br>
 * ::criAtomPlayer_GetNumPlayedSamples ֐ƈقȂA
 * TEhobt@ɏ܂ꂽo͂̉f[^̃Tv܂ޒlԂ܂B
 * <br>
 * Tv擾łꍇA߂l CRI_TRUE ɂȂ܂B<br>
 * ݍς݃Tv擾łȂꍇA߂l CRI_FALSE ɂȂ܂B<br>
 * iɁA sampling_rate  -1 ɂȂ܂Bj<br>
 * \par l
 * 擾Kv̂ȂɂẮA NULL w\łB<br>
 * Ⴆ΁ATvO[ĝ݂擾ꍇA2i num_rendered j
 * ɂ NULL w\łB
 * <br>
 * {֐ԂTv́Aݍς݃Tv̗ݐϒlłB<br>
 * ̂߁A[vĐV[XAĐsꍇłA
 * ĐʒuɉăTv߂邱Ƃ͂܂B<br>
 * ܂A ::criAtomPlayer_Pause ֐Ń|[YꍇA
 * ݍς݃TṽJEgAbv~܂B<br>
 * i|[Y΃JEgAbvĊJ܂Bj
 * \attention
 * ݍς݃Tv́Av[̃Xe[^X ::CRIATOMPLAYER_STATUS_PLAYING
 * ɂȂ܂Ŏ擾ł܂B<br>
 * i ::CRIATOMPLAYER_STATUS_PREP ɖ{֐sꍇAG[lԂ܂Bj<br>
 * <br>
 * ݍς݃Tv̐x́AvbgtH[̃TEhCuɈˑ܂B
 * \sa criAtomPlayer_GetNumPlayedSamples
 */
CriBool CRIAPI criAtomPlayer_GetNumRenderedSamples(
	CriAtomPlayerHn player, CriSint64 *num_rendered, CriSint32 *sampling_rate);

/*JP
 * \brief fR[hf[^TCY̎擾
 * \ingroup ATOMLIB_PLAYER
 * \param[in]	player			Atomv[[nh
 * \return		CriSint64		fR[hf[^ʁiPʂ̓oCgj
 * \par :
 * Atomv[[ŃfR[hf[^̃oCgԂ܂B<br>
 * \par l
 * {֐ԂfR[hʂ́AĐJn_̗ݐϒlłB<br>
 * ̂߁A[vĐAV[XAĐsꍇłA
 * ĐʒuɉăfR[hʂ߂邱Ƃ͂܂B<br>
 * ܂A ::criAtomPlayer_Pause ֐Ń|[YꍇA
 * fR[hʂ̃JEgAbv~܂B<br>
 * i|[Y΃JEgAbvĊJ܂Bj
 * \attention
 * HCA-MXgpꍇAkꂽf[^𒼐ڃn[hEFAɑMvbgtH[
 * ifR[hvbgtH[SDKɉBĂR[fbNj
 * ɂẮA{֐ŃfR[hʂ擾ł܂B<br>
 */
CriSint64 CRIAPI criAtomPlayer_GetDecodedDataSize(CriAtomPlayerHn player);

/*JP
 * \brief fR[hTv̎擾
 * \ingroup ATOMLIB_PLAYER
 * \param[in]	player			Atomv[[nh
 * \return		CriSint64		fR[hTv
 * \par :
 * Atomv[[ŃfR[hf[^̃oCgԂ܂B<br>
 * \par l
 * {֐ԂfR[hTv́AĐJn_̗ݐϒlłB<br>
 * ̂߁A[vĐAV[XAĐsꍇłA
 * ĐʒuɉăfR[hTv߂邱Ƃ͂܂B<br>
 * ܂A ::criAtomPlayer_Pause ֐Ń|[YꍇA
 * fR[hTṽJEgAbv~܂B<br>
 * i|[Y΃JEgAbvĊJ܂Bj
 * \attention
 * HCA-MXgpꍇAkꂽf[^𒼐ڃn[hEFAɑMvbgtH[
 * ifR[hvbgtH[SDKɉBĂR[fbNj
 * ɂẮA{֐ŃfR[hTv擾ł܂B<br>
 */
CriSint64 CRIAPI criAtomPlayer_GetNumDecodedSamples(CriAtomPlayerHn player);

/*JP
 * \brief Đ̎擾
 * \ingroup ATOMLIB_PLAYER
 * \param[in]	player		Atomv[[nh
 * \return		CriSint64	Đi~bPʁj
 * \par :
 * Atomv[[ōĐ̉ɂāA݂̍Đ擾܂B<br>
 * Đ̒Pʂ̓~bPʂłB<br>
 * <br>
 * Ɍ肪ꍇi player  NULL ̏ꍇjA{֐ -1 Ԃ܂B<br>
 * ~ĐAĐ擾łȂ^C~OŖ{֐sꍇA
 * {֐ 0 Ԃ܂B<br>
 * \par l
 * Đ͍Đς݃TvɌvZĂ܂B<br>
 * ̂߁A ::criAtomPlayer_SetFrequencyRatio ֐păsb`グꍇA
 * Đ͎Ԃi݂܂B<br>
 * isb`ꍇAĐ͎xi݂܂Bj<br>
 * <br>
 * {֐ԂĐ́Ao͍ς݉f[^̗ݐϒlłB<br>
 * ̂߁A[vĐAV[XAĐsꍇłA
 * ĐʒuɉĎ߂邱Ƃ͂܂B<br>
 * ܂A ::criAtomPlayer_Pause ֐Ń|[YꍇA
 * Đ̃JEgAbv~܂B<br>
 * i|[Y΃JEgAbvĊJ܂Bj
 * \attention
 * Đ́Av[[̃Xe[^X ::CRIATOMPLAYER_STATUS_PLAYING
 * ɂȂ܂Ŏ擾ł܂B<br>
 * i ::CRIATOMPLAYER_STATUS_PREP ɖ{֐sꍇA 0 Ԃ܂Bj<br>
 * <br>
 * Đ̐x́AvbgtH[̃TEhCuɈˑ܂B
 * \sa criAtomPlayer_GetStatus, criAtomPlayer_SetFrequencyRatio
 */
CriSint64 CRIAPI criAtomPlayer_GetTime(CriAtomPlayerHn player);

/*JP
 * \brief Đ̃tH[}bg̎擾
 * \ingroup ATOMLIB_PLAYER
 * \param[in]	player		Atomv[[nh
 * \param[out]	info		tH[}bg
 * \return		CriBool		񂪎擾łǂi CRI_TRUE = 擾łA CRI_FALSE = 擾łȂj
 * \par :
 * ::criAtomPlayer_Start ֐ōĐꂽ̃tH[}bg擾܂B<br>
 * <br>
 * tH[}bg񂪎擾łꍇA{֐ CRI_TRUE Ԃ܂B<br>
 * tH[}bg񂪎擾łȂꍇA{֐ CRI_FALSE Ԃ܂B<br>
 * \attention
 * {֐́AĐ̂݃tH[}bg擾\łB<br>
 * ĐJnOĐɖ{֐sƁAtH[}bg̎擾Ɏs܂B<br>
 * \sa criAtomPlayer_Start, criAtomPlayer_GetStatus
 */
CriBool CRIAPI criAtomPlayer_GetFormatInfo(
	CriAtomPlayerHn player, CriAtomFormatInfo *info);

/*JP
 * \brief ̓obt@[f[^cʂ̎擾
 * \ingroup ATOMLIB_PLAYER
 * \param[in]	player		Atomv[[nh
 * \return		CriSint32	̓obt@[̃f[^cʁiBytePʁj
 * \par :
 * Atomv[[̓̓obt@[̃f[^cʂ擾܂B<br>
 * \par l:
 * {֐͏擾prɂ݂̂ɗp\ȃfobO֐łB<br>
 * <br>
 * r؂̕sہA{֐gpčĐ̃v[[
 * ̓obt@[Ƀf[^cĂ邩ǂ`FbN\łB<br>
 * v[[̃Xe[^X ::CRIATOMPLAYER_STATUS_PLAYING ɂ炸A
 * f[^cʂ 0 ̏ꍇA炩ُ̈ɂf[^̋
 * ubNĂ\܂B<br>
 */
CriSint32 CRIAPI criAtomPlayer_GetInputBufferRemainSize(CriAtomPlayerHn player);

/*JP
 * \brief o̓obt@[f[^cʂ̎擾
 * \ingroup ATOMLIB_PLAYER
 * \param[in]	player		Atomv[[nh
 * \return		CriSint32	o̓obt@[̃f[^cʁiTvPʁj
 * \par :
 * Atomv[[̏o̓obt@[̃f[^cʂ擾܂B<br>
 * \par l:
 * {֐͏擾prɂ݂̂ɗp\ȃfobO֐łB<br>
 * <br>
 * r؂̕sہA{֐gpčĐ̃v[[
 * o̓obt@[Ƀf[^cĂ邩ǂ`FbN\łB<br>
 * v[[̃Xe[^X ::CRIATOMPLAYER_STATUS_PLAYING ɂ炸A
 * f[^cʂ 0 ̏ꍇA炩ُ̈ɂfR[h
 * sĂȂ\܂B<br>
 * \attention
 * {֐́Af[^AtomCuŃfR[hP[XɂĂ̂ݗLłB<br>
 * kꂽf[^𒼐ڃn[hEFAɑMvbgtH[
 * ifR[hvbgtH[SDKɉBĂR[fbNj
 * ɂẮA{֐Ńf[^cʂ擾ł܂B<br>
 */
CriSint32 CRIAPI criAtomPlayer_GetOutputBufferRemainSamples(CriAtomPlayerHn player);

/*JP
 * \brief ĐJnʒu̎w
 * \ingroup ATOMLIB_PLAYER
 * \param[in]	player		Atomv[[nh
 * \param[in]	start_time_ms	ĐJnʒui~bwj
 * \par :
 * Atomv[[ōĐ鉹ɂāAĐJnʒuw肵܂B<br>
 * f[^rĐꍇAĐJnOɖ{֐ōĐJnʒu
 * w肷Kv܂B<br>
 * <br>
 * ĐJnʒu̎w̓~bPʂōs܂B<br>
 * Ⴆ΁A start_time_ms  10000 ZbgĖ{֐sƁA
 * ɍĐ鉹f[^ 10 bڂ̈ʒuĐ܂B
 * \par l
 * {֐ōĐʒuw肵ꍇłAw肵҂̈ʒuĐ
 * JnƂ͌܂B<br>
 * igp鉹R[fbNɂẮAw莞̏OĐJn܂Bj<br>
 * <br>
 * f[^r̍Đ́Af[^擪̍ĐɔׁAJn
 * ^C~OxȂ܂B<br>
 * ́AUf[^̃wb_[͌AwʒuɃWvĂf[^ǂ
 * čĐJn邽߂łB
 * \attention
 * start_time_ms ɂ64bitlZbg\łAA32bitȏ̍Đ
 * w肷邱Ƃ͂ł܂B<br>
 * <br>
 * Đɖ{֐sĂAĐ̉̍Đʒu͕ύX܂B<br>
 * {֐Őݒ肵ĺA ::criAtomPlayer_Start ֐ŉ̍ĐJn
 * ^C~Oł̂ݎQƂ܂B<br>
 * <br>
 * @ŗL̉tH[}bgɂĂAĐJnʒuwłȂꍇ܂B<br>
 * <br>
 * \sa criAtomPlayer_Start
 */
void CRIAPI criAtomPlayer_SetStartTime(CriAtomPlayerHn player, CriSint64 start_time_ms);

/*JP
 * \brief {[̎w
 * \ingroup ATOMLIB_PLAYER
 * \param[in]	player		Atomv[[nh
 * \param[in]	vol			{[l
 * \par :
 * õ͉{[w肵܂B<br>
 * {֐gp邱ƂŁAAtomv[[ōĐ鉹̃{[R
 * ύX\łB<br>
 * <br>
 * {[l͉f[^̐Uɑ΂{łiPʂ̓fVxł͂܂jB<br>
 * Ⴆ΁A1.0fw肵ꍇA͂̂܂܂̃{[ŏo͂܂B<br>
 * 0.5fw肵ꍇAg`̐U𔼕ɂf[^Ɠʁi-6dBj
 * o͂܂B<br>
 * 0.0fw肵ꍇA̓~[g܂iɂȂ܂jB
 * \l:
 * {[lɂ0.0fȏ̒lݒ\łB<br>
 * iAtomCu Ver.1.21.07A
 * {[l1.0f𒴂lwł悤ɂȂ܂Bj<br>
 * 1.0f𒴂lZbgꍇA<b>vbgtH[ɂĂ</b>A
 * g`f[^fނ傫ȉʂōĐ\łB<br>
 * {[lɕlw肵ꍇAl0.0fɃNbv܂B<br>
 * ig`f[^̈ʑ]邱Ƃ͂܂Bj<br>
 * <br>
 * {֐̐ݒlƁAȉ̊֐̃{[ݒl͓ƗĐ䂳܂B<br>
 * 	- ::criAtomPlayer_SetChannelVolume
 * 	- ::criAtomPlayer_SetSendLevel
 *
 * Ⴆ΁A{֐0.5fA ::criAtomPlayer_SetChannelVolume
 * ֐ɂ0.5fݒ肵ꍇA
 * õ͉{[͌0.25f{{[ŏo͂܂B<br>
 * i0.5f~0.5f0.25f̉Zs܂Bj<br>
 * \attention
 * 1.0f𒴂{[w肷ꍇAȉ̓_ɒӂKv܂B<br>
 *  - vbgtH[ƂɋقȂ\B
 *  - ꂪ\B
 *
 * <br>
 * {֐1.0f𒴂{[lݒ肵ꍇłA
 * ̔g`f[^傫ȉʂōĐ邩ǂ́A
 * vbgtH[≹kR[fbN̎ʂɂĈقȂ܂B<br>
 * ̂߁A}`vbgtH[^CgŃ{[𒲐ꍇɂ́A
 * 1.0f𒴂{[lgpȂƂ߂܂B<br>
 * i1.0f𒴂{[lw肵ꍇAg`f[^ĐꍇłA
 * @킲ƂɈقȂ鉹ʂŏo͂\܂Bj<br>
 * <br>
 * ܂Aʂグ邱Ƃ\ȋ@łĂA
 * n[hEFAŏo͉\ȉʂɂ͏邽߁A
 * ɂmCY\܂B<br>
 * \sa criAtomPlayer_GetVolume
 */
void CRIAPI criAtomPlayer_SetVolume(CriAtomPlayerHn player, CriFloat32 vol);

/*JP
 * \brief {[̎w
 * \ingroup ATOMLIB_PLAYER
 * \param[in]	player		Atomv[[nh
 * \return		CriFloat32	{[l
 * \par :
 * õ͉{[擾܂B<br>
 * {[l͉f[^̐Uɑ΂{łiPʂ̓fVxł͂܂jB<br>
 * \sa criAtomPlayer_SetVolume
 */
CriFloat32 CRIAPI criAtomPlayer_GetVolume(CriAtomPlayerHn player);

/*JP
 * \brief `lPʂ̃{[w
 * \ingroup ATOMLIB_PLAYER
 * \param[in]	player		Atomv[[nh
 * \param[in]	ch			`lԍ
 * \param[in]	vol			{[li0.0f`1.0fj
 * \par :
 * õ͉{[`lPʂŎw肵܂B<br>
 * {֐gp邱ƂŁAAtomv[[ōĐ鉹̃{[A
 * `lPʂŎRɕύX\łB<br>
 * <br>
 * 2̃`lԍ"f[^̃`lԍ"w肵܂B<br>
 * io̓Xs[J[IDł͂܂Bj<br>
 * Ⴆ΁Am0Ԃ̃{[ύXꍇA
 * Xs[J[o͂鉹̃{[SĂύX܂B<br>
 * i ::criAtomPlayer_SetVolume ֐ŝƓ܂Bj<br>
 * ɑ΂AXeI0Ԃ̃{[ύXƁAftHgݒ
 * ł̓tgXs[J[o͂鉹̃{[݂̂ύX܂B<br>
 * i ::criAtomPlayer_SetSendLevel ֐𕹗pĂꍇ́A
 * KtgXs[J[o͂鉹ʂ̃{[ύX
 * Ƃ͌܂Bj<br>
 * <br>
 * {[lɂ́A0.0f`1.0f͈̔͂Ŏlw肵܂B<br>
 * {[l͉f[^̐Uɑ΂{łiPʂ̓fVxł͂܂jB<br>
 * Ⴆ΁A1.0fw肵ꍇA͂̂܂܂̃{[ŏo͂܂B<br>
 * 0.5fw肵ꍇAg`̐U𔼕ɂf[^Ɠʁi-6dBj
 * o͂܂B<br>
 * 0.0fw肵ꍇA̓~[g܂iɂȂ܂jB
 * \l:
 * {[l1.0f𒴂lw肵ꍇAl1.0fɃNbv܂B<br>
 * i傫ȉʂŉĐ邱Ƃ͂܂Bj<br>
 * lɁA{[l0.0f̒lw肵ꍇAl0.0fɃNbv܂B<br>
 * iʑ]邱Ƃ͂܂Bj
 * <br>
 * {֐̐ݒlƁAȉ̊֐̃{[ݒl͓ƗĐ䂳܂B<br>
 * 	- ::criAtomPlayer_SetVolume
 * 	- ::criAtomPlayer_SetSendLevel
 * Ⴆ΁A{֐0.5fA ::criAtomPlayer_SetVolume ֐ɂ0.5fݒ肵ꍇA
 * õ͉{[͌0.25f{{[ŏo͂܂B<br>
 * i0.5f~0.5f0.25f̉Zs܂Bj
 * \sa criAtomPlayer_SetVolume, criAtomPlayer_SetSendLevel, criAtomPlayer_SetPanAdx1Compatible
 */
void CRIAPI criAtomPlayer_SetChannelVolume(
	CriAtomPlayerHn player, CriSint32 ch, CriFloat32 vol);

/*JP
 * \brief Zhx̐ݒ
 * \ingroup ATOMLIB_PLAYER
 * \param[in]	player		Atomv[[nh
 * \param[in]	ch			`lԍ
 * \param[in]	spk			Xs[J[ID
 * \param[in]	level		{[li0.0f`1.0fj
 * \par :
 * Zhxw肵܂B<br>
 * Zhx́Af[^̊e`l̉Aǂ̃Xs[J[
 * ǂ̒x̉ʂŏo͂邩w肷邽߂̎dg݂łB<br>
 * <br>
 * 2̃`lԍ"f[^̃`lԍ"w肵܂B<br>
 * 3̃Xs[J[IDɂ́Aw肵`lԍ̃f[^ǂ̃Xs[J[
 * o͂邩w肵A4̑M̃{[w肵܂B<br>
 * {[ĺA0.0f`1.0f͈̔͂Ŏlw肵܂B<br>
 * {[l͉f[^̐Uɑ΂{łiPʂ̓fVxł͂܂jB<br>
 * Ⴆ΁A1.0fw肵ꍇA͂̂܂܂̃{[ŏo͂܂B<br>
 * 0.5fw肵ꍇAg`̐U𔼕ɂf[^Ɠʁi-6dBj
 * o͂܂B<br>
 * 0.0fw肵ꍇA̓~[g܂iɂȂ܂jB
 * <br>
 * Ⴆ΁Af[^̃`l0Ԃ̃f[^CgXs[J[
 * t{[i1.0fjŏo͂ꍇAw͈ȉ̂悤ɂȂ܂B
 * \code
 * criAtomPlayer_SetSendLevel(player, 0, CRIATOM_SPEAKER_FRONT_RIGHT, 1.0f);
 * \endcode
 * `lPʂ̃{[wi ::criAtomPlayer_SetChannelVolume ֐j
 * ƈقȂA{֐ł1̃`l̃f[^𕡐̃Xs[J[قȂ
 * {[ŏo͂邱Ƃ\łB<br>
 * Ⴆ΁A`l1Ԃ̉tgXs[J[0.3fACgXs[J[
 * 0.5fAZ^[Xs[J[0.7fŏo͂ꍇAw͈ȉ̂悤ɂȂ܂B
 * \code
 * criAtomPlayer_SetSendLevel(player, 1, CRIATOM_SPEAKER_FRONT_LEFT, 0.3f);
 * criAtomPlayer_SetSendLevel(player, 1, CRIATOM_SPEAKER_FRONT_RIGHT, 0.5f);
 * criAtomPlayer_SetSendLevel(player, 1, CRIATOM_SPEAKER_FRONT_CENTER, 0.7f);
 * \endcode
 * AZbgꂽZhx̒l ::criAtomPlayer_ResetSendLevel ֐
 * Zbg邱Ƃ\łB<br>
 * \l:
 * Zhx̐ݒɂ́uݒvu蓮ݒv2ʂ肪݂܂B<br>
 * Atomv[[쐬A ::criAtomPlayer_ResetSendLevel ֐
 * ZhxNAꍇAZhx̐ݒ́uݒvƂȂ܂B<br>
 * {֐sꍇAZhx̐ݒ́u蓮ݒvƂȂ܂B<br>
 * <br>
 * uݒv̏ꍇAAtomv[[͈ȉ̂悤ɉ[eBO܂B<br>
 * <br>
 * ymĐꍇz<br>
 * `l0̉ẼXs[J[0.7fi-3dBj̃{[ŏo͂܂B<br>
 * <br>
 * yXeIĐꍇz<br>
 * `l0̉tgXs[J[A
 * `l1̉CgXs[J[o͂܂B<br>
 * <br>
 * y4chĐꍇz<br>
 * `l0̉tgXs[J[A`l1̉CgXs[J[A
 * `l2̉TEhtgXs[J[A
 * `l3̉TEhCgXs[J[łꂼo͂܂B<br>
 * <br>
 * y5chĐꍇz<br>
 * `l0̉tgXs[J[A`l1̉CgXs[J[A
 * `l2̉Z^[Xs[J[A
 * `l3̉TEhtgXs[J[A
 * `l4̉TEhCgXs[J[炻ꂼo͂܂B<br>
 * i 5chĐꍇA ::criAtom_SetChannelMapping
 * ֐ŕʂ̕яɕύX邱Ƃ\łBj<br>
 * <br>
 * y5.1chĐꍇz<br>
 * `l0̉tgXs[J[A`l1̉CgXs[J[A
 * `l2̉Z^[Xs[J[A`l3̉LFEA
 * `l4̉TEhtgXs[J[A
 * `l5̉TEhCgXs[J[炻ꂼo͂܂B<br>
 * i 6chĐꍇA ::criAtom_SetChannelMapping
 * ֐ŕʂ̕яɕύX邱Ƃ\łBj<br>
 * <br>
 * y7.1chĐꍇz<br>
 * `l0̉tgXs[J[A`l1̉CgXs[J[A
 * `l2̉Z^[Xs[J[A`l3̉LFEA
 * `l4̉TEhtgXs[J[A
 * `l5̉TEhCgXs[J[A<br>
 * `l6̉TEhobNtgXs[J[A
 * `l7̉TEhobNCgXs[J[炻ꂼo͂܂B<br>
 * <br>
 * ɑ΂A{֐pāu蓮ݒvsꍇAf[^̃`l
 * ֌WȂAw肳ꂽ[eBOŉo͂܂B<br>
 * iZhxݒ肵ĂȂ`l̉͏o͂܂Bj<br>
 * Zhx̐ݒNAA[eBOuݒv̏Ԃɖ߂ꍇ́A
 * ::criAtomPlayer_ResetSendLevel ֐sĂB<br>
 * <br>
 * {[l1.0f𒴂lw肵ꍇAl1.0fɃNbv܂B<br>
 * i傫ȉʂŉĐ邱Ƃ͂܂Bj<br>
 * lɁA{[l0.0f̒lw肵ꍇAl0.0fɃNbv܂B<br>
 * iʑ]邱Ƃ͂܂Bj
 * <br>
 * {֐̐ݒlƁAȉ̊֐̃{[ݒl͓ƗĐ䂳܂B<br>
 * 	- ::criAtomPlayer_SetVolume
 * 	- ::criAtomPlayer_SetChannelVolume
 * Ⴆ΁A{֐0.5fA ::criAtomPlayer_SetVolume ֐ɂ0.5fݒ肵ꍇA
 * õ͉{[͌0.25f{{[ŏo͂܂B<br>
 * i0.5f~0.5f0.25f̉Zs܂Bj
 * \attention
 * Đ鉹f[^}``l̃f[^łĂAZhxꕔ
 * `l݂̂ɂݒ肳ĂȂꍇAZhx̐ݒ肳ĂȂ
 * `l̉͏o͂܂B<br>
 * <br>
 * {֐ ::criAtomPlayer_SetPanAdx1Compatible ֐𕹗pȂłB<br>
 * ::criAtomPlayer_SetPanAdx1Compatible ֐AIɖ{֐Ăяo߁A
 * ҂𕹗pꍇAォs֐ɂݒ肪㏑\܂B<br>
 * ̒ʂRg[ۂɂ́A{֐܂ ::criAtomPlayer_SetPanAdx1Compatible ֐
 * ̂ꂩ݂̂pB<br>
 * i3Dp𗘗pꍇ͖{֐A2Dp݂̂sꍇ ::criAtomPlayer_SetPanAdx1Compatible
 * ֐pBj
 * <br>
 * {֐͈ꕔ̋@ł̂ݗp\łB<br>
 * ivbgtH[̃TEhCu̎dlɂĂ͎ȏꍇ
 * Ȁꍇ͗pł܂Bj<br>
 * {֐p\ǂ́Aʓr}jA̋@ˑ̃y[WQƂB
 * \sa criAtomPlayer_SetVolume, criAtomPlayer_SetChannelVolume, criAtomPlayer_SetPanAdx1Compatible,
 * criAtomPlayer_ResetSendLevel, criAtom_SetChannelMapping
 */
void CRIAPI criAtomPlayer_SetSendLevel(
	CriAtomPlayerHn player, CriSint32 ch, CriAtomSpeakerId spk, CriFloat32 level);

/*JP
 * \brief Zhx̃Zbg
 * \ingroup ATOMLIB_PLAYER
 * \param[in]	player		Atomv[[nh
 * \par :
 * Zhx̐ݒZbg܂B<br>
 * {֐s邱ƂŁAߋɃZbgꂽZhxݒ肪SăNA܂B<br>
 * \l:
 * Zhx̐ݒɂ́uݒvu蓮ݒv2ʂ肪݂܂B<br>
 * Atomv[[쐬A{֐ŃZhxZbgꍇA
 * Zhx̐ݒ́uݒvƂȂ܂B<br>
 * iݒ莞̃[eBOɂẮA ::criAtomPlayer_SetSendLevel
 * ֐̐QƂĂBj<br>
 * \attention
 * {֐ ::criAtomPlayer_ResetPan ֐𕹗pȂłB<br>
 * ::criAtomPlayer_ResetPan ֐AIɖ{֐Ăяo߁A
 * ҂𕹗pꍇAォs֐ɂݒ肪㏑\܂B
 * \sa criAtomPlayer_SetSendLevel, criAtomPlayer_ResetPan
 */
void CRIAPI criAtomPlayer_ResetSendLevel(CriAtomPlayerHn player);

/*JP
 * \brief p̐ݒ
 * \ingroup ATOMLIB_PLAYER
 * \param[in]	player		Atomv[[nh
 * \param[in]	ch			`lԍ
 * \param[in]	pan			pݒli-1.0f`1.0fj
 * \par :
 * pi̒ʈʒujw肵܂B<br>
 * {֐s邱ƂŁAmXeIɑ΂A̒ʈʒuR
 * ɃRg[邱Ƃ\łB<br>
 * <br>
 * 2̃`lԍ"f[^̃`lԍ"w肵܂B<br>
 * 3̃pݒlɂ́Aw肵`lԍ̃f[^̒ʂǂ̈ʒuɂ
 * w肵܂B<br>
 * pݒĺA-1.0f`1.0f͈̔͂Ŏlw肵܂B<br>
 * ́A̒lw肷ƒ荶ilقǍjA0.0fw肷
 * A̒lw肷ƒEil傫قǉEjɒʂ܂B<br>
 * iL̂lł́A-1.0f[A0.0fA1.0fE[ɂȂ܂Bj<br>
 * -1.0f1.0f̊Ԃł́Äʒu̓jAɕω܂B
 * ܂ApݒlʂωȂ-1.0`1.0܂ŕύXꍇA
 * ͍[E[ֈ葬xňړ邱ƂɂȂ܂B<br>
 * \par l:
 * p̐ݒɂ́uݒvu蓮ݒv2ʂ肪݂܂B<br>
 * Atomv[[쐬A ::criAtomPlayer_ResetPan ֐
 * pNAꍇAp̐ݒ́uݒvƂȂ܂B<br>
 * {֐sꍇAp̐ݒ́u蓮ݒvƂȂ܂B<br>
 * <br>
 * uݒv̏ꍇAAtomv[[͈ȉ̂悤ɉ[eBO܂B<br>
 * <br>
 * ymĐꍇz<br>
 * `l0̉ẼXs[J[0.7fi-3dBj̃{[ŏo͂܂B<br>
 * <br>
 * yXeIĐꍇz<br>
 * `l0̉tgXs[J[A
 * `l1̉CgXs[J[o͂܂B<br>
 * <br>
 * ɑ΂A{֐pāu蓮ݒvsꍇAf[^̃`l
 * ֌WȂAw肳ꂽ[eBOŉo͂܂B<br>
 * p̐ݒNAA[eBOuݒv̏Ԃɖ߂ꍇ́A
 * ::criAtomPlayer_ResetPan ֐sĂB<br>
 * \attention
 * {֐ŃpRg[\Ȃ̂́AmƃXeÎ݂łB<br>
 * 3chȏ̉ɑ΂ăpRg[ꍇɂ́A ::criAtomPlayer_SetSendLevel
 * ֐gpKv܂B<br>
 * <br>
 * Đ鉹f[^XeȈꍇA`l0Ԃƃ`l1Ԃ̂ꂼ
 * ɂāAƗăpRg[邱Ƃ\łB<br>
 * Aݒ肳ꂽpmȂ̂AXeIȂ̂͋
 * Ȃ߁AXeIݒpɃpݒsAtomv[[ŃmĐ
 * ꍇAӐ}Ȃʒuɉʂ\܂B<br>
 * <br>
 * Đ鉹f[^XeIɂ炸Aǂ炩̃`lɑ΂
 * pݒ肳ĂȂꍇApݒ肵ĂȂ`l̉̒ʈʒu
 *  0.0f ȉójɂȂ܂B<br>
 * XeĨpRg[ۂɂ́AK̃`lɂăp
 * ݒsĂB<br>
 * <br>
 * {֐ ::criAtomPlayer_SetSendLevel ֐𕹗pȂłB<br>
 * {֐I ::criAtomPlayer_SetSendLevel ֐Ăяo߁A
 * ҂𕹗pꍇAォs֐ɂݒ肪㏑\܂B<br>
 * ̒ʂRg[ۂɂ́A{֐܂ ::criAtomPlayer_SetSendLevel ֐
 * ̂ꂩ݂̂pB<br>
 * i3Dp𗘗pꍇ ::criAtomPlayer_SetSendLevel ֐A2Dp݂̂sꍇ
 * {֐pBj
 * \sa criAtomPlayer_SetVolume, criAtomPlayer_SetChannelVolume, criAtomPlayer_SetPanAdx1Compatible
 * criAtomPlayer_ResetPan
 */
void CRIAPI criAtomPlayer_SetPanAdx1Compatible(
	CriAtomPlayerHn player, CriSint32 ch, CriFloat32 pan);

/*JP
 * \brief p̃Zbg
 * \ingroup ATOMLIB_PLAYER
 * \param[in]	player		Atomv[[nh
 * \par :
 * p̐ݒZbg܂B<br>
 * {֐s邱ƂŁAߋɃZbgꂽpݒ肪SăNA܂B<br>
 * \l:
 * p̐ݒɂ́uݒvu蓮ݒv2ʂ肪݂܂B<br>
 * Atomv[[쐬A{֐ŃpZbgꍇA
 * p̐ݒ́uݒvƂȂ܂B<br>
 * iݒ莞̃[eBOɂẮA ::criAtomPlayer_SetPanAdx1Compatible
 * ֐̐QƂĂBj<br>
 * \attention
 * {֐ ::criAtomPlayer_ResetSendLevel ֐𕹗pȂłB<br>
 * {֐I ::criAtomPlayer_ResetSendLevel ֐Ăяo߁A
 * ҂𕹗pꍇAォs֐ɂݒ肪㏑\܂B
 * \sa criAtomPlayer_SetPanAdx1Compatible, criAtomPlayer_ResetSendLevel
 */
void CRIAPI criAtomPlayer_ResetPan(CriAtomPlayerHn player);

/*JP
 * \brief g̐ݒ
 * \ingroup ATOMLIB_PLAYER
 * \param[in]	player		Atomv[[nh
 * \param[in]	ratio		g
 * \par :
 * ̎gݒ肵܂B<br>
 * ǵAf[^̎gƍĐg̔䗦ŁAĐx̔{ƓłB<br>
 * g䂪1.0f𒴂ꍇAf[^͌荂ɍĐA
 * 1.0f̏ꍇ́Af[^͌ᑬōĐ܂B<br>
 * <br>
 * ǵÃsb`ɂe܂B<br>
 * Ⴆ΁Ag1.0fōĐꍇAf[^͌ʂ̃sb`ōĐ܂A
 * g2.0fɕύXꍇAsb`1IN^[uオ܂B<br>
 * iĐx2{ɂȂ邽߁Bj<br>
 * \par :
 * \code
 * // 1/2̑xi-1IN^[ujŉĐ悤w
 * criAtomPlayer_SetFrequencyRatio(player, 0.5f);
 * \endcode
 * \attention
 * g1.0f𒴂lݒ肵ꍇAĐ鉹̃f[^ʏ
 * 邽߁Af[^̋Af[^̃fR[hԂɍȂȂ
 * \܂B<br>
 * i؂ꓙ̖肪\܂Bj<br>
 * g1.0f𒴂lݒ肷ꍇɂ́AAtomv[[쐬Ɏw肷
 * őTvO[g̒lAgllɐݒ肵ĂB<br>
 * iAtomv[[쐬Ɏw肷 ::CriAtomAdxPlayerConfig \
 *  max_sampling_rate ̒lɁAũTvO[g~gv
 * vZlw肷Kv܂Bj<br>
 * \code
 * main()
 * {
 * 	CriAtomAdxPlayerConfig config;	// Atomv[[쐬pRtBO\
 * 	CriAtomAdxPlayerHn player;		// Atomv[[nh
 * 		:
 * 	// Atomv[[쐬pRtBO\̂ݒ
 * 	memset(&config, 0, sizeof(config));
 * 	config.max_channels = 2;			// XeIĐ\ȃv[[쐬
 *
 * 	// 48000Hz̉1.5{ōĐꍇ
 * 	// 48000~1.572000Hz̐ݒAtomv[[쐬
 * 	config.max_sampling_rate = 72000;	// ő72000Hz̉Đ
 *
 * 	// Atomv[[̍쐬
 * 	// [N̈ɂNULL0w肷B
 * 	// Kvȃ̓CuœIɊmۂB
 * 	player = criAtomPlayer_CreateAdxPlayer(&config, NULL, 0);
 * 		:
 * 	// gύX
 * 	criAtomPlayer_SetFrequencyRatio(player, 1.5f);
 * 		:
 * }
 * \endcode
 * {֐͈ꕔ̋@ł̂ݗp\łB<br>
 * ivbgtH[̃TEhCu̎dlɂĂ͎ȏꍇ
 * Ȁꍇ͗pł܂Bj<br>
 * {֐p\ǂ́Aʓr}jA̋@ˑ̃y[WQƂB
 * \sa CriAtomAdxPlayerConfig, criAtomPlayer_CreateAdxPlayer, criAtomPlayer_SetMaxFrequencyRatio
 */
void CRIAPI criAtomPlayer_SetFrequencyRatio(CriAtomPlayerHn player, CriFloat32 ratio);

/*JP
 * \brief őg̐ݒ
 * \ingroup ATOMLIB_PLAYER
 * \param[in]	player		Atomv[[nh
 * \param[in]	ratio		őg
 * \par :
 * ̍őgݒ肵܂B<br>
 * {֐ōőgw肷邱ƂŁAw͈͓ł̃sb`ύXɔf悤ɂȂ܂B<br>
 * \par l:
 * Atom Ver.2.10.00ȑÕCuł́Asb`グۂɉr؂
 * iĐxȂʁAf[^̋ȂȂjP[X܂B<br>
 * ̑΍ƂāAAtom Ver.2.10.00ł̓sb`グĂr؂Ȃ悤A
 * [Ƀobt@OĂsb`グ悤ύXĂ܂B<br>
 * CɂAsb`ɂĉr؂邱Ƃ͂ȂȂ܂A
 * sb`グۂɃobt@O҂ԕsb`ύXx`ɂȂ邽߁A
 * ̕ωȑÕo[WƔׂĊɖɂȂ\܂B<br>
 * iZԂɃsb`グP[XɂāA̖ς\܂Bj<br>
 * <br>
 * {֐ōőg炩ߐݒ肵ꍇA
 * w肳ꂽxz肵ďɃobt@Os悤ɂȂ邽߁A
 * iw肳ꂽ͈͓̎gɂẮjobt@OȂɃsb`ύXɍs܂B<br>
 * ZԂɃsb`グP[XɂẮA
 * \zőg炩ߖ{֐Őݒ肵ĂĐsĂB<br>
 * \sa criAtomPlayer_SetFrequencyRatio
 */
void CRIAPI criAtomPlayer_SetMaxFrequencyRatio(CriAtomPlayerHn player, CriFloat32 ratio);

/*JP
 * \brief [v񐔂̐
 * \ingroup ATOMLIB_PLAYER
 * \param[in]	player		Atomv[[nh
 * \param[in]	count		[v
 * \par :
 * g`f[^̃[vĐ񐔂𐧌܂B<br>
 * Ⴆ΁Acount1w肵ꍇA[vg`f[^1̂݃[včĐI܂B<br>
 * i[vGh|CgɓBA1񂾂[vX^[gʒuɖ߂܂Bj<br>
 * \par l:
 * ftHgԂł́A[v|Cgt̉f[^͖Ƀ[vĐ܂B<br>
 * [v񐔂UA[v񐔂ēxɖ߂ꍇɂ́A
 * count  ::CRIATOMPLAYER_NO_LOOP_LIMITATION w肵ĂB<br>
 * <br>
 * count  ::CRIATOMPLAYER_IGNORE_LOOP w肷邱ƂŁA
 * [v|Cgt̉f[^[vɍĐ邱Ƃ\łB<br>
 * \attention
 * [v񐔂̎ẃAĐJnOɍsKv܂B<br>
 * Đɖ{֐sĂA[v񐔂͕ύX܂B<br>
 * Đ̔Cӂ̃^C~OŃ[vĐ~ꍇA
 * [vĐł͂ȂAV[XAĐŐsĂB<br>
 * <br>
 * {֐Ŏw肵[v񐔂́A
 * 炩߃[v|Cgݒ肳ꂽg`f[^Đꍇɂ̂ݓKp܂B<br>
 * g`f[^̂Ƀ[v|Cgݒ肳ĂȂꍇA
 * {֐sĂ̌ʂ܂B<br>
 * <br>
 * {֐gpă[v񐔂w肵ꍇłA
 * [vIɃ[vGh|Cgȍ~̔g`f[^Đ邱Ƃ͂܂B<br>
 * iw񐔕[vA[vGh|CgōĐ~܂Bj<br>
 * <br>
 * OIɁAȉ̏𖞂ꍇɌAi[v͂܂񂪁j
 * VbgŃ[v|Cgȍ~̃f[^܂߂čĐ邱Ƃ\łB<br>
 * 	- criatomencd.exe  -nodelterm w肵ăf[^GR[hB
 * 	- {֐ ::CRIATOMPLAYER_IGNORE_LOOP w肵ĂĐsB
 *
 * <br>
 * {֐Ń[v񐔂𐧌ł̂́AADXR[fbNHCAR[fbN݂̂łB<br>
 * vbgtH[ˑ̉R[fbNɑ΂Ė{֐sȂłB<br>
 * iĐIȂAmCY铙̖肪܂Bj<br>
 */
void CRIAPI criAtomPlayer_LimitLoopCount(CriAtomPlayerHn player, CriSint32 count);

/*JP
 * \brief HCA-MXfR[h~LT[ID̎w
 * \ingroup ATOMLIB_PLAYER
 * \param[in]	player		Atomv[[nh
 * \param[in]	mixer_id	~LT[ID
 * \par :
 * HCA-MX̃fR[h~LT[IDw肵܂B<br>
 * \attention
 * {֐ ::criAtomPlayer_CreateHcaMxPlayer
 * ֐ō쐬ꂽv[[ɑ΂Ă̂݌ʂ܂B<br>
 * i̊֐ō쐬ꂽv[[ɑ΂ẮǍʂ܂Bj<br>
 * <br>
 * {֐͒~̃v[[ɑ΂Ă̂ݎs\łB<br>
 * \sa criAtomPlayer_CreateHcaMxPlayer
 */
void CRIAPI criAtomPlayer_SetHcaMxMixerId(CriAtomPlayerHn player, CriSint32 mixer_id);

/*JP
 * \brief ASRbNID̎w
 * \ingroup ATOMLIB_PLAYER
 * \param[in]	player		Atomv[[nh
 * \param[in]	rack_id		bNID
 * \par :
 * {CX̏o͐̃bNIDw肵܂B<br>
 * \attention
 * {֐͒~̃v[[ɑ΂Ă̂ݎs\łB<br>
 */
void CRIAPI criAtomPlayer_SetAsrRackId(CriAtomPlayerHn player, CriSint32 rack_id);

/*JP
 * \brief RawPCMtH[}bg̎w
 * \ingroup ATOMLIB_PLAYER
 * \param[in]	player			Atomv[[nh
 * \param[in]	pcm_format		RawPCM̃f[^tH[}bg
 * \param[in]	num_channels	`l
 * \param[in]	sampling_rate	TvO[g
 * \par :
 * RawPCM̃f[^tH[}bgw肵܂B<br>
 * \attention
 * {֐ ::criAtomPlayer_CreateRawPcmPlayer
 * ֐ō쐬ꂽv[[ɑ΂Ă̂݌ʂ܂B<br>
 * i̊֐ō쐬ꂽv[[ɑ΂ẮǍʂ܂Bj<br>
 * <br>
 * {֐͒~̃v[[ɑ΂Ă̂ݎs\łB<br>
 * \sa criAtomPlayer_CreateRawPcmPlayer
 */
void CRIAPI criAtomPlayer_SetRawPcmFormat(CriAtomPlayerHn player,
	CriAtomPcmFormat pcm_format, CriSint32 num_channels, CriSint32 sampling_rate);

/*JP
 * \brief f[^vR[obN֐̓o^
 * \ingroup ATOMLIB_PLAYER
 * \param[in]	player		Atomv[[nh
 * \param[in]	func		f[^vR[obN֐
 * \param[in]	obj			[UwIuWFNg
 * \par :
 * f[^vR[obN֐̓o^s܂B<br>
 * <br>
 * f[^vR[obŃẢf[^V[XɘAčĐۂ
 * gp܂B<br>
 * o^R[obN֐́AAtomv[[AĐp̃f[^v^C~O
 * s܂B<br>
 * iÕf[^ǂݍݏIāAɍĐׂf[^v^C~O
 * R[obN֐s܂Bj<br>
 * o^R[obN֐ ::criAtomPlayer_SetData ֐pAtomv[[
 * f[^ZbgƁAZbgꂽf[^͌ݍĐ̃f[^ɑăV[X
 * AčĐ܂B<br>
 * ܂AR[obN֐ ::criAtomPlayer_SetPreviousDataAgain ֐s邱ƂŁA
 * f[^JԂĐ邱Ƃ\łB<br>
 * \par l:
 * o^R[obN֐Ńf[^w肵ȂꍇÃ݂f[^Đ
 * I_ŁAAtomv[[̃Xe[^X CRIATOMPLAYER_STATUS_PLAYEND ɑJڂ܂B<br>
 * <br>
 * ^C~O̖ɂAf[^w肷邱ƂłȂAXe[^X
 * CRIATOMPLAYER_STATUS_PLAYEND ɑJڂȂꍇɂ́AR[obN֐
 * ::criAtomPlayer_DeferCallback ֐sĂB<br>
 * ::criAtomPlayer_DeferCallback ֐s邱ƂŁA1Vɍēxf[^v
 * R[obN֐Ăяo܂BiR[obNgC\Bj<br>
 * A ::criAtomPlayer_DeferCallback ֐sꍇAĐr؂
 * iAӏɈ莞Ԗj\܂B<br>
 * \par :
 * ȉ̃R[hsƁAbuffer1̃f[^buffer2̃f[^V[X
 * AčĐ܂B<br>
 * ǐbuffer2̃f[^JԂĐ܂Bj<br>
 * \code
 * // f[^vR[obN֐
 * void on_data_request(void *obj, CriAtomPlayerHn player)
 * {
 * 	// čĐf[^Zbg
 * 	criAtomPlayer_SetData(player, buffer2, buffer_size2);
 * }
 *
 * main()
 * {
 * 		:
 * 	// f[^vR[obN֐̓o^
 * 	criAtomPlayer_SetDataRequestCallback(player, on_data_request, NULL);
 *
 * 	// f[^Zbg
 * 	criAtomPlayer_SetData(player, buffer1, buffer_size1);
 *
 * 	// Zbgꂽf[^Đ
 * 	criAtomPlayer_Start(player);
 * 		:
 * }
 * \endcode
 * ȉ̏ɂAꉹf[^𖳌Ƀ[vĐ\łB<br>
 * \code
 * // f[^vR[obN֐
 * void on_data_request(void *obj, CriAtomPlayerHn player)
 * {
 * 	// OĐf[^ăZbg
 * 	criAtomPlayer_SetPreviousDataAgain(player);
 * }
 *
 * main()
 * {
 * 		:
 * 	// f[^vR[obN֐̓o^
 * 	criAtomPlayer_SetDataRequestCallback(player, on_data_request, NULL);
 *
 * 	// f[^Zbg
 * 	criAtomPlayer_SetData(player, buffer, buffer_size);
 *
 * 	// Zbgꂽf[^Đ
 * 	criAtomPlayer_Start(player);
 * 		:
 * }
 * \endcode
 * \attention
 * f[^vR[obN֐ŒԏubNƁA؂ꓙ̖肪
 * ܂̂ŁAӂB<br>
 * <br>
 * V[XAĐT|[gȂR[fbNgpĂꍇA
 * f[^vR[obN֐Ŏ̃f[^ZbgĂA
 * f[^͑čĐ܂B<br>
 * iHCA-MXvbgtH[ŗL̉kR[fbNgpĂꍇA
 * V[XAĐ͂ł܂Bj<br>
 * <br>
 * V[XAĐɎgpg`f[^̃tH[}bǵA
 * SēɂKv܂B<br>
 * ̓Iɂ́Aȉ̃p[^[łKv܂B<br>
 * 	- R[fbN
 * 	- `l
 * 	- TvO[g
 *
 * p[^[قȂg`A悤ƂꍇA
 * Ӑ}Ȃxŉf[^ĐꂽA
 * G[R[obN铙̖肪܂B<br>
 * <br>
 * R[obN֐Ń[vt̔g`f[^ZbgꍇłA
 * [vĐ͍s܂B<br>
 * i[v|CgAĐI܂Bj<br>
 * <br>
 * R[obN֐Atomv[[jȂłB<br>
 * R[obN𔲂A΂炭̊Ԃ̓T[o[œYnh̃\[X
 * QƂ邽߁AANZXᔽ̏dȖ肪\܂B
 * <br>
 * R[obN֐1o^ł܂B<br>
 * o^𕡐sꍇAɓo^ς݂̃R[obN֐A
 * ォo^R[obN֐ɂ㏑Ă܂܂B<br>
 * <br>
 * funcNULLw肷邱Ƃœo^ς݊֐̓o^s܂B<br>
 * \sa CriAtomPlayerDataRequestCbFunc, criAtomPlayer_SetData,
 * criAtomPlayer_SetPreviousDataAgain, criAtomPlayer_DeferCallback
 */
void CRIAPI criAtomPlayer_SetDataRequestCallback(
	CriAtomPlayerHn player, CriAtomPlayerDataRequestCbFunc func, void *obj);

/*JP
 * \brief Xe[^XύXR[obN֐̓o^
 * \ingroup ATOMLIB_PLAYER
 * \param[in]	player		Atomv[[nh
 * \param[in]	func		Xe[^XύXR[obN֐
 * \param[in]	obj			[UwIuWFNg
 * \par :
 * Xe[^XύXR[obN֐o^܂B<br>
 * o^R[obN֐́AAtomv[[̃Xe[^XXV^C~O
 * s܂B<br>
 * ύXꂽXe[^XɂẮAR[obN֐̈ƂēnAtomv[[
 * nhɑ΂A ::criAtomPlayer_GetStatus ֐s邱ƂŎ擾\łB<br>
 * <br>
 * Xe[^XύXR[obN𗘗p邱ƂŁAAtomv[[̃Xe[^XύX
 * 킹ē̏sƂ\ɂȂ܂B<br>
 * Ⴆ΁Aȉ̂悤ȃR[hŁAXe[^X CRIATOMPLAYER_STATUS_ERROR ɂȂ
 * ꍇɃ[hG[bZ[W\邱Ƃ\łB<br>
 * \code
 * // Xe[^XύXR[obN֐
 * void on_status_change(void *obj, CriAtomPlayerHn player)
 * {
 * 	CriAtomPlayerStatus status;
 *
 * 	// Xe[^X̎擾
 * 	status = criAtomPlayer_GetStatus(player);
 * 	if (status == CRIATOMPLAYER_STATUS_ERROR) {
 * 		// [hG[̏
 * 			:
 * 	}
 * }
 *
 * main()
 * {
 * 		:
 * 	// Xe[^XύXR[obN֐̓o^
 * 	criAtomPlayer_SetStatusChangeCallback(player, on_status_change, NULL);
 *
 * 	// t@CZbg
 * 	criAtomPlayer_SetFile(player, NULL, "sample.adx");
 *
 * 	// Zbgꂽt@CĐ
 * 	criAtomPlayer_Start(player);
 * 		:
 * }
 * \endcode
 * \par l:
 * ɂ́AXe[^XJځ`R[obN֐s܂ł̊Ԃɑ̏荞݂œ삷
 * ]n邽߁AXe[^XJڂƃR[obN֐s̃^C~OY\܂B<br>
 * \attention
 * Xe[^XύXR[obN֐ŒԏubNƁA؂ꓙ̖
 * ܂̂ŁAӂB<br>
 * <br>
 * Xe[^XύXR[obN֐𔲂܂ł́AAtomv[[̃Xe[^X
 * ύX邱Ƃ͂܂B<br>
 * ̂߁AXe[^XύXR[obN֐Atomv[[̃Xe[^XJڂ
 * ҂sƁAfbhbNAɐi܂ȂȂ܂B<br>
 * <br>
 * R[obN֐Atomv[[jȂłB<br>
 * R[obN𔲂A΂炭̊Ԃ̓T[o[œYnh̃\[X
 * QƂ邽߁AANZXᔽ̏dȖ肪\܂B
 * <br>
 * R[obN֐1o^ł܂B<br>
 * o^𕡐sꍇAɓo^ς݂̃R[obN֐A
 * ォo^R[obN֐ɂ㏑Ă܂܂B<br>
 * <br>
 * funcNULLw肷邱Ƃœo^ς݊֐̓o^s܂B<br>
 * \sa criAtomPlayer_GetStatus
 */
void CRIAPI criAtomPlayer_SetStatusChangeCallback(
	CriAtomPlayerHn player, CriAtomPlayerStatusChangeCbFunc func, void *obj);

/*JP
 * \brief p[^[ύXR[obN֐̓o^
 * \ingroup ATOMLIB_PLAYER
 * \param[in]	player		Atomv[[nh
 * \param[in]	func		p[^[ύXR[obN֐
 * \param[in]	obj			[UwIuWFNg
 * \par :
 * p[^[ύXR[obN֐o^܂B<br>
 * o^R[obN֐́AAtomv[[̃p[^[XV^C~OŎs܂B<br>
 * \attention
 * p[^[ύXR[obN֐ŒԏubNƁA؂ꓙ̖
 * ܂̂ŁAӂB<br>
 * <br>
 * R[obN֐Atomv[[jȂłB<br>
 * R[obN𔲂A΂炭̊Ԃ̓T[o[œYnh̃\[X
 * QƂ邽߁AANZXᔽ̏dȖ肪\܂B
 * <br>
 * R[obN֐1o^ł܂B<br>
 * o^𕡐sꍇAɓo^ς݂̃R[obN֐A
 * ォo^R[obN֐ɂ㏑Ă܂܂B<br>
 * <br>
 * funcNULLw肷邱Ƃœo^ς݊֐̓o^s܂B<br>
 */
void CRIAPI criAtomPlayer_SetParameterChangeCallback(
	CriAtomPlayerHn player, CriAtomPlayerParameterChangeCbFunc func, void *obj);

/*JP
 * \brief g`tB^[R[obN֐̓o^
 * \ingroup ATOMLIB_PLAYER
 * \param[in]	player		Atomv[[nh
 * \param[in]	func		g`tB^[R[obN֐
 * \param[in]	obj			[UwIuWFNg
 * \par :
 * fR[hʂ PCM f[^󂯎R[obN֐o^܂B<br>
 * o^ꂽR[obN֐́A Atom v[[f[^fR[h^C~OŌĂяo܂B<br>
 * \attention
 * Xe[^XύXR[obN֐ŒԏubNƁA؂ꓙ̖
 * ܂̂ŁAӂB<br>
 * <br>
 * HCA-MXR[fbNvbgtH[ŗL̉kR[fbNgpĂꍇA
 * tB^[R[obN͗pł܂B<br>
 * <br>
 * R[obN֐1o^ł܂B<br>
 * o^𕡐sꍇAɓo^ς݂̃R[obN֐A
 * ォo^R[obN֐ɂ㏑Ă܂܂B<br>
 * <br>
 * funcNULLw肷邱Ƃœo^ς݊֐̓o^s܂B<br>
 * \sa CriAtomPlayerFilterCbFunc
 */
void CRIAPI criAtomPlayer_SetFilterCallback(
	CriAtomPlayerHn player, CriAtomPlayerFilterCbFunc func, void *obj);

/*JP
 * \brief [hvR[obN֐̓o^
 * \ingroup ATOMLIB_PLAYER
 * \param[in]	player		Atomv[[nh
 * \param[in]	func		[hvR[obN֐
 * \param[in]	obj			[UwIuWFNg
 * \par :
 * [hvR[obN֐̓o^s܂B<br>
 * <br>
 * [hvR[obŃAAtomv[[̃t@C[hԂĎۂɎgp܂B<br>
 * ifobOړI̊֐Ȃ̂ŁAʏ{֐gpKv͂܂Bj<br>
 * \attention
 * [hvR[obN֐ŒԏubNƁA؂ꓙ̖肪
 * ܂̂ŁAӂB<br>
 * <br>
 * R[obN֐Atomv[[jȂłB<br>
 * R[obN𔲂A΂炭̊Ԃ̓T[o[œYnh̃\[X
 * QƂ邽߁AANZXᔽ̏dȖ肪\܂B
 * <br>
 * R[obN֐1o^ł܂B<br>
 * o^𕡐sꍇAɓo^ς݂̃R[obN֐A
 * ォo^R[obN֐ɂ㏑Ă܂܂B<br>
 * <br>
 * funcNULLw肷邱Ƃœo^ς݊֐̓o^s܂B<br>
 * \sa CriAtomPlayerLoadRequestCbFunc
 */
void CRIAPI criAtomPlayer_SetLoadRequestCallback(
	CriAtomPlayerHn player, CriAtomPlayerLoadRequestCbFunc func, void *obj);

/*==========================================================================
 *      Functions for HCA Streaming
 *=========================================================================*/

/*JP
 * \brief HCAtH[}bg̎w
 * \ingroup ATOMLIB_PLAYER
 * \param[in]	player				Atomv[[
 * \param[in]	num_channels		`l
 * \param[in]	sampling_rate		TvOg
 * \param[in]	bitrate				rbg[g
 * \par :
 * HCAf[^̃tH[}bgݒ肵܂B<br>
 * {֐s邱ƂŁAwb_[XHCAf[^Đ邱Ƃ\ɂȂ܂B<br>
 */
void CRIAPI criAtomPlayer_SetHcaFormat(CriAtomPlayerHn player,
	CriSint32 num_channels, CriSint32 sampling_rate, CriSint32 bitrate);

/*==========================================================================
 *      CRI Atom D-BAS API
 *=========================================================================*/
/*JP
 * \brief D-BAS쐬p[NTCY̌vZ
 * \ingroup ATOMLIB_DBAS
 * \param[in]	config		D-BAS쐬pRtBO\̂ւ̃|C^
 * \return		CriSint32	D-BAS쐬p[NTCY
 * \retval		0ȏ		ɏ
 * \retval		-1			G[
 * \par :
 * D-BAS쐬pp[^[ɊÂāAD-BAS̍쐬ɕKv[NTCYvZ܂B<br>
 * <br>
 * [N̈TCY̌vZɎsƁA{֐ -1 Ԃ܂B<br>
 * [N̈TCY̌vZɎsRɂẮAG[R[obÑbZ[WŊmF\łB<br>
 * \attention
 * {֐sOɁACuĂKv܂B<br>
 * <br>
 * ݒɂẮAD-BAS2GBȏ̃[NTCYKvƂꍇA<br>
 * ̍ۂ̓G[ɂȂA -1 Ԃ܂B<br>
 * G[ꍇ́Amax_streamsmax_bps̒lႭݒ肵ĂB<br>
 * \sa criAtomDbas_Create
 */
CriSint32 CRIAPI criAtomDbas_CalculateWorkSize(const CriAtomDbasConfig *config);

/*JP
 * \brief D-BAS̍쐬
 * \ingroup ATOMLIB_DBAS
 * \param[in]	config			D-BAS쐬pRtBO\̂ւ̃|C^
 * \param[in]	work			D-BAS쐬p[N̈ւ̃|C^
 * \param[in]	work_size		D-BAS쐬p[NTCY
 * \return		CriAtomDbasId	D-BASǗpID
 * \par :
 * D-BAS쐬pp[^[ɊÂāAD-BAS쐬܂B<br>
 * 쐬ɐƁAD-BASCuɓo^ALȊǗpIDԂ܂B<br>
 * D-BAS̍쐬ɎsꍇA{֐ ::CRIATOMDBAS_ILLEGAL_ID Ԃ܂B<br>
 * iG[̌̓G[R[obNɕԂ܂Bj<br>
 * <br>
 * 擾ID::criAtomDbas_Destroy ֐Ŏgp܂B<br>
 * \attention
 * {֐sOɁACuĂKv܂B<br>
 * \sa criAtomDbas_CalculateWorkSize, criAtomDbas_Destroy
 */
CriAtomDbasId CRIAPI criAtomDbas_Create(
	const CriAtomDbasConfig *config, void *work, CriSint32 work_size);

/*JP
 * \brief D-BAS̔j
 * \ingroup ATOMLIB_DBAS
 * \param[in]	atom_dbas_id	D-BASǗpID
 * \par :
 * ::criAtomDbas_Create ֐Ŏ擾ǗpIDw肵āAD-BASj܂B<br>
 * \sa criAtomDbas_Create
 */
void CRIAPI criAtomDbas_Destroy(CriAtomDbasId atom_dbas_id);

/*JP
 * \brief Xg[ĐAtomv[[nh擾
 * \ingroup ATOMLIB_DBAS
 * \param[in]	dbas_id			D-BASǗpID
 * \param[out]	players			v[[nh󂯎pz
 * \param[in]	length			v[[nh󂯎pzvf
 * \return		CriSint32		v[[
 * \retval		0ȏ			ɏ
 * \retval		-1				G[
 * \par :
 * Xg[ĐAtomv[[nh擾܂B<br>
 * v[[nh̎擾ɐƁA
 * 3iplayerszjɃv[[nh̃AhXۑA
 * v[[nh߂lƂĕԂ܂B<br>
 * \par l:
 * 3iplayerszjNULLA4ilengthj0w肷邱ƂŁA
 * Xg[Đ̃v[[̐߂lƂĎ擾\łB<br>
 * \attention
 * v[[擾Ănh擾ꍇA
 * v[[擾ƃnh擾̊ԂɃT[o[荞܂Ȃ悤A
 * criAtom_Lock ֐ŔrsKv܂B<br>
 * iT[o[̃^C~OŁAv[[ς\܂Bj<br>
 * <br>
 * zvfXg[Đ̃v[[ɖȂꍇA
 * {֐̓G[li-1jԂ܂B<br>
 */
CriSint32 CRIAPI criAtomDbas_GetStreamingPlayerHandles(
	CriAtomDbasId dbas_id, CriAtomPlayerHn *players, CriSint32 length);

/* ========================================================================*/
/*       CRI Atom Streaming Cache API                                      */
/* ========================================================================*/
/*JP
 * \brief Xg[~OLbV쐬ɕKvȃ[NTCY̌vZ
 * \ingroup ATOMLIB_STREAMING_CACHE
 * \param[in]	config		Xg[~OLbV쐬p\
 * return		CriSint32	Xg[~OLbV쐬ɕKvȃ[NTCY
 * \retval		0ȏ		ɏ
 * \retval		-1			G[
 * \par :
 * Xg[~OLbV쐬ɕKvȃ[NTCYvZ܂B<br>
 * configŗ^p[^[ɈˑAKvȃ[NTCY͑܂B<br>
 * \sa criAtomStreamingCache_Create
 */
CriSint32 CRIAPI criAtomStreamingCache_CalculateWorkSize(
	const CriAtomStreamingCacheConfig* config);

/*JP
 * \brief Xg[~OLbV̍쐬
 * \ingroup ATOMLIB_STREAMING_CACHE
 * \param[in]	config		Xg[~OLbV쐬p\
 * \param[in]	work		Xg[~OLbV쐬p[N
 * \param[in]	work_size	Xg[~OLbV쐬p[NTCY
 * return		CriAtomStreamingCacheId	Xg[~OLbVID
 * \par :
 * Xg[~OLbV쐬܂B<br>
 * Atomv[[ɃXg[~OLbVݒ肷邱ƂŁA
 * Xg[~OĐsɃt@CŜێiLbVj܂B<br>
 * t@C2ڈȍ~̍Đł́ALbVgĐɎIɐ؂ւ܂B<br>
 * ܂AĐf[^[vf[^ĂꍇA
 * [vȍ~̍Đ͎IɃĐōs悤ɂȂ܂B<br>
 * {@\Atomv[[Xg[~OĐsꍇ̂݋@\܂B<br>
 * {֐ɎsꍇACRIATOM_STREAMING_CACHE_ILLEGAL_IDԂ܂B<br>
 * \attention
 * t@CŜLbV鎖OłBāALbVpɊ蓖Ăꂽ
 * TCYXg[~OĐΏۂƂǂ̃t@CTCYꍇA
 * ؃LbV܂B
 * \sa criAtomStreamingCache_CalculateWorkSize, criAtomStreamingCache_Destroy,
 */
CriAtomStreamingCacheId CRIAPI criAtomStreamingCache_Create(
	const CriAtomStreamingCacheConfig* config, void* work, CriSint32 work_size);

/*JP
 * \brief Xg[~OLbV̔j
 * \ingroup ATOMLIB_STREAMING_CACHE
 * \param[in]	stm_cache_id		Xg[~OLbVID
 * \par :
 * w肵Xg[~OLbVj܂B<br>
 * \attention
 * w肵Xg[~OLbV𗘗pĂv[[݂ȂԂŁA
 * {֐sĂB
 * \sa criAtomStreamingCache_Create
 */
void CRIAPI criAtomStreamingCache_Destroy(CriAtomStreamingCacheId stm_cache_id);

/*JP
 * \brief Xg[~OLbṼLbVeNA
 * \ingroup ATOMLIB_STREAMING_CACHE
 * \param[in]	cache_id		Xg[~OLbVID
 * \par :
 * w肵Xg[~OLbV̓eNA܂B<br>
 * LbV͌ÂɃNA܂B<br>
 * w肵Xg[~OLbVgp̃v[[݂ꍇA
 * LbṼNA͓rŒf܂B<br>
 * \attention
 * ԌÂLbVgp̃v[[݂ꍇA{֐sĂ
 * LbV͈؃NA܂B
 * \sa criAtomStreamingCache_Create
 */
void CRIAPI criAtomStreamingCache_Clear(CriAtomStreamingCacheId cache_id);

/*JP
 * \brief WaveIDwŃLbVς݌
 * \ingroup ATOMLIB_STREAMING_CACHE
 * \param[in]	stm_cache_id		Xg[~OLbVID
 * \param[in]	awb					AWBnh
 * \param[in]	id					WaveID
 * \return		CriBool				LbVς݂łCRI_TRUEAȊOCRI_FALSE
 * \par :
 * w肵Xg[~OLbVɁAw̉f[^LbVĂ邩܂B<br>
 * w̉f[^LbVĂԂłCRI_TRUEA
 * LbVĂȂԂłCRI_FALSEԂ܂B<br>
 * \attention
 * AWBnhĐp̏ꍇA{֐͉f[^̗Lɂ炸CRI_TRUEԂ܂B<br>
 * \sa criAtomStreamingCache_Create
 */
CriBool CRIAPI criAtomStreamingCache_IsCachedWaveId(
	CriAtomStreamingCacheId stm_cache_id, CriAtomAwbHn awb, CriSint32 id);

/*JP
 * \brief pXwŃLbVς݌
 * \ingroup ATOMLIB_STREAMING_CACHE
 * \param[in]	stm_cache_id		Xg[~OLbVID
 * \param[in]	src_binder			f[^t@Cǂݍ݌̃oC_[nh
 * \param[in]	path				f[^t@C̃pX
 * \return		CriBool				LbVς݂łCRI_TRUEAȊOCRI_FALSE
 * \par :
 * w肵Xg[~OLbVɁAw̉f[^LbVĂ邩܂B<br>
 * w̉f[^LbVĂԂłCRI_TRUEA
 * LbVĂȂԂłCRI_FALSEԂ܂B<br>
 * \sa criAtomStreamingCache_Create
 */
CriBool CRIAPI criAtomStreamingCache_IsCachedFile(
	CriAtomStreamingCacheId stm_cache_id, CriFsBinderHn src_binder, const CriChar8 *path);

/*==========================================================================
 *      CRI Atom DSP API
 *=========================================================================*/
/*JP
 * \brief ZglDSPp[^[ւ̕ϊ
 * \ingroup ATOMLIB_DSP
 * \param[in]	cent		Zgl
 * \return		CriFloat32	DSPp[^[l
 * \par :
 * -1200`1200͈̔͂0.0f`1.0f͈̔͂ɐK܂B<br>
 */
CriFloat32 criAtomDsp_ConvertParameterFromCent(CriFloat32 cent);

/*JP
 * \brief XyNgAiCU쐬ɕKvȃ[N̈TCYvZ
 * \ingroup ATOMLIB_DSP
 * \param[in]	config		XyNgAiCU쐬p[^[
 * \return		CriSint32	Kvȃ[N̈̃TCYiPʂ̓oCgj
 * \par :
 * XyNgAiCU̍쐬ɕKvȃ[NTCYvZ܂B<br>
 * configŗ^p[^[ɈˑAKvȃ[NTCY͕ω܂B<br>
 * \par l:
 * [N̈TCY̌vZɎsꍇA{֐͕lԂ܂B<br>
 * iš̓G[R[obNŒʒm܂Bj<br>
 * \sa CriAtomDspSpectraConfig, criAtomDspSpectra_Create
 */
CriSint32 criAtomDspSpectra_CalculateWorkSize(const CriAtomDspSpectraConfig *config);

/*JP
 * \brief XyNgAiCU̍쐬
 * \ingroup ATOMLIB_DSP
 * \param[in]	config		XyNgAiCU쐬p[^[
 * \param[in]	work		[N̈
 * \param[in]	work_size	[N̈TCY
 * \return		CriAtomDspSpectraHn	XyNgAiCUnh
 * \par :
 * XyNgAiCU쐬܂B<br>
 * XyNgAiCÚAPCMf[^͂A
 * ш悲Ƃ̐M̋v郂W[łB<br>
 * <br>
 * PCMf[^̓͂ɂ́A ::criAtomDspSpectra_Process ֐gp܂B<br>
 * ͌ʂ̎擾ɂ́A ::criAtomDspSpectra_GetLevels ֐gp܂B<br>
 * <br>
 * svɂȂXyNgAiCÚA ::criAtomDspSpectra_Destroy
 * ֐ŖIɔjKv܂B<br>
 * \par l:
 * XyNgAiCU̍쐬ɎsꍇA{֐NULLԂ܂B<br>
 * iš̓G[R[obNŒʒm܂Bj
 * <br>
 * ::criAtom_SetUserAllocator ɂAP[^[o^s킸ɖ{֐sꍇA
 * ::criAtomDspSpectra_CalculateWorkSize
 * ֐ŌvZTCỸ[N̈ƂēnKv܂B<br>
 * \attention
 * {֐sOɁACuĂKv܂B<br>
 * <br>
 * {֐ɃZbg[N̈́A ::criAtomDspSpectra_Destroy
 * ֐s܂ł̊ԁAAvP[VŕێKv܂B<br>
 * i ::criAtomDspSpectra_Destroy ֐sOɁA[N̈̃ȂłBj<br>
 * <br>
 * {֐͊A^̊֐łB<br>
 * {֐sƁA΂炭̊AtomCũT[o[ubN܂B<br>
 * Đɖ{֐sƁAr؂ꓙ̕s\邽߁A
 * {֐̌Ăяo̓V[̐؂ւ蓙Aוϓeł^C~OōsĂB<br>
 * \sa CriAtomDspSpectraConfig, criAtomDspSpectra_CalculateWorkSize, criAtomDspSpectra_Destroy
 */
CriAtomDspSpectraHn criAtomDspSpectra_Create(
	const CriAtomDspSpectraConfig *config, void *work, CriSint32 work_size);

/*JP
 * \brief XyNgAiCU̔j
 * \ingroup ATOMLIB_DSP
 * \par :
 * XyNgAiCUj܂B<br>
 * XyNgAiCU쐬Ɋmۂꂽ̈悪܂B<br>
 * iXyNgAiCU쐬Ƀ[N̈nꍇA{֐sł
 * [N̈\łBj<br>
 * \attention
 * {֐͊A^̊֐łB<br>
 * {֐sƁA΂炭̊AtomCũT[o[ubN܂B<br>
 * Đɖ{֐sƁAr؂ꓙ̕s\邽߁A
 * {֐̌Ăяo̓V[̐؂ւ蓙Aוϓeł^C~OōsĂB
 * \sa criAtomDspSpectra_Create
 */
void criAtomDspSpectra_Destroy(CriAtomDspSpectraHn spectra);

/*JP
 * \brief XyNgAiCŨZbg
 * \ingroup ATOMLIB_DSP
 * \par :
 * XyNgAiCUZbg܂B<br>
 * {֐s_ŁA ::criAtomDspSpectra_Process
 * ֐ɃZbgPCM̏񂪃NA܂B<br>
 * \par l:
 * ::criAtomDspSpectra_GetLevels ֐̖߂l[NAꍇA
 * {֐sĂB<br>
 * \sa criAtomDspSpectra_Process, criAtomDspSpectra_GetLevels
 */
void criAtomDspSpectra_Reset(CriAtomDspSpectraHn spectra);

/*JP
 * \brief XyNg
 * \ingroup ATOMLIB_DSP
 * \par :
 * PCMf[^͂܂B<br>
 * ͌ʂ ::criAtomDspSpectra_GetLevels ֐Ŏ擾\łB<br>
 * \par l:
 * ͂f[^ipcmj̒l -1.0f ` +1.0f ͈̔͂z肵Ă܂B<br>
 * A}1͈̔͂𒴂l͂ꍇłAcriAtomDspSpectra_GetLevels
 * ֐Ԃl傫Ȃ邾Ȃ̂ŁA
 * f[^͎_ŃNbsOsKv͂܂B<br>
 * {֐͓1024_̃Tv~ς̂҂ĂFFTsׁA
 * XyNg1024Tv͖ɍXV܂B
 * \sa criAtomDspSpectra_GetLevels
 */
void criAtomDspSpectra_Process(CriAtomDspSpectraHn spectra,
	CriUint32 num_channels, CriUint32 num_samples, CriFloat32 *pcm[]);

/*JP
 * \brief XyNg͌ʂ̎擾
 * \ingroup ATOMLIB_DSP
 * \par :
 * ::criAtomDspSpectra_Process ֐ŃZbgPCMf[^́A͌ʂԂ܂B<br>
 * <br>
 * ͌ʂ CriFloat32 ^̔złB<br>
 * z̗vf́A ::criAtomDspSpectra_Create ֐s
 * CriAtomDspSpectraConfig::num_bands Ŏw肵ɂȂ܂B<br>
 * 0 Ԗڂ̗vfŒш̐UlA (num_bands - 1) Ԗڂ̗vfōш̐UlłB<br>
 * \par l:
 * `lPCMf[^͂ꍇA
 * SẴ`lPCMf[^U~bNXA~bNXʂɑ΂͂s܂B<br>
 * ̂߁A criAtomDspSpectra_Process ֐ɕ`l̉f[^ZbgꍇłA
 * {֐͒ num_bands 1zԂ܂B<br>
 * \attention
 * criAtomDspSpectra_GetLevels ֐ԂĺAш悲Ƃ̐UlłB<br>
 * ͌ʂŝ̃XyNgAiCÛ悤ɕ\ꍇA
 * {֐ԂlfVxlɕϊKv܂B<br>
 * \sa criAtomDspSpectra_Process
 */
const CriFloat32* criAtomDspSpectra_GetLevels(CriAtomDspSpectraHn spectra);

/* ========================================================================*/
/*       CRI Atom Meter API                                                */
/* ========================================================================*/

/*JP
 * \brief x[^[@\p̃[NTCY̌vZ
 * \ingroup ATOMLIB_METER
 * \param[in]	config			x[^[ǉp̃RtBO\
 * \return		CriSint32		Kvȃ[N̈TCY
 * \par :
 * x[^[ǉɕKvȃ[N̈TCYvZ܂B<br>
 * config NULLw肷ƃftHgݒŌvZ܂B<br>
 * \sa criAtomMeter_AttachLevelMeter
 */
CriSint32 CRIAPI criAtomMeter_CalculateWorkSizeForLevelMeter(
	const CriAtomLevelMeterConfig *config);

/*JP
 * \brief x[^[@\̒ǉ
 * \ingroup ATOMLIB_METER
 * \param[in]	config			x[^[ǉp̃RtBO\
 * \param[in]	work			[N̈
 * \param[in]	work_size		[N̈TCY
 * \par :
 * CuɃx[^[@\ǉ܂B<br>
 * config NULLw肷ƃftHgݒŃx[^[ǉ܂B<br>
 * work NULLAwork_size 0w肷ƁAo^ꂽ[UAP[^[ɂ
 * [N̈悪mۂ܂B<br>
 * \sa criAtomMeter_GetLevelInfo
 */
void CRIAPI criAtomMeter_AttachLevelMeter(
	const CriAtomLevelMeterConfig *config, void *work, CriSint32 work_size);

/*JP
 * \brief x[^[@\̉
 * \ingroup ATOMLIB_METER
 * \par :
 * Cũx[^[@\܂B<br>
 * \sa criAtomMeter_AttachLevelMeter
 */
void CRIAPI criAtomMeter_DetachLevelMeter(void);

/*JP
 * \brief x̎擾
 * \ingroup ATOMLIB_METER
 * \param[out]	info			x̍\
 * \par :
 * x[^[̌ʂ擾܂B<br>
 * w肷oXɂ ::criAtomMeter_AttachLevelMeter ֐ł炩
 * x[^[@\ǉĂKv܂B<br>
 * \sa criAtomMeter_AttachLevelMeter
 */
void CRIAPI criAtomMeter_GetLevelInfo(CriAtomLevelInfo *info);

/*JP
 * \brief EhlX[^[@\p̃[NTCY̌vZ
 * \ingroup ATOMLIB_METER
 * \param[in]	config			EhlX[^[ǉp̃RtBO\
 * \return		CriSint32		Kvȃ[N̈TCY
 * \par :
 * ITU-R BS.1770-3KĩEhlX[^[ǉɕKvȃ[N̈TCYvZ܂B<br>
 * config NULLw肷ƃftHgݒŌvZ܂B<br>
 * \sa criAtomMeter_AttachLoudnessMeter
 */
CriSint32 CRIAPI criAtomMeter_CalculateWorkSizeForLoudnessMeter(const CriAtomLoudnessMeterConfig *config);

/*JP
 * \brief EhlX[^[@\̒ǉ
 * \ingroup ATOMLIB_METER
 * \param[in]	config			EhlX[^[ǉp̃RtBO\
 * \param[in]	work			[N̈
 * \param[in]	work_size		[N̈TCY
 * \par :
 * CuITU-R BS.1770-3KĩEhlX[^[@\ǉ܂B<br>
 * config NULLw肷ƃftHgݒŃEhlX[^[ǉ܂B<br>
 * work NULLAwork_size 0w肷ƁAo^ꂽ[UAP[^[ɂ
 * [N̈悪mۂ܂B<br>
 * \sa criAtomMeter_GetLoudnessInfo
 */
void CRIAPI criAtomMeter_AttachLoudnessMeter(const CriAtomLoudnessMeterConfig *config, void *work, CriSint32 work_size);

/*JP
 * \brief EhlX[^[@\̉
 * \ingroup ATOMLIB_METER
 * \par :
 * CũEhlX[^[@\܂B<br>
 * \sa criAtomMeter_AttachLoudnessMeter
 */
void CRIAPI criAtomMeter_DetachLoudnessMeter(void);

/*JP
 * \brief EhlX̎擾
 * \ingroup ATOMLIB_METER
 * \param[out]	info		EhlX̍\
 * \par :
 * EhlX[^[̑茋ʂ擾܂B
 * {֐ĂяoOɃCuփEhlX[^[ǉĂKv܂B
 * \sa criAtomMeter_AttachLoudnessMeter
 */
void CRIAPI criAtomMeter_GetLoudnessInfo(CriAtomLoudnessInfo *info);

/*JP
 * \brief EhlX[^[̃Zbg
 * \ingroup ATOMLIB_METER
 * \par :
 * EhlX[^[̒~σf[^Zbg܂B
 * {֐ĂяoOɃCuփEhlX[^[ǉĂKv܂B
 * \sa criAtomMeter_AttachLoudnessMeter
 */
void CRIAPI criAtomMeter_ResetLoudnessMeter(void);

/*JP
 * \brief gD[s[N[^[@\p̃[NTCY̌vZ
 * \ingroup ATOMLIB_METER
 * \param[in]	config			gD[s[N[^[ǉp̃RtBO\
 * \return		CriSint32		Kvȃ[N̈TCY
 * \par :
 * ITU-R BS.1770-3KĩgD[s[N[^[ǉɕKvȃ[N̈TCYvZ܂B<br>
 * config NULLw肷ƃftHgݒŌvZ܂B<br>
 * \sa criAtomMeter_AttachTruePeakMeter
 */
CriSint32 CRIAPI criAtomMeter_CalculateWorkSizeForTruePeakMeter(const CriAtomTruePeakMeterConfig *config);

/*JP
 * \brief gD[s[N[^[@\̒ǉ
 * \ingroup ATOMLIB_METER
 * \param[in]	config			gD[s[N[^[ǉp̃RtBO\
 * \param[in]	work			[N̈
 * \param[in]	work_size		[N̈TCY
 * \par :
 * CuITU-R BS.1770-3KĩgD[s[N[^[@\ǉ܂B<br>
 * config NULLw肷ƃftHgݒŃgD[s[N[^[ǉ܂B<br>
 * work NULLAwork_size 0w肷ƁAo^ꂽ[UAP[^[ɂ
 * [N̈悪mۂ܂B<br>
 * \sa criAtomMeter_GetTruePeakInfo
 */
void CRIAPI criAtomMeter_AttachTruePeakMeter(const CriAtomTruePeakMeterConfig *config, void *work, CriSint32 work_size);

/*JP
 * \brief gD[s[N[^[@\̉
 * \ingroup ATOMLIB_METER
 * \par :
 * CũgD[s[N[^[@\܂B<br>
 * \sa criAtomMeter_AttachLoudnessMeter
 */
void CRIAPI criAtomMeter_DetachTruePeakMeter(void);

/*JP
 * \brief gD[s[N̎擾
 * \ingroup ATOMLIB_METER
 * \param[out]	info		gD[s[N̍\
 * \par :
 * gD[s[N[^[̑茋ʂ擾܂B
 * {֐ĂяoOɃCuփgD[s[N[^[ǉĂKv܂B
 * \sa criAtomMeter_AttachTruePeakMeter
 */
void CRIAPI criAtomMeter_GetTruePeakInfo(CriAtomTruePeakInfo *info);

/* ========================================================================*/
/*       CRI Atom Instrument API                                           */
/* ========================================================================*/
/*JP
 * \brief [U`CXgDgC^[tF[X̓o^
 * \param[in]	ainst_interface	[U`CXgDg̃o[WtC^[tF[X
 * \return						o^ɐHiCRI_TRUE:o^ɐ, CRI_FALSE:o^Ɏsj
 * \par :
 * [U`CXgDgC^[tF[XAtomCuɓo^܂B<br>
 * [U`CXgDgC^[tF[Xo^CXgDǵACXgDggbN̍ĐɎgpł悤ɂȂ܂B<br>
 * ȉ̏ɊYꍇ́A[U`CXgDgC^[tF[X̓o^ɎsAG[R[obNԂ܂:
 *  - ̃GtFNg[U`CXgDgC^[tF[Xɓo^Ă
 *  - AtomgpĂ郆[U`CXgDgC^[tF[XƈقȂ
 *  - [U`GtFNgC^[tF[X̓o^i ::CRIATOMEXASR_MAX_NUM_USER_EFFECT_INTERFACES jɒB
 * \par :
 * [U`CXgDgC^[tF[X́ACXgDggbNĐO<br>
 * {֐ɂēo^sĉB<br>
 * AtomCugpɃC^[tF[X̓o^sꍇ́A ::criAtomInstrument_UnregisterInstrumentInterface gpĉB
 * \sa criAtomInstrument_UnregisterInstrumentInterface
 */
CriBool CRIAPI criAtomInstrument_RegisterInstrumentInterface(CriAtomAinstInterfaceWithVersionPtr ainst_interface);

/*JP
 * \brief [U`CXgDgC^[tF[X̓o^
 * \param[in]	ainst_interface	[U`CXgDg̃o[WtC^[tF[X
 * \par :
 * CXgDgC^[tF[X̓o^܂B<br>
 * o^CXgDg̓CXgDggbNĐۂɎgpłȂȂ܂B<br>
 * o^sĂȂCXgDgC^[tF[X̓o^邱Ƃ͂ł܂iG[R[obNԂ܂jB
 * \par :
 * o^s[U`CXgDgC^[tF[X̓v[[̍ĐɎQƂꑱ邽߁A<br>
 * SẴv[[~ŁA{֐sĂB<br>
 * AtomCȕIi::criAtom_Finalize ֐̌Ăяojɂ͑SẴ[U`CXgDgC^[tF[X̓o^܂B
 * \sa  criAtomInstrument_RegisterInstrumentInterface
 */
void CRIAPI criAtomInstrument_UnregisterInstrumentInterface(CriAtomAinstInterfaceWithVersionPtr ainst_interface);

/***************************************************************************
 *      bAPIigp͂Tj
 *      Tentative API (Please don't use it)
 ***************************************************************************/
/* ȉɐ錾Ă֐Atom̓pAQ[GWƂ̘Agɂ
 * bIɎgpĂAPIłB
 * ̃Abvf[gɂė\ȂύXE폜s邽߁Agp͂TB
 */
typedef void (CRIAPI *CriAtomPlayerDataEndCbFunc)(void *obj, void *buffer, CriSint32 size);
typedef void (CRIAPI *CriAtomPlayerCbFunc)(void *obj, CriAtomPlayerHn player);
typedef void (CRIAPI *CriAtomPlayerDecodeCbFunc)(void *obj, CriAtomPcmFormat format,
	CriSint32 num_channels, CriSint32 num_samples, void *data[]);
void CRIAPI criAtomPlayer_BreakLoop(CriAtomPlayerHn player);
void CRIAPI criAtomPlayer_SetDataEndCallback(
	CriAtomPlayerHn player, CriAtomPlayerDataEndCbFunc func, void *obj);
void CRIAPI criAtomPlayer_SetDecodeCallback(
	CriAtomPlayerHn player, CriAtomPlayerDecodeCbFunc func, void *obj);
void CRIAPI criAtomPlayer_DiscardSamples(CriAtomPlayerHn player, CriSint32 num_discard);
typedef CriSint32 CriAtomWaveType;
void CRIAPI criAtomDbas_EnableDbas(void);
void CRIAPI criAtomDbas_DisableDbas(void);

#ifdef __cplusplus
}
#endif

/***************************************************************************
 *      o[WƂ̌݊p
 *      For compatibility with old version
 ***************************************************************************/
typedef enum CriAtomDownmixModeTag {
	CRIATOM_DOWNMIX_MODE_NONE = 0,
	CRIATOM_DOWNMIX_MODE_MONO = 1,
	CRIATOM_DOWNMIX_MODE_STEREO = 2,
	CRIATOM_DOWNMIX_MODE_STEREO_AND_LFE = 3,
	CRIATOM_DOWNMIX_MODE_ENUM_SIZE_IS_4BYTES = 0x7FFFFFFF
} CriAtomDownmixMode;

/*JP
 * \brief AmbisonicsI[_[ip~ς݁j
 * \ingroup ATOMLIB_GLOBAL
 * \par :
 * AmbisonicsI[_[^Cv܂B݂͔p~ς݂łB
 */
typedef enum CriAtomAmbisonicsOrderTypeTag {
	CRIATOMAMBISONICS_ORDER_TYPE_NONE = 0,	/*JP< ݒ */
	CRIATOMAMBISONICS_ORDER_TYPE_FIRST,		/*JP< 1st Order */
	CRIATOMAMBISONICS_ORDER_TYPE_1P = CRIATOMAMBISONICS_ORDER_TYPE_FIRST,	/*JP< 1 Periphonic(1st OrderƓ`) */
	CRIATOMAMBISONICS_ORDER_TYPE_ENUM_SIZE_IS_4BYTES = 0x7FFFFFFF
} CriAtomAmbisonicsOrderType;

#define CRI_ATOM_VERSION				(0xFFFFFFFF)
#define CRIATOMAWB_STATUS_NONE			(CRIATOMAWB_STATUS_STOP)
#define criAtomPlayer_SetPitch(player, pitch)	\
	criAtomPlayer_SetFrequencyRatio((player), (pitch))
#define criAtomPlayer_SetPan(player, ch, pan) \
	criAtomPlayer_SetPanAdx1Compatible((player), (ch), (pan))
/* _[̏oChݒɉāAŃ_E~bNX邽߉L֐͖ɂĂ܂ */
#define criAtom_SetDownmixMode(downmix_mode)
#define criAtomHcaMx_SetBusSendLevel(mixer_id, bus_no, level) \
	criAtomExHcaMx_SetBusSendLevel(mixer_id, bus_no, level)
#define CRIATOM_SPEAKER_MAPPING_OBJECT CRIATOM_SPEAKER_MAPPING_OBJECT_16

#ifdef __cplusplus
extern "C" {
#endif

/*JP
 * \deprecated
 * 폜\̔񐄏APIłB
 * {֐sA 0xFFFFFFFF ԋp܂B
 * ::criAtom_GetVersionString ֐̎gpĂB
 */
CriUint32 CRIAPI criAtom_GetVersionNumber(void);

#ifdef __cplusplus
}
#endif

#endif	/* CRI_INCL_CRI_ATOM_H */

/* --- end of file --- */
