#
# CRI Middleware SDK
# Copyright (c) 2019 CRI Middleware Co., Ltd.
#

import criatomcraft_api_lib
import json
from . import common
from . import debug
from . import error
from . import project

ACAPIMODULE_DSP = "dsp"
ACAPIMODULE_PROJECT = "project"

def add_dsp_bus_send(dsp_bus_from, dsp_bus_to, send_level = 1.0):
    debug.warning("[add_dsp_bus_send] Use project.add_mixer_bus_send instead.")
    return project.add_mixer_bus_send(dsp_bus_from, dsp_bus_to, send_level)

def copy_dsp_bus_effect(effect, destination_dsp_bus, destination_effect):
    debug.warning("[copy_dsp_bus_effect] Use project.copy_bus_effect instead.")
    return project.copy_bus_effect(effect, destination_dsp_bus, destination_effect)

def create_dsp_bus(parent_dsp_bus_settings, dsp_bus_name):
    debug.warning("[create_dsp_bus] Use project.create_object instead.")
    arguments = {}
    arguments["parent"] = parent_dsp_bus_settings
    arguments["object_type"] = "Bus"
    arguments["object_name"] = dsp_bus_name
    return common.call_api(ACAPIMODULE_PROJECT, "create_object", arguments, True)

def create_dsp_bus_settings(name):
    debug.warning("[create_dsp_bus_settings] Use project.create_mixer instead.")
    return project.create_mixer(name)

def delete_dsp_bus(parent_dsp_bus_settings, dsp_bus_name):
    return project.delete_dsp_bus(parent_dsp_bus_settings, dsp_bus_name)

def get_dsp_bus(parent_dsp_bus_settings, dsp_bus_name):
    debug.warning("[get_dsp_bus] Use project.get_child_object instead.")
    arguments = {}
    arguments["parent"] = parent_dsp_bus_settings
    arguments["object_type"] = "Bus"
    arguments["object_name"] = dsp_bus_name
    return common.call_api(ACAPIMODULE_PROJECT, "get_child_object", arguments, True)

def get_dsp_bus_effect(dsp_bus, effect_name):
    debug.warning("[get_dsp_bus_effect] Use project.get_bus_effect instead.")
    return project.get_bus_effect(dsp_bus, effect_name)

def get_masterout_dsp_bus(parent_dsp_bus_settings):
    debug.warning("[get_masterout_dsp_bus] Use project.get_child_object instead.")
    arguments = {}
    arguments["parent"] = parent_dsp_bus_settings
    arguments["object_type"] = "BusMaster"
    arguments["object_name"] = "MasterOut"
    return common.call_api(ACAPIMODULE_PROJECT, "get_child_object", arguments, True)

def move_dsp_bus(dsp_bus, move_destination_dsp_bus):
    debug.warning("[move_dsp_bus] Use project.move_bus instead.")
    return project.move_bus(dsp_bus, move_destination_dsp_bus)

def move_dsp_bus_effect(effect, destination_dsp_bus, destination_effect):
    debug.warning("[move_dsp_bus_effect] Use project.move_object instead.")
    arguments = {}
    arguments["target"] = effect
    if destination_dsp_bus is not None:
        arguments["destination_parent"] = destination_dsp_bus
    if destination_effect is not None:
        arguments["destination_object"] = destination_effect
    return common.call_api(ACAPIMODULE_PROJECT, "move_object", arguments, False)

def remove_dsp_bus_send(dsp_bus_from, dsp_bus_to):
    debug.warning("[remove_dsp_bus_send] Use project.remove_mixer_bus_send instead.")
    return project.remove_mixer_bus_send(dsp_bus_from, dsp_bus_to)

def sync_snapshot_effect_parameters(effect, snapshot):
    debug.warning("Use project.sync_snapshot_effect_parameters instead.")
    return project.sync_snapshot_effect_parameters(effect, snapshot)
