# CRI Middleware SDK
# Copyright (c) 2021 CRI Middleware Co., Ltd.
# CRI Atom Craft Robot Samples
# Version : 1.0.0
#
# --Description:[ja]キューシート内で使用している音声ファイルの列挙
# --Description:[en]Enumerate the audio files used in the Cue Sheet
# --Description:[zh]Cue Sheet内使用的音频文件的枚举

import sys
import cri.atomcraft.debug as acdebug
import cri.atomcraft.project as acproject
import cri.atomcraft.project

# Get the selected Cue Sheet
cuesheets = acproject.get_selected_objects("CueSheet")["data"]

if len(cuesheets) != 1:
    acdebug.warning("Please select a Cue Sheet.")
    sys.exit()

cuesheet = cuesheets[0]

acdebug.log("Start the enumeration of the audio files used in the Cue Sheet")

# Get the Cue.
cues = acproject.find_objects(cuesheet, "Cue")["data"]

# Use "set" to avoid duplicate file names
link_materials = set()

for cue in cues:
    # Get Waveform Region.
    waveform_regions = acproject.find_objects(cue, "WaveformRegion")["data"]

    # Get the Material used from the "LinkMaterial" field
    # of the Waveform Region.
    for waveform_region in waveform_regions:
        link_material = acproject.get_value(waveform_region, "LinkMaterial")["data"]
        link_materials.add(link_material)

# Output the list of audio files used.
for link_material in link_materials:
    file_name = acproject.get_value(link_material, "Name")["data"]
    file_path = acproject.get_value(link_material, "SrcFileAbsolutePath")["data"]
    acdebug.log(file_name + ", " + file_path)

acdebug.log("Completed the enumeration of the audio files used in the Cue Sheet")
