#
# CRI Middleware SDK
# Copyright (c) 2019 CRI Middleware Co., Ltd.
#

import criatomcraft_api_lib
import json
from . import error

ATOMCRAFT_API_REQUEST_VERSION = "1.0.0"

def call_api(module_name, function_name, arguments, has_returns):
    # create request
    request_json = {}
    request_json["request"] = {}
    request_json["request"]["version"] = ATOMCRAFT_API_REQUEST_VERSION
    request_json["request"]["module"] = module_name
    request_json["request"]["function"] = function_name
    if arguments is not None:
        request_json["request"]["arguments"] = arguments
    log_json_txt = json.dumps(request_json)
    # call
    result_json_txt = criatomcraft_api_lib.call(log_json_txt)
    # parse response
    decode_succeed = True
    try:
        result_json = json.loads(result_json_txt)
    except json.JSONDecodeError as e:
        decode_succeed = False
    if not decode_succeed:
        return error.make_response_parse_error(has_returns)
    if not "response" in result_json:
        return error.make_response_parse_error(has_returns)
    res_top = result_json["response"]
    if not "status" in res_top:
        return error.make_response_parse_error(has_returns)
    res_top["succeed"] = res_top["status"] == "success"
    if res_top["status"] != "success":
        error.make_response_error_message(res_top, has_returns)
    return res_top
