# CRI Middleware SDK
# Copyright (c) 2020 CRI Middleware Co., Ltd.
# CRI Atom Craft Robot Samples
# Version : 1.0.0
#
# --Description:[ja]AISACグラフのコピー＆ペースト
# --Description:[en]Copy and paste AISAC graph
# --Description:[zh]复制粘贴AISAC图形

import sys
import cri.atomcraft.project
import cri.atomcraft.project as acproject
import cri.atomcraft.debug as acdebug


# --BeginUserVariable
"""
SOURCE_AISAC:
  type: object
  comment: the AISAC object to copy the graph from.
DEST_AISAC:
  type: object
  comment: the AISAC object to paste the graph into.
AISAC_GRAPH_TYPE:
  type: string
  comment: the name of the AISAC graph to copy.
"""
SOURCE_AISAC = None
DEST_AISAC = None
AISAC_GRAPH_TYPE = "Volume"
# --EndUserVariable

if not SOURCE_AISAC:
    acdebug.warning("Specify the AISAC from which to copy the graph.")
    sys.exit()

if not DEST_AISAC:
    acdebug.warning("Specify the AISAC into which to paste the graph.")
    sys.exit()

if not AISAC_GRAPH_TYPE:
    acdebug.warning("Specify the name of the AISAC graph to copy.")
    sys.exit()

# Get the AISAC graph to copy from the source AISAC.
source_aisac_graph = acproject.get_aisac_graph(SOURCE_AISAC, AISAC_GRAPH_TYPE)["data"]
if not source_aisac_graph:
    source_aisac_name = acproject.get_value(SOURCE_AISAC, "Name")["data"]
    acdebug.warning("The graph type {0} does not exist in the source AISAC {1}. Terminate script execution.".format(AISAC_GRAPH_TYPE, source_aisac_name))
    sys.exit()

# Copy AISAC graph
result = acproject.copy_object(source_aisac_graph, DEST_AISAC)

if not result["succeed"]:
    acdebug.warning("Failed to paste the AISAC graph.")
    sys.exit()

acdebug.log("The copy-paste of the AISAC graph is completed.")
