# CRI Middleware SDK
# Copyright (c) 2020 CRI Middleware Co., Ltd.
# CRI Atom Craft Robot Samples
# Version : 1.0.0
# 
# --Description:[ja]選択キューのカテゴリを置き換え
# --Description:[en]Replace Categories in selected Cues.
# --Description:[zh]替换选择Cue的类别

import sys
import cri.atomcraft.debug as acdebug
import cri.atomcraft.project as acproject
import cri.atomcraft.project

# --BeginUserVariable
"""
REPLACE_FROM:
  type: object
  comment: Category to be replaced.
REPLACE_TO:
  type: object
  comment: Category to use as replacement.
"""
REPLACE_FROM = None
REPLACE_TO = None
# --EndUserVariable


if not REPLACE_FROM:
    acdebug.warning("Please set the Category to be replaced with the user variable.")
    sys.exit()

if not REPLACE_TO:
    acdebug.warning("Please set the new Category with the user variable.")
    sys.exit()

# Get the selected Cues
selected_cues = acproject.get_selected_objects("Cue")["data"]
if not selected_cues:
    acdebug.warning("Please select at least one Cue.")
    sys.exit()

category_name_before = acproject.get_value(REPLACE_FROM, "Name")["data"]
category_name_after = acproject.get_value(REPLACE_TO, "Name")["data"]
acdebug.log("Start replacing Category \"{0}\" with Category \"{1}\" in the selected Cues.".format(category_name_before, category_name_after))

modified_cues = []

for cue in selected_cues:
    # Get the Categories assigned to the Cue.
    categories = acproject.get_categories(cue)["data"]

    for i, category in enumerate(categories):
        if category == REPLACE_FROM:
            # The Category is a match.
            categories[i] = REPLACE_TO
            acproject.set_categories(cue, categories)
            modified_cues.append(cue)
            break

if modified_cues:
    acdebug.log("Replaced Category in {0} Cues.".format(len(modified_cues)))

acdebug.log("The Category has been replaced.")