# CRI Middleware SDK
# Copyright (c) 2021 CRI Middleware Co., Ltd.
# CRI Atom Craft Robot Samples
# Version : 1.0.0
#
# --Description:[ja]カテゴリが登録されていないキューの列挙
# --Description:[en]Enumerate the Cues that are not part of a specific Category
# --Description:[zh]未注册类别的Cue的枚举

import sys
import cri.atomcraft.debug as acdebug
import cri.atomcraft.project as acproject
import cri.atomcraft.project

# --BeginUserVariable
"""
SEARCH_CATEGORY:
  type:object
  comment:The Category to be looked for in the Cues
"""
SEARCH_CATEGORY = None
# --EndUserVariable


if not SEARCH_CATEGORY:
    acdebug.warning("Please select a Category.")
    sys.exit()

# Get the Cues selected on the GUI.
selected_cues = acproject.get_selected_objects("Cue")["data"]
if not selected_cues:
    acdebug.warning("Please select one or more Cues.")
    sys.exit()

# Get the name of the Category to look for.
search_category_name = acproject.get_value(SEARCH_CATEGORY, "Name")["data"]
acdebug.log(f"Specified Category name: {search_category_name}")

# A variable to count the Cues that are not part of the specified Category.
category_not_set_cue_count = 0

for cue in selected_cues:
    # A flag that indicates if the Cue is part of the Category.
    is_set_category = False

    # Get the list of categories assigned to the Cue.
    category_list = acproject.get_categories(cue)["data"]
    
    # Check if the specified Category is included in the list.
    for category in category_list:
        if category == SEARCH_CATEGORY:
            is_set_category = True
            break

    # Output the name of the Cue if it is not part of the specified Category.
    if not is_set_category:
        # Get the Cue name。
        cue_name = acproject.get_value(cue, "Name")["data"]
        category_not_set_cue_count += 1
        acdebug.log(f"{cue_name} is not a member of the {search_category_name} Category.")

# Output the number of Cues that are not part of the specified Category.
acdebug.log(f"Number of Cues that are not part of the specified Category: {category_not_set_cue_count}")
