# CRI Middleware SDK
# Copyright (c) 2021 CRI Middleware Co., Ltd.
# CRI Atom Craft Robot Samples
# Version : 1.0.0
#
# --Description:[ja]片方のマテリアルフォルダーにしか存在しないマテリアルを列挙
# --Description:[en]Find Materials only present in one Material folder
# --Description:[zh]枚举只存在于单个的素材文件夹中的素材

import sys
import cri.atomcraft.debug as acdebug
import cri.atomcraft.project as acproject

material_folders = acproject.get_selected_objects("MaterialSubFolder")["data"]
if len(material_folders) != 2:
    acdebug.warning("Please select two Material folders.")
    sys.exit()

acdebug.log("Start enumerating the files which exist only in one of the Material folders.")

# The function to get the relative path of the Material.
def get_relative_path(material_folder_obj, material_obj):
    # Get the absolute path of the Material folder
    material_folder_path = acproject.get_object_path(material_folder)["data"]
    # Get the absolute path of the Material
    material_absolute_path = acproject.get_object_path(material)["data"] 
    # Get the relative path of the Material
    material_relative_path = material_absolute_path.split(material_folder_path)[-1]
    return material_relative_path


# Store the relative path of the Material for each folder.
material_paths = {"1st_folder": [], "2nd_folder": []}

# Get the relative path of the Material in the first Material folder.
material_folder = material_folders[0]
for material in acproject.find_objects(material_folder, "Material")["data"]:
    material_relative_path = get_relative_path(material_folder, material)
    material_paths["1st_folder"].append(material_relative_path)

# Get the relative path of the Material in the second Material folder.
material_folder = material_folders[1]
for material in acproject.find_objects(material_folder, "Material")["data"]:
    material_relative_path = get_relative_path(material_folder, material)
    material_paths["2nd_folder"].append(material_relative_path)

# Enumerate the relative paths of the Materials which exist only in the first folder.
material_folder_name = acproject.get_value(material_folders[0], "Name")["data"]
acdebug.log(f"----- Files which exist only in {material_folder_name} -----")
for material_relative_path in material_paths["1st_folder"]:
    if not material_relative_path in material_paths["2nd_folder"]:
        acdebug.log(f"{material_relative_path}")

# Enumerate the relative paths of the Materials which exist only in the second folder.
material_folder_name = acproject.get_value(material_folders[1], "Name")["data"]
acdebug.log(f"----- Files which exist only in {material_folder_name} -----")
for material_relative_path in material_paths["2nd_folder"]:
    if not material_relative_path in material_paths["1st_folder"]:
        acdebug.log(f"{material_relative_path}")

acdebug.log("Completed the enumeration of the files which exist only in one of the Material folders.")
