# CRI Middleware SDK
# Copyright (c) 2020 CRI Middleware Co., Ltd.
# CRI Atom Craft Robot Samples
# Version : 1.0.0
# 
# --Description:[ja]オートメーショングラフのコピー＆ペースト
# --Description:[en]Copy and paste an Automation graph
# --Description:[zh]复制粘贴自动化图形

import sys
import cri.atomcraft.project
import cri.atomcraft.project as acproject
import cri.atomcraft.debug as acdebug

# Copy automation graph
def copy_automation(target_automation_graph, destination_sequence):
    automation_graph = acproject.create_automation(destination_sequence, AUTOMATION_GRAPH_TYPE)["data"]
    if not automation_graph:
        return False
    
    automation_point_list = acproject.get_child_objects(target_automation_graph, "AutomationPoint")["data"]
    for point in automation_point_list:
        acproject.copy_object(point, automation_graph)

    return True

# --BeginUserVariable
"""
SOURCE_SEQUENCE:
  type: object
  comment: Cue object or Track object to copy the automation graph from.
DEST_SEQUENCE:
  type: object
  comment: Cue object or Track object to paste the automation graph into.
AUTOMATION_GRAPH_TYPE:
  type: string
  comment: Automation graph type name.
"""
SOURCE_SEQUENCE = None
DEST_SEQUENCE = None
AUTOMATION_GRAPH_TYPE = ""
# --EndUserVariable

if not SOURCE_SEQUENCE:
    acdebug.warning("Specify the Cue or the Track to copy the automation graph from.")
    sys.exit()

if not DEST_SEQUENCE:
    acdebug.warning("Specify the Cue or the Track to paste the automation graph into.")
    sys.exit()

if not AUTOMATION_GRAPH_TYPE:
    acdebug.warning("Specify the name of the automation graph to copy.")
    sys.exit()

# Get the automation graph to copy from the source object.
source_automation_graph = acproject.get_automation(SOURCE_SEQUENCE, AUTOMATION_GRAPH_TYPE)["data"]

if not source_automation_graph:
    source_sequence_name = acproject.get_value(SOURCE_SEQUENCE, "Name")["data"]
    acdebug.warning("The automation graph type \"{0}\" does not exist in the source object \"{1}\". Terminate script execution.".format(AUTOMATION_GRAPH_TYPE, source_sequence_name))
    sys.exit()

# Copy the automation graph.
succeed = copy_automation(source_automation_graph, DEST_SEQUENCE)

if not succeed:
    acdebug.warning("Failed to paste the automation graph.")
    sys.exit()

acdebug.log("The copy-paste of the automation graph is completed.")
