#
# CRI Middleware SDK
# Copyright (c) 2019 CRI Middleware Co., Ltd.
#

import criatomcraft_api_lib
import json
from . import common
from . import debug
from . import error

ACAPIMODULE_PROJECT = "project"

def add_bookmark(target):
    arguments = {}
    arguments["target"] = target
    return common.call_api(ACAPIMODULE_PROJECT, "add_bookmark", arguments, False)

def add_category_to_cues(cue_list, category):
    arguments = {}
    arguments["cue_list"] = cue_list
    arguments["category"] = category
    return common.call_api(ACAPIMODULE_PROJECT, "add_category_to_cues", arguments, False)

def add_mixer_bus_send(bus_from, bus_to, send_level = 1.0):
    arguments = {}
    arguments["bus_from"] = bus_from
    arguments["bus_to"] = bus_to
    arguments["send_level"] = str(send_level)
    return common.call_api(ACAPIMODULE_PROJECT, "add_mixer_bus_send", arguments, False)

def copy_bus_effect(bus_effect, destination_bus, destination_bus_effect):
    arguments = {}
    arguments["bus_effect"] = bus_effect
    if destination_bus is not None:
        arguments["destination_bus"] = destination_bus
    if destination_bus_effect is not None:
        arguments["destination_bus_effect"] = destination_bus_effect
    return common.call_api(ACAPIMODULE_PROJECT, "copy_bus_effect", arguments, False)

def copy_object(target, destination_parent):
    arguments = {}
    arguments["target"] = target
    arguments["destination_parent"] = destination_parent
    return common.call_api(ACAPIMODULE_PROJECT, "copy_object", arguments, True)

def create_aisac(parent, object_name, aisac_control):
    arguments = {}
    arguments["parent"] = parent
    arguments["object_name"] = object_name
    arguments["aisac_control"] = aisac_control
    return common.call_api(ACAPIMODULE_PROJECT, "create_aisac", arguments, True)

def create_aisac_graph(aisac, graph_type):
    arguments = {}
    arguments["aisac"] = aisac
    arguments["graph_type"] = graph_type
    return common.call_api(ACAPIMODULE_PROJECT, "create_aisac_graph", arguments, True)

def create_aisac_point(aisac_graph, aisac_control_value, aisac_destination_value):
    arguments = {}
    arguments["aisac_graph"] = aisac_graph
    arguments["aisac_control_value"] = str(aisac_control_value)
    arguments["aisac_destination_value"] = str(aisac_destination_value)
    return common.call_api(ACAPIMODULE_PROJECT, "create_aisac_point", arguments, True)

def create_aisaclink(parent, aisac):
    arguments = {}
    arguments["parent"] = parent
    arguments["aisac"] = aisac
    return common.call_api(ACAPIMODULE_PROJECT, "create_aisaclink", arguments, True)

def create_automation(parent, graph_type):
    arguments = {}
    arguments["parent"] = parent
    arguments["graph_type"] = graph_type
    return common.call_api(ACAPIMODULE_PROJECT, "create_automation", arguments, True)

def create_automation_point(automation, time_ms, automation_destination_value):
    arguments = {}
    arguments["automation"] = automation
    arguments["time_ms"] = str(time_ms)
    arguments["automation_destination_value"] = str(automation_destination_value)
    return common.call_api(ACAPIMODULE_PROJECT, "create_automation_point", arguments, True)

def create_beatsync(parent, time_ms, bpm = 120.0, numerator = 4, pattern_strlist = [], beatsync_label = None):
    arguments = {}
    arguments["parent"]    = parent
    arguments["time_ms"]   = str(time_ms)
    arguments["bpm"]       = str(bpm)
    arguments["numerator"] = str(numerator)
    arguments["beat_pattern"] = pattern_strlist
    arguments["label"]     = beatsync_label
    return common.call_api(ACAPIMODULE_PROJECT, "create_beatsync", arguments, True)

def create_beatsync_track(parent, beatsync_label = None):
    arguments = {}
    arguments["parent"]    = parent
    arguments["label"]     = beatsync_label
    return common.call_api(ACAPIMODULE_PROJECT, "create_beatsynctrack", arguments, True)

def create_busmap_for_cue(busmap_name):
    arguments = {}
    arguments["busmap_name"] = busmap_name
    return common.call_api(ACAPIMODULE_PROJECT, "create_busmap_for_cue", arguments, True)

def create_cuelink(target, cue):
    arguments = {}
    arguments["target"] = target
    arguments["cue"] = cue
    return common.call_api(ACAPIMODULE_PROJECT, "create_cuelink", arguments, True)

def create_custom_busmap(cue):
    arguments = {}
    arguments["cue"] = cue
    return common.call_api(ACAPIMODULE_PROJECT, "create_custom_busmap", arguments, True)

def create_external_cuelink(target, link_cue_name, link_cue_id):
    arguments = {}
    arguments["target"] = target
    if link_cue_name is not None:
        arguments["link_cue_name"] = link_cue_name
    if link_cue_id is not None:
        arguments["link_cue_id"] = str(link_cue_id)
    return common.call_api(ACAPIMODULE_PROJECT, "create_external_cuelink", arguments, True)

def create_language_settings(object_name, reference_folder_name, output_folder_name):
    arguments = {}
    arguments["object_name"] = object_name
    arguments["reference_folder_name"] = reference_folder_name
    if output_folder_name is not None:
        arguments["output_folder_name"] = output_folder_name
    return common.call_api(ACAPIMODULE_PROJECT, "create_language_settings", arguments, True)

def create_lipsync_file(target):
    arguments = {}
    arguments["target"] = target
    return common.call_api(ACAPIMODULE_PROJECT, "create_lipsync_file", arguments, True)

def create_mixer(object_name):
    arguments = {}
    arguments["object_name"] = object_name
    return common.call_api(ACAPIMODULE_PROJECT, "create_mixer", arguments, True)

def create_object(parent, object_type, object_name):
    arguments = {}
    arguments["parent"] = parent
    arguments["object_type"] = object_type
    arguments["object_name"] = object_name
    return common.call_api(ACAPIMODULE_PROJECT, "create_object", arguments, True)

def create_project(project_root_folder, project_name, overwrite = False):
    arguments = {}
    arguments["project_root_folder"] = project_root_folder
    arguments["project_name"] = project_name
    arguments["overwrite"] = str(overwrite)
    return common.call_api(ACAPIMODULE_PROJECT, "create_project", arguments, False)

def create_simple_cue(parent, material):
    arguments = {}
    arguments["parent"] = parent
    arguments["material"] = material
    return common.call_api(ACAPIMODULE_PROJECT, "create_simple_cue", arguments, True)

def create_target_config(target_config_type, target_config_name):
    arguments = {}
    arguments["target_config_type"] = target_config_type
    arguments["target_config_name"] = target_config_name
    return common.call_api(ACAPIMODULE_PROJECT, "create_target_config", arguments, True)

def create_waveform_region(parent, material):
    arguments = {}
    arguments["parent"] = parent
    arguments["material"] = material
    return common.call_api(ACAPIMODULE_PROJECT, "create_waveform_region", arguments, True)

def create_workunit(workunit_name, use_individual_material, default_busmap, workunit_folder = None):
    arguments = {}
    arguments["workunit_name"] = workunit_name
    arguments["use_individual_material"] = str(use_individual_material)
    if default_busmap is not None:
        arguments["default_busmap"] = default_busmap
    if workunit_folder is not None:
        arguments["workunit_folder"] = workunit_folder
    return common.call_api(ACAPIMODULE_PROJECT, "create_workunit", arguments, True)

def delete_object(target):
    arguments = {}
    arguments["target"] = target
    return common.call_api(ACAPIMODULE_PROJECT, "delete_object", arguments, False)

def delete_workunit(workunit_name):
    arguments = {}
    arguments["workunit_name"] = workunit_name
    return common.call_api(ACAPIMODULE_PROJECT, "delete_workunit", arguments, False)

def duplicate_object(target):
    arguments = {}
    arguments["target"] = target
    return common.call_api(ACAPIMODULE_PROJECT, "duplicate_object", arguments, True)

def exclude_workunit(workunit):
    arguments = {}
    arguments["workunit"] = workunit
    return common.call_api(ACAPIMODULE_PROJECT, "exclude_workunit", arguments, False)

def find_object(search_root, object_type, object_name):
    arguments = {}
    if search_root is not None:
        arguments["search_root"] = search_root
    arguments["object_type"] = object_type
    arguments["object_name"] = object_name
    return common.call_api(ACAPIMODULE_PROJECT, "find_object", arguments, True)

def find_objects(search_root, object_type):
    arguments = {}
    if search_root is not None:
        arguments["search_root"] = search_root
    arguments["object_type"] = object_type
    return common.call_api(ACAPIMODULE_PROJECT, "find_objects", arguments, True)

def get_actual_value(target, field_name, target_config = None):
    arguments = {}
    arguments["target"] = target
    arguments["field_name"] = field_name
    if target_config is not None:
        arguments["target_config"] = target_config
    return common.call_api(ACAPIMODULE_PROJECT, "get_actual_value", arguments, True)

def get_aisac_graph(aisac, graph_type):
    arguments = {}
    arguments["aisac"] = aisac
    arguments["graph_type"] = graph_type
    return common.call_api(ACAPIMODULE_PROJECT, "get_aisac_graph", arguments, True)

def get_automation(parent, graph_type):
    arguments = {}
    arguments["parent"] = parent
    arguments["graph_type"] = graph_type
    return common.call_api(ACAPIMODULE_PROJECT, "get_automation", arguments, True)

def get_bookmarks():
    return common.call_api(ACAPIMODULE_PROJECT, "get_bookmarks", None, True)

def get_bus_effect(bus, bus_effect_name):
    arguments = {}
    arguments["bus"] = bus
    arguments["bus_effect_name"] = bus_effect_name
    return common.call_api(ACAPIMODULE_PROJECT, "get_bus_effect", arguments, True)

def get_busmap_for_aisac():
    return common.call_api(ACAPIMODULE_PROJECT, "get_busmap_for_aisac", None, True)

def get_busmap_for_cue(busmap_name):
    arguments = {}
    arguments["busmap_name"] = busmap_name
    return common.call_api(ACAPIMODULE_PROJECT, "get_busmap_for_cue", arguments, True)

def get_child_object(parent, object_type, object_name):
    arguments = {}
    arguments["parent"] = parent
    arguments["object_type"] = object_type
    arguments["object_name"] = object_name
    return common.call_api(ACAPIMODULE_PROJECT, "get_child_object", arguments, True)

def get_child_objects(parent, object_type):
    arguments = {}
    arguments["parent"] = parent
    arguments["object_type"] = object_type
    return common.call_api(ACAPIMODULE_PROJECT, "get_child_objects", arguments, True)

def get_categories(cue):
    arguments = {}
    arguments["cue"] = cue
    return common.call_api(ACAPIMODULE_PROJECT, "get_categories", arguments, True)

def get_color(target):
    arguments = {}
    arguments["target"] = target
    return common.call_api(ACAPIMODULE_PROJECT, "get_color", arguments, True)

def get_cuesheet_rootfolder(workunit):
    arguments = {}
    arguments["workunit"] = workunit
    return common.call_api(ACAPIMODULE_PROJECT, "get_cuesheet_rootfolder", arguments, True)

def get_custom_busmap(cue):
    arguments = {}
    arguments["cue"] = cue
    return common.call_api(ACAPIMODULE_PROJECT, "get_custom_busmap", arguments, True)

def get_global_folder(object_type):
    arguments = {}
    arguments["object_type"] = object_type
    return common.call_api(ACAPIMODULE_PROJECT, "get_global_folder", arguments, True)

def get_globalfolder(object_type):
    debug.warning("Use get_global_folder instead.")
    return get_global_folder(object_type)

def get_materialinfo(workunit):
    arguments = {}
    arguments["workunit"] = workunit
    return common.call_api(ACAPIMODULE_PROJECT, "get_materialinfo", arguments, True)

def get_material_rootfolder(workunit):
    arguments = {}
    arguments["workunit"] = workunit
    return common.call_api(ACAPIMODULE_PROJECT, "get_material_rootfolder", arguments, True)

def get_object_from_path(object_path):
    arguments = {}
    arguments["object_path"] = object_path
    return common.call_api(ACAPIMODULE_PROJECT, "get_object_from_path", arguments, True)

def get_object_path(target):
    arguments = {}
    arguments["target"] = target
    return common.call_api(ACAPIMODULE_PROJECT, "get_object_path", arguments, True)

def get_parent(target, object_type):
    arguments = {}
    arguments["target"] = target
    arguments["object_type"] = object_type
    return common.call_api(ACAPIMODULE_PROJECT, "get_parent", arguments, True)

def get_project_materialinfo():
    return common.call_api(ACAPIMODULE_PROJECT, "get_project_materialinfo", None, True)

def get_project_material_rootfolder():
    return common.call_api(ACAPIMODULE_PROJECT, "get_project_material_rootfolder", None, True)

def get_selected_objects(object_type):
    arguments = {}
    arguments["object_type"] = object_type
    return common.call_api(ACAPIMODULE_PROJECT, "get_selected_objects", arguments, True)

def get_type_name(target):
    arguments = {}
    arguments["target"] = target
    return common.call_api(ACAPIMODULE_PROJECT, "get_type_name", arguments, True)

def get_user_settings():
    return common.call_api(ACAPIMODULE_PROJECT, "get_user_settings", None, True)

def get_usersettings():
    debug.warning("Use get_user_settings instead.")
    return get_user_settings()

def get_value(target, field_name):
    arguments = {}
    arguments["target"] = target
    arguments["field_name"] = field_name
    return common.call_api(ACAPIMODULE_PROJECT, "get_value", arguments, True)

def get_values(target, field_names):
    arguments = {}
    arguments["target"] = target
    arguments["field_names"] = field_names
    return common.call_api(ACAPIMODULE_PROJECT, "get_values", arguments, True)

def get_value_from_targets(targets, field_names):
    arguments = {}
    arguments["target_list"] = targets
    arguments["field_name"] = field_names
    return common.call_api(ACAPIMODULE_PROJECT, "get_value_from_targets", arguments, True)

def get_workunit(workunit_name):
    arguments = {}
    arguments["workunit_name"] = workunit_name
    return common.call_api(ACAPIMODULE_PROJECT, "get_workunit", arguments, True)

def include_workunit(workunit_name):
    arguments = {}
    arguments["workunit_name"] = workunit_name
    return common.call_api(ACAPIMODULE_PROJECT, "include_workunit", arguments, True)

def move_bus(bus, destination_bus):
    arguments = {}
    arguments["bus"] = bus
    if destination_bus is not None:
        arguments["destination_bus"] = destination_bus
    return common.call_api(ACAPIMODULE_PROJECT, "move_bus", arguments, False)

def move_object(target, destination_parent, destination_object):
    arguments = {}
    arguments["target"] = target
    if destination_parent is not None:
        arguments["destination_parent"] = destination_parent
    if destination_object is not None:
        arguments["destination_object"] = destination_object
    return common.call_api(ACAPIMODULE_PROJECT, "move_object", arguments, False)

def open_project(file_path):
    arguments = {}
    arguments["file_path"] = file_path
    return common.call_api(ACAPIMODULE_PROJECT, "open_project", arguments, False)

def register_material(parent, file_path):
    arguments = {}
    arguments["parent"] = parent
    arguments["file_path"] = file_path
    return common.call_api(ACAPIMODULE_PROJECT, "register_material", arguments, True)

def register_unregistered_materials(material_folder):
    arguments = {}
    arguments["material_folder"] = material_folder
    return common.call_api(ACAPIMODULE_PROJECT, "register_unregistered_materials", arguments, False)

def remove_bookmark(target):
    arguments = {}
    arguments["target"] = target
    return common.call_api(ACAPIMODULE_PROJECT, "remove_bookmark", arguments, False)

def remove_mixer_bus_send(bus_from, bus_to):
    arguments = {}
    arguments["bus_from"] = bus_from
    arguments["bus_to"] = bus_to
    return common.call_api(ACAPIMODULE_PROJECT, "remove_mixer_bus_send", arguments, False)

def save_project_all():
    return common.call_api(ACAPIMODULE_PROJECT, "save_project_all", None, False)

def save_workunit(workunit):
    arguments = {}
    arguments["workunit"] = workunit
    return common.call_api(ACAPIMODULE_PROJECT, "save_workunit", arguments, False)

def select_object(target):
    arguments = {}
    arguments["target"] = target
    return common.call_api(ACAPIMODULE_PROJECT, "select_object", arguments, False)

def set_categories(cue, category_list):
    arguments = {}
    arguments["cue"] = cue
    arguments["category_list"] = category_list
    return common.call_api(ACAPIMODULE_PROJECT, "set_categories", arguments, False)

def set_color(target, value):
    arguments = {}
    arguments["target"] = target
    arguments["value"] = value
    return common.call_api(ACAPIMODULE_PROJECT, "set_color", arguments, False)

def set_value(target, field_name, value):
    arguments = {}
    arguments["target"] = target
    arguments["field_name"] = field_name
    arguments["value"] = str(value)
    return common.call_api(ACAPIMODULE_PROJECT, "set_value", arguments, False)

def set_values(target, field_name_and_values):
    arguments = {}
    arguments["target"] = target
    field_name_and_values_str = {}
    for key, value in field_name_and_values.items():
        field_name_and_values_str[key] = str(value)
    arguments["field_name_and_values"] = field_name_and_values_str
    return common.call_api(ACAPIMODULE_PROJECT, "set_values", arguments, False)

def set_value_to_targets(targets, field_name, value):
    arguments = {}
    arguments["target_list"] = targets
    arguments["field_name"] = field_name
    arguments["value"] = str(value)
    return common.call_api(ACAPIMODULE_PROJECT, "set_value_to_targets", arguments, False)

def sync_local_files(target_list):
    arguments = {}
    arguments["target_list"] = target_list
    return common.call_api(ACAPIMODULE_PROJECT, "sync_local_files", arguments, False)

def sync_snapshot_effect_parameters(bus_effect, mixer_snapshot):
    arguments = {}
    arguments["bus_effect"] = bus_effect
    arguments["mixer_snapshot"] = mixer_snapshot
    return common.call_api(ACAPIMODULE_PROJECT, "sync_snapshot_effect_parameters", arguments, False)

def unset_color(target):
    arguments = {}
    arguments["target"] = target
    return common.call_api(ACAPIMODULE_PROJECT, "unset_color", arguments, False)

# --- deprecated
def add_dsp_bus_send(dsp_bus_from, dsp_bus_to, send_level = 1.0):
    debug.warning("[add_dsp_bus_send] Use project.add_mixer_bus_send instead.")
    return add_mixer_bus_send(dsp_bus_from, dsp_bus_to, send_level)

def copy_dsp_bus_effect(dsp_bus_effect, destination_dsp_bus, destination_dsp_bus_effect):
    debug.warning("[copy_dsp_bus_effect] Use project.copy_bus_effect instead.")
    return copy_bus_effect(dsp_bus_effect, destination_dsp_bus, destination_dsp_bus_effect)

def create_aisac_link(parent, aisac):
    debug.warning("[create_aisac_link] Use project.create_aisaclink instead.")
    return create_aisaclink(parent, aisac)

def create_dsp_bus(dsp_bus_settings, dsp_bus_name):
    debug.warning("[create_dsp_bus] Use project.create_object instead.")
    arguments = {}
    arguments["parent"] = dsp_bus_settings
    arguments["object_type"] = "Bus"
    arguments["object_name"] = dsp_bus_name
    return common.call_api(ACAPIMODULE_PROJECT, "create_object", arguments, True)

def create_dsp_bus_settings(object_name):
    debug.warning("[create_dsp_bus_settings] Use project.create_mixer instead.")
    return create_mixer(object_name)

def create_selector_label(selector, object_name):
    debug.warning("[create_selector_label] Use project.create_object instead.")
    arguments = {}
    arguments["parent"] = selector
    arguments["object_type"] = "SelectorLabel"
    arguments["object_name"] = object_name
    return common.call_api(ACAPIMODULE_PROJECT, "create_object", arguments, True)

def delete_dsp_bus(dsp_bus_settings, dsp_bus_name):
    debug.warning("[delete_dsp_bus] Use project.get_child_object and project.delete_object instead.")
    arguments = {}
    arguments["parent"] = dsp_bus_settings
    arguments["object_type"] = "Bus"
    arguments["object_name"] = dsp_bus_name
    get_dsp_bus_result = common.call_api(ACAPIMODULE_PROJECT, "get_child_object", arguments, True)
    if not get_dsp_bus_result["succeed"]:
        return get_dsp_bus_result
    dsp_bus = get_dsp_bus_result["data"]
    arguments = {}
    arguments["target"] = dsp_bus
    return common.call_api(ACAPIMODULE_PROJECT, "delete_object", arguments, False)

def get_cue_categories(cue):
    debug.warning("[get_cue_categories] Use project.get_categories instead.")
    return get_categories(cue)

def get_dsp_bus(dsp_bus_settings, dsp_bus_name):
    debug.warning("[get_dsp_bus] Use project.get_child_object instead.")
    arguments = {}
    arguments["parent"] = dsp_bus_settings
    arguments["object_type"] = "Bus"
    arguments["object_name"] = dsp_bus_name
    return common.call_api(ACAPIMODULE_PROJECT, "get_child_object", arguments, True)

def get_dsp_bus_effect(dsp_bus, dsp_bus_effect_name):
    debug.warning("[get_dsp_bus_effect] Use project.get_bus_effect instead.")
    return get_bus_effect(dsp_bus, dsp_bus_effect_name)

def get_masterout_dsp_bus(dsp_bus_settings):
    debug.warning("[get_masterout_dsp_bus] Use project.get_child_object instead.")
    arguments = {}
    arguments["parent"] = dsp_bus_settings
    arguments["object_type"] = "BusMaster"
    arguments["object_name"] = "MasterOut"
    return common.call_api(ACAPIMODULE_PROJECT, "get_child_object", arguments, True)

def get_root():
    return common.call_api(ACAPIMODULE_PROJECT, "get_root", None, True)

def move_dsp_bus(dsp_bus, destination_dsp_bus):
    debug.warning("[move_dsp_bus] Use project.move_bus instead.")
    return move_bus(dsp_bus, destination_dsp_bus)

def move_dsp_bus_effect(dsp_bus_effect, destination_dsp_bus, destination_dsp_bus_effect):
    debug.warning("[move_dsp_bus_effect] Use project.move_object instead.")
    arguments = {}
    arguments["target"] = dsp_bus_effect
    if destination_dsp_bus is not None:
        arguments["destination_parent"] = destination_dsp_bus
    if destination_dsp_bus_effect is not None:
        arguments["destination_object"] = destination_dsp_bus_effect
    return common.call_api(ACAPIMODULE_PROJECT, "move_object", arguments, False)

def remove_dsp_bus_send(dsp_bus_from, dsp_bus_to):
    debug.warning("[remove_dsp_bus_send] Use project.remove_mixer_bus_send instead.")
    return remove_mixer_bus_send(dsp_bus_from, dsp_bus_to)

def set_cue_categories(cue, category_list):
    debug.warning("[set_cue_categories] Use project.set_categories instead.")
    return set_categories(cue, category_list)
