﻿// Copyright Epic Games, Inc. All Rights Reserved.

#pragma once

#include "CoreMinimal.h"
#include "Misc/Guid.h"

// Custom serialization version for all packages containing Atom2D asset types
struct FAtomCustomVersion
{
	enum Type
	{
		// Before any version changes were made in the plugin
		BeforeCustomVersionWasAdded = 0,

		// Add support for procedural sounds. 
		AddProceduralSoundsSupport = 1,

		// Add mixer playback support.
		AddMixerPlaybackSupport = 2,

		// Add user name from acf data for mixer.
		AddMixerNameSupport = 3,

		// Add submixers to extend Atom buses in mixer.
		AddMixerSubmixSupport = 4,

		// Add output from acf data for mixer.
		AddMixerOutputSupport = 5,

		// -----<new versions can be added above this line>-------------------------------------------------
		VersionPlusOne,
		LatestVersion = VersionPlusOne - 1
	};

	// The GUID for this custom version number
	const static FGuid GUID;

private:
	FAtomCustomVersion() {}
};
