/****************************************************************************
 *
 * CRI Middleware SDK
 *
 * Copyright (c) 2010-2017 CRI Middleware Co., Ltd.
 *
 * Library  : CRI Atom
 * Module   : Library User's Header
 * File     : cri_le_atom_asr.h
 *
 ****************************************************************************/
/*!
 *	\file		cri_le_atom_asr.h
 */

/* d`h~					*/
/* Prevention of redefinition	*/
#ifndef	CRI_ATOM_ASR_H_INCLUDED
#define	CRI_ATOM_ASR_H_INCLUDED

/***************************************************************************
 *      CN[ht@C
 *      Include files
 ***************************************************************************/
#include "cri_le_xpt.h"
#include "cri_le_atom.h"
#include "cri_le_atom_ex.h"

/***************************************************************************
 *      萔}N
 *      Macro Constants
 ***************************************************************************/
/*JP
 * \brief ő`l
 * \ingroup ATOMEXLIB_ASR
 * \par :
 * ASR\ȍő`lłB
 */
#define CRIATOMEXASR_MAX_CHANNELS		(16)

/*JP
 * \brief ftHgZh\oX
 * \ingroup ATOMEXLIB_ASR
 * \par :
 * ftHg̃Zh\ȃoXłB
 */
#define CRIATOMEXASR_DEFAULT_NUM_ROUTES	(8)

/*JP
 * \brief fttHg̃oX
 * \ingroup ATOMEXLIB_ASR
 * \par :
 * ftHg̃oXłB
 */
#define CRIATOMEXASR_DEFAULT_NUM_BUSES	(8)

/*JP
 * \brief ő`l
 * \ingroup ATOMEXLIB_ASR
 * \par :
 * ASR\ȍőoXłB
 */
#define CRIATOMEXASR_MAX_BUSES			(64)

/*JP
 * \brief ftHgASRbNID
 * \ingroup ATOMEXLIB_ASR
 * \par :
 * ɎIɍ쐬ASRbNIDłB <br>
 * \sa criAtomExAsrRack_Create, criAtomExAsrRack_Destroy
 */
#define CRIATOMEXASR_RACK_DEFAULT_ID	(0)

/*JP
 * \brief sȃbNID
 * \ingroup ATOMEXLIB_ASR
 * \par :
 * ::criAtomExAsrRack_Create ֐ɎsۂɕԂlłB <br>
 * \sa criAtomExAsrRack_Create, criAtomExAsrRack_Destroy
 */
#define CRIATOMEXASR_RACK_ILLEGAL_ID	(-1)

/*JP
 * \brief [U`GtFNgC^[tF[X̍őo^
 * \ingroup ATOMEXLIB_ASR
 * \par :
 * o^\ȃ[U`GtFNgC^[tF[X̍ő吔łB<br>
 * \sa  criAtomExAsr_RegisterEffectInterface, criAtomExAsr_UnregisterEffectInterface
 */
#define CRIATOMEXASR_MAX_NUM_USER_EFFECT_INTERFACES	(256)

/*JP
 * \brief IuWFNgx[X̓Đ
 * \ingroup ATOMEXLIB_ASR
 * \par :
 * ASRœɍĐłIuWFNgx[X̐łB<br>
 */
#define CRIATOMEXASR_NUM_OBJECT_BASED_AUDIO (CRIATOMEXASR_MAX_CHANNELS)

/*==========================================================================
 *      CRI ASRoXGtFNg
 *=========================================================================*/
/*JP
 * \brief U͊̃GtFNg
 * \ingroup  ATOMEXLIB_ASR
 */
#define CRIATOMEXASR_AMPLITUDE_ANALYZER_NAME			"CRIWARE/AmplitudeAnalyzer"

/*JP
 * \brief oXEobt@[v[̃GtFNg
 * \ingroup  ATOMEXLIB_ASR
 */
#define CRIATOMEXASR_BUS_BUFFER_POOL					"CRIWARE/BusBufferPool"

/*JP
 * \brief oCNAbhtB^[̃GtFNg
 * \ingroup  ATOMEXLIB_ASR
 */
#define CRIATOMEXASR_BIQUAD_FILTER_NAME					"CRIWARE/Biquad"

/*JP
 * \brief ohpXtB^[i2̃o^[[XtB^[j̃GtFNg
 * \ingroup  ATOMEXLIB_ASR
 */
#define CRIATOMEXASR_BANDPASS_FILTER_NAME				"CRIWARE/Bandpass"

/*JP
 * \brief R[X̃GtFNg
 * \ingroup  ATOMEXLIB_ASR
 */
#define CRIATOMEXASR_CHORUS_NAME						"CRIWARE/Chorus"

/*JP
 * \brief tW[̃GtFNg
 * \ingroup  ATOMEXLIB_ASR
 */
#define CRIATOMEXASR_FLANGER_NAME						"CRIWARE/Flanger"

/*JP
 * \brief RvbT[̃GtFNg
 * \ingroup  ATOMEXLIB_ASR
 */
#define CRIATOMEXASR_COMPRESSOR_NAME					"CRIWARE/Compressor"

/*JP
 * \brief ~b^̃GtFNg
 * \ingroup  ATOMEXLIB_ASR
 */
#define CRIATOMEXASR_LIMITER_NAME						"CRIWARE/Limiter"

/*JP
 * \brief fBC̃GtFNg
 * \ingroup  ATOMEXLIB_ASR
 */
#define CRIATOMEXASR_DELAY_NAME							"CRIWARE/Delay"

/*JP
 * \brief GR[̃GtFNg
 * \ingroup  ATOMEXLIB_ASR
 */
#define CRIATOMEXASR_ECHO_NAME							"CRIWARE/Echo"

/*JP
 * \brief }`^bvfBC̃GtFNg
 * \ingroup  ATOMEXLIB_ASR
 */
#define CRIATOMEXASR_MULTITAP_DELAY_NAME				"CRIWARE/MultiTapDelay"

/*JP
 * \brief fBXg[ṼGtFNg
 * \ingroup  ATOMEXLIB_ASR
 */
#define CRIATOMEXASR_DISTORTION_NAME					"CRIWARE/Distortion"

/*JP
 * \brief I3DL2o[ũGtFNg
 * \ingroup  ATOMEXLIB_ASR
 */
#define CRIATOMEXASR_I3DL2_REVERB_NAME					"CRIWARE/I3DL2Reverb"

/*JP
 * \brief }gNX̃GtFNg
 * \ingroup  ATOMEXLIB_ASR
 */
#define CRIATOMEXASR_MATRIX_NAME						"CRIWARE/Matrix"

/*JP
 * \brief 16ch gɑΉ}gNX̃GtFNg
 * \ingroup  ATOMEXLIB_ASR
 */
#define CRIATOMEXASR_MATRIX16_NAME						"CRIWARE/Matrix16"

/*JP
 * \brief 3ohCRCŨGtFNg
 * \ingroup  ATOMEXLIB_ASR
 */
#define CRIATOMEXASR_3BANDS_EQUALIZER_NAME				"CRIWARE/3BandsEQ"

/*JP
 * \brief 32ohCRCŨGtFNg
 * \ingroup  ATOMEXLIB_ASR
 */
#define CRIATOMEXASR_32BANDS_EQUALIZER_NAME				"CRIWARE/32BandsEQ"

/*JP
 * \brief sb`Vt^̃GtFNg
 * \ingroup  ATOMEXLIB_ASR
 */
#define CRIATOMEXASR_PITCH_SHIFTER_NAME					"CRIWARE/PitchShifter"

/*JP
 * \brief o[ũGtFNg
 * \ingroup  ATOMEXLIB_ASR
 */
#define CRIATOMEXASR_REVERB_NAME						"CRIWARE/Reverb"

/*JP
 * \brief TE_̃GtFNg
 * \ingroup  ATOMEXLIB_ASR
 */
#define CRIATOMEXASR_SURROUNDER_NAME					"CRIWARE/Surrounder"
 
/*JP
 * \brief rbgNbV[̃GtFNg
 * \ingroup  ATOMEXLIB_ASR
 */
#define CRIATOMEXASR_BIT_CRUSHER_NAME					"CRIWARE/BitCrusher"

/*JP
 * \brief tF[U[̃GtFNg
 * \ingroup  ATOMEXLIB_ASR
 */
#define CRIATOMEXASR_PHASER_NAME						"CRIWARE/Phaser"

/*JP
 * \brief wbhtHo[`TEh̃GtFNg
 * \ingroup  ATOMEXLIB_ASR
 */
#define CRIATOMEXASR_HEADPHONE_VIRTUAL_SURROUND_NAME	"CRIWARE/HeadphoneVirtualSurround"

/*JP
 * \brief IRo[ũGtFNg
 * \ingroup  ATOMEXLIB_ASR
 */
#define CRIATOMEXASR_IR_REVERB_NAME						"CRIWARE/IRReverb"

/*JP
 * \brief I3DL2o[u Ver.2 ̃GtFNg
 * \ingroup  ATOMEXLIB_ASR
 */
#define CRIATOMEXASR_I3DL2_REVERB2_NAME					"CRIWARE/I3DL2Reverb2"


/*JP
 * \brief EQtTE_̃GtFNg
 * \ingroup  ATOMEXLIB_ASR
 */
#define CRIATOMEXASR_SURROUNDER_WITH_EQUALIZER_NAME		"CRIWARE/SurrounderWithEqualizer"


/*==========================================================================
 *      CRI ASRoXGtFNg p[^[`}N
 *=========================================================================*/
/*JP
 * \defgroup CRIATOMASR_DSP_PARAM ASRoXGtFNg̃p[^[
 * \ingroup  ATOMEXLIB_ASR
 * \par :
 * ASRoXŎgpCRIWAREГGtFNg̃p[^[Ɋւ`łB<br>
 * ::criAtomExAsrRack_SetEffectParameter ֐ ::criAtomExAsrRack_SetEffectParameter 
 * ֐Ŏw肷CfbNX̒`ƁÃp[^[̐ݒl̒`łB
 * \sa criAtomExAsrRack_SetEffectParameter, criAtomExAsrRack_GetEffectParameter
 */

/*JP
 * \defgroup CRIATOMASR_DSP_PARAM_AMPLITUDE_ANALYZER U͊̃p[^[
 * \ingroup CRIATOMASR_DSP_PARAM
 * \brief U͊Őݒ肷p[^[̒`łB
 * \sa criAtomExAsrRack_SetEffectParameter, criAtomExAsrRack_GetEffectParameter
 */
/*JP
 * \brief ݐ̃TCh`FCe[uID
 * \ingroup CRIATOMASR_DSP_PARAM_AMPLITUDE_ANALYZER 
 * \par :
 * {p[^[CfbNXɐU͊킪ސ̃e[uIDw肵܂B<br>
 * e[uID𓯈ɂGtFNgmł́A͌ʂL鎖ł܂B
 */
#define CRIATOMEXASR_AMPLITUDE_ANALYZER_PARAMETER_SIDE_CHAIN_TABLE_ID	(0)

/*JP
 * \brief U͊̃p[^[
 * \ingroup CRIATOMASR_DSP_PARAM_AMPLITUDE_ANALYZER 
 * \par :
 * U͊̃p[^[łB
 */
#define CRIATOMEXASR_AMPLITUDE_ANALYZER_NUM_PARAMETERS					(1)

/*JP
 * \defgroup CRIATOMASR_DSP_PARAM_BIQUAD_FILTER oCNAbhtB^[EohpXtB^[̃p[^[
 * \ingroup CRIATOMASR_DSP_PARAM
 * \brief oCNAbhtB^[EohpXtB^[Őݒ肷p[^[̒`łB
 * \sa criAtomExAsrRack_SetEffectParameter, criAtomExAsrRack_GetEffectParameter
 */
/*JP
 * \brief ^Cv
 * \ingroup CRIATOMASR_DSP_PARAM_BIQUAD_FILTER 
 * \par :
 * {p[^[CfbNXɃoCNAbhtB^[̃^Cvw肵܂B<br>
 * \sa CRIATOMEXASR_BIQUAD_FILTER_TYPE_LOWPASS, CRIATOMEXASR_BIQUAD_FILTER_TYPE_HIGHPASS, CRIATOMEXASR_BIQUAD_FILTER_TYPE_NOTCH, CRIATOMEXASR_BIQUAD_FILTER_TYPE_LOWSHELF, CRIATOMEXASR_BIQUAD_FILTER_TYPE_HIGHSHELF, CRIATOMEXASR_BIQUAD_FILTER_TYPE_PEAKING
 */
#define CRIATOMEXASR_BIQUAD_FILTER_PARAMETER_TYPE						(0)

/*JP
 * \brief g[Hz]
 * \ingroup CRIATOMASR_DSP_PARAM_BIQUAD_FILTER 
 * \par :
 * {p[^[CfbNXɃoCNAbhtB^[̏gw肵܂B<br>
 * g̓^CvɈˑĕω܂B
 * | ^Cv  | g  |
 * | :-----: | :-: |
 * | [pXtB^[AnCpXtB^[ | Ւfg |
 * | mb`tB^[As[LOtB^[A[VFttB^[AnCVFttB^[ | Sg |
 */
#define CRIATOMEXASR_BIQUAD_FILTER_PARAMETER_FREQUENCY					(1)

/*JP
 * \brief Ql
 * \ingroup CRIATOMASR_DSP_PARAM_BIQUAD_FILTER 
 * \par :
 * {p[^[CfbNXɃoCNAbhtB^[QlisxANIeBt@N^jw肵܂B<br>
 * p[^[̏l1.0fAŏl0.0fAől10.0fłBohpXtB^[ȊOł͐M̍ۂɍŏl0.001fɐ܂B
 */
#define CRIATOMEXASR_BIQUAD_FILTER_PARAMETER_QUALITY_FACTOR				(2)

/*JP
 * \brief o̓QC[U]
 * \ingroup CRIATOMASR_DSP_PARAM_BIQUAD_FILTER 
 * \par :
 * {p[^[CfbNXɃoCNAbhtB^[̏o̓QCw肵܂B<br>
 * o̓QCKp̂̓[VFttB^[AnCVFttB^[As[LOtB^[݂̂ƂȂ܂B<br>
 * p[^[̏l1.0fAŏl0.0fAől5.0fłB[VFtAnCVFtAs[LOtB^[̏ꍇ͐M̍ۂɍŏl 1/65536.0fɐ܂B
 */
#define CRIATOMEXASR_BIQUAD_FILTER_PARAMETER_GAIN						(3)

/*JP
 * \brief oCNAbhtB^[̃p[^[
 * \ingroup CRIATOMASR_DSP_PARAM_BIQUAD_FILTER 
 * \par :
 * oCNAbhtB^[̃p[^[łB
 */
#define CRIATOMEXASR_BIQUAD_FILTER_NUM_PARAMETERS						(4)

/*JP
 * \brief [pXtB^[w肷鎞̃p[^[̐ݒl
 * \ingroup CRIATOMASR_DSP_PARAM_BIQUAD_FILTER 
 */
#define CRIATOMEXASR_BIQUAD_FILTER_TYPE_LOWPASS							(0)

/*JP
 * \brief nCpXtB^[w肷鎞̃p[^[̐ݒl
 * \ingroup CRIATOMASR_DSP_PARAM_BIQUAD_FILTER 
 */
#define CRIATOMEXASR_BIQUAD_FILTER_TYPE_HIGHPASS						(1)

/*JP
 * \brief mb`tB^[w肷鎞̃p[^[̐ݒl
 * \ingroup CRIATOMASR_DSP_PARAM_BIQUAD_FILTER 
 */
#define CRIATOMEXASR_BIQUAD_FILTER_TYPE_NOTCH							(2)

/*JP
 * \brief [VFttB^[w肷鎞̃p[^[̐ݒl
 * \ingroup CRIATOMASR_DSP_PARAM_BIQUAD_FILTER 
 */
#define CRIATOMEXASR_BIQUAD_FILTER_TYPE_LOWSHELF						(3)

/*JP
 * \brief nCVFttB^[w肷鎞̃p[^[̐ݒl
 * \ingroup CRIATOMASR_DSP_PARAM_BIQUAD_FILTER 
 */
#define CRIATOMEXASR_BIQUAD_FILTER_TYPE_HIGHSHELF						(4)

/*JP
 * \brief s[LOtB^[w肷鎞̃p[^[̐ݒl
 * \ingroup CRIATOMASR_DSP_PARAM_BIQUAD_FILTER 
 */
#define CRIATOMEXASR_BIQUAD_FILTER_TYPE_PEAKING							(5)

/*JP
 * \brief ՒfiJbgItjg[Hz]
 * \ingroup CRIATOMASR_DSP_PARAM_BIQUAD_FILTER 
 * \par :
 * {p[^[CfbNXɃohpXtB^[i2̃o^[[XtB^[j̒Ւfgw肵܂B<br>
 * p[^[̍ŏl24.0fAől24000.0fłB
 */
#define CRIATOMEXASR_BANDPASS_FILTER_PARAMETER_LOW_FREQ					(0)

/*JP
 * \brief ՒfiJbgItjg[Hz]
 * \ingroup CRIATOMASR_DSP_PARAM_BIQUAD_FILTER 
 * \par :
 * {p[^[CfbNXɃohpXtB^[i2̃o^[[XtB^[j̍Ւfgw肵܂B<br>
 * p[^[̍ŏl24.0fAől24000.0fłB
 */
#define CRIATOMEXASR_BANDPASS_FILTER_PARAMETER_HIGH_FREQ				(1)

/*JP
 * \brief ohpXtB^[i2̃o^[[XtB^[j̃p[^[
 * \ingroup CRIATOMASR_DSP_PARAM_BIQUAD_FILTER 
 * \par :
 * ohpXtB^[̃p[^[łB
 */
#define CRIATOMEXASR_BANDPASS_FILTER_NUM_PARAMETERS						(2)

/*JP
 * \defgroup CRIATOMASR_DSP_PARAM_CHORUS R[XEtW[̃p[^[
 * \ingroup CRIATOMASR_DSP_PARAM
 * \brief R[XEtW[Őݒ肷p[^[̒`łB
 * \sa criAtomExAsrRack_SetEffectParameter, criAtomExAsrRack_GetEffectParameter
 */
/*JP
 * \brief x[ms]
 * \ingroup CRIATOMASR_DSP_PARAM_CHORUS
 * \par :
 * {p[^[CfbNXɃR[X̒xiLFO̒SƂȂxjԂw肵܂B<br>
 * p[^[̏l30.0fAŏl0.1fAől100.fłB
 */
#define CRIATOMEXASR_CHORUS_PARAMETER_DELAY_TIME_MS						(0)

/*JP
 * \brief [iLFOUj
 * \ingroup CRIATOMASR_DSP_PARAM_CHORUS
 * \par :
 * {p[^[CfbNXɃR[X̐[w肵܂B<br>
 * p[^[̏l0.2fAŏl0.0fAől1.0fłB
 */
#define CRIATOMEXASR_CHORUS_PARAMETER_DEPTH								(1)

/*JP
 * \brief [giXs[hALFOgj[Hz]
 * \ingroup CRIATOMASR_DSP_PARAM_CHORUS
 * \par :
 * {p[^[CfbNXɃR[XLFÕ[gw肵܂B<br>
 * p[^[̏l1.0fAŏl0.01fAől100.0fłB
 */
#define CRIATOMEXASR_CHORUS_PARAMETER_RATE								(2)

/*JP
 * \brief tB[hobNQC
 * \ingroup CRIATOMASR_DSP_PARAM_CHORUS
 * \par :
 * {p[^[CfbNXɃR[X̃tB[hobNQCw肵܂B<br>
 * p[^[̏l0.0fAŏl0.0fAől1.0fłB
 */
#define CRIATOMEXASR_CHORUS_PARAMETER_FEEDBACK							(3)

/*JP
 * \brief drỹ~bNX
 * \ingroup CRIATOMASR_DSP_PARAM_CHORUS
 * \par :
 * {p[^[CfbNXɃR[Xdryij̃~bNXw肵܂B<br>
 * p[^[̏l0.7fAŏl0.0fAől1.0fłB
 */
#define CRIATOMEXASR_CHORUS_PARAMETER_DRY_MIX							(4)

/*JP
 * \brief R[X̃p[^[
 * \ingroup CRIATOMASR_DSP_PARAM_CHORUS
 */
#define CRIATOMEXASR_CHORUS_NUM_PARAMETERS								(8)

/*JP
 * \brief x[ms]
 * \ingroup CRIATOMASR_DSP_PARAM_CHORUS
 * \par :
 * {p[^[CfbNXɃtW[̒xiLFO̒SƂȂxjԂw肵܂B<br>
 * p[^[̏l10.0fAŏl0.1fAől10.0fłB
 */
#define CRIATOMEXASR_FLANGER_PARAMETER_DELAY_TIME_MS					(0)

/*JP
 * \brief [iLFOUj
 * \ingroup CRIATOMASR_DSP_PARAM_CHORUS
 * \par :
 * {p[^[CfbNXɃtW[̐[w肵܂B<br>
 * p[^[̏l0.1fAŏl0.0fAől1.0fłB
 */
#define CRIATOMEXASR_FLANGER_PARAMETER_DEPTH							(1)

/*JP
 * \brief [giXs[hALFOgj[Hz]
 * \ingroup CRIATOMASR_DSP_PARAM_CHORUS
 * \par :
 * {p[^[CfbNXɃtW[LFÕ[gw肵܂B<br>
 * p[^[̏l1.0fAŏl0.01fAől100.0fłB
 */
#define CRIATOMEXASR_FLANGER_PARAMETER_RATE								(2)

/*JP
 * \brief tB[hobNQC
 * \ingroup CRIATOMASR_DSP_PARAM_CHORUS
 * \par :
 * {p[^[CfbNXɃtW[̃tB[hobNQCw肵܂B<br>
 * p[^[̏l0.0fAŏl0.0fAől1.0fłB
 */
#define CRIATOMEXASR_FLANGER_PARAMETER_FEEDBACK							(3)

/*JP
 * \brief drỹ~bNX
 * \ingroup CRIATOMASR_DSP_PARAM_CHORUS
 * \par :
 * {p[^[CfbNXɃtW[dryij̃~bNXw肵܂B<br>
 * p[^[̏l0.71fAŏl0.0fAől1.0fłB
 */
#define CRIATOMEXASR_FLANGER_PARAMETER_DRY_MIX							(4)

/*JP
 * \brief wet̃~bNX
 * \ingroup CRIATOMASR_DSP_PARAM_CHORUS
 * \par :
 * {p[^[CfbNXɃtW[wetij̃~bNXw肵܂B
 * p[^[̏l0.71fAŏl0.0fAől1.0fłB
 */
#define CRIATOMEXASR_FLANGER_PARAMETER_WET_MIX							(5)

/*JP
 * \brief tW[̃p[^[
 * \ingroup CRIATOMASR_DSP_PARAM_CHORUS
 */
#define CRIATOMEXASR_FLANGER_NUM_PARAMETERS								(6)

/*JP
 * \defgroup CRIATOMASR_DSP_PARAM_COMPRESSOR RvbT[E~b^̃p[^[
 * \ingroup CRIATOMASR_DSP_PARAM
 * \brief RvbT[E~b^Őݒ肷p[^[̒`łB
 * \sa criAtomExAsrRack_SetEffectParameter, criAtomExAsrRack_GetEffectParameter
 */
/*JP
 * \brief XbVh
 * \ingroup CRIATOMASR_DSP_PARAM_COMPRESSOR
 * \par :
 * {p[^[CfbNXɃRvbT[̃XbVhiUkn߂臒ljw肵܂B<br>
 * p[^[̏l1.0fAŏl0.0fAől1.0fłB<br>
 * \note VIldBlւ̕ϊ̓VIlɏpΐiꂪ10̑ΐjl20.0f悶邱ƂŎ擾ł܂B
 * \code
 * // dbl db 烌VIl ratio ֕ϊ
 * ratio = powf(10.0f, db / 20.0f);
 * // VIl ratio Zgl cent ֕ϊ
 * db = 20.0f * log10f(ratio);
 * \endcode
 */
#define CRIATOMEXASR_COMPRESSOR_PARAMETER_THRESHOLD						(0)

/*JP
 * \brief VI
 * \ingroup CRIATOMASR_DSP_PARAM_COMPRESSOR
 * \par :
 * {p[^[CfbNXɃRvbT[̃VIikljw肵܂B<br>
 * p[^[̏l1.0fAŏlAőlɐ͂܂񂪁AM̍ۂɍŏl0.01fɐ܂B
 */
#define CRIATOMEXASR_COMPRESSOR_PARAMETER_RATIO							(1)

/*JP
 * \brief A^bN[ms]
 * \ingroup CRIATOMASR_DSP_PARAM_COMPRESSOR
 * \par :
 * {p[^[CfbNXɃRvbT[̃A^bNԁiw肵VIɈk܂ł̎ԁjw肵܂B<br>
 * p[^[̏l0.0fAŏl0.0fAől3000.0fłB
 */
#define CRIATOMEXASR_COMPRESSOR_PARAMETER_ATTACK_TIME_MS				(2)

/*JP
 * \brief [X[ms]
 * \ingroup CRIATOMASR_DSP_PARAM_COMPRESSOR
 * \par :
 * {p[^[CfbNXɃRvbT[̃[XԁiU臒lȉɂȂɈkI܂ł̎ԁjw肵܂B<br>
 * p[^[̏l0.0fAŏl0.0fAől50000.0fłB
 */
#define CRIATOMEXASR_COMPRESSOR_PARAMETER_RELEASE_TIME_MS				(3)

/*JP
 * \brief őo̓QC[U]
 * \ingroup CRIATOMASR_DSP_PARAM_COMPRESSOR
 * \par :
 * {p[^[CfbNXɃRvbT[̍őo̓QCw肵܂B<br>
 * p[^[̏l1.0fAŏl 10(-24/5)i-96dBɑjAől10(12/5)i48dBɑjłB
 */
#define CRIATOMEXASR_COMPRESSOR_PARAMETER_OUTPUT_GAIN					(4)

/*JP
 * \brief TEhN̋
 * \ingroup CRIATOMASR_DSP_PARAM_COMPRESSOR
 * \par :
 * {p[^[CfbNXɃRvbT[̃TEhN̋w肵܂B<br>
 * TEhN@\Ƃ́AS`lōŒ̐UlpĈk|鋭ω@\łB<br>
 * 1.0f̎ɑS`lōŒ̐UlSɎgpA0.0fŃTEhN@\OFFɂȂ܂B
 */
#define CRIATOMEXASR_COMPRESSOR_PARAMETER_SURROUND_LINK					(5)

/*JP
 * \brief XvbgEQ̃^Cv
 * \ingroup CRIATOMASR_DSP_PARAM_COMPRESSOR
 * \par :
 * {p[^[CfbNXɃRvbT[̃XvbgEQ̃^Cvw肵܂B<br>
 * XvbgEQƂ͑ш񕪊EQłBtB^[ɂĎoш݂̂ɃRvbT[|Acшƍ܂B
 * \sa CRIATOMEXASR_COMPRESSOR_SPLIT_EQ_TYPE_NONE, CRIATOMEXASR_COMPRESSOR_SPLIT_EQ_TYPE_LOWPASS, CRIATOMEXASR_COMPRESSOR_SPLIT_EQ_TYPE_HIGHPASS, CRIATOMEXASR_COMPRESSOR_SPLIT_EQ_TYPE_BANDPASS, CRIATOMEXASR_COMPRESSOR_SPLIT_EQ_TYPE_NOTCH
 */
#define CRIATOMEXASR_COMPRESSOR_PARAMETER_SPLIT_EQ_TYPE					(6)

/*JP
 * \brief XvbgEQ̏g[Hz]
 * \ingroup CRIATOMASR_DSP_PARAM_COMPRESSOR
 * \par :
 * {p[^[CfbNXɃRvbT[̃XvbgEQ̏gw肵܂B<br>
 * p[^[̍ŏl24.0fAől24000.0fłB
 */
#define CRIATOMEXASR_COMPRESSOR_PARAMETER_SPLIT_EQ_FREQUENCY			(7)

/*JP
 * \brief XvbgEQQl
 * \ingroup CRIATOMASR_DSP_PARAM_COMPRESSOR
 * \par :
 * {p[^[CfbNXɃRvbT[̃XvbgEQQlisxANIeBt@N^jw肵܂B<br>
 * p[^[̏l1.0fAŏl0.0fAől10.0fłB
 */
#define CRIATOMEXASR_COMPRESSOR_PARAMETER_SPLIT_EQ_QUALITY_FACTOR		(8)

/*JP
 * \brief RvbT[̃p[^[
 * \ingroup CRIATOMASR_DSP_PARAM_COMPRESSOR
 */
#define CRIATOMEXASR_COMPRESSOR_NUM_PARAMETERS							(9)

/*JP
 * \brief XvbgEQgpȂۂ̐ݒl
 * \ingroup CRIATOMASR_DSP_PARAM_COMPRESSOR
 */
#define CRIATOMEXASR_COMPRESSOR_SPLIT_EQ_TYPE_NONE						(0)

/*JP
 * \brief XvbgEQŃ[pXtB^[gpۂ̐ݒl
 * \ingroup CRIATOMASR_DSP_PARAM_COMPRESSOR
 */
#define CRIATOMEXASR_COMPRESSOR_SPLIT_EQ_TYPE_LOWPASS					(1)

/*JP
 * \brief XvbgEQŃnCpXtB^[gpۂ̐ݒl
 * \ingroup CRIATOMASR_DSP_PARAM_COMPRESSOR
 */
#define CRIATOMEXASR_COMPRESSOR_SPLIT_EQ_TYPE_HIGHPASS					(2)

/*JP
 * \brief XvbgEQŃohpXtB^[gpۂ̐ݒl
 * \ingroup CRIATOMASR_DSP_PARAM_COMPRESSOR
 */
#define CRIATOMEXASR_COMPRESSOR_SPLIT_EQ_TYPE_BANDPASS					(3)

/*JP
 * \brief XvbgEQŃmb`tB^[gpۂ̐ݒl
 * \ingroup CRIATOMASR_DSP_PARAM_COMPRESSOR
 */
#define CRIATOMEXASR_COMPRESSOR_SPLIT_EQ_TYPE_NOTCH						(4)

/*JP
 * \brief RvbT[g̐Uvʂɂ蓮삳ۂ̐ݒl
 * \ingroup CRIATOMASR_DSP_PARAM_COMPRESSOR
 */
#define CRIATOMEXASR_COMPRESSOR_MODE_NORMAL								(0)

/*JP
 * \brief RvbT[TCh`FCgpē삳ۂ̐ݒl
 * \ingroup CRIATOMASR_DSP_PARAM_COMPRESSOR
 */
#define CRIATOMEXASR_COMPRESSOR_MODE_SIDE_CHAIN							(1)

/*JP
 * \brief RvbT[̐Um^Cvs[Nlɂۂ̐ݒl
 * \ingroup CRIATOMASR_DSP_PARAM_COMPRESSOR
 */
#define CRIATOMEXASR_COMPRESSOR_TYPE_PEAK								(0)

/*JP
 * \brief RvbT[̐Um^CvRMSɂۂ̐ݒl
 * \ingroup CRIATOMASR_DSP_PARAM_COMPRESSOR
 */
#define CRIATOMEXASR_COMPRESSOR_TYPE_RMS								(1)

/*JP
 * \brief XbVh
 * \ingroup CRIATOMASR_DSP_PARAM_COMPRESSOR
 * \par :
 * {p[^[CfbNXɃ~b^̃XbVhiUk臒ljw肵܂B<br>
 */
#define CRIATOMEXASR_LIMITER_PARAMETER_THRESHOLD						(0)

/*JP
 * \brief A^bN[ms]
 * \ingroup CRIATOMASR_DSP_PARAM_COMPRESSOR
 * \par :
 * {p[^[CfbNXɃ~b^̃A^bNԁik܂ł̎ԁjw肵܂B
 * p[^[̏l0.0fAŏl0.0fAől200.0fłB
 */
#define CRIATOMEXASR_LIMITER_PARAMETER_ATTACK_TIME_MS					(1)

/*JP
 * \brief [X[ms]
 * \ingroup CRIATOMASR_DSP_PARAM_COMPRESSOR
 * \par :
 * {p[^[CfbNXɃ~b^̃[XԁiU臒lȉɂȂɈkI܂ł̎ԁjw肵܂B
 * p[^[̏l0.0fAŏl0.0fAől50000.0fłB
 */
#define CRIATOMEXASR_LIMITER_PARAMETER_RELEASE_TIME_MS					(2)

/*JP
 * \brief őo̓QC[U]
 * \ingroup CRIATOMASR_DSP_PARAM_COMPRESSOR
 * \par :
 * {p[^[CfbNXɃ~b^̍őo̓QCw肵܂B<br>
 * p[^[̏l1.0fAŏl 10-4.8i-96dBɑjAől102.4i48dBɑjłB
 */
#define CRIATOMEXASR_LIMITER_PARAMETER_OUTPUT_GAIN						(3)

/*JP
 * \brief TEhN̋
 * \ingroup CRIATOMASR_DSP_PARAM_COMPRESSOR
 * \par :
 * {p[^[CfbNXɃ~b^̃TEhN̋w肵܂B<br>
 * TEhN@\Ƃ́AS`lōŒ̐UlpĈk|鋭ω@\łB<br>
 * 1.0f̎ɑS`lōŒ̐UlSɎgpA0.0fŃTEhN@\OFFɂȂ܂B
 */
#define CRIATOMEXASR_LIMITER_PARAMETER_SURROUND_LINK					(4)

/*JP
 * \brief Uol^Cv
 * \ingroup CRIATOMASR_DSP_PARAM_COMPRESSOR
 * \par :
 * {p[^[CfbNXɃ~b^̐Uol^Cvw肵܂B
 * \sa CRIATOMEXASR_LIMITER_TYPE_PEAK, CRIATOMEXASR_LIMITER_TYPE_RMS
 */
#define CRIATOMEXASR_LIMITER_PARAMETER_TYPE								(5)

/*JP
 * \brief ~b^̃p[^[
 * \ingroup CRIATOMASR_DSP_PARAM_COMPRESSOR
 */
#define CRIATOMEXASR_LIMITER_NUM_PARAMETERS								(6)
																	
/*JP
 * \brief ~b^g̐Uvʂɂ蓮삳ۂ̐ݒl
 * \ingroup CRIATOMASR_DSP_PARAM_COMPRESSOR
 */
#define CRIATOMEXASR_LIMITER_MODE_NORMAL								(0)

/*JP
 * \brief ~b^TCh`FCɂ蓮삳ۂ̐ݒl
 * \ingroup CRIATOMASR_DSP_PARAM_COMPRESSOR
 */
#define CRIATOMEXASR_LIMITER_MODE_SIDE_CHAIN							(1)

/*JP
 * \brief ~b^̐Um^Cvs[Nlɂۂ̐ݒl
 * \ingroup CRIATOMASR_DSP_PARAM_COMPRESSOR
 */
#define CRIATOMEXASR_LIMITER_TYPE_PEAK									(0)

/*JP
 * \brief ~b^̐Um^CvRMSɂۂ̐ݒl
 * \ingroup CRIATOMASR_DSP_PARAM_COMPRESSOR
 */
#define CRIATOMEXASR_LIMITER_TYPE_RMS									(1)

/*JP
 * \defgroup CRIATOMASR_DSP_PARAM_DELAY fBCEGR[E}`^bvfBC̃p[^[
 * \ingroup CRIATOMASR_DSP_PARAM
 * \brief fBCEGR[E}`^bvfBCŐݒ肷p[^[̒`łB
 * \sa criAtomExAsrRack_SetEffectParameter, criAtomExAsrRack_GetEffectParameter
 */
/*JP
 * \brief x[ms]
 * \ingroup CRIATOMASR_DSP_PARAM_DELAY
 * \par :
 * {p[^[CfbNXɃfBC̒xԂw肵܂B<br>
 * őfBCԂ̔̒lŏ܂B p[^[̍ŏl50.0fAől1000.0fłB
 */
#define CRIATOMEXASR_DELAY_PARAMETER_DELAY_TIME_MS						(0)

/*JP
 * \brief fBC̃p[^[
 * \ingroup CRIATOMASR_DSP_PARAM_DELAY
 */
#define CRIATOMEXASR_DELAY_NUM_PARAMETERS								(1)

/*JP
 * \brief fBCŐݒ\ȍŏ̒x[ms]
 * \ingroup CRIATOMASR_DSP_PARAM_DELAY
 */
#define CRIATOMEXASR_DELAY_PARAMETER_MIN_DELAY_TIME_MS					(50.0f)

/*JP
 * \brief fBCŐݒ\ȍő̒x[ms]
 * \ingroup CRIATOMASR_DSP_PARAM_DELAY
 * \attention RtBOݒ肵lȏɐݒ肵ĂA̒lD悵Đ܂B
 */
#define CRIATOMEXASR_DELAY_PARAMETER_MAX_DELAY_TIME_MS					(1000.0f)

/*JP
 * \brief x[ms]
 * \ingroup CRIATOMASR_DSP_PARAM_DELAY
 * \par :
 * {p[^[CfbNXɃGR[̒xԂw肵܂B
 */
#define CRIATOMEXASR_ECHO_PARAMETER_DELAY_TIME_MS						(0)

/*JP
 * \brief tB[hobNQC
 * \ingroup CRIATOMASR_DSP_PARAM_DELAY
 * \par :
 * {p[^[CfbNXɃGR[̃tB[hobNQCw肵܂B<br>
 * tB[hobNQC傫ɂGR[͍Đ~Ă~܂Ȃ_ɒӂĉB܂AtB[hobNQC̐Βl̍ől1.0fłAIɂ0.99fɐ؂l߂ׁAUĂ܂iGR[Ȃj͂܂B
 * \par :
 * p[^[̏l0.0fAŏl-0.99fAől0.99fłBL̐ɂA1.0fݒ肵ꍇł܂B
 */
#define CRIATOMEXASR_ECHO_PARAMETER_FB_GAIN								(1)

/*JP
 * \brief GR[̃p[^[
 * \ingroup CRIATOMASR_DSP_PARAM_DELAY
 */
#define CRIATOMEXASR_ECHO_NUM_PARAMETERS								(2)

/*JP
 * \brief GR[Őݒ\ȍŏ̒x[ms]
 * \ingroup CRIATOMASR_DSP_PARAM_DELAY
 */
#define CRIATOMEXASR_ECHO_PARAMETER_MIN_DELAY_TIME_MS					(0.0f)

/*JP
 * \brief GR[Őݒ\ȍő̒x[ms]
 * \ingroup CRIATOMASR_DSP_PARAM_DELAY
 * \attention RtBOŐݒ肵őxԂA̒lD悵Đ܂B
 */
#define CRIATOMEXASR_ECHO_PARAMETER_MAX_DELAY_TIME_MS					(1000.0f)

/*JP
 * \brief GR[Őݒ\ȍŏ̃tB[hobNQC
 * \ingroup CRIATOMASR_DSP_PARAM_DELAY
 */
#define CRIATOMEXASR_ECHO_PARAMETER_MIN_FB_GAIN							(-0.99f)

/*JP
 * \brief GR[Őݒ\ȍő̃tB[hobNQC
 * \ingroup CRIATOMASR_DSP_PARAM_DELAY
 */
#define CRIATOMEXASR_ECHO_PARAMETER_MAX_FB_GAIN							(0.99f)

/*JP
 * \brief }`^bvfBC̃^bv
 * \ingroup CRIATOMASR_DSP_PARAM_DELAY
 */
#define CRIATOMEXASR_MULTITAP_DELAY_NUM_TAPS							(4)

/*JP
 * \brief }`^bvfBC̏o̓`l
 * \ingroup CRIATOMASR_DSP_PARAM_DELAY
 * \par :
 * ʏ4`liL, R, TEhL, TEhRjɐݒ肳܂B
 */
#define CRIATOMEXASR_MULTITAP_DELAY_NUM_CHANNELS						(4)

/*JP
 * \brief }`^bvfBCŐݒ\ȍő̒x[ms]
 * \ingroup CRIATOMASR_DSP_PARAM_DELAY
 * \attention RtBOł̒lȏɐݒ肵ĂA̒lD悵Đ܂B
 */
#define CRIATOMEXASR_MULTITAP_DELAY_PARAMETER_MAX_DELAY_TIME_MS			(10000.0f)

/*JP
 * \brief }`^bvfBC1^bṽp[^[
 * \ingroup CRIATOMASR_DSP_PARAM_DELAY
 */
#define CRIATOMEXASR_MULTITAP_DELAY_NUM_PARAMETER_PAR_TAP				(4)

/*JP
 * \brief }`^bvfBC̃tB[hobNʑal
 * \ingroup CRIATOMASR_DSP_PARAM_DELAY
 * \par :
 * }`^bvfBCł͊e^bvŃtB[hobNŝŁAo͂UĂ܂ꍇ܂BS^bṽtB[hobNalpāAUȂׂ܂B
 * \attention ̏lpĂo͂Uꍇ܂B
 */
#define CRIATOMEXASR_MULTITAP_DELAY_PARAMETER_MAX_SUM_FEEDBACK_GAIN		(0.90f)

/*JP
 * \brief }`^bvfBC̃p[^[
 * \ingroup CRIATOMASR_DSP_PARAM_DELAY
 */
#define CRIATOMEXASR_MULTITAP_DELAY_NUM_PARAMETERS \
	(CRIATOMEXASR_MULTITAP_DELAY_NUM_PARAMETER_PAR_TAP * CRIATOMEXASR_MULTITAP_DELAY_NUM_TAPS)	

/*JP
 * \defgroup CRIATOMASR_DSP_PARAM_DISTORTION fBXg[Ṽp[^[
 * \ingroup CRIATOMASR_DSP_PARAM
 * \brief fBXg[VŐݒ肷p[^[̒`łB
 * \sa criAtomExAsrRack_SetEffectParameter, criAtomExAsrRack_GetEffectParameter
 */
/*JP
 * \brief c݂̋[dB]
 * \ingroup CRIATOMASR_DSP_PARAM_DISTORTION
 * \par :
 * {p[^[CfbNXɃfBXg[V̘c݂̋ihCujw肵܂B<br>
 * p[^[̏l0.5fAŏl0.0fAől48.0fłB
 */
#define CRIATOMEXASR_DISTORTION_PARAMETER_DRIVE_DB						(0)

/*JP
 * \brief drẙ
 * \ingroup CRIATOMASR_DSP_PARAM_DISTORTION
 * \par :
 * {p[^[CfbNXɃfBXg[Vdryij~bNX銄w肵܂B<br>
 * p[^[̏l0.71fAŏl0.0fAől1.0fłB
 */
#define CRIATOMEXASR_DISTORTION_PARAMETER_DRY_MIX						(1)

/*JP
 * \brief wet̊
 * \ingroup CRIATOMASR_DSP_PARAM_DISTORTION
 * \par :
 * {p[^[CfbNXɃfBXg[Vwetic݁j~bNX銄w肵܂B<br>
 * p[^[̏l0.71fAŏl0.0fAől1.0fłB
 */
#define CRIATOMEXASR_DISTORTION_PARAMETER_WET_MIX						(2)

/*JP
 * \brief ŏIo̓x[U]
 * \ingroup CRIATOMASR_DSP_PARAM_DISTORTION
 * \par :
 * {p[^[CfbNXɃfBXg[V̍ŏIo̓xw肵܂B<br>
 * p[^[̏l0.5fAŏl0.0fAől102.4i48dBɑljłB
 */
#define CRIATOMEXASR_DISTORTION_PARAMETER_OUTPUT_GAIN					(3)

/*JP
 * \brief fBXg[Ṽp[^[
 * \ingroup CRIATOMASR_DSP_PARAM_DISTORTION
 */
#define CRIATOMEXASR_DISTORTION_NUM_PARAMETERS							(4)

/*JP
 * \defgroup CRIATOMASR_DSP_PARAM_I3DL2_REVERB I3DL2o[ũp[^[
 * \ingroup CRIATOMASR_DSP_PARAM
 * \brief I3DL2o[uŐݒ肷p[^[̒`łB
 * \sa criAtomExAsrRack_SetEffectParameter, criAtomExAsrRack_GetEffectParameter
 * \attention vZbg̓p[^[CfbNX0-10܂ł̏񂪕񂾔złA
 *			  CfbNX11-13ɂĂ͎wł܂B
 */
/*JP
 * \brief GtFNgŜ̏o̓{[[mB]
 * \ingroup CRIATOMASR_DSP_PARAM_I3DL2_REVERB
 * \par :
 * {p[^[CfbNXI3DL2o[u̍ŏIo̓{[w肵܂B<br>
 * p[^[̏l-1000.0fAŏl-10000.0fAől0.0fłB
 */
#define CRIATOMEXASR_I3DL2_REVERB_PARAMETER_ROOM						(0)

/*JP
 * \brief QƎgij̃{[[mB]
 * \ingroup CRIATOMASR_DSP_PARAM_I3DL2_REVERB
 * \par :
 * {p[^[CfbNXI3DL2o[u̎QƎgij̃{[w肵܂B<br>
 * p[^[̏l-100.0fAŏl-10000.0fAől0.0fłB
 */
#define CRIATOMEXASR_I3DL2_REVERB_PARAMETER_ROOM_HF						(1)

/*JP
 * \brief 㕔č[sec]
 * \ingroup CRIATOMASR_DSP_PARAM_I3DL2_REVERB
 * \par :
 * {p[^[CfbNXI3DL2o[ǔ㕔čԂw肵܂B<br>
 * p[^[̏l1.49fAŏl0.1fAől20.0fłB
 */
#define CRIATOMEXASR_I3DL2_REVERB_PARAMETER_DECAY_TIME					(2)

/*JP
 * \brief 㕔c̒gɑ΂鍂g̔
 * \ingroup CRIATOMASR_DSP_PARAM_I3DL2_REVERB
 * \par :
 * {p[^[CfbNXI3DL2o[ǔ㕔cɂAgɑ΂鍂g̔䗦w肵܂B<br>
 * p[^[̏l0.83fAŏl0.1fAől2.0fłB
 */
#define CRIATOMEXASR_I3DL2_REVERB_PARAMETER_DECAY_HF_RATIO				(3)

/*JP
 * \brief ˉ̃{[[mB]
 * \ingroup CRIATOMASR_DSP_PARAM_I3DL2_REVERB
 * \par :
 * {p[^[CfbNXI3DL2o[ȕˉ̃{[w肵܂B<br>
 * p[^[̏l-2602fAŏl-10000.0fAől1000.0łB
 */
#define CRIATOMEXASR_I3DL2_REVERB_PARAMETER_REFLECTIONS					(4)

/*JP
 * \brief ˉ̒x[sec]
 * \ingroup CRIATOMASR_DSP_PARAM_I3DL2_REVERB
 * \par :
 * {p[^[CfbNXI3DL2o[ȕˉ̃{[w肵܂B<br>
 * p[^[̏l0.007fAŏl0.0fAől0.3fłB
 */
#define CRIATOMEXASR_I3DL2_REVERB_PARAMETER_REFLECTIONS_DELAY			(5)

/*JP
 * \brief 㕔c̃{[[mB]
 * \ingroup CRIATOMASR_DSP_PARAM_I3DL2_REVERB
 * \par :
 * {p[^[CfbNXI3DL2o[ǔ㕔c̃{[w肵܂B<br>
 * p[^[̏l200fAŏl-10000.0fAől2000.0fłB
 */
#define CRIATOMEXASR_I3DL2_REVERB_PARAMETER_REVERB						(6)

/*JP
 * \brief 㕔c̒x[sec]
 * \ingroup CRIATOMASR_DSP_PARAM_I3DL2_REVERB
 * \par :
 * {p[^[CfbNXI3DL2o[ǔ㕔c̒xԂw肵܂B<br>
 * p[^[̏l0.011fAŏl0.0fAől0.1fłB
 */
#define CRIATOMEXASR_I3DL2_REVERB_PARAMETER_REVERB_DELAY				(7)

/*JP
 * \brief 㕔c̃GR[x[%]
 * \ingroup CRIATOMASR_DSP_PARAM_I3DL2_REVERB
 * \par :
 * {p[^[CfbNXI3DL2o[ǔ㕔c̃GR[xw肵܂B<br>
 * p[^[̏l100.0fAŏl0.0fAől100.0fłB
 */
#define CRIATOMEXASR_I3DL2_REVERB_PARAMETER_DIFFUSION					(8)

/*JP
 * \brief 㕔c̃[_x[%]
 * \ingroup CRIATOMASR_DSP_PARAM_I3DL2_REVERB
 * \par :
 * {p[^[CfbNXI3DL2o[ǔ㕔c̃[_xw肵܂B<br>
 * p[^[̏l100.0fAŏl0.0fAől100.0fłB
 */
#define CRIATOMEXASR_I3DL2_REVERB_PARAMETER_DENSITY						(9)

/*JP
 * \brief RoomHF̎QƎgij[Hz]
 * \ingroup CRIATOMASR_DSP_PARAM_I3DL2_REVERB
 * \par :
 * {p[^[CfbNXI3DL2o[uRoomHF̎QƎgijw肵܂B<br>
 * p[^[̏l5000.0fAŏl20.0fAől20000.0fłB
 */
#define CRIATOMEXASR_I3DL2_REVERB_PARAMETER_HF_REFERENCE				(10)

/*JP
 * \brief tg̓̓x[mB]
 * \ingroup CRIATOMASR_DSP_PARAM_I3DL2_REVERB
 * \par :
 * {p[^[CfbNXI3DL2o[ũtgiL,R`lj̓̓xw肵܂B<br>
 * I3DL2o[ũvZbgł͎włȂɒӂĉB<br>
 * p[^[̏l0.0fAŏl-10000.0fAől0.0fłB
 */
#define CRIATOMEXASR_I3DL2_REVERB_PARAMETER_FRONT_INPUT					(11)

/*JP
 * \brief A̓̓x[mB]
 * \ingroup CRIATOMASR_DSP_PARAM_I3DL2_REVERB
 * \par :
 * {p[^[CfbNXI3DL2o[ũAiTEhL,TEhR`lj̓̓xw肵܂B<br>
 * I3DL2o[ũvZbgł͎włȂɒӂĉB<br>
 * p[^[̏l0.0fAŏl-10000.0fAől0.0fłB
 */
#define CRIATOMEXASR_I3DL2_REVERB_PARAMETER_REAR_INPUT					(12)

/*JP
 * \brief Z^[̓̓x[mB]
 * \ingroup CRIATOMASR_DSP_PARAM_I3DL2_REVERB
 * \par :
 * {p[^[CfbNXI3DL2o[ũZ^[iC`lj̓̓xw肵܂B<br>
 * I3DL2o[ũvZbgł͎włȂɒӂĉB<br>
 * p[^[̏l-10000.0fAŏl-10000.0fAől0.0fłB
 */
#define CRIATOMEXASR_I3DL2_REVERB_PARAMETER_CENTER_INPUT				(13)

/*JP
 * \brief tg̏o̓x[mB]
 * \ingroup CRIATOMASR_DSP_PARAM_I3DL2_REVERB
 * \par :
 * {p[^[CfbNXI3DL2o[ũtgiL,R`lj̏o̓xw肵܂B<br>
 * I3DL2o[ũvZbgł͎włȂɒӂĉB<br>
 * p[^[̏l0.0fAŏl-10000.0fAől0.0fłB
 */
#define CRIATOMEXASR_I3DL2_REVERB_PARAMETER_FRONT_OUTPUT				(14)

/*JP
 * \brief Ȁo̓x[mB]
 * \ingroup CRIATOMASR_DSP_PARAM_I3DL2_REVERB
 * \par :
 * {p[^[CfbNXI3DL2o[ũAiTEhL,TEhR`lj̏o̓xw肵܂B<br>
 * I3DL2o[ũvZbgł͎włȂɒӂĉB<br>
 * p[^[̏l0.0fAŏl-10000.0fAől0.0fłB
 */
#define CRIATOMEXASR_I3DL2_REVERB_PARAMETER_REAR_OUTPUT					(15)

/*JP
 * \brief Z^[̏o̓x[mB]
 * \ingroup CRIATOMASR_DSP_PARAM_I3DL2_REVERB
 * \par :
 * {p[^[CfbNXI3DL2o[ũZ^[iC`lj̏o̓xw肵܂B<br>
 * I3DL2o[ũvZbgł͎włȂɒӂĉB<br>
 * p[^[̏l-10000.0fAŏl-10000.0fAől0.0fłB
 */
#define CRIATOMEXASR_I3DL2_REVERB_PARAMETER_CENTER_OUTPUT				(16)

/*JP
 * \brief I3DL2o[ũp[^[
 * \ingroup CRIATOMASR_DSP_PARAM_I3DL2_REVERB
 */
#define CRIATOMEXASR_I3DL2_REVERB_NUM_PARAMETERS						(17)

/*JP
 * \brief I3DL2o[ũp[^[̃vZbg: GENERIC
 * \ingroup CRIATOMASR_DSP_PARAM_I3DL2_REVERB
 */
#define CRIATOMEXASR_I3DL2_REVERB_PRESET_GENERIC \
	{ -1000,  -100, 1.49f, 0.83f,  -2602, 0.007f,    200, 0.011f, 100.0f, 100.0f, 5000.0f}

/*JP
 * \brief I3DL2o[ũp[^[̃vZbg: PADDED CELL
 * \ingroup CRIATOMASR_DSP_PARAM_I3DL2_REVERB
 */
#define CRIATOMEXASR_I3DL2_REVERB_PRESET_PADDEDCELL \
	{ -1000, -6000, 0.17f, 0.10f,  -1204, 0.001f,    207, 0.002f, 100.0f, 100.0f, 5000.0f}

/*JP
 * \brief I3DL2o[ũp[^[̃vZbg: ROOM
 * \ingroup CRIATOMASR_DSP_PARAM_I3DL2_REVERB
 */
#define CRIATOMEXASR_I3DL2_REVERB_PRESET_ROOM \
	{ -1000,  -454, 0.40f, 0.83f,  -1646, 0.002f,     53, 0.003f, 100.0f, 100.0f, 5000.0f}

/*JP
 * \brief I3DL2o[ũp[^[̃vZbg: BATH ROOM
 * \ingroup CRIATOMASR_DSP_PARAM_I3DL2_REVERB
 */
#define CRIATOMEXASR_I3DL2_REVERB_PRESET_BATHROOM \
	{ -1000, -1200, 1.49f, 0.54f,   -370, 0.007f,   1030, 0.011f, 100.0f,  60.0f, 5000.0f}

/*JP
 * \brief I3DL2o[ũp[^[̃vZbg: LIVING ROOM
 * \ingroup CRIATOMASR_DSP_PARAM_I3DL2_REVERB
 */
#define CRIATOMEXASR_I3DL2_REVERB_PRESET_LIVINGROOM \
	{ -1000, -6000, 0.50f, 0.10f,  -1376, 0.003f,  -1104, 0.004f, 100.0f, 100.0f, 5000.0f}

/*JP
 * \brief I3DL2o[ũp[^[̃vZbg: STONE ROOM
 * \ingroup CRIATOMASR_DSP_PARAM_I3DL2_REVERB
 */
#define CRIATOMEXASR_I3DL2_REVERB_PRESET_STONEROOM \
	{ -1000,  -300, 2.31f, 0.64f,   -711, 0.012f,     83, 0.017f, 100.0f, 100.0f, 5000.0f}

/*JP
 * \brief I3DL2o[ũp[^[̃vZbg: AUDITORIUM
 * \ingroup CRIATOMASR_DSP_PARAM_I3DL2_REVERB
 */
#define CRIATOMEXASR_I3DL2_REVERB_PRESET_AUDITORIUM \
	{ -1000,  -476, 4.32f, 0.59f,   -789, 0.020f,   -289, 0.030f, 100.0f, 100.0f, 5000.0f}

/*JP
 * \brief I3DL2o[ũp[^[̃vZbg: CONCERT HALL
 * \ingroup CRIATOMASR_DSP_PARAM_I3DL2_REVERB
 */
#define CRIATOMEXASR_I3DL2_REVERB_PRESET_CONCERTHALL \
	{ -1000,  -500, 3.92f, 0.70f,  -1230, 0.020f,     -2, 0.029f, 100.0f, 100.0f, 5000.0f}

/*JP
 * \brief I3DL2o[ũp[^[̃vZbg: CAVE
 * \ingroup CRIATOMASR_DSP_PARAM_I3DL2_REVERB
 */
#define CRIATOMEXASR_I3DL2_REVERB_PRESET_CAVE \
	{ -1000,     0, 2.91f, 1.30f,   -602, 0.015f,   -302, 0.022f, 100.0f, 100.0f, 5000.0f}

/*JP
 * \brief I3DL2o[ũp[^[̃vZbg: ARENA
 * \ingroup CRIATOMASR_DSP_PARAM_I3DL2_REVERB
 */
#define CRIATOMEXASR_I3DL2_REVERB_PRESET_ARENA \
	{ -1000,  -698, 7.24f, 0.33f,  -1166, 0.020f,     16, 0.030f, 100.0f, 100.0f, 5000.0f}

/*JP
 * \brief I3DL2o[ũp[^[̃vZbg: HANGER
 * \ingroup CRIATOMASR_DSP_PARAM_I3DL2_REVERB
 */
#define CRIATOMEXASR_I3DL2_REVERB_PRESET_HANGAR \
	{ -1000, -1000, 10.05f, 0.23f,   -602, 0.020f,    198, 0.030f, 100.0f, 100.0f, 5000.0f}

/*JP
 * \brief I3DL2o[ũp[^[̃vZbg: CARPETED HALL WAY
 * \ingroup CRIATOMASR_DSP_PARAM_I3DL2_REVERB
 */
#define CRIATOMEXASR_I3DL2_REVERB_PRESET_CARPETEDHALLWAY \
	{ -1000, -4000, 0.30f, 0.10f,  -1831, 0.002f,  -1630, 0.030f, 100.0f, 100.0f, 5000.0f}

/*JP
 * \brief I3DL2o[ũp[^[̃vZbg: HALL WAY
 * \ingroup CRIATOMASR_DSP_PARAM_I3DL2_REVERB
 */
#define CRIATOMEXASR_I3DL2_REVERB_PRESET_HALLWAY \
	{ -1000,  -300, 1.49f, 0.59f,  -1219, 0.007f,    441, 0.011f, 100.0f, 100.0f, 5000.0f}

/*JP
 * \brief I3DL2o[ũp[^[̃vZbg: STONE CORRIDOR
 * \ingroup CRIATOMASR_DSP_PARAM_I3DL2_REVERB
 */
#define CRIATOMEXASR_I3DL2_REVERB_PRESET_STONECORRIDOR \
	{ -1000,  -237, 2.70f, 0.79f,  -1214, 0.013f,    395, 0.020f, 100.0f, 100.0f, 5000.0f}

/*JP
 * \brief I3DL2o[ũp[^[̃vZbg: ALLEY
 * \ingroup CRIATOMASR_DSP_PARAM_I3DL2_REVERB
 */
#define CRIATOMEXASR_I3DL2_REVERB_PRESET_ALLEY \
	{ -1000,  -270, 1.49f, 0.86f,  -1204, 0.007f,     -4, 0.011f, 100.0f, 100.0f, 5000.0f}

/*JP
 * \brief I3DL2o[ũp[^[̃vZbg: FOREST
 * \ingroup CRIATOMASR_DSP_PARAM_I3DL2_REVERB
 */
#define CRIATOMEXASR_I3DL2_REVERB_PRESET_FOREST \
	{ -1000, -3300, 1.49f, 0.54f,  -2560, 0.162f,   -613, 0.088f,  79.0f, 100.0f, 5000.0f}

/*JP
 * \brief I3DL2o[ũp[^[̃vZbg: CITY
 * \ingroup CRIATOMASR_DSP_PARAM_I3DL2_REVERB
 */
#define CRIATOMEXASR_I3DL2_REVERB_PRESET_CITY \
	{ -1000,  -800, 1.49f, 0.67f,  -2273, 0.007f,  -2217, 0.011f,  50.0f, 100.0f, 5000.0f}

/*JP
 * \brief I3DL2o[ũp[^[̃vZbg: MOUNTAINS
 * \ingroup CRIATOMASR_DSP_PARAM_I3DL2_REVERB
 */
#define CRIATOMEXASR_I3DL2_REVERB_PRESET_MOUNTAINS \
	{ -1000, -2500, 1.49f, 0.21f,  -2780, 0.300f,  -2014, 0.100f,  27.0f, 100.0f, 5000.0f}

/*JP
 * \brief I3DL2o[ũp[^[̃vZbg: QUARRY
 * \ingroup CRIATOMASR_DSP_PARAM_I3DL2_REVERB
 */
#define CRIATOMEXASR_I3DL2_REVERB_PRESET_QUARRY \
	{ -1000, -1000, 1.49f, 0.83f, -10000, 0.061f,    500, 0.025f, 100.0f, 100.0f, 5000.0f}

/*JP
 * \brief I3DL2o[ũp[^[̃vZbg: PLAIN
 * \ingroup CRIATOMASR_DSP_PARAM_I3DL2_REVERB
 */
#define CRIATOMEXASR_I3DL2_REVERB_PRESET_PLAIN \
	{ -1000, -2000, 1.49f, 0.50f,  -2466, 0.179f,  -2514, 0.100f,  21.0f, 100.0f, 5000.0f}

/*JP
 * \brief I3DL2o[ũp[^[̃vZbg: PARKING LOT
 * \ingroup CRIATOMASR_DSP_PARAM_I3DL2_REVERB
 */
#define CRIATOMEXASR_I3DL2_REVERB_PRESET_PARKINGLOT \
	{ -1000,     0, 1.65f, 1.50f,  -1363, 0.008f,  -1153, 0.012f, 100.0f, 100.0f, 5000.0f}

/*JP
 * \brief I3DL2o[ũp[^[̃vZbg: SEWER PIPE
 * \ingroup CRIATOMASR_DSP_PARAM_I3DL2_REVERB
 */
#define CRIATOMEXASR_I3DL2_REVERB_PRESET_SEWERPIPE \
	{ -1000, -1000, 2.81f, 0.14f,    429, 0.014f,    648, 0.021f,  80.0f,  60.0f, 5000.0f}

/*JP
 * \brief I3DL2o[ũp[^[̃vZbg: UNDER WATER
 * \ingroup CRIATOMASR_DSP_PARAM_I3DL2_REVERB
 */
#define CRIATOMEXASR_I3DL2_REVERB_PRESET_UNDERWATER \
	{ -1000, -4000, 1.49f, 0.10f,   -449, 0.007f,   1700, 0.011f, 100.0f, 100.0f, 5000.0f}

/*JP
 * \brief I3DL2o[ũp[^[̃vZbg: SMALL ROOM
 * \ingroup CRIATOMASR_DSP_PARAM_I3DL2_REVERB
 */
#define CRIATOMEXASR_I3DL2_REVERB_PRESET_SMALLROOM \
	{ -1000,  -600, 1.10f, 0.83f,   -400, 0.005f,    500, 0.010f, 100.0f, 100.0f, 5000.0f}

/*JP
 * \brief I3DL2o[ũp[^[̃vZbg: MEDIUM ROOM
 * \ingroup CRIATOMASR_DSP_PARAM_I3DL2_REVERB
 */
#define CRIATOMEXASR_I3DL2_REVERB_PRESET_MEDIUMROOM \
	{ -1000,  -600, 1.30f, 0.83f,  -1000, 0.010f,   -200, 0.020f, 100.0f, 100.0f, 5000.0f}

/*JP
 * \brief I3DL2o[ũp[^[̃vZbg: LARGE ROOM
 * \ingroup CRIATOMASR_DSP_PARAM_I3DL2_REVERB
 */
#define CRIATOMEXASR_I3DL2_REVERB_PRESET_LARGEROOM \
	{ -1000,  -600, 1.50f, 0.83f,  -1600, 0.020f,  -1000, 0.040f, 100.0f, 100.0f, 5000.0f}

/*JP
 * \brief I3DL2o[ũp[^[̃vZbg: MEDIUM HALL
 * \ingroup CRIATOMASR_DSP_PARAM_I3DL2_REVERB
 */
#define CRIATOMEXASR_I3DL2_REVERB_PRESET_MEDIUMHALL \
	{ -1000,  -600, 1.80f, 0.70f,  -1300, 0.015f,   -800, 0.030f, 100.0f, 100.0f, 5000.0f}

/*JP
 * \brief I3DL2o[ũp[^[̃vZbg: LARGE HALL
 * \ingroup CRIATOMASR_DSP_PARAM_I3DL2_REVERB
 */
#define CRIATOMEXASR_I3DL2_REVERB_PRESET_LARGEHALL \
	{ -1000,  -600, 1.80f, 0.70f,  -2000, 0.030f,  -1400, 0.060f, 100.0f, 100.0f, 5000.0f}

/*JP
 * \brief I3DL2o[ũp[^[̃vZbg: PLATE
 * \ingroup CRIATOMASR_DSP_PARAM_I3DL2_REVERB
 */
#define CRIATOMEXASR_I3DL2_REVERB_PRESET_PLATE \
	{ -1000,  -200, 1.30f, 0.90f,      0, 0.002f,      0, 0.010f, 100.0f,  75.0f, 5000.0f}

/*JP
 * \defgroup CRIATOMASR_DSP_PARAM_MATRIX }gNX̃p[^[
 * \ingroup CRIATOMASR_DSP_PARAM
 * \brief }gNXŐݒ肷p[^[̒`łB
 * \sa criAtomExAsrRack_SetEffectParameter, criAtomExAsrRack_GetEffectParameter
 */

/*JP
 * \brief }gNX̃ftHg̓o̓`l
 * \ingroup CRIATOMASR_DSP_PARAM_MATRIX
 * \par :
 * RtBOp^ɂo̓`lw肳ȂꍇɎw肳܂B
 */
#define CRIATOMEXASR_MATRIX_DEFAULT_NUM_CHANNELS							(8)

/*JP
 * \brief }gNX̓o̓`lftHgŎw肳ꂽꍇ̓쎞p^
 * \ingroup CRIATOMASR_DSP_PARAM_MATRIX
 * \par :
 * }gNX̓o̓`lɃftHgw肳ꂽۂ̓쎞p^łB
 */
#define CRIATOMEXASR_MATRIX_DEFAULT_NUM_PARAMETERS							\
	(CRIATOMEXASR_MATRIX_DEFAULT_NUM_CHANNELS * CRIATOMEXASR_MATRIX_DEFAULT_NUM_CHANNELS)

/*JP
 * \defgroup CRIATOMASR_DSP_PARAM_MULTIBANDS_EQ 3ohCRCUE32ohCRCŨp[^[
 * \ingroup CRIATOMASR_DSP_PARAM
 * \brief 3ohCRCUE32ohCRCUŐݒ肷p[^[̒`łB
 * \sa criAtomExAsrRack_SetEffectParameter, criAtomExAsrRack_GetEffectParameter
 */

/*JP
 * \brief [VFttB^[w肷鎞̃p[^[̐ݒl
 * \ingroup CRIATOMASR_DSP_PARAM_MULTIBANDS_EQ
 */
#define CRIATOMEXASR_MULTIBANDS_EQ_BAND_FILTER_TYPE_LOWSHELF 			(0)

/*JP
 * \brief nCVFttB^[w肷鎞̃p[^[̐ݒl
 * \ingroup CRIATOMASR_DSP_PARAM_MULTIBANDS_EQ
 */
#define CRIATOMEXASR_MULTIBANDS_EQ_BAND_FILTER_TYPE_HIGHSHELF			(1)

/*JP
 * \brief s[LOtB^[w肷鎞̃p[^[̐ݒl
 * \ingroup CRIATOMASR_DSP_PARAM_MULTIBANDS_EQ
 */
#define CRIATOMEXASR_MULTIBANDS_EQ_BAND_FILTER_TYPE_PEAKING 			(2)

/*JP
 * \brief 3ohCRCU/32ohCRCU1oh̃p[^[
 * \ingroup CRIATOMASR_DSP_PARAM_MULTIBANDS_EQ
 */
#define CRIATOMEXASR_MULTIBANDS_EQ_NUM_PARAMETER_PAR_BAND 				(4)

/*JP
 * \defgroup CRIATOMASR_DSP_PARAM_PITCH_SHIFTER sb`Vt^̃p[^[
 * \ingroup CRIATOMASR_DSP_PARAM
 * \brief sb`Vt^Őݒ肷p[^[̒`łB
 * \sa criAtomExAsrRack_SetEffectParameter, criAtomExAsrRack_GetEffectParameter
 */
/*JP
 * \brief sb`ύX[VI]
 * \ingroup CRIATOMASR_DSP_PARAM_PITCH_SHIFTER
 * \par :
 * {p[^[CfbNXɃsb`Vt^̃sb`ύXʂw肵܂B<br>
 * sb`VtgliZglj̔䗦iVIjłBp[^[̏l1.0fAŏl0.25fi-2400ZgɑjAől4.0fi2400ZgɑjB<br>
 * \note VIlZglւ̕ϊ̓VIlɒꂪ2̑ΐlɁA1200.0f悶邱ƂŎ擾ł܂B
 * \code
 * // Zgl cent 烌VIl ratio ֕ϊ
 * ratio = powf(2.0f, cent / 1200.0f);
 * // VIl ratio Zgl cent ֕ϊ
 * cent = 1200.0f * log2f(ratio);
 * \endcode
 */
#define CRIATOMEXASR_PITCH_SHIFTER_PARAMETER_PITCH_RATIO				(0)

/*JP
 * \brief tH}gύX[VI]
 * \ingroup CRIATOMASR_DSP_PARAM_PITCH_SHIFTER
 * \par :
 * {p[^[CfbNXɃsb`Vt^̃tH}gύXʂw肵܂B<br>
 * sb`VtgliZglj̔䗦iVIjłBp[^[̏l1.0fAŏl0.25fi-2400ZgɑjAől4.0fi2400ZgɑjB<br>
 * \note VIlZglւ̕ϊ̓VIlɒꂪ2̑ΐlɁA1200.0f悶邱ƂŎ擾ł܂B
 * \code
 * // Zgl cent 烌VIl ratio ֕ϊ
 * ratio = powf(2.0f, cent / 1200.0f);
 * // VIl ratio Zgl cent ֕ϊ
 * cent = 1200.0f * log2f(ratio);
 * \endcode
 */
#define CRIATOMEXASR_PITCH_SHIFTER_PARAMETER_FORMANT_RATIO				(1)

/*JP
 * \brief 샂[h
 * \ingroup CRIATOMASR_DSP_PARAM_PITCH_SHIFTER
 * \par :
 * {p[^[CfbNXɃsb`Vt^̓샂[hw肵܂B<br>
 * ʊd邩ۂAlԂ̐܂񂾉isb`̂鉹jۂœK؂ȓ샂[hقȂ܂B
 * \sa CRIATOMEXASR_PITCH_SHIFTER_MODE_MUSIC, CRIATOMEXASR_PITCH_SHIFTER_MODE_VOCAL, CRIATOMEXASR_PITCH_SHIFTER_MODE_SE, CRIATOMEXASR_PITCH_SHIFTER_MODE_SPEECH
 */
#define CRIATOMEXASR_PITCH_SHIFTER_PARAMETER_MODE						(2)

/*JP
 * \brief ͉f[^̃sb`g[Hz]
 * \ingroup CRIATOMASR_DSP_PARAM_PITCH_SHIFTER
 * \par :
 * {p[^[CfbNXɓ͉f[^̃sb`gw肵܂B<br>
 * tH}g͂̍ۂ̃qgɂȂ܂Aۂ̉f[^ɂꂽlw肷ƉɎGt邽ߒӂĉBw肵Ȃꍇ̓ftHg̃sb`i459.375HzjŎgp܂B
 */
#define CRIATOMEXASR_PITCH_SHIFTER_PARAMETER_DATA_PITCH_FREQUENCY		(3)

/*JP
 * \brief sb`Vt^̃p[^[
 * \ingroup CRIATOMASR_DSP_PARAM_PITCH_SHIFTER
 */
#define CRIATOMEXASR_PITCH_SHIFTER_NUM_PARAMETERS						(4)

/*JP
 * \brief sb`Vt^̓샂[hŉyw肷ۂ̃p[^[̐ݒl
 * \ingroup CRIATOMASR_DSP_PARAM_PITCH_SHIFTER 
 * \par :
 * LRMSϊiL,Rch̉M,SchɕϊsjsAtH}gVtgs܂B
 */
#define CRIATOMEXASR_PITCH_SHIFTER_MODE_MUSIC							(0)

/*JP
 * \brief sb`Vt^̓샂[hŃ{[Jw肷ۂ̃p[^[̐ݒl
 * \ingroup CRIATOMASR_DSP_PARAM_PITCH_SHIFTER 
 * \par :
 * LRMSϊsAtH}gVtgs܂B
 */
#define CRIATOMEXASR_PITCH_SHIFTER_MODE_VOCAL							(1)

/*JP
 * \brief sb`Vt^̓샂[hSEw肷ۂ̃p[^[̐ݒl
 * \ingroup CRIATOMASR_DSP_PARAM_PITCH_SHIFTER 
 * \par :
 * LRMSϊ͍s킸AtH}gVtgs܂B
 */
#define CRIATOMEXASR_PITCH_SHIFTER_MODE_SE								(2)

/*JP
 * \brief sb`Vt^̓샂[hŃXs[`w肷ۂ̃p[^[̐ݒl
 * \ingroup CRIATOMASR_DSP_PARAM_PITCH_SHIFTER 
 * \par :
 * LRMSϊ͍s킸AtH}gVtg͍s܂B
 */
#define CRIATOMEXASR_PITCH_SHIFTER_MODE_SPEECH							(3)

/*JP
 * \defgroup CRIATOMASR_DSP_PARAM_REVERB o[ũp[^[
 * \ingroup CRIATOMASR_DSP_PARAM
 * \brief o[uŐݒ肷p[^[̒`łB
 * \sa criAtomExAsrRack_SetEffectParameter, criAtomExAsrRack_GetEffectParameter
 */
/*JP
 * \brief c[ms]
 * \ingroup CRIATOMASR_DSP_PARAM_REVERB
 * \par :
 * {p[^[CfbNXɃo[u̎cԂw肵܂B<br>
 * p[^[̏l3000.0fAŏl1.0fAől20000.0fłB
 */
#define CRIATOMEXASR_REVERB_PARAMETER_REVERB_TIME_MS					(0)

/*JP
 * \brief [TCY[m]
 * \ingroup CRIATOMASR_DSP_PARAM_REVERB
 * \par :
 * {p[^[CfbNXɃo[ũ[TCYw肵܂B<br>
 * ő僋[TCY̔̒lŏ܂Bp[^[̍ŏl1.0fAől50.0fłB
 */
#define CRIATOMEXASR_REVERB_PARAMETER_ROOM_SIZE_M						(1)

/*JP
 * \brief vfBC[ms]
 * \ingroup CRIATOMASR_DSP_PARAM_REVERB
 * \par :
 * {p[^[CfbNXɃo[ũvfBCԂw肵܂B<br>
 * p[^[̍ŏl10.0fAől1000.0fłB
 */
#define CRIATOMEXASR_REVERB_PARAMETER_PRE_DELAY_TIME_MS					(2)

/*JP
 * \brief JbgItg[Hz]
 * \ingroup CRIATOMASR_DSP_PARAM_REVERB
 * \par :
 * {p[^[CfbNXɃo[uo͂̒JbgItgw肵܂B<br>
 * l0.0fłBp[^[̍ŏl0.0fAől24000.0fłB
 */
#define CRIATOMEXASR_REVERB_PARAMETER_LOW_COF							(3)

/*JP
 * \brief JbgItg[Hz]
 * \ingroup CRIATOMASR_DSP_PARAM_REVERB
 * \par :
 * {p[^[CfbNXɃo[uo͂̍JbgItgw肵܂B<br>
 * l8000.0fłBp[^[̍ŏl8000.0fAől24000.fłB
 */
#define CRIATOMEXASR_REVERB_PARAMETER_HIGH_COF							(4)

/*JP
 * \brief o[ũp[^[
 * \ingroup CRIATOMASR_DSP_PARAM_REVERB
 */
#define CRIATOMEXASR_REVERB_NUM_PARAMETERS								(5)

/*JP
 * \brief o[u̓샂[hŃTEhw肷ۂ̃p[^[̐ݒl
 * \ingroup CRIATOMASR_DSP_PARAM_REVERB 
 * \par :
 * SCh̓͂mփ~bNXAoChɍ킹ă}gNXTEhɓWJs܂B<br>
 * 
 *  - oCh5Chȉ̏ꍇ́AXeIo͂s܂B
 *  - oCh6Chȏ̏ꍇ́ATEhChiTEhL,RChjɃAChiAL,RChj
 *    tʑ̐Mo͂܂B
 *
 * \attention Z^[ChLFȄo͖͂ɂȂ܂B
 */
#define CRIATOMEXASR_REVERB_MODE_DEF_SURROUND							(0)

/*JP
 * \brief o[u̓샂[hŃXeIw肷ۂ̃p[^[̐ݒl
 * \ingroup CRIATOMASR_DSP_PARAM_REVERB 
 * \par :
 * 2Chœo͂s܂B
 */
#define CRIATOMEXASR_REVERB_MODE_DEF_STEREO								(1)

/*JP
 * \brief o[u̓샂[hŃÂ݂w肷ۂ̃p[^[̐ݒl
 * \ingroup CRIATOMASR_DSP_PARAM_REVERB 
 * \par :
 * AChiAL,RChĵ݂œo͂s܂B
 */
#define CRIATOMEXASR_REVERB_MODE_DEF_REAR_ONLY							(2)

/*JP
 * \brief o[u̓샂[hŃZ^[݂̂w肷ۂ̃p[^[̐ݒl
 * \ingroup CRIATOMASR_DSP_PARAM_REVERB 
 * \par :
 * Z^[Cĥ݂œo͂s܂B
 */
#define CRIATOMEXASR_REVERB_MODE_DEF_CENTER_ONLY						(3)

/*JP
 * \defgroup CRIATOMASR_DSP_PARAM_SURROUNDER TE_̃p[^[
 * \ingroup CRIATOMASR_DSP_PARAM
 * \brief TE_Őݒ肷p[^[̒`łB
 * \sa criAtomExAsrRack_SetEffectParameter, criAtomExAsrRack_GetEffectParameter
 */
/*JP
 * \brief 샂[h
 * \ingroup CRIATOMASR_DSP_PARAM_SURROUNDER
 * \par :
 * {p[^[CfbNXɃTE_̓샂[hw肵܂B
 * \sa CRIATOMEXASR_SURROUNDER_MODE_STRAIGHT, CRIATOMEXASR_SURROUNDER_MODE_CROSS, CRIATOMEXASR_SURROUNDER_MODE_MATRIX
 */
#define CRIATOMEXASR_SURROUNDER_PARAMETER_MODE							(0)

/*JP
 * \brief TEh̒x[ms]
 * \ingroup CRIATOMASR_DSP_PARAM_SURROUNDER
 * \par :
 * {p[^[CfbNXɃTE_̃TEh`l̒xԂw肵܂B<br>
 * p[^[̏l0.0fAŏl0.0fAől500.0fłB
 */
#define CRIATOMEXASR_SURROUNDER_PARAMETER_DELAY_TIME_MS					(1)

/*JP
 * \brief TEh̃QC[U]
 * \ingroup CRIATOMASR_DSP_PARAM_SURROUNDER
 * \par :
 * {p[^[CfbNXɃTE_̃TEh`l̏o̓QCw肵܂B<br>
 * p[^[̏l1.0fAŏl0.0fAől102.4i48dBɑjłB
 */
#define CRIATOMEXASR_SURROUNDER_PARAMETER_GAIN							(2)

/*JP
 * \brief TE_̃p[^[
 * \ingroup CRIATOMASR_DSP_PARAM_SURROUNDER
 */
#define CRIATOMEXASR_SURROUNDER_NUM_PARAMETERS							(3)


/*JP
 * \brief TE_̓샂[hŃXg[gw肷ۂ̃p[^[̐ݒl
 * \ingroup CRIATOMASR_DSP_PARAM_SURROUNDER
 * \par :
 * ͂LChTEhLChɁARChTEhRChɓWJ܂B
 */
#define CRIATOMEXASR_SURROUNDER_MODE_STRAIGHT							(0)

/*JP
 * \brief TE_̓샂[hŃNXw肷ۂ̃p[^[̐ݒl
 * \ingroup CRIATOMASR_DSP_PARAM_SURROUNDER
 * \par :
 * ͂LChTEhRChɁARChTEhLChɓWJ܂B
 */
#define CRIATOMEXASR_SURROUNDER_MODE_CROSS								(1)

/*JP
 * \brief TE_̓샂[hŃ}gNXw肷ۂ̃p[^[̐ݒl
 * \ingroup CRIATOMASR_DSP_PARAM_SURROUNDER
 * \par :
 * ͂LCh - RChiLCh͂RCh͂́jTEhLChɁARCh - LChTEhRChɓWJ܂B
 */
#define CRIATOMEXASR_SURROUNDER_MODE_MATRIX								(2)

/*JP
 * \defgroup CRIATOMASR_DSP_PARAM_BIT_CRUSHER rbgNbV[̃p[^[
 * \ingroup CRIATOMASR_DSP_PARAM
 * \brief rbgNbV[Őݒ肷p[^[̒`łB
 * \sa criAtomExAsrRack_SetEffectParameter, criAtomExAsrRack_GetEffectParameter
 */
/*JP
 * \brief c݂̋[dB]
 * \ingroup CRIATOMASR_DSP_PARAM_BIT_CRUSHER
 * \par :
 * {p[^[CfbNXɃrbgNbV[̘c݂̋ihCujw肵܂B<br>
 * p[^[̏l0.5fAŏl0.0fAől48.0fłB
 */
#define CRIATOMEXASR_BIT_CRUSHER_PARAMETER_DRIVE_DB						(0)

/*JP
 * \brief ʎqrbg
 * \ingroup CRIATOMASR_DSP_PARAM_BIT_CRUSHER
 * \par :
 * {p[^[CfbNXɃrbgNbV[̗ʎqrbgw肵܂B<br>
 * ݒ肷قǐULo-FiɂȂ܂B<br>
 * p[^[̏l8Aŏl1Aől24łB
 */
#define CRIATOMEXASR_BIT_CRUSHER_PARAMETER_DEPTH_BITS					(1)

/*JP
 * \brief _ETvO
 * \ingroup CRIATOMASR_DSP_PARAM_BIT_CRUSHER
 * \par :
 * {p[^[CfbNXɃrbgNbV[̃_ETvOw肵܂B<br>
 * 傫ݒ肷قǎԂLo-FiɂȂ܂B<br>
 * p[^[̏l8Aŏl1Aől100łB
 */
#define CRIATOMEXASR_BIT_CRUSHER_PARAMETER_DOWN_SAMPLING				(2)

/*JP
 * \brief drẙ
 * \ingroup CRIATOMASR_DSP_PARAM_BIT_CRUSHER
 * \par :
 * {p[^[CfbNXɃrbgNbV[dryij~bNX銄w肵܂B<br>
 * p[^[̏l0.71fAŏl0.0fAől1.0fłB
 */
#define CRIATOMEXASR_BIT_CRUSHER_PARAMETER_DRY_MIX						(3)

/*JP
 * \brief wet̊
 * \ingroup CRIATOMASR_DSP_PARAM_BIT_CRUSHER
 * \par :
 * {p[^[CfbNXɃrbgNbV[wetic݁j~bNX銄w肵܂B<br>
 * p[^[̏l0.71fAŏl0.0fAől1.0fłB
 */
#define CRIATOMEXASR_BIT_CRUSHER_PARAMETER_WET_MIX						(4)

/*JP
 * \brief ŏIo̓x[U]
 * \ingroup CRIATOMASR_DSP_PARAM_BIT_CRUSHER
 * \par :
 * {p[^[CfbNXɃrbgNbV[̍ŏIo̓xw肵܂B<br>
 * p[^[̏l0.5fAŏl0.0fAől102.4i48dBɑljłB
 */
#define CRIATOMEXASR_BIT_CRUSHER_PARAMETER_OUTPUT_GAIN					(5)

/*JP
 * \brief rbgNbV[̃p[^[
 * \ingroup CRIATOMASR_DSP_PARAM_BIT_CRUSHER
 */
#define CRIATOMEXASR_BIT_CRUSHER_NUM_PARAMETERS							(6)

/*JP
 * \defgroup CRIATOMASR_DSP_PARAM_PHASER tF[U[̃p[^[
 * \ingroup CRIATOMASR_DSP_PARAM
 * \brief tF[U[Őݒ肷p[^[̒`łB
 * \sa criAtomExAsrRack_SetEffectParameter, criAtomExAsrRack_GetEffectParameter
 */
/*JP
 * \brief x[ms]
 * \ingroup CRIATOMASR_DSP_PARAM_PHASER
 * \par :
 * {p[^[CfbNXɃtF[U[̃tFCWOʂ̋w肵܂B<br>
 * p[^[̏l8Aŏl4Aől12łB
 */
#define CRIATOMEXASR_PHASER_PARAMETER_STAGES							(0)

/*JP
 * \brief [iLFOUj
 * \ingroup CRIATOMASR_DSP_PARAM_PHASER
 * \par :
 * {p[^[CfbNXɃtF[U[̐[w肵܂B<br>
 * p[^[̏l0.5fAŏl0.0fAől1.0fłB
 */
#define CRIATOMEXASR_PHASER_PARAMETER_DEPTH								(1)

/*JP
 * \brief [giXs[hALFOgj[Hz]
 * \ingroup CRIATOMASR_DSP_PARAM_PHASER
 * \par :
 * {p[^[CfbNXɃtF[U[LFÕ[gw肵܂B<br>
 * p[^[̏l1.0fAŏl0.01fAől100.0fłB
 */
#define CRIATOMEXASR_PHASER_PARAMETER_RATE								(2)

/*JP
 * \brief tB[hobNQC
 * \ingroup CRIATOMASR_DSP_PARAM_PHASER
 * \par :
 * {p[^[CfbNXɃtF[U[̃tB[hobNQCw肵܂B<br>
 * p[^[̏l0.0fAŏl0.0fAől1.0fłB
 */
#define CRIATOMEXASR_PHASER_PARAMETER_FEEDBACK							(3)

/*JP
 * \brief drỹ~bNX
 * \ingroup CRIATOMASR_DSP_PARAM_PHASER
 * \par :
 * {p[^[CfbNXɃtF[U[dryij̃~bNXw肵܂B<br>
 * p[^[̏l0.71fAŏl0.0fAől1.0fłB
 */
#define CRIATOMEXASR_PHASER_PARAMETER_DRY_MIX							(4)

/*JP
 * \brief wet̃~bNX
 * \ingroup CRIATOMASR_DSP_PARAM_PHASER
 * \par :
 * {p[^[CfbNXɃtF[U[wetij̃~bNXw肵܂B
 * p[^[̏l0.71fAŏl0.0fAől1.0fłB
 */
#define CRIATOMEXASR_PHASER_PARAMETER_WET_MIX							(5)

/*JP
 * \brief tF[U[̃p[^[
 * \ingroup CRIATOMASR_DSP_PARAM_PHASER
 */
#define CRIATOMEXASR_PHASER_NUM_PARAMETERS								(6)

/*JP
 * \defgroup CRIATOMASR_DSP_PARAM_HEADPHONE_VIRTUAL_SURROUND wbhtHo[`TEh̃p[^[
 * \ingroup CRIATOMASR_DSP_PARAM
 * \brief wbhtHo[`TEhŐݒ肷p[^[̒`łB
 * \sa criAtomExAsrRack_SetEffectParameter, criAtomExAsrRack_GetEffectParameter
 */
/*JP
 * \brief QC
 * \ingroup CRIATOMASR_DSP_PARAM_HEADPHONE_VIRTUAL_SURROUND
 * \par :
 * Ŝ̉ʂɑ΂{BPʂdBB
 */
#define CRIATOMEXASR_HEADPHONE_VIRTUAL_SURROUND_GAIN					(0)

/*JP
 * \brief oX
 * \ingroup CRIATOMASR_DSP_PARAM_HEADPHONE_VIRTUAL_SURROUND
 * \par :
 * tg̃AATEhɑ΂鑊΃{[BPʂdBB
 */
#define CRIATOMEXASR_HEADPHONE_VIRTUAL_SURROUND_BALANCE					(1)

/*JP
 * \brief o[`TEh쎞Ɏw\ȃp[^[
 * \ingroup CRIATOMASR_DSP_PARAM_HEADPHONE_VIRTUAL_SURROUND
 */
#define CRIATOMEXASR_HEADPHONE_VIRTUAL_SURROUND_NUM_PARAMETERS			(2)

/*JP
 * \defgroup CRIATOMASR_DSP_PARAM_IR_REVERB IRo[ũp[^[
 * \ingroup CRIATOMASR_DSP_PARAM
 * \brief IRo[uŐݒ肷p[^[̒`łB
 * \sa criAtomExAsrRack_SetEffectParameter, criAtomExAsrRack_GetEffectParameter
 */
/*JP
 * \brief hC̃QC(0 ~ 1)
 * \ingroup CRIATOMASR_DSP_PARAM_IR_REVERB
 * \par :
 * hC̃~bNXQCłB
 * ̃GtFNgKp̓hCłAtom̃T[o[g1V̒x܂B
 * xNeBJȏꍇÃp[^[0ɐݒ肵ʃoXŃhC~bNXĂB
 */
#define CRIATOMEXASR_IR_REVERB_PARAMETER_DRY_GAIN						(0)

/*JP
 * \brief EFbg̃QC(0 ~ 1)
 * \ingroup CRIATOMASR_DSP_PARAM_IR_REVERB
 * \par :
 * EFbg̃~bNXQCłB
 * ɋĂc܂߁AGtFNgo͂SẴEFbgɓKp܂B
 */
#define CRIATOMEXASR_IR_REVERB_PARAMETER_WET_GAIN						(1)

/*JP
 * \brief c̃QC(0 ~ 1)
 * \ingroup CRIATOMASR_DSP_PARAM_IR_REVERB
 * \par :
 * c𐶐鎞ɓKpQCłB
 * EFbgQCƈقȂAȍ~cɂ̂ݓKp܂B
 * ɋĂcɂ͓Kp܂BIR̐ؑ֎ɍXV邱ƂŁAIRƂ̎č݂𒲐ł܂B
 */
#define CRIATOMEXASR_IR_REVERB_PARAMETER_REVERB_GAIN					(2)

/*JP
 * \brief ͐M̃XeI~bNX̍Ex(0 ~ 1)
 * \ingroup CRIATOMASR_DSP_PARAM_IR_REVERB
 * \par :
 * ͐Mݍ݂̂߂ɃXeI~bNX鎞AE̕xw肵܂B
 * ̃p[^[0̏ꍇA͐Mm~bNXIRƏ􍞂݂s܂B
 * 1̏ꍇA͐M̍(L, SL, SBL)ƉE(R, SR, SBR)ꂼXeILRɃ~bNX܂B
 * mIRɑ΂̃p[^[0̏ꍇAEɑSc邱ƂɂӂB
 */
#define CRIATOMEXASR_IR_REVERB_PARAMETER_INPUT_SEPARATION_RATIO			(3)

/*JP
 * \brief ͐M̃XeI~bNX̃tg̃QC(0 ~ 1)
 * \ingroup CRIATOMASR_DSP_PARAM_IR_REVERB
 * \par :
 * ͐MXeI~bNX邽߂̃tg̃QCw肵܂B
 */
#define CRIATOMEXASR_IR_REVERB_PARAMETER_FRONT_INPUT_GAIN				(4)

/*JP
 * \brief ͐M̃XeI~bNX̃Z^[̃QC(0 ~ 1)
 * \ingroup CRIATOMASR_DSP_PARAM_IR_REVERB
 * \par :
 * ͐MXeI~bNX邽߂̃Z^[̃QCw肵܂B
 */
#define CRIATOMEXASR_IR_REVERB_PARAMETER_CENTER_INPUT_GAIN				(5)

/*JP
 * \brief ͐M̃XeI~bNX̃TEh̃QC(0 ~ 1)
 * \ingroup CRIATOMASR_DSP_PARAM_IR_REVERB
 * \par :
 * ͐MXeI~bNX邽߂̃TEh̃QCw肵܂B
 */
#define CRIATOMEXASR_IR_REVERB_PARAMETER_SURROUND_INPUT_GAIN			(6)

/*JP
 * \brief ͐M̃XeI~bNX̃TEhobÑQC(0 ~ 1)
 * \ingroup CRIATOMASR_DSP_PARAM_IR_REVERB
 * \par :
 * ͐MXeI~bNX邽߂̃TEhobÑQCw肵܂B
 */
#define CRIATOMEXASR_IR_REVERB_PARAMETER_SURROUND_BACK_INPUT_GAIN		(7)

/*JP
 * \brief EFbg̃Abv~bNX̃tg̃QC(0 ~ 1)
 * \ingroup CRIATOMASR_DSP_PARAM_IR_REVERB
 * \par :
 * ꂽXeĨEFbgicj͐MƓ`lɃ~bNX邽߂̃tg̃QCw肵܂B
 */
#define CRIATOMEXASR_IR_REVERB_PARAMETER_FRONT_OUTPUT_GAIN				(8)

/*JP
 * \brief EFbg̃Abv~bNX̃Z^[̃QC(0 ~ 1)
 * \ingroup CRIATOMASR_DSP_PARAM_IR_REVERB
 * \par :
 * ꂽXeĨEFbgicj͐MƓ`lɃ~bNX邽߂̃Z^[̃QCw肵܂B
 */
#define CRIATOMEXASR_IR_REVERB_PARAMETER_CENTER_OUTPUT_GAIN				(9)

/*JP
 * \brief EFbg̃Abv~bNX̃TEh̃QC(0 ~ 1)
 * \ingroup CRIATOMASR_DSP_PARAM_IR_REVERB
 * \par :
 * ꂽXeĨEFbgicj͐MƓ`lɃ~bNX邽߂̃TEh̃QCw肵܂B
 */
#define CRIATOMEXASR_IR_REVERB_PARAMETER_SURROUND_OUTPUT_GAIN			(10)

/*JP
 * \brief EFbg̃Abv~bNX̃TEhobÑQC(0 ~ 1)
 * \ingroup CRIATOMASR_DSP_PARAM_IR_REVERB
 * \par :
 * ꂽXeĨEFbgicj͐MƓ`lɃ~bNX邽߂̃TEhobÑQCw肵܂B
 */
#define CRIATOMEXASR_IR_REVERB_PARAMETER_SURROUND_BACK_OUTPUT_GAIN		(11)

/*JP
 * \brief IR̃CfbNXԍ
 * \ingroup CRIATOMASR_DSP_PARAM_IR_REVERB
 * \par :
 * IR̃Xg􍞂݂ɗpIRw肷CfbNXԍłB
 * ͈͊OIRw肵ꍇA0Ԗڂ̎w肵܂B
 * ̃p[^[Ŏw肵IR͐V̎cɂ̂ݓKp܂B
 * xꂽ̎ćAcI܂ŔIRKp܂B
 */
#define CRIATOMEXASR_IR_REVERB_PARAMETER_CURRENT_IR_INDEX				(12)

/*JP
 * \brief IRo[ũGtFNgp[^
 * \ingroup CRIATOMASR_DSP_PARAM_IR_REVERB
 */
#define CRIATOMEXASR_IR_REVERB_NUM_PARAMETERS							(13)

/*JP
 * \defgroup CRIATOMASR_DSP_PARAM_I3DL2_REVERB2 I3DL2o[u Ver.2 ̃p[^[
 * \ingroup CRIATOMASR_DSP_PARAM
 * \brief I3DL2o[u Ver.2 Őݒ肷p[^[̒`łB
 * \sa criAtomExAsrRack_SetEffectParameter, criAtomExAsrRack_GetEffectParameter
 */
/*JP
 * \brief GtFNgŜ̏o̓{[[mB]
 * \ingroup CRIATOMASR_DSP_PARAM_I3DL2_REVERB2
 * \par :
 * I3DL2o[u Ver.2 ̍ŏIo̓{[w肵܂B
 */
#define CRIATOMEXASR_I3DL2_REVERB2_PARAMETER_ROOM						(0)

/*JP
 * \brief QƎgij̃{[[mB]
 * \ingroup CRIATOMASR_DSP_PARAM_I3DL2_REVERB2
 * \par :
 * I3DL2o[u Ver.2 ̎QƎgij̃{[w肵܂B
 */
#define CRIATOMEXASR_I3DL2_REVERB2_PARAMETER_ROOM_HF					(1)

/*JP
 * \brief 㕔č[sec]
 * \ingroup CRIATOMASR_DSP_PARAM_I3DL2_REVERB2
 * \par :
 * I3DL2o[u Ver.2 ̌㕔čԂw肵܂B
 */
#define CRIATOMEXASR_I3DL2_REVERB2_PARAMETER_DECAY_TIME					(2)

/*JP
 * \brief 㕔c̒gɑ΂鍂g̔
 * \ingroup CRIATOMASR_DSP_PARAM_I3DL2_REVERB2
 * \par :
 * I3DL2o[u Ver.2 ̌㕔cɂAgɑ΂鍂g̓w肵܂B
 */
#define CRIATOMEXASR_I3DL2_REVERB2_PARAMETER_DECAY_HF_RATIO				(3)

/*JP
 * \brief ˉ̃{[[mB]
 * \ingroup CRIATOMASR_DSP_PARAM_I3DL2_REVERB2
 * \par :
 * I3DL2o[u Ver.2 ̏ˉ̃{[w肵܂B
 */
#define CRIATOMEXASR_I3DL2_REVERB2_PARAMETER_REFLECTIONS				(4)

/*JP
 * \brief ˉ̒x[sec]
 * \ingroup CRIATOMASR_DSP_PARAM_I3DL2_REVERB2
 * \par :
 * I3DL2o[u Ver.2 ̏ˉ̃{[w肵܂B
 */
#define CRIATOMEXASR_I3DL2_REVERB2_PARAMETER_REFLECTIONS_DELAY			(5)

/*JP
 * \brief 㕔c̃{[[mB]
 * \ingroup CRIATOMASR_DSP_PARAM_I3DL2_REVERB2
 * \par :
 * I3DL2o[u Ver.2 ̌㕔c̃{[w肵܂B
 */
#define CRIATOMEXASR_I3DL2_REVERB2_PARAMETER_REVERB						(6)

/*JP
 * \brief 㕔c̒x[sec]
 * \ingroup CRIATOMASR_DSP_PARAM_I3DL2_REVERB2
 * \par :
 * I3DL2o[u Ver.2 ̌㕔c̒xԂw肵܂B
 */
#define CRIATOMEXASR_I3DL2_REVERB2_PARAMETER_REVERB_DELAY				(7)

/*JP
 * \brief 㕔c̃GR[x[%]
 * \ingroup CRIATOMASR_DSP_PARAM_I3DL2_REVERB2
 * \par :
 * I3DL2o[u Ver.2 ̌㕔c̃GR[xw肵܂B
 */
#define CRIATOMEXASR_I3DL2_REVERB2_PARAMETER_DIFFUSION					(8)

/*JP
 * \brief 㕔c̃[_x[%]
 * \ingroup CRIATOMASR_DSP_PARAM_I3DL2_REVERB2
 * \par :
 * I3DL2o[u Ver.2 ̌㕔c̃[_xw肵܂B
 */
#define CRIATOMEXASR_I3DL2_REVERB2_PARAMETER_DENSITY					(9)

/*JP
 * \brief RoomHF̎QƎgij[Hz]
 * \ingroup CRIATOMASR_DSP_PARAM_I3DL2_REVERB2
 * \par :
 * I3DL2o[u Ver.2 RoomHF̎QƎgijw肵܂B
 */
#define CRIATOMEXASR_I3DL2_REVERB2_PARAMETER_HF_REFERENCE				(10)

/*JP
 * \brief tg̓̓x[mB]
 * \ingroup CRIATOMASR_DSP_PARAM_I3DL2_REVERB2
 * \par :
 * I3DL2o[u Ver.2 ̃tgiL,R`lj̓̓xw肵܂BI3DL2o[u Ver.2 ̃vZbgł͎włȂɒӂĉB
 */
#define CRIATOMEXASR_I3DL2_REVERB2_PARAMETER_FRONT_INPUT				(11)

/*JP
 * \brief A̓̓x[mB]
 * \ingroup CRIATOMASR_DSP_PARAM_I3DL2_REVERB2
 * \par :
 * I3DL2o[u Ver.2 ̃AiTEhL,TEhR`lj̓̓xw肵܂BI3DL2o[u Ver.2 ̃vZbgł͎włȂɒӂĉB
 */
#define CRIATOMEXASR_I3DL2_REVERB2_PARAMETER_REAR_INPUT					(12)

/*JP
 * \brief Z^[̓̓x[mB]
 * \ingroup CRIATOMASR_DSP_PARAM_I3DL2_REVERB2
 * \par :
 * I3DL2o[u Ver.2 ̃Z^[iC`lj̓̓xw肵܂BI3DL2o[u Ver.2 ̃vZbgł͎włȂɒӂĉB
 */
#define CRIATOMEXASR_I3DL2_REVERB2_PARAMETER_CENTER_INPUT				(13)

/*JP
 * \brief tg̏o̓x[mB]
 * \ingroup CRIATOMASR_DSP_PARAM_I3DL2_REVERB2
 * \par :
 * I3DL2o[u Ver.2 ̃tgiL,R`lj̏o̓xw肵܂BI3DL2o[u Ver.2 ̃vZbgł͎włȂɒӂĉB
 */
#define CRIATOMEXASR_I3DL2_REVERB2_PARAMETER_FRONT_OUTPUT				(14)

/*JP
 * \brief Ȁo̓x[mB]
 * \ingroup CRIATOMASR_DSP_PARAM_I3DL2_REVERB2
 * \par :
 * I3DL2o[u Ver.2 ̃AiTEhL,TEhR`lj̏o̓xw肵܂BI3DL2o[u Ver.2 ̃vZbgł͎włȂɒӂĉB
 */
#define CRIATOMEXASR_I3DL2_REVERB2_PARAMETER_REAR_OUTPUT				(15)

/*JP
 * \brief Z^[̏o̓x[mB]
 * \ingroup CRIATOMASR_DSP_PARAM_I3DL2_REVERB2
 * \par :
 * I3DL2o[u Ver.2 ̃Z^[iC`lj̏o̓xw肵܂BI3DL2o[u Ver.2 ̃vZbgł͎włȂɒӂĉB
 */
#define CRIATOMEXASR_I3DL2_REVERB2_PARAMETER_CENTER_OUTPUT				(16)

/*JP
 * \brief I3DL2o[u Ver.2 ̃p[^[
 * \ingroup CRIATOMASR_DSP_PARAM_I3DL2_REVERB2
 */
#define CRIATOMEXASR_I3DL2_REVERB2_NUM_PARAMETERS						(17)
/***************************************************************************
 *      }N
 *      Macro Functions
 ***************************************************************************/
/*==========================================================================
 *      CRI AtomEx ASR API
 *=========================================================================*/
/*JP
 * \brief ASȐRtBO\̂ɃftHglZbg
 * \ingroup ATOMEXLIB_ASR
 * \par :
 * ::criAtomExAsr_Initialize ֐ɐݒ肷RtBO\
 * i ::CriAtomExAsrConfig jɁAftHglZbg܂B<br>
 * \sa criAtomExAsr_Initialize, CriAtomExAsrConfig
 */
#define criAtomExAsr_SetDefaultConfig(p_config)	\
{\
	(p_config)->server_frequency = 60.0f;\
	(p_config)->num_buses = CRIATOMEXASR_DEFAULT_NUM_BUSES; \
	(p_config)->output_channels = CRIATOM_DEFAULT_OUTPUT_CHANNELS;\
	(p_config)->speaker_mapping = CRIATOM_SPEAKER_MAPPING_AUTO;\
	(p_config)->output_sampling_rate = CRIATOM_DEFAULT_OUTPUT_SAMPLING_RATE;\
	(p_config)->sound_renderer_type	= CRIATOM_SOUND_RENDERER_NATIVE;\
	(p_config)->context	= NULL;\
	(p_config)->max_racks = 8;\
	(p_config)->ambisonics_order_type = CRIATOMAMBISONICS_ORDER_TYPE_NONE;\
}

/*JP
 * \brief x@\RtBO\̂ɃftHglZbg
 * \ingroup ATOMEXLIB_ASR
 * \par :
 * ::criAtomExAsr_AttachBusAnalyzerByName ֐ɐݒ肷RtBO\
 * i ::CriAtomExAsrBusAnalyzerConfig jɁAftHglZbg܂B<br>
 * \sa criAtomExAsr_AttachBusAnalyzerByName, CriAtomExAsrBusAnalyzerConfig
 */
#define criAtomExAsr_SetDefaultConfigForBusAnalyzer(p_config) \
{\
	(p_config)->interval = 50;\
	(p_config)->peak_hold_time = 1000;\
}

/*==========================================================================
 *      CRI AtomEx ASR Rack API
 *=========================================================================*/
/*JP
 * \brief CriAtomAsrConfigւ̃ftHgp[^[Zbg
 * \ingroup ATOMLIB_ASR
 * \param[out]	p_config	pRtBO\̂ւ̃|C^
 * \par :
 * ::criAtomAsr_Initialize ֐ɐݒ肷RtBO\́i ::CriAtomAsrConfig jɁA
 * ftHg̒lZbg܂B<br>
 * \sa
 * CriAtomAsrConfig
*/
#define criAtomExAsrRack_SetDefaultConfig(p_config)	\
{\
	(p_config)->server_frequency = 60.0f;\
	(p_config)->num_buses = CRIATOMEXASR_DEFAULT_NUM_BUSES; \
	(p_config)->output_channels = CRIATOM_DEFAULT_OUTPUT_CHANNELS;\
	(p_config)->speaker_mapping = CRIATOM_SPEAKER_MAPPING_AUTO;\
	(p_config)->output_sampling_rate = CRIATOM_DEFAULT_OUTPUT_SAMPLING_RATE;\
	(p_config)->sound_renderer_type	= CRIATOM_SOUND_RENDERER_NATIVE;\
	(p_config)->output_rack_id = 0;\
	(p_config)->context = NULL;\
}

/*==========================================================================
 *      CRI Atom ASR API
 *=========================================================================*/
/*JP
 * \brief CriAtomAsrConfigւ̃ftHgp[^[Zbg
 * \ingroup ATOMLIB_ASR
 * \param[out]	p_config	pRtBO\̂ւ̃|C^
 * \par :
 * ::criAtomAsr_Initialize ֐ɐݒ肷RtBO\́i ::CriAtomAsrConfig jɁA
 * ftHg̒lZbg܂B<br>
 * \sa
 * CriAtomAsrConfig
*/
#define criAtomAsr_SetDefaultConfig(p_config)	\
{\
	(p_config)->server_frequency = 60.0f;\
	(p_config)->num_buses = CRIATOMEXASR_DEFAULT_NUM_BUSES; \
	(p_config)->output_channels = CRIATOM_DEFAULT_OUTPUT_CHANNELS;\
	(p_config)->speaker_mapping = CRIATOM_SPEAKER_MAPPING_AUTO;\
	(p_config)->output_sampling_rate = CRIATOM_DEFAULT_OUTPUT_SAMPLING_RATE;\
	(p_config)->sound_renderer_type	= CRIATOM_SOUND_RENDERER_NATIVE;\
	(p_config)->context	= NULL;\
	(p_config)->max_racks = 8;\
	(p_config)->ambisonics_order_type = CRIATOMAMBISONICS_ORDER_TYPE_NONE;\
}

/*==========================================================================
 *      CRI AtomEx API
 *=========================================================================*/
/*JP
* \brief CupRtBO\̂ɃftHglZbg
* \ingroup ATOMEXLIB_GLOBAL
* \param[out]	p_config	pRtBO\̂ւ̃|C^
* \par :
* ::criAtomEx_InitializeForUserPcmOutput ֐ɐݒ肷RtBO\
* i ::CriAtomExConfigForUserPcmOutput jɁAftHg̒lZbg܂B<br>
* \sa CriAtomExConfigForUserPcmOutput
*/
#define criAtomEx_SetDefaultConfigForUserPcmOutput(p_config)			\
{															\
	criAtomEx_SetDefaultConfig(&(p_config)->atom_ex);		\
	criAtomExAsr_SetDefaultConfig(&(p_config)->asr);		\
	criAtomExHcaMx_SetDefaultConfig(&(p_config)->hca_mx);	\
}

/*==========================================================================
 *      CRI Atom Player API
 *=========================================================================*/
 /*JP
  * \brief CriAtomPlayerConfig_ASRւ̃ftHgp[^[̃Zbg
  * \ingroup ATOMLIB_ASR
  * \param[in]	p_config	v[[쐬pRtBO\̂ւ̃|C^
  * \par :
  * v[[쐬ۂɁAdlw肷邽߂̃RtBO\
  * i ::CriAtomPlayerConfig_ASR jɁAftHg̒lZbg܂B<br>
  * \sa CriAtomPlayerConfig_ASR
  */
#define criAtomPlayer_SetDefaultConfig_ASR(p_config)				\
{																	\
	(p_config)->max_routes = CRIATOMEXASR_DEFAULT_NUM_ROUTES;		\
}

/*==========================================================================
 *      CRI ASRoXGtFNg p[^[CfbNXANZX}N
 *=========================================================================*/
/*JP
 * \brief wet̃~bNX
 * \ingroup CRIATOMASR_DSP_PARAM_CHORUS
 * \param[in] tap_index	ݒΏۂ̃W[^^bṽCfbNX
 * \par :
 * {p[^[CfbNXɃR[XwetitB[hobNj̃~bNXW[^̃CfbNXɂw肵܂B<br>
 * SẴ^bvŃp[^[̏l0.5fAŏl0.0fAől1.0fłB
 */
#define CRIATOMEXASR_CHORUS_PARAMETER_WET_MIX(tap_index)				\
	((tap_index) + 5)

/*JP
 * \brief Zhx[U]
 * \param[in] input_ch	ݒΏۂ̓̓`l
 * \param[in] output_ch	ݒΏۂ̏o̓`l
 * \ingroup CRIATOMASR_DSP_PARAM_MATRIX
 * \par :
 * {p[^[CfbNXɃ}gNX̃Zhxo̓`lpĎw肵܂B<br>
 * p[^[̍ŏl0.0fAől1.0fłBlɂinput_ch == output_ch̗vfɂ1.0fAȊOɂ0.0fZbg܂B
 * {p[^[CfbNX 8 x 8 ch ̃}gNXΏۂƂĂ܂B̂߁AȊÕTCYō쐬ꂽ}gNXł͑zƂ͈قȂ铮鋰ꂪ܂B
 */
#define CRIATOMEXASR_MATRIX_PARAMETER_LEVELS(input_ch, output_ch)		\
	((input_ch) * CRIATOMEXASR_MATRIX_DEFAULT_NUM_CHANNELS + (output_ch))

/*JP
 * \brief eoh̃tB^[^Cv
 * \ingroup CRIATOMASR_DSP_PARAM_MULTIBANDS_EQ
 * \param[in] band_index	ݒΏۂ̃ohCfbNX
 * \par :
 * {p[^[CfbNX3ohCRCUE32ohCRCŮeoh̃tB^[̃^Cvw肵܂B<br>
 * eoh̃tB^[̓oCNAbhtB^[\܂B
 * \attention 32ohCRCUł́Ac[ŗLɂoh̃tB^[݂̂LɂȂAohLɂȂĂoĥ݂ɐ܂B
 * \sa CRIATOMEXASR_MULTIBANDS_EQ_BAND_FILTER_TYPE_LOWSHELF, CRIATOMEXASR_MULTIBANDS_EQ_BAND_FILTER_TYPE_HIGHSHELF, CRIATOMEXASR_MULTIBANDS_EQ_BAND_FILTER_TYPE_PEAKING
 */
#define CRIATOMEXASR_MULTIBANDS_EQ_PARAMETER_TYPE(band_index)			\
	(CRIATOMEXASR_MULTIBANDS_EQ_NUM_PARAMETER_PAR_BAND * (band_index))

/*JP
 * \brief eoh̒Sg[Hz]
 * \ingroup CRIATOMASR_DSP_PARAM_MULTIBANDS_EQ
 * \param[in] band_index	ݒΏۂ̃ohCfbNX
 * \par :
 * {p[^[CfbNX3ohCRCUE32ohCRCŮeoh̃tB^[̒Sgw肵܂B<br>
 * p[^[̏l24.0fAŏl24.0fAől24000.fłB
 */
#define CRIATOMEXASR_MULTIBANDS_EQ_PARAMETER_FREQUENCY(band_index)		\
	(CRIATOMEXASR_MULTIBANDS_EQ_NUM_PARAMETER_PAR_BAND * (band_index) + 1)	

/*JP
 * \brief eohQl
 * \ingroup CRIATOMASR_DSP_PARAM_MULTIBANDS_EQ
 * \param[in] band_index	ݒΏۂ̃ohCfbNX
 * \par :
 * {p[^[CfbNX3ohCRCUE32ohCRCŮeohQlisxANIeBt@N^jw肵܂B<br>
 * p[^[̏l1.0fAŏl0.0fAől10.0fłB<br>
 * ohpXtB^[ȊOł͐M̍ۂɍŏl0.001fɐ܂B
 */
#define CRIATOMEXASR_MULTIBANDS_EQ_PARAMETER_QUALITY_FACTOR(band_index)	\
	(CRIATOMEXASR_MULTIBANDS_EQ_NUM_PARAMETER_PAR_BAND * (band_index) + 2)	

/*JP
 * \brief eoh̏o̓QC[U]
 * \ingroup CRIATOMASR_DSP_PARAM_MULTIBANDS_EQ
 * \param[in] band_index	ݒΏۂ̃ohCfbNX
 * \par :
 * {p[^[CfbNX3ohCRCUE32ohCRCŮeoh̏o̓QCw肵܂B<br>
 * p[^[̏l1.0fAŏl0.0fAől5.0fłB<br>
 * [VFtAnCVFtAs[LOtB^[̏ꍇ͐M̍ۂɍŏl 1/65536.0fɐ܂B
 */
#define CRIATOMEXASR_MULTIBANDS_EQ_PARAMETER_GAIN(band_index)			\
	(CRIATOMEXASR_MULTIBANDS_EQ_NUM_PARAMETER_PAR_BAND * (band_index) + 3)	

/*JP
 * \brief 3ohCRCUE32ohCRCȖSp[^[AohwɂvZ܂B
 * \ingroup CRIATOMASR_DSP_PARAM_MULTIBANDS_EQ
 * \param[in] num_bands	oh
 */
#define CRIATOMEXASR_MULTIBANDS_EQ_NUM_PARAMETERS(num_bands)			\
	((num_bands) * CRIATOMEXASR_MULTIBANDS_EQ_NUM_PARAMETER_PAR_BAND)

/*JP
 * \brief x[ms]
 * \ingroup CRIATOMASR_DSP_PARAM_DELAY
 * \param[in] i_tap	ݒΏۂ̃^bṽCfbNX
 * \par :
 * {p[^[CfbNXɃ}`^bvfBC̊e^bv̒xԂw肵܂B<br>
 * p[^[̏l͍őfBCԂ̔̒lAől10000.0fAŏl4̃^bv1,2,3,4ꂼ20.0fA40.0fA60.0fA80.0fɐ܂B
 */
#define CRIATOMEXASR_MULTITAP_DELAY_PARAMETER_DELAY_TIME_MS(i_tap)		\
	(0 + (i_tap) * CRIATOMEXASR_MULTITAP_DELAY_NUM_PARAMETER_PAR_TAP)

/*JP
 * \brief o̓x[U]
 * \ingroup CRIATOMASR_DSP_PARAM_DELAY
 * \param[in] i_tap	ݒΏۂ̃^bṽCfbNX
 * \par :
 * {p[^[CfbNXɃ}`^bvfBC̊e^bv̏o̓xw肵܂B<br>
 * p[^[̏l0.0fAŏl0.0fAől1.0fłB
 */
#define CRIATOMEXASR_MULTITAP_DELAY_PARAMETER_LEVEL(i_tap)				\
	(1 + (i_tap) * CRIATOMEXASR_MULTITAP_DELAY_NUM_PARAMETER_PAR_TAP)

/*JP
 * \brief ipjpx[]
 * \ingroup CRIATOMASR_DSP_PARAM_DELAY
 * \param[in] i_tap	ݒΏۂ̃^bṽCfbNX
 * \par :
 * {p[^[CfbNXɃ}`^bvfBC̊e^bv̐̊pxw肵܂B<br>
 * ̊pxw肷邱ƂŁAɍLx\ł܂B<br>
 * p[^[̏l0.0fAŏl-180.0fAől180.fłB
 */
#define CRIATOMEXASR_MULTITAP_DELAY_PARAMETER_AZIMUTH(i_tap)			\
	(2 + (i_tap) * CRIATOMEXASR_MULTITAP_DELAY_NUM_PARAMETER_PAR_TAP)

/*JP
 * \brief tB[hobNQC
 * \ingroup CRIATOMASR_DSP_PARAM_DELAY
 * \param[in] i_tap	ݒΏۂ̃^bṽCfbNX
 * \par :
 * {p[^[CfbNXɃ}`^bvfBC̃tB[hobNQCw肵܂B
 * \attention tB[hobNQC傫Əo͂U܂B<br>
 * p[^[̏l0.0fAŏl0.0fAől͊e^bv1.0fłAS^bv̑a0.90fɂȂ悤ɐ܂B
 */
#define CRIATOMEXASR_MULTITAP_DELAY_PARAMETER_FEEDBACK(i_tap)			\
	(3 + (i_tap) * CRIATOMEXASR_MULTITAP_DELAY_NUM_PARAMETER_PAR_TAP)

/***************************************************************************
 *      f[^^錾
 *      Data Type Declarations
 ***************************************************************************/
/*==========================================================================
 *      CRI AtomEx ASR API
 *=========================================================================*/
/*JP
 * \brief ASRpRtBO\
 * \ingroup ATOMEXLIB_ASR
 * ASRiAtom Sound Rendererj̓dlw肷邽߂̍\̂łB<br>
 * ::criAtomExAsr_Initialize ֐̈Ɏw肵܂B<br>
 * \par l:
 * ftHgݒgpꍇA ::criAtomExAsr_SetDefaultConfig }N
 * \̂ɃftHgp[^[ZbgA ::criAtomExAsr_Initialize ֐
 * ɍ\̂w肵ĂB<br>
 * \attention
 * IɃo\邽߁A ::criAtomExAsr_SetDefaultConfig 
 * }NgpȂꍇɂ́AgpOɕK\̂[NAĂB<br>
 * i\̂̃oɕslȂ悤ӂBj
 * \sa criAtomExAsr_Initialize, criAtomExAsr_SetDefaultConfig
 */
typedef struct CriAtomExAsrConfigTag {
	/*JP
		\brief T[o[̎spx
		\par :
		T[o[spxw肵܂B<br>
		\attention
		AtomCuɎw肵li ::CriAtomExConfig \̂
		server_frequency jƁAlZbgKv܂B<br>
		\sa CriAtomConfig
	*/
	CriFloat32 server_frequency;

	/*JP
		\brief oX
		\par :
		ASR쐬oX̐w肵܂B<br>
		oX̓TEh̃~bNXAGtFNg̊Ǘs܂B<br>
		}X^[oẌ̗1܂߂邽߁AK1ȏ̒lݒ肵ĉB<br>
	*/
	CriSint32 num_buses;

	/*JP
		\brief o̓`l
		\par :
		ASȐo̓`lw肵܂B<br>
		p3D3D|WVjO@\gpꍇ6chȏw肵܂B<br>
	*/
	CriSint32 output_channels;

	/*JP
		\brief ~LT[̃Xs[J[}bsO
		\par :
		ASRbÑXs[J[}bsOw肵܂B<br>
	*/
	CriAtomSpeakerMapping speaker_mapping;
	
	/*JP
		\brief o̓TvO[g
		\par :
		o͂яߒ̃TvO[gw肵܂B<br>
		ʏA^[Qbg@̃TEhfoCX̃TvO[gw肵܂B<br>
		\par l:
		ႭƏׂ邱Ƃł܂܂B<br>
	*/
	CriSint32 output_sampling_rate;
	
	/*JP
		\brief TEh_^Cv
		\par :
		ASȐo͐TEh_̎ʂw肵܂B<br>
		sound_renderer_type  CRIATOM_SOUND_RENDERER_NATIVE w肵ꍇA
		f[^̓ftHgݒ̊evbgtH[̃TEho͂ɓ]܂B<br>
		\attention
		CRIATOM_SOUND_RENDERER_ASRCRIATOM_SOUND_RENDERER_DEFAULT͎w肵ȂłB
	*/
	CriAtomSoundRendererType sound_renderer_type;

	/*JP
		\brief vbgtH[ŗL̃p[^[ւ̃|C^
		\par :
		vbgtH[ŗL̃p[^[ւ̃|C^w肵܂B
		NULLw肵ꍇAvbgtH[̃ftHgp[^[ASRbN쐬܂B<br>
		p[^[\̂͊evbgtH[ŗLwb_[ɒ`Ă܂B
		p[^[\̂`ĂȂvbgtH[ł́ANULLw肵ĂB
	*/
	void *context;
	
	/*JP
		\brief ASRbN̍ő吔
		\par :
		쐬\ASRbN̍őłB<br>
	*/
	CriSint32 max_racks;

	/*JP
		\brief Ambisonics̃I[_[^Cvip~j
		\par :
		̃o[ϐ͍폜\łAgpȂłB<br>
		AmbisonicsĐ邽߂ɂ CRIATOM_SOUND_RENDERER_AMBISONICS gp܂B<br>
		ڂ̓}jAQƂĂB
	 */
	CriAtomAmbisonicsOrderType ambisonics_order_type;
} CriAtomExAsrConfig;

/*JP
 * \brief x@\A^b`pRtBO\
 * \ingroup ATOMEXLIB_ASR
 * x@\oXɃA^b`邽߂̍\̂łB<br>
 * ::criAtomExAsr_AttachBusAnalyzerByName ֐̈Ɏw肵܂B<br>
 * \par l:
 * ftHgݒgpꍇA ::criAtomExAsr_SetDefaultConfigForBusAnalyzer }N
 * \̂ɃftHgp[^[ZbgA ::criAtomExAsr_AttachBusAnalyzerByName ֐
 * ɍ\̂w肵ĂB<br>
 * \attention
 * IɃo\邽߁A ::criAtomExAsr_SetDefaultConfigForBusAnalyzer
 * }NgpȂꍇɂ́AgpOɕK\̂[NAĂB<br>
 * i\̂̃oɕslȂ悤ӂBj
 * \sa criAtomExAsr_AttachBusAnalyzerByName
 */
typedef struct {
	/*JP
		\brief Ԋui~bPʁj
		\par :
		茋ʂXVԊułB<br>
	*/
	CriSint32 interval;

	/*JP
		\brief s[Nz[hԁi~bPʁj
		\par :
		s[Nl傫lōXVꂽƂAȂ悤Ƀz[h鎞ԂłB<br>
	*/
	CriSint32 peak_hold_time;
} CriAtomExAsrBusAnalyzerConfig;

/*JP
 * \brief x
 * \par :
 * oX̃x擾邽߂̍\̂łB<br>
 * ::criAtomExAsr_GetBusAnalyzerInfo ֐ŗp܂B
 * \par l:
 * exl͉f[^̐Uɑ΂{łiPʂ̓fVxł͂܂jB<br>
 * ȉ̃R[hŃfVx\Lɕϊ邱Ƃł܂B<br>
 * dB = 10.0f * log10f(level);
 * \sa criAtomExAsr_GetBusAnalyzerInfo
 */
typedef struct CriAtomExAsrBusAnalyzerInfoTag {
	/*JP
		\brief L`l
		\par :
		茋ʂLȃ`lłB<br>
	*/
	CriSint32 num_channels;
	
	/*JP
		\brief RMSx
		\par :
		ԊuԂ̉URMSi敽ϕjvZlłB<br>
		xƂĈ܂B
	*/
	CriFloat32 rms_levels[CRIATOMEXASR_MAX_CHANNELS];
	
	/*JP
		\brief s[Nx
		\par :
		ԊuԂ̉U̍őlłB<br>
	*/
	CriFloat32 peak_levels[CRIATOMEXASR_MAX_CHANNELS];
	
	/*JP
		\brief s[Nz[hx
		\par :
		z[hĂs[NxlłB<br>
	*/
	CriFloat32 peak_hold_levels[CRIATOMEXASR_MAX_CHANNELS];
} CriAtomExAsrBusAnalyzerInfo;

/*JP
 * \brief p\
 * \ingroup ATOMEXLIB_ASR
 * \par :
 * oXɂp܂Ƃ߂\̂łB<br>
 * oX̃p̐ݒ擾Ɏgp܂B
 * \sa criAtomExAsr_SetBusPanInfoByName, criAtomExAsr_GetBusPanInfoByName, criAtomExAsrRack_SetBusPanInfoByName, criAtomExAsrRack_GetBusPanInfoByName
 */
typedef struct CriAtomExAsrBusPanInfoTag {
	/*JP
		\brief 
		\par :
		pɂ鉹ʂłB<br>
		0.0f ` 1.0f͈̔͂ŐݒE擾܂B<br>
		܂Aʏ̉ʂƊ|킳܂B
	*/
	CriFloat32 volume;
	/*JP
		\brief px
		\par :
		pɂpxłB<br>
		0.0f 𐳖ʂƂ -180.0f ` 180.0f͈̔͂ŐݒE擾܂B
	*/
	CriFloat32 angle;
	/*JP
		\brief CeA
		\par :
		pɂCeAłB<br>
		0.0f ` 1.0f͈̔͂ŐݒE擾܂B
	*/
	CriFloat32 distance;
	/*JP
		\brief }``l̍L
		\par :
		}``l̊pxɑ΂{łB<br>
		0.0f ` 1.0f͈̔͂ŐݒE擾܂B
	*/
	CriFloat32 wideness;
	/*JP
		\brief Xvbh
		\par :
		pɂXvbhłB<br>
		0.0f ` 1.0f͈̔͂ŐݒE擾܂B
	*/
	CriFloat32 spread;
} CriAtomExAsrBusPanInfo;

/*JP
 * \brief g`tB^[R[obN֐
 * \ingroup ATOMEXLIB_PLAYER
 * \par :
 * \param[in]		obj				[UwIuWFNg
 * \param[in]		format			PCM̌`
 * \param[in]		num_channels	`l
 * \param[in]		num_samples		Tv
 * \param[in,out]	data			PCMf[^̃`lz
 * \return							Ȃ
 * \par :
 * oXɓo^邱Ƃł PCM f[^󂯎R[obN֐łB<br>
 * <br>
 * R[obN֐̓o^ɂ ::criAtomExAsr_SetBusFilterCallback ֐gp܂B<br>
 * R[obN֐o^ƁATEh_sxɁA
 * R[obN֐s悤ɂȂ܂B<br>
 * <br>
 * tB^[R[obN֐ɂ́A PCM f[^̃tH[}bg`lA
 * QƉ\ȃTvA PCM f[^i[̈̃AhXԂ܂B<br>
 * R[obNł PCM f[^̒l𒼐ڎQƉ\ɂȂ̂ŁA
 * Đ̉̐U`FbNƂprɗp\łB<br>
 * <br>
 * ܂AR[obN֐ PCM f[^HƁAĐɔf邽߁A
 * PCM f[^ɑ΂ă[UƎ̃GtFNg邱Ƃ\łB<br>
 * iA^CXgb`̂悤ȃf[^ʂHsƂ͂ł܂Bj<br>
 * \par l:
 * PCM f[^̓`lPʂŕĂ܂B<br>
 * iC^[[uĂ܂Bj<br>
 * Tv32̔{ŁA32A256ƂȂ܂B<br>
 * ܂ATv̓vbgtH[foCX̏o͂̐iɉĕω܂B<br>
 *  6 i data zjɂ́Ae`l PCM f[^z̐擪AhXi[Ă܂B<br>
 * i񎟌z̐擪AhXł͂ȂA`lƂ PCM f[^z̐擪AhXi[
 * ꎟ̃|C^złBj<br>
 * i[Ă PCM f[^̓oXɐݒ肳ĂGtFNg̏̉łB<br>
 * <br>
 * vbgtH[ɂāA PCM f[^̃tH[}bg͈قȂ܂B<br>
 * s̃f[^tH[}bgɂẮA 3 i format jŔʉ\łB<br>
 * PCM f[^̃tH[}bg 16 bit ^̏ꍇA format  CRIATOM_PCM_FORMAT_SINT16 ƂȂA
 * PCM f[^̃tH[}bg 32 bit _^̏ꍇA format  CRIATOM_PCM_FORMAT_FLOAT32 ƂȂ܂B<br>
 * ꂼ̃P[X PCM f[^̒l͈قȂ܂̂łӂB<br>
 * - CRIATOM_PCM_FORMAT_SINT16  -32768 ` +32767
 * - CRIATOM_PCM_FORMAT_FLOAT32  -1.0f ` +1.0f
 * 
 * id̃~LVOOĩGtFNgɂĂ͏L͈͂𒴂lo\܂Bj<br>
 * \attention
 * <br>
 * {R[obN֐ŁAAtomCuAPIsȂłB<br>
 * R[obN֐AtomCũT[o[s܂B<br>
 * ̂߁AT[o[ւ̊荞݂lȂAPIsꍇA
 * G[AfbhbN\܂B<br>
 * <br>
 * R[obN֐ŒԏubNƁA؂ꓙ̖肪\܂B<br>
 * \sa criAtomExAsr_SetBusFilterCallback
 */
typedef void (*CriAtomExAsrBusFilterCbFunc)(void *obj, CriAtomPcmFormat format,
	CriSint32 num_channels, CriSint32 num_samples, void *data[]);

/*JP
 * \brief GtFNgC^[tF[X\̂̕sS^
 * \par :
 * GtFNgC^[tF[Xo^֐̈^łB
 * \sa criAtomExAsr_RegisterEffectInterface, criAtomExAsr_UnregisterEffectInterface
 */
typedef const struct CriAfxInterfaceWithVersionTag* CriAtomExAsrAfxInterfaceWithVersionPtr;

/*JP
 * \brief IRo[uGtFNg̕׌v\
 * \ingroup ATOMEXLIB_ASR
 * \par :
 * IRo[u̕׌vœ܂Ƃ߂\̂łB
 * IRo[u͈Tv1ubNƂĔ񓯊ŏAubNPʂŕׂv܂B
 * \attention
 * vbgtH[ɂČveقȂꍇ܂B<br>
 * ڂ͊evbgtH[CRI ADX }jA IR o[uQƂĂB
 * \sa criAtomExAsr_GetIrReverbPerformanceInfo
 */
typedef struct CriAtomExAsrIrReverbPerformanceInfoTag {
	/*JP
		\brief ubNTCY
		\par :
		CraftŐݒ\IRo[u1ubÑTvłB
		\par l:
		IRo[ũubNTCY512,1024݂̂T|[g܂B<br>
		oXIRo[uGtFNg݂ȂꍇA0Ԃ܂B
    */
	CriUint32 blocksize;
	
	/*JP
		\brief TvO[g
		\par :
		IRo[uTvO[głB
		\par l:
		݌IRo[ũTvO[g48000Hẑ݂T|[g܂B<br>
		oXIRo[uGtFNg݂ȂꍇA0Ԃ܂B
    */
	CriUint32 sampling_rate;
	
	/*JP
		\brief 
		\par :
		IRo[u1ubN̏񐔂łB
    */
	CriUint32 process_count;

	/*JP
		\brief ŐVԁi}CNbj
		\par :
		IRo[u̍ŐV1ubN̏ɂԂłB
	*/
	CriUint32 last_process_time;

	/*JP
		\brief ő又ԁi}CNbj
		\par :
		IRo[ǔvZbg擾_܂łōł1ubN̏ԂłB
	*/
	CriUint32 max_process_time;

	/*JP
		\brief Ϗԁi}CNbj
		\par :
		IRo[ǔvZbg擾_܂ł1ubN̕ϏԂłB
	*/
	CriUint32 average_process_time;

	/*JP
		\brief ŐVC^[oi}CNbj
		\par :
		IRo[u̍ŐV1ubN̏ԊułB
	*/
	CriUint32 last_process_interval;

	/*JP
		\brief ő又C^[oi}CNbj
		\par :
		IRo[ǔvZbg擾_܂łōł1ubN̏C^[ołB
	*/
	CriUint32 max_process_interval;

	/*JP
		\brief ϏC^[oi}CNbj
		\par :
		IRo[ǔvZbg擾_܂ł1ubN̕ϏC^[ołB
	*/
	CriUint32 average_process_interval;

} CriAtomExAsrIrReverbPerformanceInfo;

/*==========================================================================
 *      CRI AtomEx ASR Rack API
 *=========================================================================*/

/*JP
 * \brief ASRbNID
 * \ingroup ATOMEXLIB_ASR
 * \par :
 * ASRbNǗpID^łB<br>
 * ::criAtomExAsrRack_Create ֐ASRbN쐬Ǝ擾ł܂B<br>
 * \sa criAtomExAsrRack_Create, criAtomExAsrRack_AttachDspBusSetting
 */
typedef CriSint32 CriAtomExAsrRackId;

/*JP
 * \brief ASRbN쐬pRtBO\
 * \ingroup ATOMEXLIB_ASR
 * ASRiAtom Sound Rendererj̓dlw肷邽߂̍\̂łB<br>
 * ::criAtomExAsrRack_Create ֐̈Ɏw肵܂B<br>
 * \par l:
 * ftHgݒgpꍇA ::criAtomExAsrRack_SetDefaultConfig }N
 * \̂ɃftHgp[^[ZbgA ::criAtomExAsrRack_Create ֐
 * ɍ\̂w肵ĂB<br>
 * \attention
 * IɃo\邽߁A ::criAtomExAsrRack_SetDefaultConfig 
 * }NgpȂꍇɂ́AgpOɕK\̂[NAĂB<br>
 * i\̂̃oɕslȂ悤ӂBj
 * \sa criAtomExAsrRack_Create, criAtomExAsrRack_SetDefaultConfig
 */
typedef struct CriAtomExAsrRackConfigTag {
	/*JP
		\brief T[o[̎spx
		\par :
		T[o[spxw肵܂B<br>
		\attention
		AtomCuɎw肵li ::CriAtomExConfig \̂
		server_frequency jƁAlZbgKv܂B<br>
		\sa CriAtomConfig
	*/
	CriFloat32 server_frequency;
	
	/*JP
		\brief oX
		\par :
		ASR쐬oX̐w肵܂B<br>
		oX̓TEh̃~bNXAGtFNg̊Ǘs܂B<br>
	*/
	CriSint32 num_buses;

	/*JP
		\brief o̓`l
		\par :
		ASRbN̏o̓`lw肵܂B<br>
		p3D3D|WVjO@\gpꍇ6chȏw肵܂B<br>
	*/
	CriSint32 output_channels;

	/*JP
		\brief ~LT[̃Xs[J[}bsO
		\par :
		ASRbÑXs[J[}bsOw肵܂B<br>
	*/
	CriAtomSpeakerMapping speaker_mapping;
	
	/*JP
		\brief o̓TvO[g
		\par :
		ASRbN̏o͂яߒ̃TvO[gw肵܂B<br>
		ʏA^[Qbg@̃TEhfoCX̃TvO[gw肵܂B<br>
		\par l:
		ႭƏׂ邱Ƃł܂܂B<br>
	*/
	CriSint32 output_sampling_rate;
	
	/*JP
		\brief TEh_^Cv
		\par :
		ASRbN̏o͐TEh_̎ʂw肵܂B<br>
		sound_renderer_type  CRIATOM_SOUND_RENDERER_NATIVE w肵ꍇA
		f[^̓ftHgݒ̊evbgtH[̃TEho͂ɓ]܂B<br>
	*/
	CriAtomSoundRendererType sound_renderer_type;

	/*JP
		\brief o͐ASRbNID
		\par :
		ASRbN̏o͐ASRbNIDw肵܂B<br>
		sound_renderer_type  CRIATOM_SOUND_RENDERER_ASR w肵ꍇ̂ݗLłB<br>
	*/
	CriAtomExAsrRackId output_rack_id;

	/*JP
		\brief vbgtH[ŗL̃p[^[ւ̃|C^
		\par :
		vbgtH[ŗL̃p[^[ւ̃|C^w肵܂B
		NULLw肵ꍇAvbgtH[̃ftHgp[^[ASRbN쐬܂B<br>
		p[^[\̂͊evbgtH[ŗLwb_[ɒ`Ă܂B
		p[^[\̂`ĂȂvbgtH[ł́ANULLw肵ĂB
	*/
	void *context;
} CriAtomExAsrRackConfig;

/*JP
 * \brief ptH[}X
 * \ingroup ATOMEXLIB_ASR
 * \par :
 * ptH[}X擾邽߂̍\̂łB<br>
 * ::criAtomExAsrRack_GetPerformanceInfo ֐ŗp܂B
 * \sa criAtomExAsrRack_GetPerformanceInfo
 */
typedef struct CriAtomExAsrRackPerformanceInfoTag {
	CriUint32 process_count;			/*JP<M							*/
	CriUint32 last_process_time;		/*JP<Ԃ̍ŏIvli}CNbPʁj		*/
	CriUint32 max_process_time;			/*JP<Ԃ̍őli}CNbPʁj			*/
	CriUint32 average_process_time;		/*JP<Ԃ̕ϒli}CNbPʁj			*/
	CriUint32 last_process_interval;	/*JP<Ԋu̍ŏIvli}CNbPʁj		*/
	CriUint32 max_process_interval;		/*JP<Ԋu̍őli}CNbPʁj			*/
	CriUint32 average_process_interval;	/*JP<Ԋu̕ϒli}CNbPʁj			*/
	CriUint32 last_process_samples;		/*JP<PʏŐꂽTv̍ŏIvl	*/
	CriUint32 max_process_samples;		/*JP<PʏŐꂽTv̍ől		*/
	CriUint32 average_process_samples;	/*JP<PʏŐꂽTv̕ϒl		*/
} CriAtomExAsrRackPerformanceInfo;

/*==========================================================================
 *      CRI Atom ASR API
 *=========================================================================*/
/*JP
 * \brief ASRpRtBO\
 * \ingroup ATOMLIB_ASR
 * ASRiAtom Sound Rendererj̓dlw肷邽߂̍\̂łB<br>
 * ::criAtomAsr_Initialize ֐̈Ɏw肵܂B<br>
 * \par l:
 * ftHgݒgpꍇA ::criAtomAsr_SetDefaultConfig }N
 * \̂ɃftHgp[^[ZbgA ::criAtomAsr_Initialize ֐
 * ɍ\̂w肵ĂB<br>
 * \attention
 * IɃo\邽߁A ::criAtomAsr_SetDefaultConfig 
 * }NgpȂꍇɂ́AgpOɕK\̂[NAĂB<br>
 * i\̂̃oɕslȂ悤ӂBj
 * \sa criAtomAsr_Initialize, criAtomAsr_SetDefaultConfig
 */
typedef struct CriAtomAsrConfigTag {
	/*JP
		\brief T[o[̎spx
		\par :
		T[o[spxw肵܂B<br>
		\attention
		AtomCuɎw肵li ::CriAtomConfig \̂
		server_frequency jƁAlZbgKv܂B<br>
		\sa CriAtomConfig
	*/
	CriFloat32 server_frequency;
	
	/*JP
		\brief oX
		\par :
		ASR쐬oX̐w肵܂B<br>
		oX̓TEh̃~bNXAGtFNg̊Ǘs܂B<br>
	*/
	CriSint32 num_buses;

	/*JP
		\brief o̓`l
		\par :
		ASȐo̓`lw肵܂B<br>
		p3D3D|WVjO@\gpꍇ6chȏw肵܂B<br>
	*/
	CriSint32 output_channels;
	
	/*JP
		\brief ~LT[̃Xs[J[}bsO
		\par :
		ASRbÑXs[J[}bsOw肵܂B<br>
	*/
	CriAtomSpeakerMapping speaker_mapping;
	
	/*JP
		\brief o̓TvO[g
		\par :
		o͂яߒ̃TvO[gw肵܂B<br>
		ʏA^[Qbg@̃TEhfoCX̃TvO[gw肵܂B<br>
		\par l:
		ႭƏׂ邱Ƃł܂Ȃ܂B<br>
	*/
	CriSint32 output_sampling_rate;
	
	/*JP
		\brief TEh_^Cv
		\par :
		ASȐo͐TEh_̎ʂw肵܂B<br>
		sound_renderer_type  CRIATOM_SOUND_RENDERER_NATIVE w肵ꍇA
		f[^̓ftHgݒ̊evbgtH[̃TEho͂ɓ]܂B<br>
		\attention
		CRIATOM_SOUND_RENDERER_ASRCRIATOM_SOUND_RENDERER_DEFAULT͎w肵ȂłB
	*/
	CriAtomSoundRendererType sound_renderer_type;
	
	/*JP
		\brief vbgtH[ŗL̃p[^[ւ̃|C^
		\par :
		vbgtH[ŗL̃p[^[ւ̃|C^w肵܂B
		NULLw肵ꍇAvbgtH[̃ftHgp[^[ASRbN쐬܂B<br>
		p[^[\̂͊evbgtH[ŗLwb_[ɒ`Ă܂B
		p[^[\̂`ĂȂvbgtH[ł́ANULLw肵ĂB
	*/
	void *context;

	/*JP
		\brief ASRbN̍ő吔
		\par :
		쐬\ASRbN̍őłB<br>
	*/
	CriSint32 max_racks;

	/*JP
		\brief Ambisonics̃I[_[^Cv
		\par :
		AtomCuAmbisonics̍ĐsہAǂ̃I[_[^Cvgp邩ݒ肵܂B<br>
		\par l:
		Ambisonics̍ĐɔΉ̃vbgtH[ł́A̒l͖܂B<br>
		܂A ::CRIATOMAMBISONICS_ORDER_TYPE_NONE w肵ꍇAAmbisonics̍Đs܂B<br>
	 */
	CriAtomAmbisonicsOrderType ambisonics_order_type;
} CriAtomAsrConfig;

/*==========================================================================
*      CRI AtomEx API
*=========================================================================*/
/*JP
* \brief AtomCupRtBO\
* \ingroup ATOMLIB_PC
* CRI AtomCu̓dlw肷邽߂̍\̂łB<br>
* ::criAtomEx_InitializeForUserPcmOutput ֐̈Ɏw肵܂B<br>
* \sa criAtomEx_InitializeForUserPcmOutput, criAtomEx_SetDefaultConfigForUserPcmOutput
*/
typedef struct CriAtomExConfigForUserPcmOutputTag {
	CriAtomExConfig			atom_ex;	/*JP< AtomExpRtBO\	*/
	CriAtomExAsrConfig		asr;		/*JP< ASRpRtBO			*/
	CriAtomExHcaMxConfig	hca_mx;		/*JP< HCA-MXpRtBO\	*/
} CriAtomExConfigForUserPcmOutput;

/*==========================================================================
 *      CRI Atom Player API
 *=========================================================================*/
 /*JP
  * v[[쐬pRtBO\
  * \ingroup ATOMEXLIB_ASR
  * \par :
  * v[[쐬ۂɁAdlw肷邽߂̍\̂łB<br>
  * eR[fbN CriAtomXXXPlayerConfig  context Ɏw肵܂B<br>
  *  XXX ̓R[fbN
  * \attention
  * {\̂ ::CRIATOM_SOUND_RENDERER_ASR gpꍇ̂ݎQƂ܂B<br>
  * <br>
  * IɃo\邽߁A
  * ::criAtomPlayer_SetDefaultConfig_ASR }NŕK\̂ĂB<br>
  * i\̂̃oɕslȂ悤ӂBj
  */
typedef struct {
	CriSint32 max_routes;				/*JP< Zh\oX */
} CriAtomPlayerConfig_ASR;

/***************************************************************************
 *      ϐ錾
 *      Prototype Variables
 ***************************************************************************/

/***************************************************************************
 *      ֐錾
 *      Prototype Functions
 ***************************************************************************/
#ifdef __cplusplus
extern "C" {
#endif
/*==========================================================================
 *      CRI AtomEx ASR API
 *=========================================================================*/
/*JP
 * \brief ASRp[N̈TCY̌vZ
 * \ingroup ATOMEXLIB_ASR
 * \param[in]	config	ASRpRtBO\
 * \par :
 * ASRiAtom Sound Rendererj̏ɕKvȃ[N̈̃TCY擾܂B<br>
 * ::criAtomEx_SetUserAllocator }NɂAP[^[o^s킸
 * ::criAtomExAsr_Initialize ֐ASȐsꍇA
 * {֐ŌvZTCỸ[N̈ƂēnKv܂B<br>
 * <br>
 * [N̈TCY̌vZɎsƁA{֐ -1 Ԃ܂B<br>
 * [N̈TCY̌vZɎsRɂẮAG[R[obÑbZ[WŊmF\łB<br>
 * \par l:
 * ASȐɕKvȃ[ÑTCÝAASRpRtBO
 * \́i ::CriAtomExAsrConfig j̓eɂĕω܂B<br>
 * <br>
 * NULLw肵ꍇAftHgݒ
 * i ::criAtomExAsr_SetDefaultConfig KpƓp[^[j
 * [N̈TCYvZ܂B
 * <br>
 *  config ̏́A֐ł̂ݎQƂ܂B<br>
 * ֐𔲂͎QƂ܂̂ŁA֐s config ̗̈Ă
 * 肠܂B
 * \sa criAtomEx_SetUserAllocator, criAtomExAsr_Initialize
 */
CriSint32 CRIAPI criAtomExAsr_CalculateWorkSize(const CriAtomExAsrConfig *config);

/*JP
 * \brief [N̈TCYvZpRtBO\̂̐ݒ
 * \ingroup ATOMEXLIB_ASR
 * \param[in]	config	ASRpRtBO\
 * \par :
 * [N̈TCY̌vZpɁAASRpRtBO\
 * i ::CriAtomExAsrConfig \́jo^܂B<br>
 * <br>
 * GtFNg̃A^b`ɕKvȃ[N̈̃TCÝA
 * ASRi ::criAtomExAsr_Initialize ֐sj
 * ɐݒ肷\̂̃p[^[ɂĕω܂B<br>
 * ̂߁Aʏ̓GtFNg̃A^b`ɕKvȃ[N̈TCYvZOɁA
 * ASRKv܂B<br>
 * {֐gpASRpRtBO\̂o^ꍇA
 * GtFNg̃A^b`ɕKvȃ[N̈̃TCYA
 * ȂɌvZ\ɂȂ܂B<br>
 * i ::criAtomEx_CalculateWorkSizeForDspBusSettingFromAcfData
 * ֐s\ƂȂ܂Bj<br>
 * \par l:
 * i config j NULL w肵ꍇAftHgݒ
 * i ::criAtomExAsr_SetDefaultConfig KpƓp[^[j
 * [N̈TCYvZ܂B<br>
 * <br>
 * A{֐ňURtBO\̂ݒ肷ƁA
 * ݒȌԁiԂł̃[N̈TCYvZG[Ƃ铮j
 * ɖ߂ƂłȂȂ܂B<br>
 * i֐ēxsăp[^[㏑邱Ƃ͉\łBj<br>
 * \attention
 * {֐œo^pRtBO\̂́A
 * ASRԂł̃[N̈TCYvZɂgp܂B<br>
 * ASRɂ͖{֐ɐݒ肵p[^[ł͂ȂA
 * Ɏw肳ꂽp[^[[N̈TCY̌vZɎgp܂B<br>
 * i{֐œo^\̂̃p[^[ƁA
 * ASȐɎgp\̂̃p[^[قȂꍇA
 * [N̈TCYsAnh̍쐬Ɏs鋰ꂪ܂Bj<br>
 * <br>
 * {֐sꍇłA ::criAtomEx_CalculateWorkSizeForDspBusSetting 
 * ֐͎gpł܂B<br>
 * DSPoXݒA^b`p[N̈TCY̌vZɂ́A
 * ::criAtomEx_CalculateWorkSizeForDspBusSettingFromAcfData 
 * ֐gpĂBj<br>
 * \par :
 * \code
 * 	CriAtomExAsrConfig asr_config;
 * 	
 * 	// [N̈vZpASRݒo^
 * 	criAtomExAsr_SetDefaultConfig(&asr_config);
 * 	criAtomExAsr_SetConfigForWorkSizeCalculation(&asr_config);
 * 	
 * 	// DSPoXݒA^b`p[N̈TCY̌vZ
 * 	dsp_work_size = criAtomEx_CalculateWorkSizeForDspBusSettingFromAcfData(
 * 		acf_data, acf_data_size, "DspBusSetting_0");
 * 		F
 * \endcode
 * \sa criAtomEx_CalculateWorkSizeForDspBusSettingFromAcfData
 */
void CRIAPI criAtomExAsr_SetConfigForWorkSizeCalculation(const CriAtomExAsrConfig *config);

/*JP
 * \brief ASȐ
 * \ingroup ATOMEXLIB_ASR
 * \param[in]	config		ASRpRtBO\
 * \param[in]	work		[N̈
 * \param[in]	work_size	[N̈TCY
 * \par :
 * ASRiAtom Sound Rendererj̏s܂B<br>
 * {֐s邱ƂASRNASRbN1ǉA_Oʂ̏o͂Jn܂B<br>
 * \par l:
 * ASȐɕKvȃ[ÑTCÝAASRpRtBO
 * \́i ::CriAtomExAsrConfig j̓eɂĕω܂B<br>
 * <br>
 * NULLw肵ꍇAftHgݒ<br>
 * i ::criAtomExAsr_SetDefaultConfig KpƓp[^[jŏs܂B<br>
 * <br>
 *  config ̏́A֐ł̂ݎQƂ܂B<br>
 * ֐𔲂͎QƂ܂̂ŁA֐s config ̗̈Ă
 * 肠܂B<br>
 * \attention
 * {֐͊A^̊֐łB<br>
 * {֐sƁA΂炭̊AtomCũT[o[ubN܂B<br>
 * Đɖ{֐sƁAr؂ꓙ̕s\邽߁A
 * {֐̌Ăяo̓V[̐؂ւ蓙Aוϓeł^C~OōsĂB
 * <br>
 * {֐sAK΂ɂȂ ::criAtomExAsr_Finalize ֐sĂB<br>
 * ܂A ::criAtomExAsr_Finalize ֐s܂ł́A{֐ēxsȂłB<br>
 * \sa criAtomEx_SetUserAllocator, criAtomExAsr_Finalize, criAtomExAsrRack_Create
 */
void CRIAPI criAtomExAsr_Initialize(
	const CriAtomExAsrConfig *config, void *work, CriSint32 work_size);

/*JP
 * \brief ASȐI
 * \ingroup ATOMEXLIB_ASR
 * \par :
 * ASRiAtom Sound Rendererj̏Is܂B<br>
 * {֐s邱ƂŁA_Oʂ̏o͂~܂B<br>
 * ::criAtomEx_SetUserAllocator }NgpăAP[^[o^ς݂̏ꍇA
 * ASRɊmۂꂽ̈悪܂B<br>
 * iASRɃ[N̈nꍇA{֐sł
 * [N̈\łBj<br>
 * \attention
 * {֐͊A^̊֐łB<br>
 * {֐sƁA΂炭̊AtomCũT[o[ubN܂B<br>
 * Đɖ{֐sƁAr؂ꓙ̕s\邽߁A<br>
 * {֐̌Ăяo̓V[̐؂ւ蓙Aוϓeł^C~OōsĂB<br>
 * \sa criAtomEx_SetUserAllocator, criAtomExAsr_Initialize
 */
void CRIAPI criAtomExAsr_Finalize(void);

/*JP
 * \brief oX̃{[̐ݒ
 * \ingroup ATOMEXLIB_ASR
 * \param[in]	bus_name	oX
 * \param[in]	volume		{[l
 * \par :
 * oX̃{[ݒ肵܂B<br>
 * Zh^Cv|Xg{[A|Xgp̃ZhɗLłB<br>
 * <br>
 * {[lɂ́A0.0f`1.0f͈̔͂Ŏlw肵܂B<br>
 * {[l͉f[^̐Uɑ΂{łiPʂ̓fVxł͂܂jB<br>
 * Ⴆ΁A1.0fw肵ꍇA͂̂܂܂̃{[ŏo͂܂B<br>
 * 0.5fw肵ꍇAg`̐U𔼕ɂf[^Ɠʁi-6dBj
 * o͂܂B<br>
 * 0.0fw肵ꍇA̓~[g܂iɂȂ܂jB<br>
 * {[̃ftHglCRI Atom CraftŐݒ肵lłB<br>
 */
void CRIAPI criAtomExAsr_SetBusVolumeByName(const CriChar8* bus_name, CriFloat32 volume);

/*JP
 * \brief oX̃{[̎擾
 * \ingroup ATOMEXLIB_ASR
 * \param[in]	bus_name	oX
 * \param[in]	volume		{[l
 * \par :
 * oX̃{[ݒ肵܂B<br>
 * Zh^Cv|Xg{[A|Xgp̃ZhɗLłB<br>
 * <br>
 * {[l͎lœ܂B<br>
 * {[̃ftHglCRI Atom CraftŐݒ肵lłB<br>
 */
void CRIAPI criAtomExAsr_GetBusVolumeByName(const CriChar8* bus_name, CriFloat32 *volume);

/*JP
 * \brief oX̃p̐ݒ
 * \ingroup ATOMEXLIB_ASR
 * \param[in]	bus_name	oX
 * \param[in]	pan_info	p
 * \par :
 * oX̃pݒ肵܂B<br>
 * Zh^Cv|Xgp̃ZhɗLłB
 * \par l:
 * {֐̓ftHg ASR bN DSP oXݒQƂ܂B<br>
 * Cӂ ASR bN DSP oXݒQƂꍇA ::criAtomExAsrRack_SetBusPanInfoByName ֐gpĂB<br>
 * <br>
 * p̃ftHglCRI Atom CraftŐݒ肵lłB
 */
void CRIAPI criAtomExAsr_SetBusPanInfoByName(const CriChar8 *bus_name, const CriAtomExAsrBusPanInfo *pan_info);

/*JP
 * \brief oX̃p̎擾
 * \ingroup ATOMEXLIB_ASR
 * \param[in]	bus_name	oX
 * \param[out]	pan_info	p
 * \par :
 * oX̃p擾܂B
 * \par l:
 * {֐̓ftHg ASR bN DSP oXݒQƂ܂B<br>
 * Cӂ ASR bN DSP oXݒQƂꍇA ::criAtomExAsrRack_GetBusPanInfoByName ֐gpĂB
 */
void CRIAPI criAtomExAsr_GetBusPanInfoByName(const CriChar8 *bus_name, CriAtomExAsrBusPanInfo *pan_info);

/*JP
 * \brief oX̃xs̐ݒ
 * \ingroup ATOMEXLIB_ASR
 * \param[in]	bus_name		oX
 * \param[in]	input_channels	̓`l
 * \param[in]	output_channels	o̓`l
 * \param[in]	matrix			xs1ɕ\xl̔z
 * \par :
 * oX̃xsݒ肵܂B<br>
 * Zh^Cv|Xgp̃ZhɗLłB<br>
 * <br>
 * x}gbNX́Af[^̊e`l̉Aǂ̃Xs[J[
 * ǂ̒x̉ʂŏo͂邩w肷邽߂̎dg݂łB<br>
 * matrix[input_channels * output_channels]̔złB<br>
 * ̓`lch_ino̓`lch_outɃZh郌x
 * matrix[ch_in * output_channels + ch_out]ɃZbg܂B<br>
 * xs̃ftHgl͒PʍsłB<br>
 * <br>
 * xlɂ́A0.0f`1.0f͈̔͂Ŏlw肵܂B<br>
 * xl͉f[^̐Uɑ΂{łiPʂ̓fVxł͂܂jB<br>
 * Ⴆ΁A1.0fw肵ꍇA͂̂܂܂̃xŏo͂܂B<br>
 * 0.5fw肵ꍇAg`̐U𔼕ɂf[^Ɠʁi-6dBj
 * o͂܂B<br>
 * 0.0fw肵ꍇA̓~[g܂iɂȂ܂jB<br>
 */
void CRIAPI criAtomExAsr_SetBusMatrixByName(const CriChar8* bus_name, 
	CriSint32 input_channels, CriSint32 output_channels, const CriFloat32 matrix[]);

/*JP
 * \brief oX̃Zhx̐ݒ
 * \ingroup ATOMEXLIB_ASR
 * \param[in]	bus_name 		oX
 * \param[in]	sendto_bus_name Zh̃oX
 * \param[in]	level			xl
 * \par :
 * ZhoXɉf[^𑗂ۂ̃xݒ肵܂B<br>
 * <br>
 * xlɂ́A0.0f`1.0f͈̔͂Ŏlw肵܂B<br>
 * xl͉f[^̐Uɑ΂{łiPʂ̓fVxł͂܂jB<br>
 * Ⴆ΁A1.0fw肵ꍇA͂̂܂܂̃xŏo͂܂B<br>
 * 0.5fw肵ꍇAg`̐U𔼕ɂf[^Ɠʁi-6dBj
 * o͂܂B<br>
 * 0.0fw肵ꍇA̓~[g܂iɂȂ܂jB<br>
 * x̃ftHglCRI Atom CraftŐݒ肵lłB<br>
 */
void CRIAPI criAtomExAsr_SetBusSendLevelByName(
	const CriChar8* bus_name, const CriChar8* sendto_bus_name, CriFloat32 level);

/*JP
 * \brief GtFNg쎞p[^[̐ݒ
 * \ingroup ATOMEXLIB_ASR
 * \param[in]	bus_name		oX
 * \param[in]	effect_name		GtFNg
 * \param[in]	parameter_index	GtFNg쎞p[^[CfbNX
 * \param[in]	parameter_value GtFNg쎞p[^[ݒl
 * \par :
 * ftHgASRbNIDgpăGtFNg̓쎞p[^[ݒ肵܂B<br>
 * 쎞p[^[ݒ肷ۂ́A{֐ĂяoOɂ炩
 * ::criAtomEx_AttachDspBusSetting ֐ŃoX\zĂKv܂B<br>
 * ǂ̃oXɂǂ̃GtFNg݂邩́AA^b`DSPoXݒɈˑ܂B<br>
 * w肵oXɎw肵ID̃GtFNg݂ȂꍇA֐͎s܂B<br>
 * Zbgp[^[criAtomExAsr_UpdateParameter֐ĂԂ܂ŎۂɃGtFNgɔf܂B<br>
 * p[^[CfbNXƎۂ̃p[^[̑ΉɂẮAeGtFNg̃p[^[CfbNXi \ref CRIATOMASR_DSP_PARAM jQƉB
 * \sa criAtomEx_AttachDspBusSetting, criAtomExAsr_UpdateEffectParameters
 */
void CRIAPI criAtomExAsr_SetEffectParameter(
	const CriChar8* bus_name, const CriChar8* effect_name, 
	CriUint32 parameter_index, CriFloat32 parameter_value);

/*JP
 * \brief GtFNg쎞p[^[̔f
 * \ingroup ATOMEXLIB_ASR
 * \param[in]	bus_name		oX
 * \param[in]	effect_name		GtFNg
 * \par :
 * ftHgASRbNIDgpăGtFNg̓쎞p[^[𔽉f܂B<br>
 * 쎞p[^[ۂɔfɂ́AcriAtomExAsr_SetEffectParameter ̑ɂ{֐ĂяoĉB
 * \sa criAtomEx_AttachDspBusSetting, criAtomExAsr_SetEffectParameter
 */
void CRIAPI criAtomExAsr_UpdateEffectParameters(const CriChar8* bus_name, const CriChar8* effect_name);

/*JP
 * \brief GtFNg쎞p[^[̎擾
 * \ingroup ATOMEXLIB_ASR
 * \param[in]		bus_name		oX
 * \param[in]		effect_name		GtFNg
 * \param[in]		parameter_index	GtFNg쎞p[^[CfbNX
 * \return w肵p[^[CfbNX̃GtFNg쎞p[^[lԂ܂B
 * \par :
 * ftHgASRbNIDgpăGtFNg̓쎞p[^[擾܂B<br>
 * 쎞p[^[擾ۂ́A{֐ĂяoOɂ炩
 * ::criAtomEx_AttachDspBusSetting ֐ŃoX\zĂKv܂B<br>
 * ǂ̃oXɂǂ̃GtFNg݂邩́AA^b`DSPoXݒɈˑ܂Bw肵oXɎw肵ÕGtFNg݂ȂꍇA֐͎s܂B<br>
 * 쎞p[^[̏ڍׂɂẮAeGtFNg̃p[^[CfbNXi \ref CRIATOMASR_DSP_PARAM jQƉB
 * \sa criAtomEx_AttachDspBusSetting
 */
CriFloat32 CRIAPI criAtomExAsr_GetEffectParameter(
	const CriChar8* bus_name, const CriChar8* effect_name, CriUint32 parameter_index);

/*JP
 * \brief GtFNg̃oCpXݒ
 * \ingroup ATOMEXLIB_ASR
 * \param[in]	bus_name	oX
 * \param[in]	effect_name	GtFNg
 * \param[in]	bypass		oCpXݒiCRI_TRUE:oCpXs, CRI_FALSE:oCpXsȂj
 * \par :
 * GtFNg̃oCpXݒs܂B<br>
 * oCpXݒ肳ꂽGtFNg͉̍ہAX[悤ɂȂ܂B<br>
 * GtFNg̃oCpXݒۂ́A{֐ĂяoOɂ炩
 * ::criAtomEx_AttachDspBusSetting ֐ŃoX\zĂKv܂B<br>
 * ǂ̃oXɂǂ̃GtFNg݂邩́AA^b`DSPoXݒɈˑ܂Bw肵oXɎw肵ID̃GtFNg݂ȂꍇA֐͎s܂B<br>
 * \attention
 * ĐɃoCpXݒsƃmCY邱Ƃ܂B<br>
 * \sa criAtomEx_AttachDspBusSetting
 */
void CRIAPI criAtomExAsr_SetEffectBypass(
	const CriChar8* bus_name, const CriChar8* effect_name, CriBool bypass);

/*JP
 * \brief x@\̒ǉ
 * \ingroup ATOMEXLIB_ASR
 * \param[in]	bus_name	oX
 * \param[in]	config		x@\̃RtBO\
 * \par :
 * oXɃx@\ǉAx菈Jn܂B<br>
 * {֐sA ::criAtomExAsr_GetBusAnalyzerInfo ֐s邱ƂŁA
 * RMSxijAs[NxiőUjAs[Nz[hx
 * 擾邱Ƃ\łB
 * oX̃xvɂ́AoXƂɖ{֐ĂяoKv܂B
 * \par :
 * \code
 * 	// x擾p\
 * 	CriAtomExAsrBusAnalyzerInfo info;
 * 	
 * 	// 0ԃoXi}X^[oXjɃx@\̒ǉ
 * 	criAtomExAsr_AttachBusAnalyzer(0, NULL);
 * 	
 * 	@@F
 * 	
 * 	// x̎擾
 * 	criAtomExAsr_GetBusAnalyzerInfo(0, &info);
 * 	
 * 	// vʂ̕\
 *  for (i = 0; i < CRIATOMEXASR_MAX_CHANNELS; i++) {
 * 	    printf("[%d] RMS: %1.6f, Peak: %1.6f, Hold: %1.6f", 
 * 	        i, info.rms_levels[i], info.peak_levels[i], info.peak_hold_levels[i]);
 *  }
 * \endcode
 * \attention
 * {֐ ::criAtomEx_AttachDspBusSetting ֐Ɠ̃\[X𑀍삵܂B<br>
 * ̂߁A ::criAtomEx_AttachDspBusSetting ֐sƁA
 * ::criAtomExAsr_GetBusAnalyzerInfo ֐ɂ擾łȂȂ܂B<br>
 * {֐ ::criAtomEx_AttachDspBusSetting ֐𕹗pۂɂ́A
 * ::criAtomEx_AttachDspBusSetting ֐sOɈU
 * ::criAtomExAsr_DetachBusAnalyzer ֐Ńx@\𖳌A
 * ::criAtomEx_AttachDspBusSetting ֐sɍēx{֐sĂB<br>
 * \code
 * 		F
 * 	// DSPoXݒ̕ύXOɈUx@𖳌
 * 	criAtomExAsr_DetachBusAnalyzer(0);
 * 	
 * 	// DSPoXݒ̍XV
 * 	criAtomEx_AttachDspBusSetting("DspBusSetting_0", NULL, 0);
 * 	
 * 	// x@̍ăA^b`
 * 	criAtomExAsr_AttachBusAnalyzer(0, NULL);
 * 		F
 * \endcode
 * \sa criAtomExAsr_GetBusAnalyzerInfo, criAtomExAsr_DetachBusAnalyzer
 */
void CRIAPI criAtomExAsr_AttachBusAnalyzerByName(
	const CriChar8* bus_name, const CriAtomExAsrBusAnalyzerConfig* config);

/*JP
 * \brief x@\̍폜
 * \ingroup ATOMEXLIB_ASR
 * \param[in]	bus_name	oX
 * \par :
 * oX烌x@\폜܂B
 * \sa criAtomExAsr_AttachBusAnalyzerByName
 */
void CRIAPI criAtomExAsr_DetachBusAnalyzerByName(const CriChar8* bus_name);

/*JP
 * \brief x茋ʂ̎擾
 * \ingroup ATOMEXLIB_ASR
 * \param[in]	bus_name	oX
 * \param[out]	info		x茋ʂ̍\
 * \par :
 * oX烌x@\̌ʂ擾܂B
 * \sa criAtomExAsr_AttachBusAnalyzerByName
 */
void CRIAPI criAtomExAsr_GetBusAnalyzerInfoByName(
	const CriChar8* bus_name, CriAtomExAsrBusAnalyzerInfo *info);

/*JP
 * \brief g`tB^[R[obN֐̓o^
 * \ingroup ATOMEXLIB_ASR
 * \param[in]	bus_name	oX
 * \param[in]	pre_func	GtFNgÕtB^[R[obN֐
 * \param[in]	post_func	GtFNg̃tB^[R[obN֐
 * \param[in]	obj			[UwIuWFNg
 * \par :
 * oXɗĂ PCM f[^󂯎R[obN֐o^܂B<br>
 * o^ꂽR[obN֐́ATEh_s^C~OŌĂяo܂B<br>
 * GtFNgOƃGtFNg2ނ̎gpȂقNULLw肪\łB<br>
 * \attention
 * R[obN֐ŁAAtomCuAPIsȂłB<br>
 * R[obN֐AtomCũT[o[s܂B<br>
 * ̂߁AT[o[ւ̊荞݂lȂAPIsꍇA
 * G[AfbhbN\܂B<br>
 * <br>
 * g`tB^[R[obN֐ŒԏubNƁA؂ꓙ̖
 * ܂̂ŁAӂB<br>
 * \sa CriAtomExPlayerFilterCbFunc
 */
void CRIAPI criAtomExAsr_SetBusFilterCallbackByName(const CriChar8* bus_name, 
	CriAtomExAsrBusFilterCbFunc pre_func, CriAtomExAsrBusFilterCbFunc post_func, void *obj);

/*JP
 * \brief őoX擾
 * \ingroup ATOMEXLIB_ASR
 * \return						őoX
 * \par :
 * p\ȍőoX擾܂B
 * <br>
 * ftHgݒł ::CRIATOMEXASR_DEFAULT_NUM_BUSES Ԃ܂B
 * <br>
 * őoXύXɂ́ACriAtomExAsrConfig::num_buses ύX
 * ASRbN쐬ĂB
 * \sa CriAtomExAsrConfig, criAtomExAsr_Create, criAtomExAsr_SetDefaultConfig
 */
CriSint32 CRIAPI criAtomExAsr_GetNumBuses(void);

/*JP
 * \brief [U`GtFNgC^[tF[X̓o^
 * \ingroup ATOMEXLIB_ASR
 * \param[in]	afx_interface	[U`GtFNg̃o[WtC^[tF[X
 * \return						o^ɐHiCRI_TRUE:o^ɐ, CRI_FALSE:o^Ɏsj
 * \par :
 * [U`GtFNgC^[tF[XASRɓo^܂B<br>
 * [U`GtFNgC^[tF[Xo^GtFNgDSPoXݒA^b`ۂɎgpł悤ɂȂ܂B<br>
 * ȉ̏ɊYꍇ́A[U`GtFNgC^[tF[X̓o^ɎsAG[R[obNԂ܂:
 *  - ̃GtFNg[U`GtFNgC^[tF[Xɓo^Ă
 *  - AtomgpĂ郆[U`GtFNgC^[tF[XƈقȂ
 *  - [U`GtFNgC^[tF[X̓o^i ::CRIATOMEXASR_MAX_NUM_USER_EFFECT_INTERFACES jɒB
 * \attention
 * {֐CRI ADX Audio Effect Plugin SDKō쐬[U`GtFNgo^ꍇɂ̂ݎgpĉB<br>
 * [U`GtFNgC^[tF[X́A[U`GtFNg܂DSPoXݒA^b`O<br>
 * {֐ɂēo^sĉB<br>
 * ACFɃftHgDSPoXݒ肪݂ꍇAACF̓o^i ::criAtomEx_RegisterAcfFile, ::criAtomEx_RegisterAcfData ֐jɂĂDSPoXݒ肪A^b`邽߁A<br>
 * [U`GtFNgftHgDSPoXݒɊ܂܂ĂꍇACFo^OɃ[U`GtFNgC^[tF[Xo^ĉB<br>
 * xo^sC^[tF[X̃|C^́ADSPoXݒA^b`ĂԎQƂꑱ܂B<br>
 * AtomCugpɃC^[tF[X̓o^sꍇ́A ::criAtomExAsr_UnregisterEffectInterface gpĉB
 * \sa criAtomExAsr_UnregisterEffectInterface, criAtomEx_AttachDspBusSetting, criAtomEx_DetachDspBusSetting, criAtomEx_RegisterAcfFile, criAtomEx_RegisterAcfData 
 */
CriBool CRIAPI criAtomExAsr_RegisterEffectInterface(CriAtomExAsrAfxInterfaceWithVersionPtr afx_interface);

/*JP
 * \brief [U`GtFNgC^[tF[X̓o^
 * \ingroup ATOMEXLIB_ASR
 * \param[in]	afx_interface	[U`GtFNg̃o[WtC^[tF[X
 * \par :
 * GtFNgC^[tF[X̓o^܂B<br>
 * o^GtFNgDSPoXݒA^b`ۂɎgpłȂȂ܂B<br>
 * o^sĂȂGtFNgC^[tF[X̓o^邱Ƃ͂ł܂iG[R[obNԂ܂jB
 * \attention
 * {֐CRI ADX Audio Effect Plugin SDKō쐬[U`GtFNgo^ꍇɂ̂ݎgpĉB<br>
 * o^s[U`GtFNgC^[tF[XDSPoXݒ肪A^b`ĂԎQƂꑱ邽߁A<br>
 * {֐͕K ::criAtomEx_DetachDspBusSetting ̌ĂяǒɍsĉB<br>
 * AtomCȕIi::criAtomEx_Finalize ֐̌Ăяojɂ͑SẴ[U`GtFNgC^[tF[X̓o^܂B
 * \sa criAtomExAsr_RegisterEffectInterface, criAtomEx_AttachDspBusSetting, criAtomEx_DetachDspBusSetting
 */
void CRIAPI criAtomExAsr_UnregisterEffectInterface(CriAtomExAsrAfxInterfaceWithVersionPtr afx_interface);

/*JP
 * \brief IRo[uGtFNg̕׌vZbg
 * \ingroup ATOMEXLIB_ASR
 * \par :
 * ASRGtFNgIRo[u̕׌vZbg܂B
 * \par l:
 * DSPoXIRo[uGtFNgZbgĂȂĂ{֐ĂяoƂ͉\łA܂B
 * \sa criAtomExAsr_GetIrReverbPerformanceInfo
 */
void CRIAPI criAtomExAsr_ResetIrReverbPerformanceInfo(void);

/*JP
 * \brief IRo[uGtFNg̕׌v
 * \ingroup ATOMEXLIB_ASR
 * \param[out]	info	IRo[u̕׌v\
 * \par :
 * DSPoXIRo[uGtFNgׂ̕܂Ƃ߂Čv܂B<br>
 * \par l:
 * DSPoXIRo[uGtFNgZbgĂȂĂ{֐ĂяoƂ͉\łA܂B
 * \attention
 * vbgtH[ɂČveقȂꍇ܂B<br>
 * ڂ͊evbgtH[CRI ADX }jA IR o[uQƂĂB
 * \sa criAtomExAsr_ResetIrReverbPerformanceInfo
 */
void CRIAPI criAtomExAsr_GetIrReverbPerformanceInfo(CriAtomExAsrIrReverbPerformanceInfo *info);

/*==========================================================================
 *      CRI AtomEx ASR Rack API
 *=========================================================================*/
/*JP
 * \brief ASRbN쐬p[N̈TCY̌vZ
 * \ingroup ATOMEXLIB_ASR
 * \param[in]	config	ASRpRtBO\
 * \par :
 * ASRbN̍쐬ɕKvȃ[N̈̃TCY擾܂B<br>
 * ::criAtomEx_SetUserAllocator }NɂAP[^[o^s킸
 * ::criAtomExAsrRack_Create ֐ASȐsꍇA
 * {֐ŌvZTCỸ[N̈ƂēnKv܂B<br>
 * <br>
 * [N̈TCY̌vZɎsƁA{֐ -1 Ԃ܂B<br>
 * [N̈TCY̌vZɎsRɂẮAG[R[obÑbZ[WŊmF\łB<br>
 * \par l:
 * ASRbN̏ɕKvȃ[ÑTCÝAASRbNpRtBO
 * \́i ::CriAtomExAsrRackConfig j̓eɂĕω܂B<br>
 * <br>
 * NULLw肵ꍇAftHgݒ
 * i ::criAtomExAsr_SetDefaultConfig KpƓp[^[j
 * [N̈TCYvZ܂B
 * <br>
 *  config ̏́A֐ł̂ݎQƂ܂B<br>
 * ֐𔲂͎QƂ܂̂ŁA֐s config ̗̈Ă
 * 肠܂B
 * \sa criAtomEx_SetUserAllocator, criAtomExAsrRack_Create
 */
CriSint32 CRIAPI criAtomExAsrRack_CalculateWorkSize(const CriAtomExAsrRackConfig *config);

/*JP
 * \brief DSPoXݒ̃A^b`p[NTCY̌vZ
 * \ingroup ATOMEXLIB_ASR
 * \param[in]	config		ASRbN쐬pRtBO\
 * \param[in]	setting		DSPoXݒ̖O
 * \return		CriSint32	Kv[N̈TCY
 * \par :
 * DSPoXݒ肩oX\ẑɕKvȃ[N̈TCYvZ܂B<br>
 * {֐sɂ́A炩::criAtomEx_RegisterAcfConfig ֐ACF
 * o^ĂKv܂<br>
 * configɂ ::criAtomExAsrRack_Create ֐Ɏw肷̂Ɠ\̂w肵ĂB<br>
 * <br>
 * [N̈TCY̌vZɎsƁA{֐ -1 Ԃ܂B<br>
 * [N̈TCY̌vZɎsRɂẮAG[R[obÑbZ[WŊmF\łB<br>
 * \par l:
 * DSPoXݒ̃A^b`ɕKvȃ[ÑTCÝACRI Atom Craftō쐬
 * DSPoXݒ̓eɂĕω܂B<br>
 * \sa criAtomExAsrRack_AttachDspBusSetting, criAtomEx_RegisterAcfConfig
 */
CriSint32 CRIAPI criAtomExAsrRack_CalculateWorkSizeForDspBusSettingFromConfig(
	const CriAtomExAsrRackConfig *config, const CriChar8 *setting);

/*JP
 * \brief DSPoXݒ̃A^b`p[NTCY̌vZ
 * \ingroup ATOMEXLIB_ASR
 * \param[in]	acf_data		ACFf[^
 * \param[in]	acf_data_size	ACFf[^TCY
 * \param[in]	rack_config		ASRbN쐬pRtBO\
 * \param[in]	setting			DSPoXݒ̖O
 * \return		CriSint32		Kv[N̈TCY
 * \par :
 * DSPoXݒ肩oX\ẑɕKvȃ[N̈TCYvZ܂B<br>
 * ::criAtomExAsrRack_CalculateWorkSizeForDspBusSettingFromConfig ֐ƈႢA
 * Ƀ[hς݂ACFf[^gpă[NTCY̌vZ\łB<br>
 * <br>
 * [N̈TCY̌vZɎsƁA{֐ -1 Ԃ܂B<br>
 * [N̈TCY̌vZɎsRɂẮAG[R[obÑbZ[WŊmF\łB<br>
 * \par l:
 * DSPoXݒ̃A^b`ɕKvȃ[ÑTCÝACRI Atom Craftō쐬
 * DSPoXݒ̓eɂĕω܂B<br>
 * \sa criAtomExAsrRack_AttachDspBusSetting, criAtomEx_RegisterAcfConfig
 */
CriSint32 CRIAPI criAtomExAsrRack_CalculateWorkSizeForDspBusSettingFromAcfDataAndConfig(
	void *acf_data, CriSint32 acf_data_size,
	const CriAtomExAsrRackConfig *rack_config, const CriChar8 *setting);

/*JP
 * \brief ASRbN̍쐬
 * \ingroup ATOMEXLIB_ASR
 * \param[in]	config				ASRpRtBO\
 * \param[in]	work				[N̈
 * \param[in]	work_size			[N̈TCY
 * \return		CriAtomExAsrRackId 	ASRbNID
 * \par :
 * ASRbN̍쐬s܂B<br>
 * ASRbNƂ̓oX̏Ŵ̂ƂŁADSPoXݒA^b`邱Ƃł܂B<br>
 * {֐s邱ƂASRASRbNǉA_Oʂ̏o͂Jn܂B<br>
 * ̊֐ŒǉASRbN͏o͐I邱ƂłAvbgtH[lCeBu
 * TEh_AASRI邱ƂőASRbNɏo͂邱Ƃ\łB<br>
 * \par l:
 * ::criAtomExAsr_Initialize ֐sƁAftHgASRbNǉ܂B<br>
 * criAtomExAsr_*** ֐̓ftHgASRbN𑀍삷APIɂȂ܂B<br>
 * <br>
 * ASȐɕKvȃ[ÑTCÝAASRpRtBO
 * \́i ::CriAtomExAsrConfig j̓eɂĕω܂B<br>
 * <br>
 * NULLw肵ꍇAftHgݒ<br>
 * i ::criAtomExAsr_SetDefaultConfig KpƓp[^[jŏs܂B<br>
 * <br>
 *  config ̏́A֐ł̂ݎQƂ܂B<br>
 * ֐𔲂͎QƂ܂̂ŁA֐s config ̗̈Ă
 * 肠܂B<br>
 * ASRbN̐ɐꍇ́A{֐͐ASRbNIDԂ܂B
 * Ɏsꍇ -1 Ԃ܂B<br>
 * \attention
 * {֐͊A^̊֐łB<br>
 * {֐sƁA΂炭̊AtomCũT[o[ubN܂B<br>
 * Đɖ{֐sƁAr؂ꓙ̕s\邽߁A
 * {֐̌Ăяo̓V[̐؂ւ蓙Aוϓeł^C~OōsĂB
 * \sa criAtomEx_SetUserAllocator, criAtomExAsrRack_Destroy, criAtomExAsrRack_AttachDspBusSetting
 */
CriAtomExAsrRackId CRIAPI criAtomExAsrRack_Create(
	const CriAtomExAsrRackConfig *config, void *work, CriSint32 work_size);

/*JP
 * \brief ASRbN̔j
 * \ingroup ATOMEXLIB_ASR
 * \par :
 * ASRbN̔js܂B<br>
 * {֐s邱ƂŁA_Oʂ̏o͂~܂B<br>
 * ::criAtomEx_SetUserAllocator }NgpăAP[^[o^ς݂̏ꍇA
 * ASRbN쐬Ɋmۂꂽ̈悪܂B<br>
 * iASRbN쐬Ƀ[N̈nꍇA{֐sł
 * [N̈\łBj<br>
 * \attention
 * {֐͊A^̊֐łB<br>
 * {֐sƁA΂炭̊AtomCũT[o[ubN܂B<br>
 * Đɖ{֐sƁAr؂ꓙ̕s\邽߁A<br>
 * {֐̌Ăяo̓V[̐؂ւ蓙Aוϓeł^C~OōsĂB<br>
 * \sa criAtomEx_SetUserAllocator, criAtomExAsrRack_Create
 */
void CRIAPI criAtomExAsrRack_Destroy(CriAtomExAsrRackId rack_id);

/*JP
 * \brief ASRbN̑_Oʂ̎擾
 * \ingroup ATOMEXLIB_ASR
 * \par :
 * ASRbÑ_Oς݃TvƃTvO[g擾܂B<br>
 * \attention
 * {֐̃_Oς݃Tv̑p^[͎s̃vbgtH[o̓foCXɂĕω\܂B<br>
 */
void CRIAPI criAtomExAsrRack_GetNumRenderedSamples(CriAtomExAsrRackId rack_id, CriSint64 *num_samples, CriSint32 *sampling_rate);

/*JP
 * \brief ptH[}Xj^[̃Zbg
 * \ingroup ATOMEXLIB_ASR
 * \param[in]	rack_id		ASRbNID
 * \par :
 * ݂܂ł̌vʂj܂B<br>
 * ptH[}Xj^[́A
 * ASRbN쐬ォptH[}X̎擾JnAvʂݐς܂B<br>
 * ȑǑvʂȍ~̌vʂɊ܂߂Ȃꍇɂ́A
 * {֐sAݐςꂽvʂUjKv܂B
 */
void CRIAPI criAtomExAsrRack_ResetPerformanceMonitor(CriAtomExAsrRackId rack_id);

/*JP
 * \brief ptH[}X̎擾
 * \ingroup ATOMEXLIB_ASR
 * \param[in]	rack_id		ASRbNID
 * \param[out]	info		ptH[}X
 * \par :
 * ptH[}X擾܂B<br>
 * {֐́Aw肳ꂽASRbÑ_Ôׂ݂v܂B<br>
 * \par l:
 * XbhfCRIATOMEX_THREAD_MODEL_MULTI_WITH_SONICSYNCw肵ȂꍇA
 * {֐gpKv͂܂B<br>
 * iCRIATOMEX_THREAD_MODEL_MULTI_WITH_SONICSYNCȊÕXbhfgpĂꍇA
 * {֐ׂ̏́A ::CriAtomExPerformanceInfo ɕ܂Ă܂Bj<br>
 * \sa CriAtomExAsrRackPerformanceInfo
 */
void CRIAPI criAtomExAsrRack_GetPerformanceInfo(CriAtomExAsrRackId rack_id, CriAtomExAsrRackPerformanceInfo *info);

/*JP
 * \brief DSPoXݒ̃A^b`p[NTCY̌vZ
 * \ingroup ATOMEXLIB_ASR
 * \param[in]	rack_id		ASRbNID
 * \param[in]	setting		DSPoXݒ̖O
 * \return		CriSint32	Kv[N̈TCY
 * \par :
 * DSPoXݒ肩oX\ẑɕKvȃ[N̈TCYvZ܂B<br>
 * {֐sɂ́A炩::criAtomEx_RegisterAcfConfig ֐ACF
 * o^ĂKv܂<br>
 * <br>
 * [N̈TCY̌vZɎsƁA{֐ -1 Ԃ܂B<br>
 * [N̈TCY̌vZɎsRɂẮAG[R[obÑbZ[WŊmF\łB<br>
 * \par l:
 * DSPoXݒ̃A^b`ɕKvȃ[ÑTCÝACRI Atom Craftō쐬
 * DSPoXݒ̓eɂĕω܂B<br>
 * \sa criAtomExAsrRack_AttachDspBusSetting, criAtomEx_RegisterAcfConfig
 */
CriSint32 CRIAPI criAtomExAsrRack_CalculateWorkSizeForDspBusSetting(
	CriAtomExAsrRackId rack_id, const CriChar8 *setting);

/*JP
 * \brief DSPoXݒ̃A^b`
 * \ingroup ATOMEXLIB_ASR
 * \param[in]	rack_id		ASRbNID
 * \param[in]	setting		DSPoXݒ̖O
 * \param[in]	work		[N̈
 * \param[in]	work_size	[N̈TCY
 * \par :
 * DSPoXݒ肩oX\zASRbNɃA^b`܂B<br>
 * {֐sɂ́A炩::criAtomEx_RegisterAcfConfig ֐ACF
 * o^ĂKv܂<br>
 * \par l:
 * DSPoXݒ̃A^b`ɕKvȃ[ÑTCÝA
 * CRI Atom Craftō쐬DSPoXݒ̓eɂĕω܂B<br>
 * \attention
 * {֐͊A^̊֐łB<br>
 * {֐sƁA΂炭̊AtomCũT[o[ubN܂B<br>
 * Đɖ{֐sƁAr؂ꓙ̕s\邽߁A
 * {֐̌Ăяo̓V[̐؂ւ蓙Aוϓeł^C~OōsĂB<br>
 * \sa criAtomExAsrRack_DetachDspBusSetting, criAtomEx_RegisterAcfConfig
 */
void CRIAPI criAtomExAsrRack_AttachDspBusSetting(CriAtomExAsrRackId rack_id,
	const CriChar8 *setting, void *work, CriSint32 work_size);

/*JP
 * \brief DSPoXݒ̃f^b`
 * \ingroup ATOMEXLIB_ASR
 * \param[in]	rack_id		ASRbNID
 * \par :
 * DSPoXݒASRbNf^b`܂B<br>
 * ::criAtomEx_SetUserAllocator }NgpăAP[^[o^ς݂̏ꍇA
 * DSPoXݒA^b`Ɋmۂꂽ̈悪܂B<br>
 * iDSPoXݒA^b`Ƀ[N̈nꍇA{֐sł
 * [N̈\łBj<br>
 * \attention
 * {֐͊A^̊֐łB<br>
 * {֐sƁA΂炭̊AtomCũT[o[ubN܂B<br>
 * Đɖ{֐sƁAr؂ꓙ̕s\邽߁A
 * {֐̌Ăяo̓V[̐؂ւ蓙Aוϓeł^C~OōsĂB
 * \sa criAtomExAsrRack_AttachDspBusSetting
 */
void CRIAPI criAtomExAsrRack_DetachDspBusSetting(CriAtomExAsrRackId rack_id);

/*JP
 * \brief DSPoXXibvVbg̓Kp
 * \ingroup ATOMEXLIB_ASR
 * \param[in]	rack_id		ASRbNID
 * \param[in]	snapshot_name	XibvVbg
 * \param[in]	time_ms			ԁi~bj
 * \par :
 * DSPoXXibvVbgKp܂B<br>
 * {֐ĂяoƁAXibvVbgŐݒ肵p[^[ time_ms |ĕω܂B<br>
 *  snapshot_name  CRI_NULL w肷ƁADSPoXݒ̏ԁiXibvVbgKpĂȂԁjɖ߂܂B<br>
 * \sa criAtomExAsrRack_AttachDspBusSetting
 */
void CRIAPI criAtomExAsrRack_ApplyDspBusSnapshot(CriAtomExAsrRackId rack_id,
	const CriChar8 *snapshot_name, CriSint32 time_ms);

/*JP
 * \brief KpDSPoXXibvVbg̎擾
 * \ingroup ATOMEXLIB_ASR
 * \param[in]	rack_id		ASRbNID
 * \par :
 * ASRbNIDw肵ēKpDSPoXXibvVbg擾܂B
 * XibvVbgKpĂȂꍇCRI_NULLԂ܂B
 * \sa criAtomExAsrRack_ApplyDspBusSnapshot
 */
const CriChar8* CRIAPI criAtomExAsrRack_GetAppliedDspBusSnapshotName(CriAtomExAsrRackId rack_id);

/*JP
 * \brief oX̃{[̐ݒ
 * \ingroup ATOMEXLIB_ASR
 * \param[in]	rack_id		ASRbNID
 * \param[in]	bus_name	oX
 * \param[in]	volume		{[l
 * \par :
 * oX̃{[ݒ肵܂B<br>
 * Zh^Cv|Xg{[A|Xgp̃ZhɗLłB<br>
 * <br>
 * {[lɂ́A0.0f`1.0f͈̔͂Ŏlw肵܂B<br>
 * {[l͉f[^̐Uɑ΂{łiPʂ̓fVxł͂܂jB<br>
 * Ⴆ΁A1.0fw肵ꍇA͂̂܂܂̃{[ŏo͂܂B<br>
 * 0.5fw肵ꍇAg`̐U𔼕ɂf[^Ɠʁi-6dBj
 * o͂܂B<br>
 * 0.0fw肵ꍇA̓~[g܂iɂȂ܂jB<br>
 * {[̃ftHglCRI Atom CraftŐݒ肵lłB<br>
 */
void CRIAPI criAtomExAsrRack_SetBusVolumeByName(CriAtomExAsrRackId rack_id, 
	const CriChar8* bus_name, CriFloat32 volume);

/*JP
 * \brief oX̃{[̎擾
 * \ingroup ATOMEXLIB_ASR
 * \param[in]	rack_id		ASRbNID
 * \param[in]	bus_name	oX
 * \param[in]	volume		{[l
 * \par :
 * oX̃{[ݒ肵܂B<br>
 * Zh^Cv|Xg{[A|Xgp̃ZhɗLłB<br>
 * <br>
 * {[l͎lœ܂B<br>
 * {[̃ftHglCRI Atom CraftŐݒ肵lłB<br>
 */
void CRIAPI criAtomExAsrRack_GetBusVolumeByName(CriAtomExAsrRackId rack_id, 
	const CriChar8* bus_name, CriFloat32* volume);

/*JP
 * \brief oX̃p̐ݒ
 * \ingroup ATOMEXLIB_ASR
 * \param[in]	rack_id		ASR bN ID
 * \param[in]	bus_name	oX
 * \param[in]	pan_info	p
 * \par :
 * oX̃pݒ肵܂B<br>
 * Zh^Cv|Xgp̃ZhɗLłB<br>
 * <br>
 * p̃ftHgl CRI Atom Craft Őݒ肵lłB
 */
void CRIAPI criAtomExAsrRack_SetBusPanInfoByName(CriAtomExAsrRackId rack_id, const CriChar8 *bus_name,
	const CriAtomExAsrBusPanInfo *pan_info);

/*JP
 * \brief oX̃p̎擾
 * \ingroup ATOMEXLIB_ASR
 * \param[in]	rack_id		ASR bN ID
 * \param[in]	bus_name	oX
 * \param[out]	pan_info	p
 * \par :
 * oX̃p擾܂B
 */
void CRIAPI criAtomExAsrRack_GetBusPanInfoByName(CriAtomExAsrRackId rack_id, const CriChar8 *bus_name,
	CriAtomExAsrBusPanInfo *pan_info);

/*JP
 * \brief oX̃xs̐ݒ
 * \ingroup ATOMEXLIB_ASR
 * \param[in]	rack_id			ASRbNID
 * \param[in]	bus_name		oX
 * \param[in]	input_channels	̓`l
 * \param[in]	output_channels	o̓`l
 * \param[in]	matrix			xs1ɕ\xl̔z
 * \par :
 * oX̃xsݒ肵܂B<br>
 * Zh^Cv|Xgp̃ZhɗLłB<br>
 * <br>
 * x}gbNX́Af[^̊e`l̉Aǂ̃Xs[J[
 * ǂ̒x̉ʂŏo͂邩w肷邽߂̎dg݂łB<br>
 * matrix[input_channels * output_channels]̔złB<br>
 * ̓`lch_ino̓`lch_outɃZh郌x
 * matrix[ch_in * output_channels + ch_out]ɃZbg܂B<br>
 * xs̃ftHgl͒PʍsłB<br>
 * <br>
 * xlɂ́A0.0f`1.0f͈̔͂Ŏlw肵܂B<br>
 * xl͉f[^̐Uɑ΂{łiPʂ̓fVxł͂܂jB<br>
 * Ⴆ΁A1.0fw肵ꍇA͂̂܂܂̃xŏo͂܂B<br>
 * 0.5fw肵ꍇAg`̐U𔼕ɂf[^Ɠʁi-6dBj
 * o͂܂B<br>
 * 0.0fw肵ꍇA̓~[g܂iɂȂ܂jB<br>
 */
void CRIAPI criAtomExAsrRack_SetBusMatrixByName(
	CriAtomExAsrRackId rack_id, const CriChar8* bus_name, CriSint32 input_channels, 
	CriSint32 output_channels, const CriFloat32 matrix[]);

/*JP
 * \brief oX̃Zhx̐ݒ
 * \ingroup ATOMEXLIB_ASR
 * \param[in]	rack_id			ASRbNID
 * \param[in]	bus_name		oX
 * \param[in]	sendto_bus_name	Zh̃oX
 * \param[in]	level			xl
 * \par :
 * ZhoXɉf[^𑗂ۂ̃xݒ肵܂B<br>
 * <br>
 * xlɂ́A0.0f`1.0f͈̔͂Ŏlw肵܂B<br>
 * xl͉f[^̐Uɑ΂{łiPʂ̓fVxł͂܂jB<br>
 * Ⴆ΁A1.0fw肵ꍇA͂̂܂܂̃xŏo͂܂B<br>
 * 0.5fw肵ꍇAg`̐U𔼕ɂf[^Ɠʁi-6dBj
 * o͂܂B<br>
 * 0.0fw肵ꍇA̓~[g܂iɂȂ܂jB<br>
 * x̃ftHglCRI Atom CraftŐݒ肵lłB<br>
 */
void CRIAPI criAtomExAsrRack_SetBusSendLevelByName(CriAtomExAsrRackId rack_id,
	const CriChar8* bus_name, const CriChar8* sendto_bus_name, CriFloat32 level);

/*JP
 * \brief GtFNg쎞p[^[̐ݒ
 * \ingroup ATOMEXLIB_ASR
 * \param[in]	rack_id			ASRbNID
 * \param[in]	bus_name		oX
 * \param[in]	effect_name		GtFNg
 * \param[in]	parameter_index	GtFNg쎞p[^[CfbNX
 * \param[in]	parameter_value GtFNgp[^[ݒl
 * \par :
 * GtFNg̓쎞p[^[ݒ肵܂B<br>
 * GtFNgp[^[ݒ肷ۂ́A{֐ĂяoOɂ炩
 * ::criAtomEx_AttachDspBusSetting ֐ŃoX\zĂKv܂B<br>
 * ǂ̃oXɂǂ̃GtFNg݂邩́AA^b`DSPoXݒɈˑ܂Bw肵oXɎw肵ÕGtFNg݂ȂꍇA֐͎s܂B<br>
 * ܂A
 * GtFNg̃p[^[́AeGtFNg̃p[^[CfbNXi \ref CRIATOMASR_DSP_PARAM jQƉB
 * \sa criAtomEx_AttachDspBusSetting, criAtomExAsrRack_UpdateEffectParameters
 */
void CRIAPI criAtomExAsrRack_SetEffectParameter(CriAtomExAsrRackId rack_id,
	const CriChar8* bus_name, const CriChar8* effect_name, 
	const CriUint32 parameter_index, const CriFloat32 parameter_value);

/*JP
 * \brief GtFNg̓쎞p[^[̔f
 * \ingroup ATOMEXLIB_ASR
 * \param[in]	rack_id			ASRbNID
 * \param[in]	bus_name		oX
 * \param[in]	effect_name		GtFNg
 * \par :
 * GtFNg̓쎞p[^[𔽉f܂B<br>
 * 쎞p[^[ۂɔfɂ́AcriAtomExAsrRack_SetEffectParameter ̑ɂ{֐ĂяoĉB
 * \sa criAtomEx_AttachDspBusSetting, criAtomExAsrRack_SetEffectParameter
 */
void CRIAPI criAtomExAsrRack_UpdateEffectParameters(CriAtomExAsrRackId rack_id,
	const CriChar8* bus_name, const CriChar8* effect_name);

/*JP
 * \brief GtFNg̓쎞p[^[̎擾
 * \ingroup ATOMEXLIB_ASR
 * \param[in]		rack_id			ASRbNID
 * \param[in]		bus_name		oX
 * \param[in]		effect_name		GtFNg
 * \param[in]		parameter_index	GtFNg̓쎞p[^[CfbNX
 * \return w肵p[^[CfbNXl̃GtFNgp[^[lԂ܂B
 * \par :
 * GtFNg̓쎞p[^[擾܂B<br>
 * 쎞p[^[擾ۂ́A{֐ĂяoOɂ炩
 * ::criAtomEx_AttachDspBusSetting ֐ŃoX\zĂKv܂B<br>
 * ǂ̃oXɂǂ̃GtFNg݂邩́AA^b`DSPoXݒɈˑ܂Bw肵oXɎw肵ÕGtFNg݂ȂꍇA֐͎s܂B<br>
 * GtFNg̓쎞p[^[̏ڍׂ́AeGtFNg̃p[^[CfbNXi \ref CRIATOMASR_DSP_PARAM jQƉB
 * \sa criAtomEx_AttachDspBusSetting
 */
CriFloat32 CRIAPI criAtomExAsrRack_GetEffectParameter(CriAtomExAsrRackId rack_id,
	const CriChar8* bus_name, const CriChar8* effect_name, 
	const CriUint32 parameter_index);

/*JP
 * \brief GtFNg̃oCpXݒ
 * \ingroup ATOMEXLIB_ASR
 * \param[in]	rack_id		ASRbNID
 * \param[in]	bus_name	oX
 * \param[in]	effect_name	GtFNg
 * \param[in]	bypass		oCpXݒiCRI_TRUE:oCpXs, CRI_FALSE:oCpXsȂj
 * \par :
 * GtFNg̃oCpXݒs܂B<br>
 * oCpXݒ肳ꂽGtFNg͉̍ہAX[悤ɂȂ܂B<br>
 * GtFNg̃oCpXݒۂ́A{֐ĂяoOɂ炩
 * ::criAtomEx_AttachDspBusSetting ֐ŃoX\zĂKv܂B<br>
 * ǂ̃oXɂǂ̃GtFNg݂邩́AA^b`DSPoXݒɈˑ܂Bw肵oXɎw肵ÕGtFNg݂ȂꍇA֐͎s܂B<br>
 * \attention
 * ĐɃoCpXݒsƃmCY邱Ƃ܂B<br>
 * \sa criAtomEx_AttachDspBusSetting
 */
void CRIAPI criAtomExAsrRack_SetEffectBypass(CriAtomExAsrRackId rack_id,
	const CriChar8* bus_name, const CriChar8* effect_name, const CriBool bypass);

/*JP
 * \brief GtFNg̃oCpXݒ̎擾
 * \ingroup ATOMEXLIB_ASR
 * \param[in]	rack_id		ASRbNID
 * \param[in]	bus_name	oX
 * \param[in]	effect_name	GtFNg
 * \return CriBool oCpXݒ肳Ă邩HiCRI_TRUE:oCpXs, CRI_FALSE:oCpXsȂj
 * \par :
 * GtFNg̃oCpXݒ擾܂B<br>
 * oCpXݒ肳ꂽGtFNg͉̍ہAX[悤ɂȂ܂B<br>
 * GtFNg̃oCpXݒۂ́A{֐ĂяoOɂ炩
 * ::criAtomEx_AttachDspBusSetting ֐ŃoX\zĂKv܂B<br>
 * ǂ̃oXɂǂ̃GtFNg݂邩́AA^b`DSPoXݒɈˑ܂Bw肵oXɎw肵ÕGtFNg݂ȂꍇA֐CRI_FALSEԋp܂B<br>
 * \sa criAtomExAsrRack_SetEffectBypass
 */
CriBool CRIAPI criAtomExAsrRack_GetEffectBypass(CriAtomExAsrRackId rack_id,
	const CriChar8* bus_name, const CriChar8* effect_name);

/*JP
 * \brief x@\̒ǉ
 * \ingroup ATOMEXLIB_ASR
 * \param[in]	rack_id		ASRbNID
 * \param[in]	bus_name	oX
 * \param[in]	config		x@\̃RtBO\
 * \par :
 * oXɃx@\ǉAx菈Jn܂B<br>
 * {֐sA ::criAtomExAsrRack_GetBusAnalyzerInfo ֐s邱ƂŁA
 * RMSxijAs[NxiőUjAs[Nz[hx
 * 擾邱Ƃ\łB
 * oX̃xvɂ́AoXƂɖ{֐ĂяoKv܂B
 * \attention
 * {֐ ::criAtomExAsrRack_AttachDspBusSetting ֐Ɠ̃\[X𑀍삵܂B<br>
 * ̂߁A ::criAtomExAsrRack_AttachDspBusSetting ֐sƁA
 * ::criAtomExAsrRack_GetBusAnalyzerInfo ֐ɂ擾łȂȂ܂B<br>
 * {֐ ::criAtomExAsrRack_AttachDspBusSetting ֐𕹗pۂɂ́A
 * ::criAtomExAsrRack_AttachDspBusSetting ֐sOɈU
 * ::criAtomExAsrRack_DetachBusAnalyzer ֐Ńx@\𖳌A
 * ::criAtomExAsrRack_AttachDspBusSetting ֐sɍēx{֐sĂB<br>
 * \sa criAtomExAsrRack_GetBusAnalyzerInfo, criAtomExAsrRack_DetachBusAnalyzer
 */
void CRIAPI criAtomExAsrRack_AttachBusAnalyzerByName(CriAtomExAsrRackId rack_id, 
	const CriChar8* bus_name, const CriAtomExAsrBusAnalyzerConfig* config);

/*JP
 * \brief x@\̍폜
 * \ingroup ATOMEXLIB_ASR
 * \param[in]	rack_id		ASRbNID
 * \param[in]	bus_name	oX
 * \par :
 * oX烌x@\폜܂B
 * \sa criAtomExAsrRack_AttachBusAnalyzer
 */
void CRIAPI criAtomExAsrRack_DetachBusAnalyzerByName(
	CriAtomExAsrRackId rack_id, const CriChar8* bus_name);

/*JP
 * \brief x茋ʂ̎擾
 * \ingroup ATOMEXLIB_ASR
 * \param[in]	rack_id		ASRbNID
 * \param[in]	bus_name	oX
 * \param[out]	info		x茋ʂ̍\
 * \par :
 * oX烌x@\̌ʂ擾܂B
 * \sa criAtomExAsrRack_AttachBusAnalyzer
 */
void CRIAPI criAtomExAsrRack_GetBusAnalyzerInfoByName(CriAtomExAsrRackId rack_id, 
	const CriChar8* bus_name, CriAtomExAsrBusAnalyzerInfo *info);

/*JP
 * \brief g`tB^[R[obN֐̓o^
 * \ingroup ATOMEXLIB_ASR
 * \param[in]	rack_id		ASRbNID
 * \param[in]	bus_name	oX
 * \param[in]	pre_func	GtFNgÕtB^[R[obN֐
 * \param[in]	post_func	GtFNg̃tB^[R[obN֐
 * \param[in]	obj			[UwIuWFNg
 * \par :
 * oXɗĂ PCM f[^󂯎R[obN֐o^܂B<br>
 * o^ꂽR[obN֐́ATEh_s^C~OŌĂяo܂B<br>
 * GtFNgOƃGtFNg2ނ̎gpȂقNULLw肪\łB<br>
 * \attention
 * R[obN֐ŁAAtomCuAPIsȂłB<br>
 * R[obN֐AtomCũT[o[s܂B<br>
 * ̂߁AT[o[ւ̊荞݂lȂAPIsꍇA
 * G[AfbhbN\܂B<br>
 * <br>
 * g`tB^[R[obN֐ŒԏubNƁA؂ꓙ̖
 * ܂̂ŁAӂB<br>
 * \sa CriAtomExPlayerFilterCbFunc
 */
void CRIAPI criAtomExAsrRack_SetBusFilterCallbackByName(CriAtomExAsrRackId rack_id, 
	const CriChar8* bus_name, CriAtomExAsrBusFilterCbFunc pre_func, 
	CriAtomExAsrBusFilterCbFunc post_func, void *obj);

/*JP
 * \brief ASRbNID̐ݒ
 * \ingroup ATOMEXLIB_ASR
 * \param[in]	rack_id			ASRbNID
 * \param[in]	alt_rack_id		ASRbNID
 * \par :
 * w肵IDASRbN݂ȂꍇɁAɂȂASRbNIDݒ肵܂B<br>
 * i rack_id ASRbN݂ȂꍇɁẢ alt_rack_id ASRbNoRŏo͂܂Bj<br>
 * <br>
 * ftHgݒ ::CRIATOMEXASR_RACK_DEFAULT_ID
 * iw肵IDASRbNȂ΃ftHgASRo͂jłB<br>
 * \par l:
 * ݂ȂASRbNւ̏o͂G[ƂĈꍇA
 * alt_rack_id  rack_id Ɠlݒ肵ĂB<br>
 */
void CRIAPI criAtomExAsrRack_SetAlternateRackId(
	CriAtomExAsrRackId rack_id, CriAtomExAsrRackId alt_rack_id);

/*JP
 * \brief őoX擾
 * \ingroup ATOMEXLIB_ASR
 * \param[in]	rack_id			ASRbNID
 * \return						őoX
 * \par :
 * w肵IDASRbNŗp\ȍőoX擾܂B
 * <br>
 * ftHgݒł ::CRIATOMEXASR_DEFAULT_NUM_BUSES Ԃ܂B
 * <br>
 * őoXύXɂ́ACriAtomExAsrRackConfig::num_buses ύX
 * ASRbN쐬ĂB
 * \sa CriAtomExAsrRackConfig, criAtomExAsrRack_Create, criAtomExAsrRack_SetDefaultConfig
 */
CriSint32 CRIAPI criAtomExAsrRack_GetNumBuses(CriAtomExAsrRackId rack_id);

/*JP
* \brief PCMf[^̎擾
* \ingroup ATOMEXLIB_ASR
* \param[in]	output_channels		o̓obt@[̃`l
* \param[in]	output_samples		o̓obt@[Ɋi[\ȃTv
* \param[out]	output_buffer		o̓obt@[
* \return		CriSint32			擾łTv
* \retval		0ȏ				擾łTv
* \retval		l				G[
* \par :
* AtomCȕoPCMf[^擾܂B<br>
* <br>
* {֐gpɂ́AO ::criAtomEx_InitializeForUserPcmOutput
* ֐gpăCuĂKv܂B<br>
* \attention
* {֐̌ĂяóAƗXbhŒIɍsKv܂B<br>
* AAtomCuAPIɂ́A
* PCMf[^o͂܂ŏԂȂ̂݂܂B<br>
* i{CXv[̔jBj<br>
* ֐Ɩ{֐Ƃ𓯈XbhŏԂɌĂяoƁA
* YAPIPCMf[^̏o͂iɑ҂`ɂȂA
* AȂȂ\܂B<br>
* \sa criAtomEx_InitializeForUserPcmOutput
*/
CriSint32 CRIAPI criAtomExAsr_GetPcmDataFloat32(
	CriSint32 output_channels, CriSint32 output_samples, CriFloat32 *output_buffer[]);

/*JP
* \brief PCMf[^cʂ̎擾
* \ingroup ATOMEXLIB_ASR
* \return CriSint32 PCMf[^cʁiTvPʁj
* \par :
* ::criAtomExAsr_GetPcmDataFloat32 ֐Ŏ擾\ȃTvԂ܂B<br>
* \sa criAtomExAsr_GetPcmDataFloat32
*/
CriSint32 CRIAPI criAtomExAsr_GetNumBufferedSamples(void);

/*JP
 * \brief PCMobt@[TCY̎w
 * \ingroup ATOMEXLIB_ASR
 * \param[in]	num_samples	PCMobt@[TCYiTvPʁj
 * \par :
 * AtomCuPCMf[^̕ۑɎgpobt@[̃TCYw肵܂B<br>
 * iTCY̓TvPʂŎw肵܂Bj<br>
 * <br>
 * obt@[TCY 0 w肵ꍇA2Ṽobt@[쐬܂B<br>
 * <br>
 * {֐ɂĐݒ肵l ::criAtomExAsr_GetPcmBufferSize ֐ɂĎ擾邱Ƃł܂B
 * \par l:
 * [UPCMo͕AtomCuꍇA
 * AtomCuASȐo͌ʂCũobt@[iPCMobt@[jɕێ܂B<br>
 * ftHgԂł́APCMobt@[̃TCY̓Cũp[^[ɉĎIɌ肳܂A
 * {֐s邱ƂŁAPCMobt@[̃TCYCӂ̃TCYɕύX邱Ƃ\łB<br>
 * \attention
 * PCMobt@[̊mۂ ::criAtomEx_InitializeForUserPcmOutput ֐ōs܂B<br>
 * ̂߁A{֐ ::criAtomEx_InitializeForUserPcmOutput
 * ֐ɎsKv܂B<br>
 * <br>
 * PCMobt@[ɒ~PCMf[^̃TvA
 * [UPCMf[^擾Ԋu菭ȂꍇA
 * r؂ꓙ̖肪\܂B<br>
 * tɁAPCMobt@[̃TCY傫ꍇA
 * JnTEho͂܂ł̒x傫Ȃ\܂B<br>
 * <br>
 * PCł́APCMobt@[TCYꍇɍĐs邩ǂA
 * TEhfoCX̐\ɂE܂B<br>
 * ̊ŉr؂ȂĐsꍇɂ́A
 * PCMobt@[TCYɂx傫߂̒lw肷邩A
 * ܂͉\ȌZԊu ::criAtomExAsr_GetPcmDataFloat32 ֐sĂB<br>
 * \sa criAtomExAsr_GetPcmBufferSize
 */
void CRIAPI criAtomExAsr_SetPcmBufferSize(CriSint32 num_samples);

/*JP
 * \brief PCMobt@[TCY̎擾
 * \ingroup ATOMEXLIB_ASR
 * \par :
 * AtomCuŐݒ肳ĂPCMf[^̕ۑɎgpobt@[̃TCY擾܂B<br>
 * iTCY̓TvPʂŎ擾܂Bj<br>
 * \par l:
 * ::criAtomExAsr_SetPcmBufferSize ֐ɂĐݒsĂȂꍇA 0 ԋp܂B
 * \sa criAtomExAsr_SetPcmBufferSize
 */
CriSint32 CRIAPI criAtomExAsr_GetPcmBufferSize(void);

/*JP
* \brief ASRbNPCMf[^̎擾
* \ingroup ATOMEXLIB_ASR
* \param[in]	rack_id			ASRbNID
* \param[in]	output_channels		o̓obt@[̃`l
* \param[in]	output_samples		o̓obt@[Ɋi[\ȃTv
* \param[out]	output_buffer		o̓obt@[
* \return		CriSint32			擾łTv
* \retval		0ȏ				擾łTv
* \retval		l				G[
* \par :
* ASRbN̏oPCMf[^擾܂B<br>
* <br>
* {֐gpɂ́AO ::criAtomEx_InitializeForUserPcmOutput
* ֐gpăCuĂKv܂B<br>
* \attention
* {֐̌ĂяóAƗXbhŒIɍsKv܂B<br>
* AAtomCuAPIɂ́A
* PCMf[^o͂܂ŏԂȂ̂݂܂B<br>
* i{CXv[̔jBj<br>
* ֐Ɩ{֐Ƃ𓯈XbhŏԂɌĂяoƁA
* YAPIPCMf[^̏o͂iɑ҂`ɂȂA
* AȂȂ\܂B<br>
* \sa criAtomEx_InitializeForUserPcmOutput
*/
CriSint32 CRIAPI criAtomExAsrRack_GetPcmDataFloat32(CriAtomExAsrRackId rack_id,
	CriSint32 output_channels, CriSint32 output_samples, CriFloat32 *output_buffer[]);

/*JP
* \brief ASRbNPCMf[^cʂ̎擾
* \ingroup ATOMEXLIB_ASR
* \return CriSint32 PCMf[^cʁiTvPʁj
* \par :
* ::criAtomExAsrRack_GetPcmDataFloat32 ֐Ŏ擾\ȃTvԂ܂B<br>
* \sa criAtomExAsrRack_GetPcmDataFloat32
*/
CriSint32 CRIAPI criAtomExAsrRack_GetNumBufferedSamples(CriAtomExAsrRackId rack_id);

/*JP
* \brief w肵oX̐U͊̉͌ʎ擾
* \ingroup ATOMEXLIB_ASR
* \param[in]	rack_id				ASRbNID
* \param[in]	bus_no				oXԍ
* \param[out]	rms					Uʏo̓obt@[
* \param[in]	num_channels		Uʏo̓obt@[̃`l
* \return	CriBool 擾ɐHiCRI_TRUE:擾ɐ, CRI_FALSE:擾Ɏsj
* \par :
* U݂͊̌̉͌ʁiRMSlj擾܂B
* w肵oXɐU͊킪ȂꍇAw肵`lASRoXꍇA擾Ɏs܂B
*/
CriBool CRIAPI criAtomExAsrRack_GetAmplitudeAnalyzerRms(CriAtomExAsrRackId rack_id,
	CriSint32 bus_no, CriFloat32* rms, CriUint32 num_channels);

/*JP
* \brief w肵oX̐U͊̉͌ʎ擾
* \ingroup ATOMEXLIB_ASR
* \param[in]	rack_id				ASRbNID
* \param[in]	bus_name			oX
* \param[out]	rms					Uʏo̓obt@[
* \param[in]	num_channels		Uʏo̓obt@[̃`l
* \return	CriBool 擾ɐHiCRI_TRUE:擾ɐ, CRI_FALSE:擾Ɏsj
* \par :
* U݂͊̌̉͌ʁiRMSlj擾܂B<br>
* w肵oXɐU͊킪ȂꍇAw肵`lASRoXꍇA擾Ɏs܂B
*/
CriBool CRIAPI criAtomExAsrRack_GetAmplitudeAnalyzerRmsByName(CriAtomExAsrRackId rack_id,
	const CriChar8* bus_name, CriFloat32* rms, CriUint32 num_channels);

/*JP
* \brief w肵oX̃RvbT[̐UZl擾
* \ingroup ATOMEXLIB_ASR
* \param[in]	rack_id				ASRbNID
* \param[in]	bus_no				oXԍ
* \param[out]	gain				UZlo̓obt@[
* \param[in]	num_channels		UZlo̓obt@[̃`l
* \return	CriBool 擾ɐHiCRI_TRUE:擾ɐ, CRI_FALSE:擾Ɏsj
* \par :
* RvbT[͔g`ɏZl擾܂B<br>
* w肵oXɃRvbT[ȂꍇAw肵`lASRoXꍇA擾Ɏs܂B
*/
CriBool CRIAPI criAtomExAsrRack_GetCompressorGain(CriAtomExAsrRackId rack_id,
	CriSint32 bus_no, CriFloat32* gain, CriUint32 num_channels);

/*JP
* \brief w肵oX̃RvbT[̐UZl擾
* \ingroup ATOMEXLIB_ASR
* \param[in]	rack_id				ASRbNID
* \param[in]	bus_name			oX
* \param[out]	gain				UZlo̓obt@[
* \param[in]	num_channels		UZlo̓obt@[̃`l
* \return	CriBool 擾ɐHiCRI_TRUE:擾ɐ, CRI_FALSE:擾Ɏsj
* \par :
* RvbT[͔g`ɏZl擾܂B<br>
* w肵oXɃRvbT[ȂꍇAw肵`lASRoXꍇA擾Ɏs܂B
*/
CriBool CRIAPI criAtomExAsrRack_GetCompressorGainByName(CriAtomExAsrRackId rack_id,
	const CriChar8* bus_name, CriFloat32* gain, CriUint32 num_channels);

/*JP
* \brief w肵oX̃RvbT[̐Ul擾
* \ingroup ATOMEXLIB_ASR
* \param[in]	rack_id				ASRbNID
* \param[in]	bus_no				oXԍ
* \param[out]	rms					UZlo̓obt@[
* \param[in]	num_channels		UZlo̓obt@[̃`l
* \return	CriBool 擾ɐHiCRI_TRUE:擾ɐ, CRI_FALSE:擾Ɏsj
* \par :
* RvbT[ɓKpĂUl擾܂B<br>
* w肵oXɃRvbT[ȂꍇAw肵`lASRoXꍇA擾Ɏs܂B
*/
CriBool CRIAPI criAtomExAsrRack_GetCompressorRms(CriAtomExAsrRackId rack_id,
	CriSint32 bus_no, CriFloat32* rms, CriUint32 num_channels);

/*JP
* \brief w肵oX̃RvbT[̐Ul擾
* \ingroup ATOMEXLIB_ASR
* \param[in]	rack_id				ASRbNID
* \param[in]	bus_name			oX
* \param[out]	rms					Ulo̓obt@[
* \param[in]	num_channels		Ulo̓obt@[̃`l
* \return	CriBool 擾ɐHiCRI_TRUE:擾ɐ, CRI_FALSE:擾Ɏsj
* \par :
* RvbT[ɓKpĂUl擾܂B<br>
* w肵oXɃRvbT[ȂꍇAw肵`lASRoXꍇA擾Ɏs܂B
*/
CriBool CRIAPI criAtomExAsrRack_GetCompressorRmsByName(CriAtomExAsrRackId rack_id,
	const CriChar8* bus_name, CriFloat32* rms, CriUint32 num_channels);

/*JP
 * \brief w肵ASRbNAISACRg[ɒlKpiRg[IDwj
 * \ingroup ATOMEXLIB_ASR
 * \param[in]	rack_id				ASRbNID
 * \param[in]	control_id			AISACRg[ID
 * \param[in]	control_value		AISACRg[l
 * \return	CriBool KpɐHiCRI_TRUE:Kpɐ, CRI_FALSE:KpɎsj
 * \par :
 * w肵ASRbNɃA^b`ĂDSPoXݒAISACRg[ɒlZbg܂B<br>
 * sꍇAG[R[obNԂ܂B
 */
CriBool CRIAPI criAtomExAsrRack_SetAisacControlById(CriAtomExAsrRackId rack_id,
	CriAtomExAisacControlId control_id, CriFloat32 control_value);

/*JP
 * \brief w肵ASRbNAISACRg[ɒlKpiRg[wj
 * \ingroup ATOMEXLIB_ASR
 * \param[in]	rack_id				ASRbNID
 * \param[in]	control_name		AISACRg[
 * \param[in]	control_value		AISACRg[l
 * \return	CriBool KpɐHiCRI_TRUE:Kpɐ, CRI_FALSE:KpɎsj
 * \par :
 * w肵ASRbNɃA^b`ĂDSPoXݒAISACRg[ɒlZbg܂B<br>
 * sꍇAG[R[obNԂ܂B
 */
CriBool CRIAPI criAtomExAsrRack_SetAisacControlByName(CriAtomExAsrRackId rack_id,
	const CriChar8* control_name, CriFloat32 control_value);

/*JP
 * \brief w肵ASRbNAISACRg[ɒl擾iRg[IDwj
 * \ingroup ATOMEXLIB_ASR
 * \param[in]	rack_id				ASRbNID
 * \param[in]	control_id			AISACRg[ID
 * \param[out]	control_value		AISACRg[l
 * \return	CriBool 擾ɐHiCRI_TRUE:擾ɐ, CRI_FALSE:擾Ɏsj
 * \par :
 * w肵ASRbNɃA^b`ĂDSPoXݒAISACRg[ɒl擾܂B<br>
 * sꍇAG[R[obNԂ܂B
 */
CriBool CRIAPI criAtomExAsrRack_GetAisacControlById(CriAtomExAsrRackId rack_id,
	CriAtomExAisacControlId control_id, CriFloat32 *control_value);

/*JP
 * \brief w肵ASRbNAISACRg[ɒl擾iRg[wj
 * \ingroup ATOMEXLIB_ASR
 * \param[in]	rack_id				ASRbNID
 * \param[in]	control_name		AISACRg[
 * \param[out]	control_value		AISACRg[l
 * \return	CriBool 擾ɐHiCRI_TRUE:擾ɐ, CRI_FALSE:擾Ɏsj
 * \par :
 * w肵ASRbNɃA^b`ĂDSPoXݒAISACRg[ɒl擾܂B<br>
 * sꍇAG[R[obNԂ܂B
 */
CriBool CRIAPI criAtomExAsrRack_GetAisacControlByName(CriAtomExAsrRackId rack_id,
	const CriChar8* control_name, CriFloat32 *control_value);

/*JP
 * \brief w肵ASRbN̏o̓foCX^Cv擾
 * \ingroup ATOMEXLIB_ASR
 * \param[in]	rack_id				ASRbNID
 * \return	CriAtomDeviceType	o̓foCX̃^Cv
 * \par :
 * w肵ASRbNo͂ĂfoCX̃^Cv擾܂B<br>
 * \par l:
 * foCX^Cv擾łȂvbgtH[ł͏ CRIATOM_DEVICE_TYPE_UNKNOWN Ԃ܂B
 * ܂AvbgtH[ɂĂ͎擾ɎԂꍇ邽߁A
 * ::criAtom_SetDeviceUpdateCallback œo^R[obN֐̒Ŏgp邱Ƃ܂B
 * \sa criAtom_SetDeviceUpdateCallback
 */
CriAtomDeviceType CRIAPI criAtomExAsrRack_GetDeviceType(CriAtomExAsrRackId rack_id);

/*JP
 * \brief AmbisonicsĐpASRbNID擾
 * \ingroup ATOMEXLIB_ASR
 * \return	CriSint32	ASRbNID
 * \par :
 * AmbisonicsĐ݂̂sASRbNID擾܂B<br>
 * 쐬ĂȂꍇACRIATOMEXASR_RACK_ILLEGAL_IDԂ܂B
 */
CriSint32 CRIAPI criAtomExAsrRack_GetAmbisonicRackId(void);

/*JP
 * \brief ASRbNw背x[^[@\p̃[NTCY̌vZ
 * \ingroup ATOMLIB_METER
 * \param[in]	rack_id			ASRbNID
 * \param[in]	config			x[^[ǉp̃RtBO\
 * \return		CriSint32		Kvȃ[N̈TCY
 * \par :
 * rack_idŎw肵ASRbNւ̃x[^[ǉɕKvȃ[N̈TCYvZ܂B<br>
 * config NULLw肷ƃftHgݒŌvZ܂B<br>
 * \sa criAtomExAsrRack_AttachLevelMeter
 */
CriSint32 CRIAPI criAtomExAsrRack_CalculateWorkSizeForLevelMeter(CriAtomExAsrRackId rack_id, const CriAtomLevelMeterConfig *config);

/*JP
 * \brief ASRbNw背x[^[@\̒ǉ
 * \ingroup ATOMLIB_METER
 * \param[in]	rack_id			ASRbNID
 * \param[in]	config			x[^[ǉp̃RtBO\
 * \param[in]	work			[N̈
 * \param[in]	work_size		[N̈TCY
 * \par :
 * rack_idŎw肵ASRbNփx[^[@\ǉ܂B<br>
 * config NULLw肷ƃftHgݒŃx[^[ǉ܂B<br>
 * work NULLAwork_size 0w肷ƁAo^ꂽ[UAP[^[ɂ
 * [N̈悪mۂ܂B<br>
 * \sa criAtomExAsrRack_GetLevelInfo
 */
void CRIAPI criAtomExAsrRack_AttachLevelMeter(CriAtomExAsrRackId rack_id, const CriAtomLevelMeterConfig *config, void *work, CriSint32 work_size);

/*JP
 * \brief ASRbNw背x[^[@\̉
 * \ingroup ATOMLIB_METER
 * \param[out]	rack_id			ASRbNID
 * \par :
 * rack_idŎw肵ASRbNɒǉꂽx[^[@\܂B<br>
 * \sa criAtomExAsrRack_AttachLevelMeter
 */
void CRIAPI criAtomExAsrRack_DetachLevelMeter(CriAtomExAsrRackId rack_id);

/*JP
 * \brief ASRbNw背x̎擾
 * \ingroup ATOMLIB_METER
 * \param[out]	rack_id			ASRbNID
 * \param[out]	info			x̍\
 * \par :
 * rack_idŎw肵ASRbÑx[^[̌ʂ擾܂B<br>
 * w肷郉bNɂ ::criAtomExAsrRack_AttachLevelMeter ֐ł炩
 * x[^[@\ǉĂKv܂B<br>
 * \sa criAtomExAsrRack_AttachLevelMeter
 */
void CRIAPI criAtomExAsrRack_GetLevelInfo(CriAtomExAsrRackId rack_id, CriAtomLevelInfo *info);

/*JP
 * \brief ASRbNw胉EhlX[^[@\p̃[NTCY̌vZ
 * \ingroup ATOMLIB_METER
 * \param[in]	rack_id			ASRbNID
 * \param[in]	config			EhlX[^[ǉp̃RtBO\
 * \return		CriSint32		Kvȃ[N̈TCY
 * \par :
 * rack_idŎw肵ASRbNւITU-R BS.1770-3KĩEhlX[^[ǉɕKvȃ[N̈TCYvZ܂B<br>
 * config NULLw肷ƃftHgݒŌvZ܂B<br>
 * \sa criAtomExAsrRack_AttachLoudnessMeter
 */
CriSint32 CRIAPI criAtomExAsrRack_CalculateWorkSizeForLoudnessMeter(CriAtomExAsrRackId rack_id, const CriAtomLoudnessMeterConfig *config);

/*JP
 * \brief ASRbNw胉EhlX[^[@\̒ǉ
 * \ingroup ATOMLIB_METER
 * \param[in]	rack_id			ASRbNID
 * \param[in]	config			EhlX[^[ǉp̃RtBO\
 * \param[in]	work			[N̈
 * \param[in]	work_size		[N̈TCY
 * \par :
 * rack_idŎw肵ASRbNITU-R BS.1770-3KĩEhlX[^[@\ǉ܂B<br>
 * config NULLw肷ƃftHgݒŃEhlX[^[ǉ܂B<br>
 * work NULLAwork_size 0w肷ƁAo^ꂽ[UAP[^[ɂ
 * [N̈悪mۂ܂B<br>
 * \sa criAtomExAsrRack_GetLoudnessInfo
 */
void CRIAPI criAtomExAsrRack_AttachLoudnessMeter(CriAtomExAsrRackId rack_id, const CriAtomLoudnessMeterConfig *config, void *work, CriSint32 work_size);

/*JP
 * \brief ASRbNw胉EhlX[^[@\̉
 * \ingroup ATOMLIB_METER
 * \param[in]	rack_id			ASRbNID
 * \par :
 * rack_idŎw肵ASRbÑEhlX[^[@\܂B<br>
 * \sa criAtomExAsrRack_DetachLoudnessMeter
 */
void CRIAPI criAtomExAsrRack_DetachLoudnessMeter(CriAtomExAsrRackId rack_id);

/*JP
 * \brief ASRbNw胉EhlX[^[̎擾
 * \ingroup ATOMLIB_METER
 * \param[in]	rack_id			ASRbNID
 * \param[out]	info			EhlX̍\
 * \par :
 * rack_idŎw肵ASRbÑEhlX[^[̌ʂ擾܂B<br>
 * w肷郉bNɂ ::criAtomExAsrRack_AttachLoudnessMeter ֐ł炩
 * EhlX[^[@\ǉĂKv܂B<br>
 * \sa criAtomExAsrRack_AttachLoudnessMeter
 */
void CRIAPI criAtomExAsrRack_GetLoudnessInfo(CriAtomExAsrRackId rack_id, CriAtomLoudnessInfo *info);

/*JP
 * \brief ASRbNw胉EhlX[^[̃Zbg
 * \ingroup ATOMLIB_METER
 * \par :
 * rack_idŎw肵ASRbÑEhlX[^[̒~σf[^Zbg܂B
 * {֐ĂяoOɃCuփEhlX[^[ǉĂKv܂B
 * \sa criAtomExAsrRack_AttachLoudnessMeter
 */
void CRIAPI criAtomExAsrRack_ResetLoudnessMeter(CriAtomExAsrRackId rack_id);

/*JP
 * \brief ASRbNwgD[s[N[^[@\p̃[NTCY̌vZ
 * \ingroup ATOMLIB_METER
 * \param[in]	rack_id			ASRbNID
 * \param[in]	config			gD[s[N[^[ǉp̃RtBO\
 * \return		CriSint32		Kvȃ[N̈TCY
 * \par :
 * rack_idŎw肵ASRbNւITU-R BS.1770-3KĩgD[s[N[^[ǉɕKvȃ[N̈TCYvZ܂B<br>
 * config NULLw肷ƃftHgݒŌvZ܂B<br>
 * \sa criAtomExAsrRack_AttachTruePeakMeter
 */
CriSint32 CRIAPI criAtomExAsrRack_CalculateWorkSizeForTruePeakMeter(CriAtomExAsrRackId rack_id, const CriAtomTruePeakMeterConfig *config);

/*JP
 * \brief ASRbNwgD[s[N[^[@\̒ǉ
 * \ingroup ATOMLIB_METER
 * \param[in]	rack_id			ASRbNID
 * \param[in]	config			gD[s[N[^[ǉp̃RtBO\
 * \param[in]	work			[N̈
 * \param[in]	work_size		[N̈TCY
 * \par :
 * rack_idŎw肵ASRbNITU-R BS.1770-3KĩgD[s[N[^[@\ǉ܂B<br>
 * config NULLw肷ƃftHgݒŃgD[s[N[^[ǉ܂B<br>
 * work NULLAwork_size 0w肷ƁAo^ꂽ[UAP[^[ɂ
 * [N̈悪mۂ܂B<br>
 * \sa criAtomExAsrRack_GetTruePeakInfo
 */
void CRIAPI criAtomExAsrRack_AttachTruePeakMeter(CriAtomExAsrRackId rack_id, const CriAtomTruePeakMeterConfig *config, void *work, CriSint32 work_size);

/*JP
 * \brief ASRbNwgD[s[N[^[@\̉
 * \param[in]	rack_id			ASRbNID
 * \ingroup ATOMLIB_METER
 * \par :
 * rack_idŎw肵ASRbNɒǉgD[s[N[^[@\܂B<br>
 * \sa criAtomExAsrRack_AttachTruePeakMeter
 */
void CRIAPI criAtomExAsrRack_DetachTruePeakMeter(CriAtomExAsrRackId rack_id);

/*JP
 * \brief ASRbNwgD[s[N̎擾
 * \ingroup ATOMLIB_METER
 * \param[in]	rack_id			ASRbNID
 * \param[out]	info		gD[s[N̍\
 * \par :
 * rack_idŎw肵ASRbÑgD[s[N[^[̑茋ʂ擾܂B
 * {֐ĂяoOɃCuփgD[s[N[^[ǉĂKv܂B
 * \sa criAtomExAsrRack_AttachTruePeakMeter
 */
void CRIAPI criAtomExAsrRack_GetTruePeakInfo(CriAtomExAsrRackId rack_id, CriAtomTruePeakInfo *info);

/*==========================================================================
 *      CRI Atom ASR API
 *=========================================================================*/
/*JP
 * \brief ASRp[N̈TCY̌vZ
 * \ingroup ATOMLIB_ASR
 * \param[in]	config	ASRpRtBO\
 * \par :
 * ASRiAtom Sound Rendererj̏ɕKvȃ[N̈̃TCY擾܂B<br>
 * ::criAtom_SetUserAllocator }NɂAP[^[o^s킸
 * ::criAtomAsr_Initialize ֐ASȐsꍇA
 * {֐ŌvZTCỸ[N̈ƂēnKv܂B<br>
 * <br>
 * [N̈TCY̌vZɎsƁA{֐ -1 Ԃ܂B<br>
 * [N̈TCY̌vZɎsRɂẮAG[R[obÑbZ[WŊmF\łB<br>
 * \par l:
 * ASȐɕKvȃ[ÑTCÝAASRpRtBO
 * \́i ::CriAtomAsrConfig j̓eɂĕω܂B<br>
 * <br>
 * NULLw肵ꍇAftHgݒ
 * i ::criAtomAsr_SetDefaultConfig KpƓp[^[j
 * [N̈TCYvZ܂B
 * <br>
 *  config ̏́A֐ł̂ݎQƂ܂B<br>
 * ֐𔲂͎QƂ܂̂ŁA֐s config ̗̈Ă
 * 肠܂B
 * \sa criAtom_SetUserAllocator, criAtomAsr_Initialize
 */
CriSint32 CRIAPI criAtomAsr_CalculateWorkSize(const CriAtomAsrConfig *config);

/*JP
 * \brief ASȐ
 * \ingroup ATOMLIB_ASR
 * \param[in]	config		ASRpRtBO\
 * \param[in]	work		[N̈
 * \param[in]	work_size	[N̈TCY
 * \par :
 * ASRiAtom Sound Rendererj̏s܂B<br>
 * {֐s邱ƂASRNA_Oʂ̏o͂Jn܂B<br>
 * \par l:
 * ASȐɕKvȃ[ÑTCÝAASRpRtBO
 * \́i ::CriAtomAsrConfig j̓eɂĕω܂B<br>
 * <br>
 * NULLw肵ꍇAftHgݒ<br>
 * i ::criAtomAsr_SetDefaultConfig KpƓp[^[jŏs܂B<br>
 * <br>
 *  config ̏́A֐ł̂ݎQƂ܂B<br>
 * ֐𔲂͎QƂ܂̂ŁA֐s config ̗̈Ă
 * 肠܂B<br>
 * \attention
 * {֐sOɁACuĂKv܂B<br>
 * <br>
 * {֐͊A^̊֐łB<br>
 * {֐sƁA΂炭̊AtomCũT[o[ubN܂B<br>
 * Đɖ{֐sƁAr؂ꓙ̕s\邽߁A
 * {֐̌Ăяo̓V[̐؂ւ蓙Aוϓeł^C~OōsĂB
 * <br>
 * {֐sAK΂ɂȂ ::criAtomAsr_Finalize ֐sĂB<br>
 * ܂A ::criAtomAsr_Finalize ֐s܂ł́A{֐ēxsȂłB<br>
 * \sa criAtom_SetUserAllocator, criAtomAsr_Finalize
 */
void CRIAPI criAtomAsr_Initialize(
	const CriAtomAsrConfig *config, void *work, CriSint32 work_size);

/*JP
 * \brief ASȐI
 * \ingroup ATOMLIB_ASR
 * \par :
 * ASRiAtom Sound Rendererj̏Is܂B<br>
 * {֐s邱ƂŁA_Oʂ̏o͂~܂B<br>
 * ::criAtom_SetUserAllocator }NgpăAP[^[o^ς݂̏ꍇA
 * ASRɊmۂꂽ̈悪܂B<br>
 * iASRɃ[N̈nꍇA{֐sł
 * [N̈\łBj<br>
 * \attention
 * {֐͊A^̊֐łB<br>
 * {֐sƁA΂炭̊AtomCũT[o[ubN܂B<br>
 * Đɖ{֐sƁAr؂ꓙ̕s\邽߁A<br>
 * {֐̌Ăяo̓V[̐؂ւ蓙Aוϓeł^C~OōsĂB<br>
 * \sa criAtom_SetUserAllocator, criAtomAsr_Initialize
 */
void CRIAPI criAtomAsr_Finalize(void);

/*JP
 * \brief oCm[CU[̗L
 * \ingroup ATOMEXLIB_ASR
 * \param[in]	enabled				LtO
 * \par :
 * oCm[CU[̗Lw肵܂B<br>
 * \par l:
 * oCm[CU[ sound_renderer_type  CRIATOM_SOUND_RENDERER_SPATIAL łASRbNł̂ݎgp\łB
 * oCm[CU[̃XyVCU[C^tF[Xo^ĂꍇAo^XyVCU[gp܂B
 * o^ĂȂꍇAAtom̃XyVCU[gp܂B
 */
void CRIAPI criAtomExAsr_EnableBinauralizer(CriBool enabled);

/*JP
 * \brief oCm[CU[̗LԂ̎擾
 * \ingroup ATOMEXLIB_ASR
 * \return						oCm[CU[̗LHiCRI_TRUE:L, CRI_FALSE:j
 * \par :
 * oCm[CU[̗LԂ擾܂B<br>
 */
CriBool CRIAPI criAtomExAsr_IsEnabledBinauralizer(void);

/*==========================================================================
 *      CRI AtomEx Player API
 *=========================================================================*/
/*JP
 * \brief o̓|[gnh̒ǉ
 * \ingroup ATOMEXLIB_PLAYER
 * \param[in]	player			AtomExv[[nh
 * \param[in]	output_port		o̓|[gnh
 * \par :
 * v[[ɏo̓|[gǉ܂B<br>
 * ::CRIATOMEXPLAYER_MAX_OUTPUT_PORTS ɒ`ꂽ̏o̓|[gw肷邱Ƃ\łB<br>
 * \par l:
 * {p[^[ ::criAtomExPlayer_ResetParameters ֐܂ ::criAtomExPlayer_ClearOutputPorts
 * ֐ɂăNA܂B
 * ܂A::criAtomExPlayer_RemoveOutputPort ֐œ̃nĥ݂OƂ\łB
 * <br>
 * L[Đɖ{֐ĂяoƁAȉ̐ݒ͑S<b></b>AL[͑SĒǉo̓|[gʂčĐ܂B
 * - f[^ɐݒ肳Ăp[^[pbgASRbNIDݒ
 * - ::criAtomExPlayer_SetAsrRackId ֐y ::criAtomExPlayer_SetAsrRackIdArray ֐Ŏw肵ASRbNID
 * - f[^ɐݒ肳ĂgbN̏o̓|[g
 * <br>
 * o̓|[g͍ĐJnOɐݒ肷Kv܂B<br>
 * ɍĐJnꂽɑ΂Aォo̓|[gύX邱Ƃ͂ł܂B<br>
 * <br>
 * ̏o̓|[gw肵v[[ĐꍇA{CX͂̎w肳ꂽo̓|[g̐gp܂B<br>
 * ̂߁AOɎw肷o̓|[g̃{CXmۂĂKv܂B<br>
 * <br>
 * ::criAtomExPlayer_SetData ֐gpL[ĐȊO̍Đł́A{֐ɂĎw肵̏o̓|[g̓A
 * 1ڂɐݒ肵o̓|[ĝ݂Kp܂B<br>
 * <br>
 * HCA-MXpɃGR[hꂽf[^ɂ́A{֐̐ݒ肪Kp܂B<br>
 * HCA-MXpɃGR[hꂽf[^ɂďo͐ݒ肷ꍇA
 * \attention
 * {֐ {CX̃TEh_^CvASRgpꍇɂ̂݌ʂ܂B<br>
 * ĩ{CXgpꍇA{֐̐ݒl͖܂Bj<br>
 * ::criAtomExHcaMx_SetAsrRackId ֐gpāAHCA-MX~LT̂̏o͐ASRbNIDݒ肵ĂB<br>
 * \sa criAtomExOutputPort_Create, criAtomExPlayer_RemoveOutputPort, criAtomExPlayer_ClearOutputPorts
 */
void CRIAPI criAtomExPlayer_AddOutputPort(CriAtomExPlayerHn player, CriAtomExOutputPortHn output_port);

/*JP
 * \brief o̓|[gnh̎O
 * \ingroup ATOMEXLIB_PLAYER
 * \param[in]	player			AtomExv[[nh
 * \param[in]	output_port		o̓|[gnh
 * \par :
 * v[[ɒǉo̓|[gO܂B<br>
 * \par l:
 * v[[ ::criAtomExPlayer_AddOutputPort ֐Œǉ̏o̓|[gnhO܂B
 * v[[ɐݒ肳Ăo̓|[gSĂOɂ ::criAtomExPlayer_ClearOutputPorts ֐gpĂB<br>
 * \attention
 * ɍĐJnꂽɑ΂Aォo̓|[gύX邱Ƃ͂ł܂B<br>
 * \sa criAtomExOutputPort_Create, criAtomExPlayer_AddOutputPort, criAtomExPlayer_ClearOutputPorts
 */
void CRIAPI criAtomExPlayer_RemoveOutputPort(CriAtomExPlayerHn player, CriAtomExOutputPortHn output_port);

/*JP
 * \brief o̓|[gnh̃NA
 * \ingroup ATOMEXLIB_PLAYER
 * \param[in]	player			AtomExv[[nh
 * \par :
 * v[[ɒǉo̓|[gSăNA܂B<br>
 * \par l:
 * v[[ ::criAtomExPlayer_AddOutputPort ֐Œǉ̏o̓|[gnhSăNA܂B
 * ̃nhO߂ɂ ::criAtomExPlayer_RemoveOutputPort ֐gpĂB<br>
 * \attention
 * ɍĐJnꂽɑ΂Aォo̓|[gύX邱Ƃ͂ł܂B<br>
 * \sa criAtomExOutputPort_Create, criAtomExPlayer_AddOutputPort, criAtomExPlayer_RemoveOutputPort
 */
void CRIAPI criAtomExPlayer_ClearOutputPorts(CriAtomExPlayerHn player);

/*JP
 * \brief Do̓|[gnh̒ǉ
 * \ingroup ATOMEXLIB_PLAYER
 * \param[in]	player			AtomExv[[nh
 * \param[in]	output_port		o̓|[gnh
 * \par :
 * v[[ACF̏o̓|[gDIɎQƂo̓|[gǉ܂B<br>
 * ::CRIATOMEXPLAYER_MAX_OUTPUT_PORTS ɒ`ꂽ̏o̓|[gw肷邱Ƃ\łB<br>
 * \par l:
 * {p[^[ ::criAtomExPlayer_ResetParameters ֐܂
 * ::criAtomExPlayer_ClearPreferredOutputPorts ɂăNA܂B
 * ܂A::criAtomExPlayer_RemovePreferredOutputPort ֐
 * ::criAtomExPlayer_RemovePreferredOutputPortByName ֐ɂē̃nĥ݂OƂ\łB
 * <br>
 * o̓|[gݒ肳ĂgbNL[ĐƂAʏACFo^Ɏꂽ
 * o̓|[go͂܂B
 * {֐Ńv[[ɑ΂ėDo̓|[gǉƂA
 * OqL[Đۂɂ͒ǉꂽ̗Do̓|[go͂悤ɂȂ܂B
 * \attention
 * f[^ɏo̓|[gݒ肳ĂȂgbN̍Đɂ͉e܂B<br>
 * <br>
 * o̓|[g͍ĐJnOɐݒ肷Kv܂B<br>
 * ɍĐJnꂽɑ΂Aォo̓|[gύX邱Ƃ͂ł܂B<br>
 * <br>
 * ̃v[[ɑ΂AO̗Do̓|[go^邱Ƃ͂ł܂B
 * <br>
 * ::criAtomExPlayer_SetData ֐gpL[ĐȊO̍Đł́A{֐ɂĎw肵̏o̓|[g̓A
 * 1ڂɐݒ肵o̓|[ĝ݂Kp܂B<br>
 * <br>
 * ::criAtomExPlayer_SetAsrRackId ֐sɖ{֐sƁA ::criAtomExPlayer_SetAsrRackId ֐ɂ
 * ݒ肵ASRbNIDݒ͏㏑܂B<br>
 * <br>
 * HCA-MXpɃGR[hꂽf[^ɂ́A{֐̐ݒ肪Kp܂B<br>
 * \sa criAtomExPlayer_RemovePreferredOutputPort, criAtomExPlayer_RemovePreferredOutputPortByName, criAtomExPlayer_ClearPreferredOutputPorts
 */
void CRIAPI criAtomExPlayer_AddPreferredOutputPort(CriAtomExPlayerHn player, CriAtomExOutputPortHn output_port);

/*JP
 * \brief Do̓|[gnh̎O
 * \ingroup ATOMEXLIB_PLAYER
 * \param[in]	player			AtomExv[[nh
 * \param[in]	output_port		o̓|[gnh
 * \par :
 * v[[ɒǉDo̓|[gO܂B<br>
 * \par l:
 * v[[ ::criAtomExPlayer_AddPreferredOutputPort ֐Œǉ̗Do̓|[gnhO܂B
 * v[[ɐݒ肳Ăo̓|[gSĎOɂ ::criAtomExPlayer_ClearOutputPorts ֐gpĂB<br>
 * \attention
 * Do̓|[gOĂAɍĐJnꂽɂ͉e܂B<br>
 * \sa criAtomExPlayer_AddOutputPort, criAtomExPlayer_RemovePreferredOutputPortByName, criAtomExPlayer_ClearPreferredOutputPorts
 */
void CRIAPI criAtomExPlayer_RemovePreferredOutputPort(CriAtomExPlayerHn player, CriAtomExOutputPortHn output_port);

/*JP
 * \brief Do̓|[gnh̎OiOwj
 * \ingroup ATOMEXLIB_PLAYER
 * \param[in]	player			AtomExv[[nh
 * \param[in]	name			o̓|[g
 * \par :
 * v[[ɒǉDo̓|[g𖼑Ow肵ĎO܂B<br>
 * \par l:
 * v[[ ::criAtomExPlayer_AddPreferredOutputPort ֐Œǉ̗Do̓|[gnhO܂B
 * v[[ɐݒ肳Ăo̓|[gSăNA邽߂ɂ ::criAtomExPlayer_ClearOutputPorts ֐gpĂB<br>
 * \attention
 * Do̓|[gOĂAɍĐJnꂽɂ͉e܂B<br>
 * \sa criAtomExPlayer_AddOutputPort, criAtomExPlayer_RemovePreferredOutputPort, criAtomExPlayer_ClearPreferredOutputPorts
 */
void CRIAPI criAtomExPlayer_RemovePreferredOutputPortByName(CriAtomExPlayerHn player, CriChar8* name);

/*JP
 * \brief Do̓|[gnh̃NA
 * \ingroup ATOMEXLIB_PLAYER
 * \param[in]	player			AtomExv[[nh
 * \par :
 * v[[ɒǉDo̓|[gSăNA܂B<br>
 * \par l:
 * v[[ ::criAtomExPlayer_AddPreferredOutputPort ֐ŒǉDo̓|[gnhSăNA܂B
 * ̗Do̓|[gO߂ɂ́A::criAtomExPlayer_RemovePreferredOutputPort ֐܂
 * ::criAtomExPlayer_RemovePreferredOutputPortByName ֐gpĂB<br>
 * \attention
 * Do̓|[gOĂAɍĐJnꂽɂ͉e܂B<br>
 * \sa criAtomExPlayer_AddOutputPort, criAtomExPlayer_RemovePreferredOutputPort, criAtomExPlayer_RemovePreferredOutputPortByName
 */
void CRIAPI criAtomExPlayer_ClearPreferredOutputPorts(CriAtomExPlayerHn player);

/*==========================================================================
 *      CRI AtomEx Output Port API
 *=========================================================================*/
/*JP
 * \brief o̓|[gnh쐬p[N̈TCY̌vZ
 * \ingroup ATOMEXLIB_OUTPUT_PORT
 * \param[in]	config		o̓|[gnh쐬pRtBO\
 * \return		CriSint32	[N̈TCY
 * \retval		0ȏ		ɏ
 * \retval		-1			G[
 * \par :
 * o̓|[gnh̍쐬ɕKvȃ[N̈̃TCYvZ܂B<br>
 * ::criAtomEx_SetUserAllocator }NɂAP[^[o^s킸
 * ::criAtomExOutputPort_Create ֐ŏo̓|[gnh쐬ۂɂ́A
 * ::criAtomExOutputPort_Create ֐ɖ{֐ԂTCỸ[N
 * ̈ƂēnKv܂B<br>
 * <br>
 * [N̈TCY̌vZɎsƁA{֐ -1 Ԃ܂B<br>
 * [N̈TCY̌vZɎsRɂẮAG[R[obÑbZ[WŊmF\łB<br>
 * \par l:
 *  config ̏́A֐ł̂ݎQƂ܂B<br>
 * ֐𔲂͎QƂ܂̂ŁA֐s config ̗̈Ă
 * 肠܂B
 * \attention
 * ::CriAtomExOutputPortConfig::name Ɏw肷o̓|[g̒́A
 * ::CRIATOMEX_OUTPUT_PORT_MAX_NAME_LENGTH ȉłKv܂B
 * \sa criAtomExOutputPort_Create
 */
CriSint32 CRIAPI criAtomExOutputPort_CalculateWorkSize(const CriAtomExOutputPortConfig *config);

/*JP
 * \brief o̓|[gnh̍쐬
 * \ingroup ATOMEXLIB_OUTPUT_PORT
 * \param[in]	config					ASRpRtBO\
 * \param[in]	work					[N̈
 * \param[in]	work_size				[N̈TCY
 * \return		CriAtomExOutputPortHn 	o̓|[gnh
 * \par :
 * o̓|[gnh̍쐬s܂B<br>
 * o̓|[gASRbNƕRtAo̓|[gw肳ꂽ{CX͂̏o̓|[gɕRtꂽ
 * ASRbNɂčĐ悤ɂȂ܂B<br>
 * \par l:
 * ACFt@Cɐݒ肳ꂽo̓|[gnh ::criAtomEx_RegisterAcfFile ֐Ȃǂp
 * ACFt@Co^ƂAACFɎIɍ쐬邽߁A
 * {֐ŐVɍ쐬Kv͂܂B<br>
 * ACF̏o̓|[gnh ::criAtomExAcf_GetOutputPortHnByName ֐Ŏ擾ł܂B<br>
 * ̂߁A{֐̓AvP[VŐVɏo̓|[gnhKvɂȂꍇɎgpĂB
 * <br>
 *  config ̏́A֐ł̂ݎQƂ܂B<br>
 * ֐𔲂͎QƂ܂̂ŁA֐s config ̗̈Ă
 * 肠܂B<br>
 * o̓|[gnh̐ɐꍇ́A{֐͐o̓|[gnhԂ܂B
 * Ɏsꍇ NULL Ԃ܂B<br>
 * \attention
 * {֐ō쐬ꂽo̓|[gnhɂ́A::CriAtomExOutputPortConfig::type Ŏw肵^Cvɂ
 * ȉASRbNIDlƂăZbgĂ܂B<br>
 * - CRIATOMEX_OUTPUT_PORT_TYPE_AUDIO wFCRIATOMEXASR_RACK_DEFAULT_ID
 * - CRIATOMEX_OUTPUT_PORT_TYPE_VIBRATION wFCRIATOMEXASR_RACK_ILLEGAL_ID
 * \par
 * o̓|[gnhgpOɁAK ::criAtomExOutputPort_SetAsrRackId 
 * ֐œK؂ASRbNݒ肵ĂB<br>
 * \sa criAtomExOutputPort_Destroy, criAtomExAcf_GetOutputPortHnByName, criAtomExPlayer_AddOutputPort, criAtomExPlayer_AddPreferredOutputPort
 */
CriAtomExOutputPortHn CRIAPI criAtomExOutputPort_Create(const CriAtomExOutputPortConfig *config, void *work, CriSint32 work_size);

/*JP
 * \brief o̓|[gnh̔j\̔
 * \ingroup ATOMEXLIB_OUTPUT_PORT
 * \param[in]	output_port				o̓|[gnh
 * \return		CriBool					j\HiCRI_TRUE = \, CRI_FALSE = s\j
 * \par :
 * o̓|[gnh̔j\肵܂B<br>
 * \par l:
 * ::criAtomExPlayer_AddOutputPort ֐܂ ::criAtomExPlayer_AddPreferredOutputPort ֐gp
 * v[[ɒǉ̏o̓|[gnh͔j邱Ƃł܂B<br>
 * ::criAtomExPlayer_RemoveOutputPort ֐܂ ::criAtomExPlayer_RemovePreferredOutputPort ֐gp
 * v[[OĂjĂB<br>
 * ܂AACFt@C̏񂩂쐬ꂽACF̏o̓|[gnh͔j邱Ƃł܂B
 * \sa criAtomExOutputPort_Destroy
 */
CriBool CRIAPI criAtomExOutputPort_IsDestroyable(CriAtomExOutputPortHn output_port);

/*JP
 * \brief o̓|[gnh̔j
 * \ingroup ATOMEXLIB_OUTPUT_PORT
 * \param[in]	output_port				o̓|[gnh
 * \par :
 * o̓|[gnh̔js܂B<br>
 * \par l:
 * AA ::criAtomExPlayer_AddOutputPort ֐܂ ::criAtomExPlayer_AddPreferredOutputPort ֐gp
 * v[[ɒǉ̏o̓|[gnh͔j邱Ƃł܂B<br>
 * ::criAtomExPlayer_RemoveOutputPort ֐܂ ::criAtomExPlayer_RemovePreferredOutputPort ֐gp
 * v[[OĂjĂB<br>
 * ܂AACFt@C̏񂩂쐬ꂽACF̏o̓|[gnh͔j邱Ƃł܂B
 * \sa criAtomExOutputPort_Create
 */
void CRIAPI criAtomExOutputPort_Destroy(CriAtomExOutputPortHn output_port);

/*JP
 * \brief ASRbNID̎w
 * \ingroup ATOMEXLIB_OUTPUT_PORT
 * \param[in]	output_port		o̓|[gnh
 * \param[in]	rack_id		ASRbNID
 * \par :
 * o̓|[gASRbNw肵܂B<br>
 * o̓|[gw肳ꂽ{CX́Ȁo̓|[gɎw肳ĂASRbNōĐ܂B
 * \par l:
 * ACFt@Co^ɍ쐬ꂽo̓|[gnh ::criAtomExOutputPort_Create ֐ō쐬ꂽ
 * o̓|[gnhɂ́AK{֐œK؂ASRbNw肷Kv܂B
 * <br>
 * o̓|[g̃^CvȂǂɂāAwłASRbNɐꍇ܂B
 * ڍׂɊւ܂Ă̓}jAQƂĂB
 * \attention
 * {֐ŏo̓|[gASRbNIDύXĂAɍĐĂ鉹ɂ͉e܂B
 * \sa criAtomExOutputPort_Create, criAtomExAcf_GetOutputPortHnByName
 */
void CRIAPI criAtomExOutputPort_SetAsrRackId(CriAtomExOutputPortHn output_port, CriAtomExAsrRackId rack_id);

/*JP
 * \brief U^Cv̏o̓|[g̃`lx̐ݒ
 * \ingroup ATOMEXLIB_OUTPUT_PORT
 * \param[in]	output_port			o̓|[gnh
 * \param[in]	channel				`lCfbNXi0 = L, 1 = Rj
 * \param[in]	level				x(0 ~ 2.0)
 * \par :
 * U^Cv̏o̓|[gɑ΂AUfoCX̊e`lւ̏o̓xݒ肵܂B<br>
 * \par l:
 * U^Cv̏o̓|[g͂Q`lœ삵ĂAŏIo̓foCXm̏ꍇ-3dB̃_E~bNXKp܂B
 * ̊֐Őݒ肵ĺAĐłf܂B
 * \sa criAtomExOutputPort_SetMonauralMix
 */
void CRIAPI criAtomExOutputPort_SetVibrationChannelLevel(CriAtomExOutputPortHn output_port, CriSint32 channel, CriFloat32 level);

/*JP
 * \brief U^Cv̏o̓|[g̃m~bNXLݒ
 * \ingroup ATOMEXLIB_OUTPUT_PORT
 * \param[in]	output_port			o̓|[gnh
 * \param[in]	monaural_mix			m~bNXLiCRI_TRUE = L, CRI_FALSE = j
 * \par :
 * U^Cv̏o̓|[g͂Q`lœ삷邽߁A͂{CXXeIȏ̉f[^A
 * 3Dpݒ肳ĂꍇǍʂUfoCX̍Eɓ`܂B
 * m~bNXLɂƁAUfoCX֏o͂OɈxmɃ_E~bNXsƂł̉eȂƂł܂B
 * ::criAtomExOutputPort_SetVibrationChannelLevel ֐gpāAm~bNXUfoCX֑郌xݒ肷邱Ƃ\łB<br>
 * \par l:
 * ̊֐Őݒ肵ĺAĐłf܂B
 * \sa criAtomExOutputPort_SetVibrationChannelLevel
 */
void CRIAPI criAtomExOutputPort_SetMonauralMix(CriAtomExOutputPortHn output_port, CriBool monaural_mix);

/*JP
 * \brief o̓|[gwJeS̃p[^𖳎邩̐ݒ
 * \ingroup ATOMEXLIB_OUTPUT_PORT
 * \param[in]	output_port_hn			o̓|[gnh
 * \param[in]	category_id				JeSID
 * \param[in]	ignore_parameters		ݒp[^ iCRI_TRUE:, CRI_FALSE:Ȃj
 * \par :
 * o̓|[gɑ΂Ďw肵JeSID̃p[^𖳎邩ݒ肵܂B<br>
 * \par l:
 * o̓|[gɑ΂Ďw肵JeSID̃p[^𖳎邱ƂŃJeS̉eȂƂł܂B
 * JeSIDw肵āAJeS𖳎EȂύX邱Ƃ\łB<br>
 * ݒłJeS͍ő4܂łłB4ݒ肵ĂԂł̊֐sƌxA͍s܂B<br>
 * \par l:
 * ̊֐Őݒ͍Đɔf܂B
 * \sa criAtomExOutputPort_Create, criAtomExAcf_GetOutputPortHnByName
 */
void CRIAPI criAtomExOutputPort_IgnoreCategoryParametersById(CriAtomExOutputPortHn output_port_hn, CriAtomExCategoryId category_id, CriBool ignore_parameters);

/*JP
 * \brief o̓|[gɐݒ肵wJeS̃p[^𖳎ݒZbg
 * \ingroup ATOMEXLIB_OUTPUT_PORT
 * \param[in]	output_port_hn			o̓|[gnh
 * \par :
 * o̓|[gɐݒ肵wJeS̃p[^𖳎ݒZbg܂B<br>
 * \par l:
 * o̓|[gɑ΂Ďw肵JeSID̃p[^𖳎ݒׂăZbg܂B<br>
 * ݒ肳ĂJeS̐Zbg邽ߐVɃJeSw肵ăJeS̃p[^𖳎ݒs܂B
 * \par l:
 * ̊֐Őݒ͍Đɔf܂B
 * \sa criAtomExOutputPort_Create, criAtomExOutputPort_IgnoreCategoryParametersById
 */
void CRIAPI criAtomExOutputPort_ResetIgnoreCategory(CriAtomExOutputPortHn output_port_hn);

/*==========================================================================
 *      CRI AtomEx API
 *=========================================================================*/
/*JP
 * \brief [UPCMo͕p[N̈TCYvZ
 * \ingroup ATOMEXLIB_GLOBAL
 * \param[in]	config		pRtBO\
 * \return		CriSint32	[N̈TCY
 * \par :
 * [UPCMo͕ŃCu邽߂ɕKvȁA
 * [N̈̃TCY擾܂B<br>
 * \par l:
 * CuKvƂ郏[N̈̃TCÝACupRtBO
 * \́i ::CriAtomExConfigForUserPcmOutput j̓eɂĕω܂B<br>
 * <br>
 *  config ̏́A֐ł̂ݎQƂ܂B<br>
 * ֐𔲂͎QƂ܂̂ŁA֐s config ̗̈Ă
 * 肠܂B
 * \attention
 * {֐ ::criAtomEx_InitializeForUserPcmOutput ֐gp
 * CuꍇɎgp܂B<br>
 * ::criAtomEx_Initialize ֐gpꍇɂ́A{֐ł͂Ȃ
 * ::criAtomEx_CalculateWorkSize ֐gpă[N̈TCYvZĂB<br>
 * \sa CriAtomExConfigForUserPcmOutput, criAtomEx_InitializeForUserPcmOutput
 */
CriSint32 CRIAPI criAtomEx_CalculateWorkSizeForUserPcmOutput(
	const CriAtomExConfigForUserPcmOutput *config);

/*JP
 * \brief [UPCMo͗pCu
 * \ingroup ATOMEXLIB_GLOBAL
 * \param[in]	config		pRtBO\
 * \param[in]	work		[N̈
 * \param[in]	work_size	[N̈TCY
 * \par :
 * [UPCMo̓[hŃCu܂B<br>
 * <br>
 * {֐gpďsꍇAAtomCu͉o͂s܂B<br>
 * [U ::criAtomExAsr_GetPcmDataFloat32 
 * ֐gpăCuIPCMf[^擾A
 * AvP[Vŉo͂sKv܂B<br>
 * \attention
 * {֐ƈȉ̊֐͕pł܂B<br>
 * 	- ::criAtomEx_Initialize
 * 	- ::criAtomExAsr_Initialize
 * 	- ::criAtomExHcaMx_Initialize
 * 	- evbgtH[ɂAtomCu֐
 * \sa CriAtomExConfigForUserPcmOutput, criAtomEx_FinalizeForUserPcmOutput,
 * criAtomExAsr_GetPcmDataFloat32, criAtomEx_CalculateWorkSizeForUserPcmOutput
 */
void CRIAPI criAtomEx_InitializeForUserPcmOutput(
	const CriAtomExConfigForUserPcmOutput *config, void *work, CriSint32 work_size);

/*JP
 * \brief [UPCMo͗pCuI
 * \ingroup ATOMEXLIB_GLOBAL
 * \par :
 * [UPCMo̓[hŏꂽCuɑ΂AIs܂B<br>
 * \attention
 * {֐ ::criAtomEx_InitializeForUserPcmOutput
 * ֐gpăCuꍇɎgp܂B<br>
 * ::criAtomEx_Initialize ֐gpꍇɂ́A{֐ł͂Ȃ
 * ::criAtomEx_Finalize ֐gpďIsĂB<br>
 * \sa criAtomEx_InitializeForUserPcmOutput
 */
void CRIAPI criAtomEx_FinalizeForUserPcmOutput(void);

/***************************************************************************
 *      bAPIigp͂Tj
 *      Tentative API (Please don't use it)
 ***************************************************************************/
/* ȉɐ錾Ă֐Atom̓pAQ[GWƂ̘Agɂ
 * bIɎgpĂAPIłB
 * ̃Abvf[gɂė\ȂύXE폜s邽߁Agp͂TB
 */
#define criAtomExAsr_GetEffectName(bus_name, index)	\
	criAtomExAsrRack_GetEffectName((CRIATOMEXASR_RACK_DEFAULT_ID), (bus_name), (index))
void CRIAPI criAtomExAsr_PauseOutputVoice(CriBool sw);
CriBool CRIAPI criAtomExAsrRack_GetNumOutputSamples(
	CriAtomExAsrRackId rack_id, CriSint64 *num_samples, CriSint32 *sampling_rate);
CriSint32 CRIAPI criAtomExAsrRack_GetOutputChannels(CriAtomExAsrRackId rack_id);
CriAtomSpeakerMapping CRIAPI criAtomExAsrRack_GetSpeakerMapping(CriAtomExAsrRackId rack_id);
CriSint32 CRIAPI criAtomExAsrRack_GetOutputDeviceChannels(CriAtomExAsrRackId rack_id);
CriUint16 CRIAPI criAtomExAsrRack_GetBusNumber(
	CriAtomExAsrRackId rack_id, const CriChar8 *bus_name);
void CRIAPI criAtomAsr_PauseOutputVoice(CriBool sw);
CriSint32 CRIAPI criAtomExAsr_CalculateResourceSize(const CriAtomExAsrConfig *config);
void CRIAPI criAtomExAsr_AddResource(const CriAtomExAsrConfig *config, void *work, CriSint32 work_size);
void CRIAPI criAtomExAsr_RemoveResource(void);
CriAtomExAsrRackId CRIAPI criAtomExAsrRack_CreateForAdditionalResource(
	const CriAtomExAsrRackConfig *config, void *work, CriSint32 work_size);

CriBool CRIAPI criAtomExAsr_IsSoundxREnabled(void);
const CriChar8* CRIAPI criAtomExAsrRack_GetEffectName(
	CriAtomExAsrRackId rack_id, const CriChar8* bus_name, CriUint32 index);

/*JP
 * \brief `lx[X Đp ASR bNID擾
 * \ingroup ATOMEXLIB_ASR
 * \return	CriSint32	ASRbNID
 * \par :
 * `lx[X Đ݂̂sASRbNID擾܂B<br>
 * 쐬ĂȂꍇACRIATOMEXASR_RACK_ILLEGAL_IDԂ܂B
 */
CriSint32 CRIAPI criAtomExAsrRack_GetChannelBasedAudioRackId(void);

/*JP
 * \brief ObjectBasedAudio ĐpASRbNID擾
 * \ingroup ATOMEXLIB_ASR
 * \return	CriSint32	ASRbNID
 * \par :
 * ObjectBasedAudio Đ݂̂sASRbNID擾܂B<br>
 * 쐬ĂȂꍇACRIATOMEXASR_RACK_ILLEGAL_IDԂ܂B
 */
CriSint32 CRIAPI criAtomExAsrRack_GetObjectBasedAudioRackId(void);

/*JP
 * \brief SoundxRvOCC^[tF[X̓o^
 * \ingroup ATOMEXLIB_ASR
 * \param[in]	soundxr_interface		SoundxRvOC̃C^[tF[X
 * \return		o^ɐHiCRI_TRUE:o^ɐ, CRI_FALSE:o^Ɏsj
 * \par :
 * SoundxRvOC̃C^[tF[Xo^܂B<br>
 * c[ŃoCm[CU[ Sound xR ݒ肵 ACF o^Kv܂B<br>
 * قȂoCm[CU[ݒ ACF o^ꍇ͈ȉ̋ɂȂ܂B
 * - oCm[CU[ݒ肪݂ȂÂ ACF		 : oCm[ʂɂȂB
 * - oCm[CU[ݒ肪 CRI Binauralizer  ACF : oCm[ʂɂȂB
 * \attention
 * {֐́ACȕOɎsĂB
 */
CriBool CRIAPI criAtomExAsr_RegisterSoundxRInterface(const void* soundxr_interface);

#ifdef __cplusplus
}
#endif

/***************************************************************************
 *      o[WƂ̌݊p
 *      For compatibility with old version
 ***************************************************************************/
#define CRIATOMEXASR_DEFAULT_NUM_BASES	(CRIATOMEXASR_DEFAULT_NUM_BUSES)
#define CRIATOMEXASR_MAX_BASES			(CRIATOMEXASR_MAX_BUSES)
#define criAtomExAsr_CalculateWorkSizeForDspBusSettingFromAcfData(acf_data, acf_buffer_size, setting_name)	\
	criAtomEx_CalculateWorkSizeForDspBusSettingFromAcfData((acf_data), (acf_buffer_size), (setting_name))
#define criAtomExAsr_CalculateWorkSizeForDspBusSetting(setting) \
	criAtomEx_CalculateWorkSizeForDspBusSetting(setting)
#define criAtomExAsr_AttachDspBusSetting(setting, work, work_size) \
	criAtomEx_AttachDspBusSetting(setting, work, work_size)
#define criAtomExAsr_DetachDspBusSetting() \
	criAtomEx_DetachDspBusSetting()
/* _[̏oChݒɉāAŃ_E~bNX邽߉L2֐͖ɂĂ܂ */
#define criAtomExAsr_SetDownmixMode(downmix_mode)
#define criAtomExAsrRack_SetDownmixMode(rack_id, downmix_mode)

/* \L}N */
#define CRIATOMEXASR_BIQUAD_FILTER_ANALYZER_NAME				"CRIWARE/Biquad"
#define CRIATOMEXASR_BANDPASS_FILTER_PARAMETER_TYPE				(-1)
#define CRIATOMEXASR_BUTTERWORTH_FILTER_PARAMETER_TYPE			(-1)
#define CRIATOMEXASR_BUTTERWORTH_FILTER_PARAMETER_LOW_FREQ		(0)
#define CRIATOMEXASR_BUTTERWORTH_FILTER_PARAMETER_HIGH_FREQ		(1)
#define CRIATOMEXASR_BUTTERWORTH_FILTER_NUM_PARAMETERS			(2)

/*
 * CRI Atom Ver.2.26.126 ȍ~ł́A}gNX̃GtFNg
 * Cӂ̃`lőł悤ɕύXĂ܂B
 * ̕ύXɔ]̍ő`l}gNX̃ftHg̃`lɂȂ܂B
 * ߋׁ݊̈AGCAXc܂B
 */
#define CRIATOMEXASR_MATRIX_MAX_NUM_CHANNELS (CRIATOMEXASR_MATRIX_DEFAULT_NUM_CHANNELS)
#define CRIATOMEXASR_MATRIX_MAX_NUM_PARAMETERS (CRIATOMEXASR_MATRIX_DEFAULT_NUM_PARAMETERS)

/* 
 * CRI Atom Ver.2.13.00 ȍ~ł́AASRoXɎgpGtFNg̎ʂ
 * idi񋓌^j當ɕύXA܂GtFNg̃p[^[͍\̂floatzɕύXĂ܂B
 * ̕ύXɔAȉ̗񋓌^ƍ\͓̂IɎgp܂B
 * ߋׁ݊̈A^`c܂B
 */
typedef enum {
	CRIATOMEXASR_DSP_ID_INVALID = 0,		
	CRIATOMEXASR_DSP_ID_BANDPASS_FILTER,	
	CRIATOMEXASR_DSP_ID_BIQUAD_FILTER,		
	CRIATOMEXASR_DSP_ID_DELAY,				
	CRIATOMEXASR_DSP_ID_ECHO,				
	CRIATOMEXASR_DSP_ID_REVERB,				
	CRIATOMEXASR_DSP_ID_PITCH_SHIFTER,		
	CRIATOMEXASR_DSP_ID_3BAND_EQ,			
	CRIATOMEXASR_DSP_ID_COMPRESSOR,			
	CRIATOMEXASR_DSP_ID_COMPRESSOR_EX,		
	CRIATOMEXASR_DSP_ID_CHORUS,				
	CRIATOMEXASR_DSP_ID_FLANGER,			
	CRIATOMEXASR_DSP_ID_DISTORTION,			
	CRIATOMEXASR_DSP_ID_AMPLITUDE_ANALYZER,	
	CRIATOMEXASR_DSP_ID_SURROUNDER,			
	CRIATOMEXASR_DSP_ID_I3DL2_REVERB,		
	CRIATOMEXASR_DSP_ID_MULTI_TAP_DELAY,	
	CRIATOMEXASR_DSP_ID_LIMITER,			
	CRIATOMEXASR_DSP_ID_MATRIX,
	CRIATOMEXASR_DSP_ID_32BANDS_EQ,
	CRIATOMEXASR_DSP_ID_BIT_CRUSHER,
	CRIATOMEXASR_DSP_ID_PHASER,
    CRIATOMEXASR_DSP_ID_BUS_BUFFER_POOL,
    CRIATOMEXASR_DSP_ID_MID_SIDE,
	CRIATOMEXASR_DSP_ID_IR_REVERB,
	CRIATOMEXASR_DSP_ID_CHANNELSPLIT_EQ,
	CRIATOMEXASR_DSP_ID_I3DL2_REVERB2,
	CRIATOMEXASR_DSP_ID_NO_TYPE = 0xFF,
	CRIATOMEXASR_DSP_ID_ENUM_SIZE_IS_4BYTES = 0x7FFFFFFF
} CriAtomExAsrDspId;

typedef struct CriAtomExAsrBandpassFilterParameterTag {
	CriFloat32 cof_high;
	CriFloat32 cof_low;
} CriAtomExAsrBandpassFilterParameter;

typedef struct CriAtomExAsrBiquadFilterParameterTag {
	CriAtomExBiquadFilterType type;
	CriFloat32 frequency;
	CriFloat32 q_value;
	CriFloat32 gain;
} CriAtomExAsrBiquadFilterParameter;

typedef struct CriAtomExAsrDelayParameterTag {
	CriFloat32 max_delay_time_ms;
	CriFloat32 delay_time_ms;
} CriAtomExAsrDelayParameter;

typedef struct CriAtomExAsrEchoParameterTag {
	CriFloat32 max_delay_time_ms;
	CriFloat32 delay_time_ms;
	CriFloat32 gain;
} CriAtomExAsrEchoParameter;

typedef enum {
	CRIATOMEXASR_REVERB_MODE_SURROUND = 0,
	CRIATOMEXASR_REVERB_MODE_STEREO,
	CRIATOMEXASR_REVERB_MODE_REAR_ONLY,
	CRIATOMEXASR_REVERB_MODE_CENTER_ONLY,
	CRIATOMEXASR_REVERB_MODE_ENUM_SIZE_IS_4BYTES = 0x7FFFFFFF
} CriAtomExAsrReverbMode;

typedef struct CriAtomExAsrReverbParameterTag {
	CriFloat32 max_predelay_time_ms;
	CriFloat32 max_room_size;
	CriAtomExAsrReverbMode mode;
	CriFloat32 reverb_time_ms;
	CriFloat32 room_size;
	CriFloat32 predelay_time_ms;
	CriFloat32 cof_low;
	CriFloat32 cof_high;
} CriAtomExAsrReverbParameter;

typedef enum {
	CRIATOMEXASR_PITCHSHIFTER_WINDOW_WIDTH_128 = 0,
	CRIATOMEXASR_PITCHSHIFTER_WINDOW_WIDTH_256,    
	CRIATOMEXASR_PITCHSHIFTER_WINDOW_WIDTH_512,    
	CRIATOMEXASR_PITCHSHIFTER_WINDOW_WIDTH_1024,   
	CRIATOMEXASR_PITCHSHIFTER_WINDOW_WIDTH_2048,   
	CRIATOMEXASR_PITCHSHIFTER_WINDOW_WIDTH_ENUM_SIZE_IS_4BYTES = 0x7FFFFFFF
} CriAtomExAsrPitchShifterWindowWidthType;

typedef enum {
	CRIATOMEXASR_PITCHSHIFTER_OVERLAP_1 = 0, 
	CRIATOMEXASR_PITCHSHIFTER_OVERLAP_2,     
	CRIATOMEXASR_PITCHSHIFTER_OVERLAP_4,     
	CRIATOMEXASR_PITCHSHIFTER_OVERLAP_8,     
	CRIATOMEXASR_PITCHSHIFTER_OVERLAP_ENUM_SIZE_IS_4BYTES = 0x7FFFFFFF
} CriAtomExAsrPitchShifterOverlapType;

typedef struct CriAtomExAsrPitchShifterParameterTag {
	CriFloat32 pitch_cent;
	CriFloat32 formant_cent;
	CriSint32 mode;
    CriAtomExAsrPitchShifterWindowWidthType window_width;
    CriAtomExAsrPitchShifterOverlapType overlap;
} CriAtomExAsrPitchShifterParameter;

typedef enum {
	CRIATOMEX_EQ_BAND_TYPE_LOWSHELF 	= 0,	
	CRIATOMEX_EQ_BAND_TYPE_HIGHSHELF 	= 1,	
	CRIATOMEX_EQ_BAND_TYPE_PEAKING 		= 2,	
	CRIATOMEX_EQ_BAND_TYPE_ENUM_SIZE_IS_4BYTES = 0x7FFFFFFF
} CriAtomExAsrEqBandType;

typedef struct CriAtomExAsr3BandsEqParameterTag {
	struct {
		CriAtomExAsrEqBandType type;
		CriFloat32 frequency;
		CriFloat32 q_value;
		CriFloat32 gain;
	} bands[3];
} CriAtomExAsr3BandsEqParameter;

typedef struct CriAtomExAsr32BandsEqParameterTag {
	CriSint32 num_used_bands;
	struct {
		CriAtomExAsrEqBandType type;
		CriFloat32 frequency;
		CriFloat32 q_value;
		CriFloat32 gain;
	} bands[32];
} CriAtomExAsr32BandsEqParameter;

typedef struct CriAtomExAsrCompressorParameterTag {
	CriFloat32 threshold;
	CriFloat32 ratio;
	CriFloat32 attack_time;
	CriFloat32 release_time;
	CriFloat32 output_gain; 
	CriFloat32 surround_link;
	CriSint32 side_chain_input_bus_no;
} CriAtomExAsrCompressorParameter;

typedef enum {
	CRIATOMEXASR_SPLIT_EQ_NONE     = 0,
	CRIATOMEXASR_SPLIT_EQ_LOWPASS  = 1,
	CRIATOMEXASR_SPLIT_EQ_HIGHPASS = 2,
	CRIATOMEXASR_SPLIT_EQ_BANDPASS = 3,
	CRIATOMEXASR_SPLIT_EQ_NOTCH    = 4,
	CRIATOMEXASR_SPLIT_EQ_TYPE_ENUM_SIZE_IS_4BYTES = 0x7FFFFFFF
} CriAtomExAsrSplitEqType;

typedef struct CriAtomExAsrCompressorExParameterTag {
	CriAtomExAsrCompressorParameter base;
	CriAtomExAsrSplitEqType eq_type;
	CriFloat32 frequency;
	CriFloat32 q_value;
} CriAtomExAsrCompressorExParameter;

typedef struct CriAtomExAsrChorusParameterTag {
	CriFloat32 max_delay_time_ms;
	CriFloat32 delay_time_ms;
	CriFloat32 rate;
	CriFloat32 depth;
	CriFloat32 feedback;
	CriFloat32 dry_mix; 
	CriFloat32 wet_mix1;
	CriFloat32 wet_mix2;
	CriFloat32 wet_mix3;
} CriAtomExAsrChorusParameter;

typedef struct CriAtomExAsrFlangerParameterTag {
	CriFloat32 delay_time_ms;
	CriFloat32 rate;
	CriFloat32 depth;
	CriFloat32 feedback;
	CriFloat32 dry_mix; 
	CriFloat32 wet_mix;
} CriAtomExAsrFlangerParameter;

typedef struct CriAtomExAsrDistortionParameterTag {
	CriFloat32 drive;
	CriFloat32 dry_mix; 
	CriFloat32 wet_mix;
	CriFloat32 output_gain; 
} CriAtomExAsrDistortionParameter;

typedef enum {
	CRIATOMEX_SURROUNDER_MODE_STRAIGHT = 0,
	CRIATOMEX_SURROUNDER_MODE_CROSS = 1,
	CRIATOMEX_SURROUNDER_MODE_MATRIX = 2,
	CRIATOMEX_SURROUNDER_MODE_ENUM_SIZE_IS_4BYTES = 0x7FFFFFFF
} CriAtomExAsrSurrounderMode;

typedef struct CriAtomExAsrSurrounderParameterTag {
	CriFloat32 max_delay_time_ms;
	CriFloat32 delay_time_ms;
	CriFloat32 gain;
	CriAtomExAsrSurrounderMode mode;
} CriAtomExAsrSurrounderParameter;

typedef struct CriAtomExAsrI3DL2ReverbParameterTag {
	CriFloat32 room;
	CriFloat32 room_hf;
	CriFloat32 decay_time;
	CriFloat32 decay_hf_ratio;
	CriFloat32 reflections;
	CriFloat32 reflections_delay;
	CriFloat32 reverb;
	CriFloat32 reverb_delay;
	CriFloat32 diffusion;
	CriFloat32 density;
	CriFloat32 hf_reference;
	CriFloat32 front_input;
	CriFloat32 rear_input;
	CriFloat32 center_input;
	CriFloat32 front_output;
	CriFloat32 rear_output;
	CriFloat32 center_output;
} CriAtomExAsrI3DL2ReverbParameter;

typedef struct CriAtomExAsrMultiTapDelayParameterTag {
	CriFloat32 max_delay_time_ms;
	struct {
		CriFloat32 delay_time_ms;
		CriFloat32 level;
		CriFloat32 pan;
		CriFloat32 feedback;
	} taps[4];
} CriAtomExAsrMultiTapDelayParameter;

typedef enum {
	CRIATOMEX_LIMITER_TYPE_PEAK = 0,
	CRIATOMEX_LIMITER_TYPE_RMS = 1,
	CRIATOMEX_LIMITER_TYPE_ENUM_SIZE_IS_4BYTES = 0x7FFFFFFF
} CriAtomExAsrLimiterType;

typedef struct CriAtomExAsrLimiterParameterTag {
	CriAtomExAsrLimiterType type;
	CriFloat32 threshold;
	CriFloat32 attack_time;
	CriFloat32 release_time;
	CriFloat32 output_gain; 
	CriFloat32 surround_link;
	CriSint32 side_chain_input_bus_no;
} CriAtomExAsrLimiterParameter;

typedef struct CriAtomExAsrMatrixParameterTag {
	CriFloat32		levels[CRIATOMEXASR_MAX_CHANNELS][CRIATOMEXASR_MAX_CHANNELS];
} CriAtomExAsrMatrixParameter;

#ifdef __cplusplus
extern "C" {
#endif

/*JP
 * \deprecated
 * 폜\̔񐄏APIłB
 * ĂяoƃG[R[obNԂ܂B
 * ::criAtomExAsr_SetEffectParameter ֐̎gpĉB
 */
void CRIAPI criAtomExAsr_SetDspParameter(
	CriSint32 bus_no, CriAtomExAsrDspId dsp_id, const void* parameter);

/*JP
 * \deprecated
 * 폜\̔񐄏APIłB
 * ĂяoƃG[R[obNԂ܂B
 * ::criAtomExAsr_SetEffectParameter ֐̎gpĉB
 */
void CRIAPI criAtomExAsr_SetDspParameterByName(
	const CriChar8* bus_name, CriAtomExAsrDspId dsp_id, const void* parameter);

/*JP
 * \deprecated
 * 폜\̔񐄏APIłB
 * ĂяoƃG[R[obNԂ܂B
 * ::criAtomExAsr_GetEffectParameter ֐̎gpĉB
 */
void CRIAPI criAtomExAsr_GetDspParameter(
	CriSint32 bus_no, CriAtomExAsrDspId dsp_id, void* parameter_buf, CriSint32 parameter_size);

/*JP
 * \deprecated
 * 폜\̔񐄏APIłB
 * ĂяoƃG[R[obNԂ܂B
 * ::criAtomExAsr_GetEffectParameter ֐̎gpĉB
 */
void CRIAPI criAtomExAsr_GetDspParameterByName(
	const CriChar8* bus_name, CriAtomExAsrDspId dsp_id, void* parameter_buf, CriSint32 parameter_size);

/*JP
 * \deprecated
 * 폜\̔񐄏APIłB
 * ĂяoƃG[R[obNԂ܂B
 * ::criAtomExAsrRack_SetEffectBypass ֐̎gpĉB
 */
void CRIAPI criAtomExAsr_SetDspBypass(
	CriSint32 bus_no, CriAtomExAsrDspId dsp_id, CriBool bypass);

/*JP
 * \deprecated
 * 폜\̔񐄏APIłB
 * Ăяoƌx܂A͍s܂B
 * ::criAtomExAsrRack_SetEffectBypass ֐̎gpĉB
 */
void CRIAPI criAtomExAsr_SetDspBypassByName(
	const CriChar8* bus_name, CriAtomExAsrDspId dsp_id, CriBool bypass);

/*JP
 * \deprecated
 * 폜\̔񐄏APIłB
 * ::criAtomExAsr_SetBusVolumeByName ֐̎gpĉB
 */
void CRIAPI criAtomExAsr_SetBusVolume(CriSint32 bus_no, CriFloat32 volume);

/*JP
 * \deprecated
 * 폜\̔񐄏APIłB
 * ::criAtomExAsr_GetBusVolumeByName ֐̎gpĉB
 */
void CRIAPI criAtomExAsr_GetBusVolume(CriSint32 bus_no, CriFloat32 *volume);

/*JP
 * \deprecated
 * 폜\̔񐄏APIłB
 * ::criAtomExAsr_SetBusPanInfoByName ֐̎gpĉB
 */
void CRIAPI criAtomExAsr_SetBusPan3d(CriSint32 bus_no, 
	CriFloat32 pan3d_angle, CriFloat32 pan3d_distance, CriFloat32 pan3d_volume);

/*JP
 * \deprecated
 * 폜\̔񐄏APIłB
 * ::criAtomExAsr_GetBusPanInfoByName ֐̎gpĉB
 */
void CRIAPI criAtomExAsr_GetBusPan3d(CriSint32 bus_no, 
	CriFloat32 *pan3d_angle, CriFloat32 *pan3d_distance, CriFloat32 *pan3d_volume);

/*JP
 * \deprecated
 * 폜\̔񐄏APIłB
 * ::criAtomExAsr_SetBusPanInfoByName ֐̎gpĉB
 */
void CRIAPI criAtomExAsr_SetBusPan3dByName(const CriChar8* bus_name,
	CriFloat32 pan3d_angle, CriFloat32 pan3d_distance, CriFloat32 pan3d_volume);

/*JP
 * \deprecated
 * 폜\̔񐄏APIłB
 * ::criAtomExAsr_GetBusPanInfoByName ֐̎gpĉB
 */
void CRIAPI criAtomExAsr_GetBusPan3dByName(const CriChar8* bus_name,
	CriFloat32 *pan3d_angle, CriFloat32 *pan3d_distance, CriFloat32 *pan3d_volume);

/*JP
 * \deprecated
 * 폜\̔񐄏APIłB
 * ::criAtomExAsr_SetBusMatrixByName ֐̎gpĉB
 */
void CRIAPI criAtomExAsr_SetBusMatrix(CriSint32 bus_no, 
	CriSint32 input_channels, CriSint32 output_channels, const CriFloat32 matrix[]);

/*JP
 * \deprecated
 * 폜\̔񐄏APIłB
 * ::criAtomExAsr_SetBusSendLevelByName ֐̎gpĉB
 */
void CRIAPI criAtomExAsr_SetBusSendLevel(
	CriSint32 bus_no, CriSint32 sendto_no, CriFloat32 level);
/*JP
 * \deprecated
 * 폜\̔񐄏APIłB
 * ::criAtomExAsr_AttachBusAnalyzerByName ֐̎gpĉB
 */
void CRIAPI criAtomExAsr_AttachBusAnalyzer(
	CriSint32 bus_no, const CriAtomExAsrBusAnalyzerConfig* config);

/*JP
 * \deprecated
 * 폜\̔񐄏APIłB
 * ::criAtomExAsr_DetachBusAnalyzerByName ֐̎gpĉB
 */
void CRIAPI criAtomExAsr_DetachBusAnalyzer(CriSint32 bus_no);

/*JP
 * \deprecated
 * 폜\̔񐄏APIłB
 * ::criAtomExAsr_GetBusAnalyzerInfoByName ֐̎gpĉB
 */
void CRIAPI criAtomExAsr_GetBusAnalyzerInfo(
	CriSint32 bus_no, CriAtomExAsrBusAnalyzerInfo *info);

/*JP
 * \deprecated
 * 폜\̔񐄏APIłB
 * ::criAtomExAsr_SetBusFilterCallbackByName ֐̎gpĉB
 */
void CRIAPI criAtomExAsr_SetBusFilterCallback(CriSint32 bus_no, 
	CriAtomExAsrBusFilterCbFunc pre_func, CriAtomExAsrBusFilterCbFunc post_func, void *obj);

/*JP
 * \deprecated
 * 폜\̔񐄏APIłB
 * ĂяoƃG[R[obNԂ܂B
 * ::criAtomExAsrRack_SetEffectParameter ֐̎gpĉB
 */
void CRIAPI criAtomExAsrRack_SetDspParameter(CriAtomExAsrRackId rack_id, 
	CriSint32 bus_no, CriAtomExAsrDspId dsp_id, const void* parameter);

/*JP
 * \deprecated
 * 폜\̔񐄏APIłB
 * ĂяoƃG[R[obNԂ܂B
 * ::criAtomExAsrRack_SetEffectParameter ֐̎gpĉB
 */
void CRIAPI criAtomExAsrRack_SetDspParameterByName(CriAtomExAsrRackId rack_id, 
	const CriChar8* bus_name, CriAtomExAsrDspId dsp_id, const void* parameter);

/*JP
 * \deprecated
 * 폜\̔񐄏APIłB
 * ĂяoƃG[R[obNԂ܂B
 * ::criAtomExAsrRack_GetEffectParameter ֐̎gpĉB
 */
void CRIAPI criAtomExAsrRack_GetDspParameter(CriAtomExAsrRackId rack_id, 
	CriSint32 bus_no, CriAtomExAsrDspId dsp_id, void* parameter_buf, CriSint32 parameter_size);

/*JP
 * \deprecated
 * 폜\̔񐄏APIłB
 * ĂяoƃG[R[obNԂ܂B
 * ::criAtomExAsrRack_GetEffectParameter ֐̎gpĉB
 */
void CRIAPI criAtomExAsrRack_GetDspParameterByName(CriAtomExAsrRackId rack_id, 
	const CriChar8* bus_name, CriAtomExAsrDspId dsp_id, void* parameter_buf, CriSint32 parameter_size);

/*JP
 * \deprecated
 * 폜\̔񐄏APIłB
 * ĂяoƃG[R[obNԂ܂B
 * ::criAtomExAsrRack_SetEffectBypass ֐̎gpĉB
 */
void CRIAPI criAtomExAsrRack_SetDspBypass(CriAtomExAsrRackId rack_id, 
	CriSint32 bus_no, CriAtomExAsrDspId dsp_id, CriBool bypass);

/*JP
 * \deprecated
 * 폜\̔񐄏APIłB
 * Ăяoƌx܂A͍s܂B
 * ::criAtomExAsrRack_SetEffectBypass ֐̎gpĉB
 */
void CRIAPI criAtomExAsrRack_SetDspBypassByName(CriAtomExAsrRackId rack_id, 
	const CriChar8* bus_name, CriAtomExAsrDspId dsp_id, CriBool bypass);

/*JP
 * \deprecated
 * 폜\̔񐄏APIłB
 * ::criAtomExAsrRack_SetBusVolumeByName ֐̎gpĉB
 */
void CRIAPI criAtomExAsrRack_SetBusVolume(CriAtomExAsrRackId rack_id, 
	CriSint32 bus_no, CriFloat32 volume);

/*JP
 * \deprecated
 * 폜\̔񐄏APIłB
 * ::criAtomExAsrRack_GetBusVolumeByName ֐̎gpĉB
 */
void CRIAPI criAtomExAsrRack_GetBusVolume(CriAtomExAsrRackId rack_id, 
	CriSint32 bus_no, CriFloat32* volume);

/*JP
 * \deprecated
 * 폜\̔񐄏APIłB
 * ::criAtomExAsrRack_SetBusPanInfoByName ֐̎gpĉB
 */
void CRIAPI criAtomExAsrRack_SetBusPan3d(CriAtomExAsrRackId rack_id, CriSint32 bus_no, 
	CriFloat32 pan3d_angle, CriFloat32 pan3d_distance, CriFloat32 pan3d_volume);

/*JP
 * \deprecated
 * 폜\̔񐄏APIłB
 * ::criAtomExAsrRack_GetBusPanInfoByName ֐̎gpĉB
 */
void CRIAPI criAtomExAsrRack_GetBusPan3d(CriAtomExAsrRackId rack_id, CriSint32 bus_no, 
	CriFloat32 *pan3d_angle, CriFloat32 *pan3d_distance, CriFloat32 *pan3d_volume);

/*JP
 * \deprecated
 * 폜\̔񐄏APIłB
 * ::criAtomExAsrRack_SetBusPanInfoByName ֐̎gpĉB
 */
void CRIAPI criAtomExAsrRack_SetBusPan3dByName(CriAtomExAsrRackId rack_id, const CriChar8* bus_name,
	CriFloat32 pan3d_angle, CriFloat32 pan3d_distance, CriFloat32 pan3d_volume);

/*JP
 * \deprecated
 * 폜\̔񐄏APIłB
 * ::criAtomExAsrRack_GetBusPanInfoByName ֐̎gpĉB
 */
void CRIAPI criAtomExAsrRack_GetBusPan3dByName(CriAtomExAsrRackId rack_id, const CriChar8* bus_name,
	CriFloat32 *pan3d_angle, CriFloat32 *pan3d_distance, CriFloat32 *pan3d_volume);

/*JP
 * \deprecated
 * 폜\̔񐄏APIłB
 * ::criAtomExAsrRack_SetBusMatrixByName ֐̎gpĉB
 */
void CRIAPI criAtomExAsrRack_SetBusMatrix(
	CriAtomExAsrRackId rack_id, CriSint32 bus_no, CriSint32 input_channels, 
	CriSint32 output_channels, const CriFloat32 matrix[]);

/*JP
 * \deprecated
 * 폜\̔񐄏APIłB
 * ::criAtomExAsrRack_SetBusSendLevelByName ֐̎gpĉB
 */
void CRIAPI criAtomExAsrRack_SetBusSendLevel(CriAtomExAsrRackId rack_id,
	CriSint32 bus_no, CriSint32 sendto_no, CriFloat32 level);

/*JP
 * \deprecated
 * 폜\̔񐄏APIłB
 * ::criAtomExAsrRack_AttachBusAnalyzerByName ֐̎gpĉB
 */
void CRIAPI criAtomExAsrRack_AttachBusAnalyzer(CriAtomExAsrRackId rack_id, 
	CriSint32 bus_no, const CriAtomExAsrBusAnalyzerConfig* config);

/*JP
 * \deprecated
 * 폜\̔񐄏APIłB
 * ::criAtomExAsrRack_DetachBusAnalyzerByName ֐̎gpĉB
 */
void CRIAPI criAtomExAsrRack_DetachBusAnalyzer(
	CriAtomExAsrRackId rack_id, CriSint32 bus_no);

/*JP
 * \deprecated
 * 폜\̔񐄏APIłB
 * ::criAtomExAsrRack_GetBusAnalyzerInfoByName ֐̎gpĉB
 */
void CRIAPI criAtomExAsrRack_GetBusAnalyzerInfo(CriAtomExAsrRackId rack_id, 
	CriSint32 bus_no, CriAtomExAsrBusAnalyzerInfo *info);

/*JP
 * \deprecated
 * 폜\̔񐄏APIłB
 * ::criAtomExAsrRack_SetBusFilterCallbackByName ֐̎gpĉB
 */
void CRIAPI criAtomExAsrRack_SetBusFilterCallback(CriAtomExAsrRackId rack_id, 
	CriSint32 bus_no, CriAtomExAsrBusFilterCbFunc pre_func, 
	CriAtomExAsrBusFilterCbFunc post_func, void *obj);

#ifdef __cplusplus
}
#endif


#endif	/* CRI_ATOM_ASR_H_INCLUDED */

/* --- end of file --- */
