/****************************************************************************
 *
 * CRI ADX2 LE SDK
 *
 * Copyright (c) 2013-2014 CRI Middleware Co., Ltd.
 *
 * Title   : CRI ADX2 LE sample program
 * Module  : 3D|WVjO
 * File    : 3Dpos.cpp
 *
 ****************************************************************************/

/**************************************************************************
 * CN[h
 * Header files
 **************************************************************************/
#include <windows.h>
#include <math.h> 

#include <cri_adx2le.h>
#include <CriSmpFramework.h>

/* CQ[vr[LɂꍇA` */
#define USE_INGAME_PREVIEW

/**************************************************************************
 * 萔}N`
 * Constant macro definitions
 **************************************************************************/
/* ACF/ACB̃}N`wb_ */
#include "../../data/Public/3Dpos.h"
#include "../../data/Public/ADX2_samples_acf.h"

/* f[^fBNgւ̃pX */
/* Header file for path definitions to data directory */
#define PATH				"../../../data/Public/"

/* TvŎgpt@C */
#define ACF_FILE			"ADX2_samples.acf"
#define ACB_FILE			"3Dpos.acb"

/* ő{CX𑝂₷߂̊֘Ap[^ */
#define MAX_STANDARD_VOICE	(8)
#define MAX_HCAMX_VOICE		(8)
#define MAX_VOICE			(MAX_STANDARD_VOICE + MAX_HCAMX_VOICE)
#define MAX_VIRTUAL_VOICE	(MAX_VOICE + 8)		/* o[`{CX͑ */
#define MAX_CRIFS_LOADER	(MAX_VOICE + 1)		/* ǂݍݐ߂ */

/* őTvO[gisb`ύX܂ށj */
#define MAX_SAMPLING_RATE	(48000*2)

/* HCA-MXR[fbÑTvO[g */
#define HCAMX_SAMPLING_RATE		(32000)

/* ̈ړ̍ŏlƍől (200 x 200 x 200 ̗̏ԓړ) */
#define SOURCE_POS_MIN				(-100)
#define SOURCE_POS_MAX				(100)

#define X_POS_OFFSET_FOR_MAP_DRAW	(60)
#define Z_POS_OFFSET_FOR_MAP_DRAW	(7)

#define X_POS_SCALE_VAL				(0.2f)
#define Z_POS_SCALE_VAL				(0.08f)

#define MAP_2D_WIDTH				(41)
#define MAP_2D_HEIGHT				(17)

#define GM	(-44.0f)

/**************************************************************************
 * ^`
 * Type definitions
 **************************************************************************/
/* 3D̈ړp^[ */
typedef enum {
	APP_MORTION_CROSS_FRONT_OF_LISTENER = 0,
	APP_MOTION_PASS_LISTENER_FRONT_TO_REAR,
	APP_MOTION_GO_AROUND_LISTENER,
	APP_MOTION_APPEAR_AT_RANDOM,
} AppSourceMotionPattern;

/* 3D|WVjOvr[ */
typedef struct App3dPositioningPreviewItemTag {
	CriAtomExCueId cue_id;
	AppSourceMotionPattern motion_pattern;
	const CriChar8 *description;
} App3dPositioningPreviewItem;

/* AvP[V\ */
typedef struct AppTag{
	/* \[XIuWFNg */
	CriAtomExVoicePoolHn voice_pool;
	CriAtomExVoicePoolHn hcamx_voice_pool; /* {CXv[nh(HCA-MXR[fbNp) 	*/
	CriAtomExAcbHn acb_hn;
	CriAtomDbasId dbas_id;

	/* 3D */
	CriAtomExPlayerHn player;			/* Đv[ */
	CriAtomEx3dSourceHn source;			/* IuWFNg */
	CriAtomExVector source_pos;			/* ̈ʒu */
	CriAtomExVector source_velocity;	/* ̑x */

	/* Xi[ */
	CriAtomEx3dListenerHn listener;
	CriAtomExVector listener_pos;		/* Xi[̈ʒu */
	CriAtomExVector listener_front;		/* Xi[̌Ă(OxNg) */
	CriAtomExVector listener_top;		/* Xi[̌Ă(xNg) */

	/* 3D|WVjÕvr[CfbNX */
	CriSint32 selecting_preview_index;
	CriSint32 current_preview_index;
} AppObj;

/***************************************************************************
 * ֐`
 * Function definitions
 ***************************************************************************/
static void user_error_callback_func(const CriChar8 *errid, CriUint32 p1, CriUint32 p2, CriUint32 *parray);
void *user_alloc_func(void *obj, CriUint32 size);
void user_free_func(void *obj, void *ptr);

/* AvP[V̎ */
static void app_display_info(AppObj *app_obj);
static CriBool app_atomex_initialize(AppObj *app_obj);
static CriBool app_atomex_finalize(AppObj *app_obj);
static CriBool app_execute_main(AppObj *app_obj);
static CriBool app_atomex_start(AppObj *app_obj);
static CriBool app_atomex_stop(AppObj *app_obj);
static void app_goto_next_preview(AppObj *app_obj);
static void app_goto_prev_preview(AppObj *app_obj);
static void app_reset_source(AppObj *app_obj);
static void app_update_source(AppObj *app_obj);
static void app_atomex_switch_binaural(AppObj* app_obj);

/**************************************************************************
 * ϐ`
 * Variable definitions
 **************************************************************************/

/* 3D Positioning̃vr[Xg */
static App3dPositioningPreviewItem g_preview_list[] = {
	{CRI_3DPOS_HELI_LOOP,		APP_MORTION_CROSS_FRONT_OF_LISTENER,    "Cross front of Listener"},
	{CRI_3DPOS_FOOTSTEP_LOOP,	APP_MOTION_PASS_LISTENER_FRONT_TO_REAR, "Pass Listener from front to rear"},
	{CRI_3DPOS_FOOTSTEP,	APP_MOTION_GO_AROUND_LISTENER,        "Go around Listener"},
	{CRI_3DPOS_BOMB2,			APP_MOTION_APPEAR_AT_RANDOM,          "Appears at random"},
};

/* 2D}bv̏ */
static const CriChar8 g_map_2d_default[MAP_2D_HEIGHT][MAP_2D_WIDTH + 1] = {
	"                    |z                   ", // 0
	"                    |                    ", // 1
	"                    |                    ", // 2
	"                    |                    ", // 3
	"                    |                    ", // 4
	"                    |                    ", // 5
	"                    |                    ", // 6
	"                    |                    ", // 7
	"-------------------(L)-------------------", // 8 _Listener݂
	"                    |                   x", // 9
	"                    |                    ", //10
	"                    |                    ", //11
	"                    |                    ", //12
	"                    |                    ", //13
	"                    |                    ", //14
	"                    |                    ", //15
	"                    |                    ", //16
};

/* ۂɕ`悳2D}bvB3Dx, z̈ړ2D\ */
static CriChar8 g_map_2d[MAP_2D_HEIGHT][MAP_2D_WIDTH + 1];

/***************************************************************************
 * ֐`
 * Function definitions
 ***************************************************************************/

/* TṽGg|Cg */
int main(void)
{
	/* AvP[VIuWFNg̒` */
	AppObj app_obj = {0};
	/* Tvt[[NIuWFNg (EBhEǗEfobO\p) */
	CriSmpFramework *smpfw = NULL;
	/* L[͔pIuWFNg */
	CriSmpInputDevice* idev = NULL;

	/* Tvt[[N̍쐬 */
	smpfw = CriSmpFramework::Create();
	idev = smpfw->GetInputDevice();

	/* AvP[V̏ */
	app_atomex_initialize(&app_obj);

	/* C[v̊Jn */
	for (;;) {
		/* [ŨL[͏XV */
		idev->Update();
		{
			/* 1: ̍ĐJn */
			if ( idev->IsPressed(idev->BUTTON1) ) {
				app_atomex_start(&app_obj);
			}
			/* 2: ̍Đ~ */
			if ( idev->IsPressed(idev->BUTTON2) ) {
				app_atomex_stop(&app_obj);
			}
			/* 3: oCm[ ON/OFF */
			if (idev->IsPressed(idev->BUTTON3)) {
				app_atomex_switch_binaural(&app_obj);
			}
			/* 3: Đ[hOɈڍs */
			if ( idev->IsPressed(idev->BUTTON_UP) ) {
				app_goto_prev_preview(&app_obj);
			}
			/* 4: Đ[hɈڍs */
			if ( idev->IsPressed(idev->BUTTON_DOWN) ) {
				app_goto_next_preview(&app_obj);
			}
		}

		/* AvP[VI (ESCL[EBhEꂽꍇ) */
		if ( idev->IsPressed(idev->BUTTON_CANCEL) || smpfw->IsTerninated() == TRUE) {
			break;
		}

		/* AvP[V̍XV */
		if (app_execute_main(&app_obj) != CRI_TRUE) {
			break;
		}

		/* AvP[V̏\ */
		smpfw->BeginDraw();
		app_display_info(&app_obj);
		smpfw->EndDraw();

		/* zV҂(^C}[ɂX[v) */
		smpfw->SyncFrame();
	}

	/* AvP[V̏I */
	app_atomex_finalize(&app_obj);

	/* Tvt[[N̔j */
	smpfw->Destroy(); smpfw = NULL;

	return CRI_OK;
}

static void app_display_info(AppObj *app_obj)
{
	CriSint32 i = 1;
	CriSmpPrintf( 2, i++, "CRI ADX2 LE Sample Program: 3D Positioning");i+=2;

	/* Đ̕\ */
	CriSmpPrintf( 2, i++, "<< 3D Positioning Preview List >>");
	for (CriSint32 n=0; n<sizeof(g_preview_list)/sizeof(App3dPositioningPreviewItem); n++) {
		if (n==app_obj->selecting_preview_index) {
			CriSmpPrintf( 1, i, "*");
		}
		CriSmpPrintf( 3, i, "%d: Cue Name=%s", n, criAtomExAcb_GetCueNameById(app_obj->acb_hn, g_preview_list[n].cue_id));
		CriSmpPrintf(27, i, "Motion Type=%s", g_preview_list[n].description);
		i++;
	}

	i++;
	CriSmpPrintf( 2, i++, "Current Preview Index : %d", app_obj->current_preview_index);

	i++;
	i++;
	CriSmpPrintf( 2, i++, "<Source Info>");
	CriSmpPrintf( 2, i++, "  Motion Type  : %s", g_preview_list[app_obj->current_preview_index].description);
	CriSmpPrintf( 2, i++, "  Position     : (%7.2f, %7.2f, %7.2f)", app_obj->source_pos.x, app_obj->source_pos.y, app_obj->source_pos.z);
	CriSmpPrintf( 2, i++, "  Velocity     : (%7.2f, %7.2f, %7.2f)", app_obj->source_velocity.x, app_obj->source_velocity.y, app_obj->source_velocity.z);

	/* L[͏̕\ */
	i=25;
	CriSmpPrintf( 2, i++, "1       key: Start");
	CriSmpPrintf( 2, i++, "2       key: Stop");
	CriSmpPrintf( 2, i++, "3       key: Switch Binaural");
	CriSmpPrintf( 2, i++, "UP/DOWN Key: Select Preview Index");
	CriSmpPrintf( 2, i++, "ESC     key: EXIT");

	/* 3D̈ʒu2D}bvɕ`悷 */
	CriSint32 mapped_source_pos_x		= (CriSint32)((app_obj->source_pos.x + SOURCE_POS_MAX) * X_POS_SCALE_VAL);
	CriSint32 mapped_source_pos_z		= (MAP_2D_HEIGHT-1) - (CriSint32)((app_obj->source_pos.z + SOURCE_POS_MAX) * Z_POS_SCALE_VAL);
	memcpy(g_map_2d, g_map_2d_default, MAP_2D_HEIGHT * (MAP_2D_WIDTH + 1));	/* }bṽKCh */
	for (int i=0; i<MAP_2D_HEIGHT; i++) {
		if (i == mapped_source_pos_z) {
			g_map_2d[i][mapped_source_pos_x] = 'S';
		}
		CriSmpPrintf(X_POS_OFFSET_FOR_MAP_DRAW, i + Z_POS_OFFSET_FOR_MAP_DRAW, "%s", g_map_2d[i]);
	}
	CriSmpPrintf(90, i-5 , "(L:Listener)"); i++;
	CriSmpPrintf(90, i-5 , "(S:Source )");
}

static CriBool app_atomex_initialize(AppObj *app_obj)
{
	/* AvP[V̏lݒ */
	app_obj->selecting_preview_index = 0;
	app_obj->current_preview_index = 0;

	/* ̏ʒuݒ(̎_ł͂܂ۂɔfĂȂ) */
	app_obj->source_pos.x	 = 0.0f;	app_obj->source_pos.y	 = 0.0f;	app_obj->source_pos.z	 = 20.0f;

	/* Xi[̏ʒuݒ(̎_ł͂܂ۂɔfĂȂ) */
	app_obj->listener_pos.x	 = 0.0f;	app_obj->listener_pos.y	 = 0.0f;	app_obj->listener_pos.z	 = 0.0f;
	app_obj->listener_front.x = 0.0f;	app_obj->listener_front.y = 0.0f;	app_obj->listener_front.z = 1.0f;
	app_obj->listener_top.x	 = 0.0f;	app_obj->listener_top.y	 = 1.0f;	app_obj->listener_top.z	 = 0.0f;

	/* G[R[obN֐̓o^ */
	criErr_SetCallback(user_error_callback_func);

	/* AP[^̓o^ */
	criAtomEx_SetUserAllocator(user_alloc_func, user_free_func, NULL);

	/* Sound xR C^[tF[X̓o^ */
	criAtomExAsr_RegisterSoundxRInterface(criSoundxR_GetInterface());

	/* Cȕݒiő{CXύXj */
	CriAtomExConfig_WASAPI lib_config;
	CriFsConfig fs_config;
	criAtomEx_SetDefaultConfig_WASAPI(&lib_config);
	criFs_SetDefaultConfig(&fs_config);
	lib_config.atom_ex.max_virtual_voices = MAX_VIRTUAL_VOICE;
	lib_config.hca_mx.output_sampling_rate = HCAMX_SAMPLING_RATE;
	fs_config.num_loaders = MAX_CRIFS_LOADER;
	lib_config.atom_ex.fs_config = &fs_config;
	criAtomEx_Initialize_WASAPI(&lib_config, NULL, 0);

	/* D-Bas̍쐬iőXg[͂Ō܂܂j */
	app_obj->dbas_id = criAtomDbas_Create(NULL, NULL, 0);

	#if defined(USE_INGAME_PREVIEW)
		CriAtomExAsrBusAnalyzerConfig analyze_config;
		CriSint32 bus_no;
		/* CQ[vr[p̃j^Cu */
		criAtomExMonitor_Initialize(NULL, NULL, 0);
		/* x@\ǉ */
		criAtomExAsr_SetDefaultConfigForBusAnalyzer(&analyze_config);
		for ( bus_no=0;bus_no<8;bus_no++) {
			criAtomExAsr_AttachBusAnalyzer(bus_no, &analyze_config);
		}
	#endif

	/* ACFt@C̓ǂݍ݂Ɠo^ */
	criAtomEx_RegisterAcfFile(NULL, PATH ACF_FILE, NULL, 0);
	
	/* DSPݒ̃A^b` */
	criAtomEx_AttachDspBusSetting(CRI_ADX2_SAMPLES_ACF_DSPSETTING_DSPBUSSETTING_0, NULL, 0);

	/* {CXv[̍쐬iő{CXύX^ősb`ύX^Xg[ĐΉj */
	CriAtomExStandardVoicePoolConfig vpool_config;
	criAtomExVoicePool_SetDefaultConfigForStandardVoicePool(&vpool_config);
	vpool_config.num_voices							= MAX_STANDARD_VOICE;
	vpool_config.player_config.max_sampling_rate	= MAX_SAMPLING_RATE;
	vpool_config.player_config.streaming_flag		= CRI_TRUE;
	app_obj->voice_pool = criAtomExVoicePool_AllocateStandardVoicePool(&vpool_config, NULL, 0);

	/* HCA-MXĐp̃{CXv[쐬 */
	CriAtomExHcaMxVoicePoolConfig hcamx_config;
	criAtomExVoicePool_SetDefaultConfigForHcaMxVoicePool(&hcamx_config);
	hcamx_config.num_voices							= MAX_HCAMX_VOICE;
	hcamx_config.player_config.max_sampling_rate	= HCAMX_SAMPLING_RATE;
	hcamx_config.player_config.streaming_flag		= CRI_TRUE;
	app_obj->hcamx_voice_pool = criAtomExVoicePool_AllocateHcaMxVoicePool(&hcamx_config, NULL, 0);

	/* ACBt@Cǂݍ݁AACBnh쐬 */
	app_obj->acb_hn = criAtomExAcb_LoadAcbFile(NULL, PATH ACB_FILE, NULL, NULL, NULL, 0);

	/* v[̍쐬 */
	app_obj->player = criAtomExPlayer_Create(NULL, NULL, 0);

	/* 3DXi[nh3Dnh쐬 */
	app_obj->listener = criAtomEx3dListener_Create(NULL, NULL, 0);
	app_obj->source = criAtomEx3dSource_Create(NULL, NULL, 0);

	/* v[ɃXi[Ɖ̃nho^ */
	criAtomExPlayer_Set3dListenerHn(app_obj->player, app_obj->listener);
	criAtomExPlayer_Set3dSourceHn(app_obj->player, app_obj->source);

	/* Xi[̈ʒu̐ݒ */
	criAtomEx3dListener_SetPosition(app_obj->listener, &(app_obj->listener_pos)); 

	/* Xi[̌̐ݒ */
	criAtomEx3dListener_SetOrientation(app_obj->listener, &(app_obj->listener_front), &(app_obj->listener_top));

	/* Xi[̃p[^ۂɔf */
	criAtomEx3dListener_Update(app_obj->listener);

	/* ̈ʒu̐ݒ聕f */	
	criAtomEx3dSource_SetPosition(app_obj->source, &(app_obj->source_pos));

	/* ̃p[^ۂɔf */
	criAtomEx3dSource_Update(app_obj->source);

	return CRI_TRUE;
}

static CriBool app_atomex_finalize(AppObj *app_obj)
{
	/* DSP̃f^b` */
	criAtomEx_DetachDspBusSetting();

	/* v[nh̔j */
	criAtomExPlayer_Destroy(app_obj->player);
	
	/* {CXv[̔j */
	criAtomExVoicePool_Free(app_obj->voice_pool);
	criAtomExVoicePool_Free(app_obj->hcamx_voice_pool);

	/* ACBnh̔j */
	criAtomExAcb_Release(app_obj->acb_hn);

	/* ACF̓o^ */
	criAtomEx_UnregisterAcf();

	#if defined(USE_INGAME_PREVIEW)
		/* CQ[vr[֘A@\̏I */
		CriSint32 bus_no;
		for ( bus_no=0;bus_no<8;bus_no++) {
			criAtomExAsr_DetachBusAnalyzer(bus_no);
		}
		criAtomExMonitor_Finalize();
	#endif

	/* D-BAS̔j */
	criAtomDbas_Destroy(app_obj->dbas_id);

	/* CȕI */
	criAtomEx_Finalize_WASAPI();

	return CRI_TRUE;
}

CriBool app_execute_main(AppObj *app_obj)
{
	CriAtomExPlayerStatus player_status;

	/* T[o̎s */
	criAtomEx_ExecuteMain();

#if defined(USE_INGAME_PREVIEW)
	/* oX͏̎擾 */
	CriAtomExAsrBusAnalyzerInfo analyze_info;
	CriSint32 bus_no;
	for ( bus_no=0;bus_no<8;bus_no++) {
		criAtomExAsr_GetBusAnalyzerInfo(bus_no, &analyze_info);
	}
#endif

	/* Exv[̃Xe[^XmF */
	player_status = criAtomExPlayer_GetStatus(app_obj->player);

	/* ĐG[ɂȂꍇ̓AvP[VI */
	if (player_status == CRIATOMEXPLAYER_STATUS_ERROR) {
		return CRI_FALSE;		
	}
		
	/* ̈ʒu̍XV */
	if (player_status == CRIATOMEXPLAYER_STATUS_PLAYING) {
		app_update_source(app_obj);
	}
	
	return CRI_TRUE;
}

static CriBool app_atomex_start(AppObj *app_obj)
{
	/* Ỏ~ */
	//criAtomExPlayer_Stop(app_obj->player);
	criAtomExPlayer_StopWithoutReleaseTime(app_obj->player);

	/* L[ID̎w */
	criAtomExPlayer_SetCueId(app_obj->player, app_obj->acb_hn, g_preview_list[app_obj->selecting_preview_index].cue_id);

	/* Đ̊Jn */
	criAtomExPlayer_Start(app_obj->player);
	
	/* ړp^[ύXĉʒuɒu */
	app_obj->current_preview_index = app_obj->selecting_preview_index;
	app_reset_source(app_obj);

	return CRI_TRUE;
}

static CriBool app_atomex_stop(AppObj *app_obj)
{
	criAtomExPlayer_Stop(app_obj->player);
	app_reset_source(app_obj);

	return CRI_TRUE;
}

void app_reset_source(AppObj *app_obj)
{
	/* ̏ʒuݒ */
	switch (g_preview_list[app_obj->current_preview_index].motion_pattern) {
		case	APP_MORTION_CROSS_FRONT_OF_LISTENER:
			app_obj->source_pos.x	 =-100.0f;		app_obj->source_pos.y	 = 0.0f;		app_obj->source_pos.z	 = 40.0f;
			app_obj->source_velocity.x=0.25f;		app_obj->source_velocity.y= 0.0f;		app_obj->source_velocity.z= 0.0f;
			break;
		case	APP_MOTION_PASS_LISTENER_FRONT_TO_REAR:
			app_obj->source_pos.x	 =   0.0f;		app_obj->source_pos.y	 = 0.0f;		app_obj->source_pos.z	 =100.0f;
			app_obj->source_velocity.x=   0.0f;		app_obj->source_velocity.y= 0.0f;		app_obj->source_velocity.z= -0.25f;
			break;
		case	APP_MOTION_GO_AROUND_LISTENER:
			app_obj->source_pos.x	 =50.0f;		app_obj->source_pos.y	 = 0.0f;		app_obj->source_pos.z	 = 0.0f;
			app_obj->source_velocity.x=0.0f;			app_obj->source_velocity.y= 0.0f;		app_obj->source_velocity.z= 1.0f;
			break;
		case	APP_MOTION_APPEAR_AT_RANDOM:				
			app_obj->source_pos.x	 = (CriFloat32)(rand() % (SOURCE_POS_MAX*2) - SOURCE_POS_MAX);
			app_obj->source_pos.y	 = 0.0f;
			app_obj->source_pos.z	 = (CriFloat32)(rand() % (SOURCE_POS_MAX*2) - SOURCE_POS_MAX);
			app_obj->source_velocity.x=   0.0f;		app_obj->source_velocity.y= 0.0f;		app_obj->source_velocity.z= 0.0f;
			break;
		default:
			app_obj->source_pos.x	 =   0.0f;		app_obj->source_pos.y	 = 0.0f;		app_obj->source_pos.z	 =20.0f;
			app_obj->source_velocity.x= 0.0f;		app_obj->source_velocity.y= 0.0f;		app_obj->source_velocity.z= 0.0f;
			break;
	}

	/* Őݒ肵p[^ۂɓo^f */
	criAtomEx3dSource_SetVelocity (app_obj->source, &(app_obj->source_velocity)); 
	criAtomEx3dSource_SetPosition(app_obj->source, &(app_obj->source_pos));
	criAtomEx3dSource_Update(app_obj->source);
	return;
}

void app_update_source(AppObj *app_obj)
{
	switch (g_preview_list[app_obj->current_preview_index].motion_pattern) {
		case	APP_MORTION_CROSS_FRONT_OF_LISTENER:
			/* Xi[̑O؂ */
			if (app_obj->source_pos.x < SOURCE_POS_MAX) {
				app_obj->source_pos.x = app_obj->source_pos.x + app_obj->source_velocity.x;
			} else {
				/* ړ̒[܂ŒH蒅珉ʒuɖ߂ */
				app_reset_source(app_obj);
			}
			break;
		case	APP_MOTION_PASS_LISTENER_FRONT_TO_REAR:
			/* Xi[̐ʂwւƒʂ蔲 */
			if (app_obj->source_pos.z >= SOURCE_POS_MIN) {
				app_obj->source_pos.z = app_obj->source_pos.z + app_obj->source_velocity.z;
			} else {
				app_reset_source(app_obj);
			}
			break;
		case	APP_MOTION_GO_AROUND_LISTENER:
			/* Xi[(_)̎͂ */
			{
				CriFloat32 rr = static_cast<CriFloat32>(pow(app_obj->source_pos.x, 2.0f) + pow(app_obj->source_pos.z, 2.0f));
				CriFloat32 acceleration = GM / rr;
				CriFloat32 r = static_cast<CriFloat32>(sqrt(rr));

				app_obj->source_velocity.x = app_obj->source_velocity.x + (acceleration * app_obj->source_pos.x / r);
				app_obj->source_velocity.z = app_obj->source_velocity.z + (acceleration * app_obj->source_pos.z / r);

				app_obj->source_pos.x = app_obj->source_pos.x + app_obj->source_velocity.x;
				app_obj->source_pos.z = app_obj->source_pos.z + app_obj->source_velocity.z;
			}
			break;
		case APP_MOTION_APPEAR_AT_RANDOM:
			/* ̃[hł͈ړȂBʒu_Ɍ܂邾 */
			break;
		default:
			break;
	}

	/* Őݒ肵p[^ۂɓo^f */
	criAtomEx3dSource_SetVelocity (app_obj->source, &(app_obj->source_velocity)); 
	criAtomEx3dSource_SetPosition(app_obj->source, &(app_obj->source_pos));
	criAtomEx3dSource_Update(app_obj->source);

	return;
}

static void app_atomex_switch_binaural(AppObj* app_obj)
{
	CriBool is_binaural;

	is_binaural = criAtomExAsr_IsEnabledBinauralizer();

	if (is_binaural == CRI_FALSE) {
		is_binaural = CRI_TRUE;
	} else {
		is_binaural = CRI_FALSE;
	}

	criAtomExAsr_EnableBinauralizer(is_binaural);
}

static void app_goto_next_preview(AppObj *app_obj)
{
	CriSint32 max_items = sizeof(g_preview_list)/sizeof(App3dPositioningPreviewItem);

	app_obj->selecting_preview_index++;
	if (app_obj->selecting_preview_index >= max_items) {
		app_obj->selecting_preview_index = 0;
	}
}

static void app_goto_prev_preview(AppObj *app_obj)
{
	CriSint32 max_items = sizeof(g_preview_list)/sizeof(App3dPositioningPreviewItem);

	app_obj->selecting_preview_index--;
	if (app_obj->selecting_preview_index < 0) {
		app_obj->selecting_preview_index = max_items -1;
	}
}


/* G[R[obN֐ */
static void user_error_callback_func(const CriChar8 *errid, CriUint32 p1, CriUint32 p2, CriUint32 *parray)
{
	const CriChar8 *errmsg;

	/* G[̕\ */
	errmsg = criErr_ConvertIdToMessage(errid, p1, p2);
	CriSmpDebugPrintf("%s\n", errmsg);

	return;
}

void *user_alloc_func(void *obj, CriUint32 size)
{
	void *ptr;
	ptr = malloc(size);
	return ptr;
}

void user_free_func(void *obj, void *ptr)
{
	free(ptr);
}
/* --- end of file --- */
