/****************************************************************************
 *
 * CRI Middleware SDK
 *
 * Copyright (c) 2011-2015 CRI Middleware Co., Ltd.
 *
 * Library  : CRI Atom
 * Module   : Library User's Header for Android
 * File     : cri_atom_android.h
 *
 ****************************************************************************/
/*!
 *	\file		cri_atom_android.h
 */

/* d`h~					*/
/* Prevention of redefinition	*/
#ifndef	CRI_INCL_CRI_ATOM_ANDROID_H
#define	CRI_INCL_CRI_ATOM_ANDROID_H

/***************************************************************************
 *      CN[ht@C
 *      Include files
 ***************************************************************************/
#include <jni.h>
#include <cri_le_xpt.h>
#include <cri_le_error.h>
#include <cri_le_atom.h>
#include <cri_le_atom_ex.h>
#include <cri_le_atom_asr.h>

/***************************************************************************
 *      萔}N
 *      Macro Constants
 ***************************************************************************/
/*JP
 * \brief Stream Type ID
 * \ingroup ATOMLIB_Android
 * o͐̃Xg[^Cvݒ肷lłB<br>
 */
typedef enum {
    CRIATOMANDROID_STREAM_TYPE_MUSIC,
    CRIATOMANDROID_STREAM_TYPE_ALARM,
    CRIATOMANDROID_STREAM_TYPE_DTMF ,
    CRIATOMANDROID_STREAM_TYPE_NOTIFICATION,
    CRIATOMANDROID_STREAM_TYPE_RING,
    CRIATOMANDROID_STREAM_TYPE_SYSTEM,
    CRIATOMANDROID_STREAM_TYPE_VOICE_CALL,
	CRIATOMANDROID_STREAM_TYPE_ENUM_SIZE_IS_4BYTES = 0x7FFFFFFF
} CriAtomAndroidStreamType;

/*==========================================================================
 *      CRI Atom API
 *=========================================================================*/
/*JP
 * \brief CupRtBO\̂ɃftHglZbg
 * \ingroup ATOMLIB_Android
 * \param[out]	p_config	pRtBO\̂ւ̃|C^
 * \par :
 * ::criAtom_Initialize_ANDROID ֐ɐݒ肷RtBO\
 * i ::CriAtomConfig_ANDROID jɁAftHg̒lZbg܂B<br>
 * \attention
 * {}N͉ʃCAPIłB<br>
 * AtomExC̋@\𗘗pۂɂ́A{}N̑
 * ::criAtomEx_SetDefaultConfig_ANDROID }NpB
 * \sa CriAtomConfig_ANDROID
 */
#define criAtom_SetDefaultConfig_ANDROID(p_config)			\
{															\
	(p_config)->initialize_hca_mx = CRI_TRUE;				\
	criAtom_SetDefaultConfig(&(p_config)->atom);			\
	criAtomHcaMx_SetDefaultConfig(&(p_config)->hca_mx);		\
}

/*==========================================================================
 *      CRI AtomEx API
 *=========================================================================*/
/*JP
 * \brief CupRtBO\̂ɃftHglZbg
 * \ingroup ATOMLIB_Android
 * \param[out]	p_config	pRtBO\̂ւ̃|C^
 * \par :
 * ::criAtomEx_Initialize_ANDROID ֐ɐݒ肷RtBO\
 * i ::CriAtomExConfig_ANDROID jɁAftHg̒lZbg܂B<br>
 * \sa CriAtomExConfig_ANDROID
 */
#define criAtomEx_SetDefaultConfig_ANDROID(p_config)		\
{															\
	(p_config)->initialize_hca_mx = CRI_TRUE;				\
	criAtomEx_SetDefaultConfig(&(p_config)->atom_ex);		\
	criAtomExAsr_SetDefaultConfig(&(p_config)->asr);		\
	criAtomExHcaMx_SetDefaultConfig(&(p_config)->hca_mx);	\
}

/***************************************************************************
 *      }N
 *      Macro Functions
 ***************************************************************************/

/***************************************************************************
 *      f[^^錾
 *      Data Type Declarations
 ***************************************************************************/
/*==========================================================================
 *      CRI Atom API
 *=========================================================================*/
/*JP
 * \brief AtomCupRtBO\
 * \ingroup ATOMLIB_Android
 * CRI AtomCu̓dlw肷邽߂̍\̂łB<br>
 * ::criAtom_Initialize_ANDROID ֐̈Ɏw肵܂B<br>
 * \attention
 * {\͉̂ʃCAPIłB<br>
 * AtomExC̋@\𗘗pۂɂ́A{\̂̑
 * ::CriAtomExConfig_ANDROID \̂pB
 * \sa criAtom_Initialize_ANDROID, criAtom_SetDefaultConfig_ANDROID
 */
typedef struct {
	CriBool					initialize_hca_mx;	/*JP< HCA-MX邩ǂ		*/
	CriAtomConfig			atom;				/*JP< AtompRtBO\		*/
	CriAtomAsrConfig		asr;				/*JP< ASRpRtBO				*/
	CriAtomHcaMxConfig		hca_mx;				/*JP< HCA-MXpRtBO\	*/
} CriAtomConfig_ANDROID;

/*==========================================================================
 *      CRI AtomEx API
 *=========================================================================*/
/*JP
 * \brief AtomCupRtBO\
 * \ingroup ATOMLIB_Android
 * CRI AtomCu̓dlw肷邽߂̍\̂łB<br>
 * ::criAtomEx_Initialize_ANDROID ֐̈Ɏw肵܂B<br>
 * \sa criAtomEx_Initialize_ANDROID, criAtomEx_SetDefaultConfig_ANDROID
 */
typedef struct {
	CriBool					initialize_hca_mx;	/*JP< HCA-MX邩ǂ		*/
	CriAtomExConfig			atom_ex;			/*JP< AtomExpRtBO\	*/
	CriAtomExAsrConfig		asr;				/*JP< ASRpRtBO				*/
	CriAtomExHcaMxConfig	hca_mx;				/*JP< HCA-MXpRtBO\	*/
} CriAtomExConfig_ANDROID;

/*JP
 * \brief x ԗ񋓌^
 * \ingroup ATOMLIB_Android
 * x̏Ԃ\񋓌^łB <br>
 */
typedef enum CriAtomExLatencyEstimatorStatus_Tag {
	CRIATOM_LATENCYESTIMATOR_STATUS_STOP,			/* /~	(sXbhȂ) */
	CRIATOM_LATENCYESTIMATOR_STATUS_PROCESSING,		/* xԂ𐄑		(sXbh) */
	CRIATOM_LATENCYESTIMATOR_STATUS_DONE,			/* xԂ̐	(sXbhȂ) */
	CRIATOM_LATENCYESTIMATOR_STATUS_ERROR,			/* G[				(sXbhȂ) */
	CRIATOM_LATENCYESTIMATOR_STATUS_ENUM_SIZE_IS_4BYTES = 0x7FFFFFFF
} CriAtomLatencyEstimatorStatus;

/*JP
 * \brief x \
 * \ingroup ATOMLIB_Android
 * x̏\\̂łB<br>
 * x̏ԂƁAx(~b)܂B
 */
typedef struct CriAtomExLatencyEstimatorInfo_Tag {
	CriAtomLatencyEstimatorStatus	status;
	CriUint32						latency_msec; // ُl0
} CriAtomLatencyEstimatorInfo;

/***************************************************************************
 *      ϐ錾
 *      Prototype Variables
 ***************************************************************************/

/***************************************************************************
 *      ֐錾
 *      Prototype Functions
 ***************************************************************************/
#ifdef __cplusplus
extern "C" {
#endif

/*==========================================================================
 *      CRI Atom API
 *=========================================================================*/
/*JP
 * \brief Cup[N̈TCY̌vZ
 * \ingroup ATOMLIB_Android
 * \param[in]	config		pRtBO\
 * \return		CriSint32	[N̈TCY
 * \par :
 * Cugp邽߂ɕKvȁA[N̈̃TCY擾܂B<br>
 * \par l:
 * CuKvƂ郏[N̈̃TCÝACupRtBO
 * \́i ::CriAtomConfig_ANDROID j̓eɂĕω܂B<br>
 * <br>
 *  config ̏́A֐ł̂ݎQƂ܂B<br>
 * ֐𔲂͎QƂ܂̂ŁA֐s config ̗̈Ă
 * 肠܂B
 * \attention
 * {֐͉ʃCAPIłB<br>
 * AtomExC̋@\𗘗pۂɂ́A{֐̑
 * ::criAtomEx_CalculateWorkSize_ANDROID ֐pB
 * \sa CriAtomConfig_ANDROID, criAtom_Initialize_ANDROID
 */
CriSint32 CRIAPI criAtom_CalculateWorkSize_ANDROID(const CriAtomConfig_ANDROID *config);

/*JP
 * \brief Cȕ
 * \ingroup ATOMLIB_Android
 * \param[in]	config		pRtBO\
 * \param[in]	work		[N̈
 * \param[in]	work_size	[N̈TCY
 * \par :
 * Cu܂B<br>
 * Cű@\𗘗pɂ́AK̊֐sKv܂B<br>
 * iCű@\́A{֐sA ::criAtom_Finalize_ANDROID ֐s܂ł̊ԁA
 * p\łBj<br>
 * <br>
 * Cuۂɂ́ACuŗp邽߂̃̈i[N̈j
 * mۂKv܂B<br>
 * CuKvƂ郏[N̈̃TCÝApRtBO\̂̓eɉ
 * ω܂B<br>
 * [N̈TCY̌vZɂ́A ::criAtom_CalculateWorkSize_ANDROID
 * ֐gpĂB<br>
 * \par l:
 * ::criAtom_SetUserAllocator }NgpăAP[^o^ς݂̏ꍇA
 * {֐Ƀ[N̈w肷Kv͂܂B<br>
 * i work  NULL A work_size  0 w肷邱ƂŁAo^ς݂̃AP[^
 * Kvȃ[N̈TCỸIɊmۂ܂Bj
 * <br>
 *  config ̏́A֐ł̂ݎQƂ܂B<br>
 * ֐𔲂͎QƂ܂̂ŁA֐s config ̗̈Ă
 * 肠܂B
 * \attention
 * {֐͓IɈȉ̊֐s܂B<br>
 * 	- ::criAtom_Initialize
 * 	- ::criAtomAsr_Initialize
 * 	- ::criAtomHcaMx_Initialize
 * 	.
 * {֐sꍇAL֐sȂłB<br>
 * <br>
 * {֐sAK΂ɂȂ ::criAtom_Finalize_ANDROID ֐sĂB<br>
 * ܂A ::criAtom_Finalize_ANDROID ֐s܂ł́A{֐ēxsȂłB<br>
 * <br>
 * {֐͉ʃCAPIłB<br>
 * AtomExC̋@\𗘗pۂɂ́A{֐̑
 * ::criAtomEx_Initialize_ANDROID ֐pB
 * \sa CriAtomConfig_ANDROID, criAtom_Finalize_ANDROID,
 * criAtom_SetUserAllocator, criAtom_CalculateWorkSize_ANDROID
 */
void CRIAPI criAtom_Initialize_ANDROID(
	const CriAtomConfig_ANDROID *config, void *work, CriSint32 work_size);

/*JP
 * \brief CȕI
 * \ingroup ATOMLIB_Android
 * \par :
 * CuI܂B<br>
 * \attention
 * {֐͓IɈȉ̊֐s܂B<br>
 * 	- ::criAtom_Finalize
 * 	- ::criAtomAsr_Finalize
 * 	- ::criAtomHcaMx_Finalize
 * 	.
 * {֐sꍇAL֐sȂłB<br>
 * <br>
 * ::criAtom_Initialize_ANDROID ֐sOɖ{֐s邱Ƃ͂ł܂B<br>
 * <br>
 * {֐͉ʃCAPIłB<br>
 * AtomExC̋@\𗘗pۂɂ́A{֐̑
 * ::criAtomEx_Finalize_ANDROID ֐pB
 * \sa criAtom_Initialize_ANDROID
 */
void CRIAPI criAtom_Finalize_ANDROID(void);

/*JP
 * \brief T[oXbh̃vCIeBύX
 * \ingroup ATOMLIB_Android
 * \param[in]	prio	XbhvCIeB
 * \par :
 * T[oiCu̓jsXbh̃vCIeBύX܂B<br>
 * ftHgԁi{֐sȂꍇjł́AT[oXbh̃vCIeB
 * -19(iCXl) ɐݒ肳܂B<br>
 * \attention:
 * {֐́ACuɃXbhf}`Xbhf
 * i ::CRIATOM_THREAD_MODEL_MULTI jɐݒ肵ꍇɂ̂݌ʂ𔭊܂B<br>
 * ̃XbhfIꍇA{֐͉s܂B<br>
 * iG[R[obN܂Bj<br>
 * <br>
 * {֐͏`IO̊ԂɎsKv܂B<br>
 * OIɖ{֐sĂAʂ͂܂B<br>
 * iG[R[obN܂Bj<br>
 * <br>
 * T[oXbh́ACRI File SystemCułpĂ܂B<br>
 * łCRI File SystemCuAPIŃT[oXbh̐ݒύXĂꍇ
 * {֐ɂݒ肪㏑܂̂łӂB<br>
 * \sa criAtom_Initialize_ANDROID, criAtom_GetThreadPriority_ANDROID
 */
void CRIAPI criAtom_SetThreadPriority_ANDROID(int prio);

/*JP
 * \brief T[oXbh̃vCIeB擾
 * \ingroup ATOMLIB_Android
 * \return	int		XbhvCIeB
 * \par :
 * T[oiCu̓jsXbh̃vCIeB擾܂B<br>
 * 擾ɐƁA{֐̓T[osXbh̃vCIeB(iCXl)Ԃ܂B<br>
 * \attention:
 * {֐́ACuɃXbhf}`Xbhf
 * i ::CRIATOM_THREAD_MODEL_MULTI jɐݒ肵ꍇɂ̂݌ʂ𔭊܂B<br>
 * ̃XbhfIꍇA{֐̓G[lԂ܂B<br>
 * iG[R[obN܂Bj<br>
 * <br>
 * {֐͏`IO̊ԂɎsKv܂B<br>
 * OIɖ{֐sꍇA{֐̓G[lԂ܂B<br>
 * iG[R[obN܂Bj<br>
 * \sa criAtom_Initialize_ANDROID, criAtom_SetThreadPriority_ANDROID
 */
int CRIAPI criAtom_GetThreadPriority_ANDROID(void);

/*JP
 * \brief JavaVMIuWFNg̐ݒ
 * \ingroup ATOMLIB_Android
 * \return	JavaVM*		JavaVMIuWFNg
 * \par :
 * JavaVMIuWFNgAtomCuɓo^܂B<br>
 * Android OS 2.3OOST|[gꍇ́A{֐KgpAJavaVMIuWFNgo^ĂB<br>
 * Android OS 2.3ȍ~OŜ݂ΏۂƂꍇ́A{֐ĂяoȂĂ삵܂B<br>
 * \attention:
 * JavaVMIuWFNgo^ꍇACuō쐬XbhJavaVMɃA^b`܂B<br>
 *
 * <br>
 * {֐̓CuOɎsKv܂B<br>
 * \sa criAtom_Initialize_ANDROID
 */
void CRIAPI criAtom_SetJavaVM_ANDROID(JavaVM* vm);

/*JP
 * \brief o͐Xg[^Cv̐ݒ
 * \ingroup ATOMLIB_Android
 * \return
 * \par :
 * o͐Xg[^Cvݒ肵܂B<br>
 * <br>
 * {֐̓CuOɎsKv܂B<br>
 * \sa criAtomEx_Initialize_ANDROID
 */
void CRIAPI criAtom_SetOutputStreamType(CriAtomAndroidStreamType type);

/*JP
 * \brief ĐJnobt@OԂ̐ݒ
 * \ingroup ATOMLIB_Android
 * \param[in]	time	ĐJnobt@Oԁi~bPʁj
 * \par :
 * AtomCuŉĐJnɃobt@O鎞ԁi~bPʁjw肵܂B<br>
 * 0 w肵ꍇAftHgTCYŃobt@O܂B<br>
 * {֐̐ݒlNSRilCeBuTEh_j[hł̍ĐJnCeVɉe܂B<br>
 * i傫lݒ肵Ă܂Ƃ̕AĐJnCeV傫Ȃ邱ƂɂȂ܂j<br>
 * \par l:
 * ftHgł3V̍ĐJnobt@OԂݒ肵Ă܂B
 * iT[og̐ݒ肪60[fps]F16.6[ms]̏ꍇA3V͖50[ms]̍ĐJnobt@OԂɂȂ܂j<br>
 * <br>
 * Android[ɂĂ͍ĐJnobt@OԂȂƃmCYɂȂĂ܂ꍇ܂B
 * ̏ꍇ͖{֐Œ邱ƂŉP鎖܂B
 * \sa criAtom_SetSoundBufferingTime_ANDROID
 */
void CRIAPI criAtom_SetSoundStartBufferingTime_ANDROID(CriSint32 time);

/*JP
 * \brief TEhfR[hobt@ʂ̐ݒi~bPʁj
 * \ingroup ATOMLIB_Android
 * \param[in]	time	TEhfR[hobt@ʁi~bPʁj
 * \par :
 * AtomCuŉĐŎgpfR[hobt@ʁi~bPʁjw肵܂B<br>
 * 0 w肵ꍇAftHgTCỸTEhfR[hobt@ʂݒ肵܂B<br>
 * {֐̐ݒlASRiAtomTEh_j[hł̍ĐJnCeVɉe܂B<br>
 * i傫lݒ肵Ă܂Ƃ̕AĐJnCeV傫Ȃ邱ƂɂȂ܂j<br>
 * \par l:
 * ftHgł4ṼfR[hobt@ʂݒ肵܂B
 * iT[og̐ݒ肪60[fps]F16.6[ms]̏ꍇA4V͖66[ms]̃TEhfR[hobt@ʂɂȂ܂j<br>
 * <br>
 * Android[ɂĂ̓TEhfR[hobt@ʂȂƃmCYɂȂĂ܂ꍇ܂B
 * ̏ꍇ͖{֐Œ邱ƂŉP鎖܂B
 * \attention
 * {֐͏OɎsĂKv܂B<br>
 * \sa criAtom_SetSoundStartBufferingTime_ANDROID
 */
void CRIAPI criAtom_SetSoundBufferingTime_ANDROID(CriSint32 time);

/*JP
 * \brief TEhobt@TCY̐ݒ
 * \ingroup ATOMLIB_Android
 * \param[in]	num_samples	TEhobt@TCYiTvPʁj
 * \par :
 * {֐͌݊̂߂ɎcĂ܂B
 * CRI Atom Ver.1.30.02ȍ~criAtom_SetSoundBufferingTime_ANDROID֐
 * gpăTEhobt@TCY𒲐ĉB
 * ͌݊̂߂ɋ֐ƂĎcĂ܂B
 * <br>
 * AtomCuŃ{CXɃL[COTv̍őlw肵܂B<br>
 * TEhobt@̃TCY̓TvPʂŎw肵܂B<br>
 * <br>
 * TEhobt@TCY 0 w肵ꍇA
 * ftHgTCYŃTEhobt@쐬܂B<br>
 * \sa criAtom_SetSoundBufferingTime_ANDROID
 */
void CRIAPI criAtom_SetSoundBufferSize_ANDROID(CriSint32 num_samples);

/*JP
 * \brief [ŗLvpeB̓Kp
 * \ingroup ATOMLIB_Android
 * \param[in]	vm		JavaVMIuWFNg̎Q
 * \param[in]	context		android.content.Context IuWFNg
 * \return		CriBool	vpeB̓Kpɐ
 * \par :
 * o̓TvO[gȂǁA[ŗL̃vpeBCu̓ɓKp܂B<br>
 * CRI_TRUE ԂꍇAKpɐĂ܂B<br>
 * CRI_FALSE ԂꍇAAPI LevelႢȂǂ̗Rɂ莸sĂAftHg̐ݒ
 * 삵܂B<br>
 * \par l:
 * NSRilCeBuTEh_j[h𗘗pĉo͂sꍇA[Android OS
 * o[WɂAĐׂ̕傷邱Ƃ܂B<br>
 * {֐̌ĂяoɂAOpenSL ES̃CŒ[̃TvO[gɉs
 * 悤ɂȂAĐׂጸ邱Ƃ\łB>
 * \attention
 * {֐͏OɎsĂKv܂B<br>
 * \sa criAtomEx_Initialize_ANDROID
 */
CriBool CRIAPI criAtom_ApplyHardwareProperties_ANDROID(JavaVM* vm, jobject context);

/*==========================================================================
 *      CRI AtomEx API
 *=========================================================================*/
/*JP
 * \brief Cup[N̈TCY̌vZ
 * \ingroup ATOMLIB_Android
 * \param[in]	config		pRtBO\
 * \return		CriSint32	[N̈TCY
 * \par :
 * Cugp邽߂ɕKvȁA[N̈̃TCY擾܂B<br>
 * \par l:
 * CuKvƂ郏[N̈̃TCÝACupRtBO
 * \́i ::CriAtomExConfig_ANDROID j̓eɂĕω܂B<br>
 * <br>
 *  config ̏́A֐ł̂ݎQƂ܂B<br>
 * ֐𔲂͎QƂ܂̂ŁA֐s config ̗̈Ă
 * 肠܂B
 * \attention
 * ::CriAtomExConfig_ANDROID \̂acf_infooɒlݒ肵ĂꍇA{֐͎s-1Ԃ܂B<br>
 * ACFf[^̓o^sꍇ́A{֐lgpmۂł͂ȂADXVXeɂ
 * AP[^gpmۏKvɂȂ܂B
 * \sa CriAtomExConfig_ANDROID, criAtomEx_Initialize_ANDROID
 */
CriSint32 CRIAPI criAtomEx_CalculateWorkSize_ANDROID(const CriAtomExConfig_ANDROID *config);

/*JP
 * \brief Cȕ
 * \ingroup ATOMLIB_Android
 * \param[in]	config		pRtBO\
 * \param[in]	work		[N̈
 * \param[in]	work_size	[N̈TCY
 * \par :
 * Cu܂B<br>
 * Cű@\𗘗pɂ́AK̊֐sKv܂B<br>
 * iCű@\́A{֐sA ::criAtomEx_Finalize_ANDROID ֐s܂ł̊ԁA
 * p\łBj<br>
 * <br>
 * Cuۂɂ́ACuŗp邽߂̃̈i[N̈j
 * mۂKv܂B<br>
 * CuKvƂ郏[N̈̃TCÝApRtBO\̂̓eɉ
 * ω܂B<br>
 * [N̈TCY̌vZɂ́A ::criAtomEx_CalculateWorkSize_ANDROID
 * ֐gpĂB<br>
 * \par l:
 * ::criAtomEx_SetUserAllocator }NgpăAP[^o^ς݂̏ꍇA
 * {֐Ƀ[N̈w肷Kv͂܂B<br>
 * i work  NULL A work_size  0 w肷邱ƂŁAo^ς݂̃AP[^
 * Kvȃ[N̈TCỸIɊmۂ܂Bj
 * <br>
 *  config ̏́A֐ł̂ݎQƂ܂B<br>
 * ֐𔲂͎QƂ܂̂ŁA֐s config ̗̈Ă
 * 肠܂B
 * \attention
 * {֐͓IɈȉ̊֐s܂B<br>
 * 	- ::criAtomEx_Initialize
 * 	- ::criAtomExAsr_Initialize
 * 	- ::criAtomExHcaMx_Initialize
 * 	.
 * {֐sꍇAL֐sȂłB<br>
 * <br>
 * {֐sAK΂ɂȂ ::criAtomEx_Finalize_ANDROID ֐sĂB<br>
 * ܂A ::criAtomEx_Finalize_ANDROID ֐s܂ł́A{֐ēxsȂłB<br>
 * \sa CriAtomExConfig_ANDROID, criAtomEx_Finalize_ANDROID,
 * criAtomEx_SetUserAllocator, criAtomEx_CalculateWorkSize_ANDROID
 */
void CRIAPI criAtomEx_Initialize_ANDROID(
	const CriAtomExConfig_ANDROID *config, void *work, CriSint32 work_size);

/*JP
 * \brief CȕI
 * \ingroup ATOMLIB_Android
 * \par :
 * CuI܂B<br>
 * \attention
 * {֐͓IɈȉ̊֐s܂B<br>
 * 	- ::criAtomEx_Finalize
 * 	- ::criAtomExAsr_Finalize
 * 	- ::criAtomExHcaMx_Finalize
 * 	.
 * {֐sꍇAL֐sȂłB<br>
 * <br>
 * ::criAtomEx_Initialize_ANDROID ֐sOɖ{֐s邱Ƃ͂ł܂B<br>
 * \sa criAtomEx_Initialize_ANDROID
 */
void CRIAPI criAtomEx_Finalize_ANDROID(void);

/*JP
 * \brief TEh̍ĊJ
 * \ingroup ATOMLIB_Android
 * \par :
 * {֐łAtomT[oXbh̃bNԂ܂B<br>
 * ܂AASR̒~܂B<br>
 * {֐̓ۏ؂̂߁AĂяȏOɂ͕KcriAtom_StopSound_ANDROID֐<br>
 * Ă΂邱ƂmFĂB
 * \sa criAtomEx_StartSound_ANDROID
 */
void CRIAPI criAtomEx_StartSound_ANDROID(void);

/*JP
 * \brief TEh̒~
 * \ingroup ATOMLIB_Android
 * \par :
 * {֐łAtomT[oXbhbNԂɂ܂B<br>
 * ܂AASȐ~܂B<br>
 * {֐̓ۏ؂̂߁AĂяǒɂ͕KcriAtom_StartSound_ANDROID֐<br>
 * Ă΂邱ƂmFĂB
 * \sa criAtomEx_StopSound_ANDROID
 */
void CRIAPI criAtomEx_StopSound_ANDROID(void);



/*JP
 * \brief T[oXbh̃vCIeBύX
 * \ingroup ATOMLIB_Android
 * \param[in]	prio	XbhvCIeB
 * \par :
 * T[oiCu̓jsXbh̃vCIeBύX܂B<br>
 * ftHgԁi{֐sȂꍇjł́AT[oXbh̃vCIeB
 * -19(iCXl) ɐݒ肳܂B<br>
 * \attention:
 * {֐́ACuɃXbhf}`Xbhf
 * i ::CRIATOM_THREAD_MODEL_MULTI jɐݒ肵ꍇɂ̂݌ʂ𔭊܂B<br>
 * ̃XbhfIꍇA{֐͉s܂B<br>
 * iG[R[obN܂Bj<br>
 * <br>
 * {֐͏`IO̊ԂɎsKv܂B<br>
 * OIɖ{֐sĂAʂ͂܂B<br>
 * iG[R[obN܂Bj<br>
 * <br>
 * T[oXbh́ACRI File SystemCułpĂ܂B<br>
 * łCRI File SystemCuAPIŃT[oXbh̐ݒύXĂꍇ
 * {֐ɂݒ肪㏑܂̂łӂB<br>
 * \sa criAtomEx_Initialize_ANDROID, criAtomEx_GetThreadPriority_ANDROID
 */
#define criAtomEx_SetThreadPriority_ANDROID(prio)	\
	criAtom_SetThreadPriority_ANDROID(prio)

/*JP
 * \brief T[oXbh̃vCIeB擾
 * \ingroup ATOMLIB_Android
 * \return	int		XbhvCIeB
 * \par :
 * T[oiCu̓jsXbh̃vCIeB擾܂B<br>
 * 擾ɐƁA{֐̓T[osXbh̃vCIeB(iCXl)Ԃ܂B<br>
 * \attention:
 * {֐́ACuɃXbhf}`Xbhf
 * i ::CRIATOM_THREAD_MODEL_MULTI jɐݒ肵ꍇɂ̂݌ʂ𔭊܂B<br>
 * ̃XbhfIꍇA{֐̓G[lԂ܂B<br>
 * iG[R[obN܂Bj<br>
 * <br>
 * {֐͏`IO̊ԂɎsKv܂B<br>
 * OIɖ{֐sꍇA{֐̓G[lԂ܂B<br>
 * iG[R[obN܂Bj<br>
 * \sa criAtomEx_Initialize_ANDROID, criAtomEx_SetThreadPriority_ANDROID
 */
#define criAtomEx_GetThreadPriority_ANDROID()	\
	criAtom_GetThreadPriority_ANDROID()

/*JP
 * \brief JavaVMIuWFNg̐ݒ
 * \ingroup ATOMLIB_Android
 * \return	JavaVM*		JavaVMIuWFNg
 * \par :
 * JavaVMIuWFNgAtomCuɓo^܂B<br>
 * Android OS 2.3OOST|[gꍇ́A{֐KgpAJavaVMIuWFNgo^ĂB<br>
 * Android OS 2.3ȍ~OŜ݂ΏۂƂꍇ́A{֐ĂяoȂĂ삵܂B<br>
 * \attention:
 * JavaVMIuWFNgo^ꍇACuō쐬XbhJavaVMɃA^b`܂B<br>
 *
 * <br>
 * {֐̓CuOɎsKv܂B<br>
 * \sa criAtomEx_Initialize_ANDROID
 */
#define criAtomEx_SetJavaVM_ANDROID(vm)		\
	criAtom_SetJavaVM_ANDROID(vm)

/*JP
 * \brief o͐Xg[^Cv̐ݒ
 * \ingroup ATOMLIB_Android
 * \return	JavaVM*		JavaVMIuWFNg
 * \par :
 * o͐Xg[^Cvݒ肵܂B<br>
 * <br>
 * {֐̓CuOɎsKv܂B<br>
 * \sa criAtomEx_Initialize_ANDROID
 */
#define criAtomEx_SetOutputStreamType(type)		\
	criAtom_SetOutputStreamType(type)

/*JP
 * \brief x̏
 * \ingroup ATOMLIB_Android
 * \par :
 * x܂B<br>
 * <br>
 * xgpہA{֐̌Ăяo͕K{łB
 * <br>
 * {֐ĂяoƁAAtomCuŒx킪AN܂B
 * Nꂽx̃Xbh́AXbh̗v҂xJn܂B
 * xIɂ́A::criAtomLatencyEstimator_Finalize ֐ĂԕKv܂B
 * <br>
 * ܂A{֐͊AłBdĂяoe܂AAtomCuł
 * {֐̌Ăяo񐔂JEgĂ܂B
 * ۂ̏ŝ́Aŏ̌Ăяo̎ɂȂ܂B
 * ȂǍĂяo񐔃JE^́A::criAtomLatencyEstimator_Finalize ֐Ăяox
 * fNg܂B
 * \attention
 * ::criAtom_Initialize_ANDROID ֐sOɖ{֐sȂłB<br>
 * \sa criAtomLatencyEstimator_Finalize
 */
void CRIAPI criAtomLatencyEstimator_Initialize_ANDROID();

/*JP
 * \brief x̏I
 * \ingroup ATOMLIB_Android
 * \par :
 * xI܂B<br>
 * <br>
 * xIہA{֐ĂяoĂB
 * <br>
 * N̒xXbh́A{֐̌ĂяoɂĐI܂B
 * IXbh́AIɔj܂B
 * <br>
 * ܂A{֐͊AłBdĂяoe܂B
 * {֐ĂяoƁA::criAtomLatencyEstimator_Initialize ֐̌ĂяoJE^
 * fNg܂B{֐::criAtomLatencyEstimator_Initialize ֐̌Ăяo񐔂
 * ɂȂ悤ӂĂB
 * \attention
 * ::criAtom_Initialize_ANDROID ֐sOɖ{֐sȂłB<br>
 * \sa criAtomLatencyEstimator_Initialize
 */
void CRIAPI criAtomLatencyEstimator_Finalize_ANDROID();

/*JP
 * \brief x̏擾
 * \ingroup ATOMLIB_Android
 * \return	CriAtomLatencyEstimatorInfo		x̏
 * \par :
 * x݂̌̏擾܂B<br>
 * 擾ł́ux̏ԁvux(~b)v̂QłB<br>
 * <br>
 * ::criAtomLatencyEstimator_Initialize ֐ĂяoA{֐ĂԂƂ
 * ݂̒x̏(ԁAx)擾邱Ƃł܂B
 * Ԃ ::CRIATOM_LATENCYESTIMATOR_STATUS_DONE ł鎞AxԂ0łȂlɂȂ܂B
 * ȊȌԂł́AxԂ0Ԃ܂B
 * <br>
 * \attention
 * ::criAtomLatencyEstimator_Initialize ֐sOɖ{֐sȂłB<br>
 * ::criAtomLatencyEstimator_Finalize ֐sɖ{֐sȂłB<br>
 * \sa criAtomLatencyEstimator_Initialize criAtomLatencyEstimator_Finalize
 */
CriAtomLatencyEstimatorInfo CRIAPI criAtomLatencyEstimator_GetCurrentInfo_ANDROID();

/*JP
 * \brief CuԂ̎擾
 * \ingroup ATOMLIB_Android
 * \return	CriBool		ς݂ǂ
 * \retval	CRI_FALSE	
 * \retval	CRI_TRUE	ς
 * \par :
 * x킪ɏĂ邩ǂ`FbN܂B<br>
 * \sa criAtomLatencyEstimator_Initialize criAtomLatencyEstimator_Finalize
 */
CriBool CRIAPI criAtomLatencyEstimator_IsInitialized_ANDROID();

#ifdef __cplusplus
}
#endif

#endif	/* CRI_INCL_CRI_ATOM_ANDROID_H */


/***************************************************************************
 *      o[WƂ̌݊p
 *      For compatibility with old version
 ***************************************************************************/



















/* --- end of file --- */
