# CRI Middleware SDK
# Copyright (c) 2020 CRI Middleware Co., Ltd.
# CRI Atom Craft Robot Samples
# Version : 1.0.0
# 
# --Description:[ja]キューIDの重複確認
# --Description:[en]Check for overlapping Cue IDs
# --Description:[zh]检查重复的Cue ID

import csv
import os
import sys
import cri.atomcraft.debug as acdebug
import cri.atomcraft.project as acproject

# Get the selected cuesheets
cuesheets = acproject.get_selected_objects("CueSheet")["data"]

if not cuesheets:
    acdebug.warning("Please select a CueSheet.")
    sys.exit()

# Enumerate Cues from Cuesheet
cuesheet = cuesheets[0]
cues = acproject.find_objects(cuesheet, "Cue")["data"]

# Make a double array of CueId and Cue
cueid_cue_pairs = []
for cue in cues:
    cue_id = acproject.get_value(cue, "CueID")["data"]
    cueid_cue_pairs.append([int(cue_id), cue])

# Sort by Cue ID
cueid_cue_pairs.sort()

# -----Check for overlapping Cue IDs -----
cuesheet_name = acproject.get_value(cuesheet, "Name")["data"]
acdebug.log("Start checking for overlapping Cue IDs in the CueSheet \"{0}\".".format(cuesheet_name))

overlapping_cues = []

is_overlapped_prev_cue_id = False
for i in range(len(cueid_cue_pairs) - 1):
    if cueid_cue_pairs[i][0] == cueid_cue_pairs[i+1][0]:
        # Add if ID is the same as for the next Cue.
        overlapping_cues.append(cueid_cue_pairs[i])
        is_overlapped_prev_cue_id = True
    else:
        if is_overlapped_prev_cue_id:
            # Add if the ID is the same as for the previous Cue.
            overlapping_cues.append(cueid_cue_pairs[i])
        is_overlapped_prev_cue_id = False

if is_overlapped_prev_cue_id:
    # Add if the ID is the same as for the previous Cue.
    overlapping_cues.append(cueid_cue_pairs[-1])

if overlapping_cues:
    acdebug.log("These Cue IDs overlap.")
    project = acproject.get_child_objects(None, "Project")["data"][0]
    project_dir = os.path.dirname(acproject.get_value(project, "ProjectFilePath")["data"])
    csv_path = os.path.join(project_dir, cuesheet_name + "check_overlapping_cue_id_result.csv")
    with open(csv_path, "w") as f:
        writer = csv.writer(f)
        writer.writerow(["Cue ID", "Path"])
        for cueid_cue_pair in overlapping_cues:
            path = acproject.get_object_path(cueid_cue_pair[1])["data"]
            acdebug.log("Cue ID: {0}, Path: {1}".format(cueid_cue_pair[0], path))
            writer.writerow([cueid_cue_pair[0], path])
    acdebug.log("Output the result to a file: {0}".format(csv_path))
else:
    acdebug.log("There were no overlapping Cue IDs")

acdebug.log("The checking of overlapping Cue IDs is completed.")
