# CRI Middleware SDK
# Copyright (c) 2020 CRI Middleware Co., Ltd.
# CRI Atom Craft Robot Samples
# Version : 1.0.0
# 
# --Description:[ja]選択キューから指定カテゴリを削除
# --Description:[en]Remove the specified Category from selected Cues.
# --Description:[zh]从选择Cue中删除指定类别

import sys
import cri.atomcraft.debug as acdebug
import cri.atomcraft.project as acproject
import cri.atomcraft.project

# --BeginUserVariable
"""
REMOVE_CATEGORY:
  type: object
  comment: Category to be removed from the selected Cues.
"""
REMOVE_CATEGORY = None
# --EndUserVariable

if not REMOVE_CATEGORY:
    acdebug.warning("Please set the Category to remove.")
    sys.exit()

# Get the selected Cues
selected_cues = acproject.get_selected_objects("Cue")["data"]
if not selected_cues:
    acdebug.warning("Please select at least a Cue.")
    sys.exit()

category_name = acproject.get_value(REMOVE_CATEGORY, "Name")["data"]
acdebug.log("Start removing the specified Category \"{0}\" from the selected Cues.".format(category_name))

modified_cues = []

for cue in selected_cues:
    # Get the Categories assigned to the Cue.
    categories = acproject.get_categories(cue)["data"]

    for i, category in enumerate(categories):
        if category == REMOVE_CATEGORY:
            # The Category is a match.
            categories.remove(REMOVE_CATEGORY)
            acproject.set_categories(cue, categories)
            modified_cues.append(cue)
            break

if modified_cues:
    acdebug.log("Removed Category \"{0}\" from {1} Cues.".format(category_name, len(modified_cues)))

acdebug.log("The removal of the specified Category is completed.")
