/*
 * Decompiled with CFR 0.152.
 */
package com.criware.filesystem;

import com.criware.filesystem.CriFsWebInstaller;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ConcurrentLinkedQueue;
import javax.net.ssl.X509TrustManager;

public class CriFsWebInstallerManager {
    public int num_installers;
    public boolean allow_insecure_ssl;
    public int inactive_timeout_sec;
    public String proxy_host = "";
    public short proxy_port = (short)-1;
    public String user_agent;
    public boolean crc_enabled;
    public boolean is_initialized;
    private int num_installers_max;
    public RequestHeaders request_headers;
    public ConcurrentLinkedQueue<CriFsWebInstaller> installer_list;

    public void Manager_Initialize(CriFsWebInstaller.Config wiconfig) {
        if (this.is_initialized) {
            return;
        }
        this.num_installers = wiconfig.num_installers;
        this.allow_insecure_ssl = wiconfig.allow_insecure_ssl;
        this.inactive_timeout_sec = wiconfig.inactive_timeout_sec;
        this.proxy_host = wiconfig.proxy_host;
        this.proxy_port = wiconfig.proxy_port;
        this.user_agent = wiconfig.user_agent;
        this.crc_enabled = wiconfig.crc_enabled;
        this.num_installers_max = this.num_installers;
        this.num_installers = 0;
        this.installer_list = new ConcurrentLinkedQueue();
        this.request_headers = new RequestHeaders(wiconfig.max_request_fields);
        this.is_initialized = true;
    }

    public void Manager_Finalize() {
        if (!this.is_initialized) {
            return;
        }
        for (CriFsWebInstaller hnd : this.installer_list) {
            hnd.is_stop_required = true;
            this.installer_list.remove(hnd);
        }
        this.is_initialized = false;
    }

    public CriFsWebInstaller CreateInstaller() {
        if (this.num_installers >= this.num_installers_max) {
            CriFsWebInstaller.ErrorEntry(3);
            return null;
        }
        CriFsWebInstaller hnd = new CriFsWebInstaller();
        if (this.installer_list.add(hnd)) {
            ++this.num_installers;
        }
        return hnd;
    }

    public void ExecuteMain() {
        for (CriFsWebInstaller hnd : this.installer_list) {
            hnd.Update();
        }
    }

    public final class RequestHeaders {
        private List<String> fieldAndValues = null;

        public RequestHeaders(int maxFields) {
            this.fieldAndValues = new ArrayList<String>(maxFields * 2);
        }

        public void set(String field, String value) {
            this.removeAll(field);
            if (value != null) {
                this.add(field, value);
            }
        }

        public int length() {
            return this.fieldAndValues.size() / 2;
        }

        public String getFieldName(int index) {
            int fieldIndex = index * 2;
            if (fieldIndex < 0 || fieldIndex >= this.fieldAndValues.size()) {
                return null;
            }
            return this.fieldAndValues.get(fieldIndex);
        }

        public String getValue(int index) {
            int valueIndex = index * 2 + 1;
            if (valueIndex < 0 || valueIndex >= this.fieldAndValues.size()) {
                return null;
            }
            return this.fieldAndValues.get(valueIndex);
        }

        private void add(String field, String value) {
            this.fieldAndValues.add(field);
            this.fieldAndValues.add(value);
        }

        private void removeAll(String field) {
            for (int i = 0; i < this.fieldAndValues.size(); i += 2) {
                if (!field.equalsIgnoreCase(this.fieldAndValues.get(i))) continue;
                this.fieldAndValues.remove(i);
                this.fieldAndValues.remove(i);
            }
        }
    }

    public static class LooseTrustManager
    implements X509TrustManager {
        @Override
        public void checkClientTrusted(X509Certificate[] chain, String authType) throws CertificateException {
        }

        @Override
        public void checkServerTrusted(X509Certificate[] chain, String authType) throws CertificateException {
        }

        @Override
        public X509Certificate[] getAcceptedIssuers() {
            return null;
        }
    }
}

