﻿/****************************************************************************
 *
 * CRI Middleware SDK
 *
 * Copyright (c) 2012-2023 CRI Middleware Co., Ltd.
 *
 * Library      : CRIWARE plugin for Unreal Engine
 * Module       : Function exporter
 * File         : CriWareApi.h
 * Generator    : CriWareExporterForUE4.exe (May  8 2023)
 * Date         : Fri May  8 19:56:50 2023
 *
 ****************************************************************************/
#pragma once

/***************************************************************************
 *      Include files
 ***************************************************************************/
#include "CoreTypes.h"
#include "Misc/Build.h"

#define CRI_XPT_DISABLE_UNPREFIXED_TYPE
#include <cri_le_xpt.h>
#include <cri_le_error.h>
#include <cri_le_file_system.h>
#include <cri_le_atom.h>
#include <cri_le_atom_asr.h>
#include <cri_le_atom_ex.h>
#if defined(XPT_TGT_MACOSX)
#include <cri_le_atom_macosx.h>
#endif
#if defined(XPT_TGT_IOS)
#include <cri_le_atom_ios.h>
#endif
#if defined(XPT_TGT_ANDROID)
#include <cri_le_file_system_android.h>
#include <cri_le_atom_android.h>
#endif

#if defined(XPT_TGT_PC)
#include "Windows/AllowWindowsPlatformTypes.h"
#include "Windows/AllowWindowsPlatformAtomics.h"
#include "Windows/MinWindows.h"
THIRD_PARTY_INCLUDES_START
#include <cri_le_atom_wasapi.h>
THIRD_PARTY_INCLUDES_END
#endif

#ifndef CRIWARE_USE_ATOM_MONITOR
#if !UE_BUILD_SHIPPING
#include <cri_le_atom_ex_monitor.h>
#define CRIWARE_USE_ATOM_MONITOR	1
#else
#define CRIWARE_USE_ATOM_MONITOR	0
#endif
#endif


#ifndef CRIWARE_USE_SOUNDXR
#define CRIWARE_USE_SOUNDXR 0
#else
#if CRIWARE_USE_SOUNDXR
#include <crisoundxr_le_plugin.h>
#endif
#endif
#ifndef CRIWARE_USE_SOFDEC_ALPHA_STREAM
#define CRIWARE_USE_SOFDEC_ALPHA_STREAM 0
#endif

/***************************************************************************
 *      Function Types
 ***************************************************************************/
typedef CriBool (CRIAPI *criFs_IsInitialized_TYPE)(void);
typedef const CriChar8* (CRIAPI *criErr_ConvertIdToMsg_TYPE)(const CriChar8 *errid);
typedef const CriChar8* (CRIAPI *criErr_ConvertIdToMessage_TYPE)(const CriChar8 *errid, CriUint32 p1, CriUint32 p2);
typedef void (CRIAPI *criErr_SetCallback_TYPE)(CriErrCbFunc cbf);
typedef void (CRIAPI *criErr_SetErrorNotificationLevel_TYPE)(CriErrorNotificationLevel level);
typedef CriUint32 (CRIAPI *criErr_GetErrorCount_TYPE)(CriErrorLevel level);
typedef void (CRIAPI *criErr_ResetErrorCount_TYPE)(CriErrorLevel level);
typedef void (CRIAPI *criFs_SetUserMallocFunction_TYPE)(CriFsMallocFunc func, void *obj);
typedef void (CRIAPI *criFs_SetUserFreeFunction_TYPE)(CriFsFreeFunc func, void *obj);
typedef CriError (CRIAPI *criFs_GetNumUsedBinders_TYPE)(CriSint32 *cur_num, CriSint32 *max_num, CriSint32 *limit);
typedef CriError (CRIAPI *criFs_SetSelectIoCallback_TYPE)(CriFsSelectIoCbFunc func);
typedef CriError (CRIAPI *criFs_ControlFileIoMode_TYPE)(CriFsFileIoMode io_mode);
typedef CriError (CRIAPI *criFsBinder_Create_TYPE)(CriFsBinderHn *bndrhn);
typedef CriError (CRIAPI *criFsBinder_Destroy_TYPE)(CriFsBinderHn bndrhn);
typedef CriError (CRIAPI *criFsBinder_BindFile_TYPE)(CriFsBinderHn bndrhn, CriFsBinderHn srcbndrhn, const CriChar8 *path, void *work, CriSint32 worksize, CriFsBindId *bndrid);
typedef CriError (CRIAPI *criFsBinder_BindFileSection_TYPE)( CriFsBinderHn bndrhn, CriFsBinderHn srcbndrhn, const CriChar8 *path, CriUint64 offset, CriSint32 size, const CriChar8 *section_name, void *work, CriSint32 worksize, CriFsBindId *bndrid);
typedef CriError (CRIAPI *criFsBinder_CleanImplicitUnbindList_TYPE)(void);
typedef CriError (CRIAPI *criFsBinder_GetStatus_TYPE)(CriFsBindId bndrid, CriFsBinderStatus *status);
typedef CriError (CRIAPI *criFsBinder_Find_TYPE)(CriFsBinderHn bndrhn, const CriChar8 *filepath, CriFsBinderFileInfo *finfo, CriBool *exist);
typedef CriError (CRIAPI *criFsBinder_GetFileSize_TYPE)(CriFsBinderHn bndrhn, const CriChar8 *filepath, CriSint64 *size);
typedef CriFsStdioHn (CRIAPI *criFsStdio_OpenFile_TYPE)(CriFsBinderHn bndr, const char *fname, const char *mode);
typedef CriError (CRIAPI *criFsStdio_CloseFile_TYPE)(CriFsStdioHn stdhn);
typedef CriSint64 (CRIAPI *criFsStdio_GetFileSize_TYPE)(CriFsStdioHn stdhn);
typedef CriSint64 (CRIAPI *criFsStdio_SeekFile_TYPE)(CriFsStdioHn rdr, CriSint64 offset, CRIFSSTDIO_SEEK_TYPE seek_type);
typedef CriSint64 (CRIAPI *criFsStdio_ReadFile_TYPE)(CriFsStdioHn stdhn, CriSint64 rsize, void *buf, CriSint64 bsize);
typedef CriUint32 (CRIAPI *criAtom_GetVersionNumber_TYPE)(void);
typedef CriBool (CRIAPI *criAtom_IsInitialized_TYPE)(void);
typedef CriBool (CRIAPI *criAtom_IsAudioOutputActive_TYPE)(void);
typedef void (CRIAPI *criAtom_ExecuteMain_TYPE)(void);
typedef void (CRIAPI *criAtom_ExecuteAudioProcess_TYPE)(void);
typedef void (CRIAPI *criAtom_SetUserMallocFunction_TYPE)(CriAtomMallocFunc func, void *obj);
typedef void (CRIAPI *criAtom_SetUserFreeFunction_TYPE)(CriAtomFreeFunc func, void *obj);
typedef void (CRIAPI *criAtom_SetAudioFrameStartCallback_TYPE)( CriAtomAudioFrameStartCbFunc func, void *obj);
typedef void (CRIAPI *criAtom_SetAudioFrameEndCallback_TYPE)( CriAtomAudioFrameEndCbFunc func, void *obj);
typedef void (CRIAPI *criAtom_Lock_TYPE)(void);
typedef void (CRIAPI *criAtom_Unlock_TYPE)(void);
typedef void (CRIAPI *criAtom_SetChannelMapping_TYPE)(CriSint32 nch, CriUint32 type);
typedef void (CRIAPI *criAtom_AttachPerformanceMonitor_TYPE)(void);
typedef void (CRIAPI *criAtom_DetachPerformanceMonitor_TYPE)(void);
typedef void (CRIAPI *criAtom_ResetPerformanceMonitor_TYPE)(void);
typedef void (CRIAPI *criAtom_GetPerformanceInfo_TYPE)(CriAtomPerformanceInfo *info);
typedef CriSint32 (CRIAPI *criAtom_CalculateAdxBitrate_TYPE)( CriSint32 num_channels, CriSint32 sampling_rate);
typedef CriSint32 (CRIAPI *criAtom_CalculateHcaBitrate_TYPE)( CriSint32 num_channels, CriSint32 sampling_rate, CriAtomEncodeQuality quality);
typedef CriSint32 (CRIAPI *criAtom_CalculateHcaMxBitrate_TYPE)( CriSint32 num_channels, CriSint32 sampling_rate, CriAtomEncodeQuality quality);
typedef CriBool (CRIAPI *criAtom_GetStreamingInfo_TYPE)(CriAtomStreamingInfo* streaming_info);
typedef CriBool (CRIAPI *criAtom_SetFreeTimeBufferingFlagForDefaultDevice_TYPE)(CriBool flag);
typedef void (CRIAPI *criAtom_SetAdx1KeyString_TYPE)(const CriChar8 *key_string);
typedef CriSint32 (CRIAPI *criAtomHcaMx_CalculateWorkSize_TYPE)(const CriAtomHcaMxConfig *config);
typedef void (CRIAPI *criAtomHcaMx_SetConfigForWorkSizeCalculation_TYPE)(const CriAtomHcaMxConfig *config);
typedef void (CRIAPI *criAtomHcaMx_Initialize_TYPE)( const CriAtomHcaMxConfig *config, void *work, CriSint32 work_size);
typedef void (CRIAPI *criAtomHcaMx_Finalize_TYPE)(void);
typedef void (CRIAPI *criAtomHcaMx_SetBusSendLevelByName_TYPE)( CriSint32 mixer_id, const CriChar8* bus_name, CriFloat32 level);
typedef void (CRIAPI *criAtomHcaMx_SetFrequencyRatio_TYPE)(CriSint32 mixer_id, CriFloat32 ratio);
typedef CriSint32 (CRIAPI *criAtomAwb_CalculateWorkSizeForLoadToc_TYPE)(CriSint32 num);
typedef CriAtomAwbHn (CRIAPI *criAtomAwb_LoadToc_TYPE)( CriFsBinderHn binder, const CriChar8 *path, void *work, CriSint32 work_size);
typedef CriAtomAwbHn (CRIAPI *criAtomAwb_LoadTocById_TYPE)( CriFsBinderHn binder, CriUint16 id, void *work, CriSint32 work_size);
typedef CriAtomAwbHn (CRIAPI *criAtomAwb_LoadTocAsync_TYPE)( CriFsBinderHn binder, const CriChar8 *path, void *work, CriSint32 work_size);
typedef CriAtomAwbHn (CRIAPI *criAtomAwb_LoadTocAsyncById_TYPE)( CriFsBinderHn binder, CriUint16 id, void *work, CriSint32 work_size);
typedef CriAtomAwbHn (CRIAPI *criAtomAwb_LoadFromMemory_TYPE)( void *awb_mem, CriSint32 awb_mem_size, void *work, CriSint32 work_size);
typedef CriAtomAwbType (CRIAPI *criAtomAwb_GetType_TYPE)(CriAtomAwbHn awb);
typedef CriBool (CRIAPI *criAtomAwb_GetWaveFileInfo_TYPE)( CriAtomAwbHn awb, CriSint32 id, CriSint64 *offset, CriUint32 *size);
typedef void (CRIAPI *criAtomAwb_GetWaveDataInfo_TYPE)(CriAtomAwbHn awb, CriSint32 id, void **wave_data_start, CriUint32 *size);
typedef CriUint16 (CRIAPI *criAtomAwb_GetNumContents_TYPE)(CriAtomAwbHn awb);
typedef void (CRIAPI *criAtomAwb_Release_TYPE)(CriAtomAwbHn awb);
typedef CriBool (CRIAPI *criAtomAwb_IsReadyToRelease_TYPE)(CriAtomAwbHn awb);
typedef CriAtomAwbStatus (CRIAPI *criAtomAwb_GetStatus_TYPE)(CriAtomAwbHn awb);
typedef CriSint32 (CRIAPI *criAtomAwb_GetIdByIndex_TYPE)(CriAtomAwbHn awb, CriUint16 index);
typedef CriSint32 (CRIAPI *criAtomPlayer_CalculateWorkSizeForStandardPlayer_TYPE)( const CriAtomStandardPlayerConfig *config);
typedef CriAtomPlayerHn (CRIAPI *criAtomPlayer_CreateStandardPlayer_TYPE)( const CriAtomStandardPlayerConfig *config, void *work, CriSint32 work_size);
typedef CriSint32 (CRIAPI *criAtomPlayer_CalculateWorkSizeForAdxPlayer_TYPE)( const CriAtomAdxPlayerConfig *config);
typedef CriAtomPlayerHn (CRIAPI *criAtomPlayer_CreateAdxPlayer_TYPE)( const CriAtomAdxPlayerConfig *config, void *work, CriSint32 work_size);
typedef CriSint32 (CRIAPI *criAtomPlayer_CalculateWorkSizeForHcaPlayer_TYPE)( const CriAtomHcaPlayerConfig *config);
typedef CriAtomPlayerHn (CRIAPI *criAtomPlayer_CreateHcaPlayer_TYPE)( const CriAtomHcaPlayerConfig *config, void *work, CriSint32 work_size);
typedef CriSint32 (CRIAPI *criAtomPlayer_CalculateWorkSizeForHcaMxPlayer_TYPE)( const CriAtomHcaMxPlayerConfig *config);
typedef CriAtomPlayerHn (CRIAPI *criAtomPlayer_CreateHcaMxPlayer_TYPE)( const CriAtomHcaMxPlayerConfig *config, void *work, CriSint32 work_size);
typedef CriSint32 (CRIAPI *criAtomPlayer_CalculateWorkSizeForWavePlayer_TYPE)( const CriAtomWavePlayerConfig *config);
typedef CriAtomPlayerHn (CRIAPI *criAtomPlayer_CreateWavePlayer_TYPE)( const CriAtomWavePlayerConfig *config, void *work, CriSint32 work_size);
typedef CriSint32 (CRIAPI *criAtomPlayer_CalculateWorkSizeForAiffPlayer_TYPE)( const CriAtomAiffPlayerConfig *config);
typedef CriAtomPlayerHn (CRIAPI *criAtomPlayer_CreateAiffPlayer_TYPE)( const CriAtomAiffPlayerConfig *config, void *work, CriSint32 work_size);
typedef CriSint32 (CRIAPI *criAtomPlayer_CalculateWorkSizeForRawPcmPlayer_TYPE)( const CriAtomRawPcmPlayerConfig *config);
typedef CriAtomPlayerHn (CRIAPI *criAtomPlayer_CreateRawPcmPlayer_TYPE)( const CriAtomRawPcmPlayerConfig *config, void *work, CriSint32 work_size);
typedef void (CRIAPI *criAtomPlayer_Destroy_TYPE)(CriAtomPlayerHn player);
typedef void (CRIAPI *criAtomPlayer_SetData_TYPE)( CriAtomPlayerHn player, void *buffer, CriSint32 buffer_size);
typedef void (CRIAPI *criAtomPlayer_SetFile_TYPE)( CriAtomPlayerHn player, CriFsBinderHn binder, const CriChar8 *path);
typedef void (CRIAPI *criAtomPlayer_SetContentId_TYPE)( CriAtomPlayerHn player, CriFsBinderHn binder, CriSint32 id);
typedef void (CRIAPI *criAtomPlayer_SetWaveId_TYPE)( CriAtomPlayerHn player, CriAtomAwbHn awb, CriSint32 id);
typedef void (CRIAPI *criAtomPlayer_SetPreviousDataAgain_TYPE)(CriAtomPlayerHn player);
typedef void (CRIAPI *criAtomPlayer_DeferCallback_TYPE)(CriAtomPlayerHn player);
typedef void (CRIAPI *criAtomPlayer_Start_TYPE)(CriAtomPlayerHn player);
typedef void (CRIAPI *criAtomPlayer_Stop_TYPE)(CriAtomPlayerHn player);
typedef void (CRIAPI *criAtomPlayer_ForceStop_TYPE)(CriAtomPlayerHn player);
typedef void (CRIAPI *criAtomPlayer_Pause_TYPE)(CriAtomPlayerHn player, CriBool flag);
typedef CriBool (CRIAPI *criAtomPlayer_IsPaused_TYPE)(CriAtomPlayerHn player);
typedef CriAtomPlayerStatus (CRIAPI *criAtomPlayer_GetStatus_TYPE)(CriAtomPlayerHn player);
typedef CriSint32 (CRIAPI *criAtomPlayer_GetNumChannels_TYPE)(CriAtomPlayerHn player);
typedef CriBool (CRIAPI *criAtomPlayer_GetNumPlayedSamples_TYPE)( CriAtomPlayerHn player, CriSint64 *num_played, CriSint32 *sampling_rate);
typedef CriSint64 (CRIAPI *criAtomPlayer_GetDecodedDataSize_TYPE)(CriAtomPlayerHn player);
typedef CriSint64 (CRIAPI *criAtomPlayer_GetNumDecodedSamples_TYPE)(CriAtomPlayerHn player);
typedef CriSint64 (CRIAPI *criAtomPlayer_GetTime_TYPE)(CriAtomPlayerHn player);
typedef CriBool (CRIAPI *criAtomPlayer_GetFormatInfo_TYPE)( CriAtomPlayerHn player, CriAtomFormatInfo *info);
typedef CriSint32 (CRIAPI *criAtomPlayer_GetInputBufferRemainSize_TYPE)(CriAtomPlayerHn player);
typedef CriSint32 (CRIAPI *criAtomPlayer_GetOutputBufferRemainSamples_TYPE)(CriAtomPlayerHn player);
typedef void (CRIAPI *criAtomPlayer_SetStartTime_TYPE)(CriAtomPlayerHn player, CriSint64 start_time_ms);
typedef void (CRIAPI *criAtomPlayer_SetVolume_TYPE)(CriAtomPlayerHn player, CriFloat32 vol);
typedef CriFloat32 (CRIAPI *criAtomPlayer_GetVolume_TYPE)(CriAtomPlayerHn player);
typedef void (CRIAPI *criAtomPlayer_SetChannelVolume_TYPE)( CriAtomPlayerHn player, CriSint32 ch, CriFloat32 vol);
typedef void (CRIAPI *criAtomPlayer_SetSendLevel_TYPE)( CriAtomPlayerHn player, CriSint32 ch, CriAtomSpeakerId spk, CriFloat32 level);
typedef void (CRIAPI *criAtomPlayer_ResetSendLevel_TYPE)(CriAtomPlayerHn player);
typedef void (CRIAPI *criAtomPlayer_SetPanAdx1Compatible_TYPE)( CriAtomPlayerHn player, CriSint32 ch, CriFloat32 pan);
typedef void (CRIAPI *criAtomPlayer_ResetPan_TYPE)(CriAtomPlayerHn player);
typedef void (CRIAPI *criAtomPlayer_SetFrequencyRatio_TYPE)(CriAtomPlayerHn player, CriFloat32 ratio);
typedef void (CRIAPI *criAtomPlayer_SetMaxFrequencyRatio_TYPE)(CriAtomPlayerHn player, CriFloat32 ratio);
typedef void (CRIAPI *criAtomPlayer_LimitLoopCount_TYPE)(CriAtomPlayerHn player, CriSint32 count);
typedef void (CRIAPI *criAtomPlayer_SetHcaMxMixerId_TYPE)(CriAtomPlayerHn player, CriSint32 mixer_id);
typedef void (CRIAPI *criAtomPlayer_SetAsrRackId_TYPE)(CriAtomPlayerHn player, CriSint32 rack_id);
typedef void (CRIAPI *criAtomPlayer_SetRawPcmFormat_TYPE)(CriAtomPlayerHn player, CriAtomPcmFormat pcm_format, CriSint32 num_channels, CriSint32 sampling_rate);
typedef void (CRIAPI *criAtomPlayer_SetDataRequestCallback_TYPE)( CriAtomPlayerHn player, CriAtomPlayerDataRequestCbFunc func, void *obj);
typedef void (CRIAPI *criAtomPlayer_SetStatusChangeCallback_TYPE)( CriAtomPlayerHn player, CriAtomPlayerStatusChangeCbFunc func, void *obj);
typedef void (CRIAPI *criAtomPlayer_SetParameterChangeCallback_TYPE)( CriAtomPlayerHn player, CriAtomPlayerParameterChangeCbFunc func, void *obj);
typedef void (CRIAPI *criAtomPlayer_SetFilterCallback_TYPE)( CriAtomPlayerHn player, CriAtomPlayerFilterCbFunc func, void *obj);
typedef void (CRIAPI *criAtomPlayer_SetLoadRequestCallback_TYPE)( CriAtomPlayerHn player, CriAtomPlayerLoadRequestCbFunc func, void *obj);
typedef CriSint32 (CRIAPI *criAtomDbas_CalculateWorkSize_TYPE)(const CriAtomDbasConfig *config);
typedef CriAtomDbasId (CRIAPI *criAtomDbas_Create_TYPE)( const CriAtomDbasConfig *config, void *work, CriSint32 work_size);
typedef void (CRIAPI *criAtomDbas_Destroy_TYPE)(CriAtomDbasId atom_dbas_id);
typedef CriSint32 (CRIAPI *criAtomDbas_GetStreamingPlayerHandles_TYPE)( CriAtomDbasId dbas_id, CriAtomPlayerHn *players, CriSint32 length);
typedef CriSint32 (CRIAPI *criAtomStreamingCache_CalculateWorkSize_TYPE)( const CriAtomStreamingCacheConfig* config);
typedef CriAtomStreamingCacheId (CRIAPI *criAtomStreamingCache_Create_TYPE)( const CriAtomStreamingCacheConfig* config, void* work, CriSint32 work_size);
typedef void (CRIAPI *criAtomStreamingCache_Destroy_TYPE)(CriAtomStreamingCacheId stm_cache_id);
typedef void (CRIAPI *criAtomStreamingCache_Clear_TYPE)(CriAtomStreamingCacheId cache_id);
typedef CriBool (CRIAPI *criAtomStreamingCache_IsCachedWaveId_TYPE)( CriAtomStreamingCacheId stm_cache_id, CriAtomAwbHn awb, CriSint32 id);
typedef CriBool (CRIAPI *criAtomStreamingCache_IsCachedFile_TYPE)( CriAtomStreamingCacheId stm_cache_id, CriFsBinderHn src_binder, const CriChar8 *path);
typedef CriSint32 (CRIAPI *criAtomMeter_CalculateWorkSizeForLevelMeter_TYPE)( const CriAtomLevelMeterConfig *config);
typedef void (CRIAPI *criAtomMeter_AttachLevelMeter_TYPE)( const CriAtomLevelMeterConfig *config, void *work, CriSint32 work_size);
typedef void (CRIAPI *criAtomMeter_DetachLevelMeter_TYPE)(void);
typedef void (CRIAPI *criAtomMeter_GetLevelInfo_TYPE)(CriAtomLevelInfo *info);
typedef CriSint32 (CRIAPI *criAtomMeter_CalculateWorkSizeForLoudnessMeter_TYPE)(const CriAtomLoudnessMeterConfig *config);
typedef void (CRIAPI *criAtomMeter_AttachLoudnessMeter_TYPE)(const CriAtomLoudnessMeterConfig *config, void *work, CriSint32 work_size);
typedef void (CRIAPI *criAtomMeter_DetachLoudnessMeter_TYPE)(void);
typedef void (CRIAPI *criAtomMeter_GetLoudnessInfo_TYPE)(CriAtomLoudnessInfo *info);
typedef void (CRIAPI *criAtomMeter_ResetLoudnessMeter_TYPE)(void);
typedef CriSint32 (CRIAPI *criAtomMeter_CalculateWorkSizeForTruePeakMeter_TYPE)(const CriAtomTruePeakMeterConfig *config);
typedef void (CRIAPI *criAtomMeter_AttachTruePeakMeter_TYPE)(const CriAtomTruePeakMeterConfig *config, void *work, CriSint32 work_size);
typedef void (CRIAPI *criAtomMeter_DetachTruePeakMeter_TYPE)(void);
typedef void (CRIAPI *criAtomMeter_GetTruePeakInfo_TYPE)(CriAtomTruePeakInfo *info);
typedef CriBool (CRIAPI *criAtomInstrument_RegisterInstrumentInterface_TYPE)(CriAtomAinstInterfaceWithVersionPtr ainst_interface);
typedef void (CRIAPI *criAtomInstrument_UnregisterInstrumentInterface_TYPE)(CriAtomAinstInterfaceWithVersionPtr ainst_interface);
typedef void (CRIAPI *criAtomPlayer_SetDecodeCallback_TYPE)( CriAtomPlayerHn player, CriAtomPlayerDecodeCbFunc func, void *obj);
typedef void (CRIAPI *criAtomPlayer_DiscardSamples_TYPE)(CriAtomPlayerHn player, CriSint32 num_discard);
typedef CriSint32 (CRIAPI *criAtomExAsr_CalculateWorkSize_TYPE)(const CriAtomExAsrConfig *config);
typedef void (CRIAPI *criAtomExAsr_SetConfigForWorkSizeCalculation_TYPE)(const CriAtomExAsrConfig *config);
typedef void (CRIAPI *criAtomExAsr_Initialize_TYPE)( const CriAtomExAsrConfig *config, void *work, CriSint32 work_size);
typedef void (CRIAPI *criAtomExAsr_Finalize_TYPE)(void);
typedef void (CRIAPI *criAtomExAsr_EnableBinauralizer_TYPE)(CriBool enabled);
typedef void (CRIAPI *criAtomExAsr_SetBusVolumeByName_TYPE)(const CriChar8* bus_name, CriFloat32 volume);
typedef void (CRIAPI *criAtomExAsr_GetBusVolumeByName_TYPE)(const CriChar8* bus_name, CriFloat32 *volume);
typedef void (CRIAPI *criAtomExAsr_SetBusPan3dByName_TYPE)(const CriChar8* bus_name,  CriFloat32 pan3d_angle, CriFloat32 pan3d_distance, CriFloat32 pan3d_volume);
typedef void (CRIAPI *criAtomExAsr_GetBusPan3dByName_TYPE)(const CriChar8* bus_name,  CriFloat32 *pan3d_angle, CriFloat32 *pan3d_distance, CriFloat32 *pan3d_volume);
typedef void (CRIAPI *criAtomExAsr_SetBusMatrixByName_TYPE)(const CriChar8* bus_name,  CriSint32 input_channels, CriSint32 output_channels, const CriFloat32 matrix[]);
typedef void (CRIAPI *criAtomExAsr_SetBusSendLevelByName_TYPE)( const CriChar8* bus_name, const CriChar8* sendto_bus_name, CriFloat32 level);
typedef void (CRIAPI *criAtomExAsr_SetEffectParameter_TYPE)( const CriChar8* bus_name, const CriChar8* effect_name,  CriUint32 parameter_index, CriFloat32 parameter_value);
typedef void (CRIAPI *criAtomExAsr_UpdateEffectParameters_TYPE)(const CriChar8* bus_name, const CriChar8* effect_name);
typedef CriFloat32 (CRIAPI *criAtomExAsr_GetEffectParameter_TYPE)( const CriChar8* bus_name, const CriChar8* effect_name, CriUint32 parameter_index);
typedef void (CRIAPI *criAtomExAsr_SetEffectBypass_TYPE)( const CriChar8* bus_name, const CriChar8* effect_name, CriBool bypass);
typedef void (CRIAPI *criAtomExAsr_AttachBusAnalyzerByName_TYPE)( const CriChar8* bus_name, const CriAtomExAsrBusAnalyzerConfig* config);
typedef void (CRIAPI *criAtomExAsr_DetachBusAnalyzerByName_TYPE)(const CriChar8* bus_name);
typedef void (CRIAPI *criAtomExAsr_GetBusAnalyzerInfoByName_TYPE)( const CriChar8* bus_name, CriAtomExAsrBusAnalyzerInfo *info);
typedef void (CRIAPI *criAtomExAsr_SetBusFilterCallbackByName_TYPE)(const CriChar8* bus_name,  CriAtomExAsrBusFilterCbFunc pre_func, CriAtomExAsrBusFilterCbFunc post_func, void *obj);
typedef CriSint32 (CRIAPI *criAtomExAsr_GetNumBuses_TYPE)(void);
typedef CriBool (CRIAPI *criAtomExAsr_RegisterEffectInterface_TYPE)(CriAtomExAsrAfxInterfaceWithVersionPtr afx_interface);
typedef void (CRIAPI *criAtomExAsr_UnregisterEffectInterface_TYPE)(CriAtomExAsrAfxInterfaceWithVersionPtr afx_interface);
typedef CriBool (CRIAPI* criAtomExAsr_RegisterSoundxRInterface_TYPE)(const void* soundxr_interface);
typedef CriSint32 (CRIAPI *criAtomExAsrRack_CalculateWorkSize_TYPE)(const CriAtomExAsrRackConfig *config);
typedef CriSint32 (CRIAPI *criAtomExAsrRack_CalculateWorkSizeForDspBusSettingFromConfig_TYPE)( const CriAtomExAsrRackConfig *config, const CriChar8 *setting);
typedef CriSint32 (CRIAPI *criAtomExAsrRack_CalculateWorkSizeForDspBusSettingFromAcfDataAndConfig_TYPE)( void *acf_data, CriSint32 acf_data_size, const CriAtomExAsrRackConfig *rack_config, const CriChar8 *setting);
typedef CriAtomExAsrRackId (CRIAPI *criAtomExAsrRack_Create_TYPE)( const CriAtomExAsrRackConfig *config, void *work, CriSint32 work_size);
typedef void (CRIAPI *criAtomExAsrRack_Destroy_TYPE)(CriAtomExAsrRackId rack_id);
typedef CriSint32 (CRIAPI *criAtomExAsrRack_CalculateWorkSizeForDspBusSetting_TYPE)( CriAtomExAsrRackId rack_id, const CriChar8 *setting);
typedef void (CRIAPI *criAtomExAsrRack_AttachDspBusSetting_TYPE)(CriAtomExAsrRackId rack_id, const CriChar8 *setting, void *work, CriSint32 work_size);
typedef void (CRIAPI *criAtomExAsrRack_DetachDspBusSetting_TYPE)(CriAtomExAsrRackId rack_id);
typedef void (CRIAPI *criAtomExAsrRack_ApplyDspBusSnapshot_TYPE)(CriAtomExAsrRackId rack_id, const CriChar8 *snapshot_name, CriSint32 time_ms);
typedef const CriChar8* (CRIAPI *criAtomExAsrRack_GetAppliedDspBusSnapshotName_TYPE)(CriAtomExAsrRackId rack_id);
typedef void (CRIAPI *criAtomExAsrRack_SetBusVolumeByName_TYPE)(CriAtomExAsrRackId rack_id,  const CriChar8* bus_name, CriFloat32 volume);
typedef void (CRIAPI *criAtomExAsrRack_GetBusVolumeByName_TYPE)(CriAtomExAsrRackId rack_id,  const CriChar8* bus_name, CriFloat32* volume);
typedef void (CRIAPI *criAtomExAsrRack_SetBusPanInfoByName_TYPE)(CriAtomExAsrRackId rack_id, const CriChar8* bus_name, const CriAtomExAsrBusPanInfo* pan_info);
typedef void (CRIAPI *criAtomExAsrRack_GetBusPanInfoByName_TYPE)(CriAtomExAsrRackId rack_id, const CriChar8* bus_name, CriAtomExAsrBusPanInfo* pan_info);
typedef void (CRIAPI *criAtomExAsrRack_SetBusMatrixByName_TYPE)( CriAtomExAsrRackId rack_id, const CriChar8* bus_name, CriSint32 input_channels,  CriSint32 output_channels, const CriFloat32 matrix[]);
typedef void (CRIAPI *criAtomExAsrRack_SetBusSendLevelByName_TYPE)(CriAtomExAsrRackId rack_id, const CriChar8* bus_name, const CriChar8* sendto_bus_name, CriFloat32 level);
typedef void (CRIAPI *criAtomExAsrRack_SetEffectParameter_TYPE)(CriAtomExAsrRackId rack_id, const CriChar8* bus_name, const CriChar8* effect_name,  const CriUint32 parameter_index, const CriFloat32 parameter_value);
typedef void (CRIAPI *criAtomExAsrRack_UpdateEffectParameters_TYPE)(CriAtomExAsrRackId rack_id, const CriChar8* bus_name, const CriChar8* effect_name);
typedef CriFloat32 (CRIAPI *criAtomExAsrRack_GetEffectParameter_TYPE)(CriAtomExAsrRackId rack_id, const CriChar8* bus_name, const CriChar8* effect_name,  const CriUint32 parameter_index);
typedef void (CRIAPI *criAtomExAsrRack_SetEffectBypass_TYPE)(CriAtomExAsrRackId rack_id, const CriChar8* bus_name, const CriChar8* effect_name, const CriBool bypass);
typedef CriBool (CRIAPI *criAtomExAsrRack_GetEffectBypass_TYPE)(CriAtomExAsrRackId rack_id, const CriChar8* bus_name, const CriChar8* effect_name);
typedef void (CRIAPI *criAtomExAsrRack_AttachBusAnalyzerByName_TYPE)(CriAtomExAsrRackId rack_id,  const CriChar8* bus_name, const CriAtomExAsrBusAnalyzerConfig* config);
typedef void (CRIAPI *criAtomExAsrRack_DetachBusAnalyzerByName_TYPE)( CriAtomExAsrRackId rack_id, const CriChar8* bus_name);
typedef void (CRIAPI *criAtomExAsrRack_GetBusAnalyzerInfoByName_TYPE)(CriAtomExAsrRackId rack_id,  const CriChar8* bus_name, CriAtomExAsrBusAnalyzerInfo *info);
typedef void (CRIAPI *criAtomExAsrRack_SetBusFilterCallbackByName_TYPE)(CriAtomExAsrRackId rack_id,  const CriChar8* bus_name, CriAtomExAsrBusFilterCbFunc pre_func,  CriAtomExAsrBusFilterCbFunc post_func, void *obj);
typedef void (CRIAPI *criAtomExAsrRack_SetAlternateRackId_TYPE)( CriAtomExAsrRackId rack_id, CriAtomExAsrRackId alt_rack_id);
typedef CriSint32 (CRIAPI *criAtomExAsrRack_GetNumBuses_TYPE)(CriAtomExAsrRackId rack_id);
typedef CriSint32 (CRIAPI* criAtomExAsrRack_GetPcmDataFloat32_TYPE)(CriAtomExAsrRackId rack_id, CriSint32 output_channels, CriSint32 output_samples, CriFloat32* output_buffer[]);
typedef CriSint32 (CRIAPI* criAtomExAsrRack_GetNumBufferedSamples_TYPE)(CriAtomExAsrRackId rack_id);
typedef CriBool (CRIAPI *criAtomExAsrRack_GetAmplitudeAnalyzerRms_TYPE)(CriAtomExAsrRackId rack_id, CriSint32 bus_no, CriFloat32* rms, CriUint32 num_channels);
typedef CriBool (CRIAPI *criAtomExAsrRack_GetAmplitudeAnalyzerRmsByName_TYPE)(CriAtomExAsrRackId rack_id, const CriChar8* bus_name, CriFloat32* rms, CriUint32 num_channels);
typedef CriBool (CRIAPI *criAtomExAsrRack_GetCompressorGain_TYPE)(CriAtomExAsrRackId rack_id, CriSint32 bus_no, CriFloat32* gain, CriUint32 num_channels);
typedef CriBool (CRIAPI *criAtomExAsrRack_GetCompressorGainByName_TYPE)(CriAtomExAsrRackId rack_id, const CriChar8* bus_name, CriFloat32* gain, CriUint32 num_channels);
typedef CriBool (CRIAPI *criAtomExAsrRack_GetCompressorRms_TYPE)(CriAtomExAsrRackId rack_id, CriSint32 bus_no, CriFloat32* rms, CriUint32 num_channels);
typedef CriBool (CRIAPI *criAtomExAsrRack_GetCompressorRmsByName_TYPE)(CriAtomExAsrRackId rack_id, const CriChar8* bus_name, CriFloat32* rms, CriUint32 num_channels);
typedef CriSint32 (CRIAPI *criAtomAsr_CalculateWorkSize_TYPE)(const CriAtomAsrConfig *config);
typedef void (CRIAPI *criAtomAsr_Initialize_TYPE)( const CriAtomAsrConfig *config, void *work, CriSint32 work_size);
typedef void (CRIAPI *criAtomAsr_Finalize_TYPE)(void);
typedef void (CRIAPI *criAtomExAsr_PauseOutputVoice_TYPE)(CriBool sw);
typedef CriBool (CRIAPI *criAtomExAsrRack_GetNumOutputSamples_TYPE)( CriAtomExAsrRackId rack_id, CriSint64 *num_samples, CriSint32 *sampling_rate);
typedef CriUint16 (CRIAPI *criAtomExAsrRack_GetBusNumber_TYPE)( CriAtomExAsrRackId rack_id, const CriChar8 *bus_name);
typedef void (CRIAPI *criAtomAsr_PauseOutputVoice_TYPE)(CriBool sw);
typedef CriSint64 (CRIAPI *criAtomAsr_GetAudioTime_TYPE)(CriSint32 rack_id);
typedef CriSint32 (CRIAPI *criAtomExAsrRack_GetAmbisonicRackId_TYPE)(void);
typedef CriSint32 (CRIAPI* criAtomExAsrRack_GetChannelBasedAudioRackId_TYPE)(void);
typedef CriSint32 (CRIAPI* criAtomExAsrRack_GetObjectBasedAudioRackId_TYPE)(void);
typedef void (CRIAPI *criAtomExAsr_SetDspParameter_TYPE)( CriSint32 bus_no, CriAtomExAsrDspId dsp_id, const void* parameter);
typedef void (CRIAPI *criAtomExAsr_SetDspParameterByName_TYPE)( const CriChar8* bus_name, CriAtomExAsrDspId dsp_id, const void* parameter);
typedef void (CRIAPI *criAtomExAsr_GetDspParameter_TYPE)( CriSint32 bus_no, CriAtomExAsrDspId dsp_id, void* parameter_buf, CriSint32 parameter_size);
typedef void (CRIAPI *criAtomExAsr_GetDspParameterByName_TYPE)( const CriChar8* bus_name, CriAtomExAsrDspId dsp_id, void* parameter_buf, CriSint32 parameter_size);
typedef void (CRIAPI *criAtomExAsr_SetDspBypass_TYPE)( CriSint32 bus_no, CriAtomExAsrDspId dsp_id, CriBool bypass);
typedef void (CRIAPI *criAtomExAsr_SetDspBypassByName_TYPE)( const CriChar8* bus_name, CriAtomExAsrDspId dsp_id, CriBool bypass);
typedef void (CRIAPI *criAtomExAsr_SetBusVolume_TYPE)(CriSint32 bus_no, CriFloat32 volume);
typedef void (CRIAPI *criAtomExAsr_GetBusVolume_TYPE)(CriSint32 bus_no, CriFloat32 *volume);
typedef void (CRIAPI *criAtomExAsr_SetBusPan3d_TYPE)(CriSint32 bus_no,  CriFloat32 pan3d_angle, CriFloat32 pan3d_distance, CriFloat32 pan3d_volume);
typedef void (CRIAPI *criAtomExAsr_GetBusPan3d_TYPE)(CriSint32 bus_no,  CriFloat32 *pan3d_angle, CriFloat32 *pan3d_distance, CriFloat32 *pan3d_volume);
typedef void (CRIAPI *criAtomExAsr_SetBusMatrix_TYPE)(CriSint32 bus_no,  CriSint32 input_channels, CriSint32 output_channels, const CriFloat32 matrix[]);
typedef void (CRIAPI *criAtomExAsr_SetBusSendLevel_TYPE)( CriSint32 bus_no, CriSint32 sendto_no, CriFloat32 level);
typedef void (CRIAPI *criAtomExAsr_AttachBusAnalyzer_TYPE)( CriSint32 bus_no, const CriAtomExAsrBusAnalyzerConfig* config);
typedef void (CRIAPI *criAtomExAsr_DetachBusAnalyzer_TYPE)(CriSint32 bus_no);
typedef void (CRIAPI *criAtomExAsr_GetBusAnalyzerInfo_TYPE)( CriSint32 bus_no, CriAtomExAsrBusAnalyzerInfo *info);
typedef void (CRIAPI *criAtomExAsr_SetBusFilterCallback_TYPE)(CriSint32 bus_no,  CriAtomExAsrBusFilterCbFunc pre_func, CriAtomExAsrBusFilterCbFunc post_func, void *obj);
typedef void (CRIAPI *criAtomExAsrRack_SetDspParameter_TYPE)(CriAtomExAsrRackId rack_id,  CriSint32 bus_no, CriAtomExAsrDspId dsp_id, const void* parameter);
typedef void (CRIAPI *criAtomExAsrRack_SetDspParameterByName_TYPE)(CriAtomExAsrRackId rack_id,  const CriChar8* bus_name, CriAtomExAsrDspId dsp_id, const void* parameter);
typedef void (CRIAPI *criAtomExAsrRack_GetDspParameter_TYPE)(CriAtomExAsrRackId rack_id,  CriSint32 bus_no, CriAtomExAsrDspId dsp_id, void* parameter_buf, CriSint32 parameter_size);
typedef void (CRIAPI *criAtomExAsrRack_GetDspParameterByName_TYPE)(CriAtomExAsrRackId rack_id,  const CriChar8* bus_name, CriAtomExAsrDspId dsp_id, void* parameter_buf, CriSint32 parameter_size);
typedef void (CRIAPI *criAtomExAsrRack_SetDspBypass_TYPE)(CriAtomExAsrRackId rack_id,  CriSint32 bus_no, CriAtomExAsrDspId dsp_id, CriBool bypass);
typedef void (CRIAPI *criAtomExAsrRack_SetDspBypassByName_TYPE)(CriAtomExAsrRackId rack_id,  const CriChar8* bus_name, CriAtomExAsrDspId dsp_id, CriBool bypass);
typedef void (CRIAPI *criAtomExAsrRack_SetBusVolume_TYPE)(CriAtomExAsrRackId rack_id,  CriSint32 bus_no, CriFloat32 volume);
typedef void (CRIAPI *criAtomExAsrRack_GetBusVolume_TYPE)(CriAtomExAsrRackId rack_id,  CriSint32 bus_no, CriFloat32* volume);
typedef void (CRIAPI *criAtomExAsrRack_SetBusPan3d_TYPE)(CriAtomExAsrRackId rack_id, CriSint32 bus_no,  CriFloat32 pan3d_angle, CriFloat32 pan3d_distance, CriFloat32 pan3d_volume);
typedef void (CRIAPI *criAtomExAsrRack_GetBusPan3d_TYPE)(CriAtomExAsrRackId rack_id, CriSint32 bus_no,  CriFloat32 *pan3d_angle, CriFloat32 *pan3d_distance, CriFloat32 *pan3d_volume);
typedef void (CRIAPI *criAtomExAsrRack_SetBusMatrix_TYPE)( CriAtomExAsrRackId rack_id, CriSint32 bus_no, CriSint32 input_channels,  CriSint32 output_channels, const CriFloat32 matrix[]);
typedef void (CRIAPI *criAtomExAsrRack_SetBusSendLevel_TYPE)(CriAtomExAsrRackId rack_id, CriSint32 bus_no, CriSint32 sendto_no, CriFloat32 level);
typedef void (CRIAPI *criAtomExAsrRack_AttachBusAnalyzer_TYPE)(CriAtomExAsrRackId rack_id,  CriSint32 bus_no, const CriAtomExAsrBusAnalyzerConfig* config);
typedef void (CRIAPI *criAtomExAsrRack_DetachBusAnalyzer_TYPE)( CriAtomExAsrRackId rack_id, CriSint32 bus_no);
typedef void (CRIAPI *criAtomExAsrRack_GetBusAnalyzerInfo_TYPE)(CriAtomExAsrRackId rack_id,  CriSint32 bus_no, CriAtomExAsrBusAnalyzerInfo *info);
typedef void (CRIAPI *criAtomExAsrRack_SetBusFilterCallback_TYPE)(CriAtomExAsrRackId rack_id,  CriSint32 bus_no, CriAtomExAsrBusFilterCbFunc pre_func,  CriAtomExAsrBusFilterCbFunc post_func, void *obj);
typedef CriSint32 (CRIAPI *criAtomExOutputPort_CalculateWorkSize_TYPE)(const CriAtomExOutputPortConfig* config);
typedef CriAtomExOutputPortHn (CRIAPI *criAtomExOutputPort_Create_TYPE)(const CriAtomExOutputPortConfig* config, void* work, CriSint32 work_size);
typedef void (CRIAPI *criAtomExOutputPort_Destroy_TYPE)(CriAtomExOutputPortHn output_port);
typedef void (CRIAPI *criAtomExOutputPort_SetAsrRackId_TYPE)(CriAtomExOutputPortHn output_port, CriAtomExAsrRackId rack_id);
typedef void (CRIAPI *criAtomExOutputPort_SetVibrationChannelLevel_TYPE)(CriAtomExOutputPortHn output_port, CriSint32 channel, CriFloat32 level);
typedef void (CRIAPI *criAtomExOutputPort_SetMonauralMix_TYPE)(CriAtomExOutputPortHn output_port, CriBool monaural_mix);

typedef void (CRIAPI* criAtomEx_InitializeForUserPcmOutput_TYPE)(const CriAtomExConfigForUserPcmOutput* config, void* work, CriSint32 work_size);
typedef void (CRIAPI* criAtomEx_FinalizeForUserPcmOutput_TYPE)(void);
typedef CriBool (CRIAPI *criAtomEx_IsInitialized_TYPE)(void);
typedef void (CRIAPI *criAtomEx_ExecuteMain_TYPE)(void);
typedef void (CRIAPI *criAtomEx_ExecuteAudioProcess_TYPE)(void);
typedef void (CRIAPI *criAtomEx_Lock_TYPE)(void);
typedef void (CRIAPI *criAtomEx_Unlock_TYPE)(void);
typedef CriUint64 (CRIAPI *criAtomEx_GetTimeMicro_TYPE)(void);
typedef void (CRIAPI *criAtomEx_ResetTimer_TYPE)(void);
typedef void (CRIAPI *criAtomEx_PauseTimer_TYPE)(CriBool sw);
typedef void (CRIAPI *criAtomEx_SetConfigForWorkSizeCalculation_TYPE)(const CriAtomExConfig *config);
typedef CriSint32 (CRIAPI *criAtomEx_CalculateWorkSizeForRegisterAcfData_TYPE)( void *acf_data, CriSint32 acf_data_size);
typedef CriBool (CRIAPI *criAtomEx_RegisterAcfData_TYPE)( void *acf_data, CriSint32 acf_data_size, void *work, CriSint32 work_size);
typedef CriSint32 (CRIAPI *criAtomEx_CalculateWorkSizeForRegisterAcfFile_TYPE)( CriFsBinderHn binder, const CriChar8 *path);
typedef CriSint32 (CRIAPI *criAtomEx_CalculateWorkSizeForRegisterAcfFileById_TYPE)( CriFsBinderHn binder, CriUint16 id);
typedef CriBool (CRIAPI *criAtomEx_RegisterAcfFile_TYPE)( CriFsBinderHn binder, const CriChar8 *path, void *work, CriSint32 work_size);
typedef CriBool (CRIAPI *criAtomEx_RegisterAcfFileById_TYPE)( CriFsBinderHn binder, CriUint16 id, void *work, CriSint32 work_size);
typedef void (CRIAPI *criAtomEx_UnregisterAcf_TYPE)(void);
typedef CriUint32 (CRIAPI *criAtomEx_GetAcfVersion_TYPE)( void *acf_data, CriSint32 acf_data_size, CriBool *flag);
typedef CriUint32 (CRIAPI *criAtomEx_GetAcfVersionFromFile_TYPE)( CriFsBinderHn binder, const CriChar8 *path, void *work, CriSint32 work_size, CriBool *flag);
typedef CriUint32 (CRIAPI *criAtomEx_GetAcfVersionFromFileById_TYPE)( CriFsBinderHn binder, CriUint16 id, void *work, CriSint32 work_size, CriBool *flag);
typedef void (CRIAPI *criAtomEx_GetSupportedAcfVersion_TYPE)( CriUint32 *version_low, CriUint32 *version_high);
typedef CriBool (CRIAPI *criAtomEx_AnalyzeAudioHeader_TYPE)( const void *buffer, CriSint32 buffer_size, CriAtomExFormatInfo *info);
typedef void (CRIAPI *criAtomEx_SetRandomSeed_TYPE)(CriUint32 seed);
typedef CriBool (CRIAPI *criAtomEx_IsDataPlaying_TYPE)(void *buffer, CriSint32 size);
typedef CriSint32 (CRIAPI *criAtomEx_CalculateWorkSizeForDspBusSetting_TYPE)( const CriChar8 *setting);
typedef CriSint32 (CRIAPI *criAtomEx_CalculateWorkSizeForDspBusSettingFromAcfData_TYPE)( void *acf_data, CriSint32 acf_buffer_size, const CriChar8 *setting_name);
typedef void (CRIAPI *criAtomEx_AttachDspBusSetting_TYPE)( const CriChar8 *setting, void *work, CriSint32 work_size);
typedef void (CRIAPI *criAtomEx_DetachDspBusSetting_TYPE)(void);
typedef void (CRIAPI *criAtomEx_ApplyDspBusSnapshot_TYPE)(const CriChar8 *snapshot_name, CriSint32 time_ms);
typedef const CriChar8* (CRIAPI *criAtomEx_GetAppliedDspBusSnapshotName_TYPE)(void);
typedef void (CRIAPI *criAtomEx_SetCueLinkCallback_TYPE)(CriAtomExCueLinkCbFunc func, void* obj);
typedef void (CRIAPI *criAtomEx_SetSpeakerAngles_TYPE)(CriFloat32 angle_l, CriFloat32 angle_r, CriFloat32 angle_sl, CriFloat32 angle_sr);
typedef void (CRIAPI *criAtomEx_SetSpeakerAngleArray_TYPE)(CriAtomExSpeakerSystem speaker_system, const CriFloat32 *angle_array);
typedef void (CRIAPI *criAtomEx_SetVirtualSpeakerAngleArray_TYPE)(CriAtomExSpeakerSystem speaker_system, const CriFloat32 *angle_array);
typedef void (CRIAPI *criAtomEx_ControlVirtualSpeakerSetting_TYPE)(CriBool sw);
typedef CriSint32 (CRIAPI *criAtomEx_GetNumGameVariables_TYPE)(void);
typedef CriBool (CRIAPI *criAtomEx_GetGameVariableInfo_TYPE)(CriUint16 index, CriAtomExGameVariableInfo* info);
typedef CriFloat32 (CRIAPI *criAtomEx_GetGameVariableById_TYPE)(CriAtomExGameVariableId id);
typedef CriFloat32 (CRIAPI *criAtomEx_GetGameVariableByName_TYPE)(const CriChar8* name);
typedef void (CRIAPI *criAtomEx_SetGameVariableById_TYPE)(CriAtomExGameVariableId id, CriFloat32 value);
typedef void (CRIAPI *criAtomEx_SetGameVariableByName_TYPE)(const CriChar8* name, CriFloat32 value);
typedef void (CRIAPI *criAtomEx_SetPlaybackCancelCallback_TYPE)(CriAtomExPlaybackCancelCbFunc func, void* obj);
typedef void (CRIAPI *criAtomEx_ControlAcfConsistencyCheck_TYPE)(CriBool sw);
typedef void (CRIAPI *criAtomEx_SetAcfConsistencyCheckErrorLevel_TYPE)(CriErrorLevel level);
typedef void (CRIAPI *criAtomEx_SetTrackTransitionBySelectorCallback_TYPE)(CriAtomExTrackTransitionBySelectorCbFunc func, void* obj);
typedef void (CRIAPI *criAtomExDebug_GetResourcesInfo_TYPE)(CriAtomExDebugResourcesInfo *resources_info);
typedef CriSint32 (CRIAPI *criAtomExHcaMx_CalculateWorkSize_TYPE)(const CriAtomExHcaMxConfig *config);
typedef void (CRIAPI *criAtomExHcaMx_SetConfigForWorkSizeCalculation_TYPE)(const CriAtomExHcaMxConfig *config);
typedef void (CRIAPI *criAtomExHcaMx_Initialize_TYPE)( const CriAtomExHcaMxConfig *config, void *work, CriSint32 work_size);
typedef void (CRIAPI *criAtomExHcaMx_Finalize_TYPE)(void);
typedef void (CRIAPI *criAtomExHcaMx_SetFrequencyRatio_TYPE)(CriSint32 mixer_id, CriFloat32 ratio);
typedef void (CRIAPI *criAtomExHcaMx_SetAsrRackId_TYPE)(CriSint32 mixer_id, CriSint32 rack_id);
typedef CriSint32 (CRIAPI *criAtomExAcf_GetNumAisacControls_TYPE)(void);
typedef CriBool (CRIAPI *criAtomExAcf_GetAisacControlInfo_TYPE)(CriUint16 index, CriAtomExAisacControlInfo* info);
typedef CriAtomExAisacControlId (CRIAPI *criAtomExAcf_GetAisacControlIdByName_TYPE)(const CriChar8* name);
typedef const CriChar8 * (CRIAPI *criAtomExAcf_GetAisacControlNameById_TYPE)(CriAtomExAisacControlId id);
typedef CriSint32 (CRIAPI *criAtomExAcf_GetNumDspSettings_TYPE)(void);
typedef CriSint32 (CRIAPI *criAtomExAcf_GetNumDspSettingsFromAcfData_TYPE)( void *acf_data, CriSint32 acf_data_size);
typedef const CriChar8 * (CRIAPI *criAtomExAcf_GetDspSettingNameByIndex_TYPE)(CriUint16 index);
typedef const CriChar8 * (CRIAPI *criAtomExAcf_GetDspSettingNameByIndexFromAcfData_TYPE)( void *acf_data, CriSint32 acf_data_size, CriUint16 index);
typedef CriBool (CRIAPI *criAtomExAcf_GetDspSettingInformation_TYPE)(const CriChar8* name, CriAtomExAcfDspSettingInfo* info);
typedef CriBool (CRIAPI *criAtomExAcf_GetDspSettingSnapshotInformation_TYPE)(CriUint16 index, CriAtomExAcfDspSettingSnapshotInfo* info);
typedef CriBool (CRIAPI *criAtomExAcf_GetDspBusInformation_TYPE)(CriUint16 index, CriAtomExAcfDspBusInfo* info);
typedef CriUint32 (CRIAPI *criAtomExAcf_GetDspFxType_TYPE)(CriUint16 index);
typedef const CriChar8* (CRIAPI *criAtomExAcf_GetDspFxName_TYPE)(CriUint16 index);
typedef CriBool (CRIAPI *criAtomExAcf_GetDspFxParameters_TYPE)(CriUint16 index, void* parameters, CriSint32 size);
typedef CriBool (CRIAPI *criAtomExAcf_GetDspBusLinkInformation_TYPE)(CriUint16 index, CriAtomExAcfDspBusLinkInfo* info);
typedef CriSint32 (CRIAPI *criAtomExAcf_GetNumCategoriesFromAcfData_TYPE)( void *acf_data, CriSint32 acf_data_size);
typedef CriSint32 (CRIAPI *criAtomExAcf_GetNumCategories_TYPE)(void);
typedef CriSint32 (CRIAPI *criAtomExAcf_GetNumCategoriesPerPlaybackFromAcfData_TYPE)( void *acf_data, CriSint32 acf_data_size);
typedef CriSint32 (CRIAPI *criAtomExAcf_GetNumCategoriesPerPlayback_TYPE)(void);
typedef CriBool (CRIAPI *criAtomExAcf_GetCategoryInfo_TYPE)(CriUint16 index, CriAtomExCategoryInfo* info);
typedef CriBool (CRIAPI *criAtomExAcf_GetCategoryInfoByName_TYPE)(const CriChar8* name, CriAtomExCategoryInfo* info);
typedef CriBool (CRIAPI *criAtomExAcf_GetCategoryInfoById_TYPE)(CriUint32 id, CriAtomExCategoryInfo* info);
typedef CriSint32 (CRIAPI *criAtomExAcf_GetNumGlobalAisacs_TYPE)(void);
typedef CriBool (CRIAPI *criAtomExAcf_GetGlobalAisacInfo_TYPE)(CriUint16 index, CriAtomExGlobalAisacInfo* info);
typedef CriBool (CRIAPI *criAtomExAcf_GetGlobalAisacInfoByName_TYPE)(const CriChar8* name, CriAtomExGlobalAisacInfo* info);
typedef CriBool (CRIAPI *criAtomExAcf_GetGlobalAisacGraphInfo_TYPE)( const CriAtomExGlobalAisacInfo* aisac_info, CriUint16 graph_index, CriAtomExAisacGraphInfo* graph_info);
typedef CriBool (CRIAPI *criAtomExAcf_GetGlobalAisacValue_TYPE)( const CriAtomExGlobalAisacInfo* aisac_info, CriFloat32 control, CriAtomExAisacGraphType type, CriFloat32* value);
typedef CriBool (CRIAPI *criAtomExAcf_GetAcfInfo_TYPE)(CriAtomExAcfInfo *acf_info);
typedef CriBool (CRIAPI *criAtomExAcf_GetAcfInfoFromAcfData_TYPE)( void *acf_data, CriSint32 acf_data_size, CriAtomExAcfInfo *acf_info);
typedef CriSint32 (CRIAPI *criAtomExAcf_GetNumSelectors_TYPE)(void);
typedef CriBool (CRIAPI *criAtomExAcf_GetSelectorInfoByIndex_TYPE)(CriUint16 index, CriAtomExSelectorInfo* info);
typedef CriBool (CRIAPI *criAtomExAcf_GetSelectorInfoByName_TYPE)(const CriChar8* name, CriAtomExSelectorInfo* info);
typedef CriBool (CRIAPI *criAtomExAcf_GetSelectorLabelInfo_TYPE)( const CriAtomExSelectorInfo* selector_info, CriUint16 label_index, CriAtomExSelectorLabelInfo* label_info);
typedef void (CRIAPI *criAtomExAcf_SetGlobalLabelToSelectorByName_TYPE)(const CriChar8* selsector_name, const CriChar8* label_name);
typedef void (CRIAPI *criAtomExAcf_SetGlobalLabelToSelectorByIndex_TYPE)(CriUint16 selsector_index, CriUint16 label_index);
typedef CriSint32 (CRIAPI *criAtomExAcf_GetNumBusesFromAcfData_TYPE)( void *acf_data, CriSint32 acf_data_size);
typedef CriSint32 (CRIAPI *criAtomExAcf_GetNumBuses_TYPE)(void);
typedef CriSint32 (CRIAPI *criAtomExAcf_GetMaxBusesOfDspBusSettingsFromAcfData_TYPE)( void *acf_data, CriSint32 acf_data_size);
typedef CriSint32 (CRIAPI *criAtomExAcf_GetMaxBusesOfDspBusSettings_TYPE)(void);
typedef const CriChar8* (CRIAPI *criAtomExAcf_FindBusName_TYPE)(const CriChar8* bus_name);
typedef CriAtomExOutputPortHn (CRIAPI *criAtomExAcf_GetOutputPortHnByName_TYPE)(const CriChar8* name);
typedef void (CRIAPI* criAtomExAcf_DoCreateSpatialAsrRack_TYPE)(CriBool do_create);
typedef CriSint32 (CRIAPI *criAtomExAcb_CalculateWorkSizeForLoadAcbData_TYPE)( void *acb_data, CriSint32 acb_data_size, CriFsBinderHn awb_binder, const CriChar8 *awb_path);
typedef CriSint32 (CRIAPI *criAtomExAcb_CalculateWorkSizeForLoadAcbDataById_TYPE)( void *acb_data, CriSint32 acb_data_size, CriFsBinderHn awb_binder, CriUint16 awb_id);
typedef CriAtomExAcbHn (CRIAPI *criAtomExAcb_LoadAcbData_TYPE)( void *acb_data, CriSint32 acb_data_size, CriFsBinderHn awb_binder, const CriChar8 *awb_path, void *work, CriSint32 work_size);
typedef CriAtomExAcbHn (CRIAPI *criAtomExAcb_LoadAcbDataById_TYPE)( void *acb_data, CriSint32 acb_data_size, CriFsBinderHn awb_binder, CriUint16 awb_id, void *work, CriSint32 work_size);
typedef CriSint32 (CRIAPI *criAtomExAcb_CalculateWorkSizeForLoadAcbFile_TYPE)( CriFsBinderHn acb_binder, const CriChar8 *acb_path, CriFsBinderHn awb_binder, const CriChar8 *awb_path);
typedef CriSint32 (CRIAPI *criAtomExAcb_CalculateWorkSizeForLoadAcbFileById_TYPE)( CriFsBinderHn acb_binder, CriUint16 acb_id, CriFsBinderHn awb_binder, CriUint16 awb_id);
typedef CriAtomExAcbHn (CRIAPI *criAtomExAcb_LoadAcbFile_TYPE)( CriFsBinderHn acb_binder, const CriChar8 *acb_path, CriFsBinderHn awb_binder, const CriChar8 *awb_path, void *work, CriSint32 work_size);
typedef CriAtomExAcbHn (CRIAPI *criAtomExAcb_LoadAcbFileById_TYPE)( CriFsBinderHn acb_binder, CriUint16 acb_id, CriFsBinderHn awb_binder, CriUint16 awb_id, void *work, CriSint32 work_size);
typedef void (CRIAPI *criAtomExAcb_Release_TYPE)(CriAtomExAcbHn acb_hn);
typedef CriBool (CRIAPI *criAtomExAcb_IsReadyToRelease_TYPE)(CriAtomExAcbHn acb_hn);
typedef void (CRIAPI *criAtomExAcb_ReleaseAll_TYPE)(void);
typedef CriSint32 (CRIAPI *criAtomExAcb_EnumerateHandles_TYPE)(CriAtomExAcbHandleCbFunc func, void *obj);
typedef CriUint32 (CRIAPI *criAtomExAcb_GetVersion_TYPE)( void *acb_data, CriSint32 acb_data_size, void *flag);
typedef CriUint32 (CRIAPI *criAtomExAcb_GetVersionFromFile_TYPE)( CriFsBinderHn acb_binder, const CriChar8 *acb_path, void *work, CriSint32 work_size, CriBool *flag);
typedef void (CRIAPI *criAtomExAcb_GetSupportedVersion_TYPE)( CriUint32 *version_low, CriUint32 *version_high);
typedef CriSint32 (CRIAPI *criAtomExAcb_GetNumCues_TYPE)(CriAtomExAcbHn acb_hn);
typedef CriBool (CRIAPI *criAtomExAcb_ExistsId_TYPE)(CriAtomExAcbHn acb_hn, CriAtomExCueId id);
typedef CriBool (CRIAPI *criAtomExAcb_ExistsName_TYPE)(CriAtomExAcbHn acb_hn, const CriChar8 *name);
typedef CriBool (CRIAPI *criAtomExAcb_ExistsIndex_TYPE)(CriAtomExAcbHn acb_hn, CriAtomExCueIndex index);
typedef CriAtomExCueId (CRIAPI *criAtomExAcb_GetCueIdByIndex_TYPE)(CriAtomExAcbHn acb_hn, CriAtomExCueIndex index);
typedef CriAtomExCueId (CRIAPI *criAtomExAcb_GetCueIdByName_TYPE)(CriAtomExAcbHn acb_hn, const CriChar8* name);
typedef const CriChar8 * (CRIAPI *criAtomExAcb_GetCueNameByIndex_TYPE)(CriAtomExAcbHn acb_hn, CriAtomExCueIndex index);
typedef const CriChar8 * (CRIAPI *criAtomExAcb_GetCueNameById_TYPE)(CriAtomExAcbHn acb_hn, CriAtomExCueId id);
typedef CriAtomExCueIndex (CRIAPI *criAtomExAcb_GetCueIndexById_TYPE)(CriAtomExAcbHn acb_hn, CriAtomExCueId id);
typedef CriAtomExCueIndex (CRIAPI *criAtomExAcb_GetCueIndexByName_TYPE)(CriAtomExAcbHn acb_hn, const CriChar8* name);
typedef const CriChar8 * (CRIAPI *criAtomExAcb_GetUserDataById_TYPE)(CriAtomExAcbHn acb_hn, CriAtomExCueId id);
typedef const CriChar8 * (CRIAPI *criAtomExAcb_GetUserDataByName_TYPE)(CriAtomExAcbHn acb_hn, const CriChar8 *name);
typedef CriSint64 (CRIAPI *criAtomExAcb_GetLengthById_TYPE)(CriAtomExAcbHn acb_hn, CriAtomExCueId id);
typedef CriSint64 (CRIAPI *criAtomExAcb_GetLengthByName_TYPE)(CriAtomExAcbHn acb_hn, const CriChar8 *name);
typedef CriSint32 (CRIAPI *criAtomExAcb_GetNumUsableAisacControlsById_TYPE)(CriAtomExAcbHn acb_hn, CriAtomExCueId id);
typedef CriSint32 (CRIAPI *criAtomExAcb_GetNumUsableAisacControlsByName_TYPE)(CriAtomExAcbHn acb_hn, const CriChar8 *name);
typedef CriBool (CRIAPI *criAtomExAcb_GetUsableAisacControlById_TYPE)(CriAtomExAcbHn acb_hn, CriAtomExCueId id, CriUint16 index, CriAtomExAisacControlInfo* info);
typedef CriBool (CRIAPI *criAtomExAcb_GetUsableAisacControlByName_TYPE)(CriAtomExAcbHn acb_hn, const CriChar8 *name, CriUint16 index, CriAtomExAisacControlInfo* info);
typedef CriBool (CRIAPI *criAtomExAcb_IsUsingAisacControlById_TYPE)(CriAtomExAcbHn acb_hn, CriAtomExCueId id, CriAtomExAisacControlId aisac_control_id);
typedef CriBool (CRIAPI *criAtomExAcb_IsUsingAisacControlByName_TYPE)(CriAtomExAcbHn acb_hn, const CriChar8 *name, const CriChar8 *aisac_control_name);
typedef CriSint32 (CRIAPI *criAtomExAcb_GetCuePriorityById_TYPE)(CriAtomExAcbHn acb_hn, CriAtomExCueId id);
typedef CriSint32 (CRIAPI *criAtomExAcb_GetCuePriorityByName_TYPE)(CriAtomExAcbHn acb_hn, const CriChar8 *name);
typedef CriBool (CRIAPI *criAtomExAcb_GetWaveformInfoById_TYPE)( CriAtomExAcbHn acb_hn, CriAtomExCueId id, CriAtomExWaveformInfo *waveform_info);
typedef CriBool (CRIAPI *criAtomExAcb_GetWaveformInfoByName_TYPE)( CriAtomExAcbHn acb_hn, const CriChar8 *name, CriAtomExWaveformInfo *waveform_info);
typedef CriAtomAwbHn (CRIAPI *criAtomExAcb_GetOnMemoryAwbHandle_TYPE)(CriAtomExAcbHn acb_hn);
typedef CriAtomAwbHn (CRIAPI *criAtomExAcb_GetStreamingAwbHandle_TYPE)(CriAtomExAcbHn acb_hn);
typedef CriAtomAwbHn (CRIAPI *criAtomExAcb_GetStreamingAwbHandleBySlotIndex_TYPE)(CriAtomExAcbHn acb_hn, CriUint16 awb_slot_index);
typedef CriAtomAwbHn (CRIAPI *criAtomExAcb_GetStreamingAwbHandleBySlotName_TYPE)(CriAtomExAcbHn acb_hn, const CriChar8* awb_slot_name);
typedef CriBool (CRIAPI *criAtomExAcb_GetCueInfoByName_TYPE)(CriAtomExAcbHn acb_hn, const CriChar8* name, CriAtomExCueInfo* info);
typedef CriBool (CRIAPI *criAtomExAcb_GetCueInfoById_TYPE)(CriAtomExAcbHn acb_hn, CriAtomExCueId id, CriAtomExCueInfo* info);
typedef CriBool (CRIAPI *criAtomExAcb_GetCueInfoByIndex_TYPE)(CriAtomExAcbHn acb_hn, CriAtomExCueIndex index, CriAtomExCueInfo* info);
typedef CriSint32 (CRIAPI *criAtomExAcb_GetNumCuePlayingCountByName_TYPE)(CriAtomExAcbHn acb_hn, const CriChar8* name);
typedef CriSint32 (CRIAPI *criAtomExAcb_GetNumCuePlayingCountById_TYPE)(CriAtomExAcbHn acb_hn, CriAtomExCueId id);
typedef CriSint32 (CRIAPI *criAtomExAcb_GetNumCuePlayingCountByIndex_TYPE)(CriAtomExAcbHn acb_hn, CriAtomExCueIndex index);
typedef CriAtomExBlockIndex (CRIAPI *criAtomExAcb_GetBlockIndexByIndex_TYPE)(CriAtomExAcbHn acb_hn, CriAtomExCueIndex index, const CriChar8* block_name);
typedef CriAtomExBlockIndex (CRIAPI *criAtomExAcb_GetBlockIndexById_TYPE)(CriAtomExAcbHn acb_hn, CriAtomExCueId id, const CriChar8* block_name);
typedef CriAtomExBlockIndex (CRIAPI *criAtomExAcb_GetBlockIndexByName_TYPE)(CriAtomExAcbHn acb_hn, const CriChar8* name, const CriChar8* block_name);
typedef void (CRIAPI *criAtomExAcb_SetDetectionInGamePreviewDataCallback_TYPE)(CriAtomExAcbDetectionInGamePreviewDataCbFunc func, void* obj);
typedef CriBool (CRIAPI *criAtomExAcb_GetAcbInfo_TYPE)(CriAtomExAcbHn acb_hn, CriAtomExAcbInfo *acb_info);
typedef void (CRIAPI *criAtomExAcb_ResetCueTypeStateByName_TYPE)(CriAtomExAcbHn acb_hn, const CriChar8* name);
typedef void (CRIAPI *criAtomExAcb_ResetCueTypeStateById_TYPE)(CriAtomExAcbHn acb_hn, CriAtomExCueId id);
typedef void (CRIAPI *criAtomExAcb_ResetCueTypeStateByIndex_TYPE)(CriAtomExAcbHn acb_hn, CriAtomExCueIndex index);
typedef void (CRIAPI *criAtomExAcb_AttachAwbFile_TYPE)( CriAtomExAcbHn acb_hn, CriFsBinderHn awb_binder, const CriChar8* awb_path, const CriChar8* awb_name, void* work, CriSint32 work_size);
typedef void (CRIAPI *criAtomExAcb_DetachAwbFile_TYPE)( CriAtomExAcbHn acb_hn, const CriChar8* awb_name);
typedef void (CRIAPI* criAtomExAcb_AttachAwbHn_TYPE)(CriAtomExAcbHn acb_hn, CriAtomAwbHn awb_hn);
typedef CriSint32 (CRIAPI *criAtomExAcb_CalculateWorkSizeForAttachAwbFile_TYPE)( CriFsBinderHn awb_binder, const CriChar8* awb_path);
typedef CriSint32 (CRIAPI *criAtomExAcb_GetNumAwbFileSlots_TYPE)( CriAtomExAcbHn acb_hn);
typedef const CriChar8* (CRIAPI *criAtomExAcb_GetAwbFileSlotName_TYPE)( CriAtomExAcbHn acb_hn, CriUint16 index);
typedef CriBool (CRIAPI *criAtomExAcb_IsAttachedAwbFile_TYPE)( CriAtomExAcbHn acb_hn, const CriChar8* awb_name);
typedef CriSint32 (CRIAPI *criAtomExVoicePool_CalculateWorkSizeForStandardVoicePool_TYPE)( const CriAtomExStandardVoicePoolConfig *config);
typedef CriAtomExVoicePoolHn (CRIAPI *criAtomExVoicePool_AllocateStandardVoicePool_TYPE)( const CriAtomExStandardVoicePoolConfig *config, void *work, CriSint32 work_size);
typedef CriSint32 (CRIAPI *criAtomExVoicePool_CalculateWorkSizeForAdxVoicePool_TYPE)( const CriAtomExAdxVoicePoolConfig *config);
typedef CriAtomExVoicePoolHn (CRIAPI *criAtomExVoicePool_AllocateAdxVoicePool_TYPE)( const CriAtomExAdxVoicePoolConfig *config, void *work, CriSint32 work_size);
typedef CriSint32 (CRIAPI *criAtomExVoicePool_CalculateWorkSizeForHcaVoicePool_TYPE)( const CriAtomExHcaVoicePoolConfig *config);
typedef CriAtomExVoicePoolHn (CRIAPI *criAtomExVoicePool_AllocateHcaVoicePool_TYPE)( const CriAtomExHcaVoicePoolConfig *config, void *work, CriSint32 work_size);
typedef CriSint32 (CRIAPI *criAtomExVoicePool_CalculateWorkSizeForHcaMxVoicePool_TYPE)( const CriAtomExHcaMxVoicePoolConfig *config);
typedef CriAtomExVoicePoolHn (CRIAPI *criAtomExVoicePool_AllocateHcaMxVoicePool_TYPE)( const CriAtomExHcaMxVoicePoolConfig *config, void *work, CriSint32 work_size);
typedef CriSint32 (CRIAPI *criAtomExVoicePool_CalculateWorkSizeForWaveVoicePool_TYPE)( const CriAtomExWaveVoicePoolConfig *config);
typedef CriAtomExVoicePoolHn (CRIAPI *criAtomExVoicePool_AllocateWaveVoicePool_TYPE)( const CriAtomExWaveVoicePoolConfig *config, void *work, CriSint32 work_size);
typedef CriSint32 (CRIAPI *criAtomExVoicePool_CalculateWorkSizeForAiffVoicePool_TYPE)( const CriAtomExAiffVoicePoolConfig *config);
typedef CriAtomExVoicePoolHn (CRIAPI *criAtomExVoicePool_AllocateAiffVoicePool_TYPE)( const CriAtomExAiffVoicePoolConfig *config, void *work, CriSint32 work_size);
typedef CriSint32 (CRIAPI *criAtomExVoicePool_CalculateWorkSizeForRawPcmVoicePool_TYPE)( const CriAtomExRawPcmVoicePoolConfig *config);
typedef CriAtomExVoicePoolHn (CRIAPI *criAtomExVoicePool_AllocateRawPcmVoicePool_TYPE)( const CriAtomExRawPcmVoicePoolConfig *config, void *work, CriSint32 work_size);
typedef CriAtomExVoicePoolHn (CRIAPI *criAtomExVoicePool_AllocateInstrumentVoicePool_TYPE)( const CriAtomExInstrumentVoicePoolConfig *config, void *work, CriSint32 work_size);
typedef void (CRIAPI *criAtomExVoicePool_Free_TYPE)(CriAtomExVoicePoolHn pool);
typedef void (CRIAPI *criAtomExVoicePool_FreeAll_TYPE)(void);
typedef void (CRIAPI *criAtomExVoicePool_GetNumUsedVoices_TYPE)( CriAtomExVoicePoolHn pool, CriSint32 *cur_num, CriSint32 *limit);
typedef CriAtomPlayerHn (CRIAPI *criAtomExVoicePool_GetPlayerHandle_TYPE)( CriAtomExVoicePoolHn pool, CriSint32 index);
typedef CriSint32 (CRIAPI *criAtomExVoicePool_CalculateWorkSizeForInstrumentVoicePool_TYPE)( const CriAtomExInstrumentVoicePoolConfig *config);
typedef struct CriAtomExInputPortConfigTag {
	CriAtomExInputPortType type;
	CriSint32 num_channels;
	CriSint32 sampling_rate;
	CriSint32 num_grains;	
	CriSint32 buffering_time;
	void* context;
} CriAtomExInputPortConfig;
typedef CriAtomExInputPortHn (CRIAPI* criAtomExInputPort_Create_TYPE)(const CriAtomExInputPortConfig* config, void* work, CriSint32 work_size);
typedef void (CRIAPI* criAtomExInputPort_Destroy_TYPE)(CriAtomExInputPortHn port);
typedef void (CRIAPI *criAtomExCategory_SetVolumeById_TYPE)(CriAtomExCategoryId id, CriFloat32 volume);
typedef CriFloat32 (CRIAPI *criAtomExCategory_GetVolumeById_TYPE)(CriAtomExCategoryId id);
typedef CriFloat32 (CRIAPI *criAtomExCategory_GetTotalVolumeById_TYPE)(CriAtomExCategoryId id);
typedef void (CRIAPI *criAtomExCategory_SetVolumeByName_TYPE)(const CriChar8* name, CriFloat32 volume);
typedef CriFloat32 (CRIAPI *criAtomExCategory_GetVolumeByName_TYPE)(const CriChar8* name);
typedef CriFloat32 (CRIAPI *criAtomExCategory_GetTotalVolumeByName_TYPE)(const CriChar8* name);
typedef void (CRIAPI *criAtomExCategory_MuteById_TYPE)(CriAtomExCategoryId id, CriBool mute);
typedef CriBool (CRIAPI *criAtomExCategory_IsMutedById_TYPE)(CriAtomExCategoryId id);
typedef void (CRIAPI *criAtomExCategory_MuteByName_TYPE)(const CriChar8* name, CriBool mute);
typedef CriBool (CRIAPI *criAtomExCategory_IsMutedByName_TYPE)(const CriChar8* name);
typedef void (CRIAPI *criAtomExCategory_SoloById_TYPE)(CriAtomExCategoryId id, CriBool solo, CriFloat32 mute_volume);
typedef CriBool (CRIAPI *criAtomExCategory_IsSoloedById_TYPE)(CriAtomExCategoryId id);
typedef void (CRIAPI *criAtomExCategory_SoloByName_TYPE)(const CriChar8* name, CriBool solo, CriFloat32 mute_volume);
typedef CriBool (CRIAPI *criAtomExCategory_IsSoloedByName_TYPE)(const CriChar8* name);
typedef void (CRIAPI *criAtomExCategory_PauseById_TYPE)(CriAtomExCategoryId id, CriBool sw);
typedef CriBool (CRIAPI *criAtomExCategory_IsPausedById_TYPE)(CriAtomExCategoryId id);
typedef void (CRIAPI *criAtomExCategory_PauseByName_TYPE)(const CriChar8* name, CriBool sw);
typedef CriBool (CRIAPI *criAtomExCategory_IsPausedByName_TYPE)(const CriChar8* name);
typedef void (CRIAPI *criAtomExCategory_SetFadeInTimeById_TYPE)(CriAtomExCategoryId id, CriUint16 ms);
typedef void (CRIAPI *criAtomExCategory_SetFadeInTimeByName_TYPE)(const CriChar8* name, CriUint16 ms);
typedef void (CRIAPI *criAtomExCategory_SetFadeOutTimeById_TYPE)(CriAtomExCategoryId id, CriUint16 ms);
typedef void (CRIAPI *criAtomExCategory_SetFadeOutTimeByName_TYPE)(const CriChar8* name, CriUint16 ms);
typedef void (CRIAPI *criAtomExCategory_SetAisacControlById_TYPE)( CriAtomExCategoryId id, CriAtomExAisacControlId control_id, CriFloat32 control_value);
typedef void (CRIAPI *criAtomExCategory_SetAisacControlByName_TYPE)( const CriChar8* name, const CriChar8* control_name, CriFloat32 control_value);
typedef CriBool (CRIAPI *criAtomExCategory_ResetAllAisacControlById_TYPE)(CriAtomExCategoryId category_id);
typedef CriBool (CRIAPI *criAtomExCategory_ResetAllAisacControlByName_TYPE)(const CriChar8* category_name);
typedef void (CRIAPI *criAtomExCategory_AttachAisacById_TYPE)(CriAtomExCategoryId id, const CriChar8* global_aisac_name);
typedef void (CRIAPI *criAtomExCategory_AttachAisacByName_TYPE)(const CriChar8* name, const CriChar8* global_aisac_name);
typedef void (CRIAPI *criAtomExCategory_DetachAisacById_TYPE)(CriAtomExCategoryId id, const CriChar8* global_aisac_name);
typedef void (CRIAPI *criAtomExCategory_DetachAisacByName_TYPE)(const CriChar8* name, const CriChar8* global_aisac_name);
typedef void (CRIAPI *criAtomExCategory_DetachAisacAllById_TYPE)(CriAtomExCategoryId id);
typedef void (CRIAPI *criAtomExCategory_DetachAisacAllByName_TYPE)(const CriChar8* name);
typedef CriSint32 (CRIAPI *criAtomExCategory_GetNumAttachedAisacsById_TYPE)(CriAtomExCategoryId id);
typedef CriSint32 (CRIAPI *criAtomExCategory_GetNumAttachedAisacsByName_TYPE)(const CriChar8* name);
typedef CriBool (CRIAPI *criAtomExCategory_GetAttachedAisacInfoById_TYPE)( CriAtomExCategoryId id,  CriSint32 aisac_attached_index, CriAtomExAisacInfo *aisac_info);
typedef CriBool (CRIAPI *criAtomExCategory_GetAttachedAisacInfoByName_TYPE)( const CriChar8* name, CriSint32 aisac_attached_index, CriAtomExAisacInfo *aisac_info);
typedef CriBool (CRIAPI *criAtomExCategory_GetCurrentAisacControlValueById_TYPE)( CriAtomExCategoryId category_id, CriAtomExAisacControlId aisac_control_id, CriFloat32 * control_value);
typedef CriBool (CRIAPI *criAtomExCategory_GetCurrentAisacControlValueByName_TYPE)( const CriChar8* category_name, const CriChar8* aisac_control_name, CriFloat32 * control_value);
typedef void (CRIAPI *criAtomExCategory_SetReactParameter_TYPE)( const CriChar8* react_name,  const CriAtomExReactParameter* react_parameter);
typedef CriBool (CRIAPI *criAtomExCategory_GetReactParameter_TYPE)( const CriChar8* react_name,  CriAtomExReactParameter* react_parameter);
typedef CriSint32 (CRIAPI *criAtomExCategory_GetNumCuePlayingCountById_TYPE)(CriAtomExCategoryId id);
typedef CriSint32 (CRIAPI *criAtomExCategory_GetNumCuePlayingCountByName_TYPE)(const CriChar8* name);
typedef void (CRIAPI *criAtomExCategory_StopById_TYPE)(CriAtomExCategoryId id);
typedef void (CRIAPI *criAtomExCategory_StopByName_TYPE)(const CriChar8* name);
typedef void (CRIAPI *criAtomExCategory_StopWithoutReleaseTimeById_TYPE)(CriAtomExCategoryId id);
typedef void (CRIAPI *criAtomExCategory_StopWithoutReleaseTimeByName_TYPE)(const CriChar8* name);
typedef CriSint32 (CRIAPI *criAtomExPlayer_CalculateWorkSize_TYPE)( const CriAtomExPlayerConfig *config);
typedef CriAtomExPlayerHn (CRIAPI *criAtomExPlayer_Create_TYPE)( const CriAtomExPlayerConfig *config, void *work, CriSint32 work_size);
typedef void (CRIAPI *criAtomExPlayer_Destroy_TYPE)(CriAtomExPlayerHn player);
typedef void (CRIAPI *criAtomExPlayer_SetCueId_TYPE)( CriAtomExPlayerHn player, CriAtomExAcbHn acb_hn, CriAtomExCueId id);
typedef void (CRIAPI *criAtomExPlayer_SetCueName_TYPE)( CriAtomExPlayerHn player, CriAtomExAcbHn acb_hn, const CriChar8 *cue_name);
typedef void (CRIAPI *criAtomExPlayer_SetCueIndex_TYPE)( CriAtomExPlayerHn player, CriAtomExAcbHn acb_hn, CriAtomExCueIndex index);
typedef void (CRIAPI *criAtomExPlayer_SetData_TYPE)( CriAtomExPlayerHn player, void *buffer, CriSint32 size);
typedef void (CRIAPI *criAtomExPlayer_SetFile_TYPE)( CriAtomExPlayerHn player, CriFsBinderHn binder, const CriChar8 *path);
typedef void (CRIAPI *criAtomExPlayer_SetContentId_TYPE)( CriAtomExPlayerHn player, CriFsBinderHn binder, CriSint32 id);
typedef void (CRIAPI *criAtomExPlayer_SetWaveId_TYPE)( CriAtomExPlayerHn player, CriAtomAwbHn awb, CriAtomExWaveId id);
typedef CriAtomExPlaybackId (CRIAPI *criAtomExPlayer_Start_TYPE)(CriAtomExPlayerHn player);
typedef CriAtomExPlaybackId (CRIAPI *criAtomExPlayer_Prepare_TYPE)(CriAtomExPlayerHn player);
typedef void (CRIAPI *criAtomExPlayer_Stop_TYPE)(CriAtomExPlayerHn player);
typedef void (CRIAPI *criAtomExPlayer_StopWithoutReleaseTime_TYPE)(CriAtomExPlayerHn player);
typedef void (CRIAPI *criAtomExPlayer_StopAllPlayers_TYPE)(void);
typedef void (CRIAPI *criAtomExPlayer_StopAllPlayersWithoutReleaseTime_TYPE)(void);
typedef void (CRIAPI *criAtomExPlayer_EnumeratePlayers_TYPE)(CriAtomExPlayerCbFunc func, void *obj);
typedef void (CRIAPI *criAtomExPlayer_Pause_TYPE)(CriAtomExPlayerHn player, CriBool sw);
typedef void (CRIAPI *criAtomExPlayer_Resume_TYPE)(CriAtomExPlayerHn player, CriAtomExResumeMode mode);
typedef CriBool (CRIAPI *criAtomExPlayer_IsPaused_TYPE)(CriAtomExPlayerHn player);
typedef CriAtomExPlayerStatus (CRIAPI *criAtomExPlayer_GetStatus_TYPE)(CriAtomExPlayerHn player);
typedef CriSint32 (CRIAPI *criAtomExPlayer_GetNumPlaybacks_TYPE)(CriAtomExPlayerHn player);
typedef CriAtomExPlaybackId (CRIAPI *criAtomExPlayer_GetLastPlaybackId_TYPE)(CriAtomExPlayerHn player);
typedef CriSint64 (CRIAPI *criAtomExPlayer_GetTime_TYPE)(CriAtomExPlayerHn player);
typedef void (CRIAPI *criAtomExPlayer_SetFormat_TYPE)( CriAtomExPlayerHn player, CriAtomExFormat format);
typedef void (CRIAPI *criAtomExPlayer_SetNumChannels_TYPE)( CriAtomExPlayerHn player, CriSint32 num_channels);
typedef void (CRIAPI *criAtomExPlayer_SetSamplingRate_TYPE)( CriAtomExPlayerHn player, CriSint32 sampling_rate);
typedef void (CRIAPI *criAtomExPlayer_SetSoundRendererType_TYPE)( CriAtomExPlayerHn player, CriAtomSoundRendererType type);
typedef void (CRIAPI *criAtomExPlayer_SetGroupNumber_TYPE)( CriAtomExPlayerHn player, CriSint32 group_no);
typedef void (CRIAPI *criAtomExPlayer_SetVoiceControlMethod_TYPE)( CriAtomExPlayerHn player, CriAtomExVoiceControlMethod method);
typedef void (CRIAPI *criAtomExPlayer_SetVoicePoolIdentifier_TYPE)( CriAtomExPlayerHn player, CriAtomExVoicePoolIdentifier identifier);
typedef void (CRIAPI *criAtomExPlayer_SetInputPort_TYPE)(CriAtomExPlayerHn player, CriAtomExInputPortHn port);
typedef void (CRIAPI *criAtomExPlayer_SetHcaMxMixerId_TYPE)(CriAtomExPlayerHn player, CriSint32 mixer_id);
typedef void (CRIAPI *criAtomExPlayer_SetAsrRackId_TYPE)(CriAtomExPlayerHn player, CriSint32 rack_id);
typedef void (CRIAPI *criAtomExPlayer_SetAsrRackIdArray_TYPE)( CriAtomExPlayerHn player, const CriSint32 *rack_id_array, CriSint32 num_racks);
typedef void (CRIAPI *criAtomExPlayer_SetStartTime_TYPE)( CriAtomExPlayerHn player, CriSint64 start_time_ms);
typedef void (CRIAPI *criAtomExPlayer_SetSyncPlaybackId_TYPE)( CriAtomExPlayerHn player, CriAtomExPlaybackId playback_id);
typedef void (CRIAPI *criAtomExPlayer_SetPlaybackRatio_TYPE)( CriAtomExPlayerHn player, CriFloat32 playback_ratio);
typedef void (CRIAPI *criAtomExPlayer_LimitLoopCount_TYPE)(CriAtomExPlayerHn player, CriSint32 count);
typedef void (CRIAPI *criAtomExPlayer_UpdateAll_TYPE)(CriAtomExPlayerHn player);
typedef void (CRIAPI *criAtomExPlayer_Update_TYPE)( CriAtomExPlayerHn player, CriAtomExPlaybackId id);
typedef void (CRIAPI *criAtomExPlayer_ResetParameters_TYPE)(CriAtomExPlayerHn player);
typedef CriFloat32 (CRIAPI *criAtomExPlayer_GetParameterFloat32_TYPE)(CriAtomExPlayerHn player, CriAtomExParameterId id);
typedef CriUint32 (CRIAPI *criAtomExPlayer_GetParameterUint32_TYPE)(CriAtomExPlayerHn player, CriAtomExParameterId id);
typedef CriSint32 (CRIAPI *criAtomExPlayer_GetParameterSint32_TYPE)(CriAtomExPlayerHn player, CriAtomExParameterId id);
typedef void (CRIAPI *criAtomExPlayer_SetVolume_TYPE)( CriAtomExPlayerHn player, CriFloat32 volume);
typedef void (CRIAPI *criAtomExPlayer_SetPitch_TYPE)(CriAtomExPlayerHn player, CriFloat32 pitch);
typedef void (CRIAPI *criAtomExPlayer_SetMaxPitch_TYPE)(CriAtomExPlayerHn player, CriFloat32 pitch);
typedef void (CRIAPI *criAtomExPlayer_SetPan3dAngle_TYPE)( CriAtomExPlayerHn player, CriFloat32 pan3d_angle);
typedef void (CRIAPI *criAtomExPlayer_SetPan3dInteriorDistance_TYPE)( CriAtomExPlayerHn player, CriFloat32 pan3d_interior_distance);
typedef void (CRIAPI *criAtomExPlayer_SetPan3dVolume_TYPE)( CriAtomExPlayerHn player, CriFloat32 pan3d_volume);
typedef void (CRIAPI *criAtomExPlayer_SetPanType_TYPE)( CriAtomExPlayerHn player, CriAtomExPanType pan_type);
typedef void (CRIAPI *criAtomExPlayer_SetPanSpeakerType_TYPE)( CriAtomExPlayerHn player, CriAtomExPanSpeakerType pan_speaker_type);
typedef void (CRIAPI *criAtomExPlayer_AddMixDownCenterVolumeOffset_TYPE)( CriAtomExPlayerHn player, CriFloat32 mixdown_center_volume_offset);
typedef void (CRIAPI *criAtomExPlayer_AddMixDownLfeVolumeOffset_TYPE)( CriAtomExPlayerHn player, CriFloat32 mixdown_lfe_volume_offset);
typedef void (CRIAPI *criAtomExPlayer_ChangeDefaultPanSpeakerType_TYPE)( CriAtomExPanSpeakerType pan_speaker_type);
typedef void (CRIAPI *criAtomExPlayer_SetPanAngleType_TYPE)( CriAtomExPlayerHn player, CriAtomExPanAngleType pan_angle_type);
typedef void (CRIAPI *criAtomExPlayer_SetWideness_TYPE)(CriAtomExPlayerHn player, CriFloat32 wideness);
typedef void (CRIAPI *criAtomExPlayer_SetSendLevel_TYPE)( CriAtomExPlayerHn player, CriSint32 ch, CriAtomExSpeakerId spk, CriFloat32 level);
typedef void (CRIAPI *criAtomExPlayer_SetBusSendLevelByName_TYPE)( CriAtomExPlayerHn player, const CriChar8* bus_name, CriFloat32 level);
typedef void (CRIAPI* criAtomExPlayer_SetBusSendLevelOffsetByName_TYPE)(CriAtomExPlayerHn player, const CriChar8* bus_name, CriFloat32 level_offset);
typedef void (CRIAPI *criAtomExPlayer_ResetBusSends_TYPE)(CriAtomExPlayerHn player);
typedef void (CRIAPI *criAtomExPlayer_SetPanAdx1Compatible_TYPE)( CriAtomExPlayerHn player, CriSint32 ch, CriFloat32 pan);
typedef void (CRIAPI *criAtomExPlayer_SetBandpassFilterParameters_TYPE)( CriAtomExPlayerHn player, CriFloat32 cof_low, CriFloat32 cof_high);
typedef void (CRIAPI *criAtomExPlayer_SetBiquadFilterParameters_TYPE)( CriAtomExPlayerHn player, CriAtomExBiquadFilterType type, CriFloat32 frequency, CriFloat32 gain, CriFloat32 q_value);
typedef void (CRIAPI *criAtomExPlayer_SetVoicePriority_TYPE)( CriAtomExPlayerHn player, CriSint32 priority);
typedef void (CRIAPI *criAtomExPlayer_SetAisacControlById_TYPE)( CriAtomExPlayerHn player, CriAtomExAisacControlId control_id, CriFloat32 control_value);
typedef void (CRIAPI *criAtomExPlayer_SetAisacControlByName_TYPE)( CriAtomExPlayerHn player, const CriChar8 *control_name, CriFloat32 control_value);
typedef void (CRIAPI *criAtomExPlayer_ClearAisacControls_TYPE)(CriAtomExPlayerHn player);
typedef void (CRIAPI *criAtomExPlayer_Set3dSourceHn_TYPE)( CriAtomExPlayerHn player, CriAtomEx3dSourceHn source);
typedef void (CRIAPI *criAtomExPlayer_Set3dSourceListHn_TYPE)( CriAtomExPlayerHn player, CriAtomEx3dSourceListHn source_list);
typedef void (CRIAPI *criAtomExPlayer_Set3dListenerHn_TYPE)( CriAtomExPlayerHn player, CriAtomEx3dListenerHn listener);
typedef CriFloat32 (CRIAPI *criAtomExPlayer_GetAisacControlById_TYPE)( CriAtomExPlayerHn player, CriAtomExAisacControlId control_id);
typedef CriFloat32 (CRIAPI *criAtomExPlayer_GetAisacControlByName_TYPE)( CriAtomExPlayerHn player, const CriChar8 *control_name);
typedef void (CRIAPI *criAtomExPlayer_SetCategoryById_TYPE)( CriAtomExPlayerHn player, CriUint32 category_id);
typedef void (CRIAPI *criAtomExPlayer_SetCategoryByName_TYPE)( CriAtomExPlayerHn player, const CriChar8 *category_name);
typedef void (CRIAPI *criAtomExPlayer_UnsetCategory_TYPE)(CriAtomExPlayerHn player);
typedef CriSint32 (CRIAPI *criAtomExPlayer_GetNumCategories_TYPE)(CriAtomExPlayerHn player);
typedef CriBool (CRIAPI *criAtomExPlayer_GetCategoryInfo_TYPE)(CriAtomExPlayerHn player, CriUint16 index, CriAtomExCategoryInfo* info);
typedef void (CRIAPI *criAtomExPlayer_SetTrackInfo_TYPE)(CriAtomExPlayerHn player, CriSint32 num_tracks, const CriSint32 *channels_per_track);
typedef void (CRIAPI *criAtomExPlayer_SetTrackVolume_TYPE)( CriAtomExPlayerHn player, CriSint32 track_no, CriFloat32 volume);
typedef void (CRIAPI *criAtomExPlayer_SetSilentMode_TYPE)( CriAtomExPlayerHn player, CriAtomExSilentMode silent_mode);
typedef void (CRIAPI *criAtomExPlayer_SetCuePriority_TYPE)( CriAtomExPlayerHn player, CriSint32 cue_priority);
typedef void (CRIAPI *criAtomExPlayer_SetPreDelayTime_TYPE)( CriAtomExPlayerHn player, CriFloat32 predelay_time_ms);
typedef void (CRIAPI *criAtomExPlayer_SetEnvelopeAttackTime_TYPE)( CriAtomExPlayerHn player, CriFloat32 attack_time_ms);
typedef void (CRIAPI *criAtomExPlayer_SetEnvelopeHoldTime_TYPE)( CriAtomExPlayerHn player, CriFloat32 hold_time_ms);
typedef void (CRIAPI *criAtomExPlayer_SetEnvelopeDecayTime_TYPE)( CriAtomExPlayerHn player, CriFloat32 decay_time_ms);
typedef void (CRIAPI *criAtomExPlayer_SetEnvelopeReleaseTime_TYPE)( CriAtomExPlayerHn player, CriFloat32 release_time_ms);
typedef void (CRIAPI *criAtomExPlayer_SetEnvelopeSustainLevel_TYPE)( CriAtomExPlayerHn player, CriFloat32 susutain_level);
typedef void (CRIAPI* criAtomExPlayer_SetEnvelopeAttackCurve_TYPE)(CriAtomExPlayerHn player, CriAtomExCurveType curve_type, CriFloat32 strength);
typedef void (CRIAPI* criAtomExPlayer_SetEnvelopeDecayCurve_TYPE)(CriAtomExPlayerHn player, CriAtomExCurveType curve_type, CriFloat32 strength);
typedef void (CRIAPI* criAtomExPlayer_SetEnvelopeReleaseCurve_TYPE)(CriAtomExPlayerHn player, CriAtomExCurveType curve_type, CriFloat32 strength);
typedef void (CRIAPI *criAtomExPlayer_SetDataRequestCallback_TYPE)( CriAtomExPlayerHn player, CriAtomExPlayerDataRequestCbFunc func, void *obj);
typedef void (CRIAPI *criAtomExPlayer_SetFilterCallback_TYPE)( CriAtomExPlayerHn player, CriAtomExPlayerFilterCbFunc func, void *obj);
typedef void (CRIAPI *criAtomExPlayer_SetRandomSeed_TYPE)(CriAtomExPlayerHn player, CriUint32 seed);
typedef void (CRIAPI *criAtomExPlayer_SetDspParameter_TYPE)( CriAtomExPlayerHn player, CriSint32 param_id, CriFloat32 param_val);
typedef void (CRIAPI *criAtomExPlayer_AttachAisac_TYPE)(CriAtomExPlayerHn player, const CriChar8* global_aisac_name);
typedef void (CRIAPI *criAtomExPlayer_AttachAisacByIndex_TYPE)(CriAtomExPlayerHn player, CriUint16 global_aisac_index);
typedef void (CRIAPI *criAtomExPlayer_DetachAisac_TYPE)(CriAtomExPlayerHn player, const CriChar8* global_aisac_name);
typedef void (CRIAPI *criAtomExPlayer_DetachAisacByIndex_TYPE)(CriAtomExPlayerHn player, CriUint16 global_aisac_index);
typedef void (CRIAPI *criAtomExPlayer_DetachAisacAll_TYPE)(CriAtomExPlayerHn player);
typedef CriSint32 (CRIAPI *criAtomExPlayer_GetNumAttachedAisacs_TYPE)(CriAtomExPlayerHn player);
typedef CriBool (CRIAPI *criAtomExPlayer_GetAttachedAisacInfo_TYPE)( CriAtomExPlayerHn player, CriSint32 aisac_attached_index, CriAtomExAisacInfo *aisac_info);
typedef void (CRIAPI *criAtomExPlayer_SetStreamingCacheId_TYPE)( CriAtomExPlayerHn player, CriAtomExStreamingCacheId cache_id);
typedef void (CRIAPI *criAtomExPlayer_AttachTween_TYPE)(CriAtomExPlayerHn player, CriAtomExTweenHn tween);
typedef void (CRIAPI *criAtomExPlayer_DetachTween_TYPE)(CriAtomExPlayerHn player, CriAtomExTweenHn tween);
typedef void (CRIAPI *criAtomExPlayer_DetachTweenAll_TYPE)(CriAtomExPlayerHn player);
typedef void (CRIAPI *criAtomExPlayer_SetFirstBlockIndex_TYPE)( CriAtomExPlayerHn player, CriAtomExBlockIndex index);
typedef void (CRIAPI *criAtomExPlayer_SetBlockTransitionCallback_TYPE)( CriAtomExPlayerHn player, CriAtomExPlayerBlockTransitionCbFunc func, void *obj);
typedef CriAtomExSoundObjectHn (CRIAPI *criAtomExPlayer_GetSoundObject_TYPE)(CriAtomExPlayerHn player); 
typedef void (CRIAPI *criAtomExPlayer_SetDrySendLevel_TYPE)( CriAtomExPlayerHn player, CriAtomExSpeakerId spk, CriFloat32 offset, CriFloat32 gain);
typedef void (CRIAPI *criAtomExPlayer_SetSelectorLabel_TYPE)( CriAtomExPlayerHn player, const CriChar8 *selector, const CriChar8 *label);
typedef void (CRIAPI *criAtomExPlayer_ClearSelectorLabels_TYPE)(CriAtomExPlayerHn player);
typedef void (CRIAPI *criAtomExPlayer_SetPlaybackTrackInfoNotificationCallback_TYPE)( CriAtomExPlayerHn player, CriAtomExPlayerPlaybackTrackInfoNotificationCbFunc func, void *obj);
typedef void (CRIAPI *criAtomExPlayer_SetPlaybackEventCallback_TYPE)( CriAtomExPlayerHn player, CriAtomExPlaybackEventCbFunc func, void *obj);
typedef void (CRIAPI *criAtomExPlayback_Stop_TYPE)(CriAtomExPlaybackId id);
typedef void (CRIAPI *criAtomExPlayback_StopWithoutReleaseTime_TYPE)(CriAtomExPlaybackId id);
typedef void (CRIAPI *criAtomExPlayback_Pause_TYPE)(CriAtomExPlaybackId id, CriBool sw);
typedef void (CRIAPI *criAtomExPlayback_Resume_TYPE)(CriAtomExPlaybackId id, CriAtomExResumeMode mode);
typedef CriBool (CRIAPI *criAtomExPlayback_IsPaused_TYPE)(CriAtomExPlaybackId id);
typedef CriAtomExPlaybackStatus (CRIAPI *criAtomExPlayback_GetStatus_TYPE)(CriAtomExPlaybackId id);
typedef CriBool (CRIAPI *criAtomExPlayback_GetFormatInfo_TYPE)( CriAtomExPlaybackId id, CriAtomExFormatInfo *info);
typedef CriBool (CRIAPI *criAtomExPlayback_GetSource_TYPE)( CriAtomExPlaybackId id, CriAtomExSourceInfo *source);
typedef CriAtomPlayerHn (CRIAPI *criAtomExPlayback_GetAtomPlayer_TYPE)(CriAtomExPlaybackId id);
typedef CriSint64 (CRIAPI *criAtomExPlayback_GetTime_TYPE)(CriAtomExPlaybackId id);
typedef CriSint64 (CRIAPI *criAtomExPlayback_GetTimeSyncedWithAudio_TYPE)(CriAtomExPlaybackId id);
typedef CriSint64 (CRIAPI *criAtomExPlayback_GetTimeSyncedWithAudioMicro_TYPE)(CriAtomExPlaybackId id);
typedef CriSint64 (CRIAPI *criAtomExPlayback_GetSequencePosition_TYPE)(CriAtomExPlaybackId id);
typedef CriBool (CRIAPI *criAtomExPlayback_GetNumPlayedSamples_TYPE)( CriAtomExPlaybackId id, CriSint64 *num_samples, CriSint32 *sampling_rate);
typedef CriBool (CRIAPI *criAtomExPlayback_GetParameterFloat32_TYPE)( CriAtomExPlaybackId playback_id, CriAtomExParameterId parameter_id, CriFloat32 *value_float32);
typedef CriBool (CRIAPI *criAtomExPlayback_GetParameterUint32_TYPE)( CriAtomExPlaybackId playback_id, CriAtomExParameterId parameter_id, CriUint32* value_uint32);
typedef CriBool (CRIAPI *criAtomExPlayback_GetParameterSint32_TYPE)( CriAtomExPlaybackId playback_id, CriAtomExParameterId parameter_id, CriSint32* value_sint32);
typedef CriBool (CRIAPI *criAtomExPlayback_GetAisacControlById_TYPE)( CriAtomExPlaybackId playback_id, CriAtomExAisacControlId control_id, CriFloat32 *control_value);
typedef CriBool (CRIAPI *criAtomExPlayback_GetAisacControlByName_TYPE)( CriAtomExPlaybackId playback_id, const CriChar8 *control_name, CriFloat32 *control_value);
typedef void (CRIAPI *criAtomExPlayback_SetNextBlockIndex_TYPE)(CriAtomExPlaybackId id, CriAtomExBlockIndex index);
typedef CriAtomExBlockIndex (CRIAPI *criAtomExPlayback_GetCurrentBlockIndex_TYPE)(CriAtomExPlaybackId id);
typedef CriBool (CRIAPI *criAtomExPlayback_GetPlaybackTrackInfo_TYPE)(CriAtomExPlaybackId id, CriAtomExPlaybackTrackInfo* info);
typedef CriBool (CRIAPI *criAtomExPlayback_GetBeatSyncInfo_TYPE)(CriAtomExPlaybackId id, CriAtomExBeatSyncInfo* info);
typedef CriBool (CRIAPI *criAtomExPlayback_SetBeatSyncOffset_TYPE)(CriAtomExPlaybackId id, CriSint16 time_ms);
typedef CriSint32 (CRIAPI *criAtomExPlayer_CalculateWorkSizeForFader_TYPE)( const CriAtomExFaderConfig *config);
typedef void (CRIAPI *criAtomExPlayer_AttachFader_TYPE)(CriAtomExPlayerHn player, const CriAtomExFaderConfig *config, void *work, CriSint32 work_size);
typedef void (CRIAPI *criAtomExPlayer_DetachFader_TYPE)(CriAtomExPlayerHn player);
typedef void (CRIAPI *criAtomExPlayer_SetFadeOutTime_TYPE)(CriAtomExPlayerHn player, CriSint32 ms);
typedef CriSint32 (CRIAPI *criAtomExPlayer_GetFadeOutTime_TYPE)(CriAtomExPlayerHn player);
typedef void (CRIAPI *criAtomExPlayer_SetFadeInTime_TYPE)(CriAtomExPlayerHn player, CriSint32 ms);
typedef CriSint32 (CRIAPI *criAtomExPlayer_GetFadeInTime_TYPE)(CriAtomExPlayerHn player);
typedef void (CRIAPI *criAtomExPlayer_SetFadeInStartOffset_TYPE)(CriAtomExPlayerHn player, CriSint32 ms);
typedef CriSint32 (CRIAPI *criAtomExPlayer_GetFadeInStartOffset_TYPE)(CriAtomExPlayerHn player);
typedef void (CRIAPI *criAtomExPlayer_SetFadeOutEndDelay_TYPE)(CriAtomExPlayerHn player, CriSint32 ms);
typedef CriSint32 (CRIAPI *criAtomExPlayer_GetFadeOutEndDelay_TYPE)(CriAtomExPlayerHn player);
typedef CriBool (CRIAPI *criAtomExPlayer_IsFading_TYPE)(CriAtomExPlayerHn player);
typedef void (CRIAPI *criAtomExPlayer_ResetFaderParameters_TYPE)(CriAtomExPlayerHn player);
typedef void (CRIAPI *criAtomExSequencer_SetEventCallback_TYPE)(CriAtomExSequencerEventCbFunc func, void* obj);
typedef void (CRIAPI *criAtomExBeatSync_SetCallback_TYPE)(CriAtomExBeatSyncCbFunc func, void* obj);
typedef CriSint32 (CRIAPI *criAtomEx3dSource_CalculateWorkSize_TYPE)(const CriAtomEx3dSourceConfig *config);
typedef CriAtomEx3dSourceHn (CRIAPI *criAtomEx3dSource_Create_TYPE)( const CriAtomEx3dSourceConfig *config, void *work, CriSint32 work_size);
typedef void (CRIAPI *criAtomEx3dSource_Destroy_TYPE)(CriAtomEx3dSourceHn ex_3d_source);
typedef void (CRIAPI *criAtomEx3dSource_Update_TYPE)(CriAtomEx3dSourceHn ex_3d_source);
typedef void (CRIAPI *criAtomEx3dSource_ResetParameters_TYPE)(CriAtomEx3dSourceHn ex_3d_source);
typedef void (CRIAPI *criAtomEx3dSource_SetPosition_TYPE)(CriAtomEx3dSourceHn ex_3d_source, const CriAtomExVector *position);
typedef CriAtomExVector (CRIAPI *criAtomEx3dSource_GetPosition_TYPE)(CriAtomEx3dSourceHn ex_3d_source);
typedef void (CRIAPI *criAtomEx3dSource_SetVelocity_TYPE)(CriAtomEx3dSourceHn ex_3d_source, const CriAtomExVector *velocity);
typedef void (CRIAPI *criAtomEx3dSource_SetOrientation_TYPE)(CriAtomEx3dSourceHn ex_3d_source, const CriAtomExVector *front, const CriAtomExVector *top);
typedef void (CRIAPI *criAtomEx3dSource_SetConeParameter_TYPE)(CriAtomEx3dSourceHn ex_3d_source, CriFloat32 inside_angle, CriFloat32 outside_angle, CriFloat32 outside_volume);
typedef void (CRIAPI *criAtomEx3dSource_ChangeDefaultConeParameter_TYPE)( CriFloat32 inside_angle, CriFloat32 outside_angle, CriFloat32 outside_volume);
typedef void (CRIAPI *criAtomEx3dSource_SetMinMaxAttenuationDistance_TYPE)(CriAtomEx3dSourceHn ex_3d_source, CriFloat32 min_attenuation_distance, CriFloat32 max_attenuation_distance);
typedef void (CRIAPI *criAtomEx3dSource_ChangeDefaultMinMaxAttenuationDistance_TYPE)( CriFloat32 min_attenuation_distance, CriFloat32 max_attenuation_distance);
typedef void (CRIAPI *criAtomEx3dSource_SetInteriorPanField_TYPE)(CriAtomEx3dSourceHn ex_3d_source, CriFloat32 source_radius, CriFloat32 interior_distance);
typedef void (CRIAPI *criAtomEx3dSource_ChangeDefaultInteriorPanField_TYPE)(CriFloat32 source_radius, CriFloat32 interior_distance);
typedef void (CRIAPI *criAtomEx3dSource_SetDopplerFactor_TYPE)(CriAtomEx3dSourceHn ex_3d_source, CriFloat32 doppler_factor);
typedef void (CRIAPI *criAtomEx3dSource_ChangeDefaultDopplerFactor_TYPE)(CriFloat32 doppler_factor);
typedef void (CRIAPI *criAtomEx3dSource_SetVolume_TYPE)(CriAtomEx3dSourceHn ex_3d_source, CriFloat32 volume);
typedef void (CRIAPI *criAtomEx3dSource_ChangeDefaultVolume_TYPE)(CriFloat32 volume);
typedef void (CRIAPI *criAtomEx3dSource_SetMaxAngleAisacDelta_TYPE)(CriAtomEx3dSourceHn ex_3d_source, CriFloat32 max_delta);
typedef void (CRIAPI *criAtomEx3dSource_SetDistanceAisacControlId_TYPE)(CriAtomEx3dSourceHn ex_3d_source, CriAtomExAisacControlId aisac_control_id);
typedef void (CRIAPI *criAtomEx3dSource_SetListenerBasedAzimuthAngleAisacControlId_TYPE)(CriAtomEx3dSourceHn ex_3d_source, CriAtomExAisacControlId aisac_control_id);
typedef void (CRIAPI *criAtomEx3dSource_SetListenerBasedElevationAngleAisacControlId_TYPE)(CriAtomEx3dSourceHn ex_3d_source, CriAtomExAisacControlId aisac_control_id);
typedef void (CRIAPI *criAtomEx3dSource_SetSourceBasedAzimuthAngleAisacControlId_TYPE)(CriAtomEx3dSourceHn ex_3d_source, CriAtomExAisacControlId aisac_control_id);
typedef void (CRIAPI* criAtomEx3dSource_SetSourceBasedElevationAngleAisacControlId_TYPE)(CriAtomEx3dSourceHn ex_3d_source, CriAtomExAisacControlId aisac_control_id);
typedef void (CRIAPI *criAtomEx3dSource_Set3dRegionHn_TYPE)(CriAtomEx3dSourceHn ex_3d_source, CriAtomEx3dRegionHn ex_3d_region);
typedef CriSint32 (CRIAPI *criAtomEx3dSourceList_CalculateWorkSize_TYPE)(const CriAtomEx3dSourceListConfig *config);
typedef CriAtomEx3dSourceListHn (CRIAPI *criAtomEx3dSourceList_Create_TYPE)( const CriAtomEx3dSourceListConfig *config, void *work, CriSint32 work_size);
typedef void (CRIAPI *criAtomEx3dSourceList_Destroy_TYPE)(CriAtomEx3dSourceListHn ex_3d_source_list);
typedef void (CRIAPI *criAtomEx3dSourceList_Add_TYPE)( CriAtomEx3dSourceListHn ex_3d_source_list, CriAtomEx3dSourceHn ex_3d_source);
typedef void (CRIAPI *criAtomEx3dSourceList_Remove_TYPE)( CriAtomEx3dSourceListHn ex_3d_source_list, CriAtomEx3dSourceHn ex_3d_source);
typedef void (CRIAPI *criAtomEx3dSourceList_RemoveAll_TYPE)(CriAtomEx3dSourceListHn ex_3d_source_list);
typedef CriSint32 (CRIAPI *criAtomEx3dListener_CalculateWorkSize_TYPE)(const CriAtomEx3dListenerConfig *config);
typedef CriAtomEx3dListenerHn (CRIAPI *criAtomEx3dListener_Create_TYPE)( const CriAtomEx3dListenerConfig *config, void *work, CriSint32 work_size);
typedef void (CRIAPI *criAtomEx3dListener_Destroy_TYPE)(CriAtomEx3dListenerHn ex_3d_listener);
typedef void (CRIAPI *criAtomEx3dListener_Update_TYPE)(CriAtomEx3dListenerHn ex_3d_listener);
typedef void (CRIAPI *criAtomEx3dListener_ResetParameters_TYPE)(CriAtomEx3dListenerHn ex_3d_listener);
typedef void (CRIAPI *criAtomEx3dListener_SetPosition_TYPE)(CriAtomEx3dListenerHn ex_3d_listener, const CriAtomExVector *position);
typedef CriAtomExVector (CRIAPI *criAtomEx3dListener_GetPosition_TYPE)(CriAtomEx3dListenerHn ex_3d_listener);
typedef void (CRIAPI *criAtomEx3dListener_SetVelocity_TYPE)(CriAtomEx3dListenerHn ex_3d_listener, const CriAtomExVector *velocity);
typedef void (CRIAPI *criAtomEx3dListener_SetOrientation_TYPE)(CriAtomEx3dListenerHn ex_3d_listener, const CriAtomExVector *front, const CriAtomExVector *top);
typedef void (CRIAPI *criAtomEx3dListener_SetDopplerMultiplier_TYPE)(CriAtomEx3dListenerHn ex_3d_listener, CriFloat32 doppler_multiplier);
typedef void (CRIAPI *criAtomEx3dListener_SetFocusPoint_TYPE)(CriAtomEx3dListenerHn ex_3d_listener, const CriAtomExVector *focus_point);
typedef void (CRIAPI *criAtomEx3dListener_SetDistanceFocusLevel_TYPE)(CriAtomEx3dListenerHn ex_3d_listener, CriFloat32 distance_focus_level);
typedef void (CRIAPI *criAtomEx3dListener_SetDirectionFocusLevel_TYPE)(CriAtomEx3dListenerHn ex_3d_listener, CriFloat32 direction_focus_level);
typedef void (CRIAPI *criAtomEx_EnableCalculationAisacControlFrom3dPosition_TYPE)(CriBool flag);
typedef CriBool (CRIAPI *criAtomEx_IsEnableCalculationAisacControlFrom3dPosition_TYPE)(void);
typedef void (CRIAPI *criAtomEx3dListener_Set3dRegionHn_TYPE)(CriAtomEx3dListenerHn ex_3d_listener, CriAtomEx3dRegionHn ex_3d_region);
typedef CriSint32 (CRIAPI *criAtomEx3dRegion_CalculateWorkSize_TYPE)(const CriAtomEx3dRegionConfig *config);
typedef CriAtomEx3dRegionHn (CRIAPI *criAtomEx3dRegion_Create_TYPE)( const CriAtomEx3dRegionConfig *config, void *work, CriSint32 work_size);
typedef void (CRIAPI *criAtomEx3dRegion_Destroy_TYPE)(CriAtomEx3dRegionHn ex_3d_region);
typedef CriSint32 (CRIAPI *criAtomEx3dTransceiver_CalculateWorkSize_TYPE)(const CriAtomEx3dTransceiverConfig *config);
typedef CriAtomEx3dTransceiverHn (CRIAPI *criAtomEx3dTransceiver_Create_TYPE)(const CriAtomEx3dTransceiverConfig *config, void *work, CriSint32 work_size);
typedef void (CRIAPI *criAtomEx3dTransceiver_Destroy_TYPE)(CriAtomEx3dTransceiverHn ex_3d_transceiver);
typedef void (CRIAPI *criAtomEx3dTransceiver_Update_TYPE)(CriAtomEx3dTransceiverHn ex_3d_transceiver);
typedef void (CRIAPI *criAtomEx3dTransceiver_SetInputPosition_TYPE)(CriAtomEx3dTransceiverHn ex_3d_transceiver, const CriAtomExVector *position);
typedef void (CRIAPI *criAtomEx3dTransceiver_SetOutputPosition_TYPE)(CriAtomEx3dTransceiverHn ex_3d_transceiver, const CriAtomExVector *position);
typedef void (CRIAPI *criAtomEx3dTransceiver_SetInputOrientation_TYPE)(CriAtomEx3dTransceiverHn ex_3d_transceiver, const CriAtomExVector *front, const CriAtomExVector *top);
typedef void (CRIAPI *criAtomEx3dTransceiver_SetOutputOrientation_TYPE)(CriAtomEx3dTransceiverHn ex_3d_transceiver, const CriAtomExVector *front, const CriAtomExVector *top);
typedef void (CRIAPI *criAtomEx3dTransceiver_SetOutputConeParameter_TYPE)(CriAtomEx3dTransceiverHn ex_3d_transceiver, CriFloat32 inside_angle, CriFloat32 outside_angle, CriFloat32 outside_volume);
typedef void (CRIAPI *criAtomEx3dTransceiver_SetOutputMinMaxAttenuationDistance_TYPE)(CriAtomEx3dTransceiverHn ex_3d_transceiver, CriFloat32 min_attenuation_distance, CriFloat32 max_attenuation_distance);
typedef void (CRIAPI *criAtomEx3dTransceiver_SetOutputInteriorPanField_TYPE)(CriAtomEx3dTransceiverHn ex_3d_transceiver, CriFloat32 transceiver_radius, CriFloat32 interior_distance);
typedef void (CRIAPI *criAtomEx3dTransceiver_SetInputCrossFadeField_TYPE)(CriAtomEx3dTransceiverHn ex_3d_transceiver, CriFloat32 direct_audio_radius, CriFloat32 crossfade_distance);
typedef void (CRIAPI *criAtomEx3dTransceiver_SetOutputVolume_TYPE)(CriAtomEx3dTransceiverHn ex_3d_transceiver, CriFloat32 volume);
typedef void (CRIAPI *criAtomEx3dTransceiver_AttachAisac_TYPE)(CriAtomEx3dTransceiverHn ex_3d_transceiver, const CriChar8* global_aisac_name);
typedef void (CRIAPI *criAtomEx3dTransceiver_DetachAisac_TYPE)(CriAtomEx3dTransceiverHn ex_3d_transceiver, const CriChar8* global_aisac_name);
typedef void (CRIAPI *criAtomEx3dTransceiver_SetMaxAngleAisacDelta_TYPE)(CriAtomEx3dTransceiverHn ex_3d_transceiver, CriFloat32 max_delta);
typedef void (CRIAPI *criAtomEx3dTransceiver_SetDistanceAisacControlId_TYPE)(CriAtomEx3dTransceiverHn ex_3d_transceiver, CriAtomExAisacControlId aisac_control_id);
typedef void (CRIAPI *criAtomEx3dTransceiver_SetListenerBasedAzimuthAngleAisacControlId_TYPE)(CriAtomEx3dTransceiverHn ex_3d_transceiver, CriAtomExAisacControlId aisac_control_id);
typedef void (CRIAPI *criAtomEx3dTransceiver_SetListenerBasedElevationAngleAisacControlId_TYPE)(CriAtomEx3dTransceiverHn ex_3d_transceiver, CriAtomExAisacControlId aisac_control_id);
typedef void (CRIAPI *criAtomEx3dTransceiver_SetTransceiverOutputBasedAzimuthAngleAisacControlId_TYPE)(CriAtomEx3dTransceiverHn ex_3d_transceiver, CriAtomExAisacControlId aisac_control_id);
typedef void (CRIAPI *criAtomEx3dTransceiver_SetTransceiverOutputBasedElevationAngleAisacControlId_TYPE)(CriAtomEx3dTransceiverHn ex_3d_transceiver, CriAtomExAisacControlId aisac_control_id);
typedef void (CRIAPI *criAtomEx3dTransceiver_Set3dRegionHn_TYPE)(CriAtomEx3dTransceiverHn ex_3d_transceiver, CriAtomEx3dRegionHn ex_3d_region);
typedef void (CRIAPI *criAtomExVoicePool_DetachDsp_TYPE)(CriAtomExVoicePoolHn pool);
typedef CriSint32 (CRIAPI *criAtomExVoicePool_CalculateWorkSizeForDspPitchShifter_TYPE)( const CriAtomExDspPitchShifterConfig *config);
typedef void (CRIAPI *criAtomExVoicePool_AttachDspPitchShifter_TYPE)(CriAtomExVoicePoolHn pool, const CriAtomExDspPitchShifterConfig *config, void *work, CriSint32 work_size);
typedef CriSint32 (CRIAPI *criAtomExVoicePool_CalculateWorkSizeForDspTimeStretch_TYPE)( const CriAtomExDspTimeStretchConfig *config);
typedef void (CRIAPI *criAtomExVoicePool_AttachDspTimeStretch_TYPE)(CriAtomExVoicePoolHn pool, const CriAtomExDspTimeStretchConfig *config, void *work, CriSint32 work_size);
typedef CriBool (CRIAPI *criAtomExStreamingCache_IsCachedWaveformById_TYPE)( CriAtomExStreamingCacheId stm_cache_id, CriAtomExAcbHn acb_hn, CriAtomExCueId id);
typedef CriBool (CRIAPI *criAtomExStreamingCache_IsCachedWaveformByName_TYPE)( CriAtomExStreamingCacheId stm_cache_id, CriAtomExAcbHn acb_hn, const CriChar8 *name);
typedef CriBool (CRIAPI *criAtomExStreamingCache_LoadWaveformById_TYPE)( CriAtomExStreamingCacheId stm_cache_id, CriAtomExAcbHn acb_hn, CriAtomExCueId cue_id);
typedef CriBool (CRIAPI *criAtomExStreamingCache_LoadWaveformByName_TYPE)( CriAtomExStreamingCacheId stm_cache_id, CriAtomExAcbHn acb_hn, const CriChar8 *name);
typedef CriSint32 (CRIAPI *criAtomExTween_CalculateWorkSize_TYPE)(const CriAtomExTweenConfig *config);
typedef CriAtomExTweenHn (CRIAPI *criAtomExTween_Create_TYPE)( const CriAtomExTweenConfig *config, void *work, CriSint32 work_size);
typedef void (CRIAPI *criAtomExTween_Destroy_TYPE)(CriAtomExTweenHn tween);
typedef CriFloat32 (CRIAPI *criAtomExTween_GetValue_TYPE)(CriAtomExTweenHn tween);
typedef void (CRIAPI *criAtomExTween_MoveTo_TYPE)(CriAtomExTweenHn tween, CriUint16 time_ms, CriFloat32 value);
typedef void (CRIAPI *criAtomExTween_MoveFrom_TYPE)(CriAtomExTweenHn tween, CriUint16 time_ms, CriFloat32 value);
typedef void (CRIAPI *criAtomExTween_Stop_TYPE)(CriAtomExTweenHn tween);
typedef void (CRIAPI *criAtomExTween_Reset_TYPE)(CriAtomExTweenHn tween);
typedef void (CRIAPI *criAtomEx_SetVoiceEventCallback_TYPE)(CriAtomExVoiceEventCbFunc func, void *obj);
typedef void (CRIAPI *criAtomEx_EnumerateVoiceInfos_TYPE)(CriAtomExVoiceInfoCbFunc func, void *obj);
typedef void (CRIAPI *criAtomEx_SetMonitoringVoiceStopCallback_TYPE)(CriAtomExMonitoringVoiceStopCbFunc func, void *obj);
typedef void (CRIAPI *criAtomEx_SetMonitoringVoiceStopPlaybackId_TYPE)(CriAtomExPlaybackId playback_id);
typedef CriSint32 (CRIAPI *criAtomExSoundObject_CalculateWorkSize_TYPE)( const CriAtomExSoundObjectConfig *config);
typedef CriAtomExSoundObjectHn (CRIAPI *criAtomExSoundObject_Create_TYPE)( const CriAtomExSoundObjectConfig *config, void *work, CriSint32 work_size);
typedef void (CRIAPI *criAtomExSoundObject_Destroy_TYPE)(CriAtomExSoundObjectHn sound_object);
typedef void (CRIAPI *criAtomExSoundObject_AddPlayer_TYPE)(CriAtomExSoundObjectHn sound_object, CriAtomExPlayerHn player);
typedef void (CRIAPI *criAtomExSoundObject_DeletePlayer_TYPE)(CriAtomExSoundObjectHn sound_object, CriAtomExPlayerHn player);
typedef void (CRIAPI *criAtomExSoundObject_DeleteAllPlayers_TYPE)(CriAtomExSoundObjectHn sound_object);
typedef void (CRIAPI *criAtomExAcb_ReleaseAsync_TYPE)( CriAtomExAcbHn acb_hn, CriAtomExAcbReleasedCbFunc func, void *obj);
typedef CriBool (CRIAPI *criAtomExPlayer_IsReadyToStartAsync_TYPE)(CriAtomExPlayerHn player);
typedef void (CRIAPI *criAtomExPlayer_UpdateAllAsync_TYPE)(CriAtomExPlayerHn player);
typedef CriSint64 (CRIAPI *criAtomExPlayer_GetTimeReal_TYPE)(CriAtomExPlayerHn player);
typedef CriSint64 (CRIAPI *criAtomExPlayback_GetTimeReal_TYPE)(CriAtomExPlaybackId id);
typedef void (CRIAPI *criAtomExPlayback_EnumerateAtomPlayers_TYPE)( CriAtomExPlaybackId id, CriAtomPlayerCbFunc func, void* obj);
typedef void (CRIAPI *criAtomEx3dListener_GetFocusPoint_TYPE)(CriAtomEx3dListenerHn ex_3d_listener, CriAtomExVector *focus_point);
typedef CriFloat32 (CRIAPI *criAtomEx3dListener_GetDistanceFocusLevel_TYPE)(CriAtomEx3dListenerHn ex_3d_listener);
typedef CriFloat32 (CRIAPI *criAtomEx3dListener_GetDirectionFocusLevel_TYPE)(CriAtomEx3dListenerHn ex_3d_listener);
typedef CriAtomExAcbHn (CRIAPI *criAtomExAcb_GetCurrentAcb_TYPE)(void);
typedef CriBool (CRIAPI *criAtomExAcb_IsParameterPalletAssignedByName_TYPE)(CriAtomExAcbHn acb_hn, const CriChar8 *cue_name);
typedef void (CRIAPI *criAtomEx3dSource_SetAttenuationDistanceSetting_TYPE)(CriAtomEx3dSourceHn ex_3d_source, CriBool sw);
typedef CriBool (CRIAPI *criAtomEx3dSource_GetAttenuationDistanceSetting_TYPE)(const CriAtomEx3dSourceHn ex_3d_source);
typedef void (CRIAPI *criAtomExPlayer_SetBusSendLevel_TYPE)( CriAtomExPlayerHn player, CriSint32 bus_index, CriFloat32 level);
typedef void (CRIAPI *criAtomExPlayer_SetBusSendLevelOffset_TYPE)( CriAtomExPlayerHn player, CriSint32 bus_index, CriFloat32 level_offset);
typedef void (CRIAPI *criAtomEx_GetNumUsedVirtualVoices_TYPE)(CriSint32 *cur_num, CriSint32 *limit);
typedef void (CRIAPI *criAtomEx_GetNumUsedSequences_TYPE)(CriSint32 *cur_num, CriSint32 *limit);
typedef void (CRIAPI *criAtomEx_GetNumUsedSequenceTracks_TYPE)(CriSint32 *cur_num, CriSint32 *limit);
typedef void (CRIAPI *criAtomEx_GetNumUsedSequenceTrackItems_TYPE)(CriSint32 *cur_num, CriSint32 *limit);
typedef void (CRIAPI *criAtomEx3dListener_SetDistanceFactor_TYPE)(CriAtomEx3dListenerHn ex_3d_listener, CriFloat32 distance_factor);
typedef void (CRIAPI *criAtomEx_GetNumUsedAisacAutoModulations_TYPE)(CriSint32 *cur_num, CriSint32 *limit);
typedef void (CRIAPI *criAtomEx3dSource_SetConeOrientation_TYPE)(CriAtomEx3dSourceHn ex_3d_source, const CriAtomExVector *cone_orient);
typedef CriSint32 (CRIAPI *criAtomEx_CalculateWorkSizeForRegisterAcfConfig_TYPE)( const CriAtomExAcfConfig *config);
typedef void (CRIAPI *criAtomExPlayer_SetSequencePrepareTime_TYPE)( CriAtomExPlayerHn player, CriUint32 seq_prep_time_ms);
#if CRIWARE_USE_ATOM_MONITOR
typedef CriSint32 (CRIAPI *criAtomExMonitor_CalculateWorkSize_TYPE)(const CriAtomExMonitorConfig* config);
typedef void (CRIAPI *criAtomExMonitor_Initialize_TYPE)( const CriAtomExMonitorConfig *config, void *work, CriSint32 work_size);
typedef void (CRIAPI *criAtomExMonitor_Finalize_TYPE)(void);
typedef const CriChar8* (CRIAPI *criAtomExMonitor_GetServerIpString_TYPE)(void);
typedef const CriChar8* (CRIAPI *criAtomExMonitor_GetClientIpString_TYPE)(void);
typedef CriBool (CRIAPI *criAtomExMonitor_IsConnected_TYPE)(void);
typedef void (CRIAPI* criAtomExMonitor_SetLogCallback_TYPE)(CriAtomExMonitorLogCbFunc cbf, void* obj);
typedef void (*CriAtomExMonitorLogWithModeCbFunc)(void* obj, const CriChar8* log_string, CriUint32 mode); // callback definition
typedef void (CRIAPI *criAtomExMonitor_SetLogCallbackWithLogMode_TYPE)(CriAtomExMonitorLogWithModeCbFunc cbf, void* obj);
typedef void (CRIAPI *criAtomExMonitor_SetLogMode_TYPE)(CriUint32 mode);
typedef void (CRIAPI *criAtomExMonitor_OutputUserLog_TYPE)(const CriChar8* message);
typedef void (CRIAPI *criAtomExMonitor_SetDataUpdateNotificationCallback_TYPE)( CriAtomExMonitorDataUpdateNotificationCbFunc func, void *obj);
#endif
#ifdef XPT_TGT_ANDROID
typedef void (CRIAPI* criAtom_SetThreadPriority_ANDROID_TYPE)(int prio);
typedef int (CRIAPI* criAtom_GetThreadPriority_ANDROID_TYPE)(void);
typedef void (CRIAPI* criAtom_SetJavaVM_ANDROID_TYPE)(JavaVM* vm);
typedef void (CRIAPI* criAtom_SetSoundStartBufferingTime_ANDROID_TYPE)(CriSint32 time);
typedef void (CRIAPI* criAtom_SetSoundBufferingTime_ANDROID_TYPE)(CriSint32 time);
typedef void (CRIAPI* criAtom_SetSoundBufferSize_ANDROID_TYPE)(CriSint32 num_samples);
typedef CriBool(CRIAPI* criAtom_ApplyHardwareProperties_ANDROID_TYPE)(JavaVM* vm, jobject context);
typedef CriSint32(CRIAPI* criAtomEx_CalculateWorkSize_ANDROID_TYPE)(const CriAtomExConfig_ANDROID* config);
typedef void (CRIAPI* criAtomEx_Initialize_ANDROID_TYPE)(const CriAtomExConfig_ANDROID* config, void* work, CriSint32 work_size);
typedef void (CRIAPI* criAtomEx_Finalize_ANDROID_TYPE)(void);
typedef void (CRIAPI* criAtomEx_StartSound_ANDROID_TYPE)(void);
typedef void (CRIAPI* criAtomEx_StopSound_ANDROID_TYPE)(void);
typedef void (CRIAPI* criAtomLatencyEstimator_Initialize_ANDROID_TYPE)();
typedef void (CRIAPI* criAtomLatencyEstimator_Finalize_ANDROID_TYPE)();
typedef CriAtomLatencyEstimatorInfo(CRIAPI* criAtomLatencyEstimator_GetCurrentInfo_ANDROID_TYPE)();
typedef CriBool(CRIAPI* criAtomLatencyEstimator_IsInitialized_ANDROID_TYPE)();
typedef CriError(CRIAPI* criFs_EnableAssetsAccess_ANDROID_TYPE)(JavaVM* vm, jobject jobj);
typedef CriError(CRIAPI* criFs_DisableAssetsAccess_ANDROID_TYPE)();
#endif
#if defined XPT_TGT_PC
typedef CriSint32(CRIAPI* criAtomEx_CalculateWorkSize_WASAPI_TYPE)(const CriAtomExConfig_WASAPI* config);
typedef void (CRIAPI* criAtomEx_Initialize_WASAPI_TYPE)(const CriAtomExConfig_WASAPI* config, void* work, CriSint32 work_size);
typedef void (CRIAPI* criAtomEx_Finalize_WASAPI_TYPE)(void);
typedef void (CRIAPI* criAtom_SetAudioClientFormat_WASAPI_TYPE)(const WAVEFORMATEX* format);
typedef void (CRIAPI* criAtom_SetAudioClientShareMode_WASAPI_TYPE)(AUDCLNT_SHAREMODE mode);
typedef void (CRIAPI* criAtom_SetDeviceId_WASAPI_TYPE)(CriAtomSoundRendererType type, LPCWSTR device_id);
typedef void (CRIAPI* criAtom_SetSpatialAudioEnabled_WASAPI_TYPE)(CriAtomSoundRendererType type, CriBool sw);
typedef CriSint32(CRIAPI* criAtom_EnumAudioEndpoints_WASAPI_TYPE)(CriAtomAudioEndpointCbFunc_WASAPI callback, void* object);
typedef void (CRIAPI* criAtom_SetDeviceUpdateCallback_WASAPI_TYPE)(CriAtomDeviceUpdateCbFunc_WASAPI callback, void* object);
#endif

#if defined XPT_TGT_MACOSX
typedef CriSint32(CRIAPI* criAtomEx_CalculateWorkSize_MACOSX_TYPE)(const CriAtomExConfig_MACOSX* config);
typedef void (CRIAPI* criAtomEx_Initialize_MACOSX_TYPE)(const CriAtomExConfig_MACOSX* config, void* work, CriSint32 work_size);
typedef void (CRIAPI* criAtomEx_Finalize_MACOSX_TYPE)(void);
#endif

#ifdef CRIWARE_USE_SOUNDXR
typedef const void* (CRIAPI* criSoundxR_GetInterface_TYPE)(void);
#endif

/***************************************************************************
 *      Prototype Classes
 ***************************************************************************/
class CRIWARECORE_API FCriWareApi {
public:
	static criFs_IsInitialized_TYPE criFs_IsInitialized;
	static criErr_ConvertIdToMessage_TYPE criErr_ConvertIdToMessage;
	static criErr_SetCallback_TYPE criErr_SetCallback;
	static criErr_SetErrorNotificationLevel_TYPE criErr_SetErrorNotificationLevel;
	static criErr_GetErrorCount_TYPE criErr_GetErrorCount;
	static criErr_ResetErrorCount_TYPE criErr_ResetErrorCount;
	static criFs_SetUserMallocFunction_TYPE criFs_SetUserMallocFunction;
	static criFs_SetUserFreeFunction_TYPE criFs_SetUserFreeFunction;
	static criFs_GetNumUsedBinders_TYPE criFs_GetNumUsedBinders;
	static criFs_SetSelectIoCallback_TYPE criFs_SetSelectIoCallback;
	static criFs_ControlFileIoMode_TYPE criFs_ControlFileIoMode;
	static criFsBinder_Create_TYPE criFsBinder_Create;
	static criFsBinder_Destroy_TYPE criFsBinder_Destroy;
	static criFsBinder_BindFile_TYPE criFsBinder_BindFile;
	static criFsBinder_BindFileSection_TYPE criFsBinder_BindFileSection;
	static criFsBinder_GetStatus_TYPE criFsBinder_GetStatus;
	static criFsStdio_OpenFile_TYPE criFsStdio_OpenFile;
	static criFsStdio_CloseFile_TYPE criFsStdio_CloseFile;
	static criFsStdio_GetFileSize_TYPE criFsStdio_GetFileSize;
	static criFsStdio_SeekFile_TYPE criFsStdio_SeekFile;
	static criFsStdio_ReadFile_TYPE criFsStdio_ReadFile;
	static criAtom_GetVersionNumber_TYPE criAtom_GetVersionNumber;
	static criAtom_IsInitialized_TYPE criAtom_IsInitialized;
	static criAtom_IsAudioOutputActive_TYPE criAtom_IsAudioOutputActive;
	static criAtom_ExecuteMain_TYPE criAtom_ExecuteMain;
	static criAtom_ExecuteAudioProcess_TYPE criAtom_ExecuteAudioProcess;
	static criAtom_SetUserMallocFunction_TYPE criAtom_SetUserMallocFunction;
	static criAtom_SetUserFreeFunction_TYPE criAtom_SetUserFreeFunction;
	static criAtom_SetAudioFrameStartCallback_TYPE criAtom_SetAudioFrameStartCallback;
	static criAtom_SetAudioFrameEndCallback_TYPE criAtom_SetAudioFrameEndCallback;
	static criAtom_Lock_TYPE criAtom_Lock;
	static criAtom_Unlock_TYPE criAtom_Unlock;
	static criAtom_SetChannelMapping_TYPE criAtom_SetChannelMapping;
	static criAtom_AttachPerformanceMonitor_TYPE criAtom_AttachPerformanceMonitor;
	static criAtom_DetachPerformanceMonitor_TYPE criAtom_DetachPerformanceMonitor;
	static criAtom_ResetPerformanceMonitor_TYPE criAtom_ResetPerformanceMonitor;
	static criAtom_GetPerformanceInfo_TYPE criAtom_GetPerformanceInfo;
	static criAtom_CalculateAdxBitrate_TYPE criAtom_CalculateAdxBitrate;
	static criAtom_CalculateHcaBitrate_TYPE criAtom_CalculateHcaBitrate;
	static criAtom_CalculateHcaMxBitrate_TYPE criAtom_CalculateHcaMxBitrate;
	static criAtom_GetStreamingInfo_TYPE criAtom_GetStreamingInfo;
	static criAtom_SetFreeTimeBufferingFlagForDefaultDevice_TYPE criAtom_SetFreeTimeBufferingFlagForDefaultDevice;
	static criAtom_SetAdx1KeyString_TYPE criAtom_SetAdx1KeyString;
	static criAtomHcaMx_CalculateWorkSize_TYPE criAtomHcaMx_CalculateWorkSize;
	static criAtomHcaMx_SetConfigForWorkSizeCalculation_TYPE criAtomHcaMx_SetConfigForWorkSizeCalculation;
	static criAtomHcaMx_Initialize_TYPE criAtomHcaMx_Initialize;
	static criAtomHcaMx_Finalize_TYPE criAtomHcaMx_Finalize;
	static criAtomHcaMx_SetBusSendLevelByName_TYPE criAtomHcaMx_SetBusSendLevelByName;
	static criAtomHcaMx_SetFrequencyRatio_TYPE criAtomHcaMx_SetFrequencyRatio;
	static criAtomAwb_CalculateWorkSizeForLoadToc_TYPE criAtomAwb_CalculateWorkSizeForLoadToc;
	static criAtomAwb_LoadToc_TYPE criAtomAwb_LoadToc;
	static criAtomAwb_LoadTocById_TYPE criAtomAwb_LoadTocById;
	static criAtomAwb_LoadTocAsync_TYPE criAtomAwb_LoadTocAsync;
	static criAtomAwb_LoadTocAsyncById_TYPE criAtomAwb_LoadTocAsyncById;
	static criAtomAwb_LoadFromMemory_TYPE criAtomAwb_LoadFromMemory;
	static criAtomAwb_GetType_TYPE criAtomAwb_GetType;
	static criAtomAwb_GetWaveFileInfo_TYPE criAtomAwb_GetWaveFileInfo;
	static criAtomAwb_GetWaveDataInfo_TYPE criAtomAwb_GetWaveDataInfo;
	static criAtomAwb_GetNumContents_TYPE criAtomAwb_GetNumContents;
	static criAtomAwb_Release_TYPE criAtomAwb_Release;
	static criAtomAwb_IsReadyToRelease_TYPE criAtomAwb_IsReadyToRelease;
	static criAtomAwb_GetStatus_TYPE criAtomAwb_GetStatus;
	static criAtomAwb_GetIdByIndex_TYPE criAtomAwb_GetIdByIndex;
	static criAtomPlayer_CalculateWorkSizeForStandardPlayer_TYPE criAtomPlayer_CalculateWorkSizeForStandardPlayer;
	static criAtomPlayer_CreateStandardPlayer_TYPE criAtomPlayer_CreateStandardPlayer;
	static criAtomPlayer_CalculateWorkSizeForAdxPlayer_TYPE criAtomPlayer_CalculateWorkSizeForAdxPlayer;
	static criAtomPlayer_CreateAdxPlayer_TYPE criAtomPlayer_CreateAdxPlayer;
	static criAtomPlayer_CalculateWorkSizeForHcaPlayer_TYPE criAtomPlayer_CalculateWorkSizeForHcaPlayer;
	static criAtomPlayer_CreateHcaPlayer_TYPE criAtomPlayer_CreateHcaPlayer;
	static criAtomPlayer_CalculateWorkSizeForHcaMxPlayer_TYPE criAtomPlayer_CalculateWorkSizeForHcaMxPlayer;
	static criAtomPlayer_CreateHcaMxPlayer_TYPE criAtomPlayer_CreateHcaMxPlayer;
	static criAtomPlayer_CalculateWorkSizeForWavePlayer_TYPE criAtomPlayer_CalculateWorkSizeForWavePlayer;
	static criAtomPlayer_CreateWavePlayer_TYPE criAtomPlayer_CreateWavePlayer;
	static criAtomPlayer_CalculateWorkSizeForAiffPlayer_TYPE criAtomPlayer_CalculateWorkSizeForAiffPlayer;
	static criAtomPlayer_CreateAiffPlayer_TYPE criAtomPlayer_CreateAiffPlayer;
	static criAtomPlayer_CalculateWorkSizeForRawPcmPlayer_TYPE criAtomPlayer_CalculateWorkSizeForRawPcmPlayer;
	static criAtomPlayer_CreateRawPcmPlayer_TYPE criAtomPlayer_CreateRawPcmPlayer;
	static criAtomPlayer_Destroy_TYPE criAtomPlayer_Destroy;
	static criAtomPlayer_SetData_TYPE criAtomPlayer_SetData;
	static criAtomPlayer_SetFile_TYPE criAtomPlayer_SetFile;
	static criAtomPlayer_SetContentId_TYPE criAtomPlayer_SetContentId;
	static criAtomPlayer_SetWaveId_TYPE criAtomPlayer_SetWaveId;
	static criAtomPlayer_SetPreviousDataAgain_TYPE criAtomPlayer_SetPreviousDataAgain;
	static criAtomPlayer_DeferCallback_TYPE criAtomPlayer_DeferCallback;
	static criAtomPlayer_Start_TYPE criAtomPlayer_Start;
	static criAtomPlayer_Stop_TYPE criAtomPlayer_Stop;
	static criAtomPlayer_ForceStop_TYPE criAtomPlayer_ForceStop;
	static criAtomPlayer_Pause_TYPE criAtomPlayer_Pause;
	static criAtomPlayer_IsPaused_TYPE criAtomPlayer_IsPaused;
	static criAtomPlayer_GetStatus_TYPE criAtomPlayer_GetStatus;
	static criAtomPlayer_GetNumChannels_TYPE criAtomPlayer_GetNumChannels;
	static criAtomPlayer_GetNumPlayedSamples_TYPE criAtomPlayer_GetNumPlayedSamples;
	static criAtomPlayer_GetDecodedDataSize_TYPE criAtomPlayer_GetDecodedDataSize;
	static criAtomPlayer_GetNumDecodedSamples_TYPE criAtomPlayer_GetNumDecodedSamples;
	static criAtomPlayer_GetTime_TYPE criAtomPlayer_GetTime;
	static criAtomPlayer_GetFormatInfo_TYPE criAtomPlayer_GetFormatInfo;
	static criAtomPlayer_GetInputBufferRemainSize_TYPE criAtomPlayer_GetInputBufferRemainSize;
	static criAtomPlayer_GetOutputBufferRemainSamples_TYPE criAtomPlayer_GetOutputBufferRemainSamples;
	static criAtomPlayer_SetStartTime_TYPE criAtomPlayer_SetStartTime;
	static criAtomPlayer_SetVolume_TYPE criAtomPlayer_SetVolume;
	static criAtomPlayer_GetVolume_TYPE criAtomPlayer_GetVolume;
	static criAtomPlayer_SetChannelVolume_TYPE criAtomPlayer_SetChannelVolume;
	static criAtomPlayer_SetSendLevel_TYPE criAtomPlayer_SetSendLevel;
	static criAtomPlayer_ResetSendLevel_TYPE criAtomPlayer_ResetSendLevel;
	static criAtomPlayer_SetPanAdx1Compatible_TYPE criAtomPlayer_SetPanAdx1Compatible;
	static criAtomPlayer_ResetPan_TYPE criAtomPlayer_ResetPan;
	static criAtomPlayer_SetFrequencyRatio_TYPE criAtomPlayer_SetFrequencyRatio;
	static criAtomPlayer_SetMaxFrequencyRatio_TYPE criAtomPlayer_SetMaxFrequencyRatio;
	static criAtomPlayer_LimitLoopCount_TYPE criAtomPlayer_LimitLoopCount;
	static criAtomPlayer_SetHcaMxMixerId_TYPE criAtomPlayer_SetHcaMxMixerId;
	static criAtomPlayer_SetAsrRackId_TYPE criAtomPlayer_SetAsrRackId;
	static criAtomPlayer_SetRawPcmFormat_TYPE criAtomPlayer_SetRawPcmFormat;
	static criAtomPlayer_SetDataRequestCallback_TYPE criAtomPlayer_SetDataRequestCallback;
	static criAtomPlayer_SetStatusChangeCallback_TYPE criAtomPlayer_SetStatusChangeCallback;
	static criAtomPlayer_SetParameterChangeCallback_TYPE criAtomPlayer_SetParameterChangeCallback;
	static criAtomPlayer_SetFilterCallback_TYPE criAtomPlayer_SetFilterCallback;
	static criAtomPlayer_SetLoadRequestCallback_TYPE criAtomPlayer_SetLoadRequestCallback;
	static criAtomDbas_CalculateWorkSize_TYPE criAtomDbas_CalculateWorkSize;
	static criAtomDbas_Create_TYPE criAtomDbas_Create;
	static criAtomDbas_Destroy_TYPE criAtomDbas_Destroy;
	static criAtomDbas_GetStreamingPlayerHandles_TYPE criAtomDbas_GetStreamingPlayerHandles;
	static criAtomStreamingCache_CalculateWorkSize_TYPE criAtomStreamingCache_CalculateWorkSize;
	static criAtomStreamingCache_Create_TYPE criAtomStreamingCache_Create;
	static criAtomStreamingCache_Destroy_TYPE criAtomStreamingCache_Destroy;
	static criAtomStreamingCache_Clear_TYPE criAtomStreamingCache_Clear;
	static criAtomStreamingCache_IsCachedWaveId_TYPE criAtomStreamingCache_IsCachedWaveId;
	static criAtomStreamingCache_IsCachedFile_TYPE criAtomStreamingCache_IsCachedFile;
	static criAtomMeter_CalculateWorkSizeForLevelMeter_TYPE criAtomMeter_CalculateWorkSizeForLevelMeter;
	static criAtomMeter_AttachLevelMeter_TYPE criAtomMeter_AttachLevelMeter;
	static criAtomMeter_DetachLevelMeter_TYPE criAtomMeter_DetachLevelMeter;
	static criAtomMeter_GetLevelInfo_TYPE criAtomMeter_GetLevelInfo;
	static criAtomMeter_CalculateWorkSizeForLoudnessMeter_TYPE criAtomMeter_CalculateWorkSizeForLoudnessMeter;
	static criAtomMeter_AttachLoudnessMeter_TYPE criAtomMeter_AttachLoudnessMeter;
	static criAtomMeter_DetachLoudnessMeter_TYPE criAtomMeter_DetachLoudnessMeter;
	static criAtomMeter_GetLoudnessInfo_TYPE criAtomMeter_GetLoudnessInfo;
	static criAtomMeter_ResetLoudnessMeter_TYPE criAtomMeter_ResetLoudnessMeter;
	static criAtomMeter_CalculateWorkSizeForTruePeakMeter_TYPE criAtomMeter_CalculateWorkSizeForTruePeakMeter;
	static criAtomMeter_AttachTruePeakMeter_TYPE criAtomMeter_AttachTruePeakMeter;
	static criAtomMeter_DetachTruePeakMeter_TYPE criAtomMeter_DetachTruePeakMeter;
	static criAtomMeter_GetTruePeakInfo_TYPE criAtomMeter_GetTruePeakInfo;
	static criAtomInstrument_RegisterInstrumentInterface_TYPE criAtomInstrument_RegisterInstrumentInterface;
	static criAtomInstrument_UnregisterInstrumentInterface_TYPE criAtomInstrument_UnregisterInstrumentInterface;
	static criAtomPlayer_SetDecodeCallback_TYPE criAtomPlayer_SetDecodeCallback;
	static criAtomPlayer_DiscardSamples_TYPE criAtomPlayer_DiscardSamples;
	static criAtomExAsr_CalculateWorkSize_TYPE criAtomExAsr_CalculateWorkSize;
	static criAtomExAsr_SetConfigForWorkSizeCalculation_TYPE criAtomExAsr_SetConfigForWorkSizeCalculation;
	static criAtomExAsr_Initialize_TYPE criAtomExAsr_Initialize;
	static criAtomExAsr_Finalize_TYPE criAtomExAsr_Finalize;
	static criAtomExAsr_EnableBinauralizer_TYPE criAtomExAsr_EnableBinauralizer;
	static criAtomExAsr_SetBusVolumeByName_TYPE criAtomExAsr_SetBusVolumeByName;
	static criAtomExAsr_GetBusVolumeByName_TYPE criAtomExAsr_GetBusVolumeByName;
	static criAtomExAsr_SetBusPan3dByName_TYPE criAtomExAsr_SetBusPan3dByName;
	static criAtomExAsr_GetBusPan3dByName_TYPE criAtomExAsr_GetBusPan3dByName;
	static criAtomExAsr_SetBusMatrixByName_TYPE criAtomExAsr_SetBusMatrixByName;
	static criAtomExAsr_SetBusSendLevelByName_TYPE criAtomExAsr_SetBusSendLevelByName;
	static criAtomExAsr_SetEffectParameter_TYPE criAtomExAsr_SetEffectParameter;
	static criAtomExAsr_UpdateEffectParameters_TYPE criAtomExAsr_UpdateEffectParameters;
	static criAtomExAsr_GetEffectParameter_TYPE criAtomExAsr_GetEffectParameter;
	static criAtomExAsr_SetEffectBypass_TYPE criAtomExAsr_SetEffectBypass;
	static criAtomExAsr_AttachBusAnalyzerByName_TYPE criAtomExAsr_AttachBusAnalyzerByName;
	static criAtomExAsr_DetachBusAnalyzerByName_TYPE criAtomExAsr_DetachBusAnalyzerByName;
	static criAtomExAsr_GetBusAnalyzerInfoByName_TYPE criAtomExAsr_GetBusAnalyzerInfoByName;
	static criAtomExAsr_SetBusFilterCallbackByName_TYPE criAtomExAsr_SetBusFilterCallbackByName;
	static criAtomExAsr_GetNumBuses_TYPE criAtomExAsr_GetNumBuses;
	static criAtomExAsr_RegisterEffectInterface_TYPE criAtomExAsr_RegisterEffectInterface;
	static criAtomExAsr_UnregisterEffectInterface_TYPE criAtomExAsr_UnregisterEffectInterface;
	static criAtomExAsr_RegisterSoundxRInterface_TYPE criAtomExAsr_RegisterSoundxRInterface;
	static criAtomExAsrRack_CalculateWorkSize_TYPE criAtomExAsrRack_CalculateWorkSize;
	static criAtomExAsrRack_CalculateWorkSizeForDspBusSettingFromConfig_TYPE criAtomExAsrRack_CalculateWorkSizeForDspBusSettingFromConfig;
	static criAtomExAsrRack_CalculateWorkSizeForDspBusSettingFromAcfDataAndConfig_TYPE criAtomExAsrRack_CalculateWorkSizeForDspBusSettingFromAcfDataAndConfig;
	static criAtomExAsrRack_Create_TYPE criAtomExAsrRack_Create;
	static criAtomExAsrRack_Destroy_TYPE criAtomExAsrRack_Destroy;
	static criAtomExAsrRack_CalculateWorkSizeForDspBusSetting_TYPE criAtomExAsrRack_CalculateWorkSizeForDspBusSetting;
	static criAtomExAsrRack_AttachDspBusSetting_TYPE criAtomExAsrRack_AttachDspBusSetting;
	static criAtomExAsrRack_DetachDspBusSetting_TYPE criAtomExAsrRack_DetachDspBusSetting;
	static criAtomExAsrRack_ApplyDspBusSnapshot_TYPE criAtomExAsrRack_ApplyDspBusSnapshot;
	static criAtomExAsrRack_GetAppliedDspBusSnapshotName_TYPE criAtomExAsrRack_GetAppliedDspBusSnapshotName;
	static criAtomExAsrRack_SetBusVolumeByName_TYPE criAtomExAsrRack_SetBusVolumeByName;
	static criAtomExAsrRack_GetBusVolumeByName_TYPE criAtomExAsrRack_GetBusVolumeByName;
	static criAtomExAsrRack_SetBusPanInfoByName_TYPE criAtomExAsrRack_SetBusPanInfoByName;
	static criAtomExAsrRack_GetBusPanInfoByName_TYPE criAtomExAsrRack_GetBusPanInfoByName;
	static criAtomExAsrRack_SetBusMatrixByName_TYPE criAtomExAsrRack_SetBusMatrixByName;
	static criAtomExAsrRack_SetBusSendLevelByName_TYPE criAtomExAsrRack_SetBusSendLevelByName;
	static criAtomExAsrRack_SetEffectParameter_TYPE criAtomExAsrRack_SetEffectParameter;
	static criAtomExAsrRack_UpdateEffectParameters_TYPE criAtomExAsrRack_UpdateEffectParameters;
	static criAtomExAsrRack_GetEffectParameter_TYPE criAtomExAsrRack_GetEffectParameter;
	static criAtomExAsrRack_SetEffectBypass_TYPE criAtomExAsrRack_SetEffectBypass;
	static criAtomExAsrRack_GetEffectBypass_TYPE criAtomExAsrRack_GetEffectBypass;
	static criAtomExAsrRack_AttachBusAnalyzerByName_TYPE criAtomExAsrRack_AttachBusAnalyzerByName;
	static criAtomExAsrRack_DetachBusAnalyzerByName_TYPE criAtomExAsrRack_DetachBusAnalyzerByName;
	static criAtomExAsrRack_GetBusAnalyzerInfoByName_TYPE criAtomExAsrRack_GetBusAnalyzerInfoByName;
	static criAtomExAsrRack_SetBusFilterCallbackByName_TYPE criAtomExAsrRack_SetBusFilterCallbackByName;
	static criAtomExAsrRack_SetAlternateRackId_TYPE criAtomExAsrRack_SetAlternateRackId;
	static criAtomExAsrRack_GetNumBuses_TYPE criAtomExAsrRack_GetNumBuses;
	static criAtomExAsrRack_GetPcmDataFloat32_TYPE criAtomExAsrRack_GetPcmDataFloat32;
	static criAtomExAsrRack_GetNumBufferedSamples_TYPE criAtomExAsrRack_GetNumBufferedSamples;
	static criAtomExAsrRack_GetAmplitudeAnalyzerRms_TYPE criAtomExAsrRack_GetAmplitudeAnalyzerRms;
	static criAtomExAsrRack_GetAmplitudeAnalyzerRmsByName_TYPE criAtomExAsrRack_GetAmplitudeAnalyzerRmsByName;
	static criAtomExAsrRack_GetCompressorGain_TYPE criAtomExAsrRack_GetCompressorGain;
	static criAtomExAsrRack_GetCompressorGainByName_TYPE criAtomExAsrRack_GetCompressorGainByName;
	static criAtomExAsrRack_GetCompressorRms_TYPE criAtomExAsrRack_GetCompressorRms;
	static criAtomExAsrRack_GetCompressorRmsByName_TYPE criAtomExAsrRack_GetCompressorRmsByName;
	static criAtomAsr_CalculateWorkSize_TYPE criAtomAsr_CalculateWorkSize;
	static criAtomAsr_Initialize_TYPE criAtomAsr_Initialize;
	static criAtomAsr_Finalize_TYPE criAtomAsr_Finalize;
	static criAtomExAsr_PauseOutputVoice_TYPE criAtomExAsr_PauseOutputVoice;
	static criAtomExAsrRack_GetNumOutputSamples_TYPE criAtomExAsrRack_GetNumOutputSamples;
	static criAtomExAsrRack_GetBusNumber_TYPE criAtomExAsrRack_GetBusNumber;
	static criAtomAsr_PauseOutputVoice_TYPE criAtomAsr_PauseOutputVoice;
	static criAtomAsr_GetAudioTime_TYPE criAtomAsr_GetAudioTime;
	static criAtomExAsrRack_GetAmbisonicRackId_TYPE criAtomExAsrRack_GetAmbisonicRackId;
	static criAtomExAsrRack_GetChannelBasedAudioRackId_TYPE criAtomExAsrRack_GetChannelBasedAudioRackId;
	static criAtomExAsrRack_GetObjectBasedAudioRackId_TYPE criAtomExAsrRack_GetObjectBasedAudioRackId;
	static criAtomExAsr_SetDspParameter_TYPE criAtomExAsr_SetDspParameter;
	static criAtomExAsr_SetDspParameterByName_TYPE criAtomExAsr_SetDspParameterByName;
	static criAtomExAsr_GetDspParameter_TYPE criAtomExAsr_GetDspParameter;
	static criAtomExAsr_GetDspParameterByName_TYPE criAtomExAsr_GetDspParameterByName;
	static criAtomExAsr_SetDspBypass_TYPE criAtomExAsr_SetDspBypass;
	static criAtomExAsr_SetDspBypassByName_TYPE criAtomExAsr_SetDspBypassByName;
	static criAtomExAsr_SetBusVolume_TYPE criAtomExAsr_SetBusVolume;
	static criAtomExAsr_GetBusVolume_TYPE criAtomExAsr_GetBusVolume;
	static criAtomExAsr_SetBusPan3d_TYPE criAtomExAsr_SetBusPan3d;
	static criAtomExAsr_GetBusPan3d_TYPE criAtomExAsr_GetBusPan3d;
	static criAtomExAsr_SetBusMatrix_TYPE criAtomExAsr_SetBusMatrix;
	static criAtomExAsr_SetBusSendLevel_TYPE criAtomExAsr_SetBusSendLevel;
	static criAtomExAsr_AttachBusAnalyzer_TYPE criAtomExAsr_AttachBusAnalyzer;
	static criAtomExAsr_DetachBusAnalyzer_TYPE criAtomExAsr_DetachBusAnalyzer;
	static criAtomExAsr_GetBusAnalyzerInfo_TYPE criAtomExAsr_GetBusAnalyzerInfo;
	static criAtomExAsr_SetBusFilterCallback_TYPE criAtomExAsr_SetBusFilterCallback;
	static criAtomExAsrRack_SetDspParameter_TYPE criAtomExAsrRack_SetDspParameter;
	static criAtomExAsrRack_SetDspParameterByName_TYPE criAtomExAsrRack_SetDspParameterByName;
	static criAtomExAsrRack_GetDspParameter_TYPE criAtomExAsrRack_GetDspParameter;
	static criAtomExAsrRack_GetDspParameterByName_TYPE criAtomExAsrRack_GetDspParameterByName;
	static criAtomExAsrRack_SetDspBypass_TYPE criAtomExAsrRack_SetDspBypass;
	static criAtomExAsrRack_SetDspBypassByName_TYPE criAtomExAsrRack_SetDspBypassByName;
	static criAtomExAsrRack_SetBusVolume_TYPE criAtomExAsrRack_SetBusVolume;
	static criAtomExAsrRack_GetBusVolume_TYPE criAtomExAsrRack_GetBusVolume;
	static criAtomExAsrRack_SetBusMatrix_TYPE criAtomExAsrRack_SetBusMatrix;
	static criAtomExAsrRack_SetBusSendLevel_TYPE criAtomExAsrRack_SetBusSendLevel;
	static criAtomExAsrRack_AttachBusAnalyzer_TYPE criAtomExAsrRack_AttachBusAnalyzer;
	static criAtomExAsrRack_DetachBusAnalyzer_TYPE criAtomExAsrRack_DetachBusAnalyzer;
	static criAtomExAsrRack_GetBusAnalyzerInfo_TYPE criAtomExAsrRack_GetBusAnalyzerInfo;
	static criAtomExAsrRack_SetBusFilterCallback_TYPE criAtomExAsrRack_SetBusFilterCallback;
	static criAtomExOutputPort_CalculateWorkSize_TYPE criAtomExOutputPort_CalculateWorkSize;
	static criAtomExOutputPort_Create_TYPE criAtomExOutputPort_Create;
	static criAtomExOutputPort_Destroy_TYPE criAtomExOutputPort_Destroy;
	static criAtomExOutputPort_SetAsrRackId_TYPE criAtomExOutputPort_SetAsrRackId;
	static criAtomExOutputPort_SetVibrationChannelLevel_TYPE criAtomExOutputPort_SetVibrationChannelLevel;
	static criAtomExOutputPort_SetMonauralMix_TYPE criAtomExOutputPort_SetMonauralMix;

	static criAtomEx_InitializeForUserPcmOutput_TYPE criAtomEx_InitializeForUserPcmOutput;
	static criAtomEx_FinalizeForUserPcmOutput_TYPE criAtomEx_FinalizeForUserPcmOutput;
	static criAtomEx_IsInitialized_TYPE criAtomEx_IsInitialized;
	static criAtomEx_ExecuteMain_TYPE criAtomEx_ExecuteMain;
	static criAtomEx_ExecuteAudioProcess_TYPE criAtomEx_ExecuteAudioProcess;
	static criAtomEx_Lock_TYPE criAtomEx_Lock;
	static criAtomEx_Unlock_TYPE criAtomEx_Unlock;
	static criAtomEx_GetTimeMicro_TYPE criAtomEx_GetTimeMicro;
	static criAtomEx_ResetTimer_TYPE criAtomEx_ResetTimer;
	static criAtomEx_PauseTimer_TYPE criAtomEx_PauseTimer;
	static criAtomEx_SetConfigForWorkSizeCalculation_TYPE criAtomEx_SetConfigForWorkSizeCalculation;
	static criAtomEx_CalculateWorkSizeForRegisterAcfData_TYPE criAtomEx_CalculateWorkSizeForRegisterAcfData;
	static criAtomEx_RegisterAcfData_TYPE criAtomEx_RegisterAcfData;
	static criAtomEx_CalculateWorkSizeForRegisterAcfFile_TYPE criAtomEx_CalculateWorkSizeForRegisterAcfFile;
	static criAtomEx_CalculateWorkSizeForRegisterAcfFileById_TYPE criAtomEx_CalculateWorkSizeForRegisterAcfFileById;
	static criAtomEx_RegisterAcfFile_TYPE criAtomEx_RegisterAcfFile;
	static criAtomEx_RegisterAcfFileById_TYPE criAtomEx_RegisterAcfFileById;
	static criAtomEx_UnregisterAcf_TYPE criAtomEx_UnregisterAcf;
	static criAtomEx_GetAcfVersion_TYPE criAtomEx_GetAcfVersion;
	static criAtomEx_GetAcfVersionFromFile_TYPE criAtomEx_GetAcfVersionFromFile;
	static criAtomEx_GetAcfVersionFromFileById_TYPE criAtomEx_GetAcfVersionFromFileById;
	static criAtomEx_GetSupportedAcfVersion_TYPE criAtomEx_GetSupportedAcfVersion;
	static criAtomEx_AnalyzeAudioHeader_TYPE criAtomEx_AnalyzeAudioHeader;
	static criAtomEx_SetRandomSeed_TYPE criAtomEx_SetRandomSeed;
	static criAtomEx_IsDataPlaying_TYPE criAtomEx_IsDataPlaying;
	static criAtomEx_CalculateWorkSizeForDspBusSetting_TYPE criAtomEx_CalculateWorkSizeForDspBusSetting;
	static criAtomEx_CalculateWorkSizeForDspBusSettingFromAcfData_TYPE criAtomEx_CalculateWorkSizeForDspBusSettingFromAcfData;
	static criAtomEx_AttachDspBusSetting_TYPE criAtomEx_AttachDspBusSetting;
	static criAtomEx_DetachDspBusSetting_TYPE criAtomEx_DetachDspBusSetting;
	static criAtomEx_ApplyDspBusSnapshot_TYPE criAtomEx_ApplyDspBusSnapshot;
	static criAtomEx_GetAppliedDspBusSnapshotName_TYPE criAtomEx_GetAppliedDspBusSnapshotName;
	static criAtomEx_SetCueLinkCallback_TYPE criAtomEx_SetCueLinkCallback;
	static criAtomEx_SetSpeakerAngles_TYPE criAtomEx_SetSpeakerAngles;
	static criAtomEx_SetSpeakerAngleArray_TYPE criAtomEx_SetSpeakerAngleArray;
	static criAtomEx_SetVirtualSpeakerAngleArray_TYPE criAtomEx_SetVirtualSpeakerAngleArray;
	static criAtomEx_ControlVirtualSpeakerSetting_TYPE criAtomEx_ControlVirtualSpeakerSetting;
	static criAtomEx_GetNumGameVariables_TYPE criAtomEx_GetNumGameVariables;
	static criAtomEx_GetGameVariableInfo_TYPE criAtomEx_GetGameVariableInfo;
	static criAtomEx_GetGameVariableById_TYPE criAtomEx_GetGameVariableById;
	static criAtomEx_GetGameVariableByName_TYPE criAtomEx_GetGameVariableByName;
	static criAtomEx_SetGameVariableById_TYPE criAtomEx_SetGameVariableById;
	static criAtomEx_SetGameVariableByName_TYPE criAtomEx_SetGameVariableByName;
	static criAtomEx_SetPlaybackCancelCallback_TYPE criAtomEx_SetPlaybackCancelCallback;
	static criAtomEx_ControlAcfConsistencyCheck_TYPE criAtomEx_ControlAcfConsistencyCheck;
	static criAtomEx_SetAcfConsistencyCheckErrorLevel_TYPE criAtomEx_SetAcfConsistencyCheckErrorLevel;
	static criAtomEx_SetTrackTransitionBySelectorCallback_TYPE criAtomEx_SetTrackTransitionBySelectorCallback;
	static criAtomExDebug_GetResourcesInfo_TYPE criAtomExDebug_GetResourcesInfo;
	static criAtomExHcaMx_CalculateWorkSize_TYPE criAtomExHcaMx_CalculateWorkSize;
	static criAtomExHcaMx_SetConfigForWorkSizeCalculation_TYPE criAtomExHcaMx_SetConfigForWorkSizeCalculation;
	static criAtomExHcaMx_Initialize_TYPE criAtomExHcaMx_Initialize;
	static criAtomExHcaMx_Finalize_TYPE criAtomExHcaMx_Finalize;
	static criAtomExHcaMx_SetFrequencyRatio_TYPE criAtomExHcaMx_SetFrequencyRatio;
	static criAtomExHcaMx_SetAsrRackId_TYPE criAtomExHcaMx_SetAsrRackId;
	static criAtomExAcf_GetNumAisacControls_TYPE criAtomExAcf_GetNumAisacControls;
	static criAtomExAcf_GetAisacControlInfo_TYPE criAtomExAcf_GetAisacControlInfo;
	static criAtomExAcf_GetAisacControlIdByName_TYPE criAtomExAcf_GetAisacControlIdByName;
	static criAtomExAcf_GetAisacControlNameById_TYPE criAtomExAcf_GetAisacControlNameById;
	static criAtomExAcf_GetNumDspSettings_TYPE criAtomExAcf_GetNumDspSettings;
	static criAtomExAcf_GetNumDspSettingsFromAcfData_TYPE criAtomExAcf_GetNumDspSettingsFromAcfData;
	static criAtomExAcf_GetDspSettingNameByIndex_TYPE criAtomExAcf_GetDspSettingNameByIndex;
	static criAtomExAcf_GetDspSettingNameByIndexFromAcfData_TYPE criAtomExAcf_GetDspSettingNameByIndexFromAcfData;
	static criAtomExAcf_GetDspSettingInformation_TYPE criAtomExAcf_GetDspSettingInformation;
	static criAtomExAcf_GetDspSettingSnapshotInformation_TYPE criAtomExAcf_GetDspSettingSnapshotInformation;
	static criAtomExAcf_GetDspBusInformation_TYPE criAtomExAcf_GetDspBusInformation;
	static criAtomExAcf_GetDspFxType_TYPE criAtomExAcf_GetDspFxType;
	static criAtomExAcf_GetDspFxName_TYPE criAtomExAcf_GetDspFxName;
	static criAtomExAcf_GetDspFxParameters_TYPE criAtomExAcf_GetDspFxParameters;
	static criAtomExAcf_GetDspBusLinkInformation_TYPE criAtomExAcf_GetDspBusLinkInformation;
	static criAtomExAcf_GetNumCategoriesFromAcfData_TYPE criAtomExAcf_GetNumCategoriesFromAcfData;
	static criAtomExAcf_GetNumCategories_TYPE criAtomExAcf_GetNumCategories;
	static criAtomExAcf_GetNumCategoriesPerPlaybackFromAcfData_TYPE criAtomExAcf_GetNumCategoriesPerPlaybackFromAcfData;
	static criAtomExAcf_GetNumCategoriesPerPlayback_TYPE criAtomExAcf_GetNumCategoriesPerPlayback;
	static criAtomExAcf_GetCategoryInfo_TYPE criAtomExAcf_GetCategoryInfo;
	static criAtomExAcf_GetCategoryInfoByName_TYPE criAtomExAcf_GetCategoryInfoByName;
	static criAtomExAcf_GetCategoryInfoById_TYPE criAtomExAcf_GetCategoryInfoById;
	static criAtomExAcf_GetNumGlobalAisacs_TYPE criAtomExAcf_GetNumGlobalAisacs;
	static criAtomExAcf_GetGlobalAisacInfo_TYPE criAtomExAcf_GetGlobalAisacInfo;
	static criAtomExAcf_GetGlobalAisacInfoByName_TYPE criAtomExAcf_GetGlobalAisacInfoByName;
	static criAtomExAcf_GetGlobalAisacGraphInfo_TYPE criAtomExAcf_GetGlobalAisacGraphInfo;
	static criAtomExAcf_GetGlobalAisacValue_TYPE criAtomExAcf_GetGlobalAisacValue;
	static criAtomExAcf_GetAcfInfo_TYPE criAtomExAcf_GetAcfInfo;
	static criAtomExAcf_GetAcfInfoFromAcfData_TYPE criAtomExAcf_GetAcfInfoFromAcfData;
	static criAtomExAcf_GetNumSelectors_TYPE criAtomExAcf_GetNumSelectors;
	static criAtomExAcf_GetSelectorInfoByIndex_TYPE criAtomExAcf_GetSelectorInfoByIndex;
	static criAtomExAcf_GetSelectorInfoByName_TYPE criAtomExAcf_GetSelectorInfoByName;
	static criAtomExAcf_GetSelectorLabelInfo_TYPE criAtomExAcf_GetSelectorLabelInfo;
	static criAtomExAcf_SetGlobalLabelToSelectorByName_TYPE criAtomExAcf_SetGlobalLabelToSelectorByName;
	static criAtomExAcf_SetGlobalLabelToSelectorByIndex_TYPE criAtomExAcf_SetGlobalLabelToSelectorByIndex;
	static criAtomExAcf_GetNumBusesFromAcfData_TYPE criAtomExAcf_GetNumBusesFromAcfData;
	static criAtomExAcf_GetNumBuses_TYPE criAtomExAcf_GetNumBuses;
	static criAtomExAcf_GetMaxBusesOfDspBusSettingsFromAcfData_TYPE criAtomExAcf_GetMaxBusesOfDspBusSettingsFromAcfData;
	static criAtomExAcf_GetMaxBusesOfDspBusSettings_TYPE criAtomExAcf_GetMaxBusesOfDspBusSettings;
	static criAtomExAcf_FindBusName_TYPE criAtomExAcf_FindBusName;
	static criAtomExAcf_GetOutputPortHnByName_TYPE criAtomExAcf_GetOutputPortHnByName;
	static criAtomExAcf_DoCreateSpatialAsrRack_TYPE criAtomExAcf_DoCreateSpatialAsrRack;
	static criAtomExAcb_CalculateWorkSizeForLoadAcbData_TYPE criAtomExAcb_CalculateWorkSizeForLoadAcbData;
	static criAtomExAcb_CalculateWorkSizeForLoadAcbDataById_TYPE criAtomExAcb_CalculateWorkSizeForLoadAcbDataById;
	static criAtomExAcb_LoadAcbData_TYPE criAtomExAcb_LoadAcbData;
	static criAtomExAcb_LoadAcbDataById_TYPE criAtomExAcb_LoadAcbDataById;
	static criAtomExAcb_CalculateWorkSizeForLoadAcbFile_TYPE criAtomExAcb_CalculateWorkSizeForLoadAcbFile;
	static criAtomExAcb_CalculateWorkSizeForLoadAcbFileById_TYPE criAtomExAcb_CalculateWorkSizeForLoadAcbFileById;
	static criAtomExAcb_LoadAcbFile_TYPE criAtomExAcb_LoadAcbFile;
	static criAtomExAcb_LoadAcbFileById_TYPE criAtomExAcb_LoadAcbFileById;
	static criAtomExAcb_Release_TYPE criAtomExAcb_Release;
	static criAtomExAcb_IsReadyToRelease_TYPE criAtomExAcb_IsReadyToRelease;
	static criAtomExAcb_ReleaseAll_TYPE criAtomExAcb_ReleaseAll;
	static criAtomExAcb_EnumerateHandles_TYPE criAtomExAcb_EnumerateHandles;
	static criAtomExAcb_GetVersion_TYPE criAtomExAcb_GetVersion;
	static criAtomExAcb_GetVersionFromFile_TYPE criAtomExAcb_GetVersionFromFile;
	static criAtomExAcb_GetSupportedVersion_TYPE criAtomExAcb_GetSupportedVersion;
	static criAtomExAcb_GetNumCues_TYPE criAtomExAcb_GetNumCues;
	static criAtomExAcb_ExistsId_TYPE criAtomExAcb_ExistsId;
	static criAtomExAcb_ExistsName_TYPE criAtomExAcb_ExistsName;
	static criAtomExAcb_ExistsIndex_TYPE criAtomExAcb_ExistsIndex;
	static criAtomExAcb_GetCueIdByIndex_TYPE criAtomExAcb_GetCueIdByIndex;
	static criAtomExAcb_GetCueIdByName_TYPE criAtomExAcb_GetCueIdByName;
	static criAtomExAcb_GetCueNameByIndex_TYPE criAtomExAcb_GetCueNameByIndex;
	static criAtomExAcb_GetCueNameById_TYPE criAtomExAcb_GetCueNameById;
	static criAtomExAcb_GetCueIndexById_TYPE criAtomExAcb_GetCueIndexById;
	static criAtomExAcb_GetCueIndexByName_TYPE criAtomExAcb_GetCueIndexByName;
	static criAtomExAcb_GetUserDataById_TYPE criAtomExAcb_GetUserDataById;
	static criAtomExAcb_GetUserDataByName_TYPE criAtomExAcb_GetUserDataByName;
	static criAtomExAcb_GetLengthById_TYPE criAtomExAcb_GetLengthById;
	static criAtomExAcb_GetLengthByName_TYPE criAtomExAcb_GetLengthByName;
	static criAtomExAcb_GetNumUsableAisacControlsById_TYPE criAtomExAcb_GetNumUsableAisacControlsById;
	static criAtomExAcb_GetNumUsableAisacControlsByName_TYPE criAtomExAcb_GetNumUsableAisacControlsByName;
	static criAtomExAcb_GetUsableAisacControlById_TYPE criAtomExAcb_GetUsableAisacControlById;
	static criAtomExAcb_GetUsableAisacControlByName_TYPE criAtomExAcb_GetUsableAisacControlByName;
	static criAtomExAcb_IsUsingAisacControlById_TYPE criAtomExAcb_IsUsingAisacControlById;
	static criAtomExAcb_IsUsingAisacControlByName_TYPE criAtomExAcb_IsUsingAisacControlByName;
	static criAtomExAcb_GetCuePriorityById_TYPE criAtomExAcb_GetCuePriorityById;
	static criAtomExAcb_GetCuePriorityByName_TYPE criAtomExAcb_GetCuePriorityByName;
	static criAtomExAcb_GetWaveformInfoById_TYPE criAtomExAcb_GetWaveformInfoById;
	static criAtomExAcb_GetWaveformInfoByName_TYPE criAtomExAcb_GetWaveformInfoByName;
	static criAtomExAcb_GetOnMemoryAwbHandle_TYPE criAtomExAcb_GetOnMemoryAwbHandle;
	static criAtomExAcb_GetStreamingAwbHandle_TYPE criAtomExAcb_GetStreamingAwbHandle;
	static criAtomExAcb_GetStreamingAwbHandleBySlotIndex_TYPE criAtomExAcb_GetStreamingAwbHandleBySlotIndex;
	static criAtomExAcb_GetStreamingAwbHandleBySlotName_TYPE criAtomExAcb_GetStreamingAwbHandleBySlotName;
	static criAtomExAcb_GetCueInfoByName_TYPE criAtomExAcb_GetCueInfoByName;
	static criAtomExAcb_GetCueInfoById_TYPE criAtomExAcb_GetCueInfoById;
	static criAtomExAcb_GetCueInfoByIndex_TYPE criAtomExAcb_GetCueInfoByIndex;
	static criAtomExAcb_GetNumCuePlayingCountByName_TYPE criAtomExAcb_GetNumCuePlayingCountByName;
	static criAtomExAcb_GetNumCuePlayingCountById_TYPE criAtomExAcb_GetNumCuePlayingCountById;
	static criAtomExAcb_GetNumCuePlayingCountByIndex_TYPE criAtomExAcb_GetNumCuePlayingCountByIndex;
	static criAtomExAcb_GetBlockIndexByIndex_TYPE criAtomExAcb_GetBlockIndexByIndex;
	static criAtomExAcb_GetBlockIndexById_TYPE criAtomExAcb_GetBlockIndexById;
	static criAtomExAcb_GetBlockIndexByName_TYPE criAtomExAcb_GetBlockIndexByName;
	static criAtomExAcb_SetDetectionInGamePreviewDataCallback_TYPE criAtomExAcb_SetDetectionInGamePreviewDataCallback;
	static criAtomExAcb_GetAcbInfo_TYPE criAtomExAcb_GetAcbInfo;
	static criAtomExAcb_ResetCueTypeStateByName_TYPE criAtomExAcb_ResetCueTypeStateByName;
	static criAtomExAcb_ResetCueTypeStateById_TYPE criAtomExAcb_ResetCueTypeStateById;
	static criAtomExAcb_ResetCueTypeStateByIndex_TYPE criAtomExAcb_ResetCueTypeStateByIndex;
	static criAtomExAcb_AttachAwbFile_TYPE criAtomExAcb_AttachAwbFile;
	static criAtomExAcb_DetachAwbFile_TYPE criAtomExAcb_DetachAwbFile;
	static criAtomExAcb_AttachAwbHn_TYPE criAtomExAcb_AttachAwbHn;
	static criAtomExAcb_CalculateWorkSizeForAttachAwbFile_TYPE criAtomExAcb_CalculateWorkSizeForAttachAwbFile;
	static criAtomExAcb_GetNumAwbFileSlots_TYPE criAtomExAcb_GetNumAwbFileSlots;
	static criAtomExAcb_GetAwbFileSlotName_TYPE criAtomExAcb_GetAwbFileSlotName;
	static criAtomExAcb_IsAttachedAwbFile_TYPE criAtomExAcb_IsAttachedAwbFile;
	static criAtomExVoicePool_CalculateWorkSizeForStandardVoicePool_TYPE criAtomExVoicePool_CalculateWorkSizeForStandardVoicePool;
	static criAtomExVoicePool_AllocateStandardVoicePool_TYPE criAtomExVoicePool_AllocateStandardVoicePool;
	static criAtomExVoicePool_CalculateWorkSizeForAdxVoicePool_TYPE criAtomExVoicePool_CalculateWorkSizeForAdxVoicePool;
	static criAtomExVoicePool_AllocateAdxVoicePool_TYPE criAtomExVoicePool_AllocateAdxVoicePool;
	static criAtomExVoicePool_CalculateWorkSizeForHcaVoicePool_TYPE criAtomExVoicePool_CalculateWorkSizeForHcaVoicePool;
	static criAtomExVoicePool_AllocateHcaVoicePool_TYPE criAtomExVoicePool_AllocateHcaVoicePool;
	static criAtomExVoicePool_CalculateWorkSizeForHcaMxVoicePool_TYPE criAtomExVoicePool_CalculateWorkSizeForHcaMxVoicePool;
	static criAtomExVoicePool_AllocateHcaMxVoicePool_TYPE criAtomExVoicePool_AllocateHcaMxVoicePool;
	static criAtomExVoicePool_CalculateWorkSizeForWaveVoicePool_TYPE criAtomExVoicePool_CalculateWorkSizeForWaveVoicePool;
	static criAtomExVoicePool_AllocateWaveVoicePool_TYPE criAtomExVoicePool_AllocateWaveVoicePool;
	static criAtomExVoicePool_CalculateWorkSizeForAiffVoicePool_TYPE criAtomExVoicePool_CalculateWorkSizeForAiffVoicePool;
	static criAtomExVoicePool_AllocateAiffVoicePool_TYPE criAtomExVoicePool_AllocateAiffVoicePool;
	static criAtomExVoicePool_CalculateWorkSizeForRawPcmVoicePool_TYPE criAtomExVoicePool_CalculateWorkSizeForRawPcmVoicePool;
	static criAtomExVoicePool_AllocateRawPcmVoicePool_TYPE criAtomExVoicePool_AllocateRawPcmVoicePool;
	static criAtomExVoicePool_AllocateInstrumentVoicePool_TYPE criAtomExVoicePool_AllocateInstrumentVoicePool;
	static criAtomExVoicePool_Free_TYPE criAtomExVoicePool_Free;
	static criAtomExVoicePool_FreeAll_TYPE criAtomExVoicePool_FreeAll;
	static criAtomExVoicePool_GetNumUsedVoices_TYPE criAtomExVoicePool_GetNumUsedVoices;
	static criAtomExVoicePool_GetPlayerHandle_TYPE criAtomExVoicePool_GetPlayerHandle;
	static criAtomExVoicePool_CalculateWorkSizeForInstrumentVoicePool_TYPE criAtomExVoicePool_CalculateWorkSizeForInstrumentVoicePool;
	static criAtomExInputPort_Create_TYPE criAtomExInputPort_Create;
	static criAtomExInputPort_Destroy_TYPE criAtomExInputPort_Destroy;
	static criAtomExCategory_SetVolumeById_TYPE criAtomExCategory_SetVolumeById;
	static criAtomExCategory_GetVolumeById_TYPE criAtomExCategory_GetVolumeById;
	static criAtomExCategory_GetTotalVolumeById_TYPE criAtomExCategory_GetTotalVolumeById;
	static criAtomExCategory_SetVolumeByName_TYPE criAtomExCategory_SetVolumeByName;
	static criAtomExCategory_GetVolumeByName_TYPE criAtomExCategory_GetVolumeByName;
	static criAtomExCategory_GetTotalVolumeByName_TYPE criAtomExCategory_GetTotalVolumeByName;
	static criAtomExCategory_MuteById_TYPE criAtomExCategory_MuteById;
	static criAtomExCategory_IsMutedById_TYPE criAtomExCategory_IsMutedById;
	static criAtomExCategory_MuteByName_TYPE criAtomExCategory_MuteByName;
	static criAtomExCategory_IsMutedByName_TYPE criAtomExCategory_IsMutedByName;
	static criAtomExCategory_SoloById_TYPE criAtomExCategory_SoloById;
	static criAtomExCategory_IsSoloedById_TYPE criAtomExCategory_IsSoloedById;
	static criAtomExCategory_SoloByName_TYPE criAtomExCategory_SoloByName;
	static criAtomExCategory_IsSoloedByName_TYPE criAtomExCategory_IsSoloedByName;
	static criAtomExCategory_PauseById_TYPE criAtomExCategory_PauseById;
	static criAtomExCategory_IsPausedById_TYPE criAtomExCategory_IsPausedById;
	static criAtomExCategory_PauseByName_TYPE criAtomExCategory_PauseByName;
	static criAtomExCategory_IsPausedByName_TYPE criAtomExCategory_IsPausedByName;
	static criAtomExCategory_SetFadeInTimeById_TYPE criAtomExCategory_SetFadeInTimeById;
	static criAtomExCategory_SetFadeInTimeByName_TYPE criAtomExCategory_SetFadeInTimeByName;
	static criAtomExCategory_SetFadeOutTimeById_TYPE criAtomExCategory_SetFadeOutTimeById;
	static criAtomExCategory_SetFadeOutTimeByName_TYPE criAtomExCategory_SetFadeOutTimeByName;
	static criAtomExCategory_SetAisacControlById_TYPE criAtomExCategory_SetAisacControlById;
	static criAtomExCategory_SetAisacControlByName_TYPE criAtomExCategory_SetAisacControlByName;
	static criAtomExCategory_ResetAllAisacControlById_TYPE criAtomExCategory_ResetAllAisacControlById;
	static criAtomExCategory_ResetAllAisacControlByName_TYPE criAtomExCategory_ResetAllAisacControlByName;
	static criAtomExCategory_AttachAisacById_TYPE criAtomExCategory_AttachAisacById;
	static criAtomExCategory_AttachAisacByName_TYPE criAtomExCategory_AttachAisacByName;
	static criAtomExCategory_DetachAisacById_TYPE criAtomExCategory_DetachAisacById;
	static criAtomExCategory_DetachAisacByName_TYPE criAtomExCategory_DetachAisacByName;
	static criAtomExCategory_DetachAisacAllById_TYPE criAtomExCategory_DetachAisacAllById;
	static criAtomExCategory_DetachAisacAllByName_TYPE criAtomExCategory_DetachAisacAllByName;
	static criAtomExCategory_GetNumAttachedAisacsById_TYPE criAtomExCategory_GetNumAttachedAisacsById;
	static criAtomExCategory_GetNumAttachedAisacsByName_TYPE criAtomExCategory_GetNumAttachedAisacsByName;
	static criAtomExCategory_GetAttachedAisacInfoById_TYPE criAtomExCategory_GetAttachedAisacInfoById;
	static criAtomExCategory_GetAttachedAisacInfoByName_TYPE criAtomExCategory_GetAttachedAisacInfoByName;
	static criAtomExCategory_GetCurrentAisacControlValueById_TYPE criAtomExCategory_GetCurrentAisacControlValueById;
	static criAtomExCategory_GetCurrentAisacControlValueByName_TYPE criAtomExCategory_GetCurrentAisacControlValueByName;
	static criAtomExCategory_SetReactParameter_TYPE criAtomExCategory_SetReactParameter;
	static criAtomExCategory_GetReactParameter_TYPE criAtomExCategory_GetReactParameter;
	static criAtomExCategory_GetNumCuePlayingCountById_TYPE criAtomExCategory_GetNumCuePlayingCountById;
	static criAtomExCategory_GetNumCuePlayingCountByName_TYPE criAtomExCategory_GetNumCuePlayingCountByName;
	static criAtomExCategory_StopById_TYPE criAtomExCategory_StopById;
	static criAtomExCategory_StopByName_TYPE criAtomExCategory_StopByName;
	static criAtomExCategory_StopWithoutReleaseTimeById_TYPE criAtomExCategory_StopWithoutReleaseTimeById;
	static criAtomExCategory_StopWithoutReleaseTimeByName_TYPE criAtomExCategory_StopWithoutReleaseTimeByName;
	static criAtomExPlayer_CalculateWorkSize_TYPE criAtomExPlayer_CalculateWorkSize;
	static criAtomExPlayer_Create_TYPE criAtomExPlayer_Create;
	static criAtomExPlayer_Destroy_TYPE criAtomExPlayer_Destroy;
	static criAtomExPlayer_SetCueId_TYPE criAtomExPlayer_SetCueId;
	static criAtomExPlayer_SetCueName_TYPE criAtomExPlayer_SetCueName;
	static criAtomExPlayer_SetCueIndex_TYPE criAtomExPlayer_SetCueIndex;
	static criAtomExPlayer_SetData_TYPE criAtomExPlayer_SetData;
	static criAtomExPlayer_SetFile_TYPE criAtomExPlayer_SetFile;
	static criAtomExPlayer_SetContentId_TYPE criAtomExPlayer_SetContentId;
	static criAtomExPlayer_SetWaveId_TYPE criAtomExPlayer_SetWaveId;
	static criAtomExPlayer_Start_TYPE criAtomExPlayer_Start;
	static criAtomExPlayer_Prepare_TYPE criAtomExPlayer_Prepare;
	static criAtomExPlayer_Stop_TYPE criAtomExPlayer_Stop;
	static criAtomExPlayer_StopWithoutReleaseTime_TYPE criAtomExPlayer_StopWithoutReleaseTime;
	static criAtomExPlayer_StopAllPlayers_TYPE criAtomExPlayer_StopAllPlayers;
	static criAtomExPlayer_StopAllPlayersWithoutReleaseTime_TYPE criAtomExPlayer_StopAllPlayersWithoutReleaseTime;
	static criAtomExPlayer_EnumeratePlayers_TYPE criAtomExPlayer_EnumeratePlayers;
	static criAtomExPlayer_Pause_TYPE criAtomExPlayer_Pause;
	static criAtomExPlayer_Resume_TYPE criAtomExPlayer_Resume;
	static criAtomExPlayer_IsPaused_TYPE criAtomExPlayer_IsPaused;
	static criAtomExPlayer_GetStatus_TYPE criAtomExPlayer_GetStatus;
	static criAtomExPlayer_GetNumPlaybacks_TYPE criAtomExPlayer_GetNumPlaybacks;
	static criAtomExPlayer_GetLastPlaybackId_TYPE criAtomExPlayer_GetLastPlaybackId;
	static criAtomExPlayer_GetTime_TYPE criAtomExPlayer_GetTime;
	static criAtomExPlayer_SetFormat_TYPE criAtomExPlayer_SetFormat;
	static criAtomExPlayer_SetNumChannels_TYPE criAtomExPlayer_SetNumChannels;
	static criAtomExPlayer_SetSamplingRate_TYPE criAtomExPlayer_SetSamplingRate;
	static criAtomExPlayer_SetSoundRendererType_TYPE criAtomExPlayer_SetSoundRendererType;
	static criAtomExPlayer_SetGroupNumber_TYPE criAtomExPlayer_SetGroupNumber;
	static criAtomExPlayer_SetVoiceControlMethod_TYPE criAtomExPlayer_SetVoiceControlMethod;
	static criAtomExPlayer_SetVoicePoolIdentifier_TYPE criAtomExPlayer_SetVoicePoolIdentifier;
	static criAtomExPlayer_SetInputPort_TYPE criAtomExPlayer_SetInputPort;
	static criAtomExPlayer_SetHcaMxMixerId_TYPE criAtomExPlayer_SetHcaMxMixerId;
	static criAtomExPlayer_SetAsrRackId_TYPE criAtomExPlayer_SetAsrRackId;
	static criAtomExPlayer_SetAsrRackIdArray_TYPE criAtomExPlayer_SetAsrRackIdArray;
	static criAtomExPlayer_SetStartTime_TYPE criAtomExPlayer_SetStartTime;
	static criAtomExPlayer_SetSyncPlaybackId_TYPE criAtomExPlayer_SetSyncPlaybackId;
	static criAtomExPlayer_SetPlaybackRatio_TYPE criAtomExPlayer_SetPlaybackRatio;
	static criAtomExPlayer_LimitLoopCount_TYPE criAtomExPlayer_LimitLoopCount;
	static criAtomExPlayer_UpdateAll_TYPE criAtomExPlayer_UpdateAll;
	static criAtomExPlayer_Update_TYPE criAtomExPlayer_Update;
	static criAtomExPlayer_ResetParameters_TYPE criAtomExPlayer_ResetParameters;
	static criAtomExPlayer_GetParameterFloat32_TYPE criAtomExPlayer_GetParameterFloat32;
	static criAtomExPlayer_GetParameterUint32_TYPE criAtomExPlayer_GetParameterUint32;
	static criAtomExPlayer_GetParameterSint32_TYPE criAtomExPlayer_GetParameterSint32;
	static criAtomExPlayer_SetVolume_TYPE criAtomExPlayer_SetVolume;
	static criAtomExPlayer_SetPitch_TYPE criAtomExPlayer_SetPitch;
	static criAtomExPlayer_SetMaxPitch_TYPE criAtomExPlayer_SetMaxPitch;
	static criAtomExPlayer_SetPan3dAngle_TYPE criAtomExPlayer_SetPan3dAngle;
	static criAtomExPlayer_SetPan3dInteriorDistance_TYPE criAtomExPlayer_SetPan3dInteriorDistance;
	static criAtomExPlayer_SetPan3dVolume_TYPE criAtomExPlayer_SetPan3dVolume;
	static criAtomExPlayer_SetPanType_TYPE criAtomExPlayer_SetPanType;
	static criAtomExPlayer_SetPanSpeakerType_TYPE criAtomExPlayer_SetPanSpeakerType;
	static criAtomExPlayer_AddMixDownCenterVolumeOffset_TYPE criAtomExPlayer_AddMixDownCenterVolumeOffset;
	static criAtomExPlayer_AddMixDownLfeVolumeOffset_TYPE criAtomExPlayer_AddMixDownLfeVolumeOffset;
	static criAtomExPlayer_ChangeDefaultPanSpeakerType_TYPE criAtomExPlayer_ChangeDefaultPanSpeakerType;
	static criAtomExPlayer_SetPanAngleType_TYPE criAtomExPlayer_SetPanAngleType;
	static criAtomExPlayer_SetWideness_TYPE criAtomExPlayer_SetWideness;
	static criAtomExPlayer_SetSendLevel_TYPE criAtomExPlayer_SetSendLevel;
	static criAtomExPlayer_SetBusSendLevelByName_TYPE criAtomExPlayer_SetBusSendLevelByName;
	static criAtomExPlayer_SetBusSendLevelOffsetByName_TYPE criAtomExPlayer_SetBusSendLevelOffsetByName;
	static criAtomExPlayer_ResetBusSends_TYPE criAtomExPlayer_ResetBusSends;
	static criAtomExPlayer_SetPanAdx1Compatible_TYPE criAtomExPlayer_SetPanAdx1Compatible;
	static criAtomExPlayer_SetBandpassFilterParameters_TYPE criAtomExPlayer_SetBandpassFilterParameters;
	static criAtomExPlayer_SetBiquadFilterParameters_TYPE criAtomExPlayer_SetBiquadFilterParameters;
	static criAtomExPlayer_SetVoicePriority_TYPE criAtomExPlayer_SetVoicePriority;
	static criAtomExPlayer_SetAisacControlById_TYPE criAtomExPlayer_SetAisacControlById;
	static criAtomExPlayer_SetAisacControlByName_TYPE criAtomExPlayer_SetAisacControlByName;
	static criAtomExPlayer_ClearAisacControls_TYPE criAtomExPlayer_ClearAisacControls;
	static criAtomExPlayer_Set3dSourceHn_TYPE criAtomExPlayer_Set3dSourceHn;
	static criAtomExPlayer_Set3dSourceListHn_TYPE criAtomExPlayer_Set3dSourceListHn;
	static criAtomExPlayer_Set3dListenerHn_TYPE criAtomExPlayer_Set3dListenerHn;
	static criAtomExPlayer_GetAisacControlById_TYPE criAtomExPlayer_GetAisacControlById;
	static criAtomExPlayer_GetAisacControlByName_TYPE criAtomExPlayer_GetAisacControlByName;
	static criAtomExPlayer_SetCategoryById_TYPE criAtomExPlayer_SetCategoryById;
	static criAtomExPlayer_SetCategoryByName_TYPE criAtomExPlayer_SetCategoryByName;
	static criAtomExPlayer_UnsetCategory_TYPE criAtomExPlayer_UnsetCategory;
	static criAtomExPlayer_GetNumCategories_TYPE criAtomExPlayer_GetNumCategories;
	static criAtomExPlayer_GetCategoryInfo_TYPE criAtomExPlayer_GetCategoryInfo;
	static criAtomExPlayer_SetTrackInfo_TYPE criAtomExPlayer_SetTrackInfo;
	static criAtomExPlayer_SetTrackVolume_TYPE criAtomExPlayer_SetTrackVolume;
	static criAtomExPlayer_SetSilentMode_TYPE criAtomExPlayer_SetSilentMode;
	static criAtomExPlayer_SetCuePriority_TYPE criAtomExPlayer_SetCuePriority;
	static criAtomExPlayer_SetPreDelayTime_TYPE criAtomExPlayer_SetPreDelayTime;
	static criAtomExPlayer_SetEnvelopeAttackTime_TYPE criAtomExPlayer_SetEnvelopeAttackTime;
	static criAtomExPlayer_SetEnvelopeHoldTime_TYPE criAtomExPlayer_SetEnvelopeHoldTime;
	static criAtomExPlayer_SetEnvelopeDecayTime_TYPE criAtomExPlayer_SetEnvelopeDecayTime;
	static criAtomExPlayer_SetEnvelopeReleaseTime_TYPE criAtomExPlayer_SetEnvelopeReleaseTime;
	static criAtomExPlayer_SetEnvelopeSustainLevel_TYPE criAtomExPlayer_SetEnvelopeSustainLevel;
	static criAtomExPlayer_SetEnvelopeAttackCurve_TYPE criAtomExPlayer_SetEnvelopeAttackCurve;
	static criAtomExPlayer_SetEnvelopeDecayCurve_TYPE criAtomExPlayer_SetEnvelopeDecayCurve;
	static criAtomExPlayer_SetEnvelopeReleaseCurve_TYPE criAtomExPlayer_SetEnvelopeReleaseCurve;
	static criAtomExPlayer_SetDataRequestCallback_TYPE criAtomExPlayer_SetDataRequestCallback;
	static criAtomExPlayer_SetFilterCallback_TYPE criAtomExPlayer_SetFilterCallback;
	static criAtomExPlayer_SetRandomSeed_TYPE criAtomExPlayer_SetRandomSeed;
	static criAtomExPlayer_SetDspParameter_TYPE criAtomExPlayer_SetDspParameter;
	static criAtomExPlayer_AttachAisac_TYPE criAtomExPlayer_AttachAisac;
	static criAtomExPlayer_AttachAisacByIndex_TYPE criAtomExPlayer_AttachAisacByIndex;
	static criAtomExPlayer_DetachAisac_TYPE criAtomExPlayer_DetachAisac;
	static criAtomExPlayer_DetachAisacByIndex_TYPE criAtomExPlayer_DetachAisacByIndex;
	static criAtomExPlayer_DetachAisacAll_TYPE criAtomExPlayer_DetachAisacAll;
	static criAtomExPlayer_GetNumAttachedAisacs_TYPE criAtomExPlayer_GetNumAttachedAisacs;
	static criAtomExPlayer_GetAttachedAisacInfo_TYPE criAtomExPlayer_GetAttachedAisacInfo;
	static criAtomExPlayer_SetStreamingCacheId_TYPE criAtomExPlayer_SetStreamingCacheId;
	static criAtomExPlayer_AttachTween_TYPE criAtomExPlayer_AttachTween;
	static criAtomExPlayer_DetachTween_TYPE criAtomExPlayer_DetachTween;
	static criAtomExPlayer_DetachTweenAll_TYPE criAtomExPlayer_DetachTweenAll;
	static criAtomExPlayer_SetFirstBlockIndex_TYPE criAtomExPlayer_SetFirstBlockIndex;
	static criAtomExPlayer_SetBlockTransitionCallback_TYPE criAtomExPlayer_SetBlockTransitionCallback;
	static criAtomExPlayer_GetSoundObject_TYPE criAtomExPlayer_GetSoundObject;
	static criAtomExPlayer_SetDrySendLevel_TYPE criAtomExPlayer_SetDrySendLevel;
	static criAtomExPlayer_SetSelectorLabel_TYPE criAtomExPlayer_SetSelectorLabel;
	static criAtomExPlayer_ClearSelectorLabels_TYPE criAtomExPlayer_ClearSelectorLabels;
	static criAtomExPlayer_SetPlaybackTrackInfoNotificationCallback_TYPE criAtomExPlayer_SetPlaybackTrackInfoNotificationCallback;
	static criAtomExPlayer_SetPlaybackEventCallback_TYPE criAtomExPlayer_SetPlaybackEventCallback;
	static criAtomExPlayback_Stop_TYPE criAtomExPlayback_Stop;
	static criAtomExPlayback_StopWithoutReleaseTime_TYPE criAtomExPlayback_StopWithoutReleaseTime;
	static criAtomExPlayback_Pause_TYPE criAtomExPlayback_Pause;
	static criAtomExPlayback_Resume_TYPE criAtomExPlayback_Resume;
	static criAtomExPlayback_IsPaused_TYPE criAtomExPlayback_IsPaused;
	static criAtomExPlayback_GetStatus_TYPE criAtomExPlayback_GetStatus;
	static criAtomExPlayback_GetFormatInfo_TYPE criAtomExPlayback_GetFormatInfo;
	static criAtomExPlayback_GetSource_TYPE criAtomExPlayback_GetSource;
	static criAtomExPlayback_GetAtomPlayer_TYPE criAtomExPlayback_GetAtomPlayer;
	static criAtomExPlayback_GetTime_TYPE criAtomExPlayback_GetTime;
	static criAtomExPlayback_GetTimeSyncedWithAudio_TYPE criAtomExPlayback_GetTimeSyncedWithAudio;
	static criAtomExPlayback_GetTimeSyncedWithAudioMicro_TYPE criAtomExPlayback_GetTimeSyncedWithAudioMicro;
	static criAtomExPlayback_GetSequencePosition_TYPE criAtomExPlayback_GetSequencePosition;
	static criAtomExPlayback_GetNumPlayedSamples_TYPE criAtomExPlayback_GetNumPlayedSamples;
	static criAtomExPlayback_GetParameterFloat32_TYPE criAtomExPlayback_GetParameterFloat32;
	static criAtomExPlayback_GetParameterUint32_TYPE criAtomExPlayback_GetParameterUint32;
	static criAtomExPlayback_GetParameterSint32_TYPE criAtomExPlayback_GetParameterSint32;
	static criAtomExPlayback_GetAisacControlById_TYPE criAtomExPlayback_GetAisacControlById;
	static criAtomExPlayback_GetAisacControlByName_TYPE criAtomExPlayback_GetAisacControlByName;
	static criAtomExPlayback_SetNextBlockIndex_TYPE criAtomExPlayback_SetNextBlockIndex;
	static criAtomExPlayback_GetCurrentBlockIndex_TYPE criAtomExPlayback_GetCurrentBlockIndex;
	static criAtomExPlayback_GetPlaybackTrackInfo_TYPE criAtomExPlayback_GetPlaybackTrackInfo;
	static criAtomExPlayback_GetBeatSyncInfo_TYPE criAtomExPlayback_GetBeatSyncInfo;
	static criAtomExPlayback_SetBeatSyncOffset_TYPE criAtomExPlayback_SetBeatSyncOffset;
	static criAtomExPlayer_CalculateWorkSizeForFader_TYPE criAtomExPlayer_CalculateWorkSizeForFader;
	static criAtomExPlayer_AttachFader_TYPE criAtomExPlayer_AttachFader;
	static criAtomExPlayer_DetachFader_TYPE criAtomExPlayer_DetachFader;
	static criAtomExPlayer_SetFadeOutTime_TYPE criAtomExPlayer_SetFadeOutTime;
	static criAtomExPlayer_GetFadeOutTime_TYPE criAtomExPlayer_GetFadeOutTime;
	static criAtomExPlayer_SetFadeInTime_TYPE criAtomExPlayer_SetFadeInTime;
	static criAtomExPlayer_GetFadeInTime_TYPE criAtomExPlayer_GetFadeInTime;
	static criAtomExPlayer_SetFadeInStartOffset_TYPE criAtomExPlayer_SetFadeInStartOffset;
	static criAtomExPlayer_GetFadeInStartOffset_TYPE criAtomExPlayer_GetFadeInStartOffset;
	static criAtomExPlayer_SetFadeOutEndDelay_TYPE criAtomExPlayer_SetFadeOutEndDelay;
	static criAtomExPlayer_GetFadeOutEndDelay_TYPE criAtomExPlayer_GetFadeOutEndDelay;
	static criAtomExPlayer_IsFading_TYPE criAtomExPlayer_IsFading;
	static criAtomExPlayer_ResetFaderParameters_TYPE criAtomExPlayer_ResetFaderParameters;
	static criAtomExSequencer_SetEventCallback_TYPE criAtomExSequencer_SetEventCallback;
	static criAtomExBeatSync_SetCallback_TYPE criAtomExBeatSync_SetCallback;
	static criAtomEx3dSource_CalculateWorkSize_TYPE criAtomEx3dSource_CalculateWorkSize;
	static criAtomEx3dSource_Create_TYPE criAtomEx3dSource_Create;
	static criAtomEx3dSource_Destroy_TYPE criAtomEx3dSource_Destroy;  
	static criAtomEx3dSource_Update_TYPE criAtomEx3dSource_Update;
	static criAtomEx3dSource_ResetParameters_TYPE criAtomEx3dSource_ResetParameters;
	static criAtomEx3dSource_SetPosition_TYPE criAtomEx3dSource_SetPosition;
	static criAtomEx3dSource_GetPosition_TYPE criAtomEx3dSource_GetPosition;
	static criAtomEx3dSource_SetVelocity_TYPE criAtomEx3dSource_SetVelocity;
	static criAtomEx3dSource_SetOrientation_TYPE criAtomEx3dSource_SetOrientation;
	static criAtomEx3dSource_SetConeParameter_TYPE criAtomEx3dSource_SetConeParameter;
	static criAtomEx3dSource_ChangeDefaultConeParameter_TYPE criAtomEx3dSource_ChangeDefaultConeParameter;
	static criAtomEx3dSource_SetMinMaxAttenuationDistance_TYPE criAtomEx3dSource_SetMinMaxAttenuationDistance;
	static criAtomEx3dSource_ChangeDefaultMinMaxAttenuationDistance_TYPE criAtomEx3dSource_ChangeDefaultMinMaxAttenuationDistance;
	static criAtomEx3dSource_SetInteriorPanField_TYPE criAtomEx3dSource_SetInteriorPanField;
	static criAtomEx3dSource_ChangeDefaultInteriorPanField_TYPE criAtomEx3dSource_ChangeDefaultInteriorPanField;
	static criAtomEx3dSource_SetDopplerFactor_TYPE criAtomEx3dSource_SetDopplerFactor;
	static criAtomEx3dSource_ChangeDefaultDopplerFactor_TYPE criAtomEx3dSource_ChangeDefaultDopplerFactor;
	static criAtomEx3dSource_SetVolume_TYPE criAtomEx3dSource_SetVolume;
	static criAtomEx3dSource_ChangeDefaultVolume_TYPE criAtomEx3dSource_ChangeDefaultVolume;
	static criAtomEx3dSource_SetMaxAngleAisacDelta_TYPE criAtomEx3dSource_SetMaxAngleAisacDelta;
	static criAtomEx3dSource_SetDistanceAisacControlId_TYPE criAtomEx3dSource_SetDistanceAisacControlId;
	static criAtomEx3dSource_SetListenerBasedAzimuthAngleAisacControlId_TYPE criAtomEx3dSource_SetListenerBasedAzimuthAngleAisacControlId;
	static criAtomEx3dSource_SetListenerBasedElevationAngleAisacControlId_TYPE criAtomEx3dSource_SetListenerBasedElevationAngleAisacControlId;
	static criAtomEx3dSource_SetSourceBasedAzimuthAngleAisacControlId_TYPE criAtomEx3dSource_SetSourceBasedAzimuthAngleAisacControlId;
	static criAtomEx3dSource_SetSourceBasedElevationAngleAisacControlId_TYPE criAtomEx3dSource_SetSourceBasedElevationAngleAisacControlId;
	static criAtomEx3dSource_Set3dRegionHn_TYPE criAtomEx3dSource_Set3dRegionHn;
	static criAtomEx3dSourceList_CalculateWorkSize_TYPE criAtomEx3dSourceList_CalculateWorkSize;
	static criAtomEx3dSourceList_Create_TYPE criAtomEx3dSourceList_Create;
	static criAtomEx3dSourceList_Destroy_TYPE criAtomEx3dSourceList_Destroy;
	static criAtomEx3dSourceList_Add_TYPE criAtomEx3dSourceList_Add;
	static criAtomEx3dSourceList_Remove_TYPE criAtomEx3dSourceList_Remove;
	static criAtomEx3dSourceList_RemoveAll_TYPE criAtomEx3dSourceList_RemoveAll;
	static criAtomEx3dListener_CalculateWorkSize_TYPE criAtomEx3dListener_CalculateWorkSize;
	static criAtomEx3dListener_Create_TYPE criAtomEx3dListener_Create;
	static criAtomEx3dListener_Destroy_TYPE criAtomEx3dListener_Destroy;
	static criAtomEx3dListener_Update_TYPE criAtomEx3dListener_Update;
	static criAtomEx3dListener_ResetParameters_TYPE criAtomEx3dListener_ResetParameters;
	static criAtomEx3dListener_SetPosition_TYPE criAtomEx3dListener_SetPosition;
	static criAtomEx3dListener_GetPosition_TYPE criAtomEx3dListener_GetPosition;
	static criAtomEx3dListener_SetVelocity_TYPE criAtomEx3dListener_SetVelocity;
	static criAtomEx3dListener_SetOrientation_TYPE criAtomEx3dListener_SetOrientation;
	static criAtomEx3dListener_SetDopplerMultiplier_TYPE criAtomEx3dListener_SetDopplerMultiplier;
	static criAtomEx3dListener_SetFocusPoint_TYPE criAtomEx3dListener_SetFocusPoint;
	static criAtomEx3dListener_SetDistanceFocusLevel_TYPE criAtomEx3dListener_SetDistanceFocusLevel;
	static criAtomEx3dListener_SetDirectionFocusLevel_TYPE criAtomEx3dListener_SetDirectionFocusLevel;
	static criAtomEx_EnableCalculationAisacControlFrom3dPosition_TYPE criAtomEx_EnableCalculationAisacControlFrom3dPosition;
	static criAtomEx_IsEnableCalculationAisacControlFrom3dPosition_TYPE criAtomEx_IsEnableCalculationAisacControlFrom3dPosition;
	static criAtomEx3dListener_Set3dRegionHn_TYPE criAtomEx3dListener_Set3dRegionHn;
	static criAtomEx3dRegion_CalculateWorkSize_TYPE criAtomEx3dRegion_CalculateWorkSize;
	static criAtomEx3dRegion_Create_TYPE criAtomEx3dRegion_Create;
	static criAtomEx3dRegion_Destroy_TYPE criAtomEx3dRegion_Destroy;
	static criAtomEx3dTransceiver_CalculateWorkSize_TYPE criAtomEx3dTransceiver_CalculateWorkSize;
	static criAtomEx3dTransceiver_Create_TYPE criAtomEx3dTransceiver_Create;
	static criAtomEx3dTransceiver_Destroy_TYPE criAtomEx3dTransceiver_Destroy;
	static criAtomEx3dTransceiver_Update_TYPE criAtomEx3dTransceiver_Update;
	static criAtomEx3dTransceiver_SetInputPosition_TYPE criAtomEx3dTransceiver_SetInputPosition;
	static criAtomEx3dTransceiver_SetOutputPosition_TYPE criAtomEx3dTransceiver_SetOutputPosition;
	static criAtomEx3dTransceiver_SetInputOrientation_TYPE criAtomEx3dTransceiver_SetInputOrientation;
	static criAtomEx3dTransceiver_SetOutputOrientation_TYPE criAtomEx3dTransceiver_SetOutputOrientation;
	static criAtomEx3dTransceiver_SetOutputConeParameter_TYPE criAtomEx3dTransceiver_SetOutputConeParameter;
	static criAtomEx3dTransceiver_SetOutputMinMaxAttenuationDistance_TYPE criAtomEx3dTransceiver_SetOutputMinMaxAttenuationDistance;
	static criAtomEx3dTransceiver_SetOutputInteriorPanField_TYPE criAtomEx3dTransceiver_SetOutputInteriorPanField;
	static criAtomEx3dTransceiver_SetInputCrossFadeField_TYPE criAtomEx3dTransceiver_SetInputCrossFadeField;
	static criAtomEx3dTransceiver_SetOutputVolume_TYPE criAtomEx3dTransceiver_SetOutputVolume;
	static criAtomEx3dTransceiver_AttachAisac_TYPE criAtomEx3dTransceiver_AttachAisac;
	static criAtomEx3dTransceiver_DetachAisac_TYPE criAtomEx3dTransceiver_DetachAisac;
	static criAtomEx3dTransceiver_SetMaxAngleAisacDelta_TYPE criAtomEx3dTransceiver_SetMaxAngleAisacDelta;
	static criAtomEx3dTransceiver_SetDistanceAisacControlId_TYPE criAtomEx3dTransceiver_SetDistanceAisacControlId;
	static criAtomEx3dTransceiver_SetListenerBasedAzimuthAngleAisacControlId_TYPE criAtomEx3dTransceiver_SetListenerBasedAzimuthAngleAisacControlId;
	static criAtomEx3dTransceiver_SetListenerBasedElevationAngleAisacControlId_TYPE criAtomEx3dTransceiver_SetListenerBasedElevationAngleAisacControlId;
	static criAtomEx3dTransceiver_SetTransceiverOutputBasedAzimuthAngleAisacControlId_TYPE criAtomEx3dTransceiver_SetTransceiverOutputBasedAzimuthAngleAisacControlId;
	static criAtomEx3dTransceiver_SetTransceiverOutputBasedElevationAngleAisacControlId_TYPE criAtomEx3dTransceiver_SetTransceiverOutputBasedElevationAngleAisacControlId;
	static criAtomEx3dTransceiver_Set3dRegionHn_TYPE criAtomEx3dTransceiver_Set3dRegionHn;
	static criAtomExVoicePool_DetachDsp_TYPE criAtomExVoicePool_DetachDsp;
	static criAtomExVoicePool_CalculateWorkSizeForDspPitchShifter_TYPE criAtomExVoicePool_CalculateWorkSizeForDspPitchShifter;
	static criAtomExVoicePool_AttachDspPitchShifter_TYPE criAtomExVoicePool_AttachDspPitchShifter;
	static criAtomExVoicePool_CalculateWorkSizeForDspTimeStretch_TYPE criAtomExVoicePool_CalculateWorkSizeForDspTimeStretch;
	static criAtomExVoicePool_AttachDspTimeStretch_TYPE criAtomExVoicePool_AttachDspTimeStretch;
	static criAtomExStreamingCache_IsCachedWaveformById_TYPE criAtomExStreamingCache_IsCachedWaveformById;
	static criAtomExStreamingCache_IsCachedWaveformByName_TYPE criAtomExStreamingCache_IsCachedWaveformByName;
	static criAtomExStreamingCache_LoadWaveformById_TYPE criAtomExStreamingCache_LoadWaveformById;
	static criAtomExStreamingCache_LoadWaveformByName_TYPE criAtomExStreamingCache_LoadWaveformByName;
	static criAtomExTween_CalculateWorkSize_TYPE criAtomExTween_CalculateWorkSize;
	static criAtomExTween_Create_TYPE criAtomExTween_Create;
	static criAtomExTween_Destroy_TYPE criAtomExTween_Destroy;
	static criAtomExTween_GetValue_TYPE criAtomExTween_GetValue;
	static criAtomExTween_MoveTo_TYPE criAtomExTween_MoveTo;
	static criAtomExTween_MoveFrom_TYPE criAtomExTween_MoveFrom;
	static criAtomExTween_Stop_TYPE criAtomExTween_Stop;
	static criAtomExTween_Reset_TYPE criAtomExTween_Reset;
	static criAtomEx_SetVoiceEventCallback_TYPE criAtomEx_SetVoiceEventCallback;
	static criAtomEx_EnumerateVoiceInfos_TYPE criAtomEx_EnumerateVoiceInfos;
	static criAtomEx_SetMonitoringVoiceStopCallback_TYPE criAtomEx_SetMonitoringVoiceStopCallback;
	static criAtomEx_SetMonitoringVoiceStopPlaybackId_TYPE criAtomEx_SetMonitoringVoiceStopPlaybackId;
	static criAtomExSoundObject_CalculateWorkSize_TYPE criAtomExSoundObject_CalculateWorkSize;
	static criAtomExSoundObject_Create_TYPE criAtomExSoundObject_Create;
	static criAtomExSoundObject_Destroy_TYPE criAtomExSoundObject_Destroy;
	static criAtomExSoundObject_AddPlayer_TYPE criAtomExSoundObject_AddPlayer;
	static criAtomExSoundObject_DeletePlayer_TYPE criAtomExSoundObject_DeletePlayer;
	static criAtomExSoundObject_DeleteAllPlayers_TYPE criAtomExSoundObject_DeleteAllPlayers;
	static criAtomExAcb_ReleaseAsync_TYPE criAtomExAcb_ReleaseAsync;
	static criAtomExPlayer_IsReadyToStartAsync_TYPE criAtomExPlayer_IsReadyToStartAsync;
	static criAtomExPlayer_UpdateAllAsync_TYPE criAtomExPlayer_UpdateAllAsync;
	static criAtomExPlayer_GetTimeReal_TYPE criAtomExPlayer_GetTimeReal;
	static criAtomExPlayback_GetTimeReal_TYPE criAtomExPlayback_GetTimeReal;
	static criAtomExPlayback_EnumerateAtomPlayers_TYPE criAtomExPlayback_EnumerateAtomPlayers;
	static criAtomEx3dListener_GetFocusPoint_TYPE criAtomEx3dListener_GetFocusPoint;
	static criAtomEx3dListener_GetDistanceFocusLevel_TYPE criAtomEx3dListener_GetDistanceFocusLevel;
	static criAtomEx3dListener_GetDirectionFocusLevel_TYPE criAtomEx3dListener_GetDirectionFocusLevel;
	static criAtomExAcb_GetCurrentAcb_TYPE criAtomExAcb_GetCurrentAcb;
	static criAtomExAcb_IsParameterPalletAssignedByName_TYPE criAtomExAcb_IsParameterPalletAssignedByName;
	static criAtomEx3dSource_SetAttenuationDistanceSetting_TYPE criAtomEx3dSource_SetAttenuationDistanceSetting;
	static criAtomEx3dSource_GetAttenuationDistanceSetting_TYPE criAtomEx3dSource_GetAttenuationDistanceSetting;
	static criAtomExPlayer_SetBusSendLevel_TYPE criAtomExPlayer_SetBusSendLevel;
	static criAtomExPlayer_SetBusSendLevelOffset_TYPE criAtomExPlayer_SetBusSendLevelOffset;
	static criAtomEx_GetNumUsedVirtualVoices_TYPE criAtomEx_GetNumUsedVirtualVoices;
	static criAtomEx_GetNumUsedSequences_TYPE criAtomEx_GetNumUsedSequences;
	static criAtomEx_GetNumUsedSequenceTracks_TYPE criAtomEx_GetNumUsedSequenceTracks;
	static criAtomEx_GetNumUsedSequenceTrackItems_TYPE criAtomEx_GetNumUsedSequenceTrackItems;
	static criAtomEx3dListener_SetDistanceFactor_TYPE criAtomEx3dListener_SetDistanceFactor;
	static criAtomEx_GetNumUsedAisacAutoModulations_TYPE criAtomEx_GetNumUsedAisacAutoModulations;
	static criAtomEx3dSource_SetConeOrientation_TYPE criAtomEx3dSource_SetConeOrientation;
	static criAtomEx_CalculateWorkSizeForRegisterAcfConfig_TYPE criAtomEx_CalculateWorkSizeForRegisterAcfConfig;
	static criAtomExPlayer_SetSequencePrepareTime_TYPE criAtomExPlayer_SetSequencePrepareTime;
#if CRIWARE_USE_ATOM_MONITOR
	static criAtomExMonitor_CalculateWorkSize_TYPE criAtomExMonitor_CalculateWorkSize;
	static criAtomExMonitor_Initialize_TYPE criAtomExMonitor_Initialize;
	static criAtomExMonitor_Finalize_TYPE criAtomExMonitor_Finalize;
	static criAtomExMonitor_GetServerIpString_TYPE criAtomExMonitor_GetServerIpString;
	static criAtomExMonitor_GetClientIpString_TYPE criAtomExMonitor_GetClientIpString;
	static criAtomExMonitor_IsConnected_TYPE criAtomExMonitor_IsConnected;
	static criAtomExMonitor_SetLogCallback_TYPE criAtomExMonitor_SetLogCallback;
	static criAtomExMonitor_SetLogCallbackWithLogMode_TYPE criAtomExMonitor_SetLogCallbackWithLogMode;
	static criAtomExMonitor_SetLogMode_TYPE criAtomExMonitor_SetLogMode;
	static criAtomExMonitor_OutputUserLog_TYPE criAtomExMonitor_OutputUserLog;
	static criAtomExMonitor_SetDataUpdateNotificationCallback_TYPE criAtomExMonitor_SetDataUpdateNotificationCallback;
#endif
#ifdef XPT_TGT_ANDROID
	static criAtom_SetThreadPriority_ANDROID_TYPE criAtom_SetThreadPriority_ANDROID;
	static criAtom_GetThreadPriority_ANDROID_TYPE criAtom_GetThreadPriority_ANDROID;
	static criAtom_SetJavaVM_ANDROID_TYPE criAtom_SetJavaVM_ANDROID;
	static criAtom_SetSoundStartBufferingTime_ANDROID_TYPE criAtom_SetSoundStartBufferingTime_ANDROID;
	static criAtom_SetSoundBufferingTime_ANDROID_TYPE criAtom_SetSoundBufferingTime_ANDROID;
	static criAtom_SetSoundBufferSize_ANDROID_TYPE criAtom_SetSoundBufferSize_ANDROID;
	static criAtom_ApplyHardwareProperties_ANDROID_TYPE criAtom_ApplyHardwareProperties_ANDROID;
	static criAtomEx_CalculateWorkSize_ANDROID_TYPE criAtomEx_CalculateWorkSize_ANDROID;
	static criAtomEx_Initialize_ANDROID_TYPE criAtomEx_Initialize_ANDROID;
	static criAtomEx_Finalize_ANDROID_TYPE criAtomEx_Finalize_ANDROID;
	static criAtomEx_StartSound_ANDROID_TYPE criAtomEx_StartSound_ANDROID;
	static criAtomEx_StopSound_ANDROID_TYPE criAtomEx_StopSound_ANDROID;
	static criAtomLatencyEstimator_Initialize_ANDROID_TYPE criAtomLatencyEstimator_Initialize_ANDROID;
	static criAtomLatencyEstimator_Finalize_ANDROID_TYPE criAtomLatencyEstimator_Finalize_ANDROID;
	static criAtomLatencyEstimator_GetCurrentInfo_ANDROID_TYPE criAtomLatencyEstimator_GetCurrentInfo_ANDROID;
	static criAtomLatencyEstimator_IsInitialized_ANDROID_TYPE criAtomLatencyEstimator_IsInitialized_ANDROID;
	static criFs_EnableAssetsAccess_ANDROID_TYPE criFs_EnableAssetsAccess_ANDROID;
	static criFs_DisableAssetsAccess_ANDROID_TYPE criFs_DisableAssetsAccess_ANDROID;
#endif
#if defined XPT_TGT_PC
	static criAtomEx_CalculateWorkSize_WASAPI_TYPE criAtomEx_CalculateWorkSize_WASAPI;
	static criAtomEx_Initialize_WASAPI_TYPE criAtomEx_Initialize_WASAPI;
	static criAtomEx_Finalize_WASAPI_TYPE criAtomEx_Finalize_WASAPI;
	static criAtom_SetAudioClientFormat_WASAPI_TYPE criAtom_SetAudioClientFormat_WASAPI;
	static criAtom_SetAudioClientShareMode_WASAPI_TYPE criAtom_SetAudioClientShareMode_WASAPI;
	static criAtom_SetDeviceId_WASAPI_TYPE criAtom_SetDeviceId_WASAPI;
	static criAtom_SetSpatialAudioEnabled_WASAPI_TYPE criAtom_SetSpatialAudioEnabled_WASAPI;
	static criAtom_EnumAudioEndpoints_WASAPI_TYPE criAtom_EnumAudioEndpoints_WASAPI;
	static criAtom_SetDeviceUpdateCallback_WASAPI_TYPE criAtom_SetDeviceUpdateCallback_WASAPI;
#endif
#if defined XPT_TGT_MACOSX
    static criAtomEx_CalculateWorkSize_MACOSX_TYPE criAtomEx_CalculateWorkSize_MACOSX;
    static criAtomEx_Initialize_MACOSX_TYPE criAtomEx_Initialize_MACOSX;
    static criAtomEx_Finalize_MACOSX_TYPE criAtomEx_Finalize_MACOSX;
#endif
};

#if CRIWARE_USE_SOUNDXR
class CRIWARECORE_API FCriWareSoundXRApi
{
public:
	static criSoundxR_GetInterface_TYPE criSoundxR_GetInterface;
};
#endif

#if defined(XPT_TGT_PC) || defined(XPT_TGT_GAMING_XBOX)
#include "Windows/HideWindowsPlatformAtomics.h"
#include "Windows/HideWindowsPlatformTypes.h"
#endif
