/****************************************************************************
 *
 * CRI Middleware SDK
 *
 * copyright (c) 2014 CRI Middleware Co., Ltd.
 *
 * Library  : CRI Middleware Library
 * Module   : CRI Common Header for iOS
 * File     : cri_le_xpt_ios.h
 * Date     : 2014-07-03
 * Version  : 1.00LE
 *
 ****************************************************************************/
#ifndef CRI_INCL_CRI_LE_XPT_IOS_H
#define CRI_INCL_CRI_LE_XPT_IOS_H

#include <stddef.h>
#include <stdint.h>

#include <TargetConditionals.h>
#include <Availability.h>

#define XPT_TGT_IOS
#define XPT_TGT_IPHONE
#define XPT_CCS_LEND

#if TARGET_IPHONE_SIMULATOR
	#if TARGET_CPU_X86
    	#define CRI_TARGET_STR "iOS_SIM_X86"
	#elif TARGET_CPU_X86_64
    	#define CRI_TARGET_STR "iOS_SIM_X86_64"
	#else
		#error unsupported architecture
	#endif
#elif defined(__ARM_ARCH_6__) || defined(__ARM_ARCH_6J__) || defined(__ARM_ARCH_6K__) || defined(__ARM_ARCH_6Z__)
    #define CRI_TARGET_STR "iOS_ARMv6"
#elif defined(__ARM_ARCH_7__) || defined(__ARM_ARCH_7A__)
    #define CRI_TARGET_STR "iOS_ARMv7"
#elif defined(__ARM_ARCH_7S__)
    #define CRI_TARGET_STR "iOS_ARMv7s"
#elif defined(__ARM64_ARCH_8__)
    #define CRI_TARGET_STR "iOS_ARMv8_A64"
#else
	#error unsupported architecture
#endif

#define XPT_SUPPORT_MULTICHANNEL

/*****************************************************************************
 * {f[^^錾
 *****************************************************************************/

#ifndef _TYPEDEF_CriUint8
#define _TYPEDEF_CriUint8
typedef uint8_t					CriUint8;		/* ȂPoCg */
#endif

#ifndef _TYPEDEF_CriSint8
#define _TYPEDEF_CriSint8
typedef int8_t					CriSint8;		/* PoCg */
#endif

#ifndef _TYPEDEF_CriUint16
#define _TYPEDEF_CriUint16
typedef uint16_t				CriUint16;		/* ȂQoCg */
#endif

#ifndef _TYPEDEF_CriSint16
#define _TYPEDEF_CriSint16
typedef int16_t					CriSint16;		/* QoCg */
#endif

#ifndef _TYPEDEF_CriUint32
#define _TYPEDEF_CriUint32
typedef uint32_t				CriUint32;		/* ȂSoCg */
#endif

#ifndef _TYPEDEF_CriSint32
#define _TYPEDEF_CriSint32
typedef int32_t					CriSint32;		/* SoCg */
#endif

#ifndef _TYPEDEF_CriUint64
#define _TYPEDEF_CriUint64
typedef uint64_t				CriUint64;		/* ȂWoCg */
#endif

#ifndef _TYPEDEF_CriSint64
#define _TYPEDEF_CriSint64
typedef int64_t					CriSint64;		/* WoCg */
#endif

#ifndef _TYPEDEF_CriUint128
#define _TYPEDEF_CriUint128
typedef struct {								/* Ȃ16oCg */
	CriUint64			h;						/* 64rbg */
	CriUint64			l;						/* 64rbg */
} CriUint128;
#endif

#ifndef _TYPEDEF_CriSint128
#define _TYPEDEF_CriSint128
typedef struct {								/* 16oCg */
	CriSint64	h;								/* 64rbg */
	CriUint64	l;								/* 64rbg */
} CriSint128;
#endif

#ifndef _TYPEDEF_CriFloat16
#define _TYPEDEF_CriFloat16
typedef CriSint16				CriFloat16;		/* QoCg */
#endif

#ifndef _TYPEDEF_CriFloat32
#define _TYPEDEF_CriFloat32
typedef float					CriFloat32;		/* SoCg */
#endif

#ifndef _TYPEDEF_CriFloat64
#define _TYPEDEF_CriFloat64
typedef double					CriFloat64;		/* WoCg */
#endif

#ifndef _TYPEDEF_CriFixed32
#define _TYPEDEF_CriFixed32
typedef CriSint32				CriFixed32;		/* Œ菬_32rbg */
#endif

#ifndef _TYPEDEF_CriBool
#define _TYPEDEF_CriBool
typedef CriSint32				CriBool;		/* _^i_萔lɂƂj */
#endif

#ifndef _TYPEDEF_CriChar8
#define _TYPEDEF_CriChar8
typedef char					CriChar8;		/* ^ */
#endif

/*****************************************************************************
 * |C^i[\Ȑ^
 *****************************************************************************/
#ifndef _TYPEDEF_CriSintPtr
#define _TYPEDEF_CriSintPtr
typedef intptr_t				CriSintPtr;
#endif

#ifndef _TYPEDEF_CriUintPtr
#define _TYPEDEF_CriUintPtr
typedef uintptr_t				CriUintPtr;
#endif

/*****************************************************************************
 * 萔}N
 * Macros of constant value
 *****************************************************************************/

/* NULL |C^^ */
#if !defined(CRI_NULL)
#ifdef __cplusplus
#define CRI_NULL	(0)
#else
#define CRI_NULL	((void *)0)
#endif
#endif

/* _萔PiUA^j */
#if !defined(CRI_FALSE)
#define CRI_FALSE	(0)
#endif
#if !defined(CRI_TRUE)
#define CRI_TRUE	(1)
#endif

/* _萔QiXCb`j */
#if !defined(CRI_OFF)
#define CRI_OFF		(0)
#endif
#if !defined(CRI_ON)
#define CRI_ON		(1)
#endif

/* ʔ̒萔iAsj */
#if !defined(CRI_OK)
#define CRI_OK		(0)			/*  */
#endif
#if !defined(CRI_NG)
#define CRI_NG		(-1)		/* s */
#endif

/*****************************************************************************
 * |C^܂64rbgAhXi[ł鐮^
 * l: |C^32bitROMAhX64bit̊ŁA҂𓧉ߓIɈB
 * The integer type which can hold an pointer or an address up to 64 bits.
 * NOTE: In the environment of pointer 32bit and ROM address space 64bit, 
 *       this type can treat both transparently. 
 *****************************************************************************/

#if !defined(_TYPEDEF_CriUint64Adr)
#define _TYPEDEF_CriUint64Adr
typedef CriUint64				CriUint64Adr;		/* |C^܂64rbgAhXi[ł鐮^ */
#endif

#if !defined(CRI_PTR_TO_UINT64ADR)
#define CRI_PTR_TO_UINT64ADR(ptr)		((CriUint64Adr)(ptr))	/* Convert pointer to CriUint64Adr */
#endif

#if !defined(CRI_UINT64ADR_TO_PTR)
#define CRI_UINT64ADR_TO_PTR(uint64adr)	((void *)(CriUintPtr)(uint64adr))	/* Convert CriUint64Adr to pointer */
#endif

/*****************************************************************************
 * ĂяoK
 *****************************************************************************/

#ifndef CRIAPI
#define CRIAPI
#endif	/* endif CRIAPI */

#endif  /* CRI_INCL_CRI_LE_XPT_IOS_H */
/* End Of File */
