/****************************************************************************
 *
 * CRI Middleware SDK
 *
 * Copyright (c) 2013-2018 CRI Middleware Co., Ltd.
 *
 * Library  : CRI Atom
 * Module   : Library User's Header for WASAPI
 * File     : cri_atom_wasapi.h
 *
 ****************************************************************************/
/*!
 *	\file		cri_atom_wasapi.h
 */

/* d`h~					*/
/* Prevention of redefinition	*/
#ifndef CRI_INCL_CRI_ATOM_WASAPI_H
#define CRI_INCL_CRI_ATOM_WASAPI_H

/***************************************************************************
 *      CN[ht@C
 *      Include files
 ***************************************************************************/
#include <Windows.h>
#include <sdkddkver.h>
#include <Audioclient.h>
#include <AudioSessionTypes.h>
#include <mmdeviceapi.h>
#include <cri_le_xpt.h>
#include <cri_le_atom.h>
#include <cri_le_atom_ex.h>
#include <cri_le_atom_asr.h>

/***************************************************************************
 *      萔}N
 *      Macro Constants
 ***************************************************************************/

/***************************************************************************
 *      }N
 *      Macro Functions
 ***************************************************************************/
/*==========================================================================
 *      CRI Atom API
 *=========================================================================*/
/*JP
 * \brief CupRtBO\̂ɃftHglZbg
 * \ingroup ATOMLIB_WASAPI
 * \param[out]	p_config	pRtBO\̂ւ̃|C^
 * \par :
 * ::criAtom_Initialize_WASAPI ֐ɐݒ肷RtBO\
 * i ::CriAtomConfig_WASAPI jɁAftHg̒lZbg܂B<br>
 * \attention
 * {}N͉ʃCAPIłB<br>
 * AtomExC̋@\𗘗pۂɂ́A{}N̑ 
 * ::criAtomEx_SetDefaultConfig_WASAPI }NpB
 * \sa CriAtomConfig_WASAPI
 */
#define criAtom_SetDefaultConfig_WASAPI(p_config)			\
{															\
	criAtom_SetDefaultConfig(&(p_config)->atom);			\
	criAtomAsr_SetDefaultConfig(&(p_config)->asr);			\
	criAtomHcaMx_SetDefaultConfig(&(p_config)->hca_mx);		\
}

#if defined(XPT_TGT_PC)
/*JP
 * \brief nveBNXfoCX^Cv
 * \ingroup ATOMLIB_WASAPI
 * WindowsŎgpnveBNXfoCX̃^CvłB<br>
 * ::criAtom_SetHapticDeviceId_WASAPI ֐̈Ɏw肵܂B<br>
 * CRIATOM_HAPTIC_DEVICE_TYPE_DEFAULT : XeIo͂UɎgpfoCX^CvłBAtom̓foCXɂ̂܂܂̐Mo͂܂B
 * CRIATOM_HAPTIC_DEVICE_TYPE_DLS : Ls^RsUɎgpfoCX^CvłBAtom͓ŐML/RfoCXLs^Rsɏo͂܂B
 * \sa criAtom_SetHapticDeviceId_WASAPI
 */
typedef enum CriAtomHapticDeviceTypeTag_WASAPI {
	CRIATOM_HAPTIC_DEVICE_TYPE_DEFAULT = 0,
	CRIATOM_HAPTIC_DEVICE_TYPE_DLS,
	CRIATOM_HAPTIC_DEVICE_TYPE_ENUM_SIZE_IS_4BYTES = 0x7FFFFFFF
}CriAtomHapticDeviceType_WASAPI;
#endif
/*==========================================================================
 *      CRI AtomEx API
 *=========================================================================*/
/*JP
 * \brief CupRtBO\̂ɃftHglZbg
 * \ingroup ATOMLIB_WASAPI
 * \param[out]	p_config	pRtBO\̂ւ̃|C^
 * \par :
 * ::criAtomEx_Initialize_WASAPI ֐ɐݒ肷RtBO\
 * i ::CriAtomExConfig_WASAPI jɁAftHg̒lZbg܂B<br>
 * \sa CriAtomExConfig_WASAPI
 */
#define criAtomEx_SetDefaultConfig_WASAPI(p_config)			\
{															\
	criAtomEx_SetDefaultConfig(&(p_config)->atom_ex);		\
	(p_config)->atom_ex.thread_model = CRIATOMEX_THREAD_MODEL_MULTI_WITH_SONICSYNC; \
	criAtomExAsr_SetDefaultConfig(&(p_config)->asr);		\
	criAtomExHcaMx_SetDefaultConfig(&(p_config)->hca_mx);	\
}

/***************************************************************************
 *      f[^^錾
 *      Data Type Declarations
 ***************************************************************************/
/*==========================================================================
 *      CRI Atom API
 *=========================================================================*/
/*JP
 * \brief AtomCupRtBO\
 * \ingroup ATOMLIB_WASAPI
 * CRI AtomCu̓dlw肷邽߂̍\̂łB<br>
 * ::criAtom_Initialize_WASAPI ֐̈Ɏw肵܂B<br>
 * \attention
 * {\͉̂ʃCAPIłB<br>
 * AtomExC̋@\𗘗pۂɂ́A{\̂̑ 
 * ::CriAtomExConfig_WASAPI \̂pB
 * \sa criAtom_Initialize_WASAPI, criAtom_SetDefaultConfig_WASAPI
 */
typedef struct CriAtomConfigTag_WASAPI {
	CriAtomConfig			atom;		/*JP< AtompRtBO\		*/
	CriAtomAsrConfig		asr;		/*JP< ASRpRtBO			*/
	CriAtomHcaMxConfig		hca_mx;		/*JP< HCA-MXpRtBO\	*/
} CriAtomConfig_WASAPI;

/*JP
 * \brief I[fBIGh|Cg񋓃R[obN
 * \ingroup ATOMLIB_WASAPI
 * \param[in]	object				[UwIuWFNg
 * \param[in]	device				IMMDeviceCX^X
 * \par :
 * I[fBIGh|Cg̒ʒmɎgpAR[obN֐̌^łB<br>
 * ::criAtom_EnumAudioEndpoints_WASAPI ֐ɖ{֐^̃R[obN֐o^邱ƂŁA
 * IMMDeviceCX^XR[obNoRŎ󂯎邱Ƃ\łB<br>
 * \attention
 * IMMDeviceCX^XR[obN֐ŔjĂ͂܂B<br>
 * \sa criAtom_EnumAudioEndpoints_WASAPI
 */
typedef void (CRIAPI *CriAtomAudioEndpointCbFunc_WASAPI)(void *object, IMMDevice *device);

/*JP
 * \brief foCXXVʒmR[obN
 * \ingroup ATOMLIB_WASAPI
 * \param[in]	object				[UwIuWFNg
 * \par :
 * foCX̍XVʒmɎgpAR[obN֐̌^łB<br>
 * ::criAtom_SetDeviceUpdateCallback_WASAPI ֐ɖ{֐^̃R[obN֐o^邱ƂŁA
 * foCXXVꂽۂɃR[obNoRŒʒm󂯎邱Ƃ\łB<br>
 * \sa criAtom_SetDeviceUpdateCallback_WASAPI
 */
typedef void (CRIAPI *CriAtomDeviceUpdateCbFunc_WASAPI)(void *object);

/*==========================================================================
 *      CRI AtomEx API
 *=========================================================================*/
/*JP
 * \brief AtomCupRtBO\
 * \ingroup ATOMLIB_WASAPI
 * CRI AtomCu̓dlw肷邽߂̍\̂łB<br>
 * ::criAtomEx_Initialize_WASAPI ֐̈Ɏw肵܂B<br>
 * \sa criAtomEx_Initialize_WASAPI, criAtomEx_SetDefaultConfig_WASAPI
 */
typedef struct CriAtomExConfigTag_WASAPI {
	CriAtomExConfig			atom_ex;	/*JP< AtomExpRtBO\	*/
	CriAtomExAsrConfig		asr;		/*JP< ASRpRtBO			*/
	CriAtomExHcaMxConfig	hca_mx;		/*JP< HCA-MXpRtBO\	*/
} CriAtomExConfig_WASAPI;

/***************************************************************************
 *      ϐ錾
 *      Prototype Variables
 ***************************************************************************/

/***************************************************************************
 *      ֐錾
 *      Prototype Functions
 ***************************************************************************/
#ifdef __cplusplus
extern "C" {
#endif

/*==========================================================================
 *      CRI Atom API
 *=========================================================================*/
/*JP
 * \brief Cup[N̈TCY̌vZ
 * \ingroup ATOMLIB_WASAPI
 * \param[in]	config		pRtBO\
 * \return		CriSint32	[N̈TCY
 * \par :
 * Cugp邽߂ɕKvȁA[N̈̃TCY擾܂B<br>
 * \par l:
 * CuKvƂ郏[N̈̃TCÝACupRtBO
 * \́i ::CriAtomConfig_WASAPI j̓eɂĕω܂B<br>
 * <br>
 *  config ̏́A֐ł̂ݎQƂ܂B<br>
 * ֐𔲂͎QƂ܂̂ŁA֐s config ̗̈Ă
 * 肠܂B
 * \attention
 * {֐͉ʃCAPIłB<br>
 * AtomExC̋@\𗘗pۂɂ́A{֐̑ 
 * ::criAtomEx_CalculateWorkSize_WASAPI ֐pB
 * \sa CriAtomConfig_WASAPI, criAtom_Initialize_WASAPI
 */
CriSint32 CRIAPI criAtom_CalculateWorkSize_WASAPI(const CriAtomConfig_WASAPI *config);

/*JP
 * \brief Cȕ
 * \ingroup ATOMLIB_WASAPI
 * \param[in]	config		pRtBO\
 * \param[in]	work		[N̈
 * \param[in]	work_size	[N̈TCY
 * \par :
 * Cu܂B<br>
 * Cű@\𗘗pɂ́AK̊֐sKv܂B<br>
 * iCű@\́A{֐sA ::criAtom_Finalize_WASAPI ֐s܂ł̊ԁA
 * p\łBj<br>
 * <br>
 * Cuۂɂ́ACuŗp邽߂̃̈i[N̈j
 * mۂKv܂B<br>
 * CuKvƂ郏[N̈̃TCÝApRtBO\̂̓eɉ
 * ω܂B<br>
 * [N̈TCY̌vZɂ́A ::criAtom_CalculateWorkSize_WASAPI 
 * ֐gpĂB<br>
 * \par l:
 * ::criAtom_SetUserAllocator }NgpăAP[^[o^ς݂̏ꍇA
 * {֐Ƀ[N̈w肷Kv͂܂B<br>
 * i work  NULL A work_size  0 w肷邱ƂŁAo^ς݂̃AP[^[
 * Kvȃ[N̈TCỸIɊmۂ܂Bj
 * <br>
 *  config ̏́A֐ł̂ݎQƂ܂B<br>
 * ֐𔲂͎QƂ܂̂ŁA֐s config ̗̈Ă
 * 肠܂B
 * \attention
 * {֐͓IɈȉ̊֐s܂B<br>
 * 	- ::criAtom_Initialize
 * 	- ::criAtomAsr_Initialize
 * 	- ::criAtomHcaMx_Initialize
 * {֐sꍇAL֐sȂłB<br>
 * <br>
 * {֐sAK΂ɂȂ ::criAtom_Finalize_WASAPI ֐sĂB<br>
 * ܂A ::criAtom_Finalize_WASAPI ֐s܂ł́A{֐ēxsȂłB<br>
 * <br>
 * {֐͉ʃCAPIłB<br>
 * AtomExC̋@\𗘗pۂɂ́A{֐̑ 
 * ::criAtomEx_Initialize_WASAPI ֐pB
 * \sa CriAtomConfig_WASAPI, criAtom_Finalize_WASAPI,
 * criAtom_SetUserAllocator, criAtom_CalculateWorkSize_WASAPI
 */
void CRIAPI criAtom_Initialize_WASAPI(
	const CriAtomConfig_WASAPI *config, void *work, CriSint32 work_size);

/*JP
 * \brief CȕI
 * \ingroup ATOMLIB_WASAPI
 * \par :
 * CuI܂B<br>
 * \attention
 * {֐͓IɈȉ̊֐s܂B<br>
 * 	- ::criAtom_Finalize
 * 	- ::criAtomAsr_Finalize
 * 	- ::criAtomHcaMx_Finalize
 * {֐sꍇAL֐sȂłB<br>
 * <br>
 * ::criAtom_Initialize_WASAPI ֐sOɖ{֐s邱Ƃ͂ł܂B<br>
 * <br>
 * {֐͉ʃCAPIłB<br>
 * AtomExC̋@\𗘗pۂɂ́A{֐̑ 
 * ::criAtomEx_Finalize_WASAPI ֐pB
 * \sa criAtom_Initialize_WASAPI
 */
void CRIAPI criAtom_Finalize_WASAPI(void);

/*JP
 * \brief ftHgfoCXʂ̎w
 * \ingroup ATOMLIB_WASAPI
 * \param[out]	role		ftHgfoCXƂĎgpfoCX̎
 * \par :
 * ftHgfoCX̎ʂw肵܂B
 * roleeConsolew肵ꍇAAtomCu͊̃foCXgpĉo͂܂B<br>
 * roleeCommunicationsw肵ꍇAAtomCu͊̒ʐMfoCXgpĉo͂܂B
 * \attention
 * {֐̓CuOɎgpKv܂B<br>
 */
#if !defined(XPT_TGT_WINRT)
void CRIAPI criAtom_SetDefaultDeviceRole_WASAPI(ERole role);
#endif

/*JP
 * \brief ~LTtH[}bg̎擾
 * \ingroup ATOMLIB_WASAPI
 * \param[out]	format		~LT̃tH[}bg
 * \return		CriBool		~LT̃tH[}bg擾łǂi CRI_TRUE = ACRI_FALSE = sj
 * \par :
 * L[hɎgp~LT̃tH[}bg擾܂B<br>
 * \par l:
 * {֐ IAudioClient::GetMixFormat ֐̃bp[łB<br>
 * {֐sƁA֐ AudioClient 쐬AGetMixFormat ֐s܂B<br>
 * \attention
 * {֐̓CuOɂ̂ݎgp\łB<br>
 * <br>
 * L[hƔr[hƂł́AgpłtH[}bgقȂ܂B<br>
 * {֐Ŏ擾 WAVEFORMATEXTENSIBLE \̂ IEEE float `PCMf[^tH[}bgԂ܂A
 * ̃tH[}bg͔r[hł͂قƂǂ̏ꍇgpł܂B<br>
 */
CriBool CRIAPI criAtom_GetAudioClientMixFormat_WASAPI(WAVEFORMATEXTENSIBLE *format);

/*JP
 * \brief w肵tH[}bgp\ǂ`FbN
 * \ingroup ATOMLIB_WASAPI
 * \param[in]	format		gptH[}bg
 * \return		CriBool		w肳ꂽtH[}bgp\ǂi CRI_TRUE = p\ACRI_FALSE = ps\j
 * \par :
 * Ŏw肵tH[}bgAr[hŗp\ǂ`FbN܂B<br>
 * \par l:
 * {֐ IAudioClient::IsFormatSupported ֐̃bp[łB<br>
 * {֐sƁA֐ AudioClient 쐬AIsFormatSupported ֐s܂B<br>
 * \attention
 * {֐̓CuOɂ̂ݎgp\łB<br>
 * <br>
 * ꕔ̃foCX^p[^[ɂāA{֐ɂ炸A
 * WASAPI ̏ɎsP[XmFĂ܂B<br>
 * {֐ CRI_TRUE Ԃɂ炸ACȕɎsꍇɂ́A
 * w肷tH[}bgύX邩A܂͋L[hgpB<br>
 */
CriBool CRIAPI criAtom_GetAudioClientIsFormatSupported_WASAPI(const WAVEFORMATEX *format);

/*JP
 * \brief L̎w
 * \ingroup ATOMLIB_WASAPI
 * \param[in]	mode	gp郂[h
 * \par :
 * WASAPIL[hŎgp邩Ar[hŎgp邩w肵܂B<br>
 * <br>
 * {֐sȂꍇA AUDCLNT_SHAREMODE_SHARED w肵ĎsꍇA
 * AtomCu WASAPI L[hŏ܂B<br>
 * AUDCLNT_SHAREMODE_EXCLUSIVE w肵Ė{֐sꍇA
 * AtomCu WASAPI r[hŏ܂B<br>
 * \attention
 * {֐̓CȕɎsĂKv܂B<br>
 * <br>
 * r[hgpꍇA{֐ł̃[hwɉA
 * ::criAtom_SetAudioClientFormat_WASAPI ֐ɂtH[}bg̎w肪KvłB<br>
 * \sa criAtom_SetAudioClientFormat_WASAPI
 */
void CRIAPI criAtom_SetAudioClientShareMode_WASAPI(AUDCLNT_SHAREMODE mode);

/*JP
 * \brief L̎擾
 * \ingroup ATOMLIB_WASAPI
 * \return	AUDCLNT_SHAREMODE	L
 * \par :
 * ݎw肳Ă鋤L擾܂B
 * \sa criAtom_SetAudioClientShareMode_WASAPI
 */
AUDCLNT_SHAREMODE CRIAPI criAtom_GetAudioClientShareMode_WASAPI(void);

/*JP
 * \brief o̓tH[}bg̎w
 * \ingroup ATOMLIB_WASAPI
 * \par :
 * \param[in]	format		gptH[}bg
 * \par :
 * r[hŎgptH[}bgw肵܂B<br>
 * \par l:
 * {֐Ɏw肵tH[}bgA IAudioClient::Initialize ֐ɓn܂B<br>
 * \attention
 * {֐̓CȕɎsĂKv܂B<br>
 * <br>
 * r[hgpꍇA{֐ł̃[hwɉA
 * ::criAtom_SetAudioClientShareMode_WASAPI ֐ɂ郂[hw肪KvłB<br>
 * \sa criAtom_SetAudioClientShareMode_WASAPI
 */
void CRIAPI criAtom_SetAudioClientFormat_WASAPI(const WAVEFORMATEX *format);

/*JP
 * \brief obt@OԂ̎w
 * \ingroup ATOMLIB_WASAPI
 * \param[in]	ref_time	obt@O
 * \par :
 * WASAPI Ɏw肷obt@OԂw肵܂B<br>
 * AtomCúA{֐Ŏw肳ꂽԕ̃f[^ێ\ȃTCỸTEhobt@[mۂ܂B<br>
 * \par l:
 * {֐Ɏw肵l IAudioClient::Initialize ֐ɓn܂B<br>
 * <br>
 * ref_time0w肵ꍇA{֐gpȂꍇA
 * AtomCu͏Ɏw肳T[o[g̒lA
 * K؂ȃobt@OԂvZ܂B<br>
 * <br>
 * PCł̓n[hEFA\ɂ΂邽߁A
 * [Xg\̃n[hEFAɍ킹ăftHg̃obt@Oʂ߂ɐݒ肳Ă܂B<br>
 * iftHgԂł4Ṽobt@[Ă܂Bj
 * \attention
 * {֐̓CȕɎsĂKv܂B<br>
 * <br>
 * obt@OԂƁAr؂ꓙ̖肪܂B<br>
 * <br>
 * PCł̓n[hEFAɈˑĕKvȃobt@OʂقȂ邽߁A
 * {֐gpꍇAeXgł܂삵ĂĂA
 * [ŮɂĂ͉r؂ꂪ\܂B<br>
 * ̂߁Aobt@OʂύXꍇɂ́A
 * [UݒlύXłdg݁iIvVʓj񋟂邱ƂB
 */
void CRIAPI criAtom_SetAudioClientBufferDuration_WASAPI(REFERENCE_TIME ref_time);

/*JP
 * \brief AudioClient̎擾
 * \ingroup ATOMLIB_WASAPI
 * \return IAudioClient	AudioClient
 * \par :
 * AtomCuō쐬ꂽAudioClient擾܂B
 * \par l:
 * TEhfoCXڂĂȂPCŖ{֐sꍇA
 * {֐NULLԂ܂B
 * \par :
 * {֐sOɁACuKv܂B
 */
IAudioClient * CRIAPI criAtom_GetAudioClient_WASAPI(void);

/*JP
 * \brief foCXꂽǂ̃`FbN
 * \ingroup ATOMLIB_WASAPI
 * \return	CriBool	foCXꂽǂiCRI_TRUE = ꂽACRI_FALSE = ɓ쒆j
 * \par :
 * TEhfoCXꂽǂԂ܂B
 * \par l:
 * {֐CRI_TRUEԂ̂́AAvP[VsɃTEhfoCX𖳌ꍇ݂̂łB<br>
 * XTEhfoCXڂĂȂPCŖ{֐sꍇA{֐CRI_FALSEԂ܂B<br>
 * iTEhfoCX̗L͕ʓr ::criAtom_GetAudioClient_WASAPI ֐Ń`FbNKv܂Bj
 * \sa criAtom_GetAudioClient_WASAPI
 */
CriBool CRIAPI criAtom_IsDeviceInvalidated_WASAPI(void);

/*JP
 * \brief TEhfoCX̎w
 * \ingroup ATOMLIB_WASAPI
 * \param[in]	type		TEh_^Cv
 * \param[in]	device_id	foCXID
 * \par :
 * TEh_^CvƃTEhfoCX̕RÂs܂B<br>
 * <br>
 * {֐ŃTEh_ɑ΂ăfoCXIDݒ肷ƁA
 * YTEh_w肵ďo͂́A
 * SĎw肵IDɍvTEhfoCXo͂܂B
 * <br>
 * type ɂ́Aȉ̒lw\łB<br>
 * 	- CRIATOM_SOUND_RENDERER_HW1iCRIATOM_SOUND_RENDERER_NATIVEƓlj
 * 	- CRIATOM_SOUND_RENDERER_HW2
 * 	- CRIATOM_SOUND_RENDERER_HW3
 * 	- CRIATOM_SOUND_RENDERER_HW4
 * 2idevice_idjNULL܂͒0̕w肵ꍇA
 * YTEh_ƃfoCXID̕RÂ܂B<br>
 * ĩfoCX特o͂悤A삪ύX܂Bj
 * \par l:
 * TEhfoCXID IMMDevice::GetId Ŏ擾Kv܂B<br>
 * w肳ꂽIDɈvTEhfoCXȂꍇA
 * YfoCXw肵čĐꂽ́ÃfoCXo͂܂B<br>
 */
void CRIAPI criAtom_SetDeviceId_WASAPI(CriAtomSoundRendererType type, LPCWSTR device_id);

/*JP
 * \brief TEhfoCXID擾
 * \ingroup ATOMLIB_WASAPI
 * \param[in]	type				TEh_^Cv
 * \param[out]	device_id			foCXIDi[̈
 * \param[in]	count				foCXIDi[̈̃TCYij
 * \param[out]	is_default_device	ftHgfoCXǂ
 * \return		CriBool				foCXID擾łǂ
 * \par :
 * TEh_^CvɕRÂꂽTEhfoCXID擾܂B<br>
 * <br>
 * type ɂ́Aȉ̒lw\łB<br>
 * 	- CRIATOM_SOUND_RENDERER_HW1iCRIATOM_SOUND_RENDERER_NATIVEƓlj
 * 	- CRIATOM_SOUND_RENDERER_HW2
 * 	- CRIATOM_SOUND_RENDERER_HW3
 * 	- CRIATOM_SOUND_RENDERER_HW4
 * <br>
 * 2idevice_idjɂ̓foCXID󂯎邽߂̃̈w肵܂B
 * ̗͖̈{֐ĂяoAvP[VŊmۂKv܂B<br>
 * 3icountjɂ́A2Ŏw肵̈Ɋi[\ȍő啶w肵܂B
 * <br>
 * w肵TEh_ɑΉfoCXftHgfoCX̏ꍇA
 * 4iis_default_devicejɂ CRI_TRUE Zbg܂B<br>
 * w肵TEh_ɑΉfoCX ::criAtom_SetDeviceId_WASAPI ֐
 * w肳ꂽfoCX̏ꍇA4iis_default_devicejɂ CRI_FALSE Zbg܂B<br>
 * <br>
 * TEhfoCXID擾łꍇA{֐ CRI_TRUE Ԃ܂B<br>
 * {֐ CRI_FALSE ԂꍇAȉ̂ꂩɊYĂ܂B<br>
 * - TEhfoCX݂Ȃ
 * - foCXIDi[邽߂̗̈悪sĂ
 * - vbgtH[SDKG[Ԃ
 * - sȈw肳ꂽ
 * TEhfoCX݂ȂꍇȊO͍킹ăG[R[obNʒm܂B
 * \attention
 * 3Ŏw肷TCY̓oCgł͂ȂłB<br>
 * foCXID͒ʏ탏Chiwchar_t^jł邽߁A
 * 2Ŏw肷郁̈́A sizeof(wchar_t) |TCYKvłB
 * <br>
 * ftHgfoCXgpĂꍇi4Ŏ擾l CRI_TRUE ̏ꍇjɁA
 * {֐Ŏ擾foCXID ::criAtom_SetDeviceId_WASAPI ֐Ɏw肷
 * iftHgfoCX擾foCXIDŏ㏑jƁA
 * ftHgfoCXwǏ]Ȃ`ɋύXĂ܂܂B<br>
 * ̓Iɂ́AftHgfoCXgp̓[U[Windowsł̎wɉ
 * TEhfoCXIɐ؂ւ̂ɑ΂A
 * foCXID㏑̓[U[WindowsŊ̃foCXύXƂĂA
 * foCXIɂ͕ύXȂƂȂ܂B
 * {֐gpۂɂ́A[U[ɂ̃foCX̕ύX삪Ȃ悤A
 * foCXIDłȂftHgfoCXǂ킹ĊmFĂB
 * \sa criAtom_SetDeviceId_WASAPI
 */
CriBool CRIAPI criAtom_GetDeviceId_WASAPI(CriAtomSoundRendererType type,
	LPWSTR device_id, CriSint32 count, CriBool *is_default_device);

/*JP
 * \brief I[fBIGh|Cg̗
 * \ingroup ATOMLIB_WASAPI
 * \param[in]	callback	I[fBIGh|CgR[obN֐
 * \param[in]	object		[UwIuWFNg
 * \return		CriSint32	񋓂ꂽACBnh̐
 * \par :
 * I[fBIGh|Cg񋓂܂B<br>
 * <br>
 * {֐sƁA 1 i callback j
 * ŃZbgꂽR[obN֐I[fBIGh|CgĂяo܂B<br>
 * R[obN֐ɂ́AIMMDeviceCX^XƂēn܂B<br>
 * \par l:
 *  2 i object jɃZbgĺAR[obN֐̈Ƃēn܂B<br>
 * R[obN֐̂̑̈ɂẮA
 * ʓr ::CriAtomAudioEndpointCbFunc_WASAPI ̐QƂB<br>
 * <br>
 * ߂l͗񋓂ꂽI[fBIGh|Cg̐io^R[obN֐Ăяoꂽ񐔁jłB<br>
 * I[fBIGh|Cg݂ȂꍇA{֐ 0 Ԃ܂B<br>
 * G[ۂɂ -1 Ԃ܂B<br>
 * \attention
 * IMMDeviceCX^XR[obN֐ŔjĂ͂܂B<br>
 * \sa CriAtomAudioEndpointCbFunc_WASAPI
 */
CriSint32 CRIAPI criAtom_EnumAudioEndpoints_WASAPI(CriAtomAudioEndpointCbFunc_WASAPI callback, void *object);

/*JP
 * \brief foCXXVʒm̓o^
 * \ingroup ATOMLIB_WASAPI
 * \param[in]	callback	foCXXVʒmR[obN֐
 * \param[in]	object		[UwIuWFNg
 * \par :
 * foCX̍XVʒm󂯎邽߂̃R[obNݒ肵܂B<br>
 * <br>
 * {֐sƁAfoCXXVꂽہA 1 i callback j
 * ŃZbgꂽR[obN֐Ăяo܂B<br>
 * \par l:
 *  2 i object jɃZbgĺAR[obN֐̈Ƃēn܂B<br>
 * \sa CriAtomAudioEndpointCbFunc_WASAPI
 */
void CRIAPI criAtom_SetDeviceUpdateCallback_WASAPI(CriAtomDeviceUpdateCbFunc_WASAPI callback, void *object);

/*JP
 * \brief Xy[VI[fBI@\̗L
 * \ingroup ATOMLIB_WASAPI
 * \param[in]	type		TEh_^Cv
 * \param[in]	sw			@\Lɂ邩ǂiCRI_TRUE = LACRI_FALSE = j
 * \par :
 * Xy[VI[fBI@\iMicrosoft Spatial SoundjLɂ܂B<br>
 *  type ɂ́AXy[VI[fBI@\Li͖jɂTEh_w肵܂B<br>
 * \par l:
 * s̃Cuł́AXy[VI[fBI@\̓ftHgŗLłB<br>
 * ̂߁AXy[VI[fBI@\𖳌ɂꍇA{֐𖾎IɌĂяoKv͂܂B<br>
 */
void CRIAPI criAtom_SetSpatialAudioEnabled_WASAPI(CriAtomSoundRendererType type, CriBool sw);

/*JP
 * \brief Xy[VI[fBI@\Lǂ̃`FbN
 * \ingroup ATOMLIB_WASAPI
 * \param[in]	type		TEh_^Cv
 * \return		CriBool		@\LǂiCRI_TRUE = LACRI_FALSE = j
 * \par :
 * Xy[VI[fBI@\LɂȂĂ邩ǂ`FbN܂B<br>
 *  type ɂ́AXy[VI[fBI@\Lǂ`FbNTEh_w肵܂B<br>
 */
CriBool CRIAPI criAtom_IsSpatialAudioEnabled_WASAPI(CriAtomSoundRendererType type);

#if defined(XPT_TGT_PC)
/*JP
 * \brief nveBNXfoCXID̎w
 * \ingroup ATOMLIB_WASAPI
 * \par :
 * nveBNXfoCXIDƂ̃^Cvw肵܂B<br>
 * ̊֐sACRIATOM_SOUND_RENDERER_HAPTIC gpănveBNXo͗pASRbN쐬ł܂B
 */
void CRIAPI criAtom_SetHapticDeviceId_WASAPI(LPCWSTR device_id, CriAtomHapticDeviceType_WASAPI device_type);
#endif

/*==========================================================================
 *      CRI AtomEx API
 *=========================================================================*/
/*JP
 * \brief Cup[N̈TCY̌vZ
 * \ingroup ATOMLIB_WASAPI
 * \param[in]	config		pRtBO\
 * \return		CriSint32	[N̈TCY
 * \par :
 * Cugp邽߂ɕKvȁA[N̈̃TCY擾܂B<br>
 * \par l:
 * CuKvƂ郏[N̈̃TCÝACupRtBO
 * \́i ::CriAtomExConfig_WASAPI j̓eɂĕω܂B<br>
 * <br>
 *  config ̏́A֐ł̂ݎQƂ܂B<br>
 * ֐𔲂͎QƂ܂̂ŁA֐s config ̗̈Ă
 * 肠܂B
 * \attention
 * ::CriAtomExConfig_WASAPI \̂acf_infooɒlݒ肵ĂꍇA{֐͎s-1Ԃ܂B<br>
 * ACFf[^̓o^sꍇ́A{֐lgpmۂł͂ȂADXVXeɂ
 * AP[^[gpmۏKvɂȂ܂B
 * \sa CriAtomExConfig_WASAPI, criAtomEx_Initialize_WASAPI
 */
CriSint32 CRIAPI criAtomEx_CalculateWorkSize_WASAPI(const CriAtomExConfig_WASAPI *config);

/*JP
 * \brief Cȕ
 * \ingroup ATOMLIB_WASAPI
 * \param[in]	config		pRtBO\
 * \param[in]	work		[N̈
 * \param[in]	work_size	[N̈TCY
 * \par :
 * Cu܂B<br>
 * Cű@\𗘗pɂ́AK̊֐sKv܂B<br>
 * iCű@\́A{֐sA ::criAtomEx_Finalize_WASAPI ֐s܂ł̊ԁA
 * p\łBj<br>
 * <br>
 * Cuۂɂ́ACuŗp邽߂̃̈i[N̈j
 * mۂKv܂B<br>
 * CuKvƂ郏[N̈̃TCÝApRtBO\̂̓eɉ
 * ω܂B<br>
 * [N̈TCY̌vZɂ́A ::criAtomEx_CalculateWorkSize_WASAPI 
 * ֐gpĂB<br>
 * \par l:
 * ::criAtomEx_SetUserAllocator }NgpăAP[^[o^ς݂̏ꍇA
 * {֐Ƀ[N̈w肷Kv͂܂B<br>
 * i work  NULL A work_size  0 w肷邱ƂŁAo^ς݂̃AP[^[
 * Kvȃ[N̈TCỸIɊmۂ܂Bj
 * <br>
 *  config ̏́A֐ł̂ݎQƂ܂B<br>
 * ֐𔲂͎QƂ܂̂ŁA֐s config ̗̈Ă
 * 肠܂B
 * \attention
 * {֐͓IɈȉ̊֐s܂B<br>
 * 	- ::criAtomEx_Initialize
 * 	- ::criAtomExAsr_Initialize
 * 	- ::criAtomExHcaMx_Initialize
 * {֐sꍇAL֐sȂłB<br>
 * <br>
 * {֐sAK΂ɂȂ ::criAtomEx_Finalize_WASAPI ֐sĂB<br>
 * ܂A ::criAtomEx_Finalize_WASAPI ֐s܂ł́A{֐ēxsȂłB<br>
 * \sa CriAtomExConfig_WASAPI, criAtomEx_Finalize_WASAPI,
 * criAtomEx_SetUserAllocator, criAtomEx_CalculateWorkSize_WASAPI
 */
void CRIAPI criAtomEx_Initialize_WASAPI(
	const CriAtomExConfig_WASAPI *config, void *work, CriSint32 work_size);

/*JP
 * \brief CȕI
 * \ingroup ATOMLIB_WASAPI
 * \par :
 * CuI܂B<br>
 * \attention
 * {֐͓IɈȉ̊֐s܂B<br>
 * 	- ::criAtomEx_Finalize
 * 	- ::criAtomExAsr_Finalize
 * 	- ::criAtomExHcaMx_Finalize
 * {֐sꍇAL֐sȂłB<br>
 * <br>
 * ::criAtomEx_Initialize_WASAPI ֐sOɖ{֐s邱Ƃ͂ł܂B<br>
 * \sa criAtomEx_Initialize_WASAPI
 */
void CRIAPI criAtomEx_Finalize_WASAPI(void);

#ifdef __cplusplus
}
#endif

/***************************************************************************
 *      o[WƂ̌݊p
 *      For compatibility with old version
 ***************************************************************************/
#define CRIATOM_SOUND_RENDERER_SPATIAL_AUDIO CRIATOM_SOUND_RENDERER_DEFAULT
#define criAtom_ControlComInitialization_WASAPI(sw)
#define criAtom_EnableSpatialAudio_WASAPI(type)
#define criAtom_DisableSpatialAudio_WASAPI()

#endif	/* CRI_INCL_CRI_ATOM_WASAPI_H */

/* --- end of file --- */
