﻿/****************************************************************************
 *
 * Copyright (c) 2024 CRI Middleware Co., Ltd.
 *
 ****************************************************************************/

#if UNITY_EDITOR_WIN || UNITY_EDITOR_OSX || UNITY_STANDALONE_WIN || UNITY_STANDALONE_OSX || UNITY_IOS || UNITY_ANDROID || UNITY_PS4 || UNITY_PS5 || UNITY_GAMECORE_XBOXONE || UNITY_GAMECORE_SCARLETT || UNITY_SWITCH
#define CRI_SUPPORTS_SOUNDXR
#endif

using System;
using System.Runtime.InteropServices;

#if !UNITY_EDITOR && UNITY_ANDROID
using System.Globalization;
using UnityEngine;
#endif

/**
 * \addtogroup CriSoundxR
 * @{
 */

namespace CriWare {
	/**
	 * <summary>Class providing functions to use Sound xR</summary>
	 */
    public class CriSoundxR
    {
		private const string scriptVersionString = "1.00.04";

		const string pluginName =
#if UNITY_STANDALONE_OSX || UNITY_EDITOR_OSX
			"criafx_soundxr_macosx";
#elif UNITY_EDITOR || UNITY_ANDROID || UNITY_STANDALONE || UNITY_GAMECORE_XBOXONE || UNITY_GAMECORE_SCARLETT
			"criafx_soundxr";
#else
			"__Internal";
#endif

		/**
		 * <summary>Registering the Sound xR library in ADX</summary>
		 * <remarks>
		 * <para header='Description'>Perform the registration process of Sound xR for ADX.<br/>
		 * Be sure to call this function before initializing ADX.<br/>
		 * You do not need to call this function when using components for the Sound xR initialization.<br/></para>
		 * </remarks>
		 * <seealso cref='CriWare.CriSoundxRInitializer'/>
		 */
		public static void RegisterInterface()
		{
#if !UNITY_EDITOR && UNITY_ANDROID
			if(CultureInfo.InvariantCulture.CompareInfo.IndexOf(SystemInfo.processorType, "ARM", CompareOptions.IgnoreCase) < 0){ 
				Debug.LogWarning("[CRIWARE] CRI Afx Sound xR Expansion currently does not support x86_64/x86 version of Android.");
				return;
			}
#endif
			NativeMethods.criAtomExAsr_RegisterSoundxRInterface(NativeMethods.criSoundxR_GetInterface());
		}

		/**
		 * <summary>Unregistering the Sound xR library from ADX</summary>
		 * <remarks>
		 * <para header='Description'>Unregister Sound xR from ADX.<br/>
		 * You only need to call this function when finalizing the library in the game or during re-initialization.<br/></para>
		 * </remarks>
		 */
		public static void ResetInterface()
		{
#if !UNITY_EDITOR && UNITY_ANDROID
			if(CultureInfo.InvariantCulture.CompareInfo.IndexOf(SystemInfo.processorType, "ARM", CompareOptions.IgnoreCase) < 0){ 
				Debug.LogWarning("[CRIWARE] CRI Afx Sound xR Expansion currently does not support x86_64/x86 version of Android.");
				return;
			}
#endif
			NativeMethods.criAtomExAsr_RegisterSoundxRInterface(IntPtr.Zero);
		}

		class NativeMethods
		{
#if !CRIWARE_ENABLE_HEADLESS_MODE && CRI_SUPPORTS_SOUNDXR
			[DllImport(pluginName, CallingConvention = CriWare.Common.pluginCallingConvention)]
			public static extern IntPtr criSoundxR_GetInterface();
			[DllImport(CriWare.Common.pluginName, CallingConvention = CriWare.Common.pluginCallingConvention)]
			public static extern void criAtomExAsr_RegisterSoundxRInterface(IntPtr interfacePointer);
#else
			public static IntPtr criSoundxR_GetInterface(){return default;}
			public static void criAtomExAsr_RegisterSoundxRInterface(IntPtr interfacePointer) {}
#endif
		}
	}
} // namespace CriWare
/** @} */
