﻿/****************************************************************************
 *
 * Copyright (c) 2024 CRI Middleware Co., Ltd.
 *
 ****************************************************************************/

using UnityEngine;

/**
 * \addtogroup CriSoundxR
 * @{
 */

namespace CriWare
{
	/**
	 * <summary>Component for the initialization preprocessing of Sound xR</summary>
	 * <remarks>
	 * <para header='Description'>If this component is allocated in the scene,<br/>
	 * it will perform the tasks required to initialize Sound xR.<br/>
	 * When calling <see cref='CriWare.CriSoundxR.RegisterInterface'/> via the program,<br/>
	 * you do not need to allocate this component.</para>
	 * </remarks>
	 */
	[DefaultExecutionOrder(-20)]
	public class CriSoundxRInitializer : MonoBehaviour
	{
		private void Awake()
		{
			CriSoundxR.RegisterInterface();
			CriAtomPlugin.OnFinalized += CriSoundxR.ResetInterface;
		}
	}
}
/** @} */
