﻿/****************************************************************************
 *
 * Copyright (c) 2022 CRI Middleware Co., Ltd.
 *
 ****************************************************************************/

/**
 * \addtogroup CRIADDON_ASSETS_INTEGRATION
 * @{
 */

using System.Collections;
using System.Collections.Generic;
using UnityEngine;

namespace CriWare.Assets
{
	/**
	 * <summary>Interface to represent the CRI virtual assets</summary>
	 * <remarks>
	 * <para header='Description'>An interface for assets that have references to imported CRI assets and behave like CRI assets. <br/>
	 * Multilingual ACB assets and multi-platform assets implement this interface.</para>
	 * <seealso cref='CriAtomAcbLocalizedAsset'/><seealso cref='CriAtomAcbMultiPlatformAsset'/><seealso cref='CriAtomAcfMultiPlatformAsset'/>
	 * </remarks>
	 */
	public interface ICriReferenceAsset
	{
		/**
		 * <summary>Referenced assets</summary>
		 * <remarks>
		 * <para header='Description'>Returns the referenced CRI asset.<br/>
		 * Usually this will be a CRI asset（with actual data） generated by importing Non-Asset CRI data.<br/></para>
		 * </remarks>
		 */
		CriAssetBase ReferencedAsset { get; }
	}
}

/** @} */
