#
# CRI Middleware SDK
# Copyright (c) 2019 CRI Middleware Co., Ltd.
#

import criatomcraft_api_lib
import json
from . import common
from . import error

ACAPIMODULE_DEBUG = "debug"

def clear_log():
    return common.call_api(ACAPIMODULE_DEBUG, "clear_log", None, False)

def get_script_argument():
    return common.call_api(ACAPIMODULE_DEBUG, "get_script_argument", None, True)

def get_tool_version():
    return common.call_api(ACAPIMODULE_DEBUG, "get_tool_version", None, True)

def log(message):
    arguments = {}
    arguments["message"] = str(message)
    return common.call_api(ACAPIMODULE_DEBUG, "log", arguments, False)

def ping():
    return common.call_api(ACAPIMODULE_DEBUG, "ping", None, False)

def warning(message):
    arguments = {}
    arguments["message"] = message
    return common.call_api(ACAPIMODULE_DEBUG, "warning", arguments, False)

# --- deprecated
def get_script_file_path():
    return common.call_api(ACAPIMODULE_DEBUG, "get_script_file_path", None, True)
