/****************************************************************************
 *
 * CRI ADX2 LE SDK
 *
 * Copyright (c) 2013-2014 CRI Middleware Co., Ltd.
 *
 * Title   : CRI ADX2 LE sample program
 * Module  : C^NeBu TEh
 * File    : InteractiveSound.cpp
 *
 ****************************************************************************/

/**************************************************************************
 * CN[h
 * Header files
 **************************************************************************/
#include <windows.h>
#include <cri_adx2le.h>
#include <CriSmpFramework.h>

/* CQ[vr[LɂꍇA` */
#define USE_INGAME_PREVIEW

/**************************************************************************
 * 萔}N`
 * Constant macro definitions
 **************************************************************************/
/* ACBt@C̃}N`wb_ */
#include "../../data/Public/InteractiveSound.h"
/* ACFt@C̃}N`wb_ */
#include "../../data/Public/ADX2_samples_acf.h"

/* f[^fBNgւ̃pX */
/* Header file for path definitions to data directory */
#define PATH				"../../../data/Public/"

/* TvŎgpt@C */
/* File names used in this sample */
#define ACF_FILE			"ADX2_samples.acf"
#define ACB_FILE			"InteractiveSound.acb"
#define AWB_FILE			"InteractiveSound.awb"

/* ő{CX𑝂₷߂̊֘Ap[^ */
#define MAX_VOICE			(24)
#define MAX_VIRTUAL_VOICE	(MAX_VOICE + 8)		/* o[`{CX͑ */
#define MAX_CRIFS_LOADER	(MAX_VOICE + 8)		/* ǂݍݐ߂ */

/* őTvO[gisb`ύX܂ށj */
#define MAX_SAMPLING_RATE	(48000*2)

/* AISACRg[l臒l */
#define X_POS_OFFSET_FOR_SLIDER_DRAW	(30)
#define Z_POS_OFFSET_FOR_SLIDER_DRAW	(0)

#define X_POS_SCALE_VAL	(50.0f)

#define SLIDER_WIDTH	(51)

/* AISACRg[l̒Pʕω */
#define DELTA_AISAC_VALUE (0.02f) // 1  X_POS_SCALE_VAL (PʕωʂAXC_[ẑPvfɑj

/**************************************************************************
 * ^`
 * Type definitions
 **************************************************************************/
/* AISACvr[ */
typedef struct App3dPositioningPreviewItemTag {
	CriAtomExCueId cue_id;
} App3dPositioningPreviewItem;

/* AvP[V\ */
typedef struct AppTag{
	/* \[XIuWFNg */
	CriAtomExVoicePoolHn voice_pool;
	CriAtomExAcbHn	acb_hn;
	CriAtomExPlayerHn player;			/* Đv[ */
	CriAtomExAisacControlId  aisac_control_id;
	CriAtomDbasId dbas_id;

	/* ĐL[̃vr[CfbNX */
	CriSint32 selecting_preview_index;
	CriSint32 current_preview_index;
} AppObj;

/***************************************************************************
 * ֐`
 * Function definitions
 ***************************************************************************/
static void user_error_callback_func(const CriChar8 *errid, CriUint32 p1, CriUint32 p2, CriUint32 *parray);
void *user_alloc_func(void *obj, CriUint32 size);
void user_free_func(void *obj, void *ptr);

/* AvP[V̎ */
static void app_display_info(AppObj *app_obj);
static CriBool app_atomex_initialize(AppObj *app_obj);
static CriBool app_atomex_finalize(AppObj *app_obj);
static CriBool app_execute_main(AppObj *app_obj);
static CriBool app_atomex_start(AppObj *app_obj);
static CriBool app_atomex_stop(AppObj *app_obj);
static void app_goto_next_preview(AppObj *app_obj);
static void app_goto_prev_preview(AppObj *app_obj);
static void app_decrease_aisac(AppObj *app_obj);
static void app_increase_aisac(AppObj *app_obj);
static void app_reset_aisac(AppObj *app_obj);

/**************************************************************************
 * ϐ`
 * Variable definitions
 **************************************************************************/
/* AISAC ̃vr[Xg */
static App3dPositioningPreviewItem g_preview_list[] = {
	CRI_INTERACTIVESOUND_MULTI_TRACK,
	CRI_INTERACTIVESOUND_IMPACT_SE,
};

/* AISACXC_[̏ */
static const CriChar8 g_slider_default[SLIDER_WIDTH + 1] = {
	"---------------------------------------------------",
};

/* XC_[\p */
static CriChar8 g_slider[SLIDER_WIDTH + 1];

/***************************************************************************
 * ֐`
 * Function definitions
 ***************************************************************************/

/* TṽGg|Cg */
int main(void)
{
	/* AvP[VIuWFNg̒` */
	AppObj app_obj = {0};
	/* Tvt[[NIuWFNg (EBhEǗEfobO\p) */
	CriSmpFramework *smpfw = NULL;
	/* L[͔pIuWFNg */
	CriSmpInputDevice* idev = NULL;

	/* Tvt[[N̍쐬 */
	smpfw = CriSmpFramework::Create();
	idev = smpfw->GetInputDevice();

	/* AvP[V̏ */
	app_atomex_initialize(&app_obj);

	/* C[v̊Jn */
	for (;;) {
		/* [ŨL[͏XV */
		idev->Update();
		{
			/* 1: ̍ĐJn */
			if ( idev->IsPressed(idev->BUTTON1) ) {
				app_atomex_start(&app_obj);
			}
			/* 2: ̍Đ~ */
			if ( idev->IsPressed(idev->BUTTON2) ) {
				app_atomex_stop(&app_obj);
			}
			/* 3: Đ[hOɈڍs */
			if ( idev->IsPressed(idev->BUTTON_UP) ) {
				app_goto_prev_preview(&app_obj);
			}
			/* 4: Đ[hɈڍs */
			if ( idev->IsPressed(idev->BUTTON_DOWN) ) {
				app_goto_next_preview(&app_obj);
			}

			/* 5: AISACRg[l */
			if ( idev->IsOn(idev->BUTTON_LEFT) ) {
				app_decrease_aisac(&app_obj);
			}
			/* 6: AISACRg[l𑝉 */
			if ( idev->IsOn(idev->BUTTON_RIGHT) ) {
				app_increase_aisac(&app_obj);
			}
		}

		/* AvP[VI (ESCL[EBhEꂽꍇ) */
		if ( idev->IsPressed(idev->BUTTON_CANCEL) || smpfw->IsTerninated() == TRUE) {
			break;
		}

		/* AvP[V̍XV */
		if (app_execute_main(&app_obj) != CRI_TRUE) {
			break;
		}

		/* AvP[V̏\ */
		smpfw->BeginDraw();
		app_display_info(&app_obj);
		smpfw->EndDraw();

		/* zV҂(^C}[ɂX[v) */
		smpfw->SyncFrame();
	}

	/* AvP[V̏I */
	app_atomex_finalize(&app_obj);

	/* Tvt[[N̔j */
	smpfw->Destroy(); smpfw = NULL;

	return CRI_OK;
}

static void app_display_info(AppObj *app_obj)
{
	CriSint32 i = 1;
	CriSmpPrintf( 2, i++, "CRI ADX2 LE Sample Program: InteractiveSound");i+=2;

	/* Đ̕\ */
	CriSmpPrintf( 2, i++, "<< AISAC Preview List >>");
	for (CriSint32 n=0;n<sizeof(g_preview_list)/sizeof(App3dPositioningPreviewItem);n++) {
		if (n==app_obj->selecting_preview_index) {
			CriSmpPrintf( 1, i, "*");
		}
		CriSmpPrintf( 3, i, "%d: Cue Name=%s", n, criAtomExAcb_GetCueNameById(app_obj->acb_hn, g_preview_list[n].cue_id));
		i++;
	}
	i++;
	CriSmpPrintf( 2, i++, "Current Preview Index : %d", app_obj->current_preview_index);

	CriFloat32 aisac_val = criAtomExPlayer_GetAisacById(app_obj->player, app_obj->aisac_control_id);
	CriSmpPrintf( 2, i++, "Current AISAC Value   : %1.2f", aisac_val);

	/* L[͏̕\ */
	i=22;
	CriSmpPrintf( 2, i++, "1          key: Start");
	CriSmpPrintf( 2, i++, "2          key: Stop");
	CriSmpPrintf( 2, i++, "UP/DOWN    Key: Select Preview Index");
	CriSmpPrintf( 2, i++, "LEFT/RIGHT Key: Change AISAC Control Value");
	CriSmpPrintf( 2, i++, "ESC        key: EXIT");

	/* ݂AISACRg[lXC_[ɕ\ */
	i=9;
	CriSint32 mapped_aisac_cv = (CriSint32)(criAtomExPlayer_GetAisacById(app_obj->player, app_obj->aisac_control_id) * X_POS_SCALE_VAL);
	memcpy(g_slider, g_slider_default, SLIDER_WIDTH + 1);
	if ((i < SLIDER_WIDTH + 1) && (i >= 0)) {
		g_slider[mapped_aisac_cv] = '#';
	}
	CriSmpPrintf(X_POS_OFFSET_FOR_SLIDER_DRAW, i + Z_POS_OFFSET_FOR_SLIDER_DRAW, "%s", g_slider);
}

static CriBool app_atomex_initialize(AppObj *app_obj)
{
	/* AvP[V̏lݒ */
	app_obj->selecting_preview_index = 0;
	app_obj->current_preview_index = 0;
	app_obj->aisac_control_id = CRI_INTERACTIVESOUND_AISACCONTROL_ANY;

	/* G[R[obN֐̓o^ */
	criErr_SetCallback(user_error_callback_func);

	/* AP[^̓o^ */
	criAtomEx_SetUserAllocator(user_alloc_func, user_free_func, NULL);
	
	/* Cȕiő{CXύXj */
	CriAtomExConfig_WASAPI lib_config;
	CriFsConfig fs_config;
	criAtomEx_SetDefaultConfig_WASAPI(&lib_config);
	criFs_SetDefaultConfig(&fs_config);
	lib_config.atom_ex.max_virtual_voices = MAX_VIRTUAL_VOICE;
	fs_config.num_loaders = MAX_CRIFS_LOADER;
	lib_config.atom_ex.fs_config = &fs_config;
	criAtomEx_Initialize_WASAPI(&lib_config, NULL, 0);

	/* D-Bas̍쐬iőXg[͂Ō܂܂j */
	app_obj->dbas_id = criAtomDbas_Create(NULL, NULL, 0);

	#if defined(USE_INGAME_PREVIEW)
		CriAtomExAsrBusAnalyzerConfig analyze_config;
		CriSint32 bus_no;
		/* CQ[vr[p̃j^Cu */
		criAtomExMonitor_Initialize(NULL, NULL, 0);
		/* x@\ǉ */
		criAtomExAsr_SetDefaultConfigForBusAnalyzer(&analyze_config);
		for ( bus_no=0;bus_no<8;bus_no++) {
			criAtomExAsr_AttachBusAnalyzer(bus_no, &analyze_config);
		}
	#endif

	/* ACFt@C̓ǂݍ݂Ɠo^ */
	criAtomEx_RegisterAcfFile(NULL, PATH ACF_FILE, NULL, 0);
	
	/* DSPݒ̃A^b` */
	criAtomEx_AttachDspBusSetting(CRI_ADX2_SAMPLES_ACF_DSPSETTING_DSPBUSSETTING_0, NULL, 0);

	/* {CXv[̍쐬iő{CXύX^ősb`ύX^Xg[ĐΉj */
	CriAtomExStandardVoicePoolConfig vpool_config;
	criAtomExVoicePool_SetDefaultConfigForStandardVoicePool(&vpool_config);
	vpool_config.num_voices = MAX_VOICE;
	vpool_config.player_config.max_sampling_rate = MAX_SAMPLING_RATE;
	vpool_config.player_config.streaming_flag = CRI_TRUE;
	app_obj->voice_pool = criAtomExVoicePool_AllocateStandardVoicePool(&vpool_config, NULL, 0);

	/* ACBt@Cǂݍ݁AACBnh쐬 */
	app_obj->acb_hn = criAtomExAcb_LoadAcbFile(NULL, PATH ACB_FILE, NULL, PATH AWB_FILE, NULL, 0);

	/* v[̍쐬 */
	app_obj->player = criAtomExPlayer_Create(NULL, NULL, 0);
	app_reset_aisac(app_obj);

	return CRI_TRUE;
}

static CriBool app_atomex_finalize(AppObj *app_obj)
{
	/* DSP̃f^b` */
	criAtomEx_DetachDspBusSetting();

	/* Atomnh̔j */
	criAtomExPlayer_Destroy(app_obj->player);
	
	/* {CXv[̔j */
	criAtomExVoicePool_Free(app_obj->voice_pool);

	/* ACBnh̔j */
	criAtomExAcb_Release(app_obj->acb_hn);

	/* ACF̓o^ */
	criAtomEx_UnregisterAcf();

	#if defined(USE_INGAME_PREVIEW)
		/* CQ[vr[֘A@\̏I */
		CriSint32 bus_no;
		for ( bus_no=0;bus_no<8;bus_no++) {
			criAtomExAsr_DetachBusAnalyzer(bus_no);
		}
		criAtomExMonitor_Finalize();
	#endif

	/* D-BAS̔j */
	criAtomDbas_Destroy(app_obj->dbas_id);

	/* CȕI */
	criAtomEx_Finalize_WASAPI();

	return CRI_TRUE;
}

CriBool app_execute_main(AppObj *app_obj)
{
	CriAtomExPlayerStatus player_status;

	/* T[o̎s */
	criAtomEx_ExecuteMain();

#if defined(USE_INGAME_PREVIEW)
	/* oX͏̎擾 */
	CriAtomExAsrBusAnalyzerInfo analyze_info;
	CriSint32 bus_no;
	for ( bus_no=0;bus_no<8;bus_no++) {
		criAtomExAsr_GetBusAnalyzerInfo(bus_no, &analyze_info);
	}
#endif

	/* Exv[̃Xe[^XmF */
	player_status = criAtomExPlayer_GetStatus(app_obj->player);

	/* ĐG[ɂȂꍇ̓AvP[VI */
	if (player_status == CRIATOMEXPLAYER_STATUS_ERROR) {
		return CRI_FALSE;		
	}

	return CRI_TRUE;
}

static CriBool app_atomex_start(AppObj *app_obj)
{
	/* Ỏ~ */
	criAtomExPlayer_Stop(app_obj->player);

	/* L[ID̎w */
	criAtomExPlayer_SetCueId(app_obj->player, app_obj->acb_hn, g_preview_list[app_obj->selecting_preview_index].cue_id);

	/* Đ̊Jn */
	criAtomExPlayer_Start(app_obj->player);

	app_obj->current_preview_index = app_obj->selecting_preview_index;

	return CRI_TRUE;
}

static CriBool app_atomex_stop(AppObj *app_obj)
{
	criAtomExPlayer_Stop(app_obj->player);
	app_reset_aisac(app_obj);

	return CRI_TRUE;
}

void app_reset_aisac(AppObj *app_obj)
{
	/* AISACRg[l[ */
	criAtomExPlayer_SetAisacById(app_obj->player, app_obj->aisac_control_id, 0.0f);
	return;
}

static void app_decrease_aisac(AppObj *app_obj)
{
	/* AISACRg[l */
	CriFloat32 aisac_val = criAtomExPlayer_GetAisacById(app_obj->player, app_obj->aisac_control_id) - DELTA_AISAC_VALUE;
	criAtomExPlayer_SetAisacById(app_obj->player, app_obj->aisac_control_id, aisac_val);
	criAtomExPlayer_UpdateAll(app_obj->player);
}

static void app_increase_aisac(AppObj *app_obj)
{
	/* AISACRg[l */
	CriFloat32 aisac_val = criAtomExPlayer_GetAisacById(app_obj->player, app_obj->aisac_control_id) + DELTA_AISAC_VALUE;
	criAtomExPlayer_SetAisacById(app_obj->player, app_obj->aisac_control_id, aisac_val);
	criAtomExPlayer_UpdateAll(app_obj->player);
}

static void app_goto_next_preview(AppObj *app_obj)
{
	CriSint32 max_items = sizeof(g_preview_list)/sizeof(App3dPositioningPreviewItem);

	app_obj->selecting_preview_index++;
	if (app_obj->selecting_preview_index >= max_items) {
		app_obj->selecting_preview_index = 0;
	}
}

static void app_goto_prev_preview(AppObj *app_obj)
{
	CriSint32 max_items = sizeof(g_preview_list)/sizeof(App3dPositioningPreviewItem);

	app_obj->selecting_preview_index--;
	if (app_obj->selecting_preview_index < 0) {
		app_obj->selecting_preview_index = max_items -1;
	}
}

/* G[R[obN֐ */
static void user_error_callback_func(const CriChar8 *errid, CriUint32 p1, CriUint32 p2, CriUint32 *parray)
{
	const CriChar8 *errmsg;

	/* G[̕\ */
	errmsg = criErr_ConvertIdToMessage(errid, p1, p2);
	CriSmpDebugPrintf("%s\n", errmsg);

	return;
}

void *user_alloc_func(void *obj, CriUint32 size)
{
	void *ptr;
	ptr = malloc(size);
	return ptr;
}

void user_free_func(void *obj, void *ptr)
{
	free(ptr);
}
/* --- end of file --- */
