/****************************************************************************
 *
 * CRI ADX2 LE SDK
 *
 * Copyright (c) 2013-2014 CRI Middleware Co., Ltd.
 *
 * Title   : CRI ADX2 LE sample program
 * Module  : {ĐTv(HCA-MXĐΉ)
 * File    : Basic.cpp
 *
 ****************************************************************************/

/**************************************************************************
 * CN[h
 * Header files
 **************************************************************************/
#include <cri_adx2le.h>
#include <CriSmpFramework.h>

/* CQ[vr[LɂꍇA` */
#define USE_INGAME_PREVIEW

/**************************************************************************
 * 萔}N`
 * Constant macro definitions
 **************************************************************************/
/* ACF/ACB̃}N`wb_ */
#include "../../data/Public/Basic.h"
#include "../../data/Public/ADX2_samples_acf.h"

/* f[^fBNgւ̃pX */
#define PATH	"../../../data/Public/"

/* TvŎgpt@C */
#define ACF_FILE			"ADX2_samples.acf"
#define ACB_FILE			"Basic.acb"
#define AWB_FILE			"Basic.awb"

/* ő{CX𑝂₷߂̊֘Ap[^ */
#define MAX_VOICE			(24)
#define MAX_VIRTUAL_VOICE	(64)		/* 葽(ʏ{CX{HCA-MX{CX{) */
#define MAX_CRIFS_LOADER	(64)		/* 葽(ʏ{CX{HCA-MX{CX{) */

/* őTvO[gisb`ύX܂ށj */
#define MAX_SAMPLING_RATE	(48000*2)

/* HCA-MXR[fbÑTvO[g */
#define SAMPLINGRATE_HCAMX		(32000)


#define X_POS_OFFSET_FOR_MAP_DRAW	(20)
#define PITCH_CHANGE_VALUE			(-200.0f)

/**************************************************************************
 * ^`
 * Type definitions
 **************************************************************************/

/* L[XgACe */
typedef struct AppCueListItemTag {
	CriAtomExCueId id;
} AppCueListItem;

/* AvP[V\ */
typedef struct AppTag{
	CriAtomExPlayerHn		player;		/* Đv[ */
	CriAtomExVoicePoolHn	standard_voice_pool;	/* {CXv[(ADX/HCAR[fbNp) */
	CriAtomExVoicePoolHn	hcamx_voice_pool;		/* {CXv[(HCA-MXp) */
	CriAtomExAcbHn			acb_hn;		/* ACBnh(f[^) */
	CriAtomDbasId			dbas_id;	/* D-BAS̍쐬*/

	CriAtomExPlaybackId		playback_id;	/* VoiceL[̃vCobNID(ĐJnɕێ) */

	CriSint32 ui_cue_idnex;				/* [UI𒆂̃L[   */

} AppObj;

/***************************************************************************
 * ֐錾
 * Function declarations
 ***************************************************************************/
static void user_error_callback_func(const CriChar8 *errid, CriUint32 p1, CriUint32 p2, CriUint32 *parray);
static void *user_alloc_func(void *obj, CriUint32 size);
static void user_free_func(void *obj, void *ptr);

static void app_display_info(AppObj *app_obj);
static CriBool app_atomex_initialize(AppObj *app_obj);
static CriBool app_atomex_finalize(AppObj *app_obj);
static CriBool app_execute_main(AppObj *app_obj);

static CriBool app_atomex_start(AppObj *app_obj);
static CriBool app_atomex_stop_player(AppObj *app_obj);
static CriBool app_atomex_stop_cue(AppObj *app_obj);

/**************************************************************************
 * ϐ`
 * Variable definitions
 **************************************************************************/

/* L[ꗗ */
static AppCueListItem g_cue_list[] = {
	CRI_BASIC_MUSIC1,
	CRI_BASIC_MUSIC2,
	CRI_BASIC_VOICE_RANDOM,
	CRI_BASIC_VOICE_EFFECT,
	CRI_BASIC_KALIMBA,
	CRI_BASIC_GUNSHOT,
	CRI_BASIC_BOMB_LIMIT,
	CRI_BASIC_PITCH_UP_M2,
	CRI_BASIC_PITCH_DEF_M2
};
static CriUint32 g_num_cue_items = sizeof(g_cue_list)/sizeof(AppCueListItem);

static CriChar8* g_playback_status_description[] = {
	"--",
	"Prepare",
	"Playing",
	"Removed",
};

/***************************************************************************
 * ֐`
 * Function definitions
 ***************************************************************************/

int main(void) {
	/* AvP[VIuWFNg̒` */
	AppObj app_obj = {0};
	/* Tvt[[NIuWFNg (EBhEǗEfobO\p) */
	CriSmpFramework *smpfw = NULL;
	/* L[͔pIuWFNg */
	CriSmpInputDevice* idev = NULL;

	/* Tvt[[N̍쐬 */
	smpfw = CriSmpFramework::Create();
	idev = smpfw->GetInputDevice();

	/* AvP[V̏ */
	app_atomex_initialize(&app_obj);

	for (;;) {
		/* [ŨL[͏XV */
		idev->Update();
		{
			/* 1: L[Đ */
			if ( idev->IsPressed(idev->BUTTON1) ) {
				app_atomex_start(&app_obj);
			}
			/* 2: v[~ (S̒~) */
			if ( idev->IsPressed(idev->BUTTON2) ) {
				app_atomex_stop_player(&app_obj);
			}
			/* 3: ̍Đɑ΂~ ({TvłVoiceL[̂ݒ~) */
			if ( idev->IsPressed(idev->BUTTON3) ) {
				app_atomex_stop_cue(&app_obj);
			}

			/* 4: L[Ii) */
			if ( idev->IsPressed(idev->BUTTON_UP) ) {
				app_obj.ui_cue_idnex--;
				if (app_obj.ui_cue_idnex<0) {
					app_obj.ui_cue_idnex = g_num_cue_items - 1;
				}
			}
			/* 5: L[Ii) */
			if ( idev->IsPressed(idev->BUTTON_DOWN) ) {
				app_obj.ui_cue_idnex++;
				if (app_obj.ui_cue_idnex == g_num_cue_items) {
					app_obj.ui_cue_idnex = 0;
				}
			}
		}

		/* AvP[VI (ESCL[EBhEꂽꍇ) */
		if ( idev->IsPressed(idev->BUTTON_CANCEL) || smpfw->IsTerninated() == TRUE) {
			break;
		}

		/* AvP[V̍XV */
		if (app_execute_main(&app_obj) != CRI_TRUE) {
			break;
		}

		/* AvP[V̏\ */
		smpfw->BeginDraw();
		app_display_info(&app_obj);
		smpfw->EndDraw();

		/* zV҂(^C}[ɂX[v) */
		smpfw->SyncFrame();
	}

	/* AvP[V̏I */
	app_atomex_finalize(&app_obj);

	/* Tvt[[N̔j */
	smpfw->Destroy(); smpfw = NULL;

	return 0;
}

/* G[R[obN֐ */
static void user_error_callback_func(const CriChar8 *errid, CriUint32 p1, CriUint32 p2, CriUint32 *parray)
{
	const CriChar8 *errmsg;

	/* G[̕\ */
	errmsg = criErr_ConvertIdToMessage(errid, p1, p2);
	CriSmpDebugPrintf("%s\n", errmsg);

	return;
}

void *user_alloc_func(void *obj, CriUint32 size)
{
	void *ptr;
	ptr = malloc(size);
	return ptr;
}

void user_free_func(void *obj, void *ptr)
{
	free(ptr);
}

static void app_display_info(AppObj *app_obj)
{
	CriSint32 i = 1;
	CriSmpPrintf( 2, i++, "CRI ADX2 LE Sample Program: Basic");i++;

	/* {CXv[̃{CXgp󋵂\ */
	CriSint32 current_vnum, vlimit;
	criAtomExVoicePool_GetNumUsedVoices(app_obj->standard_voice_pool, &current_vnum, &vlimit);
	CriSmpPrintf( 2, i++, "Standard Voice (Playing / Max): %d/%d", current_vnum, vlimit);
	criAtomExVoicePool_GetNumUsedVoices(app_obj->hcamx_voice_pool, &current_vnum, &vlimit);
	CriSmpPrintf( 2, i++, "HCA-MX Voice   (Playing / Max): %d/%d", current_vnum, vlimit);i+=2;

	/* L[̃Xg\ */
	CriSmpPrintf( 2, i++, "-- Cue List --");
	for (CriUint32 n=0;n<g_num_cue_items;n++) {

		if (n==app_obj->ui_cue_idnex) {
			CriSmpPrintf(2, i+n, "*");
		}

		CriSmpPrintf( 4, i+n, "%s", criAtomExAcb_GetCueNameById(app_obj->acb_hn, g_cue_list[n].id));

		/* VoiceL[̖Oׂ̗ɂÃL[̍ĐԂƎ\ */
		if (g_cue_list[n].id == CRI_BASIC_VOICE_RANDOM) {
			CriAtomExPlaybackStatus playback_state = criAtomExPlayback_GetStatus(app_obj->playback_id);
			CriSint64 playback_time = criAtomExPlayback_GetTime(app_obj->playback_id);
			CriSmpPrintf( 4 + X_POS_OFFSET_FOR_MAP_DRAW, i+n, "[Status: %s,  Time:%lld msec.]",
				g_playback_status_description[playback_state], playback_time);
		}
	}

	/* L[͏̕\ */
	i=24;
	CriSmpPrintf( 2, i++, "1       key: Start");
	CriSmpPrintf( 2, i++, "2       key: Stop All");
	CriSmpPrintf( 2, i++, "3       key: Stop Only Voice");
	CriSmpPrintf( 2, i++, "UP/DOWN Key: Select Preview Index");
	CriSmpPrintf( 2, i++, "ESC     key: EXIT");
}

CriBool app_atomex_initialize(AppObj *app_obj)
{
	/* J[\̃Zbg */
	app_obj->ui_cue_idnex = 0;
	/* 擾ȃvCobNID(VoiceL[Đ̂ݎ擾) */
	app_obj->playback_id = 0;

	/* G[R[obN֐̓o^ */
	criErr_SetCallback(user_error_callback_func);

	/* AP[^̓o^ */
	criAtomEx_SetUserAllocator(user_alloc_func, user_free_func, NULL);

	/* Cȕiő{CXύXj */
	CriAtomExConfig_WASAPI lib_config;
	CriFsConfig fs_config;
	criAtomEx_SetDefaultConfig_WASAPI(&lib_config);
	criFs_SetDefaultConfig(&fs_config);
	lib_config.atom_ex.max_virtual_voices = MAX_VIRTUAL_VOICE;
	lib_config.hca_mx.output_sampling_rate = SAMPLINGRATE_HCAMX;
	fs_config.num_loaders = MAX_CRIFS_LOADER;
	lib_config.atom_ex.fs_config = &fs_config;
	criAtomEx_Initialize_WASAPI(&lib_config, NULL, 0);

	/* D-Bas̍쐬iőXg[͂Ō܂܂j */
	app_obj->dbas_id = criAtomDbas_Create(NULL, NULL, 0);

	#if defined(USE_INGAME_PREVIEW)
		CriAtomExAsrBusAnalyzerConfig analyze_config;
		CriSint32 bus_no;
		/* CQ[vr[p̃j^Cu */
		criAtomExMonitor_Initialize(NULL, NULL, 0);
		/* x@\ǉ */
		criAtomExAsr_SetDefaultConfigForBusAnalyzer(&analyze_config);
		for ( bus_no=0;bus_no<8;bus_no++) {
			criAtomExAsr_AttachBusAnalyzer(bus_no, &analyze_config);
		}
	#endif

	/* ACFt@C̓ǂݍ݂Ɠo^ */
	criAtomEx_RegisterAcfFile(NULL, PATH ACF_FILE, NULL, 0);
	
	/* DSPݒ̃A^b` */
	criAtomEx_AttachDspBusSetting(CRI_ADX2_SAMPLES_ACF_DSPSETTING_DSPBUSSETTING_0, NULL, 0);

	/* {CXv[̍쐬iő{CXύX^ősb`ύX^Xg[ĐΉj */
	CriAtomExStandardVoicePoolConfig standard_vpool_config;
	criAtomExVoicePool_SetDefaultConfigForStandardVoicePool(&standard_vpool_config);
	standard_vpool_config.num_voices = MAX_VOICE;
	standard_vpool_config.player_config.max_sampling_rate = MAX_SAMPLING_RATE;
	standard_vpool_config.player_config.streaming_flag = CRI_TRUE;
	app_obj->standard_voice_pool = criAtomExVoicePool_AllocateStandardVoicePool(&standard_vpool_config, NULL, 0);

	/* HCA-MXĐpF{CXv[̍쐬 */
	CriAtomExHcaMxVoicePoolConfig hcamx_vpool_config;
	criAtomExVoicePool_SetDefaultConfigForHcaMxVoicePool(&hcamx_vpool_config);
	hcamx_vpool_config.num_voices = MAX_VOICE;
	hcamx_vpool_config.player_config.max_sampling_rate = MAX_SAMPLING_RATE;
	hcamx_vpool_config.player_config.streaming_flag = CRI_TRUE;
	app_obj->hcamx_voice_pool = criAtomExVoicePool_AllocateHcaMxVoicePool(&hcamx_vpool_config, NULL, 0);

	/* ACBt@Cǂݍ݁AACBnh쐬 */
	app_obj->acb_hn = criAtomExAcb_LoadAcbFile(NULL, PATH ACB_FILE, NULL, PATH AWB_FILE, NULL, 0);

	/* v[̍쐬 */
	app_obj->player = criAtomExPlayer_Create(NULL, NULL, 0);

	return CRI_TRUE;
}

CriBool app_atomex_finalize(AppObj *app_obj)
{
	/* DSP̃f^b` */
	criAtomEx_DetachDspBusSetting();

	/* v[nh̔j */
	criAtomExPlayer_Destroy(app_obj->player);
	
	/* {CXv[̔j */
	criAtomExVoicePool_Free(app_obj->hcamx_voice_pool);
	criAtomExVoicePool_Free(app_obj->standard_voice_pool);

	/* ACBnh̔j */
	criAtomExAcb_Release(app_obj->acb_hn);

	/* ACF̓o^ */
	criAtomEx_UnregisterAcf();

	#if defined(USE_INGAME_PREVIEW)
		/* CQ[vr[֘A@\̏I */
		CriSint32 bus_no;
		for ( bus_no=0;bus_no<8;bus_no++) {
			criAtomExAsr_DetachBusAnalyzer(bus_no);
		}
		criAtomExMonitor_Finalize();
	#endif

	/* D-BAS̔j */
	criAtomDbas_Destroy(app_obj->dbas_id);

	/* CȕI */
	criAtomEx_Finalize_WASAPI();

	return CRI_TRUE;
}

CriBool app_execute_main(AppObj *app_obj)
{
	/* T[o̎s */
	criAtomEx_ExecuteMain();

#if defined(USE_INGAME_PREVIEW)
	/* oX͏̎擾 */
	CriAtomExAsrBusAnalyzerInfo analyze_info;
	CriSint32 bus_no;
	for ( bus_no=0;bus_no<8;bus_no++) {
		criAtomExAsr_GetBusAnalyzerInfo(bus_no, &analyze_info);
	}
#endif

	return CRI_TRUE;
}

static CriBool app_atomex_start(AppObj *app_obj)
{
	CriAtomExCueId start_cue_id = g_cue_list[app_obj->ui_cue_idnex].id;

	/* L[ID̎w */
	criAtomExPlayer_SetCueId(app_obj->player, app_obj->acb_hn, start_cue_id);

	/* MEMO: ̉sb`ςčĐꍇB      */
	/* (1) v[Ƀsb`ݒB                          */
	/* (2) ĐJnB                                        */
	/* (3) v[̃sb`߂B                          */
	/* {                                                     */
	/*   criAtomExPlayer_SetPitch(player, pitch);          */
	/*   criAtomExPlayer_SetCueId(player, acb, cue_id);  */
	/*   criAtomExPlayer_Start(player, pitch);             */
	/*   criAtomExPlayer_SetPitch(player, 0.0f);           */
	/* {                                                     */
	/* ⑫: HCA-MXR[fbN̏ꍇ̓sb`ύX͖B      */

	/* Đ̊Jn */
	CriAtomExPlaybackId playback_id = criAtomExPlayer_Start(app_obj->player);

	/* VoiceL[̂݁AĐ擾̂߃vCobNIDۑ */
	if (start_cue_id == CRI_BASIC_VOICE_RANDOM) {
		app_obj->playback_id = playback_id;
	}

	return CRI_TRUE;
}

static CriBool app_atomex_stop_player(AppObj *app_obj)
{
	/* v[̒~ */
	criAtomExPlayer_Stop(app_obj->player);

	return CRI_TRUE;
}

static CriBool app_atomex_stop_cue(AppObj *app_obj)
{
	/* ̍Đ̂ݒ~ */
	criAtomExPlayback_Stop(app_obj->playback_id);

	return CRI_TRUE;
}
