/****************************************************************************
 *
 * CRI Middleware SDK
 *
 * Copyright (c) 2011 CRI Middleware Co., Ltd.
 *
 * Library  : CRI Atom
 * Module   : Library User's Header for Mac OS X
 * File     : cri_atom_macosx.h
 *
 ****************************************************************************/
/*!
 *	\file		cri_atom_macosx.h
 */

/* d`h~					*/
/* Prevention of redefinition	*/
#ifndef	CRI_INCL_CRI_ATOM_MACOSX_H
#define	CRI_INCL_CRI_ATOM_MACOSX_H

/***************************************************************************
 *      CN[ht@C
 *      Include files
 ***************************************************************************/
#include <cri_le_error.h>
#include <cri_le_atom.h>
#include <cri_le_atom_ex.h>
#include <cri_le_atom_asr.h>

/***************************************************************************
 *      萔}N
 *      Macro Constants
 ***************************************************************************/
/*==========================================================================
 *      CRI Atom API
 *=========================================================================*/
/*JP
 * \brief CupRtBO\̂ɃftHglZbg
 * \ingroup ATOMLIB_MACOSX
 * \param[out]	p_config	pRtBO\̂ւ̃|C^
 * \par :
 * ::criAtom_Initialize_MACOSX ֐ɐݒ肷RtBO\
 * i ::CriAtomConfig_MACOSX jɁAftHg̒lZbg܂B<br>
 * \attention
 * {}N͉ʃCAPIłB<br>
 * AtomExC̋@\𗘗pۂɂ́A{}N̑ 
 * ::criAtomEx_SetDefaultConfig_MACOSX }NpB
 * \sa CriAtomConfig_MACOSX
 */
#define criAtom_SetDefaultConfig_MACOSX(p_config)				\
{															\
	criAtom_SetDefaultConfig(&(p_config)->atom);			\
	criAtomExAsr_SetDefaultConfig(&(p_config)->asr);		\
	criAtomHcaMx_SetDefaultConfig(&(p_config)->hca_mx);		\
}

/*==========================================================================
 *      CRI AtomEx API
 *=========================================================================*/
/*JP
 * \brief CupRtBO\̂ɃftHglZbg
 * \ingroup ATOMLIB_MACOSX
 * \param[out]	p_config	pRtBO\̂ւ̃|C^
 * \par :
 * ::criAtomEx_Initialize_MACOSX ֐ɐݒ肷RtBO\
 * i ::CriAtomExConfig_MACOSX jɁAftHg̒lZbg܂B<br>
 * \sa CriAtomExConfig_MACOSX
 */
#define criAtomEx_SetDefaultConfig_MACOSX(p_config)			\
{															\
	criAtomEx_SetDefaultConfig(&(p_config)->atom_ex);		\
	criAtomExAsr_SetDefaultConfig(&(p_config)->asr);		\
	criAtomExHcaMx_SetDefaultConfig(&(p_config)->hca_mx);	\
}

/***************************************************************************
 *      }N
 *      Macro Functions
 ***************************************************************************/

/***************************************************************************
 *      f[^^錾
 *      Data Type Declarations
 ***************************************************************************/
/*==========================================================================
 *      CRI Atom API
 *=========================================================================*/
/*JP
 * \brief AtomCupRtBO\
 * \ingroup ATOMLIB_MACOSX
 * CRI AtomCu̓dlw肷邽߂̍\̂łB<br>
 * ::criAtom_Initialize_MACOSX ֐̈Ɏw肵܂B<br>
 * \attention
 * {\͉̂ʃCAPIłB<br>
 * AtomExC̋@\𗘗pۂɂ́A{\̂̑ 
 * ::CriAtomExConfig_MACOSX \̂pB
 * \sa criAtom_Initialize_MACOSX, criAtom_SetDefaultConfig_MACOSX
 */
typedef struct {
	CriAtomConfig			atom;		/* AtompRtBO\		*/
	CriAtomAsrConfig		asr;		/* ASRpRtBO			*/
	CriAtomHcaMxConfig		hca_mx;		/* HCA-MXpRtBO\	*/
} CriAtomConfig_MACOSX;

/*==========================================================================
 *      CRI AtomEx API
 *=========================================================================*/
/*JP
 * \brief AtomCupRtBO\
 * \ingroup ATOMLIB_MACOSX
 * CRI AtomCu̓dlw肷邽߂̍\̂łB<br>
 * ::criAtomEx_Initialize_MACOSX ֐̈Ɏw肵܂B<br>
 * \sa criAtomEx_Initialize_MACOSX, criAtomEx_SetDefaultConfig_MACOSX
 */
typedef struct {
	CriAtomExConfig			atom_ex;	/* AtomExpRtBO\	*/
	CriAtomExAsrConfig		asr;		/* ASRpRtBO			*/
	CriAtomExHcaMxConfig	hca_mx;		/* HCA-MXpRtBO\	*/
} CriAtomExConfig_MACOSX;

/***************************************************************************
 *      ϐ錾
 *      Prototype Variables
 ***************************************************************************/

/***************************************************************************
 *      ֐錾
 *      Prototype Functions
 ***************************************************************************/
#ifdef __cplusplus
extern "C" {
#endif

/*==========================================================================
 *      CRI Atom API
 *=========================================================================*/
/*JP
 * \brief Cup[N̈TCY̌vZ
 * \ingroup ATOMLIB_MACOSX
 * \param[in]	config		pRtBO\
 * \return		CriSint32	[N̈TCY
 * \par :
 * Cugp邽߂ɕKvȁA[N̈̃TCY擾܂B<br>
 * \par l:
 * CuKvƂ郏[N̈̃TCÝACupRtBO
 * \́i ::CriAtomConfig_MACOSX j̓eɂĕω܂B<br>
 * <br>
 *  config ̏́A֐ł̂ݎQƂ܂B<br>
 * ֐𔲂͎QƂ܂̂ŁA֐s config ̗̈Ă
 * 肠܂B
 * \attention
 * {֐͉ʃCAPIłB<br>
 * AtomExC̋@\𗘗pۂɂ́A{֐̑ 
 * ::criAtomEx_CalculateWorkSize_MACOSX ֐pB
 * \sa CriAtomConfig_MACOSX, criAtom_Initialize_MACOSX
 */
CriSint32 CRIAPI criAtom_CalculateWorkSize_MACOSX(const CriAtomConfig_MACOSX *config);

/*JP
 * \brief Cȕ
 * \ingroup ATOMLIB_MACOSX
 * \param[in]	config		pRtBO\
 * \param[in]	work		[N̈
 * \param[in]	work_size	[N̈TCY
 * \par :
 * Cu܂B<br>
 * Cű@\𗘗pɂ́AK̊֐sKv܂B<br>
 * iCű@\́A{֐sA ::criAtom_Finalize_MACOSX ֐s܂ł̊ԁA
 * p\łBj<br>
 * <br>
 * Cuۂɂ́ACuŗp邽߂̃̈i[N̈j
 * mۂKv܂B<br>
 * CuKvƂ郏[N̈̃TCÝApRtBO\̂̓eɉ
 * ω܂B<br>
 * [N̈TCY̌vZɂ́A ::criAtom_CalculateWorkSize_MACOSX 
 * ֐gpĂB<br>
 * \par l:
 * ::criAtom_SetUserAllocator }NgpăAP[^o^ς݂̏ꍇA
 * {֐Ƀ[N̈w肷Kv͂܂B<br>
 * i work  NULL A work_size  0 w肷邱ƂŁAo^ς݂̃AP[^
 * Kvȃ[N̈TCỸIɊmۂ܂Bj
 * <br>
 *  config ̏́A֐ł̂ݎQƂ܂B<br>
 * ֐𔲂͎QƂ܂̂ŁA֐s config ̗̈Ă
 * 肠܂B
 * \attention
 * {֐͓IɈȉ̊֐s܂B<br>
 * 	- ::criAtom_Initialize
 * 	- ::criAtomAsr_Initialize
 * 	- ::criAtomHcaMx_Initialize
 * 	.
 * {֐sꍇAL֐sȂłB<br>
 * <br>
 * {֐sAK΂ɂȂ ::criAtom_Finalize_MACOSX ֐sĂB<br>
 * ܂A ::criAtom_Finalize_MACOSX ֐s܂ł́A{֐ēxsȂłB<br>
 * <br>
 * {֐͉ʃCAPIłB<br>
 * AtomExC̋@\𗘗pۂɂ́A{֐̑ 
 * ::criAtomEx_Initialize_MACOSX ֐pB
 * \sa CriAtomConfig_MACOSX, criAtom_Finalize_MACOSX,
 * criAtom_SetUserAllocator, criAtom_CalculateWorkSize_MACOSX
 */
void CRIAPI criAtom_Initialize_MACOSX(
	const CriAtomConfig_MACOSX *config, void *work, CriSint32 work_size);

/*JP
 * \brief CȕI
 * \ingroup ATOMLIB_MACOSX
 * \par :
 * CuI܂B<br>
 * \attention
 * {֐͓IɈȉ̊֐s܂B<br>
 * 	- ::criAtom_Finalize
 * 	- ::criAtomAsr_Finalize
 * 	- ::criAtomHcaMx_Finalize
 * 	.
 * {֐sꍇAL֐sȂłB<br>
 * <br>
 * ::criAtom_Initialize_MACOSX ֐sOɖ{֐s邱Ƃ͂ł܂B<br>
 * <br>
 * {֐͉ʃCAPIłB<br>
 * AtomExC̋@\𗘗pۂɂ́A{֐̑ 
 * ::criAtomEx_Finalize_MACOSX ֐pB
 * \sa criAtom_Initialize_MACOSX
 */
void CRIAPI criAtom_Finalize_MACOSX(void);

/*JP
 * \brief T[oXbhvCIeB̐ݒ
 * \ingroup ATOMLIB_MACOSX
 * \param[in]	prio	Xbh̃vCIeB
 * \par :
 * CRIT[oXbh̃vCIeBݒ肵܂B<br>
 *  prio  pthread ̃vCIeBݒlƂĎgp܂B<br>
 * włl͈̔͂͒ʏ -16`99ŁA傫DxȂ܂B<br>
 * AvP[ṼCXbh(0)vCIeBw肵ĂB<br>
 * vCIeB̃ftHgl10łB<br>
 * \attention
 * ::criAtom_Initialize_MACOSX ֐sOɖ{֐s邱Ƃ͂ł܂B<br>
 * <br>
 * T[oXbh́ACRI File SystemCułpĂ܂B<br>
 * łCRI File SystemCuAPIŃT[oXbh̐ݒύXĂꍇ
 * {֐ɂݒ肪㏑܂̂łӂB<br>
 */
void CRIAPI criAtom_SetServerThreadPriority_MACOSX(int prio);


/*==========================================================================
 *      CRI AtomEx API
 *=========================================================================*/
/*JP
 * \brief Cup[N̈TCY̌vZ
 * \ingroup ATOMLIB_MACOSX
 * \param[in]	config		pRtBO\
 * \return		CriSint32	[N̈TCY
 * \par :
 * Cugp邽߂ɕKvȁA[N̈̃TCY擾܂B<br>
 * \par l:
 * CuKvƂ郏[N̈̃TCÝACupRtBO
 * \́i ::CriAtomExConfig_MACOSX j̓eɂĕω܂B<br>
 * <br>
 *  config ̏́A֐ł̂ݎQƂ܂B<br>
 * ֐𔲂͎QƂ܂̂ŁA֐s config ̗̈Ă
 * 肠܂B
 * \attention
 * ::CriAtomExConfig_MACOSX \̂acf_infooɒlݒ肵ĂꍇA{֐͎s-1Ԃ܂B<br>
 * ACFf[^̓o^sꍇ́A{֐lgpmۂł͂ȂADXVXeɂ
 * AP[^gpmۏKvɂȂ܂B
 * \sa CriAtomExConfig_MACOSX, criAtomEx_Initialize_MACOSX
 */
CriSint32 CRIAPI criAtomEx_CalculateWorkSize_MACOSX(const CriAtomExConfig_MACOSX *config);

/*JP
 * \brief Cȕ
 * \ingroup ATOMLIB_MACOSX
 * \param[in]	config		pRtBO\
 * \param[in]	work		[N̈
 * \param[in]	work_size	[N̈TCY
 * \par :
 * Cu܂B<br>
 * Cű@\𗘗pɂ́AK̊֐sKv܂B<br>
 * iCű@\́A{֐sA ::criAtomEx_Finalize_MACOSX ֐s܂ł̊ԁA
 * p\łBj<br>
 * <br>
 * Cuۂɂ́ACuŗp邽߂̃̈i[N̈j
 * mۂKv܂B<br>
 * CuKvƂ郏[N̈̃TCÝApRtBO\̂̓eɉ
 * ω܂B<br>
 * [N̈TCY̌vZɂ́A ::criAtom_CalculateWorkSize_MACOSX 
 * ֐gpĂB<br>
 * \par l:
 * ::criAtomEx_SetUserAllocator }NgpăAP[^o^ς݂̏ꍇA
 * {֐Ƀ[N̈w肷Kv͂܂B<br>
 * i work  NULL A work_size  0 w肷邱ƂŁAo^ς݂̃AP[^
 * Kvȃ[N̈TCỸIɊmۂ܂Bj
 * <br>
 *  config ̏́A֐ł̂ݎQƂ܂B<br>
 * ֐𔲂͎QƂ܂̂ŁA֐s config ̗̈Ă
 * 肠܂B
 * \attention
 * {֐͓IɈȉ̊֐s܂B<br>
 * 	- ::criAtomEx_Initialize
 * 	- ::criAtomExAsr_Initialize
 * 	- ::criAtomExHcaMx_Initialize
 * 	.
 * {֐sꍇAL֐sȂłB<br>
 * <br>
 * {֐sAK΂ɂȂ ::criAtomEx_Finalize_MACOSX ֐sĂB<br>
 * ܂A ::criAtomEx_Finalize_MACOSX ֐s܂ł́A{֐ēxsȂłB<br>
 * \sa CriAtomExConfig_MACOSX, criAtomEx_Finalize_MACOSX,
 * criAtomEx_SetUserAllocator, criAtomEx_CalculateWorkSize_MACOSX
 */
void CRIAPI criAtomEx_Initialize_MACOSX(
	const CriAtomExConfig_MACOSX *config, void *work, CriSint32 work_size);

/*JP
 * \brief CȕI
 * \ingroup ATOMLIB_MACOSX
 * \par :
 * CuI܂B<br>
 * \attention
 * {֐͓IɈȉ̊֐s܂B<br>
 * 	- ::criAtomEx_Finalize
 * 	- ::criAtomExAsr_Finalize
 * 	- ::criAtomExHcaMx_Finalize
 * 	.
 * {֐sꍇAL֐sȂłB<br>
 * <br>
 * ::criAtomEx_Initialize_MACOSX ֐sOɖ{֐s邱Ƃ͂ł܂B<br>
 * \sa criAtomEx_Initialize_MACOSX
 */
void CRIAPI criAtomEx_Finalize_MACOSX(void);

/*JP
 * \brief T[oXbhvCIeB̐ݒ
 * \ingroup ATOMLIB_MACOSX
 * \param[in]	prio	Xbh̃vCIeB
 * \par :
 * CRIT[oXbh̃vCIeBݒ肵܂B<br>
 *  prio  pthread ̃vCIeBݒlƂĎgp܂B<br>
 * włl͈̔͂͒ʏ -16`99ŁA傫DxȂ܂B<br>
 * AvP[ṼCXbh(0)vCIeBw肵ĂB<br>
 * vCIeB̃ftHgl10łB<br>
 * \attention
 * ::criAtomEx_Initialize_MACOSX ֐sOɖ{֐s邱Ƃ͂ł܂B<br>
 * <br>
 * T[oXbh́ACRI File SystemCułpĂ܂B<br>
 * łCRI File SystemCuAPIŃT[oXbh̐ݒύXĂꍇ
 * {֐ɂݒ肪㏑܂̂łӂB<br>
 */
void CRIAPI criAtomEx_SetServerThreadPriority_MACOSX(int prio);


#ifdef __cplusplus
}
#endif

/***************************************************************************
 *      o[WƂ̌݊p
 *      For compatibility with old version
 ***************************************************************************/

#endif	/* CRI_INCL_CRI_ATOM_MACOSX_H */

/* --- end of file --- */
