#
# CRI Middleware SDK
# Copyright (c) 2021 CRI Middleware Co., Ltd.
#

import criatomcraft_api_lib
import json
from . import common
from . import error

ACAPIMODULE_PROFILER = "profiler"

PROFILER_LOG_MODE_PLAYBACK              = (1)
PROFILER_LOG_MODE_ERROR					= (1 << 1)
PROFILER_LOG_MODE_LOW_LEVEL_PLAYBACK	= (1 << 2)
PROFILER_LOG_MODE_SYSTEM_INFO			= (1 << 3)
PROFILER_LOG_MODE_HANDLE_INFO			= (1 << 4)
PROFILER_LOG_MODE_CUE_LIMIT				= (1 << 5)
PROFILER_LOG_MODE_PROBABILITY			= (1 << 6)
PROFILER_LOG_MODE_CATEGORY				= (1 << 7)
PROFILER_LOG_MODE_EXECUTING_INFORMATION	= (1 << 8)
PROFILER_LOG_MODE_3D_INFO				= (1 << 9)
PROFILER_LOG_MODE_USER_LOG				= (1 << 10)
PROFILER_LOG_MODE_VOICE_VOLUME			= (1 << 11)
PROFILER_LOG_MODE_ALL		            = (0xFFFFFFFF)

def start_profiler_logging(logMode = PROFILER_LOG_MODE_ALL):
    arguments = {}
    arguments["mode"] = str(logMode)
    return common.call_api(ACAPIMODULE_PROFILER, "start_profiler_logging", arguments, False)

def stop_profiler_logging():
    return common.call_api(ACAPIMODULE_PROFILER, "stop_profiler_logging", None, False)
    
def export_alllog_to_csv(outputFilePath = ""):
    arguments = {}
    arguments["file_path"]   = outputFilePath
    return common.call_api(ACAPIMODULE_PROFILER, "profiler_export_all_log_to_csv", arguments, False)
