import cri.atomcraft.criatomcraft_api_lib as acconnect
import cri.atomcraft.project as acproject
import cri.atomcraft.profiler as acprofiler
import cri.atomcraft.preview  as acpreview
import cri.atomcraft.debug as acdebug
import time
import sys

# Initialization
result = acconnect.initialize()
if result != 0:
    print("initialize error")
    sys.exit()
# Connecting
result = acconnect.connect("127.0.0.1", 9000)
if result != 0:
    print("connection failed")
    acconnect.finalize()
    sys.exit()


acdebug.log("Connecting for Robot Server")

# Load the project.
# The in-game connection assumes that the project is loaded.
# Load the project in advance.
project_path = "ProjectFolder/xxx.atmcproject"
result = acproject.open_project(project_path)
if not result["succeed"]:
    acdebug.warning("Failed Load Project")
    sys.exit()

# === About the start_ingame_acpreviewiew function ===
# 1st argument: Target (string), 2nd argument: IP address to connect to (string)
# The following character strings (case-insensitive) can be specified for the target:
# pc, public, android, iphone, xboxone, ps4, ps5, switch
if acpreview.start_ingame_acpreviewiew("pc", "127.0.0.1")["succeed"]:
	# While the Cue Sheet is being transferred, start_profiler_logging may be ignored.
	# Wait for the completion of the transfer.
	time.sleep(6)
	acdebug.log("In-Game Connected")
	#start_profiler_logging: Start profiling.
	if acprofiler.start_profiler_logging()["succeed"]:
		acdebug.log("Logging...")
		# Calling sleep to get the log for 10 seconds.
		# It is not necessary if the application can be operated from the script.
		time.sleep(10)
		#stop_profiler_logging: Stop profiling.
		acprofiler.stop_profiler_logging()

		# The export_alllog_to_csv function outputs all logs in CSV format.
		# The output file name is "ProfilerAllLog.csv", located in the same hierarchy as the log.
		acprofiler.export_alllog_to_csv()
		acdebug.log("OK")

	# End the in-game preview and disconnect from the application.
	acpreview.stop_ingame_acpreviewiew()
	acdebug.log("stop_ingame_acpreviewiew")


# Disconnect
acconnect.disconnect()
# Exit
acconnect.finalize()