/*
 * Decompiled with CFR 0.152.
 */
package com.criware.filesystem;

import android.os.AsyncTask;
import android.os.Build;
import android.os.Handler;
import android.os.Looper;
import com.criware.filesystem.CriFsWebInstallerManager;
import com.criware.filesystem.TLSSocketFactory;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.InetSocketAddress;
import java.net.MalformedURLException;
import java.net.ProtocolException;
import java.net.Proxy;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import java.net.URL;
import java.net.UnknownHostException;
import java.security.GeneralSecurityException;
import java.util.Date;
import java.util.Locale;
import java.util.zip.CRC32;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLException;
import javax.net.ssl.SSLHandshakeException;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;

public class CriFsWebInstaller {
    private static final boolean ENABLE_DEBUG_PRINT = false;
    private static CriFsWebInstallerManager manager;
    private WebInstallerTask task;
    private StatusInfo synced_statusinfo = new StatusInfo();
    private AsyncTaskParam task_params;
    public boolean is_stop_required = false;
    private long start_time;
    private boolean is_waiting_to_start;
    private long timeout_start_time;
    private boolean is_timeouted;
    private boolean can_access_asynctask;
    private CRC32 crc_num;

    CriFsWebInstaller() {
        if (CriFsWebInstaller.manager.crc_enabled) {
            this.crc_num = new CRC32();
        }
        this.ClearMember();
    }

    public void Update() {
        if (this.synced_statusinfo.status != Status.CRIFSWEBINSTALLER_STATUS_BUSY || !this.can_access_asynctask) {
            return;
        }
        TaskStatusInfo task_statusinfo = this.task.GetTaskStatusInfo();
        if (task_statusinfo == null) {
            return;
        }
        switch (task_statusinfo.status) {
            case BUSY: {
                boolean is_progressing;
                if (this.is_stop_required) {
                    this.task.Cancel();
                    break;
                }
                this.synced_statusinfo.contents_size = task_statusinfo.contents_size;
                boolean bl = is_progressing = task_statusinfo.received_size > this.synced_statusinfo.received_size;
                if (is_progressing) {
                    this.synced_statusinfo.received_size = task_statusinfo.received_size;
                    this.timeout_start_time = this.GetNow() / 1000L;
                    break;
                }
                long currentSec = this.GetNow() / 1000L;
                if (this.timeout_start_time + (long)CriFsWebInstaller.manager.inactive_timeout_sec >= currentSec) break;
                this.is_timeouted = true;
                this.task.cancel(true);
                break;
            }
            case STOP: {
                if (this.is_stop_required) {
                    File tmp_file = new File(this.task_params.param_dst_path + ".tmp");
                    tmp_file.delete();
                    this.ClearMember();
                    break;
                }
                if (this.is_timeouted) {
                    this.synced_statusinfo.contents_size = task_statusinfo.contents_size;
                    this.synced_statusinfo.received_size = task_statusinfo.received_size;
                    this.synced_statusinfo.status = Status.CRIFSWEBINSTALLER_STATUS_ERROR;
                    this.synced_statusinfo.error = Error.CRIFSWEBINSTALLER_ERROR_TIMEOUT;
                    break;
                }
                this.synced_statusinfo.contents_size = task_statusinfo.contents_size;
                this.synced_statusinfo.received_size = task_statusinfo.received_size;
                long currentSec = this.GetNow() / 1000L;
                if (this.timeout_start_time + (long)CriFsWebInstaller.manager.inactive_timeout_sec < currentSec) {
                    this.is_timeouted = true;
                }
                if (task_statusinfo.error == Error.CRIFSWEBINSTALLER_ERROR_NONE) {
                    this.synced_statusinfo.status = Status.CRIFSWEBINSTALLER_STATUS_COMPLETE;
                    this.synced_statusinfo.http_status_code = task_statusinfo.http_status_code;
                    break;
                }
                if (CriFsWebInstaller.IsRetryable(task_statusinfo.error, this.synced_statusinfo.contents_size)) {
                    if (!this.is_waiting_to_start) {
                        this.is_waiting_to_start = true;
                        this.start_time = this.GetNow();
                        break;
                    }
                    long currentminiSec = this.GetNow();
                    if (currentminiSec - this.start_time < 5000L) break;
                    this.is_waiting_to_start = false;
                    this.task_params.param_contents_size = this.synced_statusinfo.contents_size;
                    this.task_params.param_received_size = this.synced_statusinfo.received_size;
                    this.can_access_asynctask = false;
                    this.StartTask(this.task_params);
                    break;
                }
                this.synced_statusinfo.status = Status.CRIFSWEBINSTALLER_STATUS_ERROR;
                this.synced_statusinfo.error = task_statusinfo.error;
                this.synced_statusinfo.http_status_code = task_statusinfo.http_status_code;
                break;
            }
            case STOPPING: {
                this.synced_statusinfo.contents_size = task_statusinfo.contents_size;
                this.synced_statusinfo.received_size = task_statusinfo.received_size;
            }
        }
    }

    private long GetNow() {
        Date date = new Date();
        return date.getTime();
    }

    private static boolean IsRetryable(Error error, long contents_size) {
        boolean is_error_retryable = error == Error.CRIFSWEBINSTALLER_ERROR_CONNECTION || error == Error.CRIFSWEBINSTALLER_ERROR_DNS;
        boolean is_contents_size_retryable = contents_size != -1L;
        return is_error_retryable && is_contents_size_retryable;
    }

    private void ClearMember() {
        this.synced_statusinfo.status = Status.CRIFSWEBINSTALLER_STATUS_STOP;
        this.synced_statusinfo.error = Error.CRIFSWEBINSTALLER_ERROR_NONE;
        this.synced_statusinfo.http_status_code = -1;
        this.synced_statusinfo.contents_size = -1L;
        this.synced_statusinfo.received_size = 0L;
        this.start_time = 0L;
        this.timeout_start_time = 0L;
        this.is_waiting_to_start = false;
        this.is_timeouted = false;
        this.can_access_asynctask = false;
        if (CriFsWebInstaller.manager.crc_enabled && this.crc_num != null) {
            this.crc_num.reset();
        }
    }

    private void StartTask(final AsyncTaskParam params) {
        block4: {
            try {
                if (Build.VERSION.SDK_INT < 11) {
                    Handler handler = new Handler(Looper.getMainLooper());
                    handler.post(new Runnable(){

                        @Override
                        public void run() {
                            CriFsWebInstaller.this.task = new WebInstallerTask();
                            CriFsWebInstaller.this.task.execute(new AsyncTaskParam[]{params});
                            CriFsWebInstaller.this.can_access_asynctask = true;
                        }
                    });
                    break block4;
                }
                if (Build.VERSION.SDK_INT >= 11 && Build.VERSION.SDK_INT < 16) {
                    Handler handler = new Handler(Looper.getMainLooper());
                    handler.post(new Runnable(){

                        @Override
                        public void run() {
                            CriFsWebInstaller.this.task = new WebInstallerTask();
                            CriFsWebInstaller.this.task.executeOnExecutor(AsyncTask.THREAD_POOL_EXECUTOR, new AsyncTaskParam[]{params});
                            CriFsWebInstaller.this.can_access_asynctask = true;
                        }
                    });
                    break block4;
                }
                this.task = new WebInstallerTask();
                this.task.executeOnExecutor(AsyncTask.THREAD_POOL_EXECUTOR, new AsyncTaskParam[]{params});
                this.can_access_asynctask = true;
                return;
            }
            catch (NullPointerException e) {
                CriFsWebInstaller.ErrorEntry(10);
                this.synced_statusinfo.status = Status.CRIFSWEBINSTALLER_STATUS_ERROR;
                this.synced_statusinfo.error = Error.CRIFSWEBINSTALLER_ERROR_MEMORY;
                return;
            }
        }
    }

    public static void Initialize(Config wiconfig) {
        if (manager == null) {
            manager = new CriFsWebInstallerManager();
            manager.Manager_Initialize(wiconfig);
        } else {
            CriFsWebInstaller.ErrorEntry(1);
        }
    }

    public static void Finalize() {
        if (manager != null) {
            manager.Manager_Finalize();
            manager = null;
        } else {
            CriFsWebInstaller.ErrorEntry(1);
        }
    }

    public static void SetRequestHeader(String field, String value) {
        if (manager != null) {
            CriFsWebInstaller.manager.request_headers.set(field, value);
        }
    }

    public static void ExecuteMain() {
        if (manager != null) {
            manager.ExecuteMain();
        }
    }

    public static CriFsWebInstaller Create() {
        if (manager != null) {
            CriFsWebInstaller installer = manager.CreateInstaller();
            return installer;
        }
        CriFsWebInstaller.ErrorEntry(1);
        return null;
    }

    public void Destroy() {
        if (this.synced_statusinfo.status != Status.CRIFSWEBINSTALLER_STATUS_STOP) {
            CriFsWebInstaller.ErrorEntry(2);
            return;
        }
        if (CriFsWebInstaller.manager.installer_list.remove(this)) {
            --CriFsWebInstaller.manager.num_installers;
        }
    }

    public void Copy(String src_path, String dst_path) {
        if (this.synced_statusinfo.status != Status.CRIFSWEBINSTALLER_STATUS_STOP) {
            CriFsWebInstaller.ErrorEntry(2);
            return;
        }
        this.ClearMember();
        this.is_stop_required = false;
        this.synced_statusinfo.status = Status.CRIFSWEBINSTALLER_STATUS_BUSY;
        this.task_params = new AsyncTaskParam(src_path, dst_path, this.synced_statusinfo.contents_size, this.synced_statusinfo.received_size);
        this.timeout_start_time = this.GetNow() / 1000L;
        this.StartTask(this.task_params);
    }

    public void Stop() {
        switch (this.synced_statusinfo.status) {
            case CRIFSWEBINSTALLER_STATUS_STOP: {
                break;
            }
            case CRIFSWEBINSTALLER_STATUS_BUSY: {
                this.is_stop_required = true;
                break;
            }
            case CRIFSWEBINSTALLER_STATUS_COMPLETE: 
            case CRIFSWEBINSTALLER_STATUS_ERROR: {
                this.ClearMember();
            }
        }
    }

    public int GetStatusInfo_status() {
        return this.synced_statusinfo.status.getValue();
    }

    public int GetStatusInfo_error() {
        return this.synced_statusinfo.error.getValue();
    }

    public int GetStatusInfo_http_status_code() {
        return this.synced_statusinfo.http_status_code;
    }

    public long GetStatusInfo_contents_size() {
        return this.synced_statusinfo.contents_size;
    }

    public long GetStatusInfo_received_size() {
        return this.synced_statusinfo.received_size;
    }

    public int IsCRCEnabled() {
        if (CriFsWebInstaller.manager.crc_enabled) {
            return 1;
        }
        return 0;
    }

    public long GetCRC32() {
        return this.crc_num.getValue();
    }

    public static boolean ErrorEntry(int entrynum) {
        return CriFsWebInstaller.ErrorCallback(entrynum);
    }

    private static native boolean ErrorCallback(int var0);

    private class WebInstallerTask
    extends AsyncTask<AsyncTaskParam, Void, Boolean> {
        private HttpURLConnection http_connection = null;
        private TaskStatusInfo task_internal_info;
        private boolean is_ssl;
        private String task_src_path;
        private String task_dst_path;
        private File tmp_file;

        WebInstallerTask() {
            this.task_internal_info = new TaskStatusInfo();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected Boolean doInBackground(AsyncTaskParam ... params) {
            this.task_src_path = params[0].param_src_path;
            this.task_dst_path = params[0].param_dst_path;
            WebInstallerTask webInstallerTask = this;
            synchronized (webInstallerTask) {
                this.task_internal_info.contents_size = params[0].param_contents_size;
                this.task_internal_info.received_size = params[0].param_received_size;
            }
            if (!this.task_setup()) {
                if (this.http_connection != null) {
                    this.http_connection.disconnect();
                }
                return false;
            }
            if (this.isCancelled()) {
                this.tmp_file.delete();
                this.http_connection.disconnect();
                return false;
            }
            if (!this.task_connect()) {
                this.http_connection.disconnect();
                return false;
            }
            if (!this.task_copyfile()) {
                return false;
            }
            webInstallerTask = this;
            synchronized (webInstallerTask) {
                this.task_internal_info.status = TaskStatus.STOP;
            }
            return true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void onPostExecute(Boolean is_completed) {
            WebInstallerTask webInstallerTask = this;
            synchronized (webInstallerTask) {
                this.task_internal_info.status = TaskStatus.STOP;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void onCancelled() {
            WebInstallerTask webInstallerTask = this;
            synchronized (webInstallerTask) {
                this.task_internal_info.status = TaskStatus.STOP;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void Cancel() {
            this.cancel(true);
            WebInstallerTask webInstallerTask = this;
            synchronized (webInstallerTask) {
                this.task_internal_info.status = TaskStatus.STOPPING;
            }
        }

        public synchronized TaskStatusInfo GetTaskStatusInfo() {
            return this.task_internal_info;
        }

        private synchronized void SetError(Error error, int http_status_code) {
            boolean is_error_retryable;
            boolean bl = is_error_retryable = error == Error.CRIFSWEBINSTALLER_ERROR_CONNECTION || error == Error.CRIFSWEBINSTALLER_ERROR_DNS;
            if (!is_error_retryable && this.tmp_file.exists()) {
                this.tmp_file.delete();
            }
            this.task_internal_info.status = TaskStatus.STOP;
            this.task_internal_info.error = error;
            this.task_internal_info.http_status_code = http_status_code;
        }

        private boolean task_setup() {
            try {
                boolean is_os_version_4_x;
                if (this.task_src_path.toLowerCase(Locale.ENGLISH).startsWith("https://")) {
                    this.is_ssl = true;
                } else if (this.task_src_path.toLowerCase(Locale.ENGLISH).startsWith("http://")) {
                    this.is_ssl = false;
                } else {
                    this.SetError(Error.CRIFSWEBINSTALLER_ERROR_INTERNAL, this.task_internal_info.http_status_code);
                    CriFsWebInstaller.ErrorEntry(7);
                    return false;
                }
                URL url = new URL(this.task_src_path);
                this.tmp_file = new File(this.task_dst_path + ".tmp");
                SSLSocketFactory special_socket_factory = null;
                TrustManager[] trust_manager_for_insecure_ssl = null;
                if (manager.allow_insecure_ssl && this.is_ssl) {
                    trust_manager_for_insecure_ssl = new X509TrustManager[]{new CriFsWebInstallerManager.LooseTrustManager()};
                }
                boolean bl = is_os_version_4_x = Build.VERSION.SDK_INT >= 16 && Build.VERSION.SDK_INT < 21;
                if (is_os_version_4_x || trust_manager_for_insecure_ssl != null) {
                    SSLContext sslcontext = SSLContext.getInstance("TLS");
                    sslcontext.init(null, trust_manager_for_insecure_ssl, null);
                    special_socket_factory = is_os_version_4_x ? new TLSSocketFactory(sslcontext.getSocketFactory()) : sslcontext.getSocketFactory();
                }
                try {
                    if (manager.proxy_host != null && manager.proxy_port != 0) {
                        Proxy proxy = new Proxy(Proxy.Type.HTTP, new InetSocketAddress(manager.proxy_host, (int)manager.proxy_port));
                        this.http_connection = (HttpURLConnection)url.openConnection(proxy);
                    } else {
                        manager.proxy_host = System.getProperty("http.proxyHost");
                        if (manager.proxy_host != null) {
                            String portStr = System.getProperty("http.proxyPort");
                            manager.proxy_port = Short.parseShort(portStr != null ? portStr : "-1");
                            Proxy proxy = new Proxy(Proxy.Type.HTTP, new InetSocketAddress(manager.proxy_host, (int)manager.proxy_port));
                            this.http_connection = (HttpURLConnection)url.openConnection(proxy);
                        } else {
                            this.http_connection = (HttpURLConnection)url.openConnection();
                        }
                    }
                }
                catch (IllegalArgumentException e) {
                    this.SetError(Error.CRIFSWEBINSTALLER_ERROR_INTERNAL, this.task_internal_info.http_status_code);
                    CriFsWebInstaller.ErrorEntry(11);
                    return false;
                }
                this.http_connection.setRequestMethod("GET");
                this.http_connection.setInstanceFollowRedirects(false);
                this.http_connection.setDoInput(true);
                this.http_connection.setConnectTimeout(5000);
                this.http_connection.setReadTimeout(5000);
                this.http_connection.setRequestProperty("User-Agent", manager.user_agent);
                this.http_connection.setRequestProperty("Accept-Encoding", "identity");
                try {
                    for (int i = 0; i < manager.request_headers.length(); ++i) {
                        this.http_connection.setRequestProperty(manager.request_headers.getFieldName(i), manager.request_headers.getValue(i));
                    }
                }
                catch (IllegalArgumentException e) {
                    this.SetError(Error.CRIFSWEBINSTALLER_ERROR_INTERNAL, this.task_internal_info.http_status_code);
                    CriFsWebInstaller.ErrorEntry(12);
                    return false;
                }
                if (special_socket_factory != null) {
                    ((HttpsURLConnection)this.http_connection).setSSLSocketFactory(special_socket_factory);
                }
                if (this.task_internal_info.contents_size != -1L) {
                    if (!this.tmp_file.exists()) {
                        CriFsWebInstaller.ErrorEntry(8);
                        this.SetError(Error.CRIFSWEBINSTALLER_ERROR_LOCALFS, this.task_internal_info.http_status_code);
                        return false;
                    }
                    if (this.tmp_file.length() != this.task_internal_info.received_size) {
                        CriFsWebInstaller.ErrorEntry(9);
                        this.SetError(Error.CRIFSWEBINSTALLER_ERROR_INTERNAL, this.task_internal_info.http_status_code);
                        return false;
                    }
                    this.http_connection.setRequestProperty("Range", "bytes=" + this.tmp_file.length() + "-");
                } else if (this.tmp_file.exists()) {
                    this.tmp_file.delete();
                }
            }
            catch (NullPointerException e) {
                this.SetError(Error.CRIFSWEBINSTALLER_ERROR_MEMORY, this.task_internal_info.http_status_code);
                e.printStackTrace();
                return false;
            }
            catch (MalformedURLException e) {
                this.SetError(Error.CRIFSWEBINSTALLER_ERROR_DNS, this.task_internal_info.http_status_code);
                e.printStackTrace();
                return false;
            }
            catch (ProtocolException e) {
                this.SetError(Error.CRIFSWEBINSTALLER_ERROR_CONNECTION, this.task_internal_info.http_status_code);
                e.printStackTrace();
                return false;
            }
            catch (GeneralSecurityException e) {
                this.SetError(Error.CRIFSWEBINSTALLER_ERROR_SSL, this.task_internal_info.http_status_code);
                e.printStackTrace();
                return false;
            }
            catch (IOException e) {
                this.SetError(Error.CRIFSWEBINSTALLER_ERROR_INTERNAL, this.task_internal_info.http_status_code);
                CriFsWebInstaller.ErrorEntry(4);
                e.printStackTrace();
                return false;
            }
            return true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private boolean task_connect() {
            try {
                boolean is_ignored_range_request;
                int status_code = -1;
                long contents_size = -1L;
                this.http_connection.connect();
                status_code = this.http_connection.getResponseCode();
                boolean bl = is_ignored_range_request = this.task_internal_info.received_size > 0L && status_code == 200;
                if (is_ignored_range_request) {
                    this.SetError(Error.CRIFSWEBINSTALLER_ERROR_HTTP, -1);
                    CriFsWebInstaller.ErrorEntry(15);
                    return false;
                }
                if (status_code == 200) {
                    contents_size = this.http_connection.getContentLength();
                } else if (status_code == 206) {
                    contents_size = (long)this.http_connection.getContentLength() + this.task_internal_info.received_size;
                } else {
                    if (status_code >= 0) {
                        this.SetError(Error.CRIFSWEBINSTALLER_ERROR_HTTP, status_code);
                        return false;
                    }
                    this.SetError(Error.CRIFSWEBINSTALLER_ERROR_CONNECTION, -1);
                    return false;
                }
                WebInstallerTask webInstallerTask = this;
                synchronized (webInstallerTask) {
                    this.task_internal_info.http_status_code = status_code;
                    this.task_internal_info.contents_size = contents_size;
                }
            }
            catch (UnknownHostException e) {
                this.SetError(Error.CRIFSWEBINSTALLER_ERROR_CONNECTION, -1);
                return false;
            }
            catch (SocketException e) {
                this.SetError(Error.CRIFSWEBINSTALLER_ERROR_CONNECTION, -1);
                return false;
            }
            catch (SocketTimeoutException e) {
                this.SetError(Error.CRIFSWEBINSTALLER_ERROR_CONNECTION, -1);
                return false;
            }
            catch (SSLHandshakeException e) {
                this.SetError(Error.CRIFSWEBINSTALLER_ERROR_SSL, -1);
                return false;
            }
            catch (FileNotFoundException e) {
                this.SetError(Error.CRIFSWEBINSTALLER_ERROR_HTTP, -1);
                return false;
            }
            catch (SSLException e) {
                this.SetError(Error.CRIFSWEBINSTALLER_ERROR_SSL, -1);
                return false;
            }
            catch (IOException e) {
                this.SetError(Error.CRIFSWEBINSTALLER_ERROR_CONNECTION, -1);
                CriFsWebInstaller.ErrorEntry(5);
                e.printStackTrace();
                return false;
            }
            return true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private boolean task_copyfile() {
            try {
                InputStream in = this.http_connection.getInputStream();
                FileOutputStream out = new FileOutputStream(this.tmp_file, true);
                int bytesRead = -1;
                byte[] buffer = new byte[65536];
                while (!this.isCancelled()) {
                    try {
                        bytesRead = in.read(buffer);
                    }
                    catch (IOException e) {
                        this.SetError(Error.CRIFSWEBINSTALLER_ERROR_CONNECTION, -1);
                        break;
                    }
                    if (bytesRead == -1) break;
                    if (bytesRead == 0) {
                        try {
                            Thread.sleep(10L);
                        }
                        catch (InterruptedException e) {}
                        continue;
                    }
                    if (manager.crc_enabled) {
                        try {
                            CriFsWebInstaller.this.crc_num.update(buffer, 0, bytesRead);
                        }
                        catch (ArrayIndexOutOfBoundsException e) {
                            this.SetError(Error.CRIFSWEBINSTALLER_ERROR_INTERNAL, -1);
                            CriFsWebInstaller.ErrorEntry(13);
                            break;
                        }
                    }
                    try {
                        out.write(buffer, 0, bytesRead);
                    }
                    catch (IOException e) {
                        this.SetError(Error.CRIFSWEBINSTALLER_ERROR_LOCALFS, -1);
                        break;
                    }
                    WebInstallerTask e = this;
                    synchronized (e) {
                        this.task_internal_info.received_size += (long)bytesRead;
                    }
                }
                try {
                    in.close();
                }
                catch (IOException e) {
                    // empty catch block
                }
                try {
                    out.close();
                }
                catch (IOException e) {
                    // empty catch block
                }
                this.http_connection.disconnect();
                if (this.task_internal_info.error != Error.CRIFSWEBINSTALLER_ERROR_NONE) {
                    if (this.task_internal_info.error == Error.CRIFSWEBINSTALLER_ERROR_LOCALFS) {
                        this.tmp_file.delete();
                    }
                    boolean e = false;
                    return e;
                }
                if (this.isCancelled()) {
                    this.tmp_file.delete();
                    boolean e = false;
                    return e;
                }
                if (this.task_internal_info.received_size != this.task_internal_info.contents_size) {
                    this.tmp_file.delete();
                    this.SetError(Error.CRIFSWEBINSTALLER_ERROR_INTERNAL, -1);
                    CriFsWebInstaller.ErrorEntry(14);
                    boolean e = false;
                    return e;
                }
                File dst_file = new File(this.task_dst_path);
                if (dst_file.exists()) {
                    this.tmp_file.delete();
                    this.SetError(Error.CRIFSWEBINSTALLER_ERROR_LOCALFS, -1);
                    boolean bl = false;
                    return bl;
                }
                this.tmp_file.renameTo(dst_file);
            }
            catch (NullPointerException e) {
                this.SetError(Error.CRIFSWEBINSTALLER_ERROR_MEMORY, -1);
                boolean bl = false;
                return bl;
            }
            catch (SocketTimeoutException e) {
                this.SetError(Error.CRIFSWEBINSTALLER_ERROR_CONNECTION, -1);
                boolean bl = false;
                return bl;
            }
            catch (FileNotFoundException e) {
                this.SetError(Error.CRIFSWEBINSTALLER_ERROR_LOCALFS, -1);
                boolean bl = false;
                return bl;
            }
            catch (IOException e) {
                this.SetError(Error.CRIFSWEBINSTALLER_ERROR_INTERNAL, -1);
                CriFsWebInstaller.ErrorEntry(6);
                e.printStackTrace();
                boolean bl = false;
                return bl;
            }
            finally {
                this.http_connection.disconnect();
            }
            return true;
        }
    }

    public class TaskStatusInfo {
        TaskStatus status = TaskStatus.BUSY;
        Error error = Error.CRIFSWEBINSTALLER_ERROR_NONE;
        int http_status_code = -1;
        long contents_size = -1L;
        long received_size = 0L;

        TaskStatusInfo() {
        }
    }

    public static enum TaskStatus {
        BUSY,
        STOP,
        STOPPING;

    }

    public class AsyncTaskParam {
        String param_src_path;
        String param_dst_path;
        long param_contents_size;
        long param_received_size;

        AsyncTaskParam(String src_path, String dst_path, long contents_size, long received_size) {
            this.param_src_path = src_path;
            this.param_dst_path = dst_path;
            this.param_contents_size = contents_size;
            this.param_received_size = received_size;
        }
    }

    public class StatusInfo {
        Status status;
        Error error;
        int http_status_code;
        long contents_size;
        long received_size;
    }

    public static class Config {
        int num_installers;
        String proxy_host;
        short proxy_port;
        String user_agent;
        int inactive_timeout_sec;
        boolean allow_insecure_ssl;
        int max_request_fields;
        boolean crc_enabled;
    }

    public static enum Error {
        CRIFSWEBINSTALLER_ERROR_NONE(0),
        CRIFSWEBINSTALLER_ERROR_TIMEOUT(1),
        CRIFSWEBINSTALLER_ERROR_MEMORY(2),
        CRIFSWEBINSTALLER_ERROR_LOCALFS(3),
        CRIFSWEBINSTALLER_ERROR_DNS(4),
        CRIFSWEBINSTALLER_ERROR_CONNECTION(5),
        CRIFSWEBINSTALLER_ERROR_SSL(6),
        CRIFSWEBINSTALLER_ERROR_HTTP(7),
        CRIFSWEBINSTALLER_ERROR_INTERNAL(8);

        private int value;

        private Error(int value) {
            this.value = value;
        }

        public int getValue() {
            return this.value;
        }
    }

    public static enum Status {
        CRIFSWEBINSTALLER_STATUS_STOP(0),
        CRIFSWEBINSTALLER_STATUS_BUSY(1),
        CRIFSWEBINSTALLER_STATUS_COMPLETE(2),
        CRIFSWEBINSTALLER_STATUS_ERROR(3);

        private int value;

        private Status(int value) {
            this.value = value;
        }

        public int getValue() {
            return this.value;
        }
    }
}

