﻿/****************************************************************************
 *
 * CRI Middleware SDK
 *
 * Copyright (c) 2012-2023 CRI Middleware Co., Ltd.
 *
 * Library      : CRIWARE plugin for Unreal Engine
 * Module       : Function exporter
 * File         : CriWareApi.cpp
 * Generator    : CriWareExporterForUE4.exe (May  8 2023)
 * Date         : Fri May  8 19:56:50 2023
 *
 ****************************************************************************/

/***************************************************************************
 *      Include files
 ***************************************************************************/
#include "CriWareApi.h"
#include "CriWareCorePrivate.h"

/***************************************************************************
 *      Prototype Functions
 ***************************************************************************/
extern "C" CriBool CRIAPI criFs_IsInitialized(void);
extern "C" CriSint64 CRIAPI criAtomAsr_GetAudioTime(CriSint32);
extern "C" void CRIAPI criAtomPlayer_ForceStop(CriAtomPlayerHn);
extern "C" CriAtomExInputPortHn CRIAPI criAtomExInputPort_Create(const CriAtomExInputPortConfig*, void*, CriSint32);
extern "C" void CRIAPI criAtomExInputPort_Destroy(CriAtomExInputPortHn);
extern "C" void CRIAPI criAtomExPlayer_SetInputPort(CriAtomExPlayerHn, CriAtomExInputPortHn);

/***************************************************************************
 *      Class Definition
 ***************************************************************************/
criFs_IsInitialized_TYPE FCriWareApi::criFs_IsInitialized = ::criFs_IsInitialized;
criErr_ConvertIdToMessage_TYPE FCriWareApi::criErr_ConvertIdToMessage = ::criErr_ConvertIdToMessage;
criErr_SetCallback_TYPE FCriWareApi::criErr_SetCallback = ::criErr_SetCallback;
criErr_SetErrorNotificationLevel_TYPE FCriWareApi::criErr_SetErrorNotificationLevel = ::criErr_SetErrorNotificationLevel;
criErr_GetErrorCount_TYPE FCriWareApi::criErr_GetErrorCount = ::criErr_GetErrorCount;
criErr_ResetErrorCount_TYPE FCriWareApi::criErr_ResetErrorCount = ::criErr_ResetErrorCount;
criFs_SetUserMallocFunction_TYPE FCriWareApi::criFs_SetUserMallocFunction = ::criFs_SetUserMallocFunction;
criFs_SetUserFreeFunction_TYPE FCriWareApi::criFs_SetUserFreeFunction = ::criFs_SetUserFreeFunction;
criFs_GetNumUsedBinders_TYPE FCriWareApi::criFs_GetNumUsedBinders = ::criFs_GetNumUsedBinders;
criFs_SetSelectIoCallback_TYPE FCriWareApi::criFs_SetSelectIoCallback = ::criFs_SetSelectIoCallback;
criFs_ControlFileIoMode_TYPE FCriWareApi::criFs_ControlFileIoMode = ::criFs_ControlFileIoMode;
criFsBinder_Create_TYPE FCriWareApi::criFsBinder_Create = ::criFsBinder_Create;
criFsBinder_Destroy_TYPE FCriWareApi::criFsBinder_Destroy = ::criFsBinder_Destroy;
criFsBinder_BindFile_TYPE FCriWareApi::criFsBinder_BindFile = ::criFsBinder_BindFile;
criFsBinder_BindFileSection_TYPE FCriWareApi::criFsBinder_BindFileSection = ::criFsBinder_BindFileSection;
criFsBinder_GetStatus_TYPE FCriWareApi::criFsBinder_GetStatus = ::criFsBinder_GetStatus;
criFsStdio_OpenFile_TYPE FCriWareApi::criFsStdio_OpenFile = ::criFsStdio_OpenFile;
criFsStdio_CloseFile_TYPE FCriWareApi::criFsStdio_CloseFile = ::criFsStdio_CloseFile;
criFsStdio_GetFileSize_TYPE FCriWareApi::criFsStdio_GetFileSize = ::criFsStdio_GetFileSize;
criFsStdio_SeekFile_TYPE FCriWareApi::criFsStdio_SeekFile = ::criFsStdio_SeekFile;
criFsStdio_ReadFile_TYPE FCriWareApi::criFsStdio_ReadFile = ::criFsStdio_ReadFile;
criAtom_GetVersionNumber_TYPE FCriWareApi::criAtom_GetVersionNumber = ::criAtom_GetVersionNumber;
criAtom_IsInitialized_TYPE FCriWareApi::criAtom_IsInitialized = ::criAtom_IsInitialized;
criAtom_IsAudioOutputActive_TYPE FCriWareApi::criAtom_IsAudioOutputActive = ::criAtom_IsAudioOutputActive;
criAtom_ExecuteMain_TYPE FCriWareApi::criAtom_ExecuteMain = ::criAtom_ExecuteMain;
criAtom_ExecuteAudioProcess_TYPE FCriWareApi::criAtom_ExecuteAudioProcess = ::criAtom_ExecuteAudioProcess;
criAtom_SetUserMallocFunction_TYPE FCriWareApi::criAtom_SetUserMallocFunction = ::criAtom_SetUserMallocFunction;
criAtom_SetUserFreeFunction_TYPE FCriWareApi::criAtom_SetUserFreeFunction = ::criAtom_SetUserFreeFunction;
criAtom_SetAudioFrameStartCallback_TYPE FCriWareApi::criAtom_SetAudioFrameStartCallback = ::criAtom_SetAudioFrameStartCallback;
criAtom_SetAudioFrameEndCallback_TYPE FCriWareApi::criAtom_SetAudioFrameEndCallback = ::criAtom_SetAudioFrameEndCallback;
criAtom_Lock_TYPE FCriWareApi::criAtom_Lock = ::criAtom_Lock;
criAtom_Unlock_TYPE FCriWareApi::criAtom_Unlock = ::criAtom_Unlock;
criAtom_SetChannelMapping_TYPE FCriWareApi::criAtom_SetChannelMapping = ::criAtom_SetChannelMapping;
criAtom_AttachPerformanceMonitor_TYPE FCriWareApi::criAtom_AttachPerformanceMonitor = ::criAtom_AttachPerformanceMonitor;
criAtom_DetachPerformanceMonitor_TYPE FCriWareApi::criAtom_DetachPerformanceMonitor = ::criAtom_DetachPerformanceMonitor;
criAtom_ResetPerformanceMonitor_TYPE FCriWareApi::criAtom_ResetPerformanceMonitor = ::criAtom_ResetPerformanceMonitor;
criAtom_GetPerformanceInfo_TYPE FCriWareApi::criAtom_GetPerformanceInfo = ::criAtom_GetPerformanceInfo;
criAtom_CalculateAdxBitrate_TYPE FCriWareApi::criAtom_CalculateAdxBitrate = ::criAtom_CalculateAdxBitrate;
criAtom_CalculateHcaBitrate_TYPE FCriWareApi::criAtom_CalculateHcaBitrate = ::criAtom_CalculateHcaBitrate;
criAtom_CalculateHcaMxBitrate_TYPE FCriWareApi::criAtom_CalculateHcaMxBitrate = ::criAtom_CalculateHcaMxBitrate;
criAtom_GetStreamingInfo_TYPE FCriWareApi::criAtom_GetStreamingInfo = ::criAtom_GetStreamingInfo;
criAtom_SetFreeTimeBufferingFlagForDefaultDevice_TYPE FCriWareApi::criAtom_SetFreeTimeBufferingFlagForDefaultDevice = ::criAtom_SetFreeTimeBufferingFlagForDefaultDevice;
criAtomHcaMx_CalculateWorkSize_TYPE FCriWareApi::criAtomHcaMx_CalculateWorkSize = ::criAtomHcaMx_CalculateWorkSize;
criAtomHcaMx_SetConfigForWorkSizeCalculation_TYPE FCriWareApi::criAtomHcaMx_SetConfigForWorkSizeCalculation = ::criAtomHcaMx_SetConfigForWorkSizeCalculation;
criAtomHcaMx_Initialize_TYPE FCriWareApi::criAtomHcaMx_Initialize = ::criAtomHcaMx_Initialize;
criAtomHcaMx_Finalize_TYPE FCriWareApi::criAtomHcaMx_Finalize = ::criAtomHcaMx_Finalize;
criAtomHcaMx_SetBusSendLevelByName_TYPE FCriWareApi::criAtomHcaMx_SetBusSendLevelByName = ::criAtomHcaMx_SetBusSendLevelByName;
criAtomHcaMx_SetFrequencyRatio_TYPE FCriWareApi::criAtomHcaMx_SetFrequencyRatio = ::criAtomHcaMx_SetFrequencyRatio;
criAtomAwb_CalculateWorkSizeForLoadToc_TYPE FCriWareApi::criAtomAwb_CalculateWorkSizeForLoadToc = ::criAtomAwb_CalculateWorkSizeForLoadToc;
criAtomAwb_LoadToc_TYPE FCriWareApi::criAtomAwb_LoadToc = ::criAtomAwb_LoadToc;
criAtomAwb_LoadTocById_TYPE FCriWareApi::criAtomAwb_LoadTocById = ::criAtomAwb_LoadTocById;
criAtomAwb_LoadTocAsync_TYPE FCriWareApi::criAtomAwb_LoadTocAsync = ::criAtomAwb_LoadTocAsync;
criAtomAwb_LoadTocAsyncById_TYPE FCriWareApi::criAtomAwb_LoadTocAsyncById = ::criAtomAwb_LoadTocAsyncById;
criAtomAwb_LoadFromMemory_TYPE FCriWareApi::criAtomAwb_LoadFromMemory = ::criAtomAwb_LoadFromMemory;
criAtomAwb_GetType_TYPE FCriWareApi::criAtomAwb_GetType = ::criAtomAwb_GetType;
criAtomAwb_GetWaveFileInfo_TYPE FCriWareApi::criAtomAwb_GetWaveFileInfo = ::criAtomAwb_GetWaveFileInfo;
criAtomAwb_GetWaveDataInfo_TYPE FCriWareApi::criAtomAwb_GetWaveDataInfo = ::criAtomAwb_GetWaveDataInfo;
criAtomAwb_GetNumContents_TYPE FCriWareApi::criAtomAwb_GetNumContents = ::criAtomAwb_GetNumContents;
criAtomAwb_Release_TYPE FCriWareApi::criAtomAwb_Release = ::criAtomAwb_Release;
criAtomAwb_IsReadyToRelease_TYPE FCriWareApi::criAtomAwb_IsReadyToRelease = ::criAtomAwb_IsReadyToRelease;
criAtomAwb_GetStatus_TYPE FCriWareApi::criAtomAwb_GetStatus = ::criAtomAwb_GetStatus;
criAtomAwb_GetIdByIndex_TYPE FCriWareApi::criAtomAwb_GetIdByIndex = ::criAtomAwb_GetIdByIndex;
criAtomPlayer_CalculateWorkSizeForStandardPlayer_TYPE FCriWareApi::criAtomPlayer_CalculateWorkSizeForStandardPlayer = ::criAtomPlayer_CalculateWorkSizeForStandardPlayer;
criAtomPlayer_CreateStandardPlayer_TYPE FCriWareApi::criAtomPlayer_CreateStandardPlayer = ::criAtomPlayer_CreateStandardPlayer;
criAtomPlayer_CalculateWorkSizeForAdxPlayer_TYPE FCriWareApi::criAtomPlayer_CalculateWorkSizeForAdxPlayer = ::criAtomPlayer_CalculateWorkSizeForAdxPlayer;
criAtomPlayer_CreateAdxPlayer_TYPE FCriWareApi::criAtomPlayer_CreateAdxPlayer = ::criAtomPlayer_CreateAdxPlayer;
criAtomPlayer_CalculateWorkSizeForHcaPlayer_TYPE FCriWareApi::criAtomPlayer_CalculateWorkSizeForHcaPlayer = ::criAtomPlayer_CalculateWorkSizeForHcaPlayer;
criAtomPlayer_CreateHcaPlayer_TYPE FCriWareApi::criAtomPlayer_CreateHcaPlayer = ::criAtomPlayer_CreateHcaPlayer;
criAtomPlayer_CalculateWorkSizeForHcaMxPlayer_TYPE FCriWareApi::criAtomPlayer_CalculateWorkSizeForHcaMxPlayer = ::criAtomPlayer_CalculateWorkSizeForHcaMxPlayer;
criAtomPlayer_CreateHcaMxPlayer_TYPE FCriWareApi::criAtomPlayer_CreateHcaMxPlayer = ::criAtomPlayer_CreateHcaMxPlayer;
criAtomPlayer_CalculateWorkSizeForWavePlayer_TYPE FCriWareApi::criAtomPlayer_CalculateWorkSizeForWavePlayer = ::criAtomPlayer_CalculateWorkSizeForWavePlayer;
criAtomPlayer_CreateWavePlayer_TYPE FCriWareApi::criAtomPlayer_CreateWavePlayer = ::criAtomPlayer_CreateWavePlayer;
criAtomPlayer_CalculateWorkSizeForAiffPlayer_TYPE FCriWareApi::criAtomPlayer_CalculateWorkSizeForAiffPlayer = ::criAtomPlayer_CalculateWorkSizeForAiffPlayer;
criAtomPlayer_CreateAiffPlayer_TYPE FCriWareApi::criAtomPlayer_CreateAiffPlayer = ::criAtomPlayer_CreateAiffPlayer;
criAtomPlayer_CalculateWorkSizeForRawPcmPlayer_TYPE FCriWareApi::criAtomPlayer_CalculateWorkSizeForRawPcmPlayer = ::criAtomPlayer_CalculateWorkSizeForRawPcmPlayer;
criAtomPlayer_CreateRawPcmPlayer_TYPE FCriWareApi::criAtomPlayer_CreateRawPcmPlayer = ::criAtomPlayer_CreateRawPcmPlayer;
criAtomPlayer_Destroy_TYPE FCriWareApi::criAtomPlayer_Destroy = ::criAtomPlayer_Destroy;
criAtomPlayer_SetData_TYPE FCriWareApi::criAtomPlayer_SetData = ::criAtomPlayer_SetData;
criAtomPlayer_SetFile_TYPE FCriWareApi::criAtomPlayer_SetFile = ::criAtomPlayer_SetFile;
criAtomPlayer_SetContentId_TYPE FCriWareApi::criAtomPlayer_SetContentId = ::criAtomPlayer_SetContentId;
criAtomPlayer_SetWaveId_TYPE FCriWareApi::criAtomPlayer_SetWaveId = ::criAtomPlayer_SetWaveId;
criAtomPlayer_SetPreviousDataAgain_TYPE FCriWareApi::criAtomPlayer_SetPreviousDataAgain = ::criAtomPlayer_SetPreviousDataAgain;
criAtomPlayer_DeferCallback_TYPE FCriWareApi::criAtomPlayer_DeferCallback = ::criAtomPlayer_DeferCallback;
criAtomPlayer_Start_TYPE FCriWareApi::criAtomPlayer_Start = ::criAtomPlayer_Start;
criAtomPlayer_Stop_TYPE FCriWareApi::criAtomPlayer_Stop = ::criAtomPlayer_Stop;
criAtomPlayer_ForceStop_TYPE FCriWareApi::criAtomPlayer_ForceStop = ::criAtomPlayer_ForceStop;
criAtomPlayer_Pause_TYPE FCriWareApi::criAtomPlayer_Pause = ::criAtomPlayer_Pause;
criAtomPlayer_IsPaused_TYPE FCriWareApi::criAtomPlayer_IsPaused = ::criAtomPlayer_IsPaused;
criAtomPlayer_GetStatus_TYPE FCriWareApi::criAtomPlayer_GetStatus = ::criAtomPlayer_GetStatus;
criAtomPlayer_GetNumChannels_TYPE FCriWareApi::criAtomPlayer_GetNumChannels = ::criAtomPlayer_GetNumChannels;
criAtomPlayer_GetNumPlayedSamples_TYPE FCriWareApi::criAtomPlayer_GetNumPlayedSamples = ::criAtomPlayer_GetNumPlayedSamples;
criAtomPlayer_GetDecodedDataSize_TYPE FCriWareApi::criAtomPlayer_GetDecodedDataSize = ::criAtomPlayer_GetDecodedDataSize;
criAtomPlayer_GetNumDecodedSamples_TYPE FCriWareApi::criAtomPlayer_GetNumDecodedSamples = ::criAtomPlayer_GetNumDecodedSamples;
criAtomPlayer_GetTime_TYPE FCriWareApi::criAtomPlayer_GetTime = ::criAtomPlayer_GetTime;
criAtomPlayer_GetFormatInfo_TYPE FCriWareApi::criAtomPlayer_GetFormatInfo = ::criAtomPlayer_GetFormatInfo;
criAtomPlayer_GetInputBufferRemainSize_TYPE FCriWareApi::criAtomPlayer_GetInputBufferRemainSize = ::criAtomPlayer_GetInputBufferRemainSize;
criAtomPlayer_GetOutputBufferRemainSamples_TYPE FCriWareApi::criAtomPlayer_GetOutputBufferRemainSamples = ::criAtomPlayer_GetOutputBufferRemainSamples;
criAtomPlayer_SetStartTime_TYPE FCriWareApi::criAtomPlayer_SetStartTime = ::criAtomPlayer_SetStartTime;
criAtomPlayer_SetVolume_TYPE FCriWareApi::criAtomPlayer_SetVolume = ::criAtomPlayer_SetVolume;
criAtomPlayer_GetVolume_TYPE FCriWareApi::criAtomPlayer_GetVolume = ::criAtomPlayer_GetVolume;
criAtomPlayer_SetChannelVolume_TYPE FCriWareApi::criAtomPlayer_SetChannelVolume = ::criAtomPlayer_SetChannelVolume;
criAtomPlayer_SetSendLevel_TYPE FCriWareApi::criAtomPlayer_SetSendLevel = ::criAtomPlayer_SetSendLevel;
criAtomPlayer_ResetSendLevel_TYPE FCriWareApi::criAtomPlayer_ResetSendLevel = ::criAtomPlayer_ResetSendLevel;
criAtomPlayer_SetPanAdx1Compatible_TYPE FCriWareApi::criAtomPlayer_SetPanAdx1Compatible = ::criAtomPlayer_SetPanAdx1Compatible;
criAtomPlayer_ResetPan_TYPE FCriWareApi::criAtomPlayer_ResetPan = ::criAtomPlayer_ResetPan;
criAtomPlayer_SetFrequencyRatio_TYPE FCriWareApi::criAtomPlayer_SetFrequencyRatio = ::criAtomPlayer_SetFrequencyRatio;
criAtomPlayer_SetMaxFrequencyRatio_TYPE FCriWareApi::criAtomPlayer_SetMaxFrequencyRatio = ::criAtomPlayer_SetMaxFrequencyRatio;
criAtomPlayer_LimitLoopCount_TYPE FCriWareApi::criAtomPlayer_LimitLoopCount = ::criAtomPlayer_LimitLoopCount;
criAtomPlayer_SetHcaMxMixerId_TYPE FCriWareApi::criAtomPlayer_SetHcaMxMixerId = ::criAtomPlayer_SetHcaMxMixerId;
criAtomPlayer_SetAsrRackId_TYPE FCriWareApi::criAtomPlayer_SetAsrRackId = ::criAtomPlayer_SetAsrRackId;
criAtomPlayer_SetRawPcmFormat_TYPE FCriWareApi::criAtomPlayer_SetRawPcmFormat = ::criAtomPlayer_SetRawPcmFormat;
criAtomPlayer_SetDataRequestCallback_TYPE FCriWareApi::criAtomPlayer_SetDataRequestCallback = ::criAtomPlayer_SetDataRequestCallback;
criAtomPlayer_SetStatusChangeCallback_TYPE FCriWareApi::criAtomPlayer_SetStatusChangeCallback = ::criAtomPlayer_SetStatusChangeCallback;
criAtomPlayer_SetParameterChangeCallback_TYPE FCriWareApi::criAtomPlayer_SetParameterChangeCallback = ::criAtomPlayer_SetParameterChangeCallback;
criAtomPlayer_SetFilterCallback_TYPE FCriWareApi::criAtomPlayer_SetFilterCallback = ::criAtomPlayer_SetFilterCallback;
criAtomPlayer_SetLoadRequestCallback_TYPE FCriWareApi::criAtomPlayer_SetLoadRequestCallback = ::criAtomPlayer_SetLoadRequestCallback;
criAtomDbas_CalculateWorkSize_TYPE FCriWareApi::criAtomDbas_CalculateWorkSize = ::criAtomDbas_CalculateWorkSize;
criAtomDbas_Create_TYPE FCriWareApi::criAtomDbas_Create = ::criAtomDbas_Create;
criAtomDbas_Destroy_TYPE FCriWareApi::criAtomDbas_Destroy = ::criAtomDbas_Destroy;
criAtomDbas_GetStreamingPlayerHandles_TYPE FCriWareApi::criAtomDbas_GetStreamingPlayerHandles = ::criAtomDbas_GetStreamingPlayerHandles;
criAtomStreamingCache_CalculateWorkSize_TYPE FCriWareApi::criAtomStreamingCache_CalculateWorkSize = ::criAtomStreamingCache_CalculateWorkSize;
criAtomStreamingCache_Create_TYPE FCriWareApi::criAtomStreamingCache_Create = ::criAtomStreamingCache_Create;
criAtomStreamingCache_Destroy_TYPE FCriWareApi::criAtomStreamingCache_Destroy = ::criAtomStreamingCache_Destroy;
criAtomStreamingCache_Clear_TYPE FCriWareApi::criAtomStreamingCache_Clear = ::criAtomStreamingCache_Clear;
criAtomStreamingCache_IsCachedWaveId_TYPE FCriWareApi::criAtomStreamingCache_IsCachedWaveId = ::criAtomStreamingCache_IsCachedWaveId;
criAtomStreamingCache_IsCachedFile_TYPE FCriWareApi::criAtomStreamingCache_IsCachedFile = ::criAtomStreamingCache_IsCachedFile;
criAtomMeter_CalculateWorkSizeForLevelMeter_TYPE FCriWareApi::criAtomMeter_CalculateWorkSizeForLevelMeter = ::criAtomMeter_CalculateWorkSizeForLevelMeter;
criAtomMeter_AttachLevelMeter_TYPE FCriWareApi::criAtomMeter_AttachLevelMeter = ::criAtomMeter_AttachLevelMeter;
criAtomMeter_DetachLevelMeter_TYPE FCriWareApi::criAtomMeter_DetachLevelMeter = ::criAtomMeter_DetachLevelMeter;
criAtomMeter_GetLevelInfo_TYPE FCriWareApi::criAtomMeter_GetLevelInfo = ::criAtomMeter_GetLevelInfo;
criAtomMeter_CalculateWorkSizeForLoudnessMeter_TYPE FCriWareApi::criAtomMeter_CalculateWorkSizeForLoudnessMeter = ::criAtomMeter_CalculateWorkSizeForLoudnessMeter;
criAtomMeter_AttachLoudnessMeter_TYPE FCriWareApi::criAtomMeter_AttachLoudnessMeter = ::criAtomMeter_AttachLoudnessMeter;
criAtomMeter_DetachLoudnessMeter_TYPE FCriWareApi::criAtomMeter_DetachLoudnessMeter = ::criAtomMeter_DetachLoudnessMeter;
criAtomMeter_GetLoudnessInfo_TYPE FCriWareApi::criAtomMeter_GetLoudnessInfo = ::criAtomMeter_GetLoudnessInfo;
criAtomMeter_ResetLoudnessMeter_TYPE FCriWareApi::criAtomMeter_ResetLoudnessMeter = ::criAtomMeter_ResetLoudnessMeter;
criAtomMeter_CalculateWorkSizeForTruePeakMeter_TYPE FCriWareApi::criAtomMeter_CalculateWorkSizeForTruePeakMeter = ::criAtomMeter_CalculateWorkSizeForTruePeakMeter;
criAtomMeter_AttachTruePeakMeter_TYPE FCriWareApi::criAtomMeter_AttachTruePeakMeter = ::criAtomMeter_AttachTruePeakMeter;
criAtomMeter_DetachTruePeakMeter_TYPE FCriWareApi::criAtomMeter_DetachTruePeakMeter = ::criAtomMeter_DetachTruePeakMeter;
criAtomMeter_GetTruePeakInfo_TYPE FCriWareApi::criAtomMeter_GetTruePeakInfo = ::criAtomMeter_GetTruePeakInfo;
criAtomInstrument_RegisterInstrumentInterface_TYPE FCriWareApi::criAtomInstrument_RegisterInstrumentInterface = ::criAtomInstrument_RegisterInstrumentInterface;
criAtomInstrument_UnregisterInstrumentInterface_TYPE FCriWareApi::criAtomInstrument_UnregisterInstrumentInterface = ::criAtomInstrument_UnregisterInstrumentInterface;
criAtomPlayer_SetDecodeCallback_TYPE FCriWareApi::criAtomPlayer_SetDecodeCallback = ::criAtomPlayer_SetDecodeCallback;
criAtomPlayer_DiscardSamples_TYPE FCriWareApi::criAtomPlayer_DiscardSamples = ::criAtomPlayer_DiscardSamples;
criAtomExAsr_CalculateWorkSize_TYPE FCriWareApi::criAtomExAsr_CalculateWorkSize = ::criAtomExAsr_CalculateWorkSize;
criAtomExAsr_SetConfigForWorkSizeCalculation_TYPE FCriWareApi::criAtomExAsr_SetConfigForWorkSizeCalculation = ::criAtomExAsr_SetConfigForWorkSizeCalculation;
criAtomExAsr_Initialize_TYPE FCriWareApi::criAtomExAsr_Initialize = ::criAtomExAsr_Initialize;
criAtomExAsr_Finalize_TYPE FCriWareApi::criAtomExAsr_Finalize = ::criAtomExAsr_Finalize;
criAtomExAsr_EnableBinauralizer_TYPE FCriWareApi::criAtomExAsr_EnableBinauralizer = ::criAtomExAsr_EnableBinauralizer;
criAtomExAsr_SetBusVolumeByName_TYPE FCriWareApi::criAtomExAsr_SetBusVolumeByName = ::criAtomExAsr_SetBusVolumeByName;
criAtomExAsr_GetBusVolumeByName_TYPE FCriWareApi::criAtomExAsr_GetBusVolumeByName = ::criAtomExAsr_GetBusVolumeByName;
criAtomExAsr_SetBusPan3dByName_TYPE FCriWareApi::criAtomExAsr_SetBusPan3dByName = ::criAtomExAsr_SetBusPan3dByName;
criAtomExAsr_GetBusPan3dByName_TYPE FCriWareApi::criAtomExAsr_GetBusPan3dByName = ::criAtomExAsr_GetBusPan3dByName;
criAtomExAsr_SetBusMatrixByName_TYPE FCriWareApi::criAtomExAsr_SetBusMatrixByName = ::criAtomExAsr_SetBusMatrixByName;
criAtomExAsr_SetBusSendLevelByName_TYPE FCriWareApi::criAtomExAsr_SetBusSendLevelByName = ::criAtomExAsr_SetBusSendLevelByName;
criAtomExAsr_SetEffectParameter_TYPE FCriWareApi::criAtomExAsr_SetEffectParameter = ::criAtomExAsr_SetEffectParameter;
criAtomExAsr_UpdateEffectParameters_TYPE FCriWareApi::criAtomExAsr_UpdateEffectParameters = ::criAtomExAsr_UpdateEffectParameters;
criAtomExAsr_GetEffectParameter_TYPE FCriWareApi::criAtomExAsr_GetEffectParameter = ::criAtomExAsr_GetEffectParameter;
criAtomExAsr_SetEffectBypass_TYPE FCriWareApi::criAtomExAsr_SetEffectBypass = ::criAtomExAsr_SetEffectBypass;
criAtomExAsr_AttachBusAnalyzerByName_TYPE FCriWareApi::criAtomExAsr_AttachBusAnalyzerByName = ::criAtomExAsr_AttachBusAnalyzerByName;
criAtomExAsr_DetachBusAnalyzerByName_TYPE FCriWareApi::criAtomExAsr_DetachBusAnalyzerByName = ::criAtomExAsr_DetachBusAnalyzerByName;
criAtomExAsr_GetBusAnalyzerInfoByName_TYPE FCriWareApi::criAtomExAsr_GetBusAnalyzerInfoByName = ::criAtomExAsr_GetBusAnalyzerInfoByName;
criAtomExAsr_SetBusFilterCallbackByName_TYPE FCriWareApi::criAtomExAsr_SetBusFilterCallbackByName = ::criAtomExAsr_SetBusFilterCallbackByName;
criAtomExAsr_GetNumBuses_TYPE FCriWareApi::criAtomExAsr_GetNumBuses = ::criAtomExAsr_GetNumBuses;
criAtomExAsr_RegisterEffectInterface_TYPE FCriWareApi::criAtomExAsr_RegisterEffectInterface = ::criAtomExAsr_RegisterEffectInterface;
criAtomExAsr_UnregisterEffectInterface_TYPE FCriWareApi::criAtomExAsr_UnregisterEffectInterface = ::criAtomExAsr_UnregisterEffectInterface;
criAtomExAsr_RegisterSoundxRInterface_TYPE FCriWareApi::criAtomExAsr_RegisterSoundxRInterface = ::criAtomExAsr_RegisterSoundxRInterface;
criAtomExAsrRack_CalculateWorkSize_TYPE FCriWareApi::criAtomExAsrRack_CalculateWorkSize = ::criAtomExAsrRack_CalculateWorkSize;
criAtomExAsrRack_CalculateWorkSizeForDspBusSettingFromConfig_TYPE FCriWareApi::criAtomExAsrRack_CalculateWorkSizeForDspBusSettingFromConfig = ::criAtomExAsrRack_CalculateWorkSizeForDspBusSettingFromConfig;
criAtomExAsrRack_CalculateWorkSizeForDspBusSettingFromAcfDataAndConfig_TYPE FCriWareApi::criAtomExAsrRack_CalculateWorkSizeForDspBusSettingFromAcfDataAndConfig = ::criAtomExAsrRack_CalculateWorkSizeForDspBusSettingFromAcfDataAndConfig;
criAtomExAsrRack_Create_TYPE FCriWareApi::criAtomExAsrRack_Create = ::criAtomExAsrRack_Create;
criAtomExAsrRack_Destroy_TYPE FCriWareApi::criAtomExAsrRack_Destroy = ::criAtomExAsrRack_Destroy;
criAtomExAsrRack_CalculateWorkSizeForDspBusSetting_TYPE FCriWareApi::criAtomExAsrRack_CalculateWorkSizeForDspBusSetting = ::criAtomExAsrRack_CalculateWorkSizeForDspBusSetting;
criAtomExAsrRack_AttachDspBusSetting_TYPE FCriWareApi::criAtomExAsrRack_AttachDspBusSetting = ::criAtomExAsrRack_AttachDspBusSetting;
criAtomExAsrRack_DetachDspBusSetting_TYPE FCriWareApi::criAtomExAsrRack_DetachDspBusSetting = ::criAtomExAsrRack_DetachDspBusSetting;
criAtomExAsrRack_ApplyDspBusSnapshot_TYPE FCriWareApi::criAtomExAsrRack_ApplyDspBusSnapshot = ::criAtomExAsrRack_ApplyDspBusSnapshot;
criAtomExAsrRack_GetAppliedDspBusSnapshotName_TYPE FCriWareApi::criAtomExAsrRack_GetAppliedDspBusSnapshotName = ::criAtomExAsrRack_GetAppliedDspBusSnapshotName;
criAtomExAsrRack_SetBusVolumeByName_TYPE FCriWareApi::criAtomExAsrRack_SetBusVolumeByName = ::criAtomExAsrRack_SetBusVolumeByName;
criAtomExAsrRack_GetBusVolumeByName_TYPE FCriWareApi::criAtomExAsrRack_GetBusVolumeByName = ::criAtomExAsrRack_GetBusVolumeByName;
criAtomExAsrRack_SetBusPanInfoByName_TYPE FCriWareApi::criAtomExAsrRack_SetBusPanInfoByName = ::criAtomExAsrRack_SetBusPanInfoByName;
criAtomExAsrRack_GetBusPanInfoByName_TYPE FCriWareApi::criAtomExAsrRack_GetBusPanInfoByName = ::criAtomExAsrRack_GetBusPanInfoByName;
criAtomExAsrRack_SetBusMatrixByName_TYPE FCriWareApi::criAtomExAsrRack_SetBusMatrixByName = ::criAtomExAsrRack_SetBusMatrixByName;
criAtomExAsrRack_SetBusSendLevelByName_TYPE FCriWareApi::criAtomExAsrRack_SetBusSendLevelByName = ::criAtomExAsrRack_SetBusSendLevelByName;
criAtomExAsrRack_SetEffectParameter_TYPE FCriWareApi::criAtomExAsrRack_SetEffectParameter = ::criAtomExAsrRack_SetEffectParameter;
criAtomExAsrRack_UpdateEffectParameters_TYPE FCriWareApi::criAtomExAsrRack_UpdateEffectParameters = ::criAtomExAsrRack_UpdateEffectParameters;
criAtomExAsrRack_GetEffectParameter_TYPE FCriWareApi::criAtomExAsrRack_GetEffectParameter = ::criAtomExAsrRack_GetEffectParameter;
criAtomExAsrRack_SetEffectBypass_TYPE FCriWareApi::criAtomExAsrRack_SetEffectBypass = ::criAtomExAsrRack_SetEffectBypass;
criAtomExAsrRack_GetEffectBypass_TYPE FCriWareApi::criAtomExAsrRack_GetEffectBypass = ::criAtomExAsrRack_GetEffectBypass;
criAtomExAsrRack_AttachBusAnalyzerByName_TYPE FCriWareApi::criAtomExAsrRack_AttachBusAnalyzerByName = ::criAtomExAsrRack_AttachBusAnalyzerByName;
criAtomExAsrRack_DetachBusAnalyzerByName_TYPE FCriWareApi::criAtomExAsrRack_DetachBusAnalyzerByName = ::criAtomExAsrRack_DetachBusAnalyzerByName;
criAtomExAsrRack_GetBusAnalyzerInfoByName_TYPE FCriWareApi::criAtomExAsrRack_GetBusAnalyzerInfoByName = ::criAtomExAsrRack_GetBusAnalyzerInfoByName;
criAtomExAsrRack_SetBusFilterCallbackByName_TYPE FCriWareApi::criAtomExAsrRack_SetBusFilterCallbackByName = ::criAtomExAsrRack_SetBusFilterCallbackByName;
criAtomExAsrRack_SetAlternateRackId_TYPE FCriWareApi::criAtomExAsrRack_SetAlternateRackId = ::criAtomExAsrRack_SetAlternateRackId;
criAtomExAsrRack_GetNumBuses_TYPE FCriWareApi::criAtomExAsrRack_GetNumBuses = ::criAtomExAsrRack_GetNumBuses;
criAtomExAsrRack_GetPcmDataFloat32_TYPE FCriWareApi::criAtomExAsrRack_GetPcmDataFloat32 = ::criAtomExAsrRack_GetPcmDataFloat32;
criAtomExAsrRack_GetNumBufferedSamples_TYPE FCriWareApi::criAtomExAsrRack_GetNumBufferedSamples = ::criAtomExAsrRack_GetNumBufferedSamples;
criAtomExAsrRack_GetAmplitudeAnalyzerRms_TYPE FCriWareApi::criAtomExAsrRack_GetAmplitudeAnalyzerRms = ::criAtomExAsrRack_GetAmplitudeAnalyzerRms;
criAtomExAsrRack_GetAmplitudeAnalyzerRmsByName_TYPE FCriWareApi::criAtomExAsrRack_GetAmplitudeAnalyzerRmsByName = ::criAtomExAsrRack_GetAmplitudeAnalyzerRmsByName;
criAtomExAsrRack_GetCompressorGain_TYPE FCriWareApi::criAtomExAsrRack_GetCompressorGain = ::criAtomExAsrRack_GetCompressorGain;
criAtomExAsrRack_GetCompressorGainByName_TYPE FCriWareApi::criAtomExAsrRack_GetCompressorGainByName = ::criAtomExAsrRack_GetCompressorGainByName;
criAtomExAsrRack_GetCompressorRms_TYPE FCriWareApi::criAtomExAsrRack_GetCompressorRms = ::criAtomExAsrRack_GetCompressorRms;
criAtomExAsrRack_GetCompressorRmsByName_TYPE FCriWareApi::criAtomExAsrRack_GetCompressorRmsByName = ::criAtomExAsrRack_GetCompressorRmsByName;
criAtomAsr_CalculateWorkSize_TYPE FCriWareApi::criAtomAsr_CalculateWorkSize = ::criAtomAsr_CalculateWorkSize;
criAtomAsr_Initialize_TYPE FCriWareApi::criAtomAsr_Initialize = ::criAtomAsr_Initialize;
criAtomAsr_Finalize_TYPE FCriWareApi::criAtomAsr_Finalize = ::criAtomAsr_Finalize;
criAtomExAsr_PauseOutputVoice_TYPE FCriWareApi::criAtomExAsr_PauseOutputVoice = ::criAtomExAsr_PauseOutputVoice;
criAtomExAsrRack_GetNumOutputSamples_TYPE FCriWareApi::criAtomExAsrRack_GetNumOutputSamples = ::criAtomExAsrRack_GetNumOutputSamples;
criAtomExAsrRack_GetBusNumber_TYPE FCriWareApi::criAtomExAsrRack_GetBusNumber = ::criAtomExAsrRack_GetBusNumber;
criAtomAsr_PauseOutputVoice_TYPE FCriWareApi::criAtomAsr_PauseOutputVoice = ::criAtomAsr_PauseOutputVoice;
criAtomAsr_GetAudioTime_TYPE FCriWareApi::criAtomAsr_GetAudioTime = ::criAtomAsr_GetAudioTime;
criAtomExAsrRack_GetAmbisonicRackId_TYPE FCriWareApi::criAtomExAsrRack_GetAmbisonicRackId = ::criAtomExAsrRack_GetAmbisonicRackId;
criAtomExAsrRack_GetChannelBasedAudioRackId_TYPE FCriWareApi::criAtomExAsrRack_GetChannelBasedAudioRackId = ::criAtomExAsrRack_GetChannelBasedAudioRackId;
criAtomExAsrRack_GetObjectBasedAudioRackId_TYPE FCriWareApi::criAtomExAsrRack_GetObjectBasedAudioRackId = ::criAtomExAsrRack_GetObjectBasedAudioRackId;
criAtomExAsr_SetDspParameter_TYPE FCriWareApi::criAtomExAsr_SetDspParameter = ::criAtomExAsr_SetDspParameter;
criAtomExAsr_SetDspParameterByName_TYPE FCriWareApi::criAtomExAsr_SetDspParameterByName = ::criAtomExAsr_SetDspParameterByName;
criAtomExAsr_GetDspParameter_TYPE FCriWareApi::criAtomExAsr_GetDspParameter = ::criAtomExAsr_GetDspParameter;
criAtomExAsr_GetDspParameterByName_TYPE FCriWareApi::criAtomExAsr_GetDspParameterByName = ::criAtomExAsr_GetDspParameterByName;
criAtomExAsr_SetDspBypass_TYPE FCriWareApi::criAtomExAsr_SetDspBypass = ::criAtomExAsr_SetDspBypass;
criAtomExAsr_SetDspBypassByName_TYPE FCriWareApi::criAtomExAsr_SetDspBypassByName = ::criAtomExAsr_SetDspBypassByName;
criAtomExAsr_SetBusVolume_TYPE FCriWareApi::criAtomExAsr_SetBusVolume = ::criAtomExAsr_SetBusVolume;
criAtomExAsr_GetBusVolume_TYPE FCriWareApi::criAtomExAsr_GetBusVolume = ::criAtomExAsr_GetBusVolume;
criAtomExAsr_SetBusPan3d_TYPE FCriWareApi::criAtomExAsr_SetBusPan3d = ::criAtomExAsr_SetBusPan3d;
criAtomExAsr_GetBusPan3d_TYPE FCriWareApi::criAtomExAsr_GetBusPan3d = ::criAtomExAsr_GetBusPan3d;
criAtomExAsr_SetBusMatrix_TYPE FCriWareApi::criAtomExAsr_SetBusMatrix = ::criAtomExAsr_SetBusMatrix;
criAtomExAsr_SetBusSendLevel_TYPE FCriWareApi::criAtomExAsr_SetBusSendLevel = ::criAtomExAsr_SetBusSendLevel;
criAtomExAsr_AttachBusAnalyzer_TYPE FCriWareApi::criAtomExAsr_AttachBusAnalyzer = ::criAtomExAsr_AttachBusAnalyzer;
criAtomExAsr_DetachBusAnalyzer_TYPE FCriWareApi::criAtomExAsr_DetachBusAnalyzer = ::criAtomExAsr_DetachBusAnalyzer;
criAtomExAsr_GetBusAnalyzerInfo_TYPE FCriWareApi::criAtomExAsr_GetBusAnalyzerInfo = ::criAtomExAsr_GetBusAnalyzerInfo;
criAtomExAsr_SetBusFilterCallback_TYPE FCriWareApi::criAtomExAsr_SetBusFilterCallback = ::criAtomExAsr_SetBusFilterCallback;
criAtomExAsrRack_SetDspParameter_TYPE FCriWareApi::criAtomExAsrRack_SetDspParameter = ::criAtomExAsrRack_SetDspParameter;
criAtomExAsrRack_SetDspParameterByName_TYPE FCriWareApi::criAtomExAsrRack_SetDspParameterByName = ::criAtomExAsrRack_SetDspParameterByName;
criAtomExAsrRack_GetDspParameter_TYPE FCriWareApi::criAtomExAsrRack_GetDspParameter = ::criAtomExAsrRack_GetDspParameter;
criAtomExAsrRack_GetDspParameterByName_TYPE FCriWareApi::criAtomExAsrRack_GetDspParameterByName = ::criAtomExAsrRack_GetDspParameterByName;
criAtomExAsrRack_SetDspBypass_TYPE FCriWareApi::criAtomExAsrRack_SetDspBypass = ::criAtomExAsrRack_SetDspBypass;
criAtomExAsrRack_SetDspBypassByName_TYPE FCriWareApi::criAtomExAsrRack_SetDspBypassByName = ::criAtomExAsrRack_SetDspBypassByName;
criAtomExAsrRack_SetBusVolume_TYPE FCriWareApi::criAtomExAsrRack_SetBusVolume = ::criAtomExAsrRack_SetBusVolume;
criAtomExAsrRack_GetBusVolume_TYPE FCriWareApi::criAtomExAsrRack_GetBusVolume = ::criAtomExAsrRack_GetBusVolume;
criAtomExAsrRack_SetBusMatrix_TYPE FCriWareApi::criAtomExAsrRack_SetBusMatrix = ::criAtomExAsrRack_SetBusMatrix;
criAtomExAsrRack_SetBusSendLevel_TYPE FCriWareApi::criAtomExAsrRack_SetBusSendLevel = ::criAtomExAsrRack_SetBusSendLevel;
criAtomExAsrRack_AttachBusAnalyzer_TYPE FCriWareApi::criAtomExAsrRack_AttachBusAnalyzer = ::criAtomExAsrRack_AttachBusAnalyzer;
criAtomExAsrRack_DetachBusAnalyzer_TYPE FCriWareApi::criAtomExAsrRack_DetachBusAnalyzer = ::criAtomExAsrRack_DetachBusAnalyzer;
criAtomExAsrRack_GetBusAnalyzerInfo_TYPE FCriWareApi::criAtomExAsrRack_GetBusAnalyzerInfo = ::criAtomExAsrRack_GetBusAnalyzerInfo;
criAtomExAsrRack_SetBusFilterCallback_TYPE FCriWareApi::criAtomExAsrRack_SetBusFilterCallback = ::criAtomExAsrRack_SetBusFilterCallback;
criAtomExOutputPort_CalculateWorkSize_TYPE FCriWareApi::criAtomExOutputPort_CalculateWorkSize = ::criAtomExOutputPort_CalculateWorkSize;
criAtomExOutputPort_Create_TYPE FCriWareApi::criAtomExOutputPort_Create = ::criAtomExOutputPort_Create;
criAtomExOutputPort_Destroy_TYPE FCriWareApi::criAtomExOutputPort_Destroy = ::criAtomExOutputPort_Destroy;
criAtomExOutputPort_SetAsrRackId_TYPE FCriWareApi::criAtomExOutputPort_SetAsrRackId = ::criAtomExOutputPort_SetAsrRackId;
criAtomExOutputPort_SetVibrationChannelLevel_TYPE FCriWareApi::criAtomExOutputPort_SetVibrationChannelLevel = ::criAtomExOutputPort_SetVibrationChannelLevel;
criAtomExOutputPort_SetMonauralMix_TYPE FCriWareApi::criAtomExOutputPort_SetMonauralMix = ::criAtomExOutputPort_SetMonauralMix;

criAtomEx_InitializeForUserPcmOutput_TYPE FCriWareApi::criAtomEx_InitializeForUserPcmOutput = ::criAtomEx_InitializeForUserPcmOutput;
criAtomEx_FinalizeForUserPcmOutput_TYPE FCriWareApi::criAtomEx_FinalizeForUserPcmOutput = ::criAtomEx_FinalizeForUserPcmOutput;
criAtomEx_IsInitialized_TYPE FCriWareApi::criAtomEx_IsInitialized = ::criAtomEx_IsInitialized;
criAtomEx_ExecuteMain_TYPE FCriWareApi::criAtomEx_ExecuteMain = ::criAtomEx_ExecuteMain;
criAtomEx_ExecuteAudioProcess_TYPE FCriWareApi::criAtomEx_ExecuteAudioProcess = ::criAtomEx_ExecuteAudioProcess;
criAtomEx_Lock_TYPE FCriWareApi::criAtomEx_Lock = ::criAtomEx_Lock;
criAtomEx_Unlock_TYPE FCriWareApi::criAtomEx_Unlock = ::criAtomEx_Unlock;
criAtomEx_GetTimeMicro_TYPE FCriWareApi::criAtomEx_GetTimeMicro = ::criAtomEx_GetTimeMicro;
criAtomEx_ResetTimer_TYPE FCriWareApi::criAtomEx_ResetTimer = ::criAtomEx_ResetTimer;
criAtomEx_PauseTimer_TYPE FCriWareApi::criAtomEx_PauseTimer = ::criAtomEx_PauseTimer;
criAtomEx_SetConfigForWorkSizeCalculation_TYPE FCriWareApi::criAtomEx_SetConfigForWorkSizeCalculation = ::criAtomEx_SetConfigForWorkSizeCalculation;
criAtomEx_CalculateWorkSizeForRegisterAcfData_TYPE FCriWareApi::criAtomEx_CalculateWorkSizeForRegisterAcfData = ::criAtomEx_CalculateWorkSizeForRegisterAcfData;
criAtomEx_RegisterAcfData_TYPE FCriWareApi::criAtomEx_RegisterAcfData = ::criAtomEx_RegisterAcfData;
criAtomEx_CalculateWorkSizeForRegisterAcfFile_TYPE FCriWareApi::criAtomEx_CalculateWorkSizeForRegisterAcfFile = ::criAtomEx_CalculateWorkSizeForRegisterAcfFile;
criAtomEx_CalculateWorkSizeForRegisterAcfFileById_TYPE FCriWareApi::criAtomEx_CalculateWorkSizeForRegisterAcfFileById = ::criAtomEx_CalculateWorkSizeForRegisterAcfFileById;
criAtomEx_RegisterAcfFile_TYPE FCriWareApi::criAtomEx_RegisterAcfFile = ::criAtomEx_RegisterAcfFile;
criAtomEx_RegisterAcfFileById_TYPE FCriWareApi::criAtomEx_RegisterAcfFileById = ::criAtomEx_RegisterAcfFileById;
criAtomEx_UnregisterAcf_TYPE FCriWareApi::criAtomEx_UnregisterAcf = ::criAtomEx_UnregisterAcf;
criAtomEx_GetAcfVersion_TYPE FCriWareApi::criAtomEx_GetAcfVersion = ::criAtomEx_GetAcfVersion;
criAtomEx_GetAcfVersionFromFile_TYPE FCriWareApi::criAtomEx_GetAcfVersionFromFile = ::criAtomEx_GetAcfVersionFromFile;
criAtomEx_GetAcfVersionFromFileById_TYPE FCriWareApi::criAtomEx_GetAcfVersionFromFileById = ::criAtomEx_GetAcfVersionFromFileById;
criAtomEx_GetSupportedAcfVersion_TYPE FCriWareApi::criAtomEx_GetSupportedAcfVersion = ::criAtomEx_GetSupportedAcfVersion;
criAtomEx_AnalyzeAudioHeader_TYPE FCriWareApi::criAtomEx_AnalyzeAudioHeader = ::criAtomEx_AnalyzeAudioHeader;
criAtomEx_SetRandomSeed_TYPE FCriWareApi::criAtomEx_SetRandomSeed = ::criAtomEx_SetRandomSeed;
criAtomEx_IsDataPlaying_TYPE FCriWareApi::criAtomEx_IsDataPlaying = ::criAtomEx_IsDataPlaying;
criAtomEx_CalculateWorkSizeForDspBusSetting_TYPE FCriWareApi::criAtomEx_CalculateWorkSizeForDspBusSetting = ::criAtomEx_CalculateWorkSizeForDspBusSetting;
criAtomEx_CalculateWorkSizeForDspBusSettingFromAcfData_TYPE FCriWareApi::criAtomEx_CalculateWorkSizeForDspBusSettingFromAcfData = ::criAtomEx_CalculateWorkSizeForDspBusSettingFromAcfData;
criAtomEx_AttachDspBusSetting_TYPE FCriWareApi::criAtomEx_AttachDspBusSetting = ::criAtomEx_AttachDspBusSetting;
criAtomEx_DetachDspBusSetting_TYPE FCriWareApi::criAtomEx_DetachDspBusSetting = ::criAtomEx_DetachDspBusSetting;
criAtomEx_ApplyDspBusSnapshot_TYPE FCriWareApi::criAtomEx_ApplyDspBusSnapshot = ::criAtomEx_ApplyDspBusSnapshot;
criAtomEx_GetAppliedDspBusSnapshotName_TYPE FCriWareApi::criAtomEx_GetAppliedDspBusSnapshotName = ::criAtomEx_GetAppliedDspBusSnapshotName;
criAtomEx_SetCueLinkCallback_TYPE FCriWareApi::criAtomEx_SetCueLinkCallback = ::criAtomEx_SetCueLinkCallback;
criAtomEx_SetSpeakerAngles_TYPE FCriWareApi::criAtomEx_SetSpeakerAngles = ::criAtomEx_SetSpeakerAngles;
criAtomEx_SetSpeakerAngleArray_TYPE FCriWareApi::criAtomEx_SetSpeakerAngleArray = ::criAtomEx_SetSpeakerAngleArray;
criAtomEx_SetVirtualSpeakerAngleArray_TYPE FCriWareApi::criAtomEx_SetVirtualSpeakerAngleArray = ::criAtomEx_SetVirtualSpeakerAngleArray;
criAtomEx_ControlVirtualSpeakerSetting_TYPE FCriWareApi::criAtomEx_ControlVirtualSpeakerSetting = ::criAtomEx_ControlVirtualSpeakerSetting;
criAtomEx_GetNumGameVariables_TYPE FCriWareApi::criAtomEx_GetNumGameVariables = ::criAtomEx_GetNumGameVariables;
criAtomEx_GetGameVariableInfo_TYPE FCriWareApi::criAtomEx_GetGameVariableInfo = ::criAtomEx_GetGameVariableInfo;
criAtomEx_GetGameVariableById_TYPE FCriWareApi::criAtomEx_GetGameVariableById = ::criAtomEx_GetGameVariableById;
criAtomEx_GetGameVariableByName_TYPE FCriWareApi::criAtomEx_GetGameVariableByName = ::criAtomEx_GetGameVariableByName;
criAtomEx_SetGameVariableById_TYPE FCriWareApi::criAtomEx_SetGameVariableById = ::criAtomEx_SetGameVariableById;
criAtomEx_SetGameVariableByName_TYPE FCriWareApi::criAtomEx_SetGameVariableByName = ::criAtomEx_SetGameVariableByName;
criAtomEx_SetPlaybackCancelCallback_TYPE FCriWareApi::criAtomEx_SetPlaybackCancelCallback = ::criAtomEx_SetPlaybackCancelCallback;
criAtomEx_ControlAcfConsistencyCheck_TYPE FCriWareApi::criAtomEx_ControlAcfConsistencyCheck = ::criAtomEx_ControlAcfConsistencyCheck;
criAtomEx_SetAcfConsistencyCheckErrorLevel_TYPE FCriWareApi::criAtomEx_SetAcfConsistencyCheckErrorLevel = ::criAtomEx_SetAcfConsistencyCheckErrorLevel;
criAtomEx_SetTrackTransitionBySelectorCallback_TYPE FCriWareApi::criAtomEx_SetTrackTransitionBySelectorCallback = ::criAtomEx_SetTrackTransitionBySelectorCallback;
criAtomExDebug_GetResourcesInfo_TYPE FCriWareApi::criAtomExDebug_GetResourcesInfo = ::criAtomExDebug_GetResourcesInfo;
criAtomExHcaMx_CalculateWorkSize_TYPE FCriWareApi::criAtomExHcaMx_CalculateWorkSize = ::criAtomExHcaMx_CalculateWorkSize;
criAtomExHcaMx_SetConfigForWorkSizeCalculation_TYPE FCriWareApi::criAtomExHcaMx_SetConfigForWorkSizeCalculation = ::criAtomExHcaMx_SetConfigForWorkSizeCalculation;
criAtomExHcaMx_Initialize_TYPE FCriWareApi::criAtomExHcaMx_Initialize = ::criAtomExHcaMx_Initialize;
criAtomExHcaMx_Finalize_TYPE FCriWareApi::criAtomExHcaMx_Finalize = ::criAtomExHcaMx_Finalize;
criAtomExHcaMx_SetFrequencyRatio_TYPE FCriWareApi::criAtomExHcaMx_SetFrequencyRatio = ::criAtomExHcaMx_SetFrequencyRatio;
criAtomExHcaMx_SetAsrRackId_TYPE FCriWareApi::criAtomExHcaMx_SetAsrRackId = ::criAtomExHcaMx_SetAsrRackId;
criAtomExAcf_GetNumAisacControls_TYPE FCriWareApi::criAtomExAcf_GetNumAisacControls = ::criAtomExAcf_GetNumAisacControls;
criAtomExAcf_GetAisacControlInfo_TYPE FCriWareApi::criAtomExAcf_GetAisacControlInfo = ::criAtomExAcf_GetAisacControlInfo;
criAtomExAcf_GetAisacControlIdByName_TYPE FCriWareApi::criAtomExAcf_GetAisacControlIdByName = ::criAtomExAcf_GetAisacControlIdByName;
criAtomExAcf_GetAisacControlNameById_TYPE FCriWareApi::criAtomExAcf_GetAisacControlNameById = ::criAtomExAcf_GetAisacControlNameById;
criAtomExAcf_GetNumDspSettings_TYPE FCriWareApi::criAtomExAcf_GetNumDspSettings = ::criAtomExAcf_GetNumDspSettings;
criAtomExAcf_GetNumDspSettingsFromAcfData_TYPE FCriWareApi::criAtomExAcf_GetNumDspSettingsFromAcfData = ::criAtomExAcf_GetNumDspSettingsFromAcfData;
criAtomExAcf_GetDspSettingNameByIndex_TYPE FCriWareApi::criAtomExAcf_GetDspSettingNameByIndex = ::criAtomExAcf_GetDspSettingNameByIndex;
criAtomExAcf_GetDspSettingNameByIndexFromAcfData_TYPE FCriWareApi::criAtomExAcf_GetDspSettingNameByIndexFromAcfData = ::criAtomExAcf_GetDspSettingNameByIndexFromAcfData;
criAtomExAcf_GetDspSettingInformation_TYPE FCriWareApi::criAtomExAcf_GetDspSettingInformation = ::criAtomExAcf_GetDspSettingInformation;
criAtomExAcf_GetDspSettingSnapshotInformation_TYPE FCriWareApi::criAtomExAcf_GetDspSettingSnapshotInformation = ::criAtomExAcf_GetDspSettingSnapshotInformation;
criAtomExAcf_GetDspBusInformation_TYPE FCriWareApi::criAtomExAcf_GetDspBusInformation = ::criAtomExAcf_GetDspBusInformation;
criAtomExAcf_GetDspFxType_TYPE FCriWareApi::criAtomExAcf_GetDspFxType = ::criAtomExAcf_GetDspFxType;
criAtomExAcf_GetDspFxName_TYPE FCriWareApi::criAtomExAcf_GetDspFxName = ::criAtomExAcf_GetDspFxName;
criAtomExAcf_GetDspFxParameters_TYPE FCriWareApi::criAtomExAcf_GetDspFxParameters = ::criAtomExAcf_GetDspFxParameters;
criAtomExAcf_GetDspBusLinkInformation_TYPE FCriWareApi::criAtomExAcf_GetDspBusLinkInformation = ::criAtomExAcf_GetDspBusLinkInformation;
criAtomExAcf_GetNumCategoriesFromAcfData_TYPE FCriWareApi::criAtomExAcf_GetNumCategoriesFromAcfData = ::criAtomExAcf_GetNumCategoriesFromAcfData;
criAtomExAcf_GetNumCategories_TYPE FCriWareApi::criAtomExAcf_GetNumCategories = ::criAtomExAcf_GetNumCategories;
criAtomExAcf_GetNumCategoriesPerPlaybackFromAcfData_TYPE FCriWareApi::criAtomExAcf_GetNumCategoriesPerPlaybackFromAcfData = ::criAtomExAcf_GetNumCategoriesPerPlaybackFromAcfData;
criAtomExAcf_GetNumCategoriesPerPlayback_TYPE FCriWareApi::criAtomExAcf_GetNumCategoriesPerPlayback = ::criAtomExAcf_GetNumCategoriesPerPlayback;
criAtomExAcf_GetCategoryInfo_TYPE FCriWareApi::criAtomExAcf_GetCategoryInfo = ::criAtomExAcf_GetCategoryInfo;
criAtomExAcf_GetCategoryInfoByName_TYPE FCriWareApi::criAtomExAcf_GetCategoryInfoByName = ::criAtomExAcf_GetCategoryInfoByName;
criAtomExAcf_GetCategoryInfoById_TYPE FCriWareApi::criAtomExAcf_GetCategoryInfoById = ::criAtomExAcf_GetCategoryInfoById;
criAtomExAcf_GetNumGlobalAisacs_TYPE FCriWareApi::criAtomExAcf_GetNumGlobalAisacs = ::criAtomExAcf_GetNumGlobalAisacs;
criAtomExAcf_GetGlobalAisacInfo_TYPE FCriWareApi::criAtomExAcf_GetGlobalAisacInfo = ::criAtomExAcf_GetGlobalAisacInfo;
criAtomExAcf_GetGlobalAisacInfoByName_TYPE FCriWareApi::criAtomExAcf_GetGlobalAisacInfoByName = ::criAtomExAcf_GetGlobalAisacInfoByName;
criAtomExAcf_GetGlobalAisacGraphInfo_TYPE FCriWareApi::criAtomExAcf_GetGlobalAisacGraphInfo = ::criAtomExAcf_GetGlobalAisacGraphInfo;
criAtomExAcf_GetGlobalAisacValue_TYPE FCriWareApi::criAtomExAcf_GetGlobalAisacValue = ::criAtomExAcf_GetGlobalAisacValue;
criAtomExAcf_GetAcfInfo_TYPE FCriWareApi::criAtomExAcf_GetAcfInfo = ::criAtomExAcf_GetAcfInfo;
criAtomExAcf_GetAcfInfoFromAcfData_TYPE FCriWareApi::criAtomExAcf_GetAcfInfoFromAcfData = ::criAtomExAcf_GetAcfInfoFromAcfData;
criAtomExAcf_GetNumSelectors_TYPE FCriWareApi::criAtomExAcf_GetNumSelectors = ::criAtomExAcf_GetNumSelectors;
criAtomExAcf_GetSelectorInfoByIndex_TYPE FCriWareApi::criAtomExAcf_GetSelectorInfoByIndex = ::criAtomExAcf_GetSelectorInfoByIndex;
criAtomExAcf_GetSelectorInfoByName_TYPE FCriWareApi::criAtomExAcf_GetSelectorInfoByName = ::criAtomExAcf_GetSelectorInfoByName;
criAtomExAcf_GetSelectorLabelInfo_TYPE FCriWareApi::criAtomExAcf_GetSelectorLabelInfo = ::criAtomExAcf_GetSelectorLabelInfo;
criAtomExAcf_SetGlobalLabelToSelectorByName_TYPE FCriWareApi::criAtomExAcf_SetGlobalLabelToSelectorByName = ::criAtomExAcf_SetGlobalLabelToSelectorByName;
criAtomExAcf_SetGlobalLabelToSelectorByIndex_TYPE FCriWareApi::criAtomExAcf_SetGlobalLabelToSelectorByIndex = ::criAtomExAcf_SetGlobalLabelToSelectorByIndex;
criAtomExAcf_GetNumBusesFromAcfData_TYPE FCriWareApi::criAtomExAcf_GetNumBusesFromAcfData = ::criAtomExAcf_GetNumBusesFromAcfData;
criAtomExAcf_GetNumBuses_TYPE FCriWareApi::criAtomExAcf_GetNumBuses = ::criAtomExAcf_GetNumBuses;
criAtomExAcf_GetMaxBusesOfDspBusSettingsFromAcfData_TYPE FCriWareApi::criAtomExAcf_GetMaxBusesOfDspBusSettingsFromAcfData = ::criAtomExAcf_GetMaxBusesOfDspBusSettingsFromAcfData;
criAtomExAcf_GetMaxBusesOfDspBusSettings_TYPE FCriWareApi::criAtomExAcf_GetMaxBusesOfDspBusSettings = ::criAtomExAcf_GetMaxBusesOfDspBusSettings;
criAtomExAcf_FindBusName_TYPE FCriWareApi::criAtomExAcf_FindBusName = ::criAtomExAcf_FindBusName;
criAtomExAcf_GetOutputPortHnByName_TYPE FCriWareApi::criAtomExAcf_GetOutputPortHnByName = ::criAtomExAcf_GetOutputPortHnByName;
criAtomExAcf_DoCreateSpatialAsrRack_TYPE FCriWareApi::criAtomExAcf_DoCreateSpatialAsrRack = ::criAtomExAcf_DoCreateSpatialAsrRack;
criAtomExAcb_CalculateWorkSizeForLoadAcbData_TYPE FCriWareApi::criAtomExAcb_CalculateWorkSizeForLoadAcbData = ::criAtomExAcb_CalculateWorkSizeForLoadAcbData;
criAtomExAcb_CalculateWorkSizeForLoadAcbDataById_TYPE FCriWareApi::criAtomExAcb_CalculateWorkSizeForLoadAcbDataById = ::criAtomExAcb_CalculateWorkSizeForLoadAcbDataById;
criAtomExAcb_LoadAcbData_TYPE FCriWareApi::criAtomExAcb_LoadAcbData = ::criAtomExAcb_LoadAcbData;
criAtomExAcb_LoadAcbDataById_TYPE FCriWareApi::criAtomExAcb_LoadAcbDataById = ::criAtomExAcb_LoadAcbDataById;
criAtomExAcb_CalculateWorkSizeForLoadAcbFile_TYPE FCriWareApi::criAtomExAcb_CalculateWorkSizeForLoadAcbFile = ::criAtomExAcb_CalculateWorkSizeForLoadAcbFile;
criAtomExAcb_CalculateWorkSizeForLoadAcbFileById_TYPE FCriWareApi::criAtomExAcb_CalculateWorkSizeForLoadAcbFileById = ::criAtomExAcb_CalculateWorkSizeForLoadAcbFileById;
criAtomExAcb_LoadAcbFile_TYPE FCriWareApi::criAtomExAcb_LoadAcbFile = ::criAtomExAcb_LoadAcbFile;
criAtomExAcb_LoadAcbFileById_TYPE FCriWareApi::criAtomExAcb_LoadAcbFileById = ::criAtomExAcb_LoadAcbFileById;
criAtomExAcb_Release_TYPE FCriWareApi::criAtomExAcb_Release = ::criAtomExAcb_Release;
criAtomExAcb_IsReadyToRelease_TYPE FCriWareApi::criAtomExAcb_IsReadyToRelease = ::criAtomExAcb_IsReadyToRelease;
criAtomExAcb_ReleaseAll_TYPE FCriWareApi::criAtomExAcb_ReleaseAll = ::criAtomExAcb_ReleaseAll;
criAtomExAcb_EnumerateHandles_TYPE FCriWareApi::criAtomExAcb_EnumerateHandles = ::criAtomExAcb_EnumerateHandles;
criAtomExAcb_GetVersion_TYPE FCriWareApi::criAtomExAcb_GetVersion = ::criAtomExAcb_GetVersion;
criAtomExAcb_GetVersionFromFile_TYPE FCriWareApi::criAtomExAcb_GetVersionFromFile = ::criAtomExAcb_GetVersionFromFile;
criAtomExAcb_GetSupportedVersion_TYPE FCriWareApi::criAtomExAcb_GetSupportedVersion = ::criAtomExAcb_GetSupportedVersion;
criAtomExAcb_GetNumCues_TYPE FCriWareApi::criAtomExAcb_GetNumCues = ::criAtomExAcb_GetNumCues;
criAtomExAcb_ExistsId_TYPE FCriWareApi::criAtomExAcb_ExistsId = ::criAtomExAcb_ExistsId;
criAtomExAcb_ExistsName_TYPE FCriWareApi::criAtomExAcb_ExistsName = ::criAtomExAcb_ExistsName;
criAtomExAcb_ExistsIndex_TYPE FCriWareApi::criAtomExAcb_ExistsIndex = ::criAtomExAcb_ExistsIndex;
criAtomExAcb_GetCueIdByIndex_TYPE FCriWareApi::criAtomExAcb_GetCueIdByIndex = ::criAtomExAcb_GetCueIdByIndex;
criAtomExAcb_GetCueIdByName_TYPE FCriWareApi::criAtomExAcb_GetCueIdByName = ::criAtomExAcb_GetCueIdByName;
criAtomExAcb_GetCueNameByIndex_TYPE FCriWareApi::criAtomExAcb_GetCueNameByIndex = ::criAtomExAcb_GetCueNameByIndex;
criAtomExAcb_GetCueNameById_TYPE FCriWareApi::criAtomExAcb_GetCueNameById = ::criAtomExAcb_GetCueNameById;
criAtomExAcb_GetCueIndexById_TYPE FCriWareApi::criAtomExAcb_GetCueIndexById = ::criAtomExAcb_GetCueIndexById;
criAtomExAcb_GetCueIndexByName_TYPE FCriWareApi::criAtomExAcb_GetCueIndexByName = ::criAtomExAcb_GetCueIndexByName;
criAtomExAcb_GetUserDataById_TYPE FCriWareApi::criAtomExAcb_GetUserDataById = ::criAtomExAcb_GetUserDataById;
criAtomExAcb_GetUserDataByName_TYPE FCriWareApi::criAtomExAcb_GetUserDataByName = ::criAtomExAcb_GetUserDataByName;
criAtomExAcb_GetLengthById_TYPE FCriWareApi::criAtomExAcb_GetLengthById = ::criAtomExAcb_GetLengthById;
criAtomExAcb_GetLengthByName_TYPE FCriWareApi::criAtomExAcb_GetLengthByName = ::criAtomExAcb_GetLengthByName;
criAtomExAcb_GetNumUsableAisacControlsById_TYPE FCriWareApi::criAtomExAcb_GetNumUsableAisacControlsById = ::criAtomExAcb_GetNumUsableAisacControlsById;
criAtomExAcb_GetNumUsableAisacControlsByName_TYPE FCriWareApi::criAtomExAcb_GetNumUsableAisacControlsByName = ::criAtomExAcb_GetNumUsableAisacControlsByName;
criAtomExAcb_GetUsableAisacControlById_TYPE FCriWareApi::criAtomExAcb_GetUsableAisacControlById = ::criAtomExAcb_GetUsableAisacControlById;
criAtomExAcb_GetUsableAisacControlByName_TYPE FCriWareApi::criAtomExAcb_GetUsableAisacControlByName = ::criAtomExAcb_GetUsableAisacControlByName;
criAtomExAcb_IsUsingAisacControlById_TYPE FCriWareApi::criAtomExAcb_IsUsingAisacControlById = ::criAtomExAcb_IsUsingAisacControlById;
criAtomExAcb_IsUsingAisacControlByName_TYPE FCriWareApi::criAtomExAcb_IsUsingAisacControlByName = ::criAtomExAcb_IsUsingAisacControlByName;
criAtomExAcb_GetCuePriorityById_TYPE FCriWareApi::criAtomExAcb_GetCuePriorityById = ::criAtomExAcb_GetCuePriorityById;
criAtomExAcb_GetCuePriorityByName_TYPE FCriWareApi::criAtomExAcb_GetCuePriorityByName = ::criAtomExAcb_GetCuePriorityByName;
criAtomExAcb_GetWaveformInfoById_TYPE FCriWareApi::criAtomExAcb_GetWaveformInfoById = ::criAtomExAcb_GetWaveformInfoById;
criAtomExAcb_GetWaveformInfoByName_TYPE FCriWareApi::criAtomExAcb_GetWaveformInfoByName = ::criAtomExAcb_GetWaveformInfoByName;
criAtomExAcb_GetOnMemoryAwbHandle_TYPE FCriWareApi::criAtomExAcb_GetOnMemoryAwbHandle = ::criAtomExAcb_GetOnMemoryAwbHandle;
criAtomExAcb_GetStreamingAwbHandle_TYPE FCriWareApi::criAtomExAcb_GetStreamingAwbHandle = ::criAtomExAcb_GetStreamingAwbHandle;
criAtomExAcb_GetStreamingAwbHandleBySlotIndex_TYPE FCriWareApi::criAtomExAcb_GetStreamingAwbHandleBySlotIndex = ::criAtomExAcb_GetStreamingAwbHandleBySlotIndex;
criAtomExAcb_GetStreamingAwbHandleBySlotName_TYPE FCriWareApi::criAtomExAcb_GetStreamingAwbHandleBySlotName = ::criAtomExAcb_GetStreamingAwbHandleBySlotName;
criAtomExAcb_GetCueInfoByName_TYPE FCriWareApi::criAtomExAcb_GetCueInfoByName = ::criAtomExAcb_GetCueInfoByName;
criAtomExAcb_GetCueInfoById_TYPE FCriWareApi::criAtomExAcb_GetCueInfoById = ::criAtomExAcb_GetCueInfoById;
criAtomExAcb_GetCueInfoByIndex_TYPE FCriWareApi::criAtomExAcb_GetCueInfoByIndex = ::criAtomExAcb_GetCueInfoByIndex;
criAtomExAcb_GetNumCuePlayingCountByName_TYPE FCriWareApi::criAtomExAcb_GetNumCuePlayingCountByName = ::criAtomExAcb_GetNumCuePlayingCountByName;
criAtomExAcb_GetNumCuePlayingCountById_TYPE FCriWareApi::criAtomExAcb_GetNumCuePlayingCountById = ::criAtomExAcb_GetNumCuePlayingCountById;
criAtomExAcb_GetNumCuePlayingCountByIndex_TYPE FCriWareApi::criAtomExAcb_GetNumCuePlayingCountByIndex = ::criAtomExAcb_GetNumCuePlayingCountByIndex;
criAtomExAcb_GetBlockIndexByIndex_TYPE FCriWareApi::criAtomExAcb_GetBlockIndexByIndex = ::criAtomExAcb_GetBlockIndexByIndex;
criAtomExAcb_GetBlockIndexById_TYPE FCriWareApi::criAtomExAcb_GetBlockIndexById = ::criAtomExAcb_GetBlockIndexById;
criAtomExAcb_GetBlockIndexByName_TYPE FCriWareApi::criAtomExAcb_GetBlockIndexByName = ::criAtomExAcb_GetBlockIndexByName;
criAtomExAcb_SetDetectionInGamePreviewDataCallback_TYPE FCriWareApi::criAtomExAcb_SetDetectionInGamePreviewDataCallback = ::criAtomExAcb_SetDetectionInGamePreviewDataCallback;
criAtomExAcb_GetAcbInfo_TYPE FCriWareApi::criAtomExAcb_GetAcbInfo = ::criAtomExAcb_GetAcbInfo;
criAtomExAcb_ResetCueTypeStateByName_TYPE FCriWareApi::criAtomExAcb_ResetCueTypeStateByName = ::criAtomExAcb_ResetCueTypeStateByName;
criAtomExAcb_ResetCueTypeStateById_TYPE FCriWareApi::criAtomExAcb_ResetCueTypeStateById = ::criAtomExAcb_ResetCueTypeStateById;
criAtomExAcb_ResetCueTypeStateByIndex_TYPE FCriWareApi::criAtomExAcb_ResetCueTypeStateByIndex = ::criAtomExAcb_ResetCueTypeStateByIndex;
criAtomExAcb_AttachAwbFile_TYPE FCriWareApi::criAtomExAcb_AttachAwbFile = ::criAtomExAcb_AttachAwbFile;
criAtomExAcb_DetachAwbFile_TYPE FCriWareApi::criAtomExAcb_DetachAwbFile = ::criAtomExAcb_DetachAwbFile;
criAtomExAcb_AttachAwbHn_TYPE FCriWareApi::criAtomExAcb_AttachAwbHn = ::criAtomExAcb_AttachAwbHn;
criAtomExAcb_CalculateWorkSizeForAttachAwbFile_TYPE FCriWareApi::criAtomExAcb_CalculateWorkSizeForAttachAwbFile = ::criAtomExAcb_CalculateWorkSizeForAttachAwbFile;
criAtomExAcb_GetNumAwbFileSlots_TYPE FCriWareApi::criAtomExAcb_GetNumAwbFileSlots = ::criAtomExAcb_GetNumAwbFileSlots;
criAtomExAcb_GetAwbFileSlotName_TYPE FCriWareApi::criAtomExAcb_GetAwbFileSlotName = ::criAtomExAcb_GetAwbFileSlotName;
criAtomExAcb_IsAttachedAwbFile_TYPE FCriWareApi::criAtomExAcb_IsAttachedAwbFile = ::criAtomExAcb_IsAttachedAwbFile;
criAtomExVoicePool_CalculateWorkSizeForStandardVoicePool_TYPE FCriWareApi::criAtomExVoicePool_CalculateWorkSizeForStandardVoicePool = ::criAtomExVoicePool_CalculateWorkSizeForStandardVoicePool;
criAtomExVoicePool_AllocateStandardVoicePool_TYPE FCriWareApi::criAtomExVoicePool_AllocateStandardVoicePool = ::criAtomExVoicePool_AllocateStandardVoicePool;
criAtomExVoicePool_CalculateWorkSizeForAdxVoicePool_TYPE FCriWareApi::criAtomExVoicePool_CalculateWorkSizeForAdxVoicePool = ::criAtomExVoicePool_CalculateWorkSizeForAdxVoicePool;
criAtomExVoicePool_AllocateAdxVoicePool_TYPE FCriWareApi::criAtomExVoicePool_AllocateAdxVoicePool = ::criAtomExVoicePool_AllocateAdxVoicePool;
criAtomExVoicePool_CalculateWorkSizeForHcaVoicePool_TYPE FCriWareApi::criAtomExVoicePool_CalculateWorkSizeForHcaVoicePool = ::criAtomExVoicePool_CalculateWorkSizeForHcaVoicePool;
criAtomExVoicePool_AllocateHcaVoicePool_TYPE FCriWareApi::criAtomExVoicePool_AllocateHcaVoicePool = ::criAtomExVoicePool_AllocateHcaVoicePool;
criAtomExVoicePool_CalculateWorkSizeForHcaMxVoicePool_TYPE FCriWareApi::criAtomExVoicePool_CalculateWorkSizeForHcaMxVoicePool = ::criAtomExVoicePool_CalculateWorkSizeForHcaMxVoicePool;
criAtomExVoicePool_AllocateHcaMxVoicePool_TYPE FCriWareApi::criAtomExVoicePool_AllocateHcaMxVoicePool = ::criAtomExVoicePool_AllocateHcaMxVoicePool;
criAtomExVoicePool_CalculateWorkSizeForWaveVoicePool_TYPE FCriWareApi::criAtomExVoicePool_CalculateWorkSizeForWaveVoicePool = ::criAtomExVoicePool_CalculateWorkSizeForWaveVoicePool;
criAtomExVoicePool_AllocateWaveVoicePool_TYPE FCriWareApi::criAtomExVoicePool_AllocateWaveVoicePool = ::criAtomExVoicePool_AllocateWaveVoicePool;
criAtomExVoicePool_CalculateWorkSizeForAiffVoicePool_TYPE FCriWareApi::criAtomExVoicePool_CalculateWorkSizeForAiffVoicePool = ::criAtomExVoicePool_CalculateWorkSizeForAiffVoicePool;
criAtomExVoicePool_AllocateAiffVoicePool_TYPE FCriWareApi::criAtomExVoicePool_AllocateAiffVoicePool = ::criAtomExVoicePool_AllocateAiffVoicePool;
criAtomExVoicePool_CalculateWorkSizeForRawPcmVoicePool_TYPE FCriWareApi::criAtomExVoicePool_CalculateWorkSizeForRawPcmVoicePool = ::criAtomExVoicePool_CalculateWorkSizeForRawPcmVoicePool;
criAtomExVoicePool_AllocateRawPcmVoicePool_TYPE FCriWareApi::criAtomExVoicePool_AllocateRawPcmVoicePool = ::criAtomExVoicePool_AllocateRawPcmVoicePool;
criAtomExVoicePool_AllocateInstrumentVoicePool_TYPE FCriWareApi::criAtomExVoicePool_AllocateInstrumentVoicePool = ::criAtomExVoicePool_AllocateInstrumentVoicePool;
criAtomExVoicePool_Free_TYPE FCriWareApi::criAtomExVoicePool_Free = ::criAtomExVoicePool_Free;
criAtomExVoicePool_FreeAll_TYPE FCriWareApi::criAtomExVoicePool_FreeAll = ::criAtomExVoicePool_FreeAll;
criAtomExVoicePool_GetNumUsedVoices_TYPE FCriWareApi::criAtomExVoicePool_GetNumUsedVoices = ::criAtomExVoicePool_GetNumUsedVoices;
criAtomExVoicePool_GetPlayerHandle_TYPE FCriWareApi::criAtomExVoicePool_GetPlayerHandle = ::criAtomExVoicePool_GetPlayerHandle;
criAtomExVoicePool_CalculateWorkSizeForInstrumentVoicePool_TYPE FCriWareApi::criAtomExVoicePool_CalculateWorkSizeForInstrumentVoicePool = ::criAtomExVoicePool_CalculateWorkSizeForInstrumentVoicePool;
criAtomExInputPort_Create_TYPE FCriWareApi::criAtomExInputPort_Create = ::criAtomExInputPort_Create;
criAtomExInputPort_Destroy_TYPE FCriWareApi::criAtomExInputPort_Destroy = ::criAtomExInputPort_Destroy;
criAtomExCategory_SetVolumeById_TYPE FCriWareApi::criAtomExCategory_SetVolumeById = ::criAtomExCategory_SetVolumeById;
criAtomExCategory_GetVolumeById_TYPE FCriWareApi::criAtomExCategory_GetVolumeById = ::criAtomExCategory_GetVolumeById;
criAtomExCategory_GetTotalVolumeById_TYPE FCriWareApi::criAtomExCategory_GetTotalVolumeById = ::criAtomExCategory_GetTotalVolumeById;
criAtomExCategory_SetVolumeByName_TYPE FCriWareApi::criAtomExCategory_SetVolumeByName = ::criAtomExCategory_SetVolumeByName;
criAtomExCategory_GetVolumeByName_TYPE FCriWareApi::criAtomExCategory_GetVolumeByName = ::criAtomExCategory_GetVolumeByName;
criAtomExCategory_GetTotalVolumeByName_TYPE FCriWareApi::criAtomExCategory_GetTotalVolumeByName = ::criAtomExCategory_GetTotalVolumeByName;
criAtomExCategory_MuteById_TYPE FCriWareApi::criAtomExCategory_MuteById = ::criAtomExCategory_MuteById;
criAtomExCategory_IsMutedById_TYPE FCriWareApi::criAtomExCategory_IsMutedById = ::criAtomExCategory_IsMutedById;
criAtomExCategory_MuteByName_TYPE FCriWareApi::criAtomExCategory_MuteByName = ::criAtomExCategory_MuteByName;
criAtomExCategory_IsMutedByName_TYPE FCriWareApi::criAtomExCategory_IsMutedByName = ::criAtomExCategory_IsMutedByName;
criAtomExCategory_SoloById_TYPE FCriWareApi::criAtomExCategory_SoloById = ::criAtomExCategory_SoloById;
criAtomExCategory_IsSoloedById_TYPE FCriWareApi::criAtomExCategory_IsSoloedById = ::criAtomExCategory_IsSoloedById;
criAtomExCategory_SoloByName_TYPE FCriWareApi::criAtomExCategory_SoloByName = ::criAtomExCategory_SoloByName;
criAtomExCategory_IsSoloedByName_TYPE FCriWareApi::criAtomExCategory_IsSoloedByName = ::criAtomExCategory_IsSoloedByName;
criAtomExCategory_PauseById_TYPE FCriWareApi::criAtomExCategory_PauseById = ::criAtomExCategory_PauseById;
criAtomExCategory_IsPausedById_TYPE FCriWareApi::criAtomExCategory_IsPausedById = ::criAtomExCategory_IsPausedById;
criAtomExCategory_PauseByName_TYPE FCriWareApi::criAtomExCategory_PauseByName = ::criAtomExCategory_PauseByName;
criAtomExCategory_IsPausedByName_TYPE FCriWareApi::criAtomExCategory_IsPausedByName = ::criAtomExCategory_IsPausedByName;
criAtomExCategory_SetFadeInTimeById_TYPE FCriWareApi::criAtomExCategory_SetFadeInTimeById = ::criAtomExCategory_SetFadeInTimeById;
criAtomExCategory_SetFadeInTimeByName_TYPE FCriWareApi::criAtomExCategory_SetFadeInTimeByName = ::criAtomExCategory_SetFadeInTimeByName;
criAtomExCategory_SetFadeOutTimeById_TYPE FCriWareApi::criAtomExCategory_SetFadeOutTimeById = ::criAtomExCategory_SetFadeOutTimeById;
criAtomExCategory_SetFadeOutTimeByName_TYPE FCriWareApi::criAtomExCategory_SetFadeOutTimeByName = ::criAtomExCategory_SetFadeOutTimeByName;
criAtomExCategory_SetAisacControlById_TYPE FCriWareApi::criAtomExCategory_SetAisacControlById = ::criAtomExCategory_SetAisacControlById;
criAtomExCategory_SetAisacControlByName_TYPE FCriWareApi::criAtomExCategory_SetAisacControlByName = ::criAtomExCategory_SetAisacControlByName;
criAtomExCategory_ResetAllAisacControlById_TYPE FCriWareApi::criAtomExCategory_ResetAllAisacControlById = ::criAtomExCategory_ResetAllAisacControlById;
criAtomExCategory_ResetAllAisacControlByName_TYPE FCriWareApi::criAtomExCategory_ResetAllAisacControlByName = ::criAtomExCategory_ResetAllAisacControlByName;
criAtomExCategory_AttachAisacById_TYPE FCriWareApi::criAtomExCategory_AttachAisacById = ::criAtomExCategory_AttachAisacById;
criAtomExCategory_AttachAisacByName_TYPE FCriWareApi::criAtomExCategory_AttachAisacByName = ::criAtomExCategory_AttachAisacByName;
criAtomExCategory_DetachAisacById_TYPE FCriWareApi::criAtomExCategory_DetachAisacById = ::criAtomExCategory_DetachAisacById;
criAtomExCategory_DetachAisacByName_TYPE FCriWareApi::criAtomExCategory_DetachAisacByName = ::criAtomExCategory_DetachAisacByName;
criAtomExCategory_DetachAisacAllById_TYPE FCriWareApi::criAtomExCategory_DetachAisacAllById = ::criAtomExCategory_DetachAisacAllById;
criAtomExCategory_DetachAisacAllByName_TYPE FCriWareApi::criAtomExCategory_DetachAisacAllByName = ::criAtomExCategory_DetachAisacAllByName;
criAtomExCategory_GetNumAttachedAisacsById_TYPE FCriWareApi::criAtomExCategory_GetNumAttachedAisacsById = ::criAtomExCategory_GetNumAttachedAisacsById;
criAtomExCategory_GetNumAttachedAisacsByName_TYPE FCriWareApi::criAtomExCategory_GetNumAttachedAisacsByName = ::criAtomExCategory_GetNumAttachedAisacsByName;
criAtomExCategory_GetAttachedAisacInfoById_TYPE FCriWareApi::criAtomExCategory_GetAttachedAisacInfoById = ::criAtomExCategory_GetAttachedAisacInfoById;
criAtomExCategory_GetAttachedAisacInfoByName_TYPE FCriWareApi::criAtomExCategory_GetAttachedAisacInfoByName = ::criAtomExCategory_GetAttachedAisacInfoByName;
criAtomExCategory_GetCurrentAisacControlValueById_TYPE FCriWareApi::criAtomExCategory_GetCurrentAisacControlValueById = ::criAtomExCategory_GetCurrentAisacControlValueById;
criAtomExCategory_GetCurrentAisacControlValueByName_TYPE FCriWareApi::criAtomExCategory_GetCurrentAisacControlValueByName = ::criAtomExCategory_GetCurrentAisacControlValueByName;
criAtomExCategory_SetReactParameter_TYPE FCriWareApi::criAtomExCategory_SetReactParameter = ::criAtomExCategory_SetReactParameter;
criAtomExCategory_GetReactParameter_TYPE FCriWareApi::criAtomExCategory_GetReactParameter = ::criAtomExCategory_GetReactParameter;
criAtomExCategory_GetNumCuePlayingCountById_TYPE FCriWareApi::criAtomExCategory_GetNumCuePlayingCountById = ::criAtomExCategory_GetNumCuePlayingCountById;
criAtomExCategory_GetNumCuePlayingCountByName_TYPE FCriWareApi::criAtomExCategory_GetNumCuePlayingCountByName = ::criAtomExCategory_GetNumCuePlayingCountByName;
criAtomExCategory_StopById_TYPE FCriWareApi::criAtomExCategory_StopById = ::criAtomExCategory_StopById;
criAtomExCategory_StopByName_TYPE FCriWareApi::criAtomExCategory_StopByName = ::criAtomExCategory_StopByName;
criAtomExCategory_StopWithoutReleaseTimeById_TYPE FCriWareApi::criAtomExCategory_StopWithoutReleaseTimeById = ::criAtomExCategory_StopWithoutReleaseTimeById;
criAtomExCategory_StopWithoutReleaseTimeByName_TYPE FCriWareApi::criAtomExCategory_StopWithoutReleaseTimeByName = ::criAtomExCategory_StopWithoutReleaseTimeByName;
criAtomExPlayer_CalculateWorkSize_TYPE FCriWareApi::criAtomExPlayer_CalculateWorkSize = ::criAtomExPlayer_CalculateWorkSize;
criAtomExPlayer_Create_TYPE FCriWareApi::criAtomExPlayer_Create = ::criAtomExPlayer_Create;
criAtomExPlayer_Destroy_TYPE FCriWareApi::criAtomExPlayer_Destroy = ::criAtomExPlayer_Destroy;
criAtomExPlayer_SetCueId_TYPE FCriWareApi::criAtomExPlayer_SetCueId = ::criAtomExPlayer_SetCueId;
criAtomExPlayer_SetCueName_TYPE FCriWareApi::criAtomExPlayer_SetCueName = ::criAtomExPlayer_SetCueName;
criAtomExPlayer_SetCueIndex_TYPE FCriWareApi::criAtomExPlayer_SetCueIndex = ::criAtomExPlayer_SetCueIndex;
criAtomExPlayer_SetData_TYPE FCriWareApi::criAtomExPlayer_SetData = ::criAtomExPlayer_SetData;
criAtomExPlayer_SetFile_TYPE FCriWareApi::criAtomExPlayer_SetFile = ::criAtomExPlayer_SetFile;
criAtomExPlayer_SetContentId_TYPE FCriWareApi::criAtomExPlayer_SetContentId = ::criAtomExPlayer_SetContentId;
criAtomExPlayer_SetWaveId_TYPE FCriWareApi::criAtomExPlayer_SetWaveId = ::criAtomExPlayer_SetWaveId;
criAtomExPlayer_Start_TYPE FCriWareApi::criAtomExPlayer_Start = ::criAtomExPlayer_Start;
criAtomExPlayer_Prepare_TYPE FCriWareApi::criAtomExPlayer_Prepare = ::criAtomExPlayer_Prepare;
criAtomExPlayer_Stop_TYPE FCriWareApi::criAtomExPlayer_Stop = ::criAtomExPlayer_Stop;
criAtomExPlayer_StopWithoutReleaseTime_TYPE FCriWareApi::criAtomExPlayer_StopWithoutReleaseTime = ::criAtomExPlayer_StopWithoutReleaseTime;
criAtomExPlayer_StopAllPlayers_TYPE FCriWareApi::criAtomExPlayer_StopAllPlayers = ::criAtomExPlayer_StopAllPlayers;
criAtomExPlayer_StopAllPlayersWithoutReleaseTime_TYPE FCriWareApi::criAtomExPlayer_StopAllPlayersWithoutReleaseTime = ::criAtomExPlayer_StopAllPlayersWithoutReleaseTime;
criAtomExPlayer_EnumeratePlayers_TYPE FCriWareApi::criAtomExPlayer_EnumeratePlayers = ::criAtomExPlayer_EnumeratePlayers;
criAtomExPlayer_Pause_TYPE FCriWareApi::criAtomExPlayer_Pause = ::criAtomExPlayer_Pause;
criAtomExPlayer_Resume_TYPE FCriWareApi::criAtomExPlayer_Resume = ::criAtomExPlayer_Resume;
criAtomExPlayer_IsPaused_TYPE FCriWareApi::criAtomExPlayer_IsPaused = ::criAtomExPlayer_IsPaused;
criAtomExPlayer_GetStatus_TYPE FCriWareApi::criAtomExPlayer_GetStatus = ::criAtomExPlayer_GetStatus;
criAtomExPlayer_GetNumPlaybacks_TYPE FCriWareApi::criAtomExPlayer_GetNumPlaybacks = ::criAtomExPlayer_GetNumPlaybacks;
criAtomExPlayer_GetLastPlaybackId_TYPE FCriWareApi::criAtomExPlayer_GetLastPlaybackId = ::criAtomExPlayer_GetLastPlaybackId;
criAtomExPlayer_GetTime_TYPE FCriWareApi::criAtomExPlayer_GetTime = ::criAtomExPlayer_GetTime;
criAtomExPlayer_SetFormat_TYPE FCriWareApi::criAtomExPlayer_SetFormat = ::criAtomExPlayer_SetFormat;
criAtomExPlayer_SetNumChannels_TYPE FCriWareApi::criAtomExPlayer_SetNumChannels = ::criAtomExPlayer_SetNumChannels;
criAtomExPlayer_SetSamplingRate_TYPE FCriWareApi::criAtomExPlayer_SetSamplingRate = ::criAtomExPlayer_SetSamplingRate;
criAtomExPlayer_SetSoundRendererType_TYPE FCriWareApi::criAtomExPlayer_SetSoundRendererType = ::criAtomExPlayer_SetSoundRendererType;
criAtomExPlayer_SetGroupNumber_TYPE FCriWareApi::criAtomExPlayer_SetGroupNumber = ::criAtomExPlayer_SetGroupNumber;
criAtomExPlayer_SetVoiceControlMethod_TYPE FCriWareApi::criAtomExPlayer_SetVoiceControlMethod = ::criAtomExPlayer_SetVoiceControlMethod;
criAtomExPlayer_SetVoicePoolIdentifier_TYPE FCriWareApi::criAtomExPlayer_SetVoicePoolIdentifier = ::criAtomExPlayer_SetVoicePoolIdentifier;
criAtomExPlayer_SetInputPort_TYPE FCriWareApi::criAtomExPlayer_SetInputPort = ::criAtomExPlayer_SetInputPort;
criAtomExPlayer_SetHcaMxMixerId_TYPE FCriWareApi::criAtomExPlayer_SetHcaMxMixerId = ::criAtomExPlayer_SetHcaMxMixerId;
criAtomExPlayer_SetAsrRackId_TYPE FCriWareApi::criAtomExPlayer_SetAsrRackId = ::criAtomExPlayer_SetAsrRackId;
criAtomExPlayer_SetAsrRackIdArray_TYPE FCriWareApi::criAtomExPlayer_SetAsrRackIdArray = ::criAtomExPlayer_SetAsrRackIdArray;
criAtomExPlayer_SetStartTime_TYPE FCriWareApi::criAtomExPlayer_SetStartTime = ::criAtomExPlayer_SetStartTime;
criAtomExPlayer_SetSyncPlaybackId_TYPE FCriWareApi::criAtomExPlayer_SetSyncPlaybackId = ::criAtomExPlayer_SetSyncPlaybackId;
criAtomExPlayer_SetPlaybackRatio_TYPE FCriWareApi::criAtomExPlayer_SetPlaybackRatio = ::criAtomExPlayer_SetPlaybackRatio;
criAtomExPlayer_LimitLoopCount_TYPE FCriWareApi::criAtomExPlayer_LimitLoopCount = ::criAtomExPlayer_LimitLoopCount;
criAtomExPlayer_UpdateAll_TYPE FCriWareApi::criAtomExPlayer_UpdateAll = ::criAtomExPlayer_UpdateAll;
criAtomExPlayer_Update_TYPE FCriWareApi::criAtomExPlayer_Update = ::criAtomExPlayer_Update;
criAtomExPlayer_ResetParameters_TYPE FCriWareApi::criAtomExPlayer_ResetParameters = ::criAtomExPlayer_ResetParameters;
criAtomExPlayer_GetParameterFloat32_TYPE FCriWareApi::criAtomExPlayer_GetParameterFloat32 = ::criAtomExPlayer_GetParameterFloat32;
criAtomExPlayer_GetParameterUint32_TYPE FCriWareApi::criAtomExPlayer_GetParameterUint32 = ::criAtomExPlayer_GetParameterUint32;
criAtomExPlayer_GetParameterSint32_TYPE FCriWareApi::criAtomExPlayer_GetParameterSint32 = ::criAtomExPlayer_GetParameterSint32;
criAtomExPlayer_SetVolume_TYPE FCriWareApi::criAtomExPlayer_SetVolume = ::criAtomExPlayer_SetVolume;
criAtomExPlayer_SetPitch_TYPE FCriWareApi::criAtomExPlayer_SetPitch = ::criAtomExPlayer_SetPitch;
criAtomExPlayer_SetMaxPitch_TYPE FCriWareApi::criAtomExPlayer_SetMaxPitch = ::criAtomExPlayer_SetMaxPitch;
criAtomExPlayer_SetPan3dAngle_TYPE FCriWareApi::criAtomExPlayer_SetPan3dAngle = ::criAtomExPlayer_SetPan3dAngle;
criAtomExPlayer_SetPan3dInteriorDistance_TYPE FCriWareApi::criAtomExPlayer_SetPan3dInteriorDistance = ::criAtomExPlayer_SetPan3dInteriorDistance;
criAtomExPlayer_SetPan3dVolume_TYPE FCriWareApi::criAtomExPlayer_SetPan3dVolume = ::criAtomExPlayer_SetPan3dVolume;
criAtomExPlayer_SetPanType_TYPE FCriWareApi::criAtomExPlayer_SetPanType = ::criAtomExPlayer_SetPanType;
criAtomExPlayer_SetPanSpeakerType_TYPE FCriWareApi::criAtomExPlayer_SetPanSpeakerType = ::criAtomExPlayer_SetPanSpeakerType;
criAtomExPlayer_AddMixDownCenterVolumeOffset_TYPE FCriWareApi::criAtomExPlayer_AddMixDownCenterVolumeOffset = ::criAtomExPlayer_AddMixDownCenterVolumeOffset;
criAtomExPlayer_AddMixDownLfeVolumeOffset_TYPE FCriWareApi::criAtomExPlayer_AddMixDownLfeVolumeOffset = ::criAtomExPlayer_AddMixDownLfeVolumeOffset;
criAtomExPlayer_ChangeDefaultPanSpeakerType_TYPE FCriWareApi::criAtomExPlayer_ChangeDefaultPanSpeakerType = ::criAtomExPlayer_ChangeDefaultPanSpeakerType;
criAtomExPlayer_SetPanAngleType_TYPE FCriWareApi::criAtomExPlayer_SetPanAngleType = ::criAtomExPlayer_SetPanAngleType;
criAtomExPlayer_SetWideness_TYPE FCriWareApi::criAtomExPlayer_SetWideness = ::criAtomExPlayer_SetWideness;
criAtomExPlayer_SetSendLevel_TYPE FCriWareApi::criAtomExPlayer_SetSendLevel = ::criAtomExPlayer_SetSendLevel;
criAtomExPlayer_SetBusSendLevelByName_TYPE FCriWareApi::criAtomExPlayer_SetBusSendLevelByName = ::criAtomExPlayer_SetBusSendLevelByName;
criAtomExPlayer_SetBusSendLevelOffsetByName_TYPE FCriWareApi::criAtomExPlayer_SetBusSendLevelOffsetByName = ::criAtomExPlayer_SetBusSendLevelOffsetByName;
criAtomExPlayer_ResetBusSends_TYPE FCriWareApi::criAtomExPlayer_ResetBusSends = ::criAtomExPlayer_ResetBusSends;
criAtomExPlayer_SetPanAdx1Compatible_TYPE FCriWareApi::criAtomExPlayer_SetPanAdx1Compatible = ::criAtomExPlayer_SetPanAdx1Compatible;
criAtomExPlayer_SetBandpassFilterParameters_TYPE FCriWareApi::criAtomExPlayer_SetBandpassFilterParameters = ::criAtomExPlayer_SetBandpassFilterParameters;
criAtomExPlayer_SetBiquadFilterParameters_TYPE FCriWareApi::criAtomExPlayer_SetBiquadFilterParameters = ::criAtomExPlayer_SetBiquadFilterParameters;
criAtomExPlayer_SetVoicePriority_TYPE FCriWareApi::criAtomExPlayer_SetVoicePriority = ::criAtomExPlayer_SetVoicePriority;
criAtomExPlayer_SetAisacControlById_TYPE FCriWareApi::criAtomExPlayer_SetAisacControlById = ::criAtomExPlayer_SetAisacControlById;
criAtomExPlayer_SetAisacControlByName_TYPE FCriWareApi::criAtomExPlayer_SetAisacControlByName = ::criAtomExPlayer_SetAisacControlByName;
criAtomExPlayer_ClearAisacControls_TYPE FCriWareApi::criAtomExPlayer_ClearAisacControls = ::criAtomExPlayer_ClearAisacControls;
criAtomExPlayer_Set3dSourceHn_TYPE FCriWareApi::criAtomExPlayer_Set3dSourceHn = ::criAtomExPlayer_Set3dSourceHn;
criAtomExPlayer_Set3dSourceListHn_TYPE FCriWareApi::criAtomExPlayer_Set3dSourceListHn = ::criAtomExPlayer_Set3dSourceListHn;
criAtomExPlayer_Set3dListenerHn_TYPE FCriWareApi::criAtomExPlayer_Set3dListenerHn = ::criAtomExPlayer_Set3dListenerHn;
criAtomExPlayer_GetAisacControlById_TYPE FCriWareApi::criAtomExPlayer_GetAisacControlById = ::criAtomExPlayer_GetAisacControlById;
criAtomExPlayer_GetAisacControlByName_TYPE FCriWareApi::criAtomExPlayer_GetAisacControlByName = ::criAtomExPlayer_GetAisacControlByName;
criAtomExPlayer_SetCategoryById_TYPE FCriWareApi::criAtomExPlayer_SetCategoryById = ::criAtomExPlayer_SetCategoryById;
criAtomExPlayer_SetCategoryByName_TYPE FCriWareApi::criAtomExPlayer_SetCategoryByName = ::criAtomExPlayer_SetCategoryByName;
criAtomExPlayer_UnsetCategory_TYPE FCriWareApi::criAtomExPlayer_UnsetCategory = ::criAtomExPlayer_UnsetCategory;
criAtomExPlayer_GetNumCategories_TYPE FCriWareApi::criAtomExPlayer_GetNumCategories = ::criAtomExPlayer_GetNumCategories;
criAtomExPlayer_GetCategoryInfo_TYPE FCriWareApi::criAtomExPlayer_GetCategoryInfo = ::criAtomExPlayer_GetCategoryInfo;
criAtomExPlayer_SetTrackInfo_TYPE FCriWareApi::criAtomExPlayer_SetTrackInfo = ::criAtomExPlayer_SetTrackInfo;
criAtomExPlayer_SetTrackVolume_TYPE FCriWareApi::criAtomExPlayer_SetTrackVolume = ::criAtomExPlayer_SetTrackVolume;
criAtomExPlayer_SetSilentMode_TYPE FCriWareApi::criAtomExPlayer_SetSilentMode = ::criAtomExPlayer_SetSilentMode;
criAtomExPlayer_SetCuePriority_TYPE FCriWareApi::criAtomExPlayer_SetCuePriority = ::criAtomExPlayer_SetCuePriority;
criAtomExPlayer_SetPreDelayTime_TYPE FCriWareApi::criAtomExPlayer_SetPreDelayTime = ::criAtomExPlayer_SetPreDelayTime;
criAtomExPlayer_SetEnvelopeAttackTime_TYPE FCriWareApi::criAtomExPlayer_SetEnvelopeAttackTime = ::criAtomExPlayer_SetEnvelopeAttackTime;
criAtomExPlayer_SetEnvelopeHoldTime_TYPE FCriWareApi::criAtomExPlayer_SetEnvelopeHoldTime = ::criAtomExPlayer_SetEnvelopeHoldTime;
criAtomExPlayer_SetEnvelopeDecayTime_TYPE FCriWareApi::criAtomExPlayer_SetEnvelopeDecayTime = ::criAtomExPlayer_SetEnvelopeDecayTime;
criAtomExPlayer_SetEnvelopeReleaseTime_TYPE FCriWareApi::criAtomExPlayer_SetEnvelopeReleaseTime = ::criAtomExPlayer_SetEnvelopeReleaseTime;
criAtomExPlayer_SetEnvelopeSustainLevel_TYPE FCriWareApi::criAtomExPlayer_SetEnvelopeSustainLevel = ::criAtomExPlayer_SetEnvelopeSustainLevel;
criAtomExPlayer_SetEnvelopeAttackCurve_TYPE FCriWareApi::criAtomExPlayer_SetEnvelopeAttackCurve = ::criAtomExPlayer_SetEnvelopeAttackCurve;
criAtomExPlayer_SetEnvelopeDecayCurve_TYPE FCriWareApi::criAtomExPlayer_SetEnvelopeDecayCurve = ::criAtomExPlayer_SetEnvelopeDecayCurve;
criAtomExPlayer_SetEnvelopeReleaseCurve_TYPE FCriWareApi::criAtomExPlayer_SetEnvelopeReleaseCurve = ::criAtomExPlayer_SetEnvelopeReleaseCurve;
criAtomExPlayer_SetDataRequestCallback_TYPE FCriWareApi::criAtomExPlayer_SetDataRequestCallback = ::criAtomExPlayer_SetDataRequestCallback;
criAtomExPlayer_SetFilterCallback_TYPE FCriWareApi::criAtomExPlayer_SetFilterCallback = ::criAtomExPlayer_SetFilterCallback;
criAtomExPlayer_SetRandomSeed_TYPE FCriWareApi::criAtomExPlayer_SetRandomSeed = ::criAtomExPlayer_SetRandomSeed;
criAtomExPlayer_SetDspParameter_TYPE FCriWareApi::criAtomExPlayer_SetDspParameter = ::criAtomExPlayer_SetDspParameter;
criAtomExPlayer_AttachAisac_TYPE FCriWareApi::criAtomExPlayer_AttachAisac = ::criAtomExPlayer_AttachAisac;
criAtomExPlayer_AttachAisacByIndex_TYPE FCriWareApi::criAtomExPlayer_AttachAisacByIndex = ::criAtomExPlayer_AttachAisacByIndex;
criAtomExPlayer_DetachAisac_TYPE FCriWareApi::criAtomExPlayer_DetachAisac = ::criAtomExPlayer_DetachAisac;
criAtomExPlayer_DetachAisacByIndex_TYPE FCriWareApi::criAtomExPlayer_DetachAisacByIndex = ::criAtomExPlayer_DetachAisacByIndex;
criAtomExPlayer_DetachAisacAll_TYPE FCriWareApi::criAtomExPlayer_DetachAisacAll = ::criAtomExPlayer_DetachAisacAll;
criAtomExPlayer_GetNumAttachedAisacs_TYPE FCriWareApi::criAtomExPlayer_GetNumAttachedAisacs = ::criAtomExPlayer_GetNumAttachedAisacs;
criAtomExPlayer_GetAttachedAisacInfo_TYPE FCriWareApi::criAtomExPlayer_GetAttachedAisacInfo = ::criAtomExPlayer_GetAttachedAisacInfo;
criAtomExPlayer_SetStreamingCacheId_TYPE FCriWareApi::criAtomExPlayer_SetStreamingCacheId = ::criAtomExPlayer_SetStreamingCacheId;
criAtomExPlayer_AttachTween_TYPE FCriWareApi::criAtomExPlayer_AttachTween = ::criAtomExPlayer_AttachTween;
criAtomExPlayer_DetachTween_TYPE FCriWareApi::criAtomExPlayer_DetachTween = ::criAtomExPlayer_DetachTween;
criAtomExPlayer_DetachTweenAll_TYPE FCriWareApi::criAtomExPlayer_DetachTweenAll = ::criAtomExPlayer_DetachTweenAll;
criAtomExPlayer_SetFirstBlockIndex_TYPE FCriWareApi::criAtomExPlayer_SetFirstBlockIndex = ::criAtomExPlayer_SetFirstBlockIndex;
criAtomExPlayer_SetBlockTransitionCallback_TYPE FCriWareApi::criAtomExPlayer_SetBlockTransitionCallback = ::criAtomExPlayer_SetBlockTransitionCallback;
criAtomExPlayer_GetSoundObject_TYPE FCriWareApi::criAtomExPlayer_GetSoundObject = ::criAtomExPlayer_GetSoundObject;
criAtomExPlayer_SetDrySendLevel_TYPE FCriWareApi::criAtomExPlayer_SetDrySendLevel = ::criAtomExPlayer_SetDrySendLevel;
criAtomExPlayer_SetSelectorLabel_TYPE FCriWareApi::criAtomExPlayer_SetSelectorLabel = ::criAtomExPlayer_SetSelectorLabel;
criAtomExPlayer_ClearSelectorLabels_TYPE FCriWareApi::criAtomExPlayer_ClearSelectorLabels = ::criAtomExPlayer_ClearSelectorLabels;
criAtomExPlayer_SetPlaybackTrackInfoNotificationCallback_TYPE FCriWareApi::criAtomExPlayer_SetPlaybackTrackInfoNotificationCallback = ::criAtomExPlayer_SetPlaybackTrackInfoNotificationCallback;
criAtomExPlayer_SetPlaybackEventCallback_TYPE FCriWareApi::criAtomExPlayer_SetPlaybackEventCallback = ::criAtomExPlayer_SetPlaybackEventCallback;
criAtomExPlayback_Stop_TYPE FCriWareApi::criAtomExPlayback_Stop = ::criAtomExPlayback_Stop;
criAtomExPlayback_StopWithoutReleaseTime_TYPE FCriWareApi::criAtomExPlayback_StopWithoutReleaseTime = ::criAtomExPlayback_StopWithoutReleaseTime;
criAtomExPlayback_Pause_TYPE FCriWareApi::criAtomExPlayback_Pause = ::criAtomExPlayback_Pause;
criAtomExPlayback_Resume_TYPE FCriWareApi::criAtomExPlayback_Resume = ::criAtomExPlayback_Resume;
criAtomExPlayback_IsPaused_TYPE FCriWareApi::criAtomExPlayback_IsPaused = ::criAtomExPlayback_IsPaused;
criAtomExPlayback_GetStatus_TYPE FCriWareApi::criAtomExPlayback_GetStatus = ::criAtomExPlayback_GetStatus;
criAtomExPlayback_GetFormatInfo_TYPE FCriWareApi::criAtomExPlayback_GetFormatInfo = ::criAtomExPlayback_GetFormatInfo;
criAtomExPlayback_GetSource_TYPE FCriWareApi::criAtomExPlayback_GetSource = ::criAtomExPlayback_GetSource;
criAtomExPlayback_GetAtomPlayer_TYPE FCriWareApi::criAtomExPlayback_GetAtomPlayer = ::criAtomExPlayback_GetAtomPlayer;
criAtomExPlayback_GetTime_TYPE FCriWareApi::criAtomExPlayback_GetTime = ::criAtomExPlayback_GetTime;
criAtomExPlayback_GetTimeSyncedWithAudio_TYPE FCriWareApi::criAtomExPlayback_GetTimeSyncedWithAudio = ::criAtomExPlayback_GetTimeSyncedWithAudio;
criAtomExPlayback_GetTimeSyncedWithAudioMicro_TYPE FCriWareApi::criAtomExPlayback_GetTimeSyncedWithAudioMicro = ::criAtomExPlayback_GetTimeSyncedWithAudioMicro;
criAtomExPlayback_GetSequencePosition_TYPE FCriWareApi::criAtomExPlayback_GetSequencePosition = ::criAtomExPlayback_GetSequencePosition;
criAtomExPlayback_GetNumPlayedSamples_TYPE FCriWareApi::criAtomExPlayback_GetNumPlayedSamples = ::criAtomExPlayback_GetNumPlayedSamples;
criAtomExPlayback_GetParameterFloat32_TYPE FCriWareApi::criAtomExPlayback_GetParameterFloat32 = ::criAtomExPlayback_GetParameterFloat32;
criAtomExPlayback_GetParameterUint32_TYPE FCriWareApi::criAtomExPlayback_GetParameterUint32 = ::criAtomExPlayback_GetParameterUint32;
criAtomExPlayback_GetParameterSint32_TYPE FCriWareApi::criAtomExPlayback_GetParameterSint32 = ::criAtomExPlayback_GetParameterSint32;
criAtomExPlayback_GetAisacControlById_TYPE FCriWareApi::criAtomExPlayback_GetAisacControlById = ::criAtomExPlayback_GetAisacControlById;
criAtomExPlayback_GetAisacControlByName_TYPE FCriWareApi::criAtomExPlayback_GetAisacControlByName = ::criAtomExPlayback_GetAisacControlByName;
criAtomExPlayback_SetNextBlockIndex_TYPE FCriWareApi::criAtomExPlayback_SetNextBlockIndex = ::criAtomExPlayback_SetNextBlockIndex;
criAtomExPlayback_GetCurrentBlockIndex_TYPE FCriWareApi::criAtomExPlayback_GetCurrentBlockIndex = ::criAtomExPlayback_GetCurrentBlockIndex;
criAtomExPlayback_GetPlaybackTrackInfo_TYPE FCriWareApi::criAtomExPlayback_GetPlaybackTrackInfo = ::criAtomExPlayback_GetPlaybackTrackInfo;
criAtomExPlayback_GetBeatSyncInfo_TYPE FCriWareApi::criAtomExPlayback_GetBeatSyncInfo = ::criAtomExPlayback_GetBeatSyncInfo;
criAtomExPlayback_SetBeatSyncOffset_TYPE FCriWareApi::criAtomExPlayback_SetBeatSyncOffset = ::criAtomExPlayback_SetBeatSyncOffset;
criAtomExPlayer_CalculateWorkSizeForFader_TYPE FCriWareApi::criAtomExPlayer_CalculateWorkSizeForFader = ::criAtomExPlayer_CalculateWorkSizeForFader;
criAtomExPlayer_AttachFader_TYPE FCriWareApi::criAtomExPlayer_AttachFader = ::criAtomExPlayer_AttachFader;
criAtomExPlayer_DetachFader_TYPE FCriWareApi::criAtomExPlayer_DetachFader = ::criAtomExPlayer_DetachFader;
criAtomExPlayer_SetFadeOutTime_TYPE FCriWareApi::criAtomExPlayer_SetFadeOutTime = ::criAtomExPlayer_SetFadeOutTime;
criAtomExPlayer_GetFadeOutTime_TYPE FCriWareApi::criAtomExPlayer_GetFadeOutTime = ::criAtomExPlayer_GetFadeOutTime;
criAtomExPlayer_SetFadeInTime_TYPE FCriWareApi::criAtomExPlayer_SetFadeInTime = ::criAtomExPlayer_SetFadeInTime;
criAtomExPlayer_GetFadeInTime_TYPE FCriWareApi::criAtomExPlayer_GetFadeInTime = ::criAtomExPlayer_GetFadeInTime;
criAtomExPlayer_SetFadeInStartOffset_TYPE FCriWareApi::criAtomExPlayer_SetFadeInStartOffset = ::criAtomExPlayer_SetFadeInStartOffset;
criAtomExPlayer_GetFadeInStartOffset_TYPE FCriWareApi::criAtomExPlayer_GetFadeInStartOffset = ::criAtomExPlayer_GetFadeInStartOffset;
criAtomExPlayer_SetFadeOutEndDelay_TYPE FCriWareApi::criAtomExPlayer_SetFadeOutEndDelay = ::criAtomExPlayer_SetFadeOutEndDelay;
criAtomExPlayer_GetFadeOutEndDelay_TYPE FCriWareApi::criAtomExPlayer_GetFadeOutEndDelay = ::criAtomExPlayer_GetFadeOutEndDelay;
criAtomExPlayer_IsFading_TYPE FCriWareApi::criAtomExPlayer_IsFading = ::criAtomExPlayer_IsFading;
criAtomExPlayer_ResetFaderParameters_TYPE FCriWareApi::criAtomExPlayer_ResetFaderParameters = ::criAtomExPlayer_ResetFaderParameters;
criAtomExSequencer_SetEventCallback_TYPE FCriWareApi::criAtomExSequencer_SetEventCallback = ::criAtomExSequencer_SetEventCallback;
criAtomExBeatSync_SetCallback_TYPE FCriWareApi::criAtomExBeatSync_SetCallback = ::criAtomExBeatSync_SetCallback;
criAtomEx3dSource_CalculateWorkSize_TYPE FCriWareApi::criAtomEx3dSource_CalculateWorkSize = ::criAtomEx3dSource_CalculateWorkSize;
criAtomEx3dSource_Create_TYPE FCriWareApi::criAtomEx3dSource_Create = ::criAtomEx3dSource_Create;
criAtomEx3dSource_Destroy_TYPE FCriWareApi::criAtomEx3dSource_Destroy = ::criAtomEx3dSource_Destroy;
criAtomEx3dSource_Update_TYPE FCriWareApi::criAtomEx3dSource_Update = ::criAtomEx3dSource_Update;
criAtomEx3dSource_ResetParameters_TYPE FCriWareApi::criAtomEx3dSource_ResetParameters = ::criAtomEx3dSource_ResetParameters;
criAtomEx3dSource_SetPosition_TYPE FCriWareApi::criAtomEx3dSource_SetPosition = ::criAtomEx3dSource_SetPosition;
criAtomEx3dSource_GetPosition_TYPE FCriWareApi::criAtomEx3dSource_GetPosition = ::criAtomEx3dSource_GetPosition;
criAtomEx3dSource_SetVelocity_TYPE FCriWareApi::criAtomEx3dSource_SetVelocity = ::criAtomEx3dSource_SetVelocity;
criAtomEx3dSource_SetOrientation_TYPE FCriWareApi::criAtomEx3dSource_SetOrientation = ::criAtomEx3dSource_SetOrientation;
criAtomEx3dSource_SetConeParameter_TYPE FCriWareApi::criAtomEx3dSource_SetConeParameter = ::criAtomEx3dSource_SetConeParameter;
criAtomEx3dSource_ChangeDefaultConeParameter_TYPE FCriWareApi::criAtomEx3dSource_ChangeDefaultConeParameter = ::criAtomEx3dSource_ChangeDefaultConeParameter;
criAtomEx3dSource_SetMinMaxAttenuationDistance_TYPE FCriWareApi::criAtomEx3dSource_SetMinMaxAttenuationDistance = ::criAtomEx3dSource_SetMinMaxAttenuationDistance;
criAtomEx3dSource_ChangeDefaultMinMaxAttenuationDistance_TYPE FCriWareApi::criAtomEx3dSource_ChangeDefaultMinMaxAttenuationDistance = ::criAtomEx3dSource_ChangeDefaultMinMaxAttenuationDistance;
criAtomEx3dSource_SetInteriorPanField_TYPE FCriWareApi::criAtomEx3dSource_SetInteriorPanField = ::criAtomEx3dSource_SetInteriorPanField;
criAtomEx3dSource_ChangeDefaultInteriorPanField_TYPE FCriWareApi::criAtomEx3dSource_ChangeDefaultInteriorPanField = ::criAtomEx3dSource_ChangeDefaultInteriorPanField;
criAtomEx3dSource_SetDopplerFactor_TYPE FCriWareApi::criAtomEx3dSource_SetDopplerFactor = ::criAtomEx3dSource_SetDopplerFactor;
criAtomEx3dSource_ChangeDefaultDopplerFactor_TYPE FCriWareApi::criAtomEx3dSource_ChangeDefaultDopplerFactor = ::criAtomEx3dSource_ChangeDefaultDopplerFactor;
criAtomEx3dSource_SetVolume_TYPE FCriWareApi::criAtomEx3dSource_SetVolume = ::criAtomEx3dSource_SetVolume;
criAtomEx3dSource_ChangeDefaultVolume_TYPE FCriWareApi::criAtomEx3dSource_ChangeDefaultVolume = ::criAtomEx3dSource_ChangeDefaultVolume;
criAtomEx3dSource_SetMaxAngleAisacDelta_TYPE FCriWareApi::criAtomEx3dSource_SetMaxAngleAisacDelta = ::criAtomEx3dSource_SetMaxAngleAisacDelta;
criAtomEx3dSource_SetDistanceAisacControlId_TYPE FCriWareApi::criAtomEx3dSource_SetDistanceAisacControlId = ::criAtomEx3dSource_SetDistanceAisacControlId;
criAtomEx3dSource_SetListenerBasedAzimuthAngleAisacControlId_TYPE FCriWareApi::criAtomEx3dSource_SetListenerBasedAzimuthAngleAisacControlId = ::criAtomEx3dSource_SetListenerBasedAzimuthAngleAisacControlId;
criAtomEx3dSource_SetListenerBasedElevationAngleAisacControlId_TYPE FCriWareApi::criAtomEx3dSource_SetListenerBasedElevationAngleAisacControlId = ::criAtomEx3dSource_SetListenerBasedElevationAngleAisacControlId;
criAtomEx3dSource_SetSourceBasedAzimuthAngleAisacControlId_TYPE FCriWareApi::criAtomEx3dSource_SetSourceBasedAzimuthAngleAisacControlId = ::criAtomEx3dSource_SetSourceBasedAzimuthAngleAisacControlId;
criAtomEx3dSource_SetSourceBasedElevationAngleAisacControlId_TYPE FCriWareApi::criAtomEx3dSource_SetSourceBasedElevationAngleAisacControlId = ::criAtomEx3dSource_SetSourceBasedElevationAngleAisacControlId;
criAtomEx3dSource_Set3dRegionHn_TYPE FCriWareApi::criAtomEx3dSource_Set3dRegionHn = ::criAtomEx3dSource_Set3dRegionHn;
criAtomEx3dSourceList_CalculateWorkSize_TYPE FCriWareApi::criAtomEx3dSourceList_CalculateWorkSize = ::criAtomEx3dSourceList_CalculateWorkSize;
criAtomEx3dSourceList_Create_TYPE FCriWareApi::criAtomEx3dSourceList_Create = ::criAtomEx3dSourceList_Create;
criAtomEx3dSourceList_Destroy_TYPE FCriWareApi::criAtomEx3dSourceList_Destroy = ::criAtomEx3dSourceList_Destroy;
criAtomEx3dSourceList_Add_TYPE FCriWareApi::criAtomEx3dSourceList_Add = ::criAtomEx3dSourceList_Add;
criAtomEx3dSourceList_Remove_TYPE FCriWareApi::criAtomEx3dSourceList_Remove = ::criAtomEx3dSourceList_Remove;
criAtomEx3dSourceList_RemoveAll_TYPE FCriWareApi::criAtomEx3dSourceList_RemoveAll = ::criAtomEx3dSourceList_RemoveAll;
criAtomEx3dListener_CalculateWorkSize_TYPE FCriWareApi::criAtomEx3dListener_CalculateWorkSize = ::criAtomEx3dListener_CalculateWorkSize;
criAtomEx3dListener_Create_TYPE FCriWareApi::criAtomEx3dListener_Create = ::criAtomEx3dListener_Create;
criAtomEx3dListener_Destroy_TYPE FCriWareApi::criAtomEx3dListener_Destroy = ::criAtomEx3dListener_Destroy;
criAtomEx3dListener_Update_TYPE FCriWareApi::criAtomEx3dListener_Update = ::criAtomEx3dListener_Update;
criAtomEx3dListener_ResetParameters_TYPE FCriWareApi::criAtomEx3dListener_ResetParameters = ::criAtomEx3dListener_ResetParameters;
criAtomEx3dListener_SetPosition_TYPE FCriWareApi::criAtomEx3dListener_SetPosition = ::criAtomEx3dListener_SetPosition;
criAtomEx3dListener_GetPosition_TYPE FCriWareApi::criAtomEx3dListener_GetPosition = ::criAtomEx3dListener_GetPosition;
criAtomEx3dListener_SetVelocity_TYPE FCriWareApi::criAtomEx3dListener_SetVelocity = ::criAtomEx3dListener_SetVelocity;
criAtomEx3dListener_SetOrientation_TYPE FCriWareApi::criAtomEx3dListener_SetOrientation = ::criAtomEx3dListener_SetOrientation;
criAtomEx3dListener_SetDopplerMultiplier_TYPE FCriWareApi::criAtomEx3dListener_SetDopplerMultiplier = ::criAtomEx3dListener_SetDopplerMultiplier;
criAtomEx3dListener_SetFocusPoint_TYPE FCriWareApi::criAtomEx3dListener_SetFocusPoint = ::criAtomEx3dListener_SetFocusPoint;
criAtomEx3dListener_SetDistanceFocusLevel_TYPE FCriWareApi::criAtomEx3dListener_SetDistanceFocusLevel = ::criAtomEx3dListener_SetDistanceFocusLevel;
criAtomEx3dListener_SetDirectionFocusLevel_TYPE FCriWareApi::criAtomEx3dListener_SetDirectionFocusLevel = ::criAtomEx3dListener_SetDirectionFocusLevel;
criAtomEx_EnableCalculationAisacControlFrom3dPosition_TYPE FCriWareApi::criAtomEx_EnableCalculationAisacControlFrom3dPosition = ::criAtomEx_EnableCalculationAisacControlFrom3dPosition;
criAtomEx_IsEnableCalculationAisacControlFrom3dPosition_TYPE FCriWareApi::criAtomEx_IsEnableCalculationAisacControlFrom3dPosition = ::criAtomEx_IsEnableCalculationAisacControlFrom3dPosition;
criAtomEx3dListener_Set3dRegionHn_TYPE FCriWareApi::criAtomEx3dListener_Set3dRegionHn = ::criAtomEx3dListener_Set3dRegionHn;
criAtomEx3dRegion_CalculateWorkSize_TYPE FCriWareApi::criAtomEx3dRegion_CalculateWorkSize = ::criAtomEx3dRegion_CalculateWorkSize;
criAtomEx3dRegion_Create_TYPE FCriWareApi::criAtomEx3dRegion_Create = ::criAtomEx3dRegion_Create;
criAtomEx3dRegion_Destroy_TYPE FCriWareApi::criAtomEx3dRegion_Destroy = ::criAtomEx3dRegion_Destroy;
criAtomEx3dTransceiver_CalculateWorkSize_TYPE FCriWareApi::criAtomEx3dTransceiver_CalculateWorkSize = ::criAtomEx3dTransceiver_CalculateWorkSize;
criAtomEx3dTransceiver_Create_TYPE FCriWareApi::criAtomEx3dTransceiver_Create = ::criAtomEx3dTransceiver_Create;
criAtomEx3dTransceiver_Destroy_TYPE FCriWareApi::criAtomEx3dTransceiver_Destroy = ::criAtomEx3dTransceiver_Destroy;
criAtomEx3dTransceiver_Update_TYPE FCriWareApi::criAtomEx3dTransceiver_Update = ::criAtomEx3dTransceiver_Update;
criAtomEx3dTransceiver_SetInputPosition_TYPE FCriWareApi::criAtomEx3dTransceiver_SetInputPosition = ::criAtomEx3dTransceiver_SetInputPosition;
criAtomEx3dTransceiver_SetOutputPosition_TYPE FCriWareApi::criAtomEx3dTransceiver_SetOutputPosition = ::criAtomEx3dTransceiver_SetOutputPosition;
criAtomEx3dTransceiver_SetInputOrientation_TYPE FCriWareApi::criAtomEx3dTransceiver_SetInputOrientation = ::criAtomEx3dTransceiver_SetInputOrientation;
criAtomEx3dTransceiver_SetOutputOrientation_TYPE FCriWareApi::criAtomEx3dTransceiver_SetOutputOrientation = ::criAtomEx3dTransceiver_SetOutputOrientation;
criAtomEx3dTransceiver_SetOutputConeParameter_TYPE FCriWareApi::criAtomEx3dTransceiver_SetOutputConeParameter = ::criAtomEx3dTransceiver_SetOutputConeParameter;
criAtomEx3dTransceiver_SetOutputMinMaxAttenuationDistance_TYPE FCriWareApi::criAtomEx3dTransceiver_SetOutputMinMaxAttenuationDistance = ::criAtomEx3dTransceiver_SetOutputMinMaxAttenuationDistance;
criAtomEx3dTransceiver_SetOutputInteriorPanField_TYPE FCriWareApi::criAtomEx3dTransceiver_SetOutputInteriorPanField = ::criAtomEx3dTransceiver_SetOutputInteriorPanField;
criAtomEx3dTransceiver_SetInputCrossFadeField_TYPE FCriWareApi::criAtomEx3dTransceiver_SetInputCrossFadeField = ::criAtomEx3dTransceiver_SetInputCrossFadeField;
criAtomEx3dTransceiver_SetOutputVolume_TYPE FCriWareApi::criAtomEx3dTransceiver_SetOutputVolume = ::criAtomEx3dTransceiver_SetOutputVolume;
criAtomEx3dTransceiver_AttachAisac_TYPE FCriWareApi::criAtomEx3dTransceiver_AttachAisac = ::criAtomEx3dTransceiver_AttachAisac;
criAtomEx3dTransceiver_DetachAisac_TYPE FCriWareApi::criAtomEx3dTransceiver_DetachAisac = ::criAtomEx3dTransceiver_DetachAisac;
criAtomEx3dTransceiver_SetMaxAngleAisacDelta_TYPE FCriWareApi::criAtomEx3dTransceiver_SetMaxAngleAisacDelta = ::criAtomEx3dTransceiver_SetMaxAngleAisacDelta;
criAtomEx3dTransceiver_SetDistanceAisacControlId_TYPE FCriWareApi::criAtomEx3dTransceiver_SetDistanceAisacControlId = ::criAtomEx3dTransceiver_SetDistanceAisacControlId;
criAtomEx3dTransceiver_SetListenerBasedAzimuthAngleAisacControlId_TYPE FCriWareApi::criAtomEx3dTransceiver_SetListenerBasedAzimuthAngleAisacControlId = ::criAtomEx3dTransceiver_SetListenerBasedAzimuthAngleAisacControlId;
criAtomEx3dTransceiver_SetListenerBasedElevationAngleAisacControlId_TYPE FCriWareApi::criAtomEx3dTransceiver_SetListenerBasedElevationAngleAisacControlId = ::criAtomEx3dTransceiver_SetListenerBasedElevationAngleAisacControlId;
criAtomEx3dTransceiver_SetTransceiverOutputBasedAzimuthAngleAisacControlId_TYPE FCriWareApi::criAtomEx3dTransceiver_SetTransceiverOutputBasedAzimuthAngleAisacControlId = ::criAtomEx3dTransceiver_SetTransceiverOutputBasedAzimuthAngleAisacControlId;
criAtomEx3dTransceiver_SetTransceiverOutputBasedElevationAngleAisacControlId_TYPE FCriWareApi::criAtomEx3dTransceiver_SetTransceiverOutputBasedElevationAngleAisacControlId = ::criAtomEx3dTransceiver_SetTransceiverOutputBasedElevationAngleAisacControlId;
criAtomEx3dTransceiver_Set3dRegionHn_TYPE FCriWareApi::criAtomEx3dTransceiver_Set3dRegionHn = ::criAtomEx3dTransceiver_Set3dRegionHn;
criAtomExVoicePool_DetachDsp_TYPE FCriWareApi::criAtomExVoicePool_DetachDsp = ::criAtomExVoicePool_DetachDsp;
criAtomExVoicePool_CalculateWorkSizeForDspPitchShifter_TYPE FCriWareApi::criAtomExVoicePool_CalculateWorkSizeForDspPitchShifter = ::criAtomExVoicePool_CalculateWorkSizeForDspPitchShifter;
criAtomExVoicePool_AttachDspPitchShifter_TYPE FCriWareApi::criAtomExVoicePool_AttachDspPitchShifter = ::criAtomExVoicePool_AttachDspPitchShifter;
criAtomExVoicePool_CalculateWorkSizeForDspTimeStretch_TYPE FCriWareApi::criAtomExVoicePool_CalculateWorkSizeForDspTimeStretch = ::criAtomExVoicePool_CalculateWorkSizeForDspTimeStretch;
criAtomExVoicePool_AttachDspTimeStretch_TYPE FCriWareApi::criAtomExVoicePool_AttachDspTimeStretch = ::criAtomExVoicePool_AttachDspTimeStretch;
criAtomExStreamingCache_IsCachedWaveformById_TYPE FCriWareApi::criAtomExStreamingCache_IsCachedWaveformById = ::criAtomExStreamingCache_IsCachedWaveformById;
criAtomExStreamingCache_IsCachedWaveformByName_TYPE FCriWareApi::criAtomExStreamingCache_IsCachedWaveformByName = ::criAtomExStreamingCache_IsCachedWaveformByName;
criAtomExStreamingCache_LoadWaveformById_TYPE FCriWareApi::criAtomExStreamingCache_LoadWaveformById = ::criAtomExStreamingCache_LoadWaveformById;
criAtomExStreamingCache_LoadWaveformByName_TYPE FCriWareApi::criAtomExStreamingCache_LoadWaveformByName = ::criAtomExStreamingCache_LoadWaveformByName;
criAtomExTween_CalculateWorkSize_TYPE FCriWareApi::criAtomExTween_CalculateWorkSize = ::criAtomExTween_CalculateWorkSize;
criAtomExTween_Create_TYPE FCriWareApi::criAtomExTween_Create = ::criAtomExTween_Create;
criAtomExTween_Destroy_TYPE FCriWareApi::criAtomExTween_Destroy = ::criAtomExTween_Destroy;
criAtomExTween_GetValue_TYPE FCriWareApi::criAtomExTween_GetValue = ::criAtomExTween_GetValue;
criAtomExTween_MoveTo_TYPE FCriWareApi::criAtomExTween_MoveTo = ::criAtomExTween_MoveTo;
criAtomExTween_MoveFrom_TYPE FCriWareApi::criAtomExTween_MoveFrom = ::criAtomExTween_MoveFrom;
criAtomExTween_Stop_TYPE FCriWareApi::criAtomExTween_Stop = ::criAtomExTween_Stop;
criAtomExTween_Reset_TYPE FCriWareApi::criAtomExTween_Reset = ::criAtomExTween_Reset;
criAtomEx_SetVoiceEventCallback_TYPE FCriWareApi::criAtomEx_SetVoiceEventCallback = ::criAtomEx_SetVoiceEventCallback;
criAtomEx_EnumerateVoiceInfos_TYPE FCriWareApi::criAtomEx_EnumerateVoiceInfos = ::criAtomEx_EnumerateVoiceInfos;
criAtomEx_SetMonitoringVoiceStopCallback_TYPE FCriWareApi::criAtomEx_SetMonitoringVoiceStopCallback = ::criAtomEx_SetMonitoringVoiceStopCallback;
criAtomEx_SetMonitoringVoiceStopPlaybackId_TYPE FCriWareApi::criAtomEx_SetMonitoringVoiceStopPlaybackId = ::criAtomEx_SetMonitoringVoiceStopPlaybackId;
criAtomExSoundObject_CalculateWorkSize_TYPE FCriWareApi::criAtomExSoundObject_CalculateWorkSize = ::criAtomExSoundObject_CalculateWorkSize;
criAtomExSoundObject_Create_TYPE FCriWareApi::criAtomExSoundObject_Create = ::criAtomExSoundObject_Create;
criAtomExSoundObject_Destroy_TYPE FCriWareApi::criAtomExSoundObject_Destroy = ::criAtomExSoundObject_Destroy;
criAtomExSoundObject_AddPlayer_TYPE FCriWareApi::criAtomExSoundObject_AddPlayer = ::criAtomExSoundObject_AddPlayer;
criAtomExSoundObject_DeletePlayer_TYPE FCriWareApi::criAtomExSoundObject_DeletePlayer = ::criAtomExSoundObject_DeletePlayer;
criAtomExSoundObject_DeleteAllPlayers_TYPE FCriWareApi::criAtomExSoundObject_DeleteAllPlayers = ::criAtomExSoundObject_DeleteAllPlayers;
criAtomExAcb_ReleaseAsync_TYPE FCriWareApi::criAtomExAcb_ReleaseAsync = ::criAtomExAcb_ReleaseAsync;
criAtomExPlayer_IsReadyToStartAsync_TYPE FCriWareApi::criAtomExPlayer_IsReadyToStartAsync = ::criAtomExPlayer_IsReadyToStartAsync;
criAtomExPlayer_UpdateAllAsync_TYPE FCriWareApi::criAtomExPlayer_UpdateAllAsync = ::criAtomExPlayer_UpdateAllAsync;
criAtomExPlayer_GetTimeReal_TYPE FCriWareApi::criAtomExPlayer_GetTimeReal = ::criAtomExPlayer_GetTimeReal;
criAtomExPlayback_GetTimeReal_TYPE FCriWareApi::criAtomExPlayback_GetTimeReal = ::criAtomExPlayback_GetTimeReal;
criAtomExPlayback_EnumerateAtomPlayers_TYPE FCriWareApi::criAtomExPlayback_EnumerateAtomPlayers = ::criAtomExPlayback_EnumerateAtomPlayers;
criAtomEx3dListener_GetFocusPoint_TYPE FCriWareApi::criAtomEx3dListener_GetFocusPoint = ::criAtomEx3dListener_GetFocusPoint;
criAtomEx3dListener_GetDistanceFocusLevel_TYPE FCriWareApi::criAtomEx3dListener_GetDistanceFocusLevel = ::criAtomEx3dListener_GetDistanceFocusLevel;
criAtomEx3dListener_GetDirectionFocusLevel_TYPE FCriWareApi::criAtomEx3dListener_GetDirectionFocusLevel = ::criAtomEx3dListener_GetDirectionFocusLevel;
criAtomExAcb_GetCurrentAcb_TYPE FCriWareApi::criAtomExAcb_GetCurrentAcb = ::criAtomExAcb_GetCurrentAcb;
criAtomExAcb_IsParameterPalletAssignedByName_TYPE FCriWareApi::criAtomExAcb_IsParameterPalletAssignedByName = ::criAtomExAcb_IsParameterPalletAssignedByName;
criAtomEx3dSource_SetAttenuationDistanceSetting_TYPE FCriWareApi::criAtomEx3dSource_SetAttenuationDistanceSetting = ::criAtomEx3dSource_SetAttenuationDistanceSetting;
criAtomEx3dSource_GetAttenuationDistanceSetting_TYPE FCriWareApi::criAtomEx3dSource_GetAttenuationDistanceSetting = ::criAtomEx3dSource_GetAttenuationDistanceSetting;
criAtomExPlayer_SetBusSendLevel_TYPE FCriWareApi::criAtomExPlayer_SetBusSendLevel = ::criAtomExPlayer_SetBusSendLevel;
criAtomExPlayer_SetBusSendLevelOffset_TYPE FCriWareApi::criAtomExPlayer_SetBusSendLevelOffset = ::criAtomExPlayer_SetBusSendLevelOffset;
criAtomEx_GetNumUsedVirtualVoices_TYPE FCriWareApi::criAtomEx_GetNumUsedVirtualVoices = ::criAtomEx_GetNumUsedVirtualVoices;
criAtomEx_GetNumUsedSequences_TYPE FCriWareApi::criAtomEx_GetNumUsedSequences = ::criAtomEx_GetNumUsedSequences;
criAtomEx_GetNumUsedSequenceTracks_TYPE FCriWareApi::criAtomEx_GetNumUsedSequenceTracks = ::criAtomEx_GetNumUsedSequenceTracks;
criAtomEx_GetNumUsedSequenceTrackItems_TYPE FCriWareApi::criAtomEx_GetNumUsedSequenceTrackItems = ::criAtomEx_GetNumUsedSequenceTrackItems;
criAtomEx3dListener_SetDistanceFactor_TYPE FCriWareApi::criAtomEx3dListener_SetDistanceFactor = ::criAtomEx3dListener_SetDistanceFactor;
criAtomEx_GetNumUsedAisacAutoModulations_TYPE FCriWareApi::criAtomEx_GetNumUsedAisacAutoModulations = ::criAtomEx_GetNumUsedAisacAutoModulations;
criAtomEx3dSource_SetConeOrientation_TYPE FCriWareApi::criAtomEx3dSource_SetConeOrientation = ::criAtomEx3dSource_SetConeOrientation;
criAtomEx_CalculateWorkSizeForRegisterAcfConfig_TYPE FCriWareApi::criAtomEx_CalculateWorkSizeForRegisterAcfConfig = ::criAtomEx_CalculateWorkSizeForRegisterAcfConfig;
criAtomExPlayer_SetSequencePrepareTime_TYPE FCriWareApi::criAtomExPlayer_SetSequencePrepareTime = ::criAtomExPlayer_SetSequencePrepareTime;
#if CRIWARE_USE_ATOM_MONITOR
criAtomExMonitor_CalculateWorkSize_TYPE FCriWareApi::criAtomExMonitor_CalculateWorkSize = ::criAtomExMonitor_CalculateWorkSize;
criAtomExMonitor_Initialize_TYPE FCriWareApi::criAtomExMonitor_Initialize = ::criAtomExMonitor_Initialize;
criAtomExMonitor_Finalize_TYPE FCriWareApi::criAtomExMonitor_Finalize = ::criAtomExMonitor_Finalize;
criAtomExMonitor_GetServerIpString_TYPE FCriWareApi::criAtomExMonitor_GetServerIpString = ::criAtomExMonitor_GetServerIpString;
criAtomExMonitor_GetClientIpString_TYPE FCriWareApi::criAtomExMonitor_GetClientIpString = ::criAtomExMonitor_GetClientIpString;
criAtomExMonitor_IsConnected_TYPE FCriWareApi::criAtomExMonitor_IsConnected = ::criAtomExMonitor_IsConnected;
criAtomExMonitor_SetLogCallback_TYPE FCriWareApi::criAtomExMonitor_SetLogCallback = ::criAtomExMonitor_SetLogCallback;
extern "C" void CRIAPI criAtomExMonitor_SetLogCallbackWithLogMode(CriAtomExMonitorLogWithModeCbFunc cbf, void* obj);
criAtomExMonitor_SetLogCallbackWithLogMode_TYPE FCriWareApi::criAtomExMonitor_SetLogCallbackWithLogMode = ::criAtomExMonitor_SetLogCallbackWithLogMode;
criAtomExMonitor_SetLogMode_TYPE FCriWareApi::criAtomExMonitor_SetLogMode = ::criAtomExMonitor_SetLogMode;
criAtomExMonitor_OutputUserLog_TYPE FCriWareApi::criAtomExMonitor_OutputUserLog = ::criAtomExMonitor_OutputUserLog;
criAtomExMonitor_SetDataUpdateNotificationCallback_TYPE FCriWareApi::criAtomExMonitor_SetDataUpdateNotificationCallback = ::criAtomExMonitor_SetDataUpdateNotificationCallback;
#endif
#ifdef XPT_TGT_ANDROID
criAtom_SetThreadPriority_ANDROID_TYPE FCriWareApi::criAtom_SetThreadPriority_ANDROID = ::criAtom_SetThreadPriority_ANDROID;
criAtom_GetThreadPriority_ANDROID_TYPE FCriWareApi::criAtom_GetThreadPriority_ANDROID = ::criAtom_GetThreadPriority_ANDROID;
criAtom_SetJavaVM_ANDROID_TYPE FCriWareApi::criAtom_SetJavaVM_ANDROID = ::criAtom_SetJavaVM_ANDROID;
criAtom_SetSoundStartBufferingTime_ANDROID_TYPE FCriWareApi::criAtom_SetSoundStartBufferingTime_ANDROID = ::criAtom_SetSoundStartBufferingTime_ANDROID;
criAtom_SetSoundBufferingTime_ANDROID_TYPE FCriWareApi::criAtom_SetSoundBufferingTime_ANDROID = ::criAtom_SetSoundBufferingTime_ANDROID;
criAtom_SetSoundBufferSize_ANDROID_TYPE FCriWareApi::criAtom_SetSoundBufferSize_ANDROID = ::criAtom_SetSoundBufferSize_ANDROID;
criAtom_ApplyHardwareProperties_ANDROID_TYPE FCriWareApi::criAtom_ApplyHardwareProperties_ANDROID = ::criAtom_ApplyHardwareProperties_ANDROID;
criAtomEx_CalculateWorkSize_ANDROID_TYPE FCriWareApi::criAtomEx_CalculateWorkSize_ANDROID = ::criAtomEx_CalculateWorkSize_ANDROID;
criAtomEx_Initialize_ANDROID_TYPE FCriWareApi::criAtomEx_Initialize_ANDROID = ::criAtomEx_Initialize_ANDROID;
criAtomEx_Finalize_ANDROID_TYPE FCriWareApi::criAtomEx_Finalize_ANDROID = ::criAtomEx_Finalize_ANDROID;
criAtomEx_StartSound_ANDROID_TYPE FCriWareApi::criAtomEx_StartSound_ANDROID = ::criAtomEx_StartSound_ANDROID;
criAtomEx_StopSound_ANDROID_TYPE FCriWareApi::criAtomEx_StopSound_ANDROID = ::criAtomEx_StopSound_ANDROID;
criAtomLatencyEstimator_Initialize_ANDROID_TYPE FCriWareApi::criAtomLatencyEstimator_Initialize_ANDROID = ::criAtomLatencyEstimator_Initialize_ANDROID;
criAtomLatencyEstimator_Finalize_ANDROID_TYPE FCriWareApi::criAtomLatencyEstimator_Finalize_ANDROID = ::criAtomLatencyEstimator_Finalize_ANDROID;
criAtomLatencyEstimator_GetCurrentInfo_ANDROID_TYPE FCriWareApi::criAtomLatencyEstimator_GetCurrentInfo_ANDROID = ::criAtomLatencyEstimator_GetCurrentInfo_ANDROID;
criAtomLatencyEstimator_IsInitialized_ANDROID_TYPE FCriWareApi::criAtomLatencyEstimator_IsInitialized_ANDROID = ::criAtomLatencyEstimator_IsInitialized_ANDROID;
criFs_EnableAssetsAccess_ANDROID_TYPE FCriWareApi::criFs_EnableAssetsAccess_ANDROID = ::criFs_EnableAssetsAccess_ANDROID;
criFs_DisableAssetsAccess_ANDROID_TYPE FCriWareApi::criFs_DisableAssetsAccess_ANDROID = ::criFs_DisableAssetsAccess_ANDROID;
#endif
#if defined XPT_TGT_PC
criAtomEx_CalculateWorkSize_WASAPI_TYPE FCriWareApi::criAtomEx_CalculateWorkSize_WASAPI = ::criAtomEx_CalculateWorkSize_WASAPI;
criAtomEx_Initialize_WASAPI_TYPE FCriWareApi::criAtomEx_Initialize_WASAPI = ::criAtomEx_Initialize_WASAPI;
criAtomEx_Finalize_WASAPI_TYPE FCriWareApi::criAtomEx_Finalize_WASAPI = ::criAtomEx_Finalize_WASAPI;
criAtom_SetAudioClientFormat_WASAPI_TYPE FCriWareApi::criAtom_SetAudioClientFormat_WASAPI = ::criAtom_SetAudioClientFormat_WASAPI;
criAtom_SetAudioClientShareMode_WASAPI_TYPE FCriWareApi::criAtom_SetAudioClientShareMode_WASAPI = ::criAtom_SetAudioClientShareMode_WASAPI;
criAtom_SetDeviceId_WASAPI_TYPE FCriWareApi::criAtom_SetDeviceId_WASAPI = ::criAtom_SetDeviceId_WASAPI;
criAtom_SetSpatialAudioEnabled_WASAPI_TYPE FCriWareApi::criAtom_SetSpatialAudioEnabled_WASAPI = ::criAtom_SetSpatialAudioEnabled_WASAPI;
criAtom_EnumAudioEndpoints_WASAPI_TYPE FCriWareApi::criAtom_EnumAudioEndpoints_WASAPI = ::criAtom_EnumAudioEndpoints_WASAPI;
criAtom_SetDeviceUpdateCallback_WASAPI_TYPE FCriWareApi::criAtom_SetDeviceUpdateCallback_WASAPI = ::criAtom_SetDeviceUpdateCallback_WASAPI;
#endif
#if defined XPT_TGT_MACOSX
criAtomEx_CalculateWorkSize_MACOSX_TYPE FCriWareApi::criAtomEx_CalculateWorkSize_MACOSX = ::criAtomEx_CalculateWorkSize_MACOSX;
criAtomEx_Initialize_MACOSX_TYPE FCriWareApi::criAtomEx_Initialize_MACOSX = ::criAtomEx_Initialize_MACOSX;
criAtomEx_Finalize_MACOSX_TYPE FCriWareApi::criAtomEx_Finalize_MACOSX = ::criAtomEx_Finalize_MACOSX;
#endif

#if CRIWARE_USE_SOUNDXR
criSoundxR_GetInterface_TYPE FCriWareSoundXRApi::criSoundxR_GetInterface = ::criSoundxR_GetInterface;
#endif

/* --- end of file --- */
