import os
import sys
import glob
import shutil

TARGET_EXTENSIONS = ["acb", "awb"]

if __name__ == "__main__":
    # [0] *.py
    # [1] %ACBPATH%
    # [2] %OUTPUT%
    args = sys.argv

    if len(args) <= 1:
        raise ValueError("Missing command line arguments.")

    for extension in TARGET_EXTENSIONS:
        # Extract files with corresponding extensions.
        files = glob.glob(os.path.join(args[1], "**/*." + extension), recursive=True)

        for file in files:
            # Ignore cache files.
            if "_Cache" in file:
                continue

            # Decomposes the file path.
            dir = os.path.dirname(file)
            name, ext = os.path.splitext(os.path.basename(file))

            # Appends the same characters as the extension to the file name. (ex. Sample_ACB.acb)
            file_name = name + "_" + extension.upper() + ext

            if len(args) == 2:
                # Rename file.
                os.rename(file, os.path.join(dir,  file_name))
            
            # Processing when "%OUTPUT%" is specified.
            else:
                dir = args[2]
                # Supports files for in-game previews.
                if "inGamePreview" in file:
                    dir = os.path.join(dir, "inGamePreview")

                # Create the directory if it does not exist.
                if not os.path.isdir(dir):
                    os.makedirs(dir, exist_ok=True)
                
                # Copy the file.
                shutil.copy(file, os.path.join(dir,  file_name))
